from typing import Dict


location_names: Dict[str, str] = {
    # The Holy Line
    "PR14":              "THL: Hanging skeleton",
    "RB07":              "THL: Across blood platforms",
    "CO04":              "THL: Underground ledge",
    "QI55":              "THL: Underground chest",
    "RESCUED_CHERUB_07": "THL: Child of Moonlight",
    "QI31":              "THL: Deogracias' gift",

    # Albero
    "RE02":              "Albero: Bless Severed Hand",
    "RE04":              "Albero: Bless Linen Cloth",
    "RE10":              "Albero: Bless Hatched Egg",
    "RB01":              "Albero: Tirso's house, top floor",
    "QI66":              "Albero: Tirso's 1st reward",
    "Tirso[500]":        "Albero: Tirso's 2nd reward",
    "Tirso[1000]":       "Albero: Tirso's 3rd reward",
    "Tirso[2000]":       "Albero: Tirso's 4th reward",
    "Tirso[5000]":       "Albero: Tirso's 5th reward",
    "Tirso[10000]":      "Albero: Tirso's 6th reward",
    "QI56":              "Albero: Tirso's final reward",
    "RESCUED_CHERUB_08": "Albero: Child of Moonlight",
    "Lvdovico[500]":     "Albero: Lvdovico's 1st reward",
    "Lvdovico[1000]":    "Albero: Lvdovico's 2nd reward",
    "PR03":              "Albero: Lvdovico's 3rd reward",
    "QI01":              "Albero: First gift for Cleofas",
    "CO43":              "Albero: Outside Ossuary",
    "CO16":              "Albero: Graveyard",
    "Sword[D01Z02S06]":  "Albero: Mea Culpa altar",
    "QI65":              "Albero: Gate of Travel room",
    "RB104":             "Albero: Donate 5000 Tears",
    "RB105":             "Albero: Donate 50000 Tears",
    "PR11":              "Albero: Final gift for Cleofas",
    "Undertaker[250]":   "Ossuary: 1st reward",
    "Undertaker[500]":   "Ossuary: 2nd reward",
    "Undertaker[750]":   "Ossuary: 3rd reward",
    "Undertaker[1000]":  "Ossuary: 4th reward",
    "Undertaker[1250]":  "Ossuary: 5th reward",
    "Undertaker[1500]":  "Ossuary: 6th reward",
    "Undertaker[1750]":  "Ossuary: 7th reward",
    "Undertaker[2000]":  "Ossuary: 8th reward",
    "Undertaker[2500]":  "Ossuary: 9th reward",
    "Undertaker[3000]":  "Ossuary: 10th reward",
    "Undertaker[5000]":  "Ossuary: 11th reward",
    "QI201":             "Ossuary: Isidora, Voice of the Dead",

    # Wasteland of the Buried Churches
    "RB04":              "WotBC: Lower log path",
    "CO14":              "WotBC: Hidden alcove",
    "CO36":              "WotBC: Outside ledge",
    "RESCUED_CHERUB_10": "WotBC: Outside Child of Moonlight",
    "QI06":              "WotBC: Under broken bridge",
    "RB20":              "WotBC: 3rd meeting with Redento",
    "HE02":              "WotBC: Cliffside statue",
    "RESCUED_CHERUB_38": "WotBC: Cliffside Child of Moonlight",

    # Mercy Dreams
    "CO30":              "MD: First area hidden wall",
    "CO03":              "MD: Second area ledge",
    "RESCUED_CHERUB_09": "MD: Second area Child of Moonlight",
    "PR01":              "MD: Second area trapped chest",
    "RB17":              "MD: First red candle",
    "QI48":              "MD: Third area hidden room",
    "CO21":              "MD: Behind gate to TSC",
    "CO38":              "MD: Sliding challenge",
    "RESCUED_CHERUB_33": "MD: Cave Child of Moonlight",
    "BS01":              "MD: Ten Piedad",
    "QI38":              "MD: Visage of Attrition",
    "QI58":              "MD: Shop item 1",
    "RB05":              "MD: Shop item 2",
    "RB09":              "MD: Shop item 3",

    # Desecrated Cistern
    "CO09":              "DC: Shortcut to WotBC",
    "QI67":              "DC: Hidden alcove near fountain",
    "PR16":              "DC: Upper east tunnel chest",
    "RESCUED_CHERUB_13": "DC: Upper east Child of Moonlight",
    "Oil[D01Z05S07]":    "DC: Oil of the Pilgrims",
    "QI12":              "DC: Behind gate in miasma room",
    "RESCUED_CHERUB_14": "DC: Child of Moonlight, miasma room",
    "QI45":              "DC: Lower east tunnel chest",
    "RESCUED_CHERUB_12": "DC: Child of Moonlight, behind pillar",
    "RESCUED_CHERUB_11": "DC: Child of Moonlight, above water",
    "CO41":              "DC: Behind sewage drips",
    "CO32":              "DC: High ledge near elevator shaft",
    "RESCUED_CHERUB_15": "DC: Top of elevator Child of Moonlight",
    "Lady[D01Z05S22]":   "DC: Lady of the Six Sorrows, from MD",
    "QI75":              "DC: Chalice room",
    "Sword[D01Z05S24]":  "DC: Mea Culpa altar",
    "CO44":              "DC: Elevator shaft ledge",
    "RESCUED_CHERUB_22": "DC: Elevator shaft Child of Moonlight",
    "Lady[D01Z05S26]":   "DC: Lady of the Six Sorrows, elevator shaft",
    "RB03":              "DC: Shroud puzzle",

    # Petrous
    "QI101": "Petrous: Temple entrance",

    # Where Olive Trees Wither
    "CO11":              "WOTW: Below Prie Dieu",
    "QI59":              "WOTW: Gemino's gift",
    "RB10":              "WOTW: Gemino's reward",
    "RESCUED_CHERUB_23": "WOTW: Upper east Child of Moonlight",
    "QI20":              "WOTW: Entrance to tomb",
    "QI68":              "WOTW: Gift for the tomb",
    "QI07":              "WOTW: Death run",
    "CO19":              "WOTW: Underground ledge",
    "RESCUED_CHERUB_27": "WOTW: Underground Child of Moonlight",
    "PR04":              "WOTW: Underground tomb",
    "HE05":              "WOTW: Upper east statue",

    # Graveyard of the Peaks
    "RESCUED_CHERUB_24":    "GotP: Center shaft Child of Moonlight",
    "QI46":                 "GotP: Lower east shaft",
    "CO29":                 "GotP: Center east shaft",
    "QI08":                 "GotP: Upper east shaft",
    "RB32":                 "GotP: Lower west shaft",
    "CO01":                 "GotP: Upper west shaft",
    "RESCUED_CHERUB_25":    "GotP: West shaft Child of Moonlight",
    "RB15":                 "GotP: Center shaft ledge",
    "RB38":                 "GotP: Confessor Dungeon room",
    "CO42":                 "GotP: Shop cave hidden hole",
    "RESCUED_CHERUB_31":    "GotP: Shop cave Child of Moonlight",
    "Oil[D02Z02S10]":       "GotP: Oil of the Pilgrims",
    "QI53":                 "GotP: Elevator shaft ledge",
    "RESCUED_CHERUB_26":    "GotP: Elevator shaft Child of Moonlight",
    "Lady[D02Z02S12]":      "GotP: Lady of the Six Sorrows",
    "HE11":                 "GotP: Self sacrifice statue",
    "RB106":                "GotP: East cliffside",
    "Amanecida[D02Z02S14]": "GotP: Amanecida of the Bejeweled Arrow",
    "QI11":                 "GotP: Shop item 1",
    "RB37":                 "GotP: Shop item 2",
    "RB02":                 "GotP: Shop item 3",

    # Convent of Our Lady of the Charred Visage
    "CO05":             "CoOLotCV: Snowy window ledge",
    "RB08":             "CoOLotCV: Center miasma room",
    "CO15":             "CoOLotCV: Center enemy lineup",
    "HE03":             "CoOLotCV: Lower west statue",
    "Sword[D02Z03S13]": "CoOLotCV: Mea Culpa altar",
    "Lady[D02Z03S15]":  "CoOLotCV: Lady of the Six Sorrows",
    "RB24":             "CoOLotCV: First blue candle",
    "QI61":             "CoOLotCV: Mask room",
    "BS03":             "CoOLotCV: Our Lady of the Charred Visage",
    "QI40":             "CoOLotCV: Visage of Compunction",
    "QI57":             "CoOLotCV: Fountain of burning oil",
    "RB107":            "CoOLotCV: Outside pathway",

    # Mountains of the Endless Dusk
    "CO13":                 "MotED: Under entrance to DC",
    "QI47":                 "MotED: Platform above chasm",
    "RB22":                 "MotED: 1st meeting with Redento",
    "RESCUED_CHERUB_16":    "MotED: Child of Moonlight, above chasm",
    "Amanecida[D03Z01S03]": "MotED: Amanecida of the Golden Blades",
    "QI63":                 "MotED: Blood platform alcove",
    'RB13':                 "MotED: Perpetva",
    "QI14":                 "MotED: Egg hatching",

    # Jondo
    "CO08":              "Jondo: Upper east ledge",
    "PR10":              "Jondo: Upper east chest",
    "CO33":              "Jondo: Lower east under chargers",
    "RESCUED_CHERUB_18": "Jondo: Upper east Child of Moonlight",
    "QI19":              "Jondo: Lower east bell trap",
    "CO07":              "Jondo: Lower west lift alcove",
    "QI41":              "Jondo: Lower west bell alcove",
    "RESCUED_CHERUB_17": "Jondo: Upper west Child of Moonlight",
    "HE06":              "Jondo: Spike tunnel statue",
    "RESCUED_CHERUB_37": "Jondo: Spike tunnel Child of Moonlight",
    "QI52":              "Jondo: Upper west bell puzzle",
    "RB28":              "Jondo: Upper west tree root",
    "QI103":             "Jondo: Spike tunnel cave",

    # Grievance Ascends
    "QI44":              "GA: Lower west ledge",
    "CO12":              "GA: Miasma room floor",
    "RE07":              "GA: Miasma room treasure",
    "RESCUED_CHERUB_19": "GA: Miasma room Child of Moonlight",
    "QI10":              "GA: End of blood bridge",
    "RESCUED_CHERUB_21": "GA: Blood bridge Child of Moonlight",
    "RESCUED_CHERUB_20": "GA: Lower east Child of Moonlight",
    "QI13":              "GA: Altasgracias' gift",
    "RB06":              "GA: Empty giant egg",
    "Oil[D03Z03S13]":    "GA: Oil of the Pilgrims",
    "BS04":              "GA: Tres Angustias",
    "QI39":              "GA: Visage of Contrition",

    # Patio of the Silent Steps
    "CO23":                 "PotSS: First area ledge",
    "RESCUED_CHERUB_35":    "PotSS: First area Child of Moonlight",
    "RB14":                 "PotSS: Second area ledge",
    "QI37":                 "PotSS: Third area lower ledge",
    "CO39":                 "PotSS: Third area upper ledge",
    "RESCUED_CHERUB_28":    "PotSS: Third area Child of Moonlight",
    "RB21":                 "PotSS: 4th meeting with Redento",
    "Amanecida[D04Z01S04]": "PotSS: Amanecida of the Chiselled Steel",
    "QI102":                "PotSS: Climb to WotHP",

    # Mother of Mothers
    "RE402":             "MoM: Western room ledge",
    "RESCUED_CHERUB_30": "MoM: Lower west Child of Moonlight",
    "CO17":              "MoM: Upper west floor",
    "CO34":              "MoM: Outside Cleofas' room",
    "CO35":              "MoM: East chandelier platform",
    "RB33":              "MoM: Upper east ledge",
    "CO20":              "MoM: Upper center floor",
    "RESCUED_CHERUB_29": "MoM: Upper center Child of Moonlight",
    "Sword[D04Z02S12]":  "MoM: Mea Culpa altar",
    "Oil[D04Z02S14]":    "MoM: Oil of the Pilgrims",
    "QI60":              "MoM: Mask room",
    "HE01":              "MoM: Giant chandelier statue",
    "BS05":              "MoM: Melquiades, The Exhumed Archbishop",
    "RE03":              "MoM: Redento's treasure",
    "QI54":              "MoM: Final meeting with Redento",

    # Knot of the Three Words
    "HE201": "KotTW: Gift from the Traitor",

    # All the Tears of the Sea
    "PR201": "AtTotS: Miriam's gift",

    # Library of the Negated Words
    "CO18":              "LotNW: Platform room ledge",
    "RESCUED_CHERUB_01": "LotNW: Platform room Child of Moonlight",
    "QI50":              "LotNW: Hidden floor",
    "CO22":              "LotNW: Root ceiling platform",
    "RB31":              "LotNW: Miasma hallway chest",
    "PR07":              "LotNW: Platform puzzle chest",
    "RB203":             "LotNW: Silence for Diosdado",
    "CO28":              "LotNW: Lowest west upper ledge",
    "RB30":              "LotNW: Lowest west center ledge",
    "RESCUED_CHERUB_02": "LotNW: Lowest west Child of Moonlight",
    "Sword[D05Z01S13]":  "LotNW: Mea Culpa altar",
    "Lady[D05Z01S14]":   "LotNW: Lady of the Six Sorrows",
    "QI62":              "LotNW: Mask room",
    "PR15":              "LotNW: Bone puzzle",
    "Oil[D05Z01S19]":    "LotNW: Oil of the Pilgrims",
    "RESCUED_CHERUB_32": "LotNW: Elevator Child of Moonlight",
    "RB301":             "LotNW: Twisted wood hidden wall",

    # The Sleeping Canvases
    "QI64":  "TSC: Painting ladder ledge",
    "HE07":  "TSC: Candle wax puzzle",
    "RE05":  "TSC: Jocinero's 1st reward",
    "PR05":  "TSC: Jocinero's final reward",
    "CO31":  "TSC: Under elevator shaft",
    "BS06":  "TSC: Exposito, Scion of Abjuration",
    "QI104": "TSC: Swinging blade tunnel",
    "RB12":  "TSC: Shop item 1",
    "QI49":  "TSC: Shop item 2",
    "QI71":  "TSC: Shop item 3",

    # Archcathedral Rooftops
    "QI02":              "AR: First soldier fight",
    "QI03":              "AR: Second soldier fight",
    "QI04":              "AR: Third soldier fight",
    "Sword[D06Z01S11]":  "AR: Mea Culpa altar",
    "CO06":              "AR: Upper west shaft ledge",
    "PR12":              "AR: Upper west shaft chest",
    "RESCUED_CHERUB_36": "AR: Upper west shaft Child of Moonlight",
    "CO40":              "AR: Upper east shaft ledge",
    "HE04":              "AR: Statue near MoM",
    "Lady[D06Z01S24]":   "AR: Lady of the Six Sorrows",
    "BS16":              "AR: Crisanta of the Wrapped Agony",

    # Deambulatory of His Holiness
    "PR08": "DoHH: Viridiana's gift",

    # Bridge of the Three Cavalries
    "BS12":  "BotTC: Esdras, of the Anointed Legion",
    "PR09":  "BotTC: Esdras' gift",
    "HE101": "BotTC: Inside giant statue",

    # Hall of the Dawning
    "QI105":                    "HotD: Mirror room",
    "LaudesBossTrigger[30000]": "HotD: Laudes, the First of the Amanecidas",

    # Wall of the Holy Prohibitions
    "Amanecida[D09Z01S01]": "WotHP: Amanecida of the Molten Thorn",
    "QI51":                 "WotHP: Upper east room, center gold cell",
    "RB11":                 "WotHP: Upper east room, lift puzzle",
    "BS14":                 "WotHP: Quirce, Returned By The Flames",
    "RESCUED_CHERUB_05":    "WotHP: Outside Child of Moonlight",
    "QI72":                 "WotHP: Collapsing floor ledge",
    "RB16":                 "WotHP: Lower west room, top ledge",
    "QI70":                 "WotHP: Lower east room, top bronze cell",
    "CO27":                 "WotHP: Lower east room, hidden ledge",
    "Oil[D09Z01S12]":       "WotHP: Oil of the Pilgrims",
    "CO10":                 "WotHP: Upper east room, center cell ledge",
    "QI69":                 "WotHP: Upper east room, center cell floor",
    "RESCUED_CHERUB_03":    "WotHP: Upper east room, top bronze cell",
    "CO24":                 "WotHP: Upper east room, top silver cell",
    "RESCUED_CHERUB_34":    "WotHP: Upper west room, top silver cell",
    "CO26":                 "WotHP: Upper west room, center gold cell",
    "CO02":                 "WotHP: Lower west room, bottom gold cell",
    "CO37":                 "WotHP: Lower east room, top silver cell",
    "RESCUED_CHERUB_04":    "WotHP: Lower east room, bottom silver cell",

    # Brotherhood of the Silent Sorrow
    "RB204":             "BotSS: Starting room ledge",
    "RESCUED_CHERUB_06": "BotSS: Starting room Child of Moonlight",
    "RE401":             "BotSS: 2nd meeting with Redento",
    "Sword[D17Z01S08]":  "BotSS: Mea Culpa altar",
    "BS13":              "BotSS: Warden of the Silent Sorrow",
    "PR203":             "BotSS: Outside church",
    "QI204":             "BotSS: Esdras' final gift",
    "QI301":             "BotSS: Crisanta's gift",
    "RE01":              "BotSS: Chamber of the Eldest Brother",
    "CO25":              "BotSS: Platforming gauntlet",

    # Echoes of Salt
    "RB108": "EoS: Lantern jump near MotED",
    "RB202": "EoS: Lantern jump near elevator",

    # Mourning and Havoc
    "RB201":             "MaH: Upper east chest",
    "BossTrigger[5000]": "MaH: Sierpes",
    "QI202":             "MaH: Sierpes' eye",
    "PR202":             "MaH: West chest",

    # The Resting Place of the Sister
    "QI203": "TRPotS: Perpetva's shrine",

    # Misc
    "QI106":                   "Beginning gift",
    "RB18":                    "Second red candle",
    "RB19":                    "Third red candle",
    "RB25":                    "Second blue candle",
    "RB26":                    "Third blue candle",
    "QI107":                   "Defeat 1 Amanecida",
    "QI108":                   "Defeat 2 Amanecidas",
    "QI109":                   "Defeat 3 Amanecidas",
    "QI110":                   "Defeat 4 Amanecidas",
    "PR101":                   "Defeat all Amanecidas",
    "QI32":                    "Confessor Dungeon 1 main",
    "QI33":                    "Confessor Dungeon 2 main",
    "QI34":                    "Confessor Dungeon 3 main",
    "QI35":                    "Confessor Dungeon 4 main",
    "QI79":                    "Confessor Dungeon 5 main",
    "QI80":                    "Confessor Dungeon 6 main",
    "QI81":                    "Confessor Dungeon 7 main",
    "Arena_NailManager[1000]": "Confessor Dungeon 1 extra",
    "HE10":                    "Confessor Dungeon 2 extra",
    "Arena_NailManager[3000]": "Confessor Dungeon 3 extra",
    "RB34":                    "Confessor Dungeon 4 extra",
    "Arena_NailManager[5000]": "Confessor Dungeon 5 extra",
    "RB35":                    "Confessor Dungeon 6 extra",
    "RB36":                    "Confessor Dungeon 7 extra",
    "COMBO_1":                 "Skill 1, Tier 1",
    "COMBO_2":                 "Skill 1, Tier 2",
    "COMBO_3":                 "Skill 1, Tier 3",
    "CHARGED_1":               "Skill 2, Tier 1",
    "CHARGED_2":               "Skill 2, Tier 2",
    "CHARGED_3":               "Skill 2, Tier 3",
    "RANGED_1":                "Skill 3, Tier 1",
    "RANGED_2":                "Skill 3, Tier 2",
    "RANGED_3":                "Skill 3, Tier 3",
    "VERTICAL_1":              "Skill 4, Tier 1",
    "VERTICAL_2":              "Skill 4, Tier 2",
    "VERTICAL_3":              "Skill 4, Tier 3",
    "LUNGE_1":                 "Skill 5, Tier 1",
    "LUNGE_2":                 "Skill 5, Tier 2",
    "LUNGE_3":                 "Skill 5, Tier 3"
}
