from BaseClasses import Region

from ..base_classes import Q1Level


class r2m8(Q1Level):
    name = ""
    mapfile = "r2m8"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Lava (1)",
            "classname": "item_lava_spikes",
            "uuid": 1503070716146688134,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Spikes (2)",
            "classname": "item_spikes",
            "uuid": 9384493490444116213,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Multi (3)",
            "classname": "item_multi_rockets",
            "uuid": 44564667278621306,
            "mp": 0,
        },
        # {
        #    "id": 4,
        #    "name": "Quad Damage (4)",
        #    "classname": "item_artifact_super_damage",
        #    "uuid": 10414775112788141147,
        #    "mp": 1,
        # },
        {
            "id": 5,
            "name": "Multi (5)",
            "classname": "item_multi_rockets",
            "uuid": 9534325684315395039,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 11321584679620539057,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 11244142923643560044,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 9693686969328707726,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Multi (9)",
            "classname": "item_multi_rockets",
            "uuid": 7868920541991890128,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Cells (10)",
            "classname": "item_cells",
            "uuid": 6824090686443659378,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Lava (11)",
            "classname": "item_lava_spikes",
            "uuid": 10794885545346438094,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 11974091002568935117,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 7036895509957882077,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Powerup (14)",
            "classname": "item_powerup_belt",
            "uuid": 15721689855285980437,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Powerup (15)",
            "classname": "item_powerup_shield",
            "uuid": 7019463072732197132,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 17866441853185029290,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 10679221476497353273,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Plasma (18)",
            "classname": "item_plasma",
            "uuid": 10336979937521751625,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Plasma (19)",
            "classname": "item_plasma",
            "uuid": 15682269891516028959,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 2264023597544167409,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 13166695727455053451,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Nailgun (22)",
            "classname": "weapon_nailgun",
            "uuid": 14977058562818849195,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Grenadelauncher (23)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10258785117349709781,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Supershotgun (24)",
            "classname": "weapon_supershotgun",
            "uuid": 10927930514320116621,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Rocketlauncher (25)",
            "classname": "weapon_rocketlauncher",
            "uuid": 9417554229112823244,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Megahealth (26)",
            "classname": "item_health",
            "uuid": 2725272878855451264,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 14956811067395239477,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 5947511237237842031,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Multi (29)",
            "classname": "item_multi_rockets",
            "uuid": 7589940933024903110,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Lava (30)",
            "classname": "item_lava_spikes",
            "uuid": 3473849954922948913,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 3579718195792895054,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 13811743756735090122,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Lightning (33)",
            "classname": "weapon_lightning",
            "uuid": 16565513403428210091,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Yellow Armor (34)",
            "classname": "item_armor2",
            "uuid": 17968373390582237319,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Time (35)",
            "classname": "item_time_machine",
            "uuid": 11131895142849149183,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Time (36)",
            "classname": "item_time_core",
            "uuid": 7365192422927172960,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Multi (37)",
            "classname": "item_multi_rockets",
            "uuid": 16556483451229428037,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Lava (38)",
            "classname": "item_lava_spikes",
            "uuid": 5900904050770840355,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Plasma (39)",
            "classname": "item_plasma",
            "uuid": 732312831011186930,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Rockets (40)",
            "classname": "item_rockets",
            "uuid": 5900428804072475597,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 4934344077403263842,
            "mp": 1,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 15789587880362419799,
            "mp": 1,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 6518800372182903276,
            "mp": 1,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 11992076340030259106,
            "mp": 1,
        },
        {
            "id": 45,
            "name": "Multi (45)",
            "classname": "item_multi_rockets",
            "uuid": 14645123747047967221,
            "mp": 1,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 992059970942636091,
            "mp": 1,
        },
        {
            "id": 47,
            "name": "Lightning (47)",
            "classname": "weapon_lightning",
            "uuid": 16985302962126617093,
            "mp": 1,
        },
        {
            "id": 48,
            "name": "Cells (48)",
            "classname": "item_cells",
            "uuid": 1888207165985945371,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Supernailgun (49)",
            "classname": "weapon_supernailgun",
            "uuid": 10243765002194988072,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "All Kills (50)",
            "classname": "all_kills",
            "uuid": 16260633654361482853,
            "mp": 0,
        },
        # manually added for the exit to exist
        {
            "id": 42,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 13397806965560897406,
            "mp": 0,
        },
    ]
    has_boss = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (31)",
                "Large Medkit (32)",
                "Lightning (33)",
                "Cells (48)",
                "Yellow Armor (34)",
                "Multi (3)",
                "Supernailgun (49)",
                "Multi (29)",
                "Lava (30)",
                "Large Medkit (12)",
                "Large Medkit (13)",
                "Powerup (14)",
                "Grenadelauncher (23)",
                "Large Medkit (28)",
                "Large Medkit (27)",
                "Plasma (18)",
                "Megahealth (26)",
                "Large Medkit (6)",
                "Large Medkit (7)",
                "Multi (5)",
                "Supershotgun (24)",
                "Powerup (15)",
                "Shells (17)",
                "Spikes (16)",
                "Lava (11)",
                "Cells (10)",
                "Rocketlauncher (25)",
                "Spikes (8)",
                "Multi (9)",
                "Lava (1)",
                "Spikes (2)",
                "Large Medkit (21)",
                "Large Medkit (20)",
                "Nailgun (22)",
                "All Kills (50)",
            ],
        )
        self.restrict("All Kills (50)", r.difficult_combat)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Shells (46)",
                "Large Medkit (44)",
                "Large Medkit (43)",
                "Multi (45)",
                "Large Medkit (41)",
                "Large Medkit (42)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door & r.difficult_combat)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Plasma (39)",
                "Multi (37)",
                "Lava (38)",
                "Rockets (40)",
                "Exit",
            ],
        )
        self.connect(past_door_area, past_button_area, r.can_button)
        self.restrict("Exit", r.backpack(1))

        return ret
