from BaseClasses import Region

from ..base_classes import Q1Level


class r2m7(Q1Level):
    name = "Last Bastion"
    mapfile = "r2m7"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Flag (1)",
            "classname": "item_flag_team1",
            "uuid": 3472360463481554071,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Flag (2)",
            "classname": "item_flag_team2",
            "uuid": 10588605850701981897,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Biosuit (3)",
            "classname": "item_artifact_envirosuit",
            "uuid": 2751700124543227757,
            "mp": 1,
        },
        {
            "id": 4,
            "name": "Green Armor (4)",
            "classname": "item_armor1",
            "uuid": 16591390502408462936,
            "mp": 1,
        },
        {
            "id": 5,
            "name": "Powerup (5)",
            "classname": "item_powerup_belt",
            "uuid": 12500278416910525815,
            "mp": 1,
        },
        {
            "id": 6,
            "name": "Sphere (6)",
            "classname": "item_sphere",
            "uuid": 11024615506951069153,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Sphere (7)",
            "classname": "item_sphere",
            "uuid": 991893786532657309,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 2795071956350882555,
            "mp": 1,
        },
        {
            "id": 9,
            "name": "Rockets (9)",
            "classname": "item_rockets",
            "uuid": 1657107900766323071,
            "mp": 1,
        },
        {
            "id": 10,
            "name": "Red Armor (10)",
            "classname": "item_armorInv",
            "uuid": 1455063466111443535,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Secret (11)",
            "classname": "trigger_secret",
            "uuid": 15372660209142585680,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Invulnerability (12)",
            "classname": "item_artifact_invulnerability",
            "uuid": 3822472632354300870,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Silver Key (13)",
            "classname": "item_key1",
            "uuid": 838607068085827194,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Red Armor (14)",
            "classname": "item_armorInv",
            "uuid": 10039632305953225284,
            "mp": 1,
        },
        {
            "id": 15,
            "name": "Nailgun (15)",
            "classname": "weapon_nailgun",
            "uuid": 3571598062737332962,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Grenadelauncher (16)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16055002767835575969,
            "mp": 1,
        },
        {
            "id": 17,
            "name": "Supershotgun (17)",
            "classname": "weapon_supershotgun",
            "uuid": 7907469570360332789,
            "mp": 1,
        },
        {
            "id": 18,
            "name": "Supernailgun (18)",
            "classname": "weapon_supernailgun",
            "uuid": 8869247611164443587,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Rocketlauncher (19)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4764832223487243684,
            "mp": 1,
        },
        {
            "id": 20,
            "name": "Lightning (20)",
            "classname": "weapon_lightning",
            "uuid": 1000386229402757776,
            "mp": 1,
        },
        {
            "id": 21,
            "name": "Nailgun (21)",
            "classname": "weapon_nailgun",
            "uuid": 18123581946538162091,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Supershotgun (22)",
            "classname": "weapon_supershotgun",
            "uuid": 331074515721238285,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 2241533196319372599,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Cells (24)",
            "classname": "item_cells",
            "uuid": 12715134272954327334,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Lava (25)",
            "classname": "item_lava_spikes",
            "uuid": 585508637019163025,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Small Medkit (26)",
            "classname": "item_health",
            "uuid": 5382199807926517717,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 11822924272843080293,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Rockets (28)",
            "classname": "item_rockets",
            "uuid": 11789963449768590536,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 7148520123269255153,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 16583408724517943227,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 11470997699968124805,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 17724105012747778298,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Plasma (33)",
            "classname": "item_plasma",
            "uuid": 4510608043493717497,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 15031418759555293490,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 18246373144120134066,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Cells (36)",
            "classname": "item_cells",
            "uuid": 8055446645883400812,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 2438708633740379759,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 10645484391632746831,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Lava (39)",
            "classname": "item_lava_spikes",
            "uuid": 6245108456715827741,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 5943512003283855482,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Rockets (41)",
            "classname": "item_rockets",
            "uuid": 10599902787675589108,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Lava (42)",
            "classname": "item_lava_spikes",
            "uuid": 7968387589598192801,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Spikes (43)",
            "classname": "item_spikes",
            "uuid": 1744387260950002212,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Small Medkit (44)",
            "classname": "item_health",
            "uuid": 7088565439170467358,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Plasma (45)",
            "classname": "item_plasma",
            "uuid": 7204051470592244684,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Cells (46)",
            "classname": "item_cells",
            "uuid": 6474338772974311169,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Shells (47)",
            "classname": "item_shells",
            "uuid": 9701570523278328111,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 17770261224779824821,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 581003013569312970,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 5742780044144681708,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Multi (51)",
            "classname": "item_multi_rockets",
            "uuid": 10826320770684682338,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Small Medkit (52)",
            "classname": "item_health",
            "uuid": 7248549723753014426,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 7499706253053532050,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 10568830778638873006,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rockets (55)",
            "classname": "item_rockets",
            "uuid": 5273054351857382023,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 7453369772103794997,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Grenadelauncher (57)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9230910200092591993,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Lava (58)",
            "classname": "item_lava_spikes",
            "uuid": 1615694456379804204,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Megahealth (59)",
            "classname": "item_health",
            "uuid": 16054513397465813200,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 17786691021402112602,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 8410192228560989638,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Plasma (62)",
            "classname": "item_plasma",
            "uuid": 2325643233141672275,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Shells (63)",
            "classname": "item_shells",
            "uuid": 14272958131385662500,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Spikes (64)",
            "classname": "item_spikes",
            "uuid": 6558256424606219550,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Rockets (65)",
            "classname": "item_rockets",
            "uuid": 13975390663996141353,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Multi (66)",
            "classname": "item_multi_rockets",
            "uuid": 8762740221952833759,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 8789653123499402401,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 15254163566436666544,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 9136178809586256358,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Yellow Armor (70)",
            "classname": "item_armor2",
            "uuid": 17410209635951561384,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Spikes (71)",
            "classname": "item_spikes",
            "uuid": 6172213230534893094,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Shells (72)",
            "classname": "item_shells",
            "uuid": 10067451996850354780,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 13747661877761025520,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Multi (74)",
            "classname": "item_multi_rockets",
            "uuid": 1658779856878313881,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Lava (75)",
            "classname": "item_lava_spikes",
            "uuid": 4120178551768969615,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Large Medkit (76)",
            "classname": "item_health",
            "uuid": 8392805432432388345,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Large Medkit (77)",
            "classname": "item_health",
            "uuid": 8890825941991361176,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Shells (78)",
            "classname": "item_shells",
            "uuid": 9637784619472496208,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Rockets (79)",
            "classname": "item_rockets",
            "uuid": 16137892747955206898,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Spikes (80)",
            "classname": "item_spikes",
            "uuid": 161876663519876496,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 15670399774910715660,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Lava (82)",
            "classname": "item_lava_spikes",
            "uuid": 1719407951681945643,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 8751081811931142471,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Plasma (84)",
            "classname": "item_plasma",
            "uuid": 3141719665641741536,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 16690539629866471678,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Rockets (86)",
            "classname": "item_rockets",
            "uuid": 2082713140811958977,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Large Medkit (87)",
            "classname": "item_health",
            "uuid": 17390957135827219947,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Shells (88)",
            "classname": "item_shells",
            "uuid": 1186847239428848017,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Invisibility (89)",
            "classname": "item_artifact_invisibility",
            "uuid": 9843460806440251519,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Secret (90)",
            "classname": "trigger_secret",
            "uuid": 12916590680130644089,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 13834392503938456944,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Large Medkit (92)",
            "classname": "item_health",
            "uuid": 2252146934848819147,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Large Medkit (93)",
            "classname": "item_health",
            "uuid": 10879572871472783591,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Lava (94)",
            "classname": "item_lava_spikes",
            "uuid": 5904865429839822994,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Large Medkit (95)",
            "classname": "item_health",
            "uuid": 10089718667532804918,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Large Medkit (96)",
            "classname": "item_health",
            "uuid": 10367334825095571060,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Multi (97)",
            "classname": "item_multi_rockets",
            "uuid": 10373627678305002400,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 10743060662895603015,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Green Armor (99)",
            "classname": "item_armor1",
            "uuid": 17017844629867126405,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Large Medkit (100)",
            "classname": "item_health",
            "uuid": 12312992565572465334,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 11367350000528861171,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Multi (102)",
            "classname": "item_multi_rockets",
            "uuid": 17382564769957371348,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Rockets (103)",
            "classname": "item_rockets",
            "uuid": 10633487801193278394,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Rocketlauncher (104)",
            "classname": "weapon_rocketlauncher",
            "uuid": 14058526760844081147,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Cells (105)",
            "classname": "item_cells",
            "uuid": 10161990291491168756,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Cells (106)",
            "classname": "item_cells",
            "uuid": 380162509595019759,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Cells (107)",
            "classname": "item_cells",
            "uuid": 2193499416483442952,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Cells (108)",
            "classname": "item_cells",
            "uuid": 6481944371082793137,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Cells (109)",
            "classname": "item_cells",
            "uuid": 18326457288359177843,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Large Medkit (110)",
            "classname": "item_health",
            "uuid": 5643236061245353307,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Large Medkit (111)",
            "classname": "item_health",
            "uuid": 9924781768872014350,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Spikes (112)",
            "classname": "item_spikes",
            "uuid": 4652149785295661920,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Rockets (113)",
            "classname": "item_rockets",
            "uuid": 3122600299029291943,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Powerup (114)",
            "classname": "item_powerup_shield",
            "uuid": 9134606745802547585,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Plasma (115)",
            "classname": "item_plasma",
            "uuid": 9040966220143498395,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Shells (116)",
            "classname": "item_shells",
            "uuid": 12055527816986964532,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Lava (117)",
            "classname": "item_lava_spikes",
            "uuid": 17859497671033123399,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Rockets (118)",
            "classname": "item_rockets",
            "uuid": 9284695176679407113,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Large Medkit (119)",
            "classname": "item_health",
            "uuid": 3716634153677114884,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Large Medkit (120)",
            "classname": "item_health",
            "uuid": 8136310725013568092,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Biosuit (121)",
            "classname": "item_artifact_envirosuit",
            "uuid": 8693348681272211601,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Large Medkit (122)",
            "classname": "item_health",
            "uuid": 5964931829245514905,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Multi (123)",
            "classname": "item_multi_rockets",
            "uuid": 5787910325951303036,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Spikes (124)",
            "classname": "item_spikes",
            "uuid": 1715506540426508720,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Shells (125)",
            "classname": "item_shells",
            "uuid": 18008332480876699267,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Lava (126)",
            "classname": "item_lava_spikes",
            "uuid": 17521817524335898790,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Supernailgun (127)",
            "classname": "weapon_supernailgun",
            "uuid": 5221249707470042298,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Large Medkit (128)",
            "classname": "item_health",
            "uuid": 8213884022174383409,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Large Medkit (129)",
            "classname": "item_health",
            "uuid": 532620212071754969,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 16916266274775542945,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Yellow Armor (131)",
            "classname": "item_armor2",
            "uuid": 7393598984031761309,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Large Medkit (132)",
            "classname": "item_health",
            "uuid": 7908064598283863500,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Large Medkit (133)",
            "classname": "item_health",
            "uuid": 8962825062581647545,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Secret (134)",
            "classname": "trigger_secret",
            "uuid": 2415032471905436138,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Rockets (135)",
            "classname": "item_rockets",
            "uuid": 9134690790779159252,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Lava (136)",
            "classname": "item_lava_spikes",
            "uuid": 13957894422380850968,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Shells (137)",
            "classname": "item_shells",
            "uuid": 9949699634024764906,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Secret (138)",
            "classname": "trigger_secret",
            "uuid": 16140341716107336603,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Shells (139)",
            "classname": "item_shells",
            "uuid": 18439585461757482846,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Lightning (140)",
            "classname": "weapon_lightning",
            "uuid": 13179941678964126973,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Plasma (141)",
            "classname": "item_plasma",
            "uuid": 7495318384677572454,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Secret (142)",
            "classname": "trigger_secret",
            "uuid": 4030492379103895239,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Megahealth (143)",
            "classname": "item_health",
            "uuid": 10465422383337616202,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Flag (144)",
            "classname": "item_flag",
            "uuid": 11391316825896866664,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "All Kills (145)",
            "classname": "all_kills",
            "uuid": 3213325358485489752,
            "mp": 0,
        },
    ]
    events = ["Bridge Active", "Gate Opened"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Spikes (124)",
                "Supernailgun (127)",
                "Flag (1)",
                "Shells (125)",
                "Large Medkit (122)",
                "Large Medkit (128)",
                "Large Medkit (129)",
                "Multi (123)",
                "Biosuit (121)",
            ],
        )

        dive_area = self.region(
            "Dive Area",
            [
                "Rockets (135)",
                "Shells (137)",
                "Secret (134)",
                "Yellow Armor (131)",
                "Large Medkit (132)",
                "Large Medkit (133)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)

        inside_castle_area = self.region(
            "Inside Castle",
            [
                "Spikes (112)",
                "Rockets (113)",
                "Large Medkit (83)",
                "Large Medkit (111)",
                "Large Medkit (110)",
                "Plasma (84)",
                "Supershotgun (17)",
                "Rockets (103)",
                "Rocketlauncher (104)",
                "Large Medkit (91)",
                "Green Armor (99)",
                "Shells (88)",
                "Large Medkit (87)",
                "Large Medkit (96)",
                "Rockets (86)",
                "Spikes (85)",
                "Large Medkit (100)",
                "Spikes (101)",
                "Large Medkit (119)",
                "Large Medkit (120)",
                "Shells (116)",
                "Large Medkit (95)",
                "Large Medkit (98)",
            ],
        )
        self.connect(ret, inside_castle_area, r.can_door | r.bigjump_hard)

        right_platform_area = self.region(
            "Right Platform",
            [
                "Powerup (114)",
                "Rockets (118)",
            ],
        )
        self.connect(
            ret,
            right_platform_area,
            r.can_door
            | r.can_rj_hard
            | r.can_gj_extr
            | (r.can_jump & r.difficulty("hard")),
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Rockets (9)",
                "Shells (8)",
                "Silver Key (13)",
            ],
        )
        self.connect(inside_castle_area, past_door_area, r.can_door)

        past_silver_door_drop_area = self.region(
            "Past Silver Door Drop",
            [
                "Invisibility (89)",
                "Secret (90)",
                "Flag (144)",
                "Multi (97)",
                "Large Medkit (73)",
                "Sphere (7)",
                "Shells (72)",
                "Secret (11)",
                "Invulnerability (12)",
            ],
        )
        self.connect(
            ret,
            past_silver_door_drop_area,
            (self.silver_key | r.difficulty("extreme") | (r.can_shootswitch & r.jump)),
        )
        self.restrict("Invisibility (89)", r.can_button & r.can_shootswitch)
        self.restrict("Secret (90)", r.can_button & r.can_shootswitch)
        self.restrict("Secret (11)", r.can_shootswitch)
        self.restrict("Invulnerability (12)", r.can_shootswitch)

        past_silver_button_area = self.region(
            "Past Silver Button Area",
            [
                "Biosuit (3)",
                "Spikes (71)",
                "Large Medkit (69)",
                "Multi (66)",
                "Rocketlauncher (19)",
                "Rockets (65)",
                "Spikes (64)",
                "Large Medkit (68)",
                "Shells (63)",
                "Large Medkit (67)",
                "Plasma (45)",
                "Plasma (62)",
                "Yellow Armor (70)",
                "Grenadelauncher (57)",
                "Large Medkit (60)",
                "Large Medkit (61)",
                "Lava (58)",
                "Shells (139)",
                "Supershotgun (22)",
                "Rockets (55)",
                "Large Medkit (56)",
                "Large Medkit (53)",
                "Large Medkit (54)",
                "Multi (51)",
                "Spikes (50)",
                "Small Medkit (52)",
                "Rockets (41)",
                "Shells (40)",
                "Bridge Active",
            ],
        )
        self.connect(
            past_silver_door_drop_area,
            past_silver_button_area,
            r.can_button & r.can_dive,
        )
        self.restrict("Bridge Active", r.can_door)

        left_bridge_area = self.region(
            "Left Bridge Area",
            [
                "Supernailgun (18)",
                "Lava (42)",
                "Spikes (43)",
                "Small Medkit (44)",
                "Cells (46)",
                "Large Medkit (49)",
                "Large Medkit (48)",
                "Shells (47)",
                "Megahealth (59)",
                "Gate Opened",
            ],
        )
        self.connect(
            past_silver_button_area,
            left_bridge_area,
            self.event("Bridge Active") | r.bigjump_hard,
        )
        self.restrict("Megahealth (59)", r.jump)
        self.restrict("Gate Opened", r.can_door)

        past_sewer_gate_area = self.region(
            "Past Sewer Gate",
            [
                "Lava (39)",
                "Spikes (38)",
                "Nailgun (21)",
                "Large Medkit (37)",
                "Cells (36)",
                "Large Medkit (35)",
                "Large Medkit (34)",
                "Spikes (32)",
                "Sphere (6)",
                "Plasma (33)",
                "Lightning (20)",
                "Shells (31)",
                "Large Medkit (29)",
                "Large Medkit (30)",
                "Flag (2)",
                "Rockets (28)",
                "Small Medkit (27)",
                "Small Medkit (26)",
                "Grenadelauncher (16)",
                "Large Medkit (23)",
                "Green Armor (4)",
                "Cells (24)",
                "Powerup (5)",
                "Lava (82)",
                "Large Medkit (81)",
                "Spikes (80)",
                "Red Armor (14)",
                "Rockets (79)",
                "Large Medkit (76)",
                "Large Medkit (77)",
                "Shells (78)",
                "Nailgun (15)",
                "Exit",
                "Secret (138)",
                "Red Armor (10)",
            ],
        )
        self.connect(
            past_silver_button_area, past_sewer_gate_area, self.event("Gate Opened")
        )
        self.restrict("Secret (138)", (r.can_shootswitch & r.can_jump) | r.bigjump_hard)
        self.restrict(
            "Red Armor (10)", (r.can_shootswitch & r.can_jump) | r.bigjump_hard
        )

        past_silver_door_jump_area = self.region(
            "Past Silver Door Jump Area",
            [
                "Plasma (141)",
                "Large Medkit (92)",
                "Large Medkit (93)",
                "Cells (105)",
                "Cells (106)",
                "Cells (107)",
                "Cells (108)",
                "Lightning (140)",
                "Cells (109)",
                "Secret (142)",
                "Megahealth (143)",
                "All Kills (145)",
            ],
        )
        self.connect(
            ret,
            past_silver_door_jump_area,
            ((self.silver_key | r.difficulty("extreme")) & r.jump) | r.can_shootswitch,
        )
        self.restrict("Secret (142)", r.jump & r.can_shootswitch)
        self.restrict("Megahealth (143)", r.jump & r.can_shootswitch)

        self.restrict(
            "All Kills (145)", r.difficult_combat & (r.jump | r.can_shootswitch)
        )

        return ret
