from BaseClasses import Region

from ..base_classes import Q1Level


class r2m6(Q1Level):
    name = "Blood Sacrifice"
    mapfile = "r2m6"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Spikes (1)",
            "classname": "item_spikes",
            "uuid": 7243155976202018668,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Flag (2)",
            "classname": "item_flag_team2",
            "uuid": 5982148366309697769,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Flag (3)",
            "classname": "item_flag_team1",
            "uuid": 18050975616019483956,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Lava (4)",
            "classname": "item_lava_spikes",
            "uuid": 9951129596697993537,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 3978815808207509232,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Random (6)",
            "classname": "item_random_powerup",
            "uuid": 8715956716197572075,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Invulnerability (7)",
            "classname": "item_artifact_invulnerability",
            "uuid": 14079545529826038252,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Powerup (8)",
            "classname": "item_powerup_shield",
            "uuid": 1665352191678772702,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 5806236616121654900,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 10428933320921955889,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Lava (11)",
            "classname": "item_lava_spikes",
            "uuid": 12897127683724341448,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Multi (12)",
            "classname": "item_multi_rockets",
            "uuid": 2312063625233182031,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 4961300040220422602,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 12416850963911130292,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 5108560701530080890,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Green Armor (16)",
            "classname": "item_armor1",
            "uuid": 17913390430185545753,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Cells (17)",
            "classname": "item_cells",
            "uuid": 8476636267084555570,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 3487854735979743898,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 10812178772974201058,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 12263402296258468205,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Lava (21)",
            "classname": "item_lava_spikes",
            "uuid": 11352474394836365052,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Megahealth (22)",
            "classname": "item_health",
            "uuid": 8592177589057114523,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Plasma (23)",
            "classname": "item_plasma",
            "uuid": 13731348468067575702,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rockets (24)",
            "classname": "item_rockets",
            "uuid": 8635756135423788100,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 17645712840727988928,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 571635969495002659,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Random (27)",
            "classname": "item_random_powerup",
            "uuid": 14352886387043197600,
            "mp": 1,
        },
        {
            "id": 28,
            "name": "Lava (28)",
            "classname": "item_lava_spikes",
            "uuid": 14521751128650596112,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Multi (29)",
            "classname": "item_multi_rockets",
            "uuid": 13727410941949211363,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Secret (30)",
            "classname": "trigger_secret",
            "uuid": 184494255975770375,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Cells (31)",
            "classname": "item_cells",
            "uuid": 16169703850562808939,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Cells (32)",
            "classname": "item_cells",
            "uuid": 14410615544709735224,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Small Medkit (33)",
            "classname": "item_health",
            "uuid": 11352963381175580464,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 11128710158022095724,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Small Medkit (35)",
            "classname": "item_health",
            "uuid": 7053286731228587483,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Rockets (36)",
            "classname": "item_rockets",
            "uuid": 2707228918915043863,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 14208993003800761971,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Secret (38)",
            "classname": "trigger_secret",
            "uuid": 7791131335265918074,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Rockets (39)",
            "classname": "item_rockets",
            "uuid": 14130190212094893700,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 6659039391188299984,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Rockets (41)",
            "classname": "item_rockets",
            "uuid": 14770551044222675011,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Lava (42)",
            "classname": "item_lava_spikes",
            "uuid": 11116632852630733714,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Small Medkit (43)",
            "classname": "item_health",
            "uuid": 1529324250594085925,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Random (44)",
            "classname": "item_random_powerup",
            "uuid": 1319988144124674135,
            "mp": 1,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 14767732018678812170,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 7700230882309495435,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Green Armor (47)",
            "classname": "item_armor1",
            "uuid": 17868825986992726112,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Small Medkit (48)",
            "classname": "item_health",
            "uuid": 6566529708255070332,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Multi (49)",
            "classname": "item_multi_rockets",
            "uuid": 17414020785519998926,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Cells (50)",
            "classname": "item_cells",
            "uuid": 4277968043813998058,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Rockets (51)",
            "classname": "item_rockets",
            "uuid": 17354022787770407351,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 7368267769746541992,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Lava (53)",
            "classname": "item_lava_spikes",
            "uuid": 3046475582517132504,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 7855607336157076616,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 17329509208937837926,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Rocketlauncher (56)",
            "classname": "weapon_rocketlauncher",
            "uuid": 13448264179233223411,
            "mp": 1,
        },
        {
            "id": 57,
            "name": "Grenadelauncher (57)",
            "classname": "weapon_grenadelauncher",
            "uuid": 1124207483984572560,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Powerup (58)",
            "classname": "item_powerup_belt",
            "uuid": 18092466869314531119,
            "mp": 1,
        },
        {
            "id": 59,
            "name": "Shells (59)",
            "classname": "item_shells",
            "uuid": 2882258599670945148,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Spikes (60)",
            "classname": "item_spikes",
            "uuid": 10254019308586798339,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 15767585248215013107,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Multi (62)",
            "classname": "item_multi_rockets",
            "uuid": 710689425867751885,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Plasma (63)",
            "classname": "item_plasma",
            "uuid": 8355279309147205965,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 13165281088110516114,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Small Medkit (65)",
            "classname": "item_health",
            "uuid": 3633453898684268914,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 925546291096497089,
            "mp": 1,
        },
        {
            "id": 67,
            "name": "Lava (67)",
            "classname": "item_lava_spikes",
            "uuid": 18017102254749992762,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 13339467910042764868,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 119203307552230082,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 9536404003852639259,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 17424257356035722459,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 15022355450365144557,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Small Medkit (73)",
            "classname": "item_health",
            "uuid": 2229343089975138925,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Secret (74)",
            "classname": "trigger_secret",
            "uuid": 3493636997472405079,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 80909170261328725,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Silver Key (76)",
            "classname": "item_key1",
            "uuid": 10703218681961867616,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Supernailgun (77)",
            "classname": "weapon_supernailgun",
            "uuid": 11785011098785579256,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Small Medkit (78)",
            "classname": "item_health",
            "uuid": 12493101267315462149,
            "mp": 1,
        },
        {
            "id": 79,
            "name": "Rockets (79)",
            "classname": "item_rockets",
            "uuid": 549328218017499870,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Powerup (80)",
            "classname": "item_powerup_belt",
            "uuid": 7294665957329200610,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Multi (81)",
            "classname": "item_multi_rockets",
            "uuid": 9773821153439086785,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Plasma (82)",
            "classname": "item_plasma",
            "uuid": 1932543509740186237,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Quad Damage (83)",
            "classname": "item_artifact_super_damage",
            "uuid": 14639179715538587208,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Red Armor (84)",
            "classname": "item_armorInv",
            "uuid": 2515700244313759106,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Lava (85)",
            "classname": "item_lava_spikes",
            "uuid": 8930462819004445325,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Spikes (86)",
            "classname": "item_spikes",
            "uuid": 14741502902545367124,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Small Medkit (87)",
            "classname": "item_health",
            "uuid": 1990415505970592594,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Large Medkit (88)",
            "classname": "item_health",
            "uuid": 17330555869456402520,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Cells (89)",
            "classname": "item_cells",
            "uuid": 10350989049807263247,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Cells (90)",
            "classname": "item_cells",
            "uuid": 6203657298124541169,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Multi (91)",
            "classname": "item_multi_rockets",
            "uuid": 1093507337392868314,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Shells (92)",
            "classname": "item_shells",
            "uuid": 12517480893488589699,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Secret (93)",
            "classname": "trigger_secret",
            "uuid": 7216454281491243591,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Powerup (94)",
            "classname": "item_powerup_shield",
            "uuid": 16044364643082382293,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Quad Damage (95)",
            "classname": "item_artifact_super_damage",
            "uuid": 14201827244059609633,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Rockets (96)",
            "classname": "item_rockets",
            "uuid": 982976891250290985,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Shells (97)",
            "classname": "item_shells",
            "uuid": 12211070925786339109,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 3100121444023238938,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Lava (99)",
            "classname": "item_lava_spikes",
            "uuid": 17560881496865661828,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Plasma (100)",
            "classname": "item_plasma",
            "uuid": 4090445514225561988,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Small Medkit (101)",
            "classname": "item_health",
            "uuid": 1600049994410256253,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Small Medkit (102)",
            "classname": "item_health",
            "uuid": 3936656250860430088,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Large Medkit (103)",
            "classname": "item_health",
            "uuid": 8303980868364492439,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Large Medkit (104)",
            "classname": "item_health",
            "uuid": 3405745873442643894,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Spikes (105)",
            "classname": "item_spikes",
            "uuid": 4195052924692097932,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Multi (106)",
            "classname": "item_multi_rockets",
            "uuid": 13999895345152842886,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Multi (107)",
            "classname": "item_multi_rockets",
            "uuid": 15165223745269752674,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Secret (108)",
            "classname": "trigger_secret",
            "uuid": 8391991342166176688,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Large Medkit (109)",
            "classname": "item_health",
            "uuid": 14182259711551583673,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Large Medkit (110)",
            "classname": "item_health",
            "uuid": 14500735813513843036,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Spikes (111)",
            "classname": "item_spikes",
            "uuid": 4573758975882859334,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Red Armor (112)",
            "classname": "item_armorInv",
            "uuid": 6167774832900261277,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Shells (113)",
            "classname": "item_shells",
            "uuid": 4601282059243585963,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Small Medkit (114)",
            "classname": "item_health",
            "uuid": 17457230159080660979,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Multi (115)",
            "classname": "item_multi_rockets",
            "uuid": 3580744714951584602,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Large Medkit (116)",
            "classname": "item_health",
            "uuid": 2862297945370408380,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Shells (117)",
            "classname": "item_shells",
            "uuid": 15719753460111655972,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Lava (118)",
            "classname": "item_lava_spikes",
            "uuid": 12609684380589320905,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Large Medkit (119)",
            "classname": "item_health",
            "uuid": 9484513524601454400,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Plasma (120)",
            "classname": "item_plasma",
            "uuid": 10860951897656885807,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Small Medkit (121)",
            "classname": "item_health",
            "uuid": 13130348118801139477,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Lava (122)",
            "classname": "item_lava_spikes",
            "uuid": 11871525203476484308,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Supershotgun (123)",
            "classname": "weapon_supershotgun",
            "uuid": 7775523529232977234,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Yellow Armor (124)",
            "classname": "item_armor2",
            "uuid": 17734483781685089695,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Rocketlauncher (125)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17580799288021422442,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Large Medkit (126)",
            "classname": "item_health",
            "uuid": 5956956089903351200,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Large Medkit (127)",
            "classname": "item_health",
            "uuid": 15196280852479908438,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Cells (128)",
            "classname": "item_cells",
            "uuid": 10467637891711714656,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Large Medkit (129)",
            "classname": "item_health",
            "uuid": 5698104621264854338,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Rockets (130)",
            "classname": "item_rockets",
            "uuid": 15784655763223811242,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Large Medkit (131)",
            "classname": "item_health",
            "uuid": 5333868423605207958,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Large Medkit (132)",
            "classname": "item_health",
            "uuid": 4588052886460246835,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Shells (133)",
            "classname": "item_shells",
            "uuid": 12310205544375544407,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Spikes (134)",
            "classname": "item_spikes",
            "uuid": 4557156213961496853,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Spikes (135)",
            "classname": "item_spikes",
            "uuid": 15338039179892278889,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Shells (136)",
            "classname": "item_shells",
            "uuid": 7734539252658342541,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Lightning (137)",
            "classname": "weapon_lightning",
            "uuid": 12015089685258956311,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Small Medkit (138)",
            "classname": "item_health",
            "uuid": 15197185331347685520,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Multi (139)",
            "classname": "item_multi_rockets",
            "uuid": 9417841891740313956,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Cells (140)",
            "classname": "item_cells",
            "uuid": 7472877433347643361,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Small Medkit (141)",
            "classname": "item_health",
            "uuid": 9510746205765255874,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Small Medkit (142)",
            "classname": "item_health",
            "uuid": 17861878832413550328,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Large Medkit (143)",
            "classname": "item_health",
            "uuid": 1712398053652974956,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Large Medkit (144)",
            "classname": "item_health",
            "uuid": 1485086234284708307,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "Spikes (145)",
            "classname": "item_spikes",
            "uuid": 4812440935170837124,
            "mp": 0,
        },
        {
            "id": 146,
            "name": "Cells (146)",
            "classname": "item_cells",
            "uuid": 6764585613541635710,
            "mp": 0,
        },
        {
            "id": 147,
            "name": "Shells (147)",
            "classname": "item_shells",
            "uuid": 14728906412442034192,
            "mp": 0,
        },
        {
            "id": 148,
            "name": "Rockets (148)",
            "classname": "item_rockets",
            "uuid": 13904340069098322395,
            "mp": 0,
        },
        {
            "id": 149,
            "name": "Lava (149)",
            "classname": "item_lava_spikes",
            "uuid": 8363447591945926039,
            "mp": 0,
        },
        {
            "id": 150,
            "name": "Plasma (150)",
            "classname": "item_plasma",
            "uuid": 18398463608924377085,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Spikes (151)",
            "classname": "item_spikes",
            "uuid": 586165723614277673,
            "mp": 0,
        },
        {
            "id": 152,
            "name": "Shells (152)",
            "classname": "item_shells",
            "uuid": 1016629711336084397,
            "mp": 0,
        },
        {
            "id": 153,
            "name": "Yellow Armor (153)",
            "classname": "item_armor2",
            "uuid": 953644235603988755,
            "mp": 0,
        },
        {
            "id": 154,
            "name": "Large Medkit (154)",
            "classname": "item_health",
            "uuid": 5661583828322938889,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Large Medkit (155)",
            "classname": "item_health",
            "uuid": 16488766094361925118,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Lava (156)",
            "classname": "item_lava_spikes",
            "uuid": 14519618885768350358,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Small Medkit (157)",
            "classname": "item_health",
            "uuid": 8531548746984642116,
            "mp": 0,
        },
        {
            "id": 158,
            "name": "Rockets (158)",
            "classname": "item_rockets",
            "uuid": 1569727110021555990,
            "mp": 1,
        },
        {
            "id": 159,
            "name": "Lava (159)",
            "classname": "item_lava_spikes",
            "uuid": 14718433524560142879,
            "mp": 1,
        },
        {
            "id": 160,
            "name": "Large Medkit (160)",
            "classname": "item_health",
            "uuid": 3025659107722197929,
            "mp": 0,
        },
        {
            "id": 161,
            "name": "Large Medkit (161)",
            "classname": "item_health",
            "uuid": 14640719805128371017,
            "mp": 0,
        },
        {
            "id": 162,
            "name": "Multi (162)",
            "classname": "item_multi_rockets",
            "uuid": 16763769741475098857,
            "mp": 1,
        },
        {
            "id": 163,
            "name": "Lava (163)",
            "classname": "item_lava_spikes",
            "uuid": 12710499717266921523,
            "mp": 0,
        },
        {
            "id": 164,
            "name": "Megahealth (164)",
            "classname": "item_health",
            "uuid": 11858267294252023505,
            "mp": 1,
        },
        {
            "id": 165,
            "name": "Large Medkit (165)",
            "classname": "item_health",
            "uuid": 15866072906931759479,
            "mp": 1,
        },
        {
            "id": 166,
            "name": "Large Medkit (166)",
            "classname": "item_health",
            "uuid": 6934144266620318404,
            "mp": 0,
        },
        {
            "id": 167,
            "name": "Large Medkit (167)",
            "classname": "item_health",
            "uuid": 18091870244500942281,
            "mp": 0,
        },
        {
            "id": 168,
            "name": "Large Medkit (168)",
            "classname": "item_health",
            "uuid": 13898579791004296401,
            "mp": 0,
        },
        {
            "id": 169,
            "name": "Spikes (169)",
            "classname": "item_spikes",
            "uuid": 235983370888650162,
            "mp": 0,
        },
        {
            "id": 170,
            "name": "Large Medkit (170)",
            "classname": "item_health",
            "uuid": 5614441452143783585,
            "mp": 0,
        },
        {
            "id": 171,
            "name": "Large Medkit (171)",
            "classname": "item_health",
            "uuid": 18294578881516499552,
            "mp": 0,
        },
        {
            "id": 172,
            "name": "Lava (172)",
            "classname": "item_lava_spikes",
            "uuid": 567050328073480327,
            "mp": 0,
        },
        {
            "id": 173,
            "name": "Nailgun (173)",
            "classname": "weapon_nailgun",
            "uuid": 5345360437212230477,
            "mp": 1,
        },
        {
            "id": 174,
            "name": "Rockets (174)",
            "classname": "item_rockets",
            "uuid": 13319651493541543736,
            "mp": 0,
        },
        {
            "id": 175,
            "name": "Lava (175)",
            "classname": "item_lava_spikes",
            "uuid": 212847742833961371,
            "mp": 0,
        },
        {
            "id": 176,
            "name": "Grenadelauncher (176)",
            "classname": "weapon_grenadelauncher",
            "uuid": 215732812208590049,
            "mp": 1,
        },
        {
            "id": 177,
            "name": "Supernailgun (177)",
            "classname": "weapon_supernailgun",
            "uuid": 11062300832168673900,
            "mp": 1,
        },
        {
            "id": 178,
            "name": "Sphere (178)",
            "classname": "item_sphere",
            "uuid": 958798495963611408,
            "mp": 0,
        },
        {
            "id": 179,
            "name": "Sphere (179)",
            "classname": "item_sphere",
            "uuid": 6720481118560988849,
            "mp": 0,
        },
        {
            "id": 180,
            "name": "Flag (180)",
            "classname": "item_flag",
            "uuid": 12868482747693388800,
            "mp": 0,
        },
        {
            "id": 181,
            "name": "Lightning (181)",
            "classname": "weapon_lightning",
            "uuid": 7998123224887617314,
            "mp": 1,
        },
        {
            "id": 182,
            "name": "Large Medkit (182)",
            "classname": "item_health",
            "uuid": 12342992566217049970,
            "mp": 0,
        },
        {
            "id": 183,
            "name": "Large Medkit (183)",
            "classname": "item_health",
            "uuid": 4015607512302448447,
            "mp": 0,
        },
        {
            "id": 184,
            "name": "All Kills (184)",
            "classname": "all_kills",
            "uuid": 12874344125848274015,
            "mp": 0,
        },
    ]
    events = ["Button1 Pressed", "Button2 Pressed"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Random (44)",
                "Shells (46)",
                "Small Medkit (45)",
                "Green Armor (47)",
                "Flag (2)",
                "Rockets (79)",
                "Large Medkit (61)",
                "Shells (69)",
                "Large Medkit (66)",
                "Lava (67)",
                "Large Medkit (68)",
                "Small Medkit (78)",
                "Spikes (70)",
                "Large Medkit (71)",
                "Supernailgun (77)",
                "Small Medkit (65)",
                "Plasma (63)",
                "Large Medkit (64)",
                "Spikes (60)",
                "Shells (59)",
                "Rocketlauncher (56)",
                "Small Medkit (48)",
                "Lava (53)",
                "Spikes (52)",
                "Rockets (51)",
                "Large Medkit (54)",
                "Grenadelauncher (57)",
                "Powerup (58)",
                "Large Medkit (55)",
                "Cells (50)",
                "Multi (49)",
            ],
        )

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Large Medkit (182)",
                "Cells (17)",
                "Large Medkit (18)",
                "Green Armor (16)",
                "Large Medkit (183)",
                "Large Medkit (13)",
                "Large Medkit (14)",
                "Lava (11)",
                "Large Medkit (19)",
                "Large Medkit (15)",
                "Lightning (181)",
                "Multi (12)",
                "Large Medkit (20)",
                "Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)
        self.restrict("Exit", r.difficult_combat & r.jump)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Supershotgun (123)",
                "Yellow Armor (124)",
                "Shells (117)",
                "Large Medkit (116)",
                "Rockets (36)",
                "Large Medkit (109)",
                "Rockets (41)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)
        self.restrict("Rockets (41)", r.can_button)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Small Medkit (43)",
                "Lava (42)",
                "Small Medkit (73)",
                "Large Medkit (72)",
                "Rocketlauncher (125)",
                "Shells (92)",
                "Cells (128)",
                "Large Medkit (129)",
                "Rockets (96)",
                "Shells (97)",
                "Lava (99)",
                "Large Medkit (98)",
                "Small Medkit (102)",
                "Multi (107)",
                "Plasma (100)",
                "Flag (3)",
                "Small Medkit (101)",
                "Large Medkit (103)",
                "Spikes (105)",
                "Large Medkit (104)",
                "Multi (106)",
                "Small Medkit (35)",
                "Random (6)",
                "Spikes (134)",
                "Large Medkit (131)",
                "Shells (133)",
                "Large Medkit (132)",
                "Rockets (130)",
                "Secret (93)",
                "Powerup (80)",
                "Powerup (94)",
                "Quad Damage (95)",
            ],
        )
        self.connect(past_door_area, past_button_area, r.can_button & r.jump)
        self.restrict("Powerup (94)", r.bigjump)
        self.restrict("Quad Damage (95)", r.bigjump)

        lava_jump_area = self.region(
            "Lava Jump",
            [
                "Supernailgun (177)",
                "Rockets (158)",
                "Large Medkit (166)",
                "Large Medkit (160)",
                "Lava (159)",
                "Large Medkit (165)",
                "Large Medkit (171)",
                "Large Medkit (37)",
                "Large Medkit (170)",
                "Spikes (111)",
                "Large Medkit (110)",
                "Small Medkit (114)",
                "Shells (113)",
                "Multi (115)",
                "Secret (108)",
                "Red Armor (112)",
                "Rockets (174)",
                "Button1 Pressed",
            ],
        )
        self.connect(past_button_area, lava_jump_area, r.jump & r.heal(200))
        self.restrict("Secret (108)", r.can_shootswitch)
        self.restrict("Red Armor (112)", r.can_shootswitch)
        self.restrict("Rockets (174)", r.can_shootswitch)
        self.restrict(
            "Supernailgun (177)", r.difficulty("hard") | (r.invuln(1) & r.can_dive)
        )
        self.restrict("Button1 Pressed", r.can_button)

        past_lift_area = self.region(
            "Past Lift Area",
            [
                "Large Medkit (119)",
                "Small Medkit (121)",
                "Large Medkit (126)",
                "Lava (122)",
                "Large Medkit (127)",
            ],
        )
        self.connect(past_door_area, past_lift_area, r.bigjump_hard)
        self.connect(lava_jump_area, past_lift_area)

        past_statue_area = self.region(
            "Past Statue",
            [
                "Large Medkit (161)",
                "Megahealth (164)",
                "Multi (162)",
                "Lava (163)",
            ],
        )
        self.connect(past_lift_area, past_statue_area, r.can_shootswitch)

        past_statue_button_area = self.region(
            "Past Statue Button",
            [
                "Secret (30)",
                "Multi (29)",
                "Lava (28)",
                "Cells (32)",
                "Cells (31)",
                "Small Medkit (157)",
                "Small Medkit (33)",
                "Large Medkit (34)",
                "Grenadelauncher (176)",
                "Plasma (23)",
                "Rockets (24)",
                "Invulnerability (7)",
                "Random (27)",
                "Shells (26)",
                "Spikes (25)",
                "Large Medkit (5)",
                "Spikes (135)",
                "Shells (136)",
                "Cells (90)",
                "Cells (89)",
                "Plasma (82)",
                "Red Armor (84)",
                "Spikes (86)",
                "Lava (85)",
                "Secret (38)",
                "Sphere (178)",
                "Quad Damage (83)",
                "Multi (81)",
                "Small Medkit (87)",
                "Large Medkit (88)",
                "Large Medkit (40)",
                "Rockets (39)",
                "Flag (180)",
                "Large Medkit (168)",
                "Large Medkit (167)",
                "Large Medkit (143)",
                "Small Medkit (142)",
                "Large Medkit (144)",
                "Spikes (145)",
                "Lightning (137)",
                "Cells (146)",
                "Shells (147)",
                "Yellow Armor (153)",
                "Lava (156)",
                "Large Medkit (154)",
                "Large Medkit (155)",
                "Small Medkit (138)",
                "Spikes (1)",
                "Multi (139)",
                "Cells (140)",
                "Small Medkit (141)",
                "Powerup (8)",
                "Large Medkit (9)",
                "Spikes (169)",
                "Rockets (148)",
                "Large Medkit (10)",
                "Button2 Pressed",
            ],
        )
        self.connect(past_statue_area, past_statue_button_area, r.can_button)
        self.restrict("Red Armor (84)", r.jump)
        self.restrict("Spikes (86)", r.jump)
        self.restrict("Lava (85)", r.jump)
        self.restrict("Secret (38)", r.jump)
        self.restrict("Sphere (178)", r.jump)
        self.restrict("Quad Damage (83)", r.jump)
        self.restrict("Multi (81)", r.jump)

        past_teleporter_area = self.region(
            "Past Teleporter",
            [
                "Shells (152)",
                "Silver Key (76)",
                "Sphere (179)",
                "Spikes (151)",
                "Secret (74)",
                "Megahealth (22)",
                "All Kills (184)",
            ],
        )
        self.connect(
            past_door_area,
            past_teleporter_area,
            self.event("Button1 Pressed") & self.event("Button2 Pressed"),
        )
        self.restrict("Secret (74)", r.jump & r.can_button)
        self.restrict("Megahealth (22)", r.jump & r.can_button)

        self.restrict("All Kills (184)", self.silver_key & r.difficult_combat)

        return ret
