from BaseClasses import Region

from ..base_classes import Q1Level


class r2m4(Q1Level):
    name = "Curse of Osiris"
    mapfile = "r2m4"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Quad Damage (1)",
            "classname": "item_artifact_super_damage",
            "uuid": 6586252432830183279,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Quad Damage (2)",
            "classname": "item_artifact_super_damage",
            "uuid": 3987437568503978570,
            "mp": 1,
        },
        {
            "id": 3,
            "name": "Rockets (3)",
            "classname": "item_rockets",
            "uuid": 7102235729174375664,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 17562373134529376923,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 2378847926192735382,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Cells (6)",
            "classname": "item_cells",
            "uuid": 3997216344977677064,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 10486382598950886299,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 14050059927199621095,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 15565826126246445941,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 13227767453020800133,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 15617822271273139966,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Multi (12)",
            "classname": "item_multi_rockets",
            "uuid": 4205534616578876573,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 15800416340947034573,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Cells (14)",
            "classname": "item_cells",
            "uuid": 8884407955149953799,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Powerup (15)",
            "classname": "item_powerup_shield",
            "uuid": 13133627744822047426,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 4057952682795505414,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 6519164599706721884,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Rockets (18)",
            "classname": "item_rockets",
            "uuid": 1146721306027692663,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Plasma (19)",
            "classname": "item_plasma",
            "uuid": 4022105374554917431,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 8067818804446598416,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 3590045191591770260,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Multi (22)",
            "classname": "item_multi_rockets",
            "uuid": 13726728993624055024,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Lava (23)",
            "classname": "item_lava_spikes",
            "uuid": 15542152978406382933,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 8814219123249144525,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 13321663639792177041,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 10218235612838648004,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Red Armor (27)",
            "classname": "item_armorInv",
            "uuid": 9388994276942592409,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 7221257752700385426,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 10503516820768548030,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Rockets (30)",
            "classname": "item_rockets",
            "uuid": 15058493577659263440,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Cells (31)",
            "classname": "item_cells",
            "uuid": 3748854449350812822,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 14182318096814830296,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Plasma (33)",
            "classname": "item_plasma",
            "uuid": 891105065698531234,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Lava (34)",
            "classname": "item_lava_spikes",
            "uuid": 14093188234429904737,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 16592056819116851408,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 5092128668459309906,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 15697923451452699101,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 10806916503724324433,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Multi (39)",
            "classname": "item_multi_rockets",
            "uuid": 15548684072292265587,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 14634899697050644368,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 13674220061230997744,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Rockets (42)",
            "classname": "item_rockets",
            "uuid": 17448396444920303297,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Lava (43)",
            "classname": "item_lava_spikes",
            "uuid": 7591726094600185214,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 15362759171918783676,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 4764568936028450022,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Lava (46)",
            "classname": "item_lava_spikes",
            "uuid": 7154715724243369014,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Lava (47)",
            "classname": "item_lava_spikes",
            "uuid": 15702214681322676994,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 12428530074957884206,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Cells (49)",
            "classname": "item_cells",
            "uuid": 7975640799131885005,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 1374411665420547493,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 12230219377413623442,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Rockets (52)",
            "classname": "item_rockets",
            "uuid": 10878278616955145796,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Lava (53)",
            "classname": "item_lava_spikes",
            "uuid": 16592919325902048759,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Spikes (54)",
            "classname": "item_spikes",
            "uuid": 7564907568978936318,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 8239829307608508958,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Small Medkit (56)",
            "classname": "item_health",
            "uuid": 17602637623837919051,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Rockets (57)",
            "classname": "item_rockets",
            "uuid": 17995577876462795782,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Large Medkit (58)",
            "classname": "item_health",
            "uuid": 1548615971600649277,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Multi (59)",
            "classname": "item_multi_rockets",
            "uuid": 10692855016019902140,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Lava (60)",
            "classname": "item_lava_spikes",
            "uuid": 8680786705678935407,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 3576294324709619350,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Cells (62)",
            "classname": "item_cells",
            "uuid": 17704232197391113303,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Small Medkit (63)",
            "classname": "item_health",
            "uuid": 11389072125071704022,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Small Medkit (64)",
            "classname": "item_health",
            "uuid": 13106990920518423736,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 18338302369627825136,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Plasma (66)",
            "classname": "item_plasma",
            "uuid": 6461566160768904767,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 15394091350909053534,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Invisibility (68)",
            "classname": "item_artifact_invisibility",
            "uuid": 10533693888280974215,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Spikes (69)",
            "classname": "item_spikes",
            "uuid": 17426907604779361109,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Shells (70)",
            "classname": "item_shells",
            "uuid": 7464701263184430123,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 16945485101518647356,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Green Armor (72)",
            "classname": "item_armor1",
            "uuid": 5399335713211202884,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Rockets (73)",
            "classname": "item_rockets",
            "uuid": 4101999953136204256,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Lava (74)",
            "classname": "item_lava_spikes",
            "uuid": 6197340744571352779,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Large Medkit (75)",
            "classname": "item_health",
            "uuid": 6320638316564432721,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Large Medkit (76)",
            "classname": "item_health",
            "uuid": 5194827849688988004,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Large Medkit (77)",
            "classname": "item_health",
            "uuid": 10780524630682326529,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Cells (78)",
            "classname": "item_cells",
            "uuid": 4535219639400005152,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Plasma (79)",
            "classname": "item_plasma",
            "uuid": 8264174482883162282,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Lightning (80)",
            "classname": "weapon_lightning",
            "uuid": 2338711764327561358,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 13471985308285757041,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Rockets (82)",
            "classname": "item_rockets",
            "uuid": 4693891054304188587,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Powerup (83)",
            "classname": "item_powerup_belt",
            "uuid": 12541208198794257618,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 3644595450502251738,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Large Medkit (85)",
            "classname": "item_health",
            "uuid": 17055906745337110862,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Shells (86)",
            "classname": "item_shells",
            "uuid": 3411515496348641261,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Lava (87)",
            "classname": "item_lava_spikes",
            "uuid": 7252946354528035367,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Large Medkit (88)",
            "classname": "item_health",
            "uuid": 17272711276844641252,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Multi (89)",
            "classname": "item_multi_rockets",
            "uuid": 526982804482546875,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Megahealth (90)",
            "classname": "item_health",
            "uuid": 3130369169016443758,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Spikes (91)",
            "classname": "item_spikes",
            "uuid": 1090002709036970714,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Large Medkit (92)",
            "classname": "item_health",
            "uuid": 17349460743584316022,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Cells (93)",
            "classname": "item_cells",
            "uuid": 5030718915040502647,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Lava (94)",
            "classname": "item_lava_spikes",
            "uuid": 10817080941873534652,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Large Medkit (95)",
            "classname": "item_health",
            "uuid": 16262060607451418210,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Shells (96)",
            "classname": "item_shells",
            "uuid": 11519228198103188651,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 14882409451884365255,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Spikes (98)",
            "classname": "item_spikes",
            "uuid": 8969410427573428051,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Large Medkit (99)",
            "classname": "item_health",
            "uuid": 15227201053562063256,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Large Medkit (100)",
            "classname": "item_health",
            "uuid": 10995537842540012753,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Shells (101)",
            "classname": "item_shells",
            "uuid": 13995794683565907398,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Rockets (102)",
            "classname": "item_rockets",
            "uuid": 3536598092291610340,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Plasma (103)",
            "classname": "item_plasma",
            "uuid": 14657463136840090635,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Large Medkit (104)",
            "classname": "item_health",
            "uuid": 11043868664155507708,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Large Medkit (105)",
            "classname": "item_health",
            "uuid": 16758742385711473756,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Spikes (106)",
            "classname": "item_spikes",
            "uuid": 15071541612836418942,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Multi (107)",
            "classname": "item_multi_rockets",
            "uuid": 13941264794485753949,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Shells (108)",
            "classname": "item_shells",
            "uuid": 14515121590569387053,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Rockets (109)",
            "classname": "item_rockets",
            "uuid": 1988440883625432363,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Lava (110)",
            "classname": "item_lava_spikes",
            "uuid": 3932459648246480866,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Large Medkit (111)",
            "classname": "item_health",
            "uuid": 10943612890576407748,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Nailgun (112)",
            "classname": "weapon_nailgun",
            "uuid": 17378306170781554335,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Yellow Armor (113)",
            "classname": "item_armor2",
            "uuid": 4935923816863207289,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Supershotgun (114)",
            "classname": "weapon_supershotgun",
            "uuid": 15656049084455585218,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 11113082871813116945,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Supernailgun (116)",
            "classname": "weapon_supernailgun",
            "uuid": 10444447529490271857,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Megahealth (117)",
            "classname": "item_health",
            "uuid": 11765600702349620979,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Small Medkit (118)",
            "classname": "item_health",
            "uuid": 4910039401681514820,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Small Medkit (119)",
            "classname": "item_health",
            "uuid": 1543289070299415460,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Rockets (120)",
            "classname": "item_rockets",
            "uuid": 2659418146722839008,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Grenadelauncher (121)",
            "classname": "weapon_grenadelauncher",
            "uuid": 5685901821463758765,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Multi (122)",
            "classname": "item_multi_rockets",
            "uuid": 7093086135385099811,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Lava (123)",
            "classname": "item_lava_spikes",
            "uuid": 7851472916901054526,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Large Medkit (124)",
            "classname": "item_health",
            "uuid": 6610532480629695929,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Large Medkit (125)",
            "classname": "item_health",
            "uuid": 9080511825280824894,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Spikes (126)",
            "classname": "item_spikes",
            "uuid": 15920460392426166325,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Large Medkit (127)",
            "classname": "item_health",
            "uuid": 11395984355636602622,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Shells (128)",
            "classname": "item_shells",
            "uuid": 4343006661793084756,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Plasma (129)",
            "classname": "item_plasma",
            "uuid": 4867110442496546692,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Large Medkit (130)",
            "classname": "item_health",
            "uuid": 352460206210299799,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Shells (131)",
            "classname": "item_shells",
            "uuid": 16626272525489228966,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Shells (132)",
            "classname": "item_shells",
            "uuid": 15198216627646541678,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Quad Damage (133)",
            "classname": "item_artifact_super_damage",
            "uuid": 17715838699404655899,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Powerup (134)",
            "classname": "item_powerup_belt",
            "uuid": 577591427237742931,
            "mp": 1,
        },
        {
            "id": 135,
            "name": "Sphere (135)",
            "classname": "item_sphere",
            "uuid": 7817495526448173211,
            "mp": 1,
        },
        {
            "id": 136,
            "name": "Yellow Armor (136)",
            "classname": "item_armor2",
            "uuid": 3880707846447841501,
            "mp": 1,
        },
        {
            "id": 137,
            "name": "Powerup (137)",
            "classname": "item_powerup_shield",
            "uuid": 10393602988931330919,
            "mp": 1,
        },
        {
            "id": 138,
            "name": "Quad Damage (138)",
            "classname": "item_artifact_super_damage",
            "uuid": 9375875948448068363,
            "mp": 1,
        },
        {
            "id": 139,
            "name": "Invulnerability (139)",
            "classname": "item_artifact_invulnerability",
            "uuid": 2619360284091530548,
            "mp": 1,
        },
        {
            "id": 140,
            "name": "Rocketlauncher (140)",
            "classname": "weapon_rocketlauncher",
            "uuid": 8347342289221185006,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Rocketlauncher (141)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17227259210841307468,
            "mp": 1,
        },
        {
            "id": 142,
            "name": "Grenadelauncher (142)",
            "classname": "weapon_grenadelauncher",
            "uuid": 1534288455284636574,
            "mp": 1,
        },
        {
            "id": 143,
            "name": "Multi (143)",
            "classname": "item_multi_rockets",
            "uuid": 2649654798394063692,
            "mp": 1,
        },
        {
            "id": 144,
            "name": "Supershotgun (144)",
            "classname": "weapon_supershotgun",
            "uuid": 13717544785743245004,
            "mp": 1,
        },
        {
            "id": 145,
            "name": "Shells (145)",
            "classname": "item_shells",
            "uuid": 3066815204874236018,
            "mp": 1,
        },
        {
            "id": 146,
            "name": "Lightning (146)",
            "classname": "weapon_lightning",
            "uuid": 16741336124232163454,
            "mp": 1,
        },
        {
            "id": 147,
            "name": "Plasma (147)",
            "classname": "item_plasma",
            "uuid": 17693386035498593698,
            "mp": 1,
        },
        {
            "id": 148,
            "name": "Nailgun (148)",
            "classname": "weapon_nailgun",
            "uuid": 7368874478635819275,
            "mp": 1,
        },
        {
            "id": 149,
            "name": "Lava (149)",
            "classname": "item_lava_spikes",
            "uuid": 11000288135548167994,
            "mp": 1,
        },
        {
            "id": 150,
            "name": "Secret (150)",
            "classname": "trigger_secret",
            "uuid": 10836218239202138287,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Secret (151)",
            "classname": "trigger_secret",
            "uuid": 1062961539132114824,
            "mp": 0,
        },
        {
            "id": 152,
            "name": "Secret (152)",
            "classname": "trigger_secret",
            "uuid": 944375129767138105,
            "mp": 0,
        },
        {
            "id": 153,
            "name": "Red Armor (153)",
            "classname": "item_armorInv",
            "uuid": 16338916078486453597,
            "mp": 0,
        },
        {
            "id": 154,
            "name": "Secret (154)",
            "classname": "trigger_secret",
            "uuid": 8014879023446651708,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Flag (155)",
            "classname": "item_flag_team2",
            "uuid": 600397733185365218,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Flag (156)",
            "classname": "item_flag_team1",
            "uuid": 17190404528035123206,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Secret (157)",
            "classname": "trigger_secret",
            "uuid": 12303514636526004997,
            "mp": 0,
        },
        {
            "id": 158,
            "name": "Large Medkit (158)",
            "classname": "item_health",
            "uuid": 1194332338776979796,
            "mp": 0,
        },
        {
            "id": 159,
            "name": "Large Medkit (159)",
            "classname": "item_health",
            "uuid": 7676960468499385404,
            "mp": 0,
        },
        {
            "id": 160,
            "name": "Large Medkit (160)",
            "classname": "item_health",
            "uuid": 4851409100648121216,
            "mp": 0,
        },
        {
            "id": 161,
            "name": "Large Medkit (161)",
            "classname": "item_health",
            "uuid": 7981030157232785182,
            "mp": 0,
        },
        {
            "id": 162,
            "name": "Flag (162)",
            "classname": "item_flag",
            "uuid": 8809033409143857452,
            "mp": 0,
        },
        {
            "id": 163,
            "name": "All Kills (163)",
            "classname": "all_kills",
            "uuid": 511359261207548447,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Rockets (120)",
                "Supershotgun (114)",
                "Small Medkit (119)",
                "Small Medkit (118)",
                "Large Medkit (125)",
                "Large Medkit (124)",
                "Grenadelauncher (121)",
                "Multi (122)",
                "Powerup (137)",
                "Shells (128)",
                "Flag (155)",
                "Spikes (126)",
                "Large Medkit (127)",
                "Yellow Armor (113)",
            ],
        )
        self.restrict("Yellow Armor (113)", r.can_button & r.can_shootswitch)

        pyramid_area = self.region(
            "Pyramid Area",
            [
                "Plasma (129)",
                "Shells (132)",
                "Large Medkit (130)",
                "Lava (43)",
                "Shells (131)",
                "Large Medkit (44)",
                "Nailgun (112)",
                "Rockets (42)",
                "Sphere (135)",
                "Large Medkit (99)",
                "Large Medkit (100)",
                "Spikes (98)",
                "Spikes (91)",
                "Yellow Armor (136)",
                "Shells (96)",
                "Large Medkit (97)",
                "Large Medkit (95)",
                "Cells (93)",
                "Large Medkit (92)",
                "Megahealth (90)",
                "Large Medkit (111)",
                "Shells (108)",
                "Rockets (109)",
                "Shells (145)",
                "Supershotgun (144)",
                "Spikes (106)",
                "Multi (107)",
                "Shells (101)",
                "Large Medkit (104)",
                "Large Medkit (105)",
                "Quad Damage (138)",
                "Rockets (102)",
                "Large Medkit (88)",
                "Shells (86)",
                "Rocketlauncher (141)",
                "Large Medkit (85)",
                "Large Medkit (84)",
                "Powerup (83)",
                "Large Medkit (81)",
                "Rockets (82)",
                "Shells (45)",
                "Large Medkit (75)",
                "Large Medkit (76)",
                "Multi (39)",
                "Rockets (73)",
                "Spikes (69)",
                "Lava (34)",
                "Plasma (33)",
                "Large Medkit (48)",
                "Large Medkit (77)",
                "Cells (78)",
                "Plasma (79)",
                "Lightning (80)",
                "Large Medkit (71)",
                "Green Armor (72)",
                "Shells (70)",
                "Large Medkit (36)",
                "Large Medkit (35)",
                "Quad Damage (133)",
                "Secret (157)",
                "Plasma (66)",
                "Large Medkit (67)",
                "Invisibility (68)",
            ],
        )
        self.connect(ret, pyramid_area, r.can_button & r.can_door)
        self.restrict("Megahealth (90)", r.can_shootswitch)
        self.restrict("Quad Damage (133)", r.can_shootswitch)
        self.restrict("Large Medkit (36)", r.can_shootswitch)
        self.restrict("Large Medkit (35)", r.can_shootswitch)
        self.restrict("Secret (157)", r.can_shootswitch)
        self.restrict("Plasma (66)", r.can_shootswitch)
        self.restrict("Large Medkit (67)", r.can_shootswitch)
        self.restrict("Invisibility (68)", r.can_shootswitch)

        past_queen_area = self.region(
            "Past Queen",
            [
                "Large Medkit (158)",
                "Spikes (65)",
                "Small Medkit (64)",
                "Rockets (52)",
                "Shells (51)",
                "Small Medkit (63)",
                "Cells (62)",
                "Invulnerability (139)",
                "Multi (143)",
                "Spikes (50)",
                "Cells (49)",
                "Grenadelauncher (142)",
                "Flag (162)",
                "Large Medkit (61)",
                "Large Medkit (58)",
                "Powerup (134)",
                "Spikes (54)",
                "Spikes (55)",
                "Small Medkit (56)",
                "Rockets (57)",
                "Secret (152)",
                "Megahealth (117)",
                "Supernailgun (116)",
                "Multi (59)",
                "Lava (53)",
                "Large Medkit (41)",
                "Shells (40)",
                "Large Medkit (159)",
                "Large Medkit (37)",
                "Spikes (38)",
                "Spikes (28)",
                "Lava (23)",
                "Shells (24)",
                "Large Medkit (25)",
                "Yellow Armor (113)",
                "Nailgun (148)",
                "Lava (149)",
                "Rockets (18)",
                "Plasma (19)",
                "Spikes (16)",
                "Shells (17)",
                "Multi (12)",
                "Shells (11)",
                "Rocketlauncher (140)",
                "Cells (14)",
                "Large Medkit (13)",
                "Large Medkit (161)",
                "Flag (156)",
                "Shells (9)",
                "Rockets (10)",
                "Large Medkit (8)",
                "Large Medkit (7)",
                "Large Medkit (160)",
                "Large Medkit (20)",
                "Shells (21)",
            ],
        )
        self.connect(pyramid_area, past_queen_area, r.difficult_combat)
        self.restrict("Secret (152)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Megahealth (117)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        exit_area = self.region(
            "Exit Area",
            [
                "Lightning (146)",
                "Plasma (147)",
                "Cells (6)",
                "Secret (154)",
                "Red Armor (153)",
                "Quad Damage (2)",
                "Large Medkit (5)",
                "Large Medkit (4)",
                "Rockets (3)",
                "Exit",
                "All Kills (163)",
            ],
        )
        self.connect(past_queen_area, exit_area, r.difficult_combat | r.bigjump_hard)

        self.restrict("All Kills (163)", r.difficult_combat)

        self.restrict("Secret (154)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Red Armor (153)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Quad Damage (2)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Large Medkit (5)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Large Medkit (4)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Rockets (3)", r.can_shootswitch | r.bigjump_hard)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Secret (151)",
                "Quad Damage (1)",
                "Large Medkit (26)",
                "Red Armor (27)",
                "Small Medkit (29)",
                "Rockets (30)",
                "Cells (31)",
                "Secret (150)",
                "Powerup (15)",
                "Rockets (32)",
            ],
        )
        self.connect(past_queen_area, shootswitch_area, r.can_shootswitch)

        return ret
