from BaseClasses import Region

from ..base_classes import Q1Level


class r2m2(Q1Level):
    name = "Elemental Fury I"
    mapfile = "r2m2"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Supernailgun (1)",
            "classname": "weapon_supernailgun",
            "uuid": 823498680392952539,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Lava (2)",
            "classname": "item_lava_spikes",
            "uuid": 8968904744571538015,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Lava (3)",
            "classname": "item_lava_spikes",
            "uuid": 5404930354536769596,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Small Medkit (4)",
            "classname": "item_health",
            "uuid": 14853918884687901497,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Small Medkit (5)",
            "classname": "item_health",
            "uuid": 4679208926797652975,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Yellow Armor (6)",
            "classname": "item_armor2",
            "uuid": 11131962831380081571,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 18160663591591439816,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Cells (8)",
            "classname": "item_cells",
            "uuid": 8834046980601409563,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Small Medkit (9)",
            "classname": "item_health",
            "uuid": 7427051468901591406,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 4348875574782009177,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 12196991206977861327,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Shells (12)",
            "classname": "item_shells",
            "uuid": 11719505482809182137,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Small Medkit (13)",
            "classname": "item_health",
            "uuid": 8363799534333901821,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Multi (14)",
            "classname": "item_multi_rockets",
            "uuid": 4218122284432070837,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 9059111928409436073,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Plasma (16)",
            "classname": "item_plasma",
            "uuid": 135240113006854872,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Rocketlauncher (17)",
            "classname": "weapon_rocketlauncher",
            "uuid": 11342448307043468999,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Rockets (18)",
            "classname": "item_rockets",
            "uuid": 5784408005158814898,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 8466289862532423648,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 5208102897631095419,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Small Medkit (21)",
            "classname": "item_health",
            "uuid": 11630512047884182704,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Lava (22)",
            "classname": "item_lava_spikes",
            "uuid": 1466131360764130367,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 15981152150859651477,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 13003580239539330038,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 7735361004730865411,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Plasma (26)",
            "classname": "item_plasma",
            "uuid": 10778551747088398697,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 16320601900538114044,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 4416781459724896202,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Multi (29)",
            "classname": "item_multi_rockets",
            "uuid": 6046524832697459737,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 2902268081716465780,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Cells (31)",
            "classname": "item_cells",
            "uuid": 7773633514371346977,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Cells (32)",
            "classname": "item_cells",
            "uuid": 1609763464081605010,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 1991933452363316099,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 188705570043401571,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Green Armor (35)",
            "classname": "item_armor1",
            "uuid": 65031480935729561,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Lava (36)",
            "classname": "item_lava_spikes",
            "uuid": 6152492897052614761,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 14084999705773629416,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 14625156437394748771,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 15368561024537597092,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Supershotgun (40)",
            "classname": "weapon_supershotgun",
            "uuid": 7327750533466747455,
            "mp": 1,
        },
        {
            "id": 41,
            "name": "Powerup (41)",
            "classname": "item_powerup_belt",
            "uuid": 5715020101792197621,
            "mp": 1,
        },
        {
            "id": 42,
            "name": "Quad Damage (42)",
            "classname": "item_artifact_super_damage",
            "uuid": 4372889222690050904,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Secret (43)",
            "classname": "trigger_secret",
            "uuid": 2206375315088228656,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 3314552823666797891,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 6861925151289257331,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Multi (46)",
            "classname": "item_multi_rockets",
            "uuid": 1943480356126416313,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Plasma (47)",
            "classname": "item_plasma",
            "uuid": 9372641662796117986,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 12884288363286408566,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Grenadelauncher (49)",
            "classname": "weapon_grenadelauncher",
            "uuid": 7685309531341541313,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Invulnerability (50)",
            "classname": "item_artifact_invulnerability",
            "uuid": 4609080266414216674,
            "mp": 1,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 9213317164153658754,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 5180594724505223216,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 3115762102252102909,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 16367389063445449534,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 5202936965432350793,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Lava (56)",
            "classname": "item_lava_spikes",
            "uuid": 6036146785812402573,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Lightning (57)",
            "classname": "weapon_lightning",
            "uuid": 15222021802735369041,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Secret (58)",
            "classname": "trigger_secret",
            "uuid": 13370478472491799729,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 12544045217711654234,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Flag (60)",
            "classname": "item_flag_team2",
            "uuid": 12289110280903720275,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Flag (61)",
            "classname": "item_flag_team1",
            "uuid": 14546673777986716061,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Flag (62)",
            "classname": "item_flag",
            "uuid": 5204149804447048526,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Powerup (63)",
            "classname": "item_powerup_belt",
            "uuid": 3785649543753052620,
            "mp": 1,
        },
        {
            "id": 64,
            "name": "Powerup (64)",
            "classname": "item_powerup_shield",
            "uuid": 15640900908743774987,
            "mp": 1,
        },
        {
            "id": 65,
            "name": "Random (65)",
            "classname": "item_random_powerup",
            "uuid": 7992852355063033636,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Sphere (66)",
            "classname": "item_sphere",
            "uuid": 14846257456692033595,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Multi (67)",
            "classname": "item_multi_rockets",
            "uuid": 16580169391671115645,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Sphere (68)",
            "classname": "item_sphere",
            "uuid": 12960360959941629500,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Small Medkit (69)",
            "classname": "item_health",
            "uuid": 5999885188942041001,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "All Kills (70)",
            "classname": "all_kills",
            "uuid": 12726042264346881895,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (12)",
                "Rockets (10)",
                "Shells (52)",
                "Small Medkit (13)",
                "Small Medkit (5)",
                "Small Medkit (4)",
                "Powerup (63)",
                "Grenadelauncher (49)",
                "Spikes (48)",
                "Large Medkit (45)",
                "Large Medkit (44)",
                "Invulnerability (50)",
                "Plasma (47)",
                "Lava (2)",
                "Small Medkit (9)",
                "Lava (3)",
                "Spikes (11)",
                "Supernailgun (1)",
                "Cells (8)",
                "Large Medkit (7)",
                "Flag (61)",
                "Large Medkit (51)",
                "Secret (58)",
                "Yellow Armor (6)",
                "Random (65)",
                "Large Medkit (54)",
                "Large Medkit (55)",
                "Flag (62)",
                "Spikes (53)",
                "Lightning (57)",
                "Sphere (66)",
                "Multi (67)",
            ],
        )
        self.restrict("Lightning (57)", r.jump)
        self.restrict("Sphere (66)", r.can_door)
        self.restrict("Multi (67)", r.can_door)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Large Medkit (15)",
                "Plasma (16)",
                "Multi (14)",
                "Small Medkit (69)",
                "Lava (22)",
                "Small Medkit (21)",
                "Large Medkit (15)",
                "Plasma (16)",
                "Multi (14)",
                "Small Medkit (69)",
                "Lava (22)",
                "Small Medkit (21)",
                "Large Medkit (20)",
                "Flag (60)",
                "Large Medkit (37)",
                "Large Medkit (23)",
                "Shells (24)",
                "Supershotgun (40)",
                "Multi (29)",
                "Large Medkit (28)",
                "Large Medkit (30)",
                "Cells (31)",
                "Cells (32)",
                "Powerup (64)",
                "Large Medkit (33)",
                "Spikes (27)",
                "Plasma (26)",
                "Sphere (68)",
                "Large Medkit (25)",
                "Spikes (34)",
                "Large Medkit (19)",
                "Green Armor (35)",
                "Large Medkit (39)",
                "Shells (38)",
                "Rocketlauncher (17)",
                "Rockets (18)",
                "Powerup (41)",
                "Exit",
                "Secret (43)",
                "Quad Damage (42)",
                "All Kills (70)",
            ],
        )
        # TODO: For simplicty this area requires
        self.connect(ret, past_button_area, r.can_button & r.jump)
        self.restrict(
            "Exit", r.can_jump | ((r.can_gj_extr | r.can_rj_hard) & r.heal(200))
        )
        self.restrict("Secret (43)", r.bigjump)
        self.restrict("Quad Damage (42)", r.bigjump)

        self.restrict("All Kills (70)", r.difficult_combat)

        return ret
