from BaseClasses import Region

from ..base_classes import Q1Level


class r1m7(Q1Level):
    name = "Tomb of the Overlord"
    mapfile = "r1m7"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Sphere (1)",
            "classname": "item_sphere",
            "uuid": 2158564158257846428,
            "mp": 1,
        },
        {
            "id": 2,
            "name": "Sphere (2)",
            "classname": "item_sphere",
            "uuid": 4734683623922497334,
            "mp": 1,
        },
        {
            "id": 3,
            "name": "Yellow Armor (3)",
            "classname": "item_armor2",
            "uuid": 8261314034321713976,
            "mp": 1,
        },
        {
            "id": 4,
            "name": "Nailgun (4)",
            "classname": "weapon_nailgun",
            "uuid": 4528477046934775694,
            "mp": 1,
        },
        {
            "id": 5,
            "name": "Rockets (5)",
            "classname": "item_rockets",
            "uuid": 1945303559232290030,
            "mp": 1,
        },
        {
            "id": 6,
            "name": "Rocketlauncher (6)",
            "classname": "weapon_rocketlauncher",
            "uuid": 9274481768576068475,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 14237559250413184910,
            "mp": 1,
        },
        {
            "id": 8,
            "name": "Supershotgun (8)",
            "classname": "weapon_supershotgun",
            "uuid": 16920510635957903805,
            "mp": 1,
        },
        {
            "id": 9,
            "name": "Small Medkit (9)",
            "classname": "item_health",
            "uuid": 17229441176591040959,
            "mp": 1,
        },
        {
            "id": 10,
            "name": "Small Medkit (10)",
            "classname": "item_health",
            "uuid": 12371449168121703319,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 2589566327634821234,
            "mp": 1,
        },
        {
            "id": 12,
            "name": "Lava (12)",
            "classname": "item_lava_spikes",
            "uuid": 7343357681526954522,
            "mp": 1,
        },
        {
            "id": 13,
            "name": "Supernailgun (13)",
            "classname": "weapon_supernailgun",
            "uuid": 9545885172674573850,
            "mp": 1,
        },
        {
            "id": 14,
            "name": "Plasma (14)",
            "classname": "item_plasma",
            "uuid": 9948372549444610024,
            "mp": 1,
        },
        {
            "id": 15,
            "name": "Cells (15)",
            "classname": "item_cells",
            "uuid": 17996310098487810442,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Lightning (16)",
            "classname": "weapon_lightning",
            "uuid": 8320416091320284707,
            "mp": 1,
        },
        {
            "id": 17,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 15158612135365176796,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 12654945909477898605,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 6120856495437346910,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Small Medkit (20)",
            "classname": "item_health",
            "uuid": 10614099004856162659,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 1090593531869536551,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Plasma (22)",
            "classname": "item_plasma",
            "uuid": 6169110464799591049,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Cells (23)",
            "classname": "item_cells",
            "uuid": 2342274561808493505,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 17528815088492759149,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Plasma (25)",
            "classname": "item_plasma",
            "uuid": 17117765295579540988,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Lava (26)",
            "classname": "item_lava_spikes",
            "uuid": 16751596893472335414,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Multi (27)",
            "classname": "item_multi_rockets",
            "uuid": 1436367786721978186,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 9580168936865288800,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 5309105997381639306,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 16208104379822694899,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Spikes (31)",
            "classname": "item_spikes",
            "uuid": 12807991951670131150,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Shells (32)",
            "classname": "item_shells",
            "uuid": 4729241367573824270,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Powerup (33)",
            "classname": "item_powerup_shield",
            "uuid": 10917398544172041506,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Secret (34)",
            "classname": "trigger_secret",
            "uuid": 10495401323853027744,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Yellow Armor (35)",
            "classname": "item_armor2",
            "uuid": 8153271218096105499,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 14909222212541616888,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 5473476885133021271,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 18401932438181812181,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Multi (39)",
            "classname": "item_multi_rockets",
            "uuid": 16411939104878554097,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 6284787717619547271,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 10667958254842941403,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Lava (42)",
            "classname": "item_lava_spikes",
            "uuid": 13779979137760189359,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 191522540636231433,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 11598865677333757160,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 363984609834254793,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Cells (46)",
            "classname": "item_cells",
            "uuid": 9792499905292429578,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 16290625930230187437,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 9325030001830027885,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Nailgun (49)",
            "classname": "weapon_nailgun",
            "uuid": 170798350383614093,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 17499100460156999754,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 15339734598405147747,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 3807155405979361111,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 1158606894454322271,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 7760760459050701749,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Plasma (55)",
            "classname": "item_plasma",
            "uuid": 9353627590695746587,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Spikes (56)",
            "classname": "item_spikes",
            "uuid": 9096191853186672935,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Green Armor (57)",
            "classname": "item_armor1",
            "uuid": 11306163262440531834,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Multi (58)",
            "classname": "item_multi_rockets",
            "uuid": 1567592540264616606,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Rockets (59)",
            "classname": "item_rockets",
            "uuid": 11808597741929782345,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Shells (60)",
            "classname": "item_shells",
            "uuid": 10718093585489577033,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Supershotgun (61)",
            "classname": "weapon_supershotgun",
            "uuid": 12113513720158956957,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Nailgun (62)",
            "classname": "weapon_nailgun",
            "uuid": 15825192629056230288,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Grenadelauncher (63)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16285624229884814283,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Cells (64)",
            "classname": "item_cells",
            "uuid": 2434932678257011735,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Cells (65)",
            "classname": "item_cells",
            "uuid": 617273378159209139,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Small Medkit (66)",
            "classname": "item_health",
            "uuid": 16250167171745979423,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Shells (67)",
            "classname": "item_shells",
            "uuid": 10345622755626131205,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 17290692692647663082,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 9818190529737978127,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 1430992992094122177,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Multi (71)",
            "classname": "item_multi_rockets",
            "uuid": 15538095638834242358,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Shells (72)",
            "classname": "item_shells",
            "uuid": 1160784480193888561,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Cells (73)",
            "classname": "item_cells",
            "uuid": 6688225250605747382,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 127448822786077398,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Rockets (75)",
            "classname": "item_rockets",
            "uuid": 7138715635883685052,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Large Medkit (76)",
            "classname": "item_health",
            "uuid": 2812814958195211814,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Green Armor (77)",
            "classname": "item_armor1",
            "uuid": 14683239563415690607,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Large Medkit (78)",
            "classname": "item_health",
            "uuid": 649136175524445003,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Yellow Armor (79)",
            "classname": "item_armor2",
            "uuid": 2043002582112004865,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Small Medkit (80)",
            "classname": "item_health",
            "uuid": 7691642013793393019,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Small Medkit (81)",
            "classname": "item_health",
            "uuid": 3785768383738102809,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Small Medkit (82)",
            "classname": "item_health",
            "uuid": 10512710747198604001,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 12679565432460098571,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Rockets (84)",
            "classname": "item_rockets",
            "uuid": 4704552870438598373,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 18103333035303919280,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Large Medkit (86)",
            "classname": "item_health",
            "uuid": 15080921757730028057,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Large Medkit (87)",
            "classname": "item_health",
            "uuid": 3313448441626324450,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Lava (88)",
            "classname": "item_lava_spikes",
            "uuid": 9429294232987570987,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Shells (89)",
            "classname": "item_shells",
            "uuid": 618108358943530419,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Multi (90)",
            "classname": "item_multi_rockets",
            "uuid": 1640412946475763325,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 16097440406750269301,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Large Medkit (92)",
            "classname": "item_health",
            "uuid": 11409494195773231626,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Lava (93)",
            "classname": "item_lava_spikes",
            "uuid": 4902370563012402371,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Supernailgun (94)",
            "classname": "weapon_supernailgun",
            "uuid": 1586871906736267136,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Lava (95)",
            "classname": "item_lava_spikes",
            "uuid": 14149721809569923899,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Large Medkit (96)",
            "classname": "item_health",
            "uuid": 10374846376005995777,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Small Medkit (97)",
            "classname": "item_health",
            "uuid": 11450265676555816267,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Multi (98)",
            "classname": "item_multi_rockets",
            "uuid": 4941788351894435818,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 1383629987648103434,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Large Medkit (100)",
            "classname": "item_health",
            "uuid": 17943633907691347350,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Shells (101)",
            "classname": "item_shells",
            "uuid": 15955146330948635454,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Secret (102)",
            "classname": "trigger_secret",
            "uuid": 12646814417962828053,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Quad Damage (103)",
            "classname": "item_artifact_super_damage",
            "uuid": 12996791757804353955,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Shells (104)",
            "classname": "item_shells",
            "uuid": 118427053651022481,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Cells (105)",
            "classname": "item_cells",
            "uuid": 18332528844198252887,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Cells (106)",
            "classname": "item_cells",
            "uuid": 17570608956211754043,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Small Medkit (107)",
            "classname": "item_health",
            "uuid": 11452572663089721222,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Small Medkit (108)",
            "classname": "item_health",
            "uuid": 7798174968648847376,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Cells (109)",
            "classname": "item_cells",
            "uuid": 14468119048401144540,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Lava (110)",
            "classname": "item_lava_spikes",
            "uuid": 2321947326137928127,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Large Medkit (111)",
            "classname": "item_health",
            "uuid": 10685813317761109065,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Rockets (112)",
            "classname": "item_rockets",
            "uuid": 7893204376259087309,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Large Medkit (113)",
            "classname": "item_health",
            "uuid": 1795719176481993651,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Shells (114)",
            "classname": "item_shells",
            "uuid": 16778260162815292289,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Plasma (115)",
            "classname": "item_plasma",
            "uuid": 15519494094835673310,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Cells (116)",
            "classname": "item_cells",
            "uuid": 1247240870180739390,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Small Medkit (117)",
            "classname": "item_health",
            "uuid": 14308619040944262451,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Small Medkit (118)",
            "classname": "item_health",
            "uuid": 10073522705654952796,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Multi (119)",
            "classname": "item_multi_rockets",
            "uuid": 9780414392144303385,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Large Medkit (120)",
            "classname": "item_health",
            "uuid": 13532613296850888373,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Spikes (121)",
            "classname": "item_spikes",
            "uuid": 1743723827566029934,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Large Medkit (122)",
            "classname": "item_health",
            "uuid": 691615636361155306,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Rocketlauncher (123)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5766056376057861488,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Invisibility (124)",
            "classname": "item_artifact_invisibility",
            "uuid": 6091664239954748078,
            "mp": 1,
        },
        {
            "id": 125,
            "name": "Lightning (125)",
            "classname": "weapon_lightning",
            "uuid": 4358521999480950388,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Rockets (126)",
            "classname": "item_rockets",
            "uuid": 16692236691921837288,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Lava (127)",
            "classname": "item_lava_spikes",
            "uuid": 4100754024866407675,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Large Medkit (128)",
            "classname": "item_health",
            "uuid": 1016261584773231320,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Powerup (129)",
            "classname": "item_powerup_shield",
            "uuid": 3540250518583895667,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Secret (130)",
            "classname": "trigger_secret",
            "uuid": 13316065231842529165,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Gold Key (131)",
            "classname": "item_key2",
            "uuid": 3126901288232441751,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Random (132)",
            "classname": "item_random_powerup",
            "uuid": 8614211981809638119,
            "mp": 1,
        },
        {
            "id": 133,
            "name": "Flag (133)",
            "classname": "item_flag_team2",
            "uuid": 11282853845160538996,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Megahealth (134)",
            "classname": "item_health",
            "uuid": 10369781099173466390,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Red Armor (135)",
            "classname": "item_armorInv",
            "uuid": 16112006404681231926,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Powerup (136)",
            "classname": "item_powerup_belt",
            "uuid": 5429913456552855726,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Flag (137)",
            "classname": "item_flag_team1",
            "uuid": 9827706034262014435,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Flag (138)",
            "classname": "item_flag",
            "uuid": 6454292909445528039,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Secret (139)",
            "classname": "trigger_secret",
            "uuid": 4668024129429684852,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "All Kills (140)",
            "classname": "all_kills",
            "uuid": 18382844961988422029,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (128)",
                "Lava (127)",
                "Random (132)",
                "Rockets (126)",
                "Spikes (121)",
                "Large Medkit (120)",
                "Multi (119)",
                "Rocketlauncher (123)",
                "Large Medkit (122)",
                "Shells (114)",
                "Large Medkit (113)",
                "Yellow Armor (79)",
                "Cells (116)",
                "Small Medkit (117)",
                "Small Medkit (118)",
            ],
        )

        past_elevator_area = self.region(
            "Past Elevator",
            [
                "Rockets (112)",
                "Large Medkit (111)",
                "Rockets (75)",
                "Cells (109)",
                "Small Medkit (82)",
                "Small Medkit (81)",
                "Large Medkit (74)",
                "Cells (73)",
                "Large Medkit (78)",
                "Large Medkit (76)",
                "Shells (101)",
                "Large Medkit (100)",
                "Multi (98)",
                "Green Armor (77)",
                "Spikes (99)",
                "Sphere (1)",
                "Small Medkit (97)",
                "Large Medkit (96)",
                "Lava (93)",
                "Supernailgun (94)",
                "Shells (60)",
                "Supershotgun (61)",
                "Large Medkit (122)",
            ],
        )
        self.connect(ret, past_elevator_area, r.bigjump_hard | r.can_button)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Small Medkit (80)",
                "Small Medkit (107)",
                "Small Medkit (108)",
                "Shells (72)",
                "Large Medkit (83)",
                "Cells (105)",
                "Cells (106)",
                "Flag (133)",
                "Shells (104)",
                "Lightning (125)",
            ],
        )
        self.connect(past_elevator_area, past_door_area, r.can_door)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Secret (130)",
                "Megahealth (134)",
                "Large Medkit (91)",
                "Large Medkit (92)",
                "Shells (89)",
                "Spikes (70)",
                "Large Medkit (86)",
                "Nailgun (62)",
                "Large Medkit (87)",
                "Powerup (129)",
                "Secret (139)",
            ],
        )
        self.connect(past_elevator_area, past_button_area, r.can_button)
        self.restrict("Powerup (129)", r.can_shootswitch & r.jump)
        self.restrict("Secret (139)", r.can_shootswitch & r.jump)

        past_grave_area = self.region(
            "Past Grave",
            [
                "Spikes (85)",
                "Rockets (84)",
                "Large Medkit (69)",
                "Large Medkit (68)",
                "Shells (7)",
                "Shells (67)",
                "Supershotgun (8)",
                "Small Medkit (66)",
                "Cells (65)",
                "Cells (64)",
                "Green Armor (57)",
                "Rockets (59)",
                "Grenadelauncher (63)",
                "Flag (137)",
                "Multi (58)",
                "Spikes (56)",
                "Large Medkit (50)",
                "Nailgun (49)",
                "Spikes (48)",
                "Small Medkit (45)",
                "Cells (46)",
                "Yellow Armor (3)",
                "Large Medkit (47)",
                "Yellow Armor (35)",
                "Large Medkit (51)",
                "Large Medkit (44)",
                "Lava (42)",
                "Large Medkit (43)",
                "Gold Key (131)",
                "Rockets (54)",
                "Large Medkit (52)",
                "Large Medkit (53)",
                "Plasma (55)",
                "Quad Damage (103)",
                "Secret (102)",
            ],
        )
        self.connect(past_button_area, past_grave_area, r.can_button & r.can_door)

        self.restrict("Gold Key (131)", r.jump)
        self.restrict("Rockets (54)", r.jump)
        self.restrict("Large Medkit (52)", r.jump)
        self.restrict("Large Medkit (53)", r.jump)
        self.restrict("Plasma (55)", r.jump)
        self.restrict("Quad Damage (103)", r.can_jump | r.bigjump_hard)
        self.restrict("Secret (102)", r.can_jump | r.bigjump_hard)

        dive_area = self.region(
            "Dive Area",
            [
                "Invisibility (124)",
                "Multi (71)",
            ],
        )
        self.connect(past_grave_area, dive_area, r.can_dive)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Shells (38)",
                "Large Medkit (41)",
                "Sphere (2)",
                "Powerup (33)",
                "Secret (34)",
                "Large Medkit (40)",
                "Multi (39)",
            ],
        )
        self.connect(dive_area, past_gold_door_area, self.gold_key)

        inside_castle_area = self.region(
            "Inside Castle",
            [
                "Large Medkit (37)",
                "Shells (32)",
                "Large Medkit (36)",
                "Rockets (5)",
                "Rocketlauncher (6)",
                "Large Medkit (30)",
                "Spikes (31)",
            ],
        )
        self.connect(
            past_gold_door_area,
            inside_castle_area,
            r.can_button | (r.jump & r.difficulty("hard")),
        )

        past_button_castle_area = self.region(
            "Past Button Castle Area",
            [
                "Plasma (25)",
                "Large Medkit (28)",
                "Large Medkit (29)",
                "Nailgun (4)",
                "Flag (138)",
                "Plasma (22)",
                "Powerup (136)",
                "Cells (23)",
                "Lightning (16)",
                "Plasma (14)",
                "Cells (15)",
                "Shells (21)",
                "Large Medkit (24)",
                "Small Medkit (19)",
                "Small Medkit (20)",
                "Spikes (18)",
            ],
        )
        self.connect(inside_castle_area, past_button_castle_area, r.can_button)

        final_area = self.region(
            "Final Area",
            [
                "Red Armor (135)",
                "Small Medkit (10)",
                "Supernailgun (13)",
                "Small Medkit (9)",
                "Lava (12)",
                "Spikes (11)",
                "Exit",
                "All Kills (140)",
            ],
        )
        self.connect(past_button_castle_area, final_area, r.difficult_combat)

        self.restrict("Red Armor (135)", r.bigjump)

        self.restrict("All Kills (140)", r.difficult_combat)

        return ret
