from BaseClasses import Region

from ..base_classes import Q1Level


class r1m2(Q1Level):
    name = "Dread Portal"
    mapfile = "r1m2"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Shells (1)",
            "classname": "item_shells",
            "uuid": 14841777371537444846,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 4466340598318331723,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 12722742314527497382,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 17734162407755132354,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Flag (5)",
            "classname": "item_flag_team2",
            "uuid": 9197325158102103116,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Flag (6)",
            "classname": "item_flag_team1",
            "uuid": 1419979862862000279,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Flag (7)",
            "classname": "item_flag",
            "uuid": 639797713135762287,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Multi (8)",
            "classname": "item_multi_rockets",
            "uuid": 14571624969720662457,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Yellow Armor (9)",
            "classname": "item_armor2",
            "uuid": 9863779614212380643,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 12257188424976123948,
            "mp": 1,
        },
        {
            "id": 11,
            "name": "Lava (11)",
            "classname": "item_lava_spikes",
            "uuid": 9835416290459396685,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Spikes (12)",
            "classname": "item_spikes",
            "uuid": 9055729209998393677,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Multi (13)",
            "classname": "item_multi_rockets",
            "uuid": 4556500290214231964,
            "mp": 1,
        },
        {
            "id": 14,
            "name": "Lava (14)",
            "classname": "item_lava_spikes",
            "uuid": 16216536426743235088,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 3631210196023898422,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 2924640115030888340,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Multi (17)",
            "classname": "item_multi_rockets",
            "uuid": 11986592594493695580,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Powerup (18)",
            "classname": "item_powerup_shield",
            "uuid": 12389802021040585489,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Lava (19)",
            "classname": "item_lava_spikes",
            "uuid": 8092076057672157177,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Lava (20)",
            "classname": "item_lava_spikes",
            "uuid": 5204902266730335303,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Grenadelauncher (21)",
            "classname": "weapon_grenadelauncher",
            "uuid": 11072779634213664524,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Large Medkit (22)",
            "classname": "item_health",
            "uuid": 11385437098644052018,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 8331761523437829098,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Invisibility (24)",
            "classname": "item_artifact_invisibility",
            "uuid": 28884605720241919,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Supershotgun (25)",
            "classname": "weapon_supershotgun",
            "uuid": 17096291108398299344,
            "mp": 1,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 4892109640386076189,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 2675504533800104808,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Cells (28)",
            "classname": "item_cells",
            "uuid": 526448063962423543,
            "mp": 1,
        },
        {
            "id": 29,
            "name": "Rockets (29)",
            "classname": "item_rockets",
            "uuid": 3633371105587570901,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Red Armor (30)",
            "classname": "item_armorInv",
            "uuid": 10883030969909775507,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Quad Damage (31)",
            "classname": "item_artifact_super_damage",
            "uuid": 10017707876134625355,
            "mp": 1,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 16161371698474380582,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 5031521651416263689,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Supernailgun (34)",
            "classname": "weapon_supernailgun",
            "uuid": 1333110217335768745,
            "mp": 1,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 12533414817324386994,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Shells (36)",
            "classname": "item_shells",
            "uuid": 14412638918417122953,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Rockets (37)",
            "classname": "item_rockets",
            "uuid": 3985624327005538157,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Small Medkit (38)",
            "classname": "item_health",
            "uuid": 7295949599567126249,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Lightning (39)",
            "classname": "weapon_lightning",
            "uuid": 12131905079989160966,
            "mp": 1,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 8430532919429895640,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 12808770411707183426,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 6189059396946210457,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Megahealth (43)",
            "classname": "item_health",
            "uuid": 1031178264417976826,
            "mp": 1,
        },
        {
            "id": 44,
            "name": "Rocketlauncher (44)",
            "classname": "weapon_rocketlauncher",
            "uuid": 14925849250227328231,
            "mp": 1,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 692078151796261960,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Rockets (46)",
            "classname": "item_rockets",
            "uuid": 1090500989275720878,
            "mp": 1,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 18119853527372018890,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 4698760049015963664,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Quad Damage (49)",
            "classname": "item_artifact_super_damage",
            "uuid": 9150227583805678338,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Small Medkit (50)",
            "classname": "item_health",
            "uuid": 4763876976481699068,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Small Medkit (51)",
            "classname": "item_health",
            "uuid": 4095152908492188275,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 4266252133902924617,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 332993789131781671,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Small Medkit (54)",
            "classname": "item_health",
            "uuid": 3029922890900035721,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Small Medkit (55)",
            "classname": "item_health",
            "uuid": 2505948386302229839,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Supershotgun (56)",
            "classname": "weapon_supershotgun",
            "uuid": 17393359380434328588,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Secret (57)",
            "classname": "trigger_secret",
            "uuid": 8804083427479186771,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Shells (58)",
            "classname": "item_shells",
            "uuid": 84732865902299115,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 12297163862906869701,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Grenadelauncher (60)",
            "classname": "weapon_grenadelauncher",
            "uuid": 13218804850144555571,
            "mp": 1,
        },
        {
            "id": 61,
            "name": "Silver Key (61)",
            "classname": "item_key1",
            "uuid": 1300842459637054770,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Gold Key (62)",
            "classname": "item_key2",
            "uuid": 4416313467651069142,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Secret (63)",
            "classname": "trigger_secret",
            "uuid": 5901169663381372874,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Green Armor (64)",
            "classname": "item_armor1",
            "uuid": 3074498268915094292,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Megahealth (65)",
            "classname": "item_health",
            "uuid": 7188594956860908114,
            "mp": 1,
        },
        {
            "id": 66,
            "name": "Small Medkit (66)",
            "classname": "item_health",
            "uuid": 2338283788049216833,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Small Medkit (67)",
            "classname": "item_health",
            "uuid": 3251864021494854478,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Shells (68)",
            "classname": "item_shells",
            "uuid": 8137706825078063235,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Invulnerability (69)",
            "classname": "item_artifact_invulnerability",
            "uuid": 8322398741559913463,
            "mp": 1,
        },
        {
            "id": 70,
            "name": "Small Medkit (70)",
            "classname": "item_health",
            "uuid": 11475368119817733364,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Rockets (71)",
            "classname": "item_rockets",
            "uuid": 10132638501546722757,
            "mp": 1,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 3570632449308386245,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 12214544888769962575,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Rockets (74)",
            "classname": "item_rockets",
            "uuid": 6668652624843237404,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Yellow Armor (75)",
            "classname": "item_armor2",
            "uuid": 9795313723292222522,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Grenadelauncher (76)",
            "classname": "weapon_grenadelauncher",
            "uuid": 17883012204073248450,
            "mp": 1,
        },
        {
            "id": 77,
            "name": "Small Medkit (77)",
            "classname": "item_health",
            "uuid": 4075093473949984522,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Small Medkit (78)",
            "classname": "item_health",
            "uuid": 15640376694038631077,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Shells (79)",
            "classname": "item_shells",
            "uuid": 12735218602677577630,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Small Medkit (80)",
            "classname": "item_health",
            "uuid": 13072212436882714455,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 8686846675572022052,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Shells (82)",
            "classname": "item_shells",
            "uuid": 2134505811669915684,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 2310495167188616191,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Secret (84)",
            "classname": "trigger_secret",
            "uuid": 1387417185094365356,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Nailgun (85)",
            "classname": "weapon_nailgun",
            "uuid": 12110855442823219880,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Shells (86)",
            "classname": "item_shells",
            "uuid": 18111696559941050747,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Shells (87)",
            "classname": "item_shells",
            "uuid": 5341559731527119037,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Large Medkit (88)",
            "classname": "item_health",
            "uuid": 14463534336012427299,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Large Medkit (89)",
            "classname": "item_health",
            "uuid": 17269230615885758370,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Shells (90)",
            "classname": "item_shells",
            "uuid": 16768101495397275835,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Plasma (91)",
            "classname": "item_plasma",
            "uuid": 16123029445717205937,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Sphere (92)",
            "classname": "item_sphere",
            "uuid": 14103518988629928618,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Multi (93)",
            "classname": "item_multi_rockets",
            "uuid": 3185977891446927358,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Supernailgun (94)",
            "classname": "weapon_supernailgun",
            "uuid": 15679878445904688032,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Plasma (95)",
            "classname": "item_plasma",
            "uuid": 7666145824893344996,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Nailgun (96)",
            "classname": "weapon_nailgun",
            "uuid": 3186748924898295079,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Sphere (97)",
            "classname": "item_sphere",
            "uuid": 278355032264534128,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Plasma (98)",
            "classname": "item_plasma",
            "uuid": 17618244758637424521,
            "mp": 1,
        },
        {
            "id": 99,
            "name": "Multi (99)",
            "classname": "item_multi_rockets",
            "uuid": 13666955176014554837,
            "mp": 1,
        },
        {
            "id": 100,
            "name": "Powerup (100)",
            "classname": "item_powerup_belt",
            "uuid": 12388668805796065484,
            "mp": 1,
        },
        {
            "id": 101,
            "name": "Plasma (101)",
            "classname": "item_plasma",
            "uuid": 10422527291994826193,
            "mp": 1,
        },
        {
            "id": 102,
            "name": "Lava (102)",
            "classname": "item_lava_spikes",
            "uuid": 4178401173530308091,
            "mp": 1,
        },
        {
            "id": 103,
            "name": "Multi (103)",
            "classname": "item_multi_rockets",
            "uuid": 13310271919200004967,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Shells (104)",
            "classname": "item_shells",
            "uuid": 9912600890208883630,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Large Medkit (105)",
            "classname": "item_health",
            "uuid": 4305642270297876807,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Lava (106)",
            "classname": "item_lava_spikes",
            "uuid": 18050329283991893638,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Spikes (107)",
            "classname": "item_spikes",
            "uuid": 11185579997942699268,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Spikes (108)",
            "classname": "item_spikes",
            "uuid": 13287982895277099403,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Large Medkit (109)",
            "classname": "item_health",
            "uuid": 17277035819764609286,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Secret (110)",
            "classname": "trigger_secret",
            "uuid": 8722622377873426909,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "All Kills (111)",
            "classname": "all_kills",
            "uuid": 17525373769459826539,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Small Medkit (54)",
                "Small Medkit (55)",
                "Shells (53)",
                "Flag (7)",
            ],
        )

        dive_area = self.region(
            "Dive Area",
            [
                "Large Medkit (16)",
                "Large Medkit (15)",
                "Secret (63)",
                "Grenadelauncher (60)",
                "Green Armor (64)",
                "Shells (58)",
                "Large Medkit (59)",
                "Secret (57)",
                "Quad Damage (49)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)
        self.restrict("Secret (57)", r.can_button)
        self.restrict("Quad Damage (49)", r.can_button)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Shells (87)",
                "Large Medkit (88)",
                "Supershotgun (56)",
                "Powerup (18)",
                "Shells (52)",
                "Small Medkit (50)",
                "Small Medkit (51)",
                "Megahealth (65)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door | r.bigjump_hard)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Large Medkit (4)",
                "Shells (3)",
            ],
        )
        self.connect(past_door_area, past_button_area, r.can_button)

        past_2nd_door_area = self.region(
            "Past 2nd Door Area",
            [
                "Small Medkit (66)",
                "Small Medkit (70)",
                "Shells (68)",
                "Nailgun (96)",
                "Rockets (71)",
                "Small Medkit (67)",
                "Large Medkit (48)",
                "Rocketlauncher (44)",
                "Rockets (46)",
                "Large Medkit (47)",
                "Shells (45)",
                "Large Medkit (105)",
                "Invulnerability (69)",
            ],
        )
        self.connect(past_button_area, past_2nd_door_area, r.can_door)
        self.restrict(
            "Invulnerability (69)", r.can_rj_hard | r.can_gj_extr | r.can_jump
        )

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Shells (40)",
                "Lightning (39)",
                "Spikes (108)",
                "Spikes (107)",
                "Lava (19)",
                "Large Medkit (109)",
                "Shells (86)",
                "Small Medkit (80)",
                "Small Medkit (38)",
                "Large Medkit (41)",
                "Large Medkit (42)",
            ],
        )
        self.connect(past_2nd_door_area, past_silver_door_area, self.silver_key)

        silver_jump_area = self.region(
            "Silver Jump Area",
            [
                "Large Medkit (35)",
                "Nailgun (85)",
                "Shells (36)",
                "Rockets (37)",
                "Supernailgun (34)",
                "Large Medkit (33)",
                "Large Medkit (32)",
                "Multi (99)",
                "Secret (110)",
                "Rockets (29)",
                "Red Armor (30)",
                "Quad Damage (31)",
                "Lava (14)",
                "Multi (13)",
                "Sphere (97)",
                "Spikes (26)",
                "Cells (28)",
                "Large Medkit (27)",
                "Shells (82)",
                "Large Medkit (81)",
                "Grenadelauncher (21)",
                "Supershotgun (25)",
                "Powerup (100)",
                "Lava (11)",
                "Spikes (12)",
                "Rockets (10)",
                "Plasma (101)",
                "Lava (102)",
                "Multi (103)",
                "Large Medkit (23)",
                "Large Medkit (22)",
                "Flag (6)",
                "Yellow Armor (9)",
                "Invisibility (24)",
                "Gold Key (62)",
                "Shells (104)",
                "All Kills (111)",
            ],
        )
        self.connect(past_silver_door_area, silver_jump_area, r.jump | r.invuln(1))
        self.restrict("All Kills (111)", r.difficult_combat)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (89)",
                "Shells (90)",
                "Exit",
            ],
        )
        self.connect(past_2nd_door_area, past_gold_door_area, self.gold_key)

        jump_area = self.region(
            "Jump Area",
            [
                "Shells (79)",
                "Multi (93)",
                "Supernailgun (94)",
                "Flag (5)",
                "Small Medkit (77)",
                "Small Medkit (78)",
                "Sphere (92)",
                "Silver Key (61)",
                "Megahealth (43)",
                "Spikes (72)",
                "Large Medkit (73)",
                "Rockets (74)",
                "Secret (84)",
                "Large Medkit (2)",
                "Grenadelauncher (76)",
                "Yellow Armor (75)",
                "Shells (1)",
            ],
        )
        self.connect(past_2nd_door_area, jump_area, r.jump | r.invuln(1))

        return ret
