from BaseClasses import Region

from ..base_classes import Q1Level


class mge5m2(Q1Level):
    name = "Too Deep, Too Greedy"
    mapfile = "mge5m2"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Shells (1)",
            "classname": "item_shells",
            "uuid": 9579947232348133576,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Lightning (2)",
            "classname": "weapon_lightning",
            "uuid": 135366603464223912,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 61829229313647393,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Spikes (4)",
            "classname": "item_spikes",
            "uuid": 1621653939527978969,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 12739419137861443214,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 5441998842969927658,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Green Armor (7)",
            "classname": "item_armor1",
            "uuid": 5546460314356530798,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 12018418559401186069,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 8628380601326044798,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Spikes (10)",
            "classname": "item_spikes",
            "uuid": 17041502513153666321,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 3296464233878601029,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Shells (12)",
            "classname": "item_shells",
            "uuid": 15290886010260822830,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Cells (13)",
            "classname": "item_cells",
            "uuid": 13275101447624991470,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Cells (14)",
            "classname": "item_cells",
            "uuid": 1760397403738654192,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Cells (15)",
            "classname": "item_cells",
            "uuid": 592013551270193821,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Cells (16)",
            "classname": "item_cells",
            "uuid": 61785498135128346,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 2461410493361140168,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 11980454274625917318,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Shells (19)",
            "classname": "item_shells",
            "uuid": 11428269697447119108,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 10140566376854341098,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 11032584624321744385,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Spikes (22)",
            "classname": "item_spikes",
            "uuid": 7368754271779536499,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 7457212686856023581,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rocketlauncher (24)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12262361857026335075,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Rockets (25)",
            "classname": "item_rockets",
            "uuid": 737900892728617938,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 125341177119748683,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 14406351249164139904,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 13518763124243117064,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Green Armor (29)",
            "classname": "item_armor1",
            "uuid": 291587086811573728,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 8034758456163263528,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Green Armor (31)",
            "classname": "item_armor1",
            "uuid": 14630312036823125723,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Megahealth (32)",
            "classname": "item_health",
            "uuid": 17042292086175960260,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 6464535192380548275,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Cells (34)",
            "classname": "item_cells",
            "uuid": 3216260586958727841,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Shells (35)",
            "classname": "item_shells",
            "uuid": 3448586496766288614,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 1165666859076089261,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Large Medkit (37)",
            "classname": "item_health",
            "uuid": 10595431876771083987,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Sigil (38)",
            "classname": "item_sigil",
            "uuid": 14626447188950166231,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Spikes (39)",
            "classname": "item_spikes",
            "uuid": 4960290286630111895,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 9592437007987575675,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Megahealth (41)",
            "classname": "item_health",
            "uuid": 5786345159991133984,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Red Armor (42)",
            "classname": "item_armorInv",
            "uuid": 12202341359022852504,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Cells (43)",
            "classname": "item_cells",
            "uuid": 18099062914525740680,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 8147936631000869436,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 11890580847770301010,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Secret (46)",
            "classname": "trigger_secret",
            "uuid": 6854653802937400142,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Shells (47)",
            "classname": "item_shells",
            "uuid": 5982832897991876486,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Supershotgun (48)",
            "classname": "weapon_supershotgun",
            "uuid": 11342136256922000040,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Nailgun (49)",
            "classname": "weapon_nailgun",
            "uuid": 15455255587406101925,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 11330116641256907544,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Spikes (51)",
            "classname": "item_spikes",
            "uuid": 6060972966279794376,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Spikes (52)",
            "classname": "item_spikes",
            "uuid": 13250746890192962099,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 15251496567608229124,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 17844170458552705510,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rockets (55)",
            "classname": "item_rockets",
            "uuid": 3027686579070322611,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 3196762611666453459,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 14997071139144588332,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Spikes (58)",
            "classname": "item_spikes",
            "uuid": 444594385967122331,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Shells (59)",
            "classname": "item_shells",
            "uuid": 3793424675264748623,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 12475750842899052348,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Shells (61)",
            "classname": "item_shells",
            "uuid": 9635440583454295134,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Grenadelauncher (62)",
            "classname": "weapon_grenadelauncher",
            "uuid": 11747053209497827167,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 13683378438799269317,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 7839516035857026564,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 8127302674153414643,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 12820802206029641312,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Secret (67)",
            "classname": "trigger_secret",
            "uuid": 18065771922612099637,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Rocketlauncher (68)",
            "classname": "weapon_rocketlauncher",
            "uuid": 1654611477610268751,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 8815907666676212337,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 927752200233152676,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Shells (71)",
            "classname": "item_shells",
            "uuid": 6097507529496845244,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 2171411318459181505,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Shells (73)",
            "classname": "item_shells",
            "uuid": 150378534507607761,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Spikes (74)",
            "classname": "item_spikes",
            "uuid": 17342093081055029050,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Shells (75)",
            "classname": "item_shells",
            "uuid": 5172835291375125083,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Green Armor (76)",
            "classname": "item_armor1",
            "uuid": 5171564997570575528,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Secret (77)",
            "classname": "trigger_secret",
            "uuid": 14011117675374855940,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Secret (78)",
            "classname": "trigger_secret",
            "uuid": 10618828462430365529,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Megahealth (79)",
            "classname": "item_health",
            "uuid": 8208641276106887999,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Large Medkit (80)",
            "classname": "item_health",
            "uuid": 17588209856392025708,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 15084182969676057664,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Spikes (82)",
            "classname": "item_spikes",
            "uuid": 14873643271208501503,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Green Armor (83)",
            "classname": "item_armor1",
            "uuid": 4388396123431202609,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Spikes (84)",
            "classname": "item_spikes",
            "uuid": 10569908012005494349,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Secret (85)",
            "classname": "trigger_secret",
            "uuid": 2797322351320146811,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Spikes (86)",
            "classname": "item_spikes",
            "uuid": 3738848599620303273,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Rockets (87)",
            "classname": "item_rockets",
            "uuid": 7301917730527679674,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Spikes (88)",
            "classname": "item_spikes",
            "uuid": 6457327965914260329,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Supernailgun (89)",
            "classname": "weapon_supernailgun",
            "uuid": 13098018205309926719,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Shells (90)",
            "classname": "item_shells",
            "uuid": 9780287182594399635,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 9463648365312761264,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Spikes (92)",
            "classname": "item_spikes",
            "uuid": 4069382448063631853,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Rockets (93)",
            "classname": "item_rockets",
            "uuid": 12130151260371558202,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Cells (94)",
            "classname": "item_cells",
            "uuid": 13539740080492870625,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Large Medkit (95)",
            "classname": "item_health",
            "uuid": 1170980330464799602,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Large Medkit (96)",
            "classname": "item_health",
            "uuid": 5681432693457080409,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Spikes (97)",
            "classname": "item_spikes",
            "uuid": 17495954938993683851,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 9634617759326965282,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Shells (99)",
            "classname": "item_shells",
            "uuid": 16046273178011532433,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Spikes (100)",
            "classname": "item_spikes",
            "uuid": 9871175067165555301,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 4089271532748529403,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Shells (102)",
            "classname": "item_shells",
            "uuid": 18393625816328357064,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Large Medkit (103)",
            "classname": "item_health",
            "uuid": 16968145714290782481,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Spikes (104)",
            "classname": "item_spikes",
            "uuid": 7627755313082427436,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Spikes (105)",
            "classname": "item_spikes",
            "uuid": 14569985533406856526,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Large Medkit (106)",
            "classname": "item_health",
            "uuid": 15666442747471859158,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Shells (107)",
            "classname": "item_shells",
            "uuid": 796628071743906505,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Spikes (108)",
            "classname": "item_spikes",
            "uuid": 3579922219299197487,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Large Medkit (109)",
            "classname": "item_health",
            "uuid": 9506817630637100669,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Large Medkit (110)",
            "classname": "item_health",
            "uuid": 9961660746452301747,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Rockets (111)",
            "classname": "item_rockets",
            "uuid": 7613819058515339780,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Grenadelauncher (112)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16805145254675554267,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Yellow Armor (113)",
            "classname": "item_armor2",
            "uuid": 7647760690315054338,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Shells (114)",
            "classname": "item_shells",
            "uuid": 16139615616746721247,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Spikes (115)",
            "classname": "item_spikes",
            "uuid": 18114891645904046731,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Secret (116)",
            "classname": "trigger_secret",
            "uuid": 18151172328161600213,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Shells (117)",
            "classname": "item_shells",
            "uuid": 3877724585540253952,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Shells (118)",
            "classname": "item_shells",
            "uuid": 7808127538332223039,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Large Medkit (119)",
            "classname": "item_health",
            "uuid": 12068990537590333763,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Large Medkit (120)",
            "classname": "item_health",
            "uuid": 3611864368636375552,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Small Medkit (121)",
            "classname": "item_health",
            "uuid": 3142137976857605866,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Spikes (122)",
            "classname": "item_spikes",
            "uuid": 17301703173428668521,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Large Medkit (123)",
            "classname": "item_health",
            "uuid": 8538498717083510668,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Large Medkit (124)",
            "classname": "item_health",
            "uuid": 10785076481713805519,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Shells (125)",
            "classname": "item_shells",
            "uuid": 5561600136085912029,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Spikes (126)",
            "classname": "item_spikes",
            "uuid": 6390846845083668664,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Spikes (127)",
            "classname": "item_spikes",
            "uuid": 14422950679242371771,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Green Armor (128)",
            "classname": "item_armor1",
            "uuid": 3426307420491721967,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Spikes (129)",
            "classname": "item_spikes",
            "uuid": 8604208460826476866,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Megahealth (130)",
            "classname": "item_health",
            "uuid": 13852841776027159249,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Gold Key (131)",
            "classname": "item_key2",
            "uuid": 1236182359250925175,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Green Armor (132)",
            "classname": "item_armor1",
            "uuid": 15671136422076316649,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Large Medkit (133)",
            "classname": "item_health",
            "uuid": 13528105042605067562,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Large Medkit (134)",
            "classname": "item_health",
            "uuid": 5905694384248752494,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Cells (135)",
            "classname": "item_cells",
            "uuid": 6004683506073641803,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Quad Damage (136)",
            "classname": "item_artifact_super_damage",
            "uuid": 10930065509289027044,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Secret (137)",
            "classname": "trigger_secret",
            "uuid": 9725997925657944658,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Spikes (138)",
            "classname": "item_spikes",
            "uuid": 5477311970326433703,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Yellow Armor (139)",
            "classname": "item_armor2",
            "uuid": 15336740246112571721,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Shells (140)",
            "classname": "item_shells",
            "uuid": 8190313775024202988,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Lightning (141)",
            "classname": "weapon_lightning",
            "uuid": 16431701906701888615,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Megahealth (142)",
            "classname": "item_health",
            "uuid": 16531651681434782021,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Spikes (143)",
            "classname": "item_spikes",
            "uuid": 15393932306075973088,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Spikes (144)",
            "classname": "item_spikes",
            "uuid": 181007399282078055,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "Shells (145)",
            "classname": "item_shells",
            "uuid": 8954299757496316127,
            "mp": 0,
        },
        {
            "id": 146,
            "name": "Large Medkit (146)",
            "classname": "item_health",
            "uuid": 13584027884511677400,
            "mp": 0,
        },
        {
            "id": 147,
            "name": "Large Medkit (147)",
            "classname": "item_health",
            "uuid": 9557356153041347755,
            "mp": 0,
        },
        {
            "id": 148,
            "name": "Spikes (148)",
            "classname": "item_spikes",
            "uuid": 15553044233842497817,
            "mp": 0,
        },
        {
            "id": 149,
            "name": "Rockets (149)",
            "classname": "item_rockets",
            "uuid": 2903715656702896280,
            "mp": 0,
        },
        {
            "id": 150,
            "name": "Cells (150)",
            "classname": "item_cells",
            "uuid": 17371476920697462242,
            "mp": 0,
        },
        {
            "id": 151,
            "name": "Shells (151)",
            "classname": "item_shells",
            "uuid": 14956388291212946630,
            "mp": 0,
        },
        {
            "id": 152,
            "name": "Rockets (152)",
            "classname": "item_rockets",
            "uuid": 2635901415289919620,
            "mp": 0,
        },
        {
            "id": 153,
            "name": "Shells (153)",
            "classname": "item_shells",
            "uuid": 2161651446433773581,
            "mp": 0,
        },
        {
            "id": 154,
            "name": "Shells (154)",
            "classname": "item_shells",
            "uuid": 14874382334278464403,
            "mp": 0,
        },
        {
            "id": 155,
            "name": "Spikes (155)",
            "classname": "item_spikes",
            "uuid": 16292623360010881506,
            "mp": 0,
        },
        {
            "id": 156,
            "name": "Large Medkit (156)",
            "classname": "item_health",
            "uuid": 9225970795608681911,
            "mp": 0,
        },
        {
            "id": 157,
            "name": "Shells (157)",
            "classname": "item_shells",
            "uuid": 13776470839731542329,
            "mp": 0,
        },
        {
            "id": 158,
            "name": "Shells (158)",
            "classname": "item_shells",
            "uuid": 3605466640679042043,
            "mp": 0,
        },
        {
            "id": 159,
            "name": "Large Medkit (159)",
            "classname": "item_health",
            "uuid": 4301297491831952731,
            "mp": 0,
        },
        {
            "id": 160,
            "name": "All Kills (160)",
            "classname": "all_kills",
            "uuid": 1030169519161604972,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Supershotgun (48)",
                "Shells (47)",
                "Nailgun (49)",
                "Shells (75)",
                "Secret (77)",
                "Green Armor (76)",
                "Spikes (50)",
                "Spikes (65)",
                "Large Medkit (60)",
                "Shells (64)",
                "Spikes (52)",
                "Shells (53)",
                "Large Medkit (54)",
                "Spikes (51)",
                "Large Medkit (66)",
                "Grenadelauncher (62)",
                "Shells (56)",
                "Rockets (55)",
                "Spikes (63)",
                "Shells (59)",
                "Green Armor (83)",
                "Large Medkit (69)",
                "Large Medkit (57)",
                "Shells (61)",
                "Shells (71)",
                "Large Medkit (70)",
                "Rocketlauncher (68)",
                "Secret (67)",
                "Large Medkit (72)",
                # jump
                "Spikes (82)",
                "Large Medkit (80)",
                "Large Medkit (81)",
                "Spikes (58)",
                "Secret (78)",
                "Megahealth (79)",
            ],
        )
        self.restrict("Spikes (82)", r.jump)
        self.restrict("Large Medkit (80)", r.jump)
        self.restrict("Large Medkit (81)", r.jump)
        self.restrict("Spikes (58)", r.jump)
        self.restrict("Secret (78)", r.jump)
        self.restrict("Megahealth (79)", r.jump)

        jump_area = self.region(
            "Jump Area",
            [
                "Large Medkit (27)",
                "Large Medkit (26)",
            ],
        )
        self.connect(ret, jump_area, r.jump)

        past_button_door_area = self.region(
            "Past Button Door Area",
            [
                "Spikes (100)",
                "Large Medkit (95)",
                "Large Medkit (96)",
                "Large Medkit (98)",
                "Large Medkit (28)",
                "Shells (99)",
                "Spikes (97)",
                "Shells (90)",
                "Spikes (115)",
                "Spikes (105)",
                "Large Medkit (123)",
                "Cells (94)",
                "Large Medkit (109)",
                "Rockets (93)",
                "Green Armor (29)",
                "Large Medkit (30)",
                "Large Medkit (110)",
                "Large Medkit (106)",
                "Secret (85)",
                "Spikes (88)",
                "Spikes (86)",
                "Rockets (87)",
                "Supernailgun (89)",
                "Spikes (104)",
                "Spikes (108)",
                "Shells (107)",
                "Rockets (111)",
                "Spikes (84)",
                "Large Medkit (103)",
                "Shells (114)",
                # jump
                "Grenadelauncher (112)",
            ],
        )
        self.connect(jump_area, past_button_door_area, r.can_button & r.can_door)

        past_bridge_area = self.region(
            "Past Bridge",
            [
                "Yellow Armor (113)",
                "Secret (116)",
                "Spikes (101)",
                "Shells (102)",
                "Shells (118)",
                "Spikes (92)",
                "Green Armor (31)",
                "Large Medkit (119)",
                "Spikes (122)",
                "Large Medkit (91)",
                "Megahealth (130)",
                "Shells (125)",
                "Green Armor (128)",
                "Spikes (126)",
                "Spikes (129)",
                "Large Medkit (124)",
                "Spikes (127)",
                "Rockets (25)",
                "Rocketlauncher (24)",
                "Spikes (138)",
                "Shells (140)",
                "Large Medkit (134)",
                "Cells (135)",
                "Large Medkit (133)",
                "Green Armor (132)",
                "Rockets (149)",
                "Large Medkit (147)",
                "Quad Damage (136)",
                "Large Medkit (146)",
                "Spikes (143)",
                "Shells (151)",
                "Shells (157)",
                "Cells (150)",
                "Megahealth (32)",
                "Spikes (148)",
                "Shells (154)",
                "Large Medkit (159)",
                "Spikes (144)",
                "Spikes (155)",
                "Large Medkit (156)",
                "Shells (145)",
                "Shells (158)",
                "Rockets (152)",
                "Gold Key (131)",
                # jump
                "Shells (117)",
                "Small Medkit (121)",
                "Large Medkit (120)",
                # shootswitch
                "Secret (77)",
                "Green Armor (76)",
                "Secret (137)",
                "Yellow Armor (139)",
                "Lightning (141)",
                "Megahealth (142)",
            ],
        )
        self.connect(
            past_button_door_area, past_bridge_area, r.bigjump_hard | r.can_shootswitch
        )
        self.restrict("Shells (117)", r.jump)
        self.restrict("Small Medkit (121)", r.jump)
        self.restrict("Large Medkit (120)", r.jump)
        self.restrict("Grenadelauncher (112)", r.jump)

        self.restrict("Secret (77)", r.can_shootswitch)
        self.restrict("Green Armor (76)", r.can_shootswitch)
        self.restrict("Secret (137)", r.can_shootswitch)
        self.restrict("Yellow Armor (139)", r.can_shootswitch)
        self.restrict("Lightning (141)", r.can_shootswitch)
        self.restrict("Megahealth (142)", r.can_shootswitch)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Shells (35)",
                "Cells (34)",
                "Large Medkit (33)",
                "Large Medkit (37)",
                "Spikes (36)",
            ],
        )
        self.connect(past_bridge_area, past_gold_door_area, self.gold_key)

        past_gold_jump_area = self.region(
            "Past Gold Jump",
            [
                "Sigil (38)",
                "Large Medkit (3)",
                "Lightning (2)",
                "Spikes (44)",
                "Cells (43)",
                "Green Armor (7)",
                "Shells (1)",
                "Spikes (4)",
                "Spikes (10)",
                "Spikes (11)",
                "Large Medkit (5)",
                "Large Medkit (6)",
                "Large Medkit (8)",
                "Shells (9)",
                "Shells (12)",
                "Large Medkit (17)",
                "Large Medkit (18)",
                "Cells (13)",
                "Cells (14)",
                "Cells (15)",
                "Cells (16)",
                "Shells (19)",
                "Large Medkit (20)",
                "Large Medkit (21)",
                "Spikes (23)",
                "Megahealth (41)",
                "Spikes (22)",
                "Secret (46)",
                "Red Armor (42)",
                "Spikes (40)",
                "Spikes (39)",
                "Exit",
                "All Kills (160)",
            ],
        )
        self.connect(ret, past_gold_jump_area, r.jump)
        self.restrict("All Kills (160)", r.difficult_combat)

        return ret
