from BaseClasses import Region

from ..base_classes import Q1Level


class mge5m1(Q1Level):
    name = "Nazard Terminal"
    mapfile = "mge5m1"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Shells (1)",
            "classname": "item_shells",
            "uuid": 9074343014484239280,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Shells (2)",
            "classname": "item_shells",
            "uuid": 16550669515231169498,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 1589261333732693848,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Spikes (4)",
            "classname": "item_spikes",
            "uuid": 13094041789348770782,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Spikes (5)",
            "classname": "item_spikes",
            "uuid": 13965809274740515891,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Nailgun (6)",
            "classname": "weapon_nailgun",
            "uuid": 4202458072607683127,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Green Armor (7)",
            "classname": "item_armor1",
            "uuid": 192311892129853258,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Nailgun (8)",
            "classname": "weapon_nailgun",
            "uuid": 2476601884853594937,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Secret (9)",
            "classname": "trigger_secret",
            "uuid": 10494482414367726155,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Spikes (10)",
            "classname": "item_spikes",
            "uuid": 6938374079459850346,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 3999382717993675547,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 11344643577254850062,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Shells (13)",
            "classname": "item_shells",
            "uuid": 17606831254113683129,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Spikes (14)",
            "classname": "item_spikes",
            "uuid": 3380549507441752793,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Spikes (15)",
            "classname": "item_spikes",
            "uuid": 13641144403323256499,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 4795856148680671618,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 16398806042058139893,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 10992872305475725709,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 18086207866771976825,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 12333991556862904371,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 1209412592722265940,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Large Medkit (22)",
            "classname": "item_health",
            "uuid": 253912935027110134,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Yellow Armor (23)",
            "classname": "item_armor2",
            "uuid": 4331363632828980763,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 18424135019824005244,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 15659968545920936223,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 15800658846411710696,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Shells (27)",
            "classname": "item_shells",
            "uuid": 16955244448685128579,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 10313719205473328455,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Spikes (29)",
            "classname": "item_spikes",
            "uuid": 2676985407547039673,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Spikes (30)",
            "classname": "item_spikes",
            "uuid": 12981282914618945439,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 1202326406756650326,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 1144843746225182381,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 9160075610786872478,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 4433944144394044558,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 12749620141014862877,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Rockets (36)",
            "classname": "item_rockets",
            "uuid": 2457284748449008920,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 5540468254652486901,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 5725823557667049243,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 15205857232920800113,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 1954568041244197385,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Yellow Armor (41)",
            "classname": "item_armor2",
            "uuid": 2476968533149229903,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 9060128043485839315,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Rockets (43)",
            "classname": "item_rockets",
            "uuid": 8883612853597516703,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Grenadelauncher (44)",
            "classname": "weapon_grenadelauncher",
            "uuid": 3270884072551066568,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Rockets (45)",
            "classname": "item_rockets",
            "uuid": 2092116170034305621,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Spikes (46)",
            "classname": "item_spikes",
            "uuid": 4471557024301857166,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Rockets (47)",
            "classname": "item_rockets",
            "uuid": 6386844665151534710,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Gold Key (48)",
            "classname": "item_key2",
            "uuid": 3865977886002757854,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 18026233658455166095,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Yellow Armor (50)",
            "classname": "item_armor2",
            "uuid": 11577683156465032417,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Secret (51)",
            "classname": "trigger_secret",
            "uuid": 6068009109927878794,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Supernailgun (52)",
            "classname": "weapon_supernailgun",
            "uuid": 2782791350472851826,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Secret (53)",
            "classname": "trigger_secret",
            "uuid": 2696613667940035500,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Green Armor (54)",
            "classname": "item_armor1",
            "uuid": 11353555420489826720,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 7169283900263513059,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 4639372737055134509,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 1505351942750528168,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Rockets (58)",
            "classname": "item_rockets",
            "uuid": 6949116486205958651,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 10954520970029783539,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 6352396211374973126,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Spikes (61)",
            "classname": "item_spikes",
            "uuid": 16364717560670872442,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 13788204293078668157,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 13130595751326450018,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 6669146617295757603,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 12958845999538542218,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 2557337402398120325,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Shells (67)",
            "classname": "item_shells",
            "uuid": 1931754257866423545,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 10344275570920639287,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Large Medkit (69)",
            "classname": "item_health",
            "uuid": 10114472421398795415,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Rockets (70)",
            "classname": "item_rockets",
            "uuid": 13413260775786857458,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 1731381342404052172,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 13899362577938163756,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Shells (73)",
            "classname": "item_shells",
            "uuid": 8442223899654141866,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 17467048451868929482,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Shells (75)",
            "classname": "item_shells",
            "uuid": 12918055741115468321,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Spikes (76)",
            "classname": "item_spikes",
            "uuid": 9313799388376281079,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Secret (77)",
            "classname": "trigger_secret",
            "uuid": 10204133870986969462,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Rockets (78)",
            "classname": "item_rockets",
            "uuid": 9357219105777902558,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Rockets (79)",
            "classname": "item_rockets",
            "uuid": 15737062732560610058,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Shells (80)",
            "classname": "item_shells",
            "uuid": 11217744308605025809,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Shells (81)",
            "classname": "item_shells",
            "uuid": 2453755994873366133,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Shells (82)",
            "classname": "item_shells",
            "uuid": 8673985612239189054,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Spikes (83)",
            "classname": "item_spikes",
            "uuid": 16923155495668814804,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Shells (84)",
            "classname": "item_shells",
            "uuid": 11684788981052872071,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Supershotgun (85)",
            "classname": "weapon_supershotgun",
            "uuid": 1169810026730581698,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Supershotgun (86)",
            "classname": "weapon_supershotgun",
            "uuid": 13833660945560506371,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Shells (87)",
            "classname": "item_shells",
            "uuid": 8772939887104937605,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Shells (88)",
            "classname": "item_shells",
            "uuid": 17112921888685338853,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Rockets (89)",
            "classname": "item_rockets",
            "uuid": 13361119878250813605,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Spikes (90)",
            "classname": "item_spikes",
            "uuid": 4862848722132201355,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Spikes (91)",
            "classname": "item_spikes",
            "uuid": 4175454738091007585,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Spikes (92)",
            "classname": "item_spikes",
            "uuid": 6605961076503100214,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Shells (93)",
            "classname": "item_shells",
            "uuid": 472616589677955120,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Shells (94)",
            "classname": "item_shells",
            "uuid": 12535490139979385442,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "All Kills (95)",
            "classname": "all_kills",
            "uuid": 13151484205186619845,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (82)",
                "Secret (9)",
                "Nailgun (6)",
                "Green Armor (7)",
                "Spikes (11)",
            ],
        )

        self.restrict("Secret (9)", r.can_shootswitch)
        self.restrict("Nailgun (6)", r.can_shootswitch)

        jump_area = self.region(
            "Jump Area",
            [
                "Shells (2)",
                "Shells (1)",
                "Nailgun (8)",
                "Spikes (5)",
                "Spikes (4)",
                "Shells (3)",
                "Large Medkit (12)",
                "Spikes (10)",
                "Spikes (14)",
                "Shells (13)",
                "Spikes (15)",
                "Spikes (16)",
                "Small Medkit (18)",
                "Supershotgun (85)",
                "Spikes (83)",
                "Shells (17)",
                "Shells (21)",
                "Spikes (20)",
                "Small Medkit (19)",
                "Large Medkit (22)",
            ],
        )
        self.connect(ret, jump_area, r.can_jump | r.can_gj_extr | r.can_rj_hard)

        past_button_area = self.region(
            "Past Button Area",
            [
                "Yellow Armor (23)",
                "Shells (84)",
                "Spikes (25)",
                "Spikes (26)",
                "Large Medkit (24)",
            ],
        )
        self.connect(jump_area, past_button_area, r.can_button)

        shootswitch_area = self.region(
            "Shootswitch Area",
            [
                "Spikes (29)",
                "Supershotgun (86)",
                "Spikes (33)",
                "Spikes (32)",
                "Shells (31)",
                "Spikes (30)",
                "Large Medkit (60)",
                "Shells (27)",
                "Spikes (28)",
            ],
        )
        self.connect(past_button_area, shootswitch_area, r.can_shootswitch)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Rockets (47)",
                "Rockets (45)",
                "Spikes (46)",
                "Spikes (90)",
                "Spikes (61)",
                "Shells (94)",
                "Large Medkit (49)",
                "Rockets (43)",
                "Large Medkit (64)",
                "Spikes (63)",
                "Spikes (62)",
                "Gold Key (48)",
                "Grenadelauncher (44)",
                "Yellow Armor (50)",
                "Secret (51)",
            ],
        )
        self.connect(shootswitch_area, past_door_area, r.can_door)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Spikes (65)",
                "Large Medkit (66)",
                "Shells (67)",
                "Rockets (70)",
                "Shells (93)",
                "Large Medkit (68)",
                "Green Armor (54)",
                "Large Medkit (69)",
                "Spikes (92)",
                "Large Medkit (71)",
                "Spikes (91)",
                "Secret (53)",
                "Supernailgun (52)",
                "Shells (87)",
                "Rockets (58)",
                "Large Medkit (56)",
                "Large Medkit (59)",
                "Large Medkit (57)",
                "Spikes (55)",
            ],
        )
        self.connect(shootswitch_area, past_gold_door_area, self.gold_key)

        past_fight_area = self.region(
            "Past Cell Fight",
            [
                "Spikes (34)",
                "Large Medkit (74)",
                "Shells (73)",
                "Spikes (35)",
                "Spikes (37)",
                "Large Medkit (39)",
                "Shells (81)",
                "Rockets (78)",
                "Spikes (76)",
                "Shells (80)",
                "Large Medkit (38)",
                "Spikes (72)",
                "Rockets (36)",
                "Shells (75)",
                "Rockets (79)",
                "Shells (88)",
                "Secret (77)",
                "Yellow Armor (41)",
                "Large Medkit (40)",
                "Rockets (89)",
                "Exit",
                "All Kills (95)",
            ],
        )
        # TODO: Is a backpack actually required with shotgun-only?
        self.connect(past_gold_door_area, past_fight_area, r.backpack(1))
        self.restrict("All Kills (95)", r.difficult_combat)

        return ret
