from BaseClasses import Region

from ..base_classes import Q1Level


class mge4m2(Q1Level):
    name = "A Grave Mistake"
    mapfile = "mge4m2"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Large Medkit (1)",
            "classname": "item_health",
            "uuid": 6155296318681454638,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Spikes (2)",
            "classname": "item_spikes",
            "uuid": 3518629945164360520,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Green Armor (3)",
            "classname": "item_armor1",
            "uuid": 140247622377128119,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Cells (4)",
            "classname": "item_cells",
            "uuid": 17654807242569566277,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 9068678293030557917,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Quad Damage (6)",
            "classname": "item_artifact_super_damage",
            "uuid": 1017355361919849670,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Secret (7)",
            "classname": "trigger_secret",
            "uuid": 7644851933644337961,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 6037393664589878838,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 17902143603751358980,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Spikes (10)",
            "classname": "item_spikes",
            "uuid": 13578441315926036757,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Spikes (11)",
            "classname": "item_spikes",
            "uuid": 7587134433086665405,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 18338210021254655708,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Rockets (13)",
            "classname": "item_rockets",
            "uuid": 8913857955415969086,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Spikes (14)",
            "classname": "item_spikes",
            "uuid": 16354647258909171107,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Spikes (15)",
            "classname": "item_spikes",
            "uuid": 14997898603963485759,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Supernailgun (16)",
            "classname": "weapon_supernailgun",
            "uuid": 9388958209263621321,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 264891342842290847,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 313868802675520077,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 4552166388368372614,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Shells (20)",
            "classname": "item_shells",
            "uuid": 16254562252597094985,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Rocketlauncher (21)",
            "classname": "weapon_rocketlauncher",
            "uuid": 8959547739428192843,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Rockets (22)",
            "classname": "item_rockets",
            "uuid": 6849544909917160352,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rockets (23)",
            "classname": "item_rockets",
            "uuid": 5231937243948497445,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 5668000095641176259,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Shells (25)",
            "classname": "item_shells",
            "uuid": 3587194120247549115,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 3224166364809170914,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 3813987594608607235,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 13879573934273442075,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 2243343898483516391,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Shells (30)",
            "classname": "item_shells",
            "uuid": 9681178324294191992,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 17277743868103385270,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 15734607047411801379,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Sigil (33)",
            "classname": "item_sigil",
            "uuid": 12513052294319243063,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 17690926287632984700,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Lightning (35)",
            "classname": "weapon_lightning",
            "uuid": 3703858061247359504,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 11098250476062364824,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 6301410730556111326,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 17760359882925368167,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 13776834628936290402,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Yellow Armor (40)",
            "classname": "item_armor2",
            "uuid": 11888363997321674237,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Rockets (41)",
            "classname": "item_rockets",
            "uuid": 831112408924654081,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Supernailgun (42)",
            "classname": "weapon_supernailgun",
            "uuid": 9256402902980543249,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Rocketlauncher (43)",
            "classname": "weapon_rocketlauncher",
            "uuid": 13081150791740052808,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Supershotgun (44)",
            "classname": "weapon_supershotgun",
            "uuid": 4076303497519787586,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 18413847204953132456,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Megahealth (46)",
            "classname": "item_health",
            "uuid": 5677839903356667242,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Secret (47)",
            "classname": "trigger_secret",
            "uuid": 2688294043324892857,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 239255111794065394,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 16085036963885681029,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 13921749720858779010,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 7692863492967648848,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Rockets (52)",
            "classname": "item_rockets",
            "uuid": 16526438895317448120,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 10181465910961183942,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 17516261649850409442,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Yellow Armor (55)",
            "classname": "item_armor2",
            "uuid": 15533817336319090948,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 1479057185516557257,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Shells (57)",
            "classname": "item_shells",
            "uuid": 11154960483896027401,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Spikes (58)",
            "classname": "item_spikes",
            "uuid": 15618084199106913941,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Spikes (59)",
            "classname": "item_spikes",
            "uuid": 13568806574039109884,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Green Armor (60)",
            "classname": "item_armor1",
            "uuid": 16931742963879775615,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Rockets (61)",
            "classname": "item_rockets",
            "uuid": 6460894536153279991,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Shells (62)",
            "classname": "item_shells",
            "uuid": 9553977288046041219,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 3421102334533818263,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 13578334294378538164,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 10406787442180129314,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 10074898767530139943,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Lightning (67)",
            "classname": "weapon_lightning",
            "uuid": 4797925211403453115,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Cells (68)",
            "classname": "item_cells",
            "uuid": 8787666922377386920,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Cells (69)",
            "classname": "item_cells",
            "uuid": 3508208679766899664,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 10248164191584955917,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Shells (71)",
            "classname": "item_shells",
            "uuid": 5713649448420192836,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 8468006058374284772,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 9621131962720152765,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Nailgun (74)",
            "classname": "weapon_nailgun",
            "uuid": 5872666339099927602,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Grenadelauncher (75)",
            "classname": "weapon_grenadelauncher",
            "uuid": 6065839849985553420,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 10527231411137964327,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Shells (77)",
            "classname": "item_shells",
            "uuid": 12374759105403183121,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Supernailgun (78)",
            "classname": "weapon_supernailgun",
            "uuid": 8634392649600138760,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Rocketlauncher (79)",
            "classname": "weapon_rocketlauncher",
            "uuid": 2141868740953215608,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Large Medkit (80)",
            "classname": "item_health",
            "uuid": 2004059388777120070,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Supershotgun (81)",
            "classname": "weapon_supershotgun",
            "uuid": 14614650655965648,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Spikes (82)",
            "classname": "item_spikes",
            "uuid": 14890530541466574405,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Spikes (83)",
            "classname": "item_spikes",
            "uuid": 17738149810545902052,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Shells (84)",
            "classname": "item_shells",
            "uuid": 6328011867094486026,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Shells (85)",
            "classname": "item_shells",
            "uuid": 15445396609078597794,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Rockets (86)",
            "classname": "item_rockets",
            "uuid": 12094901434561257371,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Red Armor (87)",
            "classname": "item_armorInv",
            "uuid": 7877399669854053400,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Secret (88)",
            "classname": "trigger_secret",
            "uuid": 16673899545667480190,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Large Medkit (89)",
            "classname": "item_health",
            "uuid": 15457840506740533002,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Large Medkit (90)",
            "classname": "item_health",
            "uuid": 10455853591732215181,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Large Medkit (91)",
            "classname": "item_health",
            "uuid": 17149070010876117052,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "All Kills (92)",
            "classname": "all_kills",
            "uuid": 15242871431450777003,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Rockets (52)",
                "Nailgun (74)",
                "Shells (51)",
                "Grenadelauncher (75)",
                "Large Medkit (54)",
                "Large Medkit (80)",
                "Supershotgun (81)",
                "Spikes (53)",
                "Large Medkit (73)",
                "Spikes (58)",
                "Spikes (59)",
                "Yellow Armor (55)",
                "Shells (57)",
                "Shells (56)",
            ],
        )

        jump_area = self.region(
            "Jump Area",
            [
                "Rockets (86)",
                "Shells (84)",
                "Spikes (82)",
                "Shells (85)",
                "Large Medkit (89)",
                "Spikes (83)",
            ],
        )
        self.connect(ret, jump_area, r.jump)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Spikes (63)",
                "Green Armor (60)",
                "Shells (62)",
                "Rockets (61)",
                "Large Medkit (65)",
                "Large Medkit (64)",
                "Large Medkit (72)",
                "Shells (76)",
                "Shells (77)",
                "Spikes (70)",
                "Shells (71)",
                "Large Medkit (66)",
                "Spikes (48)",
                "Supernailgun (78)",
                "Spikes (49)",
                "Spikes (50)",
                "Secret (47)",
                "Cells (68)",
                "Cells (69)",
                "Lightning (67)",
                "Red Armor (87)",
                "Secret (88)",
                "Large Medkit (90)",
                "Large Medkit (91)",
                "Rocketlauncher (79)",
                "Large Medkit (1)",
                "Spikes (2)",
                "Green Armor (3)",
                "Cells (4)",
                "Large Medkit (8)",
                "Large Medkit (5)",
                "Shells (31)",
                "Shells (30)",
                "Shells (20)",
                "Shells (24)",
                "Rockets (13)",
                "Rockets (12)",
                "Shells (9)",
                "Large Medkit (19)",
                "Supernailgun (16)",
                "Spikes (18)",
                "Spikes (17)",
                "Secret (7)",
                "Spikes (10)",
                "Spikes (11)",
                "Quad Damage (6)",
                "Spikes (15)",
                "Large Medkit (29)",
                "Shells (28)",
                "Large Medkit (27)",
                "Rockets (22)",
                "Rocketlauncher (21)",
                "Rockets (23)",
                "Megahealth (46)",
                "Supernailgun (42)",
                "Shells (26)",
                "Shells (25)",
                "Large Medkit (39)",
                "Large Medkit (34)",
                "Spikes (14)",
                "Spikes (45)",
                "Supershotgun (44)",
                "Yellow Armor (40)",
                "Rocketlauncher (43)",
                "Rockets (41)",
                "Lightning (35)",
                "Large Medkit (36)",
                "Spikes (38)",
                "Spikes (37)",
                "Sigil (33)",
                "Exit",
                "All Kills (92)",
            ],
        )
        self.connect(jump_area, past_door_area, r.can_door)

        self.restrict("Secret (47)", r.can_shootswitch)
        self.restrict("Cells (68)", r.can_shootswitch)
        self.restrict("Cells (69)", r.can_shootswitch)
        self.restrict("Lightning (67)", r.can_shootswitch)
        self.restrict("Red Armor (87)", r.can_shootswitch)
        self.restrict("Secret (88)", r.can_shootswitch)

        self.restrict(
            "Secret (7)", r.can_shootswitch | (r.can_jump & r.can_rj & r.invuln(1))
        )
        self.restrict(
            "Spikes (10)", r.can_shootswitch | (r.can_jump & r.can_rj & r.invuln(1))
        )
        self.restrict(
            "Spikes (11)", r.can_shootswitch | (r.can_jump & r.can_rj & r.invuln(1))
        )
        self.restrict(
            "Quad Damage (6)", r.can_shootswitch | (r.can_jump & r.can_rj & r.invuln(1))
        )

        self.restrict("Sigil (33)", r.difficult_combat)
        self.restrict("Exit", r.difficult_combat)
        self.restrict("All Kills (92)", r.difficult_combat)

        return ret
