from BaseClasses import Region

from ..base_classes import Q1Level


class mge3m1(Q1Level):
    name = "Down the Waste"
    mapfile = "mge3m1"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Secret (1)",
            "classname": "trigger_secret",
            "uuid": 6161400126937730532,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Secret (2)",
            "classname": "trigger_secret",
            "uuid": 11393765248167315442,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Secret (3)",
            "classname": "trigger_secret",
            "uuid": 18151144716136269528,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Secret (4)",
            "classname": "trigger_secret",
            "uuid": 6907734144736792532,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Secret (5)",
            "classname": "trigger_secret",
            "uuid": 4969541498406515917,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Secret (6)",
            "classname": "trigger_secret",
            "uuid": 15966986115770503416,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Secret (7)",
            "classname": "trigger_secret",
            "uuid": 8100788632611233866,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Secret (8)",
            "classname": "trigger_secret",
            "uuid": 3144290536611817854,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Secret (9)",
            "classname": "trigger_secret",
            "uuid": 8478514964162443093,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 7473143331052574770,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Secret (11)",
            "classname": "trigger_secret",
            "uuid": 2840721142374328054,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Secret (12)",
            "classname": "trigger_secret",
            "uuid": 6843694941967113132,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 8508140831918739054,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Shells (14)",
            "classname": "item_shells",
            "uuid": 15797936776484577762,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 4189708343374800571,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 10372192384299916745,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Silver Key (17)",
            "classname": "item_key1",
            "uuid": 13829137127454656370,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 12245534742593194942,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 4320797262088955044,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Biosuit (20)",
            "classname": "item_artifact_envirosuit",
            "uuid": 12795262024796406377,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Spikes (21)",
            "classname": "item_spikes",
            "uuid": 11784082626067660464,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Supershotgun (22)",
            "classname": "weapon_supershotgun",
            "uuid": 5436066330607623061,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 3939483584918098947,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Gold Key (24)",
            "classname": "item_key2",
            "uuid": 13768741055101213621,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Quad Damage (25)",
            "classname": "item_artifact_super_damage",
            "uuid": 13192544702146764241,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 7422048476252299261,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 11235726839536763928,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Small Medkit (28)",
            "classname": "item_health",
            "uuid": 16678004787182896052,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Nailgun (29)",
            "classname": "weapon_nailgun",
            "uuid": 16588492428448869128,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Small Medkit (30)",
            "classname": "item_health",
            "uuid": 13162899101227826722,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Supershotgun (31)",
            "classname": "weapon_supershotgun",
            "uuid": 18053608508290353632,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Grenadelauncher (32)",
            "classname": "weapon_grenadelauncher",
            "uuid": 15762677711351993802,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Grenadelauncher (33)",
            "classname": "weapon_grenadelauncher",
            "uuid": 14713900250414119859,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 17254868141293742158,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Shells (35)",
            "classname": "item_shells",
            "uuid": 10157755358278192324,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Green Armor (36)",
            "classname": "item_armor1",
            "uuid": 3386860950598000855,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 13903055573198804838,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 10694591653904587468,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Small Medkit (39)",
            "classname": "item_health",
            "uuid": 16203991086741240342,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 8742947048735525768,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 1168579148678636962,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Large Medkit (42)",
            "classname": "item_health",
            "uuid": 12161243957278553691,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Biosuit (43)",
            "classname": "item_artifact_envirosuit",
            "uuid": 2772817387631785927,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 8683791017001714200,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 9409577294008534603,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Rockets (46)",
            "classname": "item_rockets",
            "uuid": 12015841853447765410,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 11143694653432736489,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 4137442390736609576,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Biosuit (49)",
            "classname": "item_artifact_envirosuit",
            "uuid": 12648304798820951830,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Shells (50)",
            "classname": "item_shells",
            "uuid": 6886708316279692862,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 15601282646258800148,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 17790604285548330361,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 3707164265335931292,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 9480746482030914039,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 2065849733394426497,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Spikes (56)",
            "classname": "item_spikes",
            "uuid": 9395757108322373839,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 12844144738795854474,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Shells (58)",
            "classname": "item_shells",
            "uuid": 14011784508890625622,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Shells (59)",
            "classname": "item_shells",
            "uuid": 5625840692892719709,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Spikes (60)",
            "classname": "item_spikes",
            "uuid": 8808357050354502351,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Spikes (61)",
            "classname": "item_spikes",
            "uuid": 226738228562160688,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Lightning (62)",
            "classname": "weapon_lightning",
            "uuid": 13520008935814096225,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 10105884135585321516,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Yellow Armor (64)",
            "classname": "item_armor2",
            "uuid": 15268610661500475351,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 1464034007272491377,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Spikes (66)",
            "classname": "item_spikes",
            "uuid": 1853401574102032636,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 14511509544768038905,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 968881590150830140,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 5870594442029358139,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Shells (70)",
            "classname": "item_shells",
            "uuid": 9651953852650151693,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Invisibility (71)",
            "classname": "item_artifact_invisibility",
            "uuid": 15851755639178141785,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Green Armor (72)",
            "classname": "item_armor1",
            "uuid": 5421262464117728839,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Spikes (73)",
            "classname": "item_spikes",
            "uuid": 7171494553437937776,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Small Medkit (74)",
            "classname": "item_health",
            "uuid": 15056711486418192091,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Small Medkit (75)",
            "classname": "item_health",
            "uuid": 8762262713771285972,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Spikes (76)",
            "classname": "item_spikes",
            "uuid": 4925647147750606768,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Spikes (77)",
            "classname": "item_spikes",
            "uuid": 18161534869969667637,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Spikes (78)",
            "classname": "item_spikes",
            "uuid": 558231659456889613,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Large Medkit (79)",
            "classname": "item_health",
            "uuid": 1486646952795094462,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Large Medkit (80)",
            "classname": "item_health",
            "uuid": 1738708336506218229,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Spikes (81)",
            "classname": "item_spikes",
            "uuid": 7521437198900465578,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Large Medkit (82)",
            "classname": "item_health",
            "uuid": 12450774621178326818,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Shells (83)",
            "classname": "item_shells",
            "uuid": 5683391681204162600,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Shells (84)",
            "classname": "item_shells",
            "uuid": 4923228663003045818,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 10049098610192659470,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Large Medkit (86)",
            "classname": "item_health",
            "uuid": 8802251168918535269,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 14265298627274200364,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Large Medkit (88)",
            "classname": "item_health",
            "uuid": 14906423784647801115,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Small Medkit (89)",
            "classname": "item_health",
            "uuid": 16272759845985965243,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Spikes (90)",
            "classname": "item_spikes",
            "uuid": 17801444106493648309,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Megahealth (91)",
            "classname": "item_health",
            "uuid": 10890648736304955153,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Small Medkit (92)",
            "classname": "item_health",
            "uuid": 14432351219730630660,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Small Medkit (93)",
            "classname": "item_health",
            "uuid": 4872544495062324829,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Shells (94)",
            "classname": "item_shells",
            "uuid": 11055282989671589538,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Spikes (95)",
            "classname": "item_spikes",
            "uuid": 7038472814223739030,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Rockets (96)",
            "classname": "item_rockets",
            "uuid": 12876026659819471741,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Large Medkit (97)",
            "classname": "item_health",
            "uuid": 636252763367947050,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 12959914383391170837,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Green Armor (99)",
            "classname": "item_armor1",
            "uuid": 13544944256641987477,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Small Medkit (100)",
            "classname": "item_health",
            "uuid": 13257245430862842685,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Yellow Armor (101)",
            "classname": "item_armor2",
            "uuid": 3795240559241640974,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Megahealth (102)",
            "classname": "item_health",
            "uuid": 12155512934388408543,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Rockets (103)",
            "classname": "item_rockets",
            "uuid": 1701162782708769206,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Large Medkit (104)",
            "classname": "item_health",
            "uuid": 12722008392971587896,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Spikes (105)",
            "classname": "item_spikes",
            "uuid": 2069433355441788708,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Spikes (106)",
            "classname": "item_spikes",
            "uuid": 4855003329111103681,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Rockets (107)",
            "classname": "item_rockets",
            "uuid": 6894914114075310677,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Spikes (108)",
            "classname": "item_spikes",
            "uuid": 10813478684415370090,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Quad Damage (109)",
            "classname": "item_artifact_super_damage",
            "uuid": 2886635685653224812,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Small Medkit (110)",
            "classname": "item_health",
            "uuid": 10314481689380534016,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Supernailgun (111)",
            "classname": "weapon_supernailgun",
            "uuid": 5007930359552462999,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Red Armor (112)",
            "classname": "item_armorInv",
            "uuid": 16059742101843651163,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Yellow Armor (113)",
            "classname": "item_armor2",
            "uuid": 13296278938196893550,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Shells (114)",
            "classname": "item_shells",
            "uuid": 6282572272812267980,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Small Medkit (115)",
            "classname": "item_health",
            "uuid": 8445378373130030510,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Large Medkit (116)",
            "classname": "item_health",
            "uuid": 4258860936202064980,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Shells (117)",
            "classname": "item_shells",
            "uuid": 16347224751099249190,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Spikes (118)",
            "classname": "item_spikes",
            "uuid": 17595195825738695413,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Shells (119)",
            "classname": "item_shells",
            "uuid": 12468405528129116181,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Spikes (120)",
            "classname": "item_spikes",
            "uuid": 17131265282019684151,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Shells (121)",
            "classname": "item_shells",
            "uuid": 7973694484669588443,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Shells (122)",
            "classname": "item_shells",
            "uuid": 16054917980819633522,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Rockets (123)",
            "classname": "item_rockets",
            "uuid": 9511604247003123608,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Shells (124)",
            "classname": "item_shells",
            "uuid": 258072981794999478,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Small Medkit (125)",
            "classname": "item_health",
            "uuid": 2196681127131136354,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Shells (126)",
            "classname": "item_shells",
            "uuid": 13430266436169548159,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Small Medkit (127)",
            "classname": "item_health",
            "uuid": 5996350681806253685,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "Shells (128)",
            "classname": "item_shells",
            "uuid": 17633366958139155208,
            "mp": 0,
        },
        {
            "id": 129,
            "name": "Shells (129)",
            "classname": "item_shells",
            "uuid": 1908061604275680891,
            "mp": 0,
        },
        {
            "id": 130,
            "name": "Spikes (130)",
            "classname": "item_spikes",
            "uuid": 227487552923768765,
            "mp": 0,
        },
        {
            "id": 131,
            "name": "Shells (131)",
            "classname": "item_shells",
            "uuid": 10936271419128571343,
            "mp": 0,
        },
        {
            "id": 132,
            "name": "Spikes (132)",
            "classname": "item_spikes",
            "uuid": 16660590419227019186,
            "mp": 0,
        },
        {
            "id": 133,
            "name": "Shells (133)",
            "classname": "item_shells",
            "uuid": 10821154575753001263,
            "mp": 0,
        },
        {
            "id": 134,
            "name": "Green Armor (134)",
            "classname": "item_armor1",
            "uuid": 3267034610575419027,
            "mp": 0,
        },
        {
            "id": 135,
            "name": "Small Medkit (135)",
            "classname": "item_health",
            "uuid": 3429350698854991711,
            "mp": 0,
        },
        {
            "id": 136,
            "name": "Large Medkit (136)",
            "classname": "item_health",
            "uuid": 1804125203394247361,
            "mp": 0,
        },
        {
            "id": 137,
            "name": "Megahealth (137)",
            "classname": "item_health",
            "uuid": 6037247116627986336,
            "mp": 0,
        },
        {
            "id": 138,
            "name": "Green Armor (138)",
            "classname": "item_armor1",
            "uuid": 15982870725846346523,
            "mp": 0,
        },
        {
            "id": 139,
            "name": "Small Medkit (139)",
            "classname": "item_health",
            "uuid": 10948957232734721106,
            "mp": 0,
        },
        {
            "id": 140,
            "name": "Green Armor (140)",
            "classname": "item_armor1",
            "uuid": 14084033111723253593,
            "mp": 0,
        },
        {
            "id": 141,
            "name": "Large Medkit (141)",
            "classname": "item_health",
            "uuid": 17867309040323188526,
            "mp": 0,
        },
        {
            "id": 142,
            "name": "Supernailgun (142)",
            "classname": "weapon_supernailgun",
            "uuid": 4152935306988222461,
            "mp": 0,
        },
        {
            "id": 143,
            "name": "Large Medkit (143)",
            "classname": "item_health",
            "uuid": 17288811970444452415,
            "mp": 0,
        },
        {
            "id": 144,
            "name": "Nailgun (144)",
            "classname": "weapon_nailgun",
            "uuid": 11453775524098700928,
            "mp": 0,
        },
        {
            "id": 145,
            "name": "All Kills (145)",
            "classname": "all_kills",
            "uuid": 14235153698515031332,
            "mp": 0,
        },
    ]

    must_invuln = True
    must_bio = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Shells (114)",
                "Small Medkit (115)",
                "Shells (35)",
                "Small Medkit (30)",
                "Green Armor (36)",
                "Shells (38)",
                "Spikes (37)",
                "Small Medkit (28)",
                "Small Medkit (27)",
                "Spikes (60)",
                "Spikes (61)",
                "Nailgun (29)",
                "Small Medkit (92)",
                "Large Medkit (63)",
                "Spikes (118)",
                "Shells (119)",
                "Shells (26)",
                "Large Medkit (23)",
                "Nailgun (144)",
                "Spikes (21)",
                "Quad Damage (25)",
                "Secret (2)",
                "Secret (1)",
                "Supershotgun (31)",
                "Shells (34)",
            ],
        )

        self.restrict("Shells (35)", r.jump)
        self.restrict("Large Medkit (63)", r.jump)
        self.restrict("Spikes (118)", r.jump)
        self.restrict("Quad Damage (25)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        self.restrict("Secret (2)", r.jump)
        self.restrict(
            "Secret (1)", r.can_shootswitch & (r.difficulty("medium") | r.jump)
        )
        self.restrict(
            "Supershotgun (31)", r.can_shootswitch & (r.difficulty("medium") | r.jump)
        )
        self.restrict(
            "Shells (34)", r.can_shootswitch & (r.difficulty("medium") | r.jump)
        )

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (97)",
                "Secret (11)",
                "Lightning (62)",
                "Exit",
                "All Kills (145)",
            ],
        )
        self.connect(ret, past_gold_door_area, self.gold_key)
        self.restrict(
            "All Kills (145)",
            (r.can_gj_extr | r.can_rj_hard | r.can_jump | r.bigjump_hard)
            & self.silver_key
            & r.can_button
            & (r.can_dive & (r.biosuit(1) | r.invuln(1)))
            & ((r.can_shootswitch & r.jump) | r.bigjump_hard)
            & r.difficult_combat,
        )

        self.restrict("Exit", r.can_button)
        self.restrict(
            "Large Medkit (97)",
            r.can_jump | r.can_gj_extr | r.can_rj_hard | r.bigjump_hard,
        )
        self.restrict(
            "Secret (11)",
            r.can_jump | r.can_gj_extr | r.can_rj_hard | r.bigjump_hard,
        )
        self.restrict(
            "Lightning (62)",
            r.can_jump | r.can_gj_extr | r.can_rj_hard | r.bigjump_hard,
        )

        past_water_gap_area = self.region(
            "Past Water Gap",
            [
                "Small Medkit (39)",
                "Spikes (40)",
                "Spikes (41)",
                "Shells (65)",
                "Small Medkit (100)",
                "Small Medkit (75)",
                "Spikes (44)",
                "Megahealth (137)",
                "Supershotgun (22)",
                "Small Medkit (135)",
                "Spikes (76)",
                "Large Medkit (45)",
                "Shells (70)",
                "Shells (69)",
                "Green Armor (134)",
                "Biosuit (20)",
                "Secret (3)",
                "Yellow Armor (64)",
            ],
        )
        self.connect(
            ret,
            past_water_gap_area,
            (r.can_gj_extr & r.invuln(1) & r.quad_dmg(1))
            | (r.can_rj_hard & r.heal(200) | r.invuln(1))
            | r.can_jump
            | r.bigjump_hard,
        )
        self.restrict("Spikes (44)", r.jump)
        self.restrict("Megahealth (137)", r.jump)
        self.restrict("Biosuit (20)", r.can_door)
        self.restrict("Secret (3)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Yellow Armor (64)", r.can_shootswitch | r.bigjump_hard)

        sewage_area = self.region(
            "Sewage Area",
            [
                "Spikes (108)",
                "Large Medkit (136)",
                "Secret (4)",
                "Biosuit (43)",
                "Rockets (96)",
                "Grenadelauncher (32)",
                "Large Medkit (42)",
                "Spikes (18)",
                "Large Medkit (19)",
                "Large Medkit (16)",
                "Shells (15)",
                "Shells (14)",
                "Green Armor (140)",
                "Spikes (67)",
                "Spikes (66)",
                "Large Medkit (54)",
                "Spikes (53)",
                "Spikes (13)",
                "Small Medkit (93)",
                "Small Medkit (74)",
                "Spikes (73)",
                "Rockets (123)",
                "Large Medkit (141)",
                "Large Medkit (88)",
                "Shells (124)",
            ],
        )
        self.connect(
            past_water_gap_area, sewage_area, r.can_dive & (r.biosuit(1) | r.invuln(1))
        )

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Shells (59)",
                "Shells (58)",
                "Spikes (132)",
                "Spikes (90)",
                "Megahealth (91)",
                "Shells (133)",
                "Spikes (68)",
                "Secret (6)",
                "Spikes (55)",
                "Spikes (56)",
                "Supernailgun (111)",
                "Spikes (130)",
                "Shells (131)",
                "Secret (9)",
                "Red Armor (112)",
                "Invisibility (71)",
                "Secret (12)",
            ],
        )
        self.connect(sewage_area, past_silver_door_area, self.silver_key)

        self.restrict("Shells (131)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Secret (9)", (r.can_shootswitch & r.jump))
        self.restrict("Red Armor (112)", (r.can_shootswitch & r.jump))

        self.restrict("Shells (58)", r.jump)
        self.restrict("Secret (6)", r.jump)
        self.restrict("Spikes (56)", r.jump)
        self.restrict("Spikes (55)", r.jump)
        self.restrict("Supernailgun (111)", r.jump)
        self.restrict("Spikes (130)", r.jump)

        self.restrict("Invisibility (71)", r.can_shootswitch | r.bigjump_hard)
        self.restrict("Secret (12)", r.can_shootswitch | r.bigjump_hard)

        past_button_door_area = self.region(
            "Past Button Door Area",
            [
                "Small Medkit (125)",
                "Large Medkit (86)",
                "Large Medkit (79)",
                "Spikes (78)",
                "Spikes (77)",
                "Yellow Armor (101)",
                "Shells (126)",
                "Small Medkit (89)",
                "Secret (7)",
                "Shells (94)",
                "Megahealth (102)",
                "Spikes (87)",
                "Shells (83)",
                "Shells (84)",
                "Large Medkit (80)",
                "Small Medkit (127)",
                "Spikes (81)",
                "Spikes (85)",
                "Large Medkit (82)",
                "Small Medkit (139)",
                "Shells (128)",
                "Grenadelauncher (33)",
                "Green Armor (138)",
                "Biosuit (49)",
                "Rockets (103)",
                "Large Medkit (98)",
                "Silver Key (17)",
                "Rockets (46)",
            ],
        )
        self.connect(sewage_area, past_button_door_area, r.can_button & r.can_door)
        self.restrict("Secret (7)", r.can_shootswitch)
        self.restrict("Shells (94)", r.can_shootswitch)
        self.restrict("Megahealth (102)", r.can_shootswitch)

        dive_area = self.region(
            "Dive Area",
            [
                "Green Armor (99)",
                "Shells (50)",
                "Shells (51)",
                "Spikes (95)",
                "Large Medkit (48)",
                "Yellow Armor (113)",
                "Small Medkit (110)",
                "Large Medkit (116)",
                "Shells (129)",
                "Secret (5)",
                "Spikes (47)",
                "Large Medkit (52)",
                "Quad Damage (109)",
            ],
        )
        self.connect(
            past_button_door_area, dive_area, r.can_dive & (r.biosuit(1) | r.invuln(1))
        )
        self.restrict("Secret (5)", r.jump)
        self.restrict("Spikes (47)", r.jump)
        self.restrict("Large Medkit (52)", r.jump)
        self.restrict("Quad Damage (109)", r.jump)

        past_lava_area = self.region(
            "Past Lava Area",
            [
                "Shells (121)",
                "Shells (122)",
                "Large Medkit (143)",
                # button
                "Supernailgun (142)",
                "Large Medkit (57)",
                "Spikes (120)",
                "Secret (8)",
                "Green Armor (72)",
                "Gold Key (24)",
                "Spikes (105)",
                "Spikes (106)",
                "Large Medkit (104)",
                "Rockets (107)",
            ],
        )
        self.connect(
            past_silver_door_area,
            past_lava_area,
            (r.can_shootswitch & r.jump) | r.bigjump_hard,
        )
        self.restrict("Supernailgun (142)", r.can_button)
        self.restrict("Large Medkit (57)", r.can_button)
        self.restrict("Spikes (120)", r.can_button)
        self.restrict("Secret (8)", r.can_button)
        self.restrict("Green Armor (72)", r.can_button)
        self.restrict("Gold Key (24)", r.can_button)
        self.restrict("Spikes (105)", self.gold_key)
        self.restrict("Spikes (106)", self.gold_key)
        self.restrict("Large Medkit (104)", self.gold_key)
        self.restrict("Rockets (107)", self.gold_key)

        return ret
