from BaseClasses import Region

from ..base_classes import Q1Level


class mge2m1(Q1Level):
    name = "Acid Sanctuary"
    mapfile = "mge2m1"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Gold Key (1)",
            "classname": "item_key2",
            "uuid": 15483033532682781734,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Silver Key (2)",
            "classname": "item_key1",
            "uuid": 4625718277384675385,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 8899679165163379113,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Shells (4)",
            "classname": "item_shells",
            "uuid": 5919324805681285894,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 2936532526075628591,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Spikes (6)",
            "classname": "item_spikes",
            "uuid": 8660411122041591183,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 8625271749454185915,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Rockets (8)",
            "classname": "item_rockets",
            "uuid": 11582450226463256883,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 8303848759517041507,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Quad Damage (10)",
            "classname": "item_artifact_super_damage",
            "uuid": 16285572274762051602,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Secret (11)",
            "classname": "trigger_secret",
            "uuid": 7603786082053881702,
            "mp": 0,
        },
        # {
        #    "id": 12,
        #    "name": "Exit",
        #    "classname": "trigger_changelevel",
        #    "uuid": 3565842809723352427,
        #    "mp": 0,
        # },
        {
            "id": 13,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 5806737461011113790,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 14216318606851874406,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Rockets (15)",
            "classname": "item_rockets",
            "uuid": 15394283952833647654,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 13257224322505888179,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 4506767756644996087,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 6677302409501345701,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 15811791745381168271,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Shells (20)",
            "classname": "item_shells",
            "uuid": 1782131698323092806,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 16921699819003582728,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Spikes (22)",
            "classname": "item_spikes",
            "uuid": 8694824171952631725,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 8392013583147299487,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Nailgun (24)",
            "classname": "weapon_nailgun",
            "uuid": 6206552125510892476,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 16889156964447029908,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 4962943678484799132,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 14330804747437694095,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 6304807915684713740,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Green Armor (29)",
            "classname": "item_armor1",
            "uuid": 3429556701990955685,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Green Armor (30)",
            "classname": "item_armor1",
            "uuid": 12292171384513376949,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Secret (31)",
            "classname": "trigger_secret",
            "uuid": 10260808924155660220,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Shells (32)",
            "classname": "item_shells",
            "uuid": 14310482839134647490,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 6585885265653305353,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Yellow Armor (34)",
            "classname": "item_armor2",
            "uuid": 15045740460963889463,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Secret (35)",
            "classname": "trigger_secret",
            "uuid": 3212739943409137508,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Shells (36)",
            "classname": "item_shells",
            "uuid": 16410972919309335095,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 8919273465259076979,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 8124750886490599794,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Spikes (39)",
            "classname": "item_spikes",
            "uuid": 14996001501443212894,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 9418865651486591825,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 12542957966062193186,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Spikes (42)",
            "classname": "item_spikes",
            "uuid": 11364662399142810756,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Grenadelauncher (43)",
            "classname": "weapon_grenadelauncher",
            "uuid": 17805561687293469975,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Rockets (44)",
            "classname": "item_rockets",
            "uuid": 8811608071840607254,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Secret (45)",
            "classname": "trigger_secret",
            "uuid": 13701911294654083021,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Small Medkit (46)",
            "classname": "item_health",
            "uuid": 17618914617015606443,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Shells (47)",
            "classname": "item_shells",
            "uuid": 15857869296255175193,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 15027020873863741366,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 16104781315237244678,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Nailgun (50)",
            "classname": "weapon_nailgun",
            "uuid": 11937929922323114150,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 2366007509200674196,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 14037247725950812013,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 2749738839261581997,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Spikes (54)",
            "classname": "item_spikes",
            "uuid": 6158644014416833886,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Supershotgun (55)",
            "classname": "weapon_supershotgun",
            "uuid": 9710713566750057535,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 10571005240108359868,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Megahealth (57)",
            "classname": "item_health",
            "uuid": 10654741511950740666,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Secret (58)",
            "classname": "trigger_secret",
            "uuid": 17384082883075553820,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Supernailgun (59)",
            "classname": "weapon_supernailgun",
            "uuid": 15850777349628372671,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Secret (60)",
            "classname": "trigger_secret",
            "uuid": 11658461062469758568,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 2163886164715566340,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 4532114006146394139,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 11328520334576407900,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 1616634386075316528,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 2989376090361319734,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Rockets (66)",
            "classname": "item_rockets",
            "uuid": 4789138096339777633,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 2110622009474439783,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 1724319743633250948,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 8359924822580590300,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Shells (70)",
            "classname": "item_shells",
            "uuid": 8540258536419073133,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Spikes (71)",
            "classname": "item_spikes",
            "uuid": 9204678601586391584,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 11630986167983789542,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 8987875129586410246,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 4003500774546612427,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Spikes (75)",
            "classname": "item_spikes",
            "uuid": 11581394737423942298,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Green Armor (76)",
            "classname": "item_armor1",
            "uuid": 5565327003207177276,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Large Medkit (77)",
            "classname": "item_health",
            "uuid": 16648294888532296659,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Shells (78)",
            "classname": "item_shells",
            "uuid": 401191196710385053,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Megahealth (79)",
            "classname": "item_health",
            "uuid": 16782586160460762270,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Shells (80)",
            "classname": "item_shells",
            "uuid": 13624241919876696079,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Supernailgun (81)",
            "classname": "weapon_supernailgun",
            "uuid": 13791981198286981597,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Large Medkit (82)",
            "classname": "item_health",
            "uuid": 8337490090496557138,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Large Medkit (83)",
            "classname": "item_health",
            "uuid": 11974733155656526965,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Red Armor (84)",
            "classname": "item_armorInv",
            "uuid": 6628159047503131376,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 5175869192712894309,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Spikes (86)",
            "classname": "item_spikes",
            "uuid": 3408503537985270306,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 2070699821777776987,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Yellow Armor (88)",
            "classname": "item_armor2",
            "uuid": 14514916581358458811,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Spikes (89)",
            "classname": "item_spikes",
            "uuid": 8301010206996768177,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Secret (90)",
            "classname": "trigger_secret",
            "uuid": 5344055716486310045,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Rocketlauncher (91)",
            "classname": "weapon_rocketlauncher",
            "uuid": 7814747226095509022,
            "mp": 0,
        },
        {
            "id": 92,
            "name": "Shells (92)",
            "classname": "item_shells",
            "uuid": 18062137619455455373,
            "mp": 0,
        },
        {
            "id": 93,
            "name": "Spikes (93)",
            "classname": "item_spikes",
            "uuid": 11340010362553221800,
            "mp": 0,
        },
        {
            "id": 94,
            "name": "Spikes (94)",
            "classname": "item_spikes",
            "uuid": 8908763955512408999,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Rockets (95)",
            "classname": "item_rockets",
            "uuid": 11162806448100299153,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Shells (96)",
            "classname": "item_shells",
            "uuid": 13412308155722381866,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Spikes (97)",
            "classname": "item_spikes",
            "uuid": 9282344741331151470,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Rockets (98)",
            "classname": "item_rockets",
            "uuid": 16314096705379949059,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 13353924061238006530,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Secret (100)",
            "classname": "trigger_secret",
            "uuid": 12137037976745426332,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Spikes (101)",
            "classname": "item_spikes",
            "uuid": 7822255463902720519,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Spikes (102)",
            "classname": "item_spikes",
            "uuid": 2230893301845073628,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Shells (103)",
            "classname": "item_shells",
            "uuid": 1677474190868025113,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Grenadelauncher (104)",
            "classname": "weapon_grenadelauncher",
            "uuid": 16207404811395348183,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Rockets (105)",
            "classname": "item_rockets",
            "uuid": 5485114898672396137,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Large Medkit (106)",
            "classname": "item_health",
            "uuid": 7367711004187234036,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Spikes (107)",
            "classname": "item_spikes",
            "uuid": 54483012626225196,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Large Medkit (108)",
            "classname": "item_health",
            "uuid": 6691239714527216205,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Shells (109)",
            "classname": "item_shells",
            "uuid": 12066831200799439298,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "Rockets (110)",
            "classname": "item_rockets",
            "uuid": 14764642284099547739,
            "mp": 0,
        },
        {
            "id": 111,
            "name": "Large Medkit (111)",
            "classname": "item_health",
            "uuid": 1310637020295933638,
            "mp": 0,
        },
        {
            "id": 112,
            "name": "Large Medkit (112)",
            "classname": "item_health",
            "uuid": 12503381406077475180,
            "mp": 0,
        },
        {
            "id": 113,
            "name": "Large Medkit (113)",
            "classname": "item_health",
            "uuid": 13293665082653991212,
            "mp": 0,
        },
        {
            "id": 114,
            "name": "Large Medkit (114)",
            "classname": "item_health",
            "uuid": 18134598620582141870,
            "mp": 0,
        },
        {
            "id": 115,
            "name": "Megahealth (115)",
            "classname": "item_health",
            "uuid": 16495496372408501522,
            "mp": 0,
        },
        {
            "id": 116,
            "name": "Secret (116)",
            "classname": "trigger_secret",
            "uuid": 7352889804170404270,
            "mp": 0,
        },
        {
            "id": 117,
            "name": "Large Medkit (117)",
            "classname": "item_health",
            "uuid": 7093465562958878913,
            "mp": 0,
        },
        {
            "id": 118,
            "name": "Yellow Armor (118)",
            "classname": "item_armor2",
            "uuid": 17944521312957740711,
            "mp": 0,
        },
        {
            "id": 119,
            "name": "Rockets (119)",
            "classname": "item_rockets",
            "uuid": 3262904978467437875,
            "mp": 0,
        },
        {
            "id": 120,
            "name": "Spikes (120)",
            "classname": "item_spikes",
            "uuid": 2963782112476958984,
            "mp": 0,
        },
        {
            "id": 121,
            "name": "Small Medkit (121)",
            "classname": "item_health",
            "uuid": 13828691366295747020,
            "mp": 0,
        },
        {
            "id": 122,
            "name": "Small Medkit (122)",
            "classname": "item_health",
            "uuid": 11857799717518336407,
            "mp": 0,
        },
        {
            "id": 123,
            "name": "Grenadelauncher (123)",
            "classname": "weapon_grenadelauncher",
            "uuid": 5173516707773326,
            "mp": 0,
        },
        {
            "id": 124,
            "name": "Megahealth (124)",
            "classname": "item_health",
            "uuid": 2711007355468882909,
            "mp": 0,
        },
        {
            "id": 125,
            "name": "Shells (125)",
            "classname": "item_shells",
            "uuid": 5297808361360418662,
            "mp": 0,
        },
        {
            "id": 126,
            "name": "Large Medkit (126)",
            "classname": "item_health",
            "uuid": 11371753381055887055,
            "mp": 0,
        },
        {
            "id": 127,
            "name": "Secret (127)",
            "classname": "trigger_secret",
            "uuid": 16082753036977472198,
            "mp": 0,
        },
        {
            "id": 128,
            "name": "All Kills (128)",
            "classname": "all_kills",
            "uuid": 1291306065264945421,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Secret (127)",
                "Shells (125)",
                "Megahealth (124)",
                "Shells (4)",
                "Shells (3)",
                "Spikes (6)",
                "Large Medkit (5)",
            ],
        )

        past_button_door_area = self.region(
            "Past Button Door Area",
            [
                "Nailgun (24)",
                "Shells (23)",
                "Green Armor (29)",
                "Large Medkit (21)",
                "Secret (31)",
                "Spikes (26)",
                "Shells (28)",
                "Spikes (27)",
                "Large Medkit (19)",
                "Shells (20)",
                "Spikes (33)",
                "Large Medkit (38)",
                "Spikes (37)",
                "Shells (36)",
                "Spikes (41)",
                "Shells (40)",
                "Spikes (25)",
                "Spikes (22)",
                "Large Medkit (18)",
                "Shells (32)",
                "Secret (35)",
                "Yellow Armor (34)",
                "Spikes (39)",
                "Secret (11)",
                "Quad Damage (10)",
                "Secret (11)",
                "Quad Damage (10)",
            ],
        )
        self.connect(ret, past_button_door_area, r.can_button & r.can_door)
        self.restrict("Secret (11)", r.jump)
        self.restrict("Quad Damage (10)", r.jump)

        self.restrict("Secret (35)", r.jump)
        self.restrict("Yellow Armor (34)", r.jump)
        self.restrict("Spikes (39)", r.bigjump_hard | r.can_button)

        past_barrier_lower_area = self.region(
            "Past Stone Barrier Lower",
            [
                "Spikes (42)",
                "Small Medkit (46)",
                "Large Medkit (49)",
                "Shells (53)",
                "Shells (51)",
                "Large Medkit (52)",
                "Supershotgun (55)",
                "Spikes (48)",
                "Large Medkit (56)",
                "Shells (47)",
                "Shells (65)",
                "Large Medkit (74)",
                "Secret (58)",
                "Megahealth (57)",
                "Rockets (66)",
            ],
        )
        self.connect(past_button_door_area, past_barrier_lower_area, r.can_button)

        past_barrier_upper_area = self.region(
            "Past Stone Barrier Upper",
            [
                "Rockets (8)",
                "Gold Key (1)",
                "Spikes (9)",
                "Shells (70)",
                "Secret (60)",
                "Supernailgun (59)",
                "Spikes (67)",
                "Spikes (72)",
                "Spikes (63)",
                "Large Medkit (61)",
                "Large Medkit (77)",
                "Spikes (75)",
                "Large Medkit (73)",
                "Shells (69)",
                "Shells (64)",
                "Green Armor (76)",
                "Spikes (71)",
                "Large Medkit (68)",
                "Spikes (62)",
                "Nailgun (50)",
                "Spikes (54)",
                "Secret (45)",
                "Grenadelauncher (43)",
                "Rockets (44)",
            ],
        )
        self.connect(
            past_barrier_lower_area,
            past_barrier_upper_area,
            r.can_button | r.bigjump_hard,
        )
        self.connect(ret, past_barrier_upper_area, r.bigjump_hard)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Green Armor (30)",
                "Large Medkit (114)",
                "Grenadelauncher (104)",
                "Rockets (110)",
                "Large Medkit (106)",
                "Rockets (105)",
                "Shells (109)",
                "Large Medkit (113)",
                "Spikes (107)",
                "Large Medkit (108)",
                "Large Medkit (111)",
                "Spikes (101)",
                "Shells (103)",
                "Spikes (102)",
                "Large Medkit (112)",
                "Secret (116)",
                "Megahealth (115)",
            ],
        )
        self.connect(
            past_button_door_area,
            past_gold_door_area,
            (self.gold_key & r.can_button) | (r.jump & r.difficulty("hard")),
        )
        self.restrict(
            "Grenadelauncher (104)", (self.gold_key & r.can_button) | r.bigjump_hard
        )
        self.restrict("Rockets (105)", r.jump)
        self.restrict("Secret (116)", r.jump)
        self.restrict("Megahealth (115)", r.jump)

        past_gold_barrier_upper_area = self.region(
            "Past Gold Barrier Upper",
            [
                "Grenadelauncher (123)",
                "Large Medkit (117)",
            ],
        )

        past_gold_barrier_lower_area = self.region(
            "Past Gold Barrier Lower",
            [
                "Large Medkit (126)",
                "Yellow Armor (118)",
                "Rockets (119)",
                "Small Medkit (121)",
                "Small Medkit (122)",
                "Spikes (120)",
            ],
        )

        self.connect(past_gold_door_area, past_gold_barrier_upper_area, r.can_button)

        self.connect(past_gold_barrier_upper_area, past_gold_barrier_lower_area)
        self.connect(
            past_gold_barrier_lower_area, past_gold_barrier_upper_area, r.bigjump_hard
        )
        # extreme difficulty because its a very tiny gap in an invisible wall

        slanted_area = self.region(
            "Slanted Area",
            [
                "Shells (78)",
                "Rockets (98)",
                "Shells (96)",
                "Spikes (93)",
                "Spikes (87)",
                "Megahealth (79)",
                "Spikes (94)",
                "Shells (92)",
                "Spikes (97)",
                "Secret (90)",
                "Rocketlauncher (91)",
                "Rockets (95)",
                "Yellow Armor (88)",
                "Supernailgun (81)",
                "Shells (80)",
                "Spikes (86)",
                "Large Medkit (82)",
                "Large Medkit (83)",
                "Spikes (85)",
                "Spikes (99)",
                "Spikes (89)",
                "Secret (100)",
                "Red Armor (84)",
                "Silver Key (2)",
                "Large Medkit (7)",
            ],
        )
        self.connect(
            past_gold_barrier_lower_area,
            slanted_area,
        )
        self.connect(
            past_barrier_upper_area, slanted_area, r.bigjump & r.difficulty("extreme")
        )
        self.connect(slanted_area, past_gold_barrier_lower_area, r.jump)
        self.connect(past_gold_barrier_lower_area, slanted_area)

        self.restrict("Silver Key (2)", r.can_door)
        self.restrict("Large Medkit (7)", r.can_door)

        final_area = self.region(
            "Final Area",
            [
                "Spikes (17)",
                "Large Medkit (14)",
                "Shells (16)",
                "Rockets (15)",
                "Exit",
                "All Kills (128)",
            ],
        )
        self.connect(
            past_button_door_area,
            final_area,
            self.silver_key & self.gold_key & r.can_button,
        )
        self.restrict("All Kills (128)", r.difficult_combat)

        return ret
