from BaseClasses import Region

from ..base_classes import Q1Level


class hipend(Q1Level):
    name = "Armagon's Lair"
    mapfile = "hipend"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Large Medkit (1)",
            "classname": "item_health",
            "uuid": 1188329948158506596,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 14742372351660695419,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 14498019693556145644,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 4720487102367541711,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Cells (5)",
            "classname": "item_cells",
            "uuid": 6949601952384913903,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Cells (6)",
            "classname": "item_cells",
            "uuid": 15627362133234703688,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 7772626237075046892,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 1428509860204771905,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 373668791380589495,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Spikes (10)",
            "classname": "item_spikes",
            "uuid": 3295259063758369412,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Rockets (11)",
            "classname": "item_rockets",
            "uuid": 2415245145876262113,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 16205495255900941996,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 11464269898848169262,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 4627651055982099423,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 16679651662221603553,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 13213021074530743605,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Rocketlauncher (17)",
            "classname": "weapon_rocketlauncher",
            "uuid": 17338523229413234114,
            "mp": 1,
        },
        {
            "id": 18,
            "name": "Rockets (18)",
            "classname": "item_rockets",
            "uuid": 9032954450655647790,
            "mp": 1,
        },
        {
            "id": 19,
            "name": "Grenadelauncher (19)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10553133438054813148,
            "mp": 1,
        },
        {
            "id": 20,
            "name": "Laser (20)",
            "classname": "weapon_laser_gun",
            "uuid": 10158495130949221744,
            "mp": 1,
        },
        {
            "id": 21,
            "name": "Rocketlauncher (21)",
            "classname": "weapon_rocketlauncher",
            "uuid": 14925288384174279857,
            "mp": 1,
        },
        {
            "id": 22,
            "name": "Proximity (22)",
            "classname": "weapon_proximity_gun",
            "uuid": 627149454635698631,
            "mp": 1,
        },
        {
            "id": 23,
            "name": "Nailgun (23)",
            "classname": "weapon_nailgun",
            "uuid": 16767842989125535942,
            "mp": 1,
        },
        {
            "id": 24,
            "name": "Supershotgun (24)",
            "classname": "weapon_supershotgun",
            "uuid": 10611819446861884562,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Lightning (25)",
            "classname": "weapon_lightning",
            "uuid": 11111704584490354863,
            "mp": 1,
        },
        {
            "id": 26,
            "name": "Laser (26)",
            "classname": "weapon_laser_gun",
            "uuid": 17056375868507003885,
            "mp": 1,
        },
        {
            "id": 27,
            "name": "Mjolnir (27)",
            "classname": "weapon_mjolnir",
            "uuid": 10325480991481040455,
            "mp": 1,
        },
        {
            "id": 28,
            "name": "Supershotgun (28)",
            "classname": "weapon_supershotgun",
            "uuid": 11291797088804700655,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Invisibility (29)",
            "classname": "item_artifact_invisibility",
            "uuid": 3899611233658823052,
            "mp": 1,
        },
        {
            "id": 30,
            "name": "Empathy (30)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 17514428890140652833,
            "mp": 1,
        },
        {
            "id": 31,
            "name": "Invulnerability (31)",
            "classname": "item_artifact_invulnerability",
            "uuid": 3920246488993476471,
            "mp": 1,
        },
        {
            "id": 32,
            "name": "Red Armor (32)",
            "classname": "item_armorInv",
            "uuid": 2786777552223729728,
            "mp": 1,
        },
        {
            "id": 33,
            "name": "Quad Damage (33)",
            "classname": "item_artifact_super_damage",
            "uuid": 16237190433581622214,
            "mp": 1,
        },
        {
            "id": 34,
            "name": "Megahealth (34)",
            "classname": "item_health",
            "uuid": 13875338988316934182,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Rocketlauncher (35)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5256787189501937868,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Supernailgun (36)",
            "classname": "weapon_supernailgun",
            "uuid": 3292552206603840248,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Lightning (37)",
            "classname": "weapon_lightning",
            "uuid": 7164752652283671260,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Laser (38)",
            "classname": "weapon_laser_gun",
            "uuid": 12014165422317405266,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Megahealth (39)",
            "classname": "item_health",
            "uuid": 11603591406865244401,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Invulnerability (40)",
            "classname": "item_artifact_invulnerability",
            "uuid": 13397806965560897404,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "All Kills (41)",
            "classname": "all_kills",
            "uuid": 4209832524753352918,
            "mp": 0,
        },
        # manually added for the exit to exist
        {
            "id": 42,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 13397806965560897405,
            "mp": 0,
        },
    ]
    has_boss = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Rocketlauncher (35)",
                "Supernailgun (36)",
                "Megahealth (39)",
                "Supershotgun (28)",
                "Lightning (37)",
                "Invulnerability (40)",
                "Laser (38)",
                "Large Medkit (4)",
                "Large Medkit (3)",
                "Laser (20)",
                "Lightning (25)",
                "Cells (5)",
                "Cells (6)",
                "Empathy (30)",
                "Shells (7)",
                "Shells (8)",
                "Rocketlauncher (21)",
                "Supershotgun (24)",
                "Large Medkit (15)",
                "Large Medkit (16)",
                "Mjolnir (27)",
                "Large Medkit (13)",
                "Large Medkit (14)",
                "Proximity (22)",
                "Nailgun (23)",
                "Rockets (11)",
                "Rockets (12)",
                "Invisibility (29)",
                "Spikes (9)",
                "Spikes (10)",
                "Grenadelauncher (19)",
                "Laser (26)",
                "Large Medkit (2)",
                "Large Medkit (1)",
                "Rockets (18)",
                "Rocketlauncher (17)",
                "Exit",
                "All Kills (41)",
            ],
        )

        self.restrict("Rockets (18)", r.can_door | r.bigjump_hard)
        self.restrict("Rocketlauncher (17)", r.can_door | r.bigjump_hard)
        self.restrict("Exit", r.can_door | r.bigjump_hard)

        self.restrict("All Kills (41)", r.difficult_combat)

        return ret
