from BaseClasses import Region

from ..base_classes import Q1Level


class hipdm1(Q1Level):
    name = ""
    mapfile = "hipdm1"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Small Medkit (1)",
            "classname": "item_health",
            "uuid": 15509233188969598798,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Small Medkit (2)",
            "classname": "item_health",
            "uuid": 11591655530798118921,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Shells (3)",
            "classname": "item_shells",
            "uuid": 17878997606537432031,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Rocketlauncher (4)",
            "classname": "weapon_rocketlauncher",
            "uuid": 6002923504778124759,
            "mp": 1,
        },
        {
            "id": 5,
            "name": "Rockets (5)",
            "classname": "item_rockets",
            "uuid": 14267853589148770732,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Rockets (6)",
            "classname": "item_rockets",
            "uuid": 17884110431556081895,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 5345851339184582029,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Shells (8)",
            "classname": "item_shells",
            "uuid": 8931806757635174347,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 1550324446232273297,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Shells (10)",
            "classname": "item_shells",
            "uuid": 4206758141051852244,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 11840864685682667222,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Quad Damage (12)",
            "classname": "item_artifact_super_damage",
            "uuid": 7706241890012426245,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 10354810114169610009,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Spikes (14)",
            "classname": "item_spikes",
            "uuid": 11272867972026390485,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Rockets (15)",
            "classname": "item_rockets",
            "uuid": 3458297443936441774,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Rockets (16)",
            "classname": "item_rockets",
            "uuid": 194057720318492256,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Rockets (17)",
            "classname": "item_rockets",
            "uuid": 2394143346806907067,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 337328860822898032,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Red Armor (19)",
            "classname": "item_armorInv",
            "uuid": 4521125782314089573,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Supernailgun (20)",
            "classname": "weapon_supernailgun",
            "uuid": 11349928694944759189,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Spikes (21)",
            "classname": "item_spikes",
            "uuid": 8369247500536325994,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Spikes (22)",
            "classname": "item_spikes",
            "uuid": 3297759257077524807,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rocketlauncher (23)",
            "classname": "weapon_rocketlauncher",
            "uuid": 2562393180460241270,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Laser (24)",
            "classname": "weapon_laser_gun",
            "uuid": 874084565411009320,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 11696595041511130809,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Hornofconjuring (26)",
            "classname": "item_hornofconjuring",
            "uuid": 6915201677265029927,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Empathy (27)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 6087497075293377088,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Proximity (28)",
            "classname": "weapon_proximity_gun",
            "uuid": 12142954462418853235,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Rockets (29)",
            "classname": "item_rockets",
            "uuid": 3301159568274745847,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Rockets (30)",
            "classname": "item_rockets",
            "uuid": 9372097145073153847,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Yellow Armor (31)",
            "classname": "item_armor2",
            "uuid": 16070915083737271520,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 7155641616921789683,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Rockets (33)",
            "classname": "item_rockets",
            "uuid": 4097625674666660486,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Supershotgun (34)",
            "classname": "weapon_supershotgun",
            "uuid": 7781266008389633669,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 1546531930830039199,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Gold Key (36)",
            "classname": "item_key2",
            "uuid": 5966426116606636514,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Grenadelauncher (37)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9301584252370647831,
            "mp": 1,
        },
        {
            "id": 38,
            "name": "Megahealth (38)",
            "classname": "item_health",
            "uuid": 16794849441263955495,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Spikes (39)",
            "classname": "item_spikes",
            "uuid": 10228191510143085578,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Rockets (40)",
            "classname": "item_rockets",
            "uuid": 17196168576609237398,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Megahealth (41)",
            "classname": "item_health",
            "uuid": 13876201563540269579,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Invisibility (42)",
            "classname": "item_artifact_invisibility",
            "uuid": 15293344398581271007,
            "mp": 1,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 15383189724462927244,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 9242059381500866355,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Rockets (45)",
            "classname": "item_rockets",
            "uuid": 10477446282195608416,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Rockets (46)",
            "classname": "item_rockets",
            "uuid": 4327297169292019631,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Invulnerability (47)",
            "classname": "item_artifact_invulnerability",
            "uuid": 4650648687109887428,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Mjolnir (48)",
            "classname": "weapon_mjolnir",
            "uuid": 15646605850770354268,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Cells (49)",
            "classname": "item_cells",
            "uuid": 10473987365387819159,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Cells (50)",
            "classname": "item_cells",
            "uuid": 16672267084736991215,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Rocketlauncher (51)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4937446052177114603,
            "mp": 1,
        },
        {
            "id": 52,
            "name": "Rockets (52)",
            "classname": "item_rockets",
            "uuid": 135426482056778090,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Rockets (53)",
            "classname": "item_rockets",
            "uuid": 7683072672984602640,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 18302399076390225554,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rockets (55)",
            "classname": "item_rockets",
            "uuid": 14782729980677576567,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Rockets (56)",
            "classname": "item_rockets",
            "uuid": 746138041416410681,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Rockets (57)",
            "classname": "item_rockets",
            "uuid": 11506764724396585202,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Rockets (58)",
            "classname": "item_rockets",
            "uuid": 12834236182061428379,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Rockets (59)",
            "classname": "item_rockets",
            "uuid": 3483477502423868056,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Rockets (60)",
            "classname": "item_rockets",
            "uuid": 18180623744893511204,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "All Kills (61)",
            "classname": "all_kills",
            "uuid": 17435315347605246308,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Spikes (25)",
                "Rockets (17)",
                "Rockets (16)",
                "Supershotgun (34)",
                "Rocketlauncher (4)",
                "Shells (7)",
                "Red Armor (19)",
                "Large Medkit (18)",
                "Shells (8)",
                "Large Medkit (9)",
            ],
        )
        self.restrict("Rocketlauncher (4)", r.can_shootswitch)
        self.restrict("Shells (7)", r.can_shootswitch)
        self.restrict("Red Armor (19)", r.can_shootswitch)
        self.restrict("Large Medkit (18)", r.can_shootswitch)
        self.restrict("Shells (8)", r.can_shootswitch)
        self.restrict("Large Medkit (9)", r.can_shootswitch)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Supernailgun (20)",
                "Spikes (22)",
                "Spikes (21)",
                "Rockets (15)",
                "Rockets (56)",
                "Rocketlauncher (23)",
                "Spikes (14)",
                "Large Medkit (13)",
                "Proximity (28)",
                "Rockets (54)",
                "Rockets (55)",
                "Invulnerability (47)",
                "Shells (10)",
                "Rockets (59)",
                "Rockets (60)",
                "Rockets (52)",
                "Empathy (27)",
                "Rockets (53)",
                "Rockets (58)",
                "Quad Damage (12)",
                "Rockets (57)",
                "Rockets (6)",
                "Megahealth (41)",
                "Rockets (5)",
                "Rockets (40)",
                "Megahealth (38)",
                "Shells (3)",
                "Spikes (39)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        jump_area = self.region(
            "Ledges Area",
            [
                "Laser (24)",
                "Shells (11)",
                "Rockets (33)",
                "Hornofconjuring (26)",
                "Invisibility (42)",
                "Rockets (32)",
                "Gold Key (36)",
                "Grenadelauncher (37)",
                "Small Medkit (1)",
                "Small Medkit (2)",
                "Rockets (30)",
                "Yellow Armor (31)",
                "Rockets (29)",
                "Rocketlauncher (51)",
            ],
        )
        self.connect(past_door_area, jump_area, r.jump)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (44)",
                "Large Medkit (43)",
                "Mjolnir (48)",
                "Cells (49)",
                "Cells (50)",
                "Rockets (45)",
                "Rockets (46)",
                "Exit",
                "All Kills (61)",
            ],
        )
        self.connect(ret, past_gold_door_area, self.gold_key)
        self.restrict("All Kills (61)", r.jump & r.difficult_combat)

        return ret
