from BaseClasses import Region

from ..base_classes import Q1Level


class hip1m4(Q1Level):
    name = "Research Facility"
    mapfile = "hip1m4"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Silver Key (1)",
            "classname": "item_key1",
            "uuid": 18253717459947614324,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Gold Key (2)",
            "classname": "item_key2",
            "uuid": 10253557344348758917,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Supershotgun (3)",
            "classname": "weapon_supershotgun",
            "uuid": 6558151373617550413,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Laser (4)",
            "classname": "weapon_laser_gun",
            "uuid": 4939496149499091676,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Spikes (5)",
            "classname": "item_spikes",
            "uuid": 13635791165318215445,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 10705073431245994125,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 4493326231626165732,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 14054574767301187131,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 17220388324423165175,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Rockets (10)",
            "classname": "item_rockets",
            "uuid": 360541975484302936,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 10180397554827102026,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 7706568388235123922,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Rockets (13)",
            "classname": "item_rockets",
            "uuid": 2083912886205463778,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Yellow Armor (14)",
            "classname": "item_armor2",
            "uuid": 14170242262602790201,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 177294037304139937,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 7716847633347681432,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 8924637676000777691,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 1490311854334342026,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 8112567592717242246,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 1128707192883095512,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 11662940350298420985,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Green Armor (22)",
            "classname": "item_armor1",
            "uuid": 15820491277249046029,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 9552492541606855432,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rocketlauncher (24)",
            "classname": "weapon_rocketlauncher",
            "uuid": 16845675254310098470,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Yellow Armor (25)",
            "classname": "item_armor2",
            "uuid": 4497366370005819226,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Yellow Armor (26)",
            "classname": "item_armor2",
            "uuid": 5707100947202116760,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Rockets (27)",
            "classname": "item_rockets",
            "uuid": 13124659160074603765,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Rockets (28)",
            "classname": "item_rockets",
            "uuid": 13493012163764731776,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 16481590727200139211,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 5675945364363181957,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 2226545205025343081,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Quad Damage (32)",
            "classname": "item_artifact_super_damage",
            "uuid": 10200806902796193813,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 12099449212540229918,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 14844215671937284431,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 14990641305121826501,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 7123943638602004320,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Shells (37)",
            "classname": "item_shells",
            "uuid": 5115292056933652630,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Rockets (38)",
            "classname": "item_rockets",
            "uuid": 2970553046590285723,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 396101895089554779,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 9014938460492174251,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Wetsuit (41)",
            "classname": "item_artifact_wetsuit",
            "uuid": 3101370612607547681,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Secret (42)",
            "classname": "trigger_secret",
            "uuid": 8237576309030922065,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Yellow Armor (43)",
            "classname": "item_armor2",
            "uuid": 5916827006799012989,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 18273108486893785443,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Large Medkit (45)",
            "classname": "item_health",
            "uuid": 6814863244283585197,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 9044735239376190777,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 14138327768641116535,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Rockets (48)",
            "classname": "item_rockets",
            "uuid": 10644980000120473057,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 1533966400904271155,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Shells (50)",
            "classname": "item_shells",
            "uuid": 9909542166110069436,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 13563628266998190601,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 2465443988973040038,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 18027468469471772032,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 16399584208885656990,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Spikes (55)",
            "classname": "item_spikes",
            "uuid": 3755965125363579070,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 18255829340664908996,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 7102345497078749534,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Proximity (58)",
            "classname": "weapon_proximity_gun",
            "uuid": 4654726864519513148,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Shells (59)",
            "classname": "item_shells",
            "uuid": 16467328958514946393,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 13643833364191136195,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Supernailgun (61)",
            "classname": "weapon_supernailgun",
            "uuid": 3585590357510226746,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 2652208319375133148,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Lightning (63)",
            "classname": "weapon_lightning",
            "uuid": 5148698978882042060,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Grenadelauncher (64)",
            "classname": "weapon_grenadelauncher",
            "uuid": 999053366799021754,
            "mp": 1,
        },
        {
            "id": 65,
            "name": "Proximity (65)",
            "classname": "weapon_proximity_gun",
            "uuid": 10992327141781326880,
            "mp": 1,
        },
        {
            "id": 66,
            "name": "Cells (66)",
            "classname": "item_cells",
            "uuid": 870313093347500274,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Cells (67)",
            "classname": "item_cells",
            "uuid": 9058710241963529238,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Invisibility (68)",
            "classname": "item_artifact_invisibility",
            "uuid": 10469547227245575844,
            "mp": 1,
        },
        {
            "id": 69,
            "name": "Rockets (69)",
            "classname": "item_rockets",
            "uuid": 7458708157849674962,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 13671034764831398906,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 14316066597675064283,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Megahealth (72)",
            "classname": "item_health",
            "uuid": 2976496555341465312,
            "mp": 1,
        },
        {
            "id": 73,
            "name": "Rockets (73)",
            "classname": "item_rockets",
            "uuid": 13830445389748121492,
            "mp": 1,
        },
        {
            "id": 74,
            "name": "Rockets (74)",
            "classname": "item_rockets",
            "uuid": 9138894816336102456,
            "mp": 1,
        },
        {
            "id": 75,
            "name": "Cells (75)",
            "classname": "item_cells",
            "uuid": 8862674590571571126,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Cells (76)",
            "classname": "item_cells",
            "uuid": 15778042734350815720,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Yellow Armor (77)",
            "classname": "item_armor2",
            "uuid": 13140485335613436290,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Spikes (78)",
            "classname": "item_spikes",
            "uuid": 4793404004945728740,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Secret (79)",
            "classname": "trigger_secret",
            "uuid": 7624677971238985359,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Secret (80)",
            "classname": "trigger_secret",
            "uuid": 2290748689099813627,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Spikes (81)",
            "classname": "item_spikes",
            "uuid": 18098766323870504446,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Megahealth (82)",
            "classname": "item_health",
            "uuid": 11213501750944260653,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "All Kills (83)",
            "classname": "all_kills",
            "uuid": 12461792791099758352,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (71)",
                "Large Medkit (70)",
                "Large Medkit (60)",
                "Proximity (58)",
                "Shells (59)",
                "Rockets (69)",
            ],
        )

        past_first_door_area = self.region(
            "Past First Door",
            [
                "Supernailgun (61)",
                "Spikes (62)",
                "Spikes (5)",
                "Large Medkit (6)",
            ],
        )
        self.connect(ret, past_first_door_area, r.can_door)

        start_top_area = self.region(
            "Start Top",
            [
                "Laser (4)",
                "Shells (21)",
                "Supershotgun (3)",
                "Yellow Armor (77)",
            ],
        )
        self.connect(ret, start_top_area, r.bigjump_hard)
        self.connect(start_top_area, past_first_door_area)

        self.restrict("Yellow Armor (77)", r.bigjump)

        past_door_area = self.region(
            "Past Door Area",
            [
                "Large Medkit (8)",
                "Spikes (9)",
                "Green Armor (22)",
                "Shells (7)",
                "Rockets (10)",
                "Large Medkit (11)",
                "Lightning (63)",
                "Quad Damage (32)",
                "Large Medkit (33)",
                "Silver Key (1)",
                "Shells (31)",
                "Large Medkit (30)",
                "Large Medkit (29)",
                "Rockets (28)",
                "Rockets (27)",
                "Secret (42)",
                "Spikes (44)",
                "Yellow Armor (43)",
                "Spikes (78)",
                "Secret (79)",
                "Cells (75)",
                "Cells (76)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        self.restrict("Spikes (78)", r.can_shootswitch)
        self.restrict("Secret (79)", r.can_shootswitch)
        self.restrict("Cells (75)", r.bigjump)
        self.restrict("Cells (76)", r.bigjump)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [],
        )
        self.connect(past_door_area, past_silver_door_area, self.silver_key)

        top_past_door_area = self.region(
            "Top Past Door",
            [
                "Supernailgun (61)",
                "Spikes (62)",
                "Spikes (5)",
                "Large Medkit (6)",
                "Shells (16)",
                "Large Medkit (15)",
                "Rockets (12)",
                "Rockets (13)",
                "Yellow Armor (14)",
                "Shells (17)",
                "Large Medkit (19)",
                "Large Medkit (18)",
                "Spikes (20)",
                "Spikes (81)",
                "Secret (80)",
            ],
        )
        self.connect(start_top_area, top_past_door_area, r.can_door)
        # TODO: Is this connection required?
        self.connect(top_past_door_area, start_top_area, r.can_door)
        self.connect(past_silver_door_area, top_past_door_area)

        self.restrict("Spikes (81)", r.can_button & r.jump)
        self.restrict("Secret (80)", r.can_button & r.jump)

        sewer_area = self.region(
            "Sewer Area",
            [
                "Cells (67)",
                "Cells (66)",
                "Wetsuit (41)",
                "Yellow Armor (26)",
                "Megahealth (82)",
                "Spikes (35)",
                "Spikes (36)",
                "Rockets (38)",
                "Shells (37)",
                "Shells (34)",
            ],
        )

        self.connect(top_past_door_area, sewer_area, r.can_button)

        sewer_dive_area = self.region(
            "Sewer Dive",
            [
                "Megahealth (72)",
                "Rockets (74)",
                "Rockets (73)",
                "Gold Key (2)",
                "Invisibility (68)",
            ],
        )
        self.connect(sewer_area, sewer_dive_area, r.can_dive)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Rocketlauncher (24)",
                "Large Medkit (39)",
                "Large Medkit (23)",
                "Large Medkit (40)",
            ],
        )
        self.connect(past_door_area, past_gold_door_area, self.gold_key)

        past_gold_button_area = self.region(
            "Past Gold Button",
            [
                "Large Medkit (47)",
                "Rockets (48)",
                "Large Medkit (46)",
                "Spikes (49)",
                "Large Medkit (45)",
                "Shells (50)",
                "Grenadelauncher (64)",
                "Large Medkit (53)",
                "Rockets (54)",
                "Large Medkit (52)",
                "Spikes (55)",
                "Large Medkit (51)",
                "Shells (56)",
                "Proximity (65)",
                "Exit",
                "All Kills (83)",
            ],
        )
        self.connect(past_gold_door_area, past_gold_button_area, r.can_button)
        # dive for rotfish
        self.restrict("All Kills (83)", r.backpack(5) & r.can_dive)

        return ret
