from BaseClasses import Region

from ..base_classes import Q1Level


class hip1m3(Q1Level):
    name = "The Lost Mine"
    mapfile = "hip1m3"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Large Medkit (1)",
            "classname": "item_health",
            "uuid": 7592262829704438236,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 11597648955607976316,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Rockets (3)",
            "classname": "item_rockets",
            "uuid": 8269936059681914550,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Silver Key (4)",
            "classname": "item_key1",
            "uuid": 539743152328094926,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Spikes (5)",
            "classname": "item_spikes",
            "uuid": 1005675310686714471,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Spikes (6)",
            "classname": "item_spikes",
            "uuid": 15249516226935140387,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 17605907481350538296,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 2854251716341805772,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 3910062269036463408,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Green Armor (10)",
            "classname": "item_armor1",
            "uuid": 6411437568673891540,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 10015222563424938756,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 13542136356828851014,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 15515894924049275318,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Megahealth (14)",
            "classname": "item_health",
            "uuid": 12126158951740392039,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Supershotgun (15)",
            "classname": "weapon_supershotgun",
            "uuid": 3098765635544169771,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 194748111128950998,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Spikes (17)",
            "classname": "item_spikes",
            "uuid": 14637999130056626356,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 7158500637699835460,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Quad Damage (19)",
            "classname": "item_artifact_super_damage",
            "uuid": 13363394744770431567,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Nailgun (20)",
            "classname": "weapon_nailgun",
            "uuid": 12965902456967260908,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 16094982827603627259,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 16272962848454614658,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Rockets (23)",
            "classname": "item_rockets",
            "uuid": 2832170458805533709,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Grenadelauncher (24)",
            "classname": "weapon_grenadelauncher",
            "uuid": 8319764484100820400,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Supernailgun (25)",
            "classname": "weapon_supernailgun",
            "uuid": 10283719412765388693,
            "mp": 1,
        },
        {
            "id": 26,
            "name": "Proximity (26)",
            "classname": "weapon_proximity_gun",
            "uuid": 8218726017453199192,
            "mp": 1,
        },
        {
            "id": 27,
            "name": "Rockets (27)",
            "classname": "item_rockets",
            "uuid": 17174098797944380526,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Empathy (28)",
            "classname": "item_artifact_empathy_shields",
            "uuid": 276998124672600717,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Grenadelauncher (29)",
            "classname": "weapon_grenadelauncher",
            "uuid": 12926889215256735454,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 13222340556131413181,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Secret (31)",
            "classname": "trigger_secret",
            "uuid": 1946335292782105747,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Secret (32)",
            "classname": "trigger_secret",
            "uuid": 1461298045128755231,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Invisibility (33)",
            "classname": "item_artifact_invisibility",
            "uuid": 3432470263998615023,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 6744574941366538124,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Megahealth (35)",
            "classname": "item_health",
            "uuid": 3431056022697038886,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Secret (36)",
            "classname": "trigger_secret",
            "uuid": 6387845663309753532,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Megahealth (37)",
            "classname": "item_health",
            "uuid": 9239026205543297994,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 3036338324871384845,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Yellow Armor (39)",
            "classname": "item_armor2",
            "uuid": 8452004884561054182,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 1689320981868276965,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 9417862992755699029,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Rocketlauncher (42)",
            "classname": "weapon_rocketlauncher",
            "uuid": 275361786000735780,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Rockets (43)",
            "classname": "item_rockets",
            "uuid": 12057116874363241918,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Rockets (44)",
            "classname": "item_rockets",
            "uuid": 15155252523710386839,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Rockets (45)",
            "classname": "item_rockets",
            "uuid": 11505045709072371023,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Rockets (46)",
            "classname": "item_rockets",
            "uuid": 2704159468608850735,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Proximity (47)",
            "classname": "weapon_proximity_gun",
            "uuid": 16223726671773341255,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Laser (48)",
            "classname": "weapon_laser_gun",
            "uuid": 13729397771196732649,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Supernailgun (49)",
            "classname": "weapon_supernailgun",
            "uuid": 9343483820591007088,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Rockets (50)",
            "classname": "item_rockets",
            "uuid": 13900804946142391536,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Rockets (51)",
            "classname": "item_rockets",
            "uuid": 17762079890695410353,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Cells (52)",
            "classname": "item_cells",
            "uuid": 6264605381891965744,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Rockets (53)",
            "classname": "item_rockets",
            "uuid": 1763422684413388535,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Red Armor (54)",
            "classname": "item_armorInv",
            "uuid": 16001166618924665858,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Invulnerability (55)",
            "classname": "item_artifact_invulnerability",
            "uuid": 15772903202849365020,
            "mp": 1,
        },
        {
            "id": 56,
            "name": "Rocketlauncher (56)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12718420436044925641,
            "mp": 1,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 8158107457564641288,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Cells (58)",
            "classname": "item_cells",
            "uuid": 16810791254510432165,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Red Armor (59)",
            "classname": "item_armorInv",
            "uuid": 400004767245576481,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 9363064139496413736,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 15777747770569729407,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Large Medkit (62)",
            "classname": "item_health",
            "uuid": 7669912123221408466,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 4248958611674625588,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 18420437737775925897,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "All Kills (65)",
            "classname": "all_kills",
            "uuid": 14986715056355616413,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (60)",
                "Large Medkit (61)",
                "Spikes (17)",
                "Supershotgun (15)",
                "Rockets (53)",
                "Nailgun (20)",
                "Shells (16)",
                "Large Medkit (41)",
                "Spikes (18)",
                "Supernailgun (49)",
                "Rocketlauncher (42)",
                "Shells (34)",
                "Megahealth (14)",
                "Spikes (40)",
                "Rockets (44)",
                "Yellow Armor (39)",
                "Rockets (43)",
                "Cells (52)",
                "Rockets (50)",
                "Rockets (51)",
                "Empathy (28)",
                "Grenadelauncher (29)",
                "Rockets (27)",
                "Rockets (23)",
                "Large Medkit (13)",
                "Large Medkit (38)",
                "Quad Damage (19)",
            ],
        )

        past_door_area = self.region(
            "Past Door Area",
            [
                "Proximity (47)",
                "Large Medkit (21)",
                "Shells (22)",
                "Shells (11)",
                "Large Medkit (12)",
                "Large Medkit (1)",
                "Grenadelauncher (24)",
                "Megahealth (35)",
                "Red Armor (59)",
                "Secret (31)",
                "Cells (58)",
                "Cells (57)",
                "Large Medkit (7)",
                "Large Medkit (8)",
                "Spikes (9)",
                "Rockets (3)",
                "Spikes (6)",
                "Rockets (45)",
                "Red Armor (54)",
                "Rockets (46)",
                "Spikes (5)",
                "Large Medkit (2)",
                "Proximity (26)",
                "Silver Key (4)",
                "Invulnerability (55)",
                "Large Medkit (62)",
                "Large Medkit (64)",
                "Large Medkit (63)",
                "Green Armor (10)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        mine_exit_area = self.region(
            "Mine Exit",
            [
                "Supernailgun (25)",
            ],
        )
        self.connect(ret, mine_exit_area, self.silver_key)
        self.connect(past_door_area, mine_exit_area, r.can_button)

        mine_secret_area = self.region(
            "Mine Secret",
            [
                "Secret (32)",
                "Rocketlauncher (56)",
                "Invisibility (33)",
                "Laser (48)",
            ],
        )
        self.connect(past_door_area, mine_secret_area, r.jump)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Exit",
                "All Kills (65)",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key & r.can_button)
        self.restrict("All Kills (65)", r.backpack(5))

        machine_secret_area = self.region(
            "Machine Secret",
            [
                "Megahealth (37)",
                "Secret (36)",
            ],
        )
        self.connect(
            past_silver_door_area,
            machine_secret_area,
            self.silver_key & ((r.can_button & r.can_jump) | r.bigjump_hard),
        )

        return ret
