from BaseClasses import Region

from ..base_classes import Q1Level


class e5sm1(Q1Level):
    name = "The Forgotten Castle"
    mapfile = "e5sm1"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Biosuit (1)",
            "classname": "item_artifact_envirosuit",
            "uuid": 12809024601937370456,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Green Armor (2)",
            "classname": "item_armor1",
            "uuid": 10246553580805521518,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Grenadelauncher (3)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9393644476122061553,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Red Armor (4)",
            "classname": "item_armorInv",
            "uuid": 14406393734421708842,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Secret (5)",
            "classname": "trigger_secret",
            "uuid": 13492539341115721607,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Spikes (6)",
            "classname": "item_spikes",
            "uuid": 5953686499441220501,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Rocketlauncher (7)",
            "classname": "weapon_rocketlauncher",
            "uuid": 8949423998510494564,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Biosuit (8)",
            "classname": "item_artifact_envirosuit",
            "uuid": 3195789302943082834,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Rockets (9)",
            "classname": "item_rockets",
            "uuid": 4832116047105024710,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Secret (10)",
            "classname": "trigger_secret",
            "uuid": 7114868397599505388,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Supershotgun (11)",
            "classname": "weapon_supershotgun",
            "uuid": 11066478758527163882,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Quad Damage (12)",
            "classname": "item_artifact_super_damage",
            "uuid": 6385676459428072267,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 2988177406496761003,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Green Armor (14)",
            "classname": "item_armor1",
            "uuid": 14186729032710038713,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 15958741963057965400,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 14987422912110392063,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Secret (17)",
            "classname": "trigger_secret",
            "uuid": 714602715023436894,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Yellow Armor (18)",
            "classname": "item_armor2",
            "uuid": 3587752149693227140,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Shells (19)",
            "classname": "item_shells",
            "uuid": 9938368954320031565,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Secret (20)",
            "classname": "trigger_secret",
            "uuid": 10494898608631585791,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Silver Key (21)",
            "classname": "item_key1",
            "uuid": 3571278806170226750,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Spikes (22)",
            "classname": "item_spikes",
            "uuid": 469580745398732673,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Spikes (23)",
            "classname": "item_spikes",
            "uuid": 6470227258780248321,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 12909424981645282057,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Rockets (25)",
            "classname": "item_rockets",
            "uuid": 9058156543177107211,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Rockets (26)",
            "classname": "item_rockets",
            "uuid": 3844180091289710591,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Yellow Armor (27)",
            "classname": "item_armor2",
            "uuid": 2893259827112601899,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 18338156334206847480,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Spikes (29)",
            "classname": "item_spikes",
            "uuid": 12552905766857678684,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Shells (30)",
            "classname": "item_shells",
            "uuid": 4537581716783530964,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 18299544156457875266,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 410292315357495611,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Shells (33)",
            "classname": "item_shells",
            "uuid": 13886281275305610391,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Shells (34)",
            "classname": "item_shells",
            "uuid": 8749622646664766610,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Megahealth (35)",
            "classname": "item_health",
            "uuid": 10660488610658461737,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 11144875998758153445,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Rockets (37)",
            "classname": "item_rockets",
            "uuid": 10551831983295199419,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 468386903499289194,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Biosuit (39)",
            "classname": "item_artifact_envirosuit",
            "uuid": 12777311286053739454,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Small Medkit (40)",
            "classname": "item_health",
            "uuid": 1627169158692774907,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Shells (41)",
            "classname": "item_shells",
            "uuid": 10266810996824519534,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 2978734040473969335,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 9999130735220976828,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 17780803380491385273,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 15105924108792829031,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 12529499525227970935,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 926960904552430518,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 10967089881649207021,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Supernailgun (49)",
            "classname": "weapon_supernailgun",
            "uuid": 10357399828882320963,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 11901493582451026762,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Nailgun (51)",
            "classname": "weapon_nailgun",
            "uuid": 14398420185041319069,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Supernailgun (52)",
            "classname": "weapon_supernailgun",
            "uuid": 5508928313382511927,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Megahealth (53)",
            "classname": "item_health",
            "uuid": 4797084223775761377,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Grenadelauncher (54)",
            "classname": "weapon_grenadelauncher",
            "uuid": 8039463987566821875,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 1150057935286629869,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Spikes (56)",
            "classname": "item_spikes",
            "uuid": 2706125569593842205,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 13920235526751666233,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Yellow Armor (58)",
            "classname": "item_armor2",
            "uuid": 15753519893481000042,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 15738994578686432222,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Shells (60)",
            "classname": "item_shells",
            "uuid": 2176239409262100881,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Shells (61)",
            "classname": "item_shells",
            "uuid": 15618715091930078652,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Small Medkit (62)",
            "classname": "item_health",
            "uuid": 722318615996525622,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Rockets (63)",
            "classname": "item_rockets",
            "uuid": 8240135903232642437,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 14740818968327563450,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 9249901256409871349,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Spikes (66)",
            "classname": "item_spikes",
            "uuid": 11667202861274326655,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 1894773876169963440,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 7216993565853825588,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Small Medkit (69)",
            "classname": "item_health",
            "uuid": 2958927517509503368,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 4776485956384783814,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "All Kills (71)",
            "classname": "all_kills",
            "uuid": 17475584237568214876,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Small Medkit (45)",
                "Supershotgun (11)",
                "Megahealth (53)",
                "Green Armor (14)",
                "Shells (15)",
                "Shells (16)",
            ],
        )

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Spikes (38)",
                "Large Medkit (59)",
                "Yellow Armor (58)",
                "Small Medkit (62)",
                "Rockets (63)",
                "Biosuit (39)",
                "Shells (60)",
                "Shells (61)",
                "Large Medkit (65)",
                "Shells (64)",
                "Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        self.restrict("Large Medkit (65)", r.invuln(1) | r.biosuit(1))
        self.restrict("Shells (64)", r.can_button & (r.invuln(1) | r.biosuit(1)))
        self.restrict("Exit", r.can_button & (r.invuln(1) | r.biosuit(1)))

        past_button_area = self.region(
            "Past Button Area",
            [
                "Secret (17)",
                "Shells (19)",
                "Yellow Armor (18)",
                "Shells (46)",
                "Nailgun (51)",
                "Spikes (23)",
                "Spikes (22)",
                "Large Medkit (50)",
                "Small Medkit (40)",
                "Large Medkit (24)",
                "Secret (20)",
                "Spikes (48)",
                "Supernailgun (49)",
                "Large Medkit (47)",
                "Large Medkit (43)",
                "Shells (42)",
                "Shells (41)",
                "Biosuit (8)",
            ],
        )
        self.connect(ret, past_button_area, r.can_button & r.can_door)

        self.restrict("Secret (17)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Shells (19)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Yellow Armor (18)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Secret (20)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Spikes (48)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Supernailgun (49)", r.can_jump | r.can_gj_extr | r.can_rj_hard)
        self.restrict("Large Medkit (47)", r.can_jump | r.can_gj_extr | r.can_rj_hard)

        dive_area = self.region(
            "Dive Area",
            [
                "Rockets (9)",
                "Secret (10)",
                "Grenadelauncher (3)",
                "Biosuit (1)",
                "Green Armor (2)",
                "Large Medkit (67)",
                "Spikes (68)",
                "Spikes (66)",
            ],
        )
        self.connect(
            past_button_area, dive_area, r.can_dive & (r.biosuit(1) | r.invuln(1))
        )

        past_button_area = self.region(
            "Past Button Area",
            [
                "Shells (34)",
                "Grenadelauncher (54)",
                "Megahealth (35)",
                "Shells (30)",
                "Small Medkit (69)",
                "Large Medkit (31)",
                "Large Medkit (32)",
                "Shells (33)",
                "Supernailgun (52)",
                "Spikes (29)",
                "Spikes (28)",
                "Yellow Armor (27)",
                "Large Medkit (36)",
                "Rockets (37)",
                "Rocketlauncher (7)",
                "Spikes (6)",
                "Large Medkit (70)",
                "Secret (5)",
                "Red Armor (4)",
            ],
        )
        self.connect(dive_area, past_button_area, r.can_button)
        self.restrict("Rockets (37)", r.jump)
        self.restrict("Rocketlauncher (7)", r.can_jump | r.bigjump_hard)
        self.restrict("Spikes (6)", r.can_jump | r.bigjump_hard)
        self.restrict("Large Medkit (70)", r.can_jump | r.bigjump_hard)
        self.restrict("Secret (5)", r.can_jump | r.bigjump_hard)
        self.restrict("Red Armor (4)", r.can_jump | r.bigjump_hard)

        jump_area = self.region(
            "Jump Area",
            [
                "Rockets (25)",
                "Rockets (26)",
                "Silver Key (21)",
                "Large Medkit (55)",
                "Spikes (56)",
                "Large Medkit (57)",
                "Spikes (13)",
                "Quad Damage (12)",
                "All Kills (71)",
            ],
        )
        self.connect(
            past_button_area, jump_area, r.can_jump | r.can_gj_extr | r.can_rj_hard
        )
        self.restrict("All Kills (71)", self.silver_key & r.difficult_combat)

        return ret
