from BaseClasses import Region

from ..base_classes import Q1Level


class e5m4(Q1Level):
    name = "The Catacombs"
    mapfile = "e5m4"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Spikes (1)",
            "classname": "item_spikes",
            "uuid": 16718382970905957421,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Nailgun (2)",
            "classname": "weapon_nailgun",
            "uuid": 2825421949394352268,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Green Armor (3)",
            "classname": "item_armor1",
            "uuid": 16048505443221297741,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Small Medkit (4)",
            "classname": "item_health",
            "uuid": 5751998627642295510,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Large Medkit (5)",
            "classname": "item_health",
            "uuid": 17781900415436665325,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Shells (6)",
            "classname": "item_shells",
            "uuid": 17201121571557184597,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Red Armor (7)",
            "classname": "item_armorInv",
            "uuid": 4133393904569527943,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 17364858968254605180,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 824203317036481533,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 7051005644199403638,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Shells (11)",
            "classname": "item_shells",
            "uuid": 12483916031242955660,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Shells (12)",
            "classname": "item_shells",
            "uuid": 4215747223267192308,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Secret (13)",
            "classname": "trigger_secret",
            "uuid": 10027803128701917218,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Grenadelauncher (14)",
            "classname": "weapon_grenadelauncher",
            "uuid": 4818953469685861701,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Supershotgun (15)",
            "classname": "weapon_supershotgun",
            "uuid": 1994032730861800740,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 8577201498475611939,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Shells (17)",
            "classname": "item_shells",
            "uuid": 1980707582917264861,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 14062907451733741914,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Supernailgun (19)",
            "classname": "weapon_supernailgun",
            "uuid": 14799699706681508615,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Quad Damage (20)",
            "classname": "item_artifact_super_damage",
            "uuid": 6634339150314524452,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 17363806165454639108,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 5561526969436714736,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 8464257207174850473,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 1576026370331677927,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 469757384007228780,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 9949715730313461450,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Yellow Armor (27)",
            "classname": "item_armor2",
            "uuid": 4270727939309042498,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 14383183154493277629,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 8469663023656157568,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Spikes (30)",
            "classname": "item_spikes",
            "uuid": 11331024186678087005,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Secret (31)",
            "classname": "trigger_secret",
            "uuid": 2202208389501454034,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 706891115152882885,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 16460965484511629442,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Silver Key (34)",
            "classname": "item_key1",
            "uuid": 3281177433079224535,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 13031429579213956804,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 3443996116716558919,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 14502276622256927678,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 1302427101897717681,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Shells (39)",
            "classname": "item_shells",
            "uuid": 1195232919925153018,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Rocketlauncher (40)",
            "classname": "weapon_rocketlauncher",
            "uuid": 14230081144990069118,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Yellow Armor (41)",
            "classname": "item_armor2",
            "uuid": 13959274392633352955,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Secret (42)",
            "classname": "trigger_secret",
            "uuid": 6317583833081686779,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Spikes (43)",
            "classname": "item_spikes",
            "uuid": 12695578969054710458,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 14083587457199388461,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 16299248564341448654,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 4263356428221872154,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Shells (47)",
            "classname": "item_shells",
            "uuid": 241938389752640844,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Megahealth (48)",
            "classname": "item_health",
            "uuid": 514354731078662290,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Secret (49)",
            "classname": "trigger_secret",
            "uuid": 1630465336098073855,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 15846733976464183889,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 4237009801565512553,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 879114963321101552,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Spikes (53)",
            "classname": "item_spikes",
            "uuid": 6532934350377944624,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 2161784342012282643,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rockets (55)",
            "classname": "item_rockets",
            "uuid": 18344730158649213885,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Spikes (56)",
            "classname": "item_spikes",
            "uuid": 10056737525108962474,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Spikes (57)",
            "classname": "item_spikes",
            "uuid": 3077703536928103766,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Secret (58)",
            "classname": "trigger_secret",
            "uuid": 3429586376715440820,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Shells (59)",
            "classname": "item_shells",
            "uuid": 9627286667710339293,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Shells (60)",
            "classname": "item_shells",
            "uuid": 10184693847690404214,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 6103608587287477809,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Shells (62)",
            "classname": "item_shells",
            "uuid": 3524953289826612623,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Secret (63)",
            "classname": "trigger_secret",
            "uuid": 11122321001902960154,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Secret (64)",
            "classname": "trigger_secret",
            "uuid": 7988427195834311621,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Rockets (65)",
            "classname": "item_rockets",
            "uuid": 16140220681837787064,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "All Kills (66)",
            "classname": "all_kills",
            "uuid": 13008704284813069160,
            "mp": 0,
        },
    ]
    events = ["Left Button", "Right Button"]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Spikes (1)",
                "Spikes (43)",
                "Nailgun (2)",
                "Shells (59)",
                "Shells (60)",
                "Green Armor (3)",
                "Grenadelauncher (14)",
                "Spikes (9)",
                "Spikes (8)",
                "Shells (11)",
                "Shells (12)",
                "Large Medkit (61)",
                "Supershotgun (15)",
                "Shells (6)",
                "Shells (39)",
                "Small Medkit (4)",
                "Large Medkit (5)",
                "Rockets (65)",
                "Secret (64)",
                "Spikes (53)",
                "Secret (49)",
                "Megahealth (48)",
            ],
        )

        self.restrict("Rockets (65)", r.can_door)
        self.restrict("Secret (64)", r.can_door)
        self.restrict("Spikes (53)", r.can_door & r.can_dive)
        self.restrict("Secret (49)", r.can_door & r.can_dive)
        self.restrict("Megahealth (48)", r.can_door & r.can_dive)

        upper_left_area = self.region(
            "Upper Left Area",
            [
                "Large Medkit (16)",
                "Shells (17)",
                "Shells (38)",
                "Secret (58)",
                "Spikes (57)",
                "Spikes (56)",
                "Left Button",
            ],
        )
        self.connect(ret, upper_left_area, r.can_door | r.bigjump_hard)

        self.restrict("Left Button", r.can_button)

        self.restrict("Secret (58)", r.can_door)
        self.restrict("Spikes (57)", r.can_door)
        self.restrict("Spikes (56)", r.can_door)

        upper_right_area = self.region(
            "Upper Right Area",
            [
                "Large Medkit (10)",
                "Secret (13)",
                "Red Armor (7)",
                "Rockets (54)",
                "Right Button",
            ],
        )
        self.connect(ret, upper_right_area, r.can_door | r.bigjump_hard)

        self.restrict("Right Button", r.can_button)

        self.restrict("Secret (13)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Red Armor (7)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Rockets (54)", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        past_bridge_area = self.region(
            "Past Bridge",
            [
                "Large Medkit (36)",
                "Large Medkit (35)",
                "Silver Key (34)",
                "Spikes (32)",
                "Spikes (33)",
                "Large Medkit (50)",
                "Shells (51)",
                "Rocketlauncher (40)",
            ],
        )
        self.connect(
            ret,
            past_bridge_area,
            self.event("Right Button") & self.event("Left Button"),
        )

        self.restrict("Large Medkit (50)", r.can_door)
        self.restrict("Shells (51)", r.can_door)
        self.restrict("Rocketlauncher (40)", r.can_door)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Yellow Armor (41)",
                "Secret (63)",
                "Supernailgun (19)",
                "Spikes (18)",
                "Shells (22)",
                "Shells (21)",
                "Shells (47)",
                "Large Medkit (46)",
                "Spikes (45)",
                "Spikes (44)",
                "Secret (42)",
                "Quad Damage (20)",
                "Rockets (55)",
                "Large Medkit (26)",
                "Secret (31)",
                "Large Medkit (29)",
                "Yellow Armor (27)",
                "Large Medkit (28)",
                "Spikes (30)",
                "Large Medkit (25)",
                "Shells (24)",
                "Shells (23)",
                "Large Medkit (52)",
                "Shells (62)",
                "Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        self.restrict("Secret (42)", r.can_shootswitch)
        self.restrict("Quad Damage (20)", r.can_shootswitch)

        self.restrict("Large Medkit (52)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Shells (62)", r.can_jump | r.can_rj_hard | r.can_gj_extr)
        self.restrict("Exit", r.can_jump | r.can_rj_hard | r.can_gj_extr)

        return ret
