from BaseClasses import Region

from ..base_classes import Q1Level


class e4m7(Q1Level):
    name = "Azure Agony"
    mapfile = "e4m7"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Yellow Armor (1)",
            "classname": "item_armor2",
            "uuid": 732322601208528025,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 14768667367981175378,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 15905457312803594631,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Rockets (4)",
            "classname": "item_rockets",
            "uuid": 7153919085009371917,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Small Medkit (5)",
            "classname": "item_health",
            "uuid": 7612216592187951762,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Spikes (6)",
            "classname": "item_spikes",
            "uuid": 2703744837850387161,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 6178214412536894583,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 17296120786196945168,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 11658925723465834288,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Shells (10)",
            "classname": "item_shells",
            "uuid": 1873824975539338256,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Small Medkit (11)",
            "classname": "item_health",
            "uuid": 16593336839025391224,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Spikes (12)",
            "classname": "item_spikes",
            "uuid": 13841999401915864743,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 10806807971057456331,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 9702523400319236598,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Shells (15)",
            "classname": "item_shells",
            "uuid": 14894160949804580588,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 11379289624205612173,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 6693987585311533746,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 13512950138488626701,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 11698955352833405015,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 4305070079679450581,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 6189725126100739798,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Spikes (22)",
            "classname": "item_spikes",
            "uuid": 15535413187507095550,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 5014592400161218975,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Spikes (24)",
            "classname": "item_spikes",
            "uuid": 1830367831791662935,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 15593501741786766672,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 14982083458510236426,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Spikes (27)",
            "classname": "item_spikes",
            "uuid": 913421964019274272,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Spikes (28)",
            "classname": "item_spikes",
            "uuid": 8667243309177851330,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 1384314952401394344,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Spikes (30)",
            "classname": "item_spikes",
            "uuid": 2544457903258221764,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Spikes (31)",
            "classname": "item_spikes",
            "uuid": 18241460972483363250,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 5170484612579088034,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Rockets (33)",
            "classname": "item_rockets",
            "uuid": 10992181631209471275,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Rockets (34)",
            "classname": "item_rockets",
            "uuid": 7319893097915331653,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Green Armor (35)",
            "classname": "item_armor1",
            "uuid": 12060937353922578208,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Large Medkit (36)",
            "classname": "item_health",
            "uuid": 11074646342433149533,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 12255453212370880912,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Quad Damage (38)",
            "classname": "item_artifact_super_damage",
            "uuid": 13005898189365344357,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Megahealth (39)",
            "classname": "item_health",
            "uuid": 13698004759978344927,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 18234587140418607974,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Large Medkit (41)",
            "classname": "item_health",
            "uuid": 16086661484017930892,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Rockets (42)",
            "classname": "item_rockets",
            "uuid": 7672675746605914684,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Biosuit (43)",
            "classname": "item_artifact_envirosuit",
            "uuid": 14936343965630949442,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Quad Damage (44)",
            "classname": "item_artifact_super_damage",
            "uuid": 9888165042854442647,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Rockets (45)",
            "classname": "item_rockets",
            "uuid": 2895542430417379654,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Red Armor (46)",
            "classname": "item_armorInv",
            "uuid": 10638364321534143255,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Cells (47)",
            "classname": "item_cells",
            "uuid": 11380718719267195888,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Shells (48)",
            "classname": "item_shells",
            "uuid": 15732853751645889035,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Rockets (49)",
            "classname": "item_rockets",
            "uuid": 4658265188359678720,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Secret (50)",
            "classname": "trigger_secret",
            "uuid": 8357110556802905769,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Large Medkit (51)",
            "classname": "item_health",
            "uuid": 11629424279472479296,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Rockets (52)",
            "classname": "item_rockets",
            "uuid": 17176599047147851471,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Rockets (53)",
            "classname": "item_rockets",
            "uuid": 8550121422291348745,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Rockets (54)",
            "classname": "item_rockets",
            "uuid": 1257630755474483917,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Rockets (55)",
            "classname": "item_rockets",
            "uuid": 13756416667181628507,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Rockets (56)",
            "classname": "item_rockets",
            "uuid": 980884375947667953,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 1765952107419005446,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Cells (58)",
            "classname": "item_cells",
            "uuid": 13192808089837065059,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Secret (59)",
            "classname": "trigger_secret",
            "uuid": 6453942760640603657,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Secret (60)",
            "classname": "trigger_secret",
            "uuid": 13657436253844554999,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Secret (61)",
            "classname": "trigger_secret",
            "uuid": 10920454694477635767,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Cells (62)",
            "classname": "item_cells",
            "uuid": 12212169750926185004,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Quad Damage (63)",
            "classname": "item_artifact_super_damage",
            "uuid": 16625048062610604842,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Quad Damage (64)",
            "classname": "item_artifact_super_damage",
            "uuid": 11381933530281783320,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 792400862882682827,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 5003239784875625474,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Cells (67)",
            "classname": "item_cells",
            "uuid": 5252435419991188644,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Secret (68)",
            "classname": "trigger_secret",
            "uuid": 6116144842295989237,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Secret (69)",
            "classname": "trigger_secret",
            "uuid": 4331047052781943515,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Rockets (70)",
            "classname": "item_rockets",
            "uuid": 10544697158811726379,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 14447073300398699708,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Rockets (72)",
            "classname": "item_rockets",
            "uuid": 16905813318033629385,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Large Medkit (73)",
            "classname": "item_health",
            "uuid": 18062693316291352942,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Quad Damage (74)",
            "classname": "item_artifact_super_damage",
            "uuid": 1891242648787662909,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Secret (75)",
            "classname": "trigger_secret",
            "uuid": 7605009745652967359,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Secret (76)",
            "classname": "trigger_secret",
            "uuid": 12676767242720579833,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Megahealth (77)",
            "classname": "item_health",
            "uuid": 9780570524546123533,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Invulnerability (78)",
            "classname": "item_artifact_invulnerability",
            "uuid": 3775583921826803699,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Silver Key (79)",
            "classname": "item_key1",
            "uuid": 4667094115477766945,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Invisibility (80)",
            "classname": "item_artifact_invisibility",
            "uuid": 13419893049962683500,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Cells (81)",
            "classname": "item_cells",
            "uuid": 4451097368875395080,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Megahealth (82)",
            "classname": "item_health",
            "uuid": 12801232552702225058,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Quad Damage (83)",
            "classname": "item_artifact_super_damage",
            "uuid": 15583449363763097102,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Secret (84)",
            "classname": "trigger_secret",
            "uuid": 4351029923726217969,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 11704005720142167667,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Invisibility (86)",
            "classname": "item_artifact_invisibility",
            "uuid": 7954117857525704981,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Shells (87)",
            "classname": "item_shells",
            "uuid": 13728991625184816226,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Cells (88)",
            "classname": "item_cells",
            "uuid": 18296684494806614327,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Sigil (89)",
            "classname": "item_sigil",
            "uuid": 4761286016674119707,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Grenadelauncher (90)",
            "classname": "weapon_grenadelauncher",
            "uuid": 8826514569516220340,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Supershotgun (91)",
            "classname": "weapon_supershotgun",
            "uuid": 1417146075453189193,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Lightning (92)",
            "classname": "weapon_lightning",
            "uuid": 17432200675544277718,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Nailgun (93)",
            "classname": "weapon_nailgun",
            "uuid": 4808330967322848099,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Supershotgun (94)",
            "classname": "weapon_supershotgun",
            "uuid": 15888507704193093928,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Nailgun (95)",
            "classname": "weapon_nailgun",
            "uuid": 1112017496036784345,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Supershotgun (96)",
            "classname": "weapon_supershotgun",
            "uuid": 9925227740740730355,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Grenadelauncher (97)",
            "classname": "weapon_grenadelauncher",
            "uuid": 15448681758076979392,
            "mp": 1,
        },
        {
            "id": 98,
            "name": "Rocketlauncher (98)",
            "classname": "weapon_rocketlauncher",
            "uuid": 12578163767146446469,
            "mp": 1,
        },
        {
            "id": 99,
            "name": "Lightning (99)",
            "classname": "weapon_lightning",
            "uuid": 14455723544216344894,
            "mp": 1,
        },
        {
            "id": 100,
            "name": "Supernailgun (100)",
            "classname": "weapon_supernailgun",
            "uuid": 7119030055618325873,
            "mp": 1,
        },
        {
            "id": 101,
            "name": "Grenadelauncher (101)",
            "classname": "weapon_grenadelauncher",
            "uuid": 10466585503175423042,
            "mp": 1,
        },
        {
            "id": 102,
            "name": "Rocketlauncher (102)",
            "classname": "weapon_rocketlauncher",
            "uuid": 9014489290958435221,
            "mp": 1,
        },
        {
            "id": 103,
            "name": "Supernailgun (103)",
            "classname": "weapon_supernailgun",
            "uuid": 9025936136985695680,
            "mp": 1,
        },
        {
            "id": 104,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 389014808259874584,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Cells (105)",
            "classname": "item_cells",
            "uuid": 10033129010571274026,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Cells (106)",
            "classname": "item_cells",
            "uuid": 13024630965511362208,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Cells (107)",
            "classname": "item_cells",
            "uuid": 16823268568944827564,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Cells (108)",
            "classname": "item_cells",
            "uuid": 1260357737721310719,
            "mp": 0,
        },
        {
            "id": 109,
            "name": "Spikes (109)",
            "classname": "item_spikes",
            "uuid": 4460728570115704830,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "All Kills (110)",
            "classname": "all_kills",
            "uuid": 15588522298783522186,
            "mp": 0,
        },
    ]
    has_boss = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Megahealth (39)",
                "Supershotgun (91)",
                "Large Medkit (36)",
            ],
        )
        dive_area = self.region(
            "Dive Area",
            [
                "Cells (106)",
                "Yellow Armor (1)",
                "Rockets (4)",
                "Spikes (30)",
                "Grenadelauncher (90)",
                "Spikes (6)",
                "Cells (105)",
                "Small Medkit (5)",
                "Large Medkit (7)",
            ],
        )
        self.connect(ret, dive_area, r.can_dive)

        past_door_area1 = self.region(
            "Past Door 1",
            [
                "Spikes (31)",
                "Shells (9)",
                "Spikes (8)",
            ],
        )
        self.connect(ret, past_door_area1, r.can_door | (r.can_dive & r.can_button))

        past_door_area2 = self.region(
            "Past Door 2",
            [
                "Rockets (52)",
                "Rockets (53)",
                "Spikes (37)",
                "Nailgun (95)",
                "Cells (107)",
                "Supershotgun (96)",
                "Large Medkit (14)",
                "Quad Damage (38)",
            ],
        )
        self.connect(ret, past_door_area2, r.can_door)

        self.restrict("Rockets (52)", r.jump)
        self.restrict("Rockets (53)", r.jump)
        self.restrict("Spikes (31)", r.can_dive | (r.jump & r.difficulty("hard")))

        past_button_area = self.region(
            "Past Button",
            [
                "Grenadelauncher (97)",
            ],
        )
        self.connect(past_door_area2, past_button_area, r.can_button)

        jump_area = self.region(
            "Button Jump",
            [
                "Large Medkit (3)",
                "Shells (15)",
                "Spikes (40)",
                "Large Medkit (2)",
                "Green Armor (35)",
                "Spikes (16)",
                "Large Medkit (17)",
                "Rockets (42)",
                "Shells (10)",
                "Small Medkit (11)",
                "Biosuit (43)",
                "Spikes (12)",
                "Large Medkit (13)",
                "Large Medkit (51)",
                "Spikes (32)",
                "Large Medkit (18)",
                "Shells (48)",
                "Large Medkit (19)",
                "Shells (21)",
                "Spikes (22)",
                "Large Medkit (20)",
                "Spikes (28)",
                "Large Medkit (41)",
                "Quad Damage (44)",
                "Cells (108)",
                "Invisibility (80)",
                "Secret (50)",
                "Rocketlauncher (98)",
                "Red Armor (46)",
                "Spikes (85)",
                "Cells (67)",
                "Cells (47)",
                "Rockets (45)",
                "Shells (23)",
                "Supernailgun (100)",
            ],
        )
        self.connect(past_button_area, jump_area, r.jump)

        jump_secret_area = self.region(
            "Jump Secret",
            [
                "Spikes (109)",
                "Secret (60)",
                "Cells (88)",
                "Rockets (49)",
                "Shells (87)",
                "Invisibility (86)",
                "Lightning (99)",
                "Large Medkit (66)",
                "Secret (61)",
                "Cells (62)",
                "Quad Damage (64)",
                "Large Medkit (65)",
                "Rockets (55)",
                "Secret (68)",
                "Secret (69)",
                "Rockets (54)",
            ],
        )
        self.connect(
            jump_area,
            jump_secret_area,
            r.can_gj_extr | r.can_rj_hard | r.bigjump | (r.can_shootswitch & r.jump),
        )
        self.restrict("Secret (61)", r.can_shootswitch)
        self.restrict("Cells (62)", r.can_shootswitch)
        self.restrict("Quad Damage (64)", r.can_shootswitch)
        self.restrict("Large Medkit (65)", r.can_shootswitch)
        self.restrict("Rockets (55)", r.can_shootswitch & r.jump)
        self.restrict("Secret (68)", r.can_shootswitch & r.jump)
        self.restrict("Secret (69)", r.can_shootswitch & r.jump)
        self.restrict("Rockets (54)", r.can_shootswitch & r.jump)

        bigjump_secret_area = self.region(
            "Big Jump Secret",
            [
                "Secret (84)",
                "Rocketlauncher (102)",
                "Megahealth (77)",
            ],
        )
        self.connect(jump_secret_area, bigjump_secret_area, r.bigjump_hard)

        water_gap_area = self.region(
            "Water Gap",
            [],
        )
        self.connect(jump_area, water_gap_area)

        water_gap_dive = self.region(
            "Water Gap Dive",
            [
                "Grenadelauncher (101)",
                "Quad Damage (63)",
                "Large Medkit (29)",
                "Secret (59)",
                "Rockets (56)",
                "Cells (57)",
                "Cells (58)",
            ],
        )
        self.connect(water_gap_area, water_gap_dive, r.can_dive)
        self.restrict("Secret (59)", r.can_button)
        self.restrict("Rockets (56)", r.can_button)
        self.restrict("Cells (57)", r.can_button)
        self.restrict("Cells (58)", r.can_button)

        past_water_gap_area = self.region(
            "Past Water Gap",
            [
                "Supershotgun (94)",
                "Silver Key (79)",
                "Lightning (92)",
                "Quad Damage (74)",
                "Invulnerability (78)",
            ],
        )
        self.connect(
            water_gap_area,
            past_water_gap_area,
            (r.can_shootswitch & r.jump) | r.can_rj_hard | r.can_gj_extr,
        )

        dive_switch_area = self.region(
            "Dive Switch",
            [
                "Large Medkit (73)",
                "Spikes (25)",
                "Rockets (70)",
                "Nailgun (93)",
                "Large Medkit (71)",
                "Rockets (72)",
                "Spikes (26)",
                "Spikes (27)",
                "Spikes (24)",
                # rest requires shootswitch
                "Secret (76)",
                "Secret (75)",
                "Rockets (33)",
                "Rockets (34)",
            ],
        )
        self.connect(past_water_gap_area, dive_switch_area, r.can_dive)
        self.connect(dive_switch_area, bigjump_secret_area, r.can_shootswitch)
        self.restrict("Secret (76)", r.can_shootswitch)
        self.restrict("Secret (75)", r.can_shootswitch)
        self.restrict("Rockets (33)", r.can_shootswitch)
        self.restrict("Rockets (34)", r.can_shootswitch)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Megahealth (82)",
                "Supernailgun (103)",
                "Cells (81)",
                "Quad Damage (83)",
                "Sigil (89)",
                "All Kills (110)",
                "Exit",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key & r.jump)
        self.restrict(
            "All Kills (110)",
            r.difficult_combat
            & ((r.can_shootswitch & r.jump) | r.can_rj_hard | r.can_gj_extr)
            & r.can_dive,
        )

        return ret
