from BaseClasses import Region

from ..base_classes import Q1Level


class e3m6(Q1Level):
    name = "Chambers of Torment"
    mapfile = "e3m6"
    keys = ["Silver", "Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Silver Key (1)",
            "classname": "item_key1",
            "uuid": 1978295079584612776,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Gold Key (2)",
            "classname": "item_key2",
            "uuid": 12114600897248913554,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 11040769228277871054,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 16282556064012389832,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Secret (5)",
            "classname": "trigger_secret",
            "uuid": 15518705990586225006,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Secret (6)",
            "classname": "trigger_secret",
            "uuid": 3161944416718967000,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 6040948138918033939,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 3614381491364582099,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Shells (9)",
            "classname": "item_shells",
            "uuid": 9674540429712549003,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 11045893591893874189,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 10273144267715972174,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Spikes (12)",
            "classname": "item_spikes",
            "uuid": 2525855806447576367,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Shells (13)",
            "classname": "item_shells",
            "uuid": 16782383534897284974,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Small Medkit (14)",
            "classname": "item_health",
            "uuid": 15407125218216076821,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Cells (15)",
            "classname": "item_cells",
            "uuid": 8003857876419102969,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Cells (16)",
            "classname": "item_cells",
            "uuid": 401867756599426917,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Rockets (17)",
            "classname": "item_rockets",
            "uuid": 9533437664500971957,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Small Medkit (18)",
            "classname": "item_health",
            "uuid": 15228362024742702105,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 12355553106667405165,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 7256673925377276557,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Spikes (21)",
            "classname": "item_spikes",
            "uuid": 14964386086656090201,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 18040765962865244815,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Small Medkit (23)",
            "classname": "item_health",
            "uuid": 10502346419362107232,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Shells (24)",
            "classname": "item_shells",
            "uuid": 12718727683576722302,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Shells (25)",
            "classname": "item_shells",
            "uuid": 16557726053219618516,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 2047052414084537470,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 2761453196409941887,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Small Medkit (28)",
            "classname": "item_health",
            "uuid": 5251040850575341639,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Small Medkit (29)",
            "classname": "item_health",
            "uuid": 16274732504419108214,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Spikes (30)",
            "classname": "item_spikes",
            "uuid": 7454769019052324313,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Small Medkit (31)",
            "classname": "item_health",
            "uuid": 8933868318322476198,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Small Medkit (32)",
            "classname": "item_health",
            "uuid": 18321585690353467181,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Spikes (33)",
            "classname": "item_spikes",
            "uuid": 17764386513592120212,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 12893550279765995671,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 16171069627076162056,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Cells (36)",
            "classname": "item_cells",
            "uuid": 17355054593493497627,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Rockets (37)",
            "classname": "item_rockets",
            "uuid": 6550072047655831758,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 16378332646978750853,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 16020866147171894613,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Shells (40)",
            "classname": "item_shells",
            "uuid": 13815786986955084134,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Shells (41)",
            "classname": "item_shells",
            "uuid": 10299136176289406868,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Spikes (42)",
            "classname": "item_spikes",
            "uuid": 18308912113868905196,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Spikes (43)",
            "classname": "item_spikes",
            "uuid": 17976559938739828232,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Shells (44)",
            "classname": "item_shells",
            "uuid": 6238976437852665689,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Small Medkit (45)",
            "classname": "item_health",
            "uuid": 7191470453662312326,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Small Medkit (46)",
            "classname": "item_health",
            "uuid": 11763247035995700035,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Rockets (47)",
            "classname": "item_rockets",
            "uuid": 14194129818435308011,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Large Medkit (48)",
            "classname": "item_health",
            "uuid": 3138529720289718182,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 14580426678769147036,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 14391945143851947707,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Spikes (51)",
            "classname": "item_spikes",
            "uuid": 9421663418277676862,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 15315233082911774741,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Small Medkit (53)",
            "classname": "item_health",
            "uuid": 13867839047966323493,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Shells (54)",
            "classname": "item_shells",
            "uuid": 9251410868698698990,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Shells (55)",
            "classname": "item_shells",
            "uuid": 15045237695595053913,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 17609983548742876160,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Quad Damage (57)",
            "classname": "item_artifact_super_damage",
            "uuid": 5143629121730682339,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Yellow Armor (58)",
            "classname": "item_armor2",
            "uuid": 11429771500364434564,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Rockets (59)",
            "classname": "item_rockets",
            "uuid": 16079690672700632395,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Spikes (60)",
            "classname": "item_spikes",
            "uuid": 15795017511341169286,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Spikes (61)",
            "classname": "item_spikes",
            "uuid": 12565256222900752980,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Shells (62)",
            "classname": "item_shells",
            "uuid": 14707286251067163428,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Small Medkit (63)",
            "classname": "item_health",
            "uuid": 6396423792017215233,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Small Medkit (64)",
            "classname": "item_health",
            "uuid": 647933954946800636,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 5141184899608079598,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 17541086998805046804,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 4877599644232324456,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 2783960286021814133,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Shells (69)",
            "classname": "item_shells",
            "uuid": 11468445100853716403,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 5472303675664502710,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 10646751076778304598,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Spikes (72)",
            "classname": "item_spikes",
            "uuid": 16332850572005636992,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Shells (73)",
            "classname": "item_shells",
            "uuid": 10171906909160612408,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Rockets (74)",
            "classname": "item_rockets",
            "uuid": 3753682499955012210,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Spikes (75)",
            "classname": "item_spikes",
            "uuid": 8875106675143965308,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Red Armor (76)",
            "classname": "item_armorInv",
            "uuid": 17861526179399437556,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Rockets (77)",
            "classname": "item_rockets",
            "uuid": 10728329711041461326,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Large Medkit (78)",
            "classname": "item_health",
            "uuid": 12666845846605130313,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Small Medkit (79)",
            "classname": "item_health",
            "uuid": 10573881835741319312,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Shells (80)",
            "classname": "item_shells",
            "uuid": 9195882054271435383,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Shells (81)",
            "classname": "item_shells",
            "uuid": 17963959524479701889,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Green Armor (82)",
            "classname": "item_armor1",
            "uuid": 13059817558363148322,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Shells (83)",
            "classname": "item_shells",
            "uuid": 3212927497191333128,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 9234003569569634169,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Grenadelauncher (85)",
            "classname": "weapon_grenadelauncher",
            "uuid": 17397632363535967121,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Supershotgun (86)",
            "classname": "weapon_supershotgun",
            "uuid": 3558540994492659427,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Invisibility (87)",
            "classname": "item_artifact_invisibility",
            "uuid": 11703170050548656383,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Supernailgun (88)",
            "classname": "weapon_supernailgun",
            "uuid": 8414825514941589222,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Lightning (89)",
            "classname": "weapon_lightning",
            "uuid": 4299305437425745783,
            "mp": 1,
        },
        {
            "id": 90,
            "name": "Cells (90)",
            "classname": "item_cells",
            "uuid": 16660455354916730029,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Rocketlauncher (91)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5621785225478441171,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Supershotgun (92)",
            "classname": "weapon_supershotgun",
            "uuid": 9688982050914096176,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Nailgun (93)",
            "classname": "weapon_nailgun",
            "uuid": 11706748908789371899,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Green Armor (94)",
            "classname": "item_armor1",
            "uuid": 6470152997480850442,
            "mp": 0,
        },
        {
            "id": 95,
            "name": "Sigil (95)",
            "classname": "item_sigil",
            "uuid": 2380993327617965552,
            "mp": 0,
        },
        {
            "id": 96,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 11903391468419555573,
            "mp": 0,
        },
        {
            "id": 97,
            "name": "Cells (97)",
            "classname": "item_cells",
            "uuid": 15255493765991889703,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Rockets (98)",
            "classname": "item_rockets",
            "uuid": 3686628353599832759,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 4908824990209177624,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Spikes (100)",
            "classname": "item_spikes",
            "uuid": 11885286033156767501,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "All Kills (101)",
            "classname": "all_kills",
            "uuid": 9235368034346429053,
            "mp": 0,
        },
    ]
    has_boss = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (7)",
                "Large Medkit (8)",
                "Spikes (12)",
                "Shells (13)",
                "Small Medkit (14)",
                "Cells (16)",
                "Cells (15)",
                "Rockets (17)",
                "Supershotgun (86)",
                "Small Medkit (18)",
                "Shells (80)",
                "Rockets (77)",
                "Large Medkit (19)",
                "Large Medkit (20)",
                "Red Armor (76)",
                "Invisibility (87)",
                "Large Medkit (11)",
                "Large Medkit (10)",
                "Shells (9)",
                "Shells (25)",
                "Shells (26)",
                "Small Medkit (27)",
                "Shells (56)",
                "Spikes (99)",
                "Spikes (100)",
                "Small Medkit (28)",
                "Small Medkit (29)",
                "Spikes (30)",
                "Shells (55)",
                "Spikes (33)",
                "Spikes (34)",
                "Small Medkit (32)",
                "Small Medkit (31)",
                "Silver Key (1)",
                "Grenadelauncher (85)",
            ],
        )

        past_door_area = self.region(
            "Past Door",
            [
                "Green Armor (94)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door)

        shootswitch_secret_area = self.region(
            "First Secret Area",
            [
                "Secret (5)",
                "Yellow Armor (58)",
                "Large Medkit (4)",
                "Large Medkit (3)",
                "Supershotgun (92)",
                "Spikes (35)",
                "Quad Damage (57)",
            ],
        )
        self.connect(past_door_area, shootswitch_secret_area, r.can_shootswitch)
        self.restrict("Spikes (35)", r.jump)
        self.restrict("Quad Damage (57)", r.jump)

        past_silver_door_area = self.region(
            "Past Silver Door",
            [
                "Nailgun (93)",
                "Shells (40)",
                "Shells (81)",
                "Cells (36)",
                "Shells (41)",
                "Shells (24)",
                "Rockets (59)",
                "Small Medkit (22)",
                "Small Medkit (23)",
                "Spikes (21)",
                "Spikes (42)",
                "Spikes (43)",
                "Shells (44)",
                "Small Medkit (45)",
                "Small Medkit (46)",
                "Rocketlauncher (91)",
                "Green Armor (82)",
            ],
        )
        self.connect(ret, past_silver_door_area, self.silver_key)

        silver_shootswitch_area = self.region(
            "Silver Secret",
            [
                "Rockets (37)",
                "Large Medkit (38)",
                "Large Medkit (39)",
                "Shells (83)",
                "Secret (6)",
            ],
        )
        self.connect(
            past_silver_door_area,
            silver_shootswitch_area,
            r.can_shootswitch | r.bigjump_hard,
        )
        self.restrict("Secret (6)", r.can_shootswitch)

        past_button_area = self.region(
            "Past Button",
            [
                "Rockets (47)",
                "Large Medkit (78)",
                "Small Medkit (79)",
                "Spikes (61)",
                "Spikes (60)",
                "Shells (62)",
                "Large Medkit (49)",
                "Large Medkit (48)",
                "Cells (90)",
                "Rockets (98)",
                "Spikes (50)",
                "Small Medkit (64)",
                "Small Medkit (63)",
                "Shells (65)",
                "Large Medkit (52)",
                "Small Medkit (53)",
                "Spikes (51)",
                "Large Medkit (84)",
                "Supernailgun (88)",
                "Shells (54)",
                "Gold Key (2)",
                "Rockets (74)",
                "Spikes (68)",
                "Large Medkit (67)",
                "Large Medkit (66)",
                "Shells (69)",
                "Spikes (75)",
            ],
        )
        self.connect(past_silver_door_area, past_button_area, r.can_button)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Large Medkit (70)",
                "Large Medkit (71)",
                "Spikes (72)",
                "Shells (73)",
                "Cells (97)",
                "Sigil (95)",
                "Lightning (89)",
                "Exit",
                "All Kills (101)",
            ],
        )
        self.connect(past_silver_door_area, past_gold_door_area, self.gold_key)
        self.connect(past_button_area, past_gold_door_area, r.bigjump_hard)
        self.restrict("Exit", r.can_door)
        self.restrict("All Kills (101)", r.difficult_combat)

        return ret
