from BaseClasses import Region

from ..base_classes import Q1Level


class e3m5(Q1Level):
    name = "The Wind Tunnels"
    mapfile = "e3m5"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 11768141607934410962,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Shells (2)",
            "classname": "item_shells",
            "uuid": 9755403012360483392,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 13738164652601296234,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Large Medkit (4)",
            "classname": "item_health",
            "uuid": 14240368668219563731,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Spikes (5)",
            "classname": "item_spikes",
            "uuid": 17490881727030147803,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 7184519949071614289,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Large Medkit (7)",
            "classname": "item_health",
            "uuid": 1823571236190828120,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Spikes (8)",
            "classname": "item_spikes",
            "uuid": 3326250416509713887,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Spikes (9)",
            "classname": "item_spikes",
            "uuid": 4324398709301444294,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Secret (10)",
            "classname": "trigger_secret",
            "uuid": 16993117994590617931,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 13621221401758460124,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 6208528964733635778,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 11645157531846447571,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Biosuit (14)",
            "classname": "item_artifact_envirosuit",
            "uuid": 14744871328748800971,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Secret (15)",
            "classname": "trigger_secret",
            "uuid": 13421929945645878153,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Spikes (16)",
            "classname": "item_spikes",
            "uuid": 10972171332298931881,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Secret (17)",
            "classname": "trigger_secret",
            "uuid": 3218769101941695355,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 5298696550096431455,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Spikes (19)",
            "classname": "item_spikes",
            "uuid": 17362695122193406286,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Large Medkit (20)",
            "classname": "item_health",
            "uuid": 3883544237942907639,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Large Medkit (21)",
            "classname": "item_health",
            "uuid": 10365937340518149574,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Secret (22)",
            "classname": "trigger_secret",
            "uuid": 12994864705550162809,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 3819573453221163633,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 1477997778996211557,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Quad Damage (25)",
            "classname": "item_artifact_super_damage",
            "uuid": 16555773859104240650,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Spikes (26)",
            "classname": "item_spikes",
            "uuid": 6927825277897773951,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 12233170686782287129,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Large Medkit (28)",
            "classname": "item_health",
            "uuid": 5301069448654271510,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Shells (29)",
            "classname": "item_shells",
            "uuid": 6979395119370054147,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Rockets (30)",
            "classname": "item_rockets",
            "uuid": 2899760333940234192,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Rockets (31)",
            "classname": "item_rockets",
            "uuid": 8934154149027950696,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 13548869790148207992,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 8885728422740379630,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Small Medkit (34)",
            "classname": "item_health",
            "uuid": 16963236819147460323,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Small Medkit (35)",
            "classname": "item_health",
            "uuid": 13732579972655253123,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Cells (36)",
            "classname": "item_cells",
            "uuid": 14849307813319450500,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Shells (37)",
            "classname": "item_shells",
            "uuid": 14111596598696856228,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Shells (38)",
            "classname": "item_shells",
            "uuid": 7809577628049461327,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 16679725102874274448,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 7110480601916546466,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 4571401650574840567,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Spikes (42)",
            "classname": "item_spikes",
            "uuid": 12501038270352116869,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Large Medkit (43)",
            "classname": "item_health",
            "uuid": 16617349702617703199,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Shells (44)",
            "classname": "item_shells",
            "uuid": 3428292586331298583,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 89995391279011682,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Spikes (46)",
            "classname": "item_spikes",
            "uuid": 15526347929608306984,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 17962162619629646164,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Rockets (48)",
            "classname": "item_rockets",
            "uuid": 17010220020562493461,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 10869545187039884637,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 2161754734065488126,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Quad Damage (51)",
            "classname": "item_artifact_super_damage",
            "uuid": 13538000092504371952,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 11395951353862414505,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 13477350324362702660,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 5209517904498275905,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 8040764659823831587,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Cells (56)",
            "classname": "item_cells",
            "uuid": 6864857037730715856,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Small Medkit (57)",
            "classname": "item_health",
            "uuid": 3146198722183885210,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Green Armor (58)",
            "classname": "item_armor1",
            "uuid": 6413496784904835534,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Green Armor (59)",
            "classname": "item_armor1",
            "uuid": 18404419074815068474,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 15430417974489890044,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Large Medkit (61)",
            "classname": "item_health",
            "uuid": 10675088462820156931,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Large Medkit (62)",
            "classname": "item_health",
            "uuid": 6977034495688242746,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Large Medkit (63)",
            "classname": "item_health",
            "uuid": 8352634420178287677,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Shells (64)",
            "classname": "item_shells",
            "uuid": 823963609147300008,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 17484272055536023174,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Large Medkit (66)",
            "classname": "item_health",
            "uuid": 2952747679259523239,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 3113787883839699735,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 13768228153698029255,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Small Medkit (69)",
            "classname": "item_health",
            "uuid": 7774912488584794067,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Small Medkit (70)",
            "classname": "item_health",
            "uuid": 4930543592752849735,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Small Medkit (71)",
            "classname": "item_health",
            "uuid": 9522190925488767379,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Biosuit (72)",
            "classname": "item_artifact_envirosuit",
            "uuid": 4848415869262235920,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Spikes (73)",
            "classname": "item_spikes",
            "uuid": 1286473722381436720,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 4915176804429028052,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Large Medkit (75)",
            "classname": "item_health",
            "uuid": 11786323800385524373,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Large Medkit (76)",
            "classname": "item_health",
            "uuid": 11304715028688043710,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Large Medkit (77)",
            "classname": "item_health",
            "uuid": 6000188736668343498,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Small Medkit (78)",
            "classname": "item_health",
            "uuid": 9680652695255551762,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Small Medkit (79)",
            "classname": "item_health",
            "uuid": 4372669932446050246,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Shells (80)",
            "classname": "item_shells",
            "uuid": 7596620722024932170,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Rockets (81)",
            "classname": "item_rockets",
            "uuid": 762161433866677915,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Spikes (82)",
            "classname": "item_spikes",
            "uuid": 11481580924702290260,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Cells (83)",
            "classname": "item_cells",
            "uuid": 17400482714290292008,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Large Medkit (84)",
            "classname": "item_health",
            "uuid": 9542934444229236700,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Spikes (85)",
            "classname": "item_spikes",
            "uuid": 14754537980418373961,
            "mp": 0,
        },
        {
            "id": 86,
            "name": "Small Medkit (86)",
            "classname": "item_health",
            "uuid": 16603903120072556240,
            "mp": 0,
        },
        {
            "id": 87,
            "name": "Spikes (87)",
            "classname": "item_spikes",
            "uuid": 15047698677654850400,
            "mp": 0,
        },
        {
            "id": 88,
            "name": "Spikes (88)",
            "classname": "item_spikes",
            "uuid": 9352828734789511842,
            "mp": 0,
        },
        {
            "id": 89,
            "name": "Small Medkit (89)",
            "classname": "item_health",
            "uuid": 7494755570965806309,
            "mp": 0,
        },
        {
            "id": 90,
            "name": "Small Medkit (90)",
            "classname": "item_health",
            "uuid": 8523802204551683921,
            "mp": 0,
        },
        {
            "id": 91,
            "name": "Supershotgun (91)",
            "classname": "weapon_supershotgun",
            "uuid": 1948192019862608509,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Rocketlauncher (92)",
            "classname": "weapon_rocketlauncher",
            "uuid": 3021406615782395140,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Supernailgun (93)",
            "classname": "weapon_supernailgun",
            "uuid": 9952208383944220744,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Nailgun (94)",
            "classname": "weapon_nailgun",
            "uuid": 1458762376160132650,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Grenadelauncher (95)",
            "classname": "weapon_grenadelauncher",
            "uuid": 4422479960285448492,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Nailgun (96)",
            "classname": "weapon_nailgun",
            "uuid": 2966578446338148754,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Nailgun (97)",
            "classname": "weapon_nailgun",
            "uuid": 6636290798719411037,
            "mp": 1,
        },
        {
            "id": 98,
            "name": "Supernailgun (98)",
            "classname": "weapon_supernailgun",
            "uuid": 7538042911066368526,
            "mp": 1,
        },
        {
            "id": 99,
            "name": "Spikes (99)",
            "classname": "item_spikes",
            "uuid": 2808848297429798700,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Green Armor (100)",
            "classname": "item_armor1",
            "uuid": 15836597763938530527,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Large Medkit (101)",
            "classname": "item_health",
            "uuid": 2071985401666054248,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Rockets (102)",
            "classname": "item_rockets",
            "uuid": 17289376197171763834,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Rockets (103)",
            "classname": "item_rockets",
            "uuid": 5502026532805858431,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "Rocketlauncher (104)",
            "classname": "weapon_rocketlauncher",
            "uuid": 10794801133942709732,
            "mp": 0,
        },
        {
            "id": 105,
            "name": "Small Medkit (105)",
            "classname": "item_health",
            "uuid": 9420352090455397471,
            "mp": 0,
        },
        {
            "id": 106,
            "name": "Small Medkit (106)",
            "classname": "item_health",
            "uuid": 2963071482342953764,
            "mp": 0,
        },
        {
            "id": 107,
            "name": "Lightning (107)",
            "classname": "weapon_lightning",
            "uuid": 9377557188947495395,
            "mp": 0,
        },
        {
            "id": 108,
            "name": "Megahealth (108)",
            "classname": "item_health",
            "uuid": 6048240839030310201,
            "mp": 1,
        },
        {
            "id": 109,
            "name": "Spikes (109)",
            "classname": "item_spikes",
            "uuid": 2051183509164307297,
            "mp": 0,
        },
        {
            "id": 110,
            "name": "All Kills (110)",
            "classname": "all_kills",
            "uuid": 14667958664321143562,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Nailgun (94)",
                "Spikes (16)",
                "Spikes (5)",
                "Shells (2)",
                "Large Medkit (3)",
                "Large Medkit (4)",
            ],
        )

        first_pipe_area = self.region(
            "First Pipe",
            [
                "Supershotgun (91)",
                "Large Medkit (6)",
                "Large Medkit (7)",
                "Spikes (9)",
                "Spikes (8)",
                "Cells (36)",
                "Small Medkit (34)",
                "Small Medkit (35)",
                "Small Medkit (106)",
                "Small Medkit (105)",
                "Lightning (107)",
                "Shells (37)",
                "Shells (38)",
                "Green Armor (100)",
                "Supernailgun (98)",
                "Large Medkit (39)",
                "Large Medkit (40)",
                "Spikes (41)",
                "Large Medkit (28)",
                "Large Medkit (27)",
                "Shells (29)",
                "Spikes (42)",
                "Large Medkit (32)",
                "Large Medkit (33)",
                "Rocketlauncher (92)",
                "Rockets (30)",
                "Rockets (31)",
                "Biosuit (14)",
                "Secret (22)",
                "Spikes (26)",
                "Quad Damage (25)",
                "Large Medkit (24)",
                "Large Medkit (23)",
                "Rockets (103)",
            ],
        )
        self.connect(ret, first_pipe_area, r.jump)
        self.restrict("Small Medkit (105)", r.can_dive)
        self.restrict("Small Medkit (106)", r.can_dive)

        past_button_area = self.region(
            "Past Button",
            [
                "Small Medkit (89)",
                "Spikes (99)",
                "Shells (45)",
                "Shells (44)",
                "Large Medkit (43)",
                "Large Medkit (77)",
                "Spikes (88)",
                "Rockets (48)",
                "Small Medkit (86)",
                "Spikes (46)",
                "Green Armor (59)",
                "Spikes (47)",
                "Nailgun (97)",
                "Secret (10)",
                "Large Medkit (12)",
                "Large Medkit (11)",
                "Rocketlauncher (104)",
                "Megahealth (108)",
                "Spikes (13)",
                "Spikes (109)",
            ],
        )
        self.connect(first_pipe_area, past_button_area, r.can_button & r.can_dive)

        past_door_area = self.region(
            "Past Door",
            [
                "Shells (80)",
                "Small Medkit (79)",
                "Small Medkit (78)",
                "Spikes (87)",
                "Spikes (82)",
                "Rockets (81)",
                "Large Medkit (53)",
                "Large Medkit (52)",
                "Quad Damage (51)",
                "Cells (83)",
                "Cells (56)",
                "Large Medkit (54)",
                "Large Medkit (55)",
                "Supernailgun (93)",
                "Small Medkit (57)",
                "Green Armor (58)",
                "Spikes (50)",
                "Spikes (49)",
                "Large Medkit (61)",
                "Large Medkit (60)",
                "Rockets (102)",
                "Large Medkit (84)",
                "Spikes (85)",
                "Large Medkit (66)",
                "Spikes (67)",
                "Small Medkit (71)",
                "Small Medkit (70)",
                "Small Medkit (69)",
                "Spikes (68)",
                "Shells (65)",
                "Shells (64)",
                "Large Medkit (63)",
                "Grenadelauncher (95)",
                "Large Medkit (62)",
                "Secret (15)",
                "Biosuit (72)",
                "Spikes (73)",
                "Large Medkit (74)",
                "Small Medkit (90)",
                "Large Medkit (101)",
                "Nailgun (96)",
                "Large Medkit (76)",
                "Large Medkit (75)",
                "Exit",
                "Secret (17)",
                "Spikes (18)",
                "Spikes (19)",
                "Large Medkit (21)",
                "Large Medkit (20)",
                "All Kills (110)",
            ],
        )
        self.connect(past_button_area, past_door_area, r.can_door)
        self.restrict("Secret (15)", r.can_shootswitch)
        self.restrict("Biosuit (72)", r.can_shootswitch)
        self.restrict("Spikes (73)", r.can_shootswitch)
        self.restrict("Large Medkit (74)", r.can_shootswitch)
        self.restrict("Secret (17)", r.can_shootswitch)
        self.restrict("Spikes (18)", r.can_shootswitch)
        self.restrict("Spikes (19)", r.can_shootswitch)
        self.restrict("Large Medkit (21)", r.can_shootswitch)
        self.restrict("Large Medkit (20)", r.can_shootswitch)

        self.restrict("All Kills (110)", r.difficult_combat)

        return ret
