from BaseClasses import Region

from ..base_classes import Q1Level


class e3m4(Q1Level):
    name = "Satan's Dark Delight"
    mapfile = "e3m4"
    keys = []
    location_defs = [
        {
            "id": 1,
            "name": "Small Medkit (1)",
            "classname": "item_health",
            "uuid": 10081241831839606297,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Small Medkit (2)",
            "classname": "item_health",
            "uuid": 9112309232538272159,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Small Medkit (3)",
            "classname": "item_health",
            "uuid": 12577478794996814362,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Small Medkit (4)",
            "classname": "item_health",
            "uuid": 1490522384615732615,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Rockets (5)",
            "classname": "item_rockets",
            "uuid": 10696513856254354351,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Spikes (6)",
            "classname": "item_spikes",
            "uuid": 15696315974250214442,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Spikes (7)",
            "classname": "item_spikes",
            "uuid": 3870699527654017486,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Rockets (8)",
            "classname": "item_rockets",
            "uuid": 9896690642835840549,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 9507780150665388899,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Large Medkit (10)",
            "classname": "item_health",
            "uuid": 722761786710945025,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Small Medkit (11)",
            "classname": "item_health",
            "uuid": 8854691917775322508,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Small Medkit (12)",
            "classname": "item_health",
            "uuid": 15330174642805459257,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 12560080275222119168,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 235627506610653108,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Large Medkit (15)",
            "classname": "item_health",
            "uuid": 14724694681860781872,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 17250037565853312343,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 3932603909604668187,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 15587203853635552460,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Large Medkit (19)",
            "classname": "item_health",
            "uuid": 12055622768418083357,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Rockets (20)",
            "classname": "item_rockets",
            "uuid": 3761095164808621618,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Secret Exit",
            "classname": "trigger_changelevel",
            "uuid": 1973848427906723707,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Yellow Armor (22)",
            "classname": "item_armor2",
            "uuid": 17028974126098097975,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 4373372134308393090,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Large Medkit (24)",
            "classname": "item_health",
            "uuid": 797914786548052554,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 15986556279044578707,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Small Medkit (26)",
            "classname": "item_health",
            "uuid": 4778960728614777022,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 7977707538047303643,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Small Medkit (28)",
            "classname": "item_health",
            "uuid": 18139991321234314797,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 10082625673243741365,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 3347219881245948945,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Spikes (31)",
            "classname": "item_spikes",
            "uuid": 190952138099606357,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Large Medkit (32)",
            "classname": "item_health",
            "uuid": 11632217727859532706,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Large Medkit (33)",
            "classname": "item_health",
            "uuid": 15363853110715072097,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 15776001230462370412,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 12245812565392857964,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Spikes (36)",
            "classname": "item_spikes",
            "uuid": 13190896823148751841,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Invulnerability (37)",
            "classname": "item_artifact_invulnerability",
            "uuid": 5371171380723815010,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Large Medkit (38)",
            "classname": "item_health",
            "uuid": 1169495705052656496,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 9599612942053619720,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Small Medkit (40)",
            "classname": "item_health",
            "uuid": 14924032704306572075,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Small Medkit (41)",
            "classname": "item_health",
            "uuid": 10317798328784257536,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Spikes (42)",
            "classname": "item_spikes",
            "uuid": 9606545800608542186,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Secret (43)",
            "classname": "trigger_secret",
            "uuid": 10747402584015628104,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Megahealth (44)",
            "classname": "item_health",
            "uuid": 5014520562611958818,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Yellow Armor (45)",
            "classname": "item_armor2",
            "uuid": 17074015410384278349,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Quad Damage (46)",
            "classname": "item_artifact_super_damage",
            "uuid": 5255434482773751688,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 2552361044464402906,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Cells (48)",
            "classname": "item_cells",
            "uuid": 5712862018284384014,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Spikes (49)",
            "classname": "item_spikes",
            "uuid": 18254255306370962121,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Supershotgun (50)",
            "classname": "weapon_supershotgun",
            "uuid": 3379402238618389863,
            "mp": 1,
        },
        {
            "id": 51,
            "name": "Supershotgun (51)",
            "classname": "weapon_supershotgun",
            "uuid": 297219701403063828,
            "mp": 1,
        },
        {
            "id": 52,
            "name": "Red Armor (52)",
            "classname": "item_armorInv",
            "uuid": 5329499816866773716,
            "mp": 1,
        },
        {
            "id": 53,
            "name": "Supernailgun (53)",
            "classname": "weapon_supernailgun",
            "uuid": 18306353653258542937,
            "mp": 1,
        },
        {
            "id": 54,
            "name": "Grenadelauncher (54)",
            "classname": "weapon_grenadelauncher",
            "uuid": 15578613538699648759,
            "mp": 1,
        },
        {
            "id": 55,
            "name": "Lightning (55)",
            "classname": "weapon_lightning",
            "uuid": 10297014985642400278,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Cells (56)",
            "classname": "item_cells",
            "uuid": 14910808446619913447,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Cells (57)",
            "classname": "item_cells",
            "uuid": 17951869116459141528,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 15377982045199993733,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 13767984933606047986,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 10230711004641512518,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Rocketlauncher (61)",
            "classname": "weapon_rocketlauncher",
            "uuid": 5767296581747087377,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Supernailgun (62)",
            "classname": "weapon_supernailgun",
            "uuid": 12366420622513357432,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 4267827086893594938,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Secret (64)",
            "classname": "trigger_secret",
            "uuid": 16317636667913739847,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Shells (65)",
            "classname": "item_shells",
            "uuid": 11126574323008062349,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Spikes (66)",
            "classname": "item_spikes",
            "uuid": 16312286562092572991,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Quad Damage (67)",
            "classname": "item_artifact_super_damage",
            "uuid": 8970123547797685795,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Secret (68)",
            "classname": "trigger_secret",
            "uuid": 6881976871081895371,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Invulnerability (69)",
            "classname": "item_artifact_invulnerability",
            "uuid": 12249860442082853092,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Secret (70)",
            "classname": "trigger_secret",
            "uuid": 8748131738589919283,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "All Kills (71)",
            "classname": "all_kills",
            "uuid": 15837167611730766266,
            "mp": 0,
        },
    ]

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (38)",
                "Supershotgun (50)",
                "Large Medkit (39)",
                "Supershotgun (51)",
                "Spikes (42)",
                "Red Armor (52)",
                "Small Medkit (41)",
                "Small Medkit (40)",
            ],
        )

        past_door_area = self.region(
            "Past Door",
            [
                "Spikes (6)",
                "Rockets (5)",
                "Small Medkit (1)",
                "Small Medkit (2)",
                "Small Medkit (3)",
                "Small Medkit (4)",
                "Spikes (13)",
                "Large Medkit (14)",
            ],
        )
        self.connect(ret, past_door_area, r.can_door & r.can_dive)

        bridge_center_area = self.region(
            "Bridge Center",
            [
                "Small Medkit (11)",
                "Rocketlauncher (61)",
                "Large Medkit (24)",
                "Small Medkit (12)",
            ],
        )
        self.connect(past_door_area, bridge_center_area, r.can_button)

        bridge_one_area = self.region(
            "Bridge One",
            [],
        )
        self.connect(past_door_area, bridge_one_area, r.can_button)
        self.connect(bridge_one_area, bridge_center_area)

        bridge_two_area = self.region(
            "Bridge Two",
            [],
        )
        self.connect(bridge_two_area, bridge_center_area, r.can_door)
        self.connect(
            past_door_area,
            bridge_two_area,
            r.can_gj_extr | r.bigjump_hard,
        )

        bridge_three_side_area = self.region(
            "Bridge Three Side",
            [
                "Cells (56)",
                "Spikes (66)",
                "Cells (57)",
            ],
        )
        self.connect(bridge_two_area, bridge_three_side_area, r.can_door)

        bridge_three_secret_area = self.region(
            "Bridge Two Secret",
            [
                "Secret (43)",
                "Large Medkit (10)",
                "Spikes (7)",
                "Rockets (8)",
                "Supernailgun (53)",
                "Large Medkit (9)",
            ],
        )
        self.connect(
            bridge_three_side_area,
            bridge_three_secret_area,
            r.can_rj_hard
            | r.can_gj_extr
            | (r.can_jump & r.difficulty("hard"))
            | (r.can_shootswitch & r.jump),
        )

        bridge_three_area = self.region(
            "Bridge Three",
            [],
        )
        self.connect(
            bridge_two_area,
            bridge_three_area,
            r.can_jump | r.can_rj_hard | r.can_gj_extr,
        )
        self.connect(
            past_door_area,
            bridge_three_area,
            r.can_gj_extr | r.bigjump_hard,
        )
        self.connect(bridge_one_area, bridge_three_area)

        bridge_four_area = self.region(
            "Bridge Four",
            [],
        )
        self.connect(
            past_door_area,
            bridge_four_area,
            r.can_gj_extr | r.bigjump_hard,
        )

        bridge_four_upper_area = self.region(
            "Bridge Four Upper",
            [
                "Spikes (63)",
                "Supernailgun (62)",
                "Large Medkit (15)",
                "Shells (16)",
                "Large Medkit (60)",
                "Large Medkit (59)",
                "Large Medkit (25)",
                "Small Medkit (26)",
                "Large Medkit (29)",
                "Large Medkit (30)",
                "Spikes (31)",
            ],
        )
        # can double rj up the elevator shaft
        self.connect(
            bridge_four_area,
            bridge_four_upper_area,
            r.can_button | (r.can_rj & r.difficulty("extreme")),
        )
        self.restrict("Large Medkit (29)", r.can_shootswitch)
        self.restrict("Large Medkit (30)", r.can_shootswitch)
        self.restrict("Spikes (31)", r.can_shootswitch)

        bridge_four_door_secret = self.region(
            "Bridge Four Door Secret",
            [
                "Secret (64)",
                "Large Medkit (47)",
                "Quad Damage (46)",
                "Yellow Armor (45)",
                "Megahealth (44)",
                "Cells (48)",
                "Spikes (49)",
                "Secret (68)",
                "Invulnerability (69)",
                "Shells (65)",
            ],
        )
        self.connect(bridge_four_area, bridge_four_door_secret, r.can_door)
        self.restrict("Secret (68)", r.can_shootswitch)
        self.restrict("Invulnerability (69)", r.can_shootswitch)

        bridge_four_past_platform_ledge = self.region(
            "Bridge Four Past Platform Ledge",
            [
                "Spikes (36)",
                "Small Medkit (28)",
                "Grenadelauncher (54)",
                "Large Medkit (27)",
            ],
        )
        self.connect(
            bridge_four_upper_area,
            bridge_four_past_platform_ledge,
            r.can_rj_hard | r.can_gj_extr | (r.can_door & r.can_shootswitch),
        )

        bridge_side_area = self.region(
            "Bridge Side",
            [
                "Shells (23)",
                "Yellow Armor (22)",
            ],
        )
        self.connect(
            bridge_two_area,
            bridge_side_area,
            r.can_jump | r.can_rj_hard | r.can_gj_extr,
        )
        self.connect(
            bridge_three_area,
            bridge_side_area,
            r.can_jump | r.can_rj_hard | r.can_gj_extr,
        )
        self.connect(
            bridge_four_area,
            bridge_side_area,
            r.can_jump | r.can_rj_hard | r.can_gj_extr,
        )
        self.connect(bridge_two_area, bridge_four_area, r.can_door)
        self.connect(bridge_center_area, bridge_two_area)

        inside_elevator_area = self.region(
            "Inside Elevator",
            [
                "Secret (70)",
                "Invulnerability (37)",
                "Large Medkit (17)",
                "Large Medkit (18)",
                "Large Medkit (19)",
                "Rockets (20)",
                "Quad Damage (67)",
                "Lightning (55)",
                "Large Medkit (32)",
                "Large Medkit (33)",
                "Large Medkit (35)",
                "Large Medkit (34)",
                "Exit",
                "Secret Exit",
                "All Kills (71)",
            ],
        )
        # only requires can_button
        self.connect(
            bridge_four_past_platform_ledge,
            inside_elevator_area,
            r.can_button,
        )
        self.restrict("Exit", r.can_door)
        self.restrict("All Kills (71)", r.difficult_combat & r.can_shootswitch)

        return ret
