from BaseClasses import Region

from ..base_classes import Q1Level


class e3m1(Q1Level):
    name = "Termination Central"
    mapfile = "e3m1"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Large Medkit (1)",
            "classname": "item_health",
            "uuid": 16516616999455214758,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 15442238057551079222,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Large Medkit (3)",
            "classname": "item_health",
            "uuid": 14188635687365047045,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Spikes (4)",
            "classname": "item_spikes",
            "uuid": 2677984333715163751,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Rocketlauncher (5)",
            "classname": "weapon_rocketlauncher",
            "uuid": 6683072533252796410,
            "mp": 1,
        },
        {
            "id": 6,
            "name": "Rockets (6)",
            "classname": "item_rockets",
            "uuid": 2678988642259923586,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Megahealth (7)",
            "classname": "item_health",
            "uuid": 12086317370529752574,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Yellow Armor (8)",
            "classname": "item_armor2",
            "uuid": 14930888656428672161,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Small Medkit (9)",
            "classname": "item_health",
            "uuid": 7292369245221684921,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Small Medkit (10)",
            "classname": "item_health",
            "uuid": 12612077031167775892,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Small Medkit (11)",
            "classname": "item_health",
            "uuid": 9707293486074674581,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Rockets (12)",
            "classname": "item_rockets",
            "uuid": 1661881456035099471,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Spikes (13)",
            "classname": "item_spikes",
            "uuid": 3635499311497702663,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Grenadelauncher (14)",
            "classname": "weapon_grenadelauncher",
            "uuid": 12071426605678035613,
            "mp": 1,
        },
        {
            "id": 15,
            "name": "Supernailgun (15)",
            "classname": "weapon_supernailgun",
            "uuid": 9308030175008061872,
            "mp": 1,
        },
        {
            "id": 16,
            "name": "Rockets (16)",
            "classname": "item_rockets",
            "uuid": 7873405650416126208,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Megahealth (17)",
            "classname": "item_health",
            "uuid": 6889102557386895253,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Green Armor (18)",
            "classname": "item_armor1",
            "uuid": 16622237998391023817,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Red Armor (19)",
            "classname": "item_armorInv",
            "uuid": 17667924095980221537,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Nailgun (20)",
            "classname": "weapon_nailgun",
            "uuid": 3186826399623118170,
            "mp": 1,
        },
        {
            "id": 21,
            "name": "Shells (21)",
            "classname": "item_shells",
            "uuid": 7453356410242472206,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Shells (22)",
            "classname": "item_shells",
            "uuid": 9555030713612200198,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Large Medkit (23)",
            "classname": "item_health",
            "uuid": 7783777708112700693,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Supernailgun (24)",
            "classname": "weapon_supernailgun",
            "uuid": 6182852762388281700,
            "mp": 1,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 4787198854216051893,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 5210052303503297746,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Large Medkit (27)",
            "classname": "item_health",
            "uuid": 9699027497338137482,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Yellow Armor (28)",
            "classname": "item_armor2",
            "uuid": 16436922688247014466,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Large Medkit (29)",
            "classname": "item_health",
            "uuid": 9228066441097601186,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Rockets (30)",
            "classname": "item_rockets",
            "uuid": 15664964743461602976,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Supershotgun (31)",
            "classname": "weapon_supershotgun",
            "uuid": 10630380121128186475,
            "mp": 1,
        },
        {
            "id": 32,
            "name": "Shells (32)",
            "classname": "item_shells",
            "uuid": 4845147756100967202,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Shells (33)",
            "classname": "item_shells",
            "uuid": 2313013391183618821,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Spikes (34)",
            "classname": "item_spikes",
            "uuid": 2366776208992213047,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Spikes (35)",
            "classname": "item_spikes",
            "uuid": 1257520226583369025,
            "mp": 1,
        },
        {
            "id": 36,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 5832564994159472915,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Small Medkit (37)",
            "classname": "item_health",
            "uuid": 15641146409056648327,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Gold Key (38)",
            "classname": "item_key2",
            "uuid": 16066953385567158606,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Large Medkit (39)",
            "classname": "item_health",
            "uuid": 5809863925960966760,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Large Medkit (40)",
            "classname": "item_health",
            "uuid": 12059473840989762280,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Shells (41)",
            "classname": "item_shells",
            "uuid": 201298952779908027,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Supershotgun (42)",
            "classname": "weapon_supershotgun",
            "uuid": 4163256571401983043,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Nailgun (43)",
            "classname": "weapon_nailgun",
            "uuid": 3990182363532762912,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Quad Damage (44)",
            "classname": "item_artifact_super_damage",
            "uuid": 16338983740168489114,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Quad Damage (45)",
            "classname": "item_artifact_super_damage",
            "uuid": 14291797361214090615,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Green Armor (46)",
            "classname": "item_armor1",
            "uuid": 4200234268007470713,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 12078726096416146604,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Shells (48)",
            "classname": "item_shells",
            "uuid": 9883090468649386331,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 9154770624913914099,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Small Medkit (50)",
            "classname": "item_health",
            "uuid": 5072810650167464259,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Spikes (51)",
            "classname": "item_spikes",
            "uuid": 9797472352449628742,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Shells (52)",
            "classname": "item_shells",
            "uuid": 7753248097149485814,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 17084693434095954360,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Small Medkit (54)",
            "classname": "item_health",
            "uuid": 6020445082679639521,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 9846202420692746251,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Shells (56)",
            "classname": "item_shells",
            "uuid": 5281843351698648979,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Shells (57)",
            "classname": "item_shells",
            "uuid": 5702138654219898667,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Large Medkit (58)",
            "classname": "item_health",
            "uuid": 3958568912403274662,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 12616109620160718222,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Shells (60)",
            "classname": "item_shells",
            "uuid": 1268359870433803863,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Secret (61)",
            "classname": "trigger_secret",
            "uuid": 12759077521437223836,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Secret (62)",
            "classname": "trigger_secret",
            "uuid": 14723449306927620352,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Secret (63)",
            "classname": "trigger_secret",
            "uuid": 12520016227427500534,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Secret (64)",
            "classname": "trigger_secret",
            "uuid": 2162669062525448262,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Secret (65)",
            "classname": "trigger_secret",
            "uuid": 14278742974188753230,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Lightning (66)",
            "classname": "weapon_lightning",
            "uuid": 7228532801768133666,
            "mp": 1,
        },
        {
            "id": 67,
            "name": "Shells (67)",
            "classname": "item_shells",
            "uuid": 8938874537906311231,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Shells (68)",
            "classname": "item_shells",
            "uuid": 9100358417890498563,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "All Kills (69)",
            "classname": "all_kills",
            "uuid": 14207242401891380029,
            "mp": 0,
        },
    ]

    must_bio = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Small Medkit (37)",
                "Shells (67)",
                "Supershotgun (42)",
            ],
        )

        past_button_area = self.region(
            "Past Button",
            [
                "Shells (68)",
                "Green Armor (46)",
                "Shells (48)",
                "Spikes (47)",
                "Nailgun (43)",
                "Large Medkit (58)",
                "Large Medkit (59)",
                "Nailgun (20)",
                "Large Medkit (25)",
                "Large Medkit (26)",
                "Rockets (6)",
                "Shells (60)",
                "Large Medkit (27)",
                "Yellow Armor (8)",
                "Spikes (51)",
                "Shells (52)",
                "Small Medkit (9)",
                "Small Medkit (10)",
                "Small Medkit (11)",
                "Secret (65)",
                "Red Armor (19)",
            ],
        )
        self.connect(ret, past_button_area, r.can_button)
        self.restrict("Secret (65)", r.can_shootswitch)
        self.restrict("Red Armor (19)", r.can_shootswitch)

        past_button_upper_area = self.region(
            "Past Button Upper",
            [
                "Large Medkit (55)",
                "Shells (57)",
                "Small Medkit (54)",
                "Large Medkit (53)",
            ],
        )
        self.connect(
            past_button_area,
            past_button_upper_area,
            r.can_door | r.bigjump_hard,
        )

        center_platform_area = self.region(
            "Center Platform Area",
            [
                "Rockets (12)",
                "Spikes (13)",
                "Quad Damage (44)",
                "Secret (61)",
                "Rockets (30)",
                "Yellow Armor (28)",
                "Large Medkit (29)",
                "Shells (32)",
                "Supershotgun (31)",
                "Shells (33)",
                "Large Medkit (23)",
                "Spikes (35)",
                "Spikes (34)",
                "Shells (22)",
                "Shells (21)",
                "Secret (64)",
                "Quad Damage (45)",
                "Lightning (66)",
                "Gold Key (38)",
                "Supernailgun (24)",
                "Rocketlauncher (5)",
                "Large Medkit (49)",
                "Small Medkit (50)",
                "Secret (63)",
                "Megahealth (7)",
            ],
        )
        self.connect(
            past_button_area,
            center_platform_area,
            r.can_door
            | (r.can_jump & r.difficulty("medium"))
            | (r.can_rj_hard | r.can_gj_extr),
        )
        self.restrict(
            "Secret (63)",
            (r.jump & r.can_shootswitch) | (r.difficulty("hard") & r.bigjump),
        )
        self.restrict(
            "Megahealth (7)",
            (r.jump & r.can_shootswitch) | (r.difficulty("hard") & r.bigjump),
        )

        underwater_area = self.region(
            "Underwater Secret",
            [
                "Secret (62)",
                "Large Medkit (1)",
                "Large Medkit (2)",
                "Large Medkit (3)",
                "Rockets (16)",
                "Spikes (4)",
                "Supernailgun (15)",
                "Grenadelauncher (14)",
                "Green Armor (18)",
                "Megahealth (17)",
            ],
        )
        self.connect(
            center_platform_area,
            underwater_area,
            r.can_dive & (r.difficulty("hard") | r.biosuit(1)),
        )

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Shells (41)",
                "Large Medkit (40)",
                "Large Medkit (39)",
                "Shells (56)",
                "Exit",
                "All Kills (69)",
            ],
        )
        self.connect(center_platform_area, past_gold_door_area, self.gold_key)
        self.restrict("Large Medkit (39)", r.jump)
        self.restrict("Large Medkit (40)", r.jump)
        self.restrict("All Kills (69)", r.backpack(5))

        return ret
