from BaseClasses import Region

from ..base_classes import Q1Level


class e2m7(Q1Level):
    name = "The Underearth"
    mapfile = "e2m7"
    keys = ["Gold"]
    location_defs = [
        {
            "id": 1,
            "name": "Spikes (1)",
            "classname": "item_spikes",
            "uuid": 5506076755741055268,
            "mp": 0,
        },
        {
            "id": 2,
            "name": "Large Medkit (2)",
            "classname": "item_health",
            "uuid": 15153071916610745587,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Biosuit (3)",
            "classname": "item_artifact_envirosuit",
            "uuid": 9685253666884761727,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Green Armor (4)",
            "classname": "item_armor1",
            "uuid": 3592775904195654432,
            "mp": 0,
        },
        {
            "id": 5,
            "name": "Gold Key (5)",
            "classname": "item_key2",
            "uuid": 17505059559382954955,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Large Medkit (6)",
            "classname": "item_health",
            "uuid": 543442834685369039,
            "mp": 0,
        },
        {
            "id": 7,
            "name": "Shells (7)",
            "classname": "item_shells",
            "uuid": 12135123203477522662,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Small Medkit (8)",
            "classname": "item_health",
            "uuid": 13995392887044954973,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 16567576157844677221,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Spikes (10)",
            "classname": "item_spikes",
            "uuid": 15640291878183071821,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Rockets (11)",
            "classname": "item_rockets",
            "uuid": 12216991681049746505,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 832410322792954280,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 3993849268642553407,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Megahealth (14)",
            "classname": "item_health",
            "uuid": 16366759151417885121,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Spikes (15)",
            "classname": "item_spikes",
            "uuid": 9847115893303509826,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Shells (16)",
            "classname": "item_shells",
            "uuid": 3222295065869118272,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 1950175580757361607,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Spikes (18)",
            "classname": "item_spikes",
            "uuid": 294750384489901980,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Small Medkit (19)",
            "classname": "item_health",
            "uuid": 1892879435916548686,
            "mp": 0,
        },
        {
            "id": 20,
            "name": "Small Medkit (20)",
            "classname": "item_health",
            "uuid": 6699712898611245035,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Small Medkit (21)",
            "classname": "item_health",
            "uuid": 15447249109240516034,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Small Medkit (22)",
            "classname": "item_health",
            "uuid": 3496613952393144871,
            "mp": 0,
        },
        {
            "id": 23,
            "name": "Shells (23)",
            "classname": "item_shells",
            "uuid": 18382324421516865367,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Spikes (24)",
            "classname": "item_spikes",
            "uuid": 15666044882271238125,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Spikes (25)",
            "classname": "item_spikes",
            "uuid": 3901976768683527216,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Shells (26)",
            "classname": "item_shells",
            "uuid": 17889122834081775565,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Small Medkit (27)",
            "classname": "item_health",
            "uuid": 12379227164357998896,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Small Medkit (28)",
            "classname": "item_health",
            "uuid": 11209214137571169683,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Shells (29)",
            "classname": "item_shells",
            "uuid": 5372377732044282179,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Large Medkit (30)",
            "classname": "item_health",
            "uuid": 13506207743840558670,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Large Medkit (31)",
            "classname": "item_health",
            "uuid": 6799045913983443432,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Rockets (32)",
            "classname": "item_rockets",
            "uuid": 10995398301435313574,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Secret (33)",
            "classname": "trigger_secret",
            "uuid": 1977744950408409042,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Large Medkit (34)",
            "classname": "item_health",
            "uuid": 3766771130852875363,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Large Medkit (35)",
            "classname": "item_health",
            "uuid": 17846438637198099285,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Shells (36)",
            "classname": "item_shells",
            "uuid": 6961977827431273200,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Spikes (37)",
            "classname": "item_spikes",
            "uuid": 2997369774320052187,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Spikes (38)",
            "classname": "item_spikes",
            "uuid": 18238975780298653982,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Shells (39)",
            "classname": "item_shells",
            "uuid": 8920423762395592467,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 4167041121841351791,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Shells (41)",
            "classname": "item_shells",
            "uuid": 7777444462606297988,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Shells (42)",
            "classname": "item_shells",
            "uuid": 11509512229747853777,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Spikes (43)",
            "classname": "item_spikes",
            "uuid": 626160883427904120,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Large Medkit (44)",
            "classname": "item_health",
            "uuid": 6944920635761698871,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Shells (45)",
            "classname": "item_shells",
            "uuid": 4321467412949602949,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Shells (46)",
            "classname": "item_shells",
            "uuid": 12008063550092289251,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Spikes (47)",
            "classname": "item_spikes",
            "uuid": 6483107068458535607,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 4859229090013149696,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Small Medkit (49)",
            "classname": "item_health",
            "uuid": 8813745881922423162,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Spikes (50)",
            "classname": "item_spikes",
            "uuid": 7285326100784638794,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 9261496538540954856,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Quad Damage (52)",
            "classname": "item_artifact_super_damage",
            "uuid": 14178000831423101906,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Shells (53)",
            "classname": "item_shells",
            "uuid": 7933971214586838852,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Large Medkit (54)",
            "classname": "item_health",
            "uuid": 4814816362952257710,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Large Medkit (55)",
            "classname": "item_health",
            "uuid": 15158418311972107139,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 4052652288708280049,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Small Medkit (57)",
            "classname": "item_health",
            "uuid": 9879966802636656023,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Red Armor (58)",
            "classname": "item_armorInv",
            "uuid": 725552701505108823,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Large Medkit (59)",
            "classname": "item_health",
            "uuid": 9691544526579996923,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Large Medkit (60)",
            "classname": "item_health",
            "uuid": 16385141640680645940,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Spikes (61)",
            "classname": "item_spikes",
            "uuid": 5848876143361244732,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Spikes (62)",
            "classname": "item_spikes",
            "uuid": 7037987064361026138,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 3416344642632648918,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Spikes (64)",
            "classname": "item_spikes",
            "uuid": 16249987287956900954,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Spikes (65)",
            "classname": "item_spikes",
            "uuid": 320480766835233684,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Shells (66)",
            "classname": "item_shells",
            "uuid": 15853461067124236240,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Large Medkit (67)",
            "classname": "item_health",
            "uuid": 16577351596497426588,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Large Medkit (68)",
            "classname": "item_health",
            "uuid": 1503133359482230685,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Rockets (69)",
            "classname": "item_rockets",
            "uuid": 5962696038945025091,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Large Medkit (70)",
            "classname": "item_health",
            "uuid": 15705152845754735064,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Large Medkit (71)",
            "classname": "item_health",
            "uuid": 1485457539198811885,
            "mp": 0,
        },
        {
            "id": 72,
            "name": "Large Medkit (72)",
            "classname": "item_health",
            "uuid": 2793601730872306754,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Secret (73)",
            "classname": "trigger_secret",
            "uuid": 9465307931777423080,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Shells (74)",
            "classname": "item_shells",
            "uuid": 13831658684323492934,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Shells (75)",
            "classname": "item_shells",
            "uuid": 18283135635060818977,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Shells (76)",
            "classname": "item_shells",
            "uuid": 8154411402514494031,
            "mp": 0,
        },
        {
            "id": 77,
            "name": "Shells (77)",
            "classname": "item_shells",
            "uuid": 17611431689939228054,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 9844584155773243055,
            "mp": 0,
        },
        {
            "id": 79,
            "name": "Spikes (79)",
            "classname": "item_spikes",
            "uuid": 5916900067991533679,
            "mp": 0,
        },
        {
            "id": 80,
            "name": "Spikes (80)",
            "classname": "item_spikes",
            "uuid": 617090302250328024,
            "mp": 0,
        },
        {
            "id": 81,
            "name": "Large Medkit (81)",
            "classname": "item_health",
            "uuid": 6234793967497428985,
            "mp": 0,
        },
        {
            "id": 82,
            "name": "Shells (82)",
            "classname": "item_shells",
            "uuid": 6899532113586734777,
            "mp": 0,
        },
        {
            "id": 83,
            "name": "Small Medkit (83)",
            "classname": "item_health",
            "uuid": 10763550858717743755,
            "mp": 0,
        },
        {
            "id": 84,
            "name": "Biosuit (84)",
            "classname": "item_artifact_envirosuit",
            "uuid": 8006553002028633896,
            "mp": 0,
        },
        {
            "id": 85,
            "name": "Rocketlauncher (85)",
            "classname": "weapon_rocketlauncher",
            "uuid": 18048136435755877871,
            "mp": 1,
        },
        {
            "id": 86,
            "name": "Supernailgun (86)",
            "classname": "weapon_supernailgun",
            "uuid": 7953751833209469059,
            "mp": 1,
        },
        {
            "id": 87,
            "name": "Supershotgun (87)",
            "classname": "weapon_supershotgun",
            "uuid": 9540250148447797750,
            "mp": 1,
        },
        {
            "id": 88,
            "name": "Grenadelauncher (88)",
            "classname": "weapon_grenadelauncher",
            "uuid": 3591828405612118248,
            "mp": 1,
        },
        {
            "id": 89,
            "name": "Nailgun (89)",
            "classname": "weapon_nailgun",
            "uuid": 12353378747528263539,
            "mp": 1,
        },
        {
            "id": 90,
            "name": "Supershotgun (90)",
            "classname": "weapon_supershotgun",
            "uuid": 14225011593607441172,
            "mp": 1,
        },
        {
            "id": 91,
            "name": "Nailgun (91)",
            "classname": "weapon_nailgun",
            "uuid": 11057147887971540955,
            "mp": 1,
        },
        {
            "id": 92,
            "name": "Lightning (92)",
            "classname": "weapon_lightning",
            "uuid": 492775654795814201,
            "mp": 1,
        },
        {
            "id": 93,
            "name": "Cells (93)",
            "classname": "item_cells",
            "uuid": 11457602250391827173,
            "mp": 1,
        },
        {
            "id": 94,
            "name": "Cells (94)",
            "classname": "item_cells",
            "uuid": 17765114146387552609,
            "mp": 1,
        },
        {
            "id": 95,
            "name": "Cells (95)",
            "classname": "item_cells",
            "uuid": 12309245536696033578,
            "mp": 1,
        },
        {
            "id": 96,
            "name": "Cells (96)",
            "classname": "item_cells",
            "uuid": 1207472225012972233,
            "mp": 1,
        },
        {
            "id": 97,
            "name": "Shells (97)",
            "classname": "item_shells",
            "uuid": 4280984393795281799,
            "mp": 0,
        },
        {
            "id": 98,
            "name": "Large Medkit (98)",
            "classname": "item_health",
            "uuid": 2098076584472099150,
            "mp": 0,
        },
        {
            "id": 99,
            "name": "Green Armor (99)",
            "classname": "item_armor1",
            "uuid": 730127992766889314,
            "mp": 0,
        },
        {
            "id": 100,
            "name": "Spikes (100)",
            "classname": "item_spikes",
            "uuid": 8306451280421764970,
            "mp": 0,
        },
        {
            "id": 101,
            "name": "Rockets (101)",
            "classname": "item_rockets",
            "uuid": 1849345455044611091,
            "mp": 0,
        },
        {
            "id": 102,
            "name": "Grenadelauncher (102)",
            "classname": "weapon_grenadelauncher",
            "uuid": 9908961183806781157,
            "mp": 0,
        },
        {
            "id": 103,
            "name": "Spikes (103)",
            "classname": "item_spikes",
            "uuid": 2142666417042596695,
            "mp": 0,
        },
        {
            "id": 104,
            "name": "All Kills (104)",
            "classname": "all_kills",
            "uuid": 1547659220196547485,
            "mp": 0,
        },
    ]

    must_bio = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Cells (96)",
                "Shells (7)",
                "Large Medkit (6)",
                "Large Medkit (2)",
                "Spikes (1)",
                "Small Medkit (8)",
                "Large Medkit (9)",
                "Spikes (10)",
                "Spikes (79)",
                "Rockets (11)",
                "Shells (46)",
                "Shells (29)",
                "Spikes (61)",
                "Large Medkit (12)",
                "Grenadelauncher (88)",
                "Large Medkit (68)",
            ],
        )

        first_dive_area = self.region(
            "First Dive",
            [
                "Spikes (40)",
                "Large Medkit (30)",
                "Large Medkit (31)",
                "Shells (45)",
                "Grenadelauncher (102)",
                "Spikes (103)",
                "Rockets (32)",
                "Cells (93)",
                "Shells (53)",
                "Large Medkit (35)",
                "Large Medkit (34)",
                "Shells (82)",
                "Shells (74)",
                "Spikes (37)",
                "Nailgun (91)",
                "Spikes (38)",
                "Shells (16)",
                "Megahealth (14)",
                "Shells (23)",
                "Shells (97)",
                "Shells (39)",
                "Large Medkit (54)",
                "Spikes (63)",
                "Spikes (62)",
                "Small Medkit (28)",
                "Small Medkit (27)",
                "Shells (75)",
                "Supernailgun (86)",
                "Spikes (25)",
                "Spikes (24)",
                "Shells (26)",
                "Large Medkit (55)",
                "Gold Key (5)",
                "Large Medkit (72)",
                "Large Medkit (71)",
                "Large Medkit (13)",
                "Spikes (15)",
                "Green Armor (4)",
                "Shells (36)",
                "Lightning (92)",
                "Quad Damage (52)",
                "Secret (33)",
            ],
        )
        self.connect(ret, first_dive_area, r.can_dive)
        self.restrict("Large Medkit (72)", r.biosuit(1) | r.difficulty("hard"))
        self.restrict("Large Medkit (71)", r.biosuit(1) | r.difficulty("hard"))
        self.restrict("Large Medkit (13)", r.can_door)
        self.restrict("Spikes (15)", r.can_door)
        self.restrict("Green Armor (4)", r.can_button & r.can_door)
        self.restrict("Shells (36)", r.can_button)
        self.restrict("Lightning (92)", r.can_button)
        self.restrict("Quad Damage (52)", r.can_button & r.can_door)
        self.restrict("Secret (33)", r.can_button)

        past_gold_door_area = self.region(
            "Past Gold Door",
            [
                "Spikes (48)",
                "Spikes (47)",
                "Nailgun (89)",
                "Small Medkit (49)",
                "Spikes (50)",
                "Large Medkit (17)",
                "Biosuit (3)",
                "Spikes (18)",
                # underwater area
                "Secret (73)",
                "Red Armor (58)",
            ],
        )
        self.connect(first_dive_area, past_gold_door_area, self.gold_key)
        self.restrict("Secret (73)", r.can_dive)
        self.restrict("Red Armor (58)", r.can_dive)

        gold_ledge_area = self.region(
            "Gold Ledge",
            [
                "Cells (95)",
                "Shells (51)",
                "Supershotgun (87)",
                "Large Medkit (44)",
                "Small Medkit (19)",
                "Shells (42)",
                "Shells (41)",
                "Small Medkit (20)",
                "Small Medkit (21)",
                "Spikes (43)",
                "Biosuit (84)",
                "Small Medkit (22)",
                "Green Armor (99)",
                "Spikes (65)",
                "Spikes (64)",
                "Large Medkit (98)",
                "Supershotgun (90)",
                "Shells (76)",
                "Shells (77)",
            ],
        )
        self.connect(first_dive_area, gold_ledge_area, r.jump & r.difficulty("medium"))
        self.connect(past_gold_door_area, gold_ledge_area, r.can_button)

        gold_button_area = self.region(
            "Gold Button Area",
            [
                "Rocketlauncher (85)",
                "Small Medkit (57)",
                "Large Medkit (56)",
                "Spikes (100)",
                "Shells (66)",
                "Small Medkit (83)",
                "Cells (94)",
                "Large Medkit (81)",
                "Spikes (80)",
                "Large Medkit (59)",
                "Large Medkit (60)",
                "Rockets (69)",
                "Large Medkit (70)",
                "Large Medkit (67)",
                "Rockets (101)",
                "Exit",
                "All Kills (104)",
            ],
        )
        self.connect(gold_ledge_area, gold_button_area, r.can_button)
        self.restrict("Exit", r.can_door)
        self.restrict("All Kills (104)", r.difficult_combat)

        return ret
