from BaseClasses import Region

from ..base_classes import Q1Level


class e1m8(Q1Level):
    name = "Ziggurat Vertigo"
    mapfile = "e1m8"
    keys = ["Silver"]
    location_defs = [
        {
            "id": 1,
            "name": "Grenadelauncher (1)",
            "classname": "weapon_grenadelauncher",
            "uuid": 13748432654039285841,
            "mp": 1,
        },
        {
            "id": 2,
            "name": "Rockets (2)",
            "classname": "item_rockets",
            "uuid": 3230714329791275805,
            "mp": 0,
        },
        {
            "id": 3,
            "name": "Spikes (3)",
            "classname": "item_spikes",
            "uuid": 17345594752358627630,
            "mp": 0,
        },
        {
            "id": 4,
            "name": "Rocketlauncher (4)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4711197428166807244,
            "mp": 1,
        },
        {
            "id": 5,
            "name": "Rockets (5)",
            "classname": "item_rockets",
            "uuid": 5444658399046166699,
            "mp": 0,
        },
        {
            "id": 6,
            "name": "Supershotgun (6)",
            "classname": "weapon_supershotgun",
            "uuid": 10315518758964737078,
            "mp": 1,
        },
        {
            "id": 7,
            "name": "Yellow Armor (7)",
            "classname": "item_armor2",
            "uuid": 13782074107944263227,
            "mp": 0,
        },
        {
            "id": 8,
            "name": "Large Medkit (8)",
            "classname": "item_health",
            "uuid": 13273672344179031343,
            "mp": 0,
        },
        {
            "id": 9,
            "name": "Large Medkit (9)",
            "classname": "item_health",
            "uuid": 11248599123158700997,
            "mp": 0,
        },
        {
            "id": 10,
            "name": "Megahealth (10)",
            "classname": "item_health",
            "uuid": 12658764936931704945,
            "mp": 0,
        },
        {
            "id": 11,
            "name": "Large Medkit (11)",
            "classname": "item_health",
            "uuid": 8065225929330867770,
            "mp": 0,
        },
        {
            "id": 12,
            "name": "Large Medkit (12)",
            "classname": "item_health",
            "uuid": 16648579268223255289,
            "mp": 0,
        },
        {
            "id": 13,
            "name": "Large Medkit (13)",
            "classname": "item_health",
            "uuid": 14567939257058118992,
            "mp": 0,
        },
        {
            "id": 14,
            "name": "Large Medkit (14)",
            "classname": "item_health",
            "uuid": 833059879527747793,
            "mp": 0,
        },
        {
            "id": 15,
            "name": "Spikes (15)",
            "classname": "item_spikes",
            "uuid": 5702487509324462449,
            "mp": 0,
        },
        {
            "id": 16,
            "name": "Large Medkit (16)",
            "classname": "item_health",
            "uuid": 11447271575798594211,
            "mp": 0,
        },
        {
            "id": 17,
            "name": "Large Medkit (17)",
            "classname": "item_health",
            "uuid": 15989343262846705119,
            "mp": 0,
        },
        {
            "id": 18,
            "name": "Large Medkit (18)",
            "classname": "item_health",
            "uuid": 13285867727877715171,
            "mp": 0,
        },
        {
            "id": 19,
            "name": "Supernailgun (19)",
            "classname": "weapon_supernailgun",
            "uuid": 8821821751125152687,
            "mp": 1,
        },
        {
            "id": 20,
            "name": "Spikes (20)",
            "classname": "item_spikes",
            "uuid": 15018728453806850355,
            "mp": 0,
        },
        {
            "id": 21,
            "name": "Yellow Armor (21)",
            "classname": "item_armor2",
            "uuid": 15168146944875705885,
            "mp": 0,
        },
        {
            "id": 22,
            "name": "Nailgun (22)",
            "classname": "weapon_nailgun",
            "uuid": 15073085810024527273,
            "mp": 1,
        },
        {
            "id": 23,
            "name": "Megahealth (23)",
            "classname": "item_health",
            "uuid": 6888257311223346275,
            "mp": 0,
        },
        {
            "id": 24,
            "name": "Rocketlauncher (24)",
            "classname": "weapon_rocketlauncher",
            "uuid": 4532343415672178916,
            "mp": 0,
        },
        {
            "id": 25,
            "name": "Large Medkit (25)",
            "classname": "item_health",
            "uuid": 13807362421615428961,
            "mp": 0,
        },
        {
            "id": 26,
            "name": "Large Medkit (26)",
            "classname": "item_health",
            "uuid": 17422055397140656971,
            "mp": 0,
        },
        {
            "id": 27,
            "name": "Shells (27)",
            "classname": "item_shells",
            "uuid": 9308779725359452693,
            "mp": 0,
        },
        {
            "id": 28,
            "name": "Shells (28)",
            "classname": "item_shells",
            "uuid": 7399028885895195761,
            "mp": 0,
        },
        {
            "id": 29,
            "name": "Shells (29)",
            "classname": "item_shells",
            "uuid": 5435864409860796587,
            "mp": 0,
        },
        {
            "id": 30,
            "name": "Shells (30)",
            "classname": "item_shells",
            "uuid": 13289721413964005393,
            "mp": 0,
        },
        {
            "id": 31,
            "name": "Shells (31)",
            "classname": "item_shells",
            "uuid": 5027433959150270507,
            "mp": 0,
        },
        {
            "id": 32,
            "name": "Spikes (32)",
            "classname": "item_spikes",
            "uuid": 12692023064417009154,
            "mp": 0,
        },
        {
            "id": 33,
            "name": "Rockets (33)",
            "classname": "item_rockets",
            "uuid": 11751832633466089995,
            "mp": 0,
        },
        {
            "id": 34,
            "name": "Rockets (34)",
            "classname": "item_rockets",
            "uuid": 7075757906497084114,
            "mp": 0,
        },
        {
            "id": 35,
            "name": "Shells (35)",
            "classname": "item_shells",
            "uuid": 17935151651100781682,
            "mp": 0,
        },
        {
            "id": 36,
            "name": "Invulnerability (36)",
            "classname": "item_artifact_invulnerability",
            "uuid": 13552865542031247011,
            "mp": 0,
        },
        {
            "id": 37,
            "name": "Invulnerability (37)",
            "classname": "item_artifact_invulnerability",
            "uuid": 10538749317853245255,
            "mp": 0,
        },
        {
            "id": 38,
            "name": "Exit",
            "classname": "trigger_changelevel",
            "uuid": 12022829008672503901,
            "mp": 0,
        },
        {
            "id": 39,
            "name": "Yellow Armor (39)",
            "classname": "item_armor2",
            "uuid": 16842384694503906482,
            "mp": 0,
        },
        {
            "id": 40,
            "name": "Spikes (40)",
            "classname": "item_spikes",
            "uuid": 4738169398191336617,
            "mp": 0,
        },
        {
            "id": 41,
            "name": "Spikes (41)",
            "classname": "item_spikes",
            "uuid": 2690029500166433221,
            "mp": 0,
        },
        {
            "id": 42,
            "name": "Small Medkit (42)",
            "classname": "item_health",
            "uuid": 2837243285030373951,
            "mp": 0,
        },
        {
            "id": 43,
            "name": "Small Medkit (43)",
            "classname": "item_health",
            "uuid": 15967669841711129418,
            "mp": 0,
        },
        {
            "id": 44,
            "name": "Spikes (44)",
            "classname": "item_spikes",
            "uuid": 7568105626152537862,
            "mp": 0,
        },
        {
            "id": 45,
            "name": "Spikes (45)",
            "classname": "item_spikes",
            "uuid": 8608823350815777412,
            "mp": 0,
        },
        {
            "id": 46,
            "name": "Large Medkit (46)",
            "classname": "item_health",
            "uuid": 12162642169332139638,
            "mp": 0,
        },
        {
            "id": 47,
            "name": "Large Medkit (47)",
            "classname": "item_health",
            "uuid": 17015296049709951494,
            "mp": 0,
        },
        {
            "id": 48,
            "name": "Spikes (48)",
            "classname": "item_spikes",
            "uuid": 4383152708747793930,
            "mp": 0,
        },
        {
            "id": 49,
            "name": "Large Medkit (49)",
            "classname": "item_health",
            "uuid": 6835023152266227502,
            "mp": 0,
        },
        {
            "id": 50,
            "name": "Large Medkit (50)",
            "classname": "item_health",
            "uuid": 4860013532052757473,
            "mp": 0,
        },
        {
            "id": 51,
            "name": "Shells (51)",
            "classname": "item_shells",
            "uuid": 17321534370021331874,
            "mp": 0,
        },
        {
            "id": 52,
            "name": "Large Medkit (52)",
            "classname": "item_health",
            "uuid": 5704586635070548060,
            "mp": 0,
        },
        {
            "id": 53,
            "name": "Large Medkit (53)",
            "classname": "item_health",
            "uuid": 4444291412700364671,
            "mp": 0,
        },
        {
            "id": 54,
            "name": "Small Medkit (54)",
            "classname": "item_health",
            "uuid": 3070105521233970595,
            "mp": 0,
        },
        {
            "id": 55,
            "name": "Small Medkit (55)",
            "classname": "item_health",
            "uuid": 1965632760231343048,
            "mp": 0,
        },
        {
            "id": 56,
            "name": "Large Medkit (56)",
            "classname": "item_health",
            "uuid": 14685282622712768323,
            "mp": 0,
        },
        {
            "id": 57,
            "name": "Large Medkit (57)",
            "classname": "item_health",
            "uuid": 13788288464192869903,
            "mp": 0,
        },
        {
            "id": 58,
            "name": "Spikes (58)",
            "classname": "item_spikes",
            "uuid": 18112509827145068323,
            "mp": 0,
        },
        {
            "id": 59,
            "name": "Spikes (59)",
            "classname": "item_spikes",
            "uuid": 2702479470075095623,
            "mp": 0,
        },
        {
            "id": 60,
            "name": "Rocketlauncher (60)",
            "classname": "weapon_rocketlauncher",
            "uuid": 669521520310419631,
            "mp": 0,
        },
        {
            "id": 61,
            "name": "Spikes (61)",
            "classname": "item_spikes",
            "uuid": 14840412006420320406,
            "mp": 0,
        },
        {
            "id": 62,
            "name": "Silver Key (62)",
            "classname": "item_key1",
            "uuid": 10565053454298139410,
            "mp": 0,
        },
        {
            "id": 63,
            "name": "Spikes (63)",
            "classname": "item_spikes",
            "uuid": 2038197104689467640,
            "mp": 0,
        },
        {
            "id": 64,
            "name": "Large Medkit (64)",
            "classname": "item_health",
            "uuid": 4302595711235946259,
            "mp": 0,
        },
        {
            "id": 65,
            "name": "Large Medkit (65)",
            "classname": "item_health",
            "uuid": 9596834520189681289,
            "mp": 0,
        },
        {
            "id": 66,
            "name": "Spikes (66)",
            "classname": "item_spikes",
            "uuid": 6804227111398229741,
            "mp": 0,
        },
        {
            "id": 67,
            "name": "Spikes (67)",
            "classname": "item_spikes",
            "uuid": 10024928971650231405,
            "mp": 0,
        },
        {
            "id": 68,
            "name": "Spikes (68)",
            "classname": "item_spikes",
            "uuid": 12114674601880544855,
            "mp": 0,
        },
        {
            "id": 69,
            "name": "Secret (69)",
            "classname": "trigger_secret",
            "uuid": 6032774890112658051,
            "mp": 0,
        },
        {
            "id": 70,
            "name": "Spikes (70)",
            "classname": "item_spikes",
            "uuid": 6983467886318877296,
            "mp": 0,
        },
        {
            "id": 71,
            "name": "Invisibility (71)",
            "classname": "item_artifact_invisibility",
            "uuid": 3524584551502221936,
            "mp": 1,
        },
        {
            "id": 72,
            "name": "Secret (72)",
            "classname": "trigger_secret",
            "uuid": 7000675383923657245,
            "mp": 0,
        },
        {
            "id": 73,
            "name": "Quad Damage (73)",
            "classname": "item_artifact_super_damage",
            "uuid": 18026075504817337973,
            "mp": 0,
        },
        {
            "id": 74,
            "name": "Large Medkit (74)",
            "classname": "item_health",
            "uuid": 9555590814849064854,
            "mp": 0,
        },
        {
            "id": 75,
            "name": "Large Medkit (75)",
            "classname": "item_health",
            "uuid": 2485970645984993126,
            "mp": 0,
        },
        {
            "id": 76,
            "name": "Supernailgun (76)",
            "classname": "weapon_supernailgun",
            "uuid": 11680553681867584968,
            "mp": 1,
        },
        {
            "id": 77,
            "name": "Small Medkit (77)",
            "classname": "item_health",
            "uuid": 5023755755520268296,
            "mp": 0,
        },
        {
            "id": 78,
            "name": "All Kills (78)",
            "classname": "all_kills",
            "uuid": 17836725082810317339,
            "mp": 0,
        },
    ]
    must_invuln = True

    def main_region(self) -> Region:
        r = self.rules

        ret = self.region(
            self.name,
            [
                "Large Medkit (65)",
                "Invulnerability (36)",
                "Yellow Armor (39)",
                "Shells (29)",
                "Spikes (3)",
                "Supernailgun (76)",
                "Large Medkit (64)",
                "Spikes (59)",
                "Shells (30)",
                "Large Medkit (14)",
                "Large Medkit (13)",
                "Grenadelauncher (1)",
                "Large Medkit (50)",
                "Large Medkit (49)",
                "Shells (51)",
                "Rockets (2)",
                "Rocketlauncher (60)",
                "Small Medkit (42)",
                "Small Medkit (43)",
                "Spikes (40)",
                "Nailgun (22)",
                "Spikes (41)",
            ],
        )

        first_room_roof = self.region(
            "First Room Roof Area",
            [
                "Spikes (48)",
                "Supernailgun (19)",
                "Rockets (34)",
                "Spikes (20)",
                "Yellow Armor (21)",
                "Small Medkit (77)",
                "Megahealth (10)",
            ],
        )
        self.connect(ret, first_room_roof, r.can_jump | r.can_gj_med | r.can_rj_med)

        lava_secret_area = self.region(
            "Lava Secret Area",
            [
                "Secret (72)",
                "Quad Damage (73)",
                "Large Medkit (74)",
                "Large Medkit (75)",
            ],
        )
        self.connect(ret, lava_secret_area, r.can_dive & r.invuln(1))

        second_room_area = self.region(
            "Second Room Area",
            [
                "Shells (27)",
                "Shells (28)",
                "Small Medkit (54)",
                "Small Medkit (55)",
                "Rockets (5)",
            ],
        )
        self.connect(first_room_roof, second_room_area, r.can_button)

        second_room_upper_area = self.region(
            "Second Room Upper Area",
            [
                "Shells (31)",
                "Rocketlauncher (4)",
                "Large Medkit (52)",
                "Large Medkit (53)",
                "Megahealth (23)",
                "Spikes (67)",
                "Spikes (66)",
                "Large Medkit (12)",
                "Large Medkit (11)",
                "Invulnerability (37)",
                "Spikes (32)",
                "Rockets (33)",
                "Spikes (58)",
                "Large Medkit (9)",
                "Large Medkit (8)",
                "Rocketlauncher (24)",
                "Yellow Armor (7)",
                "Spikes (68)",
                "Spikes (61)",
                "Spikes (45)",
                "Spikes (44)",
                "Large Medkit (57)",
                "Large Medkit (56)",
                "Shells (35)",
                "Supershotgun (6)",
                "Large Medkit (47)",
                "Large Medkit (46)",
            ],
        )
        self.connect(second_room_area, second_room_upper_area, r.jump)

        second_room_upper_inside_area = self.region(
            "Second Room Upper Inside Area",
            [
                "Large Medkit (26)",
                "Large Medkit (25)",
                "Silver Key (62)",
                "Spikes (63)",
                "Large Medkit (18)",
                "Large Medkit (17)",
            ],
        )
        self.connect(
            second_room_upper_area, second_room_upper_inside_area, r.can_button
        )

        silver_key_area = self.region(
            "Silver Key Area",
            [
                "Large Medkit (16)",
                "Secret (69)",
                "Spikes (15)",
                "Spikes (70)",
                "Invisibility (71)",
                "Exit",
                "All Kills (78)",
            ],
        )
        self.connect(second_room_upper_area, silver_key_area, self.silver_key)
        self.restrict("Secret (69)", r.can_shootswitch)
        self.restrict("Spikes (15)", r.can_shootswitch)
        self.restrict("Spikes (70)", r.can_shootswitch)
        self.restrict("Invisibility (71)", r.can_shootswitch)

        self.restrict("All Kills (78)", r.backpack(5))

        return ret
