from typing import Optional, Dict, List, Set
from dataclasses import dataclass
from BaseClasses import ItemClassification

from enum import Enum

# item categories taken from META
# https://github.com/pseudostripy/DS2S-META/blob/master/DS2S%20META/Resources/Equipment/DS2SItemCategories.txt

class DLC(Enum):
    SUNKEN_KING = 1
    OLD_IRON_KING = 2
    IVORY_KING = 3
    ALL = 4

class ItemCategory(Enum):
    ARMOR = 1
    CONSUMABLE = 2
    USABLE_ITEM = 3
    UPGRADE_MATERIAL = 4
    GESTURE = 5
    KEY_ITEM = 6
    WEAPON = 7
    AMMO = 8
    RING = 9
    SHIELD = 10
    SPELL = 11
    STAFF_OR_CHIME = 12
    STATUE = 13 
    HEALING = 14

@dataclass
class ItemData:
    code: int
    name: str
    category: ItemCategory
    classification: ItemClassification = ItemClassification.filler
    dlc: Optional[DLC] = None
    sotfs: Optional[bool] = False # whether the location is only in sotfs
    skip: Optional[bool] = False # if true, item will not be added to the item pool

repeatable_categories: list[ItemCategory] = [
    ItemCategory.CONSUMABLE,
    ItemCategory.UPGRADE_MATERIAL,
    ItemCategory.AMMO
]

item_list: list[ItemData] = [
    ItemData(1, "Unpetrify Statue in Things Betwixt", ItemCategory.STATUE, classification=ItemClassification.progression, sotfs=True),
    ItemData(2, "Unpetrify Rosabeth of Melfia", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(3, "Unpetrify Statue in Heide's Tower of Flame", ItemCategory.STATUE, classification = ItemClassification.progression,  sotfs=True),
    ItemData(4, "Unpetrify Statue in Lost Bastille", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(5, "Unpetrify Straid of Olaphis", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(6, "Unpetrify Statue in Black Gulch", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(7, "Unpetrify Statue near Manscorpion Tark", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(8, "Unpetrify Statue near Black Knight Halberd", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(9, "Unpetrify Statue Blocking the Chest in Shaded Ruins", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(10, "Unpetrify Lion Mage Set Statue in Shaded Ruins", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(11, "Unpetrify Fang Key Statue in Shaded Ruins", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(12, "Unpetrify Warlock Mask Statue in Shaded Ruins", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(13, "Unpetrify Milfanito Entrance Statue", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(14, "Unpetrify Cyclops Statue in Aldia's Keep", ItemCategory.STATUE, classification = ItemClassification.progression),
    ItemData(15, "Unpetrify Left Cage Statue in Aldia's Keep", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(16, "Unpetrify Right Cage Statue in Aldia's Keep", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(17, "Unpetrify Statue in Dragon Aerie", ItemCategory.STATUE, classification = ItemClassification.progression, sotfs=True),
    ItemData(1000000, "Dagger", ItemCategory.WEAPON),
    ItemData(1010000, "Bandit's Knife", ItemCategory.WEAPON),
    ItemData(1040000, "Mytha's Bent Blade", ItemCategory.WEAPON),
    ItemData(1050000, "Shadow Dagger", ItemCategory.WEAPON),
    ItemData(1060000, "Thief Dagger", ItemCategory.WEAPON),
    ItemData(1070000, "Broken Thief Sword", ItemCategory.WEAPON),
    ItemData(1100000, "Parrying Dagger", ItemCategory.WEAPON),
    ItemData(1110000, "Manikin Knife", ItemCategory.WEAPON),
    ItemData(1130000, "Royal Dirk", ItemCategory.WEAPON),
    ItemData(1140000, "Blue Dagger", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1150000, "Umbral Dagger", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1160000, "Retainer's Short Sword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1200000, "Broken Straight Sword", ItemCategory.WEAPON),
    ItemData(1210000, "Shortsword", ItemCategory.WEAPON),
    ItemData(1220000, "Longsword", ItemCategory.WEAPON),
    ItemData(1230000, "Broadsword", ItemCategory.WEAPON),
    ItemData(1240000, "Foot Soldier Sword", ItemCategory.WEAPON),
    ItemData(1250000, "Puzzling Stone Sword", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(1260000, "Possessed Armor Sword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1270000, "Varangian Sword", ItemCategory.WEAPON),
    ItemData(1280000, "Blue Flame", ItemCategory.WEAPON),
    ItemData(1290000, "Fume Sword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1320000, "Heide Knight Sword", ItemCategory.WEAPON),
    ItemData(1330000, "Red Rust Sword", ItemCategory.WEAPON),
    ItemData(1350000, "Black Dragon Sword", ItemCategory.WEAPON),
    ItemData(1360000, "Sun Sword", ItemCategory.WEAPON),
    ItemData(1370000, "Drakekeeper's Sword", ItemCategory.WEAPON),
    ItemData(1380000, "Ashen Warrior Sword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1390000, "Ivory Straight Sword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1400000, "Estoc", ItemCategory.WEAPON),
    ItemData(1410000, "Mail Breaker", ItemCategory.WEAPON),
    ItemData(1420000, "Chaos Rapier", ItemCategory.WEAPON),
    ItemData(1430000, "Spider's Silk", ItemCategory.WEAPON),
    ItemData(1440000, "Espada Ropera", ItemCategory.WEAPON),
    ItemData(1500000, "Rapier", ItemCategory.WEAPON),
    ItemData(1520000, "Black Scorpion Stinger", ItemCategory.WEAPON),
    ItemData(1530000, "Ricard's Rapier", ItemCategory.WEAPON),
    ItemData(1580000, "Ice Rapier", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1600000, "Falchion", ItemCategory.WEAPON),
    ItemData(1610000, "Shotel", ItemCategory.WEAPON),
    ItemData(1620000, "Warped Sword", ItemCategory.WEAPON),
    ItemData(1630000, "Eleum Loyce", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1640000, "Manikin Sabre", ItemCategory.WEAPON),
    ItemData(1650000, "Scimitar", ItemCategory.WEAPON),
    ItemData(1660000, "Red Rust Scimitar", ItemCategory.WEAPON),
    ItemData(1670000, "Spider Fang", ItemCategory.WEAPON),
    ItemData(1680000, "Melu Scimitar", ItemCategory.WEAPON),
    ItemData(1690000, "Monastery Scimitar", ItemCategory.WEAPON),
    ItemData(1700000, "Uchigatana", ItemCategory.WEAPON),
    ItemData(1710000, "Washing Pole", ItemCategory.WEAPON),
    ItemData(1720000, "Chaos Blade", ItemCategory.WEAPON),
    ItemData(1730000, "Blacksteel Katana", ItemCategory.WEAPON),
    ItemData(1740000, "Manslayer", ItemCategory.WEAPON),
    ItemData(1760000, "Darkdrift", ItemCategory.WEAPON),
    ItemData(1770000, "Berserker Blade", ItemCategory.WEAPON),
    ItemData(1790000, "Bewitched Alonne Sword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(1800000, "Bastard Sword", ItemCategory.WEAPON),
    ItemData(1810000, "Flamberge", ItemCategory.WEAPON),
    ItemData(1820000, "Claymore", ItemCategory.WEAPON),
    ItemData(1830000, "Majestic Greatsword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    # ItemData(1831000, "Majestic Greatsword"),
    ItemData(1850000, "Drangleic Sword", ItemCategory.WEAPON),
    ItemData(1860000, "Thorned Greatsword", ItemCategory.WEAPON),
    ItemData(1870000, "Bluemoon Greatsword", ItemCategory.WEAPON),
    ItemData(1871000, "Moonlight Greatsword", ItemCategory.WEAPON),
    ItemData(1880000, "Mastodon Greatsword", ItemCategory.WEAPON),
    ItemData(1900000, "Ruler's Sword", ItemCategory.WEAPON),
    ItemData(1910000, "Mirrah Greatsword", ItemCategory.WEAPON),
    ItemData(1911000, "Old Mirrah Greatsword", ItemCategory.WEAPON),
    ItemData(1920000, "Black Dragon Greatsword", ItemCategory.WEAPON),
    ItemData(1930000, "Black Knight Greatsword", ItemCategory.WEAPON),
    ItemData(1940000, "Royal Greatsword", ItemCategory.WEAPON),
    ItemData(1950000, "Old Knight Greatsword", ItemCategory.WEAPON),
    ItemData(1960000, "Defender Greatsword", ItemCategory.WEAPON),
    ItemData(1970000, "Watcher Greatsword", ItemCategory.WEAPON),
    ItemData(1980000, "Key to the Embedded", ItemCategory.WEAPON),
    ItemData(1990000, "Drakeblood Greatsword", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(1995000, "Loyce Greatsword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1996000, "Charred Loyce Greatsword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(1997000, "Greatsword of the Forlorn", ItemCategory.WEAPON, sotfs=True),
    ItemData(2000000, "Hand Axe", ItemCategory.WEAPON),
    ItemData(2010000, "Battle Axe", ItemCategory.WEAPON),
    ItemData(2020000, "Bandit Axe", ItemCategory.WEAPON),
    ItemData(2030000, "Infantry Axe", ItemCategory.WEAPON),
    ItemData(2070000, "Gyrm Axe", ItemCategory.WEAPON),
    ItemData(2080000, "Dragonslayer's Crescent Axe", ItemCategory.WEAPON),
    ItemData(2090000, "Butcher's Knife", ItemCategory.WEAPON),
    ItemData(2100000, "Silverblack Sickle", ItemCategory.WEAPON),
    ItemData(2200000, "Crescent Axe", ItemCategory.WEAPON),
    ItemData(2210000, "Greataxe", ItemCategory.WEAPON),
    ItemData(2220000, "Bandit Greataxe", ItemCategory.WEAPON),
    ItemData(2240000, "Lion Greataxe", ItemCategory.WEAPON),
    ItemData(2250000, "Giant Stone Axe", ItemCategory.WEAPON),
    ItemData(2260000, "Gyrm Greataxe", ItemCategory.WEAPON),
    ItemData(2290000, "Black Dragon Greataxe", ItemCategory.WEAPON),
    ItemData(2300000, "Black Knight Greataxe", ItemCategory.WEAPON),
    ItemData(2310000, "Drakekeeper's Greataxe", ItemCategory.WEAPON),
    ItemData(2400000, "Club", ItemCategory.WEAPON),
    ItemData(2410000, "Mace", ItemCategory.WEAPON),
    ItemData(2420000, "Morning Star", ItemCategory.WEAPON),
    ItemData(2430000, "Reinforced Club", ItemCategory.WEAPON),
    ItemData(2440000, "Craftsman's Hammer", ItemCategory.WEAPON),
    ItemData(2470000, "Mace of the Insolent", ItemCategory.WEAPON),
    ItemData(2500000, "Handmaid's Ladle", ItemCategory.WEAPON),
    ItemData(2520000, "Blacksmith's Hammer", ItemCategory.WEAPON),
    ItemData(2530000, "Black Dragon Warpick", ItemCategory.WEAPON),
    ItemData(2540000, "Aldia Hammer", ItemCategory.WEAPON),
    ItemData(2560000, "Barbed Club", ItemCategory.WEAPON),
    ItemData(2600000, "Large Club", ItemCategory.WEAPON),
    ItemData(2610000, "Pickaxe", ItemCategory.WEAPON),
    ItemData(2620000, "Great Club", ItemCategory.WEAPON),
    ItemData(2630000, "Gyrm Great Hammer", ItemCategory.WEAPON),
    ItemData(2660000, "Iron King Hammer", ItemCategory.WEAPON),
    ItemData(2670000, "Malformed Skull", ItemCategory.WEAPON),
    ItemData(2680000, "Dragon Tooth", ItemCategory.WEAPON),
    ItemData(2690000, "Giant Warrior Club", ItemCategory.WEAPON),
    ItemData(2700000, "Malformed Shell", ItemCategory.WEAPON),
    ItemData(2710000, "Demon's Great Hammer", ItemCategory.WEAPON),
    ItemData(2720000, "Archdrake Mace", ItemCategory.WEAPON),
    ItemData(2730000, "Old Knight Hammer", ItemCategory.WEAPON),
    ItemData(2740000, "Drakekeeper's Great Hammer", ItemCategory.WEAPON),
    ItemData(2750000, "Sacred Chime Hammer", ItemCategory.WEAPON),
    ItemData(2760000, "Sanctum Mace", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(2800000, "Spear", ItemCategory.WEAPON),
    ItemData(2810000, "Winged Spear", ItemCategory.WEAPON),
    ItemData(2820000, "Pike", ItemCategory.WEAPON),
    ItemData(2830000, "Partizan", ItemCategory.WEAPON),
    ItemData(2840000, "Stone Soldier Spear", ItemCategory.WEAPON),
    ItemData(2850000, "Spitfire Spear", ItemCategory.WEAPON),
    ItemData(2855000, "Yorgh's Spear", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(2860000, "Silverblack Spear", ItemCategory.WEAPON),
    ItemData(2870000, "Heide Spear", ItemCategory.WEAPON),
    ItemData(2880000, "Pate's Spear", ItemCategory.WEAPON),
    ItemData(2890000, "Channeler's Trident", ItemCategory.WEAPON),
    ItemData(2895000, "Gargoyle Bident", ItemCategory.WEAPON),
    ItemData(2896000, "Dragonslayer Spear", ItemCategory.WEAPON),
    ItemData(2900000, "Heide Lance", ItemCategory.WEAPON),
    ItemData(2920000, "Heide Greatlance", ItemCategory.WEAPON),
    ItemData(2930000, "Grand Lance", ItemCategory.WEAPON),
    ItemData(2940000, "Chariot Lance", ItemCategory.WEAPON),
    ItemData(2950000, "Rampart Golem Lance", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(2960000, "Smelter Hammer", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(3000000, "Great Scythe", ItemCategory.WEAPON),
    ItemData(3010000, "Great Machete", ItemCategory.WEAPON),
    ItemData(3020000, "Full Moon Sickle", ItemCategory.WEAPON),
    ItemData(3040000, "Crescent Sickle", ItemCategory.WEAPON),
    ItemData(3050000, "Scythe of Nahr Alma", ItemCategory.WEAPON),
    ItemData(3060000, "Bone Scythe", ItemCategory.WEAPON),
    ItemData(3070000, "Scythe of Want", ItemCategory.WEAPON),
    ItemData(3080000, "Scythe of the Forlorn", ItemCategory.WEAPON, sotfs=True),
    ItemData(3200000, "Lucerne", ItemCategory.WEAPON),
    ItemData(3210000, "Scythe", ItemCategory.WEAPON),
    ItemData(3220000, "Halberd", ItemCategory.WEAPON),
    ItemData(3240000, "Helix Halberd", ItemCategory.WEAPON),
    ItemData(3250000, "Santier's Spear", ItemCategory.WEAPON),
    # ItemData(3251000, "Santier's Spear"),
    ItemData(3270000, "Mastodon Halberd", ItemCategory.WEAPON),
    ItemData(3280000, "Blue Knight's Halberd", ItemCategory.WEAPON),
    ItemData(3290000, "Dragonrider's Halberd", ItemCategory.WEAPON),
    ItemData(3300000, "Black Knight Halberd", ItemCategory.WEAPON),
    ItemData(3310000, "Syan's Halberd", ItemCategory.WEAPON),
    ItemData(3320000, "Roaring Halberd", ItemCategory.WEAPON),
    ItemData(3330000, "Old Knight Halberd", ItemCategory.WEAPON),
    ItemData(3340000, "Old Knight Pike", ItemCategory.WEAPON),
    ItemData(3350000, "Drakekeeper's Warpick", ItemCategory.WEAPON),
    ItemData(3370000, "Wrathful Axe", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(3410000, "Claws", ItemCategory.WEAPON),
    ItemData(3420000, "Malformed Claws", ItemCategory.WEAPON),
    ItemData(3430000, "Manikin Claws", ItemCategory.WEAPON),
    ItemData(3440000, "Work Hook", ItemCategory.WEAPON),
    ItemData(3500000, "Caestus", ItemCategory.WEAPON),
    ItemData(3530000, "Bone Fist", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(3600000, "Whip", ItemCategory.WEAPON),
    ItemData(3610000, "Notched Whip", ItemCategory.WEAPON),
    ItemData(3620000, "Bloodied Whip", ItemCategory.WEAPON),
    ItemData(3630000, "Spotted Whip", ItemCategory.WEAPON),
    ItemData(3660000, "Old Whip", ItemCategory.WEAPON),
    ItemData(3800000, "Sorcerer's Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3810000, "Staff of Amana", ItemCategory.STAFF_OR_CHIME),
    ItemData(3820000, "Witchtree Branch", ItemCategory.STAFF_OR_CHIME),
    ItemData(3830000, "Lizard Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3850000, "Olenford's Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3860000, "Archdrake Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3870000, "Bat Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3880000, "Bone Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3890000, "Staff of Wisdom", ItemCategory.STAFF_OR_CHIME),
    ItemData(3900000, "Sunset Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(3910000, "Pilgrim's Spontoon", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(3930000, "Azal's Staff", ItemCategory.STAFF_OR_CHIME, dlc=DLC.IVORY_KING),
    ItemData(3940000, "Retainer Staff", ItemCategory.STAFF_OR_CHIME, dlc=DLC.IVORY_KING),
    ItemData(4010000, "Cleric's Sacred Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4020000, "Witchtree Bellvine", ItemCategory.STAFF_OR_CHIME),
    ItemData(4030000, "Priest's Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4040000, "Dragon Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4050000, "Chime of Want", ItemCategory.STAFF_OR_CHIME),
    ItemData(4060000, "Archdrake Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4080000, "Idol's Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4090000, "Caitha's Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4100000, "Protective Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4110000, "Disc Chime", ItemCategory.STAFF_OR_CHIME),
    ItemData(4120000, "Chime of Screams", ItemCategory.STAFF_OR_CHIME, dlc=DLC.OLD_IRON_KING),
    ItemData(4150000, "Black Witch's Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(4200000, "Short Bow", ItemCategory.WEAPON),
    ItemData(4210000, "Long Bow", ItemCategory.WEAPON),
    ItemData(4220000, "Composite Bow", ItemCategory.WEAPON),
    ItemData(4230000, "Sea Bow", ItemCategory.WEAPON),
    ItemData(4240000, "Dragonrider Bow", ItemCategory.WEAPON),
    ItemData(4270000, "Bell Keeper Bow", ItemCategory.WEAPON),
    ItemData(4280000, "Bow of Want", ItemCategory.WEAPON),
    ItemData(4290000, "Hunter's Blackbow", ItemCategory.WEAPON),
    ItemData(4400000, "Alonne Greatbow", ItemCategory.WEAPON),
    ItemData(4420000, "Dragonslayer Greatbow", ItemCategory.WEAPON),
    ItemData(4430000, "Possessed Armor Greatbow", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(4440000, "Twin-headed Greatbow", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(4600000, "Light Crossbow", ItemCategory.WEAPON),
    ItemData(4610000, "Heavy Crossbow", ItemCategory.WEAPON),
    ItemData(4630000, "Shield Crossbow", ItemCategory.WEAPON),
    ItemData(4660000, "Avelyn", ItemCategory.WEAPON),
    ItemData(4670000, "Sanctum Crossbow", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(4680000, "Sanctum Repeating Crossbow", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(5000000, "Murakumo", ItemCategory.WEAPON),
    ItemData(5010000, "Arced Sword", ItemCategory.WEAPON),
    ItemData(5040000, "Curved Dragon Greatsword", ItemCategory.WEAPON),
    ItemData(5050000, "Curved Nil Greatsword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(5200000, "Zweihander", ItemCategory.WEAPON),
    ItemData(5210000, "Greatsword", ItemCategory.WEAPON),
    ItemData(5220000, "Smelter Sword", ItemCategory.WEAPON),
    ItemData(5225000, "Aged Smelter Sword", ItemCategory.WEAPON),
    ItemData(5230000, "Drakewing Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5240000, "King's Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5250000, "Fume Ultra Greatsword", ItemCategory.WEAPON, dlc=DLC.OLD_IRON_KING),
    ItemData(5255000, "Ivory King Ultra Greatsword", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(5270000, "Pursuer's Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5275000, "Drakekeeper's Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5280000, "Crypt Blacksword", ItemCategory.WEAPON),
    ItemData(5285000, "Old Knight Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5290000, "Black Knight Ultra Greatsword", ItemCategory.WEAPON),
    ItemData(5295000, "Lost Sinner's Sword", ItemCategory.WEAPON),
    ItemData(5310000, "Stone Twinblade", ItemCategory.WEAPON),
    ItemData(5330000, "Dragonrider Twinblade", ItemCategory.WEAPON),
    ItemData(5340000, "Twinblade", ItemCategory.WEAPON),
    ItemData(5350000, "Red Iron Twinblade", ItemCategory.WEAPON),
    ItemData(5360000, "Curved Twinblade", ItemCategory.WEAPON),
    ItemData(5370000, "Sorcerer's Twinblade", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(5400000, "Pyromancy Flame", ItemCategory.WEAPON),
    ItemData(5410000, "Dark Pyromancy Flame", ItemCategory.WEAPON),
    ItemData(5500000, "Black Flamestone Dagger", ItemCategory.WEAPON),
    ItemData(5510000, "Yellow Quartz Longsword", ItemCategory.WEAPON),
    ItemData(5520000, "Bound Hand Axe", ItemCategory.WEAPON),
    ItemData(5530000, "Homunculus Mace", ItemCategory.WEAPON),
    ItemData(5540000, "Transgressor's Staff", ItemCategory.STAFF_OR_CHIME),
    ItemData(5600000, "Longsword (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5610000, "Murakumo (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5620000, "Blacksteel Katana (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5630000, "Rapier (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5640000, "Greataxe (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5650000, "Great Club (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(5660000, "Caestus (reskin)", ItemCategory.WEAPON, skip=True),
    ItemData(6100000, "Binoculars", ItemCategory.USABLE_ITEM),
    ItemData(11000000, "Buckler", ItemCategory.WEAPON),
    ItemData(11005000, "Benhart's Parma", ItemCategory.WEAPON),
    ItemData(11010000, "Small Leather Shield", ItemCategory.WEAPON),
    ItemData(11020000, "Iron Parma", ItemCategory.WEAPON),
    ItemData(11030000, "Foot Soldier Shield", ItemCategory.WEAPON),
    ItemData(11040000, "Target Shield", ItemCategory.WEAPON),
    ItemData(11050000, "Golden Falcon Shield", ItemCategory.WEAPON),
    ItemData(11070000, "Manikin Shield", ItemCategory.WEAPON),
    ItemData(11080000, "Llewellyn Shield", ItemCategory.WEAPON),
    ItemData(11091000, "Crimson Parma", ItemCategory.WEAPON),
    ItemData(11110000, "Cleric's Parma", ItemCategory.WEAPON),
    ItemData(11120000, "Cleric's Small Shield", ItemCategory.WEAPON),
    ItemData(11130000, "Magic Shield", ItemCategory.WEAPON),
    ItemData(11140000, "Cursed Bone Shield", ItemCategory.WEAPON),
    ItemData(11150000, "Sanctum Shield", ItemCategory.WEAPON, dlc=DLC.SUNKEN_KING),
    ItemData(11160000, "Varangian Shield", ItemCategory.WEAPON),
    ItemData(11185000, "Watcher's Shield", ItemCategory.WEAPON),
    ItemData(11200000, "Large Leather Shield", ItemCategory.WEAPON),
    ItemData(11210000, "Blue Wooden Shield", ItemCategory.WEAPON),
    ItemData(11220000, "Silver Eagle Kite Shield", ItemCategory.WEAPON),
    ItemData(11230000, "Drangleic Shield", ItemCategory.WEAPON),
    ItemData(11240000, "Lion Clan Shield", ItemCategory.WEAPON),
    ItemData(11250000, "Archdrake Shield", ItemCategory.WEAPON),
    ItemData(11260000, "King's Shield", ItemCategory.WEAPON),
    ItemData(11270000, "Mirrah Shield", ItemCategory.WEAPON),
    ItemData(11280000, "Old Knight's Shield", ItemCategory.WEAPON),
    ItemData(11290000, "Loyce Shield", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(11295000, "Charred Loyce Shield", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(11300000, "Spirit Tree Shield", ItemCategory.WEAPON),
    ItemData(11310000, "Golden Wing Shield", ItemCategory.WEAPON),
    ItemData(11320000, "Vessel Shield", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(11330000, "Shield of the Insolent", ItemCategory.WEAPON),
    ItemData(11350000, "Silverblack Shield", ItemCategory.WEAPON),
    ItemData(11360000, "Stone Parma", ItemCategory.WEAPON),
    ItemData(11370000, "Grand Spirit Tree Shield", ItemCategory.WEAPON),
    ItemData(11380000, "Moon Butterfly Shield", ItemCategory.WEAPON),
    ItemData(11390000, "Slumbering Dragon Shield", ItemCategory.WEAPON),
    ItemData(11395000, "Chaos Shield", ItemCategory.WEAPON),
    ItemData(11400000, "Wooden Shield", ItemCategory.WEAPON),
    ItemData(11420000, "Hollow Soldier Shield", ItemCategory.WEAPON),
    ItemData(11430000, "Royal Kite Shield", ItemCategory.WEAPON),
    ItemData(11450000, "Red Rust Shield", ItemCategory.WEAPON),
    ItemData(11455000, "Rampart Golem Shield", ItemCategory.WEAPON, dlc=DLC.IVORY_KING),
    ItemData(11470000, "Bell Keeper Shield", ItemCategory.WEAPON),
    ItemData(11475000, "Defender's Shield", ItemCategory.WEAPON),
    ItemData(11480000, "Black Dragon Shield", ItemCategory.WEAPON),
    ItemData(11485000, "Drakekeeper's Shield", ItemCategory.WEAPON),
    ItemData(11490000, "Porcine Shield", ItemCategory.WEAPON),
    ItemData(11495000, "Bone Shield", ItemCategory.WEAPON),
    ItemData(11500000, "Twin Dragon Greatshield", ItemCategory.WEAPON),
    ItemData(11510000, "Tower Shield", ItemCategory.WEAPON),
    ItemData(11530000, "Orma's Greatshield", ItemCategory.WEAPON),
    ItemData(11540000, "Reeve's Greatshield", ItemCategory.WEAPON),
    ItemData(11550000, "King's Mirror", ItemCategory.WEAPON),
    ItemData(11560000, "Dragonrider Greatshield", ItemCategory.WEAPON),
    ItemData(11570000, "Mastodon Greatshield", ItemCategory.WEAPON),
    ItemData(11590000, "Havel's Greatshield", ItemCategory.WEAPON),
    ItemData(11600000, "Gyrm Greatshield", ItemCategory.WEAPON),
    ItemData(11610000, "Pursuer's Greatshield", ItemCategory.WEAPON),
    ItemData(11620000, "Pate's Shield", ItemCategory.WEAPON),
    ItemData(11630000, "Old Knight Greatshield", ItemCategory.WEAPON),
    ItemData(11640000, "Drakekeeper's Greatshield", ItemCategory.WEAPON),
    ItemData(11650000, "Greatshield of Glory", ItemCategory.WEAPON),
    ItemData(11700000, "Phoenix Parma", ItemCategory.WEAPON),
    ItemData(11710000, "Sunlight Parma", ItemCategory.WEAPON),
    ItemData(11720000, "Watchdragon Parma", ItemCategory.WEAPON),
    ItemData(11730000, "Blossom Kite Shield", ItemCategory.WEAPON),
    ItemData(11740000, "Rebel's Greatshield", ItemCategory.WEAPON),
    ItemData(11750000, "Wicked Eye Greatshield", ItemCategory.WEAPON),
    ItemData(11800000, "Black Flamestone Parma", ItemCategory.WEAPON),
    ItemData(11810000, "Yellow Quartz Shield", ItemCategory.WEAPON),
    ItemData(11820000, "Bound Wooden Shield", ItemCategory.WEAPON),
    ItemData(11830000, "Homunculus Wooden Shield", ItemCategory.WEAPON),
    ItemData(11840000, "Transgressor's Leather Shield", ItemCategory.WEAPON),
    ItemData(21010100, "Pate's Helm", ItemCategory.ARMOR),
    ItemData(21010101, "Pate's Armor", ItemCategory.ARMOR),
    ItemData(21010102, "Pate's Gloves", ItemCategory.ARMOR),
    ItemData(21010103, "Pate's Trousers", ItemCategory.ARMOR),
    ItemData(21020100, "Thief Mask", ItemCategory.ARMOR),
    ItemData(21020101, "Black Leather Armor", ItemCategory.ARMOR),
    ItemData(21020102, "Black Leather Gloves", ItemCategory.ARMOR),
    ItemData(21020103, "Black Leather Boots", ItemCategory.ARMOR),
    ItemData(21030100, "Wanderer Hood", ItemCategory.ARMOR),
    ItemData(21030101, "Wanderer Coat", ItemCategory.ARMOR),
    ItemData(21030102, "Wanderer Manchettes", ItemCategory.ARMOR),
    ItemData(21030103, "Wanderer Boots", ItemCategory.ARMOR),
    ItemData(21040100, "Hunter's Hat", ItemCategory.ARMOR),
    ItemData(21040101, "Leather Armor", ItemCategory.ARMOR),
    ItemData(21040102, "Leather Gloves", ItemCategory.ARMOR),
    ItemData(21040103, "Leather Boots", ItemCategory.ARMOR),
    ItemData(21050100, "Knight Helm", ItemCategory.ARMOR),
    ItemData(21050101, "Knight Armor", ItemCategory.ARMOR),
    ItemData(21050102, "Knight Gauntlets", ItemCategory.ARMOR),
    ItemData(21050103, "Knight Leggings", ItemCategory.ARMOR),
    ItemData(21060100, "Elite Knight Helm", ItemCategory.ARMOR),
    ItemData(21060101, "Elite Knight Armor", ItemCategory.ARMOR),
    ItemData(21060102, "Elite Knight Gloves", ItemCategory.ARMOR),
    ItemData(21060103, "Elite Knight Leggings", ItemCategory.ARMOR),
    ItemData(21070100, "Tattered Cloth Hood", ItemCategory.ARMOR),
    ItemData(21070101, "Tattered Cloth Robe", ItemCategory.ARMOR),
    ItemData(21070102, "Tattered Cloth Manchettes", ItemCategory.ARMOR),
    ItemData(21070103, "Heavy Boots", ItemCategory.ARMOR),
    ItemData(21080100, "Brigand Hood", ItemCategory.ARMOR),
    ItemData(21080101, "Brigand Armor", ItemCategory.ARMOR),
    ItemData(21080102, "Brigand Gauntlets", ItemCategory.ARMOR),
    ItemData(21080103, "Brigand Trousers", ItemCategory.ARMOR),
    ItemData(21100100, "Imported Hood", ItemCategory.ARMOR),
    ItemData(21100101, "Imported Tunic", ItemCategory.ARMOR),
    ItemData(21100102, "Imported Manchettes", ItemCategory.ARMOR),
    ItemData(21100103, "Imported Trousers", ItemCategory.ARMOR),
    ItemData(21140100, "Traveling Merchant Hat", ItemCategory.ARMOR),
    ItemData(21140101, "Traveling Merchant Coat", ItemCategory.ARMOR),
    ItemData(21140102, "Traveling Merchant Gloves", ItemCategory.ARMOR),
    ItemData(21140103, "Traveling Merchant Boots", ItemCategory.ARMOR),
    ItemData(21160100, "Havel's Helm", ItemCategory.ARMOR),
    ItemData(21160101, "Havel's Armor", ItemCategory.ARMOR),
    ItemData(21160102, "Havel's Gauntlets", ItemCategory.ARMOR),
    ItemData(21160103, "Havel's Leggings", ItemCategory.ARMOR),
    ItemData(21210100, "Jester's Cap", ItemCategory.ARMOR),
    ItemData(21210101, "Jester's Robes", ItemCategory.ARMOR),
    ItemData(21210102, "Jester's Gloves", ItemCategory.ARMOR),
    ItemData(21210103, "Jester's Tights", ItemCategory.ARMOR),
    ItemData(21230100, "Moon Hat", ItemCategory.ARMOR),
    ItemData(21230101, "Astrologist's Robe", ItemCategory.ARMOR),
    ItemData(21230102, "Astrologist's Gauntlets", ItemCategory.ARMOR),
    ItemData(21230103, "Astrologist's Bottoms", ItemCategory.ARMOR),
    ItemData(21320100, "Faraam Helm", ItemCategory.ARMOR),
    ItemData(21320101, "Faraam Armor", ItemCategory.ARMOR),
    ItemData(21320102, "Faraam Gauntlets", ItemCategory.ARMOR),
    ItemData(21320103, "Faraam Boots", ItemCategory.ARMOR),
    ItemData(21330100, "Black Dragon Helm", ItemCategory.ARMOR),
    ItemData(21330101, "Black Dragon Armor", ItemCategory.ARMOR),
    ItemData(21330102, "Black Dragon Gauntlets", ItemCategory.ARMOR),
    ItemData(21330103, "Black Dragon Leggings", ItemCategory.ARMOR),
    ItemData(21340100, "Xanthous Crown", ItemCategory.ARMOR),
    ItemData(21340101, "Xanthous Overcoat", ItemCategory.ARMOR),
    ItemData(21340102, "Xanthous Gloves", ItemCategory.ARMOR),
    ItemData(21340103, "Xanthous Waistcloth", ItemCategory.ARMOR),
    ItemData(21350100, "Mask of Judgment", ItemCategory.ARMOR),
    ItemData(21350101, "Robe of Judgment", ItemCategory.ARMOR),
    ItemData(21350102, "Manchettes of Judgment", ItemCategory.ARMOR),
    ItemData(21350103, "Tights of Judgment", ItemCategory.ARMOR),
    ItemData(21360100, "Helm of Aurous", ItemCategory.ARMOR),
    ItemData(21360101, "Armor of Aurous", ItemCategory.ARMOR),
    ItemData(21360102, "Gauntlets of Aurous", ItemCategory.ARMOR),
    ItemData(21360103, "Leggings of Aurous", ItemCategory.ARMOR),
    ItemData(21361100, "Helm of Aurous", ItemCategory.ARMOR),
    ItemData(21361101, "Armor of Aurous", ItemCategory.ARMOR),
    ItemData(21361102, "Gauntlets of Aurous", ItemCategory.ARMOR),
    ItemData(21361103, "Leggings of Aurous", ItemCategory.ARMOR),
    ItemData(21370100, "Monastery Headcloth", ItemCategory.ARMOR),
    ItemData(21370101, "Monastery Longshirt", ItemCategory.ARMOR),
    ItemData(21370102, "Monastery Long Gloves", ItemCategory.ARMOR),
    ItemData(21370103, "Monastery Skirt", ItemCategory.ARMOR),
    ItemData(21390100, "Dingy Hood", ItemCategory.ARMOR),
    ItemData(21390101, "Dingy Robe", ItemCategory.ARMOR),
    ItemData(21390102, "Dingy Cuffs", ItemCategory.ARMOR),
    ItemData(21390103, "Blood-Stained Skirt", ItemCategory.ARMOR),
    ItemData(21430100, "Durgo's Hat", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21440102, "Engraved Gauntlets", ItemCategory.ARMOR),
    ItemData(21460103, "Flying Feline Boots", ItemCategory.ARMOR, classification = ItemClassification.progression),
    ItemData(21470100, "Moon Butterfly Hat", ItemCategory.ARMOR),
    ItemData(21470101, "Moon Butterfly Wings", ItemCategory.ARMOR),
    ItemData(21470102, "Moon Butterfly Cuffs", ItemCategory.ARMOR),
    ItemData(21470103, "Moon Butterfly Skirt", ItemCategory.ARMOR),
    ItemData(21480100, "Catarina Helm", ItemCategory.ARMOR),
    ItemData(21480101, "Catarina Armor", ItemCategory.ARMOR),
    ItemData(21480102, "Catarina Gauntlets", ItemCategory.ARMOR),
    ItemData(21480103, "Catarina Leggings", ItemCategory.ARMOR),
    ItemData(21490100, "Alva Helm", ItemCategory.ARMOR),
    ItemData(21490101, "Alva Armor", ItemCategory.ARMOR),
    ItemData(21490102, "Alva Gauntlets", ItemCategory.ARMOR),
    ItemData(21490103, "Alva Leggings", ItemCategory.ARMOR),
    ItemData(21500100, "Black Witch Veil", ItemCategory.ARMOR),
    ItemData(21500101, "Black Witch Robe", ItemCategory.ARMOR),
    ItemData(21500102, "Black Witch Gloves", ItemCategory.ARMOR),
    ItemData(21500103, "Black Witch Trousers", ItemCategory.ARMOR),
    ItemData(21501100, "Black Witch Hat", ItemCategory.ARMOR),
    ItemData(21502100, "Black Witch Domino Mask", ItemCategory.ARMOR),
    ItemData(21600100, "Drakeblood Helm", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21600101, "Drakeblood Armor", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21600102, "Drakeblood Gauntlets", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21600103, "Drakeblood Leggings", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21610100, "Northwarder Hood", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21610101, "Northwarder Robe", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21610102, "Northwarder Manchettes", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21610103, "Northwarder Trousers", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21630100, "Crown of the Old Iron King", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(21640100, "Crown of the Ivory King", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21650100, "Crown of the Sunken King", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21660100, "Old Bell Helm", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(21670100, "Hollow Skin", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(21680100, "Pharros Mask", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(21690103, "Flower Skirt", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(21700100, "Minotaur Helm", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(21710100, "Symbol of Avarice", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(22020100, "Hollow Soldier Helm", ItemCategory.ARMOR),
    ItemData(22020101, "Hollow Soldier Armor", ItemCategory.ARMOR),
    ItemData(22020102, "Hollow Soldier Gauntlets", ItemCategory.ARMOR),
    ItemData(22020103, "Hollow Soldier Leggings", ItemCategory.ARMOR),
    ItemData(22021100, "Royal Soldier Helm", ItemCategory.ARMOR),
    ItemData(22021101, "Royal Soldier Armor", ItemCategory.ARMOR),
    ItemData(22021102, "Royal Soldier Gauntlets", ItemCategory.ARMOR),
    ItemData(22021103, "Royal Soldier Leggings", ItemCategory.ARMOR),
    ItemData(22030100, "Hollow Infantry Helm", ItemCategory.ARMOR),
    ItemData(22030101, "Hollow Infantry Armor", ItemCategory.ARMOR),
    ItemData(22030102, "Hollow Infantry Gloves", ItemCategory.ARMOR),
    ItemData(22030103, "Hollow Infantry Boots", ItemCategory.ARMOR),
    ItemData(22031100, "Infantry Helm", ItemCategory.ARMOR),
    ItemData(22031101, "Infantry Armor", ItemCategory.ARMOR),
    ItemData(22031102, "Infantry Gloves", ItemCategory.ARMOR),
    ItemData(22031103, "Infantry Boots", ItemCategory.ARMOR),
    ItemData(22060100, "White Priest Headpiece", ItemCategory.ARMOR),
    ItemData(22060101, "White Priest Robe", ItemCategory.ARMOR),
    ItemData(22060102, "White Priest Gloves", ItemCategory.ARMOR),
    ItemData(22060103, "White Priest Skirt", ItemCategory.ARMOR),
    ItemData(22062100, "Priestess Headpiece", ItemCategory.ARMOR),
    ItemData(22062101, "Priestess Robe", ItemCategory.ARMOR),
    ItemData(22062102, "Priestess Gloves", ItemCategory.ARMOR),
    ItemData(22062103, "Priestess Skirt", ItemCategory.ARMOR),
    ItemData(22080100, "Rogue Hood", ItemCategory.ARMOR),
    ItemData(22080101, "Rogue Armor", ItemCategory.ARMOR),
    ItemData(22080102, "Rogue Gauntlets", ItemCategory.ARMOR),
    ItemData(22080103, "Rogue Leggings", ItemCategory.ARMOR),
    ItemData(22110100, "Spiked Bandit Helm", ItemCategory.ARMOR),
    ItemData(22110101, "Bandit Armor", ItemCategory.ARMOR),
    ItemData(22110102, "Bandit Gauntlets", ItemCategory.ARMOR),
    ItemData(22110103, "Bandit Boots", ItemCategory.ARMOR),
    ItemData(22130100, "Varangian Helm", ItemCategory.ARMOR),
    ItemData(22130101, "Varangian Armor", ItemCategory.ARMOR),
    ItemData(22130102, "Varangian Cuffs", ItemCategory.ARMOR),
    ItemData(22130103, "Varangian Leggings", ItemCategory.ARMOR),
    ItemData(22180100, "Black Hollow Mage Hood", ItemCategory.ARMOR),
    ItemData(22180101, "Black Hollow Mage Robe", ItemCategory.ARMOR),
    ItemData(22182100, "White Hollow Mage Hood", ItemCategory.ARMOR),
    ItemData(22182101, "White Hollow Mage Robe", ItemCategory.ARMOR),
    ItemData(22190101, "Lion Mage Robe", ItemCategory.ARMOR),
    ItemData(22190102, "Lion Mage Cuffs", ItemCategory.ARMOR),
    ItemData(22190103, "Lion Mage Skirt", ItemCategory.ARMOR),
    ItemData(22220100, "Steel Helm", ItemCategory.ARMOR),
    ItemData(22220101, "Steel Armor", ItemCategory.ARMOR),
    ItemData(22220102, "Steel Gauntlets", ItemCategory.ARMOR),
    ItemData(22220103, "Steel Leggings", ItemCategory.ARMOR),
    ItemData(22230100, "Shadow Mask", ItemCategory.ARMOR),
    ItemData(22230101, "Shadow Top", ItemCategory.ARMOR),
    ItemData(22230102, "Shadow Gauntlets", ItemCategory.ARMOR),
    ItemData(22230103, "Shadow Leggings", ItemCategory.ARMOR),
    ItemData(22240100, "Manikin Mask", ItemCategory.ARMOR),
    ItemData(22240101, "Manikin Top", ItemCategory.ARMOR),
    ItemData(22240102, "Manikin Gloves", ItemCategory.ARMOR),
    ItemData(22240103, "Manikin Boots", ItemCategory.ARMOR),
    ItemData(22270100, "Prisoner's Hood", ItemCategory.ARMOR),
    ItemData(22270101, "Prisoner's Tatters", ItemCategory.ARMOR),
    ItemData(22270102, "Prisoner's Gloves", ItemCategory.ARMOR),
    ItemData(22270103, "Prisoner's Waistcloth", ItemCategory.ARMOR),
    ItemData(22271100, "Prisoner's Hood", ItemCategory.ARMOR),
    ItemData(22271101, "Prisoner's Tatters", ItemCategory.ARMOR),
    ItemData(22310100, "Archdrake Helm", ItemCategory.ARMOR),
    ItemData(22310101, "Archdrake Robes", ItemCategory.ARMOR),
    ItemData(22310102, "Archdrake Gloves", ItemCategory.ARMOR),
    ItemData(22310103, "Archdrake Boots", ItemCategory.ARMOR),
    ItemData(22340100, "Gyrm Helm", ItemCategory.ARMOR),
    ItemData(22340101, "Gyrm Armor", ItemCategory.ARMOR),
    ItemData(22340102, "Gyrm Gloves", ItemCategory.ARMOR),
    ItemData(22340103, "Gyrm Boots", ItemCategory.ARMOR),
    ItemData(22350100, "Gyrm Warrior Helm", ItemCategory.ARMOR),
    ItemData(22350101, "Gyrm Warrior Armor", ItemCategory.ARMOR),
    ItemData(22350102, "Gyrm Warrior Gloves", ItemCategory.ARMOR),
    ItemData(22350103, "Gyrm Warrior Boots", ItemCategory.ARMOR),
    ItemData(22351100, "Gyrm Warrior Greathelm", ItemCategory.ARMOR),
    ItemData(22360100, "Dark Mask", ItemCategory.ARMOR),
    ItemData(22360101, "Dark Armor", ItemCategory.ARMOR),
    ItemData(22360102, "Dark Gauntlets", ItemCategory.ARMOR),
    ItemData(22360103, "Dark Leggings", ItemCategory.ARMOR),
    ItemData(22370100, "Warlock Mask", ItemCategory.ARMOR),
    ItemData(22460100, "Tseldora Cap", ItemCategory.ARMOR),
    ItemData(22460101, "Tseldora Robe", ItemCategory.ARMOR),
    ItemData(22460102, "Tseldora Manchettes", ItemCategory.ARMOR),
    ItemData(22460103, "Tseldora Trousers", ItemCategory.ARMOR),
    ItemData(22480100, "Peasant Hat", ItemCategory.ARMOR),
    ItemData(22480101, "Peasant Attire", ItemCategory.ARMOR),
    ItemData(22480102, "Peasant Long Gloves", ItemCategory.ARMOR),
    ItemData(22480103, "Peasant Trousers", ItemCategory.ARMOR),
    ItemData(22510100, "Ironclad Helm", ItemCategory.ARMOR),
    ItemData(22510101, "Ironclad Armor", ItemCategory.ARMOR),
    ItemData(22510102, "Ironclad Gauntlets", ItemCategory.ARMOR),
    ItemData(22510103, "Ironclad Leggings", ItemCategory.ARMOR),
    ItemData(22512100, "Old Ironclad Helm", ItemCategory.ARMOR),
    ItemData(22512101, "Old Ironclad Armor", ItemCategory.ARMOR),
    ItemData(22512102, "Old Ironclad Gauntlets", ItemCategory.ARMOR),
    ItemData(22512103, "Old Ironclad Leggings", ItemCategory.ARMOR),
    ItemData(22520100, "Royal Swordsman Helm", ItemCategory.ARMOR),
    ItemData(22520101, "Royal Swordsman Armor", ItemCategory.ARMOR),
    ItemData(22520102, "Royal Swordsman Gloves", ItemCategory.ARMOR),
    ItemData(22520103, "Royal Swordsman Leggings", ItemCategory.ARMOR),
    ItemData(22530100, "Syan's Helm", ItemCategory.ARMOR),
    ItemData(22530101, "Syan's Armor", ItemCategory.ARMOR),
    ItemData(22530102, "Syan's Gauntlets", ItemCategory.ARMOR),
    ItemData(22530103, "Syan's Leggings", ItemCategory.ARMOR),
    ItemData(22540100, "Bone Crown", ItemCategory.ARMOR),
    ItemData(22540101, "Bone King Robe", ItemCategory.ARMOR),
    ItemData(22540102, "Bone King Cuffs", ItemCategory.ARMOR),
    ItemData(22540103, "Bone King Skirt", ItemCategory.ARMOR),
    ItemData(23010100, "Heide Knight Greathelm", ItemCategory.ARMOR),
    ItemData(23010101, "Heide Knight Chainmail", ItemCategory.ARMOR),
    ItemData(23010102, "Heide Knight Gauntlets", ItemCategory.ARMOR),
    ItemData(23010103, "Heide Knight Leggings", ItemCategory.ARMOR),
    ItemData(23011100, "Heide Knight Iron Mask", ItemCategory.ARMOR),
    ItemData(23040101, "Singer's Dress", ItemCategory.ARMOR),
    ItemData(23050100, "Smelter Demon Helm", ItemCategory.ARMOR),
    ItemData(23050101, "Smelter Demon Armor", ItemCategory.ARMOR),
    ItemData(23050102, "Smelter Demon Gauntlets", ItemCategory.ARMOR),
    ItemData(23050103, "Smelter Demon Leggings", ItemCategory.ARMOR),
    ItemData(23060100, "Alonne Captain Helm", ItemCategory.ARMOR),
    ItemData(23060101, "Alonne Captain Armor", ItemCategory.ARMOR),
    ItemData(23061100, "Alonne Knight Helm", ItemCategory.ARMOR),
    ItemData(23061101, "Alonne Knight Armor", ItemCategory.ARMOR),
    ItemData(23061102, "Alonne Knight Gauntlets", ItemCategory.ARMOR),
    ItemData(23061103, "Alonne Knight Leggings", ItemCategory.ARMOR),
    ItemData(23070100, "Vengarl's Helm", ItemCategory.ARMOR),
    ItemData(23070101, "Vengarl's Armor", ItemCategory.ARMOR),
    ItemData(23070102, "Vengarl's Gloves", ItemCategory.ARMOR),
    ItemData(23070103, "Vengarl's Boots", ItemCategory.ARMOR),
    ItemData(23080101, "Lion Warrior Cape", ItemCategory.ARMOR),
    ItemData(23080102, "Lion Warrior Cuffs", ItemCategory.ARMOR),
    ItemData(23080103, "Lion Warrior Skirt", ItemCategory.ARMOR),
    ItemData(23081100, "Lion Warrior Helm", ItemCategory.ARMOR),
    ItemData(23081101, "Red Lion Warrior Cape", ItemCategory.ARMOR),
    ItemData(23120100, "Grave Warden Mask", ItemCategory.ARMOR),
    ItemData(23120101, "Grave Warden Top", ItemCategory.ARMOR),
    ItemData(23120102, "Grave Warden Cuffs", ItemCategory.ARMOR),
    ItemData(23120103, "Grave Warden Bottoms", ItemCategory.ARMOR),
    ItemData(23130100, "Falconer Helm", ItemCategory.ARMOR),
    ItemData(23130101, "Falconer Armor", ItemCategory.ARMOR),
    ItemData(23130102, "Falconer Gloves", ItemCategory.ARMOR),
    ItemData(23130103, "Falconer Boots", ItemCategory.ARMOR),
    ItemData(23140100, "Rusted Mastodon Helm", ItemCategory.ARMOR),
    ItemData(23140101, "Rusted Mastodon Armor", ItemCategory.ARMOR),
    ItemData(23140102, "Rusted Mastodon Gauntlets", ItemCategory.ARMOR),
    ItemData(23140103, "Rusted Mastodon Leggings", ItemCategory.ARMOR),
    ItemData(23150100, "Mastodon Helm", ItemCategory.ARMOR),
    ItemData(23150101, "Mastodon Armor", ItemCategory.ARMOR),
    ItemData(23150102, "Mastodon Gauntlets", ItemCategory.ARMOR),
    ItemData(23150103, "Mastodon Leggings", ItemCategory.ARMOR),
    ItemData(23160100, "Desert Sorceress Hood", ItemCategory.ARMOR),
    ItemData(23160101, "Desert Sorceress Top", ItemCategory.ARMOR),
    ItemData(23160102, "Desert Sorceress Gloves", ItemCategory.ARMOR),
    ItemData(23160103, "Desert Sorceress Skirt", ItemCategory.ARMOR),
    ItemData(23170100, "Dragon Acolyte Mask", ItemCategory.ARMOR),
    ItemData(23170101, "Dragon Acolyte Robe", ItemCategory.ARMOR),
    ItemData(23170102, "Dragon Acolyte Gloves", ItemCategory.ARMOR),
    ItemData(23170103, "Dragon Acolyte Boots", ItemCategory.ARMOR),
    ItemData(23171100, "Dragon Sage Hood", ItemCategory.ARMOR),
    ItemData(23250100, "Ruin Helm", ItemCategory.ARMOR),
    ItemData(23250101, "Ruin Armor", ItemCategory.ARMOR),
    ItemData(23250102, "Ruin Gauntlets", ItemCategory.ARMOR),
    ItemData(23250103, "Ruin Leggings", ItemCategory.ARMOR),
    ItemData(23300100, "Old Knight Helm", ItemCategory.ARMOR),
    ItemData(23300101, "Old Knight Armor", ItemCategory.ARMOR),
    ItemData(23300102, "Old Knight Gauntlets", ItemCategory.ARMOR),
    ItemData(23300103, "Old Knight Leggings", ItemCategory.ARMOR),
    ItemData(23310100, "Drakekeeper Helm", ItemCategory.ARMOR),
    ItemData(23310101, "Drakekeeper Armor", ItemCategory.ARMOR),
    ItemData(23310102, "Drakekeeper Gauntlets", ItemCategory.ARMOR),
    ItemData(23310103, "Drakekeeper Boots", ItemCategory.ARMOR),
    ItemData(23320100, "Throne Defender Helm", ItemCategory.ARMOR),
    ItemData(23320101, "Throne Defender Armor", ItemCategory.ARMOR),
    ItemData(23320102, "Throne Defender Gauntlets", ItemCategory.ARMOR),
    ItemData(23320103, "Throne Defender Leggings", ItemCategory.ARMOR),
    ItemData(23330100, "Velstadt's Helm", ItemCategory.ARMOR),
    ItemData(23330101, "Velstadt's Armor", ItemCategory.ARMOR),
    ItemData(23330102, "Velstadt's Gauntlets", ItemCategory.ARMOR),
    ItemData(23330103, "Velstadt's Leggings", ItemCategory.ARMOR),
    ItemData(23340100, "Throne Watcher Helm", ItemCategory.ARMOR),
    ItemData(23340101, "Throne Watcher Armor", ItemCategory.ARMOR),
    ItemData(23340102, "Throne Watcher Gauntlets", ItemCategory.ARMOR),
    ItemData(23340103, "Throne Watcher Leggings", ItemCategory.ARMOR),
    ItemData(25040100, "Looking Glass Mask", ItemCategory.ARMOR),
    ItemData(25040101, "Looking Glass Armor", ItemCategory.ARMOR),
    ItemData(25040102, "Looking Glass Gauntlets", ItemCategory.ARMOR),
    ItemData(25040103, "Looking Glass Leggings", ItemCategory.ARMOR),
    ItemData(25060101, "Agdayne's Black Robe", ItemCategory.ARMOR),
    ItemData(25060102, "Agdayne's Cuffs", ItemCategory.ARMOR),
    ItemData(25060103, "Agdayne's Kilt", ItemCategory.ARMOR),
    ItemData(25090100, "Leydia Black Hood", ItemCategory.ARMOR),
    ItemData(25090101, "Leydia Black Robe", ItemCategory.ARMOR),
    ItemData(25100100, "Insolent Helm", ItemCategory.ARMOR),
    ItemData(25100101, "Insolent Armor", ItemCategory.ARMOR),
    ItemData(25100102, "Insolent Gloves", ItemCategory.ARMOR),
    ItemData(25100103, "Insolent Boots", ItemCategory.ARMOR),
    ItemData(25110100, "Imperious Helm", ItemCategory.ARMOR),
    ItemData(25110101, "Imperious Armor", ItemCategory.ARMOR),
    ItemData(25110102, "Imperious Gloves", ItemCategory.ARMOR),
    ItemData(25110103, "Imperious Leggings", ItemCategory.ARMOR),
    ItemData(25120100, "Leydia White Hood", ItemCategory.ARMOR),
    ItemData(25120101, "Leydia White Robe", ItemCategory.ARMOR),
    ItemData(25120102, "Leydia Gauntlets", ItemCategory.ARMOR),
    ItemData(25130100, "King's Crown", ItemCategory.ARMOR),
    ItemData(25130101, "King's Armor", ItemCategory.ARMOR),
    ItemData(25130102, "King's Gauntlets", ItemCategory.ARMOR),
    ItemData(25130103, "King's Leggings", ItemCategory.ARMOR),
    ItemData(26100100, "Dragonrider Helm", ItemCategory.ARMOR),
    ItemData(26100101, "Dragonrider Armor", ItemCategory.ARMOR),
    ItemData(26100102, "Dragonrider Gauntlets", ItemCategory.ARMOR),
    ItemData(26100103, "Dragonrider Leggings", ItemCategory.ARMOR),
    ItemData(26180100, "Executioner Helm", ItemCategory.ARMOR),
    ItemData(26180101, "Executioner Armor", ItemCategory.ARMOR),
    ItemData(26180102, "Executioner Gauntlets", ItemCategory.ARMOR),
    ItemData(26180103, "Executioner Leggings", ItemCategory.ARMOR),
    ItemData(26260100, "Penal Mask", ItemCategory.ARMOR),
    ItemData(26260101, "Penal Straightjacket", ItemCategory.ARMOR),
    ItemData(26260102, "Penal Handcuffs", ItemCategory.ARMOR),
    ItemData(26260103, "Penal Skirt", ItemCategory.ARMOR),
    # ItemData(26510000, ""),
    ItemData(26510100, "Fume Sorcerer Mask", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26510101, "Fume Sorcerer Robes", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26510102, "Fume Sorcerer Gloves", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26510103, "Fume Sorcerer Boots", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26590100, "Rampart Golem Helm", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26590101, "Rampart Golem Armor", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26590102, "Rampart Golem Gauntlets", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26590103, "Rampart Golem Leggings", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26650100, "Sanctum Knight Helm", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26650101, "Sanctum Knight Armor", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26650102, "Sanctum Knight Gauntlets", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26650103, "Sanctum Knight Leggings", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26660102, "Sanctum Soldier Gauntlet", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26700100, "Sanctum Priestess Tiara", ItemCategory.ARMOR, dlc=DLC.SUNKEN_KING),
    ItemData(26750100, "Raime's Helm", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26750101, "Raime's Armor", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26750102, "Raime's Gauntlets", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26750103, "Raime's Leggings", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26770101, "Retainer Robe", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26800100, "Alonne's Helm", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26800101, "Alonne's Armor", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26800102, "Alonne's Gauntlets", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    ItemData(26800103, "Alonne's Leggings", ItemCategory.ARMOR, dlc=DLC.OLD_IRON_KING),
    # ItemData(26880000, ""),
    ItemData(26880100, "Loyce Helm", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26880101, "Loyce Armor", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26880102, "Loyce Gauntlets", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26880103, "Loyce Leggings", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    # ItemData(26890000, ""),
    ItemData(26890100, "Charred Loyce Helm", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26890101, "Charred Loyce Armor", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26890102, "Charred Loyce Gauntlets", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26890103, "Charred Loyce Leggings", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26900100, "Ivory King Helm", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26900101, "Ivory King Armor", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26900102, "Ivory King Gauntlets", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26900103, "Ivory King Leggings", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(26940100, "Hood of the Forlorn", ItemCategory.ARMOR, sotfs=True),
    ItemData(26940101, "Armor of the Forlorn", ItemCategory.ARMOR, sotfs=True),
    ItemData(26940102, "Gauntlets of the Forlorn", ItemCategory.ARMOR, sotfs=True),
    ItemData(26940103, "Leggings of the Forlorn", ItemCategory.ARMOR, sotfs=True),
    ItemData(27210101, "Llewellyn Armor", ItemCategory.ARMOR),
    ItemData(27210102, "Llewellyn Gloves", ItemCategory.ARMOR),
    ItemData(27210103, "Llewellyn Shoes", ItemCategory.ARMOR),
    ItemData(27240100, "Drangleic Helm", ItemCategory.ARMOR),
    ItemData(27240101, "Drangleic Mail", ItemCategory.ARMOR),
    ItemData(27240102, "Drangleic Gauntlets", ItemCategory.ARMOR),
    ItemData(27240103, "Drangleic Leggings", ItemCategory.ARMOR),
    ItemData(27420100, "Creighton's Steel Mask", ItemCategory.ARMOR),
    ItemData(27420101, "Creighton's Chainmail", ItemCategory.ARMOR),
    ItemData(27420102, "Creighton's Chain Gloves", ItemCategory.ARMOR),
    ItemData(27420103, "Creighton's Chain Leggings", ItemCategory.ARMOR),
    ItemData(27430100, "Benhart's Knight Helm", ItemCategory.ARMOR),
    ItemData(27430101, "Benhart's Armor", ItemCategory.ARMOR),
    ItemData(27430102, "Benhart's Gauntlets", ItemCategory.ARMOR),
    ItemData(27430103, "Benhart's Boots", ItemCategory.ARMOR),
    ItemData(27440100, "Standard Helm", ItemCategory.ARMOR),
    ItemData(27440101, "Hard Leather Armor", ItemCategory.ARMOR),
    ItemData(27440102, "Hard Leather Gauntlets", ItemCategory.ARMOR),
    ItemData(27440103, "Hard Leather Boots", ItemCategory.ARMOR),
    ItemData(27510100, "Cale's Helm", ItemCategory.ARMOR),
    ItemData(27510101, "Cale's Leather Armor", ItemCategory.ARMOR),
    ItemData(27510103, "Cale's Shoes", ItemCategory.ARMOR),
    ItemData(27520100, "Lucatiel's Mask", ItemCategory.ARMOR),
    ItemData(27520101, "Lucatiel's Vest", ItemCategory.ARMOR),
    ItemData(27520102, "Lucatiel's Gloves", ItemCategory.ARMOR),
    ItemData(27520103, "Lucatiel's Trousers", ItemCategory.ARMOR),
    ItemData(27521100, "Mirrah Hat", ItemCategory.ARMOR, dlc=DLC.IVORY_KING),
    ItemData(27530100, "Bell Keeper Helmet", ItemCategory.ARMOR),
    ItemData(27530101, "Bell Keeper Bellyband", ItemCategory.ARMOR),
    ItemData(27530102, "Bell Keeper Cuffs", ItemCategory.ARMOR),
    ItemData(27530103, "Bell Keeper Trousers", ItemCategory.ARMOR),
    ItemData(27550100, "Mad Warrior Mask", ItemCategory.ARMOR),
    ItemData(27550101, "Mad Warrior Armor", ItemCategory.ARMOR),
    ItemData(27550102, "Mad Warrior Gauntlets", ItemCategory.ARMOR),
    ItemData(27550103, "Mad Warrior Leggings", ItemCategory.ARMOR),
    ItemData(27680100, "Black Hood", ItemCategory.ARMOR),
    ItemData(27680101, "Black Robes", ItemCategory.ARMOR),
    ItemData(27680102, "Black Gloves", ItemCategory.ARMOR),
    ItemData(27680103, "Black Boots", ItemCategory.ARMOR),
    ItemData(27690100, "Saint's Hood", ItemCategory.ARMOR),
    ItemData(27690101, "Saint's Dress", ItemCategory.ARMOR),
    ItemData(27690102, "Saint's Long Gloves", ItemCategory.ARMOR),
    ItemData(27690103, "Saint's Trousers", ItemCategory.ARMOR),
    ItemData(27700100, "Hexer's Hood", ItemCategory.ARMOR),
    ItemData(27700101, "Hexer's Robes", ItemCategory.ARMOR),
    ItemData(27700102, "Hexer's Gloves", ItemCategory.ARMOR),
    ItemData(27700103, "Hexer's Boots", ItemCategory.ARMOR),
    ItemData(27710100, "Chaos Hood", ItemCategory.ARMOR),
    ItemData(27710101, "Chaos Robe", ItemCategory.ARMOR),
    ItemData(27710102, "Chaos Gloves", ItemCategory.ARMOR),
    ItemData(27710103, "Chaos Boots", ItemCategory.ARMOR),
    ItemData(27830100, "Nahr Alma Hood", ItemCategory.ARMOR),
    ItemData(27830101, "Nahr Alma Robes", ItemCategory.ARMOR),
    ItemData(27950100, "Targray's Helm", ItemCategory.ARMOR),
    ItemData(27950101, "Targray's Armor", ItemCategory.ARMOR),
    ItemData(27950102, "Targray's Manifers", ItemCategory.ARMOR),
    ItemData(27950103, "Targray's Leggings", ItemCategory.ARMOR),
    ItemData(31010000, "Soul Arrow", ItemCategory.SPELL),
    ItemData(31020000, "Great Soul Arrow", ItemCategory.SPELL),
    ItemData(31030000, "Heavy Soul Arrow", ItemCategory.SPELL),
    ItemData(31040000, "Great Heavy Soul Arrow", ItemCategory.SPELL),
    ItemData(31050000, "Homing Soul Arrow", ItemCategory.SPELL),
    ItemData(31060000, "Heavy Homing Soul Arrow", ItemCategory.SPELL),
    ItemData(31070000, "Homing Soulmass", ItemCategory.SPELL),
    ItemData(31080000, "Homing Crystal Soulmass", ItemCategory.SPELL),
    ItemData(31090000, "Soul Spear", ItemCategory.SPELL),
    ItemData(31100000, "Crystal Soul Spear", ItemCategory.SPELL),
    ItemData(31110000, "Shockwave", ItemCategory.SPELL),
    ItemData(31120000, "Soul Spear Barrage", ItemCategory.SPELL),
    ItemData(31130000, "Soul Shower", ItemCategory.SPELL),
    ItemData(31140000, "Soul Greatsword", ItemCategory.SPELL),
    ItemData(31150000, "Soul Vortex", ItemCategory.SPELL),
    ItemData(31160000, "Soul Bolt", ItemCategory.SPELL),
    ItemData(31170000, "Soul Geyser", ItemCategory.SPELL),
    ItemData(31180000, "Magic Weapon", ItemCategory.SPELL),
    ItemData(31190000, "Great Magic Weapon", ItemCategory.SPELL),
    ItemData(31200000, "Crystal Magic Weapon", ItemCategory.SPELL),
    ItemData(31210000, "Strong Magic Shield", ItemCategory.SPELL),
    ItemData(31220000, "Yearn", ItemCategory.SPELL),
    ItemData(31230000, "Hush", ItemCategory.SPELL),
    ItemData(31240000, "Fall Control", ItemCategory.SPELL),
    ItemData(31250000, "Hidden Weapon", ItemCategory.SPELL),
    ItemData(31260000, "Repair", ItemCategory.SPELL),
    ItemData(31270000, "Cast Light", ItemCategory.SPELL),
    ItemData(31280000, "Chameleon", ItemCategory.SPELL),
    ItemData(31290000, "Unleash Magic", ItemCategory.SPELL),
    ItemData(31300000, "Soul Flash", ItemCategory.SPELL, dlc=DLC.IVORY_KING),
    ItemData(31310000, "Focus Souls", ItemCategory.SPELL, dlc=DLC.SUNKEN_KING),
    ItemData(32010000, "Heal", ItemCategory.SPELL),
    ItemData(32020000, "Med Heal", ItemCategory.SPELL),
    ItemData(32030000, "Great Heal Excerpt", ItemCategory.SPELL),
    ItemData(32040000, "Great Heal", ItemCategory.SPELL),
    ItemData(32050000, "Soothing Sunlight", ItemCategory.SPELL),
    ItemData(32060000, "Replenishment", ItemCategory.SPELL),
    ItemData(32070000, "Resplendent Life", ItemCategory.SPELL),
    ItemData(32080000, "Bountiful Sunlight", ItemCategory.SPELL),
    ItemData(32090000, "Caressing Prayer", ItemCategory.SPELL),
    ItemData(32100000, "Force", ItemCategory.SPELL),
    ItemData(32110000, "Wrath of the Gods", ItemCategory.SPELL),
    ItemData(32120000, "Emit Force", ItemCategory.SPELL),
    ItemData(32130000, "Heavenly Thunder", ItemCategory.SPELL),
    ItemData(32140000, "Lightning Spear", ItemCategory.SPELL),
    ItemData(32150000, "Great Lightning Spear", ItemCategory.SPELL),
    ItemData(32160000, "Sunlight Spear", ItemCategory.SPELL),
    ItemData(32170000, "Soul Appease", ItemCategory.SPELL),
    ItemData(32180000, "Blinding Bolt", ItemCategory.SPELL),
    ItemData(32190000, "Magic Barrier", ItemCategory.SPELL),
    ItemData(32200000, "Great Magic Barrier", ItemCategory.SPELL),
    ItemData(32210000, "Homeward", ItemCategory.SPELL),
    ItemData(32220000, "Guidance", ItemCategory.SPELL),
    ItemData(32230000, "Sacred Oath", ItemCategory.SPELL),
    ItemData(32240000, "Unveil", ItemCategory.SPELL),
    ItemData(32250000, "Perseverance", ItemCategory.SPELL),
    ItemData(32260000, "Sunlight Blade", ItemCategory.SPELL),
    ItemData(32300000, "Denial", ItemCategory.SPELL, dlc=DLC.SUNKEN_KING),
    ItemData(32310000, "Splintering Lightning Spear", ItemCategory.SPELL, dlc=DLC.IVORY_KING),
    ItemData(33010000, "Fireball", ItemCategory.SPELL),
    ItemData(33020000, "Fire Orb", ItemCategory.SPELL),
    ItemData(33030000, "Great Fireball", ItemCategory.SPELL),
    ItemData(33040000, "Great Chaos Fireball", ItemCategory.SPELL),
    ItemData(33050000, "Firestorm", ItemCategory.SPELL),
    ItemData(33060000, "Fire Tempest", ItemCategory.SPELL),
    ItemData(33070000, "Chaos Storm", ItemCategory.SPELL),
    ItemData(33080000, "Combustion", ItemCategory.SPELL),
    ItemData(33090000, "Great Combustion", ItemCategory.SPELL),
    ItemData(33100000, "Fire Whip", ItemCategory.SPELL),
    ItemData(33110000, "Poison Mist", ItemCategory.SPELL),
    ItemData(33120000, "Toxic Mist", ItemCategory.SPELL),
    ItemData(33130000, "Acid Surge", ItemCategory.SPELL),
    ItemData(33140000, "Lingering Flame", ItemCategory.SPELL),
    ItemData(33150000, "Flame Swathe", ItemCategory.SPELL),
    ItemData(33160000, "Forbidden Sun", ItemCategory.SPELL),
    ItemData(33170000, "Flame Weapon", ItemCategory.SPELL),
    ItemData(33180000, "Flash Sweat", ItemCategory.SPELL),
    ItemData(33190000, "Iron Flesh", ItemCategory.SPELL),
    ItemData(33200000, "Warmth", ItemCategory.SPELL),
    ItemData(33210000, "Immolation", ItemCategory.SPELL),
    ItemData(33300000, "Fire Snake", ItemCategory.SPELL, dlc=DLC.OLD_IRON_KING),
    ItemData(33310000, "Dance of Fire", ItemCategory.SPELL, dlc=DLC.OLD_IRON_KING),
    ItemData(33320000, "Outcry", ItemCategory.SPELL, dlc=DLC.OLD_IRON_KING),
    ItemData(34010000, "Dark Orb", ItemCategory.SPELL),
    ItemData(34020000, "Dark Hail", ItemCategory.SPELL),
    ItemData(34030000, "Dark Fog", ItemCategory.SPELL),
    ItemData(34040000, "Affinity", ItemCategory.SPELL),
    ItemData(34050000, "Dead Again", ItemCategory.SPELL),
    ItemData(34060000, "Dark Weapon", ItemCategory.SPELL),
    ItemData(34070000, "Whisper of Despair", ItemCategory.SPELL),
    ItemData(34080000, "Repel", ItemCategory.SPELL),
    ItemData(34090000, "Twisted Barricade", ItemCategory.SPELL),
    ItemData(34100000, "Numbness", ItemCategory.SPELL),
    ItemData(34300000, "Dark Greatsword", ItemCategory.SPELL, dlc=DLC.SUNKEN_KING),
    ItemData(34310000, "Recollection", ItemCategory.SPELL, dlc=DLC.OLD_IRON_KING),
    ItemData(35010000, "Scraps of Life", ItemCategory.SPELL),
    ItemData(35020000, "Darkstorm", ItemCategory.SPELL),
    ItemData(35030000, "Resonant Soul", ItemCategory.SPELL),
    ItemData(35040000, "Great Resonant Soul", ItemCategory.SPELL),
    ItemData(35050000, "Climax", ItemCategory.SPELL),
    ItemData(35060000, "Resonant Flesh", ItemCategory.SPELL),
    ItemData(35070000, "Resonant Weapon", ItemCategory.SPELL),
    ItemData(35080000, "Lifedrain Patch", ItemCategory.SPELL),
    ItemData(35090000, "Profound Still", ItemCategory.SPELL),
    ItemData(35300000, "Promised Walk of Peace", ItemCategory.SPELL, dlc=DLC.SUNKEN_KING),
    ItemData(35310000, "Dark Dance", ItemCategory.SPELL, dlc=DLC.IVORY_KING),
    ItemData(40010000, "Life Ring", ItemCategory.RING),
    ItemData(40010001, "Life Ring+1", ItemCategory.RING),
    ItemData(40010002, "Life Ring+2", ItemCategory.RING),
    ItemData(40010003, "Life Ring+3", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(40020000, "Chloranthy Ring", ItemCategory.RING),
    ItemData(40020001, "Chloranthy Ring+1", ItemCategory.RING),
    ItemData(40020002, "Chloranthy Ring+2", ItemCategory.RING),
    ItemData(40030000, "Royal Soldier's Ring", ItemCategory.RING),
    ItemData(40030001, "Royal Soldier's Ring+1", ItemCategory.RING),
    ItemData(40030002, "Royal Soldier's Ring+2", ItemCategory.RING),
    ItemData(40040000, "First Dragon Ring", ItemCategory.RING),
    ItemData(40040001, "Second Dragon Ring", ItemCategory.RING),
    ItemData(40040002, "Third Dragon Ring", ItemCategory.RING),
    ItemData(40050000, "Ring of Steel Protection", ItemCategory.RING),
    ItemData(40050001, "Ring of Steel Protection+1", ItemCategory.RING),
    ItemData(40050002, "Ring of Steel Protection+2", ItemCategory.RING),
    ItemData(40060000, "Spell Quartz Ring", ItemCategory.RING),
    ItemData(40060001, "Spell Quartz Ring+1", ItemCategory.RING),
    ItemData(40060002, "Spell Quartz Ring+2", ItemCategory.RING),
    ItemData(40060003, "Spell Quartz Ring+3", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(40070000, "Flame Quartz Ring", ItemCategory.RING),
    ItemData(40070001, "Flame Quartz Ring+1", ItemCategory.RING),
    ItemData(40070002, "Flame Quartz Ring+2", ItemCategory.RING),
    ItemData(40070003, "Flame Quartz Ring+3", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(40080000, "Thunder Quartz Ring", ItemCategory.RING),
    ItemData(40080001, "Thunder Quartz Ring+1", ItemCategory.RING),
    ItemData(40080002, "Thunder Quartz Ring+2", ItemCategory.RING),
    ItemData(40080003, "Thunder Quartz Ring+3", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(40090000, "Dark Quartz Ring", ItemCategory.RING),
    ItemData(40090001, "Dark Quartz Ring+1", ItemCategory.RING),
    ItemData(40090002, "Dark Quartz Ring+2", ItemCategory.RING),
    ItemData(40090003, "Dark Quartz Ring+3", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(40100000, "Poisonbite Ring", ItemCategory.RING),
    ItemData(40100001, "Poisonbite Ring+1", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(40110000, "Bloodbite Ring", ItemCategory.RING),
    ItemData(40110001, "Bloodbite Ring+1", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(40120000, "Bracing Knuckle Ring", ItemCategory.RING),
    ItemData(40120001, "Bracing Knuckle Ring+1", ItemCategory.RING),
    ItemData(40120002, "Bracing Knuckle Ring+2", ItemCategory.RING),
    ItemData(40130000, "Cursebite Ring", ItemCategory.RING),
    ItemData(40135000, "Ash Knuckle Ring", ItemCategory.RING),
    ItemData(40140000, "Dispelling Ring", ItemCategory.RING),
    ItemData(40140001, "Dispelling Ring+1", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(40150000, "Ring of Resistance", ItemCategory.RING),
    ItemData(40150001, "Ring of Resistance+1", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(40160000, "Ring of Blades", ItemCategory.RING),
    ItemData(40160001, "Ring of Blades+1", ItemCategory.RING),
    ItemData(40160002, "Ring of Blades+2", ItemCategory.RING),
    ItemData(40210000, "Ring of Knowledge", ItemCategory.RING),
    ItemData(40220000, "Ring of Prayer", ItemCategory.RING),
    ItemData(40230000, "Stone Ring", ItemCategory.RING),
    ItemData(40260000, "Red Tearstone Ring", ItemCategory.RING),
    ItemData(40280000, "Blue Tearstone Ring", ItemCategory.RING),
    ItemData(40290000, "Ring of Giants", ItemCategory.RING),
    ItemData(40290001, "Ring of Giants+1", ItemCategory.RING),
    ItemData(40290002, "Ring of Giants+2", ItemCategory.RING),
    ItemData(40295000, "Old Leo Ring", ItemCategory.RING),
    ItemData(40300000, "Ring of Soul Protection", ItemCategory.RING),
    ItemData(40310000, "Ring of Life Protection", ItemCategory.RING),
    ItemData(40320000, "Lingering Dragoncrest Ring", ItemCategory.RING),
    ItemData(40320001, "Lingering Dragoncrest Ring+1", ItemCategory.RING),
    ItemData(40320002, "Lingering Dragoncrest Ring+2", ItemCategory.RING),
    ItemData(40330000, "Clear Bluestone Ring", ItemCategory.RING),
    ItemData(40330001, "Clear Bluestone Ring+1", ItemCategory.RING),
    ItemData(40330002, "Clear Bluestone Ring+2", ItemCategory.RING),
    ItemData(40340000, "Northern Ritual Band", ItemCategory.RING),
    ItemData(40340001, "Northern Ritual Band+1", ItemCategory.RING),
    ItemData(40340002, "Northern Ritual Band+2", ItemCategory.RING),
    ItemData(40350000, "Southern Ritual Band", ItemCategory.RING),
    ItemData(40350001, "Southern Ritual Band+1", ItemCategory.RING),
    ItemData(40350002, "Southern Ritual Band+2", ItemCategory.RING),
    ItemData(40360000, "Covetous Gold Serpent Ring", ItemCategory.RING),
    ItemData(40360001, "Covetous Gold Serpent Ring+1", ItemCategory.RING),
    ItemData(40360002, "Covetous Gold Serpent Ring+2", ItemCategory.RING),
    ItemData(40370000, "Covetous Silver Serpent Ring", ItemCategory.RING),
    ItemData(40370001, "Covetous Silver Serpent Ring+1", ItemCategory.RING),
    ItemData(40370002, "Covetous Silver Serpent Ring+2", ItemCategory.RING),
    ItemData(40390000, "Ring of the Evil Eye", ItemCategory.RING),
    ItemData(40390001, "Ring of the Evil Eye+1", ItemCategory.RING),
    ItemData(40390002, "Ring of the Evil Eye+2", ItemCategory.RING),
    ItemData(40400000, "Ring of Restoration", ItemCategory.RING),
    ItemData(40410000, "Ring of Binding", ItemCategory.RING),
    ItemData(40420000, "Silvercat Ring", ItemCategory.RING, classification = ItemClassification.progression),
    ItemData(40430000, "Redeye Ring", ItemCategory.RING),
    ItemData(40440000, "Gower's Ring of Protection", ItemCategory.RING),
    ItemData(40450000, "Name-engraved Ring", ItemCategory.RING, skip=True),
    ItemData(40460000, "Slumbering Dragoncrest Ring", ItemCategory.RING),
    ItemData(40470000, "Hawk Ring", ItemCategory.RING),
    ItemData(40480000, "Old Sun Ring", ItemCategory.RING),
    ItemData(40500000, "Illusory Ring of a Conqueror", ItemCategory.RING),
    ItemData(40510000, "King's Ring", ItemCategory.RING, classification = ItemClassification.progression),
    ItemData(40520000, "Ring of the Dead", ItemCategory.RING),
    ItemData(40530000, "Ring of Thorns", ItemCategory.RING),
    ItemData(40530001, "Ring of Thorns+1", ItemCategory.RING),
    ItemData(40530002, "Ring of Thorns+2", ItemCategory.RING),
    ItemData(40540000, "Delicate String", ItemCategory.RING),
    ItemData(40550000, "White Ring", ItemCategory.RING),
    ItemData(40610000, "Ring of Whispers", ItemCategory.RING, classification = ItemClassification.progression),
    ItemData(40620000, "Illusory Ring of the Exalted", ItemCategory.RING),
    ItemData(40700000, "Crest of the Rat", ItemCategory.RING),
    ItemData(40710000, "Bell Keeper's Seal", ItemCategory.RING, skip=True),
    ItemData(40720000, "Guardian's Seal", ItemCategory.RING, skip=True),
    ItemData(40730000, "Crest of Blood", ItemCategory.RING),
    ItemData(40740000, "Blue Seal", ItemCategory.RING),
    ItemData(40750000, "Abyss Seal", ItemCategory.RING),
    ItemData(40760000, "Vanquisher's Seal", ItemCategory.RING),
    ItemData(40770000, "Sun Seal", ItemCategory.RING),
    ItemData(40780000, "Ancient Dragon Seal", ItemCategory.RING),
    ItemData(41000000, "Simpleton's Ring", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(41010000, "Strength Ring", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(41020000, "Dexterity Ring", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(41030000, "Ivory Warrior Ring", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(41040000, "Sorcery Clutch Ring", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(41050000, "Lightning Clutch Ring", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(41060000, "Fire Clutch Ring", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(41070000, "Dark Clutch Ring", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(41090000, "Baneful Bird Ring", ItemCategory.RING, dlc=DLC.OLD_IRON_KING),
    ItemData(41100000, "Flynn's Ring", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(41110000, "Ring of the Embedded", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(41120000, "Ring of the Living", ItemCategory.RING, dlc=DLC.IVORY_KING),
    ItemData(41130000, "Yorgh's Ring", ItemCategory.RING, dlc=DLC.SUNKEN_KING),
    ItemData(42000000, "Agape Ring", ItemCategory.RING),
    ItemData(50600000, "Soldier Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50610000, "Key to King's Passage", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50800000, "Bastille Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50810000, "Iron Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50820000, "Forgotten Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50830000, "Brightstone Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50840000, "Antiquated Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50850000, "Fang Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50860000, "House Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50870000, "Lenigrast's Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50880000, "Smooth & Silky Stone", ItemCategory.CONSUMABLE),
    ItemData(50885000, "Small Smooth & Silky Stone", ItemCategory.CONSUMABLE),
    ItemData(50890000, "Rotunda Lockstone", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50900000, "Giant's Kinship", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50910000, "Ashen Mist Heart", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50920000, "Soul of a Giant", ItemCategory.CONSUMABLE, classification = ItemClassification.progression_deprioritized_skip_balancing),
    ItemData(50930000, "Tseldora Den Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50940000, "Champion's Tablet", ItemCategory.KEY_ITEM, skip=True),
    ItemData(50950000, "Ladder Miniature", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50960000, "Soul Vessel", ItemCategory.CONSUMABLE),
    ItemData(50970000, "Undead Lockaway Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(50990000, "Dull Ember", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(51000000, "Crushed Eye Orb", ItemCategory.KEY_ITEM, skip=True),
    ItemData(51010000, "Simpleton's Spice", ItemCategory.CONSUMABLE),
    ItemData(51020000, "Skeptic's Spice", ItemCategory.CONSUMABLE),
    ItemData(51030000, "Aldia Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    ItemData(52000000, "Dragon Talon", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.SUNKEN_KING, sotfs=True),
    ItemData(52100000, "Heavy Iron Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.OLD_IRON_KING, sotfs=True),
    ItemData(52200000, "Frozen Flower", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.IVORY_KING, sotfs=True),
    ItemData(52300000, "Eternal Sanctum Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.SUNKEN_KING),
    ItemData(52400000, "Tower Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.OLD_IRON_KING),
    ItemData(52500000, "Garrison Ward Key", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.IVORY_KING),
    ItemData(52650000, "Dragon Stone", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.SUNKEN_KING),
    ItemData(53100000, "Scorching Iron Scepter", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.OLD_IRON_KING),
    ItemData(53200000, "Smelter Wedge", ItemCategory.CONSUMABLE, dlc=DLC.OLD_IRON_KING, skip=True),
    ItemData(53200011, "Smelter Wedge x11", ItemCategory.KEY_ITEM, classification = ItemClassification.progression, dlc=DLC.OLD_IRON_KING),
    ItemData(53300000, "Soul of Nadalia, Bride of Ash", ItemCategory.CONSUMABLE, dlc=DLC.OLD_IRON_KING),
    ItemData(53600000, "Eye of the Priestess", ItemCategory.KEY_ITEM, dlc=DLC.IVORY_KING),
    ItemData(60010000, "Lifegem", ItemCategory.CONSUMABLE),
    ItemData(60020000, "Radiant Lifegem", ItemCategory.CONSUMABLE),
    ItemData(60030000, "Old Radiant Lifegem", ItemCategory.CONSUMABLE),
    ItemData(60035000, "Elizabeth Mushroom", ItemCategory.CONSUMABLE),
    ItemData(60036000, "Dried Root", ItemCategory.CONSUMABLE, dlc=DLC.ALL),
    ItemData(60040000, "Amber Herb", ItemCategory.CONSUMABLE),
    ItemData(60050000, "Twilight Herb", ItemCategory.CONSUMABLE),
    ItemData(60060000, "Wilted Dusk Herb", ItemCategory.CONSUMABLE),
    ItemData(60070000, "Poison Moss", ItemCategory.CONSUMABLE),
    ItemData(60090000, "Monastery Charm", ItemCategory.CONSUMABLE),
    ItemData(60100000, "Dragon Charm", ItemCategory.CONSUMABLE),
    ItemData(60105000, "Divine Blessing", ItemCategory.CONSUMABLE),
    ItemData(60110000, "Rouge Water", ItemCategory.CONSUMABLE),
    ItemData(60120000, "Crimson Water", ItemCategory.CONSUMABLE),
    ItemData(60151000, "Human Effigy", ItemCategory.CONSUMABLE),
    ItemData(60155000, "Estus Flask", ItemCategory.USABLE_ITEM, skip=True),
    # ItemData(60155010, "Estus Flask"),
    # ItemData(60155020, "Estus Flask"),
    # ItemData(60155030, "Estus Flask"),
    ItemData(60160000, "Small Blue Burr", ItemCategory.CONSUMABLE),
    ItemData(60170000, "Small Yellow Burr", ItemCategory.CONSUMABLE),
    ItemData(60180000, "Small Orange Burr", ItemCategory.CONSUMABLE),
    ItemData(60190000, "Dark Troches", ItemCategory.CONSUMABLE),
    ItemData(60200000, "Common Fruit", ItemCategory.CONSUMABLE),
    ItemData(60210000, "Red Leech Troches", ItemCategory.CONSUMABLE),
    ItemData(60230000, "Triclops Snake Troches", ItemCategory.CONSUMABLE),
    ItemData(60235000, "Old Growth Balm", ItemCategory.CONSUMABLE, dlc=DLC.ALL),
    ItemData(60236000, "Vine Balm", ItemCategory.CONSUMABLE, dlc=DLC.ALL),
    ItemData(60237000, "Blackweed Balm", ItemCategory.CONSUMABLE, dlc=DLC.ALL),
    ItemData(60238000, "Goldenfruit Balm", ItemCategory.CONSUMABLE, dlc=DLC.ALL),
    ItemData(60239000, "Brightbug", ItemCategory.CONSUMABLE),
    ItemData(60240000, "Aromatic Ooze", ItemCategory.CONSUMABLE),
    ItemData(60250000, "Gold Pine Resin", ItemCategory.CONSUMABLE),
    ItemData(60260000, "Charcoal Pine Resin", ItemCategory.CONSUMABLE),
    ItemData(60270000, "Dark Pine Resin", ItemCategory.CONSUMABLE),
    ItemData(60280000, "Rotten Pine Resin", ItemCategory.CONSUMABLE),
    ItemData(60290000, "Bleeding Serum", ItemCategory.CONSUMABLE),
    ItemData(60310000, "Green Blossom", ItemCategory.CONSUMABLE),
    ItemData(60320000, "Rusted Coin", ItemCategory.CONSUMABLE),
    ItemData(60350000, "Homeward Bone", ItemCategory.CONSUMABLE),
    ItemData(60355000, "Aged Feather", ItemCategory.USABLE_ITEM),
    ItemData(60360000, "Darksign", ItemCategory.USABLE_ITEM),
    ItemData(60370000, "Silver Talisman", ItemCategory.CONSUMABLE),
    ItemData(60405000, "Dragon Head Stone", ItemCategory.USABLE_ITEM),
    ItemData(60405010, "Dragon Head Stone", ItemCategory.USABLE_ITEM),
    ItemData(60406000, "Dragon Torso Stone", ItemCategory.USABLE_ITEM),
    ItemData(60406010, "Dragon Torso Stone", ItemCategory.USABLE_ITEM),
    ItemData(60410000, "Repair Powder", ItemCategory.CONSUMABLE),
    ItemData(60420000, "Torch", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(60430000, "Flame Butterfly", ItemCategory.CONSUMABLE),
    ItemData(60450000, "Prism Stone", ItemCategory.CONSUMABLE),
    ItemData(60470000, "Hello Carving", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(60480000, "Thank You Carving", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(60490000, "I'm Sorry Carving", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(60500000, "Very Good! Carving", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(60510000, "Rubbish", ItemCategory.CONSUMABLE, skip=True),
    ItemData(60511000, "Petrified Something", ItemCategory.CONSUMABLE),
    ItemData(60525000, "Estus Flask Shard", ItemCategory.HEALING, classification = ItemClassification.progression_deprioritized_skip_balancing),
    ItemData(60526000, "Sublime Bone Dust", ItemCategory.HEALING, classification = ItemClassification.progression_deprioritized_skip_balancing),
    ItemData(60527000, "Bonfire Ascetic", ItemCategory.CONSUMABLE),
    ItemData(60530000, "Alluring Skull", ItemCategory.CONSUMABLE),
    ItemData(60531000, "Lloyd's Talisman", ItemCategory.CONSUMABLE),
    ItemData(60536000, "Master Lockstone", ItemCategory.KEY_ITEM, classification = ItemClassification.progression),
    # ItemData(60537000, "Fragrant Branch of Yore", ItemCategory.CONSUMABLE, skip=True),
    ItemData(60538000, "Fire Seed", ItemCategory.UPGRADE_MATERIAL),
    ItemData(60540000, "Throwing Knife", ItemCategory.CONSUMABLE),
    ItemData(60550000, "Witching Urn", ItemCategory.CONSUMABLE),
    ItemData(60560000, "Lightning Urn", ItemCategory.CONSUMABLE),
    ItemData(60570000, "Firebomb", ItemCategory.CONSUMABLE),
    ItemData(60575000, "Black Firebomb", ItemCategory.CONSUMABLE),
    ItemData(60580000, "Hexing Urn", ItemCategory.CONSUMABLE),
    ItemData(60590000, "Poison Throwing Knife", ItemCategory.CONSUMABLE),
    ItemData(60595000, "Dung Pie", ItemCategory.CONSUMABLE),
    ItemData(60600000, "Lacerating Knife", ItemCategory.CONSUMABLE),
    ItemData(60610000, "Corrosive Urn", ItemCategory.CONSUMABLE),
    ItemData(60620000, "Holy Water Urn", ItemCategory.CONSUMABLE),
    ItemData(60625000, "Fading Soul", ItemCategory.CONSUMABLE),
    ItemData(60630000, "Soul of a Lost Undead", ItemCategory.CONSUMABLE),
    ItemData(60640000, "Large Soul of a Lost Undead", ItemCategory.CONSUMABLE),
    ItemData(60650000, "Soul of a Nameless Soldier", ItemCategory.CONSUMABLE),
    ItemData(60660000, "Large Soul of a Nameless Soldier", ItemCategory.CONSUMABLE),
    ItemData(60670000, "Soul of a Proud Knight", ItemCategory.CONSUMABLE),
    ItemData(60680000, "Large Soul of a Proud Knight", ItemCategory.CONSUMABLE),
    ItemData(60690000, "Soul of a Brave Warrior", ItemCategory.CONSUMABLE),
    ItemData(60700000, "Large Soul of a Brave Warrior", ItemCategory.CONSUMABLE),
    ItemData(60710000, "Soul of a Hero", ItemCategory.CONSUMABLE),
    ItemData(60720000, "Soul of a Great Hero", ItemCategory.CONSUMABLE),
    ItemData(60760000, "Wood Arrow", ItemCategory.AMMO),
    ItemData(60770000, "Iron Arrow", ItemCategory.AMMO),
    ItemData(60780000, "Magic Arrow", ItemCategory.AMMO),
    ItemData(60790000, "Lightning Arrow", ItemCategory.AMMO),
    ItemData(60800000, "Fire Arrow", ItemCategory.AMMO),
    ItemData(60810000, "Dark Arrow", ItemCategory.AMMO),
    ItemData(60820000, "Poison Arrow", ItemCategory.AMMO),
    ItemData(60830000, "Lacerating Arrow", ItemCategory.AMMO),
    ItemData(60850000, "Iron Greatarrow", ItemCategory.AMMO),
    ItemData(60870000, "Lightning Greatarrow", ItemCategory.AMMO),
    ItemData(60880000, "Fire Greatarrow", ItemCategory.AMMO),
    ItemData(60900000, "Destructive Greatarrow", ItemCategory.AMMO),
    ItemData(60910000, "Wood Bolt", ItemCategory.AMMO),
    ItemData(60920000, "Heavy Bolt", ItemCategory.AMMO),
    ItemData(60930000, "Magic Bolt", ItemCategory.AMMO),
    ItemData(60940000, "Lightning Bolt", ItemCategory.AMMO),
    ItemData(60950000, "Fire Bolt", ItemCategory.AMMO),
    ItemData(60960000, "Dark Bolt", ItemCategory.AMMO),
    ItemData(60970000, "Titanite Shard", ItemCategory.UPGRADE_MATERIAL),
    ItemData(60975000, "Large Titanite Shard", ItemCategory.UPGRADE_MATERIAL),
    ItemData(60980000, "Titanite Chunk", ItemCategory.UPGRADE_MATERIAL),
    ItemData(60990000, "Titanite Slab", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61000000, "Twinkling Titanite", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61030000, "Petrified Dragon Bone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61060000, "Faintstone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61070000, "Boltstone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61080000, "Firedrake Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61090000, "Darknight Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61100000, "Poison Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61110000, "Bleed Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61130000, "Raw Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61140000, "Magic Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61150000, "Old Mundane Stone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(61160000, "Palestone", ItemCategory.UPGRADE_MATERIAL),
    ItemData(62000000, "Dried Fingers", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62020000, "Bone of Order", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62030000, "White Sign Soapstone", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62040000, "Small White Sign Soapstone", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62045000, "Red Sign Soapstone", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62050000, "Cracked Blue Eye Orb", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62060000, "Cracked Red Eye Orb", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62070000, "Dragon Eye", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62100000, "Token of Fidelity", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62110000, "Token of Spite", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62120000, "Sunlight Medal", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62130000, "Dragon Scale", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62140000, "Rat Tail", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62150000, "Awestone", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62160000, "Black Separation Crystal", ItemCategory.USABLE_ITEM, skip=True),
    ItemData(62170000, "Seed of a Tree of Giants", ItemCategory.CONSUMABLE, skip=True),
    ItemData(62190000, "Petrified Egg", ItemCategory.KEY_ITEM),
    ItemData(63000000, "'Point' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63001000, "'I won't bite' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63003000, "'Bow' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63004000, "'Welcome' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63005000, "'Duel bow' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63006000, "'Wave' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63007000, "'Pumped up' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63008000, "'Joy' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63009000, "'Warcry' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63010000, "'Warmup' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63011000, "'Hurrah!' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63012000, "'Righty-ho!' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63013000, "'No way' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63014000, "'This one's me' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63015000, "'Have mercy!' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63016000, "'Prostration' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63017000, "'Decapitate' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63018000, "'Fist pump' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63019000, "'Mock' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(63021000, "'Praise the Sun' Gesture", ItemCategory.GESTURE, skip=True),
    ItemData(64000000, "Soul of the Pursuer", ItemCategory.CONSUMABLE),
    ItemData(64010000, "Soul of the Last Giant", ItemCategory.CONSUMABLE),
    ItemData(64020000, "Dragonrider Soul", ItemCategory.CONSUMABLE),
    ItemData(64030000, "Old Dragonslayer Soul", ItemCategory.CONSUMABLE),
    ItemData(64040000, "Flexile Sentry Soul", ItemCategory.CONSUMABLE),
    ItemData(64050000, "Ruin Sentinel Soul", ItemCategory.CONSUMABLE),
    ItemData(64060000, "Soul of the Lost Sinner", ItemCategory.CONSUMABLE),
    ItemData(64070000, "Executioner's Chariot Soul", ItemCategory.CONSUMABLE),
    ItemData(64080000, "Skeleton Lord's Soul", ItemCategory.CONSUMABLE),
    ItemData(64090000, "Covetous Demon Soul", ItemCategory.CONSUMABLE),
    ItemData(64100000, "Mytha, the Baneful Queen Soul", ItemCategory.CONSUMABLE),
    ItemData(64110000, "Smelter Demon Soul", ItemCategory.CONSUMABLE),
    ItemData(64120000, "Old Iron King Soul", ItemCategory.CONSUMABLE),
    ItemData(64130000, "Royal Rat Vanguard Soul", ItemCategory.CONSUMABLE),
    ItemData(64140000, "Soul of the Rotten", ItemCategory.CONSUMABLE),
    ItemData(64150000, "Scorpioness Najka Soul", ItemCategory.CONSUMABLE),
    ItemData(64160000, "Royal Rat Authority Soul", ItemCategory.CONSUMABLE),
    ItemData(64170000, "Soul of the Duke's Dear Freja", ItemCategory.CONSUMABLE),
    ItemData(64180000, "Looking Glass Knight Soul", ItemCategory.CONSUMABLE),
    ItemData(64190000, "Demon of Song Soul", ItemCategory.CONSUMABLE),
    ItemData(64200000, "Soul of Velstadt", ItemCategory.CONSUMABLE),
    ItemData(64210000, "Soul of the King", ItemCategory.CONSUMABLE),
    ItemData(64220000, "Guardian Dragon Soul", ItemCategory.CONSUMABLE),
    ItemData(64230000, "Ancient Dragon Soul", ItemCategory.CONSUMABLE),
    ItemData(64240000, "Giant Lord Soul", ItemCategory.CONSUMABLE),
    ItemData(64250000, "Soul of Nashandra", ItemCategory.CONSUMABLE),
    ItemData(64260000, "Throne Defender Soul", ItemCategory.CONSUMABLE),
    ItemData(64270000, "Throne Watcher Soul", ItemCategory.CONSUMABLE),
    ItemData(64280000, "Darklurker Soul", ItemCategory.CONSUMABLE),
    ItemData(64290000, "Belfry Gargoyle Soul", ItemCategory.CONSUMABLE),
    ItemData(64300000, "Old Witch Soul", ItemCategory.CONSUMABLE),
    ItemData(64310000, "Old King Soul", ItemCategory.CONSUMABLE),
    ItemData(64320000, "Old Dead One Soul", ItemCategory.CONSUMABLE),
    ItemData(64330000, "Old Paledrake Soul", ItemCategory.CONSUMABLE),
    ItemData(64500000, "Soul of Sinh, the Slumbering Dragon", ItemCategory.CONSUMABLE, dlc=DLC.SUNKEN_KING),
    ItemData(64510000, "Soul of the Fume Knight", ItemCategory.CONSUMABLE, dlc=DLC.OLD_IRON_KING),
    ItemData(64520000, "Soul of Aava, the King's Pet", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
    ItemData(64530000, "Soul of Elana, Squalid Queen", ItemCategory.CONSUMABLE, dlc=DLC.SUNKEN_KING),
    ItemData(64540000, "Soul of Nadalia, Bride of Ash", ItemCategory.CONSUMABLE, dlc=DLC.OLD_IRON_KING),
    ItemData(64550000, "Soul of Alsanna, Silent Oracle", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
    ItemData(64560000, "Soul of Sir Alonne", ItemCategory.CONSUMABLE, dlc=DLC.OLD_IRON_KING),
    ItemData(64580000, "Soul of the Ivory King", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
    ItemData(64590000, "Soul of Zallen, the King's Pet", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
    ItemData(64600000, "Loyce Soul", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
    ItemData(64610000, "Soul of Lud, the King's Pet", ItemCategory.CONSUMABLE, dlc=DLC.IVORY_KING),
]

category_names = {
    ItemCategory.ARMOR: "Armor",
    ItemCategory.CONSUMABLE: "Consumables",
    ItemCategory.USABLE_ITEM: "Usable Items",
    ItemCategory.UPGRADE_MATERIAL: "Upgrade Materials",
    ItemCategory.GESTURE: "Gestures",
    ItemCategory.KEY_ITEM: "Key Items",
    ItemCategory.WEAPON: "Weapons",
    ItemCategory.AMMO: "Ammo",
    ItemCategory.RING: "Rings",
    ItemCategory.SHIELD: "Shields",
    ItemCategory.SPELL: "Spells",
    ItemCategory.STAFF_OR_CHIME: "Staffs and Chimes",
    ItemCategory.STATUE: "Statues",
    ItemCategory.HEALING: "Estus Upgrades",
}

group_table: Dict[str, Set[str]] = {
    "Pharros' Lockstone": {
        "Master Lockstone"
    },
}

group_table["Fragrant Branch of Yore"] = [item.name for item in item_list if item.category == ItemCategory.STATUE]

for item in item_list:
    if item.skip: continue
    category_name = category_names[item.category]
    if category_name not in group_table:
        group_table[category_name] = {item.name}
    else:
        group_table[category_name].add(item.name)
