"""Stores the data for the locations of colored bananas and balloons in DK Isles."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Settings import DamageAmount
from randomizer.Enums.Switches import Switches
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    # Treehouse
    ColoredBananaGroup(
        group=1,
        map_id=Maps.Treehouse,
        name="Next to the Radio",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Treehouse,
        locations=[
            [5, 1.0, 398, 90, 421],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.Treehouse,
        name="On the crate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Treehouse,
        locations=[
            [5, 1.0, 394, 130, 569],
        ],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.Treehouse,
        name="On the hammock",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Treehouse,
        locations=[
            [5, 1.0, 258, 131, 472],
        ],
    ),
    # Training Grounds
    ColoredBananaGroup(
        group=4,
        map_id=Maps.TrainingGrounds,
        name="Treehouse balcony",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [1, 1.0, 1410, 227, 1080],
            [1, 1.0, 1377, 227, 1080],
            [1, 1.0, 1344, 227, 1080],
            [1, 1.0, 1311, 227, 1080],
            [1, 1.0, 1278, 227, 1080],
        ],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.TrainingGrounds,
        name="Windowsills",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1266, 249, 1157],
            [5, 1.0, 1264, 249, 1217],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.TrainingGrounds,
        name="Tree front of treehouse",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1405, 228, 1003],
        ],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.TrainingGrounds,
        name="Tree right of treehouse",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1131, 243, 1112],
        ],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.TrainingGrounds,
        name="Tree next to rear tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 1201, 250, 1511],
        ],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.TrainingGrounds,
        name="On exit ledge",
        konglist=[Kongs.tiny],
        region=Regions.TrainingGrounds,
        logic=lambda l: (l.istiny and l.twirl) and l.climbing,
        locations=[
            [1, 1.0, 1032, 236, 565],
            [1, 1.0, 1026, 228, 629],
            [1, 1.0, 1022, 217, 716],
            [1, 1.0, 1076, 215, 777],
            [1, 1.0, 1173, 224, 811],
            [1, 1.0, 1292, 209, 765],
            [1, 1.0, 1403, 230, 770],
            [1, 1.0, 1495, 226, 791],
            [1, 1.0, 1572, 224, 801],
            [1, 1.0, 1691, 225, 787],
        ],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.TrainingGrounds,
        name="On rear ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing,
        locations=[
            [1, 1.0, 1002, 253, 1895],
            [1, 1.0, 1003, 248, 1853],
            [1, 1.0, 1007, 242, 1805],
            [1, 1.0, 1008, 233, 1741],
            [1, 1.0, 1071, 230, 1700],
            [1, 1.0, 1166, 240, 1750],
            [1, 1.0, 1266, 235, 1702],
            [1, 1.0, 1371, 253, 1727],
            [1, 1.0, 1489, 239, 1765],
            [1, 1.0, 1579, 230, 1733],
        ],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.TrainingGrounds,
        name="Path to Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1187, 37, 1389],
            [1, 1.0, 1165, 37, 1433],
            [1, 1.0, 1132, 38, 1470],
            [1, 1.0, 1092, 40, 1506],
            [1, 1.0, 1053, 41, 1536],
            [1, 1.0, 1014, 44, 1569],
            [1, 1.0, 976, 54, 1599],
            [1, 1.0, 938, 60, 1627],
            [1, 1.0, 896, 66, 1660],
            [1, 1.0, 849, 66, 1699],
        ],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.TrainingGrounds,
        name="Around Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 674, 75, 1902],
            [1, 1.0, 683, 73, 1860],
            [1, 1.0, 670, 73, 1819],
            [1, 1.0, 636, 73, 1795],
            [1, 1.0, 597, 75, 1789],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.TrainingGrounds,
        name="Next to Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [5, 1.0, 544, 80, 1822],
            [5, 1.0, 630, 75, 1941],
        ],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.TrainingGrounds,
        name="Path to training area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1165, 31, 1096],
            [1, 1.0, 1099, 26, 1050],
            [1, 1.0, 1038, 26, 984],
            [1, 1.0, 984, 28, 905],
            [1, 1.0, 940, 45, 823],
        ],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.TrainingGrounds,
        name="In the lake",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.swim,
        locations=[
            [5, 1.0, 1888, -182, 985],
            [5, 1.0, 1888, -182, 1111],
            [5, 1.0, 1888, -182, 1236],
        ],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.TrainingGrounds,
        name="Behind the waterfall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [5, 1.3, 2011, 7, 1188],
        ],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.TrainingGrounds,
        name="Banana hoard tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.can_use_vines and l.climbing,
        locations=[
            [1, 1.0, 2073, 211, 1180],
            [1, 1.0, 2125, 211, 1201],
            [1, 1.0, 2172, 211, 1238],
            [1, 1.0, 2213, 211, 1269],
            [1, 1.0, 2259, 211, 1301],
            [1, 1.0, 2302, 211, 1326],
            [1, 1.0, 2345, 211, 1328],
            [1, 1.0, 2410, 211, 1327],
            [1, 1.0, 2467, 211, 1303],
            [1, 1.0, 2497, 211, 1244],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.TrainingGrounds,
        name="Banana hoard room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.can_use_vines and l.climbing,
        locations=[
            [5, 1.0, 2422, 216, 1108],
            [5, 1.0, 2422, 216, 954],
            [5, 1.0, 2580, 216, 954],
            [5, 1.0, 2580, 216, 1108],
        ],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.TrainingGrounds,
        name="Rear tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1330, 38, 1692],
            [1, 1.0, 1325, 38, 1844],
            [1, 1.0, 1439, 38, 1991],
            [1, 1.0, 1447, 39, 2162],
            [1, 1.0, 1365, 39, 2216],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.TrainingGrounds,
        name="Around rear dirt patch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1239, 37, 2219],
            [1, 1.0, 1248, 37, 2207],
            [1, 1.0, 1248, 37, 2191],
            [1, 1.0, 1239, 37, 2179],
            [1, 1.0, 1224, 37, 2174],
            [1, 1.0, 1209, 37, 2179],
            [1, 1.0, 1200, 37, 2191],
            [1, 1.0, 1200, 37, 2207],
            [1, 1.0, 1209, 37, 2219],
            [1, 1.0, 1224, 37, 2224],
        ],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.TrainingGrounds,
        name="Exit tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1347, 17, 779],
            [1, 1.0, 1336, 17, 675],
            [1, 1.0, 1325, 17, 571],
            [1, 1.0, 1315, 17, 468],
            [1, 1.0, 1304, 17, 364],
            [1, 1.0, 1333, 17, 296],
            [1, 1.0, 1379, 17, 240],
            [1, 1.0, 1436, 17, 200],
            [1, 1.0, 1491, 17, 206],
            [1, 1.0, 1550, 17, 243],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.TrainingGrounds,
        name="Tree in training area",
        konglist=[Kongs.tiny],
        region=Regions.TrainingGrounds,
        logic=lambda l: l.climbing and (l.istiny and l.twirl),
        locations=[
            [5, 1.0, 810, 244, 710],
        ],
    ),
    # ColoredBananaGroup(
    #     group=23,
    #     map_id=Maps.TrainingGrounds,
    #     name="Treehouse roof",
    #     konglist=[Kongs.lanky],
    #     region=Regions.TrainingGrounds,
    #     logic=lambda l: l.handstand,
    #     locations=[
    #         [5, 1.0, 1343, 352, 1147],
    #         [5, 1.0, 1343, 352, 1204],
    #         [5, 1.0, 1343, 352, 1261],
    #     ],
    # ), @Bismuth
    ColoredBananaGroup(
        group=24,
        map_id=Maps.TrainingGrounds,
        name="Around treehouse tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 1351, 37, 1127],
            [1, 1.0, 1419, 37, 1152],
            [1, 1.0, 1443, 37, 1222],
            [1, 1.0, 1432, 37, 1283],
            [1, 1.0, 1394, 38, 1311],
            [1, 1.0, 1333, 38, 1310],
            [1, 1.0, 1279, 37, 1274],
            [1, 1.0, 1266, 37, 1220],
            [1, 1.0, 1274, 36, 1169],
            [1, 1.0, 1310, 37, 1135],
        ],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.TrainingGrounds,
        name="Training area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[
            [1, 1.0, 613, 59, 762],
            [1, 1.0, 602, 59, 690],
            [1, 1.0, 618, 59, 616],
            [1, 1.0, 696, 59, 550],
            [1, 1.0, 722, 59, 491],
        ],
    ),
    # DK Isles
    ColoredBananaGroup(
        group=26,
        map_id=Maps.Isles,
        name="W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 2802, 514, 2400],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.Isles,
        name="W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 2749, 514, 2398],
        ],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.Isles,
        name="W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 2734, 514, 2347],
        ],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.Isles,
        name="W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 2780, 514, 2311],
        ],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.Isles,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 2818, 514, 2347],
        ],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.Isles,
        name="K.Lumsy W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [5, 1.0, 3482, 514, 3151],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.Isles,
        name="Aztec W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [5, 1.0, 3355, 1028, 1671],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.Isles,
        name="Waterfall W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [5, 1.0, 3045, 514, 978],
        ],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.Isles,
        name="Factory W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        locations=[
            [5, 1.0, 2494, 1214, 3305],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.Isles,
        name="Fairy Isle W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        locations=[
            [5, 1.0, 931, 514, 2633],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.Isles,
        name="Japes entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[[1, 1.0, 3223, 527, 1872], [1, 1.0, 3274, 529, 1896], [1, 1.0, 3320, 526, 1874], [1, 1.0, 3339, 524, 1826], [1, 1.0, 3324, 525, 1776]],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.Isles,
        name="Tree between tag barrel and Japes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: (l.climbing) or (Events.AirSpaceEntered in l.Events and l.isdiddy),
        locations=[
            [5, 1.0, 3161, 704, 2188],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.Isles,
        name="Tree between tag barrel and Japes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 3182, 500, 2248],
            [1, 1.0, 3168, 500, 2204],
            [1, 1.0, 3120, 500, 2204],
            [1, 1.0, 3106, 500, 2248],
            [1, 1.0, 3144, 500, 2276],
        ],
    ),  # Linked for logic
    ColoredBananaGroup(
        group=38,
        map_id=Maps.Isles,
        name="Tree next to Japes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: (l.climbing) or (Events.AirSpaceEntered in l.Events and l.isdiddy),
        locations=[
            [5, 1.0, 3554, 709, 1920],
        ],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.Isles,
        name="Tree next to Japes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 3575, 506, 1983],
            [1, 1.0, 3561, 506, 1939],
            [1, 1.0, 3513, 506, 1939],
            [1, 1.0, 3499, 506, 1983],
            [1, 1.0, 3537, 506, 2011],
        ],
    ),  # Linked for logic
    ColoredBananaGroup(
        group=39,
        map_id=Maps.Isles,
        name="Tree on beaver beach",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: (l.climbing) or (Events.AirSpaceEntered in l.Events and l.isdiddy),
        locations=[
            [5, 1.0, 3506, 706, 1388],
        ],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.Isles,
        name="Tree on beaver beach",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 3528, 500, 1452],
            [1, 1.0, 3514, 500, 1408],
            [1, 1.0, 3466, 500, 1408],
            [1, 1.0, 3452, 500, 1452],
            [1, 1.0, 3490, 500, 1480],
        ],
    ),  # Linked for logic
    ColoredBananaGroup(
        group=40,
        map_id=Maps.Isles,
        name="Tree near W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: (l.climbing) or (Events.AirSpaceEntered in l.Events and l.isdiddy),
        locations=[
            [5, 1.0, 3170, 707, 880],
        ],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.Isles,
        name="Tree near W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 3194, 500, 942],
            [1, 1.0, 3180, 500, 898],
            [1, 1.0, 3132, 500, 898],
            [1, 1.0, 3118, 500, 942],
            [1, 1.0, 3156, 500, 970],
        ],
    ),  # Linked for logic
    ColoredBananaGroup(
        group=41,
        map_id=Maps.Isles,
        name="Behind cannon to Forest",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 3617, 494, 688],
            [1, 1.0, 3624, 494, 633],
            [1, 1.0, 3638, 494, 565],
            [1, 1.0, 3574, 494, 516],
            [1, 1.0, 3492, 495, 464],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.Isles,
        name="Waterfall pond",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.0, 3153, 417, 1197],
            [1, 1.0, 3113, 414, 1212],
            [1, 1.0, 3090, 411, 1215],
            [1, 1.0, 3067, 410, 1220],
            [1, 1.0, 3043, 409, 1222],
            [1, 1.0, 3016, 409, 1223],
            [1, 1.0, 2992, 408, 1223],
            [1, 1.0, 2970, 408, 1217],
            [1, 1.0, 2947, 408, 1211],
            [1, 1.0, 2924, 408, 1205],
            [1, 1.0, 2901, 408, 1199],
            [1, 1.0, 2878, 408, 1193],
            [1, 1.0, 2856, 408, 1184],
            [1, 1.0, 2834, 408, 1176],
            [1, 1.0, 2813, 412, 1166],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.Isles,
        name="Seafloor around the X platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.0, 1584, 236, 635],
            [1, 1.0, 1501, 237, 600],
            [1, 1.0, 1425, 238, 518],
            [1, 1.0, 1412, 233, 424],
            [1, 1.0, 1447, 221, 325],
            [1, 1.0, 1568, 214, 266],
            [1, 1.0, 1664, 212, 301],
            [1, 1.0, 1723, 215, 372],
            [1, 1.0, 1747, 225, 470],
            [1, 1.0, 1709, 227, 573],
        ],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.Isles,
        name="In the pineapple cage",
        konglist=[Kongs.chunky],
        region=Regions.IslesMain,
        logic=lambda l: l.pineapple or l.CanSTS() or l.CanPhase(),
        locations=[
            [5, 1.0, 2670, 505, 1182],
            [5, 1.0, 2616, 505, 1196],
        ],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.Isles,
        name="Beach below Caves",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 2397, 500, 1208],
            [1, 1.0, 2363, 502, 1267],
            [1, 1.0, 2329, 504, 1326],
            [1, 1.0, 2295, 506, 1384],
            [1, 1.0, 2261, 508, 1443],
        ],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.Isles,
        name="Tree below Caves",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesHill,
        locations=[
            [5, 1.0, 2358, 807, 1747],
        ],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.Isles,
        name="Path below Caves",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesHill,
        locations=[
            [1, 1.0, 2509, 800, 1403],
            [1, 1.0, 2531, 825, 1350],
            [1, 1.0, 2554, 850, 1297],
            [1, 1.0, 2576, 874, 1244],
            [1, 1.0, 2598, 899, 1191],
        ],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.Isles,
        name="Stairs near Aztec",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [1, 1.0, 3363, 920, 1379],
            [1, 1.0, 3404, 920, 1477],
            [1, 1.0, 3260, 919, 1400],
            [1, 1.0, 3260, 940, 1430],
            [1, 1.0, 3341, 940, 1414],
            [1, 1.0, 3370, 940, 1487],
            [1, 1.0, 3339, 960, 1494],
            [1, 1.0, 3323, 960, 1445],
            [1, 1.0, 3267, 960, 1457],
            [1, 1.0, 3289, 980, 1492],
        ],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.Isles,
        name="Behind Aztec lobby",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [1, 1.0, 3596, 1040, 1693],
            [1, 1.0, 3581, 1040, 1727],
            [1, 1.0, 3566, 1040, 1761],
            [1, 1.0, 3551, 1040, 1795],
            [1, 1.0, 3536, 1040, 1829],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.Isles,
        name="Aztec lobby roof",
        konglist=[Kongs.diddy],
        region=Regions.AztecLobbyRoof,
        locations=[
            [5, 1.0, 3516, 1170, 1803],
            [5, 1.0, 3563, 1170, 1693],
            [5, 1.0, 3501, 1170, 1663],
            [5, 1.0, 3450, 1170, 1774],
        ],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.Isles,
        name="On trombone boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [5, 1.0, 2958, 1077, 1959],
        ],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.Isles,
        name="On triangle boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [5, 1.0, 2681, 1066, 1909],
        ],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.Isles,
        name="Between DK Isle's nostrils",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[
            [5, 1.0, 2790, 985, 2164],
        ],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.Isles,
        name="Caves lobby ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesEar,
        locations=[
            [1, 1.0, 2554, 1000, 1440],
            [1, 1.0, 2515, 1000, 1454],
            [1, 1.0, 2493, 1000, 1478],
            [1, 1.0, 2493, 1000, 1508],
            [1, 1.0, 2542, 1000, 1535],
        ],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.Isles,
        name="Above Caves lobby",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 2518, 1249, 1467],
            [5, 1.0, 2506, 1246, 1505],
            [5, 1.0, 2501, 1241, 1547],
        ],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.Isles,
        name="Forest lobby roof",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CabinIsle,
        locations=[
            [5, 1.0, 2550, 1603, 790],
            [5, 1.0, 2465, 1603, 931],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.Isles,
        name="Flower sniffing near Forest",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinIsle,
        locations=[
            [1, 1.0, 2551, 1518, 1046],
            [1, 1.0, 2605, 1518, 828],
            [1, 1.0, 2645, 1518, 743],
            [1, 1.0, 2676, 1518, 876],
            [1, 1.0, 2647, 1498, 816],
        ],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.Isles,
        name="In the peanut cage",
        konglist=[Kongs.diddy],
        region=Regions.IslesAboveWaterfall,
        logic=lambda l: l.peanut,
        locations=[
            [5, 1.0, 2954, 1483, 1357],
            [5, 1.0, 2909, 1483, 1349],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.Isles,
        name="Waterfall upstream",
        konglist=[Kongs.diddy],
        region=Regions.IslesAboveWaterfall,
        locations=[
            [1, 1.0, 2950, 1478, 1262],
            [1, 1.0, 2957, 1478, 1222],
            [1, 1.0, 2964, 1478, 1183],
            [1, 1.0, 2970, 1478, 1143],
            [1, 1.0, 2977, 1478, 1104],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.Isles,
        name="Flower next to peanut cage",
        konglist=[Kongs.diddy],
        region=Regions.IslesAboveWaterfall,
        locations=[
            [5, 1.0, 3009, 1523, 1281],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.Isles,
        name="Waterfall freefall",
        konglist=[Kongs.diddy],
        region=Regions.IslesAboveWaterfall,
        locations=[
            [1, 1.0, 2981, 1452, 1079],
            [1, 1.0, 2981, 1412, 1079],
            [1, 1.0, 2981, 1372, 1079],
            [1, 1.0, 2981, 1331, 1079],
            [1, 1.0, 2981, 1291, 1079],
            [1, 1.0, 2981, 1251, 1079],
            [1, 1.0, 2981, 1211, 1079],
            [1, 1.0, 2981, 1170, 1079],
            [1, 1.0, 2981, 1130, 1079],
            [1, 1.0, 2981, 1090, 1079],
        ],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.Isles,
        name="DK Isle peaks",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 2892, 1855, 1536],
            [5, 1.0, 2820, 1800, 1956],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.Isles,
        name="Above the Pound the X rock",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 4468, 888, 1674],
        ],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.Isles,
        name="On DK Isle's ear above Aztec",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 3271, 1241, 1688],
            [5, 1.0, 3289, 1253, 1591],
            [5, 1.0, 3283, 1250, 1642],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.Isles,
        name="On DK Isle's eyebrows",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [1, 1.0, 2683, 1314, 1935],
            [1, 1.0, 2659, 1325, 1895],
            [1, 1.0, 2635, 1335, 1856],
            [1, 1.0, 2611, 1346, 1816],
            [1, 1.0, 2587, 1356, 1777],
            [1, 1.0, 2992, 1318, 1972],
            [1, 1.0, 3020, 1328, 1946],
            [1, 1.0, 3049, 1339, 1920],
            [1, 1.0, 3077, 1349, 1894],
            [1, 1.0, 3105, 1359, 1868],
        ],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.Isles,
        name="On Fairy Isle's banana peel hat right",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [1, 1.0, 1106, 779, 2370],
            [1, 1.0, 1063, 787, 2382],
            [1, 1.0, 1020, 795, 2394],
            [1, 1.0, 978, 803, 2406],
            [1, 1.0, 935, 811, 2418],
        ],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.Isles,
        name="On Fairy Isle's banana peel hat left",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [1, 1.0, 990, 775, 2628],
            [1, 1.0, 969, 784, 2592],
            [1, 1.0, 949, 792, 2556],
            [1, 1.0, 928, 801, 2520],
            [1, 1.0, 908, 809, 2484],
        ],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.Isles,
        name="On top of Fairy Isle",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 831, 960, 2415],
        ],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.Isles,
        name="On Fairy Isle's wings",
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        locations=[
            [5, 1.0, 196, 1020, 2618],
            [5, 1.0, 498, 1020, 1848],
        ],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.Isles,
        name="On the fairy tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        locations=[
            [5, 1.0, 1067, 733, 1413],
        ],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.Isles,
        name="Around the fairy tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        locations=[
            [1, 1.0, 1105, 500, 1425],
            [1, 1.0, 1091, 500, 1381],
            [1, 1.0, 1043, 500, 1381],
            [1, 1.0, 1029, 500, 1425],
            [1, 1.0, 1067, 500, 1453],
        ],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.Isles,
        name="In the feather cage",
        konglist=[Kongs.tiny],
        region=Regions.OuterIsles,
        logic=lambda l: l.feather or l.CanSTS() or l.CanPhase(),
        locations=[
            [5, 1.0, 877, 505, 2420],
            [5, 1.0, 865, 505, 2444],
        ],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.Isles,
        name="Fairy Isle entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        locations=[
            [5, 1.0, 1056, 504, 2498],
        ],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.Isles,
        name="In the Pound the X rock",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        logic=lambda l: Events.IslesChunkyBarrelSpawn in l.Events and l.hunkyChunky and l.Slam and l.chunky,
        locations=[
            [5, 2.0, 4403, 546, 1750],
            [5, 2.0, 4492, 528, 1562],
        ],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.Isles,
        name="Tag barrel shore",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 2406, 493, 2306],
            [1, 1.0, 2438, 494, 2375],
            [1, 1.0, 2467, 492, 2441],
            [1, 1.0, 2529, 492, 2465],
            [1, 1.0, 2587, 491, 2485],
            [1, 1.0, 2651, 492, 2500],
            [1, 1.0, 2719, 491, 2521],
            [1, 1.0, 2792, 492, 2539],
            [1, 1.0, 2864, 492, 2514],
            [1, 1.0, 2930, 492, 2472],
        ],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.Isles,
        name="Around Fairy Isle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        locations=[
            [1, 1.0, 1167, 492, 2467],
            [1, 1.0, 1096, 493, 2279],
            [1, 1.0, 960, 495, 2234],
            [1, 1.0, 835, 495, 2208],
            [1, 1.0, 737, 497, 2338],
            [1, 1.0, 740, 499, 2377],
            [1, 1.0, 714, 497, 2400],
            [1, 1.0, 754, 495, 2600],
            [1, 1.0, 923, 493, 2687],
            [1, 1.0, 1068, 493, 2633],
        ],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.Isles,
        name="Under K.Lumsy's prison",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        logic=lambda l: l.swim,
        locations=[
            [5, 1.3, 3366, 251, 3364],
        ],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.Isles,
        name="Around Castle cannon",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        logic=lambda l: (l.settings.open_lobbies or Events.ForestKeyTurnedIn in l.Events),
        locations=[
            [1, 1.0, 3867, 500, 4209],
            [1, 1.0, 3908, 500, 4153],
            [1, 1.0, 3908, 500, 4083],
            [1, 1.0, 3867, 500, 4027],
            [1, 1.0, 3801, 500, 4006],
            [1, 1.0, 3735, 500, 4027],
            [1, 1.0, 3694, 500, 4083],
            [1, 1.0, 3694, 500, 4153],
            [1, 1.0, 3735, 500, 4209],
            [1, 1.0, 3801, 500, 4230],
        ],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.Isles,
        name="On top of K.Lumsy's prison",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.KremIsle,
        logic=lambda l: (
            (l.hasMoveSwitchsanity(Switches.IslesMonkeyport) and ((l.istiny and l.twirl) or (l.settings.damage_amount != DamageAmount.ohko)))
            or ((l.settings.open_lobbies or Events.GalleonKeyTurnedIn in l.Events) and Events.IslesDiddyBarrelSpawn in l.Events and l.isdiddy and l.jetpack)
            or (
                (l.settings.open_lobbies or Events.AztecKeyTurnedIn in l.Events)
                and (l.isdonkey and (not l.isKrushaAdjacent(Kongs.donkey)) and (l.settings.damage_amount != DamageAmount.ohko))
                or (l.istiny and l.twirl)
            )
        )
        or l.CanMoonkick(),
        locations=[
            [5, 1.0, 3359, 734, 3411],
        ],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.Isles,
        name="On top of side pipes",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.KremIsleBeyondLift,
        locations=[
            [5, 1.0, 2622, 1287, 3564],
            [5, 1.0, 2631, 1280, 3597],
            [5, 1.0, 2621, 1280, 3528],
        ],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.Isles,
        name="Lower Monkeyport pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [5, 1.0, 2405, 584, 4022],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.Isles,
        name="Upper Monkeyport pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleTopLevel,
        locations=[
            [5, 1.0, 2523, 1734, 3840],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.Isles,
        name="Saxophone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleTopLevel,
        locations=[
            [5, 1.0, 2359, 1735, 3858],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.Isles,
        name="On vines to Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        logic=lambda l: l.can_use_vines,
        locations=[
            [5, 1.0, 2409, 946, 3208],
        ],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.Isles,
        name="On Krem Isle's right arm",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleTopLevel,
        locations=[
            [1, 1.0, 2646, 1620, 3570],
            [1, 1.0, 2659, 1620, 3490],
            [1, 1.0, 2673, 1620, 3410],
            [1, 1.0, 2686, 1620, 3331],
            [1, 1.0, 2699, 1620, 3251],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.Isles,
        name="On Krem Isle's left arm",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleTopLevel,
        locations=[
            [1, 1.0, 2241, 1620, 3322],
            [1, 1.0, 2266, 1620, 3287],
            [1, 1.0, 2291, 1620, 3251],
            [1, 1.0, 2315, 1620, 3216],
            [1, 1.0, 2340, 1620, 3181],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.Isles,
        name="Path to Factory",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        locations=[
            [1, 1.0, 2727, 1186, 3747],
            [1, 1.0, 2703, 1172, 3814],
            [1, 1.0, 2675, 1153, 3901],
            [1, 1.0, 2609, 1132, 3955],
            [1, 1.0, 2542, 1116, 4000],
            [1, 1.0, 2469, 1101, 4050],
            [1, 1.0, 2392, 1083, 4031],
            [1, 1.0, 2317, 1069, 4013],
            [1, 1.0, 2234, 1056, 3993],
            [1, 1.0, 2181, 1041, 3936],
            [1, 1.0, 2128, 1022, 3866],
            [1, 1.0, 2084, 1008, 3796],
            [1, 1.0, 2051, 992, 3717],
            [1, 1.0, 2030, 975, 3637],
            [1, 1.0, 2017, 957, 3529],
        ],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.Isles,
        name="Key 2 rising platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [5, 1.0, 2623, 557, 3255],
        ],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.Isles,
        name="Underwater behind propellers",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        logic=lambda l: l.swim,
        locations=[
            [5, 1.3, 1937, 384, 4338],
            [5, 1.3, 2326, 384, 4428],
        ],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.KLumsy,
        name="Inside K.Lumsy's cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Prison,
        logic=lambda l: l.IsKLumsyFree(),
        locations=[
            [1, 1.0, 1077, 50, 139],
            [1, 1.0, 1130, 50, 1100],
            [1, 1.0, 1163, 50, 1044],
            [1, 1.0, 1169, 50, 979],
            [1, 1.0, 1149, 50, 916],
            [1, 1.0, 1105, 50, 868],
            [1, 1.0, 1046, 50, 841],
            [1, 1.0, 980, 50, 841],
            [1, 1.0, 921, 50, 868],
            [1, 1.0, 877, 50, 916],
            [1, 1.0, 857, 50, 979],
            [1, 1.0, 863, 50, 1044],
            [1, 1.0, 896, 50, 1100],
            [1, 1.0, 949, 50, 1139],
            [1, 1.0, 1013, 50, 1152],
        ],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.KLumsy,
        name="Prison sprint cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Prison,
        logic=lambda l: (l.sprint and l.lanky),
        locations=[
            [5, 1.0, 1315, 100, 365],
            [5, 1.0, 1395, 100, 405],
        ],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.IslesSnideRoom,
        name="On the Snide boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesSnideRoom,
        locations=[
            [5, 1.0, 363, 48, 277],
        ],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.IslesSnideRoom,
        name="Above Snide's doorway",
        konglist=[Kongs.diddy],
        region=Regions.IslesSnideRoom,
        logic=lambda l: (l.spring and l.diddy),
        locations=[
            [5, 1.0, 488, 112, 220],
        ],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.Isles,
        name="Under path to Factory",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [1, 1.0, 2707, 500, 3324],
            [1, 1.0, 2732, 500, 3370],
            [1, 1.0, 2758, 500, 3416],
            [1, 1.0, 2783, 500, 3462],
            [1, 1.0, 2808, 500, 3508],
            [1, 1.0, 2808, 500, 3570],
            [1, 1.0, 2804, 500, 3624],
            [1, 1.0, 2801, 500, 3679],
            [1, 1.0, 2797, 500, 3733],
            [1, 1.0, 2794, 500, 3787],
        ],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.Isles,
        name="Prison cable",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [1, 1.0, 3000, 516, 3652],
            [1, 1.0, 3019, 516, 3626],
            [1, 1.0, 3038, 516, 3599],
            [1, 1.0, 3057, 516, 3573],
            [1, 1.0, 3076, 516, 3547],
        ],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.Isles,
        name="Back of Krem Isle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        locations=[
            [1, 1.0, 1938, 600, 3947],
            [1, 1.0, 1952, 600, 3927],
            [1, 1.0, 1952, 600, 3903],
            [1, 1.0, 1938, 600, 3883],
            [1, 1.0, 1914, 600, 3875],
            [1, 1.0, 1890, 600, 3883],
            [1, 1.0, 1876, 600, 3903],
            [1, 1.0, 1876, 600, 3927],
            [1, 1.0, 1890, 600, 3947],
            [1, 1.0, 1914, 600, 3955],
        ],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.Isles,
        name="Snide ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        locations=[
            [5, 1.0, 2601, 905, 3204],
        ],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.Isles,
        name="In the coconut cage",
        konglist=[Kongs.donkey],
        region=Regions.KremIsleBeyondLift,
        logic=lambda l: l.coconut,
        locations=[
            [5, 1.0, 2320, 705, 3374],
            [5, 1.0, 2250, 705, 3396],
        ],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.Isles,
        name="In the grape cage",
        konglist=[Kongs.lanky],
        region=Regions.KremIsle,
        logic=lambda l: l.grape or l.CanPhaseswim() or l.CanPhase(),
        locations=[
            [5, 1.0, 3281, 505, 3536],
            [5, 1.0, 3307, 505, 3548],
        ],
    ),
    # Japes Lobby
    ColoredBananaGroup(
        group=100,
        map_id=Maps.JungleJapesLobby,
        name="On the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 256, 42, 294],
        ],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.JungleJapesLobby,
        name="Around the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [1, 1.0, 304, 0, 309],
            [1, 1.0, 285, 0, 254],
            [1, 1.0, 227, 0, 254],
            [1, 1.0, 208, 0, 309],
            [1, 1.0, 256, 0, 344],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.JungleJapesLobby,
        name="Right torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 308, 62, 193],
        ],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.JungleJapesLobby,
        name="Left torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 759, 62, 346],
        ],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.JungleJapesLobby,
        name="Back left torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 709, 62, 739],
        ],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.JungleJapesLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 179, 14, 492],
        ],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.JungleJapesLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 188, 14, 596],
        ],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.JungleJapesLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 260, 6, 737],
        ],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.JungleJapesLobby,
        name="Diddy door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 644, 5, 766],
        ],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.JungleJapesLobby,
        name="Chunky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 796, 5, 610],
        ],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.JungleJapesLobby,
        name="Middle path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [1, 1.0, 470, 0, 291],
            [1, 1.0, 463, 0, 370],
            [1, 1.0, 457, 0, 449],
            [1, 1.0, 450, 0, 527],
            [1, 1.0, 444, 0, 606],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.JungleJapesLobby,
        name="Around B.Locker",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [1, 1.0, 530, 0, 769],
            [1, 1.0, 498, 0, 711],
            [1, 1.0, 440, 0, 685],
            [1, 1.0, 388, 1, 727],
            [1, 1.0, 365, 0, 780],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.JungleJapesLobby,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        locations=[
            [5, 1.0, 550, 5, 172],
            [5, 1.0, 397, 5, 170],
        ],
    ),
    # Aztec Lobby
    ColoredBananaGroup(
        group=113,
        map_id=Maps.AngryAztecLobby,
        name="Right ramp",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 219, 0, 527],
            [1, 1.0, 244, 20, 560],
            [1, 1.0, 269, 40, 593],
            [1, 1.0, 294, 59, 626],
            [1, 1.0, 319, 79, 659],
        ],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.AngryAztecLobby,
        name="Left ramp",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 778, 0, 531],
            [1, 1.0, 754, 20, 563],
            [1, 1.0, 729, 40, 595],
            [1, 1.0, 705, 59, 627],
            [1, 1.0, 681, 79, 659],
        ],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.AngryAztecLobby,
        name="Ridge between the posts",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 401, 87, 610],
            [1, 1.0, 449, 87, 610],
            [1, 1.0, 496, 87, 610],
            [1, 1.0, 544, 87, 610],
            [1, 1.0, 591, 87, 610],
        ],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.AngryAztecLobby,
        name="Between the Columns",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 417, 0, 259],
            [1, 1.0, 458, 0, 259],
            [1, 1.0, 500, 0, 259],
            [1, 1.0, 541, 0, 259],
            [1, 1.0, 582, 0, 259],
        ],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.AngryAztecLobby,
        name="Around the barrel hole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 542, 0, 444],
            [1, 1.0, 568, 0, 409],
            [1, 1.0, 568, 0, 365],
            [1, 1.0, 542, 0, 330],
            [1, 1.0, 501, 0, 317],
            [1, 1.0, 460, 0, 330],
            [1, 1.0, 434, 0, 365],
            [1, 1.0, 434, 0, 409],
            [1, 1.0, 460, 0, 444],
            [1, 1.0, 501, 0, 457],
        ],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.AngryAztecLobby,
        name="Also around the barrel hole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [1, 1.0, 560, 0, 468],
            [1, 1.0, 596, 0, 418],
            [1, 1.0, 596, 0, 356],
            [1, 1.0, 560, 0, 306],
            [1, 1.0, 501, 0, 287],
            [1, 1.0, 442, 0, 306],
            [1, 1.0, 406, 0, 356],
            [1, 1.0, 406, 0, 418],
            [1, 1.0, 442, 0, 468],
            [1, 1.0, 501, 0, 487],
        ],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.AngryAztecLobby,
        name="Tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesAztecLobbyFeather, False) or l.CanPhase(),
        locations=[
            [1, 1.0, 946, 0, 309],
            [1, 1.0, 958, 0, 344],
            [1, 1.0, 971, 0, 380],
            [1, 1.0, 983, 0, 415],
            [1, 1.0, 995, 0, 450],
        ],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.AngryAztecLobby,
        name="Back room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesAztecLobbyFeather, False) or l.CanPhase(),
        locations=[
            [1, 1.0, 1063, 0, 677],
            [1, 1.0, 1096, 0, 653],
            [1, 1.0, 1117, 0, 617],
            [1, 1.0, 1121, 0, 576],
            [1, 1.0, 1109, 0, 536],
            [1, 1.0, 1081, 0, 505],
            [1, 1.0, 1043, 0, 488],
            [1, 1.0, 1001, 0, 488],
            [1, 1.0, 963, 0, 505],
            [1, 1.0, 935, 0, 536],
            [1, 1.0, 923, 0, 576],
            [1, 1.0, 927, 0, 617],
            [1, 1.0, 948, 0, 653],
            [1, 1.0, 981, 0, 677],
            [1, 1.0, 1022, 0, 686],
        ],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.AngryAztecLobby,
        name="Left post",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 646, 93, 608],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.AngryAztecLobby,
        name="Right post",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 354, 93, 609],
        ],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.AngryAztecLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 500, 5, 170],
        ],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.AngryAztecLobby,
        name="Diddy door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 441, 5, 592],
        ],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.AngryAztecLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 372, 85, 687],
        ],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.AngryAztecLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 629, 85, 687],
        ],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.AngryAztecLobby,
        name="Chunky door (back room wall)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesAztecLobbyFeather, False) or l.CanPhase(),
        locations=[
            [5, 1.0, 1050, 5, 725],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.AngryAztecLobby,
        name="On the gongs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 666, 45, 544],
            [5, 1.0, 340, 45, 543],
        ],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.AngryAztecLobby,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 186, 5, 386],
            [5, 1.0, 207, 5, 294],
        ],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.AngryAztecLobby,
        name="Torch above Donkey door",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.AngryAztecLobby,
        locations=[
            [5, 1.0, 499, 76, 153],
        ],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.AngryAztecLobby,
        name="Back room torches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesAztecLobbyFeather, False) or l.CanPhase(),
        locations=[
            [5, 1.0, 1048, 60, 457],
            [5, 1.0, 946, 60, 483],
        ],
    ),
    # Factory Lobby
    ColoredBananaGroup(
        group=132,
        map_id=Maps.FranticFactoryLobby,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [5, 1.0, 388, 5, 145],
            [5, 1.0, 547, 5, 145],
        ],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.FranticFactoryLobby,
        name="On the box",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [5, 1.0, 237, 75, 154],
        ],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.FranticFactoryLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [5, 1.0, 541, 5, 640],
        ],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.FranticFactoryLobby,
        name="Chunky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [5, 1.0, 392, 5, 640],
        ],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.FranticFactoryLobby,
        name="Diddy door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [5, 1.0, 658, 138, 638],
        ],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.FranticFactoryLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [5, 1.0, 273, 138, 638],
        ],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.FranticFactoryLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [5, 1.0, 466, 90, 638],
        ],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.FranticFactoryLobby,
        name="On the lever",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [5, 1.0, 270, 6, 390],
        ],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.FranticFactoryLobby,
        name="Bongo pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [5, 1.0, 311, 147, 566],
        ],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.FranticFactoryLobby,
        name="Bridge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [5, 1.0, 671, 138, 511],
            [5, 1.0, 671, 138, 463],
        ],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.FranticFactoryLobby,
        name="In the box",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: l.punch and l.chunky,
        locations=[
            [5, 1.0, 233, 25, 147],
        ],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.FranticFactoryLobby,
        name="Post after bridge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [1, 1.0, 706, 133, 326],
            [1, 1.0, 642, 133, 326],
            [1, 1.0, 642, 133, 372],
            [1, 1.0, 642, 133, 419],
            [1, 1.0, 706, 133, 419],
        ],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.FranticFactoryLobby,
        name="Stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        logic=lambda l: ((l.grab and l.donkey) or (l.monkey_maneuvers and (l.isdiddy or l.istiny))),
        locations=[
            [1, 1.0, 578, 125, 616],
            [1, 1.0, 539, 105, 616],
            [1, 1.0, 467, 85, 616],
            [1, 1.0, 394, 105, 616],
            [1, 1.0, 355, 125, 616],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.FranticFactoryLobby,
        name="Towards doors",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [1, 1.0, 469, 0, 647],
            [1, 1.0, 469, 0, 592],
            [1, 1.0, 469, 0, 538],
            [1, 1.0, 469, 0, 483],
            [1, 1.0, 469, 0, 428],
            [1, 1.0, 469, 0, 374],
            [1, 1.0, 469, 0, 319],
            [1, 1.0, 469, 0, 264],
            [1, 1.0, 469, 0, 210],
            [1, 1.0, 469, 0, 155],
        ],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.FranticFactoryLobby,
        name="Tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        locations=[
            [1, 1.0, 637, 0, 243],
            [1, 1.0, 626, 0, 207],
            [1, 1.0, 588, 0, 207],
            [1, 1.0, 577, 0, 243],
            [1, 1.0, 607, 0, 265],
        ],
    ),
    # Galleon Lobby
    ColoredBananaGroup(
        group=147,
        map_id=Maps.GloomyGalleonLobby,
        name="Underwater entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobbyEntrance,
        locations=[
            [1, 1.0, 307, -23, 379],
            [1, 1.0, 354, -12, 443],
            [1, 1.0, 401, -1, 507],
            [1, 1.0, 447, 9, 570],
            [1, 1.0, 494, 20, 634],
        ],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.GloomyGalleonLobby,
        name="Under tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [1, 1.0, 471, 75, 757],
            [1, 1.0, 460, 75, 724],
            [1, 1.0, 424, 75, 724],
            [1, 1.0, 413, 75, 757],
            [1, 1.0, 442, 75, 778],
        ],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.GloomyGalleonLobby,
        name="Underwater along the wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobbyEntrance,
        locations=[
            [1, 1.0, 357, 14, 812],
            [1, 1.0, 450, 14, 863],
            [1, 1.0, 557, 14, 841],
            [1, 1.0, 600, 14, 763],
            [1, 1.0, 715, 14, 755],
            [1, 1.0, 789, 14, 826],
            [1, 1.0, 882, 14, 822],
            [1, 1.0, 913, 14, 852],
            [1, 1.0, 928, 14, 801],
            [1, 1.0, 996, 14, 778],
        ],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.GloomyGalleonLobby,
        name="Kasplat platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [1, 1.0, 872, 119, 883],
            [1, 1.0, 831, 119, 890],
            [1, 1.0, 796, 119, 906],
            [1, 1.0, 754, 119, 920],
            [1, 1.0, 711, 119, 931],
            [1, 1.0, 664, 119, 943],
            [1, 1.0, 629, 119, 925],
            [1, 1.0, 589, 119, 919],
            [1, 1.0, 553, 119, 912],
            [1, 1.0, 507, 119, 912],
        ],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.GloomyGalleonLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 999, 144, 849],
        ],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.GloomyGalleonLobby,
        name="Chunky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 872, 183, 1042],
        ],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.GloomyGalleonLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 580, 164, 1070],
        ],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.GloomyGalleonLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 472, 164, 1052],
        ],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.GloomyGalleonLobby,
        name="Diddy door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 365, 144, 880],
        ],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.GloomyGalleonLobby,
        name="Chunky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 662, 108, 820],
        ],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.GloomyGalleonLobby,
        name="Right water torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 387, 125, 665],
        ],
    ),
    ColoredBananaGroup(
        group=158,
        map_id=Maps.GloomyGalleonLobby,
        name="Left water torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 741, 130, 587],
        ],
    ),
    ColoredBananaGroup(
        group=159,
        map_id=Maps.GloomyGalleonLobby,
        name="Right land torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 580, 205, 965],
        ],
    ),
    ColoredBananaGroup(
        group=160,
        map_id=Maps.GloomyGalleonLobby,
        name="Left land torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        locations=[
            [5, 1.0, 880, 230, 947],
        ],
    ),
    ColoredBananaGroup(
        group=161,
        map_id=Maps.GloomyGalleonLobby,
        name="On the Tiny platform",
        konglist=[Kongs.tiny],
        region=Regions.GloomyGalleonLobby,
        logic=lambda l: l.swim and ((l.mini and l.twirl and l.tiny and l.CanSlamSwitch(Levels.GloomyGalleon, 2) and l.chunky) or l.CanPhaseswim()) and (not l.IsLavaWater() or l.Melons >= 3),
        locations=[
            [5, 1.0, 811, 104, 223],
            [5, 1.0, 846, 104, 267],
            [5, 1.0, 865, 105, 212],
        ],
    ),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.GloomyGalleonLobby,
        name="Mini tunnel",
        konglist=[Kongs.tiny],
        region=Regions.GloomyGalleonLobby,
        logic=lambda l: l.swim and ((l.mini and l.twirl and l.tiny and l.CanSlamSwitch(Levels.GloomyGalleon, 2) and l.chunky) or l.CanPhaseswim()) and (not l.IsLavaWater() or l.Melons >= 3),
        locations=[
            [5, 1.0, 895, 53, 416],
        ],
    ),
    # Forest Lobby
    ColoredBananaGroup(
        group=163,
        map_id=Maps.FungiForestLobby,
        name="Tiny door (back wall)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [5, 1.0, 292, 5, 195],
        ],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.FungiForestLobby,
        name="Chunky door (right wall)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [5, 1.0, 432, 5, 566],
        ],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.FungiForestLobby,
        name="Lanky door (right corner)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [5, 1.0, 432, 5, 694],
        ],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.FungiForestLobby,
        name="Where the lever used to be",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [5, 1.0, 289, 16, 303],
        ],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.FungiForestLobby,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [5, 1.0, 437, 5, 414],
            [5, 1.0, 437, 5, 514],
        ],
    ),
    ColoredBananaGroup(
        group=168,
        map_id=Maps.FungiForestLobby,
        name="Center line",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        locations=[
            [1, 1.0, 289, 0, 571],
            [1, 1.0, 289, 0, 514],
            [1, 1.0, 289, 0, 457],
            [1, 1.0, 289, 0, 401],
            [1, 1.0, 289, 0, 344],
        ],
    ),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.FungiForestLobby,
        name="Gorilla Gone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        logic=lambda l: ((l.coconut and l.donkey) and (l.peanut and l.diddy) and (l.grape and l.lanky) and (l.feather and l.tiny) and (l.pineapple and l.chunky) or l.CanPhase()),
        locations=[
            [5, 1.0, 94, 14, 536],
        ],
    ),
    # Caves Lobby
    ColoredBananaGroup(
        group=170,
        map_id=Maps.CrystalCavesLobby,
        name="Left path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [1, 1.0, 1236, 13, 454],
            [1, 1.0, 1244, 41, 510],
            [1, 1.0, 1252, 69, 566],
            [1, 1.0, 1259, 97, 622],
            [1, 1.0, 1267, 125, 678],
        ],
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.CrystalCavesLobby,
        name="Right path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [1, 1.0, 732, 14, 542],
            [1, 1.0, 753, 41, 591],
            [1, 1.0, 773, 68, 641],
            [1, 1.0, 794, 94, 690],
            [1, 1.0, 814, 121, 739],
        ],
    ),
    ColoredBananaGroup(
        group=172,
        map_id=Maps.CrystalCavesLobby,
        name="Bridge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [1, 1.0, 1027, 118, 711],
            [1, 1.0, 1006, 134, 663],
            [1, 1.0, 985, 149, 616],
            [1, 1.0, 964, 165, 568],
            [1, 1.0, 943, 181, 521],
            [1, 1.0, 921, 196, 473],
            [1, 1.0, 900, 212, 426],
            [1, 1.0, 879, 228, 378],
            [1, 1.0, 858, 243, 331],
            [1, 1.0, 837, 259, 283],
        ],
    ),
    ColoredBananaGroup(
        group=173,
        map_id=Maps.CrystalCavesLobby,
        name="Around the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        locations=[
            [1, 1.0, 1685, 13, 697],
            [1, 1.0, 1721, 13, 647],
            [1, 1.0, 1721, 13, 585],
            [1, 1.0, 1685, 13, 535],
            [1, 1.0, 1626, 13, 516],
            [1, 1.0, 1567, 13, 535],
            [1, 1.0, 1531, 13, 585],
            [1, 1.0, 1531, 13, 647],
            [1, 1.0, 1567, 13, 697],
            [1, 1.0, 1626, 13, 716],
        ],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.CrystalCavesLobby,
        name="Path to boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        locations=[
            [1, 1.0, 1476, 13, 252],
            [1, 1.0, 1540, 13, 241],
            [1, 1.0, 1594, 13, 266],
            [1, 1.0, 1618, 13, 321],
            [1, 1.0, 1622, 13, 406],
        ],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.CrystalCavesLobby,
        name="Left side crystals",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 1178, 18, 150],
            [5, 1.0, 1250, 39, 179],
            [5, 1.0, 1357, 18, 206],
        ],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.CrystalCavesLobby,
        name="Right side crystals",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 605, 18, 443],
            [5, 1.0, 676, 18, 307],
        ],
    ),
    ColoredBananaGroup(
        group=177,
        map_id=Maps.CrystalCavesLobby,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 925, 8, 203],
            [5, 1.0, 1034, 16, 215],
        ],
    ),
    ColoredBananaGroup(
        group=178,
        map_id=Maps.CrystalCavesLobby,
        name="On the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        locations=[
            [5, 1.0, 1626, 50, 616],
        ],
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.CrystalCavesLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 1043, 17, 457],
        ],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.CrystalCavesLobby,
        name="Chunky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 876, 17, 492],
        ],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.CrystalCavesLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 952, 147, 827],
        ],
    ),
    ColoredBananaGroup(
        group=182,
        map_id=Maps.CrystalCavesLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        locations=[
            [5, 1.0, 1098, 147, 807],
        ],
    ),
    ColoredBananaGroup(
        group=183,
        map_id=Maps.CrystalCavesLobby,
        name="Diddy door",
        konglist=[Kongs.diddy],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 748, 285, 694],
        ],
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.CrystalCavesLobby,
        name="Guitar pad",
        konglist=[Kongs.diddy],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 842, 293, 718],
        ],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.CrystalCavesLobby,
        name="Behind the lava ice wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        locations=[
            [5, 1.0, 532, 18, 345],
        ],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.CrystalCavesLobby,
        name="Lava room",
        konglist=[Kongs.donkey],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: ((l.punch and l.chunky) or l.CanPhase() or l.ledgeclip) and l.strongKong,
        locations=[
            [5, 1.0, 178, 10, 436],
            [5, 1.0, 135, 10, 306],
            [5, 1.0, 175, 10, 185],
            [5, 1.0, 291, 10, 111],
        ],
    ),
    ColoredBananaGroup(
        group=187,
        map_id=Maps.CrystalCavesLobby,
        name="In the air",
        konglist=[Kongs.diddy],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 681, 442, 403],
            [5, 1.0, 1162, 442, 323],
        ],
    ),
    # Castle Lobby
    ColoredBananaGroup(
        group=188,
        map_id=Maps.CreepyCastleLobby,
        name="Chunky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 579, 76, 571],
        ],
    ),
    ColoredBananaGroup(
        group=189,
        map_id=Maps.CreepyCastleLobby,
        name="Donkey door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 484, 76, 626],
        ],
    ),
    ColoredBananaGroup(
        group=190,
        map_id=Maps.CreepyCastleLobby,
        name="Diddy door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 485, 76, 736],
        ],
    ),
    ColoredBananaGroup(
        group=191,
        map_id=Maps.CreepyCastleLobby,
        name="Lanky door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 678, 76, 735],
        ],
    ),
    ColoredBananaGroup(
        group=192,
        map_id=Maps.CreepyCastleLobby,
        name="Tiny door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 676, 76, 625],
        ],
    ),
    ColoredBananaGroup(
        group=193,
        map_id=Maps.CreepyCastleLobby,
        name="On the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 303, 104, 842],
        ],
    ),
    ColoredBananaGroup(
        group=194,
        map_id=Maps.CreepyCastleLobby,
        name="Around the boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [1, 1.0, 341, 60, 854],
            [1, 1.0, 327, 60, 810],
            [1, 1.0, 279, 60, 810],
            [1, 1.0, 265, 60, 854],
            [1, 1.0, 303, 60, 882],
        ],
    ),
    ColoredBananaGroup(
        group=195,
        map_id=Maps.CreepyCastleLobby,
        name="Kasplat cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        logic=lambda l: (l.coconut and l.donkey) or l.CanPhase(),
        locations=[
            [1, 1.0, 599, 71, 783],
            [1, 1.0, 590, 71, 755],
            [1, 1.0, 560, 71, 755],
            [1, 1.0, 551, 71, 783],
            [1, 1.0, 575, 71, 800],
        ],
    ),
    ColoredBananaGroup(
        group=196,
        map_id=Maps.CreepyCastleLobby,
        name="Around the lobby",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [1, 1.0, 723, 60, 1002],
            [1, 1.0, 843, 60, 916],
            [1, 1.0, 917, 60, 788],
            [1, 1.0, 932, 60, 641],
            [1, 1.0, 886, 60, 501],
            [1, 1.0, 788, 60, 391],
            [1, 1.0, 653, 60, 331],
            [1, 1.0, 505, 60, 331],
            [1, 1.0, 370, 60, 391],
            [1, 1.0, 272, 60, 501],
            [1, 1.0, 226, 60, 641],
            [1, 1.0, 241, 60, 788],
            [1, 1.0, 315, 60, 916],
            [1, 1.0, 435, 60, 1002],
            [1, 1.0, 579, 60, 1033],
        ],
    ),
    ColoredBananaGroup(
        group=197,
        map_id=Maps.CreepyCastleLobby,
        name="Right torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        logic=lambda l: l.chunky and l.barrels,
        locations=[
            [5, 1.0, 83, 160, 681],
        ],
    ),
    ColoredBananaGroup(
        group=198,
        map_id=Maps.CreepyCastleLobby,
        name="Left torch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        logic=lambda l: l.chunky and l.barrels,
        locations=[
            [5, 1.0, 1083, 160, 685],
        ],
    ),
    ColoredBananaGroup(
        group=199,
        map_id=Maps.CreepyCastleLobby,
        name="Stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [1, 1.0, 634, 78, 1048],
            [1, 1.0, 526, 78, 1051],
            [1, 1.0, 555, 96, 1074],
            [1, 1.0, 609, 96, 1074],
            [1, 1.0, 580, 115, 1100],
        ],
    ),
    ColoredBananaGroup(
        group=200,
        map_id=Maps.CreepyCastleLobby,
        name="Above the entrance hole",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        locations=[
            [5, 1.0, 577, 105, 168],
        ],
    ),
    ColoredBananaGroup(
        group=201,
        map_id=Maps.CreepyCastleLobby,
        name="Torch way up",
        konglist=[Kongs.lanky],
        region=Regions.CreepyCastleLobby,
        logic=lambda l: l.chunky and l.barrels and l.balloon,
        locations=[
            [5, 1.0, 580, 240, 213],
            [5, 1.0, 580, 260, 213],
        ],
    ),
    ColoredBananaGroup(
        group=202,
        map_id=Maps.CreepyCastleLobby,
        name="Wall windows",
        konglist=[Kongs.lanky],
        region=Regions.CreepyCastleLobby,
        logic=lambda l: l.chunky and l.barrels and l.balloon,
        locations=[
            [5, 1.0, 1014, 225, 855],
            [5, 1.0, 946, 225, 974],
            [5, 1.0, 216, 225, 966],
            [5, 1.0, 143, 225, 849],
        ],
    ),
    # Helm Lobby
    ColoredBananaGroup(
        group=203,
        map_id=Maps.HideoutHelmLobby,
        name="Chunky pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        locations=[
            [5, 1.0, 455, 206, 334],
        ],
    ),
    ColoredBananaGroup(
        group=204,
        map_id=Maps.HideoutHelmLobby,
        name="W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        locations=[
            [5, 1.0, 666, 208, 262],
        ],
    ),
    ColoredBananaGroup(
        group=205,
        map_id=Maps.HideoutHelmLobby,
        name="Under bonus barrel",
        konglist=[Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesHelmLobbyGone, False) and l.can_use_vines,
        locations=[
            [5, 1.0, 687, 201, 639],
        ],
    ),  # other kongs can access this spot in switchsanity logic, but no idea how to code that
    ColoredBananaGroup(
        group=206,
        map_id=Maps.HideoutHelmLobby,
        name="Kasplat island",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        logic=lambda l: l.scope and l.coconut,
        locations=[
            [5, 1.0, 331, 196, 633],
        ],
    ),
    ColoredBananaGroup(
        group=207,
        map_id=Maps.HideoutHelmLobby,
        name="Right side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        locations=[
            [1, 1.0, 346, 196, 224],
            [1, 1.0, 317, 196, 224],
            [1, 1.0, 289, 196, 224],
            [1, 1.0, 260, 196, 224],
            [1, 1.0, 232, 196, 224],
        ],
    ),
    ColoredBananaGroup(
        group=208,
        map_id=Maps.HideoutHelmLobby,
        name="Left side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        locations=[
            [1, 1.0, 563, 197, 217],
            [1, 1.0, 591, 198, 217],
            [1, 1.0, 619, 198, 217],
            [1, 1.0, 646, 199, 217],
            [1, 1.0, 674, 199, 217],
        ],
    ),
    ColoredBananaGroup(
        group=209,
        map_id=Maps.HideoutHelmLobby,
        name="Far W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobbyPastVines,
        locations=[
            [5, 1.0, 454, 216, 1013],
        ],
    ),
    # Banana Fairy Room
    ColoredBananaGroup(
        group=210,
        map_id=Maps.BananaFairyRoom,
        name="Around the fairy",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [1, 1.0, 648, 77, 402],
            [1, 1.0, 575, 77, 431],
            [1, 1.0, 541, 77, 510],
            [1, 1.0, 574, 77, 585],
            [1, 1.0, 651, 77, 618],
        ],
    ),
    ColoredBananaGroup(
        group=211,
        map_id=Maps.BananaFairyRoom,
        name="Front corner torches",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [5, 2.0, 362, 93, 789],
            [5, 2.0, 368, 93, 219],
        ],
    ),
    ColoredBananaGroup(
        group=212,
        map_id=Maps.BananaFairyRoom,
        name="Back corner torches",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [5, 2.0, 941, 93, 228],
            [5, 2.0, 932, 93, 798],
        ],
    ),
    ColoredBananaGroup(
        group=213,
        map_id=Maps.BananaFairyRoom,
        name="Front ramp",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [1, 1.0, 386, 40, 511],
            [1, 1.0, 419, 48, 511],
            [1, 1.0, 453, 57, 510],
            [1, 1.0, 486, 65, 510],
            [1, 1.0, 519, 73, 510],
        ],
    ),
    ColoredBananaGroup(
        group=214,
        map_id=Maps.BananaFairyRoom,
        name="Left ramp",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [1, 1.0, 647, 40, 245],
            [1, 1.0, 647, 48, 276],
            [1, 1.0, 647, 56, 307],
            [1, 1.0, 647, 63, 338],
            [1, 1.0, 647, 71, 369],
        ],
    ),
    ColoredBananaGroup(
        group=215,
        map_id=Maps.BananaFairyRoom,
        name="Right ramp",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [1, 1.0, 650, 40, 771],
            [1, 1.0, 650, 48, 740],
            [1, 1.0, 650, 56, 709],
            [1, 1.0, 650, 63, 678],
            [1, 1.0, 650, 71, 647],
        ],
    ),
    ColoredBananaGroup(
        group=216,
        map_id=Maps.BananaFairyRoom,
        name="Back ramp",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [1, 1.0, 913, 40, 505],
            [1, 1.0, 880, 48, 505],
            [1, 1.0, 848, 56, 506],
            [1, 1.0, 815, 64, 506],
            [1, 1.0, 783, 72, 506],
        ],
    ),
    ColoredBananaGroup(
        group=217,
        map_id=Maps.BananaFairyRoom,
        name="Throne",
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        locations=[
            [5, 1.0, 658, 94, 512],
        ],
    ),
    ColoredBananaGroup(
        group=218,
        map_id=Maps.BananaFairyRoom,
        name="Rareware GB room",
        konglist=[Kongs.tiny],
        region=Regions.RarewareGBRoom,
        locations=[
            [5, 1.0, 650, 42, 1257],
            [5, 1.0, 624, 42, 1290],
            [5, 1.0, 650, 42, 1317],
            [5, 1.0, 676, 42, 1290],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=219,
        map_id=Maps.Isles,
        name="Around the tree below caves",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[
            [1, 1.0, 2381, 600, 1808],
            [1, 1.0, 2367, 600, 1764],
            [1, 1.0, 2319, 600, 1764],
            [1, 1.0, 2305, 600, 1808],
            [1, 1.0, 2343, 600, 1836],
        ],
    ),
    ColoredBananaGroup(
        group=220,
        map_id=Maps.Isles,
        name="Butterflies near Japes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        locations=[[1, 1.0, 3392, 519, 1900], [1, 1.0, 3392, 532, 1900], [1, 1.0, 3392, 546, 1900], [1, 1.0, 3392, 559, 1900], [1, 1.0, 3392, 572, 1900]],
    ),
    ColoredBananaGroup(
        group=221,
        map_id=Maps.Isles,
        name="Dry plant thing near Aztec",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        locations=[[1, 1.0, 3429, 1016, 1954], [1, 1.0, 3429, 1027, 1951], [1, 1.0, 3429, 1039, 1954], [1, 1.0, 3429, 1050, 1957], [1, 1.0, 3429, 1061, 1954]],
    ),
    ColoredBananaGroup(
        group=222,
        map_id=Maps.Isles,
        name="Steps to Factory lobby",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        locations=[[1, 1.0, 2479, 1220, 3356], [1, 1.0, 2488, 1240, 3380], [1, 1.0, 2462, 1240, 3374], [1, 1.0, 2442, 1260, 3389], [1, 1.0, 2495, 1260, 3403]],
    ),
    ColoredBananaGroup(
        group=223,
        map_id=Maps.Isles,
        name="Directly under Galleon lobby",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsle,
        logic=lambda l: l.swim,
        locations=[[5, 1.3, 1959, 308, 3275]],
    ),
    ColoredBananaGroup(
        group=224,
        map_id=Maps.Treehouse,
        name="Above the exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Treehouse,
        locations=[[1, 1.0, 435, 135, 465], [1, 1.0, 435, 135, 477], [1, 1.0, 435, 135, 490], [1, 1.0, 435, 135, 502], [1, 1.0, 435, 135, 514]],
    ),
    ColoredBananaGroup(
        group=225,
        map_id=Maps.TrainingGrounds,
        name="On the signposts",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        locations=[[5, 1.0, 1412, 84, 1386], [5, 1.0, 1239, 86, 1055]],
    ),
]


BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.Treehouse,
        name="In DK's Treehouse",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Treehouse,
        points=[[327, 116, 397], [369, 116, 363], [400, 116, 396], [360, 130, 498]],
    ),
    Balloon(
        id=2,
        map_id=Maps.TrainingGrounds,
        name="Above the lake",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1775, 123, 990], [1807, 150, 1128], [1775, 120, 1247]],
    ),
    Balloon(
        id=3,
        map_id=Maps.TrainingGrounds,
        name="Banana hoard room",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[2497, 280, 1038], [2497, 380, 1038]],
    ),
    Balloon(
        id=4,
        map_id=Maps.TrainingGrounds,
        name="Around the treehouse",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1464, 176, 1145], [1279, 155, 1107], [1230, 190, 1259], [1394, 151, 1312]],
    ),
    Balloon(
        id=5,
        map_id=Maps.TrainingGrounds,
        name="Above rear ledge",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1424, 343, 1758], [1265, 308, 1753], [1180, 343, 1846], [1094, 300, 1731]],
    ),
    Balloon(
        id=6,
        map_id=Maps.TrainingGrounds,
        name="Above exit ledge",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1092, 300, 756], [1330, 250, 760], [1574, 286, 743], [1330, 250, 760]],
    ),
    Balloon(
        id=7,
        map_id=Maps.TrainingGrounds,
        name="Next to Cranky",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[736, 216, 1843], [656, 200, 1723]],
    ),
    Balloon(
        id=8,
        map_id=Maps.TrainingGrounds,
        name="Training Area",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[858, 180, 755], [755, 180, 725], [839, 175, 639]],
    ),
    Balloon(
        id=9,
        map_id=Maps.TrainingGrounds,
        name="Rear tunnel",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1191, 111, 2156], [1223, 120, 2257], [1253, 100, 2120]],
    ),
    Balloon(
        id=10,
        map_id=Maps.TrainingGrounds,
        name="Exit tunnel",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TrainingGrounds,
        points=[[1694, 75, 286], [1629, 80, 222]],
    ),
    Balloon(
        id=11,
        map_id=Maps.Isles,
        name="Waterfall lower",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[2980, 564, 1084], [2980, 713, 1084]],
    ),
    Balloon(
        id=12,
        map_id=Maps.Isles,
        name="Waterfall upper",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[2980, 941, 1084], [2980, 1084, 1084]],
    ),
    Balloon(
        id=13,
        map_id=Maps.Isles,
        name="Above bananaports",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[2802, 633, 2400], [2749, 633, 2398], [2734, 633, 2347], [2780, 633, 2311], [2818, 633, 2347]],
    ),
    Balloon(
        id=14,
        map_id=Maps.Isles,
        name="Japes shore",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[3096, 600, 2156], [3298, 675, 1950], [3523, 600, 1876], [3481, 650, 2104]],
    ),
    Balloon(
        id=15,
        map_id=Maps.Isles,
        name="Beaver beach",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[3498, 625, 1271], [3436, 630, 1135], [3280, 625, 1025], [3436, 630, 1135]],
    ),
    Balloon(
        id=16,
        map_id=Maps.Isles,
        name="Between pineapple cage and the X platform",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMain,
        points=[[2208, 580, 628], [2149, 600, 725]],
    ),
    Balloon(
        id=17,
        map_id=Maps.Isles,
        name="Around the tree below caves",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesHill,
        points=[[2285, 750, 1800], [2405, 715, 1826], [2338, 700, 1703]],
    ),
    Balloon(
        id=18,
        map_id=Maps.Isles,
        name="Near Aztec",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        points=[[3421, 1140, 1548], [3291, 1140, 1847]],
    ),
    Balloon(
        id=19,
        map_id=Maps.Isles,
        name="In front of DK Isle's eyes",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        points=[[2900, 1150, 2159], [2766, 1150, 2182], [2655, 1150, 2102], [2766, 1150, 2182]],
    ),
    Balloon(
        id=20,
        map_id=Maps.Isles,
        name="Around the fairy tree",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        points=[[1197, 600, 1392], [915, 600, 1282], [977, 600, 1593]],
    ),
    Balloon(
        id=21,
        map_id=Maps.Isles,
        name="Front of Fairy Isle",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.OuterIsles,
        points=[[1033, 630, 2620], [1116, 730, 2535], [1102, 630, 2392], [1187, 580, 2552]],
    ),
    Balloon(
        id=22,
        map_id=Maps.Isles,
        name="Top of Fairy Isle",
        speed=4,
        konglist=[Kongs.diddy],
        region=Regions.IslesAirspace,
        points=[[941, 1080, 2469], [700, 1046, 2556], [750, 1040, 2285]],
    ),
    Balloon(
        id=23,
        map_id=Maps.Isles,
        name="Behind Aztec",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesMainUpper,
        points=[[3787, 1090, 1757], [3682, 1090, 1940]],
    ),
    Balloon(
        id=24,
        map_id=Maps.Isles,
        name="Near Forest",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinIsle,
        points=[[2551, 1620, 1070], [2717, 1620, 974], [2692, 1620, 806], [2717, 1620, 974]],
    ),
    Balloon(
        id=25,
        map_id=Maps.Isles,
        name="Near the Krem Krown",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleTopLevel,
        points=[
            [2535, 1980, 3711],
            [2385, 1960, 3758],
            [2276, 1980, 3660],
            [2385, 1960, 3758],
        ],
    ),
    Balloon(
        id=26,
        map_id=Maps.IslesSnideRoom,
        name="Around Snide",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IslesSnideRoom,
        points=[[574, 234, 468], [323, 234, 449]],
    ),
    Balloon(
        id=27,
        map_id=Maps.Isles,
        name="Upper Factory Path",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        points=[[1973, 1060, 3450], [1992, 1111, 3715]],
    ),
    Balloon(
        id=28,
        map_id=Maps.Isles,
        name="Big pipe in Krem Isle middle back",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.KremIsleBeyondLift,
        points=[[2485, 1247, 3931], [2485, 1350, 3931], [2457, 1377, 3869], [2485, 1350, 3931]],
    ),
    # Balloon(
    #     id=29,
    #     map_id=Maps.Isles,
    #     name="In the Krem Krown",
    #     speed=4,
    #     konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
    #     region=Regions.KremIsleTopLevel,
    #     logic=lambda l: l.scope,
    #     points=[[2439, 2135, 3537], [2439, 2400, 3537]],
    # ),
    # Removed because it just doesn't work
    Balloon(
        id=30,
        map_id=Maps.JungleJapesLobby,
        name="Left side",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        points=[[612, 145, 306], [678, 145, 458], [631, 145, 666], [678, 145, 458]],
    ),
    Balloon(
        id=31,
        map_id=Maps.JungleJapesLobby,
        name="Right side",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.JungleJapesLobby,
        points=[[337, 100, 669], [255, 120, 493], [304, 140, 293], [255, 120, 493]],
    ),
    Balloon(
        id=32,
        map_id=Maps.AngryAztecLobby,
        name="Between columns",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        points=[[427, 170, 294], [545, 155, 243], [577, 195, 349]],
    ),
    Balloon(
        id=33,
        map_id=Maps.AngryAztecLobby,
        name="Above B.Locker",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        points=[[598, 170, 702], [513, 200, 589], [414, 170, 696], [513, 200, 589]],
    ),
    Balloon(
        id=34,
        map_id=Maps.AngryAztecLobby,
        name="Back room",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.AngryAztecLobby,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.IslesAztecLobbyFeather, False) or l.CanPhase(),
        points=[[1120, 100, 585], [1057, 100, 716], [939, 100, 623], [1003, 125, 501]],
    ),
    Balloon(
        id=35,
        map_id=Maps.FranticFactoryLobby,
        name="Vents",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        points=[[265, 190, 226], [660, 185, 214], [517, 185, 180], [417, 185, 180]],
    ),
    Balloon(
        id=36,
        map_id=Maps.FranticFactoryLobby,
        name="Between pipes",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        points=[[238, 45, 284], [238, 222, 284]],
    ),
    Balloon(
        id=37,
        map_id=Maps.FranticFactoryLobby,
        name="Upper path",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FranticFactoryLobby,
        points=[
            [675, 208, 368],
            [651, 200, 600],
            [486, 166, 594],
            [257, 222, 598],
            [486, 166, 594],
            [651, 200, 600],
        ],
    ),
    Balloon(
        id=38,
        map_id=Maps.GloomyGalleonLobby,
        name="Above water",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        points=[
            [400, 200, 700],
            [491, 300, 645],
            [600, 200, 650],
            [759, 300, 625],
            [887, 200, 679],
            [759, 300, 625],
            [600, 200, 650],
            [491, 300, 645],
        ],
    ),
    Balloon(
        id=39,
        map_id=Maps.GloomyGalleonLobby,
        name="Above land",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonLobby,
        points=[[940, 270, 911], [668, 295, 1031], [413, 240, 933], [664, 200, 794]],
    ),
    Balloon(
        id=40,
        map_id=Maps.GloomyGalleonLobby,
        name="In the Tiny room",
        speed=4,
        konglist=[Kongs.tiny],
        region=Regions.GloomyGalleonLobby,
        logic=lambda l: l.swim and ((l.mini and l.twirl and l.tiny and l.CanSlamSwitch(Levels.GloomyGalleon, 2) and l.chunky) or l.CanPhaseswim()) and (not l.IsLavaWater() or l.Melons >= 3),
        points=[[781, 260, 297], [808, 300, 184], [952, 260, 184], [808, 300, 184]],
    ),
    Balloon(
        id=41,
        map_id=Maps.FungiForestLobby,
        name="Crazy fairy balloon",
        speed=23,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        points=[
            [418, 191, 680],
            [295, 160, 600],
            [196, 200, 698],
            [286, 190, 714],
            [370, 100, 657],
            [268, 120, 558],
            [359, 160, 339],
            [224, 200, 287],
            [153, 185, 456],
            [140, 165, 584],
            [269, 50, 604],
        ],
    ),
    Balloon(
        id=42,
        map_id=Maps.FungiForestLobby,
        name="Wrinkly wheel (back wall)",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestLobby,
        points=[[290, 50, 198], [330, 80, 198], [314, 140, 198], [269, 140, 198], [247, 80, 198]],
    ),
    Balloon(
        id=43,
        map_id=Maps.CrystalCavesLobby,
        name="In the lava",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        points=[[305, 100, 305], [305, -80, 305]],
    ),
    Balloon(
        id=44,
        map_id=Maps.CrystalCavesLobby,
        name="Around the bridge",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        points=[[856, 318, 357], [1022, 206, 335], [879, 111, 363], [732, 200, 438]],
    ),
    Balloon(
        id=45,
        map_id=Maps.CrystalCavesLobby,
        name="Boulder room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesLobby,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase() or l.ledgeclip,
        points=[[1724, 70, 657], [1519, 70, 654]],
    ),
    Balloon(
        id=46,
        map_id=Maps.CreepyCastleLobby,
        name="Acid moat",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        points=[[679, 55, 477], [819, 55, 681], [687, 55, 880], [465, 55, 885], [352, 55, 672], [470, 55, 474]],
    ),
    Balloon(
        id=47,
        map_id=Maps.CreepyCastleLobby,
        name="Above center piece",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        points=[[635, 280, 584], [526, 280, 585], [471, 280, 678], [525, 280, 775], [634, 280, 774], [690, 280, 680]],
    ),
    Balloon(
        id=48,
        map_id=Maps.CreepyCastleLobby,
        name="Near B.Locker",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleLobby,
        points=[[483, 70, 1058], [585, 320, 1043], [676, 70, 1055], [585, 320, 1043]],
    ),
    Balloon(
        id=49,
        map_id=Maps.HideoutHelmLobby,
        name="Around Kasplat island",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        points=[[340, 270, 545], [257, 280, 615], [326, 260, 741], [412, 275, 644]],
    ),
    Balloon(
        id=50,
        map_id=Maps.HideoutHelmLobby,
        name="Left side",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HideoutHelmLobby,
        points=[[654, 311, 493], [605, 250, 424], [598, 275, 689]],
    ),
    Balloon(
        id=51,
        map_id=Maps.BananaFairyRoom,
        name="Rareware GB room",
        speed=4,
        konglist=[Kongs.tiny],
        region=Regions.RarewareGBRoom,
        points=[[842, 100, 1211], [664, 110, 1106], [451, 100, 1221], [645, 180, 1343]],
    ),
    Balloon(
        id=52,
        map_id=Maps.BananaFairyRoom,
        name="Around the fairy",
        speed=6,
        konglist=[Kongs.tiny],
        region=Regions.BananaFairyRoom,
        points=[[554, 230, 411], [544, 240, 607], [771, 200, 629], [762, 250, 387]],
    ),
]
