world_version = "1.3"

location_ram_table = {
    "Lost Village: Above Entrance": [0x05, 0x10],
    "Lost Village: Upper Big Room Corner": [0x01, 0x08],
    "Lost Village: Pre-Boss Room Upper": [0x0D, 0x02],
    "Lost Village: Pre-Boss Room Lower": [0x00, 0x40],
    "Lost Village: Drawbridge Room": [0x00, 0x01],
    "Lost Village: Above Drawbridge": [0x0A, 0x02],
    "Lost Village: In Moat": [0x0B, 0x20],
    "Lost Village: Above Guest House Entrance": [0x0A, 0x08],
    "Lost Village: Flying Armor Indoor Room": [0x0D, 0x10],
    "Lost Village: West Plaza": [0x0C, 0x80],
    "Lost Village: West Building Upper": [0x0D, 0x80],
    "Lost Village: West Building Lower": [0x03, 0x80],
    "Lost Village: Central Building": [0x04, 0x01],
    "Lost Village: East Plaza": [0x00, 0x80],
    "Lost Village: Hidden Floor Room 1": [0x04, 0x02],
    "Lost Village: Hidden Floor Room 2": [0x05, 0x08],
    "Lost Village: Mirror Room Left": [0x09, 0x80],
    "Lost Village: Mirror Room Right": [0x0C, 0x01],
    "Lost Village: Axe Armor Hallway": [0x05, 0x02],
    "Lost Village: Underground Shaft": [0x0A, 0x80],

    "Wizardry Lab: Mirror Room": [0x0E, 0x01],
    "Wizardry Lab: Mirror World": [0x0A, 0x10],
    "Wizardry Lab: Main Entry Shaft": [0x02, 0x08],
    "Wizardry Lab: Upper Big Room": [0x0F, 0x01],
    "Wizardry Lab: West Gate": [0x0A, 0x20],
    "Wizardry Lab: Behind West Gate": [0x07, 0x40],
    "Wizardry Lab: Ceiling Secret Room": [0x05, 0x01],
    "Wizardry Lab: East Gate": [0x09, 0x10],
    "Wizardry Lab: Money Gate": [0x0C, 0x20],
    "Wizardry Lab: Underwater Left": [0x0B, 0x40],
    "Wizardry Lab: Underwater Right": [0x02, 0x01],
    "Wizardry Lab: Above Water": [0x09, 0x20],

    "Garden of Madness: Lower Tree Hallway": [0x00, 0x04],
    "Garden of Madness: West Big Room": [0x07, 0x80],
    "Garden of Madness: West Big Room Alcove": [0x0E, 0x04],
    "Garden of Madness: West Upper Room": [0x09, 0x08],
    "Garden of Madness: Hidden Room": [0x08, 0x10],
    "Garden of Madness: Center Room": [0x01, 0x02],
    "Garden of Madness: Money Gate": [0x08, 0x20],
    "Garden of Madness: Underground Room": [0x0E, 0x08],
    "Garden of Madness: East Alcove": [0x0E, 0x20],

    "Demon Guest House: Secret Room": [0x0C, 0x08],
    "Demon Guest House: Antechamber": [0x00, 0x02],
    "Demon Guest House: Lower Main Chamber Bottom Room": [0x04, 0x04],
    "Demon Guest House: Puppet Hole": [0x02, 0x20],
    "Demon Guest House: Number 1 Room": [0x0D, 0x01],
    "Demon Guest House: Number 5 Room": [0x0E, 0x02],
    "Demon Guest House: Number 8 Room": [0x0B, 0x08],
    "Demon Guest House: Number 9 Room": [0x08, 0x40],
    "Demon Guest House: Number 12 Room": [0x0D, 0x20],
    "Demon Guest House: Mirror World": [0x09, 0x04],
    "Demon Guest House: Mirror Room": [0x08, 0x01],
    "Demon Guest House: Doll Alcove": [0x01, 0x10],
    "Demon Guest House: West Wing Left": [0x00, 0x08],
    "Demon Guest House: West Wing Right": [0x07, 0x02],
    "Demon Guest House: Ice Block Room Left": [0x09, 0x01],
    "Demon Guest House: Ice Block Room Right": [0x07, 0x08],
    "Demon Guest House: Central Main Chamber Bottom Room": [0x05, 0x40],
    "Demon Guest House: Central Main Chamber Middle Room": [0x06, 0x80],
    "Demon Guest House: Central Main Chamber Top Room": [0x04, 0x20],
    "Demon Guest House: Beyond Paranoia": [0x09, 0x02],
    "Demon Guest House: Paranoia Mirror": [0x06, 0x40],

    "Dark Chapel: Entrance Alcove": [0x0D, 0x04],
    "Dark Chapel: Catacombs Top Left": [0x04, 0x08],
    "Dark Chapel: Catacombs Middle Room": [0x0A, 0x01],
    "Dark Chapel: Catacombs Soul Barrier": [0x0E, 0x40],
    "Dark Chapel: Catacombs Mirror Room": [0x0A, 0x40],
    "Dark Chapel: Catacombs Mirror World": [0x0B, 0x02],
    "Dark Chapel: Big Square Room Alcove": [0x0B, 0x01],
    "Dark Chapel: Main Room": [0x01, 0x01],
    "Dark Chapel: Bell Room In Bell": [0x05, 0x80],
    "Dark Chapel: Bell Room Top Left": [0x03, 0x04],
    "Dark Chapel: Bell Room Right": [0x02, 0x40],
    "Dark Chapel: Post-Dimitrii Room": [0x0B, 0x04],
    "Dark Chapel: Big Room Top Right": [0x0F, 0x02],
    "Dark Chapel: Big Room Central": [0x07, 0x10],
    "Dark Chapel: Big Room Lower": [0x01, 0x20],

    "Condemned Tower: 1F West": [0x06, 0x20],
    "Condemned Tower: 1F East": [0x02, 0x04],
    "Condemned Tower: 2F East": [0x0B, 0x10],
    "Condemned Tower: 5F West": [0x0E, 0x10],
    "Condemned Tower: 7F West": [0x07, 0x04],
    "Condemned Tower: Top of the Tower": [0x03, 0x40],

    "Cursed Clock Tower: Money Gate": [0x0C, 0x10],
    "Cursed Clock Tower: Lower Corner Room": [0x08, 0x80],
    "Cursed Clock Tower: Mirror Room": [0x08, 0x02],
    "Cursed Clock Tower: Mirror World": [0x0B, 0x80],
    "Cursed Clock Tower: Bugbear Hallway": [0x00, 0x10],
    "Cursed Clock Tower: East Gear Room": [0x07, 0x20],
    "Cursed Clock Tower: Spike Room Secret": [0x05, 0x20],

    "Subterranean Hell: Giant Underwater Room Center Left": [0x02, 0x80],
    "Subterranean Hell: Giant Underwater Room Center Right": [0x04, 0x40],
    "Subterranean Hell: Giant Underwater Room Top Left": [0x08, 0x04],
    "Subterranean Hell: Giant Underwater Room Bottom Right": [0x06, 0x10],
    "Subterranean Hell: Near Save Room": [0x07, 0x01],
    "Subterranean Hell: Central Lower Room": [0x06, 0x04],
    "Subterranean Hell: Central Upper Room": [0x04, 0x80],
    "Subterranean Hell: Behind Waterfall": [0x08, 0x08],
    "Subterranean Hell: Waterfall Room Lower": [0x06, 0x02],
    "Subterranean Hell: Waterfall Room Middle": [0x06, 0x08],
    "Subterranean Hell: Waterfall Room Upper": [0x06, 0x01],

    "Silenced Ruins: Ice Block Room": [0x0C, 0x04],
    "Silenced Ruins: Mirror Room": [0x03, 0x01],
    "Silenced Ruins: Mirror World": [0x01, 0x80],

    "The Pinnacle: Lower Hidden Room": [0x05, 0x04],
    "The Pinnacle: Under Big Staircase": [0x0D, 0x40],
    "The Pinnacle: Central Indoor Room": [0x03, 0x02],
    "The Pinnacle: Central Outdoor Room": [0x0E, 0x80],
    "The Pinnacle: Before Throne Room Secret Left": [0x0C, 0x02],
    "The Pinnacle: Before Throne Room Secret Right": [0x0D, 0x08],
    "The Pinnacle: Beyond Throne Room": [0x00, 0x20],

    "The Abyss: Sand Area": [0x02, 0x10],
    "The Abyss: Ice Area": [0x0C, 0x40]
}

global_soul_table = [
    "Puppet Master Soul",
    "Zephyr Soul",
    "Paranoia Soul",
    "Imp Soul",
    "Skeleton Soul",
    "Zombie Soul",
    "Axe Armor Soul",
    "Student Witch Soul",
    "Warg Soul",
    "Bomber Armor Soul",
    "Amalaric Sniper Soul",
    "Cave Troll Soul",
    "Waiter Skeleton Soul",
    "Slime Soul",
    "Yorick Soul",
    "Une Soul",
    "Mandragora Soul",
    "Rycuda Soul",
    "Fleaman Soul",
    "Ripper Soul",
    "Guillotiner Soul",
    "Killer Clown Soul",
    "Malachi Soul",
    "Disc Armor Soul",
    "Great Axe Armor Soul",
    "Slaughterer Soul",
    "Hell Boar Soul",
    "Frozen Shade Soul",
    "Merman Soul",
    "Larva Soul",
    "Ukoback Soul",
    "Decarabia Soul",
    "Succubus Soul",
    "Slogra Soul",
    "Erinys Soul",
    "Homunculus Soul",
    "Witch Soul",
    "Fish Head Soul",
    "Mollusca Soul",
    "Dead Mate Soul",
    "Killer Fish Soul",
    "Malacoda Soul",
    "Flame Demon Soul",
    "Aguni Soul",
    "Abaddon Soul",
    "Hell Fire",
    "Alucard Bat",
    "Holy Flame",
    "Blue Splash",
    "Holy Lightning",
    "Cross",
    "Holy Water",
    "Grand Cross",
    "Flying Armor Soul",
    "Bat Company Soul",
    "Black Panther Soul",
    "Armor Knight Soul",
    "Spin Devil Soul",
    "Skull Archer Soul",
    "Ghost Soul",
    "Yeti Soul",
    "Buer Soul",
    "Manticore Soul",
    "Mushussu Soul",
    "White Dragon Soul",
    "Catoblepas Soul",
    "Gorgon Soul",
    "Persephone Soul",
    "Flying Humanoid Soul",
    "Devil Soul",
    "Medusa Head Soul",
    "Final Guard Soul",
    "Werewolf Soul",
    "Alura Une Soul",
    "Iron Golem Soul",
    "Bone Ark Soul",
    "Barbariccia Soul",
    "Valkyrie Soul",
    "Bat Soul",
    "Great Armor Soul",
    "Mini Devil Soul",
    "Harpy Soul",
    "Corpseweed Soul",
    "Quetzalcoatl Soul",
    "Needles Soul",
    "Alastor Soul",
    "Gaibon Soul",
    "Gergoth Soul",
    "Death Soul",
    "Golem Soul",
    "Bone Pillar Soul",
    "Lilith Soul",
    "Ghost Dancer Soul",
    "Tanjelly Soul",
    "Bugbear Soul",
    "Arc Demon Soul",
    "Giant Slug Soul",
    "Killer Doll Soul",
    "Tombstone Soul",
    "Treant Soul",
    "Ghoul Soul",
    "Skelerang Soul",
    "Skeleton Ape Soul",
    "Dead Warrior Soul",
    "Dead Pirate Soul",
    "Draghignazzo Soul",
    "Heart Eater Soul",
    "Peeping Eye Soul",
    "Skeleton Farmer Soul",
    "The Creature Soul",
    "Mimic Soul",
    "Mothman Soul",
    "Ouija Table Soul",
    "Dead Crusader Soul",
    "Stolas Soul",
    "Wakwak Tree Soul",
    "Balore Soul",
    "Malphas Soul",
    "Doppelganger Soul",
    "Rahab Soul",
    "Hippogryph Soul",
    "Procel Soul",
    "Mud Demon Soul"
]

global_weapon_table = [
    "Bare Knuckles",
    "Knife",
    "Combat Knife",
    "Baselard",
    "Cutall",
    "Cinquedia",
    "Rapier",
    "Fleuret",
    "Main Gauche",
    "Small Sword",
    "Estoc",
    "Whip Sword",
    "Garian Sword",
    "Kris Naga",
    "Nebula",
    "Short Sword",
    "Cutlass",
    "Long Sword",
    "Fragarach",
    "Hrunting",
    "Mystletain",
    "Joyeuse",
    "Milican's Sword",
    "Ice Brand",
    "Laevatain",
    "Burtgang",
    "Kaladbolg",
    "Valmanway",
    "Alucard Sword",
    "Claymore",
    "Falchion",
    "Great Sword",
    "Durandal",
    "Dainslef",
    "Ascalon",
    "Balmung",
    "Final Sword",
    "Claimh Solais",
    "Spear",
    "Partizan",
    "Halberd",
    "Lance",
    "Trident",
    "Brionac",
    "Geiborg",
    "Longinus",
    "Gungner",
    "Mace",
    "Morgenstern",
    "Mjollnjr",
    "Axe",
    "Battle Axe",
    "Bhuj",
    "Great Axe",
    "Golden Axe",
    "Death Scythe",
    "Blunt Sword",
    "Katana",
    "Kotetsu",
    "Masamune",
    "Osafune",
    "Kunitsuna",
    "Yasutsuna",
    "Muramasa",
    "Brass Knuckles",
    "Cestus",
    "Whip Knuckle",
    "Mach Punch",
    "Kaiser Knuckle",
    "Handgun",
    "Silver Gun",
    "Boomerang",
    "Chakram",
    "Tomahawk",
    "Throwing Sickle",
    "RPG",
    "Terror Bear",
    "Nunchakus",
    "Whip"
]

valid_random_starting_weapons = [
    "Knife",
    "Combat Knife",
    "Baselard",
    "Cutall",
    "Cinquedia",
    "Rapier",
    "Fleuret",
    "Main Gauche",
    "Small Sword",
    "Estoc",
    "Whip Sword",
    "Garian Sword",
    "Kris Naga",
    "Nebula",
    "Short Sword",
    "Cutlass",
    "Long Sword",
    "Fragarach",
    "Hrunting",
    "Mystletain",
    "Joyeuse",
    "Milican's Sword",
    "Ice Brand",
    "Laevatain",
    "Burtgang",
    "Kaladbolg",
    "Valmanway",
    "Claymore",
    "Falchion",
    "Great Sword",
    "Durandal",
    "Dainslef",
    "Ascalon",
    "Balmung",
    "Final Sword",
    "Claimh Solais",
    "Spear",
    "Partizan",
    "Halberd",
    "Lance",
    "Trident",
    "Brionac",
    "Geiborg",
    "Longinus",
    "Gungner",
    "Mace",
    "Morgenstern",
    "Mjollnjr",
    "Axe",
    "Battle Axe",
    "Bhuj",
    "Great Axe",
    "Golden Axe",
    "Death Scythe",
    "Blunt Sword",
    "Katana",
    "Kotetsu",
    "Masamune",
    "Osafune",
    "Kunitsuna",
    "Yasutsuna",
    "Muramasa",
    "Brass Knuckles",
    "Cestus",
    "Whip Knuckle",
    "Mach Punch",
    "Kaiser Knuckle",
    "Handgun",
    "Silver Gun",
    "RPG",
    "Terror Bear",
    "Nunchakus"
]

base_weapons = [
    "Knife",
    "Rapier",
    "Short Sword",
    "Claymore",
    "Mace",
    "Blunt Sword",
    "Axe",
    "Spear",
    "Handgun",
    "Brass Knuckles"
]

base_check_address_table = {
    "Lost Village: Above Entrance": 0xA4B6C,
    "Lost Village: Upper Big Room Corner": 0xA4EC0,
    "Lost Village: Pre-Boss Room Upper": 0xA52A4,
    "Lost Village: Pre-Boss Room Lower": 0xA5298,
    "Lost Village: Drawbridge Room": 0xA55EC,
    "Lost Village: Above Drawbridge": 0xA5604,
    "Lost Village: In Moat": 0xA55F8,
    "Lost Village: Above Guest House Entrance": 0xA564C,
    "Lost Village: Flying Armor Indoor Room": 0xA4FB0,
    "Lost Village: West Plaza": 0xA5718,
    "Lost Village: West Building Upper": 0xA4C8C,
    "Lost Village: West Building Lower": 0xA4C98,
    "Lost Village: Central Building": 0xA501C,
    "Lost Village: East Plaza": 0xA5118,
    "Lost Village: Hidden Floor Room 1": 0xA546C,
    "Lost Village: Hidden Floor Room 2": 0xA5478,
    "Lost Village: Mirror Room Left": 0xA5520,
    "Lost Village: Mirror Room Right": 0xA552C,
    "Lost Village: Axe Armor Hallway": 0xA4E3C,
    "Lost Village: Underground Shaft": 0xA51F0,

    "Wizardry Lab: Mirror Room": 0xAD53C,
    "Wizardry Lab: Mirror World": 0xAD548,
    "Wizardry Lab: Main Entry Shaft": 0xAD11C,
    "Wizardry Lab: Upper Big Room": 0xAD23C,
    "Wizardry Lab: West Gate": 0xACE34,
    "Wizardry Lab: Behind West Gate": 0xACE28,
    "Wizardry Lab: Ceiling Secret Room": 0xAD584,
    "Wizardry Lab: East Gate": 0xAD458,
    "Wizardry Lab: Money Gate": 0xAD5CC,
    "Wizardry Lab: Underwater Left": 0xAD9BC,
    "Wizardry Lab: Underwater Right": 0xAD9C8,
    "Wizardry Lab: Above Water": 0xADA4C,

    "Garden of Madness: Lower Tree Hallway": 0xB0224,
    "Garden of Madness: West Big Room": 0xB0014,
    "Garden of Madness: West Big Room Alcove": 0xB0008,
    "Garden of Madness: West Upper Room": 0xB0128,
    "Garden of Madness: Hidden Room": 0xB0248,
    "Garden of Madness: Center Room": 0xB0C14,
    "Garden of Madness: Money Gate": 0xB0A64,
    "Garden of Madness: Underground Room": 0xB09E0,
    "Garden of Madness: East Alcove": 0xB08B4,

    "Demon Guest House: Secret Room": 0xAA368,
    "Demon Guest House: Antechamber": 0xAA2FC,
    "Demon Guest House: Lower Main Chamber Bottom Room": 0xAA338,
    "Demon Guest House: Puppet Hole": 0xAA08C,
    "Demon Guest House: Number 1 Room": 0xA97A4,
    "Demon Guest House: Number 5 Room": 0xA9810,
    "Demon Guest House: Number 8 Room": 0xA9864,
    "Demon Guest House: Number 9 Room": 0xA9888,
    "Demon Guest House: Number 12 Room": 0xA98DC,
    "Demon Guest House: Mirror World": 0xA9978,
    "Demon Guest House: Mirror Room": 0xA996C,
    "Demon Guest House: Doll Alcove": 0xA9C0C,
    "Demon Guest House: West Wing Left": 0xA9708,
    "Demon Guest House: West Wing Right": 0xA9B70,
    "Demon Guest House: Ice Block Room Left": 0xA9564,
    "Demon Guest House: Ice Block Room Right": 0xA9570,
    "Demon Guest House: Central Main Chamber Middle Room": 0xAA26C,
    "Demon Guest House: Central Main Chamber Top Room": 0xAA224,
    "Demon Guest House: Beyond Paranoia": 0xA96CC,
    "Demon Guest House: Paranoia Mirror": 0xA9B10,

    "Dark Chapel: Entrance Alcove": 0xB2714,
    "Dark Chapel: Catacombs Top Left": 0xB2798,
    "Dark Chapel: Catacombs Middle Room": 0xB27C8,
    "Dark Chapel: Catacombs Soul Barrier": 0xB2618,
    "Dark Chapel: Catacombs Mirror Room": 0xB2BB8,
    "Dark Chapel: Catacombs Mirror World": 0xB2BC4,
    "Dark Chapel: Big Square Room Alcove": 0xB2660,
    "Dark Chapel: Main Room": 0xB2D08,
    "Dark Chapel: Bell Room Top Left": 0xB2BF4,
    "Dark Chapel: Bell Room Right": 0xB2BE8,
    "Dark Chapel: Post-Dimitrii Room": 0xB2C9C,
    "Dark Chapel: Big Room Top Right": 0xB2E10,
    "Dark Chapel: Big Room Central": 0xB2E04,
    "Dark Chapel: Big Room Lower": 0xB2E1C,

    "Condemned Tower: 1F West": 0xB5BA4,
    "Condemned Tower: 1F East": 0xB5F34,
    "Condemned Tower: 2F East": 0xB5F28,
    "Condemned Tower: 5F West": 0xB5AC0,
    "Condemned Tower: 7F West": 0xB5A6C,
    "Condemned Tower: Top of the Tower": 0xB5A48,

    "Cursed Clock Tower: Money Gate": 0xBD1CC,
    "Cursed Clock Tower: Lower Corner Room": 0xBC728,
    "Cursed Clock Tower: Mirror Room": 0xBCF80,
    "Cursed Clock Tower: Mirror World": 0xBCF8C,
    "Cursed Clock Tower: Bugbear Hallway": 0xBCF2C,
    "Cursed Clock Tower: East Gear Room": 0xBD004,

    "Subterranean Hell: Giant Underwater Room Center Left": 0xB8B4C,
    "Subterranean Hell: Giant Underwater Room Center Right": 0xB8B40,
    "Subterranean Hell: Giant Underwater Room Top Left": 0xB8B34,
    "Subterranean Hell: Giant Underwater Room Bottom Right": 0xB8B58,
    "Subterranean Hell: Near Save Room": 0xB8750,
    "Subterranean Hell: Central Lower Room": 0xB8618,
    "Subterranean Hell: Central Upper Room": 0xB86C0,
    "Subterranean Hell: Behind Waterfall": 0xB83B4,
    "Subterranean Hell: Waterfall Room Lower": 0xB8420,
    "Subterranean Hell: Waterfall Room Middle": 0xB8414,
    "Subterranean Hell: Waterfall Room Upper": 0xB8408,

    "Silenced Ruins: Ice Block Room": 0xBA390,
    "Silenced Ruins: Mirror Room": 0xBA024,
    "Silenced Ruins: Mirror World": 0xBA030,

    "The Pinnacle: Lower Hidden Room": 0xBF02C,
    "The Pinnacle: Under Big Staircase": 0xBEE4C,
    "The Pinnacle: Central Indoor Room": 0xBF0C8,
    "The Pinnacle: Central Outdoor Room": 0xBF158,
    "The Pinnacle: Before Throne Room Secret Left": 0xBEDEC,
    "The Pinnacle: Before Throne Room Secret Right": 0xBEDF8,
    "The Pinnacle: Beyond Throne Room": 0xBED68,

    "The Abyss: Sand Area": 0xC2020,
    "The Abyss: Ice Area": 0xC20F8
}

easter_egg_table = {
    "Dark Chapel: Bell Room In Bell": [0xB2BE7, 0x158C6C],
    "Demon Guest House: Central Main Chamber Bottom Room": [0xAA2BF, 0x158C60],
    "Cursed Clock Tower: Spike Room Secret": [0xBCEE3, 0x158C54]
}

warp_room_table = [
    "Lost Village",
    "Wizardry Lab",
    "Garden of Madness",
    "Dark Chapel",
    "Demon Guest House",
    "Subterranean Hell",
    "Silenced Ruins",
    "Cursed Clock Tower"
    # Maybe add Condemned Tower?
]

warp_room_regions = {
    "Lost Village": "Lost Village Lower",
    "Wizardry Lab": "Wizardry Lab Main",
    "Garden of Madness": "Garden of Madness Lower",
    "Dark Chapel": "Dark Chapel",
    "Demon Guest House": "Demon Guest House West Wing",
    "Subterranean Hell": "Subterranean Hell Central Upper",
    "Silenced Ruins": "Silenced Ruins",
    "Cursed Clock Tower": "Cursed Clock Tower Post-Boss"
}

warp_room_bits = {
    "Lost Village": 0x01,
    "Demon Guest House": 0x02,
    "Wizardry Lab": 0x04,
    "Garden of Madness": 0x08,
    "Dark Chapel": 0x10,
    # "Condemned Tower": 0x20,
    # "Mine of Judgment": 0x40,
    "Subterranean Hell": 0x80,
    "Silenced Ruins": 0x0100,
    "Cursed Clock Tower": 0x0200,
    # "The Pinnacle": 0x0400,
    # "The Abyss": 0x0800
}

global_item_table = [
    "Potion",
    "High Potion",
    "Super Potion",
    "Mind Up",
    "High Mind Up",
    "Mana Prism",
    "Anti-Venom",
    "Uncurse Potion",
    "Meat Strip",
    "Tasty Meat",
    "Rice Ball",
    "Mushroom",
    "Corn Soup",
    "Beef Curry",
    "Noodles",
    "Cream Soda",
    "Cream Puff",
    "Milk",
    "Coffee",
    "Tea",
    "Pudding",
    "Strawberry",
    "Melon",
    "Grapes",
    "Hamburger",
    "Fried Chicken",
    "Hot Dog",
    "Pumpkin Pie",
    "Pancake",
    "Piroshki",
    "Tinned Spinach",
    "Foie Gras",
    "Caviar",
    "Truffle",
    "Paella",
    "Spaghetti",
    "Ice Cream",
    "Salmon Meuniere",
    "Boiled Starfish",
    "Amanita",
    "Rotten Meat",
    "Spoiled Milk",
    "Rusty Food Tin",
    "Return Gem",
    "CASTLE MAP 1",
    "CASTLE MAP 2",
    "UMA News 1-1",
    "UMA News 1-2",
    "UMA News 1-3",
    "UMA News 2-1",
    "UMA News 2-2",
    "UMA News 2-3",
    "UMA News 2-4",
    "UMA News 3-1",
    "UMA News 3-2",
    "UMA News 3-3",
    "UMA News 4",
    "Tower Key",
    "AP Item",
    "AP Item (prog)",
    "Soul Can",
    "Magic Seal 1",
    "Magic Seal 2",
    "Magic Seal 3",
    "Magic Seal 4",
    "Magic Seal 5",
    "Bare Knuckles",
    "Knife",
    "Combat Knife",
    "Baselard",
    "Cutall",
    "Cinquedia",
    "Rapier",
    "Fleuret",
    "Main Gauche",
    "Small Sword",
    "Estoc",
    "Whip Sword",
    "Garian Sword",
    "Kris Naga",
    "Nebula",
    "Short Sword",
    "Cutlass",
    "Long Sword",
    "Fragarach",
    "Hrunting",
    "Mystletain",
    "Joyeuse",
    "Milican's Sword",
    "Ice Brand",
    "Laevatain",
    "Burtgang",
    "Kaladbolg",
    "Valmanway",
    "Alucard Sword",
    "Claymore",
    "Falchion",
    "Great Sword",
    "Durandal",
    "Dainslef",
    "Ascalon",
    "Balmung",
    "Final Sword",
    "Claimh Solais",
    "Spear",
    "Partizan",
    "Halberd",
    "Lance",
    "Trident",
    "Brionac",
    "Geiborg",
    "Longinus",
    "Gungner",
    "Mace",
    "Morgenstern",
    "Mjollnjr",
    "Axe",
    "Battle Axe",
    "Bhuj",
    "Great Axe",
    "Golden Axe",
    "Death Scythe",
    "Blunt Sword",
    "Katana",
    "Kotetsu",
    "Masamune",
    "Osafune",
    "Kunitsuna",
    "Yasutsuna",
    "Muramasa",
    "Brass Knuckles",
    "Cestus",
    "Whip Knuckle",
    "Mach Punch",
    "Kaiser Knuckle",
    "Handgun",
    "Silver Gun",
    "Boomerang",
    "Chakram",
    "Tomahawk",
    "Throwing Sickle",
    "RPG",
    "Terror Bear",
    "Nunchakus",
    "Whip",
    "Casual Clothes",
    "Cloth Tunic",
    "Gym Clothes",
    "Kung Fu Suit",
    "Biker Jacket",
    "War Fatigues",
    "Ninja Suit",
    "Three 7s",
    "Justaucorps",
    "Army Jacket",
    "Pitch Black Suit",
    "Olrox's Suit",
    "Dracula's Tunic",
    "Leather Armor",
    "Breastplate",
    "Ring Mail",
    "Scale Mail",
    "Chain Mail",
    "Hauberk",
    "Cuirass",
    "Blocking Mail",
    "Eversing",
    "Demon's Mail",
    "Silk Robe",
    "Mage Robe",
    "Elfin Robe",
    "Wyrm Robe",
    "Aquarius",
    "Serenity Robe",
    "Death's Robe",
    "Cape",
    "Traveler Cape",
    "Crimson Cloak",
    "Black Cloak",
    "Pendant",
    "Heart Pendant",
    "Skull Necklace",
    "Flame Necklace",
    "Rosary",
    "Scarf",
    "Red Scarf",
    "Neck Warmer",
    "Power Belt",
    "Black Belt",
    "Megingiord",
    "Hoop Earring",
    "Turquoise Stud",
    "Silver Stud",
    "Gold Stud",
    "Bloody Stud",
    "Platinum Stud",
    "Tear Of Blood",
    "Lucky Charm",
    "Mina's Talisman",
    "Satan's Ring",
    "Rare Ring",
    "Soul Eater Ring",
    "Rune Ring",
    "Shaman Ring",
    "Gold Ring",
    "Chaos Ring"
]

common_filler_pool = [
    "Potion",
    "High Potion",
    "Super Potion",
    "Mind Up",
    "High Mind Up",
    "Mana Prism",
    "Anti-Venom",
    "Uncurse Potion",
    "Meat Strip",
    "Tasty Meat",
    "Rice Ball",
    "Mushroom",
    "Corn Soup",
    "Beef Curry",
    "Noodles",
    "Cream Soda",
    "Cream Puff",
    "Milk",
    "Coffee",
    "Tea",
    "Pudding",
    "Strawberry",
    "Melon",
    "Grapes",
    "Hamburger",
    "Fried Chicken",
    "Hot Dog",
    "Pumpkin Pie",
    "Pancake",
    "Piroshki",
    "Tinned Spinach",
    "Foie Gras",
    "Caviar",
    "Truffle",
    "Paella",
    "Spaghetti",
    "Ice Cream",
    "Salmon Meuniere",
    "Boiled Starfish",
    "Amanita",
    "Rotten Meat",
    "Spoiled Milk",
    "Rusty Food Tin",
    "CASTLE MAP 1",
    "CASTLE MAP 2",
    "UMA News 1-1",
    "UMA News 1-2",
    "UMA News 1-3",
    "UMA News 2-1",
    "UMA News 2-2",
    "UMA News 2-3",
    "UMA News 2-4",
    "UMA News 3-1",
    "UMA News 3-2",
    "UMA News 3-3",
    "UMA News 4",
    "Knife",
    "Combat Knife",
    "Baselard",
    "Cutall",
    "Cinquedia",
    "Rapier",
    "Fleuret",
    "Main Gauche",
    "Small Sword",
    "Estoc",
    "Whip Sword",
    "Garian Sword",
    "Kris Naga",
    "Nebula",
    "Short Sword",
    "Cutlass",
    "Long Sword",
    "Fragarach",
    "Hrunting",
    "Mystletain",
    "Joyeuse",
    "Milican's Sword",
    "Ice Brand",
    "Laevatain",
    "Burtgang",
    "Kaladbolg",
    "Valmanway",
    "Alucard Sword",
    "Claymore",
    "Falchion",
    "Great Sword",
    "Durandal",
    "Dainslef",
    "Ascalon",
    "Balmung",
    "Final Sword",
    "Claimh Solais",
    "Spear",
    "Partizan",
    "Halberd",
    "Lance",
    "Trident",
    "Brionac",
    "Geiborg",
    "Longinus",
    "Gungner",
    "Mace",
    "Morgenstern",
    "Mjollnjr",
    "Axe",
    "Battle Axe",
    "Bhuj",
    "Great Axe",
    "Golden Axe",
    "Death Scythe",
    "Blunt Sword",
    "Katana",
    "Kotetsu",
    "Masamune",
    "Osafune",
    "Kunitsuna",
    "Yasutsuna",
    "Muramasa",
    "Brass Knuckles",
    "Cestus",
    "Whip Knuckle",
    "Mach Punch",
    "Kaiser Knuckle",
    "Handgun",
    "Silver Gun",
    "Boomerang",
    "Chakram",
    "Tomahawk",
    "Throwing Sickle",
    "Cloth Tunic",
    "Gym Clothes",
    "Kung Fu Suit",
    "Biker Jacket",
    "War Fatigues",
    "Ninja Suit",
    "Three 7s",
    "Justaucorps",
    "Army Jacket",
    "Pitch Black Suit",
    "Olrox's Suit",
    "Dracula's Tunic",
    "Leather Armor",
    "Breastplate",
    "Ring Mail",
    "Scale Mail",
    "Chain Mail",
    "Hauberk",
    "Cuirass",
    "Blocking Mail",
    "Eversing",
    "Demon's Mail",
    "Silk Robe",
    "Mage Robe",
    "Elfin Robe",
    "Wyrm Robe",
    "Aquarius",
    "Serenity Robe",
    "Death's Robe",
    "Cape",
    "Traveler Cape",
    "Crimson Cloak",
    "Black Cloak",
    "Pendant",
    "Heart Pendant",
    "Skull Necklace",
    "Flame Necklace",
    "Rosary",
    "Scarf",
    "Red Scarf",
    "Neck Warmer",
    "Power Belt",
    "Black Belt",
    "Megingiord",
    "Hoop Earring",
    "Turquoise Stud",
    "Silver Stud",
    "Gold Stud",
    "Bloody Stud",
    "Platinum Stud",
    "Tear Of Blood",
    "Lucky Charm",
    "Satan's Ring",
    "Rare Ring",
    "Soul Eater Ring",
    "Rune Ring",
    "Shaman Ring",
    "Gold Ring"
]

enemy_table = [
    "Zombie",
    "Bat",
    "Ghost",
    "Skeleton",
    "Ouija Table",
    "Peeping Eye",
    "Axe Armor",
    "Skull Archer",
    "Warg",
    "Spin Devil",
    "Armor Knight",
    "Student Witch",
    "Slaughterer",
    "Bomber Armor",
    "Golem",
    "Slime",
    "Une",
    "Skeleton Ape",
    "Manticore",
    "Mollusca",
    "Rycuda",
    "Mandragora",
    "Yorick",
    "Skeleton Farmer",
    "The Creature",
    "Catoblepas",
    "Ghoul",
    "Corpseweed",
    "Yeti",
    "Tombstone",
    "Ghost Dancer",
    "Flying Humanoid",
    "Mini Devil",
    "Quetzalcoatl",
    "Treant",
    "Amalaric Sniper",
    "Valkyrie",
    "Great Armor",
    "Killer Doll",
    "Waiter Skeleton",
    "Persephone",
    "Witch",
    "Buer",
    "Lilith",
    "Killer Clown",
    "Skelerang",
    "Fleaman",
    "Devil",
    "Guillotiner",
    "Draghignazzo",
    "Needles",
    "Hell Boar",
    "Bone Pillar",
    "White Dragon",
    "Wakwak Tree",
    "Imp",
    "Harpy",
    "Barbariccia",
    "Malachi",
    "Cave Troll",
    "Larva",
    "Heart Eater",
    "Merman",
    "Fish Head",
    "Medusa Head",
    "Ukoback",
    "Killer Fish",
    "Mimic",
    "Dead Pirate",
    "Frozen Shade",
    "Homunculus",
    "Disc Armor",
    "Decarabia",
    "Dead Mate",
    "Bugbear",
    "Procel",
    "Bone Ark",
    "Gorgon",
    "Alura Une",
    "Great Axe Armor",
    "Mothman",
    "Mushussu",
    "Dead Crusader",
    "Dead Warrior",
    "Erinys",
    "Succubus",
    "Ripper",
    "Black Panther",
    "Mud Demon",
    "Giant Slug",
    "Werewolf",
    "Flame Demon",
    "Tanjelly",
    "Arc Demon",
    "Gaibon",
    "Slogra",
    "Stolas",
    "Final Guard",
    "Malacoda",
    "Alastor",
    "Iron Golem",
    "Flying Armor",
    "Balore",
    "Malphas",
    "Dimitrii",
    "Dario",
    "Puppet Master",
    "Rahab",
    "Gergoth",
    "Zephyr",
    "Bat Company",
    "Paranoia",
    "Aguni",
    "Death",
    "Abaddon",
    "Menace",
    "Soma",
    "Dracula"
]

boss_list = {
    "Flying Armor",
    "Balore",
    "Malphas",
    "Dimitrii",
    "Dario",
    "Puppet Master",
    "Rahab",
    "Gergoth",
    "Zephyr",
    "Bat Company",
    "Paranoia",
    "Aguni",
    "Death",
    "Abaddon",
    "Menace",
    "Soma",
    "Dracula"
}