from typing import Dict, Set, NamedTuple, Optional
from BaseClasses import ItemClassification


class ItemData(NamedTuple):
    category: str
    code: Optional[int]
    classification: ItemClassification
    amount: Optional[int] = 1


item_table: Dict[str, ItemData] = {
    "$1": ItemData("Money", 0x100, ItemClassification.filler, 0),
    "$10": ItemData("Money", 0x101, ItemClassification.filler, 0),
    "$50": ItemData("Money", 0x102, ItemClassification.filler, 0),
    "$100": ItemData("Money", 0x103, ItemClassification.filler, 0),
    "$500": ItemData("Money", 0x104, ItemClassification.filler, 0),
    "$1000": ItemData("Money", 0x105, ItemClassification.filler, 0),
    "$2000": ItemData("Money", 0x106, ItemClassification.filler, 0),

    "Potion": ItemData("Consumables", 0x200, ItemClassification.filler, 0),
    "High Potion": ItemData("Consumables", 0x201, ItemClassification.filler, 0),
    "Super Potion": ItemData("Consumables", 0x202, ItemClassification.useful, 0),
    "Mind Up": ItemData("Consumables", 0x203, ItemClassification.filler, 0),
    "High Mind Up": ItemData("Consumables", 0x204, ItemClassification.filler, 0),
    "Mana Prism": ItemData("Consumables", 0x205, ItemClassification.useful, 0),
    "Anti-Venom": ItemData("Consumables", 0x206, ItemClassification.filler, 0),
    "Uncurse Potion": ItemData("Consumables", 0x207, ItemClassification.filler, 0),
    "Meat Strip": ItemData("Consumables", 0x208, ItemClassification.filler, 0),
    "Tasty Meat": ItemData("Consumables", 0x209, ItemClassification.useful, 0),
    "Rice Ball": ItemData("Consumables", 0x20A, ItemClassification.useful, 0),
    "Mushroom": ItemData("Consumables", 0x20B, ItemClassification.filler, 0),
    "Corn Soup": ItemData("Consumables", 0x20C, ItemClassification.filler, 0),
    "Beef Curry": ItemData("Consumables", 0x20D, ItemClassification.useful, 0),
    "Noodles": ItemData("Consumables", 0x20E, ItemClassification.useful, 0),
    "Cream Soda": ItemData("Consumables", 0x20F, ItemClassification.filler, 0),
    "Cream Puff": ItemData("Consumables", 0x210, ItemClassification.filler, 0),
    "Milk": ItemData("Consumables", 0x211, ItemClassification.filler, 0),
    "Coffee": ItemData("Consumables", 0x212, ItemClassification.filler, 0),
    "Tea": ItemData("Consumables", 0x213, ItemClassification.filler, 0),
    "Pudding": ItemData("Consumables", 0x214, ItemClassification.filler, 0),
    "Strawberry": ItemData("Consumables", 0x215, ItemClassification.filler, 0),
    "Melon": ItemData("Consumables", 0x216, ItemClassification.useful, 0),
    "Grapes": ItemData("Consumables", 0x217, ItemClassification.filler, 0),
    "Hamburger": ItemData("Consumables", 0x218, ItemClassification.filler, 0),
    "Fried Chicken": ItemData("Consumables", 0x219, ItemClassification.filler, 0),
    "Hot Dog": ItemData("Consumables", 0x21A, ItemClassification.filler, 0),
    "Pumpkin Pie": ItemData("Consumables", 0x21B, ItemClassification.filler, 0),
    "Pancake": ItemData("Consumables", 0x21C, ItemClassification.filler, 0),
    "Piroshki": ItemData("Consumables", 0x21D, ItemClassification.filler, 0),
    "Tinned Spinach": ItemData("Consumables", 0x21E, ItemClassification.filler, 0),
    "Foie Gras": ItemData("Consumables", 0x21F, ItemClassification.useful, 0),
    "Caviar": ItemData("Consumables", 0x220, ItemClassification.useful, 0),
    "Truffle": ItemData("Consumables", 0x221, ItemClassification.useful, 0),
    "Paella": ItemData("Consumables", 0x222, ItemClassification.filler, 0),
    "Spaghetti": ItemData("Consumables", 0x223, ItemClassification.filler, 0),
    "Ice Cream": ItemData("Consumables", 0x224, ItemClassification.filler, 0),
    "Salmon Meuniere": ItemData("Consumables", 0x225, ItemClassification.filler, 0),
    "Boiled Starfish": ItemData("Consumables", 0x226, ItemClassification.filler, 0),
    "Amanita": ItemData("Consumables", 0x227, ItemClassification.trap, 0),
    "Rotten Meat": ItemData("Consumables", 0x228, ItemClassification.trap, 0),
    "Spoiled Milk": ItemData("Consumables", 0x229, ItemClassification.trap, 0),
    "Rusty Food Tin": ItemData("Consumables", 0x22A, ItemClassification.trap, 0),
    "Tower Key": ItemData("Key Items", 0x239, ItemClassification.progression),
    "Magic Seal 1": ItemData("Magic Seals", 0x23D, ItemClassification.progression),
    "Magic Seal 2": ItemData("Magic Seals", 0x23E, ItemClassification.progression),
    "Magic Seal 3": ItemData("Magic Seals", 0x23F, ItemClassification.progression),
    "Magic Seal 4": ItemData("Magic Seals", 0x240, ItemClassification.progression),
    "Magic Seal 5": ItemData("Magic Seals", 0x241, ItemClassification.progression),

    "Knife": ItemData("Weapons", 0x301, ItemClassification.filler, 0),
    "Combat Knife": ItemData("Weapons", 0x302, ItemClassification.filler, 0),
    "Baselard": ItemData("Weapons", 0x303, ItemClassification.filler, 0),
    "Cutall": ItemData("Weapons", 0x304, ItemClassification.filler, 0),
    "Cinquedia": ItemData("Weapons", 0x305, ItemClassification.filler, 0),
    "Rapier": ItemData("Weapons", 0x306, ItemClassification.filler, 0),
    "Fleuret": ItemData("Weapons", 0x307, ItemClassification.useful, 0),
    "Main Gauche": ItemData("Weapons", 0x308, ItemClassification.filler, 0),
    "Small Sword": ItemData("Weapons", 0x309, ItemClassification.filler, 0),
    "Estoc": ItemData("Weapons", 0x30A, ItemClassification.filler, 0),
    "Whip Sword": ItemData("Weapons", 0x30B, ItemClassification.filler, 0),
    "Garian Sword": ItemData("Weapons", 0x30C, ItemClassification.filler, 0),
    "Kris Naga": ItemData("Weapons", 0x30D, ItemClassification.filler, 0),
    "Nebula": ItemData("Weapons", 0x30E, ItemClassification.useful, 0),
    "Short Sword": ItemData("Weapons", 0x30F, ItemClassification.filler, 0),
    "Cutlass": ItemData("Weapons", 0x310, ItemClassification.filler, 0),
    "Long Sword": ItemData("Weapons", 0x311, ItemClassification.filler, 0),
    "Fragarach": ItemData("Weapons", 0x312, ItemClassification.filler, 0),
    "Hrunting": ItemData("Weapons", 0x313, ItemClassification.useful, 0),
    "Mystletain": ItemData("Weapons", 0x314, ItemClassification.useful, 0),
    "Joyeuse": ItemData("Weapons", 0x315, ItemClassification.filler, 0),
    "Milican's Sword": ItemData("Weapons", 0x316, ItemClassification.useful, 0),
    "Ice Brand": ItemData("Weapons", 0x317, ItemClassification.useful, 0),
    "Laevatain": ItemData("Weapons", 0x318, ItemClassification.useful, 0),
    "Burtgang": ItemData("Weapons", 0x319, ItemClassification.useful, 0),
    "Kaladbolg": ItemData("Weapons", 0x31A, ItemClassification.useful, 0),
    "Valmanway": ItemData("Weapons", 0x31B, ItemClassification.useful, 0),
    "Alcuard Sword": ItemData("Weapons", 0x31C, ItemClassification.filler, 0),
    "Claymore": ItemData("Weapons", 0x31D, ItemClassification.filler, 0),
    "Falchion": ItemData("Weapons", 0x31E, ItemClassification.filler, 0),
    "Great Sword": ItemData("Weapons", 0x31F, ItemClassification.filler, 0),
    "Durandal": ItemData("Weapons", 0x320, ItemClassification.useful, 0),
    "Dainslef": ItemData("Weapons", 0x321, ItemClassification.useful, 0),
    "Ascalon": ItemData("Weapons", 0x322, ItemClassification.useful, 0),
    "Balmung": ItemData("Weapons", 0x323, ItemClassification.useful, 0),
    "Final Sword": ItemData("Weapons", 0x324, ItemClassification.useful, 0),
    "Claimh Solais": ItemData("Weapons", 0x325, ItemClassification.useful, 0),
    "Spear": ItemData("Weapons", 0x326, ItemClassification.filler, 0),
    "Partizan": ItemData("Weapons", 0x327, ItemClassification.filler, 0),
    "Halberd": ItemData("Weapons", 0x328, ItemClassification.filler, 0),
    "Lance": ItemData("Weapons", 0x329, ItemClassification.filler, 0),
    "Trident": ItemData("Weapons", 0x32A, ItemClassification.filler, 0),
    "Brionac": ItemData("Weapons", 0x32B, ItemClassification.useful, 0),
    "Geiborg": ItemData("Weapons", 0x32C, ItemClassification.useful, 0),
    "Longinus": ItemData("Weapons", 0x32D, ItemClassification.useful, 0),
    "Gungner": ItemData("Weapons", 0x32E, ItemClassification.useful, 0),
    "Mace": ItemData("Weapons", 0x32F, ItemClassification.filler, 0),
    "Morgenstern": ItemData("Weapons", 0x330, ItemClassification.filler, 0),
    "Mjollnjr": ItemData("Weapons", 0x331, ItemClassification.useful, 0),
    "Axe": ItemData("Weapons", 0x332, ItemClassification.filler, 0),
    "Battle Axe": ItemData("Weapons", 0x333, ItemClassification.filler, 0),
    "Bhuj": ItemData("Weapons", 0x334, ItemClassification.useful, 0),
    "Great Axe": ItemData("Weapons", 0x335, ItemClassification.useful, 0),
    "Golden Axe": ItemData("Weapons", 0x336, ItemClassification.useful, 0),
    "Death Scythe": ItemData("Weapons", 0x337, ItemClassification.useful, 0),
    "Blunt Sword": ItemData("Weapons", 0x338, ItemClassification.filler, 0),
    "Katana": ItemData("Weapons", 0x339, ItemClassification.filler, 0),
    "Kotetsu": ItemData("Weapons", 0x33A, ItemClassification.filler, 0),
    "Masamune": ItemData("Weapons", 0x33B, ItemClassification.filler, 0),
    "Osafune": ItemData("Weapons", 0x33C, ItemClassification.useful, 0),
    "Kunitsuna": ItemData("Weapons", 0x33D, ItemClassification.useful, 0),
    "Yasutsuna": ItemData("Weapons", 0x33E, ItemClassification.useful, 0),
    "Muramasa": ItemData("Weapons", 0x33F, ItemClassification.useful, 0),
    "Brass Knuckles": ItemData("Weapons", 0x340, ItemClassification.filler, 0),
    "Cestus": ItemData("Weapons", 0x341, ItemClassification.filler, 0),
    "Whip Knuckle": ItemData("Weapons", 0x342, ItemClassification.filler, 0),
    "Mach Punch": ItemData("Weapons", 0x343, ItemClassification.useful, 0),
    "Kaiser Knuckle": ItemData("Weapons", 0x344, ItemClassification.useful, 0),
    "Handgun": ItemData("Weapons", 0x345, ItemClassification.filler, 0),
    "Silver Gun": ItemData("Weapons", 0x346, ItemClassification.useful, 0),
    "Boomerang": ItemData("Weapons", 0x347, ItemClassification.filler, 0),
    "Chakram": ItemData("Weapons", 0x348, ItemClassification.filler, 0),
    "Tomahawk": ItemData("Weapons", 0x349, ItemClassification.filler, 0),
    "Throwing Sickle": ItemData("Weapons", 0x34A, ItemClassification.filler, 0),
    "RPG": ItemData("Weapons", 0x34B, ItemClassification.useful, 0),
    "Terror Bear": ItemData("Weapons", 0x34C, ItemClassification.filler, 0),
    "Nunchakus": ItemData("Weapons", 0x34D, ItemClassification.useful, 0),

    "Casual Clothes": ItemData("Armor", 0x400, ItemClassification.filler, 0),
    "Cloth Tunic": ItemData("Armor", 0x401, ItemClassification.filler, 0),
    "Gym Clothes": ItemData("Armor", 0x402, ItemClassification.filler, 0),
    "Kung Fu Suit": ItemData("Armor", 0x403, ItemClassification.filler, 0),
    "Biker Jacket": ItemData("Armor", 0x404, ItemClassification.filler, 0),
    "War Fatigues": ItemData("Armor", 0x405, ItemClassification.filler, 0),
    "Ninja Suit": ItemData("Armor", 0x406, ItemClassification.filler, 0),
    "Three 7s": ItemData("Armor", 0x407, ItemClassification.useful, 0),
    "Justaucorps": ItemData("Armor", 0x408, ItemClassification.filler, 0),
    "Army Jacket": ItemData("Armor", 0x409, ItemClassification.filler, 0),
    "Pitch Black Suit": ItemData("Armor", 0x40A, ItemClassification.useful, 0),
    "Olrox's Suit": ItemData("Armor", 0x40B, ItemClassification.useful, 0),
    "Dracula's Tunic": ItemData("Armor", 0x40C, ItemClassification.useful, 0),
    "Leather Armor": ItemData("Armor", 0x40D, ItemClassification.filler, 0),
    "Breastplate": ItemData("Armor", 0x40E, ItemClassification.filler, 0),
    "Ring Mail": ItemData("Armor", 0x40F, ItemClassification.filler, 0),
    "Scale Mail": ItemData("Armor", 0x410, ItemClassification.filler, 0),
    "Chain Mail": ItemData("Armor", 0x411, ItemClassification.filler, 0),
    "Hauberk": ItemData("Armor", 0x412, ItemClassification.useful, 0),
    "Cuirass": ItemData("Armor", 0x413, ItemClassification.useful, 0),
    "Blocking Mail": ItemData("Armor", 0x414, ItemClassification.useful, 0),
    "Eversing": ItemData("Armor", 0x415, ItemClassification.useful, 0),
    "Demon's Mail": ItemData("Armor", 0x416, ItemClassification.useful, 0),
    "Silk Robe": ItemData("Armor", 0x417, ItemClassification.filler, 0),
    "Mage Robe": ItemData("Armor", 0x418, ItemClassification.filler, 0),
    "Elfin Robe": ItemData("Armor", 0x419, ItemClassification.filler, 0),
    "Wyrm Robe": ItemData("Armor", 0x41A, ItemClassification.filler, 0),
    "Aquarius": ItemData("Armor", 0x41B, ItemClassification.useful, 0),
    "Serenity Robe": ItemData("Armor", 0x41C, ItemClassification.useful, 0),
    "Death's Robe": ItemData("Armor", 0x41D, ItemClassification.useful, 0),
    "Cape": ItemData("Armor", 0x41E, ItemClassification.filler, 0),
    "Traveler Cape": ItemData("Armor", 0x41F, ItemClassification.filler, 0),
    "Crimson Cloak": ItemData("Armor", 0x420, ItemClassification.filler, 0),
    "Black Cloak": ItemData("Armor", 0x421, ItemClassification.filler, 0),
    "Pendant": ItemData("Armor", 0x422, ItemClassification.filler, 0),
    "Heart Pendant": ItemData("Armor", 0x423, ItemClassification.filler, 0),
    "Skull Necklace": ItemData("Armor", 0x424, ItemClassification.filler, 0),
    "Flame Necklace": ItemData("Armor", 0x425, ItemClassification.filler, 0),
    "Rosary": ItemData("Armor", 0x426, ItemClassification.filler, 0),
    "Scarf": ItemData("Armor", 0x427, ItemClassification.filler, 0),
    "Red Scarf": ItemData("Armor", 0x428, ItemClassification.filler, 0),
    "Neck Warmer": ItemData("Armor", 0x429, ItemClassification.filler, 0),
    "Power Belt": ItemData("Armor", 0x42A, ItemClassification.filler, 0),
    "Black Belt": ItemData("Armor", 0x42B, ItemClassification.filler, 0),
    "Megingiord": ItemData("Armor", 0x42C, ItemClassification.useful, 0),
    "Hoop Earring": ItemData("Armor", 0x42D, ItemClassification.filler, 0),
    "Turquoise Stud": ItemData("Armor", 0x42E, ItemClassification.filler, 0),
    "Silver Stud": ItemData("Armor", 0x42F, ItemClassification.filler, 0),
    "Gold Stud": ItemData("Armor", 0x430, ItemClassification.filler, 0),
    "Bloody Stud": ItemData("Armor", 0x431, ItemClassification.useful, 0),
    "Platinum Stud": ItemData("Armor", 0x432, ItemClassification.useful, 0),
    "Tear Of Blood": ItemData("Armor", 0x433, ItemClassification.useful, 0),
    "Lucky Charm": ItemData("Armor", 0x434, ItemClassification.filler, 0),
    "Mina's Talisman": ItemData("Armor", 0x435, ItemClassification.progression),
    "Satan's Ring": ItemData("Armor", 0x436, ItemClassification.useful, 0),
    "Rare Ring": ItemData("Armor", 0x437, ItemClassification.useful, 0),
    "Soul Eater Ring": ItemData("Armor", 0x438, ItemClassification.useful, 0),
    "Rune Ring": ItemData("Armor", 0x439, ItemClassification.filler, 0),
    "Shaman Ring": ItemData("Armor", 0x43A, ItemClassification.filler, 0),
    "Gold Ring": ItemData("Armor", 0x43B, ItemClassification.filler, 0),
    "Chaos Ring": ItemData("Armor", 0x43C, ItemClassification.useful, 0),
    
    "Puppet Master Soul": ItemData("Bullet Souls", 0x500, ItemClassification.progression),
    "Zephyr Soul": ItemData("Bullet Souls", 0x501, ItemClassification.progression),
    "Paranoia Soul": ItemData("Bullet Souls", 0x502, ItemClassification.progression),
    "Imp Soul": ItemData("Bullet Souls", 0x503, ItemClassification.useful, 0),
    "Skeleton Soul": ItemData("Bullet Souls", 0x504, ItemClassification.filler, 0),
    "Zombie Soul": ItemData("Bullet Souls", 0x505, ItemClassification.filler, 0),
    "Axe Armor Soul": ItemData("Bullet Souls", 0x506, ItemClassification.useful, 0),
    "Student Witch Soul": ItemData("Bullet Souls", 0x507, ItemClassification.filler, 0),
    "Warg Soul": ItemData("Bullet Souls", 0x508, ItemClassification.filler, 0),
    "Bomber Armor Soul": ItemData("Bullet Souls", 0x509, ItemClassification.filler, 0),
    "Amalaric Sniper Soul": ItemData("Bullet Souls", 0x50A, ItemClassification.useful, 0),
    "Cave Troll Soul": ItemData("Bullet Souls", 0x50B, ItemClassification.filler, 0),
    "Waiter Skeleton Soul": ItemData("Bullet Souls", 0x50C, ItemClassification.useful, 0),
    "Slime Soul": ItemData("Bullet Souls", 0x50D, ItemClassification.filler, 0),
    "Yorick Soul": ItemData("Bullet Souls", 0x50E, ItemClassification.filler, 0),
    "Une Soul": ItemData("Bullet Souls", 0x50F, ItemClassification.filler, 0),
    "Mandragora Soul": ItemData("Bullet Souls", 0x510, ItemClassification.useful, 0),
    "Rycuda Soul": ItemData("Bullet Souls", 0x511, ItemClassification.filler, 0),
    "Fleaman Soul": ItemData("Bullet Souls", 0x512, ItemClassification.filler, 0),
    "Ripper Soul": ItemData("Bullet Souls", 0x513, ItemClassification.filler, 0),
    "Guillotiner Soul": ItemData("Bullet Souls", 0x514, ItemClassification.useful, 0),
    "Killer Clown Soul": ItemData("Bullet Souls", 0x515, ItemClassification.useful, 0),
    "Malachi Soul": ItemData("Bullet Souls", 0x516, ItemClassification.useful, 0),
    "Disc Armor Soul": ItemData("Bullet Souls", 0x517, ItemClassification.useful, 0),
    "Great Axe Armor Soul": ItemData("Bullet Souls", 0x518, ItemClassification.useful, 0),
    "Slaughterer Soul": ItemData("Bullet Souls", 0x519, ItemClassification.filler, 0),
    "Hell Boar Soul": ItemData("Bullet Souls", 0x51A, ItemClassification.filler, 0),
    "Frozen Shade Soul": ItemData("Bullet Souls", 0x51B, ItemClassification.filler, 0),
    "Merman Soul": ItemData("Bullet Souls", 0x51C, ItemClassification.filler, 0),
    "Larva Soul": ItemData("Bullet Souls", 0x51D, ItemClassification.filler, 0),
    "Ukoback Soul": ItemData("Bullet Souls", 0x51E, ItemClassification.filler, 0),
    "Decarabia Soul": ItemData("Bullet Souls", 0x51F, ItemClassification.filler, 0),
    "Succubus Soul": ItemData("Bullet Souls", 0x520, ItemClassification.useful, 0),
    "Slogra Soul": ItemData("Bullet Souls", 0x521, ItemClassification.filler, 0),
    "Erinys Soul": ItemData("Bullet Souls", 0x522, ItemClassification.useful, 0),
    "Homunculus Soul": ItemData("Bullet Souls", 0x523, ItemClassification.filler, 0),
    "Witch Soul": ItemData("Bullet Souls", 0x524, ItemClassification.filler, 0),
    "Fish Head Soul": ItemData("Bullet Souls", 0x525, ItemClassification.filler, 0),
    "Mollusca Soul": ItemData("Bullet Souls", 0x526, ItemClassification.filler, 0),
    "Dead Mate Soul": ItemData("Bullet Souls", 0x527, ItemClassification.filler, 0),
    "Killer Fish Soul": ItemData("Bullet Souls", 0x528, ItemClassification.filler, 0),
    "Malacoda Soul": ItemData("Bullet Souls", 0x529, ItemClassification.useful, 0),
    "Flame Demon Soul": ItemData("Bullet Souls", 0x52A, ItemClassification.useful, 0),
    "Aguni Soul": ItemData("Bullet Souls", 0x52B, ItemClassification.useful),
    "Abaddon Soul": ItemData("Bullet Souls", 0x52C, ItemClassification.useful),

    "Flying Armor Soul": ItemData("Guardian Souls", 0x535, ItemClassification.progression),
    "Bat Company Soul": ItemData("Guardian Souls", 0x536, ItemClassification.progression),
    "Black Panther Soul": ItemData("Guardian Souls", 0x537, ItemClassification.progression, 0),
    "Armor Knight Soul": ItemData("Guardian Souls", 0x538, ItemClassification.filler, 0),
    "Spin Devil Soul": ItemData("Guardian Souls", 0x539, ItemClassification.filler, 0),
    "Skull Archer Soul": ItemData("Guardian Souls", 0x53A, ItemClassification.useful, 0),
    "Ghost Soul": ItemData("Guardian Souls", 0x53B, ItemClassification.filler, 0),
    "Yeti Soul": ItemData("Guardian Souls", 0x53C, ItemClassification.filler, 0),
    "Buer Soul": ItemData("Guardian Souls", 0x53D, ItemClassification.filler, 0),
    "Manticore Soul": ItemData("Guardian Souls", 0x53E, ItemClassification.filler, 0),
    "Mushussu Soul": ItemData("Guardian Souls", 0x53F, ItemClassification.filler, 0),
    "White Dragon Soul": ItemData("Guardian Souls", 0x540, ItemClassification.filler, 0),
    "Catoblepas Soul": ItemData("Guardian Souls", 0x541, ItemClassification.filler, 0),
    "Gorgon Soul": ItemData("Guardian Souls", 0x542, ItemClassification.filler, 0),
    "Persephone Soul": ItemData("Guardian Souls", 0x543, ItemClassification.filler, 0),
    "Flying Humanoid Soul": ItemData("Guardian Souls", 0x544, ItemClassification.filler, 0),
    "Devil Soul": ItemData("Guardian Souls", 0x545, ItemClassification.useful, 0),
    "Medusa Head Soul": ItemData("Guardian Souls", 0x546, ItemClassification.useful, 0),
    "Final Guard Soul": ItemData("Guardian Souls", 0x547, ItemClassification.useful, 0),
    "Werewolf Soul": ItemData("Guardian Souls", 0x548, ItemClassification.filler, 0),
    "Alura Une Soul": ItemData("Guardian Souls", 0x549, ItemClassification.useful, 0),
    "Iron Golem Soul": ItemData("Guardian Souls", 0x54A, ItemClassification.filler, 0),
    "Bone Ark Soul": ItemData("Guardian Souls", 0x54B, ItemClassification.useful, 0),
    "Barbariccia Soul": ItemData("Guardian Souls", 0x54C, ItemClassification.filler, 0),
    "Valkyrie Soul": ItemData("Guardian Souls", 0x54D, ItemClassification.filler, 0),
    "Bat Soul": ItemData("Guardian Souls", 0x54E, ItemClassification.filler, 0),
    "Great Armor Soul": ItemData("Guardian Souls", 0x54F, ItemClassification.filler, 0),
    "Mini Devil Soul": ItemData("Guardian Souls", 0x550, ItemClassification.filler, 0),
    "Harpy Soul": ItemData("Guardian Souls", 0x551, ItemClassification.filler, 0),
    "Corpseweed Soul": ItemData("Guardian Souls", 0x552, ItemClassification.filler, 0),
    "Quetzalcoatl Soul": ItemData("Guardian Souls", 0x553, ItemClassification.filler, 0),
    "Needles Soul": ItemData("Guardian Souls", 0x554, ItemClassification.filler, 0),
    "Alastor Soul": ItemData("Guardian Souls", 0x555, ItemClassification.filler, 0),
    "Gaibon Soul": ItemData("Guardian Souls", 0x556, ItemClassification.useful, 0),
    "Gergoth Soul": ItemData("Guardian Souls", 0x557, ItemClassification.useful),
    "Death Soul": ItemData("Guardian Souls", 0x558, ItemClassification.useful),

    "Golem Soul": ItemData("Enchantment Souls", 0x559, ItemClassification.useful, 0),
    "Bone Pillar Soul": ItemData("Enchantment Souls", 0x55A, ItemClassification.useful, 0),
    "Lilith Soul": ItemData("Enchantment Souls", 0x55B, ItemClassification.useful, 0),
    "Ghost Dancer Soul": ItemData("Enchantment Souls", 0x55C, ItemClassification.useful, 0),
    "Tanjelly Soul": ItemData("Enchantment Souls", 0x55D, ItemClassification.useful, 0),
    "Bugbear Soul": ItemData("Enchantment Souls", 0x55E, ItemClassification.filler, 0),
    "Arc Demon Soul": ItemData("Enchantment Souls", 0x55F, ItemClassification.useful, 0),
    "Giant Slug Soul": ItemData("Enchantment Souls", 0x560, ItemClassification.filler, 0),
    "Killer Doll Soul": ItemData("Enchantment Souls", 0x561, ItemClassification.filler, 0),
    "Tombstone Soul": ItemData("Enchantment Souls", 0x562, ItemClassification.filler, 0),
    "Treant Soul": ItemData("Enchantment Souls", 0x563, ItemClassification.useful, 0),
    "Ghoul Soul": ItemData("Enchantment Souls", 0x564, ItemClassification.useful, 0),
    "Skelerang Soul": ItemData("Enchantment Souls", 0x565, ItemClassification.filler, 0),
    "Skeleton Ape Soul": ItemData("Enchantment Souls", 0x566, ItemClassification.filler, 0),
    "Dead Warrior Soul": ItemData("Enchantment Souls", 0x567, ItemClassification.useful, 0),
    "Dead Pirate Soul": ItemData("Enchantment Souls", 0x568, ItemClassification.filler, 0),
    "Draghignazzo Soul": ItemData("Enchantment Souls", 0x569, ItemClassification.useful, 0),
    "Heart Eater Soul": ItemData("Enchantment Souls", 0x56A, ItemClassification.filler, 0),
    "Peeping Eye Soul": ItemData("Enchantment Souls", 0x56B, ItemClassification.filler, 0),
    "Skeleton Farmer Soul": ItemData("Enchantment Souls", 0x56C, ItemClassification.filler, 0),
    "The Creature Soul": ItemData("Enchantment Souls", 0x56D, ItemClassification.filler, 0),
    "Mimic Soul": ItemData("Enchantment Souls", 0x56E, ItemClassification.filler, 0),
    "Mothman Soul": ItemData("Enchantment Souls", 0x56F, ItemClassification.useful, 0),
    "Ouija Table Soul": ItemData("Enchantment Souls", 0x570, ItemClassification.filler, 0),
    "Dead Crusader Soul": ItemData("Enchantment Souls", 0x571, ItemClassification.useful, 0),
    "Stolas Soul": ItemData("Enchantment Souls", 0x572, ItemClassification.useful, 0),
    "Wakwak Tree Soul": ItemData("Enchantment Souls", 0x573, ItemClassification.useful, 0),

    "Balore Soul": ItemData("Ability Souls", 0x574, ItemClassification.progression),
    "Malphas Soul": ItemData("Ability Souls", 0x575, ItemClassification.progression),
    "Doppelganger Soul": ItemData("Ability Souls", 0x576, ItemClassification.useful),
    "Rahab Soul": ItemData("Ability Souls", 0x577, ItemClassification.progression),
    "Hippogryph Soul": ItemData("Ability Souls", 0x578, ItemClassification.progression),
    "Procel Soul": ItemData("Ability Souls", 0x579, ItemClassification.useful, 0),
    "Mud Demon Soul": ItemData("Ability Souls", 0x57A, ItemClassification.useful, 0),

    "Moat Drained": ItemData("Events", None, ItemClassification.progression, 0),
    "Aguni Defeated": ItemData("Events", None, ItemClassification.progression, 0),
    "Power of Darkness": ItemData("Events", None, ItemClassification.progression, 0),
    "Menace Defeated": ItemData("Events", None, ItemClassification.progression, 0),
}


def get_item_names_per_category() -> Dict[str, Set[str]]:
    categories: Dict[str, Set[str]] = {}

    for name, data in item_table.items():
        if data.category != "Events":
            categories.setdefault(data.category, set()).add(name)

    return categories


soul_filler_table = [
    "Imp Soul",
    "Skeleton Soul",
    "Zombie Soul",
    "Axe Armor Soul",
    "Student Witch Soul",
    "Warg Soul",
    "Bomber Armor Soul",
    "Amalaric Sniper Soul",
    "Cave Troll Soul",
    "Waiter Skeleton Soul",
    "Slime Soul",
    "Yorick Soul",
    "Une Soul",
    "Mandragora Soul",
    "Rycuda Soul",
    "Fleaman Soul",
    "Ripper Soul",
    "Guillotiner Soul",
    "Killer Clown Soul",
    "Malachi Soul",
    "Disc Armor Soul",
    "Great Axe Armor Soul",
    "Slaughterer Soul",
    "Hell Boar Soul",
    "Frozen Shade Soul",
    "Merman Soul",
    "Larva Soul",
    "Ukoback Soul",
    "Decarabia Soul",
    "Succubus Soul",
    "Slogra Soul",
    "Erinys Soul",
    "Homunculus Soul",
    "Witch Soul",
    "Fish Head Soul",
    "Mollusca Soul",
    "Dead Mate Soul",
    "Killer Fish Soul",
    "Malacoda Soul",
    "Flame Demon Soul",
    "Black Panther Soul",
    "Armor Knight Soul",
    "Spin Devil Soul",
    "Skull Archer Soul",
    "Ghost Soul",
    "Yeti Soul",
    "Buer Soul",
    "Manticore Soul",
    "Mushussu Soul",
    "White Dragon Soul",
    "Catoblepas Soul",
    "Gorgon Soul",
    "Persephone Soul",
    "Flying Humanoid Soul",
    "Devil Soul",
    "Medusa Head Soul",
    "Final Guard Soul",
    "Werewolf Soul",
    "Alura Une Soul",
    "Iron Golem Soul",
    "Bone Ark Soul",
    "Barbariccia Soul",
    "Valkyrie Soul",
    "Bat Soul",
    "Great Armor Soul",
    "Mini Devil Soul",
    "Harpy Soul",
    "Corpseweed Soul",
    "Quetzalcoatl Soul",
    "Needles Soul",
    "Alastor Soul",
    "Gaibon Soul",
    "Golem Soul",
    "Bone Pillar Soul",
    "Lilith Soul",
    "Ghost Dancer Soul",
    "Tanjelly Soul",
    "Bugbear Soul",
    "Arc Demon Soul",
    "Giant Slug Soul",
    "Killer Doll Soul",
    "Tombstone Soul",
    "Treant Soul",
    "Ghoul Soul",
    "Skelerang Soul",
    "Skeleton Ape Soul",
    "Dead Warrior Soul",
    "Dead Pirate Soul",
    "Draghignazzo Soul",
    "Heart Eater Soul",
    "Peeping Eye Soul",
    "Skeleton Farmer Soul",
    "The Creature Soul",
    "Mimic Soul",
    "Mothman Soul",
    "Ouija Table Soul",
    "Dead Crusader Soul",
    "Stolas Soul",
    "Wakwak Tree Soul",
    "Procel Soul",
    "Mud Demon Soul"
]

consumable_table = [
    "Potion",
    "High Potion",
    "Super Potion",
    "Mind Up",
    "High Mind Up",
    "Mana Prism",
    "Anti-Venom",
    "Uncurse Potion",
    "Meat Strip",
    "Tasty Meat",
    "Rice Ball",
    "Mushroom",
    "Corn Soup",
    "Beef Curry",
    "Noodles",
    "Cream Soda",
    "Cream Puff",
    "Milk",
    "Coffee",
    "Tea",
    "Pudding",
    "Strawberry",
    "Melon",
    "Grapes",
    "Hamburger",
    "Fried Chicken",
    "Hot Dog",
    "Pumpkin Pie",
    "Pancake",
    "Piroshki",
    "Tinned Spinach",
    "Foie Gras",
    "Caviar",
    "Truffle",
    "Paella",
    "Spaghetti",
    "Ice Cream",
    "Salmon Meuniere",
    "Boiled Starfish",
    "Amanita",
    "Rotten Meat",
    "Spoiled Milk",
    "Rusty Food Tin"
]

money_table = [
    "$1",
    "$10",
    "$50",
    "$100",
    "$500",
    "$1000",
    "$2000"
]
