from BaseClasses import Item, ItemClassification
from .Locations import shop_locations_table, loc_Post_Cloud, loc_Moon_Post_Moon, loc_Captures


class SMOItem(Item):
    game: str = "Super Mario Odyssey"

    def __init__(self, name: str, classification: ItemClassification, player: int, address : int = None):
        super().__init__(name, classification, address, player)


def create_event(self, event: str) -> SMOItem:
    return SMOItem(event, ItemClassification.progression, self.player)

moon_types = {
    "Cap Power Moon": 1,
    "Cascade Power Moon": 2,
    "Sand Power Moon": 3,
    "Wooded Power Moon": 4,
    "Lake Power Moon": 5,
    "Cloud Power Moon": 6,
    "Lost Power Moon": 7,
    "Metro Power Moon": 8,
    "Seaside Power Moon": 9,
    "Snow Power Moon": 10,
    "Luncheon Power Moon": 11,
    "Ruined Power Moon": 12,
    "Bowser Power Moon": 13,
    "Moon Power Moon": 14,
    "Power Star": 15,
    "Dark Side Power Moon": 16,
    "Darker Side Multi-Moon": 17,
    "Cascade Story Moon": 18,
    "Sand Story Moon": 19,
    "Wooded Story Moon": 20,
    "Metro Story Moon": 21,
    "Seaside Story Moon": 22,
    "Snow Story Moon": 23,
    "Luncheon Story Moon": 24,
    "Bowser Story Moon": 25,
    "Cascade Multi-Moon": 26,
    "Sand Multi-Moon": 27,
    "Wooded Multi-Moon": 28,
    "Lake Multi-Moon": 29,
    "Metro Multi-Moon": 30,
    "Seaside Multi-Moon": 31,
    "Snow Multi-Moon": 32,
    "Luncheon Multi-Moon": 33,
    "Ruined Multi-Moon": 34,
    "Bowser Multi-Moon": 35,
    "Mushroom Multi-Moon": 36,
    "Dark Side Multi-Moon": 38,
}

moon_item_table = {
    **loc_Post_Cloud,
    **loc_Moon_Post_Moon,
    **shop_locations_table
}

multi_moons = {
    "Cascade" : ["Cascade Kingdom - Multi Moon Atop the Falls"],
    "Sand" : ["Sand Kingdom - Showdown on the Inverted Pyramid",
    "Sand Kingdom - The Hole in the Desert"],
    "Lake" : ["Lake Kingdom - Broodals Over the Lake"],
    "Wooded" : ["Wooded Kingdom - Flower Thieves of Sky Garden",
    "Wooded Kingdom - Defend the Secret Flower Field!"],
    "Metro" : ["Metro Kingdom - New Donk City's Pest Problem",
    "Metro Kingdom - A Traditional Festival!"],
    "Snow" : ["Snow Kingdom - The Bound Bowl Grand Prix"],
    "Seaside" : ["Seaside Kingdom - The Glass Is Half Full!"],
    "Luncheon" : ["Luncheon Kingdom - Big Pot on the Volcano: Dive In!",
    "Luncheon Kingdom - Cookatiel Showdown!"],
    "Ruined" : ["Ruined Kingdom - Battle with the Lord of Lightning!"],
    "Bowser" : ["Bowser Kingdom - Showdown at Bowser's Castle"],
    "Mushroom" : ["Mushroom Kingdom - Tussle in Tostarena: Rematch",
    "Mushroom Kingdom - Struggle in Steam Gardens: Rematch",
    "Mushroom Kingdom - Dust-Up in New Donk City: Rematch",
    "Mushroom Kingdom - Battle in Bubblaine: Rematch",
    "Mushroom Kingdom - Blowup at Mount Volbono: Rematch",
    "Mushroom Kingdom - Rumble in Crumbleden: Rematch"],
    "Dark" : ["Dark Side - Arrival at Rabbit Ridge!"],
    "Darker" : ["Darker Side - A Long Journey's End!"]
}

story_moons = {
    "Cascade" : ["Cascade Kingdom - Our First Power Moon"],
    "Sand" : ["Sand Kingdom - Atop the Highest Tower",
    "Sand Kingdom - Moon Shards in the Sand"],
    "Wooded" : ["Wooded Kingdom - Road to Sky Garden",
    "Wooded Kingdom - Path to the Secret Flower Field"],
    "Metro" : ["Metro Kingdom - Drummer on Board!",
    "Metro Kingdom - Guitarist on Board!",
    "Metro Kingdom - Bassist on Board!",
    "Metro Kingdom - Trumpeter on Board!",
    "Metro Kingdom - Powering Up the Station"],
    "Snow" : ["Snow Kingdom - The Icicle Barrier",
    "Snow Kingdom - The Ice Wall Barrier",
    "Snow Kingdom - The Gusty Barrier",
    "Snow Kingdom - The Snowy Mountain Barrier"],
    "Seaside" : ["Seaside Kingdom - The Stone Pillar Seal",
    "Seaside Kingdom - The Lighthouse Seal",
    "Seaside Kingdom - The Hot Spring Seal",
    "Seaside Kingdom - The Seal Above the Canyon"],
    "Luncheon" : ["Luncheon Kingdom - The Broodals Are After Some Cookin'",
    "Luncheon Kingdom - Under the Cheese Rocks",
    "Luncheon Kingdom - Climb Up the Cascading Magma"],
    "Bowser" : ["Bowser Kingdom - Infiltrate Bowser's Castle!",
    "Bowser Kingdom - Smart Bombing",
    "Bowser Kingdom - Big Broodal Battle"]
}

outfits = [
    "Sombrero",
    "Poncho",
    "Skeleton Suit",
    "Boxer Shorts",
    "Swim Goggles",
    "Swimwear",
    "Explorer Hat",
    "Explorer Outfit",
    "Builder Helmet",
    "Builder Outfit",
    "Snow Hood",
    "Snow Suit",
    "Resort Hat",
    "Resort Outfit",
    "Chef Hat",
    "Chef Suit",
    "Samurai Helmet",
    "Samurai Armor",
    "Caveman Headwear",
    "Caveman Outfit",
    "Cowboy Hat",
    "Cowboy Outfit",
    "Space Helmet",
    "Space Suit",
    "Pirate Hat",
    "Pirate Outfit",
    "Clown Hat",
    "Clown Suit",
    "Doctor Headwear",
    "Doctor Outfit",
    "Mechanic Cap",
    "Mechanic Outfit",
    "Mario 64 Cap",
    "Mario 64 Suit",
    "Metal Mario Cap",
    "Metal Mario Suit",
    "Captain's Hat",
    "Mario's Top Hat",
    "Mario's Tuxedo",
    "Black Top Hat",
    "Black Tuxedo",
    "Scientist Visor",
    "Scientist Outfit",
    "Aviator Cap",
    "Aviator Outfit",
    "Golf Cap",
    "Golf Outfit",
    "Sailor Hat",
    "Sailor Suit",
    "Painter's Cap",
    "Painter Outfit",
    "Happi Headband",
    "Happi Outfit",
    "Employee Cap",
    "Employee Uniform",
    "Fashionable Cap",
    "Fashionable Outfit",
    "Black Fedora",
    "Black Suit",
    "Football Helmet",
    "Football Uniform",
    "Classic Cap",
    "Classic Suit",
    "Luigi Cap",
    "Luigi Suit",
    "Waluigi Cap",
    "Waluigi Suit",
    "Diddy Kong Hat",
    "Diddy Kong Suit",
    "Wario Cap",
    "Wario Suit",
    "Hakama",
    "Bowser's Top Hat",
    "Bowser's Tuxedo",
    "Bridal Veil",
    "Bridal Gown",
    "Gold Mario Cap",
    "Gold Mario Suit",
    "King's Crown",
    "King's Outfit",
    "Invisibility Hat"
]

stickers = [
    "Cap Kingdom Sticker",
    "Cascade Kingdom Sticker",
    "Sand Kingdom Sticker",
    "Lake Kingdom Sticker",
    "Wooded Kingdom Sticker",
    "Lost Kingdom Sticker",
    "Metro Kingdom Sticker",
    "Snow Kingdom Sticker",
    "Seaside Kingdom Sticker",
    "Luncheon Kingdom Sticker",
    "Bowser's Kingdom Sticker",
    "Moon Kingdom Sticker",
    "Pipe Sticker",
    "Coin Sticker",
    "Block Sticker",
    "? Block Sticker",
    "Mushroom Kingdom Sticker"
]

souvenirs = [
    "Plush Frog",
    "Bonneton Tower Model",
    "T-Rex Model",
    "Triceratops Trophy",
    "Inverted Pyramid Model",
    "Jaxi Statue",
    "Underwater Dome",
    "Rubber Dorrie",
    "Flowers from Steam Gardens",
    "Steam Gardener Watering Can",
    "Potted Palm Tree",
    "Butterfly Mobile",
    "Pauline Statue",
    "New Donk City Hall Model",
    "Shiverian Rug",
    "Shiverian Nesting Dolls",
    "Sand Jar",
    "Glass Tower Model",
    "Souvenir Forks",
    "Vegetable Plate",
    "Paper Lantern",
    "Jizo Statue",
    "Moon Rock Fragment",
    "Moon Lamp",
    "Mushroom Cushion Set",
    "Peach's Castle Model"
]

# Technically filler until achievements implemented
shop_items = [
    *stickers,
    *souvenirs
]

capture_items = [
    "Frog",
    "Spark Pylon",
    "Paragoomba",
    "Chain Chomp",
    "Big Chain Chomp",
    "Broode's Chain Chomp",
    "T-Rex",
    "Binoculars",
    "Bullet Bill",
    "Moe-Eye",
    "Cactus",
    "Goomba",
    "Knucklotec's Fist",
    "Mini Rocket",
    "Glydon",
    "Lakitu",
    "Zipper",
    "Cheep Cheep",
    "Puzzle Part (Lake Kingdom)",
    "Poison Piranha Plant",
    "Uproot",
    "Fire Bro",
    "Sherm",
    "Coin Coffer",
    "Tree",
    "Boulder",
    "Picture Match Part (Goomba)",
    "Tropical Wiggler",
    "Pole",
    "Manhole",
    "Taxi",
    "RC Car",
    "Ty-foo",
    "Shiverian Racer",
    "Cheep Cheep (Snow Kingdom)",
    "Gushen",
    "Lava Bubble",
    "Volbonan",
    "Hammer Bro",
    "Meat",
    "Fire Piranha Plant",
    "Pokio",
    "Jizo",
    "Bowser statue",
    "Parabones",
    "Banzai Bill",
    "Chargin' Chuck",
    "Bowser",
    "Letter",
    "Puzzle Part (Metro Kingdom)",
    "Picture Match Part (Mario)",
    "Yoshi"
]

world_list = [
    "Cap",
    "Cascade",
    "Sand",
    "Wooded",
    "Lake",
    "Cloud",
    "Lost",
    "Metro",
    "Seaside",
    "Snow",
    "Luncheon",
    "Ruined",
    "Bowser",
    "Moon",
    "Mushroom",
    "Dark",
    "Darker"
]

filler_item_table = {
    "Coins": 9994,
}

flag_items = {
    "Beat the Game" : 39,
}

cap_location_to_hint = {
    1019 : 1,
    815 : 0,
    861 : 3,
    227 : 4,
    230 : 2,
    236 : 6,
    237 : 9,
    234 : 7,
    235 : 10,
    238 : 5,
    239 : 8,
    228 : 12,
    1073 : 15,
    1038 : 13,
    1033 : 14,
    229 : 11,
    1086 : 16,
    233 : 18,
    816 : 22,
    817 : 25,
    1158 : 30,
    1025 : 19,
    231 : 20,
    813 : 21,
    1156 : 23,
    232 : 17,
    1018 : 24,
    981 : 26,
    1034 : 27,
    950 : 28,
    951 : 29,
    1152 : 98 # Mushroom Kingdom Art
}
cascade_location_to_hint = {
    205 : 0,
    218 : 1,
    206 : 4,
    212 : 6,
    1145 : 2,
    216 : 5,
    210 : 3,
    208 : 9,
    669 : 7,
    670 : 11,
    204 : 10,
    1116 : 15,
    1115 : 12,
    225 : 13,
    226 : 16,
    221 : 14,
    222 : 17,
    207 : 38,
    906 : 8,
    1004 : 19,
    209 : 20,
    708 : 21,
    866 : 22,
    211 : 18,
    1041 : 23,
    213 : 27,
    826 : 28,
    214 : 30,
    215 : 33,
    825 : 32,
    823 : 25,
    822 : 29,
    1167 : 39,
    217 : 26,
    770 : 31,
    894 : 24,
    224 : 35,
    223 : 36,
    673 : 34,
    674 : 37,
    1094 : 98, # Lake Kingdom Art
    1132 : 99 # Dark Side Art 1
}
sand_location_to_hint = {
    497 : 0,
    496 : 1,
    495 : 2,
    560 : 3,
    517 : 4,
    518 : 17,
    516 : 7,
    523 : 61,
    505 : 15,
    504 : 38,
    520 : 10,
    507 : 8,
    522 : 54,
    513 : 13,
    534 : 12,
    511 : 9,
    506 : 14,
    510 : 6,
    519 : 18,
    508 : 5,
    526 : 28,
    552 : 19,
    538 : 20,
    530 : 48,
    1112 : 30,
    1113 : 33,
    1114 : 36,
    531 : 21,
    536 : 24,
    539 : 27,
    512 : 29,
    525 : 25,
    532 : 11,
    502 : 49,
    493 : 50,
    893 : 53,
    692 : 52,
    1059 : 55,
    501 : 60,
    509 : 51,
    498 : 16,
    565 : 26,
    564 : 31,
    1047 : 42,
    533 : 22,
    563 : 62,
    953 : 39,
    558 : 40,
    995 : 41,
    567 : 35,
    566 : 34,
    1136 : 32,
    569 : 47,
    562 : 43,
    561 : 56,
    555 : 44,
    554 : 57,
    557 : 45,
    556 : 58,
    570 : 46,
    571 : 59,
    524 : 84,
    1096 : 37,
    910 : 66,
    924 : 65,
    1045 : 23,
    887 : 67,
    535 : 63,
    544 : 64,
    547 : 70,
    546 : 75,
    799 : 68,
    550 : 69,
    521 : 74,
    542 : 71,
    540 : 73,
    553 : 76,
    545 : 72,
    515 : 77,
    783 : 78,
    965 : 79,
    712 : 81,
    1046 : 82,
    572 : 80,
    573 : 86,
    575 : 87,
    574 : 83,
    35 : 85,
    36 : 88,
    1089 : 98, # Wooded Kingdom Art
    1091 : 99 # Bowser Kingdom Art
}

wooded_location_to_hint = {
    129 : 72,
    130 : 73,
    159 : 74,
    181 : 75,
    134 : 8,
    150 : 11,
    149 : 0,
    148 : 1,
    135 : 5,
    139 : 2,
    143 : 48,
    146 : 69,
    145 : 3,
    140 : 26,
    141 : 6,
    142 : 21,
    144 : 10,
    147 : 22,
    136 : 4,
    133 : 12,
    131 : 24,
    1026 : 25,
    138 : 13,
    180 : 14,
    179 : 23,
    195 : 62,
    182 : 15,
    183 : 30,
    1137 : 43,
    1159 : 58,
    185 : 63,
    186 : 67,
    1153 : 70,
    184 : 38,
    188 : 47,
    187 : 55,
    157 : 7,
    676 : 9,
    196 : 16,
    197 : 56,
    193 : 17,
    194 : 57,
    191 : 18,
    192 : 59,
    190 : 19,
    189 : 60,
    198 : 20,
    199 : 61,
    137 : 71,
    1089 : 68,
    1011 : 54,
    905 : 28,
    153 : 27,
    155 : 29,
    168 : 31,
    892 : 51,
    160 : 35,
    177 : 34,
    169 : 32,
    161 : 33,
    174 : 36,
    166 : 37,
    156 : 52,
    163 : 49,
    1010 : 42,
    152 : 40,
    170 : 39,
    151 : 41,
    901 : 53,
    1001 : 50,
    202 : 46,
    203 : 66,
    200 : 45,
    201 : 65,
    882 : 44,
    883 : 64,
    1165 : 98 # Moon Kingdom Art
}

lake_location_to_hint = {
    424 : 0,
    411 : 1,
    412 : 2,
    410 : 3,
    404 : 5,
    401 : 7,
    405 : 12,
    415 : 4,
    1166 : 20,
    715 : 19,
    420 : 22,
    413 : 8,
    402 : 10,
    407 : 13,
    416 : 24,
    409 : 25,
    414 : 6,
    403 : 9,
    430 : 11,
    971 : 23,
    406 : 16,
    1008 : 14,
    1009 : 17,
    425 : 15,
    426 : 18,
    417 : 41,
    1094 : 21,
    1078 : 30,
    870 : 26,
    869 : 28,
    871 : 31,
    709 : 29,
    408 : 27,
    422 : 32,
    771 : 34,
    719 : 33,
    1015 : 36,
    423 : 35,
    1017 : 38,
    720 : 39,
    434 : 37,
    431 : 40,
    1088 : 98, # Metro Kingdom Art
    1128 : 99 # Dark Side Art 9
}

cloud_location_to_hint = {
    982 : 0,
    1118 : 1,
    851 : 2,
    852 : 3,
    853 : 4,
    1160 : 8,
    983 : 5,
    914 : 6,
    915 : 7,
    1124 : 99 # Dark Side Art 4
}

lost_location_to_hint = {
    376 : 1,
    380 : 0,
    374 : 2,
    377 : 4,
    384 : 11,
    387 : 8,
    375 : 3,
    385 : 6,
    379 : 9,
    373 : 18,
    942 : 10,
    388 : 13,
    390 : 20,
    378 : 12,
    386 : 16,
    382 : 5,
    1075 : 15,
    381 : 14,
    383 : 19,
    372 : 7,
    398 : 17,
    1077 : 24,
    943 : 23,
    832 : 22,
    394 : 21,
    395 : 25,
    396 : 26,
    392 : 27,
    393 : 29,
    897 : 32,
    855 : 28,
    399 : 30,
    400 : 33,
    491 : 31,
    492 : 34,
    1087 : 98, # Snow Kingdom Art
    1126 : 99 # Dark Side Art 7
}

metro_location_to_hint = {
    37 : 0,
    42 : 1,
    41 : 2,
    44 : 3,
    43 : 4,
    107 : 5,
    95 : 6,
    38 : 9,
    39 : 10,
    54 : 8,
    65 : 20,
    61 : 14,
    59 : 7,
    49 : 11,
    62 : 13,
    77 : 64,
    99 : 19,
    68 : 16,
    1054 : 22,
    839 : 27,
    70 : 23,
    71 : 15,
    69 : 28,
    46 : 12,
    809 : 26,
    50 : 17,
    101 : 25,
    1040 : 29,
    60 : 24,
    51 : 49,
    53 : 21,
    105 : 31,
    102 : 30,
    100 : 36,
    1100 : 38,
    875 : 39,
    1022 : 37,
    1023 : 44,
    122 : 41,
    121 : 48,
    114 : 32,
    113 : 42,
    118 : 35,
    119 : 47,
    103 : 40,
    104 : 45,
    115 : 33,
    116 : 43,
    1139 : 34,
    1140 : 46,
    40 : 80,
    881 : 18,
    1088 : 70,
    1150 : 68,
    97 : 55,
    874 : 66,
    96 : 65,
    904 : 62,
    1037 : 57,
    979 : 63,
    939 : 60,
    81 : 56,
    848 : 69,
    928 : 50,
    929 : 58,
    75 : 54,
    84 : 51,
    78 : 52,
    74 : 53,
    1155 : 73,
    938 : 59,
    82 : 67,
    106 : 71,
    940 : 72,
    1021 : 61,
    949 : 79,
    948 : 76,
    125 : 74,
    126 : 77,
    123 : 75,
    124 : 78,
    1095 : 98, # Seaside Kingdom Art
    1130 : 99 # Dark Side Art 2
}

seaside_location_to_hint = {
    438 : 0,
    441 : 1,
    440 : 2,
    439 : 3,
    437 : 4,
    449 : 11,
    455 : 12,
    466 : 7,
    467 : 10,
    450 : 6,
    451 : 69,
    458 : 8,
    459 : 9,
    453 : 5,
    452 : 42,
    445 : 14,
    447 : 25,
    444 : 18,
    1151 : 21,
    1024 : 30,
    1057 : 13,
    448 : 19,
    1103 : 22,
    1104 : 26,
    1106 : 32,
    1105 : 37,
    468 : 17,
    863 : 43,
    471 : 45,
    454 : 20,
    442 : 23,
    446 : 38,
    474 : 46,
    443 : 15,
    457 : 16,
    460 : 24,
    472 : 44,
    473 : 47,
    1107 : 31,
    483 : 29,
    1135 : 28,
    484 : 36,
    485 : 33,
    486 : 39,
    478 : 34,
    479 : 40,
    482 : 35,
    481 : 41,
    464 : 70,
    1095 : 27,
    1028 : 49,
    477 : 48,
    780 : 50,
    779 : 51,
    920 : 54,
    476 : 52,
    773 : 53,
    1043 : 55,
    776 : 56,
    778 : 57,
    775 : 58,
    1120 : 59,
    475 : 61,
    864 : 62,
    790 : 60,
    1163 : 63,
    1029 : 66,
    488 : 65,
    487 : 68,
    489 : 64,
    490 : 67,
    1090 : 98, # Luncheon Kingdom Art
    1127 : 99  # Dark Side Art 6
}

snow_location_to_hint = {
    17 : 50,
    22 : 51,
    18 : 52,
    25 : 53,
    1020 : 54,
    1081 : 12,
    21 : 19,
    1080 : 14,
    16 : 20,
    1002 : 0,
    23 : 13,
    24 : 18,
    678 : 1,
    686 : 4,
    2 : 2,
    3 : 3,
    4 : 5,
    20 : 21,
    694 : 6,
    873 : 15,
    868 : 16,
    877 : 10,
    879 : 22,
    12 : 8,
    13 : 41,
    14 : 7,
    15 : 42,
    33 : 11,
    1030 : 17,
    1031 : 45,
    830 : 9,
    831 : 43,
    937 : 49,
    1087 : 48,
    695 : 23,
    903 : 40,
    19 : 24,
    8 : 26,
    6 : 25,
    7 : 30,
    703 : 35,
    843 : 39,
    10 : 27,
    9 : 28,
    701 : 36,
    704 : 37,
    1003 : 32,
    699 : 38,
    973 : 31,
    878 : 44,
    900 : 29,
    998 : 34,
    997 : 47,
    31 : 33,
    32 : 46,
    1129 : 99  # Dark Side Art 5
}

luncheon_location_to_hint = {
    291 : 0,
    251 : 1,
    292 : 2,
    257 : 3,
    290 : 4,
    256 : 5,
    250 : 6,
    253 : 15,
    240 : 7,
    247 : 10,
    248 : 14,
    245 : 8,
    246 : 16,
    254 : 12,
    242 : 9,
    241 : 13,
    243 : 17,
    264 : 20,
    249 : 42,
    711 : 59,
    263 : 19,
    970 : 18,
    244 : 21,
    803 : 11,
    294 : 22,
    1042 : 23,
    991 : 24,
    990 : 30,
    259 : 38,
    952 : 37,
    255 : 36,
    261 : 40,
    265 : 39,
    992 : 41,
    289 : 43,
    833 : 45,
    302 : 25,
    303 : 31,
    299 : 26,
    298 : 32,
    296 : 27,
    297 : 33,
    300 : 28,
    301 : 34,
    307 : 29,
    306 : 35,
    260 : 67,
    908 : 51,
    1090 : 53,
    269 : 50,
    907 : 44,
    886 : 49,
    1005 : 46,
    280 : 52,
    266 : 48,
    268 : 47,
    271 : 57,
    829 : 55,
    287 : 56,
    276 : 58,
    277 : 54,
    895 : 60,
    313 : 64,
    312 : 61,
    310 : 62,
    311 : 65,
    1101 : 63,
    308 : 66,
    1123 : 99  # Dark Side Art 8
}

ruined_location_to_hint = {
    795 : 0,
    793 : 1,
    888 : 2,
    889 : 3,
    1117 : 4,
    834 : 7,
    835 : 5,
    909 : 6,
    891 : 8,
    890 : 9,
    1125 : 99  # Dark Side Art 10
}

bowser_location_to_hint = {
    325 : 0,
    334 : 1,
    314 : 2,
    332 : 3,
    321 : 4,
    333 : 17,
    335 : 9,
    327 : 6,
    340 : 29,
    326 : 28,
    1133 : 8,
    345 : 16,
    339 : 11,
    319 : 12,
    343 : 30,
    320 : 13,
    691 : 31,
    315 : 14,
    324 : 20,
    1092 : 10,
    323 : 21,
    337 : 23,
    328 : 25,
    316 : 22,
    317 : 24,
    331 : 5,
    690 : 35,
    318 : 7,
    360 : 15,
    999 : 32,
    987 : 19,
    988 : 27,
    368 : 34,
    367 : 36,
    363 : 33,
    364 : 37,
    365 : 18,
    366 : 26,
    1039 : 43,
    941 : 42,
    859 : 39,
    1161 : 41,
    322 : 61,
    338 : 38,
    1091 : 40,
    350 : 44,
    1032 : 45,
    1016 : 48,
    356 : 46,
    1014 : 47,
    349 : 52,
    355 : 49,
    963 : 51,
    351 : 53,
    1102 : 54,
    348 : 57,
    1143 : 50,
    896 : 58,
    801 : 56,
    802 : 60,
    370 : 55,
    369 : 59,
    1096 : 98 # Sand Kingdom Art
}

moon_location_to_hint = {
    579 : 0,
    586 : 1,
    577 : 6,
    583 : 7,
    585 : 9,
    582 : 2,
    584 : 11,
    576 : 15,
    595 : 21,
    596 : 22,
    597 : 23,
    594 : 25,
    598 : 24,
    593 : 20,
    693 : 10,
    672 : 17,
    671 : 14,
    580 : 8,
    1000 : 3,
    1157 : 16,
    578 : 12,
    707 : 13,
    1164 : 26,
    599 : 19,
    911 : 4,
    581 : 5,
    1165 : 18,
    1049 : 29,
    810 : 28,
    811 : 27,
    798 : 30,
    714 : 34,
    899 : 35,
    828 : 31,
    603 : 33,
    604 : 37,
    601 : 36,
    602 : 32,
    1086 : 98 # Cap Kingdom Art
}

mushroom_location_to_hint = {
    1134 : 10,
    1027 : 2,
    613 : 4,
    1108 : 8,
    1109 : 11,
    1111 : 15,
    1110 : 19,
    959 : 3,
    977 : 5,
    840 : 17,
    1121 : 12,
    607 : 14,
    856 : 6,
    857 : 13,
    858 : 18,
    606 : 33,
    984 : 34,
    605 : 0,
    913 : 9,
    933 : 16,
    967 : 7,
    968 : 35,
    985 : 21,
    986 : 36,
    807 : 32,
    956 : 24,
    934 : 31,
    1144 : 39,
    974 : 22,
    975 : 37,
    1050 : 23,
    1051 : 38,
    1148 : 25,
    1149 : 26,
    1141 : 27,
    1147 : 28,
    1142 : 29,
    1146 : 30,
    608 : 42,
    912 : 1,
    1152 : 20,
    978 : 41,
    1119 : 40,
    1131 : 99  # Dark Side Art 3
}

dark_location_to_hint = {
    1055 : 23,
    1122 : 0,
    1062 : 11,
    1063 : 17,
    1069 : 21,
    1068 : 15,
    1065 : 22,
    1064 : 16,
    1066 : 14,
    1067 : 20,
    1070 : 13,
    1071 : 19,
    1082 : 12,
    1083 : 18,
    1132 : 1,
    1130 : 2,
    1131 : 3,
    1124 : 4,
    1129 : 5,
    1127 : 6,
    1126 : 7,
    1123 : 8,
    1128 : 9,
    1125 : 10,
}

darker_location_to_hint = {
    1061 : 0,
}

location_hint_list = [
    cap_location_to_hint,
    cascade_location_to_hint,
    sand_location_to_hint,
    wooded_location_to_hint,
    lake_location_to_hint,
    cloud_location_to_hint,
    lost_location_to_hint,
    metro_location_to_hint,
    seaside_location_to_hint,
    snow_location_to_hint,
    luncheon_location_to_hint,
    ruined_location_to_hint,
    bowser_location_to_hint,
    moon_location_to_hint,
    mushroom_location_to_hint,
    dark_location_to_hint,
    darker_location_to_hint
]

item_table = {
    **moon_item_table,
    **loc_Captures,
    # **world_items_table,
    **flag_items,
    **filler_item_table
}

# moon_item_list = [
#     *list(Cap.keys()),
#     *list(Cascade.keys()),
#     *list(Sand.keys()),
#     *list(Lake.keys()),
#     *list(Wooded.keys()),
#     *list(Cloud.keys()),
#     *list(Lost.keys()),
#     *list(Metro.keys()),
#     *list(Snow.keys()),
#     *list(Seaside.keys()),
#     *list(Luncheon.keys()),
#     *list(Ruined.keys()),
#     *list(Bowser.keys()),
#     *list(Moon.keys()),
#     *list(Mushroom.keys()),
#     *list(Dark.keys()),
#     *list(Darker.keys())
# ]
