class ShopReplaceText:
    game_index : int = -1
    slot_index : int = -1
    item_index : int = -1
    item_classification : int = 0

    def __init__(self, game_index : int, slot_index : int, item_index : int, classification : int):
        self.game_index = game_index
        self.slot_index = slot_index
        self.item_index = item_index
        self.item_classification = classification

shop_items = {
    "MarioInvisibleCap" : 2502,
    "MarioCaptainCap" : 2503,
    "MarioTailCoatCap" : 2504,
    "MarioTailCoatClothes" : 2505,
    "StickerCap" : 2506,
    "SouvenirHat1" : 2507,
    "SouvenirHat2" : 2508,
    "MarioPrimitiveManCap" : 2509,
    "MarioPrimitiveManClothes" : 2510,
    "StickerWaterfall" : 2511,
    "SouvenirFall1" : 2512,
    "SouvenirFall2" : 2513,
    "MarioPonchoCap" : 2514,
    "MarioPonchoClothes" : 2515,
    "MarioGunmanCap" : 2516,
    "MarioGunmanClothes" : 2517,
    "StickerSand" : 2518,
    "SouvenirSand2" : 2519,
    "SouvenirSand1" : 2520,
    "MarioSwimwearCap" : 2521,
    "MarioSwimwearClothes" : 2522,
    "StickerLake" : 2523,
    "SouvenirLake2" : 2524,
    "SouvenirLake1" : 2525,
    "MarioExplorerCap" : 2526,
    "MarioExplorerClothes" : 2527,
    "MarioScientistCap" : 2528,
    "MarioScientistClothes" : 2529,
    "StickerForest" : 2530,
    "SouvenirForest1" : 2531,
    "SouvenirForest2" : 2532,
    "MarioPilotCap" : 2533,
    "MarioPilotClothes" : 2534,
    "StickerClash" : 2535,
    "SouvenirCrash1" : 2536,
    "SouvenirCrash2" : 2537,
    "MarioMakerCap" : 2538,
    "MarioMakerClothes" : 2539,
    "MarioGolfCap" : 2540,
    "MarioGolfClothes" : 2541,
    "StickerCity" : 2542,
    "SouvenirCity2" : 2543,
    "SouvenirCity1" : 2544,
    "MarioSnowSuitCap" : 2545,
    "MarioSnowSuitClothes" : 2546,
    "StickerSnow" : 2547,
    "SouvenirSnow1" : 2548,
    "SouvenirSnow2" : 2549,
    "MarioAlohaCap" : 2550,
    "MarioAlohaClothes" : 2551,
    "MarioSailorCap" : 2552,
    "MarioSailorClothes" : 2553,
    "StickerSea" : 2554,
    "SouvenirSea2" : 2555,
    "SouvenirSea1" : 2556,
    "MarioCookCap" : 2557,
    "MarioCookClothes" : 2558,
    "MarioPainterCap" : 2559,
    "MarioPainterClothes" : 2560,
    "StickerLava" : 2561,
    "SouvenirLava1" : 2562,
    "SouvenirLava2" : 2563,
    "MarioArmorCap" : 2564,
    "MarioArmorClothes" : 2565,
    "MarioHappiCap" : 2566,
    "MarioHappiClothes" : 2567,
    "StickerSky" : 2568,
    "SouvenirSky1" : 2569,
    "SouvenirSky2" : 2570,
    "MarioSpaceSuitCap" : 2571,
    "MarioSpaceSuitClothes" : 2572,
    "StickerMoon" : 2573,
    "SouvenirMoon1" : 2574,
    "SouvenirMoon2" : 2575,
    "Mario64Cap" : 2576,
    "Mario64Clothes" : 2577,
    "StickerPeachDokan" : 2578,
    "StickerPeachCoin" : 2579,
    "StickerPeachBlock" : 2580,
    "StickerPeachBlockQuestion" : 2581,
    "StickerPeach" : 2582,
    "SouvenirPeach1" : 2583,
    "SouvenirPeach2" : 2584,
    "MarioShopmanCap" : 2585,
    "MarioShopmanClothes" : 2586,
    "MarioUnderwearClothes" : 2587,
    "MarioNew3DSCap" : 2588,
    "MarioNew3DSClothes" : 2589,
    "MarioMechanicCap" : 2590,
    "MarioMechanicClothes" : 2591,
    "MarioSuitCap" : 2592,
    "MarioSuitClothes" : 2593,
    "MarioPirateCap" : 2594,
    "MarioPirateClothes" : 2595,
    "MarioClownCap" : 2596,
    "MarioClownClothes" : 2597,
    "MarioFootballCap" : 2598,
    "MarioFootballClothes" : 2599,
    "MarioColorClassicCap" : 2600,
    "MarioColorClassicClothes" : 2601,
    "MarioBoneClothes" : 2602,
    "MarioColorLuigiCap" : 2603,
    "MarioColorLuigiClothes" : 2604,
    "MarioDoctorCap" : 2605,
    "MarioDoctorClothes" : 2606,
    "MarioColorWaluigiCap" : 2607,
    "MarioColorWaluigiClothes" : 2608,
    "MarioDiddyKongCap" : 2609,
    "MarioDiddyKongClothes" : 2610,
    "MarioColorWarioCap" : 2611,
    "MarioColorWarioClothes" : 2612,
    "MarioHakamaClothes" : 2613,
    "MarioKoopaCap" : 2614,
    "MarioKoopaClothes" : 2615,
    "MarioPeachCap" : 2616,
    "MarioPeachClothes" : 2617,
    "MarioColorGoldCap" : 2618,
    "MarioColorGoldClothes" : 2619,
    "Mario64MetalCap" : 2620,
    "Mario64MetalClothes" : 2621,
    "MarioKingCap" : 2622,
    "MarioKingClothes" : 2623,
    "TuxedoCap" : 2624,
    "TuxedoClothes" : 2625
}

new_shop_items = {
    2501  : "MarioTailCoatCap",
    2502  : "MarioPrimitiveManCap",
    2503  : "MarioPonchoCap",
    2504  : "MarioGunmanCap",
    2505  : "MarioSwimwearCap",
    2506  : "MarioExplorerCap",
    2507  : "MarioScientistCap",
    2508  : "MarioPilotCap",
    2509  : "MarioMakerCap",
    2510  : "MarioGolfCap",
    2511  : "MarioSnowSuitCap",
    2512  : "MarioAlohaCap",
    2513  : "MarioSailorCap",
    2514  : "MarioCookCap",
    2515  : "MarioPainterCap",
    2516  : "MarioArmorCap",
    2517  : "MarioHappiCap",
    2518  : "MarioSpaceSuitCap",
    2519  : "Mario64Cap",
    2520  : "MarioShopmanCap",
    2521  : "MarioNew3DSCap",
    2522  : "MarioMechanicCap",
    2523  : "MarioSuitCap",
    2524  : "MarioPirateCap",
    2525  : "MarioClownCap",
    2526  : "MarioFootballCap",
    2527  : "MarioColorClassicCap",
    2528  : "MarioColorLuigiCap",
    2529  : "MarioColorWarioCap",
    2530  : "MarioColorWaluigiCap",
    2531  : "MarioColorGoldCap",
    2532  : "MarioDoctorCap",
    2533  : "MarioDiddyKongCap",
    2534  : "MarioKoopaCap",
    2535  : "MarioPeachCap",
    2536  : "Mario64MetalCap",
    2537  : "MarioKingCap",
    2538  : "MarioTuxedoCap",
    # Clothes
    2539  : "MarioTailCoatClothes",
    2540  : "MarioPrimitiveManClothes",
    2541  : "MarioPonchoClothes",
    2542  : "MarioGunmanClothes",
    2543  : "MarioSwimwearClothes",
    2544  : "MarioExplorerClothes",
    2545  : "MarioScientistClothes",
    2546  : "MarioPilotClothes",
    2547  : "MarioMakerClothes",
    2548  : "MarioGolfClothes",
    2549  : "MarioSnowSuitClothes",
    2550  : "MarioAlohaClothes",
    2551  : "MarioSailorClothes",
    2552  : "MarioCookClothes",
    2553  : "MarioPainterClothes",
    2554  : "MarioArmorClothes",
    2555  : "MarioHappiClothes",
    2556  : "MarioSpaceSuitClothes",
    2557  : "Mario64Clothes",
    2558  : "MarioShopmanClothes",
    2559  : "MarioNew3DSClothes",
    2560  : "MarioMechanicClothes",
    2561  : "MarioSuitClothes",
    2562  : "MarioPirateClothes",
    2563  : "MarioClownClothes",
    2564  : "MarioFootballClothes",
    2565  : "MarioColorClassicClothes",
    2566  : "MarioColorLuigiClothes",
    2567  : "MarioColorWarioClothes",
    2568  : "MarioColorWaluigiClothes",
    2569  : "MarioColorGoldClothes",
    2570  : "MarioDoctorClothes",
    2571  : "MarioDiddyKongClothes",
    2572  : "MarioKoopaClothes",
    2573  : "MarioPeachClothes",
    2574  : "Mario64MetalClothes",
    2575  : "MarioKingClothes",
    2576  : "MarioTuxedoClothes",
    # Single Piece
    2577  : "MarioCaptainCap",
    2578  : "MarioUnderwearClothes",
    2579  : "MarioHakamaClothes",
    2580  : "MarioBoneClothes",
    2581  : "MarioInvisibleCap",
    # Shop Items
    2582: "StickerCap",
    2583: "StickerWaterfall",
    2584: "StickerSand",
    2585: "StickerLake",
    2586: "StickerForest",
    2587: "StickerClash",
    2588: "StickerCity",
    2589: "StickerSnow",
    2590: "StickerSea",
    2591: "StickerLava",
    2592: "StickerSky",
    2593: "StickerMoon",
    2594: "StickerPeachDokan",
    2595: "StickerPeachCoin",
    2596: "StickerPeachBlock",
    2597: "StickerPeachBlockQuestion",
    2598: "StickerPeach",
    2599: "SouvenirHat1",
    2600: "SouvenirHat2",
    2601: "SouvenirFall1",
    2602: "SouvenirFall2",
    2603: "SouvenirSand1",
    2604: "SouvenirSand2",
    2605: "SouvenirLake1",
    2606: "SouvenirLake2",
    2607: "SouvenirForest1",
    2608: "SouvenirForest2",
    2609: "SouvenirCrash1",
    2610: "SouvenirCrash2",
    2611: "SouvenirCity1",
    2612: "SouvenirCity2",
    2613: "SouvenirSnow1",
    2614: "SouvenirSnow2",
    2615: "SouvenirSea1",
    2616: "SouvenirSea2",
    2617: "SouvenirLava1",
    2618: "SouvenirLava2",
    2619: "SouvenirSky1",
    2620: "SouvenirSky2",
    2621: "SouvenirMoon1",
    2622: "SouvenirMoon2",
    2623: "SouvenirPeach1",
    2624: "SouvenirPeach2"
}

inverse_shop_items = {
    2503  : "MarioCaptainCap",
    2504  : "MarioTailCoatCap",
    2505  : "MarioTailCoatClothes",
    2509  : "MarioPrimitiveManCap",
    2510  : "MarioPrimitiveManClothes",
    2514  : "MarioPonchoCap",
    2515  : "MarioPonchoClothes",
    2516  : "MarioGunmanCap",
    2517  : "MarioGunmanClothes",
    2521  : "MarioSwimwearCap",
    2522  : "MarioSwimwearClothes",
    2526  : "MarioExplorerCap",
    2527  : "MarioExplorerClothes",
    2528  : "MarioScientistCap",
    2529  : "MarioScientistClothes",
    2533  : "MarioPilotCap",
    2534  : "MarioPilotClothes",
    2538  : "MarioMakerCap",
    2539  : "MarioMakerClothes",
    2540  : "MarioGolfCap",
    2541  : "MarioGolfClothes",
    2545  : "MarioSnowSuitCap",
    2546  : "MarioSnowSuitClothes",
    2550  : "MarioAlohaCap",
    2551  : "MarioAlohaClothes",
    2552  : "MarioSailorCap",
    2553  : "MarioSailorClothes",
    2557  : "MarioCookCap",
    2558  : "MarioCookClothes",
    2559  : "MarioPainterCap",
    2560  : "MarioPainterClothes",
    2564  : "MarioArmorCap",
    2565  : "MarioArmorClothes",
    2566  : "MarioHappiCap",
    2567  : "MarioHappiClothes",
    2571  : "MarioSpaceSuitCap",
    2572  : "MarioSpaceSuitClothes",
    2576  : "Mario64Cap",
    2577  : "Mario64Clothes",
    2585  : "MarioShopmanCap",
    2586  : "MarioShopmanClothes",
    2587  : "MarioUnderwearClothes",
    2588  : "MarioNew3DSCap",
    2589  : "MarioNew3DSClothes",
    2590  : "MarioMechanicCap",
    2591  : "MarioMechanicClothes",
    2592  : "MarioSuitCap",
    2593  : "MarioSuitClothes",
    2594  : "MarioPirateCap",
    2595  : "MarioPirateClothes",
    2596  : "MarioClownCap",
    2597  : "MarioClownClothes",
    2598  : "MarioFootballCap",
    2599  : "MarioFootballClothes",
    2602  : "MarioBoneClothes",
    2600  : "MarioColorClassicCap",
    2601  : "MarioColorClassicClothes",
    2603  : "MarioColorLuigiCap",
    2604  : "MarioColorLuigiClothes",
    2611  : "MarioColorWarioCap",
    2612  : "MarioColorWarioClothes",
    2607  : "MarioColorWaluigiCap",
    2608  : "MarioColorWaluigiClothes",
    2618: "MarioColorGoldCap",
    2619: "MarioColorGoldClothes",
    2605  : "MarioDoctorCap",
    2606  : "MarioDoctorClothes",
    2609  : "MarioDiddyKongCap",
    2610  : "MarioDiddyKongClothes",
    2613  : "MarioHakamaClothes",
    2614  : "MarioKoopaCap",
    2615  : "MarioKoopaClothes",
    2616  : "MarioPeachCap",
    2617  : "MarioPeachClothes",
    2620  : "Mario64MetalCap",
    2621  : "Mario64MetalClothes",
    2622  : "MarioKingCap",
    2623  : "MarioKingClothes",
    2624  : "MarioTuxedoCap",
    2625  : "MarioTuxedoClothes",
    2502 : "MarioInvisibleCap",
    2506: "StickerCap",
    2511: "StickerWaterfall",
    2518: "StickerSand",
    2523: "StickerLake",
    2530: "StickerForest",
    2535: "StickerClash",
    2542: "StickerCity",
    2547: "StickerSnow",
    2554: "StickerSea",
    2561: "StickerLava",
    2568: "StickerSky",
    2573: "StickerMoon",
    2578: "StickerPeachDokan",
    2579: "StickerPeachCoin",
    2580: "StickerPeachBlock",
    2581: "StickerPeachBlockQuestion",
    2582: "StickerPeach",
    2507: "SouvenirHat1",
    2508: "SouvenirHat2",
    2512: "SouvenirFall1",
    2513: "SouvenirFall2",
    2520: "SouvenirSand1",
    2519: "SouvenirSand2",
    2525: "SouvenirLake1",
    2524: "SouvenirLake2",
    2531: "SouvenirForest1",
    2532: "SouvenirForest2",
    2536: "SouvenirCrash1",
    2537: "SouvenirCrash2",
    2544: "SouvenirCity1",
    2543: "SouvenirCity2",
    2548: "SouvenirSnow1",
    2549: "SouvenirSnow2",
    2556: "SouvenirSea1",
    2555: "SouvenirSea2",
    2562: "SouvenirLava1",
    2563: "SouvenirLava2",
    2569: "SouvenirSky1",
    2570: "SouvenirSky2",
    2574: "SouvenirMoon1",
    2575: "SouvenirMoon2",
    2583: "SouvenirPeach1",
    2584: "SouvenirPeach2",

}

dark_side_hint_arts = {
    "WaterfallWorldHomeStage": 1132,
    "CityWorldHomeStage": 1130,
    "PeachWorldHomeStage": 1131,
    "CloudWorldHomeStage": 1124,
    "SnowWorldHomeStage": 1129,
    "SeaWorldHomeStage": 1127,
    "ClashWorldHomeStage": 1126,
    "LavaWorldHomeStage": 1123,
    "LakeWorldHomeStage": 1128,
    "BossRaidWorldHomeStage": 1125
}

moon_list = {
    "Cap" : [
        1019,
        815,
        861,
        227,
        230,
        236,
        237,
        234,
        235,
        238,
        239,
        228,
        1073,
        1038,
        1033,
        229,
        1086,
        233,
        816,
        817,
        1158,
        1025,
        231,
        813,
        1156,
        232,
        1018,
        981,
        1034,
        950,
        951
    ],
    "Cascade" : [
        205,
        218,
        206,
        212,
        1145,
        216,
        210,
        208,
        669,
        670,
        204,
        1116,
        1115,
        225,
        226,
        221,
        222,
        1004,
        207,
        211,
        906,
        209,
        708,
        866,
        1041,
        213,
        826,
        214,
        215,
        825,
        823,
        822,
        1167,
        217,
        770,
        894,
        224,
        223,
        673,
        674
    ],
    "Sand" : [
        497,
        496,
        495,
        560,
        517,
        518,
        516,
        523,
        505,
        520,
        507,
        522,
        511,
        506,
        510,
        519,
        508,
        526,
        530,
        1112,
        1113,
        1114,
        525,
        532,
        893,
        509,
        498,
        565,
        564,
        1047,
        533,
        567,
        566,
        1136,
        569,
        562,
        561,
        555,
        554,
        557,
        556,
        504,
        513,
        563,
        953,
        558,
        534,
        512,
        531,
        536,
        539,
        502,
        493,
        692,
        1059,
        501,
        552,
        538,
        995,
        570,
        571,
        524,
        1096,
        910,
        924,
        1045,
        887,
        535,
        544,
        547,
        546,
        799,
        550,
        521,
        542,
        540,
        553,
        545,
        515,
        783,
        965,
        712,
        1046,
        572,
        573,
        575,
        574,
        35,
        36,

    ],
    "Wooded" : [
    129,
    159,
    130,
    181,
    134,
    150,
    149,
    148,
    135,
    139,
    143,
    146,
    145,
    140,
    141,
    142,
    144,
    147,
    136,
    133,
    131,
    1026,
    138,
    180,
    179,
    195,
    182,
    183,
    1137,
    1159,
    185,
    186,
    1153,
    184,
    188,
    187,
    157,
    676,
    196,
    197,
    193,
    194,
    191,
    192,
    190,
    189,
    198,
    199,
    1089,
    1011,
    905,
    153,
    155,
    168,
    892,
    160,
    177,
    169,
    161,
    174,
    166,
    156,
    163,
    1010,
    152,
    170,
    151,
    901,
    1001,
    202,
    203,
    200,
    201,
    882,
    137,
    883
    ],
    "Lake" : [
    424,
    411,
    412,
    410,
    404,
    401,
    405,
    415,
    1166,
    715,
    420,
    413,
    402,
    407,
    416,
    409,
    414,
    403,
    430,
    971,
    406,
    1008,
    1009,
    425,
    426,
    1094,
    1078,
    870,
    869,
    871,
    709,
    408,
    422,
    771,
    719,
    1015,
    423,
    1017,
    720,
    434,
    417,
    431
    ],
    "Cloud" : [
    982,
    1118,
    851,
    852,
    853,
    1160,
    983,
    914,
    915
    ],
    "Lost" : [
    376,
    380,
    374,
    377,
    384,
    387,
    375,
    385,
    379,
    373,
    942,
    388,
    378,
    386,
    382,
    1075,
    381,
    383,
    372,
    398,
    390,
    1077,
    943,
    832,
    394,
    395,
    396,
    392,
    393,
    897,
    855,
    399,
    400,
    491,
    492
    ],
    "Metro" : [
    42,
    41,
    44,
    43,
    107,
    37,
    95,
    38,
    39,
    54,
    65,
    61,
    59,
    49,
    62,
    77,
    99,
    68,
    1054,
    839,
    70,
    71,
    69,
    46,
    809,
    50,
    101,
    1040,
    60,
    51,
    53,
    105,
    102,
    100,
    1100,
    875,
    1022,
    1023,
    122,
    121,
    114,
    113,
    118,
    119,
    103,
    104,
    115,
    116,
    1139,
    1140,
    1088,
    881,
    40,
    1150,
    97,
    874,
    96,
    904,
    1037,
    979,
    939,
    81,
    848,
    928,
    929,
    75,
    84,
    78,
    74,
    1155,
    938,
    82,
    106,
    940,
    1021,
    949,
    948,
    125,
    126,
    123,
    124
    ],
    "Seaside" : [
    438,
    441,
    440,
    439,
    437,
    449,
    455,
    466,
    467,
    450,
    451,
    458,
    459,
    453,
    452,
    445,
    447,
    444,
    1151,
    1024,
    1057,
    448,
    1103,
    1104,
    1106,
    1105,
    468,
    863,
    471,
    454,
    442,
    446,
    474,
    443,
    457,
    460,
    472,
    473,
    1107,
    483,
    1135,
    484,
    485,
    486,
    478,
    479,
    482,
    481,
    1095,
    464,
    1028,
    477,
    780,
    779,
    920,
    476,
    773,
    1043,
    776,
    778,
    775,
    1120,
    475,
    864,
    790,
    1163,
    1029,
    488,
    487,
    489,
    490
    ],
    "Snow" : [
    17,
    22,
    18,
    25,
    1020,
    1081,
    21,
    1080,
    16,
    1002,
    23,
    24,
    678,
    686,
    2,
    3,
    4,
    20,
    694,
    873,
    868,
    877,
    879,
    12,
    13,
    14,
    15,
    33,
    1030,
    1031,
    30,
    831,
    937,
    1087,
    695,
    903,
    19,
    8,
    6,
    7,
    703,
    843,
    10,
    9,
    701,
    704,
    1003,
    699,
    973,
    878,
    900,
    998,
    997,
    31,
    32
    ],
    "Luncheon" : [
    291,
    251,
    257,
    292,
    290,
    256,
    250,
    253,
    240,
    247,
    248,
    245,
    246,
    254,
    242,
    241,
    243,
    264,
    249,
    711,
    263,
    970,
    244,
    803,
    294,
    1042,
    991,
    990,
    259,
    952,
    255,
    261,
    265,
    992,
    289,
    833,
    302,
    303,
    299,
    298,
    296,
    297,
    300,
    301,
    307,
    306,
    1090,
    269,
    908,
    260,
    907,
    886,
    1005,
    280,
    266,
    268,
    271,
    829,
    287,
    276,
    277,
    895,
    313,
    312,
    310,
    311,
    1101,
    308
    ],
    "Ruined" : [
    795,
    793,
    888,
    889,
    1117,
    834,
    835,
    909,
    891,
    890
    ],
    "Bowser" : [
    325,
    334,
    314,
    332,
    321,
    333,
    335,
    327,
    340,
    326,
    1133,
    345,
    339,
    319,
    343,
    320,
    691,
    315,
    324,
    1092,
    323,
    337,
    328,
    316,
    317,
    331,
    26,
    318,
    360,
    999,
    987,
    988,
    368,
    367,
    363,
    364,
    365,
    366,
    1039,
    941,
    859,
    1161,
    322,
    338,
    1091,
    350,
    1032,
    1016,
    356,
    1014,
    349,
    355,
    52,
    351,
    1102,
    348,
    1143,
    896,
    801,
    802,
    370,
    369
    ],
    "Moon" : [
    1148,
    1149,
    1141,
    1147,
    1142,
    1146,
    579,
    586,
    577,
    583,
    585,
    582,
    584,
    576,
    595,
    596,
    597,
    594,
    598,
    593,
    693,
    672,
    671,
    580,
    1000,
    1157,
    578,
    707,
    1164,
    599,
    911,
    581,
    1165,
    1049,
    810,
    811,
    798,
    714,
    899,
    828,
    603,
    604,
    601,
    602
    ],
    "Mushroom" : [
    912,
    1134,
    1027,
    613,
    1108,
    1109,
    1111,
    1110,
    959,
    977,
    840,
    1121,
    607,
    856,
    857,
    858,
    606,
    984,
    605,
    913,
    933,
    967,
    968,
    985,
    986,
    807,
    956,
    934,
    1144,
    974,
    975,
    1050,
    1051,
    608,
    1152,
    978,
    1119
    ],
    "Dark" : [
    1055,
    1122,
    1062,
    1063,
    1069,
    1068,
    1065,
    1064,
    1066,
    1067,
    1070,
    1071,
    1082,
    1083,
    1132,
    1130,
    1131,
    1124,
    1129,
    1127,
    1126,
    1123,
    1128,
    1125
    ],
    "Darker" : [
        1061
    ]
}

world_prefixes = [
    "Cap",
    "Waterfall",
    "Sand",
    "Forest",
    "Lake",
    "Cloud",
    "Clash",
    "City",
    "Sea",
    "Snow",
    "Lava",
    "BossRaid",
    "Sky",
    "Moon",
    "Peach",
    "Special1",
    "Special2"
]

worlds = {
    "Cap": 0,
    "Cascade": 1,
    "Sand": 2,
    "Wooded": 3,
    "Lake": 4,
    "Cloud": 5,
    "Lost": 6,
    "Metro": 7,
    "Seaside": 8,
    "Snow": 9,
    "Luncheon": 10,
    "Ruined": 11,
    "Bowser": 12,
    "Moon": 13,
    "Mushroom": 14,
    "Dark": 15,
    "Darker": 16
}

inverse_worlds = {
    0: "Cap",
    1: "Cascade",
    2: "Sand",
    3: "Wooded",
    4: "Lake",
    5: "Cloud",
    6: "Lost",
    7: "Metro",
    8: "Seaside",
    9: "Snow",
    10: "Luncheon",
    11: "Ruined",
    12: "Bowser",
    13: "Moon",
    14: "Mushroom",
    15: "Dark",
    16: "Darker"
}


inverse_moon_items = {
    1 : "Cap Power Moon",
    2 : "Cascade Power Moon",
    3 : "Sand Power Moon",
    4 : "Wooded Power Moon",
    5 : "Lake Power Moon",
    6 : "Cloud Power Moon",
    7 : "Lost Power Moon",
    8 : "Metro Power Moon",
    9 : "Seaside Power Moon",
    10 : "Snow Power Moon",
    11 : "Luncheon Power Moon",
    12 : "Ruined Power Moon",
    13 : "Bowser Power Moon",
    14 : "Moon Power Moon",
    15 : "Power Star",
    16 : "Dark Side Power Moon",
    17 : "Darker Side Multi-Moon",
    18 : "Cascade Story Moon",
    19 : "Sand Story Moon",
    20 : "Wooded Story Moon",
    21 : "Metro Story Moon",
    22 : "Seaside Story Moon",
    23 : "Snow Story Moon",
    24 : "Luncheon Story Moon",
    25 : "Bowser Story Moon",
    26 : "Cascade Multi-Moon",
    27 : "Sand Multi-Moon",
    28 : "Wooded Multi-Moon",
    29 : "Lake Multi-Moon",
    30 : "Metro Multi-Moon",
    31 : "Seaside Multi-Moon",
    32 : "Snow Multi-Moon",
    33 : "Luncheon Multi-Moon",
    34 : "Ruined Multi-Moon",
    35 : "Bowser Multi-Moon",
    36 : "Mushroom Multi-Moon",
    38 : "Dark Side Multi-Moon"
}

inverse_filler_items = {
    9994: "50 Coins",
    9995: "100 Coins",
    9996: "250 Coins",
    9997: "500 Coins",
    9998: "1000 Coins"
}

inverse_flag_items = {
    39 : "Beat the Game"
}

# Add Regional coins and groups
id_to_name = {
    **inverse_moon_items,
    **inverse_shop_items,
    **inverse_flag_items,
    **inverse_filler_items
}

multi_moon_locations = [
    218,
    495,
    560,
    424,
    130,
    181,
    37,
    95,
    437,
    1020,
    292,
    290,
    795,
    332,
    1055,
    1061
]

regional_coin_groups = {
    "CapWorldHomeStage" : {
            1 : [
             "obj2103",
             "obj2105",
             "obj2108",
             "obj2104"
            ],
            2 : [
            "obj2109",
            "obj2110",
            "obj2111",
            "obj2112",
            ],
            3 : [
            "obj2117",
            "obj2118",
            "obj2119",
            "obj2120",
            ],
            4 : [
            "obj2139",
            "obj2140",
            "obj2141",
            "obj2142",
            ],
            5 : [
            "obj2143",
            "obj2144",
            "obj2145",
            ],
            6 : [
            "obj2147",
            "obj2148",
            "obj2149",
            ],
            7 : [
            "obj2166",
            "obj2167",
            "obj2168",
            ],
            8 : [
            "obj2169",
            "obj2170",
            "obj2171",
            ],
            9 : [
            "obj2233",
            "obj2234",
            "obj2235",
            ],
            10 : [
            "obj1348",
            "obj1349",
            "obj1350",
            "obj1351",
            ],
            11 : [
            "obj1352",
            "obj1353",
            "obj1354",
            "obj1355",
            "obj1356",
            ],
            12 : [
            "obj6104",
            "obj6105",
            "obj6106",
            ],
            13 : [
            "obj239",
            "obj240",
            "obj412",
            ],
            14 : [
            "obj430",
            "obj461",
            "obj462",
            ],
            15 : [
            "obj405",
            "obj406",
            "obj407",
            ],
            16 : [
            "obj21",
            "obj22",
            "obj23",
            ]
        },
    "WaterfallWorldHomeStage" : {
        1 : [
            "obj1046",
            "obj1047",
            "obj1048",
            ],
            2 : [
            "obj1057",
            "obj1211",
            "obj1212",
            ],
            3 : [
            "obj1106",
            "obj1107",
            "obj1109",
            ],
            4 : [
            "obj1535",
            "obj1536",
            "obj1537",
            ],
            5 : [
            "obj1641",
            "obj1926",
            "obj1927",
            ],
            6 : [
            "obj1796",
            "obj1797",
            "obj1798",
            ],
            7 : [
            "obj1855",
            "obj1856",
            "obj1857",
            ],
            8 : [
            "obj1897",
            "obj1898",
            "obj1899",
            ],
            9 : [
            "obj2041",
            "obj2042",
            "obj2043",
            ],
            10 : [
            "obj2156",
            "obj2157",
            "obj2158",
            "obj2159",
            ],
            11 : [
            "obj3265",
            "obj3266",
            "obj3267",
            ],
            12 : [
            "obj3268",
            "obj3269",
            "obj3270",
            ],
            13 : [
            "obj3271",
            "obj3272",
            "obj3273",
            ],
            14 : [
            "obj1049",
            "obj1050",
            "obj1394",
            ],
            15 : [
            "obj1555",
            "obj1556",
            "obj1557",
            ]
        },
    "SandWorldHomeStage" : {
        1 : [
            "obj1438",
            "obj3024",
            "obj3025",
            ],
            2 : [
            "obj1831",
            "obj1832",
            "obj1833",
            ],
            3 : [
            "obj1967",
            "obj1969",
            "obj1970",
            ],
            4 : [
            "obj1999",
            "obj2000",
            "obj2399",
            ],
            5 : [
            "obj2018",
            "obj3737",
            "obj2019",
            ],
            6 : [
            "obj2021",
            "obj3726",
            ],
            7 : [
            "obj2022",
            "obj3727",
            ],
            8 : [
            "obj2392",
            "obj2393",
            "obj2394",
            ],
            9 : [
            "obj2396",
            "obj2397",
            "obj2398",
            ],
            10 : [
            "obj3404",
            "obj3405",
            "obj3406",
            ],
            11 : [
            "obj3479",
            "obj3480",
            "obj3481",
            ],
            12 : [
            "obj3720",
            "obj3721",
            "obj3722",
            ],
            13 : [
            "obj3723",
            "obj3724",
            "obj3725",
            ],
            14 : [
            "obj3855",
            "obj3856",
            "obj3857",
            ],
            15 : [
            "obj3879",
            "obj3880",
            ],
            16 : [
            "obj4864",
            "obj4865",
            "obj4866",
            "obj4867",
            "obj4868",
            "obj4869",
            ],
            17 : [
            "obj6862",
            "obj6863",
            "obj6864",
            ],
            18 : [
            "obj4871",
            "obj4876",
            "obj4875",
            ],
            19 : [
            "obj38",
            "obj39",
            "obj133",
            ],
            20 : [
            "obj40",
            "obj132",
            "obj41",
            ],
            21 : [
            "obj134",
            "obj140",
            ],
            22 : [
            "obj135",
            "obj141",
            ],
            23 : [
            "obj172",
            "obj203",
            "obj204",
            "obj205",
            ],
            24 : [
            "obj44",
            "obj46",
            ],
            25 : [
            "obj195",
            "obj196",
            ],
            26 : [
            "obj295",
            "obj296",
            "obj297",
            ],
            27 : [
            "obj201",
            "obj202",
            ],
            28 : [
            "obj203",
            "obj225",
            ],
            29 : [
            "obj165",
            "obj166",
            "obj168",
            ],
            30 : [
            "obj530",
            "obj531",
            "obj532",
            "obj533",
            ]
        },
    "LakeWorldHomeStage" : {
        1 : [
            "obj20",
            "obj22",
            "obj23",
            "obj21",
            ],
            2 : [
            "obj111",
            "obj113",
            "obj112",
            ],
            3 : [
            "obj312",
            "obj313",
            "obj314",
            "obj315",
            ],
            4 : [
            "obj351",
            "obj353",
            "obj354",
            ],
            5 : [
            "obj509",
            "obj511",
            "obj510",
            ],
            6 : [
            "obj529",
            "obj530",
            "obj531",
            ],
            7 : [
            "obj336",
            "obj337",
            "obj338",
            ],
            8 : [
            "obj431",
            "obj432",
            "obj433",
            "obj549",
            ],
            9 : [
            "obj448",
            "obj449",
            "obj450",
            "obj746",
            ],
            10 : [
            "obj551",
            "obj552",
            "obj554",
            ],
            11 : [
            "obj668",
            "obj670",
            "obj671",
            "obj669",
            ],
            12 : [
            "obj743",
            "obj744",
            "obj745",
            ],
            13 : [
            "obj759",
            "obj760",
            "obj761",
            ]
        },
    "ForestWorldHomeStage" : {
        1 : [
            "obj1546",
            "obj1547",
            "obj1548",
            ],
            2 : [
            "obj1727",
            "obj1729",
            "obj1730",
            ],
            3 : [
            "obj1752",
            "obj1753",
            "obj1754",
            ],
            4 : [
            "obj1757",
            "obj1758",
            "obj1759",
            ],
            5 : [
            "obj1772",
            "obj5937",
            ],
            6 : [
            "obj1783",
            "obj1784",
            "obj1785",
            "obj1786",
            ],
            7 : [
            "obj2294",
            "obj2295",
            "obj4826",
            "obj6989",
            ],
            8 : [
            "obj2305",
            "obj2306",
            "obj2307",
            ],
            9 : [
            "obj4918",
            "obj4919",
            "obj4920",
            ],
            10 : [
            "obj5000",
            "obj5001",
            "obj5002",
            "obj6990",
            ],
            11 : [
            "obj5036",
            "obj5037",
            "obj5038",
            "obj5039",
            ],
            12 : [
            "obj5119",
            "obj5120",
            "obj5121",
            "obj5122",
            ],
            13 : [
            "obj5616",
            "obj5617",
            "obj5618",
            ],
            14 : [
            "obj5954",
            "obj5955",
            ],
            15 : [
            "obj5957",
            "obj5958",
            "obj6150",
            ],
            16 : [
            "obj5964",
            "obj5965",
            "obj5966",
            ],
            17 : [
            "obj5970",
            "obj5971",
            "obj5972",
            ],
            18 : [
            "obj6024",
            "obj6025",
            ],
            19 : [
            "obj6146",
            "obj6147",
            "obj6148",
            "obj6149",
            ],
            20 : [
            "obj6402",
            "obj6985",
            ],
            21 : [
            "obj7320",
            "obj7321",
            "obj7322",
            ],
            22 : [
            "obj7704",
            "obj7705",
            "obj7706",
            ],
            23 : [
            "obj216",
            "obj217",
            "obj218",
            ],
            24 : [
            "obj245",
            "obj246",
            "obj247",
            ],
            25 : [
            "obj93",
            "obj94",
            "obj95",
            ],
            26 : [
            "obj223",
            "obj224",
            "obj225",
            ],
            27 : [
            "obj321",
            "obj322",
            "obj323",
            ]
        },
    "ClashWorldHomeStage" : {
        1 : [
            "obj553",
            "obj554",
            "obj555",
            ],
            2 : [
            "obj587",
            "obj1030",
            "obj1035",
            "obj1122",
            ],
            3 : [
            "obj588",
            "obj589",
            "obj1036",
            ],
            4 : [
            "obj727",
            "obj979",
            "obj728",
            ],
            5 : [
            "obj729",
            "obj1121",
            ],
            6 : [
            "obj851",
            "obj852",
            "obj853",
            "obj854",
            ],
            7 : [
            "obj868",
            "obj964",
            "obj870",
            ],
            8 : [
            "obj872",
            "obj874",
            "obj875",
            "obj977",
            ],
            9 : [
            "obj873",
            "obj998",
            ],
            10 : [
            "obj901",
            "obj1193",
            ],
            11 : [
            "obj902",
            "obj904",
            ],
            12 : [
            "obj903",
            "obj1738",
            ],
            13 : [
            "obj978",
            "obj1740",
            "obj1739",
            ],
            14 : [
            "obj997",
            "obj999",
            ],
            15 : [
            "obj1039",
            "obj1043",
            ],
            16 : [
            "obj1096",
            "obj1097",
            "obj1098",
            ],
            17 : [
            "obj1689",
            "obj1690",
            "obj1691",
            ]
        },
    "CityWorldHomeStage" : {
        1 : [
            "obj664",
            "obj665",
            "obj666",
            ],
            2 : [
            "obj298",
            "obj299",
            "obj301",
            "obj367",
            ],
            3 : [
            "obj4639",
            "obj4640",
            ],
            4 : [
            "obj7901",
            "obj7902",
            "obj7904",
            ],
            5 : [
            "obj8580",
            "obj8581",
            "obj8582",
            ],
            6 : [
            "obj10505",
            "obj11282",
            ],
            7 : [
            "obj4506",
            "obj4508",
            "obj4507",
            ],
            8 : [
            "obj4633",
            "obj10075",
            "obj10076",
            ],
            9 : [
            "obj4638",
            "obj13420",
            "obj13421",
            ],
            10 : [
            "obj5910",
            "obj5913",
            "obj5911",
            ],
            11 : [
            "obj7939",
            "obj11281",
            ],
            12 : [
            "obj8269",
            "obj9541",
            "obj9542",
            ],
            13 : [
            "obj10062",
            "obj10063",
            "obj10064",
            ],
            14 : [
            "obj10675",
            "obj10676",
            ],
            15 : [
            "obj10978",
            "obj10979",
            "obj10980",
            ],
            16 : [
            "obj11083",
            "obj11280",
            ],
            17 : [
            "obj12978",
            "obj12979",
            "obj12983",
            ],
            18 : [
            "obj13145",
            "obj13146",
            ],
            19 : [
            "obj15765",
            "obj15766",
            ],
            20 : [
            "obj546",
            "obj547",
            "obj874",
            "obj1041",
            "obj1260",
            ],
            21 : [
            "obj882",
            "obj883",
            "obj884",
            ],
            22 : [
            "obj966",
            "obj967",
            ]
        },
    "SeaWorldHomeStage" : {
        1 : [
            "obj254",
            "obj256",
            "obj371",
            ],
            2 : [
            "obj220",
            "obj221",
            "obj223",
            ],
            3 : [
            "obj1149",
            "obj1150",
            "obj1151",
            ],
            4 : [
            "obj1152",
            "obj1154",
            "obj1153",
            ],
            5 : [
            "obj1403",
            "obj1404",
            "obj1405",
            ],
            6 : [
            "obj1566",
            "obj1567",
            "obj1568",
            ],
            7 : [
            "obj2064",
            "obj2065",
            "obj2066",
            ],
            8 : [
            "obj2204",
            "obj2205",
            "obj2206",
            ],
            9 : [
            "obj2385",
            "obj2386",
            "obj2387",
            ],
            10 : [
            "obj2409",
            "obj2411",
            "obj2410",
            ],
            11 : [
            "obj2413",
             "obj2415",
             "obj2414",
            ],
             12 : [
            "obj2455",
            "obj2456",
            "obj2457",
            ],
            13 : [
            "obj2458",
            "obj2459",
            "obj2460",
            ],
            14 : [
            "obj2552",
            "obj2553",
            "obj2554",
            ],
            15 : [
            "obj2686",
            "obj2687",
            "obj2688",
            ],
            16 : [
            "obj3078",
            "obj3079",
            "obj3080",
            ],
            17 : [
            "obj4312",
            "obj4313",
            "obj4314",
            ],
            18 : [
            "obj206",
            "obj207",
            "obj208",
            ],
            19 : [
            "obj236",
            "obj237",
            "obj238",
            ],
            20 : [
            "obj430",
            "obj431",
            "obj432",
            ],
            21 : [
            "obj494",
            "obj495",
            "obj496",
            ],
            22 : [
            "obj280",
            "obj282",
            "obj281",
            ],
            23 : [
            "obj314",
            "obj315",
            "obj316",
            ],
            24 : [
            "obj373",
            "obj375",
            "obj374",
            ],
            25 : [
            "obj83",
            "obj85",
            "obj84",
            ],
            26 : [
            "obj89",
            "obj90",
            "obj103",
            ],
            27 : [
            "obj149",
            "obj150",
            "obj151",
            ],
            28 : [
            "obj346",
            "obj347",
            "obj348",
            ],
            29 : [
            "obj484",
            "obj485",
            "obj486",
            ],
            30 : [
            "obj487",
            "obj488",
            "obj489",
            ],
            31 : [
            "obj46",
            "obj47",
            "obj48",
            ]
        },
    "SnowWorldHomeStage" : {
        1 : [
            "obj169",
            "obj170",
            "obj251",
            ],
            2 : [
            "obj271",
            "obj272",
            "obj273",
            ],
            3 : [
            "obj222",
            "obj223",
            "obj224",
            "obj225",
            ],
            4 : [
            "obj273",
            "obj274",
            "obj275",
            ],
            5 : [
            "obj281",
            "obj282",
            "obj283",
            ],
            6 : [
            "obj1150",
            "obj1151",
            ],
            7 : [
            "obj1533",
            "obj1534",
            ],
            8 : [
            "obj380",
            "obj381",
            "obj448",
            "obj449",
            ],
            9 : [
            "obj421",
            "obj422",
            "obj423",
            ],
            10 : [
            "obj927",
            "obj928",
            "obj929",
            ],
            11 : [
            "obj1097",
            "obj1098",
            "obj1099",
            "obj1100",
            ]
        },
    "MoonWorldHomeStage" : {
        1 : [
            "obj6104",
            "obj6105",
            "obj6106",
            ],
            2 : [
            "obj239",
            "obj240",
            "obj412",
            ],
            3 : [
            "obj430",
            "obj461",
            "obj462",
            ],
            4 : [
            "obj405",
            "obj406",
            "obj407",
            ],
            5 : [
            "obj21",
            "obj22",
            "obj23",
            ],
            6 : [
            "obj71",
            "obj72",
            "obj73",
            ],
            7 : [
            "obj94",
            "obj95",
            "obj96",
            "obj97",
            ],
            8 : [
            "obj197",
            "obj198",
            "obj199",
            "obj836",
            "obj837",
            "obj838",
            ],
            9 : [
            "obj469",
            "obj470",
            "obj471",
            ],
            10 : [
            "obj516",
            "obj517",
            "obj518",
            "obj519",
            ],
            11 : [
            "obj672",
            "obj673",
            "obj700",
            ],
            12 : [
            "obj805",
            "obj806",
            "obj807",
            ],
            13 : [
            "obj811",
            "obj812",
            "obj814",
            ],
            14 : [
            "obj859",
            "obj860",
            "obj861",
            ]
        },
    "LavaWorldHomeStage" : {
        1 : [
            "obj807",
            "obj808",
            "obj809",
            ],
            2 : [
            "obj185",
            "obj208",
            "obj209",
            ],
            3 : [
            "obj187",
            "obj206",
            "obj207",
            ],
            4 : [
            "obj431",
            "obj432",
            "obj433",
            ],
            5 : [
            "obj2675",
            "obj2746",
            "obj2747",
            ],
            6 : [
            "obj2678",
            "obj2679",
            "obj2680",
            ],
            7 : [
            "obj2685",
            "obj2686",
            "obj2688",
            ],
            8 : [
            "obj2690",
            "obj2692",
            "obj2691",
            ],
            9 : [
            "obj2713",
            "obj2774",
            "obj2773",
            ],
            10 : [
            "obj2717",
            "obj2775",
            "obj4287",
            ],
            11 : [
            "obj2744",
            "obj5567",
            "obj5568",
            ],
            12 : [
            "obj2748",
            "obj2756",
            "obj2760",
            ],
            13 : [
            "obj2750",
            "obj2754",
            "obj2758",
            "obj2762",
            "obj2751",
            ],
            14 : [
            "obj2755",
            "obj2785",
            "obj2783",
            ],
            15 : [
            "obj3310",
            "obj3311",
            "obj3312",
            ],
            16 : [
            "obj3808",
            "obj3809",
            "obj3810",
            ],
            17 : [
            "obj3843",
            "obj3844",
            "obj3845",
            ],
            18 : [
            "obj5656",
            "obj5657",
            "obj5658",
            ],
            19 : [
            "obj6254",
            "obj6255",
            "obj6256",
            ],
            20 : [
            "obj6363",
            "obj6364",
            "obj6365",
            ],
            21 : [
            "obj2659",
            "obj2660",
            "obj2663",
            "obj2664",
            ],
            22 : [
            "obj2662",
            "obj3740",
            "obj3738",
            ],
            23 : [
            "obj2665",
            "obj2666",
            "obj3991",
            ],
            24 : [
            "obj3910",
            "obj3911",
            "obj3912",
            ],
            25 : [
            "obj6347",
            "obj6348",
            "obj6349",
            ],
            26 : [
            "obj6366",
            "obj6367",
            "obj6368",
            ],
            27 : [
            "obj239",
            "obj240",
            "obj412",
            ],
            28 : [
            "obj430",
            "obj461",
            "obj462",
            ],
            29 : [
            "obj206",
            "obj207",
            "obj208",
            ],
            30 : [
            "obj236",
            "obj237",
            "obj238",
            ],
            31 : [
            "obj430",
            "obj431",
            "obj432",
            ],
            32 : [
            "obj494",
            "obj495",
            "obj496",
            ]
        },
    "SkyWorldHomeStage" : {
        1 : [
            "obj653",
            "obj4377",
            "obj6733",
            ],
            2 : [
            "obj1692",
            "obj1694",
            "obj1693",
            ],
            3 : [
            "obj1800",
            "obj1918",
            "obj2450",
            ],
            4 : [
            "obj1801",
            "obj1917",
            "obj2451",
            ],
            5 : [
            "obj1955",
            "obj1958",
            "obj1956",
            ],
            6 : [
            "obj2306",
            "obj2307",
            "obj2308",
            "obj2309",
            ],
            7 : [
            "obj2501",
            "obj2512",
            "obj2514",
            ],
            8 : [
            "obj2726",
            "obj2727",
            "obj2728",
            ],
            9 : [
            "obj5680",
            "obj5681",
            "obj8169",
            ],
            10 : [
            "obj6735",
            "obj6736",
            "obj6737",
            ],
            11 : [
            "obj7322",
            "obj7324",
            "obj7323",
            ],
            12 : [
            "obj650",
            "obj2132",
            "obj2133",
            ],
            13 : [
            "obj2714",
            "obj6734",
            "obj7583",
            ],
            14 : [
            "obj3634",
            "obj3635",
            "obj3636",
            ],
            15 : [
            "obj5706",
            "obj5708",
            "obj5707",
            ],
            16 : [
            "obj5735",
            "obj5736",
            "obj5737",
            ],
            17 : [
            "obj7580",
            "obj7581",
            "obj7582",
            ],
            18 : [
            "obj1722",
            "obj1723",
            "obj1724",
            "obj1925",
            ],
            19 : [
            "obj1970",
            "obj1971",
            "obj1972",
            ],
            20 : [
            "obj2272",
            "obj2273",
            "obj2274",
            "obj2829",
            ],
            21 : [
            "obj2830",
            "obj2841",
            ],
            22 : [
            "obj2831",
            "obj2832",
            ],
            23 : [
            "obj959",
            "obj960",
            "obj1227",
            ],
            24 : [
            "obj1503",
            "obj1504",
            "obj2159",
            ],
            25 : [
            "obj1612",
            "obj1832",
            "obj1613",
            ],
            26 : [
            "obj1872",
            "obj1873",
            "obj2192",
            ],
            27 : [
            "obj1964",
            "obj1965",
            "obj1967",
            "obj2238",
            ],
            28 : [
            "obj2097",
            "obj2098",
            "obj2099",
            ]
        },
    "PeachWorldHomeStage" : {
        1 : [
            "obj92",
            "obj93",
            "obj94",
            ],
            2 : [
            "obj740",
            "obj741",
            "obj742",
            "obj847",
            ],
            3 : [
            "obj848",
            "obj849",
            "obj850",
            ],
            4 : [
            "obj851",
            "obj852",
            "obj853",
            ],
            5 : [
            "obj854",
            "obj855",
            "obj856",
            ],
            6 : [
            "obj857",
            "obj871",
            "obj872",
            "obj873",
            ],
            7 : [
            "obj858",
            "obj859",
            "obj860",
            ],
            8 : [
            "obj861",
            "obj862",
            "obj863",
            ],
            9 : [
            "obj864",
            "obj865",
            "obj866",
            ],
            10 : [
            "obj867",
            "obj877",
            "obj887",
            ],
            11 : [
            "obj874",
            "obj875",
            "obj876",
            ],
            12 : [
            "obj878",
            "obj879",
            "obj880",
            ],
            13 : [
            "obj881",
            "obj882",
            "obj883",
            ],
            14 : [
            "obj884",
            "obj885",
            "obj886",
            ],
            15 : [
            "obj888",
            "obj889",
            "obj890",
            ],
            16 : [
            "obj1286",
            "obj1287",
            "obj1288",
            ],
            17 : [
            "obj1289",
            "obj1290",
            "obj1291",
            ],
            18 : [
            "obj1811",
            "obj1813",
            "obj1812",
            ],
            19 : [
            "obj1900",
            "obj1901",
            "obj1902",
            "obj1903",
            ],
            20 : [
            "obj1920",
            "obj1921",
            "obj1922",
            ],
            21 : [
            "obj1923",
            "obj1924",
            ],
            22 : [
            "obj1927",
            "obj1928",
            ],
            23 : [
            "obj1929",
            "obj1930",
            "obj1931",
            ],
            24 : [
            "obj1932",
            "obj1933",
            "obj1934",
            ],
            25 : [
            "obj1950",
            "obj1951",
            "obj1952",
            ],
            26 : [
            "obj1953",
            "obj1954",
            "obj1955",
            ],
            27 : [
            "obj1956",
            "obj1957",
            "obj1958",
            ],
            28 : [
            "obj1977",
            "obj1978",
            "obj1979",
            ],
            29 : [
            "obj1980",
            "obj1981",
            "obj1982",
            ],
            30 : [
            "obj1994",
            "obj1995",
            "obj1996",
            ],
            31 : [
            "obj2216",
            "obj2217",
            "obj2218",
            ],
            32 : [
            "obj2644",
            "obj2645",
            "obj2646",
            ],
            33 : [
            "obj1904",
            "obj1905",
            "obj1906",
            ]
        }
    }

world_alias = {
    "cap kingdom": "cap",
    "cascade kingdom": "cascade",
    "sand kingdom": "sand",
    "wooded kingdom": "wooded",
    "lake kingdom": "lake",
    "cloud kingdom": "cloud",
    "lost kingdom": "lost",
    "metro kingdom": "metro",
    "seaside kingdom": "seaside",
    "snow kingdom": "snow",
    "luncheon kingdom": "luncheon",
    "ruined kingdom": "ruined",
    "bowser kingdom": "bowser",
    "moon kingdom": "moon",
    "mushroom kingdom": "mushroom",
    "dark side": "dark",
    "darker side": "darker",
    "cap": "hat",
    "cascade": "waterfall",
    "sand": "SandWorldHomeStage",
    "wooded": "forest",
    "lake": "LakeWorldHomeStage",
    "cloud": "CloudWorldHomeStage",
    "lost": "clash",
    "metro": "city",
    "seaside": "sea",
    "snow": "SnowWorldHomeStage",
    "luncheon": "lava",
    "ruined": "raid",
    "bowser": "sky",
    "moon": "MoonWorldHomeStage",
    "mushroom": "peach",
    "dark": "special1",
    "darker": "special2",
    "odyssey": "home",
    "hat" : "CapWorldHomeStage",
    "waterfall" : "WaterfallWorldHomeStage",
    "forest" : "ForestWorldHomeStage",
    "clash" : "ClashWorldHomeStage",
    "city" : "CityWorldHomeStage",
    "sea" : "SeaWorldHomeStage",
    "lava" : "LavaWorldHomeStage",
    "raid" : "boss",
    "boss" : "BossRaidWorldHomeStage",
    "sky" : "SkyWorldHomeStage",
    "peach" : "PeachWorldHomeStage",
    "special1" : "Special1WorldHomeStage",
    "special2" : "Special2WorldHomeStage",
    "home" : "HomeShipInsideStageMap"
}

valid_warps = {
    "CapWorldHomeStage": "Cap",
    "SandWorldHomeStage": "Sand",
    "WaterfallWorldHomeStage": "Cascade",
    "ForestWorldHomeStage": "Wooded",
    "LakeWorldHomeStage": "Lake",
    "ClashWorldHomeStage": "Lost",
    "CloudWorldHomeStage": "Cloud",
    "CityWorldHomeStage": "Metro",
    "SeaWorldHomeStage": "Seaside",
    "SnowWorldHomeStage": "Snow",
    "LavaWorldHomeStage": "Luncheon",
    "BossRaidWorldHomeStage": "Ruined",
    "SkyWorldHomeStage": "Bowser",
    "MoonWorldHomeStage": "Moon",
    "PeachWorldHomeStage": "Mushroom",
    "Special1WorldHomeStage": "Dark",
    "Special2WorldHomeStage": "Darker",
    "HomeShipInsideStageMap": "Odyssey"
}

goals = {
    4: 560,
    5: 424,
    9: 95,
    12: 290,
    14: 2499,
    17: 1055,
    18: 1061
}

def get_item_type(item : int) -> int:
    """
    Args:
        item: the id of the shop item.
    Returns:
         The in-game item type enum value corresponding to the item name.
    """

    # Moons
    if item < 2500:
        return -1
    elif 3700 < item < 9000:
        return 5
    elif 2599 > item > 2581:
        return 3
    elif 2625 > item > 2598:
        return 2
    elif item < 2539 or item == 2577 or item == 2581:
        return 1
    elif 2581 > item > 2538:
        return 0


    # Filler
    elif item > 9990:
        return -2
    # Regional Coin
    else:
        return 4
    # Add Capture


