# below from PMR palettes table in sqlite db; more info at https://github.com/icebound777/PMR-SeedGenerator/tree/main/db
# Also pulled menu color dictionary from
# https://github.com/Pronyo-Chan/paper-mario-randomizer-web-app/blob/master/app/src/app/utilities/constants.ts
from ..options import StatusMenuColorPalette


#   sprite                  id       dbkey            palette_count
palette_table = {
    "Mario":                (1,      2751463425,         8),
    "Peach":                (2,      2751463426,         4),
    "Hammer1":              (3,      2751463427,         4),
    "Hammer2":              (4,      2751463428,         5),
    "Hammer3":              (5,      2751463429,         6),
    "01_0_Goombario":       (6,      2751528960,         6),
    "02_0_Kooper":          (7,      2751594496,         5),
    "03_0_Bombette":        (8,      2751660032,         7),
    "04_0_Parakarry":       (9,      2751725568,         4),
    "05_0_Bow":             (10,     2751791104,         5),
    "06_0_Watt":            (11,     2751856640,         4),
    "07_0_Sushie":          (12,     2751922176,         5),
    "08_0_Lakilester":      (13,     2751987712,         5),
    "20_0_Twink":           (14,     2753560576,         4),
    "26_0_Goomba":          (15,     2753953792,         5),
    "28_0_Paragoomba":      (16,     2754084864,         5),
    "27_0_SpikedGoomba":    (17,     2754019328,         5),
    "29_1_Koopa":           (18,     2754150401,         5),
    "2C_0_Bobomb":          (19,     2754347008,         5),
    "2D_0_BulletBill":      (20,     2754412544,         4),
    "2D_1_BombshellBill":   (21,     2754412545,         4),
    "31_0_Pokey":           (22,     2754674688,         6),
    "31_1_PokeyMummy":      (23,     2754674689,         3),
    "32_0_Bandit":          (24,     2754740224,         5),
    "33_0_BuzzyBeetles":    (25,     2754805760,         7),
    "34_0_Swooper":         (26,     2754871296,         3),
    "35_0_StoneChomp":      (27,     2754936832,         5),
    "37_0_PiranhaPlant":    (28,     2755067904,         5),
    "39_0_Clubba":          (29,     2755198976,         6),
    "39_1_IceClubba":       (30,     2755198977,         5),
    "6E_0_ShyGuySquad":     (31,     2755330048,         7),
    "3B_1_ShyGuy":          (32,     2755330049,         7),
    "3B_2_ShyGuy":          (33,     2755330050,         7),
    "3B_3_ShyGuy":          (34,     2755330051,         7),
    "3B_4_ShyGuy":          (35,     2755330052,         7),
    "70_0_StiltGuy":        (36,     2758803456,         7),
    "72_0_ShyGuyStack":     (37,     2758934528,         7),
    "78_0_TankGuy":         (38,     2759327744,         7),
    "3B_5_AntiGuy":         (39,     2755330053,         3),
    "3E_0_PyroGuy":         (40,     2755526656,         4),
    "3F_0_SpyGuy":          (41,     2755592192,         5),
    "40_0_MediGuy":         (42,     2755657728,         5),
    "42_0_JungleGuy":       (43,     2755788800,         7),
    "47_0_KentCKoopa":      (44,     2756116480,         6),
    "48_0_CrazyDayzee":     (45,     2756182017,         10),
    "5A_0_HammerBros":      (46,     2757361664,         5),
    "60_0_Kammy":           (47,     2757754880,         4),
    "62_GoombaBros":        (48,     2757885952,         5),
    "63_GoombaKing":        (49,     2757951488,         6),
    "66_0_KoopaBros":       (50,     2758148096,         9),
    "66_1_KoopaBros":       (51,     2758148097,         9),
    "66_2_KoopaBros":       (52,     2758148098,         9),
    "66_3_KoopaBros":       (53,     2758148099,         9),
    "68_0_TutanKoopa":      (54,     2758279168,         3),
    "6A_0_TubbaBlubba":     (55,     2758410240,         3),
    "6D_0_LanternGhost":    (56,     2758606848,         7),
    "79_0_LavaPiranha":     (57,     2759393280,         2),
    "7C_0_HuffNPuff":       (58,     2759589888,         3),
    "7F_0_CrystalKing":     (59,     2759786496,         4),
    "82_0_Luigi":           (60,     2759983104,         6),
    "83_0_Toad":            (61,     2760048640,         8),
    "83_1_Toad":            (62,     2760048641,         8),
    "83_2_Toad":            (63,     2760048642,         8),
    "83_3_Toad":            (64,     2760048643,         8),
    "84_0_Toadette":        (65,     2760114176,         8),
    "84_1_Toadette":        (66,     2760114177,         8),
    "84_2_Toadette":        (67,     2760114178,         8),
    "84_3_Toadette":        (68,     2760114179,         8),
    "86_0_ToadKid":         (69,     2760245248,         8),
    "86_1_ToadKid":         (70,     2760245249,         8),
    "86_2_ToadKid":         (71,     2760245250,         8),
    "86_3_ToadKid":         (72,     2760245251,         8),
    "88_0_Harry":           (73,     2760376320,         5),
    "93_0_Dryite":          (74,     2761097216,         6),
    "93_1_Dryite":          (75,     2761097217,         6),
    "93_2_Dryite":          (76,     2761097218,         6),
    "93_3_Dryite":          (77,     2761097219,         6),
    "9A_0_Penguin":         (78,     2761555968,         4),
    "9E_0_Goombaria":       (79,     2761818112,         4),
    "A5_0_Merlon":          (80,     2762276864,         5),
    "AE_0_RipCheato":       (81,     2762866688,         4),
    "AF_0_ChuckQuizmo":     (82,     2762932224,         2),
    "B2_0_Merlow":          (83,     2763128832,         7),
    "C1_0_GourmetGuy":      (84,     2764111872,         8),
    "C2_0_VillageLeader":   (85,     2764177408,         5),
    "C5_0_Tolielip":        (86,     2764374016,         5),
    "CC_0_Lakilulu":        (87,     2764832768,         3),
    "CD_0_Ninji":           (88,     2764898304,         6)
}


# below from https://github.com/icebound777/PMR-SeedGenerator/blob/main/metadata/palettes_meta.py

mario_n_partner_sprite_names = [
    "Mario",
    "01_0_Goombario",
    "02_0_Kooper",
    "03_0_Bombette",
    "04_0_Parakarry",
    "05_0_Bow",
    "06_0_Watt",
    "07_0_Sushie",
    "08_0_Lakilester",
]

boss_sprite_names = [
    "47_0_KentCKoopa",
    "60_0_Kammy",
    "62_GoombaBros",
    "63_0_GoombaKing",
    "66_0_KoopaBros",
    "66_1_KoopaBros",
    "66_2_KoopaBros",
    "66_3_KoopaBros",
    "68_0_TutanKoopa",
    "6A_0_TubbaBlubba",
    "6D_0_LanternGhost",
    "78_0_TankGuy",
    "79_0_LavaPiranha",
    "7C_0_HuffNPuff",
    "7F_0_CrystalKing",
]

enemy_sprite_names = [
    "26_0_Goomba",
    "27_0_SpikedGoomba",
    "28_0_Paragoomba",
    "29_1_Koopa",
    "2C_0_Bobomb",
    "2D_0_BulletBill",
    "2D_1_BombshellBill",
    "31_0_Pokey",
    "31_1_PokeyMummy",
    "32_0_Bandit",
    "33_0_BuzzyBeetles",
    "34_0_Swooper",
    "35_0_StoneChomp",
    "37_0_PiranhaPlant",
    "39_0_Clubba",
    "39_1_IceClubba",
    "3B_1_ShyGuy",
    "3B_2_ShyGuy",
    "3B_3_ShyGuy",
    "3B_4_ShyGuy",
    "3B_5_AntiGuy",
    "3E_0_PyroGuy",
    "3F_0_SpyGuy",
    "40_0_MediGuy",
    "42_0_JungleGuy",
    "48_0_CrazyDayzee",
    "5A_0_HammerBros",
    "6E_0_ShyGuySquad",
    "70_0_StiltGuy",
    "72_0_ShyGuyStack",
]

hammer_sprite_names = [
    "Hammer1",
    "Hammer2",
    "Hammer3",
]

# NPCs with these sprites don't necessarily have their vanilla palette on id 0,
# instead their vanilla id is encoded as the middle part of their key name,
# which has to be extracted in the random palettes module
special_vanilla_palette_ids = [
    #   "3B_0_ShyGuy",
    "3B_1_ShyGuy",
    "3B_2_ShyGuy",
    "3B_3_ShyGuy",
    "3B_4_ShyGuy",
    #   "66_0_KoopaBros",
    "66_1_KoopaBros",
    "66_2_KoopaBros",
    "66_3_KoopaBros",
    #   "83_0_Toad",
    "83_1_Toad",
    "83_2_Toad",
    "83_3_Toad",
    #   "84_0_Toadette",
    "84_1_Toadette",
    "84_2_Toadette",
    "84_3_Toadette",
    #   "86_0_ToadKid",
    "86_1_ToadKid",
    "86_2_ToadKid",
    "86_3_ToadKid",
    #   "93_0_Dryite",
    "93_1_Dryite",
    "93_2_Dryite",
    "93_3_Dryite",
]

#               option                     mode  colorA      colorB
MENU_COLORS = {
    StatusMenuColorPalette.option_Default: (0, 0xEBE677FF, 0x8E5A25FF),
    StatusMenuColorPalette.option_Blue: (0, 0x8D8FFFFF, 0x2B4566FF),
    StatusMenuColorPalette.option_Green: (0, 0xAAD080FF, 0x477B53FF),
    StatusMenuColorPalette.option_Teal: (0, 0x8ED4ECFF, 0x436245FF),
    StatusMenuColorPalette.option_Brown: (0, 0xD7BF74FF, 0x844632FF),
    StatusMenuColorPalette.option_Purple: (0, 0xB797B7FF, 0x62379AFF),
    StatusMenuColorPalette.option_Grey: (0, 0xC0C0C0FF, 0x404040FF),
    StatusMenuColorPalette.option_Random_Pick: (1, 0xEBE677FF, 0x8E5A25FF),
    StatusMenuColorPalette.option_Animated: (2, 0xEBE677FF, 0x8E5A25FF)
}