# Data from PMR's SQLite tables

actor_table = {
    "00_Goomba":                2149684972,
    "00_Paragoomba":            2149698816,
    "00_SpikedGoomba":          2149691564,
    "01_BlueGoomba1":           2149685644,
    "01_RedGoomba1":            2149693340,
    "01_BlueGoomba2":           2149700828,
    "01_RedGoomba2":            2149707484,
    "01_GoombaKing":            2149714448,
    "02_SpikedGoomba":          2149688428,
    "02_ParagoombaA":           2149696432,
    "02_ParagoombaB":           2149710160,
    "02_JrTroopa1":             2149722888,
    "02_JrTroopa2":             2149729512,
    "02_JrTroopa3":             2149736276,
    "02_JrTroopa4":             2149744732,
    "02_JrTroopa5":             2149754664,
    "02_JrTroopa6":             2149762732,
    "03_Chan":                  2149686856,
    "03_Lee":                   2149700768,
    "03_LeeGoombario":          2149706356,
    "03_LeeKooper":             2149713600,
    "03_LeeBombette":           2149721016,
    "03_LeeParakarry":          2149725396,
    "03_LeeBow":                2149729628,
    "03_LeeWatt":               2149735112,
    "03_LeeSushie":             2149739172,
    "03_LeeLakilester":         2149746020,
    "03_TheMaster1":            2149753736,
    "03_TheMaster2":            2149758900,
    "03_TheMaster3":            2149767992,
    "04_Ember":                 2149690932,
    "04_Magikoopa":             2149701248,
    "04_FlyingMagikoopa":       2149701288,
    "04_Magiclone":             2149717612,
    "04_FlyingMagiclone":       2149717652,
    "05_Goomba":                2149685292,
    "05_Paragoomba":            2149692176,
    "05_SpikedGoomba":          2149704844,
    "05_KoopaTroopa":           2149711848,
    "05_Fuzzy":                 2149720364,
    "05_Paratroopa":            2149726984,
    "05_KentC":                 2149743608,
    "06_BulletBill":            2149683260,
    "06_BillBlaster":           2149686816,
    "06_Bobomb":                2149689136,
    "06_KoopaTroopa":           2149698152,
    "06_Paratroopa":            2149706968,
    "07_FakeBowser":            2149689556,
    "07_GNinjakoopa":           2149733960,
    "07_RNinjakoopa":           2149746152,
    "07_BNinjakoopa":           2149758344,
    "07_YNinjakoopa":           2149770536,
    "09_Cleft":                 2149681168,
    "09_MontyMole":             2149688692,
    "09_EmptyMoleHole":         2149688976,
    "09_Buzzar":                2149693372,
    "09_WhackaA":               2149711224,
    "09_WhackaB":               2149714472,
    "09_WhackaC":               2149717828,
    "0A_Pokey":                 2149680144,
    "0A_BanditA":               2149701336,
    "0A_BanditB":               2149701376,
    "0B_PokeyMummy":            2149682592,
    "0B_Swooper":               2149696908,
    "0B_BuzzyBeetle":           2149705144,
    "0B_StoneChomp":            2149717868,
    "0C_Chomp":                 2149682844,
    "0C_Tutankoopa":            2149694452,
    "0D_ForestFuzzy":           2149680284,
    "0D_Bzzap":                 2149689852,
    "0D_PiranhaPlant":          2149700720,
    "0E_HyperGoomba":           2149681228,
    "0E_HyperParagoomba":       2149692656,
    "0E_HyperCleft":            2149715000,
    "0E_TubbasHeart":           2149727608,
    "0E_TubbaBlubba":           2149735792,
    "0F_Clubba":                2149679400,
    "0F_TubbaBlubba":           2149682504,
    "10_ShyGuy_RED":            2149683956,
    "10_ShyGuy_BLU":            2149690868,
    "10_ShyGuy_YLW":            2149697780,
    "10_ShyGuy_PNK":            2149704692,
    "10_ShyGuy_GRN":            2149711604,
    "10_AntiGuy":               2149718508,
    "10_MediGuy":               2149725504,
    "10_GrooveGuy":             2149731088,
    "10_SpyGuy":                2149741996,
    "10_SkyGuy":                2149750868,
    "10_PyroGuy":               2149764184,
    "11_GeneralGuy":            2149680176,
    "11_ToyTank":               2149763420,
    "11_LightBulb":             2149775076,
    "12_BigLanternGhost":       2149682876,
    "12_Goomba":                2149700140,
    "12_Clubba":                2149706808,
    "12_Fuzzy":                 2149709820,
    "12_HammerBros":            2149716408,
    "12_Pokey":                 2149724144,
    "12_Koopatrol":             2149745600,
    "12_ShyGuy":                2149764564,
    "13_Fuzzipede":             2149681992,
    "14_SpearGuy":              2149681280,
    "14_HurtPlant":             2149702256,
    "14_JungleFuzzy":           2149706420,
    "14_MBush":                 2149718368,
    "14_MediGuy":               2149721728,
    "14_SpikeTop":              2149727256,
    "15_PutridPiranha":         2149681136,
    "15_WMagikoopa":            2149687504,
    "15_FlyingWMagikoopa":      2149687544,
    "16_LavaBubble":            2149683100,
    "16_PutridPiranha":         2149691856,
    "16_SpikeTop":              2149697960,
    "16_MediGuy":               2149710272,
    "16_RMagikoopa":            2149716064,
    "16_FlyingRMagikoopa":      2149716104,
    "16_WMagikoopa":            2149727520,
    "16_FlyingWMagikoopa":      2149727560,
    "17_LavaPiranha":           2149700156,
    "17_PetitPiranha":          2149728288,
    "17_LavaBud":               2149732980,
    "17_PetitPiranhaBomb":      2149746800,
    "18_Lakitu":                2149687376,
    "18_Spiny":                 2149695616,
    "18_CrazeeDayzee":          2149701756,
    "18_Bzzap":                 2149706508,
    "18_AmazyDayzee":           2149717276,
    "18_RuffPuff":              2149721800,
    "18_MediGuy":               2149725952,
    "18_RMagikoopa":            2149731744,
    "18_FlyingRMagikoopa":      2149731784,
    "18_GRNMagikoopa":          2149743200,
    "18_FlyingGRNMagikoopa":    2149743240,
    "18_WMagikoopa":            2149754656,
    "18_FlyingWMagikoopa":      2149754696,
    "18_YMagikoopa":            2149770112,
    "18_FlyingYMagikoopa":      2149770152,
    "19_HuffNPuff":             2149686172,
    "19_TuffPuff":              2149775192,
    "19_MontyMole":             2149779332,
    "19_EmptyMoleHole":         2149779616,
    "19_Spike":                 2149783912,
    "1A_DarkKoopa":             2149687752,
    "1A_DarkParatroopa":        2149700648,
    "1A_Gloomba":               2149720828,
    "1A_SpikedGloomba":         2149727420,
    "1A_Paragloomba":           2149734672,
    "1A_BuzzyBeetle":           2149747368,
    "1A_SpikeTop":              2149759544,
    "1A_Spiny":                 2149771984,
    "1B_Blooper":               2149689352,
    "1B_ElectroBlooper":        2149697540,
    "1B_SuperBlooper":          2149709556,
    "1B_BlooperBaby":           2149721640,
    "1C_Swooper":               2149685548,
    "1C_Swoopula":              2149693756,
    "1D_Duplighost":            2149691344,
    "1D_GhostGoombario":        2149698588,
    "1D_GhostKooper":           2149705724,
    "1D_GhostBombette":         2149712984,
    "1D_GhostParakarry":        2149717724,
    "1D_GhostBow":              2149721704,
    "1D_GhostWatt":             2149726784,
    "1D_GhostSushie":           2149730576,
    "1D_GhostLakilester":       2149737176,
    "1D_Gulpit":                2149744472,
    "1D_GulpitRocks":           2149750212,
    "1D_WhiteClubba":           2149751800,
    "1D_FrostPiranha":          2149755880,
    "1D_GRYMagikoopa":          2149762320,
    "1D_FlyingGRYMagikoopa":    2149762360,
    "1E_Monstar":               2149687144,
    "1E_Paragoomba":            2149695632,
    "1E_GRYMagikoopa":          2149708592,
    "1E_FlyingGRYMagikoopa":    2149708632,
    "1F_Swoopula":              2149684748,
    "1F_AlbinoDino":            2149701952,
    "1F_WhiteClubba":           2149705512,
    "1F_RMagikoopa":            2149709792,
    "1F_FlyingRMagikoopa":      2149709832,
    "1F_GRNMagikoopa":          2149721248,
    "1F_FlyingGRNMagikoopa":    2149721288,
    "1F_YMagikoopa":            2149732704,
    "1F_FlyingYMagikoopa":      2149732744,
    "1F_GRYMagikoopa":          2149744240,
    "1F_FlyingGRYMagikoopa":    2149744280,
    "1F_WMagikoopa":            2149755696,
    "1F_FlyingWMagikoopa":      2149755736,
    "20_CrystalKing":           2149681944,
    "20_CrystalClone":          2149697508,
    "20_CrystalBitA":           2149713476,
    "20_CrystalBitB":           2149713516,
    "20_CrystalBitC":           2149713556,
    "21_Duplighost":            2149687376,
    "21_GhostGoombario":        2149694620,
    "21_GhostKooper":           2149701756,
    "21_GhostBombette":         2149709016,
    "21_GhostParakarry":        2149713756,
    "21_GhostBow":              2149717736,
    "21_GhostWatt":             2149722816,
    "21_GhostSushie":           2149726608,
    "21_GhostLakilester":       2149733208,
    "21_Swoopula":              2149740332,
    "21_WhiteClubba":           2149757544,
    "21_RMagikoopa":            2149761824,
    "21_FlyingRMagikoopa":      2149761864,
    "21_GRYMagikoopa":          2149773280,
    "21_FlyingGRYMagikoopa":    2149773320,
    "22_BonyBeetle":            2149681736,
    "22_DryBones":              2149698652,
    "22_HammerBros":            2149705336,
    "22_Koopatrol":             2149713392,
    "22_Magikoopa":             2149732640,
    "22_FlyingMagikoopa":       2149732680,
    "22_Magiclone":             2149749452,
    "22_FlyingMagiclone":       2149749492,
    "22_Ember":                 2149763476,
    "23_IntroBowser":           2149708712,
    "23_Bowser1":               2149717656,
    "23_Bowser2":               2149742408,
    "23_Bowser3":               2149766776,
    "24_AntiGuy":               2149685148,
    "24_Duplighost":            2149692160,
    "24_GhostGoombario":        2149699404,
    "24_GhostKooper":           2149706540,
    "24_GhostBombette":         2149713800,
    "24_GhostParakarry":        2149718540,
    "24_GhostBow":              2149722520,
    "24_GhostWatt":             2149727600,
    "24_GhostSushie":           2149731392,
    "24_GhostLakilester":       2149737992,
    "25_BombshellBlaster":      2149680940,
    "25_BombshellBill":         2149682924,
    "25_Koopatrol":             2149686944,
    "25_Magikoopa":             2149706192,
    "25_FlyingMagikoopa":       2149706232,
    "25_Magiclone":             2149723004,
    "25_FlyingMagiclone":       2149723044,
    "27_Fuzzy":                 2149690108,
    "27_Pokey":                 2149696608,
    "27_BanditA":               2149717800,
    "27_BanditB":               2149717840,
    "27_ShyGuy":                2149726292,
    "27_TubbaBlubba":           2149733288,
    "27_MontyMole":             2149740148,
    "27_EmptyMoleHole":         2149740432,
    "29_ShySquad":              2149782440,
    "2A_StiltGuy":              2149782552,
    "2B_ShyStack":              2149782240,
    "2C_ShyGuy":                2149781724,
    "2D_ShySquad":              2149782264,
    "2E_ShyGuy":                2149782012
}


#           key                               actor name,                stat name,     default, native ch, ch1,   ch2,     ch3,    ch4,     ch5,    ch6,   ch7,    ch8 values
actor_param_table = {
    ".DBKey:00_Goomba:Level":               ("00_Goomba",                "Level",            5,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:00_Goomba:HP":                  ("00_Goomba",                "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:00_Goomba:DamageA":             ("00_Goomba",                "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:00_Paragoomba:Level":           ("00_Paragoomba",            "Level",            6,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:00_Paragoomba:HP":              ("00_Paragoomba",            "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:00_Paragoomba:DamageA":         ("00_Paragoomba",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:00_SpikedGoomba:Level":         ("00_SpikedGoomba",          "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:00_SpikedGoomba:HP":            ("00_SpikedGoomba",          "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:00_SpikedGoomba:DamageA":       ("00_SpikedGoomba",          "DamageA",          2,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:01_BlueGoomba1:Level":          ("01_BlueGoomba1",           "Level",            20,     1,      20,     23,     26,     29,     31,     34,     37,    40),
    ".DBKey:01_BlueGoomba1:HP":             ("01_BlueGoomba1",           "HP",               6,      1,      6,      8,      10,     12,     14,     16,     18,    20),
    ".DBKey:01_BlueGoomba1:DamageA":        ("01_BlueGoomba1",           "DamageA",          1,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:01_RedGoomba1:Level":           ("01_RedGoomba1",            "Level",            20,     1,      20,     23,     26,     29,     31,     34,     37,    40),
    ".DBKey:01_RedGoomba1:HP":              ("01_RedGoomba1",            "HP",               7,      1,      7,      9,      12,     14,     17,     19,     22,    24),
    ".DBKey:01_RedGoomba1:DamageA":         ("01_RedGoomba1",            "DamageA",          1,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:01_BlueGoomba2:Level":          ("01_BlueGoomba2",           "Level",            20,     1,      20,     23,     26,     29,     31,     34,     37,    40),
    ".DBKey:01_BlueGoomba2:HP":             ("01_BlueGoomba2",           "HP",               6,      1,      6,      8,      10,     12,     14,     16,     18,    20),
    ".DBKey:01_BlueGoomba2:DamageA":        ("01_BlueGoomba2",           "DamageA",          1,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:01_RedGoomba2:Level":           ("01_RedGoomba2",            "Level",            20,     1,      20,     23,     26,     29,     31,     34,     37,    40),
    ".DBKey:01_RedGoomba2:HP":              ("01_RedGoomba2",            "HP",               7,      1,      7,      9,      12,     14,     17,     19,     22,    24),
    ".DBKey:01_RedGoomba2:DamageA":         ("01_RedGoomba2",            "DamageA",          1,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:01_GoombaKing:Level":           ("01_GoombaKing",            "Level",            49,     1,      50,     53,     56,     59,     61,     64,     67,    70),
    ".DBKey:01_GoombaKing:HP":              ("01_GoombaKing",            "HP",               10,     1,      10,     15,     20,     25,     30,     35,     40,    45),
    ".DBKey:01_GoombaKing:DamageA":         ("01_GoombaKing",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:01_GoombaKing:DamageB":         ("01_GoombaKing",            "DamageB",          2,      1,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:01_GoomnutTree:DamageA":        ("01_GoomnutTree",           "DamageA",          3,      1,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:01_GoomnutTree:DamageB":        ("01_GoomnutTree",           "DamageB",          3,      1,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:01_GoomnutTree:DamageC":        ("01_GoomnutTree",           "DamageC",          3,      1,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:02_GoombaA:DamageA":            ("02_GoombaA",               "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:02_GoombaB:DamageA":            ("02_GoombaB",               "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:02_SpikedGoomba:Level":         ("02_SpikedGoomba",          "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:02_SpikedGoomba:HP":            ("02_SpikedGoomba",          "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_SpikedGoomba:DamageA":       ("02_SpikedGoomba",          "DamageA",          2,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:02_ParagoombaA:Level":          ("02_ParagoombaA",           "Level",            6,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:02_ParagoombaA:HP":             ("02_ParagoombaA",           "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_ParagoombaA:DamageA":        ("02_ParagoombaA",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:02_ParagoombaB:Level":          ("02_ParagoombaB",           "Level",            6,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:02_ParagoombaB:HP":             ("02_ParagoombaB",           "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_ParagoombaB:DamageA":        ("02_ParagoombaB",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:02_JrTroopa1:Level":            ("02_JrTroopa1",             "Level",            41,     1,      45,     47,     49,     51,     54,     56,     58,    60),
    ".DBKey:02_JrTroopa1:HP":               ("02_JrTroopa1",             "HP",               5,      1,      15,     20,     25,     30,     35,     40,     45,    50),
    ".DBKey:02_JrTroopa1:DamageA":          ("02_JrTroopa1",             "DamageA",          1,      1,      1,      2,      3,      4,      5,      6,      7,     8),
    ".DBKey:02_JrTroopa1:DamageB":          ("02_JrTroopa1",             "DamageB",          2,      1,      2,      3,      4,      5,      7,      8,      9,     10),
    ".DBKey:02_JrTroopa2:Level":            ("02_JrTroopa2",             "Level",            44,     1,      45,     47,     49,     51,     54,     56,     58,    60),
    ".DBKey:02_JrTroopa2:HP":               ("02_JrTroopa2",             "HP",               15,     1,      20,     25,     30,     35,     45,     50,     55,    60),
    ".DBKey:02_JrTroopa2:DamageA":          ("02_JrTroopa2",             "DamageA",          2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_JrTroopa3:Level":            ("02_JrTroopa3",             "Level",            52,     3,      45,     47,     49,     51,     54,     56,     58,    60),
    ".DBKey:02_JrTroopa3:HP":               ("02_JrTroopa3",             "HP",               40,     3,      20,     25,     30,     35,     35,     40,     45,    50),
    ".DBKey:02_JrTroopa3:DamageA":          ("02_JrTroopa3",             "DamageA",          5,      3,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_JrTroopa4:Level":            ("02_JrTroopa4",             "Level",            59,     5,      45,     47,     49,     51,     54,     56,     58,    60),
    ".DBKey:02_JrTroopa4:HP":               ("02_JrTroopa4",             "HP",               40,     5,      20,     25,     30,     35,     45,     50,     55,    60),
    ".DBKey:02_JrTroopa4:DamageA":          ("02_JrTroopa4",             "DamageA",          6,      5,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:02_JrTroopa5:Level":            ("02_JrTroopa5",             "Level",            65,     7,      45,     48,     51,     54,     56,     59,     62,    65),
    ".DBKey:02_JrTroopa5:HP":               ("02_JrTroopa5",             "HP",               50,     7,      10,     16,     21,     27,     33,     39,     44,    50),
    ".DBKey:02_JrTroopa5:DamageA":          ("02_JrTroopa5",             "DamageA",          8,      7,      4,      5,      5,      6,      6,      7,      7,     8),
    ".DBKey:03_Chan:Level":                 ("03_Chan",                  "Level",            0,      -1,     40,     40,     40,     40,     40,     40,     40,    40),
    ".DBKey:03_Lee:Level":                  ("03_Lee",                   "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeGoombario:Level":         ("03_LeeGoombario",          "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeKooper:Level":            ("03_LeeKooper",             "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeBombette:Level":          ("03_LeeBombette",           "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeParakarry:Level":         ("03_LeeParakarry",          "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeBow:Level":               ("03_LeeBow",                "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeWatt:Level":              ("03_LeeWatt",               "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeSushie:Level":            ("03_LeeSushie",             "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_LeeLakilester:Level":        ("03_LeeLakilester",         "Level",            0,      -1,     50,     50,     50,     50,     50,     50,     50,    50),
    ".DBKey:03_TheMaster1:Level":           ("03_TheMaster1",            "Level",            0,      -1,     70,     70,     70,     70,     70,     70,     70,    70),
    ".DBKey:03_TheMaster2:Level":           ("03_TheMaster2",            "Level",            0,      -1,     85,     85,     85,     85,     85,     85,     85,    85),
    ".DBKey:03_TheMaster3:Level":           ("03_TheMaster3",            "Level",            0,      -1,     100,    100,    100,    100,    100,    100,    100,   100),
    ".DBKey:04_Magikoopa:Level":            ("04_Magikoopa",             "Level",            32,     1,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:04_Magikoopa:HP":               ("04_Magikoopa",             "HP",               8,      1,      8,      10,     13,     15,     17,     19,     22,    24),
    ".DBKey:04_Magikoopa:DamageA":          ("04_Magikoopa",             "DamageA",          3,      1,      3,      3,      4,      4,      5,      5,      6,     6),
    ".DBKey:04_FlyingMagikoopa:Level":      ("04_FlyingMagikoopa",       "Level",            32,     1,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:04_FlyingMagikoopa:HP":         ("04_FlyingMagikoopa",       "HP",               8,      1,      8,      10,     12,     14,     18,     20,     22,    24),
    ".DBKey:04_Magiclone:Level":            ("04_Magiclone",             "Level",            26,     8,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:04_Magiclone:HP":               ("04_Magiclone",             "HP",               11,     8,      8,      10,     12,     14,     18,     20,     22,    24),
    ".DBKey:04_FlyingMagiclone:Level":      ("04_FlyingMagiclone",       "Level",            26,     8,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:04_FlyingMagiclone:HP":         ("04_FlyingMagiclone",       "HP",               11,     8,      8,      10,     12,     14,     18,     20,     22,    24),
    ".DBKey:05_Goomba:Level":               ("05_Goomba",                "Level",            5,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:05_Goomba:HP":                  ("05_Goomba",                "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:05_Goomba:DamageA":             ("05_Goomba",                "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:05_Paragoomba:Level":           ("05_Paragoomba",            "Level",            6,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:05_Paragoomba:HP":              ("05_Paragoomba",            "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:05_Paragoomba:DamageA":         ("05_Paragoomba",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:05_SpikedGoomba:Level":         ("05_SpikedGoomba",          "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:05_SpikedGoomba:HP":            ("05_SpikedGoomba",          "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:05_SpikedGoomba:DamageA":       ("05_SpikedGoomba",          "DamageA",          2,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:05_KoopaTroopa:Level":          ("05_KoopaTroopa",           "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:05_KoopaTroopa:HP":             ("05_KoopaTroopa",           "HP",               4,      1,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:05_KoopaTroopa:DamageA":        ("05_KoopaTroopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:05_Fuzzy:Level":                ("05_Fuzzy",                 "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:05_Fuzzy:HP":                   ("05_Fuzzy",                 "HP",               3,      1,      3,      4,      4,      5,      6,      7,      7,     8),
    ".DBKey:05_Fuzzy:DamageA":              ("05_Fuzzy",                 "DamageA",          1,      1,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:05_Paratroopa:Level":           ("05_Paratroopa",            "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:05_Paratroopa:HP":              ("05_Paratroopa",            "HP",               4,      1,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:05_Paratroopa:DamageA":         ("05_Paratroopa",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:05_KentC:Level":                ("05_KentC",                 "Level",            55,     -1,     80,     80,     80,     80,     80,     80,     80,    80),
    ".DBKey:06_BulletBill:Level":           ("06_BulletBill",            "Level",            5,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:06_BulletBill:HP":              ("06_BulletBill",            "HP",               2,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:06_BulletBill:DamageA":         ("06_BulletBill",            "DamageA",          2,      1,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:06_BillBlaster:Level":          ("06_BillBlaster",           "Level",            10,     1,      10,     12,     14,     16,     19,     21,     23,    25),
    ".DBKey:06_BillBlaster:HP":             ("06_BillBlaster",           "HP",               4,      1,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:06_Bobomb:Level":               ("06_Bobomb",                "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:06_Bobomb:HP":                  ("06_Bobomb",                "HP",               3,      1,      3,      4,      4,      5,      6,      7,      7,     8),
    ".DBKey:06_Bobomb:DamageA":             ("06_Bobomb",                "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:06_Bobomb:DamageB":             ("06_Bobomb",                "DamageB",          2,      1,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:06_KoopaTroopa:Level":          ("06_KoopaTroopa",           "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:06_KoopaTroopa:HP":             ("06_KoopaTroopa",           "HP",               4,      1,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:06_KoopaTroopa:DamageA":        ("06_KoopaTroopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:06_Paratroopa:Level":           ("06_Paratroopa",            "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:06_Paratroopa:HP":              ("06_Paratroopa",            "HP",               4,      1,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:06_Paratroopa:DamageA":         ("06_Paratroopa",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_FakeBowser:Level":           ("07_FakeBowser",            "Level",            0,      1,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:07_FakeBowser:HP":              ("07_FakeBowser",            "HP",               10,     1,      10,     12,     14,     16,     18,     20,     22,    24),
    ".DBKey:07_FakeBowser:DamageA":         ("07_FakeBowser",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_GNinjakoopa:Level":          ("07_GNinjakoopa",           "Level",            16,     1,      15,     18,     21,     24,     27,     30,     33,    36),
    ".DBKey:07_GNinjakoopa:HP":             ("07_GNinjakoopa",           "HP",               5,      1,      5,      7,      9,      11,     12,     14,     16,    18),
    ".DBKey:07_GNinjakoopa:DamageA":        ("07_GNinjakoopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_RNinjakoopa:Level":          ("07_RNinjakoopa",           "Level",            17,     1,      15,     18,     21,     24,     27,     30,     33,    36),
    ".DBKey:07_RNinjakoopa:HP":             ("07_RNinjakoopa",           "HP",               5,      1,      5,      7,      9,      11,     12,     14,     16,    18),
    ".DBKey:07_RNinjakoopa:DamageA":        ("07_RNinjakoopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_BNinjakoopa:Level":          ("07_BNinjakoopa",           "Level",            17,     1,      15,     18,     21,     24,     27,     30,     33,    36),
    ".DBKey:07_BNinjakoopa:HP":             ("07_BNinjakoopa",           "HP",               5,      1,      5,      7,      9,      11,     12,     14,     16,    18),
    ".DBKey:07_BNinjakoopa:DamageA":        ("07_BNinjakoopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_YNinjakoopa:Level":          ("07_YNinjakoopa",           "Level",            16,     1,      15,     18,     21,     24,     27,     30,     33,    36),
    ".DBKey:07_YNinjakoopa:HP":             ("07_YNinjakoopa",           "HP",               5,      1,      5,      7,      9,      11,     12,     14,     16,    18),
    ".DBKey:07_YNinjakoopa:DamageA":        ("07_YNinjakoopa",           "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:07_KoopaBrosTower:Increment":   ("07_KoopaBrosTower",        "Increment",        1,      1,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:09_Cleft:Level":                ("09_Cleft",                 "Level",            10,     2,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:09_Cleft:HP":                   ("09_Cleft",                 "HP",               2,      2,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:09_Cleft:DamageA":              ("09_Cleft",                 "DamageA",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:09_MontyMole:Level":            ("09_MontyMole",             "Level",            8,      2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:09_MontyMole:HP":               ("09_MontyMole",             "HP",               3,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:09_MontyMole:DamageA":          ("09_MontyMole",             "DamageA",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:09_Buzzar:Level":               ("09_Buzzar",                "Level",            35,     2,      40,     42,     44,     46,     49,     51,     53,    55),
    ".DBKey:09_Buzzar:HP":                  ("09_Buzzar",                "HP",               40,     2,      35,     40,     45,     50,     55,     60,     65,    70),
    ".DBKey:09_Buzzar:DamageA":             ("09_Buzzar",                "DamageA",          2,      2,      1,      2,      2,      3,      3,      4,      4,     5),
    ".DBKey:09_Buzzar:DamageB":             ("09_Buzzar",                "DamageB",          3,      2,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:09_Buzzar:DamageC":             ("09_Buzzar",                "DamageC",          4,      2,      3,      4,      4,      5,      5,      6,      6,     7),
    ".DBKey:09_Buzzar:DamageD1":            ("09_Buzzar",                "DamageD1",         1,      2,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:09_Buzzar:DamageD2":            ("09_Buzzar",                "DamageD2",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:09_Buzzar:DamageD3":            ("09_Buzzar",                "DamageD3",         3,      2,      3,      3,      4,      4,      5,      5,      6,     6),
    ".DBKey:0A_Pokey:Level":                ("0A_Pokey",                 "Level",            9,      2,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:0A_Pokey:HP":                   ("0A_Pokey",                 "HP",               4,      2,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0A_Pokey:DamageA0":             ("0A_Pokey",                 "DamageA0",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0A_Pokey:DamageA1":             ("0A_Pokey",                 "DamageA1",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0A_Pokey:DamageA2":             ("0A_Pokey",                 "DamageA2",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0A_Pokey:DamageB":              ("0A_Pokey",                 "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0A_Pokey:DamageC":              ("0A_Pokey",                 "DamageC",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0A_BanditA:Level":              ("0A_BanditA",               "Level",            9,      2,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:0A_BanditA:HP":                 ("0A_BanditA",               "HP",               5,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0A_BanditA:DamageA":            ("0A_BanditA",               "DamageA",          2,      2,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:0A_BanditB:Level":              ("0A_BanditB",               "Level",            9,      2,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:0A_BanditB:HP":                 ("0A_BanditB",               "HP",               5,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0B_PokeyMummy:Level":           ("0B_PokeyMummy",            "Level",            10,     2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:0B_PokeyMummy:HP":              ("0B_PokeyMummy",            "HP",               4,      2,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0B_PokeyMummy:DamageA":         ("0B_PokeyMummy",            "DamageA",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_PokeyMummy:DamageB":         ("0B_PokeyMummy",            "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_Swooper:Level":              ("0B_Swooper",               "Level",            10,     2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:0B_Swooper:HP":                 ("0B_Swooper",               "HP",               4,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0B_Swooper:DamageA":            ("0B_Swooper",               "DamageA",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_Swooper:DamageB":            ("0B_Swooper",               "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_BuzzyBeetle:Level":          ("0B_BuzzyBeetle",           "Level",            10,     2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:0B_BuzzyBeetle:HP":             ("0B_BuzzyBeetle",           "HP",               3,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_BuzzyBeetle:DamageA":        ("0B_BuzzyBeetle",           "DamageA",          3,      2,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:0B_BuzzyBeetle:DamageB":        ("0B_BuzzyBeetle",           "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0B_StoneChomp:Level":           ("0B_StoneChomp",            "Level",            14,     2,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:0B_StoneChomp:HP":              ("0B_StoneChomp",            "HP",               4,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0B_StoneChomp:DamageA":         ("0B_StoneChomp",            "DamageA",          3,      2,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0C_Chomp:Level":                ("0C_Chomp",                 "Level",            14,     2,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:0C_Chomp:HP":                   ("0C_Chomp",                 "HP",               4,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0C_Chomp:DamageA":              ("0C_Chomp",                 "DamageA",          3,      2,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0C_Tutankoopa:Level":           ("0C_Tutankoopa",            "Level",            55,     2,      50,     53,     56,     59,     61,     64,     67,    70),
    ".DBKey:0C_Tutankoopa:HP":              ("0C_Tutankoopa",            "HP",               30,     2,      25,     30,     35,     40,     45,     50,     55,    60),
    ".DBKey:0C_Tutankoopa:DamageA":         ("0C_Tutankoopa",            "DamageA",          3,      2,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:0C_Tutankoopa:DamageB":         ("0C_Tutankoopa",            "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0C_Tutankoopa:DamageC":         ("0C_Tutankoopa",            "DamageC",          2,      2,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:0C_Tutankoopa:DamageD":         ("0C_Tutankoopa",            "DamageD",          2,      2,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:0C_Tutankoopa:DamageE":         ("0C_Tutankoopa",            "DamageE",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0D_ForestFuzzy:Level":          ("0D_ForestFuzzy",           "Level",            11,     3,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:0D_ForestFuzzy:HP":             ("0D_ForestFuzzy",           "HP",               6,      3,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:0D_ForestFuzzy:DamageA":        ("0D_ForestFuzzy",           "DamageA",          1,      3,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:0D_Bzzap:Level":                ("0D_Bzzap",                 "Level",            19,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:0D_Bzzap:HP":                   ("0D_Bzzap",                 "HP",               3,      6,      2,      2,      3,      3,      3,      3,      4,     4),
    ".DBKey:0D_Bzzap:DamageA":              ("0D_Bzzap",                 "DamageA",          6,      6,      3,      4,      4,      5,      5,      6,      6,     7),
    ".DBKey:0D_Bzzap:DamageB":              ("0D_Bzzap",                 "DamageB",          1,      6,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:0D_PiranhaPlant:Level":         ("0D_PiranhaPlant",          "Level",            11,     3,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:0D_PiranhaPlant:HP":            ("0D_PiranhaPlant",          "HP",               5,      3,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0D_PiranhaPlant:DamageA":       ("0D_PiranhaPlant",          "DamageA",          3,      3,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0E_HyperGoomba:Level":          ("0E_HyperGoomba",           "Level",            12,     3,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:0E_HyperGoomba:HP":             ("0E_HyperGoomba",           "HP",               7,      3,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:0E_HyperGoomba:DamageA":        ("0E_HyperGoomba",           "DamageA",          8,      3,      6,      7,      8,      9,      9,      10,     11,    12),
    ".DBKey:0E_HyperGoomba:DamageB":        ("0E_HyperGoomba",           "DamageB",          1,      3,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:0E_HyperParagoomba:Level":      ("0E_HyperParagoomba",       "Level",            12,     3,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:0E_HyperParagoomba:HP":         ("0E_HyperParagoomba",       "HP",               7,      3,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:0E_HyperParagoomba:DamageA":    ("0E_HyperParagoomba",       "DamageA",          8,      3,      6,      7,      8,      9,      9,      10,     11,    12),
    ".DBKey:0E_HyperParagoomba:DamageB":    ("0E_HyperParagoomba",       "DamageB",          1,      3,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:0E_HyperCleft:Level":           ("0E_HyperCleft",            "Level",            15,     3,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:0E_HyperCleft:HP":              ("0E_HyperCleft",            "HP",               4,      3,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:0E_HyperCleft:DamageA":         ("0E_HyperCleft",            "DamageA",          8,      3,      6,      7,      8,      9,      9,      10,     11,    12),
    ".DBKey:0E_HyperCleft:DamageB":         ("0E_HyperCleft",            "DamageB",          3,      3,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0E_TubbasHeart:Level":          ("0E_TubbasHeart",           "Level",            0,      3,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:0E_TubbasHeart:HP":             ("0E_TubbasHeart",           "HP",               50,     3,      35,     40,     45,     50,     55,     60,     65,    70),
    ".DBKey:0E_TubbasHeart:DamageA":        ("0E_TubbasHeart",           "DamageA",          6,      3,      4,      5,      5,      6,      6,      7,      7,     8),
    ".DBKey:0E_TubbasHeart:DamageB":        ("0E_TubbasHeart",           "DamageB",          12,     3,      10,     11,     11,     12,     12,     13,     13,    14),
    ".DBKey:0E_TubbaBlubba:Level":          ("0E_TubbaBlubba",           "Level",            70,     3,      55,     58,     61,     64,     66,     69,     72,    75),
    ".DBKey:0E_TubbaBlubba:HP":             ("0E_TubbaBlubba",           "HP",               10,     3,      6,      8,      10,     12,     14,     16,     18,    20),
    ".DBKey:0E_TubbaBlubba:DamageA":        ("0E_TubbaBlubba",           "DamageA",          4,      3,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:0E_TubbaBlubba:DamageB":        ("0E_TubbaBlubba",           "DamageB",          6,      3,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:0F_Clubba:Level":               ("0F_Clubba",                "Level",            13,     3,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:0F_Clubba:HP":                  ("0F_Clubba",                "HP",               8,      3,      6,      7,      8,      9,      9,      10,     11,    12),
    ".DBKey:0F_Clubba:DamageA":             ("0F_Clubba",                "DamageA",          3,      3,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:0F_TubbaBlubba:Level":          ("0F_TubbaBlubba",           "Level",            0,      3,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:0F_TubbaBlubba:HP":             ("0F_TubbaBlubba",           "HP",               10,     3,      6,      8,      10,     12,     14,     16,     18,    20),
    ".DBKey:0F_TubbaBlubba:DamageA":        ("0F_TubbaBlubba",           "DamageA",          4,      3,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:0F_TubbaBlubba:DamageB":        ("0F_TubbaBlubba",           "DamageB",          6,      3,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:10_ShyGuy_RED:Level":           ("10_ShyGuy_RED",            "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_ShyGuy_RED:HP":              ("10_ShyGuy_RED",            "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_ShyGuy_RED:DamageA":         ("10_ShyGuy_RED",            "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_ShyGuy_RED:DamageB":         ("10_ShyGuy_RED",            "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_ShyGuy_BLU:Level":           ("10_ShyGuy_BLU",            "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_ShyGuy_BLU:HP":              ("10_ShyGuy_BLU",            "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_ShyGuy_BLU:DamageA":         ("10_ShyGuy_BLU",            "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_ShyGuy_BLU:DamageB":         ("10_ShyGuy_BLU",            "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_ShyGuy_YLW:Level":           ("10_ShyGuy_YLW",            "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_ShyGuy_YLW:HP":              ("10_ShyGuy_YLW",            "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_ShyGuy_YLW:DamageA":         ("10_ShyGuy_YLW",            "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_ShyGuy_YLW:DamageB":         ("10_ShyGuy_YLW",            "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_ShyGuy_PNK:Level":           ("10_ShyGuy_PNK",            "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_ShyGuy_PNK:HP":              ("10_ShyGuy_PNK",            "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_ShyGuy_PNK:DamageA":         ("10_ShyGuy_PNK",            "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_ShyGuy_PNK:DamageB":         ("10_ShyGuy_PNK",            "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_ShyGuy_GRN:Level":           ("10_ShyGuy_GRN",            "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_ShyGuy_GRN:HP":              ("10_ShyGuy_GRN",            "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_ShyGuy_GRN:DamageA":         ("10_ShyGuy_GRN",            "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_ShyGuy_GRN:DamageB":         ("10_ShyGuy_GRN",            "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_MediGuy:Level":              ("10_MediGuy",               "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_MediGuy:HP":                 ("10_MediGuy",               "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_MediGuy:DamageA":            ("10_MediGuy",               "DamageA",          1,      4,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:10_GrooveGuy:Level":            ("10_GrooveGuy",             "Level",            15,     4,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:10_GrooveGuy:HP":               ("10_GrooveGuy",             "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_GrooveGuy:DamageA":          ("10_GrooveGuy",             "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_SpyGuy:Level":               ("10_SpyGuy",                "Level",            15,     4,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:10_SpyGuy:HP":                  ("10_SpyGuy",                "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_SpyGuy:DamageA":             ("10_SpyGuy",                "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_SpyGuy:DamageB":             ("10_SpyGuy",                "DamageB",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:10_SkyGuy:Level":               ("10_SkyGuy",                "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:10_SkyGuy:HP":                  ("10_SkyGuy",                "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_SkyGuy:DamageA":             ("10_SkyGuy",                "DamageA",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:10_PyroGuy:Level":              ("10_PyroGuy",               "Level",            15,     4,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:10_PyroGuy:HP":                 ("10_PyroGuy",               "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:10_PyroGuy:DamageA":            ("10_PyroGuy",               "DamageA",          4,      4,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:11_GeneralGuy:Level":           ("11_GeneralGuy",            "Level",            73,     4,      65,     67,     69,     71,     74,     76,     78,    80),
    ".DBKey:11_GeneralGuy:HP":              ("11_GeneralGuy",            "HP",               10,     4,      6,      8,      8,      10,     12,     14,     14,    16),
    ".DBKey:11_GeneralGuy:DamageA":         ("11_GeneralGuy",            "DamageA",          4,      4,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:11_GeneralGuy:DamageB":         ("11_GeneralGuy",            "DamageB",          5,      4,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:11_GeneralGuy:DamageC":         ("11_GeneralGuy",            "DamageC",          2,      4,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:11_ToyTank:Level":              ("11_ToyTank",               "Level",            0,      4,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:11_ToyTank:HP":                 ("11_ToyTank",               "HP",               30,     4,      25,     30,     30,     35,     40,     45,     45,    50),
    ".DBKey:11_ToyTank:DamageA":            ("11_ToyTank",               "DamageA",          4,      4,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:11_LightBulb:Level":            ("11_LightBulb",             "Level",            0,      4,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:11_LightBulb:HP":               ("11_LightBulb",             "HP",               8,      4,      6,      6,      8,      8,      10,     10,     12,    12),
    ".DBKey:12_BigLanternGhost:Level":      ("12_BigLanternGhost",       "Level",            42,     4,      32,     35,     39,     42,     45,     48,     52,    55),
    ".DBKey:12_BigLanternGhost:HP":         ("12_BigLanternGhost",       "HP",               40,     4,      25,     30,     35,     40,     45,     50,     55,    60),
    ".DBKey:12_BigLanternGhost:DamageA":    ("12_BigLanternGhost",       "DamageA",          5,      4,      3,      4,      4,      5,      6,      7,      7,     8),
    ".DBKey:12_BigLanternGhost:DamageB":    ("12_BigLanternGhost",       "DamageB",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:12_BigLanternGhost:DamageC":    ("12_BigLanternGhost",       "DamageC",          2,      4,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:12_Goomba:Level":               ("12_Goomba",                "Level",            5,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:12_Goomba:HP":                  ("12_Goomba",                "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:12_Goomba:DamageA":             ("12_Goomba",                "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:12_Clubba:Level":               ("12_Clubba",                "Level",            13,     3,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:12_Clubba:HP":                  ("12_Clubba",                "HP",               8,      3,      6,      7,      8,      9,      9,      10,     11,    12),
    ".DBKey:12_Clubba:DamageA":             ("12_Clubba",                "DamageA",          3,      3,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_Fuzzy:Level":                ("12_Fuzzy",                 "Level",            6,      1,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:12_Fuzzy:HP":                   ("12_Fuzzy",                 "HP",               3,      1,      3,      4,      4,      5,      6,      7,      7,     8),
    ".DBKey:12_Fuzzy:DamageA":              ("12_Fuzzy",                 "DamageA",          1,      1,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:12_Pokey:Level":                ("12_Pokey",                 "Level",            9,      2,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:12_Pokey:HP":                   ("12_Pokey",                 "HP",               4,      2,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:12_Pokey:DamageA0":             ("12_Pokey",                 "DamageA0",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_Pokey:DamageA1":             ("12_Pokey",                 "DamageA1",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_Pokey:DamageA2":             ("12_Pokey",                 "DamageA2",         2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_Pokey:DamageB":              ("12_Pokey",                 "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_Pokey:DamageC":              ("12_Pokey",                 "DamageC",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:12_ShyGuy:Level":               ("12_ShyGuy",                "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:12_ShyGuy:HP":                  ("12_ShyGuy",                "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:12_ShyGuy:DamageA":             ("12_ShyGuy",                "DamageA",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:12_ShyGuy:DamageB":             ("12_ShyGuy",                "DamageB",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:13_Fuzzipede:Level":            ("13_Fuzzipede",             "Level",            43,     5,      35,     37,     39,     41,     44,     46,     48,    50),
    ".DBKey:13_Fuzzipede:HP":               ("13_Fuzzipede",             "HP",               20,     5,      16,     18,     18,     20,     20,     22,     22,    24),
    ".DBKey:13_Fuzzipede:DamageA":          ("13_Fuzzipede",             "DamageA",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:13_Fuzzipede:DamageB":          ("13_Fuzzipede",             "DamageB",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:14_SpearGuy:Level":             ("14_SpearGuy",              "Level",            16,     5,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:14_SpearGuy:HP":                ("14_SpearGuy",              "HP",               7,      5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:14_SpearGuy:DamageA":           ("14_SpearGuy",              "DamageA",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:14_SpearGuy:DamageB":           ("14_SpearGuy",              "DamageB",          3,      5,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:14_SpearGuy:DamageC":           ("14_SpearGuy",              "DamageC",          2,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:14_SpearGuy:DamageD":           ("14_SpearGuy",              "DamageD",          3,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:14_HurtPlant:Level":            ("14_HurtPlant",             "Level",            16,     5,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:14_HurtPlant:HP":               ("14_HurtPlant",             "HP",               8,      5,      3,      4,      5,      6,      8,      9,      10,    11),
    ".DBKey:14_HurtPlant:DamageA":          ("14_HurtPlant",             "DamageA",          2,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:14_JungleFuzzy:Level":          ("14_JungleFuzzy",           "Level",            16,     5,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:14_JungleFuzzy:HP":             ("14_JungleFuzzy",           "HP",               7,      5,      3,      4,      5,      6,      6,      7,      8,     9),
    ".DBKey:14_JungleFuzzy:DamageA":        ("14_JungleFuzzy",           "DamageA",          2,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:14_MBush:Level":                ("14_MBush",                 "Level",            16,     5,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:14_MBush:HP":                   ("14_MBush",                 "HP",               8,      5,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:14_MBush:DamageA":              ("14_MBush",                 "DamageA",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:14_MediGuy:Level":              ("14_MediGuy",               "Level",            14,     4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:14_MediGuy:HP":                 ("14_MediGuy",               "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:14_MediGuy:DamageA":            ("14_MediGuy",               "DamageA",          1,      4,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:14_SpikeTop:Level":             ("14_SpikeTop",              "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:14_SpikeTop:HP":                ("14_SpikeTop",              "HP",               4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:14_SpikeTop:DamageA":           ("14_SpikeTop",              "DamageA",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:14_SpikeTop:DamageB":           ("14_SpikeTop",              "DamageB",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:15_PutridPiranha:Level":        ("15_PutridPiranha",         "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:15_PutridPiranha:HP":           ("15_PutridPiranha",         "HP",               12,     5,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:15_PutridPiranha:DamageA":      ("15_PutridPiranha",         "DamageA",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:15_PutridPiranha:DamageB":      ("15_PutridPiranha",         "DamageB",          2,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:15_WMagikoopa:Level":           ("15_WMagikoopa",            "Level",            21,     5,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:15_WMagikoopa:HP":              ("15_WMagikoopa",            "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:15_WMagikoopa:DamageA":         ("15_WMagikoopa",            "DamageA",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:15_WMagikoopa:DamageB":         ("15_WMagikoopa",            "DamageB",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:15_FlyingWMagikoopa:Level":     ("15_FlyingWMagikoopa",      "Level",            21,     5,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:15_FlyingWMagikoopa:HP":        ("15_FlyingWMagikoopa",      "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_LavaBubble:Level":           ("16_LavaBubble",            "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:16_LavaBubble:HP":              ("16_LavaBubble",            "HP",               9,      5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_LavaBubble:DamageA":         ("16_LavaBubble",            "DamageA",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:16_LavaBubble:DamageB":         ("16_LavaBubble",            "DamageB",          2,      5,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:16_LavaBubble:DamageC":         ("16_LavaBubble",            "DamageC",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:16_PutridPiranha:Level":        ("16_PutridPiranha",         "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:16_PutridPiranha:HP":           ("16_PutridPiranha",         "HP",               12,     5,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:16_PutridPiranha:DamageA":      ("16_PutridPiranha",         "DamageA",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:16_PutridPiranha:DamageB":      ("16_PutridPiranha",         "DamageB",          2,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:16_SpikeTop:Level":             ("16_SpikeTop",              "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:16_SpikeTop:HP":                ("16_SpikeTop",              "HP",               4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:16_SpikeTop:DamageA":           ("16_SpikeTop",              "DamageA",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:16_SpikeTop:DamageB":           ("16_SpikeTop",              "DamageB",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:16_MediGuy:Level":              ("16_MediGuy",               "Level",            14,     5,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:16_MediGuy:HP":                 ("16_MediGuy",               "HP",               7,      5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_MediGuy:DamageA":            ("16_MediGuy",               "DamageA",          1,      5,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:16_RMagikoopa:Level":           ("16_RMagikoopa",            "Level",            21,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:16_RMagikoopa:HP":              ("16_RMagikoopa",            "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_RMagikoopa:DamageA":         ("16_RMagikoopa",            "DamageA",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:16_RMagikoopa:DamageB":         ("16_RMagikoopa",            "DamageB",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:16_FlyingRMagikoopa:Level":     ("16_FlyingRMagikoopa",      "Level",            21,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:16_FlyingRMagikoopa:HP":        ("16_FlyingRMagikoopa",      "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_WMagikoopa:Level":           ("16_WMagikoopa",            "Level",            21,     5,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:16_WMagikoopa:HP":              ("16_WMagikoopa",            "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:16_WMagikoopa:DamageA":         ("16_WMagikoopa",            "DamageA",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:16_WMagikoopa:DamageB":         ("16_WMagikoopa",            "DamageB",          3,      5,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:16_FlyingWMagikoopa:Level":     ("16_FlyingWMagikoopa",      "Level",            21,     5,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:16_FlyingWMagikoopa:HP":        ("16_FlyingWMagikoopa",      "HP",               11,     5,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:17_LavaPiranha:Level":          ("17_LavaPiranha",           "Level",            45,     5,      36,     39,     41,     44,     46,     49,     51,    54),
    ".DBKey:17_LavaPiranha:HP":             ("17_LavaPiranha",           "HP",               40,     5,      20,     25,     30,     35,     40,     45,     50,    55),
    ".DBKey:17_LavaPiranha:DamageA":        ("17_LavaPiranha",           "DamageA",          5,      5,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:17_LavaPiranha:DamageB":        ("17_LavaPiranha",           "DamageB",          7,      5,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:17_PetitPiranha:Level":         ("17_PetitPiranha",          "Level",            0,      5,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:17_PetitPiranha:HP":            ("17_PetitPiranha",          "HP",               1,      5,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:17_PetitPiranha:DamageA":       ("17_PetitPiranha",          "DamageA",          6,      5,      3,      4,      4,      5,      6,      7,      7,     8),
    ".DBKey:17_LavaBud:Level":              ("17_LavaBud",               "Level",            0,      5,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:17_LavaBud:HP":                 ("17_LavaBud",               "HP",               8,      5,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:17_LavaBud:DamageA":            ("17_LavaBud",               "DamageA",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:17_PetitPiranhaBomb:Level":     ("17_PetitPiranhaBomb",      "Level",            0,      5,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:17_PetitPiranhaBomb:HP":        ("17_PetitPiranhaBomb",      "HP",               1,      5,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:18_Lakitu:Level":               ("18_Lakitu",                "Level",            20,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_Lakitu:HP":                  ("18_Lakitu",                "HP",               12,     6,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:18_Lakitu:DamageA":             ("18_Lakitu",                "DamageA",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_Spiny:Level":                ("18_Spiny",                 "Level",            19,     6,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:18_Spiny:HP":                   ("18_Spiny",                 "HP",               5,      6,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:18_Spiny:DamageA":              ("18_Spiny",                 "DamageA",          4,      6,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:18_CrazeeDayzee:Level":         ("18_CrazeeDayzee",          "Level",            19,     6,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:18_CrazeeDayzee:HP":            ("18_CrazeeDayzee",          "HP",               8,      6,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:18_CrazeeDayzee:DamageA":       ("18_CrazeeDayzee",          "DamageA",          4,      6,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:18_Bzzap:Level":                ("18_Bzzap",                 "Level",            19,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_Bzzap:HP":                   ("18_Bzzap",                 "HP",               3,      6,      2,      2,      3,      3,      3,      3,      4,     4),
    ".DBKey:18_Bzzap:DamageA":              ("18_Bzzap",                 "DamageA",          6,      6,      3,      4,      4,      5,      5,      6,      6,     7),
    ".DBKey:18_Bzzap:DamageB":              ("18_Bzzap",                 "DamageB",          1,      6,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:18_AmazyDayzee:Level":          ("18_AmazyDayzee",           "Level",            100,    6,      65,     70,     75,     80,     85,     90,     95,    100),
    ".DBKey:18_AmazyDayzee:HP":             ("18_AmazyDayzee",           "HP",               20,     6,      10,     12,     14,     16,     18,     20,     22,    24),
    ".DBKey:18_AmazyDayzee:DamageA":        ("18_AmazyDayzee",           "DamageA",          20,     6,      10,     12,     14,     16,     18,     20,     22,    24),
    ".DBKey:18_RuffPuff:Level":             ("18_RuffPuff",              "Level",            19,     6,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:18_RuffPuff:HP":                ("18_RuffPuff",              "HP",               10,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_RuffPuff:DamageA":           ("18_RuffPuff",              "DamageA",          4,      6,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:18_MediGuy:Level":              ("18_MediGuy",               "Level",            14,     6,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:18_MediGuy:HP":                 ("18_MediGuy",               "HP",               7,      6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_MediGuy:DamageA":            ("18_MediGuy",               "DamageA",          1,      6,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:18_RMagikoopa:Level":           ("18_RMagikoopa",            "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_RMagikoopa:HP":              ("18_RMagikoopa",            "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_RMagikoopa:DamageA":         ("18_RMagikoopa",            "DamageA",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_RMagikoopa:DamageB":         ("18_RMagikoopa",            "DamageB",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_FlyingRMagikoopa:Level":     ("18_FlyingRMagikoopa",      "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_FlyingRMagikoopa:HP":        ("18_FlyingRMagikoopa",      "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_GRNMagikoopa:Level":         ("18_GRNMagikoopa",          "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_GRNMagikoopa:HP":            ("18_GRNMagikoopa",          "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_GRNMagikoopa:DamageA":       ("18_GRNMagikoopa",          "DamageA",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_GRNMagikoopa:DamageB":       ("18_GRNMagikoopa",          "DamageB",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_FlyingGRNMagikoopa:Level":   ("18_FlyingGRNMagikoopa",    "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_FlyingGRNMagikoopa:HP":      ("18_FlyingGRNMagikoopa",    "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_WMagikoopa:Level":           ("18_WMagikoopa",            "Level",            21,     6,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:18_WMagikoopa:HP":              ("18_WMagikoopa",            "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_WMagikoopa:DamageA":         ("18_WMagikoopa",            "DamageA",          2,      6,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:18_WMagikoopa:DamageB":         ("18_WMagikoopa",            "DamageB",          2,      6,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:18_FlyingWMagikoopa:Level":     ("18_FlyingWMagikoopa",      "Level",            21,     6,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:18_FlyingWMagikoopa:HP":        ("18_FlyingWMagikoopa",      "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_YMagikoopa:Level":           ("18_YMagikoopa",            "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_YMagikoopa:HP":              ("18_YMagikoopa",            "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:18_YMagikoopa:DamageA":         ("18_YMagikoopa",            "DamageA",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_YMagikoopa:DamageB":         ("18_YMagikoopa",            "DamageB",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:18_FlyingYMagikoopa:Level":     ("18_FlyingYMagikoopa",      "Level",            21,     6,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:18_FlyingYMagikoopa:HP":        ("18_FlyingYMagikoopa",      "HP",               11,     6,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:19_HuffNPuff:Level":            ("19_HuffNPuff",             "Level",            80,     6,      55,     60,     65,     70,     75,     80,     85,    90),
    ".DBKey:19_HuffNPuff:HP":               ("19_HuffNPuff",             "HP",               60,     6,      32,     36,     40,     48,     52,     60,     64,    72),
    ".DBKey:19_HuffNPuff:SwarmIncrement":   ("19_HuffNPuff",             "SwarmIncrement",   1,      6,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:19_HuffNPuff:DamageA":          ("19_HuffNPuff",             "DamageA",          5,      6,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:19_HuffNPuff:DamageB":          ("19_HuffNPuff",             "DamageB",          12,     6,      6,      8,      8,      10,     12,     12,     14,    16),
    ".DBKey:19_HuffNPuff:DamageC":          ("19_HuffNPuff",             "DamageC",          10,     6,      4,      6,      6,      8,      10,     10,     12,    14),
    ".DBKey:19_HuffNPuff:DamageD":          ("19_HuffNPuff",             "DamageD",          1,      6,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:19_HuffNPuff:DamageE":          ("19_HuffNPuff",             "DamageE",          2,      6,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:19_HuffNPuff:DamageF":          ("19_HuffNPuff",             "DamageF",          5,      6,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:19_HuffNPuff:DamageG7":         ("19_HuffNPuff",             "DamageG7",         7,      6,      6,      6,      7,      7,      7,      7,      8,     8),
    ".DBKey:19_HuffNPuff:DamageG6":         ("19_HuffNPuff",             "DamageG6",         6,      6,      5,      5,      6,      6,      6,      6,      7,     7),
    ".DBKey:19_HuffNPuff:DamageG5":         ("19_HuffNPuff",             "DamageG5",         5,      6,      4,      4,      5,      5,      5,      5,      6,     6),
    ".DBKey:19_HuffNPuff:DamageG4":         ("19_HuffNPuff",             "DamageG4",         4,      6,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:19_HuffNPuff:DamageG3":         ("19_HuffNPuff",             "DamageG3",         3,      6,      2,      2,      3,      3,      3,      3,      4,     4),
    ".DBKey:19_HuffNPuff:DamageG2":         ("19_HuffNPuff",             "DamageG2",         2,      6,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:19_TuffPuff:Level":             ("19_TuffPuff",              "Level",            0,      6,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:19_TuffPuff:HP":                ("19_TuffPuff",              "HP",               1,      6,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:19_MontyMole:Level":            ("19_MontyMole",             "Level",            19,     6,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:19_MontyMole:HP":               ("19_MontyMole",             "HP",               12,     6,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:19_MontyMole:DamageA":          ("19_MontyMole",             "DamageA",          3,      6,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:19_Spike:Level":                ("19_Spike",                 "Level",            40,     6,      28,     30,     33,     35,     38,     40,     43,    45),
    ".DBKey:19_Spike:HP":                   ("19_Spike",                 "HP",               50,     6,      25,     30,     35,     40,     45,     50,     55,    60),
    ".DBKey:19_Spike:DamageA":              ("19_Spike",                 "DamageA",          4,      6,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1A_BuzzyBeetle:Level":          ("1A_BuzzyBeetle",           "Level",            10,     2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1A_BuzzyBeetle:HP":             ("1A_BuzzyBeetle",           "HP",               3,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1A_BuzzyBeetle:DamageA":        ("1A_BuzzyBeetle",           "DamageA",          3,      2,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:1A_BuzzyBeetle:DamageB":        ("1A_BuzzyBeetle",           "DamageB",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1A_SpikeTop:Level":             ("1A_SpikeTop",              "Level",            17,     5,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1A_SpikeTop:HP":                ("1A_SpikeTop",              "HP",               4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1A_SpikeTop:DamageA":           ("1A_SpikeTop",              "DamageA",          4,      5,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1A_SpikeTop:DamageB":           ("1A_SpikeTop",              "DamageB",          3,      5,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1A_Spiny:Level":                ("1A_Spiny",                 "Level",            19,     6,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:1A_Spiny:HP":                   ("1A_Spiny",                 "HP",               5,      6,      2,      3,      3,      4,      4,      5,      5,     6),
    ".DBKey:1A_Spiny:DamageA":              ("1A_Spiny",                 "DamageA",          4,      6,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1C_Swooper:Level":              ("1C_Swooper",               "Level",            10,     2,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1C_Swooper:HP":                 ("1C_Swooper",               "HP",               4,      2,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:1C_Swooper:DamageA":            ("1C_Swooper",               "DamageA",          2,      2,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1C_Swoopula:Level":             ("1C_Swoopula",              "Level",            22,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1C_Swoopula:HP":                ("1C_Swoopula",              "HP",               8,      7,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:1C_Swoopula:DamageA":           ("1C_Swoopula",              "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_Duplighost:Level":           ("1D_Duplighost",            "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_Duplighost:HP":              ("1D_Duplighost",            "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_Duplighost:DamageA":         ("1D_Duplighost",            "DamageA",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1D_GhostGoombario:Level":       ("1D_GhostGoombario",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostGoombario:HP":          ("1D_GhostGoombario",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostGoombario:DamageA":     ("1D_GhostGoombario",        "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1D_GhostGoombario:DamageB":     ("1D_GhostGoombario",        "DamageB",          2,      7,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:1D_GhostGoombario:DamageC":     ("1D_GhostGoombario",        "DamageC",          3,      7,      3,      3,      3,      3,      3,      3,      3,     3),
    ".DBKey:1D_GhostKooper:Level":          ("1D_GhostKooper",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostKooper:HP":             ("1D_GhostKooper",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostKooper:DamageA":        ("1D_GhostKooper",           "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_GhostKooper:DamageB":        ("1D_GhostKooper",           "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostKooper:DamageC":        ("1D_GhostKooper",           "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:1D_GhostBombette:Level":        ("1D_GhostBombette",         "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostBombette:HP":           ("1D_GhostBombette",         "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostBombette:DamageA":      ("1D_GhostBombette",         "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_GhostBombette:DamageB":      ("1D_GhostBombette",         "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostBombette:DamageC":      ("1D_GhostBombette",         "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:1D_GhostParakarry:Level":       ("1D_GhostParakarry",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostParakarry:HP":          ("1D_GhostParakarry",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostParakarry:DamageA":     ("1D_GhostParakarry",        "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_GhostParakarry:DamageB":     ("1D_GhostParakarry",        "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostParakarry:DamageC":     ("1D_GhostParakarry",        "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:1D_GhostBow:Level":             ("1D_GhostBow",              "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostBow:HP":                ("1D_GhostBow",              "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostBow:DamageA":           ("1D_GhostBow",              "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1D_GhostBow:DamageB":           ("1D_GhostBow",              "DamageB",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1D_GhostBow:DamageC":           ("1D_GhostBow",              "DamageC",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1D_GhostWatt:Level":            ("1D_GhostWatt",             "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostWatt:HP":               ("1D_GhostWatt",             "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostWatt:DamageA":          ("1D_GhostWatt",             "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostWatt:DamageB":          ("1D_GhostWatt",             "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:1D_GhostWatt:DamageC":          ("1D_GhostWatt",             "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:1D_GhostSushie:Level":          ("1D_GhostSushie",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostSushie:HP":             ("1D_GhostSushie",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostSushie:DamageA":        ("1D_GhostSushie",           "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostSushie:DamageB":        ("1D_GhostSushie",           "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:1D_GhostSushie:DamageC":        ("1D_GhostSushie",           "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:1D_GhostLakilester:Level":      ("1D_GhostLakilester",       "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:1D_GhostLakilester:HP":         ("1D_GhostLakilester",       "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:1D_GhostLakilester:DamageA":    ("1D_GhostLakilester",       "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:1D_GhostLakilester:DamageB":    ("1D_GhostLakilester",       "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:1D_GhostLakilester:DamageC":    ("1D_GhostLakilester",       "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:1D_Gulpit:Level":               ("1D_Gulpit",                "Level",            22,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1D_Gulpit:HP":                  ("1D_Gulpit",                "HP",               12,     7,      6,      7,      8,      9,      11,     12,     13,    14),
    ".DBKey:1D_Gulpit:DamageA":             ("1D_Gulpit",                "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_Gulpit:DamageB":             ("1D_Gulpit",                "DamageB",          7,      7,      4,      5,      5,      6,      6,      7,      7,     8),
    ".DBKey:1D_Gulpit:DamageC":             ("1D_Gulpit",                "DamageC",          5,      7,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1D_GulpitRocks:Level":          ("1D_GulpitRocks",           "Level",            0,      7,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:1D_GulpitRocks:HP":             ("1D_GulpitRocks",           "HP",               1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1D_WhiteClubba:Level":          ("1D_WhiteClubba",           "Level",            23,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1D_WhiteClubba:HP":             ("1D_WhiteClubba",           "HP",               12,     7,      3,      4,      6,      7,      9,      10,     12,    13),
    ".DBKey:1D_WhiteClubba:DamageA":        ("1D_WhiteClubba",           "DamageA",          5,      7,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1D_WhiteClubba:DamageB":        ("1D_WhiteClubba",           "DamageB",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1D_FrostPiranha:Level":         ("1D_FrostPiranha",          "Level",            22,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1D_FrostPiranha:HP":            ("1D_FrostPiranha",          "HP",               10,     7,      2,      3,      5,      6,      7,      8,      10,    11),
    ".DBKey:1D_FrostPiranha:DamageA":       ("1D_FrostPiranha",          "DamageA",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1D_GRYMagikoopa:Level":         ("1D_GRYMagikoopa",          "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1D_GRYMagikoopa:HP":            ("1D_GRYMagikoopa",          "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1D_GRYMagikoopa:DamageA":       ("1D_GRYMagikoopa",          "DamageA",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1D_GRYMagikoopa:DamageB":       ("1D_GRYMagikoopa",          "DamageB",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1D_FlyingGRYMagikoopa:Level":   ("1D_FlyingGRYMagikoopa",    "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1D_FlyingGRYMagikoopa:HP":      ("1D_FlyingGRYMagikoopa",    "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1E_Monstar:Level":              ("1E_Monstar",               "Level",            45,     7,      35,     37,     39,     41,     44,     46,     48,    50),
    ".DBKey:1E_Monstar:HP":                 ("1E_Monstar",               "HP",               20,     7,      10,     12,     14,     16,     18,     20,     22,    24),
    ".DBKey:1E_Monstar:DamageA":            ("1E_Monstar",               "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:1E_Paragoomba:Level":           ("1E_Paragoomba",            "Level",            6,      1,      4,      7,      9,      12,     14,     17,     19,    22),
    ".DBKey:1E_Paragoomba:HP":              ("1E_Paragoomba",            "HP",               2,      1,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:1E_Paragoomba:DamageA":         ("1E_Paragoomba",            "DamageA",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1E_Paragoomba:DamageB":         ("1E_Paragoomba",            "DamageB",          1,      1,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1E_GRYMagikoopa:Level":         ("1E_GRYMagikoopa",          "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1E_GRYMagikoopa:HP":            ("1E_GRYMagikoopa",          "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1E_GRYMagikoopa:DamageA":       ("1E_GRYMagikoopa",          "DamageA",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1E_GRYMagikoopa:DamageB":       ("1E_GRYMagikoopa",          "DamageB",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1E_FlyingGRYMagikoopa:Level":   ("1E_FlyingGRYMagikoopa",    "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1E_FlyingGRYMagikoopa:HP":      ("1E_FlyingGRYMagikoopa",    "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_Swoopula:Level":             ("1F_Swoopula",              "Level",            22,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1F_Swoopula:HP":                ("1F_Swoopula",              "HP",               8,      7,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:1F_Swoopula:DamageA":           ("1F_Swoopula",              "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1F_AlbinoDino:Level":           ("1F_AlbinoDino",            "Level",            23,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1F_AlbinoDino:HP":              ("1F_AlbinoDino",            "HP",               8,      7,      4,      5,      5,      6,      7,      8,      8,     9),
    ".DBKey:1F_AlbinoDino:DamageA":         ("1F_AlbinoDino",            "DamageA",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_WhiteClubba:Level":          ("1F_WhiteClubba",           "Level",            23,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1F_WhiteClubba:HP":             ("1F_WhiteClubba",           "HP",               12,     7,      3,      4,      6,      7,      9,      10,     12,    13),
    ".DBKey:1F_WhiteClubba:DamageA":        ("1F_WhiteClubba",           "DamageA",          5,      7,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:1F_WhiteClubba:DamageB":        ("1F_WhiteClubba",           "DamageB",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:1F_RMagikoopa:Level":           ("1F_RMagikoopa",            "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_RMagikoopa:HP":              ("1F_RMagikoopa",            "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_RMagikoopa:DamageA":         ("1F_RMagikoopa",            "DamageA",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_RMagikoopa:DamageB":         ("1F_RMagikoopa",            "DamageB",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_FlyingRMagikoopa:Level":     ("1F_FlyingRMagikoopa",      "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_FlyingRMagikoopa:HP":        ("1F_FlyingRMagikoopa",      "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_GRNMagikoopa:Level":         ("1F_GRNMagikoopa",          "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_GRNMagikoopa:HP":            ("1F_GRNMagikoopa",          "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_GRNMagikoopa:DamageA":       ("1F_GRNMagikoopa",          "DamageA",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_GRNMagikoopa:DamageB":       ("1F_GRNMagikoopa",          "DamageB",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_FlyingGRNMagikoopa:Level":   ("1F_FlyingGRNMagikoopa",    "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_FlyingGRNMagikoopa:HP":      ("1F_FlyingGRNMagikoopa",    "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_YMagikoopa:Level":           ("1F_YMagikoopa",            "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_YMagikoopa:HP":              ("1F_YMagikoopa",            "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_YMagikoopa:DamageA":         ("1F_YMagikoopa",            "DamageA",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_YMagikoopa:DamageB":         ("1F_YMagikoopa",            "DamageB",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:1F_FlyingYMagikoopa:Level":     ("1F_FlyingYMagikoopa",      "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:1F_FlyingYMagikoopa:HP":        ("1F_FlyingYMagikoopa",      "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_GRYMagikoopa:Level":         ("1F_GRYMagikoopa",          "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1F_GRYMagikoopa:HP":            ("1F_GRYMagikoopa",          "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_GRYMagikoopa:DamageA":       ("1F_GRYMagikoopa",          "DamageA",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1F_GRYMagikoopa:DamageB":       ("1F_GRYMagikoopa",          "DamageB",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1F_FlyingGRYMagikoopa:Level":   ("1F_FlyingGRYMagikoopa",    "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:1F_FlyingGRYMagikoopa:HP":      ("1F_FlyingGRYMagikoopa",    "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_WMagikoopa:Level":           ("1F_WMagikoopa",            "Level",            21,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1F_WMagikoopa:HP":              ("1F_WMagikoopa",            "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:1F_WMagikoopa:DamageA":         ("1F_WMagikoopa",            "DamageA",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1F_WMagikoopa:DamageB":         ("1F_WMagikoopa",            "DamageB",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:1F_FlyingWMagikoopa:Level":     ("1F_FlyingWMagikoopa",      "Level",            21,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:1F_FlyingWMagikoopa:HP":        ("1F_FlyingWMagikoopa",      "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:20_CrystalKing:Level":          ("20_CrystalKing",           "Level",            85,     7,      55,     60,     65,     70,     75,     80,     85,    90),
    ".DBKey:20_CrystalKing:HP":             ("20_CrystalKing",           "HP",               70,     7,      20,     30,     35,     45,     55,     65,     70,    80),
    ".DBKey:20_CrystalKing:DamageA":        ("20_CrystalKing",           "DamageA",          8,      7,      2,      3,      4,      5,      6,      7,      8,     9),
    ".DBKey:20_CrystalKing:DamageB":        ("20_CrystalKing",           "DamageB",          8,      7,      2,      3,      4,      5,      6,      7,      8,     9),
    ".DBKey:20_CrystalKing:DamageC":        ("20_CrystalKing",           "DamageC",          6,      7,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:20_CrystalKing:DamageD":        ("20_CrystalKing",           "DamageD",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:20_CrystalKing:Heal":           ("20_CrystalKing",           "Heal",             20,     7,      6,      8,      10,     12,     16,     18,     20,    22),
    ".DBKey:20_CrystalClone:Level":         ("20_CrystalClone",          "Level",            0,      7,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:20_CrystalClone:HP":            ("20_CrystalClone",          "HP",               70,     7,      25,     33,     41,     49,     56,     64,     72,    80),
    ".DBKey:20_CrystalBitA:Level":          ("20_CrystalBitA",           "Level",            0,      7,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:20_CrystalBitA:HP":             ("20_CrystalBitA",           "HP",               1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:20_CrystalBitB:Level":          ("20_CrystalBitB",           "Level",            0,      7,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:20_CrystalBitB:HP":             ("20_CrystalBitB",           "HP",               1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:20_CrystalBitC:Level":          ("20_CrystalBitC",           "Level",            0,      7,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:20_CrystalBitC:HP":             ("20_CrystalBitC",           "HP",               1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:21_Duplighost:Level":           ("21_Duplighost",            "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_Duplighost:HP":              ("21_Duplighost",            "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_Duplighost:DamageA":         ("21_Duplighost",            "DamageA",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:21_GhostGoombario:Level":       ("21_GhostGoombario",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostGoombario:HP":          ("21_GhostGoombario",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostGoombario:DamageA":     ("21_GhostGoombario",        "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:21_GhostGoombario:DamageB":     ("21_GhostGoombario",        "DamageB",          2,      7,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:21_GhostGoombario:DamageC":     ("21_GhostGoombario",        "DamageC",          3,      7,      3,      3,      3,      3,      3,      3,      3,     3),
    ".DBKey:21_GhostKooper:Level":          ("21_GhostKooper",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostKooper:HP":             ("21_GhostKooper",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostKooper:DamageA":        ("21_GhostKooper",           "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:21_GhostKooper:DamageB":        ("21_GhostKooper",           "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostKooper:DamageC":        ("21_GhostKooper",           "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:21_GhostBombette:Level":        ("21_GhostBombette",         "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostBombette:HP":           ("21_GhostBombette",         "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostBombette:DamageA":      ("21_GhostBombette",         "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:21_GhostBombette:DamageB":      ("21_GhostBombette",         "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostBombette:DamageC":      ("21_GhostBombette",         "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:21_GhostParakarry:Level":       ("21_GhostParakarry",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostParakarry:HP":          ("21_GhostParakarry",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostParakarry:DamageA":     ("21_GhostParakarry",        "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:21_GhostParakarry:DamageB":     ("21_GhostParakarry",        "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostParakarry:DamageC":     ("21_GhostParakarry",        "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:21_GhostBow:Level":             ("21_GhostBow",              "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostBow:HP":                ("21_GhostBow",              "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostBow:DamageA":           ("21_GhostBow",              "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:21_GhostBow:DamageB":           ("21_GhostBow",              "DamageB",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:21_GhostBow:DamageC":           ("21_GhostBow",              "DamageC",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:21_GhostWatt:Level":            ("21_GhostWatt",             "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostWatt:HP":               ("21_GhostWatt",             "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostWatt:DamageA":          ("21_GhostWatt",             "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostWatt:DamageB":          ("21_GhostWatt",             "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:21_GhostWatt:DamageC":          ("21_GhostWatt",             "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:21_GhostSushie:Level":          ("21_GhostSushie",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostSushie:HP":             ("21_GhostSushie",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostSushie:DamageA":        ("21_GhostSushie",           "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostSushie:DamageB":        ("21_GhostSushie",           "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:21_GhostSushie:DamageC":        ("21_GhostSushie",           "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:21_GhostLakilester:Level":      ("21_GhostLakilester",       "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:21_GhostLakilester:HP":         ("21_GhostLakilester",       "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:21_GhostLakilester:DamageA":    ("21_GhostLakilester",       "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:21_GhostLakilester:DamageB":    ("21_GhostLakilester",       "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:21_GhostLakilester:DamageC":    ("21_GhostLakilester",       "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:21_Swoopula:Level":             ("21_Swoopula",              "Level",            22,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:21_Swoopula:HP":                ("21_Swoopula",              "HP",               8,      7,      2,      3,      4,      5,      5,      6,      7,     8),
    ".DBKey:21_Swoopula:DamageA":           ("21_Swoopula",              "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:21_WhiteClubba:Level":          ("21_WhiteClubba",           "Level",            23,     7,      6,      9,      11,     14,     16,     19,     21,    24),
    ".DBKey:21_WhiteClubba:HP":             ("21_WhiteClubba",           "HP",               12,     7,      3,      4,      6,      7,      9,      10,     12,    13),
    ".DBKey:21_WhiteClubba:DamageA":        ("21_WhiteClubba",           "DamageA",          5,      7,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:21_WhiteClubba:DamageB":        ("21_WhiteClubba",           "DamageB",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:21_RMagikoopa:Level":           ("21_RMagikoopa",            "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:21_RMagikoopa:HP":              ("21_RMagikoopa",            "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:21_RMagikoopa:DamageA":         ("21_RMagikoopa",            "DamageA",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:21_RMagikoopa:DamageB":         ("21_RMagikoopa",            "DamageB",          3,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:21_FlyingRMagikoopa:Level":     ("21_FlyingRMagikoopa",      "Level",            21,     7,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:21_FlyingRMagikoopa:HP":        ("21_FlyingRMagikoopa",      "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:21_GRYMagikoopa:Level":         ("21_GRYMagikoopa",          "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:21_GRYMagikoopa:HP":            ("21_GRYMagikoopa",          "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:21_GRYMagikoopa:DamageA":       ("21_GRYMagikoopa",          "DamageA",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:21_GRYMagikoopa:DamageB":       ("21_GRYMagikoopa",          "DamageB",          3,      7,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:21_FlyingGRYMagikoopa:Level":   ("21_FlyingGRYMagikoopa",    "Level",            21,     7,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:21_FlyingGRYMagikoopa:HP":      ("21_FlyingGRYMagikoopa",    "HP",               11,     7,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:24_Duplighost:Level":           ("24_Duplighost",            "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_Duplighost:HP":              ("24_Duplighost",            "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_Duplighost:DamageA":         ("24_Duplighost",            "DamageA",          4,      7,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:24_GhostGoombario:Level":       ("24_GhostGoombario",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostGoombario:HP":          ("24_GhostGoombario",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostGoombario:DamageA":     ("24_GhostGoombario",        "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:24_GhostGoombario:DamageB":     ("24_GhostGoombario",        "DamageB",          2,      7,      2,      2,      2,      2,      2,      2,      2,     2),
    ".DBKey:24_GhostGoombario:DamageC":     ("24_GhostGoombario",        "DamageC",          3,      7,      3,      3,      3,      3,      3,      3,      3,     3),
    ".DBKey:24_GhostKooper:Level":          ("24_GhostKooper",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostKooper:HP":             ("24_GhostKooper",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostKooper:DamageA":        ("24_GhostKooper",           "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:24_GhostKooper:DamageB":        ("24_GhostKooper",           "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostKooper:DamageC":        ("24_GhostKooper",           "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:24_GhostBombette:Level":        ("24_GhostBombette",         "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostBombette:HP":           ("24_GhostBombette",         "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostBombette:DamageA":      ("24_GhostBombette",         "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:24_GhostBombette:DamageB":      ("24_GhostBombette",         "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostBombette:DamageC":      ("24_GhostBombette",         "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:24_GhostParakarry:Level":       ("24_GhostParakarry",        "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostParakarry:HP":          ("24_GhostParakarry",        "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostParakarry:DamageA":     ("24_GhostParakarry",        "DamageA",          2,      7,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:24_GhostParakarry:DamageB":     ("24_GhostParakarry",        "DamageB",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostParakarry:DamageC":     ("24_GhostParakarry",        "DamageC",          5,      7,      3,      3,      4,      4,      4,      4,      5,     5),
    ".DBKey:24_GhostBow:Level":             ("24_GhostBow",              "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostBow:HP":                ("24_GhostBow",              "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostBow:DamageA":           ("24_GhostBow",              "DamageA",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:24_GhostBow:DamageB":           ("24_GhostBow",              "DamageB",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:24_GhostBow:DamageC":           ("24_GhostBow",              "DamageC",          1,      7,      1,      1,      1,      1,      1,      1,      1,     1),
    ".DBKey:24_GhostWatt:Level":            ("24_GhostWatt",             "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostWatt:HP":               ("24_GhostWatt",             "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostWatt:DamageA":          ("24_GhostWatt",             "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostWatt:DamageB":          ("24_GhostWatt",             "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:24_GhostWatt:DamageC":          ("24_GhostWatt",             "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:24_GhostSushie:Level":          ("24_GhostSushie",           "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostSushie:HP":             ("24_GhostSushie",           "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostSushie:DamageA":        ("24_GhostSushie",           "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostSushie:DamageB":        ("24_GhostSushie",           "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:24_GhostSushie:DamageC":        ("24_GhostSushie",           "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:24_GhostLakilester:Level":      ("24_GhostLakilester",       "Level",            23,     7,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:24_GhostLakilester:HP":         ("24_GhostLakilester",       "HP",               15,     7,      4,      6,      7,      9,      10,     12,     13,    15),
    ".DBKey:24_GhostLakilester:DamageA":    ("24_GhostLakilester",       "DamageA",          3,      7,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:24_GhostLakilester:DamageB":    ("24_GhostLakilester",       "DamageB",          4,      7,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:24_GhostLakilester:DamageC":    ("24_GhostLakilester",       "DamageC",          5,      7,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:25_BombshellBlaster:Level":     ("25_BombshellBlaster",      "Level",            27,     8,      6,      9,      11,     14,     17,     20,     22,    25),
    ".DBKey:25_BombshellBlaster:HP":        ("25_BombshellBlaster",      "HP",               10,     8,      3,      4,      5,      6,      7,      8,      9,     10),
    ".DBKey:25_BombshellBill:Level":        ("25_BombshellBill",         "Level",            24,     8,      5,      8,      10,     13,     16,     19,     21,    24),
    ".DBKey:25_BombshellBill:HP":           ("25_BombshellBill",         "HP",               3,      8,      1,      1,      2,      2,      2,      2,      3,     3),
    ".DBKey:25_BombshellBill:DamageA":      ("25_BombshellBill",         "DamageA",          6,      8,      3,      3,      4,      4,      5,      5,      6,     6),
    ".DBKey:25_Magiclone:Level":            ("25_Magiclone",             "Level",            26,     8,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:25_Magiclone:HP":               ("25_Magiclone",             "HP",               11,     8,      8,      10,     13,     15,     17,     19,     22,    24),
    ".DBKey:25_FlyingMagiclone:Level":      ("25_FlyingMagiclone",       "Level",            26,     8,      30,     33,     36,     39,     41,     44,     47,    50),
    ".DBKey:25_FlyingMagiclone:HP":         ("25_FlyingMagiclone",       "HP",               11,     8,      8,      10,     13,     15,     17,     19,     22,    24),
    ".DBKey:2A_StiltGuy:Level":             ("2A_StiltGuy",              "Level",            0,      4,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:2A_StiltGuy:HP":                ("2A_StiltGuy",              "HP",               7,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:2A_StiltGuy:DamageA":           ("2A_StiltGuy",              "DamageA",          4,      4,      2,      3,      3,      4,      5,      6,      6,     7),
    ".DBKey:2A_StiltGuy:DamageB":           ("2A_StiltGuy",              "DamageB",          2,      4,      1,      1,      2,      2,      3,      3,      4,     4),
    ".DBKey:2A_StiltGuy:DamageC":           ("2A_StiltGuy",              "DamageC",          3,      4,      2,      2,      3,      3,      4,      4,      5,     5),
    ".DBKey:2B_ShyStack:Level":             ("2B_ShyStack",              "Level",            0,      4,      0,      0,      0,      0,      0,      0,      0,     0),
    ".DBKey:2B_ShyStack:HP":                ("2B_ShyStack",              "HP",               10,     4,      6,      7,      9,      10,     12,     13,     15,    16),
    ".DBKey:2B_ShyStack:DamageA":           ("2B_ShyStack",              "DamageA",          1,      4,      1,      1,      1,      1,      2,      2,      2,     2),
    ".DBKey:2B_ShyStack:DamageB":           ("2B_ShyStack",              "DamageB",          2,      4,      2,      2,      2,      2,      3,      3,      3,     3),
    ".DBKey:2B_ShyStack:DamageC":           ("2B_ShyStack",              "DamageC",          3,      4,      3,      3,      3,      3,      4,      4,      4,     4),
    ".DBKey:2B_ShyStack:DamageD":           ("2B_ShyStack",              "DamageD",          4,      4,      4,      4,      4,      4,      5,      5,      5,     5),
    ".DBKey:2C_ShyGuy:Level":               ("2C_ShyGuy",                "Level",            0,      4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:2C_ShyGuy:HP":                  ("2C_ShyGuy",                "HP",               8,      4,      4,      5,      6,      7,      9,      10,     11,    12),
    ".DBKey:2E_ShyGuy:Level":               ("2E_ShyGuy",                "Level",            0,      4,      5,      8,      10,     13,     15,     18,     20,    23),
    ".DBKey:2E_ShyGuy:HP":                  ("2E_ShyGuy",                "HP",               10,     4,      4,      5,      6,      7,      9,      10,     11,    12)
}


def get_actor_attr_key(dex):
    return (0xA2 << 24) | (actor_attr_table[dex][0] << 16) | (actor_attr_table[dex][1] << 8) | actor_attr_table[dex][2]


#  id       areaID actorID index      actor name                 attribute         value
actor_attr_table = {
    0:      (0,      0,      0,      "00_Goomba",                "Level",            5),
    1:      (0,      0,      1,      "00_Goomba",                "HP",               2),
    2:      (0,      0,      2,      "00_Goomba",                "DamageA",          1),
    3:      (0,      1,      0,      "00_Paragoomba",            "Level",            6),
    4:      (0,      1,      1,      "00_Paragoomba",            "HP",               2),
    5:      (0,      1,      2,      "00_Paragoomba",            "DamageA",          1),
    6:      (0,      2,      0,      "00_SpikedGoomba",          "Level",            6),
    7:      (0,      2,      1,      "00_SpikedGoomba",          "HP",               2),
    8:      (0,      2,      2,      "00_SpikedGoomba",          "DamageA",          2),
    9:      (1,      0,      0,      "01_BlueGoomba1",           "Level",            20),
    10:     (1,      0,      1,      "01_BlueGoomba1",           "HP",               6),
    11:     (1,      0,      2,      "01_BlueGoomba1",           "DamageA",          1),
    12:     (1,      1,      0,      "01_RedGoomba1",            "Level",            20),
    13:     (1,      1,      1,      "01_RedGoomba1",            "HP",               7),
    14:     (1,      1,      2,      "01_RedGoomba1",            "DamageA",          1),
    15:     (1,      2,      0,      "01_BlueGoomba2",           "Level",            20),
    16:     (1,      2,      1,      "01_BlueGoomba2",           "HP",               6),
    17:     (1,      2,      2,      "01_BlueGoomba2",           "DamageA",          1),
    18:     (1,      3,      0,      "01_RedGoomba2",            "Level",            20),
    19:     (1,      3,      1,      "01_RedGoomba2",            "HP",               7),
    20:     (1,      3,      2,      "01_RedGoomba2",            "DamageA",          1),
    21:     (1,      4,      0,      "01_GoombaKing",            "Level",            49),
    22:     (1,      4,      1,      "01_GoombaKing",            "HP",               10),
    23:     (1,      4,      2,      "01_GoombaKing",            "DamageA",          1),
    24:     (1,      4,      3,      "01_GoombaKing",            "DamageB",          2),
    25:     (1,      5,      2,      "01_GoomnutTree",           "DamageA",          3),
    26:     (1,      5,      3,      "01_GoomnutTree",           "DamageB",          3),
    27:     (1,      5,      4,      "01_GoomnutTree",           "DamageC",          3),
    28:     (2,      0,      0,      "02_SpikedGoomba",          "Level",            6),
    29:     (2,      0,      1,      "02_SpikedGoomba",          "HP",               2),
    30:     (2,      0,      2,      "02_SpikedGoomba",          "DamageA",          2),
    31:     (2,      1,      0,      "02_ParagoombaA",           "Level",            6),
    32:     (2,      1,      1,      "02_ParagoombaA",           "HP",               2),
    33:     (2,      1,      2,      "02_ParagoombaA",           "DamageA",          1),
    34:     (2,      1,      3,      "02_GoombaA",               "DamageA",          1),
    35:     (2,      2,      0,      "02_ParagoombaB",           "Level",            6),
    36:     (2,      2,      1,      "02_ParagoombaB",           "HP",               2),
    37:     (2,      2,      2,      "02_ParagoombaB",           "DamageA",          1),
    38:     (2,      2,      3,      "02_GoombaB",               "DamageA",          1),
    39:     (2,      3,      0,      "02_JrTroopa1",             "Level",            41),
    40:     (2,      3,      1,      "02_JrTroopa1",             "HP",               5),
    41:     (2,      3,      2,      "02_JrTroopa1",             "DamageA",          1),
    42:     (2,      3,      3,      "02_JrTroopa1",             "DamageB",          2),
    43:     (2,      4,      0,      "02_JrTroopa2",             "Level",            44),
    44:     (2,      4,      1,      "02_JrTroopa2",             "HP",               15),
    45:     (2,      4,      2,      "02_JrTroopa2",             "DamageA",          2),
    46:     (2,      5,      0,      "02_JrTroopa3",             "Level",            52),
    47:     (2,      5,      1,      "02_JrTroopa3",             "HP",               40),
    48:     (2,      5,      2,      "02_JrTroopa3",             "DamageA",          5),
    49:     (2,      6,      0,      "02_JrTroopa4",             "Level",            59),
    50:     (2,      6,      1,      "02_JrTroopa4",             "HP",               40),
    51:     (2,      6,      2,      "02_JrTroopa4",             "DamageA",          6),
    52:     (2,      7,      0,      "02_JrTroopa5",             "Level",            65),
    53:     (2,      7,      1,      "02_JrTroopa5",             "HP",               50),
    54:     (2,      7,      2,      "02_JrTroopa5",             "DamageA",          8),
    55:     (2,      8,      0,      "02_JrTroopa6",             "Level",            74),
    56:     (2,      8,      1,      "02_JrTroopa6",             "HP",               60),
    57:     (2,      8,      2,      "02_JrTroopa6",             "DamageA",          8),
    58:     (2,      8,      3,      "02_JrTroopa6",             "DamageB",          8),
    59:     (2,      8,      4,      "02_JrTroopa6",             "DamageC",          9),
    60:     (2,      8,      5,      "02_JrTroopa6",             "DamageD",          8),
    61:     (2,      8,      6,      "02_JrTroopa6",             "DamageE",          9),
    62:     (3,      0,      0,      "03_Chan",                  "Level",            40),
    63:     (3,      0,      1,      "03_Chan",                  "HP",               15),
    64:     (3,      0,      2,      "03_Chan",                  "DamageA",          2),
    65:     (3,      0,      3,      "03_Chan",                  "DamageB",          3),
    66:     (3,      1,      0,      "03_Lee",                   "Level",            50),
    67:     (3,      1,      1,      "03_Lee",                   "HP",               20),
    68:     (3,      1,      2,      "03_Lee",                   "DamageA",          5),
    69:     (3,      2,      0,      "03_LeeGoombario",          "Level",            50),
    70:     (3,      2,      1,      "03_LeeGoombario",          "HP",               20),
    71:     (3,      2,      2,      "03_LeeGoombario",          "Damage1",          1),
    72:     (3,      2,      3,      "03_LeeGoombario",          "Damage2",          2),
    73:     (3,      2,      4,      "03_LeeGoombario",          "Damage3",          3),
    74:     (3,      3,      0,      "03_LeeKooper",             "Level",            50),
    75:     (3,      3,      1,      "03_LeeKooper",             "HP",               20),
    76:     (3,      3,      2,      "03_LeeKooper",             "Damage1",          2),
    77:     (3,      3,      3,      "03_LeeKooper",             "Damage2",          3),
    78:     (3,      3,      4,      "03_LeeKooper",             "Damage3",          5),
    79:     (3,      4,      0,      "03_LeeBombette",           "Level",            50),
    80:     (3,      4,      1,      "03_LeeBombette",           "HP",               20),
    81:     (3,      4,      2,      "03_LeeBombette",           "Damage1",          2),
    82:     (3,      4,      3,      "03_LeeBombette",           "Damage2",          3),
    83:     (3,      4,      4,      "03_LeeBombette",           "Damage3",          5),
    84:     (3,      5,      0,      "03_LeeParakarry",          "Level",            50),
    85:     (3,      5,      1,      "03_LeeParakarry",          "HP",               20),
    86:     (3,      5,      2,      "03_LeeParakarry",          "Damage1",          2),
    87:     (3,      5,      3,      "03_LeeParakarry",          "Damage2",          3),
    88:     (3,      5,      4,      "03_LeeParakarry",          "Damage3",          5),
    89:     (3,      6,      0,      "03_LeeBow",                "Level",            50),
    90:     (3,      6,      1,      "03_LeeBow",                "HP",               20),
    91:     (3,      6,      2,      "03_LeeBow",                "Damage1",          1),
    92:     (3,      6,      3,      "03_LeeBow",                "Damage2",          1),
    93:     (3,      6,      4,      "03_LeeBow",                "Damage3",          1),
    94:     (3,      7,      0,      "03_LeeWatt",               "Level",            50),
    95:     (3,      7,      1,      "03_LeeWatt",               "HP",               20),
    96:     (3,      7,      2,      "03_LeeWatt",               "Damage1",          3),
    97:     (3,      7,      3,      "03_LeeWatt",               "Damage2",          4),
    98:     (3,      7,      4,      "03_LeeWatt",               "Damage3",          5),
    99:     (3,      8,      0,      "03_LeeSushie",             "Level",            50),
    100:    (3,      8,      1,      "03_LeeSushie",             "HP",               20),
    101:    (3,      8,      2,      "03_LeeSushie",             "Damage1",          3),
    102:    (3,      8,      3,      "03_LeeSushie",             "Damage2",          4),
    103:    (3,      8,      4,      "03_LeeSushie",             "Damage3",          5),
    104:    (3,      9,      0,      "03_LeeLakilester",         "Level",            50),
    105:    (3,      9,      1,      "03_LeeLakilester",         "HP",               20),
    106:    (3,      9,      2,      "03_LeeLakilester",         "Damage1",          3),
    107:    (3,      9,      3,      "03_LeeLakilester",         "Damage2",          4),
    108:    (3,      9,      4,      "03_LeeLakilester",         "Damage3",          5),
    109:    (3,      10,     0,      "03_TheMaster1",            "Level",            70),
    110:    (3,      10,     1,      "03_TheMaster1",            "HP",               50),
    111:    (3,      10,     2,      "03_TheMaster1",            "DamageA",          6),
    112:    (3,      11,     0,      "03_TheMaster2",            "Level",            85),
    113:    (3,      11,     1,      "03_TheMaster2",            "HP",               75),
    114:    (3,      11,     2,      "03_TheMaster2",            "DamageA",          8),
    115:    (3,      11,     3,      "03_TheMaster2",            "DamageB",          5),
    116:    (3,      11,     4,      "03_TheMaster2",            "DamageC",          6),
    117:    (3,      12,     0,      "03_TheMaster3",            "Level",            100),
    118:    (3,      12,     1,      "03_TheMaster3",            "HP",               99),
    119:    (3,      12,     2,      "03_TheMaster3",            "DamageA",          10),
    120:    (3,      12,     3,      "03_TheMaster3",            "DamageB",          6),
    121:    (3,      12,     4,      "03_TheMaster3",            "DamageC",          7),
    122:    (3,      12,     5,      "03_TheMaster3",            "DamageD",          5),
    123:    (3,      12,     6,      "03_TheMaster3",            "DamageE",          6),
    124:    (3,      12,     7,      "03_TheMaster3",            "DamageF",          7),
    125:    (4,      1,      0,      "04_Ember",                 "Level",            24),
    126:    (4,      1,      1,      "04_Ember",                 "HP",               10),
    127:    (4,      1,      2,      "04_Ember",                 "DamageA",          4),
    128:    (4,      1,      3,      "04_Ember",                 "DamageB",          3),
    129:    (4,      1,      4,      "04_Ember",                 "DamageC",          4),
    130:    (4,      2,      0,      "04_Magikoopa",             "Level",            32),
    131:    (4,      2,      1,      "04_Magikoopa",             "HP",               8),
    132:    (4,      2,      2,      "04_Magikoopa",             "DamageA",          3),
    133:    (4,      3,      0,      "04_FlyingMagikoopa",       "Level",            32),
    134:    (4,      3,      1,      "04_FlyingMagikoopa",       "HP",               8),
    135:    (4,      4,      0,      "04_Magiclone",             "Level",            26),
    136:    (4,      4,      1,      "04_Magiclone",             "HP",               11),
    137:    (4,      5,      0,      "04_FlyingMagiclone",       "Level",            26),
    138:    (4,      5,      1,      "04_FlyingMagiclone",       "HP",               11),
    139:    (5,      0,      0,      "05_Goomba",                "Level",            5),
    140:    (5,      0,      1,      "05_Goomba",                "HP",               2),
    141:    (5,      0,      2,      "05_Goomba",                "DamageA",          1),
    142:    (5,      1,      0,      "05_Paragoomba",            "Level",            6),
    143:    (5,      1,      1,      "05_Paragoomba",            "HP",               2),
    144:    (5,      1,      2,      "05_Paragoomba",            "DamageA",          1),
    145:    (5,      2,      0,      "05_SpikedGoomba",          "Level",            6),
    146:    (5,      2,      1,      "05_SpikedGoomba",          "HP",               2),
    147:    (5,      2,      2,      "05_SpikedGoomba",          "DamageA",          2),
    148:    (5,      3,      0,      "05_KoopaTroopa",           "Level",            6),
    149:    (5,      3,      1,      "05_KoopaTroopa",           "HP",               4),
    150:    (5,      3,      2,      "05_KoopaTroopa",           "DamageA",          1),
    151:    (5,      4,      0,      "05_Fuzzy",                 "Level",            6),
    152:    (5,      4,      1,      "05_Fuzzy",                 "HP",               3),
    153:    (5,      4,      2,      "05_Fuzzy",                 "DamageA",          1),
    154:    (5,      5,      0,      "05_Paratroopa",            "Level",            6),
    155:    (5,      5,      1,      "05_Paratroopa",            "HP",               4),
    156:    (5,      5,      2,      "05_Paratroopa",            "DamageA",          1),
    157:    (5,      6,      0,      "05_KentC",                 "Level",            55),
    158:    (5,      6,      1,      "05_KentC",                 "HP",               70),
    159:    (5,      6,      2,      "05_KentC",                 "DamageA",          3),
    160:    (5,      6,      3,      "05_KentC",                 "DamageB",          3),
    161:    (5,      6,      4,      "05_KentC",                 "DamageC",          10),
    162:    (6,      0,      0,      "06_BulletBill",            "Level",            5),
    163:    (6,      0,      1,      "06_BulletBill",            "HP",               2),
    164:    (6,      0,      2,      "06_BulletBill",            "DamageA",          2),
    165:    (6,      1,      0,      "06_BillBlaster",           "Level",            10),
    166:    (6,      1,      1,      "06_BillBlaster",           "HP",               4),
    167:    (6,      2,      0,      "06_Bobomb",                "Level",            6),
    168:    (6,      2,      1,      "06_Bobomb",                "HP",               3),
    169:    (6,      2,      2,      "06_Bobomb",                "DamageA",          1),
    170:    (6,      2,      3,      "06_Bobomb",                "DamageB",          2),
    171:    (6,      3,      0,      "06_KoopaTroopa",           "Level",            6),
    172:    (6,      3,      1,      "06_KoopaTroopa",           "HP",               4),
    173:    (6,      3,      2,      "06_KoopaTroopa",           "DamageA",          1),
    174:    (6,      4,      0,      "06_Paratroopa",            "Level",            6),
    175:    (6,      4,      1,      "06_Paratroopa",            "HP",               4),
    176:    (6,      4,      2,      "06_Paratroopa",            "DamageA",          1),
    177:    (7,      0,      0,      "07_FakeBowser",            "Level",            0),
    178:    (7,      0,      1,      "07_FakeBowser",            "HP",               10),
    179:    (7,      0,      2,      "07_FakeBowser",            "DamageA",          1),
    180:    (7,      0,      3,      "07_KoopaBrosTower",        "Increment",        1),
    181:    (7,      1,      0,      "07_GNinjakoopa",           "Level",            16),
    182:    (7,      1,      1,      "07_GNinjakoopa",           "HP",               5),
    183:    (7,      1,      2,      "07_GNinjakoopa",           "DamageA",          1),
    184:    (7,      2,      0,      "07_RNinjakoopa",           "Level",            17),
    185:    (7,      2,      1,      "07_RNinjakoopa",           "HP",               5),
    186:    (7,      2,      2,      "07_RNinjakoopa",           "DamageA",          1),
    187:    (7,      3,      0,      "07_BNinjakoopa",           "Level",            17),
    188:    (7,      3,      1,      "07_BNinjakoopa",           "HP",               5),
    189:    (7,      3,      2,      "07_BNinjakoopa",           "DamageA",          1),
    190:    (7,      4,      0,      "07_YNinjakoopa",           "Level",            16),
    191:    (7,      4,      1,      "07_YNinjakoopa",           "HP",               5),
    192:    (7,      4,      2,      "07_YNinjakoopa",           "DamageA",          1),
    193:    (9,      0,      0,      "09_Cleft",                 "Level",            10),
    194:    (9,      0,      1,      "09_Cleft",                 "HP",               2),
    195:    (9,      0,      2,      "09_Cleft",                 "DamageA",          2),
    196:    (9,      1,      0,      "09_MontyMole",             "Level",            8),
    197:    (9,      1,      1,      "09_MontyMole",             "HP",               3),
    198:    (9,      1,      2,      "09_MontyMole",             "DamageA",          2),
    199:    (9,      2,      0,      "09_EmptyMoleHole",         "Level",            9),
    200:    (9,      2,      1,      "09_EmptyMoleHole",         "HP",               5),
    201:    (9,      3,      0,      "09_Buzzar",                "Level",            35),
    202:    (9,      3,      1,      "09_Buzzar",                "HP",               40),
    203:    (9,      3,      2,      "09_Buzzar",                "DamageA",          2),
    204:    (9,      3,      3,      "09_Buzzar",                "DamageB",          3),
    205:    (9,      3,      4,      "09_Buzzar",                "DamageC",          4),
    206:    (9,      3,      5,      "09_Buzzar",                "DamageD1",         1),
    207:    (9,      3,      6,      "09_Buzzar",                "DamageD2",         2),
    208:    (9,      3,      7,      "09_Buzzar",                "DamageD3",         3),
    209:    (9,      4,      0,      "09_WhackaA",               "Level",            0),
    210:    (9,      4,      1,      "09_WhackaA",               "HP",               99),
    211:    (9,      5,      0,      "09_WhackaB",               "Level",            0),
    212:    (9,      5,      1,      "09_WhackaB",               "HP",               99),
    213:    (9,      6,      0,      "09_WhackaC",               "Level",            0),
    214:    (9,      6,      1,      "09_WhackaC",               "HP",               99),
    215:    (10,     0,      0,      "0A_Pokey",                 "Level",            9),
    216:    (10,     0,      1,      "0A_Pokey",                 "HP",               4),
    217:    (10,     0,      2,      "0A_Pokey",                 "DamageA0",         2),
    218:    (10,     0,      3,      "0A_Pokey",                 "DamageA1",         2),
    219:    (10,     0,      4,      "0A_Pokey",                 "DamageA2",         2),
    220:    (10,     0,      5,      "0A_Pokey",                 "DamageB",          2),
    221:    (10,     0,      6,      "0A_Pokey",                 "DamageC",          2),
    222:    (10,     1,      0,      "0A_BanditA",               "Level",            9),
    223:    (10,     1,      1,      "0A_BanditA",               "HP",               5),
    224:    (10,     1,      2,      "0A_BanditA",               "DamageA",          2),
    225:    (10,     2,      0,      "0A_BanditB",               "Level",            9),
    226:    (10,     2,      1,      "0A_BanditB",               "HP",               5),
    227:    (11,     0,      0,      "0B_PokeyMummy",            "Level",            10),
    228:    (11,     0,      1,      "0B_PokeyMummy",            "HP",               4),
    229:    (11,     0,      2,      "0B_PokeyMummy",            "DamageA",          2),
    230:    (11,     0,      3,      "0B_PokeyMummy",            "DamageB",          2),
    231:    (11,     1,      0,      "0B_Swooper",               "Level",            10),
    232:    (11,     1,      1,      "0B_Swooper",               "HP",               4),
    233:    (11,     1,      2,      "0B_Swooper",               "DamageA",          2),
    234:    (11,     1,      3,      "0B_Swooper",               "DamageB",          2),
    235:    (11,     2,      0,      "0B_BuzzyBeetle",           "Level",            10),
    236:    (11,     2,      1,      "0B_BuzzyBeetle",           "HP",               3),
    237:    (11,     2,      2,      "0B_BuzzyBeetle",           "DamageA",          3),
    238:    (11,     2,      3,      "0B_BuzzyBeetle",           "DamageB",          2),
    239:    (11,     3,      0,      "0B_StoneChomp",            "Level",            14),
    240:    (11,     3,      1,      "0B_StoneChomp",            "HP",               4),
    241:    (11,     3,      2,      "0B_StoneChomp",            "DamageA",          3),
    242:    (12,     0,      0,      "0C_Chomp",                 "Level",            14),
    243:    (12,     0,      1,      "0C_Chomp",                 "HP",               4),
    244:    (12,     0,      2,      "0C_Chomp",                 "DamageA",          3),
    245:    (12,     1,      0,      "0C_Tutankoopa",            "Level",            55),
    246:    (12,     1,      1,      "0C_Tutankoopa",            "HP",               30),
    247:    (12,     1,      2,      "0C_Tutankoopa",            "DamageA",          3),
    248:    (12,     1,      3,      "0C_Tutankoopa",            "DamageB",          2),
    249:    (12,     1,      4,      "0C_Tutankoopa",            "DamageC",          2),
    250:    (12,     1,      5,      "0C_Tutankoopa",            "DamageD",          2),
    251:    (12,     1,      6,      "0C_Tutankoopa",            "DamageE",          2),
    252:    (13,     0,      0,      "0D_ForestFuzzy",           "Level",            11),
    253:    (13,     0,      1,      "0D_ForestFuzzy",           "HP",               6),
    254:    (13,     0,      2,      "0D_ForestFuzzy",           "DamageA",          1),
    255:    (13,     1,      0,      "0D_Bzzap",                 "Level",            19),
    256:    (13,     1,      1,      "0D_Bzzap",                 "HP",               3),
    257:    (13,     1,      2,      "0D_Bzzap",                 "DamageA",          6),
    258:    (13,     1,      3,      "0D_Bzzap",                 "DamageB",          1),
    259:    (13,     2,      0,      "0D_PiranhaPlant",          "Level",            11),
    260:    (13,     2,      1,      "0D_PiranhaPlant",          "HP",               5),
    261:    (13,     2,      2,      "0D_PiranhaPlant",          "DamageA",          3),
    262:    (14,     0,      0,      "0E_HyperGoomba",           "Level",            12),
    263:    (14,     0,      1,      "0E_HyperGoomba",           "HP",               7),
    264:    (14,     0,      2,      "0E_HyperGoomba",           "DamageA",          8),
    265:    (14,     0,      3,      "0E_HyperGoomba",           "DamageB",          1),
    266:    (14,     1,      0,      "0E_HyperParagoomba",       "Level",            12),
    267:    (14,     1,      1,      "0E_HyperParagoomba",       "HP",               7),
    268:    (14,     1,      2,      "0E_HyperParagoomba",       "DamageA",          8),
    269:    (14,     1,      3,      "0E_HyperParagoomba",       "DamageB",          1),
    270:    (14,     2,      0,      "0E_HyperCleft",            "Level",            15),
    271:    (14,     2,      1,      "0E_HyperCleft",            "HP",               4),
    272:    (14,     2,      2,      "0E_HyperCleft",            "DamageA",          8),
    273:    (14,     2,      3,      "0E_HyperCleft",            "DamageB",          3),
    274:    (14,     3,      0,      "0E_TubbasHeart",           "Level",            0),
    275:    (14,     3,      1,      "0E_TubbasHeart",           "HP",               50),
    276:    (14,     3,      2,      "0E_TubbasHeart",           "DamageA",          6),
    277:    (14,     3,      3,      "0E_TubbasHeart",           "DamageB",          12),
    278:    (14,     4,      0,      "0E_TubbaBlubba",           "Level",            70),
    279:    (14,     4,      1,      "0E_TubbaBlubba",           "HP",               10),
    280:    (14,     4,      2,      "0E_TubbaBlubba",           "DamageA",          4),
    281:    (14,     4,      3,      "0E_TubbaBlubba",           "DamageB",          6),
    282:    (15,     0,      0,      "0F_Clubba",                "Level",            13),
    283:    (15,     0,      1,      "0F_Clubba",                "HP",               8),
    284:    (15,     0,      2,      "0F_Clubba",                "DamageA",          3),
    285:    (15,     1,      0,      "0F_TubbaBlubba",           "Level",            0),
    286:    (15,     1,      1,      "0F_TubbaBlubba",           "HP",               10),
    287:    (15,     1,      2,      "0F_TubbaBlubba",           "DamageA",          4),
    288:    (15,     1,      3,      "0F_TubbaBlubba",           "DamageB",          6),
    289:    (16,     0,      0,      "10_ShyGuy_RED",            "Level",            14),
    290:    (16,     0,      1,      "10_ShyGuy_RED",            "HP",               7),
    291:    (16,     0,      2,      "10_ShyGuy_RED",            "DamageA",          2),
    292:    (16,     0,      3,      "10_ShyGuy_RED",            "DamageB",          3),
    293:    (16,     1,      0,      "10_ShyGuy_BLU",            "Level",            14),
    294:    (16,     1,      1,      "10_ShyGuy_BLU",            "HP",               7),
    295:    (16,     1,      2,      "10_ShyGuy_BLU",            "DamageA",          2),
    296:    (16,     1,      3,      "10_ShyGuy_BLU",            "DamageB",          3),
    297:    (16,     2,      0,      "10_ShyGuy_YLW",            "Level",            14),
    298:    (16,     2,      1,      "10_ShyGuy_YLW",            "HP",               7),
    299:    (16,     2,      2,      "10_ShyGuy_YLW",            "DamageA",          2),
    300:    (16,     2,      3,      "10_ShyGuy_YLW",            "DamageB",          3),
    301:    (16,     3,      0,      "10_ShyGuy_PNK",            "Level",            14),
    302:    (16,     3,      1,      "10_ShyGuy_PNK",            "HP",               7),
    303:    (16,     3,      2,      "10_ShyGuy_PNK",            "DamageA",          2),
    304:    (16,     3,      3,      "10_ShyGuy_PNK",            "DamageB",          3),
    305:    (16,     4,      0,      "10_ShyGuy_GRN",            "Level",            14),
    306:    (16,     4,      1,      "10_ShyGuy_GRN",            "HP",               7),
    307:    (16,     4,      2,      "10_ShyGuy_GRN",            "DamageA",          2),
    308:    (16,     4,      3,      "10_ShyGuy_GRN",            "DamageB",          3),
    309:    (16,     5,      0,      "10_AntiGuy",               "Level",            42),
    310:    (16,     5,      1,      "10_AntiGuy",               "HP",               50),
    311:    (16,     5,      2,      "10_AntiGuy",               "DamageA",          10),
    312:    (16,     5,      3,      "10_AntiGuy",               "DamageB",          12),
    313:    (16,     6,      0,      "10_MediGuy",               "Level",            14),
    314:    (16,     6,      1,      "10_MediGuy",               "HP",               7),
    315:    (16,     6,      2,      "10_MediGuy",               "DamageA",          1),
    316:    (16,     7,      0,      "10_GrooveGuy",             "Level",            15),
    317:    (16,     7,      1,      "10_GrooveGuy",             "HP",               7),
    318:    (16,     7,      2,      "10_GrooveGuy",             "DamageA",          2),
    319:    (16,     8,      0,      "10_SpyGuy",                "Level",            15),
    320:    (16,     8,      1,      "10_SpyGuy",                "HP",               7),
    321:    (16,     8,      2,      "10_SpyGuy",                "DamageA",          2),
    322:    (16,     8,      3,      "10_SpyGuy",                "DamageB",          2),
    323:    (16,     9,      0,      "10_SkyGuy",                "Level",            14),
    324:    (16,     9,      1,      "10_SkyGuy",                "HP",               7),
    325:    (16,     9,      2,      "10_SkyGuy",                "DamageA",          3),
    326:    (16,     10,     0,      "10_PyroGuy",               "Level",            15),
    327:    (16,     10,     1,      "10_PyroGuy",               "HP",               7),
    328:    (16,     10,     2,      "10_PyroGuy",               "DamageA",          4),
    329:    (17,     0,      0,      "11_GeneralGuy",            "Level",            73),
    330:    (17,     0,      1,      "11_GeneralGuy",            "HP",               10),
    331:    (17,     0,      2,      "11_GeneralGuy",            "DamageA",          4),
    332:    (17,     0,      3,      "11_GeneralGuy",            "DamageB",          5),
    333:    (17,     0,      4,      "11_GeneralGuy",            "DamageC",          2),
    334:    (17,     1,      0,      "11_ToyTank",               "Level",            0),
    335:    (17,     1,      1,      "11_ToyTank",               "HP",               30),
    336:    (17,     1,      2,      "11_ToyTank",               "DamageA",          4),
    337:    (17,     2,      0,      "11_LightBulb",             "Level",            0),
    338:    (17,     2,      1,      "11_LightBulb",             "HP",               8),
    339:    (18,     0,      0,      "12_BigLanternGhost",       "Level",            42),
    340:    (18,     0,      1,      "12_BigLanternGhost",       "HP",               40),
    341:    (18,     0,      2,      "12_BigLanternGhost",       "DamageA",          5),
    342:    (18,     0,      3,      "12_BigLanternGhost",       "DamageB",          2),
    343:    (18,     0,      4,      "12_BigLanternGhost",       "DamageC",          2),
    344:    (18,     3,      0,      "12_Goomba",                "Level",            5),
    345:    (18,     3,      1,      "12_Goomba",                "HP",               2),
    346:    (18,     3,      2,      "12_Goomba",                "DamageA",          1),
    347:    (18,     4,      0,      "12_Clubba",                "Level",            13),
    348:    (18,     4,      1,      "12_Clubba",                "HP",               8),
    349:    (18,     4,      2,      "12_Clubba",                "DamageA",          3),
    350:    (18,     5,      0,      "12_Fuzzy",                 "Level",            6),
    351:    (18,     5,      1,      "12_Fuzzy",                 "HP",               3),
    352:    (18,     5,      2,      "12_Fuzzy",                 "DamageA",          1),
    353:    (18,     6,      0,      "12_HammerBros",            "Level",            27),
    354:    (18,     6,      1,      "12_HammerBros",            "HP",               12),
    355:    (18,     6,      2,      "12_HammerBros",            "DamageA",          5),
    356:    (18,     6,      3,      "12_HammerBros",            "DamageB",          2),
    357:    (18,     7,      0,      "12_Pokey",                 "Level",            9),
    358:    (18,     7,      1,      "12_Pokey",                 "HP",               4),
    359:    (18,     7,      2,      "12_Pokey",                 "DamageA0",         2),
    360:    (18,     7,      3,      "12_Pokey",                 "DamageA1",         2),
    361:    (18,     7,      4,      "12_Pokey",                 "DamageA2",         2),
    362:    (18,     7,      5,      "12_Pokey",                 "DamageB",          2),
    363:    (18,     7,      6,      "12_Pokey",                 "DamageC",          2),
    364:    (18,     8,      0,      "12_Koopatrol",             "Level",            25),
    365:    (18,     8,      1,      "12_Koopatrol",             "HP",               8),
    366:    (18,     8,      2,      "12_Koopatrol",             "DamageA",          4),
    367:    (18,     8,      3,      "12_Koopatrol",             "DamageB",          10),
    368:    (18,     9,      0,      "12_ShyGuy",                "Level",            14),
    369:    (18,     9,      1,      "12_ShyGuy",                "HP",               7),
    370:    (18,     9,      2,      "12_ShyGuy",                "DamageA",          2),
    371:    (18,     9,      3,      "12_ShyGuy",                "DamageB",          3),
    372:    (19,     0,      0,      "13_Fuzzipede",             "Level",            43),
    373:    (19,     0,      1,      "13_Fuzzipede",             "HP",               20),
    374:    (19,     0,      2,      "13_Fuzzipede",             "DamageA",          3),
    375:    (19,     0,      3,      "13_Fuzzipede",             "DamageB",          3),
    376:    (20,     0,      0,      "14_SpearGuy",              "Level",            16),
    377:    (20,     0,      1,      "14_SpearGuy",              "HP",               7),
    378:    (20,     0,      2,      "14_SpearGuy",              "DamageA",          3),
    379:    (20,     1,      0,      "14_HurtPlant",             "Level",            16),
    380:    (20,     1,      1,      "14_HurtPlant",             "HP",               8),
    381:    (20,     1,      2,      "14_HurtPlant",             "DamageA",          2),
    382:    (20,     2,      0,      "14_JungleFuzzy",           "Level",            16),
    383:    (20,     2,      1,      "14_JungleFuzzy",           "HP",               7),
    384:    (20,     2,      2,      "14_JungleFuzzy",           "DamageA",          2),
    385:    (20,     3,      0,      "14_MBush",                 "Level",            16),
    386:    (20,     3,      1,      "14_MBush",                 "HP",               8),
    387:    (20,     3,      2,      "14_MBush",                 "DamageA",          3),
    388:    (20,     4,      0,      "14_MediGuy",               "Level",            14),
    389:    (20,     4,      1,      "14_MediGuy",               "HP",               7),
    390:    (20,     4,      2,      "14_MediGuy",               "DamageA",          1),
    391:    (20,     5,      0,      "14_SpikeTop",              "Level",            17),
    392:    (20,     5,      1,      "14_SpikeTop",              "HP",               4),
    393:    (20,     5,      2,      "14_SpikeTop",              "DamageA",          4),
    394:    (20,     5,      3,      "14_SpikeTop",              "DamageB",          3),
    395:    (21,     0,      0,      "15_PutridPiranha",         "Level",            17),
    396:    (21,     0,      1,      "15_PutridPiranha",         "HP",               12),
    397:    (21,     0,      2,      "15_PutridPiranha",         "DamageA",          3),
    398:    (21,     0,      3,      "15_PutridPiranha",         "DamageB",          2),
    399:    (21,     1,      0,      "15_WMagikoopa",            "Level",            21),
    400:    (21,     1,      1,      "15_WMagikoopa",            "HP",               11),
    401:    (21,     1,      2,      "15_WMagikoopa",            "DamageA",          3),
    402:    (21,     1,      3,      "15_WMagikoopa",            "DamageB",          3),
    403:    (21,     2,      0,      "15_FlyingWMagikoopa",      "Level",            21),
    404:    (21,     2,      1,      "15_FlyingWMagikoopa",      "HP",               11),
    405:    (22,     0,      0,      "16_LavaBubble",            "Level",            17),
    406:    (22,     0,      1,      "16_LavaBubble",            "HP",               9),
    407:    (22,     0,      2,      "16_LavaBubble",            "DamageA",          4),
    408:    (22,     0,      3,      "16_LavaBubble",            "DamageB",          2),
    409:    (22,     0,      4,      "16_LavaBubble",            "DamageC",          4),
    410:    (22,     1,      0,      "16_PutridPiranha",         "Level",            17),
    411:    (22,     1,      1,      "16_PutridPiranha",         "HP",               12),
    412:    (22,     1,      2,      "16_PutridPiranha",         "DamageA",          3),
    413:    (22,     1,      3,      "16_PutridPiranha",         "DamageB",          2),
    414:    (22,     2,      0,      "16_SpikeTop",              "Level",            17),
    415:    (22,     2,      1,      "16_SpikeTop",              "HP",               4),
    416:    (22,     2,      2,      "16_SpikeTop",              "DamageA",          4),
    417:    (22,     2,      3,      "16_SpikeTop",              "DamageB",          3),
    418:    (22,     3,      0,      "16_MediGuy",               "Level",            14),
    419:    (22,     3,      1,      "16_MediGuy",               "HP",               7),
    420:    (22,     3,      2,      "16_MediGuy",               "DamageA",          1),
    421:    (22,     4,      0,      "16_RMagikoopa",            "Level",            21),
    422:    (22,     4,      1,      "16_RMagikoopa",            "HP",               11),
    423:    (22,     4,      2,      "16_RMagikoopa",            "DamageA",          3),
    424:    (22,     4,      3,      "16_RMagikoopa",            "DamageB",          3),
    425:    (22,     5,      0,      "16_FlyingRMagikoopa",      "Level",            21),
    426:    (22,     5,      1,      "16_FlyingRMagikoopa",      "HP",               11),
    427:    (22,     6,      0,      "16_WMagikoopa",            "Level",            21),
    428:    (22,     6,      1,      "16_WMagikoopa",            "HP",               11),
    429:    (22,     6,      2,      "16_WMagikoopa",            "DamageA",          3),
    430:    (22,     6,      3,      "16_WMagikoopa",            "DamageB",          3),
    431:    (22,     7,      0,      "16_FlyingWMagikoopa",      "Level",            21),
    432:    (22,     7,      1,      "16_FlyingWMagikoopa",      "HP",               11),
    433:    (23,     0,      0,      "17_LavaPiranha",           "Level",            45),
    434:    (23,     0,      1,      "17_LavaPiranha",           "HP",               40),
    435:    (23,     0,      2,      "17_LavaPiranha",           "DamageA",          5),
    436:    (23,     0,      3,      "17_LavaPiranha",           "DamageB",          7),
    437:    (23,     1,      0,      "17_PetitPiranha",          "Level",            0),
    438:    (23,     1,      1,      "17_PetitPiranha",          "HP",               1),
    439:    (23,     1,      2,      "17_PetitPiranha",          "DamageA",          6),
    440:    (23,     2,      0,      "17_LavaBud",               "Level",            0),
    441:    (23,     2,      1,      "17_LavaBud",               "HP",               8),
    442:    (23,     2,      2,      "17_LavaBud",               "DamageA",          4),
    443:    (23,     3,      0,      "17_PetitPiranhaBomb",      "Level",            0),
    444:    (23,     3,      1,      "17_PetitPiranhaBomb",      "HP",               1),
    445:    (24,     0,      0,      "18_Lakitu",                "Level",            20),
    446:    (24,     0,      1,      "18_Lakitu",                "HP",               12),
    447:    (24,     0,      2,      "18_Lakitu",                "DamageA",          3),
    448:    (24,     1,      0,      "18_Spiny",                 "Level",            19),
    449:    (24,     1,      1,      "18_Spiny",                 "HP",               5),
    450:    (24,     1,      2,      "18_Spiny",                 "DamageA",          4),
    451:    (24,     2,      0,      "18_CrazeeDayzee",          "Level",            19),
    452:    (24,     2,      1,      "18_CrazeeDayzee",          "HP",               8),
    453:    (24,     2,      2,      "18_CrazeeDayzee",          "DamageA",          4),
    454:    (24,     3,      0,      "18_Bzzap",                 "Level",            19),
    455:    (24,     3,      1,      "18_Bzzap",                 "HP",               3),
    456:    (24,     3,      2,      "18_Bzzap",                 "DamageA",          6),
    457:    (24,     3,      3,      "18_Bzzap",                 "DamageB",          1),
    458:    (24,     4,      0,      "18_AmazyDayzee",           "Level",            100),
    459:    (24,     4,      1,      "18_AmazyDayzee",           "HP",               20),
    460:    (24,     4,      2,      "18_AmazyDayzee",           "DamageA",          20),
    461:    (24,     5,      0,      "18_RuffPuff",              "Level",            19),
    462:    (24,     5,      1,      "18_RuffPuff",              "HP",               10),
    463:    (24,     5,      2,      "18_RuffPuff",              "DamageA",          4),
    464:    (24,     6,      0,      "18_MediGuy",               "Level",            14),
    465:    (24,     6,      1,      "18_MediGuy",               "HP",               7),
    466:    (24,     6,      2,      "18_MediGuy",               "DamageA",          1),
    467:    (24,     7,      0,      "18_RMagikoopa",            "Level",            21),
    468:    (24,     7,      1,      "18_RMagikoopa",            "HP",               11),
    469:    (24,     7,      2,      "18_RMagikoopa",            "DamageA",          3),
    470:    (24,     7,      3,      "18_RMagikoopa",            "DamageB",          3),
    471:    (24,     8,      0,      "18_FlyingRMagikoopa",      "Level",            21),
    472:    (24,     8,      1,      "18_FlyingRMagikoopa",      "HP",               11),
    473:    (24,     9,      0,      "18_GRNMagikoopa",          "Level",            21),
    474:    (24,     9,      1,      "18_GRNMagikoopa",          "HP",               11),
    475:    (24,     9,      2,      "18_GRNMagikoopa",          "DamageA",          3),
    476:    (24,     9,      3,      "18_GRNMagikoopa",          "DamageB",          3),
    477:    (24,     10,     0,      "18_FlyingGRNMagikoopa",    "Level",            21),
    478:    (24,     10,     1,      "18_FlyingGRNMagikoopa",    "HP",               11),
    479:    (24,     11,     0,      "18_WMagikoopa",            "Level",            21),
    480:    (24,     11,     1,      "18_WMagikoopa",            "HP",               11),
    481:    (24,     11,     2,      "18_WMagikoopa",            "DamageA",          3),
    482:    (24,     11,     3,      "18_WMagikoopa",            "DamageB",          3),
    483:    (24,     12,     0,      "18_FlyingWMagikoopa",      "Level",            21),
    484:    (24,     12,     1,      "18_FlyingWMagikoopa",      "HP",               11),
    485:    (24,     13,     0,      "18_YMagikoopa",            "Level",            21),
    486:    (24,     13,     1,      "18_YMagikoopa",            "HP",               11),
    487:    (24,     13,     2,      "18_YMagikoopa",            "DamageA",          3),
    488:    (24,     13,     3,      "18_YMagikoopa",            "DamageB",          3),
    489:    (24,     14,     0,      "18_FlyingYMagikoopa",      "Level",            21),
    490:    (24,     14,     1,      "18_FlyingYMagikoopa",      "HP",               11),
    491:    (25,     0,      0,      "19_HuffNPuff",             "Level",            80),
    492:    (25,     0,      1,      "19_HuffNPuff",             "HP",               60),
    493:    (25,     0,      2,      "19_HuffNPuff",             "SwarmIncrement",   1),
    494:    (25,     0,      3,      "19_HuffNPuff",             "DamageA",          5),
    495:    (25,     0,      4,      "19_HuffNPuff",             "DamageB",          12),
    496:    (25,     0,      5,      "19_HuffNPuff",             "DamageC",          10),
    497:    (25,     0,      6,      "19_HuffNPuff",             "DamageD",          1),
    498:    (25,     0,      7,      "19_HuffNPuff",             "DamageE",          2),
    499:    (25,     0,      8,      "19_HuffNPuff",             "DamageF",          5),
    500:    (25,     0,      9,      "19_HuffNPuff",             "DamageG7",         7),
    501:    (25,     0,      10,     "19_HuffNPuff",             "DamageG6",         6),
    502:    (25,     0,      11,     "19_HuffNPuff",             "DamageG5",         5),
    503:    (25,     0,      12,     "19_HuffNPuff",             "DamageG4",         4),
    504:    (25,     0,      13,     "19_HuffNPuff",             "DamageG3",         3),
    505:    (25,     0,      14,     "19_HuffNPuff",             "DamageG2",         2),
    506:    (25,     1,      0,      "19_TuffPuff",              "Level",            0),
    507:    (25,     1,      1,      "19_TuffPuff",              "HP",               1),
    508:    (25,     2,      0,      "19_MontyMole",             "Level",            19),
    509:    (25,     2,      1,      "19_MontyMole",             "HP",               12),
    510:    (25,     2,      2,      "19_MontyMole",             "DamageA",          3),
    511:    (25,     3,      0,      "19_EmptyMoleHole",         "Level",            9),
    512:    (25,     3,      1,      "19_EmptyMoleHole",         "HP",               5),
    513:    (25,     4,      0,      "19_Spike",                 "Level",            40),
    514:    (25,     4,      1,      "19_Spike",                 "HP",               50),
    515:    (25,     4,      2,      "19_Spike",                 "DamageA",          4),
    516:    (26,     0,      0,      "1A_DarkKoopa",             "Level",            18),
    517:    (26,     0,      1,      "1A_DarkKoopa",             "HP",               8),
    518:    (26,     0,      2,      "1A_DarkKoopa",             "DamageA",          3),
    519:    (26,     1,      0,      "1A_DarkParatroopa",        "Level",            18),
    520:    (26,     1,      1,      "1A_DarkParatroopa",        "HP",               8),
    521:    (26,     1,      2,      "1A_DarkParatroopa",        "DamageA",          3),
    522:    (26,     2,      0,      "1A_Gloomba",               "Level",            11),
    523:    (26,     2,      1,      "1A_Gloomba",               "HP",               7),
    524:    (26,     2,      2,      "1A_Gloomba",               "DamageA",          2),
    525:    (26,     3,      0,      "1A_SpikedGloomba",         "Level",            12),
    526:    (26,     3,      1,      "1A_SpikedGloomba",         "HP",               7),
    527:    (26,     3,      2,      "1A_SpikedGloomba",         "DamageA",          3),
    528:    (26,     4,      0,      "1A_Paragloomba",           "Level",            11),
    529:    (26,     4,      1,      "1A_Paragloomba",           "HP",               7),
    530:    (26,     4,      2,      "1A_Paragloomba",           "DamageA",          2),
    531:    (26,     5,      0,      "1A_BuzzyBeetle",           "Level",            10),
    532:    (26,     5,      1,      "1A_BuzzyBeetle",           "HP",               3),
    533:    (26,     5,      3,      "1A_BuzzyBeetle",           "DamageA",          3),
    534:    (26,     5,      2,      "1A_BuzzyBeetle",           "DamageB",          2),
    535:    (26,     6,      0,      "1A_SpikeTop",              "Level",            17),
    536:    (26,     6,      1,      "1A_SpikeTop",              "HP",               4),
    537:    (26,     6,      2,      "1A_SpikeTop",              "DamageA",          4),
    538:    (26,     6,      3,      "1A_SpikeTop",              "DamageB",          3),
    539:    (26,     7,      0,      "1A_Spiny",                 "Level",            19),
    540:    (26,     7,      1,      "1A_Spiny",                 "HP",               5),
    541:    (26,     7,      2,      "1A_Spiny",                 "DamageA",          4),
    542:    (27,     0,      0,      "1B_Blooper",               "Level",            44),
    543:    (27,     0,      1,      "1B_Blooper",               "HP",               30),
    544:    (27,     0,      2,      "1B_Blooper",               "DamageA",          3),
    545:    (27,     0,      3,      "1B_Blooper",               "DamageB",          3),
    546:    (27,     1,      0,      "1B_ElectroBlooper",        "Level",            50),
    547:    (27,     1,      1,      "1B_ElectroBlooper",        "HP",               50),
    548:    (27,     1,      2,      "1B_ElectroBlooper",        "DamageA",          4),
    549:    (27,     1,      3,      "1B_ElectroBlooper",        "DamageB",          4),
    550:    (27,     1,      4,      "1B_ElectroBlooper",        "DamageC",          6),
    551:    (27,     2,      0,      "1B_SuperBlooper",          "Level",            65),
    552:    (27,     2,      1,      "1B_SuperBlooper",          "HP",               70),
    553:    (27,     2,      2,      "1B_SuperBlooper",          "DamageA",          5),
    554:    (27,     2,      3,      "1B_SuperBlooper",          "DamageB",          5),
    555:    (27,     2,      4,      "1B_SuperBlooper",          "DamageC",          10),
    556:    (27,     2,      5,      "1B_SuperBlooper",          "DamageD",          10),
    557:    (27,     3,      0,      "1B_BlooperBaby",           "Level",            0),
    558:    (27,     3,      1,      "1B_BlooperBaby",           "HP",               6),
    559:    (27,     3,      2,      "1B_BlooperBaby",           "DamageA",          2),
    560:    (28,     0,      0,      "1C_Swooper",               "Level",            10),
    561:    (28,     0,      1,      "1C_Swooper",               "HP",               4),
    562:    (28,     0,      2,      "1C_Swooper",               "DamageA",          2),
    563:    (28,     1,      0,      "1C_Swoopula",              "Level",            22),
    564:    (28,     1,      1,      "1C_Swoopula",              "HP",               8),
    565:    (28,     1,      2,      "1C_Swoopula",              "DamageA",          2),
    566:    (29,     0,      0,      "1D_Duplighost",            "Level",            23),
    567:    (29,     0,      1,      "1D_Duplighost",            "HP",               15),
    568:    (29,     0,      2,      "1D_Duplighost",            "DamageA",          4),
    569:    (29,     1,      0,      "1D_GhostGoombario",        "Level",            23),
    570:    (29,     1,      1,      "1D_GhostGoombario",        "HP",               15),
    571:    (29,     1,      2,      "1D_GhostGoombario",        "DamageA",          1),
    572:    (29,     1,      3,      "1D_GhostGoombario",        "DamageB",          2),
    573:    (29,     1,      4,      "1D_GhostGoombario",        "DamageC",          3),
    574:    (29,     2,      0,      "1D_GhostKooper",           "Level",            23),
    575:    (29,     2,      1,      "1D_GhostKooper",           "HP",               15),
    576:    (29,     2,      2,      "1D_GhostKooper",           "DamageA",          2),
    577:    (29,     2,      3,      "1D_GhostKooper",           "DamageB",          3),
    578:    (29,     2,      4,      "1D_GhostKooper",           "DamageC",          5),
    579:    (29,     3,      0,      "1D_GhostBombette",         "Level",            23),
    580:    (29,     3,      1,      "1D_GhostBombette",         "HP",               15),
    581:    (29,     3,      2,      "1D_GhostBombette",         "DamageA",          2),
    582:    (29,     3,      3,      "1D_GhostBombette",         "DamageB",          3),
    583:    (29,     3,      4,      "1D_GhostBombette",         "DamageC",          5),
    584:    (29,     4,      0,      "1D_GhostParakarry",        "Level",            23),
    585:    (29,     4,      1,      "1D_GhostParakarry",        "HP",               15),
    586:    (29,     4,      2,      "1D_GhostParakarry",        "DamageA",          2),
    587:    (29,     4,      3,      "1D_GhostParakarry",        "DamageB",          3),
    588:    (29,     4,      4,      "1D_GhostParakarry",        "DamageC",          5),
    589:    (29,     5,      0,      "1D_GhostBow",              "Level",            23),
    590:    (29,     5,      1,      "1D_GhostBow",              "HP",               15),
    591:    (29,     5,      2,      "1D_GhostBow",              "DamageA",          1),
    592:    (29,     5,      3,      "1D_GhostBow",              "DamageB",          1),
    593:    (29,     5,      4,      "1D_GhostBow",              "DamageC",          1),
    594:    (29,     6,      0,      "1D_GhostWatt",             "Level",            23),
    595:    (29,     6,      1,      "1D_GhostWatt",             "HP",               15),
    596:    (29,     6,      2,      "1D_GhostWatt",             "DamageA",          3),
    597:    (29,     6,      3,      "1D_GhostWatt",             "DamageB",          4),
    598:    (29,     6,      4,      "1D_GhostWatt",             "DamageC",          5),
    599:    (29,     7,      0,      "1D_GhostSushie",           "Level",            23),
    600:    (29,     7,      1,      "1D_GhostSushie",           "HP",               15),
    601:    (29,     7,      2,      "1D_GhostSushie",           "DamageA",          3),
    602:    (29,     7,      3,      "1D_GhostSushie",           "DamageB",          4),
    603:    (29,     7,      4,      "1D_GhostSushie",           "DamageC",          5),
    604:    (29,     8,      0,      "1D_GhostLakilester",       "Level",            23),
    605:    (29,     8,      1,      "1D_GhostLakilester",       "HP",               15),
    606:    (29,     8,      2,      "1D_GhostLakilester",       "DamageA",          3),
    607:    (29,     8,      3,      "1D_GhostLakilester",       "DamageB",          4),
    608:    (29,     8,      4,      "1D_GhostLakilester",       "DamageC",          5),
    609:    (29,     9,      0,      "1D_Gulpit",                "Level",            22),
    610:    (29,     9,      1,      "1D_Gulpit",                "HP",               12),
    611:    (29,     9,      2,      "1D_Gulpit",                "DamageA",          2),
    612:    (29,     9,      3,      "1D_Gulpit",                "DamageB",          7),
    613:    (29,     9,      4,      "1D_Gulpit",                "DamageC",          5),
    614:    (29,     10,     0,      "1D_GulpitRocks",           "Level",            0),
    615:    (29,     10,     1,      "1D_GulpitRocks",           "HP",               1),
    616:    (29,     11,     0,      "1D_WhiteClubba",           "Level",            23),
    617:    (29,     11,     1,      "1D_WhiteClubba",           "HP",               12),
    618:    (29,     11,     2,      "1D_WhiteClubba",           "DamageA",          5),
    619:    (29,     11,     3,      "1D_WhiteClubba",           "DamageB",          2),
    620:    (29,     12,     0,      "1D_FrostPiranha",          "Level",            22),
    621:    (29,     12,     1,      "1D_FrostPiranha",          "HP",               10),
    622:    (29,     12,     2,      "1D_FrostPiranha",          "DamageA",          4),
    623:    (29,     13,     0,      "1D_GRYMagikoopa",          "Level",            21),
    624:    (29,     13,     1,      "1D_GRYMagikoopa",          "HP",               11),
    625:    (29,     13,     2,      "1D_GRYMagikoopa",          "DamageA",          3),
    626:    (29,     13,     3,      "1D_GRYMagikoopa",          "DamageB",          3),
    627:    (29,     14,     0,      "1D_FlyingGRYMagikoopa",    "Level",            21),
    628:    (29,     14,     1,      "1D_FlyingGRYMagikoopa",    "HP",               11),
    629:    (30,     0,      0,      "1E_Monstar",               "Level",            45),
    630:    (30,     0,      1,      "1E_Monstar",               "HP",               20),
    631:    (30,     0,      2,      "1E_Monstar",               "DamageA",          1),
    632:    (30,     1,      0,      "1E_Paragoomba",            "Level",            6),
    633:    (30,     1,      1,      "1E_Paragoomba",            "HP",               2),
    634:    (30,     1,      2,      "1E_Paragoomba",            "DamageA",          1),
    635:    (30,     1,      3,      "1E_Paragoomba",            "DamageB",          1),
    636:    (30,     2,      0,      "1E_GRYMagikoopa",          "Level",            21),
    637:    (30,     2,      1,      "1E_GRYMagikoopa",          "HP",               11),
    638:    (30,     2,      2,      "1E_GRYMagikoopa",          "DamageA",          3),
    639:    (30,     2,      3,      "1E_GRYMagikoopa",          "DamageB",          3),
    640:    (30,     3,      0,      "1E_FlyingGRYMagikoopa",    "Level",            21),
    641:    (30,     3,      1,      "1E_FlyingGRYMagikoopa",    "HP",               11),
    642:    (31,     0,      0,      "1F_Swoopula",              "Level",            22),
    643:    (31,     0,      1,      "1F_Swoopula",              "HP",               8),
    644:    (31,     0,      2,      "1F_Swoopula",              "DamageA",          2),
    645:    (31,     1,      0,      "1F_AlbinoDino",            "Level",            23),
    646:    (31,     1,      1,      "1F_AlbinoDino",            "HP",               8),
    647:    (31,     1,      2,      "1F_AlbinoDino",            "DamageA",          4),
    648:    (31,     2,      0,      "1F_WhiteClubba",           "Level",            23),
    649:    (31,     2,      1,      "1F_WhiteClubba",           "HP",               12),
    650:    (31,     2,      2,      "1F_WhiteClubba",           "DamageA",          5),
    651:    (31,     2,      3,      "1F_WhiteClubba",           "DamageB",          2),
    652:    (31,     3,      0,      "1F_RMagikoopa",            "Level",            21),
    653:    (31,     3,      1,      "1F_RMagikoopa",            "HP",               11),
    654:    (31,     3,      2,      "1F_RMagikoopa",            "DamageA",          3),
    655:    (31,     3,      3,      "1F_RMagikoopa",            "DamageB",          3),
    656:    (31,     4,      0,      "1F_FlyingRMagikoopa",      "Level",            21),
    657:    (31,     4,      1,      "1F_FlyingRMagikoopa",      "HP",               11),
    658:    (31,     5,      0,      "1F_GRNMagikoopa",          "Level",            21),
    659:    (31,     5,      1,      "1F_GRNMagikoopa",          "HP",               11),
    660:    (31,     5,      2,      "1F_GRNMagikoopa",          "DamageA",          3),
    661:    (31,     5,      3,      "1F_GRNMagikoopa",          "DamageB",          3),
    662:    (31,     6,      0,      "1F_FlyingGRNMagikoopa",    "Level",            21),
    663:    (31,     6,      1,      "1F_FlyingGRNMagikoopa",    "HP",               11),
    664:    (31,     7,      0,      "1F_YMagikoopa",            "Level",            21),
    665:    (31,     7,      1,      "1F_YMagikoopa",            "HP",               11),
    666:    (31,     7,      2,      "1F_YMagikoopa",            "DamageA",          3),
    667:    (31,     7,      3,      "1F_YMagikoopa",            "DamageB",          3),
    668:    (31,     8,      0,      "1F_FlyingYMagikoopa",      "Level",            21),
    669:    (31,     8,      1,      "1F_FlyingYMagikoopa",      "HP",               11),
    670:    (31,     9,      0,      "1F_GRYMagikoopa",          "Level",            21),
    671:    (31,     9,      1,      "1F_GRYMagikoopa",          "HP",               11),
    672:    (31,     9,      2,      "1F_GRYMagikoopa",          "DamageA",          3),
    673:    (31,     9,      3,      "1F_GRYMagikoopa",          "DamageB",          3),
    674:    (31,     10,     0,      "1F_FlyingGRYMagikoopa",    "Level",            21),
    675:    (31,     10,     1,      "1F_FlyingGRYMagikoopa",    "HP",               11),
    676:    (31,     11,     0,      "1F_WMagikoopa",            "Level",            21),
    677:    (31,     11,     1,      "1F_WMagikoopa",            "HP",               11),
    678:    (31,     11,     2,      "1F_WMagikoopa",            "DamageA",          3),
    679:    (31,     11,     3,      "1F_WMagikoopa",            "DamageB",          3),
    680:    (31,     12,     0,      "1F_FlyingWMagikoopa",      "Level",            21),
    681:    (31,     12,     1,      "1F_FlyingWMagikoopa",      "HP",               11),
    682:    (32,     0,      0,      "20_CrystalKing",           "Level",            85),
    683:    (32,     0,      1,      "20_CrystalKing",           "HP",               70),
    684:    (32,     0,      2,      "20_CrystalKing",           "DamageA",          8),
    685:    (32,     0,      3,      "20_CrystalKing",           "DamageB",          8),
    686:    (32,     0,      4,      "20_CrystalKing",           "DamageC",          6),
    687:    (32,     0,      5,      "20_CrystalKing",           "DamageD",          4),
    688:    (32,     0,      6,      "20_CrystalKing",           "Heal",             20),
    689:    (32,     1,      0,      "20_CrystalClone",          "Level",            0),
    690:    (32,     1,      1,      "20_CrystalClone",          "HP",               70),
    691:    (32,     2,      0,      "20_CrystalBitA",           "Level",            0),
    692:    (32,     2,      1,      "20_CrystalBitA",           "HP",               1),
    693:    (32,     3,      0,      "20_CrystalBitB",           "Level",            0),
    694:    (32,     3,      1,      "20_CrystalBitB",           "HP",               1),
    695:    (32,     4,      0,      "20_CrystalBitC",           "Level",            0),
    696:    (32,     4,      1,      "20_CrystalBitC",           "HP",               1),
    697:    (33,     0,      0,      "21_Duplighost",            "Level",            23),
    698:    (33,     0,      1,      "21_Duplighost",            "HP",               15),
    699:    (33,     0,      2,      "21_Duplighost",            "DamageA",          4),
    700:    (33,     1,      0,      "21_GhostGoombario",        "Level",            23),
    701:    (33,     1,      1,      "21_GhostGoombario",        "HP",               15),
    702:    (33,     1,      2,      "21_GhostGoombario",        "DamageA",          1),
    703:    (33,     1,      3,      "21_GhostGoombario",        "DamageB",          2),
    704:    (33,     1,      4,      "21_GhostGoombario",        "DamageC",          3),
    705:    (33,     2,      0,      "21_GhostKooper",           "Level",            23),
    706:    (33,     2,      1,      "21_GhostKooper",           "HP",               15),
    707:    (33,     2,      2,      "21_GhostKooper",           "DamageA",          2),
    708:    (33,     2,      3,      "21_GhostKooper",           "DamageB",          3),
    709:    (33,     2,      4,      "21_GhostKooper",           "DamageC",          5),
    710:    (33,     3,      0,      "21_GhostBombette",         "Level",            23),
    711:    (33,     3,      1,      "21_GhostBombette",         "HP",               15),
    712:    (33,     3,      2,      "21_GhostBombette",         "DamageA",          2),
    713:    (33,     3,      3,      "21_GhostBombette",         "DamageB",          3),
    714:    (33,     3,      4,      "21_GhostBombette",         "DamageC",          5),
    715:    (33,     4,      0,      "21_GhostParakarry",        "Level",            23),
    716:    (33,     4,      1,      "21_GhostParakarry",        "HP",               15),
    717:    (33,     4,      2,      "21_GhostParakarry",        "DamageA",          2),
    718:    (33,     4,      3,      "21_GhostParakarry",        "DamageB",          3),
    719:    (33,     4,      4,      "21_GhostParakarry",        "DamageC",          5),
    720:    (33,     5,      0,      "21_GhostBow",              "Level",            23),
    721:    (33,     5,      1,      "21_GhostBow",              "HP",               15),
    722:    (33,     5,      2,      "21_GhostBow",              "DamageA",          1),
    723:    (33,     5,      3,      "21_GhostBow",              "DamageB",          1),
    724:    (33,     5,      4,      "21_GhostBow",              "DamageC",          1),
    725:    (33,     6,      0,      "21_GhostWatt",             "Level",            23),
    726:    (33,     6,      1,      "21_GhostWatt",             "HP",               15),
    727:    (33,     6,      2,      "21_GhostWatt",             "DamageA",          3),
    728:    (33,     6,      3,      "21_GhostWatt",             "DamageB",          4),
    729:    (33,     6,      4,      "21_GhostWatt",             "DamageC",          5),
    730:    (33,     7,      0,      "21_GhostSushie",           "Level",            23),
    731:    (33,     7,      1,      "21_GhostSushie",           "HP",               15),
    732:    (33,     7,      2,      "21_GhostSushie",           "DamageA",          3),
    733:    (33,     7,      3,      "21_GhostSushie",           "DamageB",          4),
    734:    (33,     7,      4,      "21_GhostSushie",           "DamageC",          5),
    735:    (33,     8,      0,      "21_GhostLakilester",       "Level",            23),
    736:    (33,     8,      1,      "21_GhostLakilester",       "HP",               15),
    737:    (33,     8,      2,      "21_GhostLakilester",       "DamageA",          3),
    738:    (33,     8,      3,      "21_GhostLakilester",       "DamageB",          4),
    739:    (33,     8,      4,      "21_GhostLakilester",       "DamageC",          5),
    740:    (33,     9,      0,      "21_Swoopula",              "Level",            22),
    741:    (33,     9,      1,      "21_Swoopula",              "HP",               8),
    742:    (33,     9,      2,      "21_Swoopula",              "DamageA",          2),
    743:    (33,     10,     0,      "21_WhiteClubba",           "Level",            23),
    744:    (33,     10,     1,      "21_WhiteClubba",           "HP",               12),
    745:    (33,     10,     2,      "21_WhiteClubba",           "DamageA",          5),
    746:    (33,     11,     0,      "21_RMagikoopa",            "Level",            21),
    747:    (33,     11,     1,      "21_RMagikoopa",            "HP",               11),
    748:    (33,     11,     2,      "21_RMagikoopa",            "DamageA",          3),
    749:    (33,     11,     3,      "21_RMagikoopa",            "DamageB",          3),
    750:    (33,     12,     0,      "21_FlyingRMagikoopa",      "Level",            21),
    751:    (33,     12,     1,      "21_FlyingRMagikoopa",      "HP",               11),
    752:    (33,     13,     0,      "21_GRYMagikoopa",          "Level",            21),
    753:    (33,     13,     1,      "21_GRYMagikoopa",          "HP",               11),
    754:    (33,     13,     2,      "21_GRYMagikoopa",          "DamageA",          3),
    755:    (33,     13,     3,      "21_GRYMagikoopa",          "DamageB",          3),
    756:    (33,     14,     0,      "21_FlyingGRYMagikoopa",    "Level",            21),
    757:    (33,     14,     1,      "21_FlyingGRYMagikoopa",    "HP",               11),
    758:    (34,     0,      0,      "22_BonyBeetle",            "Level",            25),
    759:    (34,     0,      1,      "22_BonyBeetle",            "HP",               8),
    760:    (34,     0,      2,      "22_BonyBeetle",            "DamageA",          3),
    761:    (34,     0,      3,      "22_BonyBeetle",            "DamageB",          5),
    762:    (34,     1,      0,      "22_DryBones",              "Level",            30),
    763:    (34,     1,      1,      "22_DryBones",              "HP",               8),
    764:    (34,     1,      2,      "22_DryBones",              "DamageA",          4),
    765:    (34,     2,      0,      "22_HammerBros",            "Level",            27),
    766:    (34,     2,      1,      "22_HammerBros",            "HP",               12),
    767:    (34,     2,      2,      "22_HammerBros",            "DamageA",          5),
    768:    (34,     2,      3,      "22_HammerBros",            "DamageB",          2),
    769:    (34,     3,      0,      "22_Koopatrol",             "Level",            25),
    770:    (34,     3,      1,      "22_Koopatrol",             "HP",               8),
    771:    (34,     3,      2,      "22_Koopatrol",             "DamageA",          4),
    772:    (34,     4,      0,      "22_Magikoopa",             "Level",            26),
    773:    (34,     4,      1,      "22_Magikoopa",             "HP",               11),
    774:    (34,     4,      2,      "22_Magikoopa",             "DamageA",          6),
    775:    (34,     5,      0,      "22_FlyingMagikoopa",       "Level",            26),
    776:    (34,     5,      1,      "22_FlyingMagikoopa",       "HP",               11),
    777:    (34,     6,      0,      "22_Magiclone",             "Level",            26),
    778:    (34,     6,      1,      "22_Magiclone",             "HP",               11),
    779:    (34,     7,      0,      "22_FlyingMagiclone",       "Level",            26),
    780:    (34,     7,      1,      "22_FlyingMagiclone",       "HP",               11),
    781:    (34,     8,      0,      "22_Ember",                 "Level",            24),
    782:    (34,     8,      1,      "22_Ember",                 "HP",               10),
    783:    (34,     8,      2,      "22_Ember",                 "DamageA",          4),
    784:    (34,     8,      3,      "22_Ember",                 "DamageB",          3),
    785:    (34,     8,      4,      "22_Ember",                 "DamageC",          4),
    786:    (35,     0,      0,      "23_UnusedBowser",          "Level",            100),
    787:    (35,     0,      1,      "23_UnusedBowser",          "HP",               50),
    788:    (35,     0,      2,      "23_UnusedBowser",          "DamageA",          6),
    789:    (35,     0,      3,      "23_UnusedBowser",          "DamageB",          6),
    790:    (35,     0,      4,      "23_UnusedBowser",          "DamageC",          8),
    791:    (35,     0,      5,      "23_UnusedBowser",          "DamageD",          3),
    792:    (35,     0,      6,      "23_UnusedBowser",          "DamageE",          4),
    793:    (35,     1,      0,      "23_IntroBowser",           "Level",            0),
    794:    (35,     1,      1,      "23_IntroBowser",           "HP",               10),
    795:    (35,     1,      2,      "23_IntroBowser",           "DamageA",          1),
    796:    (35,     1,      3,      "23_IntroBowser",           "DamageB",          3),
    797:    (35,     1,      4,      "23_IntroBowser",           "DamageC",          10),
    798:    (35,     2,      0,      "23_Bowser1",               "Level",            100),
    799:    (35,     2,      1,      "23_Bowser1",               "HP",               50),
    800:    (35,     2,      2,      "23_Bowser1",               "DamageA",          6),
    801:    (35,     2,      3,      "23_Bowser1",               "DamageB",          12),
    802:    (35,     2,      4,      "23_Bowser1",               "DamageC",          6),
    803:    (35,     2,      5,      "23_Bowser1",               "DamageD",          12),
    804:    (35,     2,      6,      "23_Bowser1",               "DamageE",          3),
    805:    (35,     2,      7,      "23_Bowser1",               "DamageF",          4),
    806:    (35,     2,      8,      "23_Bowser1",               "DamageG",          8),
    807:    (35,     2,      9,      "23_Bowser1",               "DamageH",          16),
    808:    (35,     3,      0,      "23_Bowser2",               "Level",            0),
    809:    (35,     3,      1,      "23_Bowser2",               "HP",               99),
    810:    (35,     3,      2,      "23_Bowser2",               "DamageA",          8),
    811:    (35,     3,      3,      "23_Bowser2",               "DamageB",          16),
    812:    (35,     3,      4,      "23_Bowser2",               "DamageC",          8),
    813:    (35,     3,      5,      "23_Bowser2",               "DamageD",          16),
    814:    (35,     3,      6,      "23_Bowser2",               "DamageE",          3),
    815:    (35,     3,      7,      "23_Bowser2",               "DamageF",          6),
    816:    (35,     3,      8,      "23_Bowser2",               "DamageG",          10),
    817:    (35,     3,      9,      "23_Bowser2",               "DamageH",          20),
    818:    (35,     3,      10,     "23_Bowser2",               "DamageI",          10),
    819:    (35,     3,      11,     "23_Bowser2",               "DamageJ",          20),
    820:    (35,     4,      0,      "23_Bowser3",               "Level",            0),
    821:    (35,     4,      1,      "23_Bowser3",               "HP",               99),
    822:    (35,     4,      2,      "23_Bowser3",               "DamageA",          8),
    823:    (35,     4,      3,      "23_Bowser3",               "DamageB",          16),
    824:    (35,     4,      4,      "23_Bowser3",               "DamageC",          8),
    825:    (35,     4,      5,      "23_Bowser3",               "DamageD",          16),
    826:    (35,     4,      6,      "23_Bowser3",               "DamageE",          3),
    827:    (35,     4,      7,      "23_Bowser3",               "DamageF",          6),
    828:    (35,     4,      8,      "23_Bowser3",               "DamageG",          10),
    829:    (35,     4,      9,      "23_Bowser3",               "DamageH",          20),
    830:    (35,     4,      10,     "23_Bowser3",               "DamageI",          10),
    831:    (35,     4,      11,     "23_Bowser3",               "DamageJ",          20),
    832:    (36,     0,      0,      "24_AntiGuy",               "Level",            42),
    833:    (36,     0,      1,      "24_AntiGuy",               "HP",               50),
    834:    (36,     0,      2,      "24_AntiGuy",               "DamageA",          10),
    835:    (36,     0,      3,      "24_AntiGuy",               "DamageB",          12),
    836:    (36,     1,      0,      "24_Duplighost",            "Level",            23),
    837:    (36,     1,      1,      "24_Duplighost",            "HP",               15),
    838:    (36,     1,      2,      "24_Duplighost",            "DamageA",          4),
    839:    (36,     2,      0,      "24_GhostGoombario",        "Level",            23),
    840:    (36,     2,      1,      "24_GhostGoombario",        "HP",               15),
    841:    (65,     2,      2,      "24_GhostGoombario",        "DamageA",          1),
    842:    (65,     2,      3,      "24_GhostGoombario",        "DamageB",          2),
    843:    (65,     2,      4,      "24_GhostGoombario",        "DamageC",          3),
    844:    (36,     3,      0,      "24_GhostKooper",           "Level",            23),
    845:    (36,     3,      1,      "24_GhostKooper",           "HP",               15),
    846:    (65,     3,      2,      "24_GhostKooper",           "DamageA",          2),
    847:    (65,     3,      3,      "24_GhostKooper",           "DamageB",          3),
    848:    (65,     3,      4,      "24_GhostKooper",           "DamageC",          5),
    849:    (36,     4,      0,      "24_GhostBombette",         "Level",            23),
    850:    (36,     4,      1,      "24_GhostBombette",         "HP",               15),
    851:    (65,     4,      2,      "24_GhostBombette",         "DamageA",          2),
    852:    (65,     4,      3,      "24_GhostBombette",         "DamageB",          3),
    853:    (65,     4,      4,      "24_GhostBombette",         "DamageC",          5),
    854:    (36,     5,      0,      "24_GhostParakarry",        "Level",            23),
    855:    (36,     5,      1,      "24_GhostParakarry",        "HP",               15),
    856:    (65,     5,      2,      "24_GhostParakarry",        "DamageA",          2),
    857:    (65,     5,      3,      "24_GhostParakarry",        "DamageB",          3),
    858:    (65,     5,      4,      "24_GhostParakarry",        "DamageC",          5),
    859:    (36,     6,      0,      "24_GhostBow",              "Level",            23),
    860:    (36,     6,      1,      "24_GhostBow",              "HP",               15),
    861:    (65,     6,      2,      "24_GhostBow",              "DamageA",          1),
    862:    (65,     6,      3,      "24_GhostBow",              "DamageB",          1),
    863:    (65,     6,      4,      "24_GhostBow",              "DamageC",          1),
    864:    (36,     7,      0,      "24_GhostWatt",             "Level",            23),
    865:    (36,     7,      1,      "24_GhostWatt",             "HP",               15),
    866:    (65,     7,      2,      "24_GhostWatt",             "DamageA",          3),
    867:    (65,     7,      3,      "24_GhostWatt",             "DamageB",          4),
    868:    (65,     7,      4,      "24_GhostWatt",             "DamageC",          5),
    869:    (36,     8,      0,      "24_GhostSushie",           "Level",            23),
    870:    (36,     8,      1,      "24_GhostSushie",           "HP",               15),
    871:    (65,     8,      2,      "24_GhostSushie",           "DamageA",          3),
    872:    (65,     8,      3,      "24_GhostSushie",           "DamageB",          4),
    873:    (65,     8,      4,      "24_GhostSushie",           "DamageC",          5),
    874:    (36,     9,      0,      "24_GhostLakilester",       "Level",            23),
    875:    (36,     9,      1,      "24_GhostLakilester",       "HP",               15),
    876:    (65,     9,      2,      "24_GhostLakilester",       "DamageA",          3),
    877:    (65,     9,      3,      "24_GhostLakilester",       "DamageB",          4),
    878:    (65,     9,      4,      "24_GhostLakilester",       "DamageC",          5),
    879:    (37,     0,      0,      "25_BombshellBlaster",      "Level",            27),
    880:    (37,     0,      1,      "25_BombshellBlaster",      "HP",               10),
    881:    (37,     1,      0,      "25_BombshellBill",         "Level",            24),
    882:    (37,     1,      1,      "25_BombshellBill",         "HP",               3),
    883:    (37,     1,      2,      "25_BombshellBill",         "DamageA",          6),
    884:    (37,     2,      0,      "25_Koopatrol",             "Level",            25),
    885:    (37,     2,      1,      "25_Koopatrol",             "HP",               8),
    886:    (37,     2,      2,      "25_Koopatrol",             "DamageA",          4),
    887:    (37,     2,      3,      "25_Koopatrol",             "DamageB",          10),
    888:    (37,     3,      0,      "25_Magikoopa",             "Level",            26),
    889:    (37,     3,      1,      "25_Magikoopa",             "HP",               11),
    890:    (37,     3,      2,      "25_Magikoopa",             "DamageA",          6),
    891:    (37,     4,      0,      "25_FlyingMagikoopa",       "Level",            26),
    892:    (37,     4,      1,      "25_FlyingMagikoopa",       "HP",               11),
    893:    (37,     5,      0,      "25_Magiclone",             "Level",            26),
    894:    (37,     5,      1,      "25_Magiclone",             "HP",               11),
    895:    (37,     6,      0,      "25_FlyingMagiclone",       "Level",            26),
    896:    (37,     6,      1,      "25_FlyingMagiclone",       "HP",               11),
    897:    (39,     0,      0,      "27_Fuzzy",                 "Level",            6),
    898:    (39,     0,      1,      "27_Fuzzy",                 "HP",               3),
    899:    (39,     1,      0,      "27_Pokey",                 "Level",            9),
    900:    (39,     1,      1,      "27_Pokey",                 "HP",               4),
    901:    (39,     2,      0,      "27_BanditA",               "Level",            9),
    902:    (39,     2,      1,      "27_BanditA",               "HP",               5),
    903:    (39,     3,      0,      "27_BanditB",               "Level",            9),
    904:    (39,     3,      1,      "27_BanditB",               "HP",               5),
    905:    (39,     4,      0,      "27_ShyGuy",                "Level",            14),
    906:    (39,     4,      1,      "27_ShyGuy",                "HP",               7),
    907:    (39,     5,      0,      "27_TubbaBlubba",           "Level",            70),
    908:    (39,     5,      1,      "27_TubbaBlubba",           "HP",               10),
    909:    (39,     6,      0,      "27_MontyMole",             "Level",            8),
    910:    (39,     6,      1,      "27_MontyMole",             "HP",               3),
    911:    (39,     7,      0,      "27_EmptyMoleHole",         "Level",            9),
    912:    (39,     7,      1,      "27_EmptyMoleHole",         "HP",               5),
    913:    (41,     0,      0,      "29_ShySquad",              "Level",            0),
    914:    (41,     0,      1,      "29_ShySquad",              "HP",               15),
    915:    (41,     0,      2,      "29_ShySquad",              "DamageA",          1),
    916:    (42,     0,      0,      "2A_StiltGuy",              "Level",            0),
    917:    (42,     0,      1,      "2A_StiltGuy",              "HP",               7),
    918:    (42,     0,      2,      "2A_StiltGuy",              "DamageA",          4),
    919:    (42,     0,      3,      "2A_StiltGuy",              "DamageB",          2),
    920:    (42,     0,      4,      "2A_StiltGuy",              "DamageC",          3),
    921:    (43,     0,      0,      "2B_ShyStack",              "Level",            0),
    922:    (43,     0,      1,      "2B_ShyStack",              "HP",               10),
    923:    (43,     0,      2,      "2B_ShyStack",              "DamageA",          1),
    924:    (43,     0,      3,      "2B_ShyStack",              "DamageB",          2),
    925:    (43,     0,      4,      "2B_ShyStack",              "DamageC",          3),
    926:    (43,     0,      5,      "2B_ShyStack",              "DamageD",          4),
    927:    (44,     0,      0,      "2C_ShyGuy",                "Level",            0),
    928:    (44,     0,      1,      "2C_ShyGuy",                "HP",               8),
    929:    (45,     0,      0,      "2D_ShySquad",              "Level",            0),
    930:    (45,     0,      1,      "2D_ShySquad",              "HP",               15),
    931:    (45,     0,      2,      "2D_ShySquad",              "DamageA",          1),
    932:    (46,     0,      0,      "2E_ShyGuy",                "Level",            0),
    933:    (46,     0,      1,      "2E_ShyGuy",                "HP",               10),

}
