from BaseClasses import ItemClassification as Ic

#                                  0                     1                        2       3         4       5       6
#    Name                          Type            Progression                  ID, BasePrice, Unused, UnusedDupe, Unplaceable
item_table = {
    "Nothing":                  ("NOTHING",        Ic.filler,                     0,      0,      False,  False,  True),
    "Boots":                    ("OTHER",          Ic.filler,                     1,      50,     False,  False,  True),
    "SuperBoots":               ("OTHER",          Ic.filler,                     2,      50,     False,  False,  True),
    "UltraBoots":               ("OTHER",          Ic.filler,                     3,      50,     False,  False,  True),
    "Hammer":                   ("OTHER",          Ic.filler,                     4,      50,     False,  False,  True),
    "SuperHammer":              ("OTHER",          Ic.filler,                     5,      50,     False,  False,  True),
    "UltraHammer":              ("OTHER",          Ic.filler,                     6,      50,     False,  False,  True),
    "LuckyStar":                ("KEYITEM",        Ic.filler,                     7,      50,     False,  False,  True),
    "HomewardShroom":           ("KEYITEM",        Ic.filler,                     8,      1,      False,  False,  True),
    "BigMap":                   ("KEYITEM",        Ic.filler,                     9,      50,     False,  False,  True),
    "First Degree Card":        ("KEYITEM",        Ic.filler,                     10,     50,     False,  False,  False),
    "Second Degree Card":       ("KEYITEM",        Ic.filler,                     11,     50,     False,  False,  False),
    "Third Degree Card":        ("KEYITEM",        Ic.filler,                     12,     50,     False,  False,  False),
    "Fourth Degree Card":       ("KEYITEM",        Ic.filler,                     13,     50,     False,  False,  False),
    "Diploma":                  ("KEYITEM",        Ic.filler,                     14,     50,     False,  False,  False),
    "Ultra Stone":              ("KEYITEM",        Ic.useful,                     15,     50,     False,  False,  False),
    "Koopa Fortress Key":       ("KEYITEM",        Ic.progression,                16,     50,     False,  False,  False),
    "Ruins Key":                ("KEYITEM",        Ic.progression,                17,     50,     False,  False,  False),
    "Pulse Stone":              ("KEYITEM",        Ic.progression,                18,     50,     False,  False,  False),
    "Tubba Castle Key":         ("KEYITEM",        Ic.progression,                19,     50,     False,  False,  False),
    "Crystal Palace Key":       ("KEYITEM",        Ic.progression,                20,     50,     False,  False,  False),
    "Lunar Stone":              ("KEYITEM",        Ic.progression,                21,     50,     False,  False,  False),
    "Pyramid Stone":            ("KEYITEM",        Ic.progression,                22,     50,     False,  False,  False),
    "Diamond Stone":            ("KEYITEM",        Ic.progression,                23,     50,     False,  False,  False),
    "Kooper Shell":             ("KEYITEM",        Ic.progression,                25,     50,     False,  False,  False),
    "Bowser Castle Key":        ("KEYITEM",        Ic.progression,                26,     50,     False,  False,  False),
    "Forest Pass":              ("KEYITEM",        Ic.progression,                27,     50,     False,  False,  False),
    "Boo Weight":               ("KEYITEM",        Ic.progression,                28,     50,     False,  False,  False),
    "Boo Portrait":             ("KEYITEM",        Ic.progression,                29,     50,     False,  False,  False),
    "Crystal Berry":            ("KEYITEM",        Ic.progression,                30,     50,     False,  False,  False),
    "Mystical Key":             ("KEYITEM",        Ic.progression,                31,     50,     False,  False,  True),
    "Storeroom Key":            ("KEYITEM",        Ic.progression,                32,     50,     False,  False,  False),
    "Toy Train":                ("KEYITEM",        Ic.progression,                33,     50,     False,  False,  False),
    "Boo Record":               ("KEYITEM",        Ic.progression,                34,     50,     False,  False,  False),
    "Frying Pan":               ("KEYITEM",        Ic.progression,                35,     50,     False,  False,  False),
    "Dictionary":               ("KEYITEM",        Ic.progression,                36,     50,     False,  False,  False),
    "Mystery Note":             ("KEYITEM",        Ic.progression,                37,     50,     False,  False,  False),
    "SuspiciousNote":           ("KEYITEM",        Ic.filler,                     38,     50,     False,  False,  True),
    "Crystal Ball":             ("KEYITEM",        Ic.progression,                39,     50,     False,  False,  False),
    "Screwdriver":              ("KEYITEM",        Ic.filler,                     40,     50,     False,  False,  True),
    "Cookbook":                 ("KEYITEM",        Ic.progression,                41,     50,     False,  False,  False),
    "Jade Raven":               ("KEYITEM",        Ic.progression,                42,     50,     False,  False,  False),
    "Magical Seed":             ("KEYITEM",        Ic.progression,                43,     50,     False,  False,  False),
    "MagicalSeed2":             ("KEYITEM",        Ic.progression,                44,     50,     False,  False,  False),
    "MagicalSeed3":             ("KEYITEM",        Ic.progression,                45,     50,     False,  False,  False),
    "MagicalSeed4":             ("KEYITEM",        Ic.progression,                46,     50,     False,  False,  False),
    "ToadDoll":                 ("KEYITEM",        Ic.filler,                     47,     50,     False,  False,  True),
    "Calculator":               ("KEYITEM",        Ic.progression,                48,     50,     False,  False,  False),
    "Snowman Bucket":           ("KEYITEM",        Ic.progression,                49,     50,     False,  False,  False),
    "Snowman Scarf":            ("KEYITEM",        Ic.progression,                50,     50,     False,  False,  False),
    "Red Key":                  ("KEYITEM",        Ic.progression,                51,     50,     False,  False,  False),
    "Blue Key":                 ("KEYITEM",        Ic.progression,                52,     50,     False,  False,  False),
    "UnusedLetter01":           ("KEYITEM",        Ic.filler,                     53,     50,     False,  False,  True),
    "Letter to Merlon":         ("KEYITEM",        Ic.progression,                54,     50,     False,  False,  False),
    "Letter to Goompa":         ("KEYITEM",        Ic.progression,                55,     50,     False,  False,  False),
    "Letter to Mort T":         ("KEYITEM",        Ic.progression,                56,     50,     False,  False,  False),
    "Letter to Russ T":         ("KEYITEM",        Ic.progression,                57,     50,     False,  False,  False),
    "Letter to Mayor Penguin":  ("KEYITEM",        Ic.progression,                58,     50,     False,  False,  False),
    "Letter to Merlow":         ("KEYITEM",        Ic.progression,                59,     50,     False,  False,  False),
    "Letter to Fice T":         ("KEYITEM",        Ic.progression,                60,     50,     False,  False,  False),
    "Letter to Nomadimouse":    ("KEYITEM",        Ic.progression,                61,     50,     False,  False,  False),
    "Letter to Minh T":         ("KEYITEM",        Ic.progression,                62,     50,     False,  False,  False),
    "UnusedLetter02":           ("KEYITEM",        Ic.filler,                     63,     50,     False,  False,  True),
    "Letter to Goompapa 1":     ("KEYITEM",        Ic.progression,                64,     50,     False,  False,  False),
    "Letter to Igor":           ("KEYITEM",        Ic.progression,                65,     50,     False,  False,  False),
    "UnusedLetter03":           ("KEYITEM",        Ic.filler,                     66,     50,     False,  False,  True),
    "UnusedLetter04":           ("KEYITEM",        Ic.filler,                     67,     50,     False,  False,  True),
    "UnusedLetter05":           ("KEYITEM",        Ic.filler,                     68,     50,     False,  False,  True),
    "Letter to Franky":         ("KEYITEM",        Ic.progression,                69,     50,     False,  False,  False),
    "Letter to Muss T":         ("KEYITEM",        Ic.progression,                70,     50,     False,  False,  False),
    "Letter to Koover 1":       ("KEYITEM",        Ic.progression,                71,     50,     False,  False,  False),
    "Letter to Fishmael":       ("KEYITEM",        Ic.progression,                72,     50,     False,  False,  False),
    "Letter to Koover 2":       ("KEYITEM",        Ic.progression,                73,     50,     False,  False,  False),
    "Letter to Mr E":           ("KEYITEM",        Ic.progression,                74,     50,     False,  False,  False),
    "Letter to Miss T":         ("KEYITEM",        Ic.progression,                75,     50,     False,  False,  False),
    "Letter to Little Mouser":  ("KEYITEM",        Ic.progression,                76,     50,     False,  False,  False),
    "UnusedLetter06":           ("KEYITEM",        Ic.filler,                     77,     50,     False,  False,  True),
    "Letter to Dane T 1":       ("KEYITEM",        Ic.progression,                78,     50,     False,  False,  False),
    "Letter to Red Yoshi Kid":  ("KEYITEM",        Ic.progression,                79,     50,     False,  False,  False),
    "Letter to Dane T 2":       ("KEYITEM",        Ic.progression,                80,     50,     False,  False,  False),
    "Letter to Frost T":        ("KEYITEM",        Ic.progression,                81,     50,     False,  False,  False),
    "Letter to Goompapa 2":     ("KEYITEM",        Ic.progression,                82,     50,     False,  False,  False),
    "Artifact":                 ("KEYITEM",        Ic.progression,                83,     50,     False,  False,  False),
    "Letter to Kolorado":       ("KEYITEM",        Ic.progression,                84,     50,     False,  False,  False),
    "UnusedLetter07":           ("KEYITEM",        Ic.filler,                     85,     50,     False,  False,  True),
    "Dolly":                    ("KEYITEM",        Ic.progression,                86,     50,     False,  False,  False),
    "Water Stone":              ("KEYITEM",        Ic.progression,                87,     50,     False,  False,  False),
    "Magical Bean":             ("KEYITEM",        Ic.progression,                88,     50,     False,  False,  False),
    "Fertile Soil":             ("KEYITEM",        Ic.progression,                89,     50,     False,  False,  False),
    "Miracle Water":            ("KEYITEM",        Ic.progression,                90,     50,     False,  False,  False),
    "Volcano Vase":             ("KEYITEM",        Ic.progression,                91,     50,     False,  False,  False),
    "Koot Tape":                ("KEYITEM",        Ic.progression,                92,     50,     False,  False,  False),
    "BakingSugar":              ("KEYITEM",        Ic.filler,                     93,     50,     False,  False,  True),
    "BakingSalt":               ("KEYITEM",        Ic.filler,                     94,     50,     False,  False,  True),
    "BakingEgg":                ("KEYITEM",        Ic.filler,                     95,     50,     False,  False,  True),
    "BakingCream":              ("KEYITEM",        Ic.filler,                     96,     50,     False,  False,  True),
    "BakingStrawberry":         ("KEYITEM",        Ic.filler,                     97,     50,     False,  False,  True),
    "BakingButter":             ("KEYITEM",        Ic.filler,                     98,     50,     False,  False,  True),
    "BakingCleanser":           ("KEYITEM",        Ic.filler,                     99,     50,     False,  False,  True),
    "BakingWater":              ("KEYITEM",        Ic.filler,                     100,    50,     False,  False,  True),
    "BakingFlour":              ("KEYITEM",        Ic.filler,                     101,    50,     False,  False,  True),
    "BakingMilk":               ("KEYITEM",        Ic.filler,                     102,    50,     False,  False,  True),
    "Lyrics":                   ("KEYITEM",        Ic.progression,                103,    50,     False,  False,  False),
    "Melody":                   ("KEYITEM",        Ic.progression,                104,    50,     False,  False,  False),
    "Mailbag":                  ("KEYITEM",        Ic.progression,                105,    50,     False,  False,  False),
    "PeachKey1":                ("KEYITEM",        Ic.filler,                     106,    50,     False,  False,  True),
    "Odd Key":                  ("KEYITEM",        Ic.progression,                107,    50,     False,  False,  False),
    "Star Stone":               ("KEYITEM",        Ic.progression,                108,    50,     False,  False,  False),
    "SneakyParasol":            ("KEYITEM",        Ic.filler,                     109,    50,     False,  False,  True),
    "Koot Koopa Legends":       ("KEYITEM",        Ic.progression,                110,    50,     False,  False,  False),
    "Luigi Autograph":          ("KEYITEM",        Ic.progression,                111,    50,     False,  False,  False),
    "Koot Empty Wallet":        ("KEYITEM",        Ic.progression,                112,    50,     False,  False,  False),
    "Merluvlee Autograph":      ("KEYITEM",        Ic.progression,                113,    50,     False,  False,  False),
    "KootShell":                ("KEYITEM",        Ic.filler,                     114,    50,     False,  False,  True),
    "Koot Old Photo":           ("KEYITEM",        Ic.progression,                115,    50,     False,  False,  False),
    "Koot Glasses":             ("KEYITEM",        Ic.progression,                116,    50,     False,  False,  False),
    "KootAltPhoto":             ("KEYITEM",        Ic.filler,                     117,    50,     False,  False,  True),
    "Koot Package":             ("KEYITEM",        Ic.progression,                118,    50,     False,  False,  False),
    "Koot Red Jar":             ("KEYITEM",        Ic.progression,                119,    50,     False,  False,  False),
    "PeachKey2":                ("KEYITEM",        Ic.filler,                     120,    50,     False,  False,  True),
    "Warehouse Key":            ("KEYITEM",        Ic.progression,                121,    50,     False,  False,  False),
    "PrisonKey1":               ("KEYITEM",        Ic.filler,                     122,    50,     False,  False,  True),
    "Silver Credit":            ("KEYITEM",        Ic.filler,                     123,    50,     False,  False,  False),
    "Gold Credit":              ("KEYITEM",        Ic.filler,                     124,    50,     False,  False,  False),
    "PrisonKey2":               ("KEYITEM",        Ic.filler,                     125,    50,     False,  False,  True),
    "PrisonKey3":               ("KEYITEM",        Ic.filler,                     126,    50,     False,  False,  True),
    "PrisonKey4":               ("KEYITEM",        Ic.filler,                     127,    50,     False,  False,  True),
    "Fire Flower":              ("ITEM",           Ic.filler,                     128,    4,      False,  False,  False),
    "Snowman Doll":             ("ITEM",           Ic.filler,                     129,    6,      False,  False,  False),
    "Thunder Rage":             ("ITEM",           Ic.filler,                     130,    8,      False,  False,  False),
    "Shooting Star":            ("ITEM",           Ic.filler,                     131,    15,     False,  False,  False),
    "Thunder Bolt":             ("ITEM",           Ic.filler,                     132,    4,      False,  False,  False),
    "Pebble":                   ("ITEM",           Ic.filler,                     133,    1,      False,  False,  False),
    "Dusty Hammer":             ("ITEM",           Ic.filler,                     134,    1,      False,  False,  False),
    "Insecticide Herb":         ("ITEM",           Ic.filler,                     135,    1,      True,   False,  False),
    "Stone Cap":                ("ITEM",           Ic.filler,                     136,    15,     False,  False,  False),
    "Tasty Tonic":              ("ITEM",           Ic.progression,                137,    1,      False,  False,  False),
    "Mushroom":                 ("ITEM",           Ic.filler,                     138,    2,      False,  False,  False),
    "Volt Shroom":              ("ITEM",           Ic.filler,                     139,    7,      False,  False,  False),
    "Super Shroom":             ("ITEM",           Ic.progression,                140,    7,      False,  False,  False),
    "Dried Shroom":             ("ITEM",           Ic.filler,                     141,    1,      False,  False,  False),
    "Ultra Shroom":             ("ITEM",           Ic.filler,                     142,    50,     False,  False,  False),
    "Sleepy Sheep":             ("ITEM",           Ic.progression,                143,    4,      False,  False,  False),
    "POW Block":                ("ITEM",           Ic.filler,                     144,    3,      False,  False,  False),
    "Hustle Drink":             ("ITEM",           Ic.filler,                     145,    10,     True,   False,  False),
    "Stop Watch":               ("ITEM",           Ic.filler,                     146,    10,     False,  False,  False),
    "Whackas Bump":             ("ITEM",           Ic.filler,                     147,    30,     False,  False,  False),
    "Apple":                    ("ITEM",           Ic.filler,                     148,    2,      False,  False,  False),
    "Life Shroom":              ("ITEM",           Ic.useful,                     149,    20,     False,  False,  False),
    "Mystery":                  ("ITEM",           Ic.filler,                     150,    1,      False,  False,  False),
    "Repel Gel":                ("ITEM",           Ic.filler,                     151,    15,     False,  False,  False),
    "Fright Jar":               ("ITEM",           Ic.filler,                     152,    3,      False,  False,  False),
    "PleaseComeBack":           ("ITEM",           Ic.filler,                     153,    5,      False,  False,  True),
    "Dizzy Dial":               ("ITEM",           Ic.filler,                     154,    6,      False,  False,  False),
    "Super Soda":               ("ITEM",           Ic.filler,                     155,    3,      False,  False,  False),
    "Lemon":                    ("ITEM",           Ic.progression,                156,    1,      False,  False,  False),
    "Lime":                     ("ITEM",           Ic.progression,                157,    1,      False,  False,  False),
    "Blue Berry":               ("ITEM",           Ic.progression,                158,    2,      False,  False,  False),
    "Red Berry":                ("ITEM",           Ic.progression,                159,    2,      False,  False,  False),
    "Yellow Berry":             ("ITEM",           Ic.progression,                160,    2,      False,  False,  False),
    "Bubble Berry":             ("ITEM",           Ic.progression,                161,    3,      False,  False,  False),
    "Jammin Jelly":             ("ITEM",           Ic.filler,                     162,    50,     False,  False,  False),
    "Maple Syrup":              ("ITEM",           Ic.filler,                     163,    10,     False,  False,  False),
    "Honey Syrup":              ("ITEM",           Ic.filler,                     164,    3,      False,  False,  False),
    "Goomnut":                  ("ITEM",           Ic.progression,                165,    2,      False,  False,  False),
    "Koopa Leaf":               ("ITEM",           Ic.progression,                166,    1,      False,  False,  False),
    "Dried Pasta":              ("ITEM",           Ic.progression,                167,    4,      False,  False,  False),
    "Dried Fruit":              ("ITEM",           Ic.filler,                     168,    5,      False,  False,  False),
    "Strange Leaf":             ("ITEM",           Ic.progression,                169,    2,      False,  False,  False),
    "Cake Mix":                 ("ITEM",           Ic.progression,                170,    3,      False,  False,  False),
    "Egg":                      ("ITEM",           Ic.filler,                     171,    2,      False,  False,  False),
    "Coconut":                  ("ITEM",           Ic.progression,                172,    1,      False,  False,  False),
    "Melon":                    ("ITEM",           Ic.filler,                     173,    7,      False,  False,  False),
    "Stinky Herb":              ("ITEM",           Ic.filler,                     174,    1,      False,  False,  False),
    "Iced Potato":              ("ITEM",           Ic.filler,                     175,    3,      False,  False,  False),
    "Spicy Soup":               ("ITEM",           Ic.filler,                     176,    10,     False,  False,  False),
    "Apple Pie":                ("ITEM",           Ic.filler,                     177,    10,     False,  False,  False),
    "Honey Ultra":              ("ITEM",           Ic.filler,                     178,    75,     False,  False,  False),
    "Maple Ultra":              ("ITEM",           Ic.filler,                     179,    100,    False,  False,  False),
    "Jelly Ultra":              ("ITEM",           Ic.useful,                     180,    150,    False,  False,  False),
    "Koopasta":                 ("ITEM",           Ic.filler,                     181,    10,     False,  False,  False),
    "Fried Shroom":             ("ITEM",           Ic.filler,                     182,    5,      False,  False,  False),
    "Shroom Cake":              ("ITEM",           Ic.filler,                     183,    20,     False,  False,  False),
    "Shroom Steak":             ("ITEM",           Ic.filler,                     184,    45,     False,  False,  False),
    "Hot Shroom":               ("ITEM",           Ic.filler,                     185,    15,     False,  False,  False),
    "Sweet Shroom":             ("ITEM",           Ic.filler,                     186,    50,     False,  False,  False),
    "Yummy Meal":               ("ITEM",           Ic.filler,                     187,    15,     False,  False,  False),
    "Healthy Juice":            ("ITEM",           Ic.filler,                     188,    25,     False,  False,  False),
    "Bland Meal":               ("ITEM",           Ic.filler,                     189,    10,     False,  False,  False),
    "Deluxe Feast":             ("ITEM",           Ic.filler,                     190,    60,     False,  False,  False),
    "Special Shake":            ("ITEM",           Ic.filler,                     191,    10,     False,  False,  False),
    "Big Cookie":               ("ITEM",           Ic.filler,                     192,    10,     False,  False,  False),
    "Cake":                     ("ITEM",           Ic.filler,                     193,    10,     False,  False,  False),
    "Mistake":                  ("ITEM",           Ic.filler,                     194,    1,      False,  False,  False),
    "Koopa Tea":                ("ITEM",           Ic.filler,                     195,    3,      False,  False,  False),
    "Honey Super":              ("ITEM",           Ic.filler,                     196,    20,     False,  False,  False),
    "Maple Super":              ("ITEM",           Ic.filler,                     197,    35,     False,  False,  False),
    "Jelly Super":              ("ITEM",           Ic.filler,                     198,    100,    False,  False,  False),
    "Spaghetti":                ("ITEM",           Ic.filler,                     199,    7,      False,  False,  False),
    "Egg Missile":              ("ITEM",           Ic.filler,                     200,    10,     False,  False,  False),
    "Fried Egg":                ("ITEM",           Ic.filler,                     201,    7,      False,  False,  False),
    "Honey Shroom":             ("ITEM",           Ic.filler,                     202,    10,     False,  False,  False),
    "Honey Candy":              ("ITEM",           Ic.filler,                     203,    15,     False,  False,  False),
    "Electro Pop":              ("ITEM",           Ic.filler,                     204,    25,     False,  False,  False),
    "Fire Pop":                 ("ITEM",           Ic.filler,                     205,    20,     False,  False,  False),
    "Lime Candy":               ("ITEM",           Ic.filler,                     206,    15,     False,  False,  False),
    "Coco Pop":                 ("ITEM",           Ic.filler,                     207,    12,     False,  False,  False),
    "Lemon Candy":              ("ITEM",           Ic.filler,                     208,    15,     False,  False,  False),
    "Jelly Pop":                ("ITEM",           Ic.useful,                     209,    100,    False,  False,  False),
    "Strange Cake":             ("ITEM",           Ic.filler,                     210,    10,     False,  False,  False),
    "Kooky Cookie":             ("ITEM",           Ic.filler,                     211,    12,     False,  False,  False),
    "Frozen Fries":             ("ITEM",           Ic.filler,                     212,    15,     False,  False,  False),
    "Potato Salad":             ("ITEM",           Ic.filler,                     213,    6,      False,  False,  False),
    "Nutty Cake":               ("ITEM",           Ic.filler,                     214,    6,      False,  False,  False),
    "Maple Shroom":             ("ITEM",           Ic.filler,                     215,    25,     False,  False,  False),
    "Boiled Egg":               ("ITEM",           Ic.filler,                     216,    10,     False,  False,  False),
    "Yoshi Cookie":             ("ITEM",           Ic.filler,                     217,    20,     False,  False,  False),
    "Jelly Shroom":             ("ITEM",           Ic.filler,                     218,    75,     False,  False,  False),
    "JellyShroom2":             ("ITEM",           Ic.filler,                     219,    75,     False,  False,  True),
    "JellyShroom3":             ("ITEM",           Ic.filler,                     220,    75,     False,  False,  True),
    "JellyShroom4":             ("ITEM",           Ic.filler,                     221,    75,     False,  False,  True),
    "JellyShroom5":             ("ITEM",           Ic.filler,                     222,    75,     False,  False,  True),
    "JellyShroom6":             ("ITEM",           Ic.filler,                     223,    75,     False,  False,  True),
    "Spin Smash":               ("BADGE",          Ic.filler,                     224,    75,     False,  False,  False),
    "Multibounce":              ("BADGE",          Ic.useful,                     225,    75,     False,  False,  False),
    "Power Plus":               ("BADGE",          Ic.useful,                     226,    250,    False,  False,  False),
    "Dodge Master":             ("BADGE",          Ic.useful,                     227,    100,    False,  False,  False),
    "Power Bounce":             ("BADGE",          Ic.useful,                     228,    100,    False,  False,  False),
    "Spike Shield":             ("BADGE",          Ic.useful,                     229,    100,    False,  False,  False),
    "First Attack":             ("BADGE",          Ic.filler,                     230,    100,    False,  False,  False),
    "HP Plus":                  ("BADGE",          Ic.useful,                     231,    150,    False,  False,  False),
    "Quake Hammer":             ("BADGE",          Ic.filler,                     232,    100,    False,  False,  False),
    "Double Dip":               ("BADGE",          Ic.filler,                     233,    100,    False,  False,  False),
    "MysteryScroll":            ("BADGE",          Ic.filler,                     234,    100,    False,  False,  True),
    "Sleep Stomp":              ("BADGE",          Ic.filler,                     235,    75,     False,  False,  False),
    "Fire Shield":              ("BADGE",          Ic.useful,                     236,    75,     False,  False,  False),
    "Quick Change":             ("BADGE",          Ic.useful,                     237,    200,    False,  False,  False),
    "D-Down Pound":             ("BADGE",          Ic.filler,                     238,    75,     False,  False,  False),
    "Dizzy Stomp":              ("BADGE",          Ic.useful,                     239,    75,     False,  False,  False),
    "Mini Smash Charge":        ("BADGE",          Ic.filler,                     240,    30,     True,   False,  False),
    "Pretty Lucky":             ("BADGE",          Ic.filler,                     241,    100,    False,  False,  False),
    "Feeling Fine":             ("BADGE",          Ic.filler,                     242,    100,    False,  False,  False),
    "Attack FX A":              ("BADGE",          Ic.filler,                     243,    30,     False,  False,  False),
    "All or Nothing":           ("BADGE",          Ic.useful,                     244,    100,    False,  False,  False),
    "HP Drain":                 ("BADGE",          Ic.filler,                     245,    50,     False,  False,  False),
    "Mini Jump Charge":         ("BADGE",          Ic.filler,                     246,    30,     True,   False,  False),
    "Slow Go":                  ("BADGE",          Ic.filler,                     247,    10,     False,  False,  False),
    "FP Plus":                  ("BADGE",          Ic.useful,                     248,    150,    False,  False,  False),
    "Mega Rush":                ("BADGE",          Ic.useful,                     249,    50,     False,  False,  False),
    "Ice Power":                ("BADGE",          Ic.useful,                     250,    75,     False,  False,  False),
    "Defend Plus":              ("BADGE",          Ic.useful,                     251,    250,    False,  False,  False),
    "Pay Off":                  ("BADGE",          Ic.filler,                     252,    50,     False,  False,  False),
    "Money Money":              ("BADGE",          Ic.filler,                     253,    200,    False,  False,  False),
    "Chill Out":                ("BADGE",          Ic.filler,                     254,    50,     False,  False,  False),
    "Happy Heart":              ("BADGE",          Ic.filler,                     255,    100,    False,  False,  False),
    "Zap Tap":                  ("BADGE",          Ic.useful,                     256,    100,    False,  False,  False),
    "Berserker":                ("BADGE",          Ic.filler,                     257,    300,    True,   False,  False),
    "Right On":                 ("BADGE",          Ic.filler,                     258,    300,    True,   False,  False),
    "Runaway Pay":              ("BADGE",          Ic.useful,                     259,    50,     False,  False,  False),
    "Refund":                   ("BADGE",          Ic.useful,                     260,    50,     False,  False,  False),
    "Flower Saver":             ("BADGE",          Ic.useful,                     261,    250,    False,  False,  False),
    "Triple Dip":               ("BADGE",          Ic.filler,                     262,    200,    False,  False,  False),
    "Hammer Throw":             ("BADGE",          Ic.filler,                     263,    75,     False,  False,  False),
    "Mega Quake":               ("BADGE",          Ic.useful,                     264,    200,    False,  False,  False),
    "Smash Charge":             ("BADGE",          Ic.filler,                     265,    50,     False,  False,  False),
    "Jump Charge":              ("BADGE",          Ic.useful,                     266,    50,     False,  False,  False),
    "Super Smash Charge":       ("BADGE",          Ic.useful,                     267,    100,    False,  False,  False),
    "Super Jump Charge":        ("BADGE",          Ic.useful,                     268,    100,    False,  False,  False),
    "Power Rush":               ("BADGE",          Ic.filler,                     269,    50,     False,  False,  False),
    "Auto Jump":                ("BADGE",          Ic.filler,                     270,    50,     True,   False,  False),
    "Auto Smash":               ("BADGE",          Ic.filler,                     271,    50,     True,   False,  False),
    "Crazy Heart":              ("BADGE",          Ic.filler,                     272,    300,    True,   False,  False),
    "Last Stand":               ("BADGE",          Ic.useful,                     273,    50,     False,  False,  False),
    "Close Call":               ("BADGE",          Ic.useful,                     274,    50,     False,  False,  False),
    "P-Up D-Down":              ("BADGE",          Ic.useful,                     275,    100,    False,  False,  False),
    "Lucky Day":                ("BADGE",          Ic.useful,                     276,    300,    False,  False,  False),
    "Mega HP Drain":            ("BADGE",          Ic.filler,                     277,    100,    True,   False,  False),
    "P-Down D-Up":              ("BADGE",          Ic.filler,                     278,    100,    False,  False,  False),
    "Power Quake":              ("BADGE",          Ic.useful,                     279,    150,    False,  False,  False),
    "Auto Multibounce":         ("BADGE",          Ic.filler,                     280,    75,     True,   False,  False),
    "Flower Fanatic":           ("BADGE",          Ic.useful,                     281,    300,    True,   False,  False),
    "Heart Finder":             ("BADGE",          Ic.filler,                     282,    75,     False,  False,  False),
    "Flower Finder":            ("BADGE",          Ic.filler,                     283,    75,     False,  False,  False),
    "Spin Attack":              ("BADGE",          Ic.filler,                     284,    150,    False,  False,  False),
    "Dizzy Attack":             ("BADGE",          Ic.filler,                     285,    100,    False,  False,  False),
    "I Spy":                    ("BADGE",          Ic.filler,                     286,    200,    False,  False,  False),
    "Speedy Spin":              ("BADGE",          Ic.filler,                     287,    50,     False,  False,  False),
    "Bump Attack":              ("BADGE",          Ic.filler,                     288,    200,    False,  False,  False),
    "Power Jump":               ("BADGE",          Ic.filler,                     289,    50,     False,  False,  False),
    "Super Jump":               ("BADGE",          Ic.filler,                     290,    100,    True,   False,  False),
    "Mega Jump":                ("BADGE",          Ic.filler,                     291,    200,    False,  False,  False),
    "Power Smash":              ("BADGE",          Ic.filler,                     292,    50,     False,  False,  False),
    "Super Smash":              ("BADGE",          Ic.filler,                     293,    100,    True,   False,  False),
    "Mega Smash":               ("BADGE",          Ic.filler,                     294,    200,    False,  False,  False),
    "PowerSmash2":              ("BADGE",          Ic.filler,                     295,    50,     False,  False,  True),
    "PowerSmash3":              ("BADGE",          Ic.filler,                     296,    50,     False,  False,  True),
    "Deep Focus":               ("BADGE",          Ic.filler,                     297,    50,     False,  False,  False),
    "Super Focus":              ("BADGE",          Ic.filler,                     298,    100,    True,   False,  False),
    "Shrink Smash":             ("BADGE",          Ic.filler,                     299,    75,     True,   False,  False),
    "ShellCrack":               ("BADGE",          Ic.filler,                     300,    100,    False,  False,  True),
    "Kaiden":                   ("BADGE",          Ic.filler,                     301,    300,    False,  False,  True),
    "D-Down Jump":              ("BADGE",          Ic.useful,                     302,    100,    False,  False,  False),
    "Shrink Stomp":             ("BADGE",          Ic.filler,                     303,    75,     False,  False,  False),
    "Damage Dodge":             ("BADGE",          Ic.useful,                     304,    150,    False,  False,  False),
    "Quake Bounce":             ("BADGE",          Ic.useful,                     305,    100,    True,   False,  False),
    "DeepFocus2":               ("BADGE",          Ic.filler,                     306,    50,     False,  False,  False),
    "DeepFocus3":               ("BADGE",          Ic.filler,                     307,    50,     False,  False,  False),
    "HPPlusB":                  ("BADGE",          Ic.useful,                     308,    150,    False,  False,  False),
    "FPPlusB":                  ("BADGE",          Ic.useful,                     309,    150,    False,  False,  False),
    "HappyHeartB":              ("BADGE",          Ic.filler,                     310,    100,    False,  False,  False),
    "HappyHeartX":              ("BADGE",          Ic.filler,                     311,    100,    True,   True,   False),
    "FlowerSaverB":             ("BADGE",          Ic.useful,                     312,    250,    False,  False,  False),
    "FlowerSaverX":             ("BADGE",          Ic.useful,                     313,    250,    True,   True,   False),
    "DamageDodgeB":             ("BADGE",          Ic.useful,                     314,    150,    False,  False,  False),
    "DamageDodgeX":             ("BADGE",          Ic.useful,                     315,    150,    True,   True,   False),
    "PowerPlusB":               ("BADGE",          Ic.useful,                     316,    250,    False,  False,  False),
    "PowerPlusX":               ("BADGE",          Ic.useful,                     317,    250,    True,   True,   False),
    "DefendPlusX":              ("BADGE",          Ic.useful,                     318,    250,    True,   True,   False),
    "DefendPlusY":              ("BADGE",          Ic.useful,                     319,    250,    True,   True,   False),
    "Happy Flower":             ("BADGE",          Ic.filler,                     320,    100,    False,  False,  False),
    "HappyFlowerB":             ("BADGE",          Ic.filler,                     321,    100,    False,  False,  False),
    "HappyFlowerX":             ("BADGE",          Ic.filler,                     322,    100,    True,   True,   False),
    "Group Focus":              ("BADGE",          Ic.filler,                     323,    100,    False,  False,  False),
    "Peekaboo":                 ("BADGE",          Ic.filler,                     324,    100,    False,  False,  False),
    "Attack FX D":              ("BADGE",          Ic.filler,                     325,    30,     False,  False,  False),
    "Attack FX B":              ("BADGE",          Ic.filler,                     326,    30,     False,  False,  False),
    "Attack FX E":              ("BADGE",          Ic.filler,                     327,    30,     False,  False,  False),
    "Attack FX C":              ("BADGE",          Ic.filler,                     328,    30,     False,  False,  False),
    "Attack FX F":              ("BADGE",          Ic.filler,                     329,    30,     True,   False,  False),
    "HPPlusC":                  ("BADGE",          Ic.useful,                     330,    150,    False,  False,  False),
    "HPPlusX":                  ("BADGE",          Ic.useful,                     331,    150,    True,   True,   False),
    "HPPlusY":                  ("BADGE",          Ic.useful,                     332,    150,    True,   True,   False),
    "FPPlusC":                  ("BADGE",          Ic.useful,                     333,    150,    False,  False,  False),
    "FPPlusX":                  ("BADGE",          Ic.useful,                     334,    150,    True,   True,   False),
    "FPPlusY":                  ("BADGE",          Ic.useful,                     335,    150,    True,   True,   False),
    "Healthy Healthy":          ("BADGE",          Ic.filler,                     336,    100,    True,   False,  False),
    "Attack FX F2":             ("BADGE",          Ic.filler,                     337,    30,     False,  False,  True),
    "Attack FX F3":             ("BADGE",          Ic.filler,                     338,    30,     False,  False,  True),
    "Attack FX F4":             ("BADGE",          Ic.filler,                     339,    30,     False,  False,  True),
    "Attack FX F5":             ("BADGE",          Ic.filler,                     340,    30,     False,  False,  True),
    "PartnerAttack":            ("BADGE",          Ic.filler,                     341,    1,      False,  False,  True),
    "Heart":                    ("HEART",          Ic.filler,                     342,    50,     False,  False,  True),
    "Coin":                     ("COIN",           Ic.filler,                     343,    1,      False,  False,  False),
    "HeartPiece":               ("",               Ic.filler,                     344,    50,     False,  False,  True),
    "StarPoint":                ("STARPOINT",      Ic.filler,                     345,    50,     False,  False,  True),
    "HeartPoint":               ("FULLHEAL",       Ic.filler,                     346,    50,     False,  False,  True),
    "FlowerPoint":              ("FLOWER",         Ic.filler,                     347,    1,      False,  False,  True),
    "Star Piece":               ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 348,    1,      False,  False,  False),
    "Present":                  ("OTHER",          Ic.filler,                     349,    0,      False,  False,  True),
    "CakeDone":                 ("OTHER",          Ic.filler,                     350,    0,      False,  False,  True),
    "CakeBare":                 ("OTHER",          Ic.filler,                     351,    0,      False,  False,  True),
    "CakePan":                  ("OTHER",          Ic.filler,                     352,    0,      False,  False,  True),
    "CakeBatter":               ("OTHER",          Ic.filler,                     353,    0,      False,  False,  True),
    "CakeBowl":                 ("OTHER",          Ic.filler,                     354,    0,      False,  False,  True),
    "CakeMixed":                ("OTHER",          Ic.filler,                     355,    0,      False,  False,  True),
    "CakeWithIcing":            ("OTHER",          Ic.filler,                     356,    0,      False,  False,  True),
    "CakeWithBerries":          ("OTHER",          Ic.filler,                     357,    0,      False,  False,  True),
    "Hammer1Icon":              ("OTHER",          Ic.filler,                     358,    0,      False,  False,  True),
    "Hammer2Icon":              ("OTHER",          Ic.filler,                     359,    0,      False,  False,  True),
    "Hammer3Icon":              ("OTHER",          Ic.filler,                     360,    0,      False,  False,  True),
    "Boots1Icon":               ("OTHER",          Ic.filler,                     361,    0,      False,  False,  True),
    "Boots2Icon":               ("OTHER",          Ic.filler,                     362,    0,      False,  False,  True),
    "Boots3Icon":               ("OTHER",          Ic.filler,                     363,    0,      False,  False,  True),
    "ItemsIcon":                ("OTHER",          Ic.filler,                     364,    0,      False,  False,  True),
    "KoopaFortressKeyA":        ("KEYITEM",        Ic.progression,                365,    50,     False,  False,  False),
    "KoopaFortressKeyB":        ("KEYITEM",        Ic.progression,                366,    50,     False,  False,  False),
    "KoopaFortressKeyC":        ("KEYITEM",        Ic.progression,                367,    50,     False,  False,  False),
    "KoopaFortressKeyD":        ("KEYITEM",        Ic.progression,                368,    50,     False,  False,  False),
    "RuinsKeyA":                ("KEYITEM",        Ic.progression,                369,    50,     False,  False,  False),
    "RuinsKeyB":                ("KEYITEM",        Ic.progression,                370,    50,     False,  False,  False),
    "RuinsKeyC":                ("KEYITEM",        Ic.progression,                371,    50,     False,  False,  False),
    "RuinsKeyD":                ("KEYITEM",        Ic.progression,                372,    50,     False,  False,  False),
    "TubbaCastleKeyA":          ("KEYITEM",        Ic.progression,                373,    50,     False,  False,  False),
    "TubbaCastleKeyB":          ("KEYITEM",        Ic.progression,                374,    50,     False,  False,  False),
    "TubbaCastleKeyC":          ("KEYITEM",        Ic.progression,                375,    50,     False,  False,  False),
    "BowserCastleKeyA":         ("KEYITEM",        Ic.progression,                376,    50,     False,  False,  False),
    "BowserCastleKeyB":         ("KEYITEM",        Ic.progression,                377,    50,     False,  False,  False),
    "BowserCastleKeyC":         ("KEYITEM",        Ic.progression,                378,    50,     False,  False,  False),
    "BowserCastleKeyD":         ("KEYITEM",        Ic.progression,                379,    50,     False,  False,  False),
    "BowserCastleKeyE":         ("KEYITEM",        Ic.progression,                380,    50,     False,  False,  False),
    "Prison Key":               ("KEYITEM",        Ic.filler,                     381,    50,     False,  False,  False),
    "PrisonKeyB":               ("KEYITEM",        Ic.filler,                     382,    50,     False,  False,  False),
    "CakeKey":                  ("OTHER",          Ic.filler,                     383,    50,     False,  False,  True),
    "BlueBerryKey1":            ("OTHER",          Ic.filler,                     384,    50,     False,  False,  True),
    "BlueBerryKey2":            ("OTHER",          Ic.filler,                     385,    50,     False,  False,  True),
    "RedBerryKey":              ("OTHER",          Ic.filler,                     386,    50,     False,  False,  True),
    "YellowBerryKey":           ("OTHER",          Ic.filler,                     387,    50,     False,  False,  True),
    "BubbleBerryKey":           ("OTHER",          Ic.filler,                     388,    50,     False,  False,  True),
    "StarPiece00":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 389,    1,      False,  False,  False),
    "StarPiece01":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 390,    1,      False,  False,  False),
    "StarPiece02":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 391,    1,      False,  False,  False),
    "StarPiece03":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 392,    1,      False,  False,  False),
    "StarPiece04":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 393,    1,      False,  False,  False),
    "StarPiece05":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 394,    1,      False,  False,  False),
    "StarPiece06":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 395,    1,      False,  False,  False),
    "StarPiece07":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 396,    1,      False,  False,  False),
    "StarPiece08":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 397,    1,      False,  False,  False),
    "StarPiece09":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 398,    1,      False,  False,  False),
    "StarPiece0A":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 399,    1,      False,  False,  False),
    "StarPiece0B":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 400,    1,      False,  False,  False),
    "StarPiece0C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 401,    1,      False,  False,  False),
    "StarPiece0D":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 402,    1,      False,  False,  False),
    "StarPiece0E":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 403,    1,      False,  False,  False),
    "StarPiece0F":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 404,    1,      False,  False,  False),
    "StarPiece10":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 405,    1,      False,  False,  False),
    "StarPiece11":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 406,    1,      False,  False,  False),
    "StarPiece12":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 407,    1,      False,  False,  False),
    "StarPiece13":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 408,    1,      False,  False,  False),
    "StarPiece14":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 409,    1,      False,  False,  False),
    "StarPiece15":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 410,    1,      False,  False,  False),
    "StarPiece16":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 411,    1,      False,  False,  False),
    "StarPiece17":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 412,    1,      False,  False,  False),
    "StarPiece18":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 413,    1,      False,  False,  False),
    "StarPiece19":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 414,    1,      False,  False,  False),
    "StarPiece1A":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 415,    1,      False,  False,  False),
    "StarPiece1B":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 416,    1,      False,  False,  False),
    "StarPiece1C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 417,    1,      False,  False,  False),
    "StarPiece1D":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 418,    1,      False,  False,  False),
    "StarPiece1E":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 419,    1,      False,  False,  False),
    "StarPiece1F":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 420,    1,      False,  False,  False),
    "StarPiece20":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 421,    1,      False,  False,  False),
    "StarPiece21":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 422,    1,      False,  False,  False),
    "StarPiece22":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 423,    1,      False,  False,  False),
    "StarPiece23":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 424,    1,      False,  False,  False),
    "StarPiece24":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 425,    1,      False,  False,  False),
    "StarPiece25":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 426,    1,      False,  False,  False),
    "StarPiece26":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 427,    1,      False,  False,  False),
    "StarPiece27":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 428,    1,      False,  False,  False),
    "StarPiece28":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 429,    1,      False,  False,  False),
    "StarPiece29":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 430,    1,      False,  False,  False),
    "StarPiece2A":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 431,    1,      False,  False,  False),
    "StarPiece2B":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 432,    1,      False,  False,  False),
    "StarPiece2C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 433,    1,      False,  False,  False),
    "StarPiece2D":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 434,    1,      False,  False,  False),
    "StarPiece2E":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 435,    1,      False,  False,  False),
    "StarPiece2F":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 436,    1,      False,  False,  False),
    "StarPiece30":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 437,    1,      False,  False,  False),
    "StarPiece31":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 438,    1,      False,  False,  False),
    "StarPiece32":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 439,    1,      False,  False,  False),
    "StarPiece33":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 440,    1,      False,  False,  False),
    "StarPiece34":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 441,    1,      False,  False,  False),
    "StarPiece35":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 442,    1,      False,  False,  False),
    "StarPiece36":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 443,    1,      False,  False,  False),
    "StarPiece37":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 444,    1,      False,  False,  False),
    "StarPiece38":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 445,    1,      False,  False,  False),
    "StarPiece39":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 446,    1,      False,  False,  False),
    "StarPiece3A":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 447,    1,      False,  False,  False),
    "StarPiece3B":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 448,    1,      False,  False,  False),
    "StarPiece3C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 449,    1,      False,  False,  False),
    "StarPiece3C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 449,    1,      False,  False,  False),
    "StarPiece3D":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 450,    1,      False,  False,  False),
    "StarPiece3E":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 451,    1,      False,  False,  False),
    "StarPiece3F":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 452,    1,      False,  False,  False),
    "StarPiece40":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 453,    1,      False,  False,  False),
    "StarPiece41":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 454,    1,      False,  False,  False),
    "StarPiece42":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 455,    1,      False,  False,  False),
    "StarPiece43":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 456,    1,      False,  False,  False),
    "StarPiece44":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 457,    1,      False,  False,  False),
    "StarPiece45":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 458,    1,      False,  False,  False),
    "StarPiece46":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 459,    1,      False,  False,  False),
    "StarPiece47":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 460,    1,      False,  False,  False),
    "StarPiece48":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 461,    1,      False,  False,  False),
    "StarPiece49":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 462,    1,      False,  False,  False),
    "StarPiece4A":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 463,    1,      False,  False,  False),
    "StarPiece4B":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 464,    1,      False,  False,  False),
    "StarPiece4C":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 465,    1,      False,  False,  False),
    "StarPiece4D":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 466,    1,      False,  False,  False),
    "StarPiece4E":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 467,    1,      False,  False,  False),
    "StarPiece4F":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 468,    1,      False,  False,  False),
    "StarPiece50":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 469,    1,      False,  False,  False),
    "StarPiece51":              ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 470,    1,      False,  False,  False),
    "3x Star Pieces":           ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 471,    1,      False,  False,  False),
    "ThreeStarPieces1":         ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 472,    1,      False,  False,  False),
    "ThreeStarPieces2":         ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 473,    1,      False,  False,  False),
    "ThreeStarPieces3":         ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 474,    1,      False,  False,  False),
    "ThreeStarPieces4":         ("STARPIECE",      Ic.progression_deprioritized_skip_balancing, 475,    1,      False,  False,  False),
    "Power Star":               ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 476,    1,      False,  False,  False),
    "PowerStar01":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 477,    1,      False,  False,  False),
    "PowerStar02":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 478,    1,      False,  False,  False),
    "PowerStar03":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 479,    1,      False,  False,  False),
    "PowerStar04":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 480,    1,      False,  False,  False),
    "PowerStar05":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 481,    1,      False,  False,  False),
    "PowerStar06":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 482,    1,      False,  False,  False),
    "PowerStar07":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 483,    1,      False,  False,  False),
    "PowerStar08":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 484,    1,      False,  False,  False),
    "PowerStar09":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 485,    1,      False,  False,  False),
    "PowerStar0A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 486,    1,      False,  False,  False),
    "PowerStar0B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 487,    1,      False,  False,  False),
    "PowerStar0C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 488,    1,      False,  False,  False),
    "PowerStar0D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 489,    1,      False,  False,  False),
    "PowerStar0E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 490,    1,      False,  False,  False),
    "PowerStar0F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 491,    1,      False,  False,  False),
    "PowerStar10":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 492,    1,      False,  False,  False),
    "PowerStar11":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 493,    1,      False,  False,  False),
    "PowerStar12":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 494,    1,      False,  False,  False),
    "PowerStar13":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 495,    1,      False,  False,  False),
    "PowerStar14":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 496,    1,      False,  False,  False),
    "PowerStar15":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 497,    1,      False,  False,  False),
    "PowerStar16":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 498,    1,      False,  False,  False),
    "PowerStar17":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 499,    1,      False,  False,  False),
    "PowerStar18":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 500,    1,      False,  False,  False),
    "PowerStar19":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 501,    1,      False,  False,  False),
    "PowerStar1A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 502,    1,      False,  False,  False),
    "PowerStar1B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 503,    1,      False,  False,  False),
    "PowerStar1C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 504,    1,      False,  False,  False),
    "PowerStar1D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 505,    1,      False,  False,  False),
    "PowerStar1E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 506,    1,      False,  False,  False),
    "PowerStar1F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 507,    1,      False,  False,  False),
    "PowerStar20":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 508,    1,      False,  False,  False),
    "PowerStar21":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 509,    1,      False,  False,  False),
    "PowerStar22":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 510,    1,      False,  False,  False),
    "PowerStar23":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 511,    1,      False,  False,  False),
    "PowerStar24":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 512,    1,      False,  False,  False),
    "PowerStar25":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 513,    1,      False,  False,  False),
    "PowerStar26":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 514,    1,      False,  False,  False),
    "PowerStar27":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 515,    1,      False,  False,  False),
    "PowerStar28":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 516,    1,      False,  False,  False),
    "PowerStar29":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 517,    1,      False,  False,  False),
    "PowerStar2A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 518,    1,      False,  False,  False),
    "PowerStar2B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 519,    1,      False,  False,  False),
    "PowerStar2C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 520,    1,      False,  False,  False),
    "PowerStar2D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 521,    1,      False,  False,  False),
    "PowerStar2E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 522,    1,      False,  False,  False),
    "PowerStar2F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 523,    1,      False,  False,  False),
    "PowerStar30":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 524,    1,      False,  False,  False),
    "PowerStar31":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 525,    1,      False,  False,  False),
    "PowerStar32":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 526,    1,      False,  False,  False),
    "PowerStar33":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 527,    1,      False,  False,  False),
    "PowerStar34":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 528,    1,      False,  False,  False),
    "PowerStar35":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 529,    1,      False,  False,  False),
    "PowerStar36":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 530,    1,      False,  False,  False),
    "PowerStar37":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 531,    1,      False,  False,  False),
    "PowerStar38":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 532,    1,      False,  False,  False),
    "PowerStar39":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 533,    1,      False,  False,  False),
    "PowerStar3A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 534,    1,      False,  False,  False),
    "PowerStar3B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 535,    1,      False,  False,  False),
    "PowerStar3C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 536,    1,      False,  False,  False),
    "PowerStar3D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 537,    1,      False,  False,  False),
    "PowerStar3E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 538,    1,      False,  False,  False),
    "PowerStar3F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 539,    1,      False,  False,  False),
    "PowerStar40":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 540,    1,      False,  False,  False),
    "PowerStar41":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 541,    1,      False,  False,  False),
    "PowerStar42":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 542,    1,      False,  False,  False),
    "PowerStar43":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 543,    1,      False,  False,  False),
    "PowerStar44":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 544,    1,      False,  False,  False),
    "PowerStar45":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 545,    1,      False,  False,  False),
    "PowerStar46":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 546,    1,      False,  False,  False),
    "PowerStar47":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 547,    1,      False,  False,  False),
    "PowerStar48":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 548,    1,      False,  False,  False),
    "PowerStar49":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 549,    1,      False,  False,  False),
    "PowerStar4A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 550,    1,      False,  False,  False),
    "PowerStar4B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 551,    1,      False,  False,  False),
    "PowerStar4C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 552,    1,      False,  False,  False),
    "PowerStar4D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 553,    1,      False,  False,  False),
    "PowerStar4E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 554,    1,      False,  False,  False),
    "PowerStar4F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 555,    1,      False,  False,  False),
    "PowerStar50":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 556,    1,      False,  False,  False),
    "PowerStar51":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 557,    1,      False,  False,  False),
    "PowerStar52":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 558,    1,      False,  False,  False),
    "PowerStar53":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 559,    1,      False,  False,  False),
    "PowerStar54":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 560,    1,      False,  False,  False),
    "PowerStar55":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 561,    1,      False,  False,  False),
    "PowerStar56":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 562,    1,      False,  False,  False),
    "PowerStar57":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 563,    1,      False,  False,  False),
    "PowerStar58":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 564,    1,      False,  False,  False),
    "PowerStar59":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 565,    1,      False,  False,  False),
    "PowerStar5A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 566,    1,      False,  False,  False),
    "PowerStar5B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 567,    1,      False,  False,  False),
    "PowerStar5C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 568,    1,      False,  False,  False),
    "PowerStar5D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 569,    1,      False,  False,  False),
    "PowerStar5E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 570,    1,      False,  False,  False),
    "PowerStar5F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 571,    1,      False,  False,  False),
    "PowerStar60":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 572,    1,      False,  False,  False),
    "PowerStar61":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 573,    1,      False,  False,  False),
    "PowerStar62":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 574,    1,      False,  False,  False),
    "PowerStar63":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 575,    1,      False,  False,  False),
    "PowerStar64":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 576,    1,      False,  False,  False),
    "PowerStar65":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 577,    1,      False,  False,  False),
    "PowerStar66":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 578,    1,      False,  False,  False),
    "PowerStar67":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 579,    1,      False,  False,  False),
    "PowerStar68":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 580,    1,      False,  False,  False),
    "PowerStar69":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 581,    1,      False,  False,  False),
    "PowerStar6A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 582,    1,      False,  False,  False),
    "PowerStar6B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 583,    1,      False,  False,  False),
    "PowerStar6C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 584,    1,      False,  False,  False),
    "PowerStar6D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 585,    1,      False,  False,  False),
    "PowerStar6E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 586,    1,      False,  False,  False),
    "PowerStar6F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 587,    1,      False,  False,  False),
    "PowerStar70":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 588,    1,      False,  False,  False),
    "PowerStar71":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 589,    1,      False,  False,  False),
    "PowerStar72":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 590,    1,      False,  False,  False),
    "PowerStar73":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 591,    1,      False,  False,  False),
    "PowerStar74":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 592,    1,      False,  False,  False),
    "PowerStar75":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 593,    1,      False,  False,  False),
    "PowerStar76":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 594,    1,      False,  False,  False),
    "PowerStar77":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 595,    1,      False,  False,  False),
    "PowerStar78":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 596,    1,      False,  False,  False),
    "PowerStar79":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 597,    1,      False,  False,  False),
    "PowerStar7A":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 598,    1,      False,  False,  False),
    "PowerStar7B":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 599,    1,      False,  False,  False),
    "PowerStar7C":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 600,    1,      False,  False,  False),
    "PowerStar7D":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 601,    1,      False,  False,  False),
    "PowerStar7E":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 602,    1,      False,  False,  False),
    "PowerStar7F":              ("POWERSTAR",      Ic.progression_deprioritized_skip_balancing, 603,    1,      False,  False,  False),
    "MultiWorldGeneric":        ("OTHER",          Ic.filler,                     604,    1,      False,  False,  False),
    "MultiWorldKey00":          ("OTHER",          Ic.filler,                     605,    1,      False,  False,  False),
    "MultiWorldKey01":          ("OTHER",          Ic.filler,                     606,    1,      False,  False,  False),
    "MultiWorldKey02":          ("OTHER",          Ic.filler,                     607,    1,      False,  False,  False),
    "MultiWorldKey03":          ("OTHER",          Ic.filler,                     608,    1,      False,  False,  False),
    "MultiWorldKey04":          ("OTHER",          Ic.filler,                     609,    1,      False,  False,  False),
    "MultiWorldKey05":          ("OTHER",          Ic.filler,                     610,    1,      False,  False,  False),
    "MultiWorldKey06":          ("OTHER",          Ic.filler,                     611,    1,      False,  False,  False),
    "MultiWorldKey07":          ("OTHER",          Ic.filler,                     612,    1,      False,  False,  False),
    "MultiWorldKey08":          ("OTHER",          Ic.filler,                     613,    1,      False,  False,  False),
    "MultiWorldKey09":          ("OTHER",          Ic.filler,                     614,    1,      False,  False,  False),
    "MultiWorldKey0A":          ("OTHER",          Ic.filler,                     615,    1,      False,  False,  False),
    "MultiWorldKey0B":          ("OTHER",          Ic.filler,                     616,    1,      False,  False,  False),
    "MultiWorldKey0C":          ("OTHER",          Ic.filler,                     617,    1,      False,  False,  False),
    "MultiWorldKey0D":          ("OTHER",          Ic.filler,                     618,    1,      False,  False,  False),
    "MultiWorldKey0E":          ("OTHER",          Ic.filler,                     619,    1,      False,  False,  False),
    "MultiWorldKey0F":          ("OTHER",          Ic.filler,                     620,    1,      False,  False,  False),
    "MultiWorldKey10":          ("OTHER",          Ic.filler,                     621,    1,      False,  False,  False),
    "MultiWorldKey11":          ("OTHER",          Ic.filler,                     622,    1,      False,  False,  False),
    "MultiWorldKey12":          ("OTHER",          Ic.filler,                     623,    1,      False,  False,  False),
    "MultiWorldKey13":          ("OTHER",          Ic.filler,                     624,    1,      False,  False,  False),
    "MultiWorldKey14":          ("OTHER",          Ic.filler,                     625,    1,      False,  False,  False),
    "MultiWorldKey15":          ("OTHER",          Ic.filler,                     626,    1,      False,  False,  False),
    "MultiWorldKey16":          ("OTHER",          Ic.filler,                     627,    1,      False,  False,  False),
    "MultiWorldKey17":          ("OTHER",          Ic.filler,                     628,    1,      False,  False,  False),
    "MultiWorldKey18":          ("OTHER",          Ic.filler,                     629,    1,      False,  False,  False),
    "MultiWorldKey19":          ("OTHER",          Ic.filler,                     630,    1,      False,  False,  False),
    "MultiWorldKey1A":          ("OTHER",          Ic.filler,                     631,    1,      False,  False,  False),
    "MultiWorldKey1B":          ("OTHER",          Ic.filler,                     632,    1,      False,  False,  False),
    "MultiWorldKey1C":          ("OTHER",          Ic.filler,                     633,    1,      False,  False,  False),
    "MultiWorldKey1D":          ("OTHER",          Ic.filler,                     634,    1,      False,  False,  False),
    "MultiWorldKey1E":          ("OTHER",          Ic.filler,                     635,    1,      False,  False,  False),
    "MultiWorldKey1F":          ("OTHER",          Ic.filler,                     636,    1,      False,  False,  False),
    "MultiWorldKey20":          ("OTHER",          Ic.filler,                     637,    1,      False,  False,  False),
    "MultiWorldKey21":          ("OTHER",          Ic.filler,                     638,    1,      False,  False,  False),
    "MultiWorldKey22":          ("OTHER",          Ic.filler,                     639,    1,      False,  False,  False),
    "MultiWorldKey23":          ("OTHER",          Ic.filler,                     640,    1,      False,  False,  False),
    "MultiWorldKey24":          ("OTHER",          Ic.filler,                     641,    1,      False,  False,  False),
    "MultiWorldKey25":          ("OTHER",          Ic.filler,                     642,    1,      False,  False,  False),
    "MultiWorldKey26":          ("OTHER",          Ic.filler,                     643,    1,      False,  False,  False),
    "MultiWorldKey27":          ("OTHER",          Ic.filler,                     644,    1,      False,  False,  False),
    "MultiWorldKey28":          ("OTHER",          Ic.filler,                     645,    1,      False,  False,  False),
    "MultiWorldKey29":          ("OTHER",          Ic.filler,                     646,    1,      False,  False,  False),
    "MultiWorldKey2A":          ("OTHER",          Ic.filler,                     647,    1,      False,  False,  False),
    "MultiWorldKey2B":          ("OTHER",          Ic.filler,                     648,    1,      False,  False,  False),
    "MultiWorldKey2C":          ("OTHER",          Ic.filler,                     649,    1,      False,  False,  False),
    "MultiWorldKey2D":          ("OTHER",          Ic.filler,                     650,    1,      False,  False,  False),
    "MultiWorldKey2E":          ("OTHER",          Ic.filler,                     651,    1,      False,  False,  False),
    "MultiWorldKey2F":          ("OTHER",          Ic.filler,                     652,    1,      False,  False,  False),
    "MultiWorldKey30":          ("OTHER",          Ic.filler,                     653,    1,      False,  False,  False),
    "MultiWorldKey31":          ("OTHER",          Ic.filler,                     654,    1,      False,  False,  False),
    "MultiWorldKey32":          ("OTHER",          Ic.filler,                     655,    1,      False,  False,  False),
    "MultiWorldKey33":          ("OTHER",          Ic.filler,                     656,    1,      False,  False,  False),
    "MultiWorldKey34":          ("OTHER",          Ic.filler,                     657,    1,      False,  False,  False),
    "MultiWorldKey35":          ("OTHER",          Ic.filler,                     658,    1,      False,  False,  False),
    "MultiWorldKey36":          ("OTHER",          Ic.filler,                     659,    1,      False,  False,  False),
    "MultiWorldKey37":          ("OTHER",          Ic.filler,                     660,    1,      False,  False,  False),
    "MultiWorldKey38":          ("OTHER",          Ic.filler,                     661,    1,      False,  False,  False),
    "MultiWorldKey39":          ("OTHER",          Ic.filler,                     662,    1,      False,  False,  False),
    "MultiWorldKey3A":          ("OTHER",          Ic.filler,                     663,    1,      False,  False,  False),
    "MultiWorldKey3B":          ("OTHER",          Ic.filler,                     664,    1,      False,  False,  False),
    "MultiWorldKey3C":          ("OTHER",          Ic.filler,                     665,    1,      False,  False,  False),
    "MultiWorldKey3D":          ("OTHER",          Ic.filler,                     666,    1,      False,  False,  False),
    "MultiWorldKey3E":          ("OTHER",          Ic.filler,                     667,    1,      False,  False,  False),
    "MultiWorldKey3F":          ("OTHER",          Ic.filler,                     668,    1,      False,  False,  False),
    "MultiWorldKey40":          ("OTHER",          Ic.filler,                     669,    1,      False,  False,  False),
    "MultiWorldKey41":          ("OTHER",          Ic.filler,                     670,    1,      False,  False,  False),
    "MultiWorldKey42":          ("OTHER",          Ic.filler,                     671,    1,      False,  False,  False),
    "MultiWorldKey43":          ("OTHER",          Ic.filler,                     672,    1,      False,  False,  False),
    "MultiWorldKey44":          ("OTHER",          Ic.filler,                     673,    1,      False,  False,  False),
    "MultiWorldKey45":          ("OTHER",          Ic.filler,                     674,    1,      False,  False,  False),
    "MultiWorldKey46":          ("OTHER",          Ic.filler,                     675,    1,      False,  False,  False),
    "MultiWorldKey47":          ("OTHER",          Ic.filler,                     676,    1,      False,  False,  False),
    "MultiWorldKey48":          ("OTHER",          Ic.filler,                     677,    1,      False,  False,  False),
    "MultiWorldKey49":          ("OTHER",          Ic.filler,                     678,    1,      False,  False,  False),
    "MultiWorldKey4A":          ("OTHER",          Ic.filler,                     679,    1,      False,  False,  False),
    "MultiWorldKey4B":          ("OTHER",          Ic.filler,                     680,    1,      False,  False,  False),
    "MultiWorldKey4C":          ("OTHER",          Ic.filler,                     681,    1,      False,  False,  False),
    "MultiWorldKey4D":          ("OTHER",          Ic.filler,                     682,    1,      False,  False,  False),
    "MultiWorldKey4E":          ("OTHER",          Ic.filler,                     683,    1,      False,  False,  False),
    "MultiWorldKey4F":          ("OTHER",          Ic.filler,                     684,    1,      False,  False,  False),
    "MultiWorldKey50":          ("OTHER",          Ic.filler,                     685,    1,      False,  False,  False),
    "MultiWorldKey51":          ("OTHER",          Ic.filler,                     686,    1,      False,  False,  False),
    "MultiWorldKey52":          ("OTHER",          Ic.filler,                     687,    1,      False,  False,  False),
    "MultiWorldKey53":          ("OTHER",          Ic.filler,                     688,    1,      False,  False,  False),
    "MultiWorldKey54":          ("OTHER",          Ic.filler,                     689,    1,      False,  False,  False),
    "MultiWorldKey55":          ("OTHER",          Ic.filler,                     690,    1,      False,  False,  False),
    "MultiWorldKey56":          ("OTHER",          Ic.filler,                     691,    1,      False,  False,  False),
    "MultiWorldKey57":          ("OTHER",          Ic.filler,                     692,    1,      False,  False,  False),
    "MultiWorldKey58":          ("OTHER",          Ic.filler,                     693,    1,      False,  False,  False),
    "MultiWorldKey59":          ("OTHER",          Ic.filler,                     694,    1,      False,  False,  False),
    "MultiWorldKey5A":          ("OTHER",          Ic.filler,                     695,    1,      False,  False,  False),
    "MultiWorldKey5B":          ("OTHER",          Ic.filler,                     696,    1,      False,  False,  False),
    "MultiWorldKey5C":          ("OTHER",          Ic.filler,                     697,    1,      False,  False,  False),
    "Progressive Boots":        ("GEAR",           Ic.progression,                698,    50,     False,  False,  False),
    "BootsProxy2":              ("GEAR",           Ic.progression,                699,    50,     False,  False,  False),
    "BootsProxy3":              ("GEAR",           Ic.progression,                700,    50,     False,  False,  False),
    "Progressive Hammer":       ("GEAR",           Ic.progression,                701,    50,     False,  False,  False),
    "HammerProxy2":             ("GEAR",           Ic.progression,                702,    50,     False,  False,  False),
    "HammerProxy3":             ("GEAR",           Ic.progression,                703,    50,     False,  False,  False),
    "Progressive Smash Charge": ("BADGE",          Ic.filler,                     704,    50,     False,  False,  False),
    "SmashChargeProxy2":        ("BADGE",          Ic.filler,                     705,    50,     False,  False,  False),
    "SmashChargeProxy3":        ("BADGE",          Ic.filler,                     706,    50,     False,  False,  False),
    "Progressive Jump Charge":  ("BADGE",          Ic.useful,                     707,    50,     False,  False,  False),
    "JumpChargeProxy2":         ("BADGE",          Ic.useful,                     708,    50,     False,  False,  False),
    "JumpChargeProxy3":         ("BADGE",          Ic.useful,                     709,    50,     False,  False,  False),
    "Progressive Power Jump":   ("BADGE",          Ic.filler,                     710,    50,     False,  False,  False),
    "PowerJumpProxy2":          ("BADGE",          Ic.filler,                     711,    50,     False,  False,  False),
    "PowerJumpProxy3":          ("BADGE",          Ic.filler,                     712,    50,     False,  False,  False),
    "Progressive Power Smash":  ("BADGE",          Ic.filler,                     713,    50,     False,  False,  False),
    "PowerSmashProxy2":         ("BADGE",          Ic.filler,                     714,    50,     False,  False,  False),
    "PowerSmashProxy3":         ("BADGE",          Ic.filler,                     715,    50,     False,  False,  False),
    "Progressive Quake Hammer": ("BADGE",          Ic.useful,                     716,    50,     False,  False,  False),
    "QuakeHammerProxy2":        ("BADGE",          Ic.useful,                     717,    50,     False,  False,  False),
    "QuakeHammerProxy3":        ("BADGE",          Ic.useful,                     718,    50,     False,  False,  False),
    "Pouch Upgrade":            ("OTHER",          Ic.useful,                     719,    50,     False,  False,  False),
    "PouchB":                   ("OTHER",          Ic.useful,                     720,    50,     False,  False,  False),
    "PouchC":                   ("OTHER",          Ic.useful,                     721,    50,     False,  False,  False),
    "PouchD":                   ("OTHER",          Ic.useful,                     722,    50,     False,  False,  False),
    "PouchE":                   ("OTHER",          Ic.useful,                     723,    50,     False,  False,  False),
    "Star Beam":                ("STARPOWER",      Ic.progression,                724,    50,     False,  False,  False),
    "Coin Bag":                 ("OTHER",          Ic.filler,                     725,    10,     False,  False,  False),
    "PanelHintBadge":           ("OTHER",          Ic.filler,                     726,    1,      False,  False,  True),
    "PanelHintConsumable":      ("OTHER",          Ic.filler,                     727,    1,      False,  False,  True),
    "PanelHintGear":            ("OTHER",          Ic.filler,                     728,    1,      False,  False,  True),
    "PanelHintKey":             ("OTHER",          Ic.filler,                     729,    1,      False,  False,  True),
    "PanelHintPartner":         ("OTHER",          Ic.filler,                     730,    1,      False,  False,  True),
    "Partner Upgrade":          ("PARTNERUPGRADE", Ic.useful,                     731,    50,     False,  False,  False),
    "Goombario Upgrade":        ("PARTNERUPGRADE", Ic.useful,                     732,    50,     False,  False,  False),
    "Kooper Upgrade":           ("PARTNERUPGRADE", Ic.useful,                     733,    50,     False,  False,  False),
    "Bombette Upgrade":         ("PARTNERUPGRADE", Ic.useful,                     734,    50,     False,  False,  False),
    "Parakarry Upgrade":        ("PARTNERUPGRADE", Ic.useful,                     735,    50,     False,  False,  False),
    "GoompaUp1":                ("PARTNERUPGRADE", Ic.filler,                     736,    50,     False,  False,  True),
    "Watt Upgrade":             ("PARTNERUPGRADE", Ic.useful,                     737,    50,     False,  False,  False),
    "Sushie Upgrade":           ("PARTNERUPGRADE", Ic.useful,                     738,    50,     False,  False,  False),
    "Lakilester Upgrade":       ("PARTNERUPGRADE", Ic.useful,                     739,    50,     False,  False,  False),
    "Bow Upgrade":              ("PARTNERUPGRADE", Ic.useful,                     740,    50,     False,  False,  False),
    "GoombarioUp2":             ("PARTNERUPGRADE", Ic.useful,                     741,    50,     False,  False,  False),
    "KooperUp2":                ("PARTNERUPGRADE", Ic.useful,                     742,    50,     False,  False,  False),
    "BombetteUp2":              ("PARTNERUPGRADE", Ic.useful,                     743,    50,     False,  False,  False),
    "ParakarryUp2":             ("PARTNERUPGRADE", Ic.useful,                     744,    50,     False,  False,  False),
    "GoompaUp2":                ("PARTNERUPGRADE", Ic.filler,                     745,    50,     False,  False,  True),
    "WattUp2":                  ("PARTNERUPGRADE", Ic.useful,                     746,    50,     False,  False,  False),
    "SushieUp2":                ("PARTNERUPGRADE", Ic.useful,                     747,    50,     False,  False,  False),
    "LakilesterUp2":            ("PARTNERUPGRADE", Ic.useful,                     748,    50,     False,  False,  False),
    "BowUp2":                   ("PARTNERUPGRADE", Ic.useful,                     749,    50,     False,  False,  False),
    "Goombario":                ("PARTNER",        Ic.progression,                750,    50,     False,  False,  False),
    "Kooper":                   ("PARTNER",        Ic.progression,                751,    50,     False,  False,  False),
    "Bombette":                 ("PARTNER",        Ic.progression,                752,    50,     False,  False,  False),
    "Parakarry":                ("PARTNER",        Ic.progression,                753,    50,     False,  False,  False),
    "Goompa":                   ("PARTNER",        Ic.filler,                     754,    50,     False,  False,  True),
    "Watt":                     ("PARTNER",        Ic.progression,                755,    50,     False,  False,  False),
    "Sushie":                   ("PARTNER",        Ic.progression,                756,    50,     False,  False,  False),
    "Lakilester":               ("PARTNER",        Ic.progression,                757,    50,     False,  False,  False),
    "Bow":                      ("PARTNER",        Ic.progression,                758,    50,     False,  False,  False),
    "Damage Trap":              ("ITEM",           Ic.trap,                       8320,   4,      False,  False,  False)
}

item_groups = {
    "Partner": [name for (name, data) in item_table.items() if data[0] == "PARTNER" and not data[6]],
    "PartnerUpgrade": [name for (name, data) in item_table.items() if data[0] == "PARTNERUPGRADE" and "Upgrade" in name and not data[6]],
    "ItemPouch": [name for (name, data) in item_table.items() if name.startswith("Pouch")],
    "Badge": [name for (name, data) in item_table.items() if data[0] == "BADGE" and not (data[4] or data[5] or data[6])],
    "ProgBadge": [name for (name, data) in item_table.items() if data[0] == "BADGE" and "Progressive" in name],
    "BadgeBeta": [name for (name, data) in item_table.items() if data[0] == "BADGE" and data[4] and not data[6]],
    "BadgeDupe": [name for (name, data) in item_table.items() if data[0] == "BADGE" and data[5] and not data[6]],
    "ItemBeta": [name for (name, data) in item_table.items() if data[0] == "ITEM" and data[4] and not data[6]],
    "PowerStar": [name for (name, data) in item_table.items() if data[0] == "POWERSTAR"],
    "StarPiece": [name for (name, data) in item_table.items() if data[0] == "STARPIECE" and not data[6]],
    "FavorItem": [name for (name, data) in item_table.items() if (name.startswith("Koot") or name in ("Crystal Ball", "Luigi Autograph", "Merluvlee Autograph")) and not data[6]],
    "Letter": [name for (name, data) in item_table.items() if name.startswith("Letter") and not data[6]],
    "Boots": [name for (name, data) in item_table.items() if data[0] == "GEAR" and "Progressive Boots" in name],
    "Hammers": [name for (name, data) in item_table.items() if data[0] == "GEAR" and "Progressive Hammer" in name],
    "Gear": [name for (name, data) in item_table.items() if data[0] == "GEAR" and ("Progressive Boots" in name or "Progressive Hammer" in name)],
    "Consumables": [name for (name, data) in item_table.items() if data[0] == "ITEM" and not data[6]],
    "Progressives": [name for (name, data) in item_table.items() if "Progressive" in name],
}

# Below table used to assign proper item IDs to items with multiple instances
# They are functionally the same still have to be processed differently by the game
# This is all necessary mostly to make the names user-friendly for reading logs and hinting
item_multiples_ids = {
    item_table["Koopa Fortress Key"][2]:       (item_table["KoopaFortressKeyA"][2], item_table["KoopaFortressKeyB"][2],
                                                item_table["KoopaFortressKeyC"][2], item_table["KoopaFortressKeyD"][2]),
    item_table["Ruins Key"][2]:                (item_table["RuinsKeyA"][2], item_table["RuinsKeyB"][2],
                                                item_table["RuinsKeyC"][2], item_table["RuinsKeyD"][2]),
    item_table["Tubba Castle Key"][2]:         (item_table["TubbaCastleKeyA"][2], item_table["TubbaCastleKeyB"][2],
                                                item_table["TubbaCastleKeyC"][2]),
    item_table["Magical Seed"][2]:             (item_table["Magical Seed"][2], item_table["MagicalSeed2"][2],
                                                item_table["MagicalSeed3"][2], item_table["MagicalSeed4"][2]),
    item_table["Bowser Castle Key"][2]:        (item_table["BowserCastleKeyA"][2], item_table["BowserCastleKeyB"][2],
                                                item_table["BowserCastleKeyC"][2], item_table["BowserCastleKeyD"][2],
                                                item_table["BowserCastleKeyE"][2]),
    item_table["Prison Key"][2]:               (item_table["Prison Key"][2], item_table["PrisonKeyB"][2]),

    item_table["Pouch Upgrade"][2]:            (item_table["Pouch Upgrade"][2], item_table["PouchB"][2],
                                                item_table["PouchC"][2], item_table["PouchD"][2],
                                                item_table["PouchE"][2]),

    item_table["Progressive Boots"][2]:        (item_table["Progressive Boots"][2], item_table["BootsProxy2"][2],
                                                item_table["BootsProxy3"][2]),
    item_table["Progressive Hammer"][2]:       (item_table["Progressive Hammer"][2], item_table["HammerProxy2"][2],
                                                item_table["HammerProxy3"][2]),

    item_table["Progressive Smash Charge"][2]: (item_table["Progressive Smash Charge"][2],
                                                item_table["SmashChargeProxy2"][2],
                                                item_table["SmashChargeProxy3"][2]),
    item_table["Progressive Jump Charge"][2]:  (item_table["Progressive Jump Charge"][2],
                                                item_table["JumpChargeProxy2"][2],
                                                item_table["JumpChargeProxy3"][2]),
    item_table["Progressive Power Jump"][2]:   (item_table["Progressive Power Jump"][2],
                                                item_table["PowerJumpProxy2"][2],
                                                item_table["PowerJumpProxy3"][2]),
    item_table["Progressive Power Smash"][2]:  (item_table["Progressive Power Smash"][2],
                                                item_table["PowerSmashProxy2"][2],
                                                item_table["PowerSmashProxy3"][2]),
    item_table["Progressive Quake Hammer"][2]: (item_table["Progressive Quake Hammer"][2],
                                                item_table["QuakeHammerProxy2"][2],
                                                item_table["QuakeHammerProxy3"][2]),

    item_table["Goombario Upgrade"][2]:        (item_table["Goombario Upgrade"][2], item_table["GoombarioUp2"][2]),
    item_table["Kooper Upgrade"][2]:           (item_table["Kooper Upgrade"][2], item_table["KooperUp2"][2]),
    item_table["Bombette Upgrade"][2]:         (item_table["Bombette Upgrade"][2], item_table["BombetteUp2"][2]),
    item_table["Parakarry Upgrade"][2]:        (item_table["Parakarry Upgrade"][2], item_table["ParakarryUp2"][2]),
    item_table["Watt Upgrade"][2]:             (item_table["Watt Upgrade"][2], item_table["WattUp2"][2]),
    item_table["Sushie Upgrade"][2]:           (item_table["Sushie Upgrade"][2], item_table["SushieUp2"][2]),
    item_table["Lakilester Upgrade"][2]:       (item_table["Lakilester Upgrade"][2], item_table["LakilesterUp2"][2]),
    item_table["Bow Upgrade"][2]:              (item_table["Bow Upgrade"][2], item_table["BowUp2"][2]),

    item_table["Star Piece"][2]:               [i for i in range(item_table["StarPiece00"][2],
                                                                 item_table["StarPiece51"][2] + 1)],
    item_table["3x Star Pieces"][2]:           [i for i in range(item_table["3x Star Pieces"][2],
                                                                 item_table["ThreeStarPieces4"][2] + 1)],
    item_table["Power Star"][2]:               [i for i in range(item_table["Power Star"][2],
                                                                 item_table["PowerStar7F"][2] + 1)],

    item_table["Power Plus"][2]:               (item_table["Power Plus"][2], item_table["PowerPlusB"][2],
                                                item_table["PowerPlusX"][2]),
    item_table["Defend Plus"][2]:              (item_table["Defend Plus"][2], item_table["DefendPlusX"][2],
                                                item_table["DefendPlusY"][2]),

    item_table["HP Plus"][2]:                  (item_table["HP Plus"][2], item_table["HPPlusB"][2],
                                                item_table["HPPlusC"][2], item_table["HPPlusX"][2],
                                                item_table["HPPlusY"][2]),
    item_table["FP Plus"][2]:                  (item_table["FP Plus"][2], item_table["FPPlusB"][2],
                                                item_table["FPPlusC"][2], item_table["FPPlusX"][2],
                                                item_table["FPPlusY"][2]),

    item_table["Happy Heart"][2]:              (item_table["Happy Heart"][2], item_table["HappyHeartB"][2],
                                                item_table["HappyHeartX"][2]),
    item_table["Happy Flower"][2]:             (item_table["Happy Flower"][2], item_table["HappyFlowerB"][2],
                                                item_table["HappyFlowerX"][2]),

    item_table["Damage Dodge"][2]:             (item_table["Damage Dodge"][2], item_table["DamageDodgeB"][2],
                                                item_table["DamageDodgeX"][2]),
    item_table["Flower Saver"][2]:             (item_table["Flower Saver"][2], item_table["FlowerSaverB"][2],
                                                item_table["FlowerSaverX"][2]),
    item_table["Deep Focus"][2]:               (item_table["Deep Focus"][2], item_table["DeepFocus2"][2],
                                                item_table["DeepFocus3"][2]),
}

# where the above table takes the initial name and gets the id to be used by the game,
# this takes the name in the table and gets the base item name
# badges are the only ones in here since that's all that is needed currently
item_multiples_base_name = {
    "PowerPlusB": "Power Plus",
    "PowerPlusX": "Power Plus",
    "DefendPlusX": "Defend Plus",
    "DefendPlusY": "Defend Plus",
    "HPPlusB": "HP Plus",
    "HPPlusC": "HP Plus",
    "HPPlusX": "HP Plus",
    "HPPlusY": "HP Plus",
    "FPPlusB": "FP Plus",
    "FPPlusC": "FP Plus",
    "FPPlusX": "FP Plus",
    "FPPlusY": "FP Plus",
    "HappyHeartB": "Happy Heart",
    "HappyHeartX": "Happy Heart",
    "HappyFlowerB": "Happy Flower",
    "HappyFlowerX": "Happy Flower",
    "DamageDodgeB": "Damage Dodge",
    "DamageDodgeX": "Damage Dodge",
    "FlowerSaverB": "Flower Saver",
    "FlowerSaverX": "Flower Saver",
    "DeepFocus2": "Deep Focus",
    "DeepFocus3": "Deep Focus"
}

# below tables pulled from https://github.com/icebound777/PMR-SeedGenerator/blob/main/metadata/item_general.py

# changed below table to have the values commented and the name not, since the values aren't used anywhere
taycet_items = [
    "Spicy Soup",  # 0x0B0
    "Apple Pie",  # 0x0B1
    "Honey Ultra",  # 0x0B2
    "Maple Ultra",  # 0x0B3
    "Jelly Ultra",  # 0x0B4
    # "Koopasta",  # 0x0B5
    "Fried Shroom",  # 0x0B6
    "Shroom Cake",  # 0x0B7
    "Shroom Steak",  # 0x0B8
    "Hot Shroom",  # 0x0B9
    "Sweet Shroom",  # 0x0BA
    "Yummy Meal",  # 0x0BB
    "Healthy Juice",  # 0x0BC
    "Bland Meal",  # 0x0BD
    "Deluxe Feast",  # 0x0BE
    "Special Shake",  # 0x0BF
    "Big Cookie",  # 0x0C0
    # "Cake",  # 0x0C1
    # "Mistake",  # 0x0C2
    # "KoopaTea",  # 0x0C3
    "Honey Super",  # 0x0C4
    "Maple Super",  # 0x0C5
    "Jelly Super",  # 0x0C6
    "Spaghetti",  # 0x0C7
    "Egg Missile",  # 0x0C8
    "Fried Egg",  # 0x0C9
    "Honey Shroom",  # 0x0CA
    "Honey Candy",  # 0x0CB
    "Electro Pop",  # 0x0CC
    "Fire Pop",  # 0x0CD
    "Lime Candy",  # 0x0CE
    "Coco Pop",  # 0x0CF
    "Jelly Pop",  # 0x0D1
    "Strange Cake",  # 0x0D2
    # "KookyCookie",  # 0x0D3
    "Frozen Fries",  # 0x0D4
    "Potato Salad",  # 0x0D5
    # "NuttyCake",  # 0x0D6
    "Maple Shroom",  # 0x0D7
    "Boiled Egg",  # 0x0D8
    "Yoshi Cookie",  # 0x0D9
    "Jelly Shroom"  # 0x0DA
]

# List of 0xFF items for displaying a seed hash on the save select screen.
# The list indices do not correspond to ingame item ids here, this list is
# explicitly coded into the base rom like this instead.
seed_hash_item_names = [
    "Lucky Star",
    "First Degree Card",
    "Second Degree Card",
    "Third Degree Card",
    "Fourth Degree Card",
    "Diploma",
    "Ultra Stone",
    "Koopa Fortress Key",
    "Ruins Key",
    "Pulse Stone",
    "Tubba Castle Key",
    "Crystal Palace Key",
    "Lunar Stone",
    "Pyramid Stone",
    "Diamond Stone",
    "Volcano Vase",
    "Kooper Shell",
    "Bowser Castle Key",
    "Forest Pass",
    "Boo Weight",
    "Boo Portrait",
    "Crystal Berry",
    "Mystical Key",
    "Storeroom Key",
    "Toy Train",
    "Boo Record",
    "Frying Pan",
    "Dictionary",
    "Mystery Note",
    "Suspicious Note",
    "Crystal Ball",
    "Screwdriver",
    "Cookbook",
    "Jade Raven",
    "Magical Seed 1",
    "Magical Seed 2",
    "Magical Seed 3",
    "Magical Seed 4",
    "Toad Doll",
    "Calculator",
    "Snowman Bucket",
    "Snowman Scarf",
    "Red Key",
    "Blue Key",
    "Letter to Merlon",
    "Artifact",
    "Dolly",
    "Water Stone",
    "Magical Bean",
    "Fertile Soil",
    "Miracle Water",
    "Baking Sugar",
    "Baking Salt",
    "Baking Egg",
    "Baking Cream",
    "Baking Strawberry",
    "Baking Butter",
    "Baking Cleanser",
    "Baking Water",
    "Baking Flour",
    "Baking Milk",
    "Lyrics",
    "Melody",
    "Mailbag",
    "Peach Key",
    "Star Stone",
    "Sneaky Parasol",
    "Koot Tape",
    "Koot Koopa Legends",
    "Koot Luigi Autograph",
    "Koot Empty Wallet",
    "Koot Merluvlee Autograph",
    "Koot Shell",
    "Koot Old Photo",
    "Koot Glasses",
    "Koot Package",
    "Koot Red Jar",
    "Silver Credit",
    "Gold Credit",
    "Fire Flower",
    "Snowman Doll",
    "Thunder Rage",
    "Shooting Star",
    "Thunder Bolt",
    "Pebble",
    "Dusty Hammer",
    "Insecticide Herb",
    "Stone Cap",
    "Tasty Tonic",
    "Mushroom",
    "Volt Shroom",
    "Super Shroom",
    "Dried Shroom",
    "Ultra Shroom",
    "Sleepy Sheep",
    "POW Block",
    "Hustle Drink",
    "Stop Watch",
    "Whackas Bump",
    "Apple",
    "Life Shroom",
    "Mystery",
    "Repel Gel",
    "Fright Jar",
    "Please Come Back",
    "Dizzy Dial",
    "Super Soda",
    "Lemon",
    "Lime",
    "Blue Berry",
    "Red Berry",
    "Yellow Berry",
    "Bubble Berry",
    "Jammin Jelly",
    "Maple Syrup",
    "Honey Syrup",
    "Goomnut",
    "Koopa Leaf",
    "Dried Pasta",
    "Dried Fruit",
    "Strange Leaf",
    "Cake Mix",
    "Egg",
    "Coconut",
    "Melon",
    "Stinky Herb",
    "Iced Potato",
    "Spicy Soup",
    "Apple Pie",
    "Honey Ultra",
    "Maple Ultra",
    "Jelly Ultra",
    "Koopasta",
    "Fried Shroom",
    "Shroom Cake",
    "Shroom Steak",
    "Hot Shroom",
    "Sweet Shroom",
    "Yummy Meal",
    "Healthy Juice",
    "Bland Meal",
    "Deluxe Feast",
    "Special Shake",
    "Big Cookie",
    "Cake",
    "Mistake",
    "Koopa Tea",
    "Honey Super",
    "Maple Super",
    "Jelly Super",
    "Spaghetti",
    "Egg Missile",
    "Fried Egg",
    "Honey Shroom",
    "Honey Candy",
    "Electro Pop",
    "Fire Pop",
    "Lime Candy",
    "Coco Pop",
    "Lemon Candy",
    "Jelly Pop",
    "Strange Cake",
    "Kooky Cookie",
    "Frozen Fries",
    "Potato Salad",
    "Nutty Cake",
    "Maple Shroom",
    "Boiled Egg",
    "Yoshi Cookie",
    "Jelly Shroom",
    "Spin Smash",
    "Multibounce",
    "Dodge Master",
    "Power Bounce",
    "Spike Shield",
    "First Attack",
    "Quake Hammer",
    "Double Dip",
    "Sleep Stomp",
    "Fire Shield",
    "Quick Change",
    "D Down Pound",
    "Dizzy Stomp",
    "Mini Smash Chg",
    "Pretty Lucky",
    "Feeling Fine",
    "Attack FX A",
    "Allor Nothing",
    "HP Drain",
    "Mini Jump Chg",
    "Slow Go",
    "Mega Rush",
    "Ice Power",
    "Pay Off",
    "Money Money",
    "Chill Out",
    "Zap Tap",
    "Berserker",
    "Right On",
    "Runaway Pay",
    "Refund",
    "Triple Dip",
    "Hammer Throw",
    "Mega Quake",
    "Smash Charge",
    "Jump Charge",
    "S Smash Chg",
    "S Jump Chg",
    "Power Rush",
    "Auto Jump",
    "Auto Smash",
    "Crazy Heart",
    "Last Stand",
    "Close Call",
    "P Up D Down",
    "Lucky Day",
    "Mega HP Drain",
    "P Down D Up",
    "Power Quake",
    "Auto Multibounce",
    "Flower Fanatic",
    "Heart Finder",
    "Flower Finder",
    "Spin Attack",
    "Dizzy Attack",
    "I Spy",
    "Speedy Spin",
    "Bump Attack",
    "Power Jump",
    "Super Jump",
    "Mega Jump",
    "Power Smash",
    "Super Smash",
    "Mega Smash",
    "Shrink Smash",
    "Kaiden",
    "DDown Jump",
    "Shrink Stomp",
    "Earthquake Jump",
    "Deep Focus",
    "HP Plus",
    "FP Plus",
    "Flower Saver",
    "Damage Dodge",
    "Power Plus",
    "Defend Plus",
    "Happy Heart",
    "Happy Flower",
    "Group Focus",
    "Peekaboo",
    "Attack FX D",
    "Attack FX B",
    "Attack FX E",
    "Attack FX C",
    "Attack FX F",
    "Healthy Healthy",
    # "Heart",
    # "Coin",
    # "Star Point",
    # "Heart Point",
    # "Flower Point",
    # "Star Piece",
    # "Cake Done",
    # "Cake Bare",
    # "Cake Pan",
    # "Cake Batter",
    # "Cake Bowl",
    # "Cake Mixed",
    # "Cake With Icing",
    # "Cake With Berries",
    # "Hammer",
    # "Super Hammer",
    # "Ultra Hammer",
    # "Boots",
    # "Super Boots",
    # "Ultra Boots",
]

progression_miscitems = [
    "Tasty Tonic",  # 0x0089 (Koopa Koot) alternative: Lime,Lemon;BubbleBerry,Coconut
    "Sleepy Sheep",  # 0x008F (Koopa Koot)
    "Strange Leaf",  # 0x00A9 (as ingredient for cooking SleepySheep)
    # "LifeShroom", # 0x0095 (Koopa Koot) > LimitedItem, better go cook it
    "Super Shroom",  # 0x008C (as ingredient for above)
    "Lemon",       # 0x009C (LemonCandy for AntiGuy)
    "Lime",        # 0x009D (Koopa Koot)
    "Blue Berry",   # 0x01DD (Blue Flower Guard / Flower Fields Well)
    "Red Berry",    # 0x01DF (Red Flower Guard)
    "Yellow Berry",  # 0x01E1 (Yellow Flower Guard)
    "Bubble Berry",  # 0x01E3 (BubbleFlower)
    "Goomnut",     # 0x00A5 (Koopa Koot: NuttyCake from Tayce T.)
    "Koopa Leaf",   # 0x00A6 (Koopa Koot: KoopaTea from Tayce T.)
    "Dried Pasta",  # 0x00A7 (Koopa Koot: +KoopaLeaf -> Koopasta from Tayce T.)
    "Cake Mix",     # 0x00AA (Koopa Koot: +KoopaLeaf -> KookyCookie; LemonCandy for AntiGuy; Cake for Gourmet Guy)
    "Coconut",     # 0x00AC (Koopa Koot)
    # "Cake",        # 0x00C1 (Gourmet Guy) > cook via CakeMix
]
