from typing import Any, Dict

import Options as ap_options
from .. import options
from Options import Accessibility, ProgressionBalancing
from .. import item_names
from ..mission_tables import SC2Race, SC2Campaign

from ..options import ( 
    # avoid import *
    GameDifficulty, DifficultyDamageModifier, GameSpeed, DisableForcedCamera, SkipCutscenes, AllInMap, MissionOrder, 
    MaximumCampaignSize, TwoStartPositions, KeyMode, PlayerColorTerranRaynor, PlayerColorProtoss, PlayerColorZerg, 
    PlayerColorZergPrimal, PlayerColorNova, SelectedRaces, EnabledCampaigns, EnableRaceSwapVariants, EnableMissionRaceBalancing, 
    ShuffleCampaigns, ShuffleNoBuild, StarterUnit, RequiredTactics, EnableVoidTrade, VoidTradeAgeLimit, VoidTradeWorkers, 
    EnsureGenericItems, MinNumberOfUpgrades, MaxNumberOfUpgrades, MercenaryHighlanders, MaxUpgradeLevel, GenericUpgradeMissions, 
    GenericUpgradeResearch, GenericUpgradeResearchSpeedup, GenericUpgradeItems, KerriganPresence, KerriganLevelsPerMissionCompleted, 
    KerriganLevelsPerMissionCompletedCap, KerriganLevelItemSum, KerriganLevelItemDistribution, KerriganTotalLevelCap, StartPrimaryAbilities, 
    KerriganPrimalStatus, KerriganMaxActiveAbilities, KerriganMaxPassiveAbilities, EnableMorphling, WarCouncilNerfs, SpearOfAdunPresence, 
    SpearOfAdunPresentInNoBuild, SpearOfAdunPassiveAbilityPresence, SpearOfAdunPassivesPresentInNoBuild, SpearOfAdunMaxActiveAbilities, 
    SpearOfAdunMaxAutocastAbilities, GrantStoryTech, GrantStoryLevels, NovaMaxWeapons, NovaMaxGadgets, NovaGhostOfAChanceVariant, 
    TakeOverAIAllies, LockedItems, ExcludedItems, UnexcludedItems, ExcludedMissions, DifficultyCurve, ExcludeVeryHardMissions, VanillaItemsOnly, 
    ExcludeOverpoweredItems, VictoryCache, VanillaLocations, ExtraLocations, ChallengeLocations, MasteryLocations, BasebustLocations, 
    SpeedrunLocations, PreventativeLocations, FillerPercentage, MineralsPerItem, VespenePerItem, StartingSupplyPerItem, MaximumSupplyPerItem, 
    MaximumSupplyReductionPerItem, LowestMaximumSupply, ResearchCostReductionPerItem, FillerItemsDistribution, MissionOrderScouting, 
    CustomMissionOrder, OPTION_NAME
)

template_settings = {
    # Free to play, 25 WoL missions, Terran only Golden Path. Matches the template.yaml.
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_normal,
    OPTION_NAME[SelectedRaces]:                         {SC2Race.TERRAN.get_title()},
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_golden_path,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]:                      {SC2Campaign.WOL.campaign_name},
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_disabled,
    OPTION_NAME[KeyMode]:                               KeyMode.option_disabled,
    OPTION_NAME[MaximumCampaignSize]:                   25,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_balanced,
    OPTION_NAME[NovaGhostOfAChanceVariant]:             NovaGhostOfAChanceVariant.option_wol,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[MineralsPerItem]:                       10,
    OPTION_NAME[VespenePerItem]:                        10,
    OPTION_NAME[StartingSupplyPerItem]:                 2,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          2,
}



f2p_big_settings = {
    # Free to play, all race 7x7 Grid
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_normal,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_grid,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]: {
        SC2Campaign.WOL.campaign_name, 
        SC2Campaign.PROPHECY.campaign_name, 
        SC2Campaign.PROLOGUE.campaign_name
    },
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_shuffle_all,
    OPTION_NAME[EnableMissionRaceBalancing]:            EnableMissionRaceBalancing.option_semi_balanced,
    OPTION_NAME[KeyMode]:                               KeyMode.option_disabled,
    OPTION_NAME[MaximumCampaignSize]:                   48,
    OPTION_NAME[TwoStartPositions]:                     TwoStartPositions.option_true,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_balanced,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_false,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_everywhere,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_everywhere,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[MineralsPerItem]:                       5,
    OPTION_NAME[VespenePerItem]:                        5,
    OPTION_NAME[StartingSupplyPerItem]:                 2,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          2,
}

zerg_rush_settings = {
    # Zerg only, Blitz, short (5 required, 15 total). Sync-friendly
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_hard,
    OPTION_NAME[SelectedRaces]:                         {SC2Race.ZERG.get_title()},
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_blitz,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_advanced,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_shuffle_all,
    OPTION_NAME[KeyMode]:                               KeyMode.option_disabled,
    OPTION_NAME[MaximumCampaignSize]:                   15,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_balanced,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VictoryCache]:                          3,
    OPTION_NAME[GenericUpgradeItems]:                   GenericUpgradeItems.option_bundle_all,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[ExcludeVeryHardMissions]:               ExcludeVeryHardMissions.option_true,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_all,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_grant,
    OPTION_NAME[GrantStoryLevels]:                      GrantStoryLevels.option_minimum,
    OPTION_NAME[MineralsPerItem]:                       25,
    OPTION_NAME[VespenePerItem]:                        25,
    OPTION_NAME[StartingSupplyPerItem]:                 5,
    OPTION_NAME[MaximumSupplyPerItem]:                  2,
    OPTION_NAME[ResearchCostReductionPerItem]:          5,
}

classic_grid_settings = {
    # Short-ish 5x5 Grid (8 required, 24 total), all races. Sync-friendly
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_hard,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_grid,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_shuffle_all,
    OPTION_NAME[EnableMissionRaceBalancing]:            EnableMissionRaceBalancing.option_fully_balanced,
    OPTION_NAME[KeyMode]:                               KeyMode.option_disabled,
    OPTION_NAME[MaximumCampaignSize]:                   24,
    OPTION_NAME[TwoStartPositions]:                     TwoStartPositions.option_true,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_balanced,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VictoryCache]:                          5,
    OPTION_NAME[GenericUpgradeItems]:                   GenericUpgradeItems.option_bundle_all,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[ExcludeVeryHardMissions]:               ExcludeVeryHardMissions.option_true,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_false,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_any_race_lotv,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_any_race_lotv,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_all,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_grant,
    OPTION_NAME[GrantStoryLevels]:                      GrantStoryLevels.option_minimum,
    OPTION_NAME[MineralsPerItem]:                       25,
    OPTION_NAME[VespenePerItem]:                        25,
    OPTION_NAME[StartingSupplyPerItem]:                 5,
    OPTION_NAME[MaximumSupplyPerItem]:                  2,
    OPTION_NAME[ResearchCostReductionPerItem]:          5,
}

raceswap_blitz_settings = {
    # medium-sized Blitz (10 required, 50 total), all races, forced raceswaps
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_hard,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_blitz,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_advanced,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_pick_one_non_vanilla,
    OPTION_NAME[EnableMissionRaceBalancing]:            EnableMissionRaceBalancing.option_semi_balanced,
    OPTION_NAME[KeyMode]:                               KeyMode.option_disabled,
    OPTION_NAME[MaximumCampaignSize]:                   50,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_off,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_true,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_protoss,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_protoss,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[ExcludeOverpoweredItems]:               ExcludeOverpoweredItems.option_true,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[MineralsPerItem]:                       10,
    OPTION_NAME[VespenePerItem]:                        10,
    OPTION_NAME[StartingSupplyPerItem]:                 2,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          2,
}

bread_and_butter_settings = {
    # 50 mission Golden Path, all races, limits on Upgrades per Unit/Kerrigan/Nova/SoA
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_normal,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_golden_path,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_pick_one,
    OPTION_NAME[EnableMissionRaceBalancing]:            EnableMissionRaceBalancing.option_semi_balanced,
    OPTION_NAME[KeyMode]:                               KeyMode.option_progressive_questlines,
    OPTION_NAME[MaximumCampaignSize]:                   50,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_off,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_true,
    OPTION_NAME[NovaGhostOfAChanceVariant]:             NovaGhostOfAChanceVariant.option_nco,
    OPTION_NAME[GenericUpgradeItems]:                   GenericUpgradeItems.option_individual_items,
    OPTION_NAME[MinNumberOfUpgrades]:                   1,
    OPTION_NAME[MaxNumberOfUpgrades]:                   4,
    OPTION_NAME[NovaMaxWeapons]:                        2,
    OPTION_NAME[NovaMaxGadgets]:                        2,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[KerriganMaxActiveAbilities]:            4,
    OPTION_NAME[KerriganMaxPassiveAbilities]:           2,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_protoss,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_protoss,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunMaxActiveAbilities]:         3,
    OPTION_NAME[SpearOfAdunMaxAutocastAbilities]:       1,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[ExcludeOverpoweredItems]:               ExcludeOverpoweredItems.option_true,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_allow_substitutes,
    OPTION_NAME[MineralsPerItem]:                       10,
    OPTION_NAME[VespenePerItem]:                        10,
    OPTION_NAME[StartingSupplyPerItem]:                 2,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          2,
    OPTION_NAME[FillerPercentage]:                      30,
    OPTION_NAME[FillerItemsDistribution]: {        
        item_names.STARTING_MINERALS: 10,
        item_names.STARTING_VESPENE: 10,
        item_names.STARTING_SUPPLY: 10,
        item_names.MAX_SUPPLY: 10,
        item_names.SHIELD_REGENERATION: 5,
        item_names.BUILDING_CONSTRUCTION_SPEED: 10,
        item_names.KERRIGAN_LEVELS_1: 0,
        item_names.UPGRADE_RESEARCH_SPEED: 10,
        item_names.UPGRADE_RESEARCH_COST: 10,
        item_names.REDUCED_MAX_SUPPLY: 0,
    }

}

all_protoss_settings = {
    # Vanilla campaign, but full Protoss. 62 missions, huge for one race, reduced locations, low values for fillers
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_normal,
    OPTION_NAME[SelectedRaces]:                         {SC2Race.PROTOSS.get_title()},
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_vanilla_shuffled,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]: {
        SC2Campaign.WOL.campaign_name, 
        SC2Campaign.PROPHECY.campaign_name,
        SC2Campaign.HOTS.campaign_name,
        SC2Campaign.PROLOGUE.campaign_name,
        SC2Campaign.LOTV.campaign_name, 
        # SC2Campaign.EPILOGUE.campaign_name,           enable once Epilogue gets race-swaps
        # SC2Campaign.NCO.campaign_name,                enable once NCO gets race-swaps
    },
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_shuffle_all,
    OPTION_NAME[KeyMode]:                               KeyMode.option_progressive_questlines,
    OPTION_NAME[MaximumCampaignSize]:                   61,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_off,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_grant,
    OPTION_NAME[GrantStoryLevels]:                      GrantStoryLevels.option_minimum,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_disabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_true,
    OPTION_NAME[GenericUpgradeItems]:                   GenericUpgradeItems.option_individual_items,
    OPTION_NAME[MinNumberOfUpgrades]:                   2,
    OPTION_NAME[MaxNumberOfUpgrades]:                   4,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_protoss,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_protoss,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunMaxActiveAbilities]:         3,
    OPTION_NAME[SpearOfAdunMaxAutocastAbilities]:       1,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[MineralsPerItem]:                       5,
    OPTION_NAME[VespenePerItem]:                        5,
    OPTION_NAME[StartingSupplyPerItem]:                 1,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          1,
    OPTION_NAME[FillerPercentage]:                      30,
    OPTION_NAME[FillerItemsDistribution]: {        
        item_names.STARTING_MINERALS: 1,
        item_names.STARTING_VESPENE: 1,
        item_names.STARTING_SUPPLY: 1,
        item_names.MAX_SUPPLY: 1,
        item_names.SHIELD_REGENERATION: 1,
        item_names.BUILDING_CONSTRUCTION_SPEED: 1,
        item_names.KERRIGAN_LEVELS_1: 0,
        item_names.UPGRADE_RESEARCH_SPEED: 1,
        item_names.UPGRADE_RESEARCH_COST: 1,
        item_names.REDUCED_MAX_SUPPLY: 0,
    }
}

evil_logic_settings = {
    # 6x6 grid on any_unit. High difficulty, disabled Kerrigan, harsh limits, trap items. any_unit has a chance to be unbeatable
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_brutal,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_grid,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_any_units,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_pick_one,
    OPTION_NAME[EnableMissionRaceBalancing]:            EnableMissionRaceBalancing.option_semi_balanced,
    OPTION_NAME[KeyMode]:                               KeyMode.option_progressive_questlines,
    OPTION_NAME[MaximumCampaignSize]:                   35,
    OPTION_NAME[TwoStartPositions]:                     TwoStartPositions.option_true,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_off,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_enabled,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_enabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_enabled,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_true,
    OPTION_NAME[NovaGhostOfAChanceVariant]:             NovaGhostOfAChanceVariant.option_nco,
    OPTION_NAME[GenericUpgradeItems]:                   GenericUpgradeItems.option_individual_items,
    OPTION_NAME[MinNumberOfUpgrades]:                   1,
    OPTION_NAME[MaxNumberOfUpgrades]:                   2,
    OPTION_NAME[NovaMaxWeapons]:                        1,
    OPTION_NAME[NovaMaxGadgets]:                        1,
    OPTION_NAME[KerriganPresence]:                      KerriganPresence.option_not_present,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_any_race_lotv,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_any_race_lotv,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunMaxActiveAbilities]:         2,
    OPTION_NAME[SpearOfAdunMaxAutocastAbilities]:       1,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[ExcludeOverpoweredItems]:               ExcludeOverpoweredItems.option_true,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_allow_substitutes,
    OPTION_NAME[MineralsPerItem]:                       10,
    OPTION_NAME[VespenePerItem]:                        10,
    OPTION_NAME[StartingSupplyPerItem]:                 2,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          2,
    OPTION_NAME[MaximumSupplyReductionPerItem]:         10,
    OPTION_NAME[FillerPercentage]:                      20,
    OPTION_NAME[FillerItemsDistribution]: {        
        item_names.STARTING_MINERALS: 10,
        item_names.STARTING_VESPENE: 10,
        item_names.STARTING_SUPPLY: 10,
        item_names.MAX_SUPPLY: 0,
        item_names.SHIELD_REGENERATION: 5,
        item_names.BUILDING_CONSTRUCTION_SPEED: 10,
        item_names.KERRIGAN_LEVELS_1: 0,
        item_names.UPGRADE_RESEARCH_SPEED: 10,
        item_names.UPGRADE_RESEARCH_COST: 10,
        item_names.REDUCED_MAX_SUPPLY: 2,
    }
}

full_campaign_settings = {
    # mandatory full campaign, not recommended, but will be expected. 195 mission grid, all races. Reduced locations and filler values
    OPTION_NAME[Accessibility]:                         Accessibility.option_full,
    OPTION_NAME[ProgressionBalancing]:                  ProgressionBalancing.default,
    OPTION_NAME[GameDifficulty]:                        GameDifficulty.option_normal,
    OPTION_NAME[SelectedRaces]:                         SelectedRaces.valid_keys,
    OPTION_NAME[MissionOrder]:                          MissionOrder.option_grid,
    OPTION_NAME[RequiredTactics]:                       RequiredTactics.option_standard,
    OPTION_NAME[EnabledCampaigns]:                      EnabledCampaigns.valid_keys,
    OPTION_NAME[EnableRaceSwapVariants]:                EnableRaceSwapVariants.option_shuffle_all,
    OPTION_NAME[KeyMode]:                               KeyMode.option_progressive_missions,
    OPTION_NAME[MaximumCampaignSize]:                   MaximumCampaignSize.range_end,
    OPTION_NAME[TwoStartPositions]:                     TwoStartPositions.option_true,
    OPTION_NAME[StarterUnit]:                           StarterUnit.option_off,
    OPTION_NAME[EnableMorphling]:                       EnableMorphling.option_true,
    OPTION_NAME[NovaGhostOfAChanceVariant]:             NovaGhostOfAChanceVariant.option_nco,
    OPTION_NAME[GrantStoryTech]:                        GrantStoryTech.option_allow_substitutes,
    OPTION_NAME[TakeOverAIAllies]:                      TakeOverAIAllies.option_false,
    OPTION_NAME[DifficultyCurve]:                       DifficultyCurve.option_standard,
    OPTION_NAME[VanillaLocations]:                      VanillaLocations.option_enabled,
    OPTION_NAME[ExtraLocations]:                        ExtraLocations.option_half_chance,
    OPTION_NAME[ChallengeLocations]:                    ChallengeLocations.option_disabled,
    OPTION_NAME[MasteryLocations]:                      MasteryLocations.option_disabled,
    OPTION_NAME[KerriganPrimalStatus]:                  KerriganPrimalStatus.option_item,
    OPTION_NAME[WarCouncilNerfs]:                       WarCouncilNerfs.option_true,
    OPTION_NAME[MaxUpgradeLevel]:                       5,
    OPTION_NAME[SpearOfAdunPresence]:                   SpearOfAdunPresence.option_everywhere,
    OPTION_NAME[SpearOfAdunPresentInNoBuild]:           SpearOfAdunPresentInNoBuild.option_false,
    OPTION_NAME[SpearOfAdunPassiveAbilityPresence]:     SpearOfAdunPassiveAbilityPresence.option_everywhere,        
    OPTION_NAME[SpearOfAdunPassivesPresentInNoBuild]:   SpearOfAdunPassivesPresentInNoBuild.option_false,
    OPTION_NAME[MissionOrderScouting]:                  MissionOrderScouting.option_completed,
    OPTION_NAME[MineralsPerItem]:                       5,
    OPTION_NAME[VespenePerItem]:                        5,
    OPTION_NAME[StartingSupplyPerItem]:                 1,
    OPTION_NAME[MaximumSupplyPerItem]:                  1,
    OPTION_NAME[ResearchCostReductionPerItem]:          1,
    OPTION_NAME[FillerItemsDistribution]: {        
        item_names.STARTING_MINERALS: 10,
        item_names.STARTING_VESPENE: 10,
        item_names.STARTING_SUPPLY: 10,
        item_names.MAX_SUPPLY: 10,
        item_names.SHIELD_REGENERATION: 5,
        item_names.BUILDING_CONSTRUCTION_SPEED: 10,
        item_names.KERRIGAN_LEVELS_1: 5,
        item_names.UPGRADE_RESEARCH_SPEED: 10,
        item_names.UPGRADE_RESEARCH_COST: 10,
        item_names.REDUCED_MAX_SUPPLY: 0,
    }
}

sc2_options_presets: Dict[str, Dict[str, Any]] = {
    "F2P Terran [~7 hours]":        template_settings,
    "F2P Big [~10 hours]":          f2p_big_settings,
    "Zerg Rush [~3 hours]":         zerg_rush_settings,
    "Classic Grid [~4 hours]":      classic_grid_settings,
    "Raceswap Blitz [~8 hours]":    raceswap_blitz_settings, 
    "Bread and Butter [~12 hours]": bread_and_butter_settings,
    "Pure Protoss [~15 hours]":     all_protoss_settings,
    "Evil Logic [~6 hours]":        evil_logic_settings,
    "Giant Grid Game [30+ hours]":  full_campaign_settings,
}
