"""
A complete collection of Starcraft 2 item names as strings.
Users of this data may make some assumptions about the structure of a name:
* The upgrade for a unit will end with the unit's name in parentheses
* Weapon / armor upgrades may be grouped by a common prefix specified within this file
"""

# Terran Units
MARINE         = "Marine"
MEDIC          = "Medic"
FIREBAT        = "Firebat"
MARAUDER       = "Marauder"
REAPER         = "Reaper"
HELLION        = "Hellion"
VULTURE        = "Vulture"
GOLIATH        = "Goliath"
DIAMONDBACK    = "Diamondback"
SIEGE_TANK     = "Siege Tank"
MEDIVAC        = "Medivac"
WRAITH         = "Wraith"
VIKING         = "Viking"
BANSHEE        = "Banshee"
BATTLECRUISER  = "Battlecruiser"
GHOST          = "Ghost"
SPECTRE        = "Spectre"
THOR           = "Thor"
RAVEN          = "Raven"
SCIENCE_VESSEL = "Science Vessel"
PREDATOR       = "Predator"
HERCULES       = "Hercules"
# Extended units
LIBERATOR        = "Liberator"
VALKYRIE         = "Valkyrie"
WIDOW_MINE       = "Widow Mine"
CYCLONE          = "Cyclone"
HERC             = "HERC"
WARHOUND         = "Warhound"
DOMINION_TROOPER = "Dominion Trooper"
# Elites
PRIDE_OF_AUGUSTRGRAD = "Pride of Augustgrad"
SKY_FURY             = "Sky Fury"
SHOCK_DIVISION       = "Shock Division"
BLACKHAMMER          = "Blackhammer"
AEGIS_GUARD          = "Aegis Guard"
EMPERORS_SHADOW      = "Emperor's Shadow"
SON_OF_KORHAL        = "Son of Korhal"
BULWARK_COMPANY      = "Bulwark Company"
FIELD_RESPONSE_THETA = "Field Response Theta"
EMPERORS_GUARDIAN    = "Emperor's Guardian"
NIGHT_HAWK           = "Night Hawk"
NIGHT_WOLF           = "Night Wolf"

# Terran Buildings
BUNKER                              = "Bunker"
MISSILE_TURRET                      = "Missile Turret"
SENSOR_TOWER                        = "Sensor Tower"
PLANETARY_FORTRESS                  = "Planetary Fortress"
PERDITION_TURRET                    = "Perdition Turret"
# HIVE_MIND_EMULATOR                  = "Hive Mind Emulator"# moved to Lab / Global upgrades
# PSI_DISRUPTER                       = "Psi Disrupter"     # moved to Lab / Global upgrades
DEVASTATOR_TURRET                   = "Devastator Turret"

# Terran Weapon / Armor Upgrades
TERRAN_UPGRADE_PREFIX = "Progressive Terran"
TERRAN_INFANTRY_UPGRADE_PREFIX = f"{TERRAN_UPGRADE_PREFIX} Infantry"
TERRAN_VEHICLE_UPGRADE_PREFIX = f"{TERRAN_UPGRADE_PREFIX} Vehicle"
TERRAN_SHIP_UPGRADE_PREFIX = f"{TERRAN_UPGRADE_PREFIX} Ship"

PROGRESSIVE_TERRAN_INFANTRY_WEAPON      = f"{TERRAN_INFANTRY_UPGRADE_PREFIX} Weapon"
PROGRESSIVE_TERRAN_INFANTRY_ARMOR       = f"{TERRAN_INFANTRY_UPGRADE_PREFIX} Armor"
PROGRESSIVE_TERRAN_VEHICLE_WEAPON       = f"{TERRAN_VEHICLE_UPGRADE_PREFIX} Weapon"
PROGRESSIVE_TERRAN_VEHICLE_ARMOR        = f"{TERRAN_VEHICLE_UPGRADE_PREFIX} Armor"
PROGRESSIVE_TERRAN_SHIP_WEAPON          = f"{TERRAN_SHIP_UPGRADE_PREFIX} Weapon"
PROGRESSIVE_TERRAN_SHIP_ARMOR           = f"{TERRAN_SHIP_UPGRADE_PREFIX} Armor"
PROGRESSIVE_TERRAN_WEAPON_UPGRADE       = f"{TERRAN_UPGRADE_PREFIX} Weapon Upgrade"
PROGRESSIVE_TERRAN_ARMOR_UPGRADE        = f"{TERRAN_UPGRADE_PREFIX} Armor Upgrade"
PROGRESSIVE_TERRAN_INFANTRY_UPGRADE     = f"{TERRAN_INFANTRY_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_TERRAN_VEHICLE_UPGRADE      = f"{TERRAN_VEHICLE_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_TERRAN_SHIP_UPGRADE         = f"{TERRAN_SHIP_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_TERRAN_WEAPON_ARMOR_UPGRADE = f"{TERRAN_UPGRADE_PREFIX} Weapon/Armor Upgrade"

# Mercenaries
WAR_PIGS          = "War Pigs"
DEVIL_DOGS        = "Devil Dogs"
HAMMER_SECURITIES = "Hammer Securities"
SPARTAN_COMPANY   = "Spartan Company"
SIEGE_BREAKERS    = "Siege Breakers"
HELS_ANGELS       = "Hel's Angels"
DUSK_WINGS        = "Dusk Wings"
JACKSONS_REVENGE  = "Jackson's Revenge"
SKIBIS_ANGELS     = "Skibi's Angels"
DEATH_HEADS       = "Death Heads"
WINGED_NIGHTMARES = "Winged Nightmares"
MIDNIGHT_RIDERS   = "Midnight Riders"
BRYNHILDS         = "Brynhilds"
JOTUN             = "Jotun"

# Lab / Global
ULTRA_CAPACITORS                      = "Ultra-Capacitors (Terran)"
VANADIUM_PLATING                      = "Vanadium Plating (Terran)"
ORBITAL_DEPOTS                        = "Orbital Depots (Terran)"
MICRO_FILTERING                       = "Micro-Filtering (Terran)"
AUTOMATED_REFINERY                    = "Automated Refinery (Terran)"
COMMAND_CENTER_COMMAND_CENTER_REACTOR = "Command Center Reactor (Command Center)"
COMMAND_CENTER_SCANNER_SWEEP          = "Scanner Sweep (Command Center)"
COMMAND_CENTER_MULE                   = "MULE (Command Center)"
COMMAND_CENTER_EXTRA_SUPPLIES         = "Extra Supplies (Command Center)"
TECH_REACTOR                          = "Tech Reactor (Terran)"
ORBITAL_STRIKE                        = "Orbital Strike (Barracks)"
CELLULAR_REACTOR                      = "Cellular Reactor (Terran)"
PROGRESSIVE_REGENERATIVE_BIO_STEEL    = "Progressive Regenerative Bio-Steel (Terran)"
PROGRESSIVE_FIRE_SUPPRESSION_SYSTEM   = "Progressive Fire-Suppression System (Terran)"
STRUCTURE_ARMOR                       = "Structure Armor (Terran)"
HI_SEC_AUTO_TRACKING                  = "Hi-Sec Auto Tracking (Terran)"
ADVANCED_OPTICS                       = "Advanced Optics (Terran)"
ROGUE_FORCES                          = "Rogue Forces (Terran)"
MECHANICAL_KNOW_HOW                   = "Mechanical Know-how (Terran)"
MERCENARY_MUNITIONS                   = "Mercenary Munitions (Terran)"
PROGRESSIVE_FAST_DELIVERY             = "Progressive Fast Delivery (Terran)"
RAPID_REINFORCEMENT                   = "Rapid Reinforcement (Terran)"
FUSION_CORE_FUSION_REACTOR            = "Fusion Reactor (Fusion Core)"
PSI_DISRUPTER                         = "Psi Disrupter"  
PSI_SCREEN                            = "Psi Screen (Psi Disrupter)"  
SONIC_DISRUPTER                       = "Sonic Disrupter (Psi Disrupter)"  
HIVE_MIND_EMULATOR                    = "Hive Mind Emulator"
PSI_INDOCTRINATOR                     = "Psi Indoctrinator (Hive Mind Emulator)"
ARGUS_AMPLIFIER                       = "Argus Amplifier (Hive Mind Emulator)"
SIGNAL_BEACON                         = "Signal Beacon (Terran)"

# Terran Unit Upgrades
BANSHEE_HYPERFLIGHT_ROTORS                         = "Hyperflight Rotors (Banshee)"
BANSHEE_INTERNAL_TECH_MODULE                       = "Internal Tech Module (Banshee)"
BANSHEE_LASER_TARGETING_SYSTEM                     = "Laser Targeting System (Banshee)"
BANSHEE_PROGRESSIVE_CROSS_SPECTRUM_DAMPENERS       = "Progressive Cross-Spectrum Dampeners (Banshee)"
BANSHEE_SHOCKWAVE_MISSILE_BATTERY                  = "Shockwave Missile Battery (Banshee)"
BANSHEE_SHAPED_HULL                                = "Shaped Hull (Banshee)"
BANSHEE_ADVANCED_TARGETING_OPTICS                  = "Advanced Targeting Optics (Banshee)"
BANSHEE_DISTORTION_BLASTERS                        = "Distortion Blasters (Banshee)"
BANSHEE_ROCKET_BARRAGE                             = "Rocket Barrage (Banshee)"
BATTLECRUISER_ATX_LASER_BATTERY                    = "ATX Laser Battery (Battlecruiser)"
BATTLECRUISER_CLOAK                                = "Cloak (Battlecruiser)"
BATTLECRUISER_PROGRESSIVE_DEFENSIVE_MATRIX         = "Progressive Defensive Matrix (Battlecruiser)"
BATTLECRUISER_INTERNAL_TECH_MODULE                 = "Internal Tech Module (Battlecruiser)"
BATTLECRUISER_PROGRESSIVE_MISSILE_PODS             = "Progressive Missile Pods (Battlecruiser)"
BATTLECRUISER_OPTIMIZED_LOGISTICS                  = "Optimized Logistics (Battlecruiser)"
BATTLECRUISER_TACTICAL_JUMP                        = "Tactical Jump (Battlecruiser)"
BATTLECRUISER_BEHEMOTH_PLATING                     = "Behemoth Plating (Battlecruiser)"
BATTLECRUISER_MOIRAI_IMPULSE_DRIVE                 = "Moirai Impulse Drive (Battlecruiser)"
BATTLECRUISER_BEHEMOTH_REACTOR                     = "Behemoth Reactor (Battlecruiser)"
BATTLECRUISER_FIELD_ASSIST_TARGETING_SYSTEM        = "Field-Assist Target System (Battlecruiser)"
CYCLONE_MAG_FIELD_ACCELERATORS                     = "Mag-Field Accelerators (Cyclone)"
CYCLONE_MAG_FIELD_LAUNCHERS                        = "Mag-Field Launchers (Cyclone)"
CYCLONE_RAPID_FIRE_LAUNCHERS                       = "Rapid Fire Launchers (Cyclone)"
CYCLONE_TARGETING_OPTICS                           = "Targeting Optics (Cyclone)"
CYCLONE_RESOURCE_EFFICIENCY                        = "Resource Efficiency (Cyclone)"
CYCLONE_INTERNAL_TECH_MODULE                       = "Internal Tech Module (Cyclone)"
DIAMONDBACK_BURST_CAPACITORS                       = "Burst Capacitors (Diamondback)"
DIAMONDBACK_HYPERFLUXOR                            = "Hyperfluxor (Diamondback)"
DIAMONDBACK_RESOURCE_EFFICIENCY                    = "Resource Efficiency (Diamondback)"
DIAMONDBACK_SHAPED_HULL                            = "Shaped Hull (Diamondback)"
DIAMONDBACK_PROGRESSIVE_TRI_LITHIUM_POWER_CELL     = "Progressive Tri-Lithium Power Cell (Diamondback)"
DIAMONDBACK_MAGLEV_PROPULSION                      = "Maglev Propulsion (Diamondback)"
DOMINION_TROOPER_B2_HIGH_CAL_LMG                   = "B-2 High-Cal LMG (Dominion Trooper)"
DOMINION_TROOPER_CPO7_SALAMANDER_FLAMETHROWER      = "CPO-7 Salamander Flamethrower (Dominion Trooper)"
DOMINION_TROOPER_HAILSTORM_LAUNCHER                = "Hailstorm Launcher (Dominion Trooper)"
DOMINION_TROOPER_ADVANCED_ALLOYS                   = "Advanced Alloys (Dominion Trooper)"
DOMINION_TROOPER_OPTIMIZED_LOGISTICS               = "Optimized Logistics (Dominion Trooper)"
EMPERORS_SHADOW_SOVEREIGN_TACTICAL_MISSILES        = "Sovereign Tactical Missiles (Emperor's Shadow)"
FIREBAT_INCINERATOR_GAUNTLETS                      = "Incinerator Gauntlets (Firebat)"
FIREBAT_JUGGERNAUT_PLATING                         = "Juggernaut Plating (Firebat)"
FIREBAT_RESOURCE_EFFICIENCY                        = "Resource Efficiency (Firebat)"
FIREBAT_PROGRESSIVE_STIMPACK                       = "Progressive Stimpack (Firebat)"
FIREBAT_INFERNAL_PRE_IGNITER                       = "Infernal Pre-Igniter (Firebat)"
FIREBAT_KINETIC_FOAM                               = "Kinetic Foam (Firebat)"
FIREBAT_NANO_PROJECTORS                            = "Nano Projectors (Firebat)"
GHOST_CRIUS_SUIT                                   = "Crius Suit (Ghost)"
GHOST_EMP_ROUNDS                                   = "EMP Rounds (Ghost)"
GHOST_LOCKDOWN                                     = "Lockdown (Ghost)"
GHOST_OCULAR_IMPLANTS                              = "Ocular Implants (Ghost)"
GHOST_RESOURCE_EFFICIENCY                          = "Resource Efficiency (Ghost)"
GHOST_BARGAIN_BIN_PRICES                           = "Bargain Bin Prices (Ghost)"
GOLIATH_ARES_CLASS_TARGETING_SYSTEM                = "Ares-Class Targeting System (Goliath)"
GOLIATH_JUMP_JETS                                  = "Jump Jets (Goliath)"
GOLIATH_MULTI_LOCK_WEAPONS_SYSTEM                  = "Multi-Lock Weapons System (Goliath)"
GOLIATH_OPTIMIZED_LOGISTICS                        = "Optimized Logistics (Goliath)"
GOLIATH_SHAPED_HULL                                = "Shaped Hull (Goliath)"
GOLIATH_RESOURCE_EFFICIENCY                        = "Resource Efficiency (Goliath)"
GOLIATH_INTERNAL_TECH_MODULE                       = "Internal Tech Module (Goliath)"
HELLION_HELLBAT                                    = "Hellbat (Hellion Morph)"
HELLION_JUMP_JETS                                  = "Jump Jets (Hellion)"
HELLION_OPTIMIZED_LOGISTICS                        = "Optimized Logistics (Hellion)"
HELLION_PROGRESSIVE_STIMPACK                       = "Progressive Stimpack (Hellion)"
HELLION_SMART_SERVOS                               = "Smart Servos (Hellion)"
HELLION_THERMITE_FILAMENTS                         = "Thermite Filaments (Hellion)"
HELLION_TWIN_LINKED_FLAMETHROWER                   = "Twin-Linked Flamethrower (Hellion)"
HELLION_INFERNAL_PLATING                           = "Infernal Plating (Hellion)"
HERC_JUGGERNAUT_PLATING                            = "Juggernaut Plating (HERC)"
HERC_KINETIC_FOAM                                  = "Kinetic Foam (HERC)"
HERC_RESOURCE_EFFICIENCY                           = "Resource Efficiency (HERC)"
HERC_GRAPPLE_PULL                                  = "Grapple Pull (HERC)"
HERCULES_INTERNAL_FUSION_MODULE                    = "Internal Fusion Module (Hercules)"
HERCULES_TACTICAL_JUMP                             = "Tactical Jump (Hercules)"
LIBERATOR_ADVANCED_BALLISTICS                      = "Advanced Ballistics (Liberator)"
LIBERATOR_CLOAK                                    = "Cloak (Liberator)"
LIBERATOR_LASER_TARGETING_SYSTEM                   = "Laser Targeting System (Liberator)"
LIBERATOR_OPTIMIZED_LOGISTICS                      = "Optimized Logistics (Liberator)"
LIBERATOR_RAID_ARTILLERY                           = "Raid Artillery (Liberator)"
LIBERATOR_SMART_SERVOS                             = "Smart Servos (Liberator)"
LIBERATOR_RESOURCE_EFFICIENCY                      = "Resource Efficiency (Liberator)"
LIBERATOR_GUERILLA_MISSILES                        = "Guerilla Missiles (Liberator)"
LIBERATOR_UED_MISSILE_TECHNOLOGY                   = "UED Missile Technology (Liberator)"
MARAUDER_CONCUSSIVE_SHELLS                         = "Concussive Shells (Marauder)"
MARAUDER_INTERNAL_TECH_MODULE                      = "Internal Tech Module (Marauder)"
MARAUDER_KINETIC_FOAM                              = "Kinetic Foam (Marauder)"
MARAUDER_LASER_TARGETING_SYSTEM                    = "Laser Targeting System (Marauder)"
MARAUDER_MAGRAIL_MUNITIONS                         = "Magrail Munitions (Marauder)"
MARAUDER_PROGRESSIVE_STIMPACK                      = "Progressive Stimpack (Marauder)"
MARAUDER_JUGGERNAUT_PLATING                        = "Juggernaut Plating (Marauder)"
MARINE_COMBAT_SHIELD                               = "Combat Shield (Marine)"
MARINE_LASER_TARGETING_SYSTEM                      = "Laser Targeting System (Marine)"
MARINE_MAGRAIL_MUNITIONS                           = "Magrail Munitions (Marine)"
MARINE_OPTIMIZED_LOGISTICS                         = "Optimized Logistics (Marine)"
MARINE_PROGRESSIVE_STIMPACK                        = "Progressive Stimpack (Marine)"
MEDIC_ADVANCED_MEDIC_FACILITIES                    = "Advanced Medic Facilities (Medic)"
MEDIC_OPTICAL_FLARE                                = "Optical Flare (Medic)"
MEDIC_RESOURCE_EFFICIENCY                          = "Resource Efficiency (Medic)"
MEDIC_RESTORATION                                  = "Restoration (Medic)"
MEDIC_STABILIZER_MEDPACKS                          = "Stabilizer Medpacks (Medic)"
MEDIC_ADAPTIVE_MEDPACKS                            = "Adaptive Medpacks (Medic)"
MEDIC_NANO_PROJECTOR                               = "Nano Projector (Medic)"
MEDIVAC_ADVANCED_HEALING_AI                        = "Advanced Healing AI (Medivac)"
MEDIVAC_AFTERBURNERS                               = "Afterburners (Medivac)"
MEDIVAC_EXPANDED_HULL                              = "Expanded Hull (Medivac)"
MEDIVAC_RAPID_DEPLOYMENT_TUBE                      = "Rapid Deployment Tube (Medivac)"
MEDIVAC_SCATTER_VEIL                               = "Scatter Veil (Medivac)"
MEDIVAC_ADVANCED_CLOAKING_FIELD                    = "Advanced Cloaking Field (Medivac)"
MEDIVAC_RAPID_REIGNITION_SYSTEMS                   = "Rapid Reignition Systems (Medivac)"
MEDIVAC_RESOURCE_EFFICIENCY                        = "Resource Efficiency (Medivac)"
PREDATOR_RESOURCE_EFFICIENCY                       = "Resource Efficiency (Predator)"
PREDATOR_CLOAK                                     = "Phase Cloak (Predator)"
PREDATOR_CHARGE                                    = "Concussive Charge (Predator)"
PREDATOR_VESPENE_SYNTHESIS                         = "Vespene Synthesis (Predator)"
PREDATOR_ADAPTIVE_DEFENSES                         = "Adaptive Defenses (Predator)"
RAVEN_ANTI_ARMOR_MISSILE                           = "Anti-Armor Missile (Raven)"
RAVEN_BIO_MECHANICAL_REPAIR_DRONE                  = "Bio Mechanical Repair Drone (Raven)"
RAVEN_HUNTER_SEEKER_WEAPON                         = "Hunter-Seeker Weapon (Raven)"
RAVEN_INTERFERENCE_MATRIX                          = "Interference Matrix (Raven)"
RAVEN_INTERNAL_TECH_MODULE                         = "Internal Tech Module (Raven)"
RAVEN_RAILGUN_TURRET                               = "Railgun Turret (Raven)"
RAVEN_SPIDER_MINES                                 = "Spider Mines (Raven)"
RAVEN_RESOURCE_EFFICIENCY                          = "Resource Efficiency (Raven)"
RAVEN_DURABLE_MATERIALS                            = "Durable Materials (Raven)"
REAPER_ADVANCED_CLOAKING_FIELD                     = "Advanced Cloaking Field (Reaper)"
REAPER_COMBAT_DRUGS                                = "Combat Drugs (Reaper)"
REAPER_G4_CLUSTERBOMB                              = "G-4 Clusterbomb (Reaper)"
REAPER_LASER_TARGETING_SYSTEM                      = "Laser Targeting System (Reaper)"
REAPER_PROGRESSIVE_STIMPACK                        = "Progressive Stimpack (Reaper)"
REAPER_SPIDER_MINES                                = "Spider Mines (Reaper)"
REAPER_U238_ROUNDS                                 = "U-238 Rounds (Reaper)"
REAPER_JET_PACK_OVERDRIVE                          = "Jet Pack Overdrive (Reaper)"
REAPER_RESOURCE_EFFICIENCY                         = "Resource Efficiency (Reaper)"
REAPER_BALLISTIC_FLIGHTSUIT                        = "Ballistic Flightsuit (Reaper)"
SCIENCE_VESSEL_DEFENSIVE_MATRIX                    = "Defensive Matrix (Science Vessel)"
SCIENCE_VESSEL_EMP_SHOCKWAVE                       = "EMP Shockwave (Science Vessel)"
SCIENCE_VESSEL_IMPROVED_NANO_REPAIR                = "Improved Nano-Repair (Science Vessel)"
SCIENCE_VESSEL_MAGELLAN_COMPUTATION_SYSTEMS        = "Magellan Computation Systems (Science Vessel)"
SCIENCE_VESSEL_TACTICAL_JUMP                       = "Tactical Jump (Science Vessel)"
SCV_ADVANCED_CONSTRUCTION                          = "Advanced Construction (SCV)"
SCV_DUAL_FUSION_WELDERS                            = "Dual-Fusion Welders (SCV)"
SCV_HOSTILE_ENVIRONMENT_ADAPTATION                 = "Hostile Environment Adaptation (SCV)"
SCV_CONSTRUCTION_JUMP_JETS                         = "Construction Jump Jets (SCV)"
SIEGE_TANK_ADVANCED_SIEGE_TECH                     = "Advanced Siege Tech (Siege Tank)"
SIEGE_TANK_GRADUATING_RANGE                        = "Graduating Range (Siege Tank)"
SIEGE_TANK_INTERNAL_TECH_MODULE                    = "Internal Tech Module (Siege Tank)"
SIEGE_TANK_JUMP_JETS                               = "Jump Jets (Siege Tank)"
SIEGE_TANK_LASER_TARGETING_SYSTEM                  = "Laser Targeting System (Siege Tank)"
SIEGE_TANK_MAELSTROM_ROUNDS                        = "Maelstrom Rounds (Siege Tank)"
SIEGE_TANK_SHAPED_BLAST                            = "Shaped Blast (Siege Tank)"
SIEGE_TANK_SMART_SERVOS                            = "Smart Servos (Siege Tank)"
SIEGE_TANK_SPIDER_MINES                            = "Spider Mines (Siege Tank)"
SIEGE_TANK_SHAPED_HULL                             = "Shaped Hull (Siege Tank)"
SIEGE_TANK_RESOURCE_EFFICIENCY                     = "Resource Efficiency (Siege Tank)"
SIEGE_TANK_PROGRESSIVE_TRANSPORT_HOOK              = "Progressive Transport Hook (Siege Tank)"
SIEGE_TANK_ALLTERRAIN_TREADS                       = "All-Terrain Treads (Siege Tank)"
SPECTRE_IMPALER_ROUNDS                             = "Impaler Rounds (Spectre)"
SPECTRE_NYX_CLASS_CLOAKING_MODULE                  = "Nyx-Class Cloaking Module (Spectre)"
SPECTRE_PSIONIC_LASH                               = "Psionic Lash (Spectre)"
SPECTRE_RESOURCE_EFFICIENCY                        = "Resource Efficiency (Spectre)"
SPECTRE_BARGAIN_BIN_PRICES                         = "Bargain Bin Prices (Spectre)"
SPIDER_MINE_CERBERUS_MINE                          = "Cerberus Mine (Spider Mine)"
SPIDER_MINE_HIGH_EXPLOSIVE_MUNITION                = "High Explosive Munition (Spider Mine)"
THOR_330MM_BARRAGE_CANNON                          = "330mm Barrage Cannon (Thor)"
THOR_PROGRESSIVE_IMMORTALITY_PROTOCOL              = "Progressive Immortality Protocol (Thor)"
THOR_PROGRESSIVE_HIGH_IMPACT_PAYLOAD               = "Progressive High Impact Payload (Thor)"
THOR_BUTTON_WITH_A_SKULL_ON_IT                     = "Button With a Skull on It (Thor)"
THOR_LASER_TARGETING_SYSTEM                        = "Laser Targeting System (Thor)"
THOR_LARGE_SCALE_FIELD_CONSTRUCTION                = "Large Scale Field Construction (Thor)"
THOR_RAPID_RELOAD                                  = "Rapid Reload (Thor)"
VALKYRIE_AFTERBURNERS                              = "Afterburners (Valkyrie)"
VALKYRIE_FLECHETTE_MISSILES                        = "Flechette Missiles (Valkyrie)"
VALKYRIE_ENHANCED_CLUSTER_LAUNCHERS                = "Enhanced Cluster Launchers (Valkyrie)"
VALKYRIE_SHAPED_HULL                               = "Shaped Hull (Valkyrie)"
VALKYRIE_LAUNCHING_VECTOR_COMPENSATOR              = "Launching Vector Compensator (Valkyrie)"
VALKYRIE_RESOURCE_EFFICIENCY                       = "Resource Efficiency (Valkyrie)"
VIKING_ANTI_MECHANICAL_MUNITION                    = "Anti-Mechanical Munition (Viking)"
VIKING_PHOBOS_CLASS_WEAPONS_SYSTEM                 = "Phobos-Class Weapons System (Viking)"
VIKING_RIPWAVE_MISSILES                            = "Ripwave Missiles (Viking)"
VIKING_SMART_SERVOS                                = "Smart Servos (Viking)"
VIKING_SHREDDER_ROUNDS                             = "Shredder Rounds (Viking)"
VIKING_WILD_MISSILES                               = "W.I.L.D. Missiles (Viking)"
VIKING_AESIR_TURBINES                              = "Aesir Turbines (Viking)"
VULTURE_AUTO_LAUNCHERS                             = "Auto Launchers (Vulture)"
VULTURE_ION_THRUSTERS                              = "Ion Thrusters (Vulture)"
VULTURE_PROGRESSIVE_REPLENISHABLE_MAGAZINE         = "Progressive Replenishable Magazine (Vulture)"
VULTURE_JERRYRIGGED_PATCHUP                        = "Jerry-Rigged Patchup (Vulture)"
WARHOUND_RESOURCE_EFFICIENCY                       = "Resource Efficiency (Warhound)"
WARHOUND_AXIOM_PLATING                             = "Axiom Plating (Warhound)"
WARHOUND_DEPLOY_TURRET                             = "Deploy Turret (Warhound)"
WIDOW_MINE_BLACK_MARKET_LAUNCHERS                  = "Black Market Launchers (Widow Mine)"
WIDOW_MINE_CONCEALMENT                             = "Concealment (Widow Mine)"
WIDOW_MINE_DEMOLITION_PAYLOAD                      = "Demolition Payload (Widow Mine)"
WIDOW_MINE_DRILLING_CLAWS                          = "Drilling Claws (Widow Mine)"
WIDOW_MINE_EXECUTIONER_MISSILES                    = "Executioner Missiles (Widow Mine)"
WIDOW_MINE_RESOURCE_EFFICIENCY                     = "Resource Efficiency (Widow Mine)"
WRAITH_ADVANCED_LASER_TECHNOLOGY                   = "Advanced Laser Technology (Wraith)"
WRAITH_DISPLACEMENT_FIELD                          = "Displacement Field (Wraith)"
WRAITH_PROGRESSIVE_TOMAHAWK_POWER_CELLS            = "Progressive Tomahawk Power Cells (Wraith)"
WRAITH_TRIGGER_OVERRIDE                            = "Trigger Override (Wraith)"
WRAITH_INTERNAL_TECH_MODULE                        = "Internal Tech Module (Wraith)"
WRAITH_RESOURCE_EFFICIENCY                         = "Resource Efficiency (Wraith)"

# Terran Building upgrades
BUNKER_NEOSTEEL_BUNKER                             = "Neosteel Bunker (Bunker)"
BUNKER_PROJECTILE_ACCELERATOR                      = "Projectile Accelerator (Bunker)"
BUNKER_SHRIKE_TURRET                               = "Shrike Turret (Bunker)"
BUNKER_FORTIFIED_BUNKER                            = "Fortified Bunker (Bunker)"
DEVASTATOR_TURRET_ANTI_ARMOR_MUNITIONS             = "Anti-Armor Munitions (Devastator Turret)"
DEVASTATOR_TURRET_CONCUSSIVE_GRENADES              = "Concussive Grenades (Devastator Turret)"
DEVASTATOR_TURRET_RESOURCE_EFFICIENCY              = "Resource Efficiency (Devastator Turret)"
MISSILE_TURRET_HELLSTORM_BATTERIES                 = "Hellstorm Batteries (Missile Turret)"
MISSILE_TURRET_TITANIUM_HOUSING                    = "Titanium Housing (Missile Turret)"
MISSILE_TURRET_RESOURCE_EFFICENCY                  = "Resource Efficiency (Missile Turret)"
PLANETARY_FORTRESS_PROGRESSIVE_AUGMENTED_THRUSTERS = "Progressive Augmented Thrusters (Planetary Fortress)"
PLANETARY_FORTRESS_IBIKS_TRACKING_SCANNERS         = "Ibiks Tracking Scanners (Planetary Fortress)"
PLANETARY_FORTRESS_ORBITAL_MODULE                  = "Orbital Module (Planetary Fortress)"
SENSOR_TOWER_ASSISTIVE_TARGETING                   = "Assistive Targeting (Sensor Tower)"
SENSOR_TOWER_MUILTISPECTRUM_DOPPLER                = "Multispectrum Doppler (Sensor Tower)"

# Nova
NOVA_GHOST_VISOR                        = "Ghost Visor (Nova Equipment)"
NOVA_RANGEFINDER_OCULUS                 = "Rangefinder Oculus (Nova Equipment)"
NOVA_DOMINATION                         = "Domination (Nova Ability)"
NOVA_BLINK                              = "Blink (Nova Ability)"
NOVA_PROGRESSIVE_STEALTH_SUIT_MODULE    = "Progressive Stealth Suit Module (Nova Suit Module)"
NOVA_ENERGY_SUIT_MODULE                 = "Energy Suit Module (Nova Suit Module)"
NOVA_ARMORED_SUIT_MODULE                = "Armored Suit Module (Nova Suit Module)"
NOVA_JUMP_SUIT_MODULE                   = "Jump Suit Module (Nova Suit Module)"
NOVA_C20A_CANISTER_RIFLE                = "C20A Canister Rifle (Nova Weapon)"
NOVA_HELLFIRE_SHOTGUN                   = "Hellfire Shotgun (Nova Weapon)"
NOVA_PLASMA_RIFLE                       = "Plasma Rifle (Nova Weapon)"
NOVA_MONOMOLECULAR_BLADE                = "Monomolecular Blade (Nova Weapon)"
NOVA_BLAZEFIRE_GUNBLADE                 = "Blazefire Gunblade (Nova Weapon)"
NOVA_STIM_INFUSION                      = "Stim Infusion (Nova Gadget)"
NOVA_PULSE_GRENADES                     = "Pulse Grenades (Nova Gadget)"
NOVA_FLASHBANG_GRENADES                 = "Flashbang Grenades (Nova Gadget)"
NOVA_IONIC_FORCE_FIELD                  = "Ionic Force Field (Nova Gadget)"
NOVA_HOLO_DECOY                         = "Holo Decoy (Nova Gadget)"
NOVA_NUKE                               = "Tac Nuke Strike (Nova Ability)"

# Zerg Units
ZERGLING             = "Zergling"
SWARM_QUEEN          = "Swarm Queen"
ROACH                = "Roach"
HYDRALISK            = "Hydralisk"
ABERRATION           = "Aberration"
MUTALISK             = "Mutalisk"
SWARM_HOST           = "Swarm Host"
INFESTOR             = "Infestor"
ULTRALISK            = "Ultralisk"
PYGALISK             = "Pygalisk"
CORRUPTOR            = "Corruptor"
SCOURGE              = "Scourge"
BROOD_QUEEN          = "Brood Queen"
DEFILER              = "Defiler"
INFESTED_MARINE      = "Infested Marine"
INFESTED_SIEGE_TANK  = "Infested Siege Tank"
INFESTED_DIAMONDBACK = "Infested Diamondback"
BULLFROG             = "Bullfrog"
INFESTED_BANSHEE     = "Infested Banshee"
INFESTED_LIBERATOR   = "Infested Liberator"

# Zerg Buildings
SPORE_CRAWLER           = "Spore Crawler"
SPINE_CRAWLER           = "Spine Crawler"
BILE_LAUNCHER           = "Bile Launcher"
INFESTED_BUNKER         = "Infested Bunker"
INFESTED_MISSILE_TURRET = "Infested Missile Turret"
NYDUS_WORM              = "Nydus Worm"
ECHIDNA_WORM            = "Echidna Worm"

# Zerg Weapon / Armor Upgrades
ZERG_UPGRADE_PREFIX = "Progressive Zerg"
ZERG_FLYER_UPGRADE_PREFIX = f"{ZERG_UPGRADE_PREFIX} Flyer"

PROGRESSIVE_ZERG_MELEE_ATTACK         = f"{ZERG_UPGRADE_PREFIX} Melee Attack"
PROGRESSIVE_ZERG_MISSILE_ATTACK       = f"{ZERG_UPGRADE_PREFIX} Missile Attack"
PROGRESSIVE_ZERG_GROUND_CARAPACE      = f"{ZERG_UPGRADE_PREFIX} Ground Carapace"
PROGRESSIVE_ZERG_FLYER_ATTACK         = f"{ZERG_FLYER_UPGRADE_PREFIX} Attack"
PROGRESSIVE_ZERG_FLYER_CARAPACE       = f"{ZERG_FLYER_UPGRADE_PREFIX} Carapace"
PROGRESSIVE_ZERG_WEAPON_UPGRADE       = f"{ZERG_UPGRADE_PREFIX} Weapon Upgrade"
PROGRESSIVE_ZERG_ARMOR_UPGRADE        = f"{ZERG_UPGRADE_PREFIX} Armor Upgrade"
PROGRESSIVE_ZERG_GROUND_UPGRADE       = f"{ZERG_UPGRADE_PREFIX} Ground Upgrade"
PROGRESSIVE_ZERG_FLYER_UPGRADE        = f"{ZERG_FLYER_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_ZERG_WEAPON_ARMOR_UPGRADE = f"{ZERG_UPGRADE_PREFIX} Weapon/Armor Upgrade"

# Zerg Unit Upgrades
ZERGLING_HARDENED_CARAPACE                        = "Hardened Carapace (Zergling)"
ZERGLING_ADRENAL_OVERLOAD                         = "Adrenal Overload (Zergling)"
ZERGLING_METABOLIC_BOOST                          = "Metabolic Boost (Zergling)"
ZERGLING_SHREDDING_CLAWS                          = "Shredding Claws (Zergling)"
ROACH_HYDRIODIC_BILE                              = "Hydriodic Bile (Roach)"
ROACH_ADAPTIVE_PLATING                            = "Adaptive Plating (Roach)"
ROACH_TUNNELING_CLAWS                             = "Tunneling Claws (Roach)"
ROACH_GLIAL_RECONSTITUTION                        = "Glial Reconstitution (Roach)"
ROACH_ORGANIC_CARAPACE                            = "Organic Carapace (Roach)"
HYDRALISK_FRENZY                                  = "Frenzy (Hydralisk)"
HYDRALISK_ANCILLARY_CARAPACE                      = "Ancillary Carapace (Hydralisk)"
HYDRALISK_GROOVED_SPINES                          = "Grooved Spines (Hydralisk)"
HYDRALISK_MUSCULAR_AUGMENTS                       = "Muscular Augments (Hydralisk)"
HYDRALISK_RESOURCE_EFFICIENCY                     = "Resource Efficiency (Hydralisk)"
BANELING_CORROSIVE_ACID                           = "Corrosive Acid (Baneling)"
BANELING_RUPTURE                                  = "Rupture (Baneling)"
BANELING_REGENERATIVE_ACID                        = "Regenerative Acid (Baneling)"
BANELING_CENTRIFUGAL_HOOKS                        = "Centrifugal Hooks (Baneling)"
BANELING_TUNNELING_JAWS                           = "Tunneling Jaws (Baneling)"
BANELING_RAPID_METAMORPH                          = "Rapid Metamorph (Baneling)"
MUTALISK_VICIOUS_GLAIVE                           = "Vicious Glaive (Mutalisk)"
MUTALISK_RAPID_REGENERATION                       = "Rapid Regeneration (Mutalisk)"
MUTALISK_SUNDERING_GLAIVE                         = "Sundering Glaive (Mutalisk)"
MUTALISK_SEVERING_GLAIVE                          = "Severing Glaive (Mutalisk)"
MUTALISK_AERODYNAMIC_GLAIVE_SHAPE                 = "Aerodynamic Glaive Shape (Mutalisk)"
SPORE_CRAWLER_BIO_BONUS                           = "Caustic Enzymes (Spore Crawler)"
SWARM_HOST_BURROW                                 = "Burrow (Swarm Host)"
SWARM_HOST_RAPID_INCUBATION                       = "Rapid Incubation (Swarm Host)"
SWARM_HOST_PRESSURIZED_GLANDS                     = "Pressurized Glands (Swarm Host)"
SWARM_HOST_LOCUST_METABOLIC_BOOST                 = "Locust Metabolic Boost (Swarm Host)"
SWARM_HOST_ENDURING_LOCUSTS                       = "Enduring Locusts (Swarm Host)"
SWARM_HOST_ORGANIC_CARAPACE                       = "Organic Carapace (Swarm Host)"
SWARM_HOST_RESOURCE_EFFICIENCY                    = "Resource Efficiency (Swarm Host)"
ULTRALISK_BURROW_CHARGE                           = "Burrow Charge (Ultralisk)"
ULTRALISK_TISSUE_ASSIMILATION                     = "Tissue Assimilation (Ultralisk)"
ULTRALISK_MONARCH_BLADES                          = "Monarch Blades (Ultralisk)"
ULTRALISK_ANABOLIC_SYNTHESIS                      = "Anabolic Synthesis (Ultralisk)"
ULTRALISK_CHITINOUS_PLATING                       = "Chitinous Plating (Ultralisk)"
ULTRALISK_ORGANIC_CARAPACE                        = "Organic Carapace (Ultralisk)"
ULTRALISK_RESOURCE_EFFICIENCY                     = "Resource Efficiency (Ultralisk)"
PYGALISK_STIM                                     = "Stimpack (Pygalisk)"
PYGALISK_DUCAL_BLADES                             = "Ducal Blades (Pygalisk)"
PYGALISK_COMBAT_CARAPACE                          = "Combat Carapace (Pygalisk)"
CORRUPTOR_CORRUPTION                              = "Corruption (Corruptor)"
CORRUPTOR_CAUSTIC_SPRAY                           = "Caustic Spray (Corruptor)"
SCOURGE_VIRULENT_SPORES                           = "Virulent Spores (Scourge)"
SCOURGE_RESOURCE_EFFICIENCY                       = "Resource Efficiency (Scourge)"
SCOURGE_SWARM_SCOURGE                             = "Swarm Scourge (Scourge)"
DEVOURER_CORROSIVE_SPRAY                          = "Corrosive Spray (Devourer)"
DEVOURER_GAPING_MAW                               = "Gaping Maw (Devourer)"
DEVOURER_IMPROVED_OSMOSIS                         = "Improved Osmosis (Devourer)"
DEVOURER_PRESCIENT_SPORES                         = "Prescient Spores (Devourer)"
GUARDIAN_PROLONGED_DISPERSION                     = "Prolonged Dispersion (Guardian)"
GUARDIAN_PRIMAL_ADAPTATION                        = "Primal Adaptation (Guardian)"
GUARDIAN_SORONAN_ACID                             = "Soronan Acid (Guardian)"
GUARDIAN_PROPELLANT_SACS                          = "Propellant Sacs (Guardian)"
GUARDIAN_EXPLOSIVE_SPORES                         = "Explosive Spores (Guardian)"
GUARDIAN_PRIMORDIAL_FURY                          = "Primordial Fury (Guardian)"
IMPALER_ADAPTIVE_TALONS                           = "Adaptive Talons (Impaler)"
IMPALER_SECRETION_GLANDS                          = "Secretion Glands (Impaler)"
IMPALER_SUNKEN_SPINES                             = "Sunken Spines (Impaler)"
LURKER_SEISMIC_SPINES                             = "Seismic Spines (Lurker)"
LURKER_ADAPTED_SPINES                             = "Adapted Spines (Lurker)"
RAVAGER_POTENT_BILE                               = "Potent Bile (Ravager)"
RAVAGER_BLOATED_BILE_DUCTS                        = "Bloated Bile Ducts (Ravager)"
RAVAGER_DEEP_TUNNEL                               = "Deep Tunnel (Ravager)"
VIPER_PARASITIC_BOMB                              = "Parasitic Bomb (Viper)"
VIPER_PARALYTIC_BARBS                             = "Paralytic Barbs (Viper)"
VIPER_VIRULENT_MICROBES                           = "Virulent Microbes (Viper)"
BROOD_LORD_POROUS_CARTILAGE                       = "Porous Cartilage (Brood Lord)"
BROOD_LORD_BEHEMOTH_STELLARSKIN                   = "Behemoth Stellarskin (Brood Lord)"
BROOD_LORD_SPLITTER_MITOSIS                       = "Splitter Mitosis (Brood Lord)"
BROOD_LORD_RESOURCE_EFFICIENCY                    = "Resource Efficiency (Brood Lord)"
INFESTOR_INFESTED_TERRAN                          = "Infested Terran (Infestor)"
INFESTOR_MICROBIAL_SHROUD                         = "Microbial Shroud (Infestor)"
SWARM_QUEEN_SPAWN_LARVAE                          = "Spawn Larvae (Swarm Queen)"
SWARM_QUEEN_DEEP_TUNNEL                           = "Deep Tunnel (Swarm Queen)"
SWARM_QUEEN_ORGANIC_CARAPACE                      = "Organic Carapace (Swarm Queen)"
SWARM_QUEEN_BIO_MECHANICAL_TRANSFUSION            = "Bio-Mechanical Transfusion (Swarm Queen)"
SWARM_QUEEN_RESOURCE_EFFICIENCY                   = "Resource Efficiency (Swarm Queen)"
SWARM_QUEEN_INCUBATOR_CHAMBER                     = "Incubator Chamber (Swarm Queen)"
BROOD_QUEEN_FUNGAL_GROWTH                         = "Fungal Growth (Brood Queen)"
BROOD_QUEEN_ENSNARE                               = "Ensnare (Brood Queen)"
BROOD_QUEEN_ENHANCED_MITOCHONDRIA                 = "Enhanced Mitochondria (Brood Queen)"
DEFILER_PATHOGEN_PROJECTORS                       = "Pathogen Projectors (Defiler)"
DEFILER_TRAPDOOR_ADAPTATION                       = "Trapdoor Adaptation (Defiler)"
DEFILER_PREDATORY_CONSUMPTION                     = "Predatory Consumption (Defiler)"
DEFILER_COMORBIDITY                               = "Comorbidity (Defiler)"
ABERRATION_MONSTROUS_RESILIENCE                   = "Monstrous Resilience (Aberration)"
ABERRATION_CONSTRUCT_REGENERATION                 = "Construct Regeneration (Aberration)"
ABERRATION_BANELING_INCUBATION                    = "Baneling Incubation (Aberration)"
ABERRATION_PROTECTIVE_COVER                       = "Protective Cover (Aberration)"
ABERRATION_RESOURCE_EFFICIENCY                    = "Resource Efficiency (Aberration)"
ABERRATION_PROGRESSIVE_BANELING_LAUNCH            = "Progressive Baneling Launch (Aberration)"
CORRUPTOR_MONSTROUS_RESILIENCE                    = "Monstrous Resilience (Corruptor)"
CORRUPTOR_CONSTRUCT_REGENERATION                  = "Construct Regeneration (Corruptor)"
CORRUPTOR_SCOURGE_INCUBATION                      = "Scourge Incubation (Corruptor)"
CORRUPTOR_RESOURCE_EFFICIENCY                     = "Resource Efficiency (Corruptor)"
PRIMAL_IGNITER_CONCENTRATED_FIRE                  = "Concentrated Fire (Primal Igniter)"
PRIMAL_IGNITER_PRIMAL_TENACITY                    = "Primal Tenacity (Primal Igniter)"
OVERLORD_IMPROVED_OVERLORDS                       = "Improved Overlords (Overlord)"
OVERLORD_VENTRAL_SACS                             = "Ventral Sacs (Overlord)"
OVERLORD_GENERATE_CREEP                           = "Generate Creep (Overlord)"
OVERLORD_PNEUMATIZED_CARAPACE                     = "Pneumatized Carapace (Overlord)"
OVERLORD_ANTENNAE                                 = "Antennae (Overlord)"
INFESTED_SCV_BUILD_CHARGES                        = "Sustained Cultivation Ventricles (Infested SCV)"
INFESTED_MARINE_PLAGUED_MUNITIONS                 = "Plagued Munitions (Infested Marine)"
INFESTED_MARINE_RETINAL_AUGMENTATION              = "Retinal Augmentation (Infested Marine)"
INFESTED_BUNKER_CALCIFIED_ARMOR                   = "Calcified Armor (Infested Bunker)"
INFESTED_BUNKER_REGENERATIVE_PLATING              = "Regenerative Plating (Infested Bunker)"
INFESTED_BUNKER_ENGORGED_BUNKERS                  = "Engorged Bunkers (Infested Bunker)"
TYRANNOZOR_BARRAGE_OF_SPIKES                      = "Barrage of Spikes (Tyrannozor)"
TYRANNOZOR_TYRANTS_PROTECTION                     = "Tyrant's Protection (Tyrannozor)"
TYRANNOZOR_HEALING_ADAPTATION                     = "Healing Adaptation (Tyrannozor)"
TYRANNOZOR_IMPALING_STRIKE                        = "Impaling Strike (Tyrannozor)"
BILE_LAUNCHER_ARTILLERY_DUCTS                     = "Artillery Ducts (Bile Launcher)"
BILE_LAUNCHER_RAPID_BOMBARMENT                    = "Rapid Bombardment (Bile Launcher)"
NYDUS_WORM_ECHIDNA_WORM_SUBTERRANEAN_SCALES       = "Subterranean Scales (Nydus Worm/Echidna Worm)"
NYDUS_WORM_ECHIDNA_WORM_JORMUNGANDR_STRAIN        = "Jormungandr Strain (Nydus Worm/Echidna Worm)"
NYDUS_WORM_ECHIDNA_WORM_RESOURCE_EFFICIENCY       = "Resource Efficiency (Nydus Worm/Echidna Worm)"
NYDUS_WORM_RAVENOUS_APPETITE                      = "Ravenous Appetite (Nydus Worm)"
ECHIDNA_WORM_OUROBOROS_STRAIN                     = "Ouroboros Strain (Echidna Worm)"
INFESTED_SIEGE_TANK_PROGRESSIVE_AUTOMATED_MITOSIS = "Progressive Automated Mitosis (Infested Siege Tank)"
INFESTED_SIEGE_TANK_ACIDIC_ENZYMES                = "Acidic Enzymes (Infested Siege Tank)"
INFESTED_SIEGE_TANK_DEEP_TUNNEL                   = "Deep Tunnel (Infested Siege Tank)"
INFESTED_SIEGE_TANK_SEISMIC_SONAR                 = "Seismic Sonar (Infested Siege Tank)"
INFESTED_SIEGE_TANK_BALANCED_ROOTS                = "Balanced Roots (Infested Siege Tank)"
INFESTED_DIAMONDBACK_CAUSTIC_MUCUS                = "Caustic Mucus (Infested Diamondback)"
INFESTED_DIAMONDBACK_VIOLENT_ENZYMES              = "Violent Enzymes (Infested Diamondback)"
INFESTED_DIAMONDBACK_CONCENTRATED_SPEW            = "Concentrated Spew (Infested Diamondback)"
INFESTED_DIAMONDBACK_PROGRESSIVE_FUNGAL_SNARE     = "Progressive Fungal Snare (Infested Diamondback)"
INFESTED_BANSHEE_BRACED_EXOSKELETON               = "Braced Exoskeleton (Infested Banshee)"
INFESTED_BANSHEE_RAPID_HIBERNATION                = "Rapid Hibernation (Infested Banshee)"
INFESTED_BANSHEE_FLESHFUSED_TARGETING_OPTICS      = "Fleshfused Targeting Optics (Infested Banshee)"
INFESTED_LIBERATOR_CLOUD_DISPERSAL                = "Cloud Dispersal (Infested Liberator)"
INFESTED_LIBERATOR_VIRAL_CONTAMINATION            = "Viral Contamination (Infested Liberator)"
INFESTED_LIBERATOR_DEFENDER_MODE                  = "Defender Mode (Infested Liberator)"
INFESTED_SIEGE_TANK_FRIGHTFUL_FLESHWELDER         = "Frightful Fleshwelder (Infested Siege Tank)"
INFESTED_DIAMONDBACK_FRIGHTFUL_FLESHWELDER        = "Frightful Fleshwelder (Infested Diamondback)"
INFESTED_BANSHEE_FRIGHTFUL_FLESHWELDER            = "Frightful Fleshwelder (Infested Banshee)"
INFESTED_LIBERATOR_FRIGHTFUL_FLESHWELDER          = "Frightful Fleshwelder (Infested Liberator)"
INFESTED_MISSILE_TURRET_BIOELECTRIC_PAYLOAD       = "Bioelectric Payload (Infested Missile Turret)"
INFESTED_MISSILE_TURRET_ACID_SPORE_VENTS          = "Acid Spore Vents (Infested Missile Turret)"
BULLFROG_WILD_MUTATION                            = "Mutagen Vents (Bullfrog)"
BULLFROG_BROODLINGS                               = "Suffused With Vermin (Bullfrog)"
BULLFROG_HARD_IMPACT                              = "Lethal Impact (Bullfrog)"
BULLFROG_RANGE                                    = "Catalytic Boosters (Bullfrog)"

# Zerg Strains
ZERGLING_RAPTOR_STRAIN     = "Raptor Strain (Zergling)"
ZERGLING_SWARMLING_STRAIN  = "Swarmling Strain (Zergling)"
ROACH_VILE_STRAIN          = "Vile Strain (Roach)"
ROACH_CORPSER_STRAIN       = "Corpser Strain (Roach)"
BANELING_SPLITTER_STRAIN   = "Splitter Strain (Baneling)"
BANELING_HUNTER_STRAIN     = "Hunter Strain (Baneling)"
SWARM_HOST_CARRION_STRAIN  = "Carrion Strain (Swarm Host)"
SWARM_HOST_CREEPER_STRAIN  = "Creeper Strain (Swarm Host)"
ULTRALISK_NOXIOUS_STRAIN   = "Noxious Strain (Ultralisk)"
ULTRALISK_TORRASQUE_STRAIN = "Torrasque Strain (Ultralisk)"

# Morphs
ZERGLING_BANELING_ASPECT                = "Baneling"
HYDRALISK_IMPALER_ASPECT                = "Impaler"
HYDRALISK_LURKER_ASPECT                 = "Lurker"
MUTALISK_CORRUPTOR_BROOD_LORD_ASPECT    = "Brood Lord"
MUTALISK_CORRUPTOR_VIPER_ASPECT         = "Viper"
MUTALISK_CORRUPTOR_GUARDIAN_ASPECT      = "Guardian"
MUTALISK_CORRUPTOR_DEVOURER_ASPECT      = "Devourer"
ROACH_RAVAGER_ASPECT                    = "Ravager"
OVERLORD_OVERSEER_ASPECT                = "Overseer"
ROACH_PRIMAL_IGNITER_ASPECT             = "Primal Igniter"
ULTRALISK_TYRANNOZOR_ASPECT             = "Tyrannozor"

# Zerg Mercs
INFESTED_MEDICS         = "Infested Medics"
INFESTED_SIEGE_BREAKERS = "Infested Siege Breakers"
INFESTED_DUSK_WINGS     = "Infested Dusk Wings"
DEVOURING_ONES          = "Devouring Ones"
HUNTER_KILLERS          = "Hunter Killers"
TORRASQUE_MERC          = "Wise Old Torrasque"
HUNTERLING              = "Hunterling"
YGGDRASIL               = "Yggdrasil"
CAUSTIC_HORRORS         = "Caustic Horrors"

    
# Kerrigan Upgrades
KERRIGAN_KINETIC_BLAST           = "Kinetic Blast (Kerrigan Ability)"
KERRIGAN_HEROIC_FORTITUDE        = "Heroic Fortitude (Kerrigan Passive)"
KERRIGAN_LEAPING_STRIKE          = "Leaping Strike (Kerrigan Ability)"
KERRIGAN_CRUSHING_GRIP           = "Crushing Grip (Kerrigan Ability)"
KERRIGAN_CHAIN_REACTION          = "Chain Reaction (Kerrigan Passive)"
KERRIGAN_PSIONIC_SHIFT           = "Psionic Shift (Kerrigan Ability)"
KERRIGAN_WILD_MUTATION           = "Wild Mutation (Kerrigan Ability)"
KERRIGAN_SPAWN_BANELINGS         = "Spawn Banelings (Kerrigan Ability)"
KERRIGAN_MEND                    = "Mend (Kerrigan Ability)"
KERRIGAN_INFEST_BROODLINGS       = "Infest Broodlings (Kerrigan Passive)"
KERRIGAN_FURY                    = "Fury (Kerrigan Passive)"
KERRIGAN_ABILITY_EFFICIENCY      = "Ability Efficiency (Kerrigan Passive)"
KERRIGAN_APOCALYPSE              = "Apocalypse (Kerrigan Ability)"
KERRIGAN_SPAWN_LEVIATHAN         = "Spawn Leviathan (Kerrigan Ability)"
KERRIGAN_DROP_PODS               = "Drop-Pods (Kerrigan Ability)"
KERRIGAN_ASSIMILATION_AURA       = "Assimilation Aura (Kerrigan Ability)"
KERRIGAN_IMMOBILIZATION_WAVE     = "Immobilization Wave (Kerrigan Ability)"
KERRIGAN_PRIMAL_FORM             = "Primal Form (Kerrigan)"

# Misc Upgrades
ZERGLING_RECONSTITUTION          = "Zergling Reconstitution (Zerg)"
AUTOMATED_EXTRACTORS             = "Automated Extractors (Zerg)"
TWIN_DRONES                      = "Twin Drones (Zerg)"
MALIGNANT_CREEP                  = "Malignant Creep (Zerg)"
VESPENE_EFFICIENCY               = "Vespene Efficiency (Zerg)"
ZERG_CREEP_STOMACH               = "Creep Stomach (Zerg)"
ZERG_EXCAVATING_CLAWS            = "Excavating Claws (Zerg)"
HIVE_CLUSTER_MATURATION          = "Hive Cluster Maturation (Zerg)"
MACROSCOPIC_RECUPERATION         = "Macroscopic Recuperation (Zerg)"
BIOMECHANICAL_STOCKPILING        = "Bio-Mechanical Stockpiling (Zerg)"
BROODLING_SPORE_SATURATION       = "Broodling Spore Saturation (Zerg)"
UNRESTRICTED_MUTATION            = "Unrestricted Mutation (Zerg)"
CELL_DIVISION                    = "Cell Division (Zerg)"
EVOLUTIONARY_LEAP                = "Evolutionary Leap (Zerg)"
SELF_SUFFICIENT                  = "Self-Sufficient (Zerg)"

# Kerrigan Levels
KERRIGAN_LEVELS_1  = "1 Kerrigan Level"
KERRIGAN_LEVELS_2  = "2 Kerrigan Levels"
KERRIGAN_LEVELS_3  = "3 Kerrigan Levels"
KERRIGAN_LEVELS_4  = "4 Kerrigan Levels"
KERRIGAN_LEVELS_5  = "5 Kerrigan Levels"
KERRIGAN_LEVELS_6  = "6 Kerrigan Levels"
KERRIGAN_LEVELS_7  = "7 Kerrigan Levels"
KERRIGAN_LEVELS_8  = "8 Kerrigan Levels"
KERRIGAN_LEVELS_9  = "9 Kerrigan Levels"
KERRIGAN_LEVELS_10 = "10 Kerrigan Levels"
KERRIGAN_LEVELS_14 = "14 Kerrigan Levels"
KERRIGAN_LEVELS_35 = "35 Kerrigan Levels"
KERRIGAN_LEVELS_70 = "70 Kerrigan Levels"

# Protoss Units
ZEALOT       = "Zealot"
STALKER      = "Stalker"
HIGH_TEMPLAR = "High Templar"
DARK_TEMPLAR = "Dark Templar"
IMMORTAL     = "Immortal"
COLOSSUS     = "Colossus"
PHOENIX      = "Phoenix"
VOID_RAY     = "Void Ray"
CARRIER      = "Carrier"
SKYLORD      = "Skylord"
TRIREME      = "Trireme"
OBSERVER     = "Observer"
CENTURION    = "Centurion"
SENTINEL     = "Sentinel"
SUPPLICANT   = "Supplicant"
INSTIGATOR   = "Instigator"
SLAYER       = "Slayer"
SENTRY       = "Sentry"
ENERGIZER    = "Energizer"
HAVOC        = "Havoc"
SIGNIFIER    = "Signifier"
ASCENDANT    = "Ascendant"
AVENGER      = "Avenger"
BLOOD_HUNTER = "Blood Hunter"
DRAGOON      = "Dragoon"
DARK_ARCHON  = "Dark Archon"
ADEPT        = "Adept"
WARP_PRISM   = "Warp Prism"
ANNIHILATOR  = "Annihilator"
VANGUARD     = "Vanguard"
STALWART     = "Stalwart"
WRATHWALKER  = "Wrathwalker"
REAVER       = "Reaver"
DISRUPTOR    = "Disruptor"
MIRAGE       = "Mirage"
SKIRMISHER   = "Skirmisher"
CORSAIR      = "Corsair"
DESTROYER    = "Destroyer"
PULSAR       = "Pulsar"
DAWNBRINGER  = "Dawnbringer"
SCOUT        = "Scout"
OPPRESSOR    = "Oppressor"
CALADRIUS    = "Caladrius"
MISTWING     = "Mist Wing"
TEMPEST      = "Tempest"
MOTHERSHIP   = "Mothership"
ARBITER      = "Arbiter"
ORACLE       = "Oracle"

# Upgrades
PROTOSS_UPGRADE_PREFIX                   = "Progressive Protoss"
PROTOSS_GROUND_UPGRADE_PREFIX            = f"{PROTOSS_UPGRADE_PREFIX} Ground"
PROTOSS_AIR_UPGRADE_PREFIX               = f"{PROTOSS_UPGRADE_PREFIX} Air"
PROGRESSIVE_PROTOSS_GROUND_WEAPON        = f"{PROTOSS_GROUND_UPGRADE_PREFIX} Weapon"
PROGRESSIVE_PROTOSS_GROUND_ARMOR         = f"{PROTOSS_GROUND_UPGRADE_PREFIX} Armor"
PROGRESSIVE_PROTOSS_SHIELDS              = f"{PROTOSS_UPGRADE_PREFIX} Shields"
PROGRESSIVE_PROTOSS_AIR_WEAPON           = f"{PROTOSS_AIR_UPGRADE_PREFIX} Weapon"
PROGRESSIVE_PROTOSS_AIR_ARMOR            = f"{PROTOSS_AIR_UPGRADE_PREFIX} Armor"
PROGRESSIVE_PROTOSS_WEAPON_UPGRADE       = f"{PROTOSS_UPGRADE_PREFIX} Weapon Upgrade"
PROGRESSIVE_PROTOSS_ARMOR_UPGRADE        = f"{PROTOSS_UPGRADE_PREFIX} Armor Upgrade"
PROGRESSIVE_PROTOSS_GROUND_UPGRADE       = f"{PROTOSS_GROUND_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_PROTOSS_AIR_UPGRADE          = f"{PROTOSS_AIR_UPGRADE_PREFIX} Upgrade"
PROGRESSIVE_PROTOSS_WEAPON_ARMOR_UPGRADE = f"{PROTOSS_UPGRADE_PREFIX} Weapon/Armor Upgrade"

# Buildings
PHOTON_CANNON       = "Photon Cannon"
KHAYDARIN_MONOLITH  = "Khaydarin Monolith"
SHIELD_BATTERY      = "Shield Battery"

# Unit Upgrades
SUPPLICANT_BLOOD_SHIELD                                 = "Blood Shield (Supplicant)"
SUPPLICANT_SOUL_AUGMENTATION                            = "Soul Augmentation (Supplicant)"
SUPPLICANT_ENDLESS_SERVITUDE                            = "Endless Servitude (Supplicant)"
SUPPLICANT_ZENITH_PITCH                                 = "Zenith Pitch (Supplicant)"
SUPPLICANT_SACRIFICE                                    = "Sacrifice (Supplicant)"
ADEPT_SHOCKWAVE                                         = "Shockwave (Adept)"
ADEPT_RESONATING_GLAIVES                                = "Resonating Glaives (Adept)"
ADEPT_PHASE_BULWARK                                     = "Phase Bulwark (Adept)"
STALKER_INSTIGATOR_SLAYER_DISINTEGRATING_PARTICLES      = "Disintegrating Particles (Stalker/Instigator/Slayer)"
STALKER_INSTIGATOR_SLAYER_PARTICLE_REFLECTION           = "Particle Reflection (Stalker/Instigator/Slayer)"
INSTIGATOR_BLINK_OVERDRIVE                              = "Blink Overdrive (Instigator)"
INSTIGATOR_RECONSTRUCTION                               = "Reconstruction (Instigator)"
DRAGOON_CONCENTRATED_ANTIMATTER                         = "Concentrated Antimatter (Dragoon)"
DRAGOON_TRILLIC_COMPRESSION_SYSTEM                      = "Trillic Compression System (Dragoon)"
DRAGOON_SINGULARITY_CHARGE                              = "Singularity Charge (Dragoon)"
DRAGOON_ENHANCED_STRIDER_SERVOS                         = "Enhanced Strider Servos (Dragoon)"
SCOUT_COMBAT_SENSOR_ARRAY                               = "Combat Sensor Array (Scout/Oppressor/Caladrius/Mist Wing)"
SCOUT_APIAL_SENSORS                                     = "Apial Sensors (Scout)"
SCOUT_GRAVITIC_THRUSTERS                                = "Gravitic Thrusters (Scout/Oppressor/Caladrius/Mist Wing)"
SCOUT_ADVANCED_PHOTON_BLASTERS                          = "Advanced Photon Blasters (Scout/Oppressor/Mist Wing)"
SCOUT_RESOURCE_EFFICIENCY                               = "Resource Efficiency (Scout)"
SCOUT_SUPPLY_EFFICIENCY                                 = "Supply Efficiency (Scout)"
TEMPEST_TECTONIC_DESTABILIZERS                          = "Tectonic Destabilizers (Tempest)"
TEMPEST_QUANTIC_REACTOR                                 = "Quantic Reactor (Tempest)"
TEMPEST_GRAVITY_SLING                                   = "Gravity Sling (Tempest)"
TEMPEST_INTERPLANETARY_RANGE                            = "Interplanetary Range (Tempest)"
PHOENIX_CLASS_IONIC_WAVELENGTH_FLUX                     = "Ionic Wavelength Flux (Phoenix/Mirage/Skirmisher)"
PHOENIX_CLASS_ANION_PULSE_CRYSTALS                      = "Anion Pulse-Crystals (Phoenix/Mirage/Skirmisher)"
CORSAIR_STEALTH_DRIVE                                   = "Stealth Drive (Corsair)"
CORSAIR_ARGUS_JEWEL                                     = "Argus Jewel (Corsair)"
CORSAIR_SUSTAINING_DISRUPTION                           = "Sustaining Disruption (Corsair)"
CORSAIR_NEUTRON_SHIELDS                                 = "Neutron Shields (Corsair)"
ORACLE_STEALTH_DRIVE                                    = "Stealth Drive (Oracle)"
ORACLE_SKYWARD_CHRONOANOMALY                            = "Skyward Chronoanomaly (Oracle)"
ORACLE_TEMPORAL_ACCELERATION_BEAM                       = "Temporal Acceleration Beam (Oracle)"
ORACLE_BOSONIC_CORE                                     = "Bosonic Core (Oracle)"
ARBITER_CHRONOSTATIC_REINFORCEMENT                      = "Chronostatic Reinforcement (Arbiter)"
ARBITER_KHAYDARIN_CORE                                  = "Khaydarin Core (Arbiter)"
ARBITER_SPACETIME_ANCHOR                                = "Spacetime Anchor (Arbiter)"
ARBITER_RESOURCE_EFFICIENCY                             = "Resource Efficiency (Arbiter)"
ARBITER_JUDICATORS_VEIL                                 = "Judicator's Veil (Arbiter)"
CARRIER_TRIREME_GRAVITON_CATAPULT                       = "Graviton Catapult (Carrier/Trireme)"
CARRIER_SKYLORD_TRIREME_HULL_OF_PAST_GLORIES            = "Hull of Past Glories (Carrier/Skylord/Trireme)"
VOID_RAY_DESTROYER_PULSAR_DAWNBRINGER_FLUX_VANES        = "Flux Vanes (Void Ray/Destroyer/Pulsar/Dawnbringer)"
DAWNBRINGER_ANTI_SURFACE_COUNTERMEASURES                = "Anti-Surface Countermeasures (Dawnbringer)"
DAWNBRINGER_ENHANCED_SHIELD_GENERATOR                   = "Enhanced Shield Generator (Dawnbringer)"
PULSAR_CHRONOCLYSM                                      = "Chronoclysm (Pulsar)"
PULSAR_ENTROPIC_REVERSAL                                = "Entropic Reversal (Pulsar)"
DESTROYER_RESOURCE_EFFICIENCY                           = "Resource Efficiency (Destroyer)"
WARP_PRISM_GRAVITIC_DRIVE                               = "Gravitic Drive (Warp Prism)"
WARP_PRISM_PHASE_BLASTER                                = "Phase Blaster (Warp Prism)"
WARP_PRISM_WAR_CONFIGURATION                            = "War Configuration (Warp Prism)"
OBSERVER_GRAVITIC_BOOSTERS                              = "Gravitic Boosters (Observer)"
OBSERVER_SENSOR_ARRAY                                   = "Sensor Array (Observer)"
REAVER_SCARAB_DAMAGE                                    = "Scarab Damage (Reaver)"
REAVER_SOLARITE_PAYLOAD                                 = "Solarite Payload (Reaver)"
REAVER_REAVER_CAPACITY                                  = "Reaver Capacity (Reaver)"
REAVER_RESOURCE_EFFICIENCY                              = "Resource Efficiency (Reaver)"
REAVER_BARGAIN_BIN_PRICES                               = "Bargain Bin Prices (Reaver)"
VANGUARD_AGONY_LAUNCHERS                                = "Agony Launchers (Vanguard)"
VANGUARD_MATTER_DISPERSION                              = "Matter Dispersion (Vanguard)"
IMMORTAL_ANNIHILATOR_SINGULARITY_CHARGE                 = "Singularity Charge (Immortal/Annihilator)"
IMMORTAL_ANNIHILATOR_ADVANCED_TARGETING                 = "Advanced Targeting (Immortal/Annihilator)"
IMMORTAL_ANNIHILATOR_DISRUPTOR_DISPERSION               = "Disruptor Dispersion (Immortal/Annihilator)"
STALWART_HIGH_VOLTAGE_CAPACITORS                        = "High Voltage Capacitors (Stalwart)"
STALWART_REINTEGRATED_FRAMEWORK                         = "Reintegrated Framework (Stalwart)"
STALWART_STABILIZED_ELECTRODES                          = "Stabilized Electrodes (Stalwart)"
STALWART_LATTICED_SHIELDING                             = "Latticed Shielding (Stalwart)"
DISRUPTOR_CLOAKING_MODULE                               = "Cloaking Module (Disruptor)"
DISRUPTOR_PERFECTED_POWER                               = "Perfected Power (Disruptor)"
DISRUPTOR_RESTRAINED_DESTRUCTION                        = "Restrained Destruction (Disruptor)"
COLOSSUS_PACIFICATION_PROTOCOL                          = "Pacification Protocol (Colossus)"
WRATHWALKER_RAPID_POWER_CYCLING                         = "Rapid Power Cycling (Wrathwalker)"
WRATHWALKER_EYE_OF_WRATH                                = "Eye of Wrath (Wrathwalker)"
DARK_TEMPLAR_AVENGER_BLOOD_HUNTER_SHROUD_OF_ADUN        = "Shroud of Adun (Dark Templar/Avenger/Blood Hunter)"
DARK_TEMPLAR_AVENGER_BLOOD_HUNTER_SHADOW_GUARD_TRAINING = "Shadow Guard Training (Dark Templar/Avenger/Blood Hunter)"
DARK_TEMPLAR_AVENGER_BLOOD_HUNTER_BLINK                 = "Blink (Dark Templar/Avenger/Blood Hunter)"
DARK_TEMPLAR_AVENGER_BLOOD_HUNTER_RESOURCE_EFFICIENCY   = "Resource Efficiency (Dark Templar/Avenger/Blood Hunter)"
DARK_TEMPLAR_DARK_ARCHON_MELD                           = "Dark Archon Meld (Dark Templar)"
DARK_TEMPLAR_ARCHON_MERGE                               = "Archon Merge (Dark Templar)"
HIGH_TEMPLAR_SIGNIFIER_UNSHACKLED_PSIONIC_STORM         = "Unshackled Psionic Storm (High Templar/Signifier)"
HIGH_TEMPLAR_SIGNIFIER_HALLUCINATION                    = "Hallucination (High Templar/Signifier)"
HIGH_TEMPLAR_SIGNIFIER_KHAYDARIN_AMULET                 = "Khaydarin Amulet (High Templar/Signifier)"
ARCHON_HIGH_ARCHON                                      = "High Archon (Archon)"
ARCHON_TRANSCENDENCE                                    = "Transcendence (Archon)"
ARCHON_POWER_SIPHON                                     = "Power Siphon (Archon)"
ARCHON_ERADICATE                                        = "Eradicate (Archon)"
ARCHON_OBLITERATE                                       = "Obliterate (Archon)"
DARK_ARCHON_FEEDBACK                                    = "Feedback (Dark Archon)"
DARK_ARCHON_MAELSTROM                                   = "Maelstrom (Dark Archon)"
DARK_ARCHON_ARGUS_TALISMAN                              = "Argus Talisman (Dark Archon)"
ASCENDANT_POWER_OVERWHELMING                            = "Power Overwhelming (Ascendant)"
ASCENDANT_CHAOTIC_ATTUNEMENT                            = "Chaotic Attunement (Ascendant)"
ASCENDANT_BLOOD_AMULET                                  = "Blood Amulet (Ascendant)"
ASCENDANT_ARCHON_MERGE                                  = "Archon Merge (Ascendant)"
SENTRY_ENERGIZER_HAVOC_CLOAKING_MODULE                  = "Cloaking Module (Sentry/Energizer/Havoc)"
SENTRY_ENERGIZER_HAVOC_SHIELD_BATTERY_RAPID_RECHARGING  = "Rapid Recharging (Sentry/Energizer/Havoc/Shield Battery)"
SENTRY_FORCE_FIELD                                      = "Force Field (Sentry)"
SENTRY_HALLUCINATION                                    = "Hallucination (Sentry)"
ENERGIZER_RECLAMATION                                   = "Reclamation (Energizer)"
ENERGIZER_FORGED_CHASSIS                                = "Forged Chassis (Energizer)"
HAVOC_DETECT_WEAKNESS                                   = "Detect Weakness (Havoc)"
HAVOC_BLOODSHARD_RESONANCE                              = "Bloodshard Resonance (Havoc)"
ZEALOT_SENTINEL_CENTURION_LEG_ENHANCEMENTS              = "Leg Enhancements (Zealot/Sentinel/Centurion)"
ZEALOT_SENTINEL_CENTURION_SHIELD_CAPACITY               = "Shield Capacity (Zealot/Sentinel/Centurion)"
OPPRESSOR_ACCELERATED_WARP                              = "Accelerated Warp (Oppressor)"
OPPRESSOR_ARMOR_MELTING_BLASTERS                        = "Armor Melting Blasters (Oppressor)"
CALADRIUS_SIDE_MISSILES                                 = "Side Missiles (Caladrius)"
CALADRIUS_STRUCTURE_TARGETING                           = "Structure Targeting (Caladrius)"
CALADRIUS_SOLARITE_REACTOR                              = "Solarite Reactor (Caladrius)"
MISTWING_NULL_SHROUD                                    = "Null Shroud (Mist Wing)"
MISTWING_PILOT                                          = "Pilot (Mist Wing)"

# War Council
ZEALOT_WHIRLWIND                                        = "Whirlwind (Zealot)"
CENTURION_RESOURCE_EFFICIENCY                           = "Resource Efficiency (Centurion)"
SENTINEL_RESOURCE_EFFICIENCY                            = "Resource Efficiency (Sentinel)"
STALKER_PHASE_REACTOR                                   = "Phase Reactor (Stalker)"
DRAGOON_PHALANX_SUIT                                    = "Phalanx Suit (Dragoon)"
INSTIGATOR_MODERNIZED_SERVOS                            = "Modernized Servos (Instigator)"
ADEPT_DISRUPTIVE_TRANSFER                               = "Disruptive Transfer (Adept)"
SLAYER_PHASE_BLINK                                      = "Phase Blink (Slayer)"
AVENGER_KRYHAS_CLOAK                                    = "Kryhas Cloak (Avenger)"
DARK_TEMPLAR_LESSER_SHADOW_FURY                         = "Lesser Shadow Fury (Dark Templar)"
DARK_TEMPLAR_GREATER_SHADOW_FURY                        = "Greater Shadow Fury (Dark Templar)"
BLOOD_HUNTER_BRUTAL_EFFICIENCY                          = "Brutal Efficiency (Blood Hunter)"
SENTRY_DOUBLE_SHIELD_RECHARGE                           = "Double Shield Recharge (Sentry)"
ENERGIZER_MOBILE_CHRONO_BEAM                            = "Mobile Chrono Beam (Energizer)"
HAVOC_ENDURING_SIGHT                                    = "Enduring Sight (Havoc)"
HIGH_TEMPLAR_PLASMA_SURGE                               = "Plasma Surge (High Templar)"
SIGNIFIER_FEEDBACK                                      = "Feedback (Signifier)"
ASCENDANT_BREATH_OF_CREATION                            = "Breath of Creation (Ascendant)"
DARK_ARCHON_INDOMITABLE_WILL                            = "Indomitable Will (Dark Archon)"
IMMORTAL_IMPROVED_BARRIER                               = "Improved Barrier (Immortal)"
VANGUARD_RAPIDFIRE_CANNON                               = "Rapid-Fire Cannon (Vanguard)"
VANGUARD_FUSION_MORTARS                                 = "Fusion Mortars (Vanguard)"
ANNIHILATOR_TWILIGHT_CHASSIS                            = "Twilight Chassis (Annihilator)"
STALWART_ARC_INDUCERS                                   = "Arc Inducers (Stalwart)"
COLOSSUS_FIRE_LANCE                                     = "Fire Lance (Colossus)"
WRATHWALKER_AERIAL_TRACKING                             = "Aerial Tracking (Wrathwalker)"
REAVER_KHALAI_REPLICATORS                               = "Khalai Replicators (Reaver)"
DISRUPTOR_MOBILITY_PROTOCOLS                            = "Mobility Protocols (Disruptor)"
WARP_PRISM_WARP_REFRACTION                              = "Warp Refraction (Warp Prism)"
OBSERVER_INDUCE_SCOPOPHOBIA                             = "Induce Scopophobia (Observer)"
PHOENIX_DOUBLE_GRAVITON_BEAM                            = "Double Graviton Beam (Phoenix)"
CORSAIR_NETWORK_DISRUPTION                              = "Network Disruption (Corsair)"
MIRAGE_GRAVITON_BEAM                                    = "Graviton Beam (Mirage)"
SKIRMISHER_PEER_CONTEMPT                                = "Peer Contempt (Skirmisher)"
VOID_RAY_PRISMATIC_RANGE                                = "Prismatic Range (Void Ray)"
DESTROYER_REFORGED_BLOODSHARD_CORE                      = "Reforged Bloodshard Core (Destroyer)"
PULSAR_CHRONO_SHEAR                                     = "Chrono Shear (Pulsar)"
DAWNBRINGER_SOLARITE_LENS                               = "Solarite Lens (Dawnbringer)"
CARRIER_REPAIR_DRONES                                   = "Repair Drones (Carrier)"
SKYLORD_JUMP                                            = "Jump (Skylord)"
TRIREME_SOLAR_BEAM                                      = "Solar Beam (Trireme)"
TEMPEST_DISINTEGRATION                                  = "Disintegration (Tempest)"
SCOUT_EXPEDITIONARY_HULL                                = "Expeditionary Hull (Scout)"
ARBITER_VESSEL_OF_THE_CONCLAVE                          = "Vessel of the Conclave (Arbiter)"
ORACLE_STASIS_CALIBRATION                               = "Stasis Calibration (Oracle)"
MOTHERSHIP_INTEGRATED_POWER                             = "Integrated Power (Mothership)"
OPPRESSOR_VULCAN_BLASTER                                = "Vulcan Blaster (Oppressor)"
CALADRIUS_CORONA_BEAM                                   = "Corona Beam (Caladrius)"
MISTWING_PHANTOM_DASH                                   = "Phantom Dash (Mist Wing)"

# Spear Of Adun
SOA_CHRONO_SURGE            = "Chrono Surge (Spear of Adun)"
SOA_PROGRESSIVE_PROXY_PYLON = "Progressive Proxy Pylon (Spear of Adun)"
SOA_PYLON_OVERCHARGE        = "Pylon Overcharge (Spear of Adun)"
SOA_ORBITAL_STRIKE          = "Orbital Strike (Spear of Adun)"
SOA_TEMPORAL_FIELD          = "Temporal Field (Spear of Adun)"
SOA_SOLAR_LANCE             = "Solar Lance (Spear of Adun)"
SOA_MASS_RECALL             = "Mass Recall (Spear of Adun)"
SOA_SHIELD_OVERCHARGE       = "Shield Overcharge (Spear of Adun)"
SOA_DEPLOY_FENIX            = "Deploy Fenix (Spear of Adun)"
SOA_PURIFIER_BEAM           = "Purifier Beam (Spear of Adun)"
SOA_TIME_STOP               = "Time Stop (Spear of Adun)"
SOA_SOLAR_BOMBARDMENT       = "Solar Bombardment (Spear of Adun)"

# Generic upgrades
MATRIX_OVERLOAD             = "Matrix Overload (Protoss)"
QUATRO                      = "Quatro (Protoss)"
NEXUS_OVERCHARGE            = "Nexus Overcharge (Protoss)"
ORBITAL_ASSIMILATORS        = "Orbital Assimilators (Protoss)"
WARP_HARMONIZATION          = "Warp Harmonization (Protoss)"
GUARDIAN_SHELL              = "Guardian Shell (Spear of Adun)"
RECONSTRUCTION_BEAM         = "Reconstruction Beam (Spear of Adun)"
OVERWATCH                   = "Overwatch (Spear of Adun)"
SUPERIOR_WARP_GATES         = "Superior Warp Gates (Protoss)"
ENHANCED_TARGETING          = "Enhanced Targeting (Protoss)"
OPTIMIZED_ORDNANCE          = "Optimized Ordnance (Protoss)"
KHALAI_INGENUITY            = "Khalai Ingenuity (Protoss)"
AMPLIFIED_ASSIMILATORS      = "Amplified Assimilators (Protoss)"
PROGRESSIVE_WARP_RELOCATE   = "Progressive Warp Relocate (Protoss)"
PROBE_WARPIN                = "Probe Warp-In (Protoss)"
ELDER_PROBES                = "Elder Probes (Protoss)"

# Filler items
STARTING_MINERALS           = "Additional Starting Minerals"
STARTING_VESPENE            = "Additional Starting Vespene"
STARTING_SUPPLY             = "Additional Starting Supply"
MAX_SUPPLY                  = "Additional Maximum Supply"
SHIELD_REGENERATION         = "Increased Shield Regeneration"
BUILDING_CONSTRUCTION_SPEED = "Increased Building Construction Speed"
UPGRADE_RESEARCH_SPEED      = "Increased Upgrade Research Speed"
UPGRADE_RESEARCH_COST       = "Reduced Upgrade Research Cost"

# Trap
REDUCED_MAX_SUPPLY          = "Decreased Maximum Supply"
NOTHING                     = "Nothing"

# Deprecated
PROGRESSIVE_ORBITAL_COMMAND         = "Progressive Orbital Command (Deprecated)"

# Keys
_TEMPLATE_MISSION_KEY               = "{} Mission Key"
_TEMPLATE_NAMED_LAYOUT_KEY          = "{} ({}) Questline Key"
_TEMPLATE_NUMBERED_LAYOUT_KEY       = "Questline Key #{}"
_TEMPLATE_NAMED_CAMPAIGN_KEY        = "{} Campaign Key"
_TEMPLATE_NUMBERED_CAMPAIGN_KEY     = "Campaign Key #{}"
_TEMPLATE_FLAVOR_KEY                = "{} Key"
PROGRESSIVE_MISSION_KEY             = "Progressive Mission Key"
PROGRESSIVE_QUESTLINE_KEY           = "Progressive Questline Key"
_TEMPLATE_PROGRESSIVE_KEY           = "Progressive Key #{}"

# Names for flavor keys, feel free to add more, but add them to the Custom Mission Order docs too
# These will never be randomly created by the generator
_flavor_key_names = [
    "Terran", "Zerg", "Protoss",
    "Raynor", "Tychus", "Swann", "Stetmann", "Hanson", "Nova", "Tosh", "Valerian", "Warfield", "Mengsk", "Han", "Horner",
    "Kerrigan", "Zagara", "Abathur", "Yagdra", "Kraith", "Slivan", "Zurvan", "Brakk", "Stukov", "Dehaka", "Niadra", "Izsha",
    "Artanis", "Zeratul", "Tassadar", "Karax", "Vorazun", "Alarak", "Fenix", "Urun", "Mohandar", "Selendis", "Rohana",
    "Reigel", "Davis", "Ji'nara"
]
