sprite_name_to_id = {
    "Ant": 93, "Ragumo/Aqua Kuribo": 32, "Battle Beetle": 51, "Be": 52, "Noko Bombette/Bear": 68,
    "Runaway Heart Block/Bibi": 53, "Star (Vertical)/Blurp (Horizontal)": 94,
    "Star (Horizontal)/Blurp (Vertical)": 95, "Boo/Bomubomu": 77,
    "Money Bag/Bopping Toady": 31, "Neiji/Buichi": 64, "Masked Ghoul/Bullet Bill": 83,
    "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)": 61, "Cheep Cheep (Vertical)": 7,
    "Chikunto": 39, "Dokanto": 37, "Dondon": 57, "Honebon/F Boy": 85, "Fire Pakkun Zo (Large)": 104,
    "Fire Pakkun Zo (Left)": 105, "Fire Pakkun Zo (Right)": 106, "Fire Piranha Plant": 13, "Floating Face": 100,
    "Genkottsu (1.5 Tiles)": 99, "Genkottsu (2 Tiles)": 98, "Goomba": 9, "Goronto": 35,
    "Piranha Plant (Downward)/Grubby": 66, "Kurokyura/Jack-in-the-Box": 81,
    "Karakara": 86, "Karamenbo": 102, "Kiddokatto": 72, "Koopa Troopa": 1, "Kyororo": 84, "Kyotonbo": 34,
    "No 48/Mogyo": 88, "Paragoomba (Diagonal)": 8, "Paragoomba (Vertical)": 58, "Tosenbo/Pikku": 92,
    "Piranha Plant": 12, "Rerere/Poro": 90, "Shark": 6,
    "Spinning Platform (Horizontal)/Skeleton Bee": 62, "Pencil/Spikey": 33,
    "Spiny Cheep Cheep": 11, "Spinning Spike/Tamara": 67, "Tatenoko": 75, "Unibo/Terekuribo": 87,
    "Toriuo": 91, "Spinning Spike (Horizontal)/Unera": 65, "Claw Grabber": 73,
    "Diagonal Ball on Chain": 71, "Falling Spike": 78, "Falling Spike on Chain": 79, "Spinning Spike (Vertical)": 80,
    "Spike Ball (Large)": 110, "Spike Ball (Small)": 111, "Moving Saw (Ceiling)": 74, "Moving Saw (Floor)": 76,
    "Moving Platform (Small, Vertical)": 40, "Moving Platform (Large, Vertical)": 41,
    "Moving Platform (Small, Horizontal)": 42, "Moving Platform (Large, Horizontal)": 43,
    "Moving Platform (Large, Diagonal)": 45, "Falling Platform": 46, "Rising Platform": 47,
    "Rotating Platform (Small)": 48, "Owl Platform (Vertical)": 55, "Cloud Platform (Horizontal)": 56,
    "Spinning Platform (Vertical)": 63, "Falling Bone Platform": 96, "Rising Bone Platform": 97, "Skull Platform": 103,
    "Propeller Platform": 107, "Heart": 15, "Mushroom": 27, "Flower": 28, "Carrot": 29, "Star": 30,
    "Mushroom Block": 17, "Flower Block": 18, "Carrot Block": 19, "Star Block": 20, "Heart Block": 21,
    "Money Bag Block": 25, "Bubble": 24, "Midway Bell": 23, "Bonus Bell": 22, "Horizontal Blurp": 5,
    "Big Diagonal Moving Platform": 44}

sprite_id_to_name = {a: b for b, a in sprite_name_to_id.items()}

level_sprites = {
    "Mushroom Zone": [
        {"screen": 1, "sprite": "Goomba", "x": 27, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 9, "y": 24, "misc": 32},
        {"screen": 2, "sprite": "Mushroom Block", "x": 21, "y": 23, "misc": 32},
        {"screen": 4, "sprite": "Goomba", "x": 7, "y": 26, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 11, "y": 18, "misc": 32},
        {"screen": 6, "sprite": "Paragoomba (Diagonal)", "x": 19, "y": 22, "misc": 160},
        {"screen": 8, "sprite": "Piranha Plant", "x": 6, "y": 30, "misc": 160},
        {"screen": 8, "sprite": "Piranha Plant", "x": 22, "y": 30, "misc": 160},
        {"screen": 9, "sprite": "Heart Block", "x": 15, "y": 23, "misc": 32},
        {"screen": 9, "sprite": "Star Block", "x": 17, "y": 23, "misc": 32},
        {"screen": 10, "sprite": "Goomba", "x": 5, "y": 30, "misc": 32},
        {"screen": 10, "sprite": "Goomba", "x": 17, "y": 30, "misc": 32},
        {"screen": 10, "sprite": "Midway Bell", "x": 29, "y": 20, "misc": 32},
        {"screen": 11, "sprite": "Goomba", "x": 1, "y": 30, "misc": 32},
        {"screen": 11, "sprite": "Koopa Troopa", "x": 13, "y": 24, "misc": 32},
        {"screen": 11, "sprite": "Koopa Troopa", "x": 20, "y": 24, "misc": 32},
        {"screen": 11, "sprite": "Flower Block", "x": 25, "y": 23, "misc": 32},
        {"screen": 12, "sprite": "Heart", "x": 15, "y": 30, "misc": 32},
        {"screen": 13, "sprite": "Goomba", "x": 3, "y": 30, "misc": 32},
        {"screen": 13, "sprite": "Piranha Plant", "x": 16, "y": 30, "misc": 32},
        {"screen": 14, "sprite": "Goomba", "x": 11, "y": 22, "misc": 32},
        {"screen": 14, "sprite": "Koopa Troopa", "x": 20, "y": 22, "misc": 160},
        {"screen": 15, "sprite": "Bonus Bell", "x": 21, "y": 13, "misc": 32}],
    "Tree Zone 1": [
        {"screen": 1, "sprite": "Star Block", "x": 17, "y": 21, "misc": 32},
        {"screen": 2, "sprite": "Ragumo/Aqua Kuribo", "x": 5, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Heart", "x": 19, "y": 30, "misc": 0},
        {"screen": 2, "sprite": "Ragumo/Aqua Kuribo", "x": 23, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Money Bag/Bopping Toady", "x": 1, "y": 30, "misc": 160},
        {"screen": 3, "sprite": "Money Bag/Bopping Toady", "x": 20, "y": 24, "misc": 160},
        {"screen": 4, "sprite": "Money Bag/Bopping Toady", "x": 9, "y": 24, "misc": 32},
        {"screen": 4, "sprite": "Heart", "x": 13, "y": 30, "misc": 0},
        {"screen": 4, "sprite": "Money Bag/Bopping Toady", "x": 31, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Pencil/Spikey", "x": 3, "y": 24, "misc": 160},
        {"screen": 5, "sprite": "Kyotonbo", "x": 21, "y": 22, "misc": 160},
        {"screen": 6, "sprite": "Money Bag/Bopping Toady", "x": 11, "y": 24, "misc": 160},
        {"screen": 6, "sprite": "Money Bag/Bopping Toady", "x": 23, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Mushroom Block", "x": 15, "y": 23, "misc": 32},
        {"screen": 7, "sprite": "Pencil/Spikey", "x": 28, "y": 24, "misc": 160},
        {"screen": 7, "sprite": "Heart Block", "x": 29, "y": 5, "misc": 32},
        {"screen": 8, "sprite": "Midway Bell", "x": 13, "y": 22, "misc": 32},
        {"screen": 8, "sprite": "Money Bag/Bopping Toady", "x": 29, "y": 24, "misc": 32},
        {"screen": 9, "sprite": "Ragumo/Aqua Kuribo", "x": 10, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Kyotonbo", "x": 15, "y": 10, "misc": 160},
        {"screen": 9, "sprite": "Mushroom Block", "x": 17, "y": 23, "misc": 32},
        {"screen": 10, "sprite": "Kyotonbo", "x": 3, "y": 10, "misc": 160},
        {"screen": 10, "sprite": "Pencil/Spikey", "x": 19, "y": 24, "misc": 160},
        {"screen": 10, "sprite": "Star Block", "x": 25, "y": 21, "misc": 32},
        {"screen": 11, "sprite": "Money Bag/Bopping Toady", "x": 7, "y": 24, "misc": 32},
        {"screen": 11, "sprite": "Money Bag/Bopping Toady", "x": 27, "y": 24, "misc": 32},
        {"screen": 11, "sprite": "Money Bag/Bopping Toady", "x": 31, "y": 24, "misc": 32},
        {"screen": 12, "sprite": "Money Bag/Bopping Toady", "x": 15, "y": 24, "misc": 32},
        {"screen": 13, "sprite": "Ragumo/Aqua Kuribo", "x": 3, "y": 30, "misc": 32},
        {"screen": 13, "sprite": "Money Bag/Bopping Toady", "x": 23, "y": 24, "misc": 32},
        {"screen": 14, "sprite": "Money Bag/Bopping Toady", "x": 15, "y": 30, "misc": 160},
        {"screen": 14, "sprite": "Kyotonbo", "x": 31, "y": 24, "misc": 160},
        {"screen": 15, "sprite": "Bonus Bell", "x": 19, "y": 13, "misc": 32},
        {"screen": 15, "sprite": "Heart Block", "x": 25, "y": 15, "misc": 32}],
    "Tree Zone 2": [
        {"screen": 2, "sprite": "No 48/Mogyo", "x": 9, "y": 30, "misc": 0},
        {"screen": 2, "sprite": "Mushroom Block", "x": 23, "y": 19, "misc": 0},
        {"screen": 2, "sprite": "No 48/Mogyo", "x": 27, "y": 30, "misc": 0},
        {"screen": 3, "sprite": "Mushroom Block", "x": 7, "y": 23, "misc": 32},
        {"screen": 3, "sprite": "No 48/Mogyo", "x": 15, "y": 28, "misc": 160},
        {"screen": 3, "sprite": "Heart Block", "x": 27, "y": 17, "misc": 0},
        {"screen": 4, "sprite": "No 48/Mogyo", "x": 3, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "No 48/Mogyo", "x": 17, "y": 28, "misc": 160},
        {"screen": 5, "sprite": "Noko Bombette/Bear", "x": 1, "y": 30, "misc": 128},
        {"screen": 5, "sprite": "No 48/Mogyo", "x": 7, "y": 28, "misc": 32},
        {"screen": 6, "sprite": "Falling Platform", "x": 22, "y": 22, "misc": 0},
        {"screen": 7, "sprite": "Midway Bell", "x": 3, "y": 14, "misc": 0},
        {"screen": 7, "sprite": "No 48/Mogyo", "x": 15, "y": 30, "misc": 0},
        {"screen": 7, "sprite": "No 48/Mogyo", "x": 17, "y": 8, "misc": 32},
        {"screen": 7, "sprite": "Money Bag Block", "x": 19, "y": 19, "misc": 32},
        {"screen": 7, "sprite": "No 48/Mogyo", "x": 19, "y": 0, "misc": 32},
        {"screen": 8, "sprite": "Mushroom Block", "x": 5, "y": 13, "misc": 0},
        {"screen": 8, "sprite": "Noko Bombette/Bear", "x": 11, "y": 24, "misc": 0},
        {"screen": 8, "sprite": "Carrot Block", "x": 17, "y": 21, "misc": 64},
        {"screen": 9, "sprite": "Noko Bombette/Bear", "x": 3, "y": 30, "misc": 64},
        {"screen": 9, "sprite": "Noko Bombette/Bear", "x": 23, "y": 30, "misc": 64},
        {"screen": 10, "sprite": "Noko Bombette/Bear", "x": 11, "y": 30, "misc": 64},
        {"screen": 10, "sprite": "Noko Bombette/Bear", "x": 31, "y": 30, "misc": 64},
        {"screen": 11, "sprite": "Money Bag Block", "x": 5, "y": 19, "misc": 0},
        {"screen": 11, "sprite": "Mushroom Block", "x": 13, "y": 5, "misc": 0},
        {"screen": 11, "sprite": "Heart", "x": 19, "y": 24, "misc": 64},
        {"screen": 13, "sprite": "Noko Bombette/Bear", "x": 3, "y": 28, "misc": 192},
        {"screen": 13, "sprite": "Noko Bombette/Bear", "x": 5, "y": 16, "misc": 0},
        {"screen": 13, "sprite": "Noko Bombette/Bear", "x": 13, "y": 28, "misc": 192},
        {"screen": 13, "sprite": "Heart", "x": 27, "y": 8, "misc": 32},
        {"screen": 14, "sprite": "Bonus Bell", "x": 21, "y": 15, "misc": 32}],
    "Tree Zone 4": [
        {"screen": 1, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 11, "y": 26, "misc": 160},
        {"screen": 1, "sprite": "Runaway Heart Block/Bibi", "x": 20, "y": 24, "misc": 0},
        {"screen": 1, "sprite": "Flower Block", "x": 25, "y": 21, "misc": 32},
        {"screen": 2, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 16, "y": 24, "misc": 128},
        {"screen": 3, "sprite": "Neiji/Buichi", "x": 18, "y": 18, "misc": 0},
        {"screen": 3, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 28, "y": 30, "misc": 0},
        {"screen": 4, "sprite": "Neiji/Buichi", "x": 4, "y": 18, "misc": 0},
        {"screen": 4, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 12, "y": 30, "misc": 0},
        {"screen": 4, "sprite": "Neiji/Buichi", "x": 22, "y": 18, "misc": 0},
        {"screen": 4, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 28, "y": 30, "misc": 0},
        {"screen": 5, "sprite": "Neiji/Buichi", "x": 8, "y": 18, "misc": 128},
        {"screen": 6, "sprite": "Runaway Heart Block/Bibi", "x": 12, "y": 24, "misc": 0},
        {"screen": 6, "sprite": "Piranha Plant (Downward)/Grubby", "x": 13, "y": 12, "misc": 160},
        {"screen": 6, "sprite": "Mushroom Block", "x": 19, "y": 17, "misc": 32},
        {"screen": 6, "sprite": "Piranha Plant (Downward)/Grubby", "x": 23, "y": 28, "misc": 128},
        {"screen": 6, "sprite": "Piranha Plant (Downward)/Grubby", "x": 25, "y": 18, "misc": 160},
        {"screen": 6, "sprite": "Piranha Plant (Downward)/Grubby", "x": 31, "y": 24, "misc": 160},
        {"screen": 7, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 2, "y": 24, "misc": 0},
        {"screen": 7, "sprite": "Runaway Heart Block/Bibi", "x": 28, "y": 24, "misc": 128},
        {"screen": 8, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 1, "y": 12, "misc": 32},
        {"screen": 8, "sprite": "Piranha Plant (Downward)/Grubby", "x": 5, "y": 28, "misc": 0},
        {"screen": 8, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 5, "y": 18, "misc": 32},
        {"screen": 8, "sprite": "Runaway Heart Block/Bibi", "x": 14, "y": 24, "misc": 0},
        {"screen": 8, "sprite": "Star Block", "x": 17, "y": 11, "misc": 32},
        {"screen": 8, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 19, "y": 24, "misc": 32},
        {"screen": 9, "sprite": "Star Block", "x": 17, "y": 19, "misc": 0},
        {"screen": 9, "sprite": "Piranha Plant (Downward)/Grubby", "x": 21, "y": 20, "misc": 0},
        {"screen": 9, "sprite": "Spinning Spike/Tamara", "x": 23, "y": 27, "misc": 0},
        {"screen": 10, "sprite": "Midway Bell", "x": 0, "y": 18, "misc": 0},
        {"screen": 10, "sprite": "Spinning Spike/Tamara", "x": 5, "y": 27, "misc": 0},
        {"screen": 10, "sprite": "Piranha Plant (Downward)/Grubby", "x": 11, "y": 20, "misc": 0},
        {"screen": 10, "sprite": "Spinning Spike/Tamara", "x": 17, "y": 27, "misc": 0},
        {"screen": 10, "sprite": "Mushroom Block", "x": 23, "y": 19, "misc": 0},
        {"screen": 12, "sprite": "Runaway Heart Block/Bibi", "x": 2, "y": 24, "misc": 32},
        {"screen": 12, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 28, "y": 24, "misc": 32},
        {"screen": 13, "sprite": "Bonus Bell", "x": 21, "y": 17, "misc": 32}],
    "Tree Zone 3": [
        {"screen": 0, "sprite": "Moving Platform (Large, Vertical)", "x": 19, "y": 10, "misc": 32},
        {"screen": 0, "sprite": "Carrot Block", "x": 25, "y": 25, "misc": 0},
        {"screen": 0, "sprite": "Ant", "x": 28, "y": 18, "misc": 32},
        {"screen": 1, "sprite": "Ant", "x": 0, "y": 22, "misc": 64},
        {"screen": 1, "sprite": "Battle Beetle", "x": 10, "y": 24, "misc": 64},
        {"screen": 1, "sprite": "Moving Platform (Large, Diagonal)", "x": 11, "y": 22, "misc": 32},
        {"screen": 1, "sprite": "Fire Piranha Plant", "x": 18, "y": 20, "misc": 128},
        {"screen": 1, "sprite": "Cheep Cheep (Vertical)", "x": 18, "y": 21, "misc": 0},
        {"screen": 1, "sprite": "Mushroom Block", "x": 21, "y": 15, "misc": 64},
        {"screen": 1, "sprite": "Heart Block", "x": 21, "y": 7, "misc": 64},
        {"screen": 1, "sprite": "Be", "x": 30, "y": 26, "misc": 32},
        {"screen": 2, "sprite": "Piranha Plant", "x": 4, "y": 24, "misc": 192},
        {"screen": 2, "sprite": "Be", "x": 14, "y": 26, "misc": 32},
        {"screen": 2, "sprite": "Fire Piranha Plant", "x": 20, "y": 24, "misc": 192},
        {"screen": 2, "sprite": "Falling Platform", "x": 24, "y": 27, "misc": 0},
        {"screen": 2, "sprite": "Heart Block", "x": 25, "y": 19, "misc": 0},
        {"screen": 3, "sprite": "Falling Platform", "x": 0, "y": 25, "misc": 0},
        {"screen": 3, "sprite": "Falling Platform", "x": 0, "y": 31, "misc": 32},
        {"screen": 3, "sprite": "Cheep Cheep (Vertical)", "x": 4, "y": 15, "misc": 64},
        {"screen": 3, "sprite": "Falling Platform", "x": 8, "y": 31, "misc": 32},
        {"screen": 3, "sprite": "Ant", "x": 20, "y": 30, "misc": 0},
        {"screen": 3, "sprite": "Heart Block", "x": 27, "y": 17, "misc": 32},
        {"screen": 3, "sprite": "Heart Block", "x": 29, "y": 5, "misc": 32},
        {"screen": 4, "sprite": "Fire Piranha Plant", "x": 4, "y": 22, "misc": 192},
        {"screen": 4, "sprite": "Moving Platform (Small, Horizontal)", "x": 8, "y": 19, "misc": 0},
        {"screen": 4, "sprite": "Ant", "x": 12, "y": 20, "misc": 64},
        {"screen": 4, "sprite": "Moving Platform (Small, Vertical)", "x": 14, "y": 2, "misc": 64},
        {"screen": 4, "sprite": "Bonus Bell", "x": 21, "y": 17, "misc": 0},
        {"screen": 4, "sprite": "Money Bag Block", "x": 27, "y": 15, "misc": 32},
        {"screen": 4, "sprite": "Heart Block", "x": 27, "y": 17, "misc": 64}],
    "Tree Zone 5": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 15, "y": 17, "misc": 64},
        {"screen": 1, "sprite": "Rotating Platform (Small)", "x": 15, "y": 19, "misc": 64},
        {"screen": 2, "sprite": "Paragoomba (Vertical)", "x": 2, "y": 26, "misc": 192},
        {"screen": 2, "sprite": "Paragoomba (Vertical)", "x": 16, "y": 26, "misc": 192},
        {"screen": 2, "sprite": "Heart Block", "x": 17, "y": 13, "misc": 64},
        {"screen": 2, "sprite": "Paragoomba (Vertical)", "x": 26, "y": 26, "misc": 192},
        {"screen": 3, "sprite": "Paragoomba (Vertical)", "x": 6, "y": 22, "misc": 192},
        {"screen": 3, "sprite": "Owl Platform (Vertical)", "x": 23, "y": 28, "misc": 64},
        {"screen": 4, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 11, "y": 19, "misc": 64},
        {"screen": 5, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 1, "y": 21, "misc": 64},
        {"screen": 5, "sprite": "Cloud Platform (Horizontal)", "x": 18, "y": 20, "misc": 64},
        {"screen": 5, "sprite": "Cloud Platform (Horizontal)", "x": 26, "y": 26, "misc": 64},
        {"screen": 6, "sprite": "Cloud Platform (Horizontal)", "x": 2, "y": 20, "misc": 64},
        {"screen": 6, "sprite": "Midway Bell", "x": 18, "y": 20, "misc": 64},
        {"screen": 6, "sprite": "Heart Block", "x": 23, "y": 21, "misc": 64},
        {"screen": 6, "sprite": "Dondon", "x": 30, "y": 14, "misc": 64},
        {"screen": 7, "sprite": "Carrot Block", "x": 9, "y": 19, "misc": 64},
        {"screen": 7, "sprite": "Rotating Platform (Small)", "x": 9, "y": 21, "misc": 64},
        {"screen": 7, "sprite": "Heart Block", "x": 23, "y": 13, "misc": 64},
        {"screen": 7, "sprite": "Rotating Platform (Small)", "x": 23, "y": 23, "misc": 64},
        {"screen": 8, "sprite": "Mushroom Block", "x": 21, "y": 13, "misc": 64},
        {"screen": 9, "sprite": "Star Block", "x": 5, "y": 7, "misc": 64},
        {"screen": 9, "sprite": "Paragoomba (Vertical)", "x": 7, "y": 14, "misc": 64},
        {"screen": 9, "sprite": "Paragoomba (Vertical)", "x": 27, "y": 20, "misc": 64},
        {"screen": 9, "sprite": "Paragoomba (Vertical)", "x": 31, "y": 16, "misc": 64},
        {"screen": 10, "sprite": "Cloud Platform (Horizontal)", "x": 20, "y": 22, "misc": 64},
        {"screen": 10, "sprite": "Paragoomba (Vertical)", "x": 31, "y": 18, "misc": 64},
        {"screen": 11, "sprite": "Cloud Platform (Horizontal)", "x": 8, "y": 22, "misc": 64},
        {"screen": 11, "sprite": "Paragoomba (Vertical)", "x": 16, "y": 25, "misc": 64}],
    "Pumpkin Zone 1": [
        {"screen": 1, "sprite": "Falling Spike on Chain", "x": 9, "y": 14, "misc": 160},
        {"screen": 1, "sprite": "Mushroom Block", "x": 15, "y": 23, "misc": 0},
        {"screen": 1, "sprite": "Masked Ghoul/Bullet Bill", "x": 19, "y": 30, "misc": 0},
        {"screen": 1, "sprite": "Falling Spike on Chain", "x": 27, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Falling Spike on Chain", "x": 17, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Falling Spike on Chain", "x": 23, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Falling Spike on Chain", "x": 29, "y": 22, "misc": 32},
        {"screen": 3, "sprite": "Masked Ghoul/Bullet Bill", "x": 1, "y": 30, "misc": 160},
        {"screen": 3, "sprite": "Masked Ghoul/Bullet Bill", "x": 21, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Masked Ghoul/Bullet Bill", "x": 5, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Carrot Block", "x": 17, "y": 21, "misc": 32},
        {"screen": 4, "sprite": "Masked Ghoul/Bullet Bill", "x": 21, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Falling Spike", "x": 27, "y": 20, "misc": 32},
        {"screen": 6, "sprite": "Boo/Bomubomu", "x": 1, "y": 28, "misc": 0},
        {"screen": 6, "sprite": "Masked Ghoul/Bullet Bill", "x": 2, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Heart Block", "x": 5, "y": 7, "misc": 0},
        {"screen": 6, "sprite": "Boo/Bomubomu", "x": 9, "y": 28, "misc": 128},
        {"screen": 6, "sprite": "Fire Piranha Plant", "x": 16, "y": 2, "misc": 192},
        {"screen": 6, "sprite": "Midway Bell", "x": 24, "y": 22, "misc": 32},
        {"screen": 7, "sprite": "Falling Spike", "x": 1, "y": 20, "misc": 32},
        {"screen": 7, "sprite": "Masked Ghoul/Bullet Bill", "x": 9, "y": 30, "misc": 160},
        {"screen": 7, "sprite": "Falling Spike", "x": 27, "y": 20, "misc": 32},
        {"screen": 7, "sprite": "Masked Ghoul/Bullet Bill", "x": 31, "y": 30, "misc": 160},
        {"screen": 8, "sprite": "Piranha Plant", "x": 16, "y": 28, "misc": 32},
        {"screen": 8, "sprite": "Masked Ghoul/Bullet Bill", "x": 17, "y": 24, "misc": 160},
        {"screen": 8, "sprite": "Fire Piranha Plant", "x": 24, "y": 30, "misc": 160},
        {"screen": 9, "sprite": "Masked Ghoul/Bullet Bill", "x": 7, "y": 22, "misc": 160},
        {"screen": 9, "sprite": "Falling Spike on Chain", "x": 11, "y": 10, "misc": 160},
        {"screen": 9, "sprite": "Piranha Plant", "x": 20, "y": 14, "misc": 32},
        {"screen": 9, "sprite": "Falling Spike on Chain", "x": 23, "y": 30, "misc": 128},
        {"screen": 10, "sprite": "Cheep Cheep (Vertical)", "x": 30, "y": 11, "misc": 160},
        {"screen": 11, "sprite": "Cheep Cheep (Vertical)", "x": 6, "y": 19, "misc": 32},
        {"screen": 11, "sprite": "Kurokyura/Jack-in-the-Box", "x": 11, "y": 30, "misc": 0},
        {"screen": 11, "sprite": "Bonus Bell", "x": 21, "y": 3, "misc": 32},
        {"screen": 11, "sprite": "Heart Block", "x": 27, "y": 11, "misc": 0}],
    "Pumpkin Zone 2": [
        {"screen": 1, "sprite": "Karakara", "x": 7, "y": 30, "misc": 160},
        {"screen": 1, "sprite": "Karakara", "x": 15, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Karakara", "x": 23, "y": 30, "misc": 160},
        {"screen": 2, "sprite": "Piranha Plant", "x": 20, "y": 30, "misc": 160},
        {"screen": 3, "sprite": "Honebon/F Boy", "x": 4, "y": 11, "misc": 160},
        {"screen": 3, "sprite": "Cheep Cheep (Vertical)", "x": 4, "y": 23, "misc": 32},
        {"screen": 3, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 13, "y": 28, "misc": 192},
        {"screen": 3, "sprite": "Mushroom Block", "x": 17, "y": 21, "misc": 64},
        {"screen": 4, "sprite": "Kyororo", "x": 29, "y": 30, "misc": 160},
        {"screen": 5, "sprite": "Honebon/F Boy", "x": 6, "y": 24, "misc": 32},
        {"screen": 5, "sprite": "Kyororo", "x": 13, "y": 30, "misc": 160},
        {"screen": 5, "sprite": "Kyororo", "x": 29, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Midway Bell", "x": 1, "y": 16, "misc": 32},
        {"screen": 6, "sprite": "Star (Horizontal)/Blurp (Vertical)", "x": 21, "y": 30, "misc": 192},
        {"screen": 6, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 28, "y": 25, "misc": 64},
        {"screen": 7, "sprite": "Mushroom", "x": 3, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Boo/Bomubomu", "x": 9, "y": 13, "misc": 160},
        {"screen": 7, "sprite": "Boo/Bomubomu", "x": 13, "y": 21, "misc": 160},
        {"screen": 7, "sprite": "Heart", "x": 29, "y": 14, "misc": 32},
        {"screen": 8, "sprite": "Carrot", "x": 7, "y": 22, "misc": 32},
        {"screen": 8, "sprite": "Flower", "x": 13, "y": 14, "misc": 32},
        {"screen": 8, "sprite": "Heart", "x": 19, "y": 20, "misc": 32},
        {"screen": 9, "sprite": "Star Block", "x": 1, "y": 13, "misc": 32},
        {"screen": 9, "sprite": "Kyororo", "x": 19, "y": 30, "misc": 64},
        {"screen": 9, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 20, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Kyororo", "x": 21, "y": 16, "misc": 32},
        {"screen": 10, "sprite": "Kyororo", "x": 5, "y": 14, "misc": 32},
        {"screen": 10, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 7, "y": 28, "misc": 32},
        {"screen": 10, "sprite": "Kyororo", "x": 22, "y": 14, "misc": 32},
        {"screen": 11, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 0, "y": 26, "misc": 192},
        {"screen": 11, "sprite": "Falling Spike", "x": 5, "y": 24, "misc": 64},
        {"screen": 11, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 7, "y": 30, "misc": 32},
        {"screen": 11, "sprite": "Kyororo", "x": 10, "y": 16, "misc": 32},
        {"screen": 11, "sprite": "Falling Spike", "x": 15, "y": 24, "misc": 64},
        {"screen": 11, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 19, "y": 28, "misc": 192},
        {"screen": 12, "sprite": "Karakara", "x": 9, "y": 30, "misc": 32},
        {"screen": 12, "sprite": "Karakara", "x": 17, "y": 30, "misc": 32},
        {"screen": 12, "sprite": "Karakara", "x": 25, "y": 30, "misc": 32},
        {"screen": 13, "sprite": "Karakara", "x": 19, "y": 30, "misc": 32},
        {"screen": 13, "sprite": "Bonus Bell", "x": 21, "y": 11, "misc": 32}],
    "Pumpkin Zone 3": [
        {"screen": 1, "sprite": "Unibo/Terekuribo", "x": 21, "y": 26, "misc": 160},
        {"screen": 2, "sprite": "Unibo/Terekuribo", "x": 21, "y": 20, "misc": 160},
        {"screen": 3, "sprite": "Carrot Block", "x": 9, "y": 7, "misc": 32},
        {"screen": 3, "sprite": "Boo/Bomubomu", "x": 19, "y": 23, "misc": 32},
        {"screen": 4, "sprite": "Boo/Bomubomu", "x": 1, "y": 21, "misc": 32},
        {"screen": 4, "sprite": "Boo/Bomubomu", "x": 19, "y": 14, "misc": 160},
        {"screen": 6, "sprite": "Moving Platform (Small, Horizontal)", "x": 0, "y": 8, "misc": 64},
        {"screen": 6, "sprite": "Moving Platform (Small, Horizontal)", "x": 0, "y": 14, "misc": 64},
        {"screen": 6, "sprite": "Flower Block", "x": 17, "y": 19, "misc": 64},
        {"screen": 7, "sprite": "Unibo/Terekuribo", "x": 1, "y": 26, "misc": 32},
        {"screen": 7, "sprite": "Boo/Bomubomu", "x": 17, "y": 18, "misc": 64},
        {"screen": 8, "sprite": "Fire Piranha Plant", "x": 16, "y": 28, "misc": 32},
        {"screen": 8, "sprite": "Heart Block", "x": 23, "y": 5, "misc": 64},
        {"screen": 8, "sprite": "Flower Block", "x": 25, "y": 17, "misc": 64},
        {"screen": 9, "sprite": "Midway Bell", "x": 5, "y": 22, "misc": 32},
        {"screen": 9, "sprite": "Boo/Bomubomu", "x": 19, "y": 22, "misc": 160},
        {"screen": 10, "sprite": "Boo/Bomubomu", "x": 2, "y": 27, "misc": 32},
        {"screen": 10, "sprite": "Boo/Bomubomu", "x": 25, "y": 14, "misc": 160},
        {"screen": 11, "sprite": "Carrot Block", "x": 7, "y": 13, "misc": 32},
        {"screen": 11, "sprite": "Boo/Bomubomu", "x": 23, "y": 18, "misc": 160},
        {"screen": 13, "sprite": "Boo/Bomubomu", "x": 3, "y": 28, "misc": 32},
        {"screen": 13, "sprite": "Boo/Bomubomu", "x": 12, "y": 5, "misc": 64},
        {"screen": 14, "sprite": "Unibo/Terekuribo", "x": 3, "y": 28, "misc": 160},
        {"screen": 14, "sprite": "Boo/Bomubomu", "x": 5, "y": 18, "misc": 192},
        {"screen": 14, "sprite": "Unibo/Terekuribo", "x": 14, "y": 24, "misc": 32},
        {"screen": 14, "sprite": "Bonus Bell", "x": 21, "y": 13, "misc": 64}],
    "Pumpkin Zone 4": [
        {"screen": 1, "sprite": "Tosenbo/Pikku", "x": 19, "y": 30, "misc": 160},
        {"screen": 1, "sprite": "Piranha Plant", "x": 24, "y": 0, "misc": 64},
        {"screen": 2, "sprite": "Boo/Bomubomu", "x": 9, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Boo/Bomubomu", "x": 24, "y": 21, "misc": 160},
        {"screen": 3, "sprite": "Boo/Bomubomu", "x": 23, "y": 26, "misc": 160},
        {"screen": 3, "sprite": "Falling Spike on Chain", "x": 29, "y": 22, "misc": 32},
        {"screen": 4, "sprite": "Falling Spike on Chain", "x": 3, "y": 22, "misc": 32},
        {"screen": 4, "sprite": "Falling Spike on Chain", "x": 9, "y": 22, "misc": 32},
        {"screen": 4, "sprite": "Tosenbo/Pikku", "x": 28, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Mushroom Block", "x": 7, "y": 11, "misc": 64},
        {"screen": 5, "sprite": "Boo/Bomubomu", "x": 17, "y": 26, "misc": 192},
        {"screen": 5, "sprite": "Heart Block", "x": 29, "y": 15, "misc": 64},
        {"screen": 6, "sprite": "Carrot Block", "x": 17, "y": 13, "misc": 32},
        {"screen": 7, "sprite": "Midway Bell", "x": 15, "y": 24, "misc": 32},
        {"screen": 8, "sprite": "Falling Spike on Chain", "x": 3, "y": 22, "misc": 32},
        {"screen": 8, "sprite": "Rerere/Poro", "x": 10, "y": 30, "misc": 160},
        {"screen": 8, "sprite": "Falling Spike on Chain", "x": 17, "y": 22, "misc": 160},
        {"screen": 8, "sprite": "Falling Spike on Chain", "x": 27, "y": 22, "misc": 160},
        {"screen": 9, "sprite": "Rerere/Poro", "x": 3, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Falling Spike on Chain", "x": 9, "y": 22, "misc": 160},
        {"screen": 10, "sprite": "Masked Ghoul/Bullet Bill", "x": 19, "y": 30, "misc": 32},
        {"screen": 10, "sprite": "Masked Ghoul/Bullet Bill", "x": 25, "y": 26, "misc": 160},
        {"screen": 10, "sprite": "Masked Ghoul/Bullet Bill", "x": 31, "y": 22, "misc": 32},
        {"screen": 11, "sprite": "Masked Ghoul/Bullet Bill", "x": 5, "y": 18, "misc": 32},
        {"screen": 12, "sprite": "Masked Ghoul/Bullet Bill", "x": 14, "y": 16, "misc": 192},
        {"screen": 12, "sprite": "Masked Ghoul/Bullet Bill", "x": 25, "y": 16, "misc": 192},
        {"screen": 13, "sprite": "Masked Ghoul/Bullet Bill", "x": 6, "y": 16, "misc": 192},
        {"screen": 13, "sprite": "Flower Block", "x": 13, "y": 23, "misc": 32},
        {"screen": 13, "sprite": "Masked Ghoul/Bullet Bill", "x": 18, "y": 16, "misc": 192},
        {"screen": 13, "sprite": "Money Bag Block", "x": 25, "y": 23, "misc": 32},
        {"screen": 14, "sprite": "Boo/Bomubomu", "x": 13, "y": 30, "misc": 160}],
    "Mario Zone 1": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 5, "y": 23, "misc": 64},
        {"screen": 1, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 7, "y": 9, "misc": 64},
        {"screen": 1, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 13, "y": 13, "misc": 32},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 13, "y": 30, "misc": 192},
        {"screen": 1, "sprite": "Spinning Spike (Vertical)", "x": 19, "y": 22, "misc": 0},
        {"screen": 1, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 19, "y": 15, "misc": 32},
        {"screen": 2, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 13, "y": 27, "misc": 64},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 25, "y": 18, "misc": 64},
        {"screen": 3, "sprite": "Spinning Platform (Vertical)", "x": 1, "y": 18, "misc": 64},
        {"screen": 3, "sprite": "Spinning Platform (Vertical)", "x": 7, "y": 18, "misc": 64},
        {"screen": 3, "sprite": "Koopa Troopa", "x": 19, "y": 26, "misc": 192},
        {"screen": 3, "sprite": "Koopa Troopa", "x": 31, "y": 14, "misc": 192},
        {"screen": 4, "sprite": "Spinning Platform (Vertical)", "x": 23, "y": 20, "misc": 64},
        {"screen": 4, "sprite": "Tatenoko", "x": 26, "y": 15, "misc": 192},
        {"screen": 4, "sprite": "Spinning Platform (Vertical)", "x": 29, "y": 20, "misc": 64},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 11, "y": 16, "misc": 192},
        {"screen": 5, "sprite": "Spinning Platform (Vertical)", "x": 19, "y": 22, "misc": 64},
        {"screen": 5, "sprite": "Spinning Platform (Vertical)", "x": 23, "y": 22, "misc": 64},
        {"screen": 6, "sprite": "Carrot Block", "x": 5, "y": 11, "misc": 64},
        {"screen": 6, "sprite": "Midway Bell", "x": 16, "y": 12, "misc": 64},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 19, "y": 20, "misc": 64},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 21, "y": 24, "misc": 192},
        {"screen": 8, "sprite": "Spinning Spike (Horizontal)/Unera", "x": 12, "y": 30, "misc": 64},
        {"screen": 8, "sprite": "Heart Block", "x": 13, "y": 17, "misc": 64},
        {"screen": 9, "sprite": "Mushroom Block", "x": 3, "y": 19, "misc": 64},
        {"screen": 9, "sprite": "Neiji/Buichi", "x": 3, "y": 0, "misc": 96},
        {"screen": 9, "sprite": "Neiji/Buichi", "x": 11, "y": 0, "misc": 224},
        {"screen": 9, "sprite": "Neiji/Buichi", "x": 19, "y": 0, "misc": 224},
        {"screen": 9, "sprite": "Heart Block", "x": 27, "y": 7, "misc": 32},
        {"screen": 9, "sprite": "Spinning Platform (Vertical)", "x": 29, "y": 30, "misc": 32},
        {"screen": 10, "sprite": "Tatenoko", "x": 4, "y": 13, "misc": 32},
        {"screen": 10, "sprite": "Spinning Platform (Horizontal)/Skeleton Bee", "x": 7, "y": 21, "misc": 64},
        {"screen": 10, "sprite": "Carrot Block", "x": 9, "y": 7, "misc": 32},
        {"screen": 10, "sprite": "Spinning Platform (Vertical)", "x": 9, "y": 18, "misc": 32},
        {"screen": 10, "sprite": "Bonus Bell", "x": 19, "y": 17, "misc": 64}],
    "Mario Zone 2": [
        {"screen": 1, "sprite": "Boo/Bomubomu", "x": 9, "y": 28, "misc": 32},
        {"screen": 1, "sprite": "Boo/Bomubomu", "x": 31, "y": 22, "misc": 160},
        {"screen": 3, "sprite": "Paragoomba (Vertical)", "x": 6, "y": 18, "misc": 160},
        {"screen": 3, "sprite": "Paragoomba (Vertical)", "x": 15, "y": 21, "misc": 160},
        {"screen": 4, "sprite": "Paragoomba (Vertical)", "x": 3, "y": 20, "misc": 160},
        {"screen": 4, "sprite": "Paragoomba (Vertical)", "x": 12, "y": 18, "misc": 160},
        {"screen": 4, "sprite": "Paragoomba (Vertical)", "x": 28, "y": 21, "misc": 32},
        {"screen": 5, "sprite": "Mushroom Block", "x": 3, "y": 21, "misc": 32},
        {"screen": 5, "sprite": "Heart", "x": 8, "y": 28, "misc": 32},
        {"screen": 5, "sprite": "Goomba", "x": 9, "y": 20, "misc": 192},
        {"screen": 5, "sprite": "Carrot Block", "x": 17, "y": 11, "misc": 64},
        {"screen": 5, "sprite": "Goomba", "x": 25, "y": 26, "misc": 192},
        {"screen": 5, "sprite": "Money Bag Block", "x": 27, "y": 19, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 3, "y": 26, "misc": 64},
        {"screen": 6, "sprite": "Star Block", "x": 7, "y": 11, "misc": 64},
        {"screen": 7, "sprite": "Noko Bombette/Bear", "x": 6, "y": 28, "misc": 32},
        {"screen": 8, "sprite": "Midway Bell", "x": 5, "y": 18, "misc": 32},
        {"screen": 8, "sprite": "Boo/Bomubomu", "x": 21, "y": 28, "misc": 160},
        {"screen": 8, "sprite": "Boo/Bomubomu", "x": 31, "y": 16, "misc": 32},
        {"screen": 9, "sprite": "Mushroom Block", "x": 11, "y": 15, "misc": 32},
        {"screen": 9, "sprite": "Boo/Bomubomu", "x": 19, "y": 20, "misc": 160},
        {"screen": 10, "sprite": "Boo/Bomubomu", "x": 5, "y": 24, "misc": 32},
        {"screen": 11, "sprite": "Mushroom", "x": 1, "y": 14, "misc": 32},
        {"screen": 11, "sprite": "Goomba", "x": 9, "y": 14, "misc": 32},
        {"screen": 11, "sprite": "Flower", "x": 17, "y": 14, "misc": 32},
        {"screen": 11, "sprite": "Carrot", "x": 25, "y": 14, "misc": 32},
        {"screen": 12, "sprite": "Boo/Bomubomu", "x": 12, "y": 16, "misc": 32},
        {"screen": 12, "sprite": "Boo/Bomubomu", "x": 24, "y": 20, "misc": 160},
        {"screen": 13, "sprite": "Noko Bombette/Bear", "x": 16, "y": 28, "misc": 32},
        {"screen": 14, "sprite": "Noko Bombette/Bear", "x": 12, "y": 28, "misc": 32},
        {"screen": 14, "sprite": "Bonus Bell", "x": 21, "y": 17, "misc": 32}],
    "Mario Zone 3": [
        {"screen": 1, "sprite": "Kurokyura/Jack-in-the-Box", "x": 15, "y": 23, "misc": 160},
        {"screen": 1, "sprite": "Kiddokatto", "x": 21, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Masked Ghoul/Bullet Bill", "x": 4, "y": 26, "misc": 160},
        {"screen": 2, "sprite": "Diagonal Ball on Chain", "x": 9, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Diagonal Ball on Chain", "x": 1, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Mushroom Block", "x": 13, "y": 17, "misc": 32},
        {"screen": 3, "sprite": "Diagonal Ball on Chain", "x": 25, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Masked Ghoul/Bullet Bill", "x": 14, "y": 24, "misc": 160},
        {"screen": 4, "sprite": "Diagonal Ball on Chain", "x": 27, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Masked Ghoul/Bullet Bill", "x": 14, "y": 24, "misc": 160},
        {"screen": 6, "sprite": "Carrot Block", "x": 9, "y": 21, "misc": 32},
        {"screen": 6, "sprite": "Kiddokatto", "x": 25, "y": 30, "misc": 160},
        {"screen": 7, "sprite": "Masked Ghoul/Bullet Bill", "x": 26, "y": 28, "misc": 32},
        {"screen": 7, "sprite": "Midway Bell", "x": 27, "y": 22, "misc": 32},
        {"screen": 8, "sprite": "Kurokyura/Jack-in-the-Box", "x": 11, "y": 21, "misc": 32},
        {"screen": 8, "sprite": "Heart Block", "x": 13, "y": 3, "misc": 32},
        {"screen": 8, "sprite": "Kiddokatto", "x": 31, "y": 30, "misc": 160},
        {"screen": 9, "sprite": "Claw Grabber", "x": 23, "y": 28, "misc": 32},
        {"screen": 10, "sprite": "Claw Grabber", "x": 13, "y": 28, "misc": 32},
        {"screen": 11, "sprite": "Masked Ghoul/Bullet Bill", "x": 4, "y": 28, "misc": 64},
        {"screen": 11, "sprite": "Koopa Troopa", "x": 5, "y": 20, "misc": 160},
        {"screen": 11, "sprite": "Masked Ghoul/Bullet Bill", "x": 8, "y": 12, "misc": 192},
        {"screen": 11, "sprite": "Kiddokatto", "x": 26, "y": 20, "misc": 32},
        {"screen": 11, "sprite": "Heart Block", "x": 27, "y": 23, "misc": 64},
        {"screen": 11, "sprite": "Masked Ghoul/Bullet Bill", "x": 28, "y": 18, "misc": 192},
        {"screen": 12, "sprite": "Claw Grabber", "x": 11, "y": 28, "misc": 32},
        {"screen": 12, "sprite": "Kiddokatto", "x": 21, "y": 20, "misc": 32},
        {"screen": 13, "sprite": "Mushroom Block", "x": 13, "y": 21, "misc": 32},
        {"screen": 13, "sprite": "Masked Ghoul/Bullet Bill", "x": 18, "y": 28, "misc": 160},
        {"screen": 13, "sprite": "Kurokyura/Jack-in-the-Box", "x": 25, "y": 21, "misc": 32},
        {"screen": 14, "sprite": "Diagonal Ball on Chain", "x": 9, "y": 30, "misc": 32},
        {"screen": 14, "sprite": "Masked Ghoul/Bullet Bill", "x": 26, "y": 24, "misc": 160},
        {"screen": 15, "sprite": "Claw Grabber", "x": 3, "y": 18, "misc": 32},
        {"screen": 15, "sprite": "Bonus Bell", "x": 21, "y": 17, "misc": 32}],
    "Mario Zone 4": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 9, "y": 17, "misc": 32},
        {"screen": 1, "sprite": "Spinning Spike/Tamara", "x": 9, "y": 25, "misc": 160},
        {"screen": 1, "sprite": "Spinning Spike/Tamara", "x": 29, "y": 25, "misc": 32},
        {"screen": 2, "sprite": "Masked Ghoul/Bullet Bill", "x": 12, "y": 26, "misc": 160},
        {"screen": 2, "sprite": "Spinning Spike/Tamara", "x": 29, "y": 21, "misc": 160},
        {"screen": 3, "sprite": "Spinning Spike/Tamara", "x": 15, "y": 21, "misc": 32},
        {"screen": 4, "sprite": "Masked Ghoul/Bullet Bill", "x": 14, "y": 26, "misc": 160},
        {"screen": 4, "sprite": "Masked Ghoul/Bullet Bill", "x": 24, "y": 21, "misc": 32},
        {"screen": 5, "sprite": "Masked Ghoul/Bullet Bill", "x": 2, "y": 26, "misc": 32},
        {"screen": 5, "sprite": "Goomba", "x": 22, "y": 20, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 2, "y": 14, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 14, "y": 8, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 26, "y": 2, "misc": 32},
        {"screen": 7, "sprite": "Spinning Spike/Tamara", "x": 9, "y": 25, "misc": 160},
        {"screen": 7, "sprite": "Spinning Spike/Tamara", "x": 15, "y": 21, "misc": 32},
        {"screen": 7, "sprite": "Spinning Spike/Tamara", "x": 21, "y": 25, "misc": 160},
        {"screen": 7, "sprite": "Mushroom Block", "x": 25, "y": 23, "misc": 0},
        {"screen": 8, "sprite": "Boo/Bomubomu", "x": 17, "y": 26, "misc": 128},
        {"screen": 8, "sprite": "Masked Ghoul/Bullet Bill", "x": 30, "y": 24, "misc": 0},
        {"screen": 9, "sprite": "Boo/Bomubomu", "x": 11, "y": 30, "misc": 128},
        {"screen": 9, "sprite": "Midway Bell", "x": 16, "y": 24, "misc": 0},
        {"screen": 9, "sprite": "Goomba", "x": 26, "y": 30, "misc": 0},
        {"screen": 10, "sprite": "Moving Saw (Ceiling)", "x": 17, "y": 26, "misc": 0},
        {"screen": 10, "sprite": "Moving Saw (Floor)", "x": 19, "y": 22, "misc": 128},
        {"screen": 11, "sprite": "Mushroom Block", "x": 7, "y": 23, "misc": 0},
        {"screen": 11, "sprite": "Moving Saw (Ceiling)", "x": 25, "y": 26, "misc": 128},
        {"screen": 11, "sprite": "Moving Saw (Floor)", "x": 27, "y": 22, "misc": 0},
        {"screen": 11, "sprite": "Money Bag/Bopping Toady", "x": 29, "y": 30, "misc": 0},
        {"screen": 13, "sprite": "Moving Saw (Floor)", "x": 9, "y": 28, "misc": 128},
        {"screen": 13, "sprite": "Moving Saw (Floor)", "x": 19, "y": 28, "misc": 0},
        {"screen": 14, "sprite": "Spinning Spike/Tamara", "x": 13, "y": 25, "misc": 0},
        {"screen": 14, "sprite": "Goomba", "x": 21, "y": 30, "misc": 128}],
    "Turtle Zone 1": [
        {"screen": 1, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 2, "y": 16, "misc": 192},
        {"screen": 1, "sprite": "Horizontal Blurp", "x": 12, "y": 21, "misc": 64},
        {"screen": 1, "sprite": "Mushroom Block", "x": 13, "y": 3, "misc": 64},
        {"screen": 2, "sprite": "Horizontal Blurp", "x": 1, "y": 18, "misc": 64},
        {"screen": 2, "sprite": "Spiny Cheep Cheep", "x": 11, "y": 26, "misc": 64},
        {"screen": 2, "sprite": "Cheep Cheep (Vertical)", "x": 26, "y": 28, "misc": 192},
        {"screen": 3, "sprite": "Goomba", "x": 3, "y": 8, "misc": 64},
        {"screen": 3, "sprite": "Goomba", "x": 17, "y": 8, "misc": 64},
        {"screen": 3, "sprite": "Star Block", "x": 17, "y": 1, "misc": 64},
        {"screen": 3, "sprite": "Cheep Cheep (Vertical)", "x": 18, "y": 28, "misc": 192},
        {"screen": 3, "sprite": "Heart Block", "x": 19, "y": 1, "misc": 64},
        {"screen": 3, "sprite": "Shark", "x": 27, "y": 26, "misc": 192},
        {"screen": 4, "sprite": "Paragoomba (Diagonal)", "x": 1, "y": 4, "misc": 64},
        {"screen": 4, "sprite": "Goomba", "x": 10, "y": 8, "misc": 64},
        {"screen": 5, "sprite": "Horizontal Blurp", "x": 1, "y": 16, "misc": 64},
        {"screen": 5, "sprite": "Horizontal Blurp", "x": 9, "y": 22, "misc": 192},
        {"screen": 5, "sprite": "Horizontal Blurp", "x": 16, "y": 26, "misc": 64},
        {"screen": 6, "sprite": "Shark", "x": 12, "y": 21, "misc": 64},
        {"screen": 6, "sprite": "Midway Bell", "x": 21, "y": 18, "misc": 64},
        {"screen": 6, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 25, "y": 16, "misc": 64},
        {"screen": 7, "sprite": "Spiny Cheep Cheep", "x": 21, "y": 17, "misc": 64},
        {"screen": 7, "sprite": "Horizontal Blurp", "x": 25, "y": 26, "misc": 64},
        {"screen": 8, "sprite": "Cheep Cheep (Vertical)", "x": 7, "y": 20, "misc": 64},
        {"screen": 8, "sprite": "Shark", "x": 15, "y": 14, "misc": 192},
        {"screen": 8, "sprite": "Spiny Cheep Cheep", "x": 25, "y": 24, "misc": 192},
        {"screen": 8, "sprite": "Mushroom Block", "x": 31, "y": 3, "misc": 64},
        {"screen": 9, "sprite": "Cheep Cheep (Vertical)", "x": 15, "y": 24, "misc": 64},
        {"screen": 9, "sprite": "Cheep Cheep (Vertical)", "x": 23, "y": 20, "misc": 192},
        {"screen": 9, "sprite": "Cheep Cheep (Vertical)", "x": 29, "y": 26, "misc": 192},
        {"screen": 10, "sprite": "Shark", "x": 10, "y": 18, "misc": 192},
        {"screen": 10, "sprite": "Money Bag Block", "x": 11, "y": 31, "misc": 32},
        {"screen": 11, "sprite": "Shark", "x": 5, "y": 22, "misc": 64},
        {"screen": 11, "sprite": "Horizontal Blurp", "x": 16, "y": 28, "misc": 192},
        {"screen": 11, "sprite": "Bonus Bell", "x": 21, "y": 9, "misc": 64},
        {"screen": 11, "sprite": "Heart Block", "x": 27, "y": 23, "misc": 64}],
    "Turtle Zone 2": [
        {"screen": 0, "sprite": "Shark", "x": 17, "y": 12, "misc": 192},
        {"screen": 0, "sprite": "Carrot Block", "x": 21, "y": 19, "misc": 64},
        {"screen": 0, "sprite": "Masked Ghoul/Bullet Bill", "x": 22, "y": 28, "misc": 192},
        {"screen": 1, "sprite": "Honebon/F Boy", "x": 13, "y": 12, "misc": 192},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 19, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Karakara", "x": 28, "y": 27, "misc": 64},
        {"screen": 2, "sprite": "Shark", "x": 7, "y": 10, "misc": 64},
        {"screen": 2, "sprite": "Karakara", "x": 17, "y": 27, "misc": 64},
        {"screen": 2, "sprite": "Karakara", "x": 23, "y": 22, "misc": 64},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 25, "y": 14, "misc": 32},
        {"screen": 3, "sprite": "Karakara", "x": 2, "y": 1, "misc": 64},
        {"screen": 3, "sprite": "Karakara", "x": 6, "y": 14, "misc": 192},
        {"screen": 3, "sprite": "Masked Ghoul/Bullet Bill", "x": 14, "y": 24, "misc": 192},
        {"screen": 3, "sprite": "Flower Block", "x": 21, "y": 11, "misc": 64},
        {"screen": 4, "sprite": "Pencil/Spikey", "x": 7, "y": 26, "misc": 192},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 10, "y": 14, "misc": 160},
        {"screen": 4, "sprite": "Pencil/Spikey", "x": 11, "y": 26, "misc": 192},
        {"screen": 4, "sprite": "Karakara", "x": 21, "y": 22, "misc": 64},
        {"screen": 4, "sprite": "Karakara", "x": 28, "y": 12, "misc": 192},
        {"screen": 5, "sprite": "Pencil/Spikey", "x": 1, "y": 24, "misc": 192},
        {"screen": 5, "sprite": "Star Block", "x": 5, "y": 5, "misc": 64},
        {"screen": 5, "sprite": "Masked Ghoul/Bullet Bill", "x": 26, "y": 24, "misc": 192},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 30, "y": 10, "misc": 32},
        {"screen": 6, "sprite": "Masked Ghoul/Bullet Bill", "x": 6, "y": 28, "misc": 64},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 10, "y": 22, "misc": 32},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 14, "y": 26, "misc": 32},
        {"screen": 6, "sprite": "Midway Bell", "x": 15, "y": 4, "misc": 32},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 18, "y": 10, "misc": 64},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 26, "y": 2, "misc": 64},
        {"screen": 7, "sprite": "Karakara", "x": 8, "y": 14, "misc": 160},
        {"screen": 7, "sprite": "Karakara", "x": 19, "y": 27, "misc": 192},
        {"screen": 8, "sprite": "Flower", "x": 5, "y": 4, "misc": 64},
        {"screen": 8, "sprite": "Heart Block", "x": 7, "y": 3, "misc": 64},
        {"screen": 8, "sprite": "Pencil/Spikey", "x": 11, "y": 24, "misc": 32},
        {"screen": 8, "sprite": "Money Bag Block", "x": 23, "y": 13, "misc": 64},
        {"screen": 9, "sprite": "Pencil/Spikey", "x": 9, "y": 24, "misc": 192},
        {"screen": 9, "sprite": "Pencil/Spikey", "x": 19, "y": 24, "misc": 64},
        {"screen": 10, "sprite": "Rising Platform", "x": 4, "y": 22, "misc": 64},
        {"screen": 10, "sprite": "Rising Platform", "x": 10, "y": 16, "misc": 64},
        {"screen": 10, "sprite": "Bonus Bell", "x": 21, "y": 9, "misc": 64},
        {"screen": 12, "sprite": "Pencil/Spikey", "x": 5, "y": 24, "misc": 192},
        {"screen": 12, "sprite": "Pencil/Spikey", "x": 9, "y": 24, "misc": 192},
        {"screen": 12, "sprite": "Karakara", "x": 19, "y": 24, "misc": 64},
        {"screen": 12, "sprite": "Karakara", "x": 26, "y": 28, "misc": 192},
        {"screen": 13, "sprite": "Karakara", "x": 1, "y": 26, "misc": 192},
        {"screen": 13, "sprite": "Pencil/Spikey", "x": 15, "y": 24, "misc": 64},
        {"screen": 13, "sprite": "Honebon/F Boy", "x": 24, "y": 28, "misc": 192},
        {"screen": 14, "sprite": "Pencil/Spikey", "x": 1, "y": 24, "misc": 192},
        {"screen": 14, "sprite": "Shark", "x": 14, "y": 26, "misc": 64}],
    "Turtle Zone 3": [
        {"screen": 1, "sprite": "Ragumo/Aqua Kuribo", "x": 1, "y": 26, "misc": 160},
        {"screen": 1, "sprite": "Ragumo/Aqua Kuribo", "x": 31, "y": 22, "misc": 160},
        {"screen": 2, "sprite": "Carrot Block", "x": 15, "y": 15, "misc": 32},
        {"screen": 2, "sprite": "Pencil/Spikey", "x": 29, "y": 14, "misc": 160},
        {"screen": 3, "sprite": "Pencil/Spikey", "x": 13, "y": 22, "misc": 160},
        {"screen": 3, "sprite": "Pencil/Spikey", "x": 21, "y": 26, "misc": 32},
        {"screen": 4, "sprite": "Ragumo/Aqua Kuribo", "x": 5, "y": 24, "misc": 32},
        {"screen": 5, "sprite": "Paragoomba (Vertical)", "x": 0, "y": 24, "misc": 160},
        {"screen": 5, "sprite": "Midway Bell", "x": 12, "y": 18, "misc": 32},
        {"screen": 5, "sprite": "Ragumo/Aqua Kuribo", "x": 27, "y": 20, "misc": 32},
        {"screen": 5, "sprite": "Mushroom Block", "x": 29, "y": 19, "misc": 32},
        {"screen": 6, "sprite": "Honebon/F Boy", "x": 1, "y": 30, "misc": 160},
        {"screen": 6, "sprite": "Ragumo/Aqua Kuribo", "x": 7, "y": 20, "misc": 160},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 24, "y": 20, "misc": 160},
        {"screen": 7, "sprite": "Ragumo/Aqua Kuribo", "x": 6, "y": 28, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 27, "y": 28, "misc": 160},
        {"screen": 8, "sprite": "Ragumo/Aqua Kuribo", "x": 7, "y": 28, "misc": 160},
        {"screen": 8, "sprite": "Ragumo/Aqua Kuribo", "x": 19, "y": 28, "misc": 32},
        {"screen": 9, "sprite": "Mushroom Block", "x": 17, "y": 13, "misc": 32},
        {"screen": 9, "sprite": "Honebon/F Boy", "x": 27, "y": 22, "misc": 160},
        {"screen": 9, "sprite": "Money Bag Block", "x": 29, "y": 11, "misc": 32},
        {"screen": 11, "sprite": "Paragoomba (Diagonal)", "x": 13, "y": 24, "misc": 160},
        {"screen": 11, "sprite": "Koopa Troopa", "x": 19, "y": 30, "misc": 160}],
    "Hippo Zone": [
        {"screen": 0, "sprite": "Money Bag Block", "x": 5, "y": 7, "misc": 32},
        {"screen": 0, "sprite": "Heart Block", "x": 7, "y": 5, "misc": 0},
        {"screen": 0, "sprite": "Heart Block", "x": 31, "y": 19, "misc": 32},
        {"screen": 1, "sprite": "Heart Block", "x": 1, "y": 19, "misc": 32},
        {"screen": 1, "sprite": "Bubble", "x": 6, "y": 24, "misc": 0},
        {"screen": 1, "sprite": "Mushroom Block", "x": 27, "y": 9, "misc": 32},
        {"screen": 2, "sprite": "Toriuo", "x": 11, "y": 8, "misc": 160},
        {"screen": 2, "sprite": "Unibo/Terekuribo", "x": 25, "y": 26, "misc": 128},
        {"screen": 2, "sprite": "Toriuo", "x": 29, "y": 8, "misc": 160},
        {"screen": 3, "sprite": "Toriuo", "x": 11, "y": 8, "misc": 32},
        {"screen": 3, "sprite": "Unibo/Terekuribo", "x": 17, "y": 26, "misc": 128},
        {"screen": 3, "sprite": "Heart Block", "x": 17, "y": 25, "misc": 0},
        {"screen": 4, "sprite": "Toriuo", "x": 3, "y": 8, "misc": 160},
        {"screen": 4, "sprite": "Unibo/Terekuribo", "x": 9, "y": 26, "misc": 128},
        {"screen": 4, "sprite": "Toriuo", "x": 21, "y": 8, "misc": 32},
        {"screen": 5, "sprite": "Horizontal Blurp", "x": 6, "y": 10, "misc": 160},
        {"screen": 5, "sprite": "Mushroom Block", "x": 13, "y": 11, "misc": 32},
        {"screen": 5, "sprite": "Horizontal Blurp", "x": 19, "y": 12, "misc": 32},
        {"screen": 5, "sprite": "Unibo/Terekuribo", "x": 25, "y": 10, "misc": 128},
        {"screen": 5, "sprite": "Unibo/Terekuribo", "x": 27, "y": 18, "misc": 0},
        {"screen": 6, "sprite": "Unibo/Terekuribo", "x": 7, "y": 22, "misc": 128},
        {"screen": 6, "sprite": "Unibo/Terekuribo", "x": 11, "y": 12, "misc": 128},
        {"screen": 6, "sprite": "Horizontal Blurp", "x": 13, "y": 14, "misc": 160},
        {"screen": 6, "sprite": "Bubble", "x": 14, "y": 30, "misc": 0},
        {"screen": 7, "sprite": "Dondon", "x": 13, "y": 10, "misc": 128},
        {"screen": 7, "sprite": "Dondon", "x": 15, "y": 18, "misc": 128},
        {"screen": 7, "sprite": "Dondon", "x": 17, "y": 26, "misc": 0},
        {"screen": 7, "sprite": "Toriuo", "x": 25, "y": 8, "misc": 160},
        {"screen": 8, "sprite": "Toriuo", "x": 5, "y": 8, "misc": 160},
        {"screen": 8, "sprite": "Flower Block", "x": 19, "y": 25, "misc": 0},
        {"screen": 8, "sprite": "Toriuo", "x": 21, "y": 8, "misc": 160},
        {"screen": 8, "sprite": "Toriuo", "x": 31, "y": 8, "misc": 32},
        {"screen": 9, "sprite": "Money Bag Block", "x": 11, "y": 5, "misc": 0},
        {"screen": 9, "sprite": "Horizontal Blurp", "x": 15, "y": 12, "misc": 160},
        {"screen": 9, "sprite": "Horizontal Blurp", "x": 27, "y": 10, "misc": 160},
        {"screen": 10, "sprite": "Dondon", "x": 9, "y": 14, "misc": 0},
        {"screen": 10, "sprite": "Dondon", "x": 13, "y": 24, "misc": 0},
        {"screen": 10, "sprite": "Toriuo", "x": 19, "y": 8, "misc": 32},
        {"screen": 11, "sprite": "Bonus Bell", "x": 21, "y": 5, "misc": 0}],
    "Space Zone 1": [
        {"screen": 1, "sprite": "Boo/Bomubomu", "x": 19, "y": 26, "misc": 160},
        {"screen": 2, "sprite": "Boo/Bomubomu", "x": 3, "y": 26, "misc": 160},
        {"screen": 3, "sprite": "Boo/Bomubomu", "x": 5, "y": 26, "misc": 160},
        {"screen": 3, "sprite": "Rerere/Poro", "x": 25, "y": 5, "misc": 160},
        {"screen": 4, "sprite": "Money Bag Block", "x": 9, "y": 21, "misc": 0},
        {"screen": 4, "sprite": "Money Bag Block", "x": 11, "y": 29, "misc": 0},
        {"screen": 4, "sprite": "Heart", "x": 13, "y": 6, "misc": 32},
        {"screen": 4, "sprite": "Mushroom Block", "x": 23, "y": 15, "misc": 32},
        {"screen": 5, "sprite": "No 48/Mogyo", "x": 1, "y": 21, "misc": 32},
        {"screen": 5, "sprite": "Heart", "x": 5, "y": 16, "misc": 0},
        {"screen": 5, "sprite": "Boo/Bomubomu", "x": 23, "y": 28, "misc": 160},
        {"screen": 6, "sprite": "Rerere/Poro", "x": 18, "y": 20, "misc": 32},
        {"screen": 7, "sprite": "Flower Block", "x": 5, "y": 11, "misc": 32},
        {"screen": 7, "sprite": "Rerere/Poro", "x": 6, "y": 20, "misc": 160},
        {"screen": 7, "sprite": "Midway Bell", "x": 15, "y": 22, "misc": 32},
        {"screen": 7, "sprite": "Rerere/Poro", "x": 19, "y": 13, "misc": 32},
        {"screen": 8, "sprite": "Boo/Bomubomu", "x": 1, "y": 28, "misc": 32},
        {"screen": 8, "sprite": "Money Bag Block", "x": 7, "y": 21, "misc": 32},
        {"screen": 8, "sprite": "Boo/Bomubomu", "x": 17, "y": 28, "misc": 32},
        {"screen": 9, "sprite": "Heart Block", "x": 3, "y": 15, "misc": 0},
        {"screen": 9, "sprite": "Boo/Bomubomu", "x": 8, "y": 24, "misc": 32},
        {"screen": 9, "sprite": "Rerere/Poro", "x": 31, "y": 15, "misc": 160},
        {"screen": 10, "sprite": "Boo/Bomubomu", "x": 31, "y": 20, "misc": 32},
        {"screen": 11, "sprite": "Boo/Bomubomu", "x": 3, "y": 28, "misc": 32},
        {"screen": 11, "sprite": "Bonus Bell", "x": 21, "y": 11, "misc": 32}],
    "Space Zone 2": [
        {"screen": 2, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 5, "y": 22, "misc": 128},
        {"screen": 2, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 25, "y": 16, "misc": 128},
        {"screen": 2, "sprite": "Star (Horizontal)/Blurp (Vertical)", "x": 27, "y": 30, "misc": 128},
        {"screen": 3, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 11, "y": 10, "misc": 128},
        {"screen": 4, "sprite": "Mushroom", "x": 1, "y": 6, "misc": 0},
        {"screen": 4, "sprite": "Star (Horizontal)/Blurp (Vertical)", "x": 3, "y": 30, "misc": 128},
        {"screen": 4, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 23, "y": 26, "misc": 128},
        {"screen": 5, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 1, "y": 22, "misc": 128},
        {"screen": 5, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 9, "y": 26, "misc": 128},
        {"screen": 5, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 27, "y": 14, "misc": 0},
        {"screen": 6, "sprite": "Mushroom Block", "x": 13, "y": 15, "misc": 0},
        {"screen": 6, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 19, "y": 18, "misc": 128},
        {"screen": 7, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 13, "y": 22, "misc": 128},
        {"screen": 7, "sprite": "Mushroom Block", "x": 17, "y": 9, "misc": 0},
        {"screen": 7, "sprite": "Tosenbo/Pikku", "x": 27, "y": 24, "misc": 128},
        {"screen": 8, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 3, "y": 16, "misc": 128},
        {"screen": 9, "sprite": "Tosenbo/Pikku", "x": 3, "y": 16, "misc": 0},
        {"screen": 9, "sprite": "Tosenbo/Pikku", "x": 25, "y": 16, "misc": 0},
        {"screen": 10, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 13, "y": 16, "misc": 128},
        {"screen": 10, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 25, "y": 16, "misc": 128},
        {"screen": 11, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 15, "y": 20, "misc": 128},
        {"screen": 11, "sprite": "Star (Horizontal)/Blurp (Vertical)", "x": 25, "y": 22, "misc": 0},
        {"screen": 12, "sprite": "Star (Vertical)/Blurp (Horizontal)", "x": 5, "y": 16, "misc": 128},
        {"screen": 12, "sprite": "Mushroom Block", "x": 31, "y": 11, "misc": 0},
        {"screen": 13, "sprite": "Star Block", "x": 5, "y": 17, "misc": 0},
        {"screen": 13, "sprite": "Tosenbo/Pikku", "x": 7, "y": 17, "misc": 128},
        {"screen": 13, "sprite": "Midway Bell", "x": 19, "y": 20, "misc": 0},
        {"screen": 13, "sprite": "Mushroom", "x": 31, "y": 6, "misc": 0},
        {"screen": 15, "sprite": "Tosenbo/Pikku", "x": 1, "y": 26, "misc": 128},
        {"screen": 15, "sprite": "Mushroom Block", "x": 17, "y": 19, "misc": 0}],
    "Macro Zone 1": [
        {"screen": 1, "sprite": "Kyotonbo", "x": 1, "y": 22, "misc": 0},
        {"screen": 1, "sprite": "Goronto", "x": 23, "y": 26, "misc": 128},
        {"screen": 2, "sprite": "Moving Platform (Large, Horizontal)", "x": 20, "y": 31,
         "misc": 64}, {"screen": 3, "sprite": "Chikunto", "x": 1, "y": 16, "misc": 64},
        {"screen": 3, "sprite": "Mushroom Block", "x": 3, "y": 21, "misc": 64},
        {"screen": 4, "sprite": "Chikunto", "x": 19, "y": 28, "misc": 192},
        {"screen": 5, "sprite": "Big Diagonal Moving Platform", "x": 12, "y": 23,
         "misc": 64},
        {"screen": 5, "sprite": "Moving Platform (Large, Horizontal)", "x": 14, "y": 31,
         "misc": 64},
        {"screen": 5, "sprite": "Carrot Block", "x": 15, "y": 13, "misc": 64},
        {"screen": 6, "sprite": "Dokanto", "x": 25, "y": 28, "misc": 64},
        {"screen": 6, "sprite": "Carrot Block", "x": 31, "y": 27, "misc": 64},
        {"screen": 7, "sprite": "Kyotonbo", "x": 27, "y": 28, "misc": 64},
        {"screen": 8, "sprite": "Flower Block", "x": 1, "y": 27, "misc": 64},
        {"screen": 8, "sprite": "Chikunto", "x": 9, "y": 28, "misc": 64},
        {"screen": 9, "sprite": "Heart Block", "x": 11, "y": 27, "misc": 64},
        {"screen": 9, "sprite": "Chikunto", "x": 19, "y": 28, "misc": 192},
        {"screen": 9, "sprite": "Money Bag Block", "x": 25, "y": 27, "misc": 64},
        {"screen": 9, "sprite": "Goronto", "x": 29, "y": 28, "misc": 64},
        {"screen": 10, "sprite": "Heart Block", "x": 9, "y": 9, "misc": 32},
        {"screen": 10, "sprite": "Heart Block", "x": 13, "y": 9, "misc": 32},
        {"screen": 10, "sprite": "Midway Bell", "x": 15, "y": 26, "misc": 64},
        {"screen": 10, "sprite": "Heart Block", "x": 21, "y": 9, "misc": 32},
        {"screen": 10, "sprite": "Moving Platform (Large, Horizontal)", "x": 30, "y": 31,
         "misc": 64},
        {"screen": 11, "sprite": "Carrot Block", "x": 3, "y": 15, "misc": 64},
        {"screen": 11, "sprite": "Falling Platform", "x": 26, "y": 17, "misc": 64},
        {"screen": 12, "sprite": "Moving Platform (Large, Horizontal)", "x": 28, "y": 31,
         "misc": 64}, {"screen": 13, "sprite": "Kyotonbo", "x": 3, "y": 18, "misc": 192},
        {"screen": 13, "sprite": "Chikunto", "x": 17, "y": 28, "misc": 64},
        {"screen": 13, "sprite": "Dokanto", "x": 25, "y": 18, "misc": 64},
        {"screen": 14, "sprite": "Kyotonbo", "x": 0, "y": 28, "misc": 32},
        {"screen": 14, "sprite": "Moving Platform (Large, Horizontal)", "x": 0, "y": 31,
         "misc": 64}, {"screen": 14, "sprite": "Goronto", "x": 12, "y": 26, "misc": 32},
        {"screen": 14, "sprite": "Dokanto", "x": 19, "y": 28, "misc": 192},
        {"screen": 14, "sprite": "Flower Block", "x": 21, "y": 21, "misc": 64},
        {"screen": 15, "sprite": "Big Diagonal Moving Platform", "x": 13, "y": 21,
         "misc": 64},
        {"screen": 15, "sprite": "Bonus Bell", "x": 21, "y": 11, "misc": 64}],
    "Macro Zone 2": [
        {"screen": 1, "sprite": "Ant", "x": 10, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Mushroom Block", "x": 19, "y": 19, "misc": 32},
        {"screen": 1, "sprite": "Piranha Plant", "x": 28, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Ant", "x": 21, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Battle Beetle", "x": 23, "y": 24, "misc": 32},
        {"screen": 3, "sprite": "Ant", "x": 5, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Fire Piranha Plant", "x": 22, "y": 2, "misc": 192},
        {"screen": 4, "sprite": "Ant", "x": 8, "y": 26, "misc": 160},
        {"screen": 4, "sprite": "Fire Piranha Plant", "x": 18, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Piranha Plant", "x": 6, "y": 30, "misc": 160},
        {"screen": 5, "sprite": "Battle Beetle", "x": 16, "y": 26, "misc": 32},
        {"screen": 6, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 5, "y": 26, "misc": 192},
        {"screen": 6, "sprite": "Carrot Block", "x": 7, "y": 15, "misc": 64},
        {"screen": 6, "sprite": "Ant", "x": 16, "y": 18, "misc": 64},
        {"screen": 7, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 0, "y": 23, "misc": 192},
        {"screen": 7, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 11, "y": 28, "misc": 64},
        {"screen": 7, "sprite": "Fire Piranha Plant", "x": 30, "y": 20, "misc": 192},
        {"screen": 8, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 15, "y": 28, "misc": 64},
        {"screen": 8, "sprite": "Star Block", "x": 19, "y": 9, "misc": 64},
        {"screen": 8, "sprite": "Piranha Plant", "x": 30, "y": 22, "misc": 64},
        {"screen": 9, "sprite": "Cheep Cheep (Vertical)", "x": 11, "y": 28, "misc": 64},
        {"screen": 9, "sprite": "Cheep Cheep (Vertical)", "x": 17, "y": 28, "misc": 64},
        {"screen": 9, "sprite": "Midway Bell", "x": 31, "y": 14, "misc": 64},
        {"screen": 10, "sprite": "Ant", "x": 1, "y": 18, "misc": 64},
        {"screen": 10, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 31, "y": 28, "misc": 64},
        {"screen": 11, "sprite": "Ant", "x": 3, "y": 16, "misc": 64},
        {"screen": 11, "sprite": "Star Block", "x": 9, "y": 15, "misc": 64},
        {"screen": 11, "sprite": "Owl Platform (Horizontal)/Cheep Cheep (Horizontal)", "x": 19, "y": 15, "misc": 160},
        {"screen": 11, "sprite": "Cheep Cheep (Vertical)", "x": 21, "y": 29, "misc": 64},
        {"screen": 12, "sprite": "Be", "x": 9, "y": 14, "misc": 32},
        {"screen": 12, "sprite": "Be", "x": 21, "y": 24, "misc": 32},
        {"screen": 12, "sprite": "Be", "x": 27, "y": 24, "misc": 32},
        {"screen": 13, "sprite": "Mushroom Block", "x": 7, "y": 23, "misc": 32},
        {"screen": 13, "sprite": "Bonus Bell", "x": 21, "y": 15, "misc": 32}],
    "Macro Zone 3": [
        {"screen": 1, "sprite": "Koopa Troopa", "x": 0, "y": 26, "misc": 32},
        {"screen": 1, "sprite": "Goomba", "x": 9, "y": 22, "misc": 32},
        {"screen": 1, "sprite": "Carrot Block", "x": 17, "y": 13, "misc": 32},
        {"screen": 1, "sprite": "Goomba", "x": 23, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Goomba", "x": 4, "y": 26, "misc": 32},
        {"screen": 2, "sprite": "Goomba", "x": 29, "y": 26, "misc": 32},
        {"screen": 3, "sprite": "Piranha Plant", "x": 28, "y": 2, "misc": 64},
        {"screen": 4, "sprite": "Piranha Plant (Downward)/Grubby", "x": 4, "y": 25, "misc": 160},
        {"screen": 4, "sprite": "Goomba", "x": 14, "y": 30, "misc": 160},
        {"screen": 4, "sprite": "Goomba", "x": 30, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Piranha Plant (Downward)/Grubby", "x": 8, "y": 25, "misc": 32},
        {"screen": 5, "sprite": "Money Bag Block", "x": 11, "y": 21, "misc": 64},
        {"screen": 5, "sprite": "Honebon/F Boy", "x": 11, "y": 30, "misc": 64},
        {"screen": 5, "sprite": "Paragoomba (Diagonal)", "x": 23, "y": 28, "misc": 32},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 15, "y": 26, "misc": 64},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 23, "y": 26, "misc": 64},
        {"screen": 7, "sprite": "Mushroom Block", "x": 1, "y": 23, "misc": 64},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 11, "y": 26, "misc": 64},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 21, "y": 26, "misc": 64},
        {"screen": 8, "sprite": "Heart Block", "x": 3, "y": 5, "misc": 32},
        {"screen": 8, "sprite": "Koopa Troopa", "x": 7, "y": 26, "misc": 64},
        {"screen": 8, "sprite": "Koopa Troopa", "x": 17, "y": 26, "misc": 64},
        {"screen": 8, "sprite": "Star Block", "x": 29, "y": 23, "misc": 64},
        {"screen": 8, "sprite": "Midway Bell", "x": 31, "y": 22, "misc": 32},
        {"screen": 9, "sprite": "Be", "x": 31, "y": 18, "misc": 32},
        {"screen": 10, "sprite": "Be", "x": 11, "y": 18, "misc": 32},
        {"screen": 11, "sprite": "Piranha Plant", "x": 16, "y": 24, "misc": 160},
        {"screen": 12, "sprite": "Carrot Block", "x": 23, "y": 17, "misc": 32},
        {"screen": 13, "sprite": "Koopa Troopa", "x": 7, "y": 4, "misc": 160},
        {"screen": 13, "sprite": "Paragoomba (Vertical)", "x": 15, "y": 24, "misc": 128},
        {"screen": 13, "sprite": "Bonus Bell", "x": 23, "y": 5, "misc": 0}],
    "Macro Zone 4": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 1, "y": 23, "misc": 32},
        {"screen": 1, "sprite": "Goomba", "x": 7, "y": 28, "misc": 160},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 17, "y": 24, "misc": 32},
        {"screen": 2, "sprite": "Runaway Heart Block/Bibi", "x": 5, "y": 23, "misc": 32},
        {"screen": 3, "sprite": "Goomba", "x": 11, "y": 24, "misc": 32},
        {"screen": 3, "sprite": "Goomba", "x": 21, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Piranha Plant", "x": 6, "y": 24, "misc": 32},
        {"screen": 5, "sprite": "Piranha Plant (Downward)/Grubby", "x": 4, "y": 25, "misc": 32},
        {"screen": 5, "sprite": "Money Bag Block", "x": 11, "y": 7, "misc": 32},
        {"screen": 5, "sprite": "Carrot Block", "x": 15, "y": 23, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 19, "y": 30, "misc": 160},
        {"screen": 6, "sprite": "Goomba", "x": 7, "y": 30, "misc": 160},
        {"screen": 6, "sprite": "Goomba", "x": 11, "y": 18, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 25, "y": 30, "misc": 160},
        {"screen": 7, "sprite": "Runaway Heart Block/Bibi", "x": 5, "y": 23, "misc": 32},
        {"screen": 7, "sprite": "Fire Piranha Plant", "x": 24, "y": 30, "misc": 160},
        {"screen": 8, "sprite": "Midway Bell", "x": 3, "y": 20, "misc": 32},
        {"screen": 8, "sprite": "Piranha Plant", "x": 8, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Goomba", "x": 26, "y": 24, "misc": 32},
        {"screen": 9, "sprite": "Mushroom Block", "x": 1, "y": 11, "misc": 32},
        {"screen": 9, "sprite": "Goomba", "x": 1, "y": 20, "misc": 32},
        {"screen": 9, "sprite": "Paragoomba (Diagonal)", "x": 13, "y": 16, "misc": 160},
        {"screen": 10, "sprite": "Paragoomba (Diagonal)", "x": 29, "y": 26, "misc": 160},
        {"screen": 11, "sprite": "Paragoomba (Diagonal)", "x": 13, "y": 26, "misc": 32}],
    "Mario's Castle": [
        {"screen": 0, "sprite": "Mushroom Block", "x": 15, "y": 17, "misc": 32},
        {"screen": 1, "sprite": "Falling Bone Platform", "x": 14, "y": 27, "misc": 32},
        {"screen": 1, "sprite": "Falling Bone Platform", "x": 22, "y": 27, "misc": 32},
        {"screen": 1, "sprite": "Skull Platform", "x": 25, "y": 30, "misc": 64},
        {"screen": 1, "sprite": "Rising Bone Platform", "x": 30, "y": 28, "misc": 32},
        {"screen": 2, "sprite": "Skull Platform", "x": 5, "y": 30, "misc": 64},
        {"screen": 2, "sprite": "Falling Bone Platform", "x": 16, "y": 27, "misc": 32},
        {"screen": 2, "sprite": "Falling Bone Platform", "x": 24, "y": 27, "misc": 32},
        {"screen": 2, "sprite": "Skull Platform", "x": 29, "y": 30, "misc": 64},
        {"screen": 3, "sprite": "Rising Bone Platform", "x": 0, "y": 28, "misc": 32},
        {"screen": 3, "sprite": "Skull Platform", "x": 3, "y": 30, "misc": 64},
        {"screen": 3, "sprite": "Rising Bone Platform", "x": 18, "y": 28, "misc": 32},
        {"screen": 3, "sprite": "Skull Platform", "x": 25, "y": 30, "misc": 64},
        {"screen": 3, "sprite": "Falling Bone Platform", "x": 26, "y": 27, "misc": 32},
        {"screen": 3, "sprite": "Skull Platform", "x": 27, "y": 30, "misc": 64},
        {"screen": 4, "sprite": "Rising Bone Platform", "x": 2, "y": 28, "misc": 32},
        {"screen": 4, "sprite": "Genkottsu (1.5 Tiles)", "x": 22, "y": 31, "misc": 64},
        {"screen": 5, "sprite": "Genkottsu (2 Tiles)", "x": 6, "y": 31, "misc": 64},
        {"screen": 5, "sprite": "Karamenbo", "x": 14, "y": 20, "misc": 32},
        {"screen": 5, "sprite": "Karamenbo", "x": 20, "y": 20, "misc": 32},
        {"screen": 5, "sprite": "Genkottsu (2 Tiles)", "x": 22, "y": 31, "misc": 64},
        {"screen": 6, "sprite": "Karamenbo", "x": 1, "y": 20, "misc": 32},
        {"screen": 6, "sprite": "Karamenbo", "x": 8, "y": 20, "misc": 32},
        {"screen": 6, "sprite": "Karamenbo", "x": 21, "y": 20, "misc": 32},
        {"screen": 7, "sprite": "Propeller Platform", "x": 4, "y": 30, "misc": 64},
        {"screen": 7, "sprite": "Propeller Platform", "x": 16, "y": 30, "misc": 64},
        {"screen": 7, "sprite": "Floating Face", "x": 19, "y": 26, "misc": 32},
        {"screen": 8, "sprite": "Propeller Platform", "x": 4, "y": 30, "misc": 64},
        {"screen": 8, "sprite": "Floating Face", "x": 17, "y": 29, "misc": 32},
        {"screen": 8, "sprite": "Floating Face", "x": 17, "y": 23, "misc": 32},
        {"screen": 8, "sprite": "Propeller Platform", "x": 18, "y": 30, "misc": 64},
        {"screen": 9, "sprite": "Floating Face", "x": 15, "y": 28, "misc": 32},
        {"screen": 9, "sprite": "Floating Face", "x": 16, "y": 22, "misc": 32},
        {"screen": 10, "sprite": "Mushroom Block", "x": 1, "y": 23, "misc": 64},
        {"screen": 10, "sprite": "Spike Ball (Large)", "x": 11, "y": 28, "misc": 64},
        {"screen": 10, "sprite": "Mushroom Block", "x": 15, "y": 23, "misc": 32},
        {"screen": 10, "sprite": "Spike Ball (Small)", "x": 29, "y": 30, "misc": 64},
        {"screen": 11, "sprite": "Fire Pakkun Zo (Left)", "x": 8, "y": 28, "misc": 192},
        {"screen": 11, "sprite": "Fire Pakkun Zo (Left)", "x": 14, "y": 26, "misc": 64},
        {"screen": 11, "sprite": "Spike Ball (Large)", "x": 31, "y": 30, "misc": 192},
        {"screen": 12, "sprite": "Fire Pakkun Zo (Large)", "x": 15, "y": 26, "misc": 64},
        {"screen": 12, "sprite": "Fire Pakkun Zo (Left)", "x": 24, "y": 28, "misc": 192},
        {"screen": 13, "sprite": "Fire Pakkun Zo (Left)", "x": 0, "y": 24, "misc": 64},
        {"screen": 13, "sprite": "Fire Pakkun Zo (Left)", "x": 8, "y": 24, "misc": 64},
        {"screen": 13, "sprite": "Spike Ball (Large)", "x": 29, "y": 30, "misc": 64},
        {"screen": 14, "sprite": "Spike Ball (Small)", "x": 12, "y": 26, "misc": 192},
        {"screen": 15, "sprite": "Fire Pakkun Zo (Right)", "x": 4, "y": 16, "misc": 64},
        {"screen": 15, "sprite": "Mushroom Block", "x": 15, "y": 19, "misc": 32}],
    "Scenic Course": [
        {"screen": 1, "sprite": "Paragoomba (Diagonal)", "x": 1, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Goomba", "x": 11, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Paragoomba (Diagonal)", "x": 21, "y": 30, "misc": 32},
        {"screen": 1, "sprite": "Goomba", "x": 31, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Paragoomba (Diagonal)", "x": 9, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Mushroom Block", "x": 15, "y": 23, "misc": 32},
        {"screen": 2, "sprite": "Goomba", "x": 19, "y": 30, "misc": 32},
        {"screen": 2, "sprite": "Paragoomba (Diagonal)", "x": 29, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Paragoomba (Diagonal)", "x": 7, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Goomba", "x": 17, "y": 30, "misc": 32},
        {"screen": 3, "sprite": "Star Block", "x": 19, "y": 23, "misc": 32},
        {"screen": 3, "sprite": "Paragoomba (Diagonal)", "x": 27, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Goomba", "x": 5, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Goomba", "x": 15, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Mushroom Block", "x": 17, "y": 23, "misc": 32},
        {"screen": 4, "sprite": "Paragoomba (Diagonal)", "x": 25, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Paragoomba (Diagonal)", "x": 3, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Paragoomba (Diagonal)", "x": 13, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Goomba", "x": 17, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 1, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Paragoomba (Diagonal)", "x": 11, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 21, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Paragoomba (Diagonal)", "x": 31, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Paragoomba (Diagonal)", "x": 9, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Flower Block", "x": 11, "y": 23, "misc": 32},
        {"screen": 7, "sprite": "Paragoomba (Diagonal)", "x": 19, "y": 30, "misc": 32}],
    "Turtle Zone Secret Course": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 7, "y": 21, "misc": 32},
        {"screen": 1, "sprite": "Heart Block", "x": 27, "y": 15, "misc": 32},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 29, "y": 28, "misc": 32},
        {"screen": 3, "sprite": "Flower Block", "x": 11, "y": 21, "misc": 32},
        {"screen": 4, "sprite": "Money Bag Block", "x": 1, "y": 19, "misc": 32},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 31, "y": 28, "misc": 32},
        {"screen": 5, "sprite": "Carrot Block", "x": 15, "y": 21, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 1, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Piranha Plant", "x": 6, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Mushroom Block", "x": 19, "y": 23, "misc": 32},
        {"screen": 7, "sprite": "Flower Block", "x": 21, "y": 23, "misc": 32},
        {"screen": 7, "sprite": "Carrot Block", "x": 23, "y": 23, "misc": 32}],
    "Pumpkin Zone Secret Course 1": [
        {"screen": 0, "sprite": "Carrot Block", "x": 29, "y": 29, "misc": 0},
        {"screen": 1, "sprite": "Paragoomba (Vertical)", "x": 22, "y": 0, "misc": 32},
        {"screen": 2, "sprite": "Paragoomba (Vertical)", "x": 14, "y": 2, "misc": 32},
        {"screen": 3, "sprite": "Paragoomba (Vertical)", "x": 6, "y": 4, "misc": 32},
        {"screen": 3, "sprite": "Paragoomba (Vertical)", "x": 30, "y": 30, "misc": 0},
        {"screen": 4, "sprite": "Paragoomba (Vertical)", "x": 23, "y": 4, "misc": 32},
        {"screen": 5, "sprite": "Goomba", "x": 15, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Goomba", "x": 25, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 19, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Goomba", "x": 29, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Goomba", "x": 11, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Goomba", "x": 29, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Goomba", "x": 15, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Star", "x": 25, "y": 24, "misc": 32}],
    "Space Zone Secret Course": [
        {"screen": 2, "sprite": "Rerere/Poro", "x": 2, "y": 2, "misc": 32},
        {"screen": 3, "sprite": "Rerere/Poro", "x": 14, "y": 20, "misc": 0},
        {"screen": 4, "sprite": "Heart", "x": 3, "y": 22, "misc": 32},
        {"screen": 4, "sprite": "Heart", "x": 5, "y": 22, "misc": 32},
        {"screen": 4, "sprite": "Rerere/Poro", "x": 26, "y": 2, "misc": 32},
        {"screen": 5, "sprite": "Heart Block", "x": 21, "y": 19, "misc": 0}],
    "Tree Zone Secret Course": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 3, "y": 13, "misc": 32},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 9, "y": 24, "misc": 32},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 13, "y": 14, "misc": 32},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 25, "y": 16, "misc": 32},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 3, "y": 20, "misc": 32},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 19, "y": 22, "misc": 32},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 27, "y": 22, "misc": 32},
        {"screen": 3, "sprite": "Koopa Troopa", "x": 11, "y": 24, "misc": 32},
        {"screen": 3, "sprite": "Koopa Troopa", "x": 19, "y": 24, "misc": 32},
        {"screen": 3, "sprite": "Koopa Troopa", "x": 31, "y": 26, "misc": 32},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 9, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 17, "y": 30, "misc": 32},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 25, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 1, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 11, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 17, "y": 30, "misc": 32},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 29, "y": 30, "misc": 32},
        {"screen": 6, "sprite": "Heart Block", "x": 9, "y": 13, "misc": 32},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 17, "y": 26, "misc": 32},
        {"screen": 6, "sprite": "Koopa Troopa", "x": 27, "y": 26, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 1, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 11, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 21, "y": 30, "misc": 32},
        {"screen": 7, "sprite": "Koopa Troopa", "x": 31, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Koopa Troopa", "x": 7, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Koopa Troopa", "x": 17, "y": 30, "misc": 32},
        {"screen": 8, "sprite": "Koopa Troopa", "x": 27, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Koopa Troopa", "x": 5, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Koopa Troopa", "x": 13, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Koopa Troopa", "x": 21, "y": 30, "misc": 32},
        {"screen": 9, "sprite": "Heart Block", "x": 31, "y": 13, "misc": 32}],
    "Macro Zone Secret Course": [
        {"screen": 1, "sprite": "Mushroom Block", "x": 11, "y": 15, "misc": 32},
        {"screen": 1, "sprite": "Falling Platform", "x": 28, "y": 26, "misc": 32},
        {"screen": 2, "sprite": "Falling Platform", "x": 12, "y": 26, "misc": 32},
        {"screen": 2, "sprite": "Falling Platform", "x": 18, "y": 26, "misc": 32},
        {"screen": 3, "sprite": "Heart Block", "x": 11, "y": 21, "misc": 32},
        {"screen": 5, "sprite": "Flower Block", "x": 17, "y": 17, "misc": 32},
        {"screen": 6, "sprite": "Heart Block", "x": 25, "y": 27, "misc": 32}],
    "Pumpkin Zone Secret Course 2": [
        {"screen": 0, "sprite": "Flower Block", "x": 25, "y": 11, "misc": 0},
        {"screen": 1, "sprite": "Heart Block", "x": 9, "y": 17, "misc": 0},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 16, "y": 20, "misc": 0},
        {"screen": 1, "sprite": "Heart Block", "x": 23, "y": 15, "misc": 0},
        {"screen": 1, "sprite": "Koopa Troopa", "x": 29, "y": 20, "misc": 0},
        {"screen": 2, "sprite": "Heart Block", "x": 5, "y": 13, "misc": 0},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 13, "y": 20, "misc": 0},
        {"screen": 2, "sprite": "Goomba", "x": 21, "y": 20, "misc": 0},
        {"screen": 2, "sprite": "Koopa Troopa", "x": 31, "y": 20, "misc": 0},
        {"screen": 3, "sprite": "Heart Block", "x": 17, "y": 17, "misc": 0},
        {"screen": 3, "sprite": "Heart Block", "x": 25, "y": 13, "misc": 0},
        {"screen": 4, "sprite": "Koopa Troopa", "x": 1, "y": 20, "misc": 0},
        {"screen": 4, "sprite": "Falling Platform", "x": 18, "y": 24, "misc": 0},
        {"screen": 5, "sprite": "Falling Platform", "x": 2, "y": 22, "misc": 0},
        {"screen": 5, "sprite": "Koopa Troopa", "x": 10, "y": 22, "misc": 0},
        {"screen": 5, "sprite": "Mushroom Block", "x": 11, "y": 15, "misc": 0},
        {"screen": 5, "sprite": "Falling Platform", "x": 18, "y": 24, "misc": 0},
        {"screen": 5, "sprite": "Falling Platform", "x": 26, "y": 24, "misc": 0},
        {"screen": 6, "sprite": "Falling Platform", "x": 2, "y": 24, "misc": 0},
        {"screen": 6, "sprite": "Falling Platform", "x": 10, "y": 24, "misc": 0},
        {"screen": 6, "sprite": "Falling Platform", "x": 18, "y": 24, "misc": 0},
        {"screen": 7, "sprite": "Goomba", "x": 13, "y": 18, "misc": 0},
        {"screen": 7, "sprite": "Heart Block", "x": 15, "y": 17, "misc": 0},
        {"screen": 7, "sprite": "Goomba", "x": 29, "y": 18, "misc": 0},
        {"screen": 8, "sprite": "Heart Block", "x": 9, "y": 17, "misc": 0},
        {"screen": 8, "sprite": "Goomba", "x": 11, "y": 18, "misc": 0},
        {"screen": 8, "sprite": "Heart Block", "x": 23, "y": 17, "misc": 0},
        {"screen": 8, "sprite": "Goomba", "x": 25, "y": 18, "misc": 0},
        {"screen": 9, "sprite": "Falling Platform", "x": 12, "y": 20, "misc": 0},
        {"screen": 9, "sprite": "Heart", "x": 23, "y": 16, "misc": 0},
        {"screen": 10, "sprite": "Falling Platform", "x": 0, "y": 22, "misc": 0},
        {"screen": 10, "sprite": "Heart", "x": 17, "y": 14, "misc": 0}]}
