import typing
from BaseClasses import Item, ItemClassification


class ItemData(typing.NamedTuple):
    id: typing.Optional[int]
    classification: ItemClassification

    def is_progression(self):
        return self.classification & ItemClassification.progression == ItemClassification.progression

    def is_trap(self):
        return self.classification & ItemClassification.trap == ItemClassification.trap

    def is_filler(self):
        return self.classification & ItemClassification.filler == ItemClassification.filler


class TheBindingOfIsaacRepentanceItem(Item):
    game: str = "The Binding of Isaac Repentance"


base_id = 7880000

junk_items = {
    "Random Pickup": ItemData(base_id + 31, ItemClassification.filler),
    "Random Heart": ItemData(base_id + 32, ItemClassification.filler),
    "Random Coin": ItemData(base_id + 33, ItemClassification.filler),
    "Random Bomb": ItemData(base_id + 34, ItemClassification.filler),
    "Random Key": ItemData(base_id + 35, ItemClassification.filler),
    "Random Card": ItemData(base_id + 36, ItemClassification.filler),
    "Random Pill": ItemData(base_id + 37, ItemClassification.filler),
    "Random Chest": ItemData(base_id + 38, ItemClassification.filler),
    "Random Trinket": ItemData(base_id + 39, ItemClassification.filler),
}

trap_items = {
    "Troll Bomb Trap": ItemData(base_id + 772, ItemClassification.trap),
    "Teleport Trap": ItemData(base_id + 773, ItemClassification.trap),
    "Retro Vision Trap": ItemData(base_id + 774, ItemClassification.trap),
    "Curse Trap": ItemData(base_id + 775, ItemClassification.trap),
    "Paralysis Trap": ItemData(base_id + 776, ItemClassification.trap),
    "Wavy Cap Trap": ItemData(base_id + 777, ItemClassification.trap),
}

# 78000 - 78???
item_table = {
    # items (main)
    "Treasure Room Item": ItemData(base_id + 0, ItemClassification.progression),
    "Shop Item": ItemData(base_id + 1, ItemClassification.progression),
    "Boss Item": ItemData(base_id + 2, ItemClassification.progression),
    "Devil Deal Item": ItemData(base_id + 3, ItemClassification.progression),
    "Angel Deal Item": ItemData(base_id + 4, ItemClassification.progression),
    "Secret Room Item": ItemData(base_id + 5, ItemClassification.progression),
    "Library Item": ItemData(base_id + 6, ItemClassification.progression),
    "Curse Room Item": ItemData(base_id + 7, ItemClassification.progression),
    "Planetarium Item": ItemData(base_id + 8, ItemClassification.progression),
    # item (experimental)
    "Shell Game Item": ItemData(base_id + 9, ItemClassification.progression),
    "Golden Chest Item": ItemData(base_id + 10, ItemClassification.progression),
    "Red Chest Item": ItemData(base_id + 11, ItemClassification.progression),
    "Beggar Item": ItemData(base_id + 12, ItemClassification.progression),
    "Demon Baggar Item": ItemData(base_id + 13, ItemClassification.progression),
    "Key Master Item": ItemData(base_id + 14, ItemClassification.progression),
    "Battery Bum Item": ItemData(base_id + 15, ItemClassification.progression),
    "Mom's Chest Item": ItemData(base_id + 16, ItemClassification.progression),
    "Greed Treasure Room Item": ItemData(base_id + 17, ItemClassification.progression),
    "Greed Boss Item": ItemData(base_id + 18, ItemClassification.progression),
    "Greed Shop Item": ItemData(base_id + 19, ItemClassification.progression),
    "Greed Devil Deal Item": ItemData(base_id + 20, ItemClassification.progression),
    "Greed Angel Deal Item": ItemData(base_id + 21, ItemClassification.progression),
    "Greed Curse Room Item": ItemData(base_id + 22, ItemClassification.progression),
    "Greed Secret Room Item": ItemData(base_id + 23, ItemClassification.progression),
    "Crane Game Item": ItemData(base_id + 24, ItemClassification.progression),
    "Ultra Secret Room Item": ItemData(base_id + 25, ItemClassification.progression),
    "Bomb Bum Item": ItemData(base_id + 26, ItemClassification.progression),
    "Old Chest Item": ItemData(base_id + 27, ItemClassification.progression),
    "Baby Shop Item": ItemData(base_id + 28, ItemClassification.progression),
    "Wooden Chest Item": ItemData(base_id + 29, ItemClassification.progression),
    "Rotten Beggar Item": ItemData(base_id + 30, ItemClassification.progression),
    **junk_items,
    # all collectables -> for start inv
    "Sad Onion": ItemData(base_id + 40, ItemClassification.progression),
    "Inner Eye": ItemData(base_id + 41, ItemClassification.progression),
    "Spoon Bender": ItemData(base_id + 42, ItemClassification.progression),
    "Crickets Head": ItemData(base_id + 43, ItemClassification.progression),
    "My Reflection": ItemData(base_id + 44, ItemClassification.progression),
    "Number One": ItemData(base_id + 45, ItemClassification.progression),
    "Blood Of The Martyr": ItemData(base_id + 46, ItemClassification.progression),
    "Brother Bobby": ItemData(base_id + 47, ItemClassification.progression),
    "Skatole": ItemData(base_id + 48, ItemClassification.progression),
    "Halo Of Flies": ItemData(base_id + 49, ItemClassification.progression),
    "1up": ItemData(base_id + 50, ItemClassification.progression),
    # 78050 need alias One Up
    "Magic Mushroom": ItemData(base_id + 51, ItemClassification.progression),
    "Virus": ItemData(base_id + 52, ItemClassification.progression),
    "Roid Rage": ItemData(base_id + 53, ItemClassification.progression),
    "Heart": ItemData(base_id + 54, ItemClassification.progression),
    "Raw Liver": ItemData(base_id + 55, ItemClassification.progression),
    "Skeleton Key": ItemData(base_id + 56, ItemClassification.progression),
    "Dollar": ItemData(base_id + 57, ItemClassification.progression),
    "Boom": ItemData(base_id + 58, ItemClassification.progression),
    "Transcendence": ItemData(base_id + 59, ItemClassification.progression),
    "Compass": ItemData(base_id + 60, ItemClassification.progression),
    "Lunch": ItemData(base_id + 61, ItemClassification.progression),
    "Dinner": ItemData(base_id + 62, ItemClassification.progression),
    "Dessert": ItemData(base_id + 63, ItemClassification.progression),
    "Breakfast": ItemData(base_id + 64, ItemClassification.progression),
    "Rotten Meat": ItemData(base_id + 65, ItemClassification.progression),
    "Wooden Spoon": ItemData(base_id + 66, ItemClassification.progression),
    "Belt": ItemData(base_id + 67, ItemClassification.progression),
    "Moms Underwear": ItemData(base_id + 68, ItemClassification.progression),
    "Moms Heels": ItemData(base_id + 69, ItemClassification.progression),
    "Moms Lipstick": ItemData(base_id + 70, ItemClassification.progression),
    "Wire Coat Hanger": ItemData(base_id + 71, ItemClassification.progression),
    "Bible": ItemData(base_id + 72, ItemClassification.progression),
    "Book Of Belial": ItemData(base_id + 73, ItemClassification.progression),
    "Necronomicon": ItemData(base_id + 74, ItemClassification.progression),
    "Poop": ItemData(base_id + 75, ItemClassification.progression),
    "Mr Boom": ItemData(base_id + 76, ItemClassification.progression),
    "Tammys Head": ItemData(base_id + 77, ItemClassification.progression),
    "Moms Bra": ItemData(base_id + 78, ItemClassification.progression),
    "Kamikaze": ItemData(base_id + 79, ItemClassification.progression),
    "Moms Pad": ItemData(base_id + 80, ItemClassification.progression),
    "Bobs Rotten Head": ItemData(base_id + 81, ItemClassification.progression),
    # "Pills Here": ItemData(base_id + 82, ItemClassification.progression), #doesn't exist
    "Teleport": ItemData(base_id + 83, ItemClassification.progression),
    "Yum Heart": ItemData(base_id + 84, ItemClassification.progression),
    "Lucky Foot": ItemData(base_id + 85, ItemClassification.progression),
    "Doctors Remote": ItemData(base_id + 86, ItemClassification.progression),
    "Cupids Arrow": ItemData(base_id + 87, ItemClassification.progression),
    "Shoop Da Whoop": ItemData(base_id + 88, ItemClassification.progression),
    "Steven": ItemData(base_id + 89, ItemClassification.progression),
    "Pentagram": ItemData(base_id + 90, ItemClassification.progression),
    "Dr Fetus": ItemData(base_id + 91, ItemClassification.progression),
    "Magneto": ItemData(base_id + 92, ItemClassification.progression),
    "Treasure Map": ItemData(base_id + 93, ItemClassification.progression),
    "Moms Eye": ItemData(base_id + 94, ItemClassification.progression),
    "Lemon Mishap": ItemData(base_id + 95, ItemClassification.progression),
    "Distant Admiration": ItemData(base_id + 96, ItemClassification.progression),
    "Book Of Shadows": ItemData(base_id + 97, ItemClassification.progression),
    "Book Of Belial Passive": ItemData(base_id + 98, ItemClassification.progression),
    "Ladder": ItemData(base_id + 99, ItemClassification.progression),
    # "Tarot Card": ItemData(base_id + 100, ItemClassification.progression), # doesn't exist
    "Charm Vampire": ItemData(base_id + 101, ItemClassification.progression),
    "Battery": ItemData(base_id + 102, ItemClassification.progression),
    "Steam Sale": ItemData(base_id + 103, ItemClassification.progression),
    "Anarchist Cookbook": ItemData(base_id + 104, ItemClassification.progression),
    "Hourglass": ItemData(base_id + 105, ItemClassification.progression),
    "Sister Maggy": ItemData(base_id + 106, ItemClassification.progression),
    "Technology": ItemData(base_id + 107, ItemClassification.progression),
    "Chocolate Milk": ItemData(base_id + 108, ItemClassification.progression),
    "Growth Hormones": ItemData(base_id + 109, ItemClassification.progression),
    "Mini Mush": ItemData(base_id + 110, ItemClassification.progression),
    "Rosary": ItemData(base_id + 111, ItemClassification.progression),
    "Cube Of Meat": ItemData(base_id + 112, ItemClassification.progression),
    "Quarter": ItemData(base_id + 113, ItemClassification.progression),
    "Phd": ItemData(base_id + 114, ItemClassification.progression),
    "Xray Vision": ItemData(base_id + 115, ItemClassification.progression),
    "My Little Unicorn": ItemData(base_id + 116, ItemClassification.progression),
    "Book Of Revelations": ItemData(base_id + 117, ItemClassification.progression),
    "Mark": ItemData(base_id + 118, ItemClassification.progression),
    "Pact": ItemData(base_id + 119, ItemClassification.progression),
    "Dead Cat": ItemData(base_id + 120, ItemClassification.progression),
    "Lord Of The Pit": ItemData(base_id + 121, ItemClassification.progression),
    "The Nail": ItemData(base_id + 122, ItemClassification.progression),
    "We Need To Go Deeper": ItemData(base_id + 123, ItemClassification.progression),
    "Deck Of Cards": ItemData(base_id + 124, ItemClassification.progression),
    "Monstros Tooth": ItemData(base_id + 125, ItemClassification.progression),
    "Lokis Horns": ItemData(base_id + 126, ItemClassification.progression),
    "Little Chubby": ItemData(base_id + 127, ItemClassification.progression),
    "Spider Bite": ItemData(base_id + 128, ItemClassification.progression),
    "Small Rock": ItemData(base_id + 129, ItemClassification.progression),
    "Spelunker Hat": ItemData(base_id + 130, ItemClassification.progression),
    "Super Bandage": ItemData(base_id + 131, ItemClassification.progression),
    "Gamekid": ItemData(base_id + 132, ItemClassification.progression),
    "Sack Of Pennies": ItemData(base_id + 133, ItemClassification.progression),
    "Robo Baby": ItemData(base_id + 134, ItemClassification.progression),
    "Little Chad": ItemData(base_id + 135, ItemClassification.progression),
    "Book Of Sin": ItemData(base_id + 136, ItemClassification.progression),
    "Relic": ItemData(base_id + 137, ItemClassification.progression),
    "Little Gish": ItemData(base_id + 138, ItemClassification.progression),
    "Little Steven": ItemData(base_id + 139, ItemClassification.progression),
    "Halo": ItemData(base_id + 140, ItemClassification.progression),
    "Moms Bottle Of Pills": ItemData(base_id + 141, ItemClassification.progression),
    "Common Cold": ItemData(base_id + 142, ItemClassification.progression),
    "Parasite": ItemData(base_id + 143, ItemClassification.progression),
    "D6": ItemData(base_id + 144, ItemClassification.progression),
    "Mr Mega": ItemData(base_id + 145, ItemClassification.progression),
    "Pinking Shears": ItemData(base_id + 146, ItemClassification.progression),
    "Wafer": ItemData(base_id + 147, ItemClassification.progression),
    "Money Equals Power": ItemData(base_id + 148, ItemClassification.progression),
    "Moms Contacts": ItemData(base_id + 149, ItemClassification.progression),
    "Bean": ItemData(base_id + 150, ItemClassification.progression),
    "Guardian Angel": ItemData(base_id + 151, ItemClassification.progression),
    "Demon Baby": ItemData(base_id + 152, ItemClassification.progression),
    "Moms Knife": ItemData(base_id + 153, ItemClassification.progression),
    "Ouija Board": ItemData(base_id + 154, ItemClassification.progression),
    "9 Volt": ItemData(base_id + 155, ItemClassification.progression),
    # 78155 need alias Nine Volt
    "Dead Bird": ItemData(base_id + 156, ItemClassification.progression),
    "Brimstone": ItemData(base_id + 157, ItemClassification.progression),
    "Blood Bag": ItemData(base_id + 158, ItemClassification.progression),
    "Odd Mushroom Thin": ItemData(base_id + 159, ItemClassification.progression),
    "Odd Mushroom Large": ItemData(base_id + 160, ItemClassification.progression),
    "Whore Of Babylon": ItemData(base_id + 161, ItemClassification.progression),
    "Monster Manual": ItemData(base_id + 162, ItemClassification.progression),
    "Dead Sea Scrolls": ItemData(base_id + 163, ItemClassification.progression),
    "Bobby Bomb": ItemData(base_id + 164, ItemClassification.progression),
    "Razor Blade": ItemData(base_id + 165, ItemClassification.progression),
    "Forget Me Now": ItemData(base_id + 166, ItemClassification.progression),
    "Forever Alone": ItemData(base_id + 167, ItemClassification.progression),
    "Bucket Of Lard": ItemData(base_id + 168, ItemClassification.progression),
    "Pony": ItemData(base_id + 169, ItemClassification.progression),
    "Bomb Bag": ItemData(base_id + 170, ItemClassification.progression),
    "Lump Of Coal": ItemData(base_id + 171, ItemClassification.progression),
    "Guppys Paw": ItemData(base_id + 172, ItemClassification.progression),
    "Guppys Tail": ItemData(base_id + 173, ItemClassification.progression),
    "Iv Bag": ItemData(base_id + 174, ItemClassification.progression),
    "Best Friend": ItemData(base_id + 175, ItemClassification.progression),
    "Remote Detonator": ItemData(base_id + 176, ItemClassification.progression),
    "Stigmata": ItemData(base_id + 177, ItemClassification.progression),
    "Moms Purse": ItemData(base_id + 178, ItemClassification.progression),
    "Bobs Curse": ItemData(base_id + 179, ItemClassification.progression),
    "Pageant Boy": ItemData(base_id + 180, ItemClassification.progression),
    "Scapular": ItemData(base_id + 181, ItemClassification.progression),
    "Speed Ball": ItemData(base_id + 182, ItemClassification.progression),
    "Bum Friend": ItemData(base_id + 183, ItemClassification.progression),
    "Guppys Head": ItemData(base_id + 184, ItemClassification.progression),
    "Prayer Card": ItemData(base_id + 185, ItemClassification.progression),
    "Notched Axe": ItemData(base_id + 186, ItemClassification.progression),
    "Infestation": ItemData(base_id + 187, ItemClassification.progression),
    "Ipecac": ItemData(base_id + 188, ItemClassification.progression),
    "Tough Love": ItemData(base_id + 189, ItemClassification.progression),
    "Mulligan": ItemData(base_id + 190, ItemClassification.progression),
    "Technology 2": ItemData(base_id + 191, ItemClassification.progression),
    "Mutant Spider": ItemData(base_id + 192, ItemClassification.progression),
    "Chemical Peel": ItemData(base_id + 193, ItemClassification.progression),
    "Peeper": ItemData(base_id + 194, ItemClassification.progression),
    "Habit": ItemData(base_id + 195, ItemClassification.progression),
    "Bloody Lust": ItemData(base_id + 196, ItemClassification.progression),
    "Crystal Ball": ItemData(base_id + 197, ItemClassification.progression),
    "Spirit Of The Night": ItemData(base_id + 198, ItemClassification.progression),
    "Crack The Sky": ItemData(base_id + 199, ItemClassification.progression),
    "Ankh": ItemData(base_id + 200, ItemClassification.progression),
    "Celtic Cross": ItemData(base_id + 201, ItemClassification.progression),
    "Ghost Baby": ItemData(base_id + 202, ItemClassification.progression),
    "Candle": ItemData(base_id + 203, ItemClassification.progression),
    "Cat O Nine Tails": ItemData(base_id + 204, ItemClassification.progression),
    "D20": ItemData(base_id + 205, ItemClassification.progression),
    "Harlequin Baby": ItemData(base_id + 206, ItemClassification.progression),
    "Epic Fetus": ItemData(base_id + 207, ItemClassification.progression),
    "Polyphemus": ItemData(base_id + 208, ItemClassification.progression),
    "Daddy Longlegs": ItemData(base_id + 209, ItemClassification.progression),
    "Spider Butt": ItemData(base_id + 210, ItemClassification.progression),
    "Sacrificial Dagger": ItemData(base_id + 211, ItemClassification.progression),
    "Mitre": ItemData(base_id + 212, ItemClassification.progression),
    "Rainbow Baby": ItemData(base_id + 213, ItemClassification.progression),
    "Dads Key": ItemData(base_id + 214, ItemClassification.progression),
    "Stem Cells": ItemData(base_id + 215, ItemClassification.progression),
    "Portable Slot": ItemData(base_id + 216, ItemClassification.progression),
    "Holy Water": ItemData(base_id + 217, ItemClassification.progression),
    "Fate": ItemData(base_id + 218, ItemClassification.progression),
    "Black Bean": ItemData(base_id + 219, ItemClassification.progression),
    "White Pony": ItemData(base_id + 220, ItemClassification.progression),
    "Sacred Heart": ItemData(base_id + 221, ItemClassification.progression),
    "Tooth Picks": ItemData(base_id + 222, ItemClassification.progression),
    "Holy Grail": ItemData(base_id + 223, ItemClassification.progression),
    "Dead Dove": ItemData(base_id + 224, ItemClassification.progression),
    "Blood Rights": ItemData(base_id + 225, ItemClassification.progression),
    "Guppys Hairball": ItemData(base_id + 226, ItemClassification.progression),
    "Abel": ItemData(base_id + 227, ItemClassification.progression),
    "Smb Super Fan": ItemData(base_id + 228, ItemClassification.progression),
    "Pyro": ItemData(base_id + 229, ItemClassification.progression),
    "3 Dollar Bill": ItemData(base_id + 230, ItemClassification.progression),
    "Telepathy Book": ItemData(base_id + 231, ItemClassification.progression),
    "Meat": ItemData(base_id + 232, ItemClassification.progression),
    "Magic 8 Ball": ItemData(base_id + 233, ItemClassification.progression),
    "Moms Coin Purse": ItemData(base_id + 234, ItemClassification.progression),
    "Squeezy": ItemData(base_id + 235, ItemClassification.progression),
    "Jesus Juice": ItemData(base_id + 236, ItemClassification.progression),
    "Box": ItemData(base_id + 237, ItemClassification.progression),
    "Moms Key": ItemData(base_id + 238, ItemClassification.progression),
    "Moms Eyeshadow": ItemData(base_id + 239, ItemClassification.progression),
    "Iron Bar": ItemData(base_id + 240, ItemClassification.progression),
    "Midas Touch": ItemData(base_id + 241, ItemClassification.progression),
    "Humbleing Bundle": ItemData(base_id + 242, ItemClassification.progression),
    "Fanny Pack": ItemData(base_id + 243, ItemClassification.progression),
    "Sharp Plug": ItemData(base_id + 244, ItemClassification.progression),
    "Guillotine": ItemData(base_id + 245, ItemClassification.progression),
    "Ball Of Bandages": ItemData(base_id + 246, ItemClassification.progression),
    "Champion Belt": ItemData(base_id + 247, ItemClassification.progression),
    "Butt Bombs": ItemData(base_id + 248, ItemClassification.progression),
    "Gnawed Leaf": ItemData(base_id + 249, ItemClassification.progression),
    "Spiderbaby": ItemData(base_id + 250, ItemClassification.progression),
    "Guppys Collar": ItemData(base_id + 251, ItemClassification.progression),
    "Lost Contact": ItemData(base_id + 252, ItemClassification.progression),
    "Anemic": ItemData(base_id + 253, ItemClassification.progression),
    "Goat Head": ItemData(base_id + 254, ItemClassification.progression),
    "Ceremonial Robes": ItemData(base_id + 255, ItemClassification.progression),
    "Moms Wig": ItemData(base_id + 256, ItemClassification.progression),
    "Placenta": ItemData(base_id + 257, ItemClassification.progression),
    "Old Bandage": ItemData(base_id + 258, ItemClassification.progression),
    "Sad Bombs": ItemData(base_id + 259, ItemClassification.progression),
    "Rubber Cement": ItemData(base_id + 260, ItemClassification.progression),
    "Anti Gravity": ItemData(base_id + 261, ItemClassification.progression),
    "Pyromaniac": ItemData(base_id + 262, ItemClassification.progression),
    "Crickets Body": ItemData(base_id + 263, ItemClassification.progression),
    "Gimpy": ItemData(base_id + 264, ItemClassification.progression),
    "Black Lotus": ItemData(base_id + 265, ItemClassification.progression),
    "Piggy Bank": ItemData(base_id + 266, ItemClassification.progression),
    "Moms Perfume": ItemData(base_id + 267, ItemClassification.progression),
    "Monstros Lung": ItemData(base_id + 268, ItemClassification.progression),
    "Abaddon": ItemData(base_id + 269, ItemClassification.progression),
    "Ball Of Tar": ItemData(base_id + 270, ItemClassification.progression),
    "Stop Watch": ItemData(base_id + 271, ItemClassification.progression),
    "Tiny Planet": ItemData(base_id + 272, ItemClassification.progression),
    "Infestation 2": ItemData(base_id + 273, ItemClassification.progression),
    # "235": ItemData(base_id + 274, ItemClassification.progression), #doesn't exist
    "E Coli": ItemData(base_id + 275, ItemClassification.progression),
    "Deaths Touch": ItemData(base_id + 276, ItemClassification.progression),
    "Key Piece 1": ItemData(base_id + 277, ItemClassification.progression),
    "Key Piece 2": ItemData(base_id + 278, ItemClassification.progression),
    "Experimental Treatment": ItemData(base_id + 279, ItemClassification.progression),
    "Contract From Below": ItemData(base_id + 280, ItemClassification.progression),
    "Infamy": ItemData(base_id + 281, ItemClassification.progression),
    "Trinity Shield": ItemData(base_id + 282, ItemClassification.progression),
    "Tech 5": ItemData(base_id + 283, ItemClassification.progression),
    "20 20": ItemData(base_id + 284, ItemClassification.progression),
    "Blue Map": ItemData(base_id + 285, ItemClassification.progression),
    "Bffs": ItemData(base_id + 286, ItemClassification.progression),
    "Hive Mind": ItemData(base_id + 287, ItemClassification.progression),
    "Theres Options": ItemData(base_id + 288, ItemClassification.progression),
    "Bogo Bombs": ItemData(base_id + 289, ItemClassification.progression),
    "Starter Deck": ItemData(base_id + 290, ItemClassification.progression),
    "Little Baggy": ItemData(base_id + 291, ItemClassification.progression),
    "Magic Scab": ItemData(base_id + 292, ItemClassification.progression),
    "Blood Clot": ItemData(base_id + 293, ItemClassification.progression),
    "Screw": ItemData(base_id + 294, ItemClassification.progression),
    "Hot Bombs": ItemData(base_id + 295, ItemClassification.progression),
    "Fire Mind": ItemData(base_id + 296, ItemClassification.progression),
    "Missing No": ItemData(base_id + 297, ItemClassification.progression),
    "Dark Matter": ItemData(base_id + 298, ItemClassification.progression),
    "Black Candle": ItemData(base_id + 299, ItemClassification.progression),
    "Proptosis": ItemData(base_id + 300, ItemClassification.progression),
    "Missing Page 2": ItemData(base_id + 301, ItemClassification.progression),
    "Clear Rune": ItemData(base_id + 302, ItemClassification.progression),
    "Smart Fly": ItemData(base_id + 303, ItemClassification.progression),
    "Dry Baby": ItemData(base_id + 304, ItemClassification.progression),
    "Juicy Sack": ItemData(base_id + 305, ItemClassification.progression),
    "Robo Baby 2": ItemData(base_id + 306, ItemClassification.progression),
    "Rotten Baby": ItemData(base_id + 307, ItemClassification.progression),
    "Headless Baby": ItemData(base_id + 308, ItemClassification.progression),
    "Leech": ItemData(base_id + 309, ItemClassification.progression),
    "Mystery Sack": ItemData(base_id + 310, ItemClassification.progression),
    "Bbf": ItemData(base_id + 311, ItemClassification.progression),
    "Bobs Brain": ItemData(base_id + 312, ItemClassification.progression),
    "Best Bud": ItemData(base_id + 313, ItemClassification.progression),
    "Lil Brimstone": ItemData(base_id + 314, ItemClassification.progression),
    "Isaacs Heart": ItemData(base_id + 315, ItemClassification.progression),
    "Lil Haunt": ItemData(base_id + 316, ItemClassification.progression),
    "Dark Bum": ItemData(base_id + 317, ItemClassification.progression),
    "Big Fan": ItemData(base_id + 318, ItemClassification.progression),
    "Sissy Longlegs": ItemData(base_id + 319, ItemClassification.progression),
    "Punching Bag": ItemData(base_id + 320, ItemClassification.progression),
    "How To Jump": ItemData(base_id + 321, ItemClassification.progression),
    "D100": ItemData(base_id + 322, ItemClassification.progression),
    "D4": ItemData(base_id + 323, ItemClassification.progression),
    "D10": ItemData(base_id + 324, ItemClassification.progression),
    "Blank Card": ItemData(base_id + 325, ItemClassification.progression),
    "Book Of Secrets": ItemData(base_id + 326, ItemClassification.progression),
    "Box Of Spiders": ItemData(base_id + 327, ItemClassification.progression),
    "Red Candle": ItemData(base_id + 328, ItemClassification.progression),
    "The Jar": ItemData(base_id + 329, ItemClassification.progression),
    "Flush": ItemData(base_id + 330, ItemClassification.progression),
    "Satanic Bible": ItemData(base_id + 331, ItemClassification.progression),
    "Head Of Krampus": ItemData(base_id + 332, ItemClassification.progression),
    "Butter Bean": ItemData(base_id + 333, ItemClassification.progression),
    "Magic Fingers": ItemData(base_id + 334, ItemClassification.progression),
    "Converter": ItemData(base_id + 335, ItemClassification.progression),
    "Blue Box": ItemData(base_id + 336, ItemClassification.progression),
    "Unicorn Stump": ItemData(base_id + 337, ItemClassification.progression),
    "Taurus": ItemData(base_id + 338, ItemClassification.progression),
    "Aries": ItemData(base_id + 339, ItemClassification.progression),
    "Cancer": ItemData(base_id + 340, ItemClassification.progression),
    "Leo": ItemData(base_id + 341, ItemClassification.progression),
    "Virgo": ItemData(base_id + 342, ItemClassification.progression),
    "Libra": ItemData(base_id + 343, ItemClassification.progression),
    "Scorpio": ItemData(base_id + 344, ItemClassification.progression),
    "Sagittarius": ItemData(base_id + 345, ItemClassification.progression),
    "Capricorn": ItemData(base_id + 346, ItemClassification.progression),
    "Aquarius": ItemData(base_id + 347, ItemClassification.progression),
    "Pisces": ItemData(base_id + 348, ItemClassification.progression),
    "Eves Mascara": ItemData(base_id + 349, ItemClassification.progression),
    "Judas Shadow": ItemData(base_id + 350, ItemClassification.progression),
    "Maggys Bow": ItemData(base_id + 351, ItemClassification.progression),
    "Holy Mantle": ItemData(base_id + 352, ItemClassification.progression),
    "Thunder Thighs": ItemData(base_id + 353, ItemClassification.progression),
    "Strange Attractor": ItemData(base_id + 354, ItemClassification.progression),
    "Cursed Eye": ItemData(base_id + 355, ItemClassification.progression),
    "Mysterious Liquid": ItemData(base_id + 356, ItemClassification.progression),
    "Gemini": ItemData(base_id + 357, ItemClassification.progression),
    "Cains Other Eye": ItemData(base_id + 358, ItemClassification.progression),
    "Blue Babys Only Friend": ItemData(base_id + 359, ItemClassification.progression),
    "Samsons Chains": ItemData(base_id + 360, ItemClassification.progression),
    "Mongo Baby": ItemData(base_id + 361, ItemClassification.progression),
    "Isaacs Tears": ItemData(base_id + 362, ItemClassification.progression),
    "Undefined": ItemData(base_id + 363, ItemClassification.progression),
    "Scissors": ItemData(base_id + 364, ItemClassification.progression),
    "Breath Of Life": ItemData(base_id + 365, ItemClassification.progression),
    "Polaroid": ItemData(base_id + 366, ItemClassification.progression),
    "Negative": ItemData(base_id + 367, ItemClassification.progression),
    "Ludovico Technique": ItemData(base_id + 368, ItemClassification.progression),
    "Soy Milk": ItemData(base_id + 369, ItemClassification.progression),
    "Godhead": ItemData(base_id + 370, ItemClassification.progression),
    "Lazarus Rags": ItemData(base_id + 371, ItemClassification.progression),
    "Mind": ItemData(base_id + 372, ItemClassification.progression),
    "Body": ItemData(base_id + 373, ItemClassification.progression),
    "Soul": ItemData(base_id + 374, ItemClassification.progression),
    "Dead Onion": ItemData(base_id + 375, ItemClassification.progression),
    "Broken Watch": ItemData(base_id + 376, ItemClassification.progression),
    "Boomerang": ItemData(base_id + 377, ItemClassification.progression),
    "Safety Pin": ItemData(base_id + 378, ItemClassification.progression),
    "Caffeine Pill": ItemData(base_id + 379, ItemClassification.progression),
    "Torn Photo": ItemData(base_id + 380, ItemClassification.progression),
    "Blue Cap": ItemData(base_id + 381, ItemClassification.progression),
    "Latch Key": ItemData(base_id + 382, ItemClassification.progression),
    "Match Book": ItemData(base_id + 383, ItemClassification.progression),
    "Synthoil": ItemData(base_id + 384, ItemClassification.progression),
    "Snack": ItemData(base_id + 385, ItemClassification.progression),
    "Diplopia": ItemData(base_id + 386, ItemClassification.progression),
    "Placebo": ItemData(base_id + 387, ItemClassification.progression),
    "Wooden Nickel": ItemData(base_id + 388, ItemClassification.progression),
    "Toxic Shock": ItemData(base_id + 389, ItemClassification.progression),
    "Mega Bean": ItemData(base_id + 390, ItemClassification.progression),
    "Glass Cannon": ItemData(base_id + 391, ItemClassification.progression),
    "Bomber Boy": ItemData(base_id + 392, ItemClassification.progression),
    "Crack Jacks": ItemData(base_id + 393, ItemClassification.progression),
    "Moms Pearls": ItemData(base_id + 394, ItemClassification.progression),
    "Car Battery": ItemData(base_id + 395, ItemClassification.progression),
    "Box Of Friends": ItemData(base_id + 396, ItemClassification.progression),
    "The Wiz": ItemData(base_id + 397, ItemClassification.progression),
    "8 Inch Nails": ItemData(base_id + 398, ItemClassification.progression),
    "Incubus": ItemData(base_id + 399, ItemClassification.progression),
    "Fates Reward": ItemData(base_id + 400, ItemClassification.progression),
    "Lil Chest": ItemData(base_id + 401, ItemClassification.progression),
    "Sworn Protector": ItemData(base_id + 402, ItemClassification.progression),
    "Friend Zone": ItemData(base_id + 403, ItemClassification.progression),
    "Lost Fly": ItemData(base_id + 404, ItemClassification.progression),
    "Scatter Bombs": ItemData(base_id + 405, ItemClassification.progression),
    "Sticky Bombs": ItemData(base_id + 406, ItemClassification.progression),
    "Epiphora": ItemData(base_id + 407, ItemClassification.progression),
    "Continuum": ItemData(base_id + 408, ItemClassification.progression),
    "Mr Dolly": ItemData(base_id + 409, ItemClassification.progression),
    "Curse Of The Tower": ItemData(base_id + 410, ItemClassification.progression),
    "Charged Baby": ItemData(base_id + 411, ItemClassification.progression),
    "Dead Eye": ItemData(base_id + 412, ItemClassification.progression),
    "Holy Light": ItemData(base_id + 413, ItemClassification.progression),
    "Host Hat": ItemData(base_id + 414, ItemClassification.progression),
    "Restock": ItemData(base_id + 415, ItemClassification.progression),
    "Bursting Sack": ItemData(base_id + 416, ItemClassification.progression),
    "Number Two": ItemData(base_id + 417, ItemClassification.progression),
    "Pupula Duplex": ItemData(base_id + 418, ItemClassification.progression),
    "Pay To Play": ItemData(base_id + 419, ItemClassification.progression),
    "Edens Blessing": ItemData(base_id + 420, ItemClassification.progression),
    "Friend Ball": ItemData(base_id + 421, ItemClassification.progression),
    "Tear Detonator": ItemData(base_id + 422, ItemClassification.progression),
    "Lil Gurdy": ItemData(base_id + 423, ItemClassification.progression),
    "Bumbo": ItemData(base_id + 424, ItemClassification.progression),
    "D12": ItemData(base_id + 425, ItemClassification.progression),
    "Censer": ItemData(base_id + 426, ItemClassification.progression),
    "Key Bum": ItemData(base_id + 427, ItemClassification.progression),
    "Rune Bag": ItemData(base_id + 428, ItemClassification.progression),
    "Seraphim": ItemData(base_id + 429, ItemClassification.progression),
    "Betrayal": ItemData(base_id + 430, ItemClassification.progression),
    "Zodiac": ItemData(base_id + 431, ItemClassification.progression),
    "Serpents Kiss": ItemData(base_id + 432, ItemClassification.progression),
    "Marked": ItemData(base_id + 433, ItemClassification.progression),
    "Tech X": ItemData(base_id + 434, ItemClassification.progression),
    "Ventricle Razor": ItemData(base_id + 435, ItemClassification.progression),
    "Tractor Beam": ItemData(base_id + 436, ItemClassification.progression),
    "Gods Flesh": ItemData(base_id + 437, ItemClassification.progression),
    "Maw Of The Void": ItemData(base_id + 438, ItemClassification.progression),
    "Spear Of Destiny": ItemData(base_id + 439, ItemClassification.progression),
    "Explosivo": ItemData(base_id + 440, ItemClassification.progression),
    "Chaos": ItemData(base_id + 441, ItemClassification.progression),
    "Spider Mod": ItemData(base_id + 442, ItemClassification.progression),
    "Farting Baby": ItemData(base_id + 443, ItemClassification.progression),
    "Gb Bug": ItemData(base_id + 444, ItemClassification.progression),
    "D8": ItemData(base_id + 445, ItemClassification.progression),
    "Purity": ItemData(base_id + 446, ItemClassification.progression),
    "Athame": ItemData(base_id + 447, ItemClassification.progression),
    "Empty Vessel": ItemData(base_id + 448, ItemClassification.progression),
    "Evil Eye": ItemData(base_id + 449, ItemClassification.progression),
    "Lusty Blood": ItemData(base_id + 450, ItemClassification.progression),
    "Cambion Conception": ItemData(base_id + 451, ItemClassification.progression),
    "Immaculate Conception": ItemData(base_id + 452, ItemClassification.progression),
    "More Options": ItemData(base_id + 453, ItemClassification.progression),
    "Crown Of Light": ItemData(base_id + 454, ItemClassification.progression),
    "Deep Pockets": ItemData(base_id + 455, ItemClassification.progression),
    "Succubus": ItemData(base_id + 456, ItemClassification.progression),
    "Fruit Cake": ItemData(base_id + 457, ItemClassification.progression),
    "Teleport 2": ItemData(base_id + 458, ItemClassification.progression),
    "Black Powder": ItemData(base_id + 459, ItemClassification.progression),
    "Kidney Bean": ItemData(base_id + 460, ItemClassification.progression),
    "Glowing Hour Glass": ItemData(base_id + 461, ItemClassification.progression),
    "Circle Of Protection": ItemData(base_id + 462, ItemClassification.progression),
    "Sack Head": ItemData(base_id + 463, ItemClassification.progression),
    "Night Light": ItemData(base_id + 464, ItemClassification.progression),
    "Obsessed Fan": ItemData(base_id + 465, ItemClassification.progression),
    "Mine Crafter": ItemData(base_id + 466, ItemClassification.progression),
    "Pjs": ItemData(base_id + 467, ItemClassification.progression),
    "Head Of The Keeper": ItemData(base_id + 468, ItemClassification.progression),
    "Papa Fly": ItemData(base_id + 469, ItemClassification.progression),
    "Multidimensional Baby": ItemData(base_id + 470, ItemClassification.progression),
    "Glitter Bombs": ItemData(base_id + 471, ItemClassification.progression),
    "My Shadow": ItemData(base_id + 472, ItemClassification.progression),
    "Jar Of Flies": ItemData(base_id + 473, ItemClassification.progression),
    "Lil Loki": ItemData(base_id + 474, ItemClassification.progression),
    "Milk": ItemData(base_id + 475, ItemClassification.progression),
    "D7": ItemData(base_id + 476, ItemClassification.progression),
    "Binky": ItemData(base_id + 477, ItemClassification.progression),
    "Moms Box": ItemData(base_id + 478, ItemClassification.progression),
    "Kidney Stone": ItemData(base_id + 479, ItemClassification.progression),
    "Mega Blast": ItemData(base_id + 480, ItemClassification.progression),
    "Dark Princes Crown": ItemData(base_id + 481, ItemClassification.progression),
    "Apple": ItemData(base_id + 482, ItemClassification.progression),
    "Lead Pencil": ItemData(base_id + 483, ItemClassification.progression),
    "Dog Tooth": ItemData(base_id + 484, ItemClassification.progression),
    "Dead Tooth": ItemData(base_id + 485, ItemClassification.progression),
    "Linger Bean": ItemData(base_id + 486, ItemClassification.progression),
    "Shard Of Glass": ItemData(base_id + 487, ItemClassification.progression),
    "Metal Plate": ItemData(base_id + 488, ItemClassification.progression),
    "Eye Of Greed": ItemData(base_id + 489, ItemClassification.progression),
    "Tarot Cloth": ItemData(base_id + 490, ItemClassification.progression),
    "Varicose Veins": ItemData(base_id + 491, ItemClassification.progression),
    "Compound Fracture": ItemData(base_id + 492, ItemClassification.progression),
    "Polydactyly": ItemData(base_id + 493, ItemClassification.progression),
    "Dads Lost Coin": ItemData(base_id + 494, ItemClassification.progression),
    "Midnight Snack": ItemData(base_id + 495, ItemClassification.progression),
    "Cone Head": ItemData(base_id + 496, ItemClassification.progression),
    "Belly Button": ItemData(base_id + 497, ItemClassification.progression),
    "Sinus Infection": ItemData(base_id + 498, ItemClassification.progression),
    "Glaucoma": ItemData(base_id + 499, ItemClassification.progression),
    "Parasitoid": ItemData(base_id + 500, ItemClassification.progression),
    "Eye Of Belial": ItemData(base_id + 501, ItemClassification.progression),
    "Sulfuric Acid": ItemData(base_id + 502, ItemClassification.progression),
    "Glyph Of Balance": ItemData(base_id + 503, ItemClassification.progression),
    "Analog Stick": ItemData(base_id + 504, ItemClassification.progression),
    "Contagion": ItemData(base_id + 505, ItemClassification.progression),
    "Finger": ItemData(base_id + 506, ItemClassification.progression),
    "Shade": ItemData(base_id + 507, ItemClassification.progression),
    "Depression": ItemData(base_id + 508, ItemClassification.progression),
    "Hushy": ItemData(base_id + 509, ItemClassification.progression),
    "Lil Monstro": ItemData(base_id + 510, ItemClassification.progression),
    "King Baby": ItemData(base_id + 511, ItemClassification.progression),
    "Big Chubby": ItemData(base_id + 512, ItemClassification.progression),
    "Broken Glass Cannon": ItemData(base_id + 513, ItemClassification.progression),
    "Plan C": ItemData(base_id + 514, ItemClassification.progression),
    "D1": ItemData(base_id + 515, ItemClassification.progression),
    "Void": ItemData(base_id + 516, ItemClassification.progression),
    "Pause": ItemData(base_id + 517, ItemClassification.progression),
    "Smelter": ItemData(base_id + 518, ItemClassification.progression),
    "Compost": ItemData(base_id + 519, ItemClassification.progression),
    "Dataminer": ItemData(base_id + 520, ItemClassification.progression),
    "Clicker": ItemData(base_id + 521, ItemClassification.progression),
    "Mama Mega": ItemData(base_id + 522, ItemClassification.progression),
    "Wait What": ItemData(base_id + 523, ItemClassification.progression),
    "Crooked Penny": ItemData(base_id + 524, ItemClassification.progression),
    "Dull Razor": ItemData(base_id + 525, ItemClassification.progression),
    "Potato Peeler": ItemData(base_id + 526, ItemClassification.progression),
    "Metronome": ItemData(base_id + 527, ItemClassification.progression),
    "D Infinity": ItemData(base_id + 528, ItemClassification.progression),
    "Edens Soul": ItemData(base_id + 529, ItemClassification.progression),
    "Acid Baby": ItemData(base_id + 530, ItemClassification.progression),
    "Yo Listen": ItemData(base_id + 531, ItemClassification.progression),
    "Adrenaline": ItemData(base_id + 532, ItemClassification.progression),
    "Jacobs Ladder": ItemData(base_id + 533, ItemClassification.progression),
    "Ghost Pepper": ItemData(base_id + 534, ItemClassification.progression),
    "Euthanasia": ItemData(base_id + 535, ItemClassification.progression),
    "Camo Undies": ItemData(base_id + 536, ItemClassification.progression),
    "Duality": ItemData(base_id + 537, ItemClassification.progression),
    "Eucharist": ItemData(base_id + 538, ItemClassification.progression),
    "Sack Of Sacks": ItemData(base_id + 539, ItemClassification.progression),
    "Greeds Gullet": ItemData(base_id + 540, ItemClassification.progression),
    "Large Zit": ItemData(base_id + 541, ItemClassification.progression),
    "Little Horn": ItemData(base_id + 542, ItemClassification.progression),
    "Brown Nugget": ItemData(base_id + 543, ItemClassification.progression),
    "Poke Go": ItemData(base_id + 544, ItemClassification.progression),
    "Backstabber": ItemData(base_id + 545, ItemClassification.progression),
    "Sharp Straw": ItemData(base_id + 546, ItemClassification.progression),
    "Moms Razor": ItemData(base_id + 547, ItemClassification.progression),
    "Bloodshot Eye": ItemData(base_id + 548, ItemClassification.progression),
    "Delirious": ItemData(base_id + 549, ItemClassification.progression),
    "Angry Fly": ItemData(base_id + 550, ItemClassification.progression),
    "Black Hole": ItemData(base_id + 551, ItemClassification.progression),
    "Bozo": ItemData(base_id + 552, ItemClassification.progression),
    "Broken Modem": ItemData(base_id + 553, ItemClassification.progression),
    "Mystery Gift": ItemData(base_id + 554, ItemClassification.progression),
    "Sprinkler": ItemData(base_id + 555, ItemClassification.progression),
    "Fast Bombs": ItemData(base_id + 556, ItemClassification.progression),
    "Buddy In A Box": ItemData(base_id + 557, ItemClassification.progression),
    "Lil Delirium": ItemData(base_id + 558, ItemClassification.progression),
    "Jumper Cables": ItemData(base_id + 559, ItemClassification.progression),
    "Coupon": ItemData(base_id + 560, ItemClassification.progression),
    "Telekinesis": ItemData(base_id + 561, ItemClassification.progression),
    "Moving Box": ItemData(base_id + 562, ItemClassification.progression),
    "Technology Zero": ItemData(base_id + 563, ItemClassification.progression),
    "Leprosy": ItemData(base_id + 564, ItemClassification.progression),
    "7 Seals": ItemData(base_id + 565, ItemClassification.progression),
    "Mr Me": ItemData(base_id + 566, ItemClassification.progression),
    "Angelic Prism": ItemData(base_id + 567, ItemClassification.progression),
    "Pop": ItemData(base_id + 568, ItemClassification.progression),
    "Deaths List": ItemData(base_id + 569, ItemClassification.progression),
    "Haemolacria": ItemData(base_id + 570, ItemClassification.progression),
    "Lachryphagy": ItemData(base_id + 571, ItemClassification.progression),
    "Trisagion": ItemData(base_id + 572, ItemClassification.progression),
    "Schoolbag": ItemData(base_id + 573, ItemClassification.progression),
    "Blanket": ItemData(base_id + 574, ItemClassification.progression),
    "Sacrificial Altar": ItemData(base_id + 575, ItemClassification.progression),
    "Lil Spewer": ItemData(base_id + 576, ItemClassification.progression),
    "Marbles": ItemData(base_id + 577, ItemClassification.progression),
    "Mystery Egg": ItemData(base_id + 578, ItemClassification.progression),
    "Flat Stone": ItemData(base_id + 579, ItemClassification.progression),
    "Marrow": ItemData(base_id + 580, ItemClassification.progression),
    "Slipped Rib": ItemData(base_id + 581, ItemClassification.progression),
    "Hallowed Ground": ItemData(base_id + 582, ItemClassification.progression),
    "Pointy Rib": ItemData(base_id + 583, ItemClassification.progression),
    "Book Of The Dead": ItemData(base_id + 584, ItemClassification.progression),
    "Dads Ring": ItemData(base_id + 585, ItemClassification.progression),
    "Divorce Papers": ItemData(base_id + 586, ItemClassification.progression),
    "Jaw Bone": ItemData(base_id + 587, ItemClassification.progression),
    "Brittle Bones": ItemData(base_id + 588, ItemClassification.progression),
    "Broken Shovel 1": ItemData(base_id + 589, ItemClassification.progression),
    "Broken Shovel 2": ItemData(base_id + 590, ItemClassification.progression),
    "Moms Shovel": ItemData(base_id + 591, ItemClassification.progression),
    "Mucormycosis": ItemData(base_id + 592, ItemClassification.progression),
    "2spooky": ItemData(base_id + 593, ItemClassification.progression),
    "Golden Razor": ItemData(base_id + 594, ItemClassification.progression),
    "Sulfur": ItemData(base_id + 595, ItemClassification.progression),
    "Fortune Cookie": ItemData(base_id + 596, ItemClassification.progression),
    "Eye Sore": ItemData(base_id + 597, ItemClassification.progression),
    "120 Volt": ItemData(base_id + 598, ItemClassification.progression),
    "It Hurts": ItemData(base_id + 599, ItemClassification.progression),
    "Almond Milk": ItemData(base_id + 600, ItemClassification.progression),
    "Rock Bottom": ItemData(base_id + 601, ItemClassification.progression),
    "Nancy Bombs": ItemData(base_id + 602, ItemClassification.progression),
    "Bar Of Soap": ItemData(base_id + 603, ItemClassification.progression),
    "Blood Puppy": ItemData(base_id + 604, ItemClassification.progression),
    "Dream Catcher": ItemData(base_id + 605, ItemClassification.progression),
    "Paschal Candle": ItemData(base_id + 606, ItemClassification.progression),
    "Divine Intervention": ItemData(base_id + 607, ItemClassification.progression),
    "Blood Oath": ItemData(base_id + 608, ItemClassification.progression),
    "Playdough Cookie": ItemData(base_id + 609, ItemClassification.progression),
    "Socks": ItemData(base_id + 610, ItemClassification.progression),
    "Eye Of The Occult": ItemData(base_id + 611, ItemClassification.progression),
    "Immaculate Heart": ItemData(base_id + 612, ItemClassification.progression),
    "Monstrance": ItemData(base_id + 613, ItemClassification.progression),
    "Intruder": ItemData(base_id + 614, ItemClassification.progression),
    "Dirty Mind": ItemData(base_id + 615, ItemClassification.progression),
    "Damocles": ItemData(base_id + 616, ItemClassification.progression),
    "Free Lemonade": ItemData(base_id + 617, ItemClassification.progression),
    "Spirit Sword": ItemData(base_id + 618, ItemClassification.progression),
    "Red Key": ItemData(base_id + 619, ItemClassification.progression),
    "Psy Fly": ItemData(base_id + 620, ItemClassification.progression),
    "Wavy Cap": ItemData(base_id + 621, ItemClassification.progression),
    "Rocket In A Jar": ItemData(base_id + 622, ItemClassification.progression),
    "Book Of Virtues": ItemData(base_id + 623, ItemClassification.progression),
    "Alabaster Box": ItemData(base_id + 624, ItemClassification.progression),
    "Stairway": ItemData(base_id + 625, ItemClassification.progression),
    "Sol": ItemData(base_id + 627, ItemClassification.progression),
    "Luna": ItemData(base_id + 628, ItemClassification.progression),
    "Mercurius": ItemData(base_id + 629, ItemClassification.progression),
    "Venus": ItemData(base_id + 630, ItemClassification.progression),
    "Terra": ItemData(base_id + 631, ItemClassification.progression),
    "Mars": ItemData(base_id + 632, ItemClassification.progression),
    "Jupiter": ItemData(base_id + 633, ItemClassification.progression),
    "Saturnus": ItemData(base_id + 634, ItemClassification.progression),
    "Uranus": ItemData(base_id + 635, ItemClassification.progression),
    "Neptunus": ItemData(base_id + 636, ItemClassification.progression),
    "Pluto": ItemData(base_id + 637, ItemClassification.progression),
    "Voodoo Head": ItemData(base_id + 638, ItemClassification.progression),
    "Eye Drops": ItemData(base_id + 639, ItemClassification.progression),
    "Act Of Contrition": ItemData(base_id + 640, ItemClassification.progression),
    "Member Card": ItemData(base_id + 641, ItemClassification.progression),
    "Battery Pack": ItemData(base_id + 642, ItemClassification.progression),
    "Moms Bracelet": ItemData(base_id + 643, ItemClassification.progression),
    "Scooper": ItemData(base_id + 644, ItemClassification.progression),
    "Ocular Rift": ItemData(base_id + 645, ItemClassification.progression),
    "Boiled Baby": ItemData(base_id + 646, ItemClassification.progression),
    "Freezer Baby": ItemData(base_id + 647, ItemClassification.progression),
    "Eternal D6": ItemData(base_id + 648, ItemClassification.progression),
    "Bird Cage": ItemData(base_id + 649, ItemClassification.progression),
    "Larynx": ItemData(base_id + 650, ItemClassification.progression),
    "Lost Soul": ItemData(base_id + 651, ItemClassification.progression),
    "Blood Bombs": ItemData(base_id + 653, ItemClassification.progression),
    "Lil Dumpy": ItemData(base_id + 654, ItemClassification.progression),
    "Birds Eye": ItemData(base_id + 655, ItemClassification.progression),
    "Lodestone": ItemData(base_id + 656, ItemClassification.progression),
    "Rotten Tomato": ItemData(base_id + 657, ItemClassification.progression),
    "Birthright": ItemData(base_id + 658, ItemClassification.progression),
    "Red Stew": ItemData(base_id + 660, ItemClassification.progression),
    "Genesis": ItemData(base_id + 661, ItemClassification.progression),
    "Sharp Key": ItemData(base_id + 662, ItemClassification.progression),
    "Booster Pack": ItemData(base_id + 663, ItemClassification.progression),
    "Mega Mush": ItemData(base_id + 664, ItemClassification.progression),
    "Knife Piece 1": ItemData(base_id + 665, ItemClassification.progression),
    "Knife Piece 2": ItemData(base_id + 666, ItemClassification.progression),
    "Death Certificate": ItemData(base_id + 667, ItemClassification.progression),
    "Bot Fly": ItemData(base_id + 668, ItemClassification.progression),
    "Meat Cleaver": ItemData(base_id + 670, ItemClassification.progression),
    "Evil Charm": ItemData(base_id + 671, ItemClassification.progression),
    "Dogma": ItemData(base_id + 672, ItemClassification.progression),
    "Purgatory": ItemData(base_id + 673, ItemClassification.progression),
    "Stitches": ItemData(base_id + 674, ItemClassification.progression),
    "R Key": ItemData(base_id + 675, ItemClassification.progression),
    "Knockout Drops": ItemData(base_id + 676, ItemClassification.progression),
    "Eraser": ItemData(base_id + 677, ItemClassification.progression),
    "Yuck Heart": ItemData(base_id + 678, ItemClassification.progression),
    "Urn Of Souls": ItemData(base_id + 679, ItemClassification.progression),
    "Akeldama": ItemData(base_id + 680, ItemClassification.progression),
    "Magic Skin": ItemData(base_id + 681, ItemClassification.progression),
    "Revelation": ItemData(base_id + 682, ItemClassification.progression),
    "Consolation Prize": ItemData(base_id + 683, ItemClassification.progression),
    "Tinytoma": ItemData(base_id + 684, ItemClassification.progression),
    "Brimstone Bombs": ItemData(base_id + 685, ItemClassification.progression),
    "4 5 Volt": ItemData(base_id + 686, ItemClassification.progression),
    "Fruity Plum": ItemData(base_id + 688, ItemClassification.progression),
    "Plum Flute": ItemData(base_id + 689, ItemClassification.progression),
    "Star Of Bethlehem": ItemData(base_id + 690, ItemClassification.progression),
    "Cube Baby": ItemData(base_id + 691, ItemClassification.progression),
    "Vade Retro": ItemData(base_id + 692, ItemClassification.progression),
    "False Phd": ItemData(base_id + 693, ItemClassification.progression),
    "Spin To Win": ItemData(base_id + 694, ItemClassification.progression),
    "Damocles Passive": ItemData(base_id + 695, ItemClassification.progression),
    "Vasculitis": ItemData(base_id + 696, ItemClassification.progression),
    "Giant Cell": ItemData(base_id + 697, ItemClassification.progression),
    "Tropicamide": ItemData(base_id + 698, ItemClassification.progression),
    "Card Reading": ItemData(base_id + 699, ItemClassification.progression),
    "Quints": ItemData(base_id + 700, ItemClassification.progression),
    "Tooth And Nail": ItemData(base_id + 702, ItemClassification.progression),
    "Binge Eater": ItemData(base_id + 703, ItemClassification.progression),
    "Guppys Eye": ItemData(base_id + 704, ItemClassification.progression),
    "Straw Man": ItemData(base_id + 706, ItemClassification.progression),
    "Dads Note": ItemData(base_id + 707, ItemClassification.progression),
    "Sausage": ItemData(base_id + 708, ItemClassification.progression),
    "Options": ItemData(base_id + 709, ItemClassification.progression),
    "Candy Heart": ItemData(base_id + 710, ItemClassification.progression),
    "Pound Of Flesh": ItemData(base_id + 711, ItemClassification.progression),
    "Redemption": ItemData(base_id + 712, ItemClassification.progression),
    "Spirit Shackles": ItemData(base_id + 713, ItemClassification.progression),
    "Cracked Orb": ItemData(base_id + 714, ItemClassification.progression),
    "Empty Heart": ItemData(base_id + 715, ItemClassification.progression),
    "Astral Projection": ItemData(base_id + 716, ItemClassification.progression),
    "C Section": ItemData(base_id + 717, ItemClassification.progression),
    "Lil Abaddon": ItemData(base_id + 718, ItemClassification.progression),
    "Montezumas Revenge": ItemData(base_id + 719, ItemClassification.progression),
    "Lil Portal": ItemData(base_id + 720, ItemClassification.progression),
    "Worm Friend": ItemData(base_id + 721, ItemClassification.progression),
    "Bone Spurs": ItemData(base_id + 722, ItemClassification.progression),
    "Hungry Soul": ItemData(base_id + 723, ItemClassification.progression),
    "Jar Of Wisps": ItemData(base_id + 724, ItemClassification.progression),
    "Soul Locket": ItemData(base_id + 725, ItemClassification.progression),
    "Friend Finder": ItemData(base_id + 726, ItemClassification.progression),
    "Inner Child": ItemData(base_id + 727, ItemClassification.progression),
    "Glitched Crown": ItemData(base_id + 728, ItemClassification.progression),
    "Jelly Belly": ItemData(base_id + 729, ItemClassification.progression),
    "Sacred Orb": ItemData(base_id + 730, ItemClassification.progression),
    "Sanguine Bond": ItemData(base_id + 731, ItemClassification.progression),
    "Swarm": ItemData(base_id + 732, ItemClassification.progression),
    "Heartbreak": ItemData(base_id + 733, ItemClassification.progression),
    "Bloody Gust": ItemData(base_id + 734, ItemClassification.progression),
    "Salvation": ItemData(base_id + 735, ItemClassification.progression),
    "Vanishing Twin": ItemData(base_id + 736, ItemClassification.progression),
    "Twisted Pair": ItemData(base_id + 737, ItemClassification.progression),
    "Azazels Rage": ItemData(base_id + 738, ItemClassification.progression),
    "Echo Chamber": ItemData(base_id + 739, ItemClassification.progression),
    "Isaacs Tomb": ItemData(base_id + 740, ItemClassification.progression),
    "Vengeful Spirit": ItemData(base_id + 741, ItemClassification.progression),
    "Esau Jr": ItemData(base_id + 742, ItemClassification.progression),
    "Berserk": ItemData(base_id + 743, ItemClassification.progression),
    "Dark Arts": ItemData(base_id + 744, ItemClassification.progression),
    "Abyss": ItemData(base_id + 745, ItemClassification.progression),
    "Supper": ItemData(base_id + 746, ItemClassification.progression),
    "Stapler": ItemData(base_id + 747, ItemClassification.progression),
    "Suplex": ItemData(base_id + 748, ItemClassification.progression),
    "Bag Of Crafting": ItemData(base_id + 749, ItemClassification.progression),
    "Flip": ItemData(base_id + 750, ItemClassification.progression),
    "Lemegeton": ItemData(base_id + 751, ItemClassification.progression),
    "Sumptorium": ItemData(base_id + 752, ItemClassification.progression),
    "Recall": ItemData(base_id + 753, ItemClassification.progression),
    "Hold": ItemData(base_id + 754, ItemClassification.progression),
    "Keepers Sack": ItemData(base_id + 755, ItemClassification.progression),
    "Keepers Kin": ItemData(base_id + 756, ItemClassification.progression),
    "Keepers Box": ItemData(base_id + 758, ItemClassification.progression),
    "Everything Jar": ItemData(base_id + 759, ItemClassification.progression),
    "Tmtrainer": ItemData(base_id + 760, ItemClassification.progression),
    "Anima Sola": ItemData(base_id + 761, ItemClassification.progression),
    "Spindown Dice": ItemData(base_id + 762, ItemClassification.progression),
    "Hypercoagulation": ItemData(base_id + 763, ItemClassification.progression),
    "Ibs": ItemData(base_id + 764, ItemClassification.progression),
    "Hemoptysis": ItemData(base_id + 765, ItemClassification.progression),
    "Ghost Bombs": ItemData(base_id + 766, ItemClassification.progression),
    "Gello": ItemData(base_id + 767, ItemClassification.progression),
    "Decap Attack": ItemData(base_id + 768, ItemClassification.progression),
    "Glass Eye": ItemData(base_id + 769, ItemClassification.progression),
    "Stye": ItemData(base_id + 770, ItemClassification.progression),
    "Moms Ring": ItemData(base_id + 771, ItemClassification.progression),
    **trap_items,
    # other
    "Victory": ItemData(None, ItemClassification.progression),
}

default_trap_items_weights = {
    "Troll Bomb Trap": 20,
    "Teleport Trap": 20,
    "Retro Vision Trap": 20,
    "Curse Trap": 20,
    "Paralysis Trap": 20,
    "Wavy Cap Trap": 20
}

default_junk_items_weights = {
    "Random Pickup": 0,
    "Random Heart": 5,
    "Random Coin": 6,
    "Random Bomb": 5,
    "Random Key": 5,
    "Random Card": 3,
    "Random Pill": 3,
    "Random Chest": 2,
    "Random Trinket": 1,
}

default_weights = {
    "Treasure Room Item": 15,  # 15->20%
    "Shop Item": 15,  # 15->20%
    "Boss Item": 12,  # 12->15%
    "Devil Deal Item": 6,  # 7->7%
    "Angel Deal Item": 6,  # 7->7%
    "Secret Room Item": 8,  # 9->10%
    "Library Item": 1,  # 6->1%
    "Curse Room Item": 4,  # 6->5%
    "Planetarium Item": 1,  # 1->1%
    "Golden Chest Item": 8,  # 9->10%
    "Red Chest Item": 1,  # 9->1%
}

lookup_id_to_name: typing.Dict[int, str] = {data.id: name for name, data in item_table.items() if data.id}
