"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Switches import Switches
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.FungiForest,
        name="Mushroom near DK portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2436, 440, 1860]],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.FungiForest,
        name="Mushroom by pink tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2210, 460, 2047]],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.FungiForest,
        name="Mushroom with vines leading to other mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2053, 430, 2334]],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.FungiForest,
        name="Other mushroom whose vines lead to",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2178, 390, 2718]],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.FungiForest,
        name="Mushroom with vines leading to minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2573, 410, 2733]],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.FungiForest,
        name="On vines between two shrooms",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: (l.can_use_vines and l.climbing) or (l.jetpack and l.isdiddy),
        locations=[[5, 1.2, 2140, 430, 2619], [5, 1.2, 2078, 445, 2434]],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.FungiForest,
        name="Vines to minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: (l.can_use_vines and l.climbing) or (l.jetpack and l.isdiddy),
        locations=[
            [1, 1.2, 2489, 428, 2813],
            [1, 1.2, 2410, 415, 2895],
            [1, 1.2, 2348, 410, 2962],
            [1, 1.2, 2289, 405, 3024],
            [1, 1.2, 2226, 405, 3088],
        ],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.FungiForest,
        name="Around the roof of minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: ((l.can_use_vines or l.CanMoonkick()) and l.climbing) or (l.jetpack and l.isdiddy),
        locations=[
            [1, 1.0, 2092, 280, 3251],
            [1, 1.0, 2050, 280, 3192],
            [1, 1.0, 2062, 280, 3114],
            [1, 1.0, 2102, 280, 3065],
            [1, 1.0, 2166, 280, 3042],
            [1, 1.0, 2236, 277, 3056],
            [1, 1.0, 2286, 275, 3122],
            [1, 1.0, 2290, 270, 3194],
            [1, 1.0, 2239, 272, 3256],
            [1, 1.0, 2155, 273, 3278],
        ],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.FungiForest,
        name="Mushroom by blue tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 2861, 425, 2567]],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.FungiForest,
        name="Stumps leading to pendulum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2583, 335, 2283], [5, 1.0, 2608, 370, 2328], [5, 1.0, 2557, 400, 2329]],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.FungiForest,
        name="Up the pendulum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2556, 595, 2323]],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.FungiForest,
        name="Behind clock",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[
            [1, 1.0, 2343, 604, 2261],
            [1, 1.0, 2305, 604, 2296],
            [1, 1.0, 2291, 604, 2331],
            [1, 1.0, 2312, 604, 2365],
            [1, 1.0, 2343, 604, 2394],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.FungiForest,
        name="Cannon trajectory",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2784, 420, 2211], [5, 1.0, 2745, 560, 2248]],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.FungiForest,
        name="Under W2 Tag Barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2618, 385, 1966]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.FungiForest,
        name="Bouncy shroom by pink tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2047, 450, 2108]],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.FungiForest,
        name="On pink tunnel lip",
        konglist=[Kongs.diddy, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: (l.jetpack and l.isdiddy) or l.ischunky or (l.twirl and l.istiny),
        locations=[
            [1, 1.0, 1787, 302, 1933],
            [1, 1.0, 1776, 324, 1963],
            [1, 1.0, 1765, 335, 1992],
            [1, 1.0, 1754, 320, 2019],
            [1, 1.0, 1739, 302, 2043],
        ],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.FungiForest,
        name="On blue tunnel lip",
        konglist=[Kongs.diddy, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: (l.jetpack and l.isdiddy) or l.ischunky or (l.twirl and l.istiny),
        locations=[
            [1, 1.0, 3250, 287, 2555],
            [1, 1.0, 3252, 302, 2526],
            [1, 1.0, 3258, 315, 2495],
            [1, 1.0, 3267, 300, 2464],
            [1, 1.0, 3283, 283, 2439],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.FungiForest,
        name="Against the wall by the apple destination",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[
            [1, 1.0, 3281, 183, 2146],
            [1, 1.0, 3294, 182, 2097],
            [1, 1.0, 3305, 182, 2039],
            [1, 1.0, 3278, 183, 1999],
            [1, 1.0, 3252, 186, 1960],
            [1, 1.0, 3226, 188, 1908],
            [1, 1.0, 3193, 191, 1865],
            [1, 1.0, 3149, 195, 1831],
            [1, 1.0, 3094, 201, 1794],
            [1, 1.0, 3035, 206, 1756],
        ],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.FungiForest,
        name="W3 to pink tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[
            [1, 1.0, 1855, 190, 2042],
            [1, 1.0, 1899, 195, 2052],
            [1, 1.0, 1997, 210, 2112],
            [1, 1.0, 2097, 233, 2159],
            [1, 1.0, 2176, 256, 2194],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.FungiForest,
        name="W4 to Minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[
            [1, 1.0, 2491, 243, 2604],
            [1, 1.0, 2462, 221, 2661],
            [1, 1.0, 2427, 196, 2718],
            [1, 1.0, 2386, 173, 2791],
            [1, 1.0, 2336, 147, 2873],
            [1, 1.0, 2288, 122, 2960],
            [1, 1.0, 2230, 106, 3000],
            [1, 1.0, 2176, 102, 3045],
            [1, 1.0, 2278, 104, 3075],
            [1, 1.0, 2277, 100, 3149],
        ],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.FungiForest,
        name="Stump to Minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2251, 140, 3042]],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.FungiForest,
        name="Mill area - Mushroom by blue tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 3855, 370, 3045]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.FungiForest,
        name="Mushroom by Snide's",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 3657, 415, 3354]],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.FungiForest,
        name="Mushroom by Diddy's barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 3724, 425, 3881]],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.FungiForest,
        name="Mushroom by back tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 4623, 380, 4058]],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.FungiForest,
        name="Mushroom by Minecart exit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[[5, 1.0, 5001, 407, 3651]],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.FungiForest,
        name="Top of Minecart exit",
        konglist=[Kongs.tiny],
        region=Regions.MillArea,
        logic=lambda l: l.istiny and l.twirl and l.climbing,
        locations=[[5, 1.0, 5354, 395, 3644], [5, 1.0, 5331, 392, 3712]],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.FungiForest,
        name="Top of Mill (8 custom, 7 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.climbing,
        locations=[
            [1, 1.0, 4608.65478515625, 232.83334350585938, 3471.3701171875],
        ],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.FungiForest,
        name="Top of Mill (8 custom, 7 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ForestVeryTopOfMill,
        locations=[
            [1, 1.0, 4588, 462, 3493],
            [1, 1.0, 4540, 462, 3542],
            [1, 1.0, 4579, 459, 3578],
            [1, 1.0, 4537, 459, 3631],
            [1, 1.0, 4494, 459, 3671],
            [1, 1.0, 4448, 459, 3625],
            [1, 1.0, 4404, 459, 3588],
            [1, 1.0, 4490, 459, 3497],
            [1, 1.0, 4607.23486328125, 312.8333435058594, 3472.459228515625],
            [1, 1.0, 4610.38525390625, 412.8333435058594, 3471.267333984375],
        ],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.FungiForest,
        name="Top of Mill (8 custom, 7 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ForestTopOfMill,
        locations=[
            [1, 1.0, 4389.43896484375, 376.6666564941406, 3753.939208984375],
            [1, 1.0, 4120.13671875, 376.6666564941406, 3484.602294921875],
            [1, 1.0, 4214.1572265625, 376.6666564941406, 3578.652099609375],
            [1, 1.0, 4307.08740234375, 376.6666564941406, 3668.4267578125],
        ],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.FungiForest,
        name="Outside of conveyor belt (behind night gate)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: Events.Night in l.Events or l.CanPhase() or l.CanPhaseswim() or l.ledgeclip,
        locations=[[5, 1.0, 4331, 170, 3472]],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.FungiForest,
        name="W1 (1 custom, 1 Lanky bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,  # one is in FungiForestStart
        locations=[[5, 1.0, 4136, 178, 3745]],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.FungiForest,
        name="W1 (1 custom, 1 Lanky bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2721.959716796875, 299.3601989746094, 2345.412353515625]],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.FungiForest,
        name="Behind Diddy's Barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 3327, 272, 4532],
            [1, 1.0, 3286, 272, 4470],
            [1, 1.0, 3245, 272, 4408],
            [1, 1.0, 3204, 272, 4346],
            [1, 1.0, 3163, 272, 4284],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.FungiForest,
        name="Leading to Diddy barn (2 custom, 3 Diddy)",
        konglist=[Kongs.diddy, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 3447, 362, 4514],
            [1, 1.0, 3469, 332, 4556],
            [1, 1.0, 3481.006591796875, 274.3333435058594, 4574.55712890625],
            [1, 1.0, 3461.9072265625, 334.3333435058594, 4540.76025390625],
            [1, 1.0, 3435.008056640625, 371.3333435058594, 4495.05029296875],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.FungiForest,
        name="Against wall behind back tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4696, 139, 4427],
            [1, 1.0, 4748, 139, 4382],
            [1, 1.0, 4800, 139, 4337],
            [1, 1.0, 4852, 138, 4292],
            [1, 1.0, 4905, 138, 4247],
        ],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.FungiForest,
        name="Around the outside of DK's barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        locations=[
            [1, 1.0, 4477, 118, 2044],
            [1, 1.0, 4462, 115, 1880],
            [1, 1.0, 4392, 115, 1760],
            [1, 1.0, 4274, 115, 1622],
            [1, 1.0, 4174, 115, 1487],
            [1, 1.0, 4057, 115, 1382],
            [1, 1.0, 3902, 115, 1387],
            [1, 1.0, 3779, 115, 1457],
            [1, 1.0, 3636, 115, 1559],
            [1, 1.0, 3535, 115, 1628],
            [1, 1.0, 3440, 115, 1735],
            [1, 1.0, 3465, 115, 1866],
            [1, 1.0, 3522, 115, 1970],
            [1, 1.0, 3581, 115, 2115],
            [1, 1.0, 3689, 115, 2241],
            [1, 1.0, 3779, 116, 2357],
            [1, 1.0, 3868, 118, 2398],
            [1, 1.0, 3992, 118, 2371],
            [1, 1.0, 4117, 129, 2379],
            [1, 1.0, 4307, 122, 2288],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.FungiForest,
        name="Around the inside of DK's barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        locations=[
            [1, 1.0, 4071, 115, 2044],
            [1, 1.0, 4161, 115, 1983],
            [1, 1.0, 4219, 115, 1895],
            [1, 1.0, 4161, 115, 1796],
            [1, 1.0, 4105, 115, 1704],
            [1, 1.0, 4012, 115, 1625],
            [1, 1.0, 3792, 117, 1781],
            [1, 1.0, 3688, 115, 1854],
            [1, 1.0, 3735, 115, 1967],
            [1, 1.0, 3797, 115, 2057],
            [1, 1.0, 3863, 115, 2147],
            [1, 1.0, 3955, 115, 2109],
            [1, 1.0, 4099, 115, 2106],
            [1, 1.0, 4160, 115, 2201],
            [1, 1.0, 4215, 119, 2265],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.FungiForest,
        name="On thorns hedge",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineArea,
        logic=lambda l: l.strongKong,
        locations=[
            [1, 1.0, 4098, 175, 2272],
            [1, 1.0, 4030, 175, 2174],
            [1, 1.0, 3862, 210, 2273],
            [1, 1.0, 3754, 210, 2126],
            [1, 1.0, 3642, 210, 1948],
            [1, 1.0, 3547, 210, 1787],
            [1, 1.0, 3623, 210, 1720],
            [1, 1.0, 3700, 210, 1689],
            [1, 1.0, 3812, 210, 1630],
            [1, 1.0, 3902, 210, 1536],
            [1, 1.0, 4033, 210, 1475],
            [1, 1.0, 4136, 210, 1626],
            [1, 1.0, 4259, 210, 1798],
            [1, 1.0, 4352, 210, 1957],
            [1, 1.0, 4186, 178, 2077],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.FungiForest,
        name="Behind leaf wall by DK BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        locations=[[5, 1.0, 3715, 114, 1322], [5, 1.0, 3499, 115, 1461]],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.FungiForest,
        name="Apple GB T&S behind night gate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        logic=lambda l: Events.Night in l.Events or l.CanPhase(),
        locations=[[5, 1.0, 3643, 192, 913]],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.FungiForest,
        name="Around apple (1 custom, 9 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        locations=[
            [1, 1.0, 3308, 228, 730],
            [1, 1.0, 3203.807373046875, 228.1666717529297, 887.599609375],
            [1, 1.0, 3273.48046875, 228.1666717529297, 838.4252319335938],
            [1, 1.0, 3014.156982421875, 228.1666717529297, 829.3925170898438],
            [1, 1.0, 3278.467041015625, 226.1340789794922, 650.987548828125],
            [1, 1.0, 3198.622314453125, 228.1666717529297, 599.7684326171875],
            [1, 1.0, 3090.530029296875, 228.1666717529297, 607.5054321289062],
            [1, 1.0, 3105.984375, 228.1666717529297, 896.9291381835938],
            [1, 1.0, 3014.695556640625, 228.1666717529297, 654.4733276367188],
            [1, 1.0, 2962.777099609375, 226.6687774658203, 752.8132934570312],
        ],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.FungiForest,
        name="Below Mini Monkey barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        locations=[[5, 1.0, 2231, 230, 278]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.FungiForest,
        name="Inside fence around beanstalk",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        locations=[
            [1, 1.0, 2267, 233, 738],
            [1, 1.0, 2163, 233, 748],
            [1, 1.0, 2076, 233, 766],
            [1, 1.0, 2000, 234, 747],
            [1, 1.0, 1914, 234, 710],
            [1, 1.0, 1909, 233, 599],
            [1, 1.0, 1911, 233, 478],
            [1, 1.0, 2027, 228, 413],
            [1, 1.0, 2107, 228, 446],
            [1, 1.0, 2230, 228, 508],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.FungiForest,
        name="Around the outside of the fence around beanstalk",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        locations=[
            [1, 1.0, 2213, 226, 388],
            [1, 1.0, 2117, 226, 352],
            [1, 1.0, 2020, 225, 323],
            [1, 1.0, 1922, 227, 373],
            [1, 1.0, 1850, 229, 431],
            [1, 1.0, 1838, 230, 536],
            [1, 1.0, 1832, 230, 639],
            [1, 1.0, 1837, 231, 752],
            [1, 1.0, 1936, 232, 795],
            [1, 1.0, 2040, 232, 844],
            [1, 1.0, 2131, 233, 844],
            [1, 1.0, 2264, 234, 838],
            [1, 1.0, 2318, 233, 731],
            [1, 1.0, 2354, 232, 614],
            [1, 1.0, 2333, 228, 489],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.FungiForest,
        name="Below tag barrel on bouncy shroom around giant mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[[5, 1.0, 1644, 325, 955]],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.FungiForest,
        name="On mushroom near Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 650, 440, 427]],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.FungiForest,
        name="Mushroom near rocketbarrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 241, 440, 967]],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.FungiForest,
        name="Mushroom near yellow tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 546, 415, 1448]],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.FungiForest,
        name="In patch of grass near yellow tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[[5, 1.0, 151, 195, 1225], [5, 1.0, 248, 195, 1361]],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.FungiForest,
        name="In moat around giant mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.2, 1210, 100, 1362],
            [1, 1.2, 996, 105, 1464],
            [1, 1.2, 748, 102, 1466],
            [1, 1.2, 545, 100, 1319],
            [1, 1.2, 460, 100, 1123],
            [1, 1.2, 470, 100, 883],
            [1, 1.2, 595, 100, 688],
            [1, 1.2, 813, 100, 585],
            [1, 1.2, 1057, 100, 595],
            [1, 1.2, 1263, 100, 737],
        ],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.FungiForest,
        name="By middle exit of giant mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        locations=[[5, 1.0, 1083, 395, 1168]],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.FungiForest,
        name="Around Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        locations=[
            [1, 1.0, 1163, 389, 827],
            [1, 1.0, 1252, 389, 799],
            [1, 1.0, 1319, 389, 723],
            [1, 1.0, 1310, 389, 612],
            [1, 1.0, 1219, 389, 540],
            [1, 1.0, 1118, 389, 553],
            [1, 1.0, 1044, 389, 642],
            [1, 1.0, 1050, 389, 726],
            [1, 1.0, 1081, 389, 763],
            [1, 1.0, 1128, 389, 803],
        ],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.FungiForest,
        name="Behind ladder to BBlast",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        locations=[[5, 1.0, 433, 395, 890]],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.FungiForest,
        name="Behind ladder leading to Giant Mushroom middle entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        locations=[[5, 1.0, 697, 595, 1251], [5, 1.0, 757, 595, 1300]],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.FungiForest,
        name="Around baboon blast platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        locations=[
            [1, 1.0, 407, 589, 846],
            [1, 1.0, 354, 589, 843],
            [1, 1.0, 286, 589, 855],
            [1, 1.0, 237, 589, 919],
            [1, 1.0, 227, 589, 1000],
            [1, 1.0, 247, 589, 1069],
            [1, 1.0, 317, 589, 1114],
            [1, 1.0, 394, 589, 1113],
            [1, 1.0, 492, 589, 995],
            [1, 1.0, 482, 589, 912],
        ],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.FungiForest,
        name="On BBlast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        locations=[[5, 1.0, 340, 605, 951]],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.FungiForest,
        name="On path to giant mushroom middle entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMidExterior,
        locations=[[5, 1.0, 679, 785, 1312], [5, 1.0, 722, 785, 1257], [5, 1.0, 770, 785, 1193]],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.FungiForest,
        name="Entrance of Colored Slam (bright side of the mushroom)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[[5, 1.0, 844, 1260, 1423]],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.FungiForest,
        name="Each side of back T&S on top of giant mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[[5, 1.0, 1157, 1260, 1305], [5, 1.0, 1226, 1260, 1206]],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.FungiForest,
        name="Just off the edge by Face Puzzle entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[[5, 1.0, 1400, 1260, 828]],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.FungiForest,
        name="Entrance of Zinger bounce (dark side of the mushroom)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[[5, 1.0, 966, 1260, 616]],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.FungiForest,
        name="Behind night ladder on top of giant mushroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[
            [1, 1.0, 1243, 1250, 1447],
            [1, 1.0, 1332, 1250, 1442],
            [1, 1.0, 1386, 1250, 1412],
            [1, 1.0, 1409, 1250, 1347],
            [1, 1.0, 1389, 1250, 1261],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.FungiForest,
        name="By battle arena on little outcrop",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[[5, 1.0, 1130, 1090, 1203]],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.FungiForest,
        name="Around battle crown platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        locations=[
            [1, 1.0, 1218, 1079, 1203],
            [1, 1.0, 1264, 1079, 1191],
            [1, 1.0, 1339, 1079, 1196],
            [1, 1.0, 1405, 1079, 1264],
            [1, 1.0, 1407, 1079, 1370],
            [1, 1.0, 1349, 1079, 1449],
            [1, 1.0, 1258, 1079, 1465],
            [1, 1.0, 1200, 1079, 1428],
            [1, 1.0, 1149, 1079, 1367],
            [1, 1.0, 1149, 1079, 1264],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.FungiForest,
        name="Around Lanky switch on top of giant mushroom",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.MushroomUpperExterior,
        logic=lambda l: (l.handstand and l.islanky) or (l.jetpack and l.isdiddy),
        locations=[
            [1, 1.0, 980, 1500, 980],
            [1, 1.0, 945, 1500, 949],
            [1, 1.0, 920, 1500, 945],
            [1, 1.0, 872, 1500, 958],
            [1, 1.0, 825, 1500, 992],
            [1, 1.0, 823, 1500, 1040],
            [1, 1.0, 865, 1500, 1100],
            [1, 1.0, 931, 1500, 1102],
            [1, 1.0, 980, 1500, 1065],
            [1, 1.0, 993, 1500, 1032],
        ],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.FungiForest,
        name="Path to Rabbit race (2 custom, 3 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 1824, 203, 3811],
            [1, 1.0, 1724, 222, 3811],
            [1, 1.0, 1901.04736328125, 190.0165252685547, 3806.103271484375],
            [1, 1.0, 2012.5977783203125, 174.7574920654297, 3804.458984375],
            [1, 1.0, 2124.944091796875, 149.38900756835938, 3804.092041015625],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.FungiForest,
        name="On Rabbit's home",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 2313, 180, 3809]],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.FungiForest,
        name="On Guitar pad in W4 area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 1266, 290, 4182]],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.FungiForest,
        name="Saxophone pad in tree area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 1281, 325, 4596]],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.FungiForest,
        name="On anthill around hole",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.HollowTreeArea,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.mini and l.saxophone and l.istiny),
        locations=[
            [1, 1.0, 1287, 415, 4764],
            [1, 1.0, 1314, 415, 4743],
            [1, 1.0, 1304, 415, 4712],
            [1, 1.0, 1275, 415, 4708],
            [1, 1.0, 1260, 415, 4742],
        ],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.FungiForest,
        name="Around anthill (2 custom, 8 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 1253, 298, 4827],
            [1, 1.0, 1202, 299, 4774],
            [1, 1.0, 1354.79638671875, 297.2366027832031, 4664.29736328125],
            [1, 1.0, 1293.6610107421875, 297.8722839355469, 4643.83935546875],
            [1, 1.0, 1226.5498046875, 298.7757263183594, 4668.16455078125],
            [1, 1.0, 1199.1478271484375, 298.2732849121094, 4733.580078125],
            [1, 1.0, 1220.0360107421875, 297.263671875, 4804.58349609375],
            [1, 1.0, 1295.1124267578125, 298.0571594238281, 4827.4716796875],
            [1, 1.0, 1356.4080810546875, 297.7692565917969, 4800.95703125],
            [1, 1.0, 1385.7923583984375, 297.3160095214844, 4743.1748046875],
        ],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.FungiForest,
        name="In owl alcove",
        konglist=[Kongs.diddy],
        region=Regions.HollowTreeArea,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1275, 410, 3876]],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.FungiForest,
        name="Around rocketbarrel barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 533, 199, 3647],
            [1, 1.0, 470, 199, 3609],
            [1, 1.0, 423, 199, 3649],
            [1, 1.0, 440, 199, 3718],
            [1, 1.0, 506, 199, 3714],
        ],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.FungiForest,
        name="Tree stumps rocketbarrel side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 1022, 285, 3565], [5, 1.0, 890, 275, 3903]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.FungiForest,
        name="Tree stumps rabbit side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 1634, 280, 3809], [5, 1.0, 1531, 285, 3579]],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.FungiForest,
        name="Stump at the entrance of tree area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[[5, 1.0, 1290, 220, 2919], [5, 1.0, 1290, 260, 2919]],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.FungiForest,
        name="On top of yellow tunnel in tree area",
        konglist=[Kongs.diddy],
        region=Regions.HollowTreeArea,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 1222, 301, 2729],
            [1, 1.0, 1244, 315, 2735],
            [1, 1.0, 1282, 336, 2744],
            [1, 1.0, 1309, 321, 2735],
            [1, 1.0, 1345, 300, 2723],
        ],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.FungiForest,
        name="Around patch of grass by melon crate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 574, 189, 3793],
            [1, 1.0, 517, 189, 3817],
            [1, 1.0, 445, 189, 3837],
            [1, 1.0, 358, 189, 3837],
            [1, 1.0, 350, 189, 3906],
            [1, 1.0, 350, 189, 3975],
            [1, 1.0, 414, 189, 4039],
            [1, 1.0, 492, 189, 4050],
            [1, 1.0, 566, 189, 4059],
            [1, 1.0, 621, 189, 4130],
        ],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.FungiForest,
        name="Line under tree by Lanky BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 1275, 249, 3600],
            [1, 1.0, 1275, 249, 3651],
            [1, 1.0, 1275, 249, 3702],
            [1, 1.0, 1275, 249, 3753],
            [1, 1.0, 1275, 249, 3804],
            [1, 1.0, 1275, 249, 3855],
            [1, 1.0, 1275, 249, 3906],
            [1, 1.0, 1275, 249, 3957],
            [1, 1.0, 1275, 249, 4008],
            [1, 1.0, 1275, 249, 4059],
        ],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.ForestAnthill,
        name="On outside islands",
        konglist=[Kongs.tiny],
        region=Regions.Anthill,
        locations=[[5, 2.0, 770, 220, 418], [5, 2.0, 425, 220, 408]],
    ),
    # Reason for disabling: Krusha's collision with one of the automatically shooting barrels is off,
    # making one of those bunches unobtainable as Krusha.
    # ColoredBananaGroup(
    #     group=79,
    #     map_id=Maps.ForestBaboonBlast,
    #     name="Between some barrels",
    #     konglist=[Kongs.donkey],
    #     region=Regions.ForestBaboonBlast,
    #     locations=[[5, 1.0, 2550, 885, 2186], [5, 1.0, 2636, 762, 1200]],
    # ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.ForestWinchRoom,
        name="On boxes in winch room",
        konglist=[Kongs.diddy],
        region=Regions.WinchRoom,
        locations=[[5, 1.0, 236, 55, 135], [5, 1.0, 342, 26, 394], [5, 1.0, 388, 26, 173]],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.ForestRafters,
        name="On plank near entrance",
        konglist=[Kongs.diddy],
        region=Regions.MillRafters,
        logic=lambda l: l.guitar,
        locations=[
            [1, 1.0, 390, 0, 163],
            [1, 1.0, 445, 0, 163],
            [1, 1.0, 500, 0, 163],
            [1, 1.0, 555, 0, 163],
            [1, 1.0, 610, 0, 163],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.ForestRafters,
        name="On long plank near GB",
        konglist=[Kongs.diddy],
        region=Regions.MillRafters,
        logic=lambda l: l.guitar,
        locations=[
            [1, 1.0, 646, -24, 483],
            [1, 1.0, 594, -24, 483],
            [1, 1.0, 532, -24, 483],
            [1, 1.0, 470, -24, 483],
            [1, 1.0, 508, -24, 483],
            [1, 1.0, 346, -24, 483],
            [1, 1.0, 284, -24, 483],
            [1, 1.0, 222, -24, 483],
            [1, 1.0, 160, -24, 483],
            [1, 1.0, 98, -24, 483],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.ForestThornvineBarn,
        name="On barrel and box near entrance",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        locations=[[5, 1.0, 608, 50, 152], [5, 1.0, 193, 40, 111]],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.ForestThornvineBarn,
        name="On boxes by switch and ladder",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        locations=[[5, 1.0, 32, 50, 156], [5, 1.0, 32, 50, 586]],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.ForestThornvineBarn,
        name="On two barrels by switch",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        locations=[[5, 1.0, 27, 45, 353], [5, 1.0, 27, 45, 250]],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.ForestThornvineBarn,
        name="Near melon crate in thornvine area",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        locations=[
            [1, 1.0, 512, 4, 620],
            [1, 1.0, 512, 4, 565],
            [1, 1.0, 512, 4, 510],
            [1, 1.0, 512, 4, 455],
            [1, 1.0, 512, 4, 400],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.ForestThornvineBarn,
        name="On boxes on upper level",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarnAboveLadder,
        locations=[
            [5, 1.0, 207, 185, 100],
            [5, 1.0, 500, 185, 644],
        ],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.ForestThornvineBarn,
        name="On ladder",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarnAboveLadder,
        locations=[
            [1, 1.0, 180, 140, 514],
            [1, 1.0, 180, 110, 514],
            [1, 1.0, 180, 80, 514],
            [1, 1.0, 180, 50, 514],
            [1, 1.0, 180, 20, 514],
        ],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.ForestMillFront,
        name="On flour bag by Mini Monkey",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        locations=[[5, 1.0, 43, 115, 120]],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.ForestMillFront,
        name="On conveyor belt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        locations=[
            [1, 1.0, 500, 16, 574],
            [1, 1.0, 460, 16, 574],
            [1, 1.0, 420, 16, 574],
            [1, 1.0, 380, 16, 574],
            [1, 1.0, 340, 16, 574],
        ],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.ForestGiantMushroom,
        name="By entrance near gun switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLower,
        locations=[
            [1, 1.0, 540, 0, 283],
            [1, 1.0, 631, 0, 321],
            [1, 1.0, 758, 13, 347],
            [1, 1.0, 653, 53, 239],
            [1, 1.0, 515, 80, 196],
            [1, 1.0, 388, 80, 192],
            [1, 1.0, 263, 51, 231],
            [1, 1.0, 158, 13, 328],
            [1, 1.0, 250, 0, 336],
            [1, 1.0, 370, 0, 269],
        ],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.ForestGiantMushroom,
        name="Up first ladder up each path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerBetweenLadders,
        locations=[[5, 1.0, 122, 275, 621], [5, 1.0, 779, 275, 601]],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.ForestGiantMushroom,
        name="On first island to Speedy Swing Sortie",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerMid,
        locations=[[5, 1.0, 550, 415, 199]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.ForestGiantMushroom,
        name="On vines leading to night gate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        logic=lambda l: l.can_use_vines,
        locations=[
            [1, 1.2, 218, 980, 520],
            [1, 1.2, 365, 1035, 517],
            [1, 1.2, 475, 1030, 515],
            [1, 1.2, 580, 1030, 513],
            [1, 1.2, 675, 1035, 511],
        ],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.ForestGiantMushroom,
        name="On floor with oranges",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperVineFloor,
        locations=[
            [1, 1.0, 204, 1169, 307],
            [1, 1.0, 326, 1169, 317],
            [1, 1.0, 482, 1169, 307],
            [1, 1.0, 574, 1169, 390],
            [1, 1.0, 628, 1169, 509],
            [1, 1.0, 559, 1169, 629],
            [1, 1.0, 459, 1169, 711],
            [1, 1.0, 323, 1169, 816],
            [1, 1.0, 189, 1169, 785],
            [1, 1.0, 382, 1169, 575],
        ],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.ForestGiantMushroom,
        name="Over gaps near top",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        locations=[[5, 1.0, 200, 1520, 792], [5, 1.0, 111, 1565, 515], [5, 1.0, 218, 1640, 265]],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.ForestMillAttic,
        name="On boxes in Lanky attic",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillAttic,
        locations=[[5, 1.0, 398, 42, 437], [5, 1.0, 164, 32, 251]],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.ForestMillAttic,
        name="Line behind boxes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillAttic,
        locations=[
            [1, 1.0, 468, 0, 390],
            [1, 1.0, 468, 0, 320],
            [1, 1.0, 468, 0, 250],
            [1, 1.0, 468, 0, 180],
            [1, 1.0, 468, 0, 110],
        ],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.ForestLankyMushroomsRoom,
        name="On green mushroom",
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyMushroomsRoom,
        locations=[[5, 1.0, 331, 45, 382]],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.ForestMillBack,
        name="On boxes by Mini Monkey barrels",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        locations=[[5, 1.0, 474, 55, 115], [5, 1.0, 192, 40, 659]],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.ForestSpider,
        name="Around center web",
        konglist=[Kongs.tiny],
        region=Regions.SpiderRoom,
        locations=[
            [1, 2.0, 359, 173, 684],
            [1, 2.0, 350, 173, 539],
            [1, 2.0, 434, 173, 424],
            [1, 2.0, 579, 173, 363],
            [1, 2.0, 695, 173, 377],
            [1, 2.0, 789, 173, 491],
            [1, 2.0, 809, 173, 624],
            [1, 2.0, 730, 173, 748],
            [1, 2.0, 613, 173, 790],
            [1, 2.0, 491, 173, 777],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.FungiForest,
        name="In purple tunnel (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[
            [1, 1.0, 1756.8702392578125, 178.87391662597656, 1977.9796142578125],
            [1, 1.0, 1656.6934814453125, 179.3333282470703, 1906.3720703125],
            [1, 1.0, 1688.7386474609375, 179.3333282470703, 1777.5443115234375],
            [1, 1.0, 1615.83984375, 179.3333282470703, 1547.4337158203125],
            [1, 1.0, 1710.4366455078125, 179.3333282470703, 1641.1400146484375],
        ],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.FungiForest,
        name="In blue tunnel (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[
            [1, 1.0, 3574.275146484375, 166.0, 3021.802978515625],
            [1, 1.0, 3435.540771484375, 166.0, 2887.692138671875],
            [1, 1.0, 3459.6044921875, 166.0, 2719.410400390625],
            [1, 1.0, 3438.481689453125, 166.0, 2565.910888671875],
            [1, 1.0, 3253.6494140625, 166.0, 2492.8544921875],
        ],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.FungiForest,
        name="Path to thornvine barn (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        vanilla=True,
        locations=[
            [1, 1.0, 4398.31591796875, 209.8905029296875, 2748.624267578125],
            [1, 1.0, 4430.84912109375, 173.85113525390625, 2574.488525390625],
            [1, 1.0, 4376.19970703125, 131.9368438720703, 2386.465087890625],
            [1, 1.0, 4251.82763671875, 125.22212982177734, 2310.112548828125],
            [1, 1.0, 4130.05712890625, 115.0, 2154.272216796875],
        ],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.FungiForest,
        name="Path to Baboon Blast pad (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        vanilla=True,
        locations=[
            [1, 1.0, 458.903564453125, 570.3333740234375, 862.6621704101562],
            [1, 1.0, 461.7091369628906, 495.3333740234375, 857.4607543945312],
        ],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.FungiForest,
        name="Path to Baboon Blast pad (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        vanilla=True,
        locations=[
            [1, 1.0, 461.7499694824219, 389.3333435058594, 857.510986328125],
            [1, 1.0, 634.3507080078125, 389.3333435058594, 802.1203002929688],
            [1, 1.0, 527.4633178710938, 389.3333435058594, 781.2810668945312],
        ],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.FungiForest,
        name="On thornvine barn switch (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineArea,
        vanilla=True,
        logic=lambda l: l.strongKong,
        locations=[[5, 1.0, 3893.128662109375, 150.33334350585938, 1717.7393798828125]],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.FungiForest,
        name="W5 (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        vanilla=True,
        locations=[[5, 1.0, 458.7630310058594, 1265.0, 1199.4534912109375]],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.FungiForest,
        name="W5 (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        vanilla=True,
        locations=[[5, 1.0, 934.8818969726562, 244.5, 1723.2955322265625]],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.FungiForest,
        name="Around giant mushroom upper exterior (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        vanilla=True,
        locations=[
            [1, 1.0, 746.585693359375, 1250.0, 581.5753173828125],
            [1, 1.0, 553.0519409179688, 1250.0, 711.29296875],
            [1, 1.0, 440.8115539550781, 1250.0, 938.5263061523438],
            [1, 1.0, 597.60400390625, 1250.0, 1385.83984375],
            [1, 1.0, 825.7499389648438, 1250.0, 1488.3231201171875],
            [1, 1.0, 1056.98583984375, 1250.0, 1473.9320068359375],
            [1, 1.0, 1274.3011474609375, 1250.0, 1325.625244140625],
            [1, 1.0, 1368.7647705078125, 1250.0, 1117.8673095703125],
            [1, 1.0, 1348.7386474609375, 1250.0, 858.1443481445312],
            [1, 1.0, 1214.0615234375, 1250.0, 665.4550170898438],
        ],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.FungiForest,
        name="Around tree (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        vanilla=True,
        locations=[
            [1, 1.0, 1049.2794189453125, 249.3333282470703, 3738.9130859375],
            [1, 1.0, 1008.78466796875, 249.3333282470703, 3891.484130859375],
            [1, 1.0, 1076.571044921875, 249.3333282470703, 4018.788330078125],
            [1, 1.0, 1175.221435546875, 249.3333282470703, 4083.616455078125],
            [1, 1.0, 1362.18310546875, 249.3333282470703, 4087.91796875],
            [1, 1.0, 1460.9105224609375, 249.3333282470703, 4020.3701171875],
            [1, 1.0, 1537.0260009765625, 249.3333282470703, 3896.7841796875],
            [1, 1.0, 1542.94580078125, 249.3333282470703, 3757.3583984375],
            [1, 1.0, 1472.5159912109375, 249.3333282470703, 3642.606201171875],
            [1, 1.0, 1098.859619140625, 249.3333282470703, 3631.440673828125],
        ],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.FungiForest,
        name="Under starting area rocketbarrel (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[
            [5, 1.0, 2899.876953125, 336.50677490234375, 2370.239990234375],
            [5, 1.0, 2899.509033203125, 401.274658203125, 2373.41357421875],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.FungiForest,
        name="Under giant mushroom rocketbarrel (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        vanilla=True,
        locations=[
            [5, 1.0, 247.50390625, 375.33331298828125, 618.4163208007812],
            [5, 1.0, 247.19683837890625, 325.33331298828125, 618.5470581054688],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.FungiForest,
        name="By entrance of rafters attic (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.MillArea,
        vanilla=True,
        logic=lambda l: l.spring or l.CanMoontail(),
        locations=[[5, 1.0, 3436.232666015625, 472.3333435058594, 4503.90625]],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.FungiForest,
        name="On hollow tree (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.HollowTreeArea,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1277.5789794921875, 585.5, 3832.445068359375]],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.FungiForest,
        name="W4 (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        vanilla=True,
        locations=[[5, 1.0, 1277.45556640625, 264.33331298828125, 3534.0634765625]],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.FungiForest,
        name="W4 (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[[5, 1.0, 2482.936279296875, 275.435302734375, 2556.4951171875]],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.FungiForest,
        name="W3 (1 Lanky, 1 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        vanilla=True,
        locations=[[5, 1.0, 1182.403564453125, 194.3333282470703, 1244.3052978515625]],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.FungiForest,
        name="W3 (1 Lanky, 1 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[[5, 1.0, 2234.061279296875, 291.2705993652344, 2225.267822265625]],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.FungiForest,
        name="Yellow tunnel (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        vanilla=True,
        locations=[
            [1, 1.0, 385.8992614746094, 179.3333282470703, 1692.8260498046875],
            [1, 1.0, 375.8772888183594, 179.3333282470703, 1826.7147216796875],
            [1, 1.0, 458.2175598144531, 179.3333282470703, 1918.6160888671875],
            [1, 1.0, 658.5783081054688, 179.3333282470703, 1987.9764404296875],
            [1, 1.0, 852.0603637695312, 179.3333282470703, 1971.1397705078125],
            [1, 1.0, 994.600830078125, 179.3333282470703, 2033.4205322265625],
            [1, 1.0, 1127.4217529296875, 179.3333282470703, 2199.150634765625],
            [1, 1.0, 1193.711669921875, 179.3333282470703, 2355.699462890625],
            [1, 1.0, 1277.4166259765625, 179.3333282470703, 2485.598388671875],
            [1, 1.0, 1285.6912841796875, 179.3333282470703, 2698.983154296875],
        ],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.FungiForest,
        name="Around giant mushroom base (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        vanilla=True,
        locations=[
            [1, 1.0, 1247.1900634765625, 179.3333282470703, 1074.181884765625],
            [1, 1.0, 1226.817138671875, 179.3333282470703, 912.409912109375],
            [1, 1.0, 1126.0452880859375, 179.3333282470703, 764.9971313476562],
            [1, 1.0, 960.3075561523438, 179.3333282470703, 690.73291015625],
            [1, 1.0, 787.276611328125, 179.3333282470703, 709.66259765625],
            [1, 1.0, 572.1100463867188, 179.3333282470703, 946.76708984375],
            [1, 1.0, 578.024658203125, 179.3333282470703, 1124.334228515625],
            [1, 1.0, 676.7086791992188, 179.3333282470703, 1281.8023681640625],
            [1, 1.0, 841.4494018554688, 179.3333282470703, 1360.109619140625],
            [1, 1.0, 1019.1292114257812, 179.3333282470703, 1344.2034912109375],
        ],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.FungiForest,
        name="In entrance to Lanky's attic (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ForestTopOfMill,
        vanilla=True,
        logic=lambda l: Events.Night in l.Events,
        locations=[[5, 1.0, 4206.09912109375, 328.66845703125, 3661.584716796875]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.FungiForest,
        name="Over baboon balloon pad (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ForestTopOfMill,
        vanilla=True,
        locations=[[5, 1.0, 4021.470458984375, 291.83331298828125, 3603.982666015625]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.FungiForest,
        name="On Giant mushroom top switch (Lanky)",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.MushroomUpperExterior,
        vanilla=True,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.handstand and l.islanky),
        locations=[[5, 1.0, 913.51025390625, 1520.0, 1020.1333618164062]],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.FungiForest,
        name="On Rabbit Race instrument pad (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        vanilla=True,
        locations=[[5, 1.0, 2178.653564453125, 153.96243286132812, 3780.039306640625]],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.FungiForest,
        name="Green tunnel (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,  # 4 are in FungiForestStart behind feather gate
        vanilla=True,
        locations=[[1, 1.0, 3098.732666015625, 204.2165985107422, 1213.5511474609375]],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.FungiForest,
        name="Green tunnel (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.FungiGreenFeather, False) or l.CanPhase() or l.CanPhaseswim(),
        locations=[
            [1, 1.0, 2745.662841796875, 201.1666717529297, 1544.6708984375],
            [1, 1.0, 2807.278076171875, 201.1666717529297, 1464.7086181640625],
            [1, 1.0, 2928.174560546875, 201.1666717529297, 1466.7611083984375],
            [1, 1.0, 3040.849609375, 201.1666717529297, 1418.11376953125],
        ],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.FungiForest,
        name="On riverbed around mill (3 custom, 17 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.2, 4800.55322265625, 82.83333587646484, 3363.297607421875],
            [1, 1.2, 4903.84716796875, 82.83333587646484, 3501.983154296875],
            [1, 1.2, 4859.2919921875, 82.83333587646484, 3704.345458984375],
            [1, 1.2, 4744.84814453125, 82.83333587646484, 3831.670654296875],
            [1, 1.2, 4616.10888671875, 82.83333587646484, 3901.806640625],
            [1, 1.2, 4491.73388671875, 82.83333587646484, 4027.003173828125],
            [1, 1.2, 4381.63037109375, 82.83333587646484, 4129.5556640625],
            [1, 1.2, 4191.80712890625, 82.83333587646484, 4127.220703125],
            [1, 1.2, 4037.574462890625, 82.83333587646484, 4096.76318359375],
            [1, 1.2, 3924.244140625, 87.04840087890625, 3975.691650390625],
            [1, 1.2, 3846.677490234375, 101.7298812866211, 3838.585205078125],
            [1, 1.2, 3840.479248046875, 83.66397857666016, 3638.14453125],
            [1, 1.2, 3956.949951171875, 82.83333587646484, 3476.173583984375],
            [1, 1.2, 4159.92919921875, 82.83333587646484, 3290.807861328125],
            [1, 1.2, 4339.876953125, 82.83333587646484, 3236.81640625],
            [1, 1.2, 4504.056640625, 82.83333587646484, 3222.636474609375],
            [1, 1.2, 4688.71826171875, 82.83333587646484, 3252.462890625],
            [1, 1.2, 3843, 90, 3687],
            [1, 1.2, 4902, 82, 3551],
            [1, 1.2, 4881, 83, 3466],
        ],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.FungiForest,
        name="On mushrooms in beanstalk area (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        vanilla=True,
        logic=lambda l: l.climbing,
        locations=[
            [5, 1.0, 2887.5283203125, 411.20001220703125, 998.1066284179688],
            [5, 1.0, 2811.4892578125, 401.791015625, 457.0398254394531],
            [5, 1.0, 3497.2294921875, 396.33160400390625, 482.7132263183594],
        ],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.FungiForest,
        name="On anthill (Tiny)",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.HollowTreeArea,
        vanilla=True,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.istiny and (l.mini and l.saxophone)),
        locations=[[5, 1.0, 1288.1484375, 434.0, 4735.201171875]],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.FungiForest,
        name="W2 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[[5, 1.0, 2553.355712890625, 296.0357666015625, 2113.8564453125]],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.FungiForest,
        name="W2 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        vanilla=True,
        locations=[[5, 1.0, 3250.580322265625, 199.3033447265625, 233.6762237548828]],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.FungiForest,
        name="On minecart entrance (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        vanilla=True,
        locations=[[5, 1.0, 2176.2392578125, 151.1666717529297, 3166.1611328125]],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.ForestRafters,
        name="Rafters Right side (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.MillRafters,
        logic=lambda l: l.guitar,
        vanilla=True,
        locations=[[5, 1.0, 83.92961883544922, -37.16666793823242, 385.5804138183594]],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.ForestRafters,
        name="Rafters Left side (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.MillRafters,
        logic=lambda l: l.guitar,
        vanilla=True,
        locations=[[5, 1.0, 650.434814453125, -18.33333396911621, 263.2375793457031]],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.ForestMillAttic,
        name="On box (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillAttic,
        vanilla=True,
        locations=[[5, 1.0, 177.38160705566406, 41.0, 91.32874298095703]],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.ForestThornvineBarn,
        name="On switch (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        vanilla=True,
        logic=lambda l: l.Slam and l.isdonkey,
        locations=[[5, 1.0, 114.7787094116211, 17.76678466796875, 188.0786590576172]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.ForestSpider,
        name="On entrance plank (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.SpiderRoom,
        vanilla=True,
        locations=[[5, 1.9999995231628418, 132.2318572998047, 178.8333282470703, 785.8123168945312]],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.ForestMillFront,
        name="On DK switch (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        logic=lambda l: l.Slam,
        vanilla=True,
        locations=[[5, 1.0, 48.73106002807617, 61.166255950927734, 188.2012481689453]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.ForestMillBack,
        name="On boxes by spider room (Tiny)",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        vanilla=True,
        locations=[[5, 1.0, 124.76998138427734, 54.86122131347656, 156.70054626464844]],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.ForestMillBack,
        name="By Mini Monkey entrance to front mill (Tiny)",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        vanilla=True,
        locations=[[5, 1.0, 101.95130157470703, 3.0, 454.1036682128906]],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.ForestMillBack,
        name="Inside punchable box (Tiny)",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        vanilla=True,
        logic=lambda l: Events.MillBoxBroken in l.Events,
        locations=[[5, 1.0, 390.7475891113281, 0, 114.15646362304688]],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.ForestMillBack,
        name="On triangle pad (Chunky)",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        vanilla=True,
        logic=lambda l: Events.MillBoxBroken in l.Events,
        locations=[[5, 1.0, 622.750732421875, 18.0, 167.2416534423828]],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.ForestLankyMushroomsRoom,
        name="On mushroom (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyMushroomsRoom,
        vanilla=True,
        locations=[[5, 1.0, 224.94000244140625, 60.0, 226.0018768310547]],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.ForestGiantMushroom,
        name="Between cannons (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLower,
        vanilla=True,
        logic=lambda l: Events.MushroomCannonsSpawned in l.Events,
        locations=[
            [5, 1.0, 538.9384155273438, 509.23016357421875, 595.8275756835938],
            [5, 1.0999999046325684, 485.36456298828125, 1147.794921875, 518.7532958984375],
            [5, 1.0, 329.3463439941406, 1556.1666259765625, 524.5181274414062],
        ],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.ForestGiantMushroom,
        name="Around Diddy's blueprint (3 custom, 7 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomMiddle,
        locations=[
            [1, 1.0, 536, 543, 315],
            [1, 1.0, 358, 581, 744],
            [1, 1.0, 685, 574, 675],
            [1, 1.0, 393.6114807128906, 530.6331787109375, 334.1806945800781],
            [1, 1.0, 275.6488037109375, 543.3585815429688, 492.1453857421875],
            [1, 1.0, 302.3760986328125, 572.5424194335938, 661.360107421875],
            [1, 1.0, 453.6861267089844, 585.7356567382812, 775.3255004882812],
            [1, 1.0, 621.4924926757812, 577.6705322265625, 744.2703247070312],
            [1, 1.0, 731.43701171875, 573.3530883789062, 569.7015380859375],
            [1, 1.0, 635.5906982421875, 561.1755981445312, 378.2322998046875],
        ],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.ForestGiantMushroom,
        name="On Tiny switch (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLower,
        vanilla=True,
        locations=[[5, 1.0, 775.3206176757812, 15.502724647521973, 450.17333984375]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.ForestGiantMushroom,
        name="First ladder up mushroom (2 custom, 3 Chunky)",  # Altered 3 vanilla so there's no jankness with other kongs
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerBetweenLadders,
        locations=[
            [1, 1.0, 448.25, 207.75, 918.25],
            [1, 1.0, 446.875, 168, 918, 75],
            [1, 1.0, 447, 119.75, 918.75],
            [1, 1.0, 448, 86, 905],
            [1, 1.0, 448, 140, 908],
        ],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.ForestGiantMushroom,
        name="Second ladder up mushroom (2 custom, 3 Chunky)",  # Altered 3 vanilla so there's no jankness with other kong
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerMid,
        locations=[
            [1, 1.0, 746.25, 396.75, 805.25],
            [1, 1.0, 744.25, 353, 808],
            [1, 1.0, 746.5, 297.5, 805.25],
            [1, 1.0, 740, 230, 805],
            [1, 1.0, 740, 252, 805],
        ],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.ForestGiantMushroom,
        name="Third ladder up mushroom (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        vanilla=True,
        locations=[
            [1, 1.0, 202.72119140625, 651.1666870117188, 268.6103210449219],
            [1, 1.0, 202.562744140625, 603.1666870117188, 268.34991455078125],
            [1, 1.0, 202.55029296875, 539.1666870117188, 268.3563537597656],
            [1, 1.0, 203, 570, 268],
            [1, 1.0, 203, 626, 268],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.ForestGiantMushroom,
        name="Fourth ladder up mushroom (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        vanilla=True,
        locations=[
            [1, 1.0, 510.3544616699219, 896.6666870117188, 881.4966430664062],
            [1, 1.0, 510.3581848144531, 815.6666870117188, 881.5514526367188],
            [1, 1.0, 510.5141906738281, 739.6666870117188, 881.680419921875],
            [1, 1.0, 510, 778, 882],
            [1, 1.0, 510, 856, 882],
        ],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.ForestGiantMushroom,
        name="Fifth ladder up mushroom (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperVineFloor,
        vanilla=True,
        locations=[
            [1, 1.0, 476.5090026855469, 1183.1666259765625, 195.49839782714844],
            [1, 1.0, 476.5834045410156, 1125.1666259765625, 195.7490997314453],
            [1, 1.0, 476.5683288574219, 1051.1666259765625, 195.75439453125],
            [1, 1.0, 477, 1088, 196],
            [1, 1.0, 477, 1154, 196],
        ],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.ForestGiantMushroom,
        name="Sixth ladder up mushroom (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        vanilla=True,
        locations=[
            [1, 1.0, 461.6983947753906, 1442.8328857421875, 881.2282104492188],
            [1, 1.0, 461.6907653808594, 1388.8343505859375, 881.2271118164062],
            [1, 1.0, 461.6907653808594, 1316.8343505859375, 881.2271118164062],
            [1, 1.0, 462, 1353, 881],
            [1, 1.0, 462, 1415, 881],
        ],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.ForestGiantMushroom,
        name="Last ladder up mushroom (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        vanilla=True,
        locations=[
            [1, 1.0, 586.22509765625, 1817.1666259765625, 198.01715087890625],
            [1, 1.0, 586.6629638671875, 1709.1666259765625, 198.56646728515625],
            [1, 1.0, 585.9144287109375, 1770.1666259765625, 199.15513610839844],
            [1, 1.0, 586, 1740, 199],
            [1, 1.0, 586, 1794, 199],
        ],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.ForestGiantMushroom,
        name="Lowest bunch up mushroom (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerBetweenLadders,
        vanilla=True,
        locations=[[5, 1.0, 617.3297119140625, 216.20155334472656, 840.7553100585938]],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.ForestGiantMushroom,
        name="Top of mushroom (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        vanilla=True,
        locations=[[5, 1.0, 765.739013671875, 1839.1666259765625, 401.4931640625]],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.ForestGiantMushroom,
        name="Bunch in middle of climb up mushroom (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        vanilla=True,
        locations=[[5, 1.0, 173.313720703125, 739.6666870117188, 752.3272094726562]],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.ForestGiantMushroom,
        name="Top of lower portion of mushroom (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerMid,
        vanilla=True,
        locations=[[5, 1.0, 288.6304931640625, 483.5830383300781, 834.6895141601562]],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.ForestGiantMushroom,
        name="By night gate (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomNightDoor,
        vanilla=True,
        locations=[[5, 1.0, 770.0504760742188, 979.1666870117188, 501.8072204589844]],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.ForestLankyZingersRoom,
        name="Over bouncy shrooms (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyZingersRoom,
        vanilla=True,
        locations=[
            [5, 1.0, 282.8437194824219, 81.0, 400.569091796875],
            [5, 1.0, 227.91493225097656, 81.0, 212.315673828125],
        ],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.ForestChunkyFaceRoom,
        name="On Chunky switch (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.MushroomChunkyRoom,
        vanilla=True,
        locations=[[5, 1.0, 315.60430908203125, 15.0, 309.8582763671875]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.ForestBaboonBlast,
        name="In baboon blast course (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.ForestBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.0, 2256.733642578125, 769.4644775390625, 1803.3250732421875],
            [5, 1.0, 2330.926025390625, 648.6649780273438, 2737.630615234375],
        ],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.FungiForest,
        name="Around giant mushroom lower exterior",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        vanilla=True,
        locations=[
            [1, 1.0, 1163.223388671875, 389.3333435058594, 1067.7276611328125],
            [1, 1.0, 1145.6046142578125, 389.3333435058594, 922.2339477539062],
            [1, 1.0, 942.3922729492188, 389.3333435058594, 769.1979370117188],
            [1, 1.0, 816.0346069335938, 389.3333435058594, 780.24072265625],
            [1, 1.0, 710.3027954101562, 389.3333435058594, 857.68115234375],
            [1, 1.0, 645.3963623046875, 389.3333435058594, 996.0231323242188],
            [1, 1.0, 661.2913818359375, 389.3333435058594, 1117.5159912109375],
            [1, 1.0, 734.8554077148438, 390.1988830566406, 1221.1845703125],
            [1, 1.0, 865.068359375, 389.3333435058594, 1280.0574951171875],
            [1, 1.0, 991.7959594726562, 389.3333435058594, 1271.5277099609375],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=158,
        map_id=Maps.FungiForest,
        name="From W1 to W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2724, 277, 2296], [1, 1.0, 2705, 278, 2237], [1, 1.0, 2680, 280, 2197], [1, 1.0, 2645, 284, 2160], [1, 1.0, 2602, 282, 2130]],
    ),
    ColoredBananaGroup(
        group=159,
        map_id=Maps.FungiForest,
        name="From W2 to W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2500, 280, 2099], [1, 1.0, 2434, 278, 2104], [1, 1.0, 2372, 278, 2119], [1, 1.0, 2318, 279, 2136], [1, 1.0, 2271, 275, 2173]],
    ),
    ColoredBananaGroup(
        group=160,
        map_id=Maps.FungiForest,
        name="From W3 to W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2209, 270, 2299], [1, 1.0, 2218, 268, 2365], [1, 1.0, 2251, 262, 2436], [1, 1.0, 2310, 260, 2514], [1, 1.0, 2393, 257, 2539]],
    ),
    ColoredBananaGroup(
        group=161,
        map_id=Maps.FungiForest,
        name="From W4 to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2532, 256, 2535], [1, 1.0, 2587, 260, 2508], [1, 1.0, 2639, 265, 2479], [1, 1.0, 2679, 269, 2435], [1, 1.0, 2709, 273, 2391]],
    ),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.FungiForest,
        name="On the green tunnel lip (center side)",
        konglist=[Kongs.diddy, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: (l.jetpack and l.isdiddy) or l.ischunky or (l.twirl and l.istiny),
        locations=[[5, 1.0, 2692, 364, 1679]],
    ),
    ColoredBananaGroup(
        group=163,
        map_id=Maps.FungiForest,
        name="Under the pendulum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2518, 309, 2335]],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.FungiForest,
        name="The one branch of the clock tree",
        konglist=[Kongs.diddy],
        region=Regions.FungiForestStart,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.1, 2440, 500, 2203]],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.FungiForest,
        name="Day and night switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[5, 1.0, 2539, 612, 2388], [5, 1.0, 2538, 612, 2262]],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.FungiForest,
        name="Grass between pink tunnel and minecart",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2019, 182, 2574], [1, 1.0, 2019, 192, 2574], [1, 1.0, 2019, 202, 2574], [1, 1.0, 2019, 212, 2574], [1, 2.0, 2019, 222, 2574]],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.FungiForest,
        name="Grass near portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2280, 230, 1939], [1, 1.0, 2280, 240, 1939], [1, 1.0, 2280, 250, 1939], [1, 1.0, 2280, 260, 1939], [1, 2.0, 2280, 270, 1939]],
    ),
    ColoredBananaGroup(
        group=168,
        map_id=Maps.FungiForest,
        name="Grass near blue tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2994, 193, 2550], [1, 1.0, 2994, 203, 2550], [1, 1.0, 2994, 213, 2550], [1, 1.0, 2994, 223, 2550], [1, 2.0, 2994, 233, 2550]],
    ),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.FungiForest,
        name="Grass near the apple destination",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        locations=[[1, 1.0, 2780, 222, 1927], [1, 1.0, 2780, 232, 1927], [1, 1.0, 2780, 242, 1927], [1, 1.0, 2780, 252, 1927], [1, 2.0, 2780, 262, 1927]],
    ),
    ColoredBananaGroup(
        group=170, map_id=Maps.FungiForest, name="On the apple", konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky], region=Regions.WormArea, locations=[[5, 1.2, 3091, 288, 764]]
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.FungiForest,
        name="Left and right of Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        locations=[[5, 1.0, 3392, 183, 144], [5, 1.0, 3132, 182, 110]],
    ),
    # ColoredBananaGroup(
    #     group=172,
    #     map_id=Maps.FungiForest,
    #     name="The beanstalk ascent",
    #     konglist=[Kongs.tiny],
    #     region=Regions.WormArea,
    #     logic=lambda l: l.saxophone and l.mini and l.Beans >= 1,
    #     locations=[
    #         [1, 1.1, 2019, 393, 411],
    #         [1, 1.1, 1985, 433, 413],
    #         [1, 1.1, 1961, 468, 446],
    #         [1, 1.1, 1938, 507, 482],
    #         [1, 1.1, 1914, 545, 519],
    #         [1, 1.1, 1892, 580, 553],
    #         [1, 1.1, 1869, 616, 588],
    #         [1, 1.1, 1891, 643, 623],
    #         [1, 1.1, 1922, 674, 647],
    #         [1, 1.1, 1956, 698, 673],
    #         [1, 1.1, 1992, 698, 699],
    #         [1, 1.1, 2025, 702, 723],
    #         [1, 1.1, 2054, 729, 696],
    #         [1, 1.1, 2071, 746, 658],
    #         [1, 1.1, 2087, 746, 619],
    #     ],
    # ), # Squawks's flight path is not consistent, sadly
    ColoredBananaGroup(
        group=173,
        map_id=Maps.FungiForest,
        name="Along the thorns",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4044, 202, 2756],
            [1, 1.0, 4098, 205, 2778],
            [1, 1.0, 4152, 208, 2799],
            [1, 1.0, 4205, 210, 2821],
            [1, 1.0, 4259, 213, 2842],
            [1, 1.0, 4422, 212, 2912],
            [1, 1.0, 4476, 209, 2928],
            [1, 1.0, 4530, 206, 2943],
            [1, 1.0, 4584, 204, 2959],
            [1, 1.0, 4638, 201, 2974],
        ],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.FungiForest,
        name="Outer ledge between minecart exit and thorns",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4773, 173, 3197],
            [1, 1.0, 4801, 174, 3226],
            [1, 1.0, 4829, 175, 3255],
            [1, 1.0, 4857, 176, 3284],
            [1, 1.0, 4885, 177, 3313],
            [1, 1.0, 4912, 177, 3343],
            [1, 1.0, 4940, 178, 3372],
            [1, 1.0, 4968, 179, 3401],
            [1, 1.0, 4996, 180, 3430],
            [1, 1.0, 5024, 181, 3459],
        ],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.FungiForest,
        name="Minecart exit well border",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[[1, 1.0, 5323, 248, 3629], [1, 1.0, 5299, 258, 3650], [1, 1.0, 5291, 268, 3681], [1, 1.0, 5299, 258, 3711], [1, 1.0, 5322, 248, 3735]],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.FungiForest,
        name="Above the meme hidden dirt patch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[[5, 1.6, 4655, 190, 4160]],
    ),
    ColoredBananaGroup(
        group=177,
        map_id=Maps.FungiForest,
        name="Outer ledge between the meme dirt patch and rafters barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[[1, 1.0, 4285, 182, 4261], [1, 1.0, 4219, 188, 4256], [1, 1.0, 4154, 194, 4251], [1, 1.0, 4088, 200, 4247], [1, 1.0, 4023, 206, 4242]],
    ),
    ColoredBananaGroup(
        group=178,
        map_id=Maps.FungiForest,
        name="Tag barrel near rafters barn",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 3240, 272, 4153],
            [1, 1.0, 3249, 272, 4141],
            [1, 1.0, 3249, 272, 4125],
            [1, 1.0, 3240, 272, 4113],
            [1, 1.0, 3225, 272, 4108],
            [1, 1.0, 3210, 272, 4113],
            [1, 1.0, 3201, 272, 4125],
            [1, 1.0, 3201, 272, 4141],
            [1, 1.0, 3210, 272, 4153],
            [1, 1.0, 3225, 272, 4158],
        ],
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.FungiForest,
        name="On the blue tunnel lip (mills side)",
        konglist=[Kongs.tiny],
        region=Regions.MillArea,
        logic=lambda l: l.twirl and l.climbing,
        locations=[[5, 1.0, 3589, 327, 3038]],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.FungiForest,
        name="Cobblestone path to Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[[1, 1.0, 3656, 160, 3201], [1, 1.0, 3636, 186, 3300], [1, 1.0, 3566, 196, 3383], [1, 1.0, 3480, 207, 3459], [1, 1.0, 3365, 227, 3514]],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.FungiForest,
        name="Around the winch cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4669, 163, 3497],
            [1, 1.0, 4643, 163, 3418],
            [1, 1.0, 4561, 163, 3418],
            [1, 1.0, 4535, 163, 3497],
            [1, 1.0, 4602, 163, 3545],
        ],
    ),
    ColoredBananaGroup(
        group=182,
        map_id=Maps.FungiForest,
        name="Near the breakable door of the mill",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4506, 162, 3881],
            [1, 1.0, 4523, 182, 3859],
            [1, 1.0, 4523, 162, 3831],
            [1, 1.0, 4506, 182, 3809],
            [1, 1.0, 4480, 162, 3800],
            [1, 1.0, 4454, 182, 3809],
            [1, 1.0, 4437, 162, 3831],
            [1, 1.0, 4437, 182, 3859],
            [1, 1.0, 4454, 162, 3881],
            [1, 1.0, 4480, 182, 3890],
        ],
    ),
    ColoredBananaGroup(
        group=183,
        map_id=Maps.FungiForest,
        name="Above the Diddy winch switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ForestVeryTopOfMill,
        locations=[[5, 1.0, 4493, 550, 3586]],
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.FungiForest,
        name="Thornvine area right side wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        locations=[[1, 1.0, 4555, 115, 1735], [1, 1.0, 4481, 115, 1700], [1, 1.0, 4382, 115, 1661], [1, 1.0, 4360, 115, 1580], [1, 1.0, 4332, 115, 1491]],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.FungiForest,
        name="Thornvine area left side wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        locations=[[1, 1.0, 3751, 115, 2534], [1, 1.0, 3729, 115, 2457], [1, 1.0, 3708, 115, 2369], [1, 1.0, 3620, 115, 2318], [1, 1.0, 3525, 115, 2257]],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.FungiForest,
        name="Jump over the river from mill to rafters",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 3953, 188, 3895],
            [1, 1.0, 3926, 202, 3916],
            [1, 1.0, 3899, 220, 3936],
            [1, 1.0, 3872, 207, 3957],
            [1, 1.0, 3845, 198, 3977],
        ],
    ),
    ColoredBananaGroup(
        group=187,
        map_id=Maps.FungiForest,
        name="Jump over the river from mill to thorns",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        locations=[
            [1, 1.0, 4464, 162, 3309],
            [1, 1.0, 4467, 185, 3266],
            [1, 1.0, 4469, 196, 3222],
            [1, 1.0, 4472, 188, 3179],
            [1, 1.0, 4474, 169, 3136],
        ],
    ),
    ColoredBananaGroup(
        group=188,
        map_id=Maps.FungiForest,
        name="Glitchy dry water spot near warp 5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[[1, 1.0, 963, 112, 1546], [1, 1.0, 963, 147, 1546], [1, 1.0, 963, 181, 1546], [1, 1.0, 963, 216, 1546], [1, 1.0, 963, 250, 1546]],
    ),
    ColoredBananaGroup(
        group=189,
        map_id=Maps.FungiForest,
        name="On the pink tunnel lip (mushroom side)",
        konglist=[Kongs.diddy],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1604, 340, 1537]],
    ),
    ColoredBananaGroup(
        group=190,
        map_id=Maps.FungiForest,
        name="Grass near warp 5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[
            [1, 1.0, 1108, 220, 1783],
            [1, 1.0, 1108, 230, 1783],
            [1, 1.0, 1108, 240, 1783],
            [1, 1.0, 1108, 250, 1783],
            [1, 2.0, 1108, 260, 1783],
            [1, 1.0, 755, 217, 1713],
            [1, 1.0, 755, 227, 1713],
            [1, 1.0, 755, 237, 1713],
            [1, 1.0, 755, 247, 1713],
            [1, 2.0, 755, 257, 1713],
        ],
    ),
    ColoredBananaGroup(
        group=191,
        map_id=Maps.FungiForest,
        name="On the yellow tunnel lip (mushroom side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        logic=lambda l: (l.jetpack and l.isdiddy) or l.climbing,
        locations=[[1, 1.0, 504, 296, 1637], [1, 1.0, 487, 312, 1615], [1, 1.0, 471, 332, 1584], [1, 1.0, 434, 314, 1573], [1, 1.0, 402, 295, 1562]],
    ),
    ColoredBananaGroup(
        group=192,
        map_id=Maps.FungiForest,
        name="Grass near mushroom rocketbarrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[
            [1, 1.0, 165, 241, 769],
            [1, 1.0, 165, 251, 769],
            [1, 1.0, 165, 261, 769],
            [1, 1.0, 165, 271, 769],
            [1, 2.0, 165, 281, 769],
            [1, 1.0, 382, 241, 469],
            [1, 1.0, 382, 251, 469],
            [1, 1.0, 382, 261, 469],
            [1, 1.0, 382, 271, 469],
            [1, 2.0, 382, 281, 469],
        ],
    ),
    ColoredBananaGroup(
        group=193,
        map_id=Maps.FungiForest,
        name="Grass near Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[
            [1, 1.0, 844, 228, 282],
            [1, 1.0, 844, 238, 282],
            [1, 1.0, 844, 248, 282],
            [1, 1.0, 844, 258, 282],
            [1, 2.0, 844, 268, 282],
            [1, 1.0, 1129, 231, 360],
            [1, 1.0, 1129, 241, 360],
            [1, 1.0, 1129, 251, 360],
            [1, 1.0, 1129, 261, 360],
            [1, 2.0, 1129, 271, 360],
        ],
    ),
    ColoredBananaGroup(
        group=194,
        map_id=Maps.FungiForest,
        name="Grass near the bouncy mushroom tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        locations=[
            [1, 1.0, 1525, 213, 804],
            [1, 1.0, 1525, 223, 804],
            [1, 1.0, 1525, 233, 804],
            [1, 1.0, 1525, 243, 804],
            [1, 2.0, 1525, 253, 804],
            [1, 1.0, 1535, 203, 1046],
            [1, 1.0, 1535, 213, 1046],
            [1, 1.0, 1535, 223, 1046],
            [1, 1.0, 1535, 233, 1046],
            [1, 2.0, 1535, 243, 1046],
        ],
    ),
    ColoredBananaGroup(
        group=195,
        map_id=Maps.FungiForest,
        name="Near the ladder before the blast course",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        locations=[
            [1, 1.0, 678, 399, 751],
            [1, 1.0, 655, 420, 779],
            [1, 1.0, 632, 430, 807],
            [1, 1.0, 610, 420, 835],
            [1, 1.0, 587, 399, 863],
        ],
    ),
    ColoredBananaGroup(
        group=196,
        map_id=Maps.FungiForest,
        name="Near the ladder after the blast course",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        locations=[
            [1, 1.0, 614, 599, 1118],
            [1, 1.0, 601, 620, 1141],
            [1, 1.0, 588, 630, 1164],
            [1, 1.0, 575, 620, 1187],
            [1, 1.0, 562, 599, 1210],
        ],
    ),
    ColoredBananaGroup(
        group=197,
        map_id=Maps.FungiForest,
        name="Near the mushroom night door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomNightExterior,
        locations=[
            [1, 1.0, 821, 989, 715],
            [1, 1.0, 804, 1010, 721],
            [1, 1.0, 787, 1020, 728],
            [1, 1.0, 771, 1010, 734],
            [1, 1.0, 754, 989, 740],
        ],
    ),
    ColoredBananaGroup(
        group=198,
        map_id=Maps.FungiForest,
        name="Top of mushroom to zinger bounce room",
        konglist=[Kongs.lanky],
        region=Regions.MushroomUpperExterior,
        logic=lambda l: l.handstand,
        locations=[[1, 1.0, 855, 1385, 1347], [1, 1.0, 863, 1412, 1292], [1, 1.0, 872, 1439, 1238], [1, 1.0, 880, 1465, 1183], [1, 1.0, 888, 1492, 1129]],
    ),
    ColoredBananaGroup(
        group=199,
        map_id=Maps.FungiForest,
        name="Top of mushroom to colored slam room",
        konglist=[Kongs.lanky],
        region=Regions.MushroomUpperExterior,
        logic=lambda l: l.handstand,
        locations=[[1, 1.0, 962, 1384, 700], [1, 1.0, 953, 1411, 755], [1, 1.0, 945, 1438, 810], [1, 1.0, 936, 1465, 865], [1, 1.0, 928, 1492, 920]],
    ),
    ColoredBananaGroup(
        group=200,
        map_id=Maps.FungiForest,
        name="Mushroom rocketbarrel liftoff !!",
        konglist=[Kongs.diddy],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 247, 487, 619],
            [1, 1.0, 247, 567, 619],
            [1, 1.1, 247, 646, 619],
            [1, 1.1, 247, 726, 619],
            [1, 1.2, 247, 805, 619],
            [1, 1.2, 247, 885, 619],
            [1, 1.3, 247, 964, 619],
            [1, 1.3, 247, 1044, 619],
            [1, 1.4, 247, 1123, 619],
            [1, 1.4, 247, 1203, 619],
            [1, 1.5, 247, 1282, 619],
            [1, 1.5, 247, 1362, 619],
            [1, 1.6, 247, 1441, 619],
            [1, 1.6, 247, 1521, 619],
            [1, 1.7, 247, 1600, 619],
        ],
    ),
    ColoredBananaGroup(
        group=201,
        map_id=Maps.FungiForest,
        name="Around the top of mushroom bonus barrel",
        konglist=[Kongs.diddy],
        region=Regions.GiantMushroomArea,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 980, 1618, 1118],
            [1, 1.0, 1023, 1618, 1058],
            [1, 1.0, 1023, 1618, 984],
            [1, 1.0, 980, 1618, 924],
            [1, 1.0, 909, 1618, 901],
            [1, 1.0, 838, 1618, 924],
            [1, 1.0, 795, 1618, 984],
            [1, 1.0, 795, 1618, 1058],
            [1, 1.0, 838, 1618, 1118],
            [1, 1.0, 909, 1618, 1141],
        ],
    ),
    ColoredBananaGroup(
        group=202,
        map_id=Maps.FungiForest,
        name="Around the first stump in owl tree area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 1315, 179, 2958],
            [1, 1.0, 1334, 189, 2933],
            [1, 1.0, 1334, 179, 2903],
            [1, 1.0, 1315, 189, 2878],
            [1, 1.0, 1286, 179, 2868],
            [1, 1.0, 1257, 189, 2878],
            [1, 1.0, 1238, 179, 2903],
            [1, 1.0, 1238, 189, 2933],
            [1, 1.0, 1257, 179, 2958],
            [1, 1.0, 1286, 189, 2968],
        ],
    ),
    ColoredBananaGroup(
        group=203,
        map_id=Maps.FungiForest,
        name="RABBIT",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 2224, 142, 3853],
            [1, 1.0, 2233, 142, 3841],
            [1, 1.0, 2233, 142, 3825],
            [1, 1.0, 2224, 142, 3813],
            [1, 1.0, 2209, 142, 3808],
            [1, 1.0, 2194, 142, 3813],
            [1, 1.0, 2185, 142, 3825],
            [1, 1.0, 2185, 142, 3841],
            [1, 1.0, 2194, 142, 3853],
            [1, 1.0, 2209, 142, 3858],
        ],
    ),
    ColoredBananaGroup(
        group=204,
        map_id=Maps.FungiForest,
        name="Grass near the rabbit's house",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 2323, 150, 3581],
            [1, 1.0, 2323, 160, 3581],
            [1, 1.0, 2323, 170, 3581],
            [1, 1.0, 2323, 180, 3581],
            [1, 2.0, 2323, 190, 3581],
            [1, 1.0, 2442, 171, 3991],
            [1, 1.0, 2442, 181, 3991],
            [1, 1.0, 2442, 191, 3991],
            [1, 1.0, 2442, 201, 3991],
            [1, 2.0, 2442, 211, 3991],
        ],
    ),
    ColoredBananaGroup(
        group=205,
        map_id=Maps.FungiForest,
        name="Grass near the owl tree rocketbarrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        locations=[
            [1, 1.0, 372, 195, 3764],
            [1, 1.0, 372, 205, 3764],
            [1, 1.0, 372, 215, 3764],
            [1, 1.0, 372, 225, 3764],
            [1, 2.0, 372, 235, 3764],
            [1, 1.0, 383, 190, 4112],
            [1, 1.0, 383, 200, 4112],
            [1, 1.0, 383, 210, 4112],
            [1, 1.0, 383, 220, 4112],
            [1, 2.0, 383, 230, 4112],
        ],
    ),
    ColoredBananaGroup(
        group=206,
        map_id=Maps.ForestAnthill,
        name="Central platform",
        konglist=[Kongs.tiny],
        region=Regions.Anthill,
        locations=[
            [1, 1.0, 634, 220, 635],
            [1, 1.0, 654, 220, 599],
            [1, 1.0, 647, 220, 559],
            [1, 1.0, 616, 220, 533],
            [1, 1.0, 574, 220, 533],
            [1, 1.0, 543, 220, 559],
            [1, 1.0, 536, 220, 599],
            [1, 1.0, 556, 220, 635],
            [1, 1.0, 595, 220, 649],
            [1, 1.0, 638, 229, 614],
            [1, 1.0, 638, 229, 564],
            [1, 1.0, 595, 229, 539],
            [1, 1.0, 552, 229, 564],
            [1, 1.0, 552, 229, 614],
            [1, 1.0, 595, 229, 639],
            [1, 1.0, 617, 235, 596],
            [1, 1.0, 609, 235, 570],
            [1, 1.0, 581, 235, 570],
            [1, 1.0, 573, 235, 596],
            [1, 1.0, 595, 235, 612],
        ],
    ),
    ColoredBananaGroup(
        group=207,
        map_id=Maps.ForestThornvineBarn,
        name="Near the trough",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        locations=[
            [1, 1.0, 367, 0, 545],
            [1, 1.0, 396, 0, 505],
            [1, 1.0, 396, 0, 455],
            [1, 1.0, 367, 0, 415],
            [1, 1.0, 320, 0, 400],
            [1, 1.0, 273, 0, 415],
            [1, 1.0, 244, 0, 455],
            [1, 1.0, 244, 0, 505],
            [1, 1.0, 273, 0, 545],
            [1, 1.0, 320, 0, 560],
        ],
    ),
    ColoredBananaGroup(
        group=208,
        map_id=Maps.ForestThornvineBarn,
        name="In the fairy box",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarnAboveLadder,
        logic=lambda l: l.Slam,
        locations=[[5, 1.0, 496, 145, 505]],
    ),
    ColoredBananaGroup(
        group=209,
        map_id=Maps.ForestThornvineBarn,
        name="Between vines to bonus barrel",
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        logic=lambda l: l.CanSlamSwitch(Levels.FungiForest, 1) and l.climbing and l.can_use_vines,
        locations=[[5, 1.2, 325, 202, 407]],
    ),
    ColoredBananaGroup(group=210, map_id=Maps.ForestRafters, name="Above the entrance", konglist=[Kongs.diddy], region=Regions.MillRafters, locations=[[5, 1.0, 368, 48, 42]]),
    ColoredBananaGroup(
        group=211,
        map_id=Maps.ForestMillAttic,
        name="Flour bags",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillAttic,
        locations=[
            [1, 1.0, 326, 4, 117],
            [1, 1.0, 369, 14, 131],
            [1, 1.0, 399, 2, 247],
            [1, 1.0, 431, 10, 261],
            [1, 1.0, 417, 12, 302],
            [1, 1.0, 324, 37, 439],
            [1, 1.0, 232, 13, 397],
            [1, 1.0, 188, 18, 352],
            [1, 1.0, 148, 12, 216],
            [1, 1.0, 121, 11, 195],
        ],
    ),
    ColoredBananaGroup(
        group=212,
        map_id=Maps.ForestWinchRoom,
        name="Winch rope",
        konglist=[Kongs.diddy],
        region=Regions.WinchRoom,
        locations=[[1, 1.0, 237, 9, 200], [1, 1.0, 237, 9, 254], [1, 1.0, 237, 9, 308], [1, 1.0, 237, 9, 362], [1, 1.0, 237, 9, 416]],
    ),
    ColoredBananaGroup(group=213, map_id=Maps.ForestWinchRoom, name="On the broken switch", konglist=[Kongs.diddy], region=Regions.WinchRoom, locations=[[5, 1.0, 290, 19, 168]]),
    ColoredBananaGroup(
        group=214,
        map_id=Maps.ForestMillFront,
        name="In the nooks in the rafters",  # Hard
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.GrinderRoom,
        locations=[[5, 1.0, 45, 170, 362], [5, 1.0, 182, 170, 96]],
    ),
    ColoredBananaGroup(
        group=215,
        map_id=Maps.ForestMillFront,
        name="Keg Bouldertech above the entrance",  # Hard
        konglist=[Kongs.diddy],
        region=Regions.GrinderRoom,
        logic=lambda l: l.chunky and l.barrels,
        locations=[[1, 1.0, 627, 137, 487], [1, 1.0, 627, 137, 461], [1, 1.0, 627, 137, 434], [1, 1.0, 627, 137, 408], [1, 1.0, 627, 137, 382]],
    ),
    ColoredBananaGroup(
        group=216,
        map_id=Maps.ForestMillFront,
        name="On the pile of boxes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        locations=[
            [1, 1.0, 109, 50, 94],
            [1, 1.0, 90, 33, 184],
            [1, 1.0, 140, 31, 81],
            [1, 1.0, 128, 35, 137],
            [1, 1.0, 93, 50, 142],
        ],
    ),
    ColoredBananaGroup(
        group=217,
        map_id=Maps.ForestMillFront,
        name="On the wooden wall",
        konglist=[Kongs.donkey, Kongs.lanky, Kongs.chunky],
        region=Regions.GrinderRoom,
        logic=lambda l: l.chunky and l.barrels,
        locations=[[1, 1.0, 45, 70, 364], [1, 1.0, 73, 70, 364], [1, 1.0, 101, 70, 364], [1, 1.0, 129, 70, 364], [1, 1.0, 157, 70, 364]],
    ),
    ColoredBananaGroup(
        group=218,
        map_id=Maps.ForestMillFront,
        name="Between the levers",
        konglist=[Kongs.donkey],
        region=Regions.GrinderRoom,
        logic=lambda l: l.CanSlamSwitch(Levels.FungiForest, 2) or l.generalclips or l.CanPhase(),
        locations=[
            [5, 1.0, 530, 5, 179],
            [5, 1.0, 467, 5, 179],
        ],
    ),
    ColoredBananaGroup(
        group=219,
        map_id=Maps.ForestMillFront,
        name="Near the boxes",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        locations=[[1, 1.0, 184, 0, 90], [1, 1.0, 184, 0, 154], [1, 1.0, 184, 0, 217], [1, 1.0, 184, 0, 281], [1, 1.0, 184, 0, 344]],
    ),
    ColoredBananaGroup(
        group=220,
        map_id=Maps.ForestMillBack,
        name="Flour bags",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        locations=[
            [1, 1.0, 403, 0, 373],
            [1, 1.0, 405, 6, 358],
            [1, 1.0, 421, 2, 361],
            [1, 1.0, 436, 0, 351],
            [1, 1.0, 543, 0, 527],
            [1, 1.0, 543, 0, 477],
            [1, 1.0, 500, 0, 452],
            [1, 1.0, 457, 0, 477],
            [1, 1.0, 457, 0, 527],
            [1, 1.0, 500, 0, 552],
        ],
    ),
    ColoredBananaGroup(
        group=221,
        map_id=Maps.ForestMillBack,
        name="Keg Bouldertech up the high wooden wall",
        konglist=[Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        logic=lambda l: l.barrels,
        locations=[[1, 1.0, 243, 140, 157], [1, 1.0, 243, 140, 174], [1, 1.0, 243, 140, 191], [1, 1.0, 243, 140, 208], [1, 1.0, 243, 140, 225]],
    ),
    ColoredBananaGroup(
        group=222,
        map_id=Maps.ForestMillBack,
        name="Box area near spider",
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        locations=[[1, 1.0, 99, 4, 382], [1, 1.0, 130, 4, 382], [1, 1.0, 162, 4, 382], [1, 1.0, 193, 4, 382], [1, 1.0, 224, 4, 382]],
    ),
    ColoredBananaGroup(
        group=223,
        map_id=Maps.ForestGiantMushroom,
        name="Around the headphones pillar",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLower,
        locations=[
            [1, 1.0, 493, 0, 680],
            [1, 1.0, 497, 0, 637],
            [1, 1.0, 450, 0, 606],
            [1, 1.0, 402, 0, 631],
            [1, 1.0, 409, 0, 689],
        ],
    ),
    ColoredBananaGroup(
        group=224,
        map_id=Maps.ForestGiantMushroom,
        name="Pineapple switch of legends",
        konglist=[Kongs.donkey, Kongs.lanky, Kongs.chunky],
        region=Regions.MushroomLower,
        locations=[[5, 1.0, 454, 104, 155]],
    ),
    ColoredBananaGroup(
        group=225, map_id=Maps.ForestGiantMushroom, name="Coconut switch of legends", konglist=[Kongs.diddy, Kongs.tiny], region=Regions.MushroomLower, locations=[[5, 1.0, 454, 154, 155]]
    ),
    ColoredBananaGroup(
        group=226,
        map_id=Maps.ForestGiantMushroom,
        name="Torch near Tiny's bonus barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerMid,
        locations=[[5, 1.0, 556, 472, 147]],
    ),
    ColoredBananaGroup(
        group=227,
        map_id=Maps.ForestGiantMushroom,
        name="Near the u-turn ladder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        locations=[[5, 1.0, 649, 759, 830]],
    ),
    ColoredBananaGroup(
        group=228,
        map_id=Maps.ForestGiantMushroom,
        name="Near the vines to night door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        locations=[
            [1, 1.0, 164, 979, 497],
            [1, 1.0, 192, 979, 471],
            [1, 1.0, 240, 979, 467],
            [1, 1.0, 275, 979, 502],
            [1, 1.0, 280, 979, 538],
            [1, 1.0, 252, 979, 578],
            [1, 1.0, 205, 979, 583],
            [1, 1.0, 167, 979, 570],
            [1, 1.0, 151, 979, 545],
            [1, 1.0, 151, 979, 518],
        ],
    ),
    ColoredBananaGroup(
        group=229,
        map_id=Maps.ForestGiantMushroom,
        name="Near the one vine jump",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperVineFloor,
        locations=[
            [1, 1.0, 833, 1252, 451],
            [1, 1.0, 808, 1253, 452],
            [1, 1.0, 782, 1254, 454],
            [1, 1.0, 757, 1255, 455],
            [1, 1.0, 732, 1256, 456],
            [1, 1.0, 829, 1261, 620],
            [1, 1.0, 805, 1261, 616],
            [1, 1.0, 781, 1261, 612],
            [1, 1.0, 757, 1261, 608],
            [1, 1.0, 733, 1261, 604],
        ],
    ),
    ColoredBananaGroup(
        group=230,
        map_id=Maps.ForestGiantMushroom,
        name="Top of mushroom dead end",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        locations=[
            [1, 1.0, 504, 1839, 871],
            [1, 1.0, 591, 1839, 851],
            [1, 1.0, 692, 1839, 788],
            [1, 1.0, 745, 1839, 706],
            [1, 1.0, 780, 1839, 604],
        ],
    ),
    ColoredBananaGroup(
        group=231,
        map_id=Maps.ForestGiantMushroom,
        name="Twirl from the tippy top",
        konglist=[Kongs.tiny],
        region=Regions.MushroomUpper,
        logic=lambda l: l.twirl,
        locations=[
            [1, 1.1, 543, 1869, 554],
            [1, 1.1, 466, 1861, 563],
            [1, 1.1, 386, 1841, 571],
            [1, 1.1, 310, 1777, 580],
            [1, 1.1, 233, 1664, 588],
        ],
    ),
    ColoredBananaGroup(
        group=232,
        map_id=Maps.ForestLankyZingersRoom,
        name="Middle",
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyZingersRoom,
        locations=[
            [1, 1.0, 274, 0, 340],
            [1, 1.0, 326, 0, 333],
            [1, 1.0, 288, 0, 296],
            [1, 1.0, 297, 0, 243],
            [1, 1.0, 250, 0, 268],
            [1, 1.0, 203, 0, 243],
            [1, 1.0, 212, 0, 296],
            [1, 1.0, 174, 0, 333],
            [1, 1.0, 226, 0, 340],
            [1, 1.0, 250, 0, 388],
        ],
    ),
    ColoredBananaGroup(
        group=233,
        map_id=Maps.ForestLankyMushroomsRoom,
        name="Kong faces",
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyMushroomsRoom,
        locations=[
            [1, 1.4, 216, 60, 464],
            [1, 1.3, 186, 48, 452],
            [1, 1.2, 226, 25, 469],
            [1, 1.1, 202, 22, 459],
            [1, 1.0, 178, 12, 450],
        ],
    ),
    ColoredBananaGroup(
        group=234,
        map_id=Maps.ForestChunkyFaceRoom,
        name="Towards the switch",
        konglist=[Kongs.chunky],
        region=Regions.MushroomChunkyRoom,
        locations=[[1, 1.0, 103, 0, 235], [1, 1.0, 148, 0, 251], [1, 1.0, 192, 0, 267], [1, 1.0, 237, 0, 283], [1, 1.0, 281, 0, 299]],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.FungiForest,
        name="Above apple GB",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2965, 360, 1909], [3144, 370, 1997], [3025, 360, 2163]],
    ),
    Balloon(
        id=2,
        map_id=Maps.FungiForest,
        name="By blue wall near Minecart",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2978, 320, 2691], [2878, 310, 2833], [2715, 315, 2852]],
    ),
    Balloon(
        id=3,
        map_id=Maps.FungiForest,
        name="Around roof of minecart",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2278, 390, 3000], [2342, 380, 3180], [2205, 385, 3300], [2010, 380, 3171], [2090, 385, 2986]],
    ),
    Balloon(
        id=4,
        map_id=Maps.FungiForest,
        name="High against wall between pink tunnel and minecart",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[1877, 500, 2207], [1920, 500, 2500]],
    ),
    Balloon(
        id=5,
        map_id=Maps.FungiForest,
        name="Behind clock",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2220, 720, 2460], [2220, 720, 2150]],
    ),
    Balloon(
        id=6,
        map_id=Maps.FungiForest,
        name="Near blue tunnel mill side",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[4000, 430, 2780], [3860, 420, 2848], [3717, 425, 2974]],
    ),
    Balloon(
        id=7,
        map_id=Maps.FungiForest,
        name="Next to conveyor GB box",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[4368, 200, 3510], [4402, 200, 3548]],
    ),
    Balloon(
        id=8,
        map_id=Maps.FungiForest,
        name="Side of Mill where back entrance is",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[4617, 300, 3669], [4423, 295, 3845]],
    ),
    Balloon(
        id=9,
        map_id=Maps.FungiForest,
        name="Above back tag barrel (Mill area)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[4847, 420, 4219], [4677, 420, 4383]],
    ),
    Balloon(
        id=10,
        map_id=Maps.FungiForest,
        name="Barn area right side",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        points=[[4500, 270, 1852], [4350, 275, 1636], [4128, 270, 1424], [4270, 265, 1700]],
    ),
    Balloon(
        id=11,
        map_id=Maps.FungiForest,
        name="Barn area left side",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        points=[[3684, 260, 2300], [3563, 265, 2229], [3497, 260, 2073], [3627, 255, 2141]],
    ),
    Balloon(
        id=12,
        map_id=Maps.FungiForest,
        name="Around beanstalk",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        points=[
            [2231, 380, 500],
            [2029, 385, 406],
            [1909, 390, 483],
            [1916, 395, 720],
            [2082, 390, 767],
            [2261, 385, 731],
        ],
    ),
    Balloon(
        id=13,
        map_id=Maps.FungiForest,
        name="At first giant mushroom level by rocketbarrel barrel",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomBlastLevelExterior,
        points=[[523, 590, 505], [245, 580, 819]],
    ),
    Balloon(
        id=14,
        map_id=Maps.FungiForest,
        name="By second level entrance",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMidExterior,
        points=[[870, 920, 1253], [710, 925, 1430]],
    ),
    Balloon(
        id=15,
        map_id=Maps.FungiForest,
        name="By high W5",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        points=[[370, 1400, 1390], [263, 1405, 1140]],
    ),
    Balloon(
        id=16,
        map_id=Maps.FungiForest,
        name="By T&S on top of giant mushroom",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        points=[[1157, 1400, 1310], [1245, 1395, 1201]],
    ),
    Balloon(
        id=17,
        map_id=Maps.FungiForest,
        name="By battle crown",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperExterior,
        points=[[1331, 1180, 1256], [1185, 1180, 1242], [1218, 1180, 1393]],
    ),
    Balloon(
        id=18,
        map_id=Maps.FungiForest,
        name="By yellow tunnel tree side",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        points=[[1390, 400, 2759], [1168, 400, 2755]],
    ),
    Balloon(
        id=19,
        map_id=Maps.FungiForest,
        name="Rabbit race",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        points=[
            [2316, 280, 3576],
            [2506, 285, 3707],
            [2529, 290, 3864],
            [2414, 285, 3972],
            [2247, 280, 4036],
            [2414, 285, 3972],
            [2529, 290, 3864],
            [2506, 285, 3707],
        ],
    ),
    Balloon(
        id=20,
        map_id=Maps.FungiForest,
        name="By T&S portal (tree area)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        points=[[445, 300, 3948], [348, 290, 3738], [558, 295, 3779]],
    ),
    Balloon(
        id=21,
        map_id=Maps.FungiForest,
        name="Above tree",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.HollowTreeArea,
        logic=lambda l: l.jetpack,
        points=[[1059, 680, 3804], [1255, 680, 4061], [1439, 680, 3804], [1255, 680, 3650]],
    ),
    Balloon(
        id=22,
        map_id=Maps.ForestMillFront,
        name="Middle of the room",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        points=[[424, 120, 448], [239, 120, 406], [268, 120, 232]],
    ),
    Balloon(
        id=23,
        map_id=Maps.ForestGiantMushroom,
        name="Diddy BP floor",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomMiddle,
        points=[[490, 700, 699], [426, 690, 521], [608, 690, 442], [662, 700, 638]],
    ),
    Balloon(
        id=24,
        map_id=Maps.ForestGiantMushroom,
        name="Oranges level",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperVineFloor,
        points=[[393, 1290, 451], [555, 1280, 415], [555, 1290, 562], [404, 1280, 621]],
    ),
    Balloon(
        id=25,
        map_id=Maps.ForestMillBack,
        name="Middle of room",
        speed=5,
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        points=[[423, 120, 317], [454, 120, 558]],
    ),
    Balloon(
        id=26,
        map_id=Maps.FungiForest,
        name="In front of Snide (Diddy)",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        vanilla=True,
        points=[[3233, 349, 3638], [3242, 327, 3550], [3180, 345, 3477]],
    ),
    Balloon(
        id=27,
        map_id=Maps.FungiForest,
        name="Above Tiny's blueprint (Tiny)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLowerExterior,
        vanilla=True,
        points=[[1103, 551, 593], [1264, 551, 742]],
    ),
    Balloon(
        id=28,
        map_id=Maps.FungiForest,
        name="Behind Diddy's barn (Donkey)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        vanilla=True,
        points=[[3245, 372, 4549], [3131, 358, 4449], [3098, 364, 4318]],
    ),
    Balloon(
        id=29,
        map_id=Maps.FungiForest,
        name="Above Chunky's blueprint (Chunky)",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomNightExterior,
        vanilla=True,
        points=[[666, 1049, 612], [791, 1049, 573]],
    ),
    Balloon(
        id=30,
        map_id=Maps.FungiForest,
        name="By DK's blueprint (Tiny)",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        vanilla=True,
        points=[[3500, 219, 1353], [3641, 220, 1261]],
    ),
    Balloon(
        id=31,
        map_id=Maps.ForestWinchRoom,
        name="In winch room (Diddy)",
        speed=7,
        konglist=[Kongs.diddy],
        region=Regions.WinchRoom,
        vanilla=True,
        points=[[344, 72, 180], [338, 78, 371]],
    ),
    Balloon(
        id=32,
        map_id=Maps.ForestMillFront,
        name="In DK's lever room (Donkey)",
        speed=7,
        konglist=[Kongs.donkey],
        region=Regions.GrinderRoom,
        vanilla=True,
        logic=lambda l: (l.CanSlamSwitch(Levels.FungiForest, 2) or l.generalclips or l.CanPhase()),
        points=[[399, 94, 117], [606, 90, 115]],
    ),
    Balloon(
        id=33,
        map_id=Maps.ForestGiantMushroom,
        name="Top of giant mushroom interior (Lanky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        vanilla=True,
        points=[[420, 1903, 705], [468, 1934, 356]],
    ),
    Balloon(
        id=34,
        map_id=Maps.ForestGiantMushroom,
        name="Bottom of giant mushroom (Lanky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomLower,
        vanilla=True,
        points=[[366, 150, 524], [353, 146, 378], [498, 144, 347], [533, 150, 487]],
    ),
    Balloon(
        id=35,
        map_id=Maps.ForestChunkyFaceRoom,
        name="Chunky's face puzzle room (Chunky)",
        speed=10,
        konglist=[Kongs.chunky],
        region=Regions.MushroomChunkyRoom,
        vanilla=True,
        points=[[195, 66, 183], [302, 62, 178], [368, 70, 247], [381, 76, 355], [300, 64, 436]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=36,
        map_id=Maps.FungiForest,
        name="Blue tunnel",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[3279, 220, 2529], [3470, 205, 2565], [3424, 220, 2751], [3457, 205, 2888], [3561, 225, 3037], [3457, 205, 2888], [3424, 220, 2751], [3470, 205, 2565]],
    ),
    Balloon(
        id=37,
        map_id=Maps.FungiForest,
        name="Pink tunnel",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[1703, 220, 2004], [1634, 214, 1828], [1755, 200, 1720], [1625, 250, 1559], [1755, 200, 1720], [1634, 214, 1828]],
    ),
    Balloon(
        id=38,
        map_id=Maps.FungiForest,
        name="Around the clock tree trunk",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2485, 435, 2287], [2360, 470, 2254], [2345, 450, 2338], [2407, 417, 2422], [2518, 481, 2374]],
    ),
    Balloon(
        id=39,
        map_id=Maps.FungiForest,
        name="Cuckoo! Tweet tweet !!",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2626, 745, 2325], [2470, 745, 2325], [2471, 745, 2325]],
    ),
    Balloon(
        id=40,
        map_id=Maps.FungiForest,
        name="Green tunnel",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        logic=lambda l: l.hasMoveSwitchsanity(Switches.FungiGreenFeather, False) or l.CanPhase() or l.CanPhaseswim(),
        points=[[2763, 224, 1536], [2811, 247, 1418], [2922, 277, 1473], [3068, 220, 1413], [2922, 277, 1473], [2811, 247, 1418]],
    ),
    Balloon(
        id=41,
        map_id=Maps.FungiForest,
        name="Above the apple",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.WormArea,
        points=[[3202, 333, 839], [3052, 335, 826], [3049, 310, 638], [3276, 355, 705]],
    ),
    Balloon(
        id=42,
        map_id=Maps.FungiForest,
        name="Minecart well",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.FungiForestStart,
        points=[[2233, 170, 3187], [2176, 219, 3159], [2116, 180, 3154]],
    ),
    Balloon(
        id=43,
        map_id=Maps.FungiForest,
        name="Waterwheel",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[4066, 227, 3310], [4015, 296, 3383], [3950, 192, 3434], [4014, 120, 3383]],
    ),
    Balloon(
        id=44,
        map_id=Maps.FungiForest,
        name="Minecart exit",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[5342, 238, 3680], [5342, 315, 3687]],
    ),
    Balloon(
        id=45,
        map_id=Maps.FungiForest,
        name="Front mill front door to attic",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillArea,
        points=[[4228, 180, 3645], [4126, 186, 3753], [4102, 266, 3804], [4088, 365, 3735], [4173, 341, 3696], [4250, 320, 3621]],
    ),
    Balloon(
        id=46,
        map_id=Maps.FungiForest,
        name="In front of thornvine barn",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        points=[[4056, 200, 2192], [4178, 205, 2066], [4069, 280, 2027]],
    ),
    Balloon(
        id=47,
        map_id=Maps.FungiForest,
        name="Hopping the thorns behind thornvine barn",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ThornvineArea,
        points=[[3763, 123, 1746], [3735, 300, 1664], [3728, 125, 1581], [3735, 300, 1664]],
    ),
    Balloon(
        id=48,
        map_id=Maps.FungiForest,
        name="In front of the giant mushroom",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        points=[[1034, 279, 1453], [1232, 248, 1324], [1358, 270, 1076], [1162, 282, 1236]],
    ),
    Balloon(
        id=49,
        map_id=Maps.FungiForest,
        name="Around mushroom near rocketbarrel (mushroom side)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        points=[[216, 330, 896], [179, 344, 1036], [338, 295, 956]],
    ),
    Balloon(
        id=50,
        map_id=Maps.FungiForest,
        name="Under the lower kasplat mushroom platform",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GiantMushroomArea,
        points=[[1123, 348, 698], [1289, 348, 693], [1165, 348, 553]],
    ),
    Balloon(
        id=51,
        map_id=Maps.FungiForest,
        name="Yellow tunnel",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        points=[[564, 200, 2040], [914, 250, 1916], [1083, 204, 2187], [914, 250, 1916]],
    ),
    Balloon(
        id=52,
        map_id=Maps.FungiForest,
        name="Around the anthill",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.HollowTreeArea,
        points=[[1272, 384, 4635], [1192, 370, 4738], [1277, 373, 4850], [1383, 385, 4808], [1379, 366, 4685]],
    ),
    Balloon(
        id=53,
        map_id=Maps.ForestAnthill,
        name="Around the cannon",
        speed=5,
        konglist=[Kongs.tiny],
        region=Regions.Anthill,
        points=[[499, 277, 671], [440, 262, 864], [324, 285, 731]],
    ),
    Balloon(
        id=54,
        map_id=Maps.ForestThornvineBarn,
        name="Ladder side",
        speed=8,
        konglist=[Kongs.donkey],
        region=Regions.ThornvineBarn,
        points=[[89, 80, 170], [90, 20, 283], [82, 100, 360], [151, 25, 434], [71, 102, 522], [139, 39, 588], [50, 92, 628]],
    ),
    Balloon(
        id=55,
        map_id=Maps.ForestGiantMushroom,
        name="Around the vines to night door",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpperMid,
        points=[[419, 1040, 352], [492, 987, 481], [446, 1086, 631]],
    ),
    Balloon(
        id=56,
        map_id=Maps.ForestGiantMushroom,
        name="Behind the highest ladder",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MushroomUpper,
        points=[[667, 1757, 245], [728, 1746, 374], [738, 1670, 304], [644, 1775, 306]],
    ),
    Balloon(
        id=57,
        map_id=Maps.ForestLankyZingersRoom,
        name="High up",
        speed=3,
        konglist=[Kongs.lanky],
        region=Regions.MushroomLankyZingersRoom,
        points=[[246, 195, 247], [244, 195, 319]],
    ),
    Balloon(
        id=58,
        map_id=Maps.ForestMillAttic,
        name="Enemy hole",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.MillAttic,
        points=[[289, 103, 364], [305, 96, 494]],
    ),
    Balloon(
        id=59,
        map_id=Maps.ForestMillFront,
        name="Wooden wall",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GrinderRoom,
        points=[[83, 22, 412], [95, 140, 362], [129, 26, 308], [95, 140, 362]],
    ),
    Balloon(
        id=60,
        map_id=Maps.ForestMillBack,
        name="Back corner",
        speed=6,
        konglist=[Kongs.tiny, Kongs.chunky],
        region=Regions.MillChunkyTinyArea,
        points=[[383, 133, 597], [162, 100, 588]],
    ),
]
