"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Settings import RemovedBarriersSelected
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

WATER_HEIGHT = 20

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.CrystalCaves,
        name="Around DK portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1646, -29, 317],
            [1, 1.0, 1704, -29, 353],
            [1, 1.0, 1773, -29, 365],
            [1, 1.0, 1817, -29, 336],
            [1, 1.0, 1848, -29, 310],
            [1, 1.0, 1641, -29, 123],
            [1, 1.0, 1696, -29, 81],
            [1, 1.0, 1745, -29, 75],
            [1, 1.0, 1794, -29, 88],
            [1, 1.0, 1847, -29, 125],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.CrystalCaves,
        name="Around room by ice wall to Gorilla Gone GB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2262, 13, 352],
            [1, 1.0, 2307, 13, 283],
            [1, 1.0, 2306, 13, 158],
            [1, 1.0, 2185, 13, 119],
            [1, 1.0, 2078, 13, 124],
        ],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.CrystalCaves,
        name="Gorilla Gone Tunnel (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesGGRoom,
        locations=[
            [1, 1.0, 2494, 13, 188],
            [1, 1.0, 2570, 13, 244],
            [1, 1.0, 2424.140380859375, 13.5, 199.2799530029297],
            [1, 1.0, 2562.489990234375, 13.5, 182.75860595703125],
            [1, 1.0, 2580.22900390625, 13.5, 325.37249755859375],
        ],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.CrystalCaves,
        name="Around Gorilla Gone room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesGGRoom,
        locations=[
            [1, 1.0, 2502, 13, 390],
            [1, 1.0, 2465, 13, 445],
            [1, 1.0, 2449, 13, 526],
            [1, 1.0, 2491, 13, 581],
            [1, 1.0, 2555, 13, 618],
            [1, 1.0, 2611, 13, 613],
            [1, 1.0, 2659, 13, 583],
            [1, 1.0, 2704, 13, 517],
            [1, 1.0, 2682, 13, 422],
            [1, 1.0, 2650, 13, 382],
        ],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.CrystalCaves,
        name="Left side of first warps up the path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2304, 80, 709],
            [1, 1.0, 2364, 92, 738],
            [1, 1.0, 2432, 106, 770],
            [1, 1.0, 2509, 120, 790],
            [1, 1.0, 2579, 136, 797],
            [1, 1.0, 2654, 150, 800],
            [1, 1.0, 2785, 164, 767],
            [1, 1.0, 2737, 159, 817],
            [1, 1.0, 2690, 159, 859],
            [1, 1.0, 2651, 159, 895],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.CrystalCaves,
        name="On crystals on each side of W4 Mini Monkey room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 3066, 305, 673], [5, 1.0, 3197, 310, 772]],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.CrystalCaves,
        name="On Mini Monkey barrel ledge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 3171, 275, 1026], [5, 1.0, 3102, 265, 1149]],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.CrystalCaves,
        name="Next to Funky's store",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2859, 285, 1327], [5, 1.0, 2862, 285, 1287]],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.CrystalCaves,
        name="On monkeyport pad by W4",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBlueprintCave,
        locations=[[5, 1.0, 3530, 300, 731]],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.CrystalCaves,
        name="Mini Monkey tunnel to W4",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBlueprintCave,
        locations=[
            [1, 1.0, 3179, 287, 647],
            [1, 1.0, 3206, 287, 581],
            [1, 1.0, 3233, 287, 516],
            [1, 1.0, 3296, 287, 553],
            [1, 1.0, 3377, 287, 602],
        ],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.CrystalCaves,
        name="On crystal platforms to Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2617, 151, 1229],
            [1, 1.0, 2659, 197, 1249],
            [1, 1.0, 2537, 157, 1280],
            [1, 1.0, 2581, 177, 1304],
            [1, 1.0, 2458, 148, 1331],
        ],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.CrystalCaves,
        name="On crystal platforms to Ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2401, 90, 1319],
            [1, 1.0, 2358, 122, 1303],
            [1, 1.0, 2364, 178, 1344],
            [1, 1.0, 2317, 155, 1282],
            [1, 1.0, 2322, 228, 1329],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.CrystalCaves,
        name="On ice tomato switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2292, 270, 1065]],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.CrystalCaves,
        name="On Beetle Race switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2275, 270, 900]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.CrystalCaves,
        name="On Baboon Balloon pads",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2129, 270, 900]],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.CrystalCaves,
        name="On Baboon Balloon pads",
        konglist=[Kongs.diddy, Kongs.lanky, Kongs.tiny],
        region=Regions.CrystalCavesMain,
        logic=lambda l: l.isdiddy or l.istiny or (l.islanky and (l.balloon or l.monkey_maneuvers)),
        locations=[[5, 1.0, 2179, 355, 943]],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.CrystalCaves,
        name="To and around boulder by ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2051, 261, 1020],
            [1, 1.0, 1990, 276, 1040],
            [1, 1.0, 1923, 284, 1053],
            [1, 1.0, 1861, 288, 1057],
            [1, 1.0, 1776, 280, 1053],
            [1, 1.0, 1718, 277, 1012],
            [1, 1.0, 1677, 277, 957],
            [1, 1.0, 1614, 277, 998],
            [1, 1.0, 1646, 277, 1058],
            [1, 1.0, 1700, 277, 1053],
        ],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.CrystalCaves,
        name="Path from boulder to boulder switch (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1466, 315, 1081],
            [1, 1.0, 1529, 294, 1066],
            [1, 1.0, 1557.0797119140625, 284.9925231933594, 1056.4324951171875],
            [1, 1.0, 1501.0552978515625, 305.3791809082031, 1074.7030029296875],
            [1, 1.0, 1425.8890380859375, 331.49560546875, 1095.5513916015625],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.CrystalCaves,
        name="On plank to DK BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1698, 285, 903],
            [1, 1.0, 1697, 286, 877],
            [1, 1.0, 1695, 288, 852],
            [1, 1.0, 1693, 290, 827],
            [1, 1.0, 1691, 292, 802],
        ],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.CrystalCaves,
        name="Warps to Cranky slope",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2089, 64, 677],
            [1, 1.0, 1981, 68, 706],
            [1, 1.0, 1869, 82, 750],
            [1, 1.0, 1769, 97, 813],
            [1, 1.0, 1677, 101, 839],
            [1, 1.0, 1559, 100, 868],
            [1, 1.0, 1503, 95, 984],
            [1, 1.0, 1500, 92, 1083],
            [1, 1.0, 1461, 93, 1187],
            [1, 1.0, 1400, 102, 1301],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.CrystalCaves,
        name="In front of Snide's (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesSnideArea,
        locations=[
            [1, 1.0, 1352, 77, 673],
            [1, 1.0, 1293, 64, 572],
            [1, 1.0, 1391.2589111328125, 91.0971908569336, 725.7455444335938],
            [1, 1.0, 1317.0999755859375, 64.5, 613.0414428710938],
            [1, 1.0, 1263.7100830078125, 64.5, 519.2013549804688],
        ],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.CrystalCaves,
        name="Next to headphones by Snide's",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesSnideArea,
        locations=[[5, 1.0, 1394, 70, 516], [5, 1.0, 1375, 70, 443]],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.CrystalCaves,
        name="On slippery slope to Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 1240, 200, 1483], [5, 1.0, 1294, 200, 1545]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.CrystalCaves,
        name="Above Baboon Blast pad",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.CrystalCavesMain,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.balloon and l.islanky),
        locations=[[5, 1.0, 1326, 428, 2174], [5, 1.0, 1356, 431, 2263], [5, 1.0, 1386, 434, 2352]],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.CrystalCaves,
        name="From BBlast pad to Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1301, 301, 2147],
            [1, 1.0, 1274, 318, 2045],
            [1, 1.0, 1259, 327, 1933],
            [1, 1.0, 1238, 312, 1848],
            [1, 1.0, 1186, 294, 1747],
        ],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.CrystalCaves,
        name="On crystal platforms to ice castle (right side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1880, 148, 1349],
            [1, 1.0, 1914, 177, 1319],
            [1, 1.0, 1927, 197, 1366],
            [1, 1.0, 1963, 237, 1337],
            [1, 1.0, 1950, 172, 1183],
            [1, 1.0, 2065, 151, 1146],
            [1, 1.0, 2032, 151, 1233],
            [1, 1.0, 2003, 177, 1309],
            [1, 1.0, 2038, 197, 1278],
            [1, 1.0, 2081, 257, 1297],
        ],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.CrystalCaves,
        name="Vertical lines in alcoves between ice castle and BBlast",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1530, 30, 1922],
            [1, 1.0, 1530, 62, 1922],
            [1, 1.0, 1530, 94, 1922],
            [1, 1.0, 1530, 126, 1922],
            [1, 1.0, 1530, 158, 1922],
            [1, 1.0, 1557, 40, 2051],
            [1, 1.0, 1557, 75, 2051],
            [1, 1.0, 1557, 110, 2051],
            [1, 1.0, 1557, 145, 2051],
            [1, 1.0, 1557, 180, 2051],
            [1, 1.0, 1570, 45, 2180],
            [1, 1.0, 1570, 90, 2180],
            [1, 1.0, 1570, 135, 2180],
            [1, 1.0, 1570, 180, 2180],
            [1, 1.0, 1570, 225, 2180],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.CrystalCaves,
        name="Vertical line in alcove between BBlast and Mini Monkey W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1224, 30, 2480],
            [1, 1.0, 1224, 55, 2480],
            [1, 1.0, 1224, 80, 2480],
            [1, 1.0, 1224, 105, 2480],
            [1, 1.0, 1224, 130, 2480],
            [1, 1.0, 1224, 155, 2480],
            [1, 1.0, 1224, 180, 2480],
            [1, 1.0, 1224, 205, 2480],
            [1, 1.0, 1224, 230, 2480],
            [1, 1.0, 1224, 255, 2480],
        ],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.CrystalCaves,
        name="In front of Mini Monkey W3 tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 822, 185, 2348]],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.CrystalCaves,
        name="On path between BBlast and Mini Monkey W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1109, 197, 2385],
            [1, 1.0, 1158, 219, 2433],
            [1, 1.0, 1195, 236, 2463],
            [1, 1.0, 1271, 271, 2477],
            [1, 1.0, 1319, 290, 2475],
        ],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.CrystalCaves,
        name="On path between ice castle and BBlast",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 1547, 299, 2366],
            [1, 1.0, 1562, 278, 2298],
            [1, 1.0, 1574, 246, 2230],
            [1, 1.0, 1561, 198, 2113],
            [1, 1.0, 1535, 167, 1990],
            [1, 1.0, 1508, 130, 1857],
            [1, 1.0, 1520, 105, 1747],
            [1, 1.0, 1557, 84, 1656],
            [1, 1.0, 1619, 58, 1577],
            [1, 1.0, 1691, 64, 1476],
        ],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.CrystalCaves,
        name="Around Mini Monkey W3 room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBonusCave,
        locations=[
            [1, 1.0, 541, 180, 2606],
            [1, 1.0, 455, 180, 2642],
            [1, 1.0, 349, 180, 2591],
            [1, 1.0, 328, 180, 2541],
            [1, 1.0, 333, 180, 2434],
            [1, 1.0, 375, 180, 2366],
            [1, 1.0, 428, 180, 2332],
            [1, 1.0, 510, 180, 2331],
            [1, 1.0, 574, 180, 2381],
            [1, 1.0, 596, 180, 2453],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.CrystalCaves,
        name="In Mini Monkey W3 tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBonusCave,
        locations=[
            [1, 1.0, 801, 180, 2434],
            [1, 1.0, 795, 180, 2504],
            [1, 1.0, 788, 180, 2574],
            [1, 1.0, 710, 180, 2557],
            [1, 1.0, 633, 180, 2539],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.CrystalCaves,
        name="In water around 5DI",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.2, 901, WATER_HEIGHT, 1400],
            [1, 1.2, 898, WATER_HEIGHT, 1270],
            [1, 1.2, 808, WATER_HEIGHT, 1129],
            [1, 1.2, 673, WATER_HEIGHT, 1011],
            [1, 1.2, 509, WATER_HEIGHT, 1024],
            [1, 1.2, 387, WATER_HEIGHT, 1121],
            [1, 1.2, 293, WATER_HEIGHT, 1253],
            [1, 1.2, 352, WATER_HEIGHT, 1404],
            [1, 1.2, 475, WATER_HEIGHT, 1520],
            [1, 1.2, 639, WATER_HEIGHT, 1538],
        ],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.CrystalCaves,
        name="Around W1 in 5DI area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 425, 48, 1005],
            [1, 1.0, 369, 48, 1023],
            [1, 1.0, 330, 48, 961],
            [1, 1.0, 364, 48, 908],
            [1, 1.0, 425, 48, 922],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.CrystalCaves,
        name="Around W3 in 5DI area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 169, 50, 1056],
            [1, 1.0, 207, 50, 1080],
            [1, 1.0, 202, 50, 1140],
            [1, 1.0, 172, 50, 1189],
            [1, 1.0, 136, 50, 1196],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.CrystalCaves,
        name="Around Tag Barrel in 5DI area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 279, 48, 1385],
            [1, 1.0, 219, 48, 1360],
            [1, 1.0, 165, 48, 1408],
            [1, 1.0, 186, 48, 1465],
            [1, 1.0, 265, 48, 1450],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.CrystalCaves,
        name="Singles on 5DI",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 617, 125, 1218],
            [1, 1.0, 649, 125, 1253],
            [1, 1.0, 653, 125, 1303],
            [1, 1.0, 627, 125, 1344],
            [1, 1.0, 583, 125, 1364],
            [1, 1.0, 538, 125, 1352],
            [1, 1.0, 504, 125, 1316],
            [1, 1.0, 500, 125, 1267],
            [1, 1.0, 526, 125, 1226],
            [1, 1.0, 574, 125, 1205],
        ],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.CrystalCaves,
        name="Bunch on 5DI",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[[5, 1.0, 577, 150, 1285]],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.CrystalCaves,
        name="On pointy pillar by Chunky igloo",
        konglist=[Kongs.diddy],
        region=Regions.IglooArea,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 731, 150, 994]],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.CrystalCaves,
        name="In water around Chunky Igloo",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.2, 600, WATER_HEIGHT, 813],
            [1, 1.2, 685, WATER_HEIGHT, 690],
            [1, 1.2, 837, WATER_HEIGHT, 688],
            [1, 1.2, 868, WATER_HEIGHT, 806],
            [1, 1.2, 822, WATER_HEIGHT, 905],
        ],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.CrystalCaves,
        name="In water around Tiny Igloo",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.2, 419, WATER_HEIGHT, 1677],
            [1, 1.2, 341, WATER_HEIGHT, 1838],
            [1, 1.2, 208, WATER_HEIGHT, 1805],
            [1, 1.2, 210, WATER_HEIGHT, 1680],
            [1, 1.2, 228, WATER_HEIGHT, 1623],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.CrystalCaves,
        name="On edge of useless platform on the right side of waterfall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2997, 130, 1476],
            [1, 1.0, 3014, 126, 1533],
            [1, 1.0, 3035, 120, 1606],
            [1, 1.0, 3037, 120, 1653],
            [1, 1.0, 3029, 120, 1723],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.CrystalCaves,
        name="On other edge of useless platform on the right side of waterfall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2810, 148, 1881],
            [1, 1.0, 2768, 157, 1881],
            [1, 1.0, 2702, 172, 1863],
            [1, 1.0, 2632, 183, 1866],
            [1, 1.0, 2554, 190, 1885],
        ],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.CrystalCaves,
        name="On baboon balloon pad by 1DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2493, 290, 1808]],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.CrystalCaves,
        name="On Lanky 1DC",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.CavesSprintCabinRoof,
        locations=[
            [1, 1.0, 2237, 394, 1969],
            [1, 1.0, 2220, 394, 1903],
            [1, 1.0, 2272, 394, 1880],
            [1, 1.0, 2312, 394, 1864],
            [1, 1.0, 2356, 394, 1843],
        ],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.CrystalCaves,
        name="Next to Lanky 1DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2354, 278, 2034],
            [1, 1.0, 2396, 278, 1996],
            [1, 1.0, 2456, 278, 1949],
            [1, 1.0, 2498, 278, 1903],
            [1, 1.0, 2510, 278, 1847],
        ],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.CrystalCaves,
        name="Plank to Lanky 1DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2333, 286, 2079],
            [1, 1.0, 2347, 287, 2115],
            [1, 1.0, 2360, 287, 2151],
            [1, 1.0, 2373, 287, 2187],
            [1, 1.0, 2386, 288, 2222],
        ],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.CrystalCaves,
        name="From Waterfall tag to W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2383, 280, 2270],
            [1, 1.0, 2416, 287, 2244],
            [1, 1.0, 2461, 290, 2218],
            [1, 1.0, 2516, 291, 2197],
            [1, 1.0, 2577, 281, 2185],
        ],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.CrystalCaves,
        name="W2 to Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2691, 283, 2117],
            [1, 1.0, 2717, 300, 2084],
            [1, 1.0, 2758, 330, 2040],
            [1, 1.0, 2781, 354, 2008],
            [1, 1.0, 2817, 371, 1970],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.CrystalCaves,
        name="Each side of DK 1DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2965, 287, 2382], [5, 1.0, 2677, 287, 2523]],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.CrystalCaves,
        name="In front of the T&S on DK 1DC",
        konglist=[Kongs.diddy],
        region=Regions.CavesRotatingCabinRoof,
        locations=[[5, 1.0, 2837, 432, 2509]],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.CrystalCaves,
        name="On crystal platform near waterfall RB",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2463, 215, 2530]],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.CrystalCaves,
        name="Lower crystal platform to waterfall tag",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2403, 193, 2402]],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.CrystalCaves,
        name="Around Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2879, 379, 1979],
            [1, 1.0, 2959, 379, 1982],
            [1, 1.0, 3015, 379, 1929],
            [1, 1.0, 3026, 379, 1854],
            [1, 1.0, 2986, 379, 1790],
            [1, 1.0, 2935, 379, 1765],
            [1, 1.0, 2867, 379, 1773],
            [1, 1.0, 2826, 379, 1813],
            [1, 1.0, 2807, 379, 1878],
            [1, 1.0, 2815, 379, 1927],
        ],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.CrystalCaves,
        name="In the water between pickups below W4 Mini Monkey tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.2, 2755, WATER_HEIGHT, 828],
            [1, 1.2, 2804, WATER_HEIGHT, 786],
            [1, 1.2, 2861, WATER_HEIGHT, 729],
            [1, 1.2, 2956, WATER_HEIGHT, 687],
            [1, 1.2, 3068, WATER_HEIGHT, 681],
            [1, 1.2, 3156, WATER_HEIGHT, 740],
            [1, 1.2, 3198, WATER_HEIGHT, 837],
            [1, 1.2, 3198, WATER_HEIGHT, 926],
            [1, 1.2, 3167, WATER_HEIGHT, 1003],
            [1, 1.2, 3123, WATER_HEIGHT, 1082],
        ],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.CrystalCaves,
        name="In river W1W2 to Waterfall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.2, 1987, WATER_HEIGHT, 935],
            [1, 1.2, 2069, WATER_HEIGHT, 892],
            [1, 1.2, 2173, WATER_HEIGHT, 860],
            [1, 1.2, 2254, WATER_HEIGHT, 866],
            [1, 1.2, 2311, WATER_HEIGHT, 914],
            [1, 1.2, 2359, WATER_HEIGHT, 978],
            [1, 1.2, 2437, WATER_HEIGHT, 1019],
            [1, 1.2, 2517, WATER_HEIGHT, 1003],
            [1, 1.2, 2611, WATER_HEIGHT, 989],
            [1, 1.2, 2706, WATER_HEIGHT, 927],
            [1, 1.2, 2815, WATER_HEIGHT, 872],
            [1, 1.2, 2881, WATER_HEIGHT, 951],
            [1, 1.2, 2921, WATER_HEIGHT, 1038],
            [1, 1.2, 2952, WATER_HEIGHT, 1148],
            [1, 1.2, 2993, WATER_HEIGHT, 1258],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.CrystalCaves,
        name="In river in corner near Ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.2, 2139, 35, 1110]],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.CrystalCaves,
        name="Path to big boulder (2 custom, 3 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        locations=[
            [1, 1.0, 1491, 294, 2659],
            [1, 1.0, 1581, 292, 2709],
            [1, 1.0, 1461.1162109375, 295.85003662109375, 2602.834716796875],
            [1, 1.0, 1514.69775390625, 292.2107849121094, 2717.545166015625],
            [1, 1.0, 1662.88916015625, 288.1389465332031, 2697.848388671875],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.CrystalCaves,
        name="Around giant boulder",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        locations=[
            [1, 1.0, 1777, 280, 2581],
            [1, 1.0, 1860, 280, 2630],
            [1, 1.0, 1958, 280, 2651],
            [1, 1.0, 2066, 280, 2559],
            [1, 1.0, 2088, 280, 2467],
            [1, 1.0, 2079, 280, 2394],
            [1, 1.0, 1974, 280, 2330],
            [1, 1.0, 1854, 280, 2336],
            [1, 1.0, 1784, 280, 2406],
            [1, 1.0, 1758, 280, 2482],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.CrystalCaves,
        name="Behind pillar in giant boulder room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        locations=[[5, 1.0, 2090, 282, 2739]],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.CrystalCaves,
        name="Around pillar below DK 1DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2613, 176, 2517],
            [1, 1.0, 2600, 175, 2469],
            [1, 1.0, 2617, 173, 2419],
            [1, 1.0, 2638, 173, 2379],
            [1, 1.0, 2681, 168, 2348],
            [1, 1.0, 2729, 164, 2320],
            [1, 1.0, 2796, 159, 2287],
            [1, 1.0, 2863, 157, 2265],
            [1, 1.0, 2932, 155, 2273],
            [1, 1.0, 2983, 152, 2312],
        ],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.CrystalCaves,
        name="Near ledge by waterfall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 2390, 180, 2265],
            [1, 1.0, 2436, 180, 2241],
            [1, 1.0, 2484, 180, 2218],
            [1, 1.0, 2541, 180, 2191],
            [1, 1.0, 2636, 171, 2172],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.CrystalCaves,
        name="Crystal platform at the end of fence in front of 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3356, 160, 1803]],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.CrystalCaves,
        name="Lone small crystal platform close to 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3251, 170, 1472]],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.CrystalCaves,
        name="Along fence in front of 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 3390, 116, 2003],
            [1, 1.0, 3367, 116, 1967],
            [1, 1.0, 3336, 117, 1917],
            [1, 1.0, 3341, 121, 1870],
            [1, 1.0, 3356, 124, 1828],
        ],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.CrystalCaves,
        name="5DC Triangle pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3452, 180, 1821]],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.CrystalCaves,
        name="5DC Saxophone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3537, 275, 1839]],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.CrystalCaves,
        name="5DC Lower Guitar pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3525, 275, 1686]],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.CrystalCaves,
        name="5DC Upper Guitar pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3602, 357, 1680]],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.CrystalCaves,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBlueprintPillar,
        locations=[[5, 1.0, 2761, 380, 954]],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.CrystalCaves,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3614, 357, 1839]],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.CrystalCaves,
        name="Corner by W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3695, 350, 1901]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.CrystalCaves,
        name="Line on middle floor of 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 3574, 260, 1909],
            [1, 1.0, 3569, 260, 1831],
            [1, 1.0, 3565, 260, 1753],
            [1, 1.0, 3561, 260, 1676],
            [1, 1.0, 3556, 260, 1599],
        ],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.CrystalCaves,
        name="Line on upper floor of 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.0, 3698, 343, 1588],
            [1, 1.0, 3629, 343, 1595],
            [1, 1.0, 3634, 343, 1666],
            [1, 1.0, 3638, 343, 1737],
            [1, 1.0, 3642, 343, 1809],
        ],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.CrystalCaves,
        name="Bunch in front of window up high on 5DC",
        konglist=[Kongs.diddy],
        region=Regions.CabinArea,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 3637, 500, 1677]],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.CrystalCaves,
        name="Blue lonely crystal platform by 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3387, 185, 1470]],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.CrystalCaves,
        name="Crystal platform by 5DC",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3448, 195, 1470]],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.CrystalCaves,
        name="2 ends of the Giant Kosha area",
        konglist=[Kongs.tiny],
        region=Regions.GiantKosha,
        locations=[[5, 1.0, 2210, 265, 3638], [5, 1.0, 1430, 265, 3595]],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.CrystalCaves,
        name="2 other ends of the Giant Kosha area",
        konglist=[Kongs.tiny],
        region=Regions.GiantKosha,
        locations=[[5, 1.0, 1845, 265, 3217], [5, 1.0, 1800, 265, 4006]],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.CrystalCaves,
        name="In Boulder igloo (4 custom, 6 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        logic=lambda l: (l.chunky and l.barrels) or l.CanPhase(),
        locations=[
            [1, 1.0, 1885, 280, 2537],
            [1, 1.0, 1941, 280, 2548],
            [1, 1.0, 1914, 280, 2453],
            [1, 1.0, 1964, 280, 2481],
            [1, 1.0, 1899.6573486328125, 280.3333435058594, 2473.731201171875],
            [1, 1.0, 1893.52978515625, 280.3333435058594, 2505.223876953125],
            [1, 1.0, 1916.1829833984375, 280.3333435058594, 2534.476318359375],
            [1, 1.0, 1943.1602783203125, 280.3333435058594, 2527.596435546875],
            [1, 1.0, 1955.0213623046875, 280.3333435058594, 2504.2041015625],
            [1, 1.0, 1939.1451416015625, 280.3333435058594, 2471.535888671875],
        ],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.CavesBaboonBlast,
        name="Middle path first barrel",
        konglist=[Kongs.donkey],
        region=Regions.CavesBaboonBlast,
        locations=[[5, 1.2, 1281, 355, 568]],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.CavesBaboonBlast,
        name="Line that misses a barrel in slow path",
        konglist=[Kongs.donkey],
        region=Regions.CavesBaboonBlast,
        locations=[
            [1, 1.2, 645, 583, 2106],
            [1, 1.2, 711, 582, 2028],
            [1, 1.2, 776, 569, 1950],
            [1, 1.2, 841, 537, 1874],
            [1, 1.2, 905, 488, 1797],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.CavesBaboonBlast,
        name="Line of singles through ring",
        konglist=[Kongs.donkey],
        region=Regions.CavesBaboonBlast,
        locations=[
            [1, 1.2, 957, 505, 1253],
            [1, 1.2, 1009, 505, 1126],
            [1, 1.2, 1048, 503, 1031],
            [1, 1.2, 1086, 487, 938],
            [1, 1.2, 1124, 452, 845],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.CavesFrozenCastle,
        name="Each side walls",
        konglist=[Kongs.lanky],
        region=Regions.FrozenCastle,
        locations=[
            [1, 1.0, 131, 0, 407],
            [1, 1.0, 172, 0, 423],
            [1, 1.0, 214, 0, 439],
            [1, 1.0, 255, 0, 455],
            [1, 1.0, 297, 0, 472],
            [1, 1.0, 273, 0, 138],
            [1, 1.0, 308, 0, 154],
            [1, 1.0, 343, 0, 170],
            [1, 1.0, 378, 0, 186],
            [1, 1.0, 413, 0, 201],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.CavesFrozenCastle,
        name="Each side of the tomato's chair",
        konglist=[Kongs.lanky],
        region=Regions.FrozenCastle,
        locations=[[5, 1.0, 425, 20, 305], [5, 1.0, 385, 20, 407]],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.CavesChunkyIgloo,
        name="Around the igloo",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyIgloo,
        locations=[
            [1, 1.0, 199, 0, 130],
            [1, 1.0, 296, 0, 119],
            [1, 1.0, 385, 0, 153],
            [1, 1.0, 444, 0, 228],
            [1, 1.0, 455, 0, 330],
            [1, 1.0, 419, 0, 414],
            [1, 1.0, 343, 0, 471],
            [1, 1.0, 243, 0, 487],
            [1, 1.0, 154, 0, 449],
            [1, 1.0, 97, 0, 372],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.CavesDiddyIgloo,
        name="Numbers 1 5 6",
        konglist=[Kongs.diddy],
        region=Regions.DiddyIgloo,
        locations=[[5, 1.0, 387, 5, 351], [5, 1.0, 272, 5, 209], [5, 1.0, 209, 5, 368]],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.CavesDiddyIgloo,
        name="Numbers 2 3 4",
        konglist=[Kongs.diddy],
        region=Regions.DiddyIgloo,
        locations=[[5, 1.0, 368, 5, 242], [5, 1.0, 185, 5, 261], [5, 1.0, 307, 5, 408]],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.CavesDonkeyIgloo,
        name="Center of igloo group with 7 singles",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyIgloo,
        logic=lambda l: l.strongKong and l.isdonkey,
        locations=[
            [1, 1.0, 506, 0, 515],
            [1, 1.0, 469, 0, 526],
            [1, 1.0, 469, 0, 478],
            [1, 1.0, 441.2948913574219, 0, 701.4950561523438],
            [1, 1.0, 366.3046569824219, 0, 567.0046997070312],
            [1, 1.0, 338.6632995605469, 0, 441.111083984375],
            [1, 1.0, 553.1425170898438, 0, 369.2431945800781],
            [1, 1.0, 622.7244262695312, 0, 490.4476013183594],
            [1, 1.0, 432.0162658691406, 0, 360.1225280761719],
            [1, 1.0, 583.7945556640625, 0, 598.47021484375],
        ],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.CavesDonkeyIgloo,
        name="Around maze",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyIgloo,
        locations=[
            [1, 1.0, 310, 0, 249],
            [1, 1.0, 471, 0, 187],
            [1, 1.0, 634, 0, 216],
            [1, 1.0, 748, 0, 317],
            [1, 1.0, 808, 0, 469],
            [1, 1.0, 682, 0, 765],
            [1, 1.0, 515, 0, 813],
            [1, 1.0, 336, 0, 777],
            [1, 1.0, 220, 0, 675],
            [1, 1.0, 172, 0, 533],
        ],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.CavesLankyIgloo,
        name="On crystal tower",
        konglist=[Kongs.lanky],
        region=Regions.LankyIgloo,
        locations=[[5, 1.0, 218, 65, 282], [5, 1.0, 274, 135, 246]],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.CavesTinyIgloo,
        name="Inside Tiny's igloo room",
        konglist=[Kongs.tiny],
        region=Regions.TinyIgloo,
        locations=[
            [1, 1.0, 83, 0, 284],
            [1, 1.0, 153, 0, 444],
            [1, 1.0, 247, 0, 487],
            [1, 1.0, 344, 0, 470],
            [1, 1.0, 420, 0, 414],
            [1, 1.0, 457, 0, 324],
            [1, 1.0, 443, 0, 230],
            [1, 1.0, 384, 0, 153],
            [1, 1.0, 294, 0, 115],
            [1, 1.0, 201, 0, 125],
        ],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.CavesLankyCabin,
        name="Stack of books in entrance corner",
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        locations=[[5, 1.0, 530, 35, 118]],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.CavesLankyCabin,
        name="Stacks of books on shelves in Lanky's cabin",
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        locations=[[5, 1.0, 400, 72, 505], [5, 1.0, 150, 72, 335]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.CavesChunkyCabin,
        name="Stacks of books on shelves in Chunky's cabin",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyCabin,
        locations=[[5, 1.0, 177, 72, 116], [5, 1.0, 77, 72, 356]],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.CavesChunkyCabin,
        name="Books on floor and back shelf in Chunky's cabin",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyCabin,
        locations=[[5, 1.0, 402, 50, 561], [5, 1.0, 445, 15, 112]],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Books on shelf near entrance in Diddy's upper cabin",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        locations=[[5, 1.0, 201, 70, 119]],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Books on shelf on back wall in Diddy's upper cabin",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        locations=[[5, 1.0, 469, 70, 606]],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.CavesDonkeyCabin,
        name="On books on shelves in DK's cabin",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        locations=[[5, 1.0, 190, 70, 486], [5, 1.0, 143, 70, 119]],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.CrystalCaves,
        name="In star above 5DI (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.IglooArea,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 572.9354248046875, 253.16668701171875, 1286.8638916015625]],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.CrystalCaves,
        name="In waterfall under bonus barrel (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 3031.996826171875, 329.8321228027344, 1366.2552490234375]],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.CrystalCaves,
        name="W2 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [5, 1.0, 2258.80712890625, 90.08489227294922, 652.76220703125],
            [5, 1.0, 2651.197021484375, 295.0, 2181.504638671875],
        ],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.CrystalCaves,
        name="Around 5DI (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        vanilla=True,
        locations=[
            [1, 1.0, 482.5127258300781, 48.16666793823242, 1180.55712890625],
            [1, 1.0, 446.3671875, 48.16666793823242, 1336.6673583984375],
            [1, 1.0, 588.1909790039062, 48.16666793823242, 1425.1483154296875],
            [1, 1.0, 714.7677612304688, 48.16666793823242, 1313.8824462890625],
            [1, 1.0, 651.11279296875, 48.16666793823242, 1164.52001953125],
        ],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.CrystalCaves,
        name="Around baboon blast pad (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [1, 1.0, 1296.0986328125, 299.3333435058594, 2279.438720703125],
            [1, 1.0, 1281.1539306640625, 299.3333435058594, 2206.64697265625],
            [1, 1.0, 1345.323486328125, 299.3333435058594, 2172.356201171875],
            [1, 1.0, 1387.7418212890625, 299.3333435058594, 2217.896484375],
            [1, 1.0, 1367.0028076171875, 299.3333435058594, 2286.45361328125],
        ],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.CrystalCaves,
        name="W1 (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [5, 1.0, 2168.7314453125, 84.12599182128906, 657.947998046875],
            [5, 1.0, 386.0030212402344, 73.5, 970.0894165039062],
        ],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.CrystalCaves,
        name="On 5DC bongos pad (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        vanilla=True,
        locations=[[5, 1.0, 3432.132568359375, 178.8333282470703, 1580.23095703125]],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.CrystalCaves,
        name="On pillar by 5DI tag (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.IglooArea,
        vanilla=True,
        logic=lambda l: l.jetpack and l.isdiddy,
        locations=[[5, 1.0, 327.7669372558594, 154.5, 1521.9307861328125]],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.CrystalCaves,
        name="Above baboon blast pad by Cranky (Lanky)",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.balloon and l.islanky),
        locations=[
            [5, 1.0, 1068.9757080078125, 424.611083984375, 1802.6158447265625],
            [5, 1.0, 1148.0433349609375, 424.79339599609375, 1865.7960205078125],
            [5, 1.0, 1216.4617919921875, 424.5011901855469, 1930.6746826171875],
        ],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.CrystalCaves,
        name="Inside tower to beetle race (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        logic=lambda l: (l.balloon or l.monkey_maneuvers) and l.CanSlamSwitch(Levels.CrystalCaves, 2),
        locations=[[5, 1.0199991464614868, 2205.302978515625, 399.8333435058594, 971.8466796875]],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.CrystalCaves,
        name="On trombone pad on Lanky cabin (Lanky)",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.CavesSprintCabinRoof,
        vanilla=True,
        locations=[[5, 1.0, 2382.422119140625, 414.1666564941406, 1830.9127197265625]],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.CrystalCaves,
        name="First path to warps (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [1, 1.0, 2011.64453125, 9.39330005645752, 220.1348114013672],
            [1, 1.0, 1941.73828125, -8.905264854431152, 216.8893280029297],
            [1, 1.0, 2208.029052734375, 23.139623641967773, 415.3579406738281],
            [1, 1.0, 2220.832275390625, 53.43684387207031, 511.0781555175781],
            [1, 1.0, 1872.4024658203125, -27.054489135742188, 208.80503845214844],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.CrystalCaves,
        name="Path from Funky to rocketbarrel (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [1, 1.0, 2821.9306640625, 280.0, 1197.9786376953125],
            [1, 1.0, 2874.291259765625, 279.8548278808594, 1120.208740234375],
            [1, 1.0, 2958.340576171875, 253.6666717529297, 998.47314453125],
            [1, 1.0, 2913.4521484375, 272.7587890625, 1064.78662109375],
            [1, 1.0, 3008.274658203125, 253.6666717529297, 934.7453002929688],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.CrystalCaves,
        name="W4 (Diddy)",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBlueprintCave,
        vanilla=True,
        locations=[[5, 1.0, 3340.275634765625, 296.6666564941406, 570.8076782226562]],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.CrystalCaves,
        name="W4 (Diddy)",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBananaportSpire,
        vanilla=True,
        locations=[[5, 1.0, 1197.610107421875, 142.5, 1924.6083984375]],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.CrystalCaves,
        name="Above Tiny and Chunky igloos (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.IglooArea,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 289.3224792480469, 208.5, 1743.85107421875],
            [5, 1.0, 757.3706665039062, 208.5, 791.2725219726562],
        ],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.CrystalCaves,
        name="Around Diddy blueprint (Diddy)",
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBlueprintCave,
        vanilla=True,
        locations=[
            [1, 1.0, 3586.48046875, 286.6666564941406, 572.7948608398438],
            [1, 1.0, 3653.628173828125, 286.6666564941406, 658.6300048828125],
            [1, 1.0, 3623.835693359375, 286.6666564941406, 778.5648803710938],
            [1, 1.0, 3412.393310546875, 286.6666564941406, 786.0659790039062],
            [1, 1.0, 3520.326171875, 286.6666564941406, 841.3567504882812],
        ],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.CrystalCaves,
        name="Chunky igloo (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        vanilla=True,
        logic=lambda l: Events.CavesLargeBoulderButton in l.Events or l.generalclips or l.CanPhaseswim(),
        locations=[
            [1, 1.0, 807.6382446289062, 48.5, 760.23779296875],
            [1, 1.0, 786.4091186523438, 48.5, 824.6043090820312],
            [1, 1.0, 727.8129272460938, 48.5, 840.4140014648438],
            [1, 1.0, 696.62744140625, 48.5, 786.0977172851562],
            [1, 1.0, 747.8562622070312, 48.5, 734.012451171875],
        ],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.CrystalCaves,
        name="On Gorilla Gone pad (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesGGRoom,
        vanilla=True,
        locations=[[5, 1.0, 2581.2197265625, 33.5, 586.1724243164062]],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.CrystalCaves,
        name="On small boulder switch (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[[5, 1.0, 1376.521484375, 350.8470153808594, 1167.5355224609375]],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.CrystalCaves,
        name="Inside giant boulder (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        vanilla=True,
        logic=lambda l: Events.CavesSmallBoulderButton in l.Events and l.hunkyChunky and l.barrels,
        locations=[[5, 1.0, 1922.93359375, 290.3333435058594, 2504.288330078125]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.CrystalCaves,
        name="W3 (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBonusCave,
        vanilla=True,
        locations=[[5, 1.0, 541.8216552734375, 210.3333282470703, 2511.490966796875]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.CrystalCaves,
        name="W3 (Tiny)",  # Slightly moved to match new position of the warp
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        vanilla=True,
        locations=[[5, 1.0, 177, 70, 1089]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.CrystalCaves,
        name="On riverbed to waterfall (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        vanilla=True,
        locations=[
            [1, 1.0, 2802.758056640625, WATER_HEIGHT, 2033.546875],
            [1, 1.0, 3096.729736328125, WATER_HEIGHT, 1543.9088134765625],
            [1, 1.0, 3115.848388671875, WATER_HEIGHT, 1677.841796875],
            [1, 1.0, 3098.123779296875, WATER_HEIGHT, 1808.15673828125],
            [1, 1.0, 3033.780029296875, WATER_HEIGHT, 1945.6124267578125],
            [1, 1.0, 2934.6884765625, WATER_HEIGHT, 2017.9112548828125],
            [1, 1.0, 2625.267578125, WATER_HEIGHT, 2052.125244140625],
            [1, 1.0, 2463.112060546875, WATER_HEIGHT, 2117.245849609375],
            [1, 1.0, 3049.31640625, WATER_HEIGHT, 1421.4713134765625],
            [1, 1.0, 2284.283935546875, WATER_HEIGHT, 2182.173583984375],
        ],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.CrystalCaves,
        name="On W5 pillar (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBlueprintPillar,
        vanilla=True,
        locations=[
            [5, 1.0, 2809.578857421875, 366.8333435058594, 956.959228515625],
            [5, 1.0, 2759.7177734375, 366.8333435058594, 905.7832641601562],
            [5, 1.0, 2722.785888671875, 366.8333435058594, 960.2510375976562],
            [5, 1.0, 2768.906494140625, 366.8333435058594, 1006.199462890625],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.CrystalCaves,
        name="On riverbed to igloo area (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        locations=[
            [1, 1.0, 1880.107421875, WATER_HEIGHT, 1015.5917358398438],
            [1, 1.0, 1481.9830322265625, WATER_HEIGHT, 1553.572265625],
            [1, 1.0, 1558.1134033203125, WATER_HEIGHT, 1404.7265625],
            [1, 1.0, 1640.4111328125, WATER_HEIGHT, 1254.0618896484375],
            [1, 1.0, 1758.7294921875, WATER_HEIGHT, 1107.2886962890625],
            [1, 1.0, 743.7113647460938, WATER_HEIGHT, 1478.8377685546875],
            [1, 1.0, 963.6484375, WATER_HEIGHT, 1703.52880859375],
            [1, 1.0, 859.8079223632812, WATER_HEIGHT, 1596.6995849609375],
            [1, 1.0, 1106.2684326171875, WATER_HEIGHT, 1765.4384765625],
            [1, 1.0, 1370.751953125, WATER_HEIGHT, 1648.6905517578125],
        ],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.CrystalCaves,
        name="In Monkeyport igloo (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.IglooArea,
        vanilla=True,
        logic=lambda l: Events.CavesMonkeyportAccess in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.0, 261.5770263671875, 48.5, 1772.1956787109375]],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.CrystalCaves,
        name="Inside small boulder (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        logic=lambda l: l.barrels and l.chunky,
        locations=[[5, 1.0, 1658.8216552734375, 291.8333435058594, 1007.8945922851562]],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.CrystalCaves,
        name="Middle of Giant Kosha room (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.GiantKosha,
        vanilla=True,
        locations=[
            [5, 1.0, 1830.0128173828125, 231.8333282470703, 3495.708251953125],
            [5, 1.0, 1711.8521728515625, 231.8333282470703, 3605.580810546875],
            [5, 1.0, 1814.2305908203125, 231.8333282470703, 3733.613037109375],
            [5, 1.0, 1934.7154541015625, 231.8333282470703, 3621.983642578125],
        ],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.CavesTinyIgloo,
        name="In middle (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TinyIgloo,
        vanilla=True,
        locations=[[5, 1.0, 272.8538513183594, 65.0, 305.7542724609375]],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.CavesLankyIgloo,
        name="Up the crystal tower (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.LankyIgloo,
        vanilla=True,
        logic=lambda l: l.balloon or l.monkey_maneuvers,
        locations=[
            [1, 1.0, 315.4643859863281, 17.666667938232422, 314.6233825683594],
            [1, 1.0, 265.5227966308594, 150.5, 351.783447265625],
            [1, 1.0, 302.96893310546875, 107.83333587646484, 347.9389953613281],
            [1, 1.0, 241.15721130371094, 163.3333282470703, 316.1607360839844],
            [1, 1.0, 256.4052734375, 243.8333282470703, 281.9900817871094],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.CavesDonkeyIgloo,
        name="On doorframe (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyIgloo,
        vanilla=True,
        locations=[[5, 1.0, 111.83493041992188, 52.0, 369.4170227050781]],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.CavesRotatingCabin,
        name="On puzzle (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.RotatingCabin,
        vanilla=True,
        locations=[[5, 1.0, 318.0190124511719, 135.0, 297.6553955078125]],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.CavesChunkyCabin,
        name="In the middle of the room (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyCabin,
        vanilla=True,
        logic=lambda l: l.gorillaGone and l.Slam,
        locations=[
            [5, 1.0, 282.1108093261719, 5.0, 326.0027160644531],
            [5, 1.0, 310.0854797363281, 5.0, 327.1960144042969],
            [5, 1.0, 309.0625305175781, 5.0, 351.1741638183594],
            [5, 1.0, 283.9403991699219, 5.0, 350.1368103027344],
        ],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.CavesDonkeyCabin,
        name="On a trapdoor (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        vanilla=True,
        locations=[[5, 1.0, 302.6053771972656, 20.0, 443.752197265625]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.CavesDiddyLowerCabin,
        name="Around room (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.DiddyLowerCabin,
        vanilla=True,
        locations=[
            [1, 1.0, 298.4131164550781, 0, 185.8524932861328],
            [1, 1.0, 181.1191864013672, 0, 299.81561279296875],
            [1, 1.0, 224.33160400390625, 0, 419.0870056152344],
            [1, 1.0, 415.8427429199219, 0, 275.2719421386719],
            [1, 1.0, 389.1142272949219, -1.8947806851624636e-14, 410.852783203125],
        ],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.CavesDiddyLowerCabin,
        name="On center pillar (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.DiddyLowerCabin,
        vanilla=True,
        logic=lambda l: l.jetpack or l.monkey_maneuvers,
        locations=[[5, 1.0, 300.0310363769531, 101.0, 291.0983581542969]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.CavesTinyCabin,
        name="Bunches in cabin (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TinyCabin,
        vanilla=True,
        locations=[
            [5, 1.0, 412.1592102050781, 40.166664123535156, 358.9884338378906],
            [5, 1.0, 175.46046447753906, 40.166664123535156, 360.0655212402344],
        ],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.CavesLankyCabin,
        name="Bunch on switch",
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        vanilla=True,
        locations=[[5, 1.0, 89.70840454101562, 20.0, 423.5394592285156]],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.CavesBaboonBlast,
        name="Long path (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.CavesBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.119999885559082, 1230.7186279296875, 344.0, 447.0163879394531],
            [5, 1.0, 898.5409545898438, 509.0, 1734.1337890625],
            [5, 1.0, 881.0941772460938, 393.0, 1655.2952880859375],
        ],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.CavesBaboonBlast,
        name="Middle path (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.CavesBaboonBlast,
        vanilla=True,
        locations=[[5, 1.0, 1483.0496826171875, 329.0, 912.5014038085938]],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.CavesDiddyUpperCabin,
        name="On candles (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        vanilla=True,
        logic=lambda l: l.jetpack and (l.guitar or l.oranges) and l.isdiddy and (l.spring or l.CanMoontail()),
        locations=[
            [5, 1.0, 302.3088684082031, 288.8333435058594, 519.8643188476562],
            [5, 1.0, 130.18800354003906, 288.8333435058594, 228.1186065673828],
            [5, 1.0, 476.0255126953125, 288.8333435058594, 226.3907928466797],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=139,
        map_id=Maps.CrystalCaves,
        name="Around small pillar near gorilla gone cave",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[1, 1.0, 2115, 15, 390], [1, 1.0, 2129, 13, 372], [1, 1.0, 2134, 13, 341], [1, 1.0, 2106, 13, 332], [1, 1.0, 2080, 13, 343]],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.CrystalCaves,
        name="Missing fence near warps 1 and 2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[1, 1.0, 2275, 82, 805], [1, 1.0, 2221, 74, 798], [1, 1.0, 2154, 65, 797], [1, 1.0, 2096, 57, 798], [1, 1.0, 2036, 57, 804]],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.CrystalCaves,
        name="Crystals near warp 1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1937, 73, 670],
            [1, 1.6, 1937, 80, 670],
            [1, 1.4, 1937, 87, 670],
            [1, 1.2, 1937, 94, 670],
            [1, 1.0, 1937, 101, 670],
        ],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.CrystalCaves,
        name="Crystal near Snide cave",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1507, 99, 793],
            [1, 1.6, 1507, 106, 793],
            [1, 1.4, 1507, 113, 793],
            [1, 1.2, 1507, 120, 793],
            [1, 1.0, 1507, 127, 793],
        ],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.CrystalCaves,
        name="Missing fence near Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[1, 1.0, 1585, 90, 1174], [1, 1.0, 1564, 90, 1218], [1, 1.0, 1539, 91, 1268], [1, 1.0, 1513, 91, 1319], [1, 1.0, 1487, 92, 1372]],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.CrystalCaves,
        name="Next to Cranky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1105, 291, 1701],
            [1, 1.6, 1105, 298, 1701],
            [1, 1.4, 1105, 305, 1701],
            [1, 1.2, 1105, 312, 1701],
            [1, 1.0, 1105, 319, 1701],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.CrystalCaves,
        name="Balloon to the mini monkey cave",
        konglist=[Kongs.lanky],
        region=Regions.CrystalCavesMain,
        logic=lambda l: l.balloon,
        locations=[[5, 1.0, 1054, 434, 2141], [5, 1.0, 863, 435, 2296]],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.CrystalCaves,
        name="Balloon to the protruding wall",
        konglist=[Kongs.lanky],
        region=Regions.CrystalCavesMain,
        logic=lambda l: l.balloon,
        locations=[[5, 1.0, 1411, 432, 1703], [5, 1.0, 1561, 430, 1436]],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.CrystalCaves,
        name="Crystal near mini monkey cave",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 823, 151, 2194],
            [1, 1.6, 823, 158, 2194],
            [1, 1.4, 823, 165, 2194],
            [1, 1.2, 823, 172, 2194],
            [1, 1.0, 823, 179, 2194],
        ],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.CrystalCaves,
        name="Crystal near the giant boulder cave",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1514, 297, 2443],
            [1, 1.6, 1514, 304, 2443],
            [1, 1.4, 1514, 311, 2443],
            [1, 1.2, 1514, 318, 2443],
            [1, 1.0, 1514, 325, 2443],
        ],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.CrystalCaves,
        name="Near the steps to baboon blast",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1456, 103, 1745],
            [1, 1.6, 1456, 110, 1745],
            [1, 1.4, 1456, 117, 1745],
            [1, 1.2, 1456, 124, 1745],
            [1, 1.0, 1456, 131, 1745],
        ],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.CrystalCaves,
        name="Around the ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 2178, 257, 1056],
            [1, 1.0, 2149, 270, 1028],
            [1, 1.0, 2118, 257, 997],
            [1, 1.0, 2119, 257, 945],
            [1, 1.0, 2138, 270, 927],
            [1, 1.0, 2159, 270, 905],
            [1, 1.0, 2179, 257, 885],
            [1, 1.0, 2231, 257, 885],
            [1, 1.0, 2259, 270, 915],
            [1, 1.0, 2292, 257, 947],
        ],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.CrystalCaves,
        name="Big stalactite between ice castle and Funky",
        konglist=[Kongs.diddy, Kongs.lanky],
        region=Regions.CrystalCavesMain,
        logic=lambda l: (l.jetpack and l.isdiddy) or (l.balloon and l.islanky),
        locations=[[5, 1.4, 2621, 371, 1111]],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.CrystalCaves,
        name="Near the small boulder switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 1344, 330, 1230],
            [1, 1.6, 1344, 337, 1230],
            [1, 1.4, 1344, 344, 1230],
            [1, 1.2, 1344, 351, 1230],
            [1, 1.0, 1344, 358, 1230],
        ],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.CrystalCaves,
        name="Leftmost crystal platform below ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2152, 182, 1189]],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.CrystalCaves,
        name="Leftmost crystal platform below Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[5, 1.0, 2731, 182, 1181]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.CrystalCaves,
        name="Corner ledge between Funky and ice castle",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[[1, 1.0, 2271, 31, 1107], [1, 1.0, 2271, 38, 1107], [1, 1.0, 2271, 45, 1107], [1, 1.0, 2271, 52, 1107], [1, 1.0, 2271, 59, 1107]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.CrystalCaves,
        name="Next to Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.8, 2718, 280, 1213],
            [1, 1.6, 2718, 287, 1213],
            [1, 1.4, 2718, 294, 1213],
            [1, 1.2, 2718, 301, 1213],
            [1, 1.0, 2718, 308, 1213],
        ],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.CrystalCaves,
        name="Under the rocketbarrel by Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        locations=[
            [1, 1.0, 3031, 253, 965],
            [1, 1.0, 3043, 253, 948],
            [1, 1.0, 3043, 253, 926],
            [1, 1.0, 3031, 253, 909],
            [1, 1.0, 3010, 253, 902],
            [1, 1.0, 2989, 253, 909],
            [1, 1.0, 2977, 253, 926],
            [1, 1.0, 2977, 253, 948],
            [1, 1.0, 2989, 253, 965],
            [1, 1.0, 3010, 253, 972],
        ],
    ),
    ColoredBananaGroup(
        group=158,
        map_id=Maps.CrystalCaves,
        name="Big window on the 5-door cabin",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 3502, 209, 1698]],
    ),
    ColoredBananaGroup(
        group=159,
        map_id=Maps.CrystalCaves,
        name="Next to Candy",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.8, 3093, 127, 2206],
            [1, 1.6, 3093, 134, 2206],
            [1, 1.4, 3093, 141, 2206],
            [1, 1.2, 3093, 148, 2206],
            [1, 1.0, 3093, 155, 2206],
        ],
    ),
    ColoredBananaGroup(
        group=160,
        map_id=Maps.CrystalCaves,
        name="Nice ledge grab spot near cabins warp 2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2591, 265, 2241]],
    ),
    ColoredBananaGroup(
        group=161,
        map_id=Maps.CrystalCaves,
        name="Around the platform near cabins rocketbarrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[1, 1.0, 2491, 178, 2547], [1, 1.0, 2496, 177, 2522], [1, 1.0, 2477, 177, 2501], [1, 1.0, 2449, 178, 2505], [1, 1.0, 2435, 178, 2531]],
    ),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.CrystalCaves,
        name="Plank to rotating cabin",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[1, 1.0, 2695, 287, 2236], [1, 1.0, 2708, 287, 2256], [1, 1.0, 2720, 287, 2275], [1, 1.0, 2733, 287, 2295], [1, 1.0, 2745, 287, 2314]],
    ),
    ColoredBananaGroup(
        group=163,
        map_id=Maps.CrystalCaves,
        name="Up the cabins waterfall",
        konglist=[Kongs.diddy],
        region=Regions.CabinArea,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.2, 2271, 562, 2199]],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.CrystalCaves,
        name="On the headphones",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[[5, 1.0, 2580, 213, 1806]],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.CrystalCaves,
        name="Crystals on the useless platform in cabins area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.8, 2872, 142, 1688],
            [1, 1.6, 2872, 149, 1688],
            [1, 1.4, 2872, 156, 1688],
            [1, 1.2, 2872, 163, 1688],
            [1, 1.0, 2872, 170, 1688],
        ],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.CrystalCaves,
        name="Ice ground near 5-door cabin",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        locations=[
            [1, 1.8, 3331, 126, 1623],
            [1, 1.6, 3331, 133, 1623],
            [1, 1.4, 3331, 140, 1623],
            [1, 1.2, 3331, 147, 1623],
            [1, 1.0, 3331, 154, 1623],
        ],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.CrystalCaves,
        name="Around full pillar near igloo area entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 921, 20, 1351],
            [1, 1.0, 895, 20, 1272],
            [1, 1.0, 813, 20, 1272],
            [1, 1.0, 787, 20, 1351],
            [1, 1.0, 854, 20, 1399],
        ],
    ),
    ColoredBananaGroup(
        group=168,
        map_id=Maps.CrystalCaves,
        name="Around full pillar near igloo warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 371, 20, 1157],
            [1, 1.0, 345, 20, 1078],
            [1, 1.0, 263, 20, 1078],
            [1, 1.0, 237, 20, 1157],
            [1, 1.0, 304, 20, 1205],
        ],
    ),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.CrystalCaves,
        name="Around half-pillar near igloo",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        locations=[
            [1, 1.0, 390, 20, 1540],
            [1, 1.0, 367, 20, 1468],
            [1, 1.0, 291, 20, 1468],
            [1, 1.0, 268, 20, 1540],
            [1, 1.0, 329, 20, 1584],
        ],
    ),
    ColoredBananaGroup(
        group=170,
        map_id=Maps.CrystalCaves,
        name="Spire near the ice castle",
        konglist=[Kongs.tiny],
        region=Regions.CrystalCavesMain,
        logic=lambda l: l.twirl,
        locations=[[5, 1.1, 2494, 269, 902]],
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.CrystalCaves,
        name="Twirl from the cabins pillar",
        konglist=[Kongs.tiny],
        region=Regions.CabinArea,
        logic=lambda l: l.twirl,
        locations=[[1, 1.1, 2976, 409, 1695], [1, 1.1, 2987, 402, 1630], [1, 1.1, 2998, 396, 1571], [1, 1.1, 3010, 368, 1506], [1, 1.1, 3022, 303, 1441]],
    ),
    ColoredBananaGroup(
        group=172,
        map_id=Maps.CrystalCaves,
        name="Balloon to the cabins waterfall",
        konglist=[Kongs.lanky],
        region=Regions.CabinArea,
        logic=lambda l: l.balloon,
        locations=[[5, 1.4, 2291, 417, 2188]],
    ),
    ColoredBananaGroup(
        group=173,
        map_id=Maps.CavesDonkeyCabin,
        name="Around the center trapdoor",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        locations=[
            [1, 1.0, 355, 0, 386],
            [1, 1.0, 315, 0, 386],
            [1, 1.0, 276, 0, 386],
            [1, 1.0, 236, 0, 386],
            [1, 1.0, 355, 0, 264],
            [1, 1.0, 315, 0, 264],
            [1, 1.0, 276, 0, 264],
            [1, 1.0, 236, 0, 264],
            [1, 1.0, 355, 0, 324],
            [1, 1.0, 236, 0, 324],
        ],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.CavesDonkeyCabin,
        name="Backflip above the center trapdoor",
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        locations=[[5, 1.0, 298, 54, 323]],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.CavesDiddyUpperCabin,
        name="On the GB cage",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        locations=[
            [1, 1.0, 337, -2, 362],
            [1, 1.0, 326, -2, 329],
            [1, 1.0, 290, -2, 329],
            [1, 1.0, 279, -2, 362],
            [1, 1.0, 308, -2, 383],
        ],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Behind the back candle",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        locations=[[1, 1.0, 299, 0, 580], [1, 1.0, 299, 18, 580], [1, 1.0, 299, 35, 580], [1, 1.0, 299, 53, 580], [1, 1.0, 299, 70, 580]],
    ),
    ColoredBananaGroup(
        group=177,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Cobwebs",
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        locations=[[1, 1.0, 144, 2, 608], [1, 1.0, 96, 2, 113], [1, 1.0, 392, 2, 109], [1, 1.0, 550, 2, 251], [1, 1.0, 550, 2, 538]],
    ),
    ColoredBananaGroup(
        group=178, map_id=Maps.CavesDiddyLowerCabin, name="Wall torches", konglist=[Kongs.diddy], region=Regions.DiddyLowerCabin, locations=[[5, 1.0, 492, 72, 295], [5, 1.0, 109, 72, 301]]
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.CavesDiddyLowerCabin,
        name="Rocket up around the room",
        konglist=[Kongs.diddy],
        region=Regions.DiddyLowerCabin,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 380, 260, 421],
            [1, 1.0, 435, 260, 346],
            [1, 1.0, 435, 260, 254],
            [1, 1.0, 380, 260, 179],
            [1, 1.0, 292, 260, 150],
            [1, 1.0, 204, 260, 179],
            [1, 1.0, 149, 260, 254],
            [1, 1.0, 149, 260, 346],
            [1, 1.0, 204, 260, 421],
            [1, 1.0, 292, 260, 450],
        ],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.CavesTinyCabin,
        name="Lone side platform",
        konglist=[Kongs.tiny],
        region=Regions.TinyCabin,
        locations=[
            [1, 1.0, 459, 0, 278],
            [1, 1.0, 448, 0, 245],
            [1, 1.0, 412, 0, 245],
            [1, 1.0, 401, 0, 278],
            [1, 1.0, 430, 0, 299],
        ],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.CavesTinyCabin,
        name="Lone corner platform",
        konglist=[Kongs.tiny],
        region=Regions.TinyCabin,
        locations=[
            [1, 1.0, 192, 0, 462],
            [1, 1.0, 181, 0, 429],
            [1, 1.0, 145, 0, 429],
            [1, 1.0, 134, 0, 462],
            [1, 1.0, 163, 0, 483],
        ],
    ),
    ColoredBananaGroup(group=182, map_id=Maps.CavesTinyCabin, name="Corner above the void", konglist=[Kongs.tiny], region=Regions.TinyCabin, locations=[[5, 1.0, 460, 40, 183]]),
    ColoredBananaGroup(
        group=183, map_id=Maps.CavesChunkyCabin, name="Light path corners", konglist=[Kongs.chunky], region=Regions.ChunkyCabin, locations=[[5, 1.0, 167, 50, 206], [5, 1.0, 439, 50, 475]]
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.CavesLankyIgloo,
        name="Upper balloon pad",
        konglist=[Kongs.lanky],
        region=Regions.LankyIgloo,
        logic=lambda l: l.balloon or l.monkey_maneuvers,
        locations=[
            [1, 1.8, 219, 195, 350],
            [1, 1.6, 219, 202, 350],
            [1, 1.4, 219, 209, 350],
            [1, 1.2, 219, 216, 350],
            [1, 1.0, 219, 223, 350],
        ],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.CavesChunkyIgloo,
        name="Hey look, a rabbit !!",
        konglist=[Kongs.chunky],
        region=Regions.ChunkyIgloo,
        locations=[
            [1, 1.0, 277, 0, 320],
            [1, 1.0, 275, 0, 334],
            [1, 1.0, 274, 0, 347],
            [1, 1.0, 272, 0, 361],
            [1, 1.0, 271, 0, 374],
            [1, 1.0, 269, 0, 388],
            [1, 1.0, 285, 0, 338],
            [1, 1.0, 292, 0, 355],
            [1, 1.0, 268, 0, 330],
            [1, 1.0, 260, 0, 339],
        ],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.CavesFrozenCastle,
        name="L on the board",
        konglist=[Kongs.lanky],
        region=Regions.FrozenCastle,
        locations=[[1, 1.0, 301, 2, 264], [1, 1.0, 273, 2, 252], [1, 1.0, 242, 2, 239], [1, 1.0, 232, 2, 267], [1, 1.0, 220, 2, 296]],
    ),
    ColoredBananaGroup(
        group=187,
        map_id=Maps.CavesRotatingCabin,
        name="Front of puzzle",
        konglist=[Kongs.donkey],
        region=Regions.RotatingCabin,
        locations=[
            [1, 1.0, 363, 127, 251],
            [1, 1.0, 340, 127, 251],
            [1, 1.0, 317, 127, 251],
            [1, 1.0, 295, 127, 251],
            [1, 1.0, 272, 127, 251],
        ],
    ),
    ColoredBananaGroup(
        group=188,
        map_id=Maps.CavesLankyCabin,
        name="Around the balloon pad",
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        locations=[
            [1, 1.0, 462, 0, 452],
            [1, 1.0, 489, 0, 439],
            [1, 1.0, 474, 0, 413],
            [1, 1.0, 470, 0, 384],
            [1, 1.0, 441, 0, 389],
            [1, 1.0, 412, 0, 384],
            [1, 1.0, 408, 0, 413],
            [1, 1.0, 393, 0, 439],
            [1, 1.0, 420, 0, 452],
            [1, 1.0, 441, 0, 474],
        ],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.CrystalCaves,
        name="Near pillar by DK portal",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1825, 50, 120], [1734, 60, 82], [1632, 65, 136], [1734, 60, 82]],
    ),
    Balloon(
        id=2,
        map_id=Maps.CrystalCaves,
        name="First room between DK portal and main level",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2085, 100, 301], [2085, 100, 137], [2285, 105, 185], [2206, 105, 344]],
    ),
    Balloon(
        id=3,
        map_id=Maps.CrystalCaves,
        name="Under bridge to W4 Mini Monkey",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[3000, 160, 724], [3093, 160, 848]],
    ),
    Balloon(
        id=4,
        map_id=Maps.CrystalCaves,
        name="Around pillar of Lanky BP",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2701, 245, 923], [2787, 240, 882], [2832, 235, 978], [2769, 240, 1041], [2691, 245, 991]],
    ),
    Balloon(
        id=5,
        map_id=Maps.CrystalCaves,
        name="Around Lanky BP (high)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBlueprintPillar,
        points=[
            [2693, 420, 862],
            [2850, 425, 850],
            [2866, 420, 1012],
            [2765, 420, 1090],
            [2671, 415, 1045],
            [2622, 420, 964],
        ],
    ),
    Balloon(
        id=6,
        map_id=Maps.CrystalCaves,
        name="Above W1 and W2 (Ice castle height)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2105, 350, 648], [2347, 360, 698]],
    ),
    Balloon(
        id=7,
        map_id=Maps.CrystalCaves,
        name="Above small boulder",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1651, 370, 903], [1763, 375, 1039], [1590, 370, 1078], [1561, 365, 978]],
    ),
    Balloon(
        id=8,
        map_id=Maps.CrystalCaves,
        name="Around pillar near Cranky",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1350, 350, 1483], [1450, 350, 1483], [1450, 350, 1583], [1350, 350, 1583]],
    ),
    Balloon(
        id=9,
        map_id=Maps.CrystalCaves,
        name="Above river under bridge to small boulder",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1762, 170, 1158], [1822, 165, 995], [1994, 170, 979]],
    ),
    Balloon(
        id=10,
        map_id=Maps.CrystalCaves,
        name="Beneath BBlast",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1300, 160, 2395], [1467, 160, 2277]],
    ),
    Balloon(
        id=11,
        map_id=Maps.CrystalCaves,
        name="Above area to Mini Monkey W3 room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1029, 380, 2347], [981, 370, 2107]],
    ),
    Balloon(
        id=12,
        map_id=Maps.CrystalCaves,
        name="Behind right pillar near 5DI",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        points=[[801, 150, 1478], [929, 160, 1333], [880, 150, 1180], [929, 160, 1333]],
    ),
    Balloon(
        id=13,
        map_id=Maps.CrystalCaves,
        name="Above Monkeyport igloo",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        points=[
            [347, 220, 1816],
            [236, 225, 1835],
            [193, 220, 1720],
            [279, 225, 1629],
            [369, 220, 1668],
            [390, 225, 1751],
        ],
    ),
    Balloon(
        id=14,
        map_id=Maps.CrystalCaves,
        name="Between Tag barrel and W1",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        points=[[230, 180, 1355], [208, 190, 1096], [438, 180, 994], [208, 190, 1096]],
    ),
    Balloon(
        id=15,
        map_id=Maps.CrystalCaves,
        name="Above Chunky igloo",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        points=[[638, 190, 722], [688, 190, 904], [878, 190, 824], [760, 190, 650]],
    ),
    Balloon(
        id=16,
        map_id=Maps.CrystalCaves,
        name="In waterfall (Under bonus barrel)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2966, 250, 1228], [3079, 260, 1509]],
    ),
    Balloon(
        id=17,
        map_id=Maps.CrystalCaves,
        name="In front of 5DC lower floor",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3372, 280, 1572], [3429, 280, 1907]],
    ),
    Balloon(
        id=18,
        map_id=Maps.CrystalCaves,
        name="Above 5DC middle floor",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3500, 360, 1560], [3520, 360, 1888]],
    ),
    Balloon(
        id=19,
        map_id=Maps.CrystalCaves,
        name="Above river close to waterfall 5DC side",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3110, 110, 1708], [3076, 120, 1507]],
    ),
    Balloon(
        id=20,
        map_id=Maps.CrystalCaves,
        name="Around Tiny BP pillar (low)",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[
            [2974, 230, 1762],
            [2845, 235, 1778],
            [2768, 230, 1905],
            [2900, 225, 2000],
            [3023, 220, 1945],
            [3023, 225, 1828],
        ],
    ),
    Balloon(
        id=21,
        map_id=Maps.CrystalCaves,
        name="Above useless platform below Lanky 1DC",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3000, 240, 1562], [2944, 245, 1646], [2818, 250, 1731], [2944, 245, 1646]],
    ),
    Balloon(
        id=22,
        map_id=Maps.CrystalCaves,
        name="Above river at Lanky 1DC roof height",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[2572, 550, 1885], [2508, 555, 2071], [2361, 545, 2087]],
    ),
    Balloon(
        id=23,
        map_id=Maps.CrystalCaves,
        name="Above rocketbarrel area (between Rotating room and waterfall tag)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[2486, 360, 2478], [2612, 370, 2293]],
    ),
    Balloon(
        id=24,
        map_id=Maps.CrystalCaves,
        name="Above rotating room",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[2677, 460, 2413], [2861, 455, 2293]],
    ),
    Balloon(
        id=25,
        map_id=Maps.CrystalCaves,
        name="In front of Candy",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3308, 240, 1978], [3100, 240, 2144], [3147, 235, 1940]],
    ),
    Balloon(
        id=26,
        map_id=Maps.CavesLankyIgloo,
        name="Around crystal tower (lower)",
        speed=8,
        konglist=[Kongs.lanky],
        region=Regions.LankyIgloo,
        points=[[387, 100, 348], [359, 105, 211], [227, 110, 188], [139, 105, 272], [153, 100, 377], [258, 95, 412]],
    ),
    Balloon(
        id=27,
        map_id=Maps.CavesLankyCabin,
        name="Across room in L pattern",
        speed=10,
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        points=[[117, 90, 422], [440, 80, 422], [440, 90, 160], [440, 80, 422]],
    ),
    Balloon(
        id=28,
        map_id=Maps.CavesDiddyLowerCabin,
        name="Around room above platforms",
        speed=8,
        konglist=[Kongs.diddy],
        region=Regions.DiddyLowerCabin,
        points=[[306, 200, 184], [441, 200, 305], [304, 200, 431], [154, 200, 298]],
    ),
    Balloon(
        id=29,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Above entrance high up in the room",
        speed=7,
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        logic=lambda l: (l.guitar or l.oranges) and (l.spring or (l.CanMoontail() and not l.cabinBarrelMoved())) and l.jetpack,
        points=[[420, 460, 151], [197, 460, 157]],
    ),  # Double Check -> double checked by Snap : sniper is NOT a good idea for this one
    Balloon(
        id=30,
        map_id=Maps.CavesDonkeyCabin,
        name="Around room",
        speed=10,
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        points=[[180, 100, 180], [446, 100, 275], [247, 100, 407]],
    ),
    Balloon(
        id=31,
        map_id=Maps.CrystalCaves,
        name="Around W4 pillar (Diddy)",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        vanilla=True,
        points=[
            [1222, 80, 1837],
            [1295, 76, 1925],
            [1221, 72, 2026],
            [1153, 70, 2007],
            [1127, 72, 1911],
            [1196, 72, 1839],
        ],
    ),
    Balloon(
        id=32,
        map_id=Maps.CrystalCaves,
        name="In front of Snide (Chunky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesSnideArea,
        vanilla=True,
        points=[[1153, 158, 468], [1310, 150, 395], [1305, 156, 547], [1210, 150, 610]],
    ),
    Balloon(
        id=33,
        map_id=Maps.CrystalCaves,
        name="Around Tiny blueprint (Tiny)",
        speed=16,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        vanilla=True,
        points=[
            [3001, 447, 1910],
            [2943, 453, 1968],
            [2869, 451, 1969],
            [2823, 451, 1911],
            [2814, 445, 1829],
            [2866, 435, 1773],
            [2946, 445, 1776],
        ],
    ),
    Balloon(
        id=34,
        map_id=Maps.CrystalCaves,
        name="Waterfall (Lanky)",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        vanilla=True,
        points=[[2297, 116, 2243], [2265, 114, 2119]],
    ),
    Balloon(
        id=35,
        map_id=Maps.CrystalCaves,
        name="In gorilla gone room (Donkey)",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesGGRoom,
        vanilla=True,
        points=[[2698, 83, 501], [2519, 81, 572]],
    ),
    Balloon(
        id=36,
        map_id=Maps.CrystalCaves,
        name="Above 5DC (Diddy)",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        vanilla=True,
        points=[[3629, 603, 1597], [3606, 601, 1730], [3614, 599, 1832]],
    ),
    Balloon(
        id=37,
        map_id=Maps.CrystalCaves,
        name="In bonus barrel cave (Chunky)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CavesBonusCave,
        vanilla=True,
        points=[
            [382, 234, 2575],
            [349, 234, 2457],
            [429, 238, 2377],
            [511, 224, 2425],
            [528, 248, 2546],
            [475, 222, 2583],
        ],
    ),
    Balloon(
        id=38,
        map_id=Maps.CrystalCaves,
        name="In Diddy BP room (Tiny)",
        speed=16,
        konglist=[Kongs.diddy, Kongs.tiny],
        region=Regions.CavesBlueprintCave,
        vanilla=True,
        points=[
            [3509, 320, 605],
            [3589, 326, 669],
            [3617, 330, 750],
            [3538, 338, 815],
            [3459, 342, 767],
            [3430, 332, 641],
        ],
    ),
    Balloon(
        id=39,
        map_id=Maps.CrystalCaves,
        name="In giant boulder room (Donkey)",
        speed=11,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.BoulderCave,
        vanilla=True,
        points=[[2047, 380, 2375], [2085, 372, 2573], [1875, 358, 2677], [1755, 364, 2477], [1896, 366, 2325]],
    ),
    Balloon(
        id=40,
        map_id=Maps.CavesTinyIgloo,
        name="In Tiny 5DI (Tiny)",
        speed=10,
        konglist=[Kongs.tiny],
        region=Regions.TinyIgloo,
        vanilla=True,
        points=[[239, 82, 450], [175, 84, 269], [344, 80, 181], [378, 82, 375]],
    ),
    Balloon(
        id=41,
        map_id=Maps.CavesLankyIgloo,
        name="In Lanky 5DI (Lanky)",
        speed=7,
        konglist=[Kongs.lanky],
        region=Regions.LankyIgloo,
        vanilla=True,
        points=[[328, 312, 426], [204, 302, 440], [124, 308, 342], [196, 294, 172], [374, 308, 214]],
    ),
    Balloon(
        id=42,
        map_id=Maps.CavesDonkeyIgloo,
        name="In DK 5DI (Donkey)",
        speed=14,
        konglist=[Kongs.donkey],
        region=Regions.DonkeyIgloo,
        vanilla=True,
        points=[[415, 90, 507], [463, 80, 445], [533, 90, 487], [479, 82, 565]],
    ),
    Balloon(
        id=43,
        map_id=Maps.CavesTinyCabin,
        name="In Tiny 5DC (Tiny)",
        speed=15,
        konglist=[Kongs.tiny],
        region=Regions.TinyCabin,
        vanilla=True,
        points=[[455, -99, 385], [432, 51, 384]],
    ),
    Balloon(
        id=44,
        map_id=Maps.CavesChunkyIgloo,
        name="In Chunky 5DI (Chunky)",
        speed=16,
        konglist=[Kongs.chunky],
        region=Regions.ChunkyIgloo,
        vanilla=True,
        points=[[201, 76, 198], [324, 78, 196], [375, 70, 348], [269, 74, 407], [173, 72, 350]],
    ),
    Balloon(
        id=45,
        map_id=Maps.CavesFrozenCastle,
        name="In frozen castle (Lanky)",
        speed=8,
        konglist=[Kongs.lanky],
        region=Regions.FrozenCastle,
        vanilla=True,
        points=[[96, 94, 283], [151, 94, 173]],
    ),
    Balloon(
        id=46,
        map_id=Maps.CavesDiddyIgloo,
        name="In Diddy 5DI (Diddy)",
        speed=13,
        konglist=[Kongs.diddy],
        region=Regions.DiddyIgloo,
        vanilla=True,
        points=[[288, 120, 174], [383, 110, 224], [411, 100, 323], [287, 102, 451], [161, 102, 375], [183, 124, 242]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=47,
        map_id=Maps.CrystalCaves,
        name="Around the big ice castle pillar",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2350, 160, 1026], [2369, 165, 889], [2222, 139, 804], [2070, 145, 883], [2041, 177, 1023], [2070, 145, 883], [2222, 139, 804], [2369, 165, 889]],
    ),
    Balloon(
        id=48,
        map_id=Maps.CrystalCaves,
        name="Slope to Cranky",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1304, 140, 1333], [1252, 333, 1637]],
    ),
    Balloon(
        id=49,
        map_id=Maps.CrystalCaves,
        name="Bridge near Cranky",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1262, 360, 1971], [1196, 320, 1998], [1260, 260, 2010], [1376, 317, 1954]],
    ),
    Balloon(
        id=50,
        map_id=Maps.CrystalCaves,
        name="Igloo area entrance",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[907, 88, 1644], [907, 235, 1644]],
    ),
    Balloon(
        id=51,
        map_id=Maps.CrystalCaves,
        name="Little spire near Chunky transparent igloo",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.IglooArea,
        points=[[664, 80, 960], [774, 77, 934], [797, 91, 1055], [728, 135, 1081]],
    ),
    Balloon(
        id=52,
        map_id=Maps.CrystalCaves,
        name="Tall pillar near ice castle",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[1867, 395, 805], [1949, 344, 750], [2009, 370, 777], [1973, 382, 833]],
    ),
    Balloon(
        id=53,
        map_id=Maps.CrystalCaves,
        name="Crystal platforms near Funky",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CrystalCavesMain,
        points=[[2328, 140, 1161], [2400, 316, 1273], [2598, 244, 1159]],
    ),
    Balloon(
        id=54,
        map_id=Maps.CrystalCaves,
        name="Near Lanky cabin",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[2326, 415, 1999], [2496, 334, 1890]],
    ),
    Balloon(
        id=55,
        map_id=Maps.CrystalCaves,
        name="Tall pillar near 5-door cabin",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CabinArea,
        points=[[3237, 333, 1724], [3266, 301, 1586], [3136, 316, 1568], [3123, 347, 1644]],
    ),
    Balloon(
        id=56,
        map_id=Maps.CavesDonkeyCabin,
        name="Front holes",
        speed=12,
        konglist=[Kongs.donkey],
        region=Regions.DonkeyCabin,
        points=[[414, 30, 337], [411, 100, 275], [417, 30, 216], [411, -70, 275]],
    ),
    Balloon(
        id=57,
        map_id=Maps.CavesDiddyUpperCabin,
        name="Middle of the room",
        speed=9,
        konglist=[Kongs.diddy],
        region=Regions.DiddyUpperCabin,
        points=[[434, 106, 269], [300, 106, 451], [176, 106, 276]],
    ),
    Balloon(
        id=58,
        map_id=Maps.CavesChunkyCabin,
        name="Middle of the room",
        speed=9,
        konglist=[Kongs.chunky],
        region=Regions.ChunkyCabin,
        points=[[300, 64, 268], [372, 64, 338], [288, 64, 410], [213, 64, 332]],
    ),
    Balloon(
        id=59,
        map_id=Maps.CavesRotatingCabin,
        name="Puzzles",
        speed=6,
        konglist=[Kongs.donkey],
        region=Regions.RotatingCabin,
        points=[[317, 142, 285], [423, 242, 286], [217, 244, 282]],
    ),
    Balloon(
        id=60,
        map_id=Maps.CavesLankyCabin,
        name="GB hole",
        speed=17,
        konglist=[Kongs.lanky],
        region=Regions.LankyCabin,
        points=[[446, 40, 180], [446, -40, 180]],
    ),
]
