"""Flag locations for the check_flags command."""

from randomizer.Lists.Location import DROPSANITY_FLAG_START

location_flag_to_name = {
    1: "Japes Lanky Grape Gate Barrel",
    2: "Japes Tiny Feather Gate Barrel",
    3: "Japes Donkey Baboon Blast",
    4: "Japes in Front of Diddy Cage",
    5: "Japes Free Diddy Item",
    6: "Japes Cage: Diddy Kong",
    8: "Japes Tiny Stump",
    9: "Japes Tiny Beehive",
    10: "Japes Lanky Painting Room Zingers",
    11: "Japes Lanky Slope Barrel",
    12: "Japes Chunky Underground",
    18: "Japes Diddy Timed Cage Banana",
    19: "Japes Lanky Timed Cage Banana",
    20: "Japes Donkey Floor Cage Banana",
    21: "Japes Tiny Timed Cage Banana",
    22: "Japes Chunky Timed Cage Banana",
    23: "Japes Diddy Top of Mountain",
    24: "Japes Diddy Minecart",
    25: "Japes Chunky Boulder",
    26: "Japes Boss Defeated",
    28: "Japes Chunky Giant Bonus Barrel",
    31: "Japes Diddy Peanut Tunnel",
    49: "Aztec Chunky Vases",
    51: "Aztec Donkey Free Llama Blast",
    52: "Aztec Chunky Giant Caged Barrel",
    54: "Aztec Diddy Ram Gongs",
    56: "Aztec Diddy 5 Door Temple",
    57: "Aztec Donkey 5 Door Temple",
    58: "Aztec Tiny 5 Door Temple",
    59: "Aztec Chunky 5 Door Temple",
    60: "Aztec Lanky 5 Door Temple",
    62: "Aztec Donkey Sealed Quicksand Tunnel Barrel",
    63: "Aztec Diddy Vulture Race",
    64: "Aztec Chunky Klaptrap Room",
    65: "Aztec Tiny Klaptrap Room",
    66: "Aztec Cage: Tiny Kong",
    67: "Aztec Free Tiny Item",
    68: "Aztec Lanky Vulture Shooting",
    70: "Aztec Cage: Lanky Kong",
    71: "Aztec Tiny Llama Temple Lava Pedestals",
    72: "Aztec Lanky Matching Game",
    73: "Aztec Lanky Llama Temple Barrel",
    74: "Aztec Boss Defeated",
    75: "Aztec Tiny Beetle Race",
    77: "Aztec Free Lanky Item",
    112: "Factory Donkey Power Hut",
    113: "Factory Diddy Production Spring",
    114: "Factory Chunky Production Timer",
    115: "Factory Lanky Production Handstand",
    116: "Factory Tiny Production Twirl",
    117: "Factory Cage: Chunky Kong",
    118: "Factory Free Chunky Item",
    121: "Factory Chunky Dark Room",
    122: "Factory Donkey Number Game",
    123: "Factory Tiny Mini by Arcade",
    124: "Factory Tiny Dartboard",
    125: "Factory Lanky Piano Game",
    126: "Factory Diddy Charge Enemies",
    127: "Factory Chunky Toy Monster",
    128: "Factory Donkey Crusher Room",
    130: "Factory Donkey DK Arcade Round 1",
    132: "DK Arcade Round 2",
    134: "Factory Diddy Storage Room Barrel",
    135: "Factory Diddy Block Tower",
    136: "Factory Chunky Barrel by Arcade",
    137: "Factory Lanky Testing Room Barrel",
    138: "Factory Boss Defeated",
    139: "Factory Tiny Car Race",
    154: "Galleon Chunky Cannon Game",
    157: "Galleon Donkey Lighthouse",
    163: "Galleon Diddy Gold Tower Barrel",
    164: "Galleon Lanky Gold Tower Barrel",
    165: "Galleon Donkey Seal Race",
    166: "Galleon Chunky Seasick",
    167: "Galleon Diddy Mechfish",
    168: "Galleon Boss Defeated",
    182: "Galleon Chunky Chest",
    183: "Galleon Lanky 2 Door Ship",
    184: "Galleon Tiny 2 Door Ship",
    186: "Treasure Chest Far Left Clam",
    187: "Treasure Chest Center Clam",
    188: "Treasure Chest Far Right Clam",
    189: "Treasure Chest Close Right Clam",
    190: "Treasure Chest Close Left Clam",
    191: "Galleon Tiny Mermaid Reward",
    192: "Galleon Lanky Enguarde Chest",
    193: "Galleon Donkey Free the Seal",
    197: "Galleon Chunky 5 Door Ship",
    198: "Galleon Diddy 5 Door Ship",
    199: "Galleon Lanky 5 Door Ship",
    200: "Galleon Donkey 5 Door Ship",
    201: "Galleon Tiny 5 Door Ship",
    202: "Galleon Tiny Submarine Barrel",
    204: "Galleon Diddy Top of Lighthouse",
    205: "Forest Tiny Anthill Banana",
    209: "Forest Tiny Top of the Beanstalk",
    211: "Forest Diddy Top of Mushroom Barrel",
    214: "Forest Diddy Winch Cage",
    215: "Forest Chunky Minecart",
    216: "Forest Diddy Dark Rafters",
    217: "Forest Lanky Attic Shooting",
    219: "Forest Donkey Mill Levers",
    221: "Forest Chunky Keg Crushing",
    224: "Forest Lanky Colored Mushroom Slam",
    225: "Forest Chunky Face Puzzle",
    226: "Forest Lanky Zinger Bounce",
    227: "Forest Tiny Mushroom Barrel",
    228: "Forest Donkey Mushroom Cannons",
    235: "Forest Donkey Thornvine Barn Barrel",
    236: "Forest Boss Defeated",
    247: "Forest Tiny Spider Boss",
    249: "Forest Lanky Rabbit Race",
    250: "Forest Diddy Owl Race",
    253: "Forest Chunky Apple Rescue",
    254: "Forest Donkey Baboon Blast",
    259: "Caves Lanky Beetle Race",
    260: "Caves Tiny 5 Door Cabin",
    261: "Caves Donkey 5 Door Cabin",
    262: "Caves Diddy 5 Door Cabin Lower",
    263: "Caves Chunky 5 Door Cabin",
    264: "Caves Lanky Sprint Cabin",
    268: "Caves Chunky Gorilla Gone",
    270: "Caves Chunky Transparent Igloo",
    271: "Caves Lanky Ice Castle Slam Challenge",
    274: "Caves Diddy 5 Door Igloo",
    275: "Caves Donkey 5 Door Igloo",
    276: "Caves Donkey Rotating Cabin",
    278: "Caves Chunky 5 Door Igloo",
    279: "Caves Tiny 5 Door Igloo",
    281: "Caves Lanky 5 Door Igloo",
    292: "Caves Boss Defeated",
    293: "Caves Diddy 5 Door Cabin Upper",
    294: "Caves Diddy Jetpack Barrel",
    295: "Caves Tiny Mini Cave Barrel",
    297: "Caves Tiny Monkeyport Igloo",
    298: "Caves Donkey Baboon Blast",
    301: "Returning the Banana Fairies",
    305: "Castle Diddy Ballroom",
    306: "Castle Lanky Tower",
    308: "Castle Lanky Mausoleum",
    309: "Castle Tiny Mausoleum",
    310: "Castle Diddy Crypt",
    311: "Castle Chunky Crypt",
    313: "Castle Donkey Library",
    314: "Castle Chunky Museum",
    315: "Castle Tiny Over Chasm",
    316: "Castle Lanky Dungeon",
    317: "Castle Boss Defeated",
    318: "Castle Donkey Minecart",
    319: "Castle Chunky Tree Sniping Barrel",
    320: "Castle Donkey Tree Sniping",
    322: "Castle Chunky Shed",
    323: "Castle Lanky Greenhouse",
    325: "Castle Tiny Car Race",
    326: "Castle Donkey Dungeon",
    350: "Castle Diddy Above Castle",
    351: "Castle Tiny Trash Can",
    353: "Castle Diddy Dungeon",
    377: "The Banana Fairy's Gift",
    379: "Jetpac",
    380: "The End of Helm",
    381: "Isles Japes Lobby Entrance Item",
    385: "Kong Unlocked: Donkey",
    398: "Isles Lanky Japes Instrument",
    402: "Isles Tiny Aztec Lobby Barrel",
    403: "Isles Tiny Galleon Lobby Swim",
    404: "Isles Donkey Bongos Pad",
    406: "Isles Chunky Helm Lobby Barrel",
    410: "Isles Diddy Guitar Pad",
    411: "Isles Donkey Caves Lava",
    415: "Isles Lanky Castle Lobby Barrel",
    416: "Isles Diddy Snides Spring Barrel",
    419: "Isles Donkey Coconut Cage",
    420: "Isles Tiny Feather Cage",
    421: "Isles Lanky Grape Cage",
    422: "Isles Chunky Pineapple Cage",
    423: "Isles Diddy Peanut Cage",
    424: "Isles Chunky Triangle Pad",
    425: "Isles Tiny Saxophone Pad",
    428: "Isles Diddy Summit Barrel",
    429: "Isles Lanky Sprint Cage",
    431: "Isles Chunky Pound the X",
    444: "Key 1 Turned",
    445: "Key 2 Turned",
    446: "Key 3 Turned",
    447: "Key 4 Turned",
    448: "Key 5 Turned",
    449: "Key 6 Turned",
    450: "Key 7 Turned",
    451: "Key 8 Turned",
    469: "Japes Kasplat: Hive Tunnel Lower",
    470: "Japes Kasplat: Near Painting Room",
    471: "Japes Kasplat: By Lanky Slope Bonus",
    472: "Japes Kasplat: Hive Tunnel Upper",
    473: "Japes Kasplat: Underground",
    474: "Aztec Kasplat: Behind DK Stone Door",
    475: "Aztec Kasplat: On Tiny Temple",
    476: "Aztec Kasplat: Llama Temple Lava",
    477: "Aztec Kasplat: Hunky Chunky Barrel",
    478: "Aztec Kasplat: Chunky 5-Door Temple",
    479: "Factory Kasplat: Upper Production Pipe",
    480: "Factory Kasplat: Base of Production",
    481: "Factory Kasplat: Research and Development",
    482: "Factory Kasplat: Pole to Arcade",
    483: "Factory Kasplat: Block Tower",
    484: "Galleon Kasplat: Diddy Gold Tower",
    485: "Galleon Kasplat: Lighthouse Alcove",
    486: "Galleon Kasplat: Cannon Game Room",
    487: "Galleon Kasplat: Past Vines",
    488: "Galleon Kasplat: Musical Cactus",
    489: "Forest Kasplat: Behind DK's Barn",
    490: "Forest Kasplat: Inside Giant Mushroom",
    491: "Forest Kasplat: Under Owl Tree",
    492: "Forest Kasplat: Low Mushroom Exterior",
    493: "Forest Kasplat: Mushroom Night Door",
    494: "Caves Kasplat: Near Ice Castle",
    495: "Caves Kasplat: Mini Room by Funky",
    496: "Caves Kasplat: On the Pillar",
    497: "Caves Kasplat: By the Far Warp 2",
    498: "Caves Kasplat: On 5-Door Igloo",
    499: "Castle Kasplat: Inside the Tree",
    500: "Castle Kasplat: Lower Cave Center",
    501: "Castle Kasplat: Near Upper Warp 2",
    502: "Castle Kasplat: On a lone platform",
    503: "Castle Kasplat: Near Candy's",
    504: "Isles Kasplat: Helm Lobby",
    505: "Isles Kasplat: Castle Lobby",
    506: "Isles Kasplat: Caves Lobby Punch",
    507: "Isles Kasplat: Factory Lobby Box",
    508: "Isles Kasplat: Galleon Lobby",
    549: "Japes Donkey Medal",
    550: "Japes Diddy Medal",
    551: "Japes Lanky Medal",
    552: "Japes Tiny Medal",
    553: "Japes Chunky Medal",
    554: "Aztec Donkey Medal",
    555: "Aztec Diddy Medal",
    556: "Aztec Lanky Medal",
    557: "Aztec Tiny Medal",
    558: "Aztec Chunky Medal",
    559: "Factory Donkey Medal",
    560: "Factory Diddy Medal",
    561: "Factory Lanky Medal",
    562: "Factory Tiny Medal",
    563: "Factory Chunky Medal",
    564: "Galleon Donkey Medal",
    565: "Galleon Diddy Medal",
    566: "Galleon Lanky Medal",
    567: "Galleon Tiny Medal",
    568: "Galleon Chunky Medal",
    569: "Forest Donkey Medal",
    570: "Forest Diddy Medal",
    571: "Forest Lanky Medal",
    572: "Forest Tiny Medal",
    573: "Forest Chunky Medal",
    574: "Caves Donkey Medal",
    575: "Caves Diddy Medal",
    576: "Caves Lanky Medal",
    577: "Caves Tiny Medal",
    578: "Caves Chunky Medal",
    579: "Castle Donkey Medal",
    580: "Castle Diddy Medal",
    581: "Castle Lanky Medal",
    582: "Castle Tiny Medal",
    583: "Castle Chunky Medal",
    584: "Helm Donkey Medal",
    585: "Helm Diddy Medal",
    586: "Helm Lanky Medal",
    587: "Helm Tiny Medal",
    588: "Helm Chunky Medal",
    589: "Japes Fairy (Rambi Door Pool)",
    590: "Japes Fairy (Painting Room)",
    591: "Factory Fairy (Near Funky's)",
    592: "Galleon Fairy (In Punch Chest)",
    593: "Isles Fairy (Factory Lobby)",
    594: "Isles Fairy (Forest Lobby)",
    595: "Forest Fairy (Dark Rafters)",
    596: "Forest Fairy (Thornvine Barn)",
    597: "Caves Fairy (Tiny Igloo)",
    598: "Helm Fairy (Key 8 Room (1))",
    599: "Helm Fairy (Key 8 Room (2))",
    600: "Aztec Fairy (Llama Temple)",
    601: "Aztec Fairy (Tiny 5-Door Temple)",
    602: "Factory Fairy (Number Game)",
    603: "Galleon Fairy (In Tiny's 5-Door Ship)",
    604: "Castle Fairy (Near Car Race)",
    605: "Castle Fairy (Tree Sniper Room)",
    606: "Isles Fairy (Small Island)",
    607: "Isles Fairy (Upper Krem Isles)",
    608: "Caves Fairy (Diddy Candles Cabin)",
    609: "Japes Battle Arena (Near Funky)",
    610: "Aztec Battle Arena (Tiny Temple: Vulture Room)",
    611: "Factory Battle Arena (Under R&D Grate)",
    612: "Galleon Battle Arena (Under Cranky)",
    613: "Forest Battle Arena (Giant Mushroom High Ladder Platform)",
    614: "Isles Battle Arena 2 (Fungi Lobby: Gorilla Gone Box)",
    615: "Isles Battle Arena 1 (Snide's Room: Under Rock)",
    616: "Caves Battle Arena (Rotating Room: Left Portion)",
    617: "Castle Battle Arena (Greenhouse: Center)",
    618: "Helm Battle Arena (Top of Blast-o-Matic)",
    678: "Japes Dirt: Painting Hill",
    679: "Aztec Dirt: Chunky Temple",
    680: "Factory Dirt: Dark Room",
    681: "Isles Dirt: Cabin Isle",
    682: "Isles Dirt: Under Caves Lobby",
    683: "Isles Dirt: Aztec Roof",
    684: "Aztec Dirt: Oasis",
    685: "Forest Dirt: Mills Grass",
    686: "Forest Dirt: Beanstalk",
    687: "Galleon Dirt: Lighthouse",
    688: "Caves Dirt: Giant Kosha",
    689: "Castle Dirt: Top Floor",
    690: "Isles Dirt: Back of Prison",
    691: "Isles Dirt: Training Grounds Rear Tunnel",
    692: "Isles Dirt: Banana Hoard",
    693: "Isles Dirt: Castle Lobby",
    694: "Isles Boulder: Near Level 2",
    695: "Isles Boulder: Near Level 6",
    696: "Aztec Boulder: Tunnel",
    697: "Caves Boulder: Small",
    698: "Caves Boulder: Large",
    699: "Castle Boulder: Museum",
    700: "Isles Boulder: Japes Lobby",
    701: "Isles Boulder: Castle Lobby",
    702: "Isles Boulder: Caves Lobby",
    703: "Forest Keg: Mill Front Near",
    704: "Forest Keg: Mill Front Far",
    705: "Forest Keg: Mill Back",
    706: "Aztec Vase: Circle",
    707: "Aztec Vase: Colon",
    708: "Aztec Vase: Triangle",
    709: "Aztec Vase: Plus",
    768: "Forest Second Anthill Reward",
    940: "Japes Crate: Behind the Mountain",
    941: "Japes Crate: In the Rambi Cave",
    942: "Aztec Crate: Llama Temple Entrance",
    943: "Factory Crate: Near Funky",
    944: "Factory Crate: Near Candy",
    945: "Galleon Crate: Near Cactus",
    946: "Aztec Crate: On Llama Temple",
    947: "Aztec Crate: Near Gong Tower",
    948: "Forest Crate: Near Owl Tree",
    949: "Forest Crate: Near Thornvine Barn",
    950: "Forest Crate: Behind Dark Attic",
    951: "Forest Crate: In Thornvine Barn",
    952: "Castle Crate: Behind Mausoleum Entrance",
    # Half Medals (flags 982-1021: 0x3D6 + (5 * level_index) + kong)
    982: "Japes Donkey Half Medal",
    983: "Japes Diddy Half Medal",
    984: "Japes Lanky Half Medal",
    985: "Japes Tiny Half Medal",
    986: "Japes Chunky Half Medal",
    987: "Aztec Donkey Half Medal",
    988: "Aztec Diddy Half Medal",
    989: "Aztec Lanky Half Medal",
    990: "Aztec Tiny Half Medal",
    991: "Aztec Chunky Half Medal",
    992: "Factory Donkey Half Medal",
    993: "Factory Diddy Half Medal",
    994: "Factory Lanky Half Medal",
    995: "Factory Tiny Half Medal",
    996: "Factory Chunky Half Medal",
    997: "Galleon Donkey Half Medal",
    998: "Galleon Diddy Half Medal",
    999: "Galleon Lanky Half Medal",
    1000: "Galleon Tiny Half Medal",
    1001: "Galleon Chunky Half Medal",
    1002: "Forest Donkey Half Medal",
    1003: "Forest Diddy Half Medal",
    1004: "Forest Lanky Half Medal",
    1005: "Forest Tiny Half Medal",
    1006: "Forest Chunky Half Medal",
    1007: "Caves Donkey Half Medal",
    1008: "Caves Diddy Half Medal",
    1009: "Caves Lanky Half Medal",
    1010: "Caves Tiny Half Medal",
    1011: "Caves Chunky Half Medal",
    1012: "Castle Donkey Half Medal",
    1013: "Castle Diddy Half Medal",
    1014: "Castle Lanky Half Medal",
    1015: "Castle Tiny Half Medal",
    1016: "Castle Chunky Half Medal",
    DROPSANITY_FLAG_START + 0x0: "Japes Enemy: Start",
    DROPSANITY_FLAG_START + 0x1: "Japes Enemy: Diddy Cavern",
    DROPSANITY_FLAG_START + 0x2: "Japes Enemy: Tunnel (0)",
    DROPSANITY_FLAG_START + 0x3: "Japes Enemy: Tunnel (1)",
    DROPSANITY_FLAG_START + 0x4: "Japes Enemy: Storm (0)",
    DROPSANITY_FLAG_START + 0x5: "Japes Enemy: Storm (1)",
    DROPSANITY_FLAG_START + 0x6: "Japes Enemy: Storm (2)",
    DROPSANITY_FLAG_START + 0x7: "Japes Enemy: Hive (0)",
    DROPSANITY_FLAG_START + 0x8: "Japes Enemy: Hive (1)",
    DROPSANITY_FLAG_START + 0x9: "Japes Enemy: Hive (2)",
    DROPSANITY_FLAG_START + 0xA: "Japes Enemy: Hive (3)",
    DROPSANITY_FLAG_START + 0xB: "Japes Enemy: Hive (4)",
    DROPSANITY_FLAG_START + 0xC: "Japes Enemy: Killed In Demo",
    DROPSANITY_FLAG_START + 0xD: "Japes Enemy: Near Underground",
    DROPSANITY_FLAG_START + 0xE: "Japes Enemy: Near Painting (0)",
    DROPSANITY_FLAG_START + 0xF: "Japes Enemy: Near Painting (1)",
    DROPSANITY_FLAG_START + 0x10: "Japes Enemy: Near Painting (2)",
    DROPSANITY_FLAG_START + 0x11: "Japes Enemy: Mountain",
    DROPSANITY_FLAG_START + 0x12: "Japes Enemy: Feather Tunnel",
    DROPSANITY_FLAG_START + 0x13: "Japes Enemy: Middle Tunnel",
    DROPSANITY_FLAG_START + 0x14: "Isles Japes Lobby Enemy: Enemy (0)",
    DROPSANITY_FLAG_START + 0x15: "Isles Japes Lobby Enemy: Enemy (1)",
    DROPSANITY_FLAG_START + 0x1B: "Japes Mountain Enemy: Start (0)",
    DROPSANITY_FLAG_START + 0x1C: "Japes Mountain Enemy: Start (1)",
    DROPSANITY_FLAG_START + 0x1D: "Japes Mountain Enemy: Start (2)",
    DROPSANITY_FLAG_START + 0x1E: "Japes Mountain Enemy: Start (3)",
    DROPSANITY_FLAG_START + 0x1F: "Japes Mountain Enemy: Start (4)",
    DROPSANITY_FLAG_START + 0x20: "Japes Mountain Enemy: Near Gate Switch (0)",
    DROPSANITY_FLAG_START + 0x21: "Japes Mountain Enemy: Near Gate Switch (1)",
    DROPSANITY_FLAG_START + 0x22: "Japes Mountain Enemy: Hi Lo",
    DROPSANITY_FLAG_START + 0x23: "Japes Mountain Enemy: Conveyor (0)",
    DROPSANITY_FLAG_START + 0x24: "Japes Mountain Enemy: Conveyor (1)",
    DROPSANITY_FLAG_START + 0x25: "Japes Tiny Hive Enemy: First Room",
    DROPSANITY_FLAG_START + 0x26: "Japes Tiny Hive Enemy: Second Room (0)",
    DROPSANITY_FLAG_START + 0x27: "Japes Tiny Hive Enemy: Second Room (1)",
    DROPSANITY_FLAG_START + 0x28: "Japes Tiny Hive Enemy: Third Room (0)",
    DROPSANITY_FLAG_START + 0x29: "Japes Tiny Hive Enemy: Third Room (1)",
    DROPSANITY_FLAG_START + 0x2A: "Japes Tiny Hive Enemy: Third Room (2)",
    DROPSANITY_FLAG_START + 0x2B: "Japes Tiny Hive Enemy: Third Room (3)",
    DROPSANITY_FLAG_START + 0x2C: "Japes Tiny Hive Enemy: Main Room",
    DROPSANITY_FLAG_START + 0x2D: "Aztec Enemy: Vase Room (0)",
    DROPSANITY_FLAG_START + 0x2E: "Aztec Enemy: Vase Room (1)",
    DROPSANITY_FLAG_START + 0x2F: "Aztec Enemy: Vase Room (2)",
    DROPSANITY_FLAG_START + 0x30: "Aztec Enemy: Tunnel Pad (0)",
    DROPSANITY_FLAG_START + 0x31: "Aztec Enemy: Tunnel Cage (0)",
    DROPSANITY_FLAG_START + 0x32: "Aztec Enemy: Tunnel Cage (1)",
    DROPSANITY_FLAG_START + 0x33: "Aztec Enemy: Tunnel Cage (2)",
    DROPSANITY_FLAG_START + 0x34: "Aztec Enemy: Starting Tunnel (0)",
    DROPSANITY_FLAG_START + 0x35: "Aztec Enemy: Starting Tunnel (1)",
    DROPSANITY_FLAG_START + 0x36: "Aztec Enemy: Oasis Door",
    DROPSANITY_FLAG_START + 0x37: "Aztec Enemy: Tunnel Cage (3)",
    DROPSANITY_FLAG_START + 0x38: "Aztec Enemy: Outside Llama",
    DROPSANITY_FLAG_START + 0x39: "Aztec Enemy: Outside Tower",
    DROPSANITY_FLAG_START + 0x3A: "Aztec Enemy: Tunnel Pad (1)",
    DROPSANITY_FLAG_START + 0x3B: "Aztec Enemy: Near Candy",
    DROPSANITY_FLAG_START + 0x3C: "Aztec Enemy: Around Totem",
    DROPSANITY_FLAG_START + 0x3D: "Aztec Enemy: Starting Tunnel (2)",
    DROPSANITY_FLAG_START + 0x3E: "Aztec Enemy: Starting Tunnel (3)",
    DROPSANITY_FLAG_START + 0x3F: "Aztec Enemy: Outside Snide",
    DROPSANITY_FLAG_START + 0x40: "Aztec Enemy: Outside 5DT",
    DROPSANITY_FLAG_START + 0x41: "Aztec Enemy: Near Sealed Quicksand Tunnel",
    DROPSANITY_FLAG_START + 0x44: "Aztec Donkey 5DTemple Enemy: Start Trap (0)",
    DROPSANITY_FLAG_START + 0x45: "Aztec Donkey 5DTemple Enemy: Start Trap (1)",
    DROPSANITY_FLAG_START + 0x46: "Aztec Donkey 5DTemple Enemy: Start Trap (2)",
    DROPSANITY_FLAG_START + 0x47: "Aztec Donkey 5DTemple Enemy: End Trap (0)",
    DROPSANITY_FLAG_START + 0x48: "Aztec Donkey 5DTemple Enemy: End Trap (1)",
    DROPSANITY_FLAG_START + 0x49: "Aztec Donkey 5DTemple Enemy: End Trap (2)",
    DROPSANITY_FLAG_START + 0x4A: "Aztec Donkey 5DTemple Enemy: End Path (0)",
    DROPSANITY_FLAG_START + 0x4B: "Aztec Donkey 5DTemple Enemy: End Path (1)",
    DROPSANITY_FLAG_START + 0x4C: "Aztec Donkey 5DTemple Enemy: Start Path",
    DROPSANITY_FLAG_START + 0x4D: "Aztec Diddy 5DTemple Enemy: End Trap (0)",
    DROPSANITY_FLAG_START + 0x4E: "Aztec Diddy 5DTemple Enemy: End Trap (1)",
    DROPSANITY_FLAG_START + 0x4F: "Aztec Diddy 5DTemple Enemy: End Trap (2)",
    DROPSANITY_FLAG_START + 0x50: "Aztec Diddy 5DTemple Enemy: Start Left (0)",
    DROPSANITY_FLAG_START + 0x51: "Aztec Diddy 5DTemple Enemy: Start Left (1)",
    DROPSANITY_FLAG_START + 0x52: "Aztec Diddy 5DTemple Enemy: Reward",
    DROPSANITY_FLAG_START + 0x53: "Aztec Diddy 5DTemple Enemy: Second Switch",
    DROPSANITY_FLAG_START + 0x54: "Aztec Lanky 5DTemple Enemy: Joining Paths",
    DROPSANITY_FLAG_START + 0x55: "Aztec Lanky 5DTemple Enemy: End Trap",
    DROPSANITY_FLAG_START + 0x56: "Aztec Lanky 5DTemple Enemy: Reward",
    DROPSANITY_FLAG_START + 0x57: "Aztec Tiny 5DTemple Enemy: Start Right Front",
    DROPSANITY_FLAG_START + 0x58: "Aztec Tiny 5DTemple Enemy: Start Left Back",
    DROPSANITY_FLAG_START + 0x59: "Aztec Tiny 5DTemple Enemy: Start Right Back",
    DROPSANITY_FLAG_START + 0x5A: "Aztec Tiny 5DTemple Enemy: Start Left Front",
    DROPSANITY_FLAG_START + 0x5B: "Aztec Tiny 5DTemple Enemy: Reward (0)",
    DROPSANITY_FLAG_START + 0x5C: "Aztec Tiny 5DTemple Enemy: Reward (1)",
    DROPSANITY_FLAG_START + 0x5D: "Aztec Tiny 5DTemple Enemy: Dead End (0)",
    DROPSANITY_FLAG_START + 0x5E: "Aztec Tiny 5DTemple Enemy: Dead End (1)",
    DROPSANITY_FLAG_START + 0x5F: "Aztec Chunky 5DTemple Enemy: Start Right",
    DROPSANITY_FLAG_START + 0x60: "Aztec Chunky 5DTemple Enemy: Start Left",
    DROPSANITY_FLAG_START + 0x61: "Aztec Chunky 5DTemple Enemy: Second Right",
    DROPSANITY_FLAG_START + 0x62: "Aztec Chunky 5DTemple Enemy: Second Left",
    DROPSANITY_FLAG_START + 0x63: "Aztec Chunky 5DTemple Enemy: Reward",
    DROPSANITY_FLAG_START + 0x64: "Aztec Llama Temple Enemy: Kong Free Instrument",
    DROPSANITY_FLAG_START + 0x65: "Aztec Llama Temple Enemy: Dino Instrument",
    DROPSANITY_FLAG_START + 0x66: "Aztec Llama Temple Enemy: Matching0",
    DROPSANITY_FLAG_START + 0x67: "Aztec Llama Temple Enemy: Matching1",
    DROPSANITY_FLAG_START + 0x68: "Aztec Llama Temple Enemy: Right",
    DROPSANITY_FLAG_START + 0x69: "Aztec Llama Temple Enemy: Left",
    DROPSANITY_FLAG_START + 0x6A: "Aztec Llama Temple Enemy: Melon Crate",
    DROPSANITY_FLAG_START + 0x6B: "Aztec Llama Temple Enemy: Slam Switch",
    DROPSANITY_FLAG_START + 0x80: "Aztec Tiny Temple Enemy: Guard Rotating (0)",
    DROPSANITY_FLAG_START + 0x81: "Aztec Tiny Temple Enemy: Guard Rotating (1)",
    DROPSANITY_FLAG_START + 0x82: "Aztec Tiny Temple Enemy: Main Room (0)",
    DROPSANITY_FLAG_START + 0x83: "Aztec Tiny Temple Enemy: Main Room (1)",
    DROPSANITY_FLAG_START + 0x84: "Aztec Tiny Temple Enemy: Main Room (2)",
    DROPSANITY_FLAG_START + 0x85: "Aztec Tiny Temple Enemy: Kong Room (0)",
    DROPSANITY_FLAG_START + 0x86: "Aztec Tiny Temple Enemy: Kong Room (1)",
    DROPSANITY_FLAG_START + 0x87: "Aztec Tiny Temple Enemy: Kong Room (2)",
    DROPSANITY_FLAG_START + 0x88: "Aztec Tiny Temple Enemy: Kong Room (3)",
    DROPSANITY_FLAG_START + 0x89: "Aztec Tiny Temple Enemy: Kong Room (4)",
    DROPSANITY_FLAG_START + 0x8B: "Factory Enemy: Candy Cranky (0)",
    DROPSANITY_FLAG_START + 0x8C: "Factory Enemy: Candy Cranky (1)",
    DROPSANITY_FLAG_START + 0x8D: "Factory Enemy: Lobby Left",
    DROPSANITY_FLAG_START + 0x8E: "Factory Enemy: Lobby Right",
    DROPSANITY_FLAG_START + 0x8F: "Factory Enemy: Storage Room",
    DROPSANITY_FLAG_START + 0x90: "Factory Enemy: Block Tower (0)",
    DROPSANITY_FLAG_START + 0x91: "Factory Enemy: Block Tower (1)",
    DROPSANITY_FLAG_START + 0x92: "Factory Enemy: Block Tower (2)",
    DROPSANITY_FLAG_START + 0x93: "Factory Enemy: Tunnel To Hatch",
    DROPSANITY_FLAG_START + 0x94: "Factory Enemy: Tunnel To Prod (0)",
    DROPSANITY_FLAG_START + 0x95: "Factory Enemy: Tunnel To Prod (1)",
    DROPSANITY_FLAG_START + 0x96: "Factory Enemy: Tunnel To Block Tower",
    DROPSANITY_FLAG_START + 0x97: "Factory Enemy: Tunnel To Race (0)",
    DROPSANITY_FLAG_START + 0x98: "Factory Enemy: Tunnel To Race (1)",
    DROPSANITY_FLAG_START + 0x99: "Factory Enemy: Low Warp 4",
    DROPSANITY_FLAG_START + 0x9A: "Factory Enemy: Diddy Switch",
    DROPSANITY_FLAG_START + 0x9B: "Factory Enemy: To Block Tower Tunnel",
    DROPSANITY_FLAG_START + 0x9C: "Factory Enemy: Dark Room (0)",
    DROPSANITY_FLAG_START + 0x9D: "Factory Enemy: Dark Room (1)",
    DROPSANITY_FLAG_START + 0xB0: "Isles Factory Lobby Enemy: Enemy (0)",
    DROPSANITY_FLAG_START + 0xB1: "Galleon Enemy: Chest Room (0)",
    DROPSANITY_FLAG_START + 0xB2: "Galleon Enemy: Chest Room (1)",
    DROPSANITY_FLAG_START + 0xB3: "Galleon Enemy: Near Vine Cannon",
    DROPSANITY_FLAG_START + 0xB4: "Galleon Enemy: Cranky Cannon",
    DROPSANITY_FLAG_START + 0xB8: "Galleon Enemy: Peanut Tunnel",
    DROPSANITY_FLAG_START + 0xB9: "Galleon Enemy: Coconut Tunnel",
    DROPSANITY_FLAG_START + 0xBA: "Galleon Lighthouse Enemy: Enemy (0)",
    DROPSANITY_FLAG_START + 0xBB: "Galleon Lighthouse Enemy: Enemy (1)",
    DROPSANITY_FLAG_START + 0xCA: "Forest Enemy: Hollow Tree (0)",
    DROPSANITY_FLAG_START + 0xCB: "Forest Enemy: Hollow Tree (1)",
    DROPSANITY_FLAG_START + 0xCC: "Forest Enemy: Hollow Tree Entrance",
    DROPSANITY_FLAG_START + 0xCD: "Forest Enemy: Tree Melon Crate (0)",
    DROPSANITY_FLAG_START + 0xCE: "Forest Enemy: Tree Melon Crate (1)",
    DROPSANITY_FLAG_START + 0xCF: "Forest Enemy: Tree Melon Crate (2)",
    DROPSANITY_FLAG_START + 0xD0: "Forest Enemy: Apple Gauntlet (0)",
    DROPSANITY_FLAG_START + 0xD1: "Forest Enemy: Apple Gauntlet (1)",
    DROPSANITY_FLAG_START + 0xD2: "Forest Enemy: Apple Gauntlet (2)",
    DROPSANITY_FLAG_START + 0xD3: "Forest Enemy: Apple Gauntlet (3)",
    DROPSANITY_FLAG_START + 0xD4: "Forest Enemy: Near Beanstalk (0)",
    DROPSANITY_FLAG_START + 0xD5: "Forest Enemy: Near Beanstalk (1)",
    DROPSANITY_FLAG_START + 0xD6: "Forest Enemy: Green Tunnel",
    DROPSANITY_FLAG_START + 0xD7: "Forest Enemy: Near Low Warp 5",
    DROPSANITY_FLAG_START + 0xD8: "Forest Enemy: Near Pink Tunnel Bounce Tag",
    DROPSANITY_FLAG_START + 0xD9: "Forest Enemy: Near Giant Mushroom Rocketbarrel",
    DROPSANITY_FLAG_START + 0xDA: "Forest Enemy: Between Yellow Tunnel And RB",
    DROPSANITY_FLAG_START + 0xDB: "Forest Enemy: Near Cranky",
    DROPSANITY_FLAG_START + 0xDC: "Forest Enemy: Near Pink Tunnel Giant Mushroom",
    DROPSANITY_FLAG_START + 0xDD: "Forest Enemy: Giant Mushroom Rear Tag",
    DROPSANITY_FLAG_START + 0xDE: "Forest Enemy: Near Face Puzzle",
    DROPSANITY_FLAG_START + 0xDF: "Forest Enemy: Near Crown",
    DROPSANITY_FLAG_START + 0xE0: "Forest Enemy: Near High Warp 5",
    DROPSANITY_FLAG_START + 0xE1: "Forest Enemy: Top Of Mushroom",
    DROPSANITY_FLAG_START + 0xE2: "Forest Enemy: Near Apple Dropoff",
    DROPSANITY_FLAG_START + 0xE3: "Forest Enemy: Near DKPortal",
    DROPSANITY_FLAG_START + 0xE4: "Forest Enemy: Near Well Tag",
    DROPSANITY_FLAG_START + 0xE5: "Forest Enemy: Yellow Tunnel (0)",
    DROPSANITY_FLAG_START + 0xE6: "Forest Enemy: Yellow Tunnel (1)",
    DROPSANITY_FLAG_START + 0xE7: "Forest Enemy: Yellow Tunnel (2)",
    DROPSANITY_FLAG_START + 0xE8: "Forest Enemy: Yellow Tunnel (3)",
    DROPSANITY_FLAG_START + 0xE9: "Forest Enemy: Near Snide",
    DROPSANITY_FLAG_START + 0xEA: "Forest Enemy: Near the hidden Rainbow Coin",
    DROPSANITY_FLAG_START + 0xEB: "Forest Enemy: Near BBlast",
    DROPSANITY_FLAG_START + 0xEC: "Forest Enemy: Near Dark Attic",
    DROPSANITY_FLAG_START + 0xED: "Forest Enemy: Near Well Exit",
    DROPSANITY_FLAG_START + 0xEE: "Forest Enemy: Near Blue Tunnel",
    DROPSANITY_FLAG_START + 0xEF: "Forest Enemy: Thornvine (0)",
    DROPSANITY_FLAG_START + 0xF0: "Forest Enemy: Thornvine (1)",
    DROPSANITY_FLAG_START + 0xF1: "Forest Enemy: Thornvine (2)",
    DROPSANITY_FLAG_START + 0xF2: "Forest Enemy: Thornvine Entrance",
    DROPSANITY_FLAG_START + 0xF3: "Forest Anthill Enemy: Gauntlet (0)",
    DROPSANITY_FLAG_START + 0xF4: "Forest Anthill Enemy: Gauntlet (1)",
    DROPSANITY_FLAG_START + 0xF5: "Forest Anthill Enemy: Gauntlet (2)",
    DROPSANITY_FLAG_START + 0xF6: "Forest Anthill Enemy: Gauntlet (3)",
    DROPSANITY_FLAG_START + 0xF7: "Forest Winch Room Enemy: Enemy",
    DROPSANITY_FLAG_START + 0xF8: "Forest Thornvine Barn Enemy: Enemy",
    DROPSANITY_FLAG_START + 0xF9: "Forest Mill Front Enemy: Enemy",
    DROPSANITY_FLAG_START + 0xFA: "Forest Mill Back Enemy: Enemy",
    DROPSANITY_FLAG_START + 0xFB: "Forest Giant Mushroom Enemy: Above Night Door",
    DROPSANITY_FLAG_START + 0xFC: "Forest Giant Mushroom Enemy: Path (0)",
    DROPSANITY_FLAG_START + 0xFD: "Forest Giant Mushroom Enemy: Path (1)",
    DROPSANITY_FLAG_START + 0x101: "Forest Lanky Zingers Room Enemy: Enemy (0)",
    DROPSANITY_FLAG_START + 0x102: "Forest Lanky Zingers Room Enemy: Enemy (1)",
    DROPSANITY_FLAG_START + 0x103: "Forest Chunky Face Room Enemy: Enemy",
    DROPSANITY_FLAG_START + 0x107: "Caves Enemy: Start",
    DROPSANITY_FLAG_START + 0x108: "Caves Enemy: Near Ice Castle",
    DROPSANITY_FLAG_START + 0x109: "Caves Enemy: Outside 5DC",
    DROPSANITY_FLAG_START + 0x10A: "Caves Enemy: 1DC Waterfall",
    DROPSANITY_FLAG_START + 0x10B: "Caves Enemy: Near Funky",
    DROPSANITY_FLAG_START + 0x10C: "Caves Enemy: Near Snide",
    DROPSANITY_FLAG_START + 0x10D: "Caves Enemy: Near Bonus Room",
    DROPSANITY_FLAG_START + 0x10E: "Caves Enemy: 1DC Headphones",
    DROPSANITY_FLAG_START + 0x110: "Caves Donkey Igloo Enemy: Right",
    DROPSANITY_FLAG_START + 0x111: "Caves Donkey Igloo Enemy: Left",
    DROPSANITY_FLAG_START + 0x117: "Caves Tiny Igloo Enemy: Big Enemy",
    DROPSANITY_FLAG_START + 0x11D: "Caves Lanky Cabin Enemy: Near",
    DROPSANITY_FLAG_START + 0x134: "Castle Enemy: Near Bridge (0)",
    DROPSANITY_FLAG_START + 0x135: "Castle Enemy: Near Bridge (1)",
    DROPSANITY_FLAG_START + 0x136: "Castle Enemy: Wooden Extrusion (0)",
    DROPSANITY_FLAG_START + 0x137: "Castle Enemy: Wooden Extrusion (1)",
    DROPSANITY_FLAG_START + 0x138: "Castle Enemy: Near Shed",
    DROPSANITY_FLAG_START + 0x139: "Castle Enemy: Near Library",
    DROPSANITY_FLAG_START + 0x13A: "Castle Enemy: Near Tower",
    DROPSANITY_FLAG_START + 0x13B: "Castle Enemy: Museum Steps",
    DROPSANITY_FLAG_START + 0x13C: "Castle Enemy: Near Low Cave",
    DROPSANITY_FLAG_START + 0x13D: "Castle Enemy: Path To Low Kasplat",
    DROPSANITY_FLAG_START + 0x13E: "Castle Enemy: Low TnS",
    DROPSANITY_FLAG_START + 0x13F: "Castle Enemy: Path To Dungeon",
    DROPSANITY_FLAG_START + 0x140: "Castle Enemy: Near Headphones",
    DROPSANITY_FLAG_START + 0x141: "Isles Castle Lobby Enemy: Left",
    DROPSANITY_FLAG_START + 0x142: "Isles Castle Lobby Enemy: Far Right",
    DROPSANITY_FLAG_START + 0x143: "Isles Castle Lobby Enemy: Near Right",
    DROPSANITY_FLAG_START + 0x149: "Castle Ballroom Enemy: Start",
    DROPSANITY_FLAG_START + 0x14A: "Castle Dungeon Enemy: Face Room",
    DROPSANITY_FLAG_START + 0x14B: "Castle Dungeon Enemy: Chair Room",
    DROPSANITY_FLAG_START + 0x14C: "Castle Dungeon Enemy: Outside Lanky Room",
    DROPSANITY_FLAG_START + 0x152: "Castle Lower Cave Enemy: Near Crypt",
    DROPSANITY_FLAG_START + 0x153: "Castle Lower Cave Enemy: Stair Right",
    DROPSANITY_FLAG_START + 0x154: "Castle Lower Cave Enemy: Stair Left",
    DROPSANITY_FLAG_START + 0x155: "Castle Lower Cave Enemy: Near Mausoleum",
    DROPSANITY_FLAG_START + 0x156: "Castle Lower Cave Enemy: Near Funky",
    DROPSANITY_FLAG_START + 0x157: "Castle Lower Cave Enemy: Near Tag",
    DROPSANITY_FLAG_START + 0x158: "Castle Crypt Enemy: Diddy Coffin (0)",
    DROPSANITY_FLAG_START + 0x159: "Castle Crypt Enemy: Diddy Coffin (1)",
    DROPSANITY_FLAG_START + 0x15A: "Castle Crypt Enemy: Diddy Coffin (2)",
    DROPSANITY_FLAG_START + 0x15B: "Castle Crypt Enemy: Diddy Coffin (3)",
    DROPSANITY_FLAG_START + 0x15C: "Castle Crypt Enemy: Chunky Coffin (0)",
    DROPSANITY_FLAG_START + 0x15D: "Castle Crypt Enemy: Chunky Coffin (1)",
    DROPSANITY_FLAG_START + 0x15E: "Castle Crypt Enemy: Chunky Coffin (2)",
    DROPSANITY_FLAG_START + 0x15F: "Castle Crypt Enemy: Chunky Coffin (3)",
    DROPSANITY_FLAG_START + 0x160: "Castle Crypt Enemy: Minecart Entry",
    DROPSANITY_FLAG_START + 0x161: "Castle Crypt Enemy: Fork",
    DROPSANITY_FLAG_START + 0x162: "Castle Crypt Enemy: Near Diddy",
    DROPSANITY_FLAG_START + 0x163: "Castle Crypt Enemy: Near Chunky",
    DROPSANITY_FLAG_START + 0x164: "Castle Mausoleum Enemy: Tiny Path",
    DROPSANITY_FLAG_START + 0x165: "Castle Mausoleum Enemy: Lanky Path (0)",
    DROPSANITY_FLAG_START + 0x166: "Castle Mausoleum Enemy: Lanky Path (1)",
    DROPSANITY_FLAG_START + 0x167: "Castle Upper Cave Enemy: Near Dungeon",
    DROPSANITY_FLAG_START + 0x169: "Castle Upper Cave Enemy: Near Pit",
    DROPSANITY_FLAG_START + 0x16A: "Castle Upper Cave Enemy: Near Entrance",
    DROPSANITY_FLAG_START + 0x17A: "Castle Library Enemy: Fork Left (0)",
    DROPSANITY_FLAG_START + 0x17B: "Castle Library Enemy: Fork Left (1)",
    DROPSANITY_FLAG_START + 0x17C: "Castle Library Enemy: Fork Center",
    DROPSANITY_FLAG_START + 0x17D: "Castle Library Enemy: Fork Right",
    DROPSANITY_FLAG_START + 0x17E: "Castle Museum Enemy: Main Floor (0)",
    DROPSANITY_FLAG_START + 0x17F: "Castle Museum Enemy: Main Floor (1)",
    DROPSANITY_FLAG_START + 0x180: "Castle Museum Enemy: Main Floor (2)",
    DROPSANITY_FLAG_START + 0x181: "Castle Museum Enemy: Main Floor (3)",
    DROPSANITY_FLAG_START + 0x182: "Castle Museum Enemy: Start",
    DROPSANITY_FLAG_START + 0x18D: "Castle Tree Enemy: Start Room (0)",
    DROPSANITY_FLAG_START + 0x18E: "Castle Tree Enemy: Start Room (1)",
    DROPSANITY_FLAG_START + 0x18F: "Helm Enemy: Start (0)",
    DROPSANITY_FLAG_START + 0x190: "Helm Enemy: Start (1)",
    DROPSANITY_FLAG_START + 0x191: "Helm Enemy: Hill",
    DROPSANITY_FLAG_START + 0x192: "Helm Enemy: Switch Room (0)",
    DROPSANITY_FLAG_START + 0x193: "Helm Enemy: Switch Room (1)",
    DROPSANITY_FLAG_START + 0x194: "Helm Enemy: Mini Room (0)",
    DROPSANITY_FLAG_START + 0x195: "Helm Enemy: Mini Room (1)",
    DROPSANITY_FLAG_START + 0x196: "Helm Enemy: Mini Room (2)",
    DROPSANITY_FLAG_START + 0x197: "Helm Enemy: Mini Room (3)",
    DROPSANITY_FLAG_START + 0x198: "Helm Enemy: DKRoom",
    DROPSANITY_FLAG_START + 0x199: "Helm Enemy: Chunky Room (0)",
    DROPSANITY_FLAG_START + 0x19A: "Helm Enemy: Chunky Room (1)",
    DROPSANITY_FLAG_START + 0x19B: "Helm Enemy: Tiny Room",
    DROPSANITY_FLAG_START + 0x19C: "Helm Enemy: Lanky Room (0)",
    DROPSANITY_FLAG_START + 0x19D: "Helm Enemy: Lanky Room (1)",
    DROPSANITY_FLAG_START + 0x19E: "Helm Enemy: Diddy Room (0)",
    DROPSANITY_FLAG_START + 0x19F: "Helm Enemy: Diddy Room (1)",
    DROPSANITY_FLAG_START + 0x1A0: "Helm Enemy: Nav Right",
    DROPSANITY_FLAG_START + 0x1A1: "Helm Enemy: Nav Left",
    DROPSANITY_FLAG_START + 0x1A2: "Isles Enemy: Pineapple Cage (0)",
    DROPSANITY_FLAG_START + 0x1A3: "Isles Enemy: Fungi Cannon (0)",
    DROPSANITY_FLAG_START + 0x1A4: "Isles Enemy: Japes Entrance",
    DROPSANITY_FLAG_START + 0x1A5: "Isles Enemy: Monkeyport Pad",
    DROPSANITY_FLAG_START + 0x1A6: "Isles Enemy: Upper Factory Path",
    DROPSANITY_FLAG_START + 0x1A7: "Isles Enemy: Near Aztec",
    DROPSANITY_FLAG_START + 0x1A8: "Isles Enemy: Fungi Cannon (1)",
    DROPSANITY_FLAG_START + 0x1A9: "Isles Enemy: Pineapple Cage (1)",
    DROPSANITY_FLAG_START + 0x1AA: "Isles Enemy: Lower Factory Path (0)",
    DROPSANITY_FLAG_START + 0x1AB: "Isles Enemy: Lower Factory Path (1)",
    900: "Japes Donkey Hint Door",
    901: "Japes Diddy Hint Door",
    902: "Japes Lanky Hint Door",
    903: "Japes Tiny Hint Door",
    904: "Japes Chunky Hint Door",
    905: "Aztec Donkey Hint Door",
    906: "Aztec Diddy Hint Door",
    907: "Aztec Lanky Hint Door",
    908: "Aztec Tiny Hint Door",
    909: "Aztec Chunky Hint Door",
    910: "Factory Donkey Hint Door",
    911: "Factory Diddy Hint Door",
    912: "Factory Lanky Hint Door",
    913: "Factory Tiny Hint Door",
    914: "Factory Chunky Hint Door",
    915: "Galleon Donkey Hint Door",
    916: "Galleon Diddy Hint Door",
    917: "Galleon Lanky Hint Door",
    918: "Galleon Tiny Hint Door",
    919: "Galleon Chunky Hint Door",
    920: "Forest Donkey Hint Door",
    921: "Forest Diddy Hint Door",
    922: "Forest Lanky Hint Door",
    923: "Forest Tiny Hint Door",
    924: "Forest Chunky Hint Door",
    925: "Caves Donkey Hint Door",
    926: "Caves Diddy Hint Door",
    927: "Caves Lanky Hint Door",
    928: "Caves Tiny Hint Door",
    929: "Caves Chunky Hint Door",
    930: "Castle Donkey Hint Door",
    931: "Castle Diddy Hint Door",
    932: "Castle Lanky Hint Door",
    933: "Castle Tiny Hint Door",
    934: "Castle Chunky Hint Door",
    1022: "Turning In 1 Blueprint",
    1023: "Turning In 2 Blueprints",
    1024: "Turning In 3 Blueprints",
    1025: "Turning In 4 Blueprints",
    1026: "Turning In 5 Blueprints",
    1027: "Turning In 6 Blueprints",
    1028: "Turning In 7 Blueprints",
    1029: "Turning In 8 Blueprints",
    1030: "Turning In 9 Blueprints",
    1031: "Turning In 10 Blueprints",
    1032: "Turning In 11 Blueprints",
    1033: "Turning In 12 Blueprints",
    1034: "Turning In 13 Blueprints",
    1035: "Turning In 14 Blueprints",
    1036: "Turning In 15 Blueprints",
    1037: "Turning In 16 Blueprints",
    1038: "Turning In 17 Blueprints",
    1039: "Turning In 18 Blueprints",
    1040: "Turning In 19 Blueprints",
    1041: "Turning In 20 Blueprints",
    1042: "Turning In 21 Blueprints",
    1043: "Turning In 22 Blueprints",
    1044: "Turning In 23 Blueprints",
    1045: "Turning In 24 Blueprints",
    1046: "Turning In 25 Blueprints",
    1047: "Turning In 26 Blueprints",
    1048: "Turning In 27 Blueprints",
    1049: "Turning In 28 Blueprints",
    1050: "Turning In 29 Blueprints",
    1051: "Turning In 30 Blueprints",
    1052: "Turning In 31 Blueprints",
    1053: "Turning In 32 Blueprints",
    1054: "Turning In 33 Blueprints",
    1055: "Turning In 34 Blueprints",
    1056: "Turning In 35 Blueprints",
    1057: "Turning In 36 Blueprints",
    1058: "Turning In 37 Blueprints",
    1059: "Turning In 38 Blueprints",
    1060: "Turning In 39 Blueprints",
    1061: "Turning In 40 Blueprints",
}

location_name_to_flag = {v: k for k, v in location_flag_to_name.items()}
