"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Events import Events
from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.GloomyGalleon,
        name="Entrance (5 custom, 5 Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 2118, 1616, 2728],
            [1, 1.0, 2112, 1611, 2858],
            [1, 1.0, 2116, 1611, 3036],
            [1, 1.0, 2158, 1611, 3167],
            [1, 1.0, 2272, 1611, 3225],
            [1, 1.0, 2118.467529296875, 1611.78857421875, 2974.53125],
            [1, 1.0, 2128.10400390625, 1610.0740966796875, 3123.285400390625],
            [1, 1.0, 2211.945556640625, 1610.3818359375, 3216.2353515625],
            [1, 1.0, 2335.08251953125, 1610.06591796875, 3232.972412109375],
            [1, 1.0, 2466.710205078125, 1610.75927734375, 3227.426025390625],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to cannon game room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,  # Some of them are in GloomyGalleonStart
        locations=[
            [1, 1.0, 2048, 1611, 2981],
            [1, 1.0, 1941, 1589, 2980],
            [1, 1.0, 1805, 1555, 2979],
            [1, 1.0, 1580, 1513, 2978],
            [1, 1.0, 1466, 1500, 2977],
        ],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.GloomyGalleon,
        name="Tunnels to Lighthouse and 5DS area (6 custom, 9 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 2238, 1611, 3470],
            [1, 1.0, 2404, 1611, 3514],
            [1, 1.0, 2538, 1611, 3317],
            [1, 1.0, 2410, 1611, 2856],
            [1, 1.0, 2508, 1611, 3001],
            [1, 1.0, 2535, 1611, 3163],
            [1, 1.0, 2380.290771484375, 1612.3818359375, 2629.027587890625],
            [1, 1.0, 2384.823486328125, 1610.5078125, 2764.619384765625],
            [1, 1.0, 2471.539306640625, 1611.3758544921875, 2922.3173828125],
            [1, 1.0, 2529.58203125, 1610.7115478515625, 3080.453369140625],
            [1, 1.0, 2545.250732421875, 1610.46875, 3402.308349609375],
            [1, 1.0, 2506.486572265625, 1611.4774169921875, 3507.504150390625],
            [1, 1.0, 2305.64404296875, 1610.1602783203125, 3491.7744140625],
            [1, 1.0, 2166.028076171875, 1610.4735107421875, 3468.050537109375],
            [1, 1.0, 2052.783203125, 1615.63916015625, 3529.741943359375],
        ],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.GloomyGalleon,
        name="To Cranky area (3 custom, 2 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 2597, 1611, 3225],
            [1, 1.0, 2730, 1639, 3231],
            [1, 1.0, 2911, 1683, 3223],
            [1, 1.0, 2782.384765625, 1656.5252685546875, 3231.776123046875],
            [1, 1.0, 2661.07373046875, 1620.4764404296875, 3228.8369140625],
        ],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to Chests room (5 custom, 5 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3070, 1670, 3411],
            [1, 1.0, 3075, 1670, 3572],
            [1, 1.0, 3110, 1670, 3730],
            [1, 1.0, 3252, 1670, 3794],
            [1, 1.0, 3431, 1670, 3805],
            [1, 1.0, 3073.390380859375, 1670.0, 3323.15234375],
            [1, 1.0, 3073.8798828125, 1670.0, 3497.5068359375],
            [1, 1.0, 3083.624755859375, 1667.8056640625, 3667.054443359375],
            [1, 1.0, 3166.656005859375, 1670.0, 3780.068359375],
            [1, 1.0, 3344.751953125, 1670.0, 3800.844970703125],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.GloomyGalleon,
        name="Around Chunky chest room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3366, 1670, 3690],
            [1, 1.0, 3427, 1670, 3618],
            [1, 1.0, 3524, 1670, 3620],
            [1, 1.0, 3606, 1670, 3622],
            [1, 1.0, 3698, 1670, 3709],
            [1, 1.0, 3698, 1670, 3894],
            [1, 1.0, 3602, 1670, 3988],
            [1, 1.0, 3510, 1670, 3986],
            [1, 1.0, 3420, 1670, 3984],
            [1, 1.0, 3346, 1670, 3893],
        ],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.GloomyGalleon,
        name="Inside middle chest with headphones",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        logic=lambda l: l.punch,
        locations=[[5, 1.0, 3668, 1675, 3808]],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.GloomyGalleon,
        name="Inside left chest with Fairy",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        logic=lambda l: l.punch,
        locations=[[5, 1.0, 3548, 1675, 3695]],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.GloomyGalleon,
        name="In alcove to chest room by Chunky coins",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 3066, 1675, 3841], [5, 1.0, 3024, 1675, 3812]],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.GloomyGalleon,
        name="On left side of ship to chests room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3170, 1671, 3320],
            [1, 1.0, 3170, 1670, 3365],
            [1, 1.0, 3170, 1670, 3410],
            [1, 1.0, 3170, 1670, 3455],
            [1, 1.0, 3170, 1670, 3500],
        ],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.GloomyGalleon,
        name="On each side of Cranky's Lab ship at the bottom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 3189, 1680, 2439], [5, 1.0, 3405, 1680, 2386]],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.GloomyGalleon,
        name="On wooden box (5DS side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 2348, 1640, 2473], [5, 1.0, 2426, 1640, 2473]],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.GloomyGalleon,
        name="Around battle arena pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        logic=lambda l: l.punch or l.CanPhase(),
        locations=[[1, 1.0, 3384, 1670, 2459], [1, 1.0, 3343, 1670, 2350], [1, 1.0, 3228, 1670, 2383], [1, 1.0, 3247, 1670, 2502], [1, 1.0, 3329, 1670, 2546]],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.GloomyGalleon,
        name="Back wall of Cranky area at the bottom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3243, 1684, 3517],
            [1, 1.0, 3290, 1674, 3427],
            [1, 1.0, 3316, 1687, 3356],
            [1, 1.0, 3320, 1674, 3263],
            [1, 1.0, 3329, 1689, 3168],
            [1, 1.0, 3392, 1670, 3109],
            [1, 1.0, 3429, 1688, 3031],
            [1, 1.0, 3430, 1676, 2937],
            [1, 1.0, 3444, 1672, 2852],
            [1, 1.0, 3464, 1689, 2783],
            [1, 1.0, 3482, 1686, 2718],
            [1, 1.0, 3495, 1670, 2633],
            [1, 1.0, 3497, 1670, 2553],
            [1, 1.0, 3500, 1670, 2478],
            [1, 1.0, 3448, 1670, 2418],
        ],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.GloomyGalleon,
        name="Between the two cannons in Cranky room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3116, 1676, 3061],
            [1, 1.0, 3199, 1670, 3020],
            [1, 1.0, 3257, 1670, 2950],
            [1, 1.0, 3331, 1670, 2871],
            [1, 1.0, 3339, 1671, 2781],
        ],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.GloomyGalleon,
        name="Cranky room inside wall",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3133, 1670, 2541],
            [1, 1.0, 3200, 1685, 2658],
            [1, 1.0, 3212, 1672, 2742],
            [1, 1.0, 3214, 1688, 2828],
            [1, 1.0, 3103, 1674, 2827],
            [1, 1.0, 3005, 1688, 2827],
            [1, 1.0, 2914, 1678, 2851],
            [1, 1.0, 2852, 1689, 2923],
            [1, 1.0, 2820, 1670, 3021],
            [1, 1.0, 2828, 1672, 3121],
        ],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.GloomyGalleon,
        name="Stack of boxes by W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 2942, 1690, 3433],
            [1, 1.0, 2980, 1690, 3381],
            [1, 1.0, 2980, 1690, 3495],
            [1, 1.0, 2980, 1740, 3474],
            [1, 1.0, 2980, 1740, 3408],
        ],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.GloomyGalleon,
        name="On ship to chests room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 3102, 1795, 3357], [5, 1.0, 3046, 1795, 3347]],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.GloomyGalleon,
        name="To Tiny BP (2 custom, 3 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonPastVines,
        locations=[
            [1, 1.0, 2997, 1890, 2933],
            [1, 1.0, 3033, 1890, 2924],
            [1, 1.0, 2854.8994140625, 1898.0, 2999.631103515625],
            [1, 1.0, 2904.9384765625, 1893.0, 2975.348876953125],
            [1, 1.0, 2950.147705078125, 1898.0, 2943.14453125],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.GloomyGalleon,
        name="Cranky's Room to T&S (2 custom, 3 Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonPastVines,
        locations=[
            [1, 1.0, 3106, 1890, 2934],
            [1, 1.0, 3143, 1890, 2940],
            [1, 1.0, 3198.1337890625, 1898.0, 2966.6611328125],
            [1, 1.0, 3293.109375, 1893.0, 2987.6875],
            [1, 1.0, 3375.562744140625, 1898.0, 3018.9609375],
        ],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.GloomyGalleon,
        name="Cannon GB room boulder side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        locations=[[5, 1.0, 1400, 1615, 2588], [5, 1.0, 1250, 1615, 2588]],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.GloomyGalleon,
        name="Cannon GB room cannon side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        locations=[[5, 1.0, 1370, 1615, 3024], [5, 1.0, 1315, 1615, 3072], [5, 1.0, 1260, 1615, 3024]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.GloomyGalleon,
        name="Cannon game room underwater",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: l.swim,
        locations=[[5, 1.2, 1245, 1530, 3289], [5, 1.2, 1360, 1495, 2561]],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.GloomyGalleon,
        name="On top of stalactite near 2DS",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 1463, 1210, 2041]],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.GloomyGalleon,
        name="Under ship tunnel by 5DS (with oranges)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 2274, 650, 2405], [5, 1.2, 2317, 650, 2400], [5, 1.2, 2380, 650, 2395]],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.GloomyGalleon,
        name="In chest by 5DS (Chunky OoB coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        logic=lambda l: Events.ShipyardEnguarde in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.2, 2769, 643, 2282]],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.GloomyGalleon,
        name="In chest by 5DS (Lanky coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        logic=lambda l: Events.ShipyardEnguarde in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.2, 3018, 584, 1582]],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.GloomyGalleon,
        name="Chest around 5DS (DK coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        logic=lambda l: Events.ShipyardEnguarde in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.2, 2439, 622, 1596]],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.GloomyGalleon,
        name="Chest around 5DS (Tiny coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        logic=lambda l: Events.ShipyardEnguarde in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.2, 1982, 662, 2247]],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.GloomyGalleon,
        name="Chest near mech fish (Diddy coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        logic=lambda l: Events.ShipyardEnguarde in l.Events or l.CanPhaseswim(),
        locations=[[5, 1.2, 3023, 116, 751]],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.GloomyGalleon,
        name="From 5DS to Mech fish on sea floor",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.2, 2964, 140, 904],
            [1, 1.2, 2933, 246, 1014],
            [1, 1.2, 2902, 351, 1125],
            [1, 1.2, 2871, 457, 1235],
            [1, 1.2, 2840, 562, 1345],
        ],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.GloomyGalleon,
        name="From 5DS to 2DS on sea floor",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.2, 1530, 950, 2039],
            [1, 1.2, 1609, 886, 2052],
            [1, 1.2, 1688, 823, 2064],
            [1, 1.2, 1767, 759, 2077],
            [1, 1.2, 1846, 695, 2089],
        ],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.GloomyGalleon,
        name="On underwater mast of 2DS",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 1387, 1095, 1956]],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to gold tower room (4 custom, 6 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.2, 2066, 1389, 1507],
            [1, 1.2, 1696, 1414, 1192],
            [1, 1.2, 1669, 1404, 1060],
            [1, 1.2, 1900, 1404, 1288],
            [1, 1.0, 1652.220703125, 1411.52587890625, 1132.323486328125],
            [1, 1.0, 1698.8853759765625, 1411.91015625, 992.362548828125],
            [1, 1.0, 2016.5594482421875, 1387.5380859375, 1437.3363037109375],
            [1, 1.0, 1945.29052734375, 1407.6614990234375, 1337.1527099609375],
            [1, 1.0, 1842.0916748046875, 1404.0252685546875, 1257.164306640625],
            [1, 1.0, 1748.5238037109375, 1414.1339111328125, 1227.4063720703125],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.GloomyGalleon,
        name="Seafloor around Lanky gold tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        locations=[[5, 1.2, 1568, 1460, 649], [5, 1.2, 1696, 1462, 460]],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.GloomyGalleon,
        name="4 corners of gold tower room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        locations=[
            [5, 1.2, 1723, 1470, 289],
            [5, 1.2, 2271, 1470, 568],
            [5, 1.2, 2036, 1468, 1018],
            [5, 1.2, 1510, 1468, 709],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.GloomyGalleon,
        name="On Lanky Gold Tower (5 custom, 5 Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.TreasureRoom,
        logic=lambda l: l.balloon and ((Events.WaterRaised in l.Events) or (Events.ShipyardEnguarde in l.Events and l.monkey_maneuvers)),
        locations=[
            [1, 1.0, 1620, 2000, 566],
            [1, 1.0, 1642, 1980, 529],
            [1, 1.0, 1616, 2040, 490],
            [1, 1.0, 1596, 2060, 529],
            [1, 1.0, 1688, 1755, 599],
            [1, 1.0, 1714.4791259765625, 1735.0, 638.5502319335938],
            [1, 1.0, 1705.23828125, 1815.0, 561.5382690429688],
            [1, 1.0, 1665.20458984375, 1955.0, 562.423828125],
            [1, 1.0, 1662.1121826171875, 2045.0, 493.0118408203125],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.GloomyGalleon,
        name="On Lanky Gold Tower (5 custom, 5 Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.TreasureRoom,
        logic=lambda l: l.balloon and ((Events.WaterRaised in l.Events) or (Events.ShipyardEnguarde in l.Events and l.monkey_maneuvers)),
        locations=[[1, 1.0, 1756.18212890625, 1620.0, 635.8522338867188]],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.GloomyGalleon,
        name="On Diddy gold tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoomDiddyGoldTower,
        locations=[[5, 1.0, 1993, 1715, 773], [5, 1.0, 2061, 1795, 807], [5, 1.0, 2105, 1885, 805]],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.GloomyGalleon,
        name="W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 2763, 1625, 1432]],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.GloomyGalleon,
        name="W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoomDiddyGoldTower,
        locations=[[5, 1.0, 2168, 1895, 764]],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.GloomyGalleon,
        name="On wooden box (lighthouse side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        locations=[[5, 1.0, 1929, 1640, 3566], [5, 1.0, 1998, 1640, 3628]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.GloomyGalleon,
        name="Around Candy's Store",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[
            [5, 1.0, 2736, 1635, 680],
            [5, 1.0, 2736, 1635, 428],
            [5, 1.0, 2908, 1635, 428],
            [5, 1.0, 2908, 1635, 680],
        ],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.GloomyGalleon,
        name="By Seal race",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 3298, 1625, 125], [5, 1.0, 3392, 1625, 180]],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.GloomyGalleon,
        name="On ship part by Candy's store",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        logic=lambda l: Events.WaterRaised in l.Events,
        locations=[[5, 1.0, 3166, 1630, 666], [5, 1.0, 3219, 1630, 615]],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.GloomyGalleon,
        name="By submarine entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 3931, 405, 1238]],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.GloomyGalleon,
        name="On seafloor from 5DS to submarine area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.2, 3712, 148, 1688],
            [1, 1.2, 3694, 180, 1744],
            [1, 1.2, 3676, 212, 1800],
            [1, 1.2, 3658, 244, 1856],
            [1, 1.2, 3640, 276, 1912],
            [1, 1.2, 3586, 311, 1939],
            [1, 1.2, 3532, 348, 1966],
            [1, 1.2, 3478, 384, 1992],
            [1, 1.2, 3356, 448, 1952],
            [1, 1.2, 3234, 512, 1912],
        ],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.GloomyGalleon,
        name="On floating plank with 4 DK coins",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 3604, 1620, 1883], [5, 1.0, 3555, 1620, 1933]],
        logic=lambda l: Events.WaterRaised in l.Events,
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.GloomyGalleon,
        name="Plank in front of Funky (Melon crate)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 3930, 1620, 1486], [5, 1.0, 3867, 1620, 1325]],
        logic=lambda l: Events.WaterRaised in l.Events,
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.GloomyGalleon,
        name="On stalactite between 5DS and mech fish",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 2808, 845, 1470]],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.GloomyGalleon,
        name="Around Funky's store",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[
            [5, 1.0, 3602, 1630, 1313],
            [5, 1.0, 3700, 1630, 1359],
            [5, 1.0, 3769, 1630, 1173],
            [5, 1.0, 3664, 1630, 1125],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.GloomyGalleon,
        name="Cactus on guitar pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 4373, 1560, 1108]],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.GloomyGalleon,
        name="Cactus on bongo pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 4294, 1614, 1030]],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.GloomyGalleon,
        name="Cactus on saxophone pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 4461, 1614, 1027]],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.GloomyGalleon,
        name="Cactus on top",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 4381, 1655, 1031]],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.GloomyGalleon,
        name="Cactus on top between coins",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[
            [1, 1.0, 4409, 1650, 1046],
            [1, 1.0, 4404, 1650, 1003],
            [1, 1.0, 4365, 1650, 999],
            [1, 1.0, 4345, 1650, 1036],
            [1, 1.0, 4370, 1650, 1064],
        ],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.GloomyGalleon,
        name="Bottom around cactus",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.2, 4406, 1295, 1226],
            [1, 1.2, 4461, 1295, 1179],
            [1, 1.2, 4516, 1295, 1132],
            [1, 1.2, 4571, 1295, 1084],
            [1, 1.2, 4626, 1295, 1037],
            [1, 1.2, 4588, 1295, 994],
            [1, 1.2, 4550, 1295, 951],
            [1, 1.2, 4512, 1295, 908],
            [1, 1.2, 4474, 1295, 865],
            [1, 1.2, 4436, 1295, 822],
            [1, 1.2, 4398, 1295, 778],
            [1, 1.2, 4346, 1295, 821],
            [1, 1.2, 4294, 1295, 863],
            [1, 1.2, 4243, 1295, 906],
            [1, 1.2, 4181, 1295, 948],
        ],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.GloomyGalleon,
        name="Bottom on stalactites around submarine",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [5, 1.2, 4129, 280, 1595],
            [5, 1.2, 4089, 390, 1290],
            [5, 1.2, 3851, 295, 1113],
            [5, 1.2, 3671, 270, 1269],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.GloomyGalleon,
        name="In corner behind cactus above the water surface",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        logic=lambda l: Events.WaterRaised in l.Events,
        locations=[[5, 1.0, 4389, 1600, 778], [5, 1.0, 4605, 1600, 1038]],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.GloomyGalleon,
        name="Alcove behind Enguarde plank",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseEnguardeDoor,
        locations=[
            [5, 1.2, 881, 1465, 4900],
            [5, 1.2, 777, 1465, 4966],
            [5, 1.2, 643, 1465, 4788],
            [5, 1.2, 754, 1465, 4695],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.GloomyGalleon,
        name="Around tag barrel near enguarde box (Lighthouse area)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [1, 1.2, 1708, 937, 3808],
            [1, 1.2, 1769, 942, 3788],
            [1, 1.2, 1765, 942, 3706],
            [1, 1.2, 1686, 942, 3706],
            [1, 1.2, 1669, 942, 3761],
        ],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.GloomyGalleon,
        name="Bottom of water around chest between tag barrel and mermaid area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [1, 1.2, 775, 581, 4027],
            [1, 1.2, 777, 581, 3920],
            [1, 1.2, 787, 595, 3824],
            [1, 1.2, 823, 626, 3694],
            [1, 1.2, 916, 651, 3507],
            [1, 1.2, 997, 635, 3441],
            [1, 1.2, 1108, 591, 3384],
            [1, 1.2, 1179, 598, 3375],
            [1, 1.2, 1283, 615, 3367],
            [1, 1.2, 1405, 640, 3375],
            [1, 1.2, 1402, 654, 3459],
            [1, 1.2, 1400, 668, 3536],
            [1, 1.2, 1434, 686, 3637],
            [1, 1.2, 1494, 689, 3728],
            [1, 1.2, 1555, 691, 3798],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.GloomyGalleon,
        name="Bottom of water near mermaid on seashells (Right)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 790, 148, 4175], [5, 1.2, 893, 148, 4161]],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.GloomyGalleon,
        name="Bottom of water near mermaid on seashells (Center)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 1042, 148, 4196], [5, 1.2, 1136, 148, 4303], [5, 1.2, 1184, 148, 4444]],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.GloomyGalleon,
        name="Bottom of water near mermaid on seashells (Left)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 1154, 148, 4574], [5, 1.2, 1058, 148, 4631]],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.GloomyGalleon,
        name="Bottom on each side of mermaid entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 866, 108, 4549], [5, 1.2, 761, 108, 4404]],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.GloomyGalleon,
        name="Mermaid area top of pillars on each side",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 889, 420, 4618], [5, 1.2, 714, 420, 4361]],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.GloomyGalleon,
        name="Mermaid area just under tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 910, 338, 3939]],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.GloomyGalleon,
        name="Bunches leading down to bottom T&S",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 1873, 110, 4492],
            [5, 1.2, 1873, 250, 4492],
            [5, 1.2, 1873, 390, 4492],
            [5, 1.2, 1873, 530, 4492],
        ],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.GloomyGalleon,
        name="Bottom of Lighthouse area around T&S portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [1, 1.2, 1918, 102, 4574],
            [1, 1.2, 1846, 102, 4611],
            [1, 1.2, 1772, 102, 4590],
            [1, 1.2, 1750, 102, 4522],
            [1, 1.2, 1800, 102, 4441],
            [1, 1.2, 1878, 102, 4390],
            [1, 1.2, 1950, 102, 4411],
            [1, 1.2, 1938, 102, 4467],
            [1, 1.2, 1835, 102, 4545],
            [1, 1.2, 1852, 102, 4455],
        ],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.GloomyGalleon,
        name="Around hole leading to bottom T&S",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [1, 1.2, 1828, 585, 4389],
            [1, 1.2, 1752, 583, 4463],
            [1, 1.2, 1713, 585, 4561],
            [1, 1.2, 1797, 585, 4646],
            [1, 1.2, 1888, 585, 4620],
            [1, 1.2, 1966, 590, 4566],
            [1, 1.2, 1998, 590, 4465],
            [1, 1.2, 1982, 584, 4421],
            [1, 1.2, 1938, 584, 4368],
            [1, 1.2, 1895, 584, 4356],
        ],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.GloomyGalleon,
        name="In front of water lowering switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 1465, 1390, 4155]],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.GloomyGalleon,
        name="In front of water raising switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[[5, 1.2, 1581, 1390, 3958]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.GloomyGalleon,
        name="W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[[5, 1.0, 1519, 1615, 4221]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.GloomyGalleon,
        name="W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 2844, 1692, 3236]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.GloomyGalleon,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[[5, 1.0, 1395, 1630, 3970]],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.GloomyGalleon,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        locations=[[5, 1.0, 3175, 1625, 1846]],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.GloomyGalleon,
        name="Lighthouse switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[[5, 1.0, 1520, 1620, 3890]],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.GloomyGalleon,
        name="Baboon Blast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[[5, 1.0, 1697, 1670, 4048]],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.GloomyGalleon,
        name="Around lighthouse",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[
            [1, 1.0, 1464, 1610, 4209],
            [1, 1.0, 1416, 1610, 4185],
            [1, 1.0, 1374, 1610, 4107],
            [1, 1.0, 1382, 1610, 4018],
            [1, 1.0, 1455, 1610, 3924],
            [1, 1.0, 1573, 1610, 3917],
            [1, 1.0, 1638, 1610, 3965],
            [1, 1.0, 1656, 1610, 4061],
            [1, 1.0, 1636, 1610, 4160],
            [1, 1.0, 1582, 1610, 4198],
        ],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.GloomyGalleon,
        name="On triangle pad by Diddy's BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        locations=[[5, 1.0, 632, 1575, 4037]],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.GloomyGalleon,
        name="On seal cage",
        konglist=[Kongs.diddy],
        region=Regions.LighthousePlatform,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 2212, 1842, 4055], [5, 1.0, 2192, 1842, 4122]],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.GloomyGalleon,
        name="Guitar pad on top of lighthouse",
        konglist=[Kongs.diddy],
        region=Regions.LighthousePlatform,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1520, 2260, 4059]],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.GloomyGalleon,
        name="Up the ladder into the lighthouse",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        locations=[
            [1, 1.0, 1524, 1625, 3940],
            [1, 1.0, 1524, 1655, 3946],
            [1, 1.0, 1524, 1685, 3952],
            [1, 1.0, 1524, 1715, 3959],
            [1, 1.0, 1524, 1745, 3966],
        ],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.GloomyGalleon,
        name="Around Diddy BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        locations=[
            [1, 1.0, 750, 1574, 4207],
            [1, 1.0, 697, 1574, 4203],
            [1, 1.0, 644, 1574, 4199],
            [1, 1.0, 591, 1574, 4195],
            [1, 1.0, 561, 1574, 4101],
            [1, 1.0, 544, 1574, 4048],
            [1, 1.0, 558, 1574, 3989],
            [1, 1.0, 585, 1574, 3897],
            [1, 1.0, 641, 1574, 3890],
            [1, 1.0, 697, 1574, 3883],
            [1, 1.0, 753, 1574, 3876],
            [1, 1.0, 752, 1574, 3942],
            [1, 1.0, 752, 1574, 4008],
            [1, 1.0, 751, 1574, 4074],
            [1, 1.0, 751, 1574, 4140],
        ],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.GalleonSickBay,
        name="Each side of cannon",
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        locations=[[5, 1.0, 706, 25, 129], [5, 1.0, 545, 25, 129]],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.GalleonLighthouse,
        name="Ladder at the bottom",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        locations=[
            [1, 1.0, 450, 16, 287],
            [1, 1.0, 450, 59, 288],
            [1, 1.0, 450, 103, 289],
            [1, 1.0, 450, 146, 290],
            [1, 1.0, 450, 190, 291],
        ],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.GalleonLighthouse,
        name="Around first floor platforms",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        locations=[
            [1, 1.0, 332, 200, 352],
            [1, 1.0, 303, 200, 425],
            [1, 1.0, 303, 200, 508],
            [1, 1.0, 330, 200, 579],
            [1, 1.0, 402, 200, 612],
            [1, 1.0, 483, 200, 612],
            [1, 1.0, 568, 200, 582],
            [1, 1.0, 597, 200, 515],
            [1, 1.0, 597, 200, 412],
            [1, 1.0, 568, 200, 350],
        ],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.GalleonLighthouse,
        name="Around the top of the lighthouse",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        locations=[
            [1, 1.0, 428, 720, 414],
            [1, 1.0, 400, 720, 461],
            [1, 1.0, 428, 720, 511],
            [1, 1.0, 474, 720, 514],
            [1, 1.0, 502, 720, 471],
        ],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.GalleonLighthouse,
        name="Around the bottom of the lighthouse",
        konglist=[Kongs.donkey],
        region=Regions.Lighthouse,
        locations=[
            [1, 1.0, 379, 0, 221],
            [1, 1.0, 286, 0, 269],
            [1, 1.0, 202, 0, 441],
            [1, 1.0, 215, 0, 358],
            [1, 1.0, 206, 0, 508],
            [1, 1.0, 224, 0, 609],
            [1, 1.0, 324, 0, 692],
            [1, 1.0, 547, 5, 716],
            [1, 1.0, 576, 0, 701],
            [1, 1.0, 658, 0, 625],
            [1, 1.0, 704, 0, 527],
            [1, 1.0, 698, 0, 389],
            [1, 1.0, 666, 0, 312],
            [1, 1.0, 586, 0, 237],
            [1, 1.0, 488, 0, 226],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.GalleonMechafish,
        name="On planks",
        konglist=[Kongs.diddy],
        region=Regions.Mechafish,
        locations=[[5, 1.0, 259, 35, 398], [5, 1.0, 453, 30, 470]],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.GalleonMermaidRoom,
        name="In the alcove",
        konglist=[Kongs.tiny],
        region=Regions.MermaidRoom,
        locations=[[5, 1.2, 198, 71, 214]],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.GalleonMermaidRoom,
        name="Above the mermaid",
        konglist=[Kongs.tiny],
        region=Regions.MermaidRoom,
        locations=[[5, 1.2, 345, 130, 125]],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Entrance tunnel (1 custom, 4 Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.GuitarShip,
        locations=[
            [1, 1.2, 1533, 15, 285],
            [1, 1.0, 1351.25927734375, 15.0, 585.6755981445312],
            [1, 1.0, 1347.3311767578125, 15.0, 441.4481506347656],
            [1, 1.0, 1512.5908203125, 15.0, 354.8580627441406],
            [1, 1.0, 1385.2635498046875, 15.0, 356.4963684082031],
        ],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On a barrel and a box",
        konglist=[Kongs.diddy],
        region=Regions.GuitarShip,
        locations=[[5, 1.2, 1129, 60, 809], [5, 1.2, 1257, 55, 1178]],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On barrel",
        konglist=[Kongs.chunky],
        region=Regions.TriangleShip,
        locations=[[5, 1.2, 1368, 55, 1223]],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On stack of boxes",
        konglist=[Kongs.chunky],
        region=Regions.TriangleShip,
        locations=[[5, 1.2, 1582, 90, 1288]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On chests",
        konglist=[Kongs.chunky],
        region=Regions.TriangleShip,
        locations=[[5, 1.2, 1548, 85, 1556], [5, 1.2, 1147, 85, 1563]],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On Captain K. Rools Log Book",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        locations=[[5, 1.2, 885, 65, 1582]],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On a barrel",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        locations=[[5, 1.2, 1077, 55, 1164]],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="On a box in the corner",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        locations=[[5, 1.2, 621, 50, 678]],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.Galleon5DShipDKTiny,
        name="On stack of boxes on the right",
        konglist=[Kongs.donkey],
        region=Regions.BongosShip,
        locations=[[5, 1.2, 23, 65, 946]],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.Galleon5DShipDKTiny,
        name="On box in right bedroom",
        konglist=[Kongs.donkey],
        region=Regions.BongosShip,
        locations=[[5, 1.2, 306, 40, 593]],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.Galleon5DShipDKTiny,
        name="On algae on the left",
        konglist=[Kongs.donkey],
        region=Regions.BongosShip,
        locations=[[5, 1.2, 1078, 35, 1155]],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.Galleon5DShipDKTiny,
        name="On boxes in bonus barrel room",
        konglist=[Kongs.donkey],
        region=Regions.BongosShip,
        locations=[[5, 1.2, 969, 95, 478], [5, 1.2, 1195, 45, 478]],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Singles in Tiny's 5DS (2 custom, 8 Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        locations=[
            [1, 1.2, 1081, 15, 1422],
            [1, 1.2, 431, 15, 1706],
            [1, 1.0, 617.0110473632812, 10.0, 2499.878173828125],
            [1, 1.0, 160.9495391845703, 10.0, 1833.5562744140625],
            [1, 1.0, 258.3056335449219, 10.0, 1700.5958251953125],
            [1, 1.0, 1057.914794921875, 10.0, 1809.9609375],
            [1, 1.0, 619.5040283203125, 10.0, 2349.959228515625],
            [1, 1.0, 620.2012939453125, 10.0, 2107.261962890625],
            [1, 1.0, 635.4428100585938, 10.0, 1699.7821044921875],
            [1, 1.0, 842.3317260742188, 10.0, 1700.9510498046875],
        ],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.Galleon5DShipDKTiny,
        name="On pillow in back bedroom",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        locations=[[5, 1.2, 629, 40, 1101]],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.Galleon2DShip,
        name="On the right on Tiny's side",
        konglist=[Kongs.tiny],
        region=Regions.TinyShip,
        locations=[[5, 1.2, 85, 30, 612], [5, 1.2, 85, 30, 872]],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.Galleon2DShip,
        name="In the chests",
        konglist=[Kongs.lanky],
        region=Regions.LankyShip,
        locations=[[5, 1.2, 1544, 10, 604], [5, 1.2, 2182, 10, 622], [5, 1.2, 2419, 10, 849]],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.Galleon2DShip,
        name="In tunnel to GB",
        konglist=[Kongs.lanky],
        region=Regions.LankyShip,
        locations=[
            [1, 1.2, 1867, 30, 1080],
            [1, 1.2, 1767, 30, 1080],
            [1, 1.2, 1667, 30, 1080],
            [1, 1.2, 1567, 30, 1080],
            [1, 1.2, 1467, 30, 1080],
            [1, 1.2, 1367, 30, 1080],
            [1, 1.2, 1267, 30, 1080],
            [1, 1.2, 1167, 30, 1080],
            [1, 1.2, 1167, 30, 1030],
            [1, 1.2, 1167, 30, 980],
        ],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.GalleonSubmarine,
        name="Back of submarine",
        konglist=[Kongs.tiny],
        region=Regions.Submarine,
        locations=[[5, 2.5, 1280, 20, 765]],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.GalleonSubmarine,
        name="On each side",
        konglist=[Kongs.tiny],
        region=Regions.Submarine,
        locations=[[5, 2.5, 912, 40, 1062], [5, 2.5, 912, 40, 426]],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.GalleonSubmarine,
        name="On console",
        konglist=[Kongs.tiny],
        region=Regions.Submarine,
        locations=[[5, 2.5, 552, 115, 748]],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.GalleonTreasureChest,
        name="Along bottom on each side",
        konglist=[Kongs.tiny],
        region=Regions.TinyChest,
        locations=[
            [1, 2.5, 394, 240, 1141],
            [1, 2.5, 504, 215, 1141],
            [1, 2.5, 614, 190, 1141],
            [1, 2.5, 724, 165, 1141],
            [1, 2.5, 834, 140, 1141],
            [1, 2.5, 1680, 205, 1220],
            [1, 2.5, 1805, 235, 1220],
            [1, 2.5, 1930, 265, 1220],
            [1, 2.5, 2055, 295, 1220],
            [1, 2.5, 2180, 325, 1220],
        ],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.GloomyGalleon,
        name="In alcove behind Enguarde box (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseEnguardeDoor,
        vanilla=True,
        locations=[
            [1, 1.0, 945.9843139648438, 1429.8197021484375, 4678.3828125],
            [1, 1.0, 895.1714477539062, 1457.6646728515625, 4727.05419921875],
            [1, 1.0, 826.5108032226562, 1460.0, 4797.65966796875],
            [1, 1.0, 676.1040649414062, 1460.0, 4934.986328125],
            [1, 1.0, 762.696044921875, 1460.0, 4853.44873046875],
            [1, 1.0, 792.2416381835938, 1460.0, 5015.51904296875],
            [1, 1.0, 620.0411987304688, 1460.0, 4662.14404296875],
            [1, 1.0, 923.1962890625, 1460.0, 4992.6025390625],
            [1, 1.0, 603.2728881835938, 1460.0, 4858.0810546875],
            [1, 1.0, 581.1214599609375, 1460.0, 4765.84619140625],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.GloomyGalleon,
        name="Under ship tunnel by 5DS (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        vanilla=True,
        locations=[
            [5, 1.0, 2824.778076171875, 596.7368774414062, 1752.3443603515625],
            [5, 1.0, 2858.2861328125, 605.494873046875, 1855.7796630859375],
            [5, 1.0, 2888.214111328125, 614.2701416015625, 1946.7269287109375],
        ],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.GloomyGalleon,
        name="On top of lighthouse (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.LighthousePlatform,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 1475.5653076171875, 2120.25927734375, 4034.429443359375],
            [5, 1.0, 1563.48046875, 2121.21728515625, 4082.459228515625],
        ],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.GloomyGalleon,
        name="Around 2DS on seafloor (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        vanilla=True,
        locations=[
            [1, 1.0, 1228.1392822265625, 987.3125610351562, 2100.660400390625],
            [1, 1.0, 1285.090576171875, 986.5239868164062, 1982.8514404296875],
            [1, 1.0, 1249.547607421875, 1003.9800415039062, 1861.2430419921875],
            [1, 1.0, 1148.827880859375, 1023.568603515625, 1792.0870361328125],
            [1, 1.0, 1041.688232421875, 1036.730712890625, 1808.53955078125],
            [1, 1.0, 942.9592895507812, 1046.5533447265625, 1849.84326171875],
            [1, 1.0, 867.29931640625, 1043.2325439453125, 1934.7257080078125],
            [1, 1.0, 889.126220703125, 1037.0758056640625, 2050.594970703125],
            [1, 1.0, 964.618896484375, 1027.7491455078125, 2137.951171875],
            [1, 1.0, 1098.7542724609375, 1007.4852905273438, 2142.24951171875],
        ],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.GloomyGalleon,
        name="In cannon path to Cranky (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        vanilla=True,
        locations=[
            [5, 1.0, 3333.526123046875, 1788.10888671875, 2680.950927734375],
            [5, 1.0, 3329.330810546875, 1881.7352294921875, 2625.457763671875],
        ],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.GloomyGalleon,
        name="On seafloor around mech fish (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        vanilla=True,
        locations=[
            [5, 1.2599997520446777, 3089.0830078125, 112.22805786132812, 392.5912170410156],
            [5, 1.2599997520446777, 3190.9619140625, 103.73084259033203, 549.248291015625],
            [5, 1.2599997520446777, 3030.50390625, 91.20886993408203, 645.425537109375],
            [5, 1.2599997520446777, 2938.355712890625, 100.4043197631836, 491.2366638183594],
        ],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.GloomyGalleon,
        name="On seafloor around enguarde chest in lighthouse area (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        locations=[
            [1, 1.2599997520446777, 1989.25244140625, 940.2966918945312, 3766.440673828125],
            [1, 1.2599997520446777, 1907.8111572265625, 943.6618041992188, 3721.9580078125],
            [1, 1.2599997520446777, 1921.1954345703125, 958.65380859375, 3640.207275390625],
            [1, 1.2599997520446777, 2045.1463623046875, 971.97265625, 3737.040771484375],
            [1, 1.2599997520446777, 2011.5821533203125, 987.3009643554688, 3642.58203125],
        ],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.GloomyGalleon,
        name="Under Enguarde box on 5DS (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        vanilla=True,
        locations=[[5, 1.3199996948242188, 2419.1142578125, 1207.5704345703125, 2018.81982421875]],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.GloomyGalleon,
        name="On cactus trombone pad (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        locations=[[5, 1.0, 4380.5703125, 1565.0, 949.15087890625]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.GloomyGalleon,
        name="In chest right of Enguarde box (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        logic=lambda l: (Events.LighthouseEnguarde in l.Events or l.CanPhaseswim()),
        locations=[[5, 1.0799999237060547, 2084.046875, 987.3544921875, 4043.450439453125]],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.GloomyGalleon,
        name="In chest left of Enguarde box (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        logic=lambda l: (Events.LighthouseEnguarde in l.Events or l.CanPhaseswim()),
        locations=[[5, 1.0999999046325684, 1521.998046875, 957.9177856445312, 3546.240478515625]],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.GloomyGalleon,
        name="In chest close to mermaid (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        logic=lambda l: (Events.LighthouseEnguarde in l.Events or l.CanPhaseswim()),
        locations=[[5, 1.119999885559082, 1164.2645263671875, 645.4811401367188, 3786.085693359375]],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.GloomyGalleon,
        name="In chest close to T&S hole (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        logic=lambda l: (Events.LighthouseEnguarde in l.Events or l.CanPhaseswim()),
        locations=[[5, 1.119999885559082, 1740.2940673828125, 604.6221313476562, 4295.24609375]],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.GloomyGalleon,
        name="W3 (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonPastVines,
        vanilla=True,
        locations=[[5, 1.0, 3067.403076171875, 1912.0, 2924.8515625]],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.GloomyGalleon,
        name="W3 (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSnideAlcove,
        vanilla=True,
        locations=[[5, 1.0, 1983.5390625, 1625.0, 4779.45654296875]],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.GloomyGalleon,
        name="In front of Tiny's treasure chest (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        vanilla=True,
        locations=[[5, 1.0, 1920.3751220703125, 1495.5020751953125, 573.7442016601562]],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.GloomyGalleon,
        name="In cannon game room over planks (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        vanilla=True,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        locations=[
            [5, 1.0, 1312.0430908203125, 1615.0, 2905.87890625],
            [5, 1.0, 1314.042724609375, 1648.0, 2806.0751953125],
            [5, 1.0, 1311.7952880859375, 1615.0, 2679.703857421875],
        ],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.GloomyGalleon,
        name="On seafloor around lighthouse (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        vanilla=True,
        locations=[
            [1, 1.299999713897705, 1579.5802001953125, 579.6561889648438, 4252.6025390625],
            [1, 1.3199996948242188, 1685.9461669921875, 587.1625366210938, 4202.845703125],
            [1, 1.3199996948242188, 1740.5537109375, 612.1123657226562, 4129.33056640625],
            [1, 1.3199996948242188, 1699.4215087890625, 625.6463012695312, 4031.528564453125],
            [1, 1.3199996948242188, 1648.1986083984375, 629.8402709960938, 3947.433349609375],
            [1, 1.3199996948242188, 1444.7314453125, 596.2842407226562, 4188.54296875],
            [1, 1.3199996948242188, 1351.8819580078125, 596.9949951171875, 4112.84716796875],
            [1, 1.3199996948242188, 1334.8101806640625, 617.2083740234375, 3960.038330078125],
            [1, 1.3199996948242188, 1422.3360595703125, 626.4080200195312, 3880.083740234375],
            [1, 1.3399996757507324, 1570.8819580078125, 622.7302856445312, 3866.293701171875],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.GloomyGalleon,
        name="W2 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        logic=lambda l: Events.WaterRaised in l.Events,
        locations=[[5, 1.0, 1554.5889892578125, 1665.417724609375, 2014.8204345703125]],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.GloomyGalleon,
        name="W2 (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        vanilla=True,
        locations=[[5, 1.0, 2905.437255859375, 1710.0, 3365.6474609375]],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.GloomyGalleon,
        name="Under ship tunnel by 5DS (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        vanilla=True,
        locations=[
            [5, 1.0, 2197.298095703125, 629.7448120117188, 1649.69921875],
            [5, 1.0, 2156.089111328125, 635.5853881835938, 1669.4090576171875],
            [5, 1.0, 2091.1240234375, 644.3757934570312, 1700.81787109375],
        ],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.GalleonSickBay,
        name="In main hallway (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        vanilla=True,
        locations=[
            [5, 1.0, 627.1885375976562, 35.0, 317.7214050292969],
            [5, 1.0, 628.9715576171875, 35.0, 437.8950500488281],
            [5, 1.0, 628.9347534179688, 35.0, 558.1495971679688],
            [5, 1.0, 625.2689819335938, 35.0, 680.0481567382812],
        ],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.GalleonSickBay,
        name="In barrels room (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        vanilla=True,
        logic=lambda l: l.punch or l.CanPhase(),
        locations=[[5, 1.0, 330.61083984375, 25.0, 919.9414672851562]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Corners of Diddy's 5DS (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.GuitarShip,
        vanilla=True,
        locations=[
            [5, 1.0, 1567.70166015625, 9.0, 653.36865234375],
            [5, 1.0, 1121.5743408203125, 0.24331586062908173, 624.4321899414062],
        ],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Close right corner of Lanky's 5DS (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        vanilla=True,
        locations=[[5, 1.3199996948242188, 648.4867553710938, 13.0, 1557.2476806640625]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Far left corner of Lanky's 5DS (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        vanilla=True,
        locations=[[5, 1.3199996948242188, 989.4599609375, 51.0, 627.8273315429688]],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Far right corner of Lanky's 5DS (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        vanilla=True,
        locations=[[5, 1.3199996948242188, 1078.12841796875, 89.0, 1520.2606201171875]],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Right side of Tiny's 5DS (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        vanilla=True,
        locations=[[5, 1.1399998664855957, 1036.256103515625, 7.0, 1591.2198486328125]],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Singles in DK's 5DS (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.BongosShip,
        vanilla=True,
        locations=[
            [1, 1.0, 622.3836059570312, 0, 287.2615661621094],
            [1, 1.0, 1080.5947265625, 0, 990.5343627929688],
            [1, 1.0, 620.6486206054688, 0, 875.5372924804688],
            [1, 1.0, 622.7431030273438, 0, 574.8864135742188],
            [1, 1.0, 449.1336975097656, 0, 874.5420532226562],
            [1, 1.0, 297.6194763183594, 0, 874.012939453125],
            [1, 1.0, 172.5303955078125, 0, 975.8445434570312],
            [1, 1.0, 813.9716796875, 0, 874.3157348632812],
            [1, 1.0, 961.7481079101562, 0, 864.8102416992188],
            [1, 1.0, 1002.6956176757812, 0, 689.1470336914062],
        ],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Left side of Tiny's 5DS (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        vanilla=True,
        locations=[[5, 1.1399998664855957, 112.45358276367188, 5.0, 1540.0069580078125]],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.Galleon2DShip,
        name="On barrel in Tiny's 2DS (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TinyShip,
        vanilla=True,
        locations=[[5, 1.239999771118164, 67.60479736328125, 84.0, 517.0884399414062]],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.Galleon2DShip,
        name="On path to Enguarde box (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.LankyShip,
        vanilla=True,
        locations=[
            [1, 1.0, 2266.932861328125, 0, 739.8952026367188],
            [1, 1.0, 2033.8956298828125, 0, 740.7173461914062],
            [1, 1.0, 1733.3310546875, 0, 739.9981079101562],
            [1, 1.0, 1445.3385009765625, 0, 741.1182250976562],
            [1, 1.0, 2464.440673828125, 0, 740.826416015625],
        ],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.Galleon2DShip,
        name="On chest in Tiny's 2DS (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TinyShip,
        vanilla=True,
        locations=[[5, 1.2599997520446777, 458.3203430175781, 66.27201843261719, 458.7626647949219]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.Galleon2DShip,
        name="At the end of tunnel to GB (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.LankyShip,
        vanilla=True,
        locations=[[5, 1.0, 1169.0096435546875, 48.7713623046875, 925.720947265625]],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.GalleonLighthouse,
        name="Group 1 up the lighthouse (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        vanilla=True,
        locations=[
            [5, 1.0, 550.31982421875, 343.0, 467.5648193359375],
            [5, 1.0, 483.4810485839844, 723.0, 440.6039123535156],
        ],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.GalleonLighthouse,
        name="Group 2 up the lighthouse (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        vanilla=True,
        locations=[
            [5, 1.0, 379.747802734375, 505.0, 392.3007507324219],
            [5, 1.0, 452.7491455078125, 220.0, 366.3783874511719],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.GalleonBaboonBlast,
        name="Baboon blast bunches (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.GalleonBaboonBlast,
        vanilla=True,
        locations=[
            [5, 1.0, 734.097412109375, 476.4828186035156, 1356.400390625],
            [5, 1.0, 932.83349609375, 332.1756896972656, 1368.240234375],
            [5, 1.0, 1275.2044677734375, 309.2455139160156, 745.03515625],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=146,
        map_id=Maps.GloomyGalleon,
        name="Around poles in cannon game room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: Events.WaterLowered in l.Events or l.swim,
        locations=[
            [1, 1.0, 1358, 1530, 3093],
            [1, 1.0, 1339, 1530, 3038],
            [1, 1.0, 1281, 1530, 3038],
            [1, 1.0, 1262, 1530, 3093],
            [1, 1.0, 1310, 1530, 3128],
            [1, 1.0, 1358, 1530, 2706],
            [1, 1.0, 1339, 1530, 2651],
            [1, 1.0, 1281, 1530, 2651],
            [1, 1.0, 1262, 1530, 2706],
            [1, 1.0, 1310, 1530, 2741],
        ],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.GloomyGalleon,
        name="On the cannon game cannon",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        locations=[[5, 1.0, 1313, 1670, 3024]],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.GloomyGalleon,
        name="Where the lighthouse sign is pointing",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 2595, 1680, 3469]],
    ),
    ColoredBananaGroup(
        group=149,
        map_id=Maps.GloomyGalleon,
        name="Torch above Lanky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 2599, 1677, 2847]],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.GloomyGalleon,
        name="Torch above Tiny switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 2223, 1685, 2696]],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.GloomyGalleon,
        name="First cannon shot to the wreck",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.5, 3070, 1995, 3320]],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.GloomyGalleon,
        name="Around the big pole of the caverns",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[
            [1, 1.0, 3106, 1685, 3009],
            [1, 1.0, 3092, 1685, 2965],
            [1, 1.0, 3044, 1685, 2965],
            [1, 1.0, 3030, 1685, 3009],
            [1, 1.0, 3068, 1685, 3037],
            [1, 1.0, 3106, 1723, 3009],
            [1, 1.0, 3092, 1723, 2965],
            [1, 1.0, 3044, 1723, 2965],
            [1, 1.0, 3030, 1723, 3009],
            [1, 1.0, 3068, 1723, 3037],
        ],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.GloomyGalleon,
        name="Bow of Cranky's wreck",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[1, 1.0, 3348, 1829, 2611], [1, 1.0, 3348, 1836, 2611], [1, 1.0, 3348, 1843, 2611], [1, 1.0, 3348, 1850, 2611], [1, 1.0, 3348, 1857, 2611]],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.GloomyGalleon,
        name="Klobber and Kaboom in the tunnel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[5, 1.0, 3295, 1675, 3772], [5, 1.0, 3293, 1675, 3815]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.GloomyGalleon,
        name="Front of the chests",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        locations=[[1, 1.0, 3525, 1688, 3721], [1, 1.0, 3638, 1688, 3808], [1, 1.0, 3520, 1688, 3880], [1, 1.0, 3578, 1672, 3765], [1, 1.0, 3586, 1672, 3843]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.GloomyGalleon,
        name="Twirl from the upper planks",
        konglist=[Kongs.tiny],
        region=Regions.GalleonPastVines,
        logic=lambda l: l.twirl,
        locations=[[1, 1.1, 3371, 1922, 2903], [1, 1.1, 3388, 1916, 2850], [1, 1.1, 3407, 1910, 2793], [1, 1.1, 3426, 1882, 2734], [1, 1.1, 3445, 1826, 2677]],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.GloomyGalleon,
        name="In the water around the lighthouse platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        logic=lambda l: Events.WaterLowered in l.Events or l.swim,
        locations=[
            [1, 1.0, 1666, 1530, 4258],
            [1, 1.0, 1757, 1530, 4133],
            [1, 1.0, 1757, 1530, 3979],
            [1, 1.0, 1666, 1530, 3854],
            [1, 1.0, 1519, 1530, 3806],
            [1, 1.0, 1372, 1530, 3854],
            [1, 1.0, 1281, 1530, 3979],
            [1, 1.0, 1281, 1530, 4133],
            [1, 1.0, 1372, 1530, 4258],
            [1, 1.0, 1519, 1530, 4306],
        ],
    ),
    ColoredBananaGroup(
        group=158,
        map_id=Maps.GloomyGalleon,
        name="On Kevin's spot (lighthouse alcove)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        locations=[[5, 2.0, 686, 1590, 4134]],
    ),
    ColoredBananaGroup(
        group=159,
        map_id=Maps.GloomyGalleon,
        name="Ceiling of the Enguarde cave",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseEnguardeDoor,
        logic=lambda l: Events.WaterRaised in l.Events,
        locations=[[5, 1.0, 792, 1620, 4824]],
    ),
    ColoredBananaGroup(
        group=160,
        map_id=Maps.GloomyGalleon,
        name="Rocket around the lighthouse",
        konglist=[Kongs.diddy],
        region=Regions.LighthousePlatform,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 1468, 1888, 4170],
            [1, 1.0, 1519, 1902, 4181],
            [1, 1.0, 1570, 1915, 4170],
            [1, 1.0, 1612, 1929, 4140],
            [1, 1.0, 1638, 1942, 4095],
            [1, 1.0, 1643, 1956, 4043],
            [1, 1.0, 1627, 1969, 3994],
            [1, 1.0, 1592, 1983, 3955],
            [1, 1.0, 1545, 1997, 3934],
            [1, 1.0, 1493, 2010, 3934],
            [1, 1.0, 1446, 2024, 3955],
            [1, 1.0, 1411, 2037, 3994],
            [1, 1.0, 1395, 2051, 4043],
            [1, 1.0, 1400, 2064, 4095],
            [1, 1.0, 1426, 2078, 4140],
        ],
    ),
    ColoredBananaGroup(
        group=161,
        map_id=Maps.GloomyGalleon,
        name="Algae near Enguarde crate",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 1508, 950, 3681],
            [5, 1.2, 1858, 960, 3764],
            [5, 1.2, 1952, 983, 4052],
        ],
    ),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.GloomyGalleon,
        name="Algae near the pit",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 2047, 610, 4408],
            [5, 1.2, 1756, 610, 4351],
            [5, 1.2, 1682, 582, 4462],
            [5, 1.2, 1664, 622, 4711],
        ],
    ),
    ColoredBananaGroup(
        group=163,
        map_id=Maps.GloomyGalleon,
        name="Algae near the center pillar",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 1312, 609, 4129],
            [5, 1.2, 1654, 670, 3903],
        ],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.GloomyGalleon,
        name="Algae near the intermediate chest",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 1177, 676, 3675],
            [5, 1.2, 890, 630, 3857],
        ],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.GloomyGalleon,
        name="Algae at the very bottom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseUnderwater,
        locations=[
            [5, 1.2, 923, 138, 4261],
            [5, 1.2, 1050, 138, 4455],
            [5, 1.2, 1330, 150, 4674],
        ],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.GloomyGalleon,
        name="Seal race entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        logic=lambda l: Events.WaterRaised in l.Events,
        locations=[[1, 1.0, 3359, 1640, 78], [1, 1.0, 3372, 1640, 86], [1, 1.0, 3386, 1640, 94], [1, 1.0, 3399, 1640, 101], [1, 1.0, 3412, 1640, 109]],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.GloomyGalleon,
        name="In the DK star",
        konglist=[Kongs.lanky],
        region=Regions.Shipyard,
        logic=lambda l: Events.ShipyardEnguarde in l.Events and (Events.WaterRaised in l.Events or l.monkey_maneuvers),
        locations=[[5, 1.3, 2413, 1655, 1779]],
    ),
    ColoredBananaGroup(
        group=168,
        map_id=Maps.GloomyGalleon,
        name="Around the cactus trunk",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.0, 4427, 1451, 1097],
            [1, 1.0, 4460, 1451, 1052],
            [1, 1.0, 4460, 1451, 996],
            [1, 1.0, 4427, 1451, 951],
            [1, 1.0, 4374, 1451, 934],
            [1, 1.0, 4321, 1451, 951],
            [1, 1.0, 4288, 1451, 996],
            [1, 1.0, 4288, 1451, 1052],
            [1, 1.0, 4321, 1451, 1097],
            [1, 1.0, 4374, 1451, 1114],
        ],
    ),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.GloomyGalleon,
        name="On big spike between 5DS and submarine",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 3071, 822, 1867]],
    ),
    ColoredBananaGroup(
        group=170,
        map_id=Maps.GloomyGalleon,
        name="Top of wreck under shipyard entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[1, 1.0, 2196, 781, 2404], [1, 1.0, 2240, 769, 2404], [1, 1.0, 2285, 758, 2403], [1, 1.0, 2329, 746, 2403], [1, 1.0, 2373, 735, 2403]],
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.GloomyGalleon,
        name="Top of wreck under tunnel to treasure room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[1, 1.0, 2127, 709, 1727], [1, 1.0, 2154, 701, 1693], [1, 1.0, 2181, 693, 1659], [1, 1.0, 2208, 686, 1626], [1, 1.0, 2235, 678, 1592]],
    ),
    ColoredBananaGroup(
        group=172,
        map_id=Maps.GloomyGalleon,
        name="Top of wreck towards Funky area",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.0, 2860, 658, 1699],
            [1, 1.0, 2861, 660, 1734],
            [1, 1.0, 2863, 663, 1770],
            [1, 1.0, 2864, 665, 1805],
            [1, 1.0, 2866, 668, 1841],
            [1, 1.0, 2867, 670, 1876],
            [1, 1.0, 2869, 673, 1912],
            [1, 1.0, 2870, 675, 1947],
            [1, 1.0, 2872, 678, 1983],
            [1, 1.0, 2873, 680, 2018],
        ],
    ),
    ColoredBananaGroup(
        group=173,
        map_id=Maps.GloomyGalleon,
        name="Chunky 5DS entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.0, 2284, 1160, 2030]],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.GloomyGalleon,
        name="Top of the 2DS",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.0, 1099, 1430, 2005]],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.GloomyGalleon,
        name="Railings on the 5DS",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.0, 2603, 1245, 2145],
            [1, 1.0, 2500, 1245, 2150],
            [1, 1.0, 2396, 1245, 2155],
            [1, 1.0, 2293, 1245, 2160],
            [1, 1.0, 2190, 1245, 2165],
            [1, 1.0, 2184, 1253, 1877],
            [1, 1.0, 2290, 1252, 1875],
            [1, 1.0, 2396, 1250, 1872],
            [1, 1.0, 2501, 1249, 1870],
            [1, 1.0, 2607, 1248, 1868],
        ],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.GloomyGalleon,
        name="Around the tunnel to treasure room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[
            [1, 1.0, 2018, 1456, 1586],
            [1, 1.0, 2047, 1491, 1559],
            [1, 1.0, 2086, 1504, 1536],
            [1, 1.0, 2118, 1492, 1514],
            [1, 1.0, 2156, 1457, 1482],
            [1, 1.0, 2156, 1404, 1482],
            [1, 1.0, 2122, 1379, 1509],
            [1, 1.0, 2089, 1360, 1533],
            [1, 1.0, 2055, 1379, 1556],
            [1, 1.0, 2018, 1402, 1584],
        ],
    ),
    ColoredBananaGroup(
        group=177,
        map_id=Maps.GloomyGalleon,
        name="Big spike near the mechfish cage",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.ShipyardUnderwater,
        locations=[[5, 1.2, 3184, 350, 449]],
    ),
    ColoredBananaGroup(
        group=178,
        map_id=Maps.GloomyGalleon,
        name="Top of the Diddy gold tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoomDiddyGoldTower,
        locations=[[5, 1.0, 2107, 1919, 878], [5, 1.0, 2143, 1919, 799]],
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.GloomyGalleon,
        name="Underwater against the Diddy gold tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        locations=[[1, 1.0, 1936, 1442, 718], [1, 1.0, 1958, 1442, 770], [1, 1.0, 1982, 1442, 807], [1, 1.0, 2006, 1443, 843], [1, 1.0, 2029, 1443, 879]],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.GloomyGalleon,
        name="Underwater against the Lanky gold tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        locations=[[1, 1.0, 1588, 1443, 638], [1, 1.0, 1649, 1443, 668], [1, 1.0, 1691, 1441, 666], [1, 1.0, 1736, 1441, 664], [1, 1.0, 1791, 1441, 650]],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.GalleonSickBay,
        name="Spilled all over the seasick ship",
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        locations=[
            [1, 1.0, 463, 20, 978],
            [1, 1.0, 524, 40, 869],
            [1, 1.0, 639, 32, 892],
            [1, 1.0, 685, 55, 744],
            [1, 1.0, 554, 22, 654],
            [1, 1.0, 676, 40, 559],
            [1, 1.0, 570, 30, 518],
            [1, 1.0, 564, 50, 408],
            [1, 1.0, 643, 60, 448],
            [1, 1.0, 673, 20, 363],
            [1, 1.0, 574, 36, 261],
            [1, 1.0, 733, 35, 632],
            [1, 1.0, 658, 62, 775],
            [1, 1.0, 632, 28, 985],
            [1, 1.0, 657, 20, 758],
        ],
    ),
    ColoredBananaGroup(
        group=182, map_id=Maps.GalleonLighthouse, name="Entrance corners", konglist=[Kongs.donkey], region=Regions.Lighthouse, locations=[[5, 1.0, 507, 26, 146], [5, 1.0, 389, 26, 143]]
    ),
    ColoredBananaGroup(
        group=183,
        map_id=Maps.GalleonLighthouse,
        name="Cobwebs at the bottom",
        konglist=[Kongs.donkey],
        region=Regions.Lighthouse,
        locations=[
            [1, 1.0, 555, 0, 305],
            [1, 1.0, 743, 0, 290],
            [1, 1.0, 613, 0, 425],
            [1, 1.0, 705, 0, 683],
            [1, 1.0, 553, 0, 628],
            [1, 1.0, 396, 0, 796],
            [1, 1.0, 305, 0, 603],
            [1, 1.0, 124, 0, 582],
            [1, 1.0, 147, 0, 302],
            [1, 1.0, 314, 0, 332],
        ],
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.GalleonLighthouse,
        name="First elevator platform",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        locations=[[1, 1.0, 451, 442, 369], [1, 1.0, 451, 444, 369], [1, 1.0, 451, 447, 369], [1, 1.0, 451, 449, 369], [1, 1.0, 451, 451, 369]],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.GalleonLighthouse,
        name="Final elevator platforms",
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        locations=[
            [1, 1.0, 380, 536, 532],
            [1, 1.0, 380, 561, 532],
            [1, 1.0, 380, 585, 532],
            [1, 1.0, 380, 610, 532],
            [1, 1.0, 380, 634, 532],
            [1, 1.0, 450, 607, 565],
            [1, 1.0, 450, 632, 565],
            [1, 1.0, 450, 656, 565],
            [1, 1.0, 450, 681, 565],
            [1, 1.0, 450, 705, 565],
        ],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.GalleonMermaidRoom,
        name="Mermaid's armrests",
        konglist=[Kongs.tiny],
        region=Regions.MermaidRoom,
        locations=[
            [5, 1.2, 306, 88, 142],
            [5, 1.2, 385, 88, 142],
        ],
    ),
    ColoredBananaGroup(group=187, map_id=Maps.Galleon5DShipDKTiny, name="Skeleton in the main room", konglist=[Kongs.donkey], region=Regions.BongosShip, locations=[[5, 1.0, 654, 116, 1066]]),
    ColoredBananaGroup(group=188, map_id=Maps.Galleon5DShipDKTiny, name="Skeleton near the GB", konglist=[Kongs.donkey], region=Regions.BongosShip, locations=[[5, 1.0, 1217, 163, 528]]),
    ColoredBananaGroup(
        group=189,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Windows to Lanky's room",
        konglist=[Kongs.diddy],
        region=Regions.GuitarShip,
        locations=[
            [5, 1.0, 1111, 91, 1047],
            [5, 1.0, 1111, 91, 747],
        ],
    ),
    ColoredBananaGroup(
        group=190,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Cannons",
        konglist=[Kongs.diddy],
        region=Regions.GuitarShip,
        locations=[
            [1, 1.0, 1485, 5, 711],
            [1, 1.0, 1473, 5, 725],
            [1, 1.0, 1463, 5, 750],
            [1, 1.0, 1473, 5, 775],
            [1, 1.0, 1485, 5, 789],
            [1, 1.0, 1485, 5, 1011],
            [1, 1.0, 1473, 5, 1025],
            [1, 1.0, 1463, 5, 1050],
            [1, 1.0, 1473, 5, 1075],
            [1, 1.0, 1485, 5, 1089],
        ],
    ),
    ColoredBananaGroup(
        group=191,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Windows to Diddy's room",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        locations=[
            [5, 1.0, 1086, 91, 1047],
            [5, 1.0, 1086, 91, 747],
        ],
    ),
    ColoredBananaGroup(
        group=192,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Red carpet",
        konglist=[Kongs.lanky],
        region=Regions.TromboneShip,
        locations=[
            [1, 1.0, 929, 5, 1139],
            [1, 1.0, 900, 5, 1049],
            [1, 1.0, 806, 5, 1049],
            [1, 1.0, 777, 5, 1139],
            [1, 1.0, 853, 5, 1194],
            [1, 1.0, 947, 5, 1243],
            [1, 1.0, 1005, 5, 1163],
            [1, 1.0, 1005, 5, 1065],
            [1, 1.0, 947, 5, 985],
            [1, 1.0, 853, 5, 954],
            [1, 1.0, 759, 5, 985],
            [1, 1.0, 701, 5, 1065],
            [1, 1.0, 701, 5, 1163],
            [1, 1.0, 759, 5, 1243],
            [1, 1.0, 853, 5, 1274],
        ],
    ),
    ColoredBananaGroup(
        group=193,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Locked fairy door",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        locations=[
            [1, 1.0, 1017, 130, 1890],
            [1, 1.0, 1008, 104, 1890],
            [1, 1.0, 1000, 79, 1890],
            [1, 1.0, 991, 53, 1890],
            [1, 1.0, 983, 28, 1890],
            [1, 1.0, 974, 2, 1890],
            [1, 1.0, 1017, 2, 1890],
            [1, 1.0, 1003, 45, 1890],
            [1, 1.0, 988, 87, 1890],
            [1, 1.0, 974, 130, 1890],
        ],
    ),
    ColoredBananaGroup(
        group=194,
        map_id=Maps.Galleon5DShipDKTiny,
        name="Around the GB",
        konglist=[Kongs.tiny],
        region=Regions.SaxophoneShip,
        locations=[
            [1, 1.0, 196, 2, 2046],
            [1, 1.0, 174, 2, 1978],
            [1, 1.0, 104, 2, 1978],
            [1, 1.0, 82, 2, 2046],
            [1, 1.0, 139, 2, 2087],
        ],
    ),
    ColoredBananaGroup(
        group=195,
        map_id=Maps.Galleon5DShipDiddyLankyChunky,
        name="Pile o' gold",
        konglist=[Kongs.chunky],
        region=Regions.TriangleShip,
        locations=[
            [5, 1.0, 1330, 34, 1421],
            [1, 1.0, 1375, 2, 1435],
            [1, 1.0, 1332, 2, 1477],
            [1, 1.0, 1275, 2, 1437],
            [1, 1.0, 1296, 2, 1374],
            [1, 1.0, 1350, 2, 1381],
        ],
    ),
    ColoredBananaGroup(group=196, map_id=Maps.Galleon2DShip, name="Above the entrance", konglist=[Kongs.lanky], region=Regions.LankyShip, locations=[[5, 1.0, 2578, 138, 754]]),
    ColoredBananaGroup(
        group=197,
        map_id=Maps.Galleon2DShip,
        name="Wooden beam",
        konglist=[Kongs.tiny],
        region=Regions.TinyShip,
        locations=[[1, 1.0, 154, 16, 377], [1, 1.0, 154, 50, 413], [1, 1.0, 154, 84, 449], [1, 1.0, 154, 117, 484], [1, 1.0, 154, 151, 520]],
    ),
    ColoredBananaGroup(group=198, map_id=Maps.Galleon2DShip, name="Through the hole", konglist=[Kongs.tiny], region=Regions.TinyShip, locations=[[5, 1.0, 346, 94, 557]]),
    ColoredBananaGroup(
        group=199,
        map_id=Maps.GalleonTreasureChest,
        name="The smile of the center clam",
        konglist=[Kongs.tiny],
        region=Regions.TinyChest,
        locations=[
            [1, 2.5, 1167, 456, 1246],
            [1, 2.5, 1212, 436, 1298],
            [1, 2.5, 1281, 425, 1317],
            [1, 2.5, 1355, 436, 1300],
            [1, 2.5, 1402, 456, 1249],
        ],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.GloomyGalleon,
        name="Cannon game room",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        points=[[1206, 1680, 2714], [1187, 1685, 3072]],
    ),
    Balloon(
        id=2,
        map_id=Maps.GloomyGalleon,
        name="Between W2 and Tiny BP",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[2920, 1950, 3339], [2920, 1950, 3000]],
    ),
    Balloon(
        id=3,
        map_id=Maps.GloomyGalleon,
        name="Between left side of ship and T&S portal",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[3217, 1950, 3450], [3170, 1950, 3118]],
    ),
    Balloon(
        id=4,
        map_id=Maps.GloomyGalleon,
        name="Around Cranky",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[
            [3184, 1910, 2565],
            [3236, 1920, 2627],
            [3362, 1925, 2671],
            [3462, 1920, 2546],
            [3443, 1910, 2429],
            [3462, 1920, 2546],
            [3362, 1925, 2671],
            [3236, 1920, 2627],
        ],
    ),
    Balloon(
        id=5,
        map_id=Maps.GloomyGalleon,
        name="Around top of lighthouse",
        speed=6,
        konglist=[Kongs.diddy],
        region=Regions.LighthousePlatform,
        logic=lambda l: l.jetpack,
        points=[
            [1515, 2315, 4222],
            [1362, 2310, 4099],
            [1454, 2300, 3913],
            [1617, 2305, 3930],
            [1666, 2300, 4060],
            [1626, 2310, 4177],
        ],
    ),
    Balloon(
        id=6,
        map_id=Maps.GloomyGalleon,
        name="In front of Funky's",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        points=[[3800, 1750, 1707], [4038, 1760, 1624], [4142, 1750, 1400], [3914, 1740, 1564]],
    ),
    Balloon(
        id=7,
        map_id=Maps.GloomyGalleon,
        name="In front of Candy's",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        points=[[3035, 1750, 750], [3175, 1750, 430]],
    ),
    Balloon(
        id=8,
        map_id=Maps.GloomyGalleon,
        name="High in gold tower room",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        points=[[1984, 1840, 962], [1620, 1850, 770]],
    ),
    Balloon(
        id=9,
        map_id=Maps.GalleonSickBay,
        name="Corner",
        speed=6,
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        points=[[730, 110, 893], [440, 110, 984]],
    ),
    Balloon(
        id=10,
        map_id=Maps.GalleonLighthouse,
        name="Around top",
        speed=6,
        konglist=[Kongs.donkey],
        region=Regions.LighthouseAboveLadder,
        points=[
            [372, 800, 315],
            [298, 807, 418],
            [298, 804, 535],
            [396, 810, 616],
            [517, 803, 616],
            [601, 808, 527],
            [601, 802, 407],
            [534, 806, 315],
        ],
    ),
    Balloon(
        id=11,
        map_id=Maps.GloomyGalleon,
        name="Around cactus (Diddy)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        points=[[4282, 1682, 1006], [4358, 1688, 1029], [4398, 1696, 1138]],
    ),
    Balloon(
        id=12,
        map_id=Maps.GloomyGalleon,
        name="By Diddy BP (Tiny)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSurface,
        vanilla=True,
        logic=lambda l: Events.WaterLowered in l.Events,
        points=[[637, 1604, 4091], [638, 1606, 3967]],
    ),
    Balloon(
        id=13,
        map_id=Maps.GloomyGalleon,
        name="Above battle crown pad 1 (Lanky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        vanilla=True,
        logic=lambda l: (l.punch and l.chunky) or l.CanPhase(),
        points=[[3278, 1706, 2500], [3252, 1704, 2418]],
    ),
    Balloon(
        id=14,
        map_id=Maps.GloomyGalleon,
        name="Above battle crown pad 2 (Lanky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        vanilla=True,
        logic=lambda l: ((l.punch and l.chunky) or l.CanPhase()),
        points=[[3245, 1720, 2405], [3304, 1718, 2382]],
    ),
    Balloon(
        id=15,
        map_id=Maps.GloomyGalleon,
        name="Around cactus (Chunky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        points=[[4426, 1634, 873], [4551, 1654, 1037], [4435, 1632, 1130], [4308, 1658, 1041], [4299, 1640, 900]],
    ),
    Balloon(
        id=16,
        map_id=Maps.GloomyGalleon,
        name="Above seal cage (Diddy)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        vanilla=True,
        points=[[2085, 1908, 3972], [2025, 1914, 4129]],
    ),
    Balloon(
        id=17,
        map_id=Maps.GloomyGalleon,
        name="Around lighthouse (Donkey)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        vanilla=True,
        points=[
            [1606, 1802, 3925],
            [1671, 1796, 4025],
            [1639, 1804, 4174],
            [1491, 1810, 4229],
            [1386, 1806, 4157],
            [1374, 1803, 4019],
            [1448, 1802, 3923],
        ],
    ),
    Balloon(
        id=18,
        map_id=Maps.GloomyGalleon,
        name="In chests room (Donkey)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        vanilla=True,
        points=[[3418, 1750, 3750], [3508, 1752, 3838], [3393, 1748, 3881]],
    ),
    Balloon(
        id=19,
        map_id=Maps.GloomyGalleon,
        name="In gold tower room (Diddy)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        vanilla=True,
        points=[[2187, 1591, 614], [2126, 1594, 552], [2082, 1587, 640]],
    ),
    Balloon(
        id=20,
        map_id=Maps.GloomyGalleon,
        name="By cannon in cannon game room (Chunky)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        vanilla=True,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        points=[[1421, 1597, 3255], [1257, 1624, 3198]],
    ),
    Balloon(
        id=21,
        map_id=Maps.GloomyGalleon,
        name="Above 2DS (Chunky)",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        points=[[1256, 1664, 2152], [1279, 1689, 1853]],
    ),
    Balloon(
        id=22,
        map_id=Maps.GloomyGalleon,
        name="Above 5DS (Lanky)",
        speed=3,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        vanilla=True,
        points=[[2312, 1704, 2125], [2481, 1704, 2124]],
    ),
    Balloon(
        id=23,
        map_id=Maps.GloomyGalleon,
        name="In front of Snide (Tiny)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthouseSnideAlcove,
        vanilla=True,
        logic=lambda l: Events.WaterRaised in l.Events,
        points=[[2070, 1678, 4623], [1979, 1672, 4713]],
    ),
    Balloon(
        id=24,
        map_id=Maps.GloomyGalleon,
        name="In gold tower room (Tiny)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        vanilla=True,
        points=[[1692, 1605, 422], [1749, 1609, 347]],
    ),
    Balloon(
        id=25,
        map_id=Maps.GalleonLighthouse,
        name="Left side (Donkey)",
        speed=5,
        konglist=[Kongs.donkey],
        region=Regions.Lighthouse,
        vanilla=True,
        points=[[686, 206, 577], [696, 186, 416]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=26,
        map_id=Maps.GloomyGalleon,
        name="Around the cannonball",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GalleonBeyondPineappleGate,
        logic=lambda l: (Events.WaterRaised in l.Events or (l.monkey_maneuvers and ((l.islanky and not l.isKrushaAdjacent(Kongs.lanky)) or l.ischunky))),
        points=[[1274, 1680, 2590], [1339, 1680, 1554], [1331, 1690, 2635]],
    ),
    Balloon(
        id=27,
        map_id=Maps.GloomyGalleon,
        name="Entrance tunnel",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[2148, 1686, 2805], [2122, 1650, 3155], [2425, 1700, 3239], [2142, 1640, 3162]],
    ),
    Balloon(
        id=28,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to shipyard",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[2570, 1670, 3129], [2413, 1660, 2959], [2444, 1670, 2829], [2356, 1640, 2712], [2464, 1672, 2937]],
    ),
    Balloon(
        id=29,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to lighthouse",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[2495, 1640, 3343], [2498, 1650, 3518], [2281, 1630, 3522], [2176, 1691, 3429], [2515, 1685, 3523], [2571, 1680, 3380]],
    ),
    Balloon(
        id=30,
        map_id=Maps.GloomyGalleon,
        name="Tunnel to chests",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.GloomyGalleonStart,
        points=[[3060, 1723, 3807], [3181, 1730, 3770], [3101, 1694, 3633], [3105, 1692, 3739]],
    ),
    Balloon(
        id=31,
        map_id=Maps.GloomyGalleon,
        name="Near lighthouse warp 1",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LighthousePlatform,
        points=[[1521, 1654, 4222], [1526, 1666, 4363], [1525, 1496, 4346], [1526, 1666, 4363]],
    ),
    Balloon(
        id=32,
        map_id=Maps.GloomyGalleon,
        name="Near shipyard warp 4",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        points=[[2729, 1632, 1320], [2841, 1666, 1263], [2834, 1768, 1351]],
    ),
    Balloon(
        id=33,
        map_id=Maps.GloomyGalleon,
        name="Near shipyard warp 5",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Shipyard,
        points=[[3212, 1689, 1707], [3097, 1677, 2027]],
    ),
    Balloon(
        id=34,
        map_id=Maps.GloomyGalleon,
        name="Between the gold towers",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.TreasureRoom,
        points=[[1771, 1630, 648], [1865, 1678, 680], [1949, 1638, 727], [1832, 1472, 747]],
    ),
    Balloon(
        id=35,
        map_id=Maps.GalleonSickBay,
        name="Above the cannons",
        speed=11,
        konglist=[Kongs.chunky],
        region=Regions.SickBay,
        points=[[688, 150, 287], [518, 155, 416], [735, 100, 475], [547, 111, 567], [682, 98, 627], [599, 151, 434]],
    ),
    Balloon(
        id=36,
        map_id=Maps.GalleonMechafish,
        name="Mechanical heart",
        speed=11,
        konglist=[Kongs.diddy],
        region=Regions.Mechafish,
        points=[[362, 105, 622], [440, 232, 608], [272, 242, 601]],
    ),
]
