import typing
from BaseClasses import Location, Region
from .names import location_name

if typing.TYPE_CHECKING:
    from .room import KDL3Room


class KDL3Location(Location):
    game: str = "Kirby's Dream Land 3"
    room: typing.Optional["KDL3Room"] = None

    def __init__(self, player: int, name: str, address: typing.Optional[int], parent: typing.Union[Region, None]):
        super().__init__(player, name, address, parent)
        if not address:
            self.show_in_spoiler = False


stage_locations = {
    0x770000: location_name.grass_land_1,
    0x770001: location_name.grass_land_2,
    0x770002: location_name.grass_land_3,
    0x770003: location_name.grass_land_4,
    0x770004: location_name.grass_land_5,
    0x770005: location_name.grass_land_6,
    0x770006: location_name.ripple_field_1,
    0x770007: location_name.ripple_field_2,
    0x770008: location_name.ripple_field_3,
    0x770009: location_name.ripple_field_4,
    0x77000A: location_name.ripple_field_5,
    0x77000B: location_name.ripple_field_6,
    0x77000C: location_name.sand_canyon_1,
    0x77000D: location_name.sand_canyon_2,
    0x77000E: location_name.sand_canyon_3,
    0x77000F: location_name.sand_canyon_4,
    0x770010: location_name.sand_canyon_5,
    0x770011: location_name.sand_canyon_6,
    0x770012: location_name.cloudy_park_1,
    0x770013: location_name.cloudy_park_2,
    0x770014: location_name.cloudy_park_3,
    0x770015: location_name.cloudy_park_4,
    0x770016: location_name.cloudy_park_5,
    0x770017: location_name.cloudy_park_6,
    0x770018: location_name.iceberg_1,
    0x770019: location_name.iceberg_2,
    0x77001A: location_name.iceberg_3,
    0x77001B: location_name.iceberg_4,
    0x77001C: location_name.iceberg_5,
    0x77001D: location_name.iceberg_6,
}

heart_star_locations = {
    0x770100: location_name.grass_land_tulip,
    0x770101: location_name.grass_land_muchi,
    0x770102: location_name.grass_land_pitcherman,
    0x770103: location_name.grass_land_chao,
    0x770104: location_name.grass_land_mine,
    0x770105: location_name.grass_land_pierre,
    0x770106: location_name.ripple_field_kamuribana,
    0x770107: location_name.ripple_field_bakasa,
    0x770108: location_name.ripple_field_elieel,
    0x770109: location_name.ripple_field_toad,
    0x77010A: location_name.ripple_field_mama_pitch,
    0x77010B: location_name.ripple_field_hb002,
    0x77010C: location_name.sand_canyon_mushrooms,
    0x77010D: location_name.sand_canyon_auntie,
    0x77010E: location_name.sand_canyon_caramello,
    0x77010F: location_name.sand_canyon_hikari,
    0x770110: location_name.sand_canyon_nyupun,
    0x770111: location_name.sand_canyon_rob,
    0x770112: location_name.cloudy_park_hibanamodoki,
    0x770113: location_name.cloudy_park_piyokeko,
    0x770114: location_name.cloudy_park_mrball,
    0x770115: location_name.cloudy_park_mikarin,
    0x770116: location_name.cloudy_park_pick,
    0x770117: location_name.cloudy_park_hb007,
    0x770118: location_name.iceberg_kogoesou,
    0x770119: location_name.iceberg_samus,
    0x77011A: location_name.iceberg_kawasaki,
    0x77011B: location_name.iceberg_name,
    0x77011C: location_name.iceberg_shiro,
    0x77011D: location_name.iceberg_angel,
}

boss_locations = {
    0x770200: location_name.grass_land_whispy,
    0x770201: location_name.ripple_field_acro,
    0x770202: location_name.sand_canyon_poncon,
    0x770203: location_name.cloudy_park_ado,
    0x770204: location_name.iceberg_dedede,
}

consumable_locations = {
    0x770300: location_name.grass_land_1_u1,
    0x770301: location_name.grass_land_1_m1,
    0x770302: location_name.grass_land_2_u1,
    0x770303: location_name.grass_land_3_u1,
    0x770304: location_name.grass_land_3_m1,
    0x770305: location_name.grass_land_4_m1,
    0x770306: location_name.grass_land_4_u1,
    0x770307: location_name.grass_land_4_m2,
    0x770308: location_name.grass_land_4_m3,
    0x770309: location_name.grass_land_6_u1,
    0x77030A: location_name.grass_land_6_u2,
    0x77030B: location_name.ripple_field_2_u1,
    0x77030C: location_name.ripple_field_2_m1,
    0x77030D: location_name.ripple_field_3_m1,
    0x77030E: location_name.ripple_field_3_u1,
    0x77030F: location_name.ripple_field_4_m2,
    0x770310: location_name.ripple_field_4_u1,
    0x770311: location_name.ripple_field_4_m1,
    0x770312: location_name.ripple_field_5_u1,
    0x770313: location_name.ripple_field_5_m2,
    0x770314: location_name.ripple_field_5_m1,
    0x770315: location_name.sand_canyon_1_u1,
    0x770316: location_name.sand_canyon_2_u1,
    0x770317: location_name.sand_canyon_2_m1,
    0x770318: location_name.sand_canyon_4_m1,
    0x770319: location_name.sand_canyon_4_u1,
    0x77031A: location_name.sand_canyon_4_m2,
    0x77031B: location_name.sand_canyon_5_u1,
    0x77031C: location_name.sand_canyon_5_u3,
    0x77031D: location_name.sand_canyon_5_m1,
    0x77031E: location_name.sand_canyon_5_u4,
    0x77031F: location_name.sand_canyon_5_u2,
    0x770320: location_name.cloudy_park_1_m1,
    0x770321: location_name.cloudy_park_1_u1,
    0x770322: location_name.cloudy_park_4_u1,
    0x770323: location_name.cloudy_park_4_m1,
    0x770324: location_name.cloudy_park_5_m1,
    0x770325: location_name.cloudy_park_6_u1,
    0x770326: location_name.iceberg_3_m1,
    0x770327: location_name.iceberg_5_u1,
    0x770328: location_name.iceberg_5_u2,
    0x770329: location_name.iceberg_5_u3,
    0x77032A: location_name.iceberg_6_m1,
    0x77032B: location_name.iceberg_6_u1,
}

level_consumables = {
    1: [0, 1],
    2: [2],
    3: [3, 4],
    4: [5, 6, 7, 8],
    6: [9, 10],
    8: [11, 12],
    9: [13, 14],
    10: [15, 16, 17],
    11: [18, 19, 20],
    13: [21],
    14: [22, 23],
    16: [24, 25, 26],
    17: [27, 28, 29, 30, 31],
    19: [32, 33],
    22: [34, 35],
    23: [36],
    24: [37],
    27: [38],
    29: [39, 40, 41],
    30: [42, 43],
}

star_locations = {
    0x770401: location_name.grass_land_1_s1,
    0x770402: location_name.grass_land_1_s2,
    0x770403: location_name.grass_land_1_s3,
    0x770404: location_name.grass_land_1_s4,
    0x770405: location_name.grass_land_1_s5,
    0x770406: location_name.grass_land_1_s6,
    0x770407: location_name.grass_land_1_s7,
    0x770408: location_name.grass_land_1_s8,
    0x770409: location_name.grass_land_1_s9,
    0x77040a: location_name.grass_land_1_s10,
    0x77040b: location_name.grass_land_1_s11,
    0x77040c: location_name.grass_land_1_s12,
    0x77040d: location_name.grass_land_1_s13,
    0x77040e: location_name.grass_land_1_s14,
    0x77040f: location_name.grass_land_1_s15,
    0x770410: location_name.grass_land_1_s16,
    0x770411: location_name.grass_land_1_s17,
    0x770412: location_name.grass_land_1_s18,
    0x770413: location_name.grass_land_1_s19,
    0x770414: location_name.grass_land_1_s20,
    0x770415: location_name.grass_land_1_s21,
    0x770416: location_name.grass_land_1_s22,
    0x770417: location_name.grass_land_1_s23,
    0x770418: location_name.grass_land_2_s1,
    0x770419: location_name.grass_land_2_s2,
    0x77041a: location_name.grass_land_2_s3,
    0x77041b: location_name.grass_land_2_s4,
    0x77041c: location_name.grass_land_2_s5,
    0x77041d: location_name.grass_land_2_s6,
    0x77041e: location_name.grass_land_2_s7,
    0x77041f: location_name.grass_land_2_s8,
    0x770420: location_name.grass_land_2_s9,
    0x770421: location_name.grass_land_2_s10,
    0x770422: location_name.grass_land_2_s11,
    0x770423: location_name.grass_land_2_s12,
    0x770424: location_name.grass_land_2_s13,
    0x770425: location_name.grass_land_2_s14,
    0x770426: location_name.grass_land_2_s15,
    0x770427: location_name.grass_land_2_s16,
    0x770428: location_name.grass_land_2_s17,
    0x770429: location_name.grass_land_2_s18,
    0x77042a: location_name.grass_land_2_s19,
    0x77042b: location_name.grass_land_2_s20,
    0x77042c: location_name.grass_land_2_s21,
    0x77042d: location_name.grass_land_3_s1,
    0x77042e: location_name.grass_land_3_s2,
    0x77042f: location_name.grass_land_3_s3,
    0x770430: location_name.grass_land_3_s4,
    0x770431: location_name.grass_land_3_s5,
    0x770432: location_name.grass_land_3_s6,
    0x770433: location_name.grass_land_3_s7,
    0x770434: location_name.grass_land_3_s8,
    0x770435: location_name.grass_land_3_s9,
    0x770436: location_name.grass_land_3_s10,
    0x770437: location_name.grass_land_3_s11,
    0x770438: location_name.grass_land_3_s12,
    0x770439: location_name.grass_land_3_s13,
    0x77043a: location_name.grass_land_3_s14,
    0x77043b: location_name.grass_land_3_s15,
    0x77043c: location_name.grass_land_3_s16,
    0x77043d: location_name.grass_land_3_s17,
    0x77043e: location_name.grass_land_3_s18,
    0x77043f: location_name.grass_land_3_s19,
    0x770440: location_name.grass_land_3_s20,
    0x770441: location_name.grass_land_3_s21,
    0x770442: location_name.grass_land_3_s22,
    0x770443: location_name.grass_land_3_s23,
    0x770444: location_name.grass_land_3_s24,
    0x770445: location_name.grass_land_3_s25,
    0x770446: location_name.grass_land_3_s26,
    0x770447: location_name.grass_land_3_s27,
    0x770448: location_name.grass_land_3_s28,
    0x770449: location_name.grass_land_3_s29,
    0x77044a: location_name.grass_land_3_s30,
    0x77044b: location_name.grass_land_3_s31,
    0x77044c: location_name.grass_land_4_s1,
    0x77044d: location_name.grass_land_4_s2,
    0x77044e: location_name.grass_land_4_s3,
    0x77044f: location_name.grass_land_4_s4,
    0x770450: location_name.grass_land_4_s5,
    0x770451: location_name.grass_land_4_s6,
    0x770452: location_name.grass_land_4_s7,
    0x770453: location_name.grass_land_4_s8,
    0x770454: location_name.grass_land_4_s9,
    0x770455: location_name.grass_land_4_s10,
    0x770456: location_name.grass_land_4_s11,
    0x770457: location_name.grass_land_4_s12,
    0x770458: location_name.grass_land_4_s13,
    0x770459: location_name.grass_land_4_s14,
    0x77045a: location_name.grass_land_4_s15,
    0x77045b: location_name.grass_land_4_s16,
    0x77045c: location_name.grass_land_4_s17,
    0x77045d: location_name.grass_land_4_s18,
    0x77045e: location_name.grass_land_4_s19,
    0x77045f: location_name.grass_land_4_s20,
    0x770460: location_name.grass_land_4_s21,
    0x770461: location_name.grass_land_4_s22,
    0x770462: location_name.grass_land_4_s23,
    0x770463: location_name.grass_land_4_s24,
    0x770464: location_name.grass_land_4_s25,
    0x770465: location_name.grass_land_4_s26,
    0x770466: location_name.grass_land_4_s27,
    0x770467: location_name.grass_land_4_s28,
    0x770468: location_name.grass_land_4_s29,
    0x770469: location_name.grass_land_4_s30,
    0x77046a: location_name.grass_land_4_s31,
    0x77046b: location_name.grass_land_4_s32,
    0x77046c: location_name.grass_land_4_s33,
    0x77046d: location_name.grass_land_4_s34,
    0x77046e: location_name.grass_land_4_s35,
    0x77046f: location_name.grass_land_4_s36,
    0x770470: location_name.grass_land_4_s37,
    0x770471: location_name.grass_land_5_s1,
    0x770472: location_name.grass_land_5_s2,
    0x770473: location_name.grass_land_5_s3,
    0x770474: location_name.grass_land_5_s4,
    0x770475: location_name.grass_land_5_s5,
    0x770476: location_name.grass_land_5_s6,
    0x770477: location_name.grass_land_5_s7,
    0x770478: location_name.grass_land_5_s8,
    0x770479: location_name.grass_land_5_s9,
    0x77047a: location_name.grass_land_5_s10,
    0x77047b: location_name.grass_land_5_s11,
    0x77047c: location_name.grass_land_5_s12,
    0x77047d: location_name.grass_land_5_s13,
    0x77047e: location_name.grass_land_5_s14,
    0x77047f: location_name.grass_land_5_s15,
    0x770480: location_name.grass_land_5_s16,
    0x770481: location_name.grass_land_5_s17,
    0x770482: location_name.grass_land_5_s18,
    0x770483: location_name.grass_land_5_s19,
    0x770484: location_name.grass_land_5_s20,
    0x770485: location_name.grass_land_5_s21,
    0x770486: location_name.grass_land_5_s22,
    0x770487: location_name.grass_land_5_s23,
    0x770488: location_name.grass_land_5_s24,
    0x770489: location_name.grass_land_5_s25,
    0x77048a: location_name.grass_land_5_s26,
    0x77048b: location_name.grass_land_5_s27,
    0x77048c: location_name.grass_land_5_s28,
    0x77048d: location_name.grass_land_5_s29,
    0x77048e: location_name.grass_land_6_s1,
    0x77048f: location_name.grass_land_6_s2,
    0x770490: location_name.grass_land_6_s3,
    0x770491: location_name.grass_land_6_s4,
    0x770492: location_name.grass_land_6_s5,
    0x770493: location_name.grass_land_6_s6,
    0x770494: location_name.grass_land_6_s7,
    0x770495: location_name.grass_land_6_s8,
    0x770496: location_name.grass_land_6_s9,
    0x770497: location_name.grass_land_6_s10,
    0x770498: location_name.grass_land_6_s11,
    0x770499: location_name.grass_land_6_s12,
    0x77049a: location_name.grass_land_6_s13,
    0x77049b: location_name.grass_land_6_s14,
    0x77049c: location_name.grass_land_6_s15,
    0x77049d: location_name.grass_land_6_s16,
    0x77049e: location_name.grass_land_6_s17,
    0x77049f: location_name.grass_land_6_s18,
    0x7704a0: location_name.grass_land_6_s19,
    0x7704a1: location_name.grass_land_6_s20,
    0x7704a2: location_name.grass_land_6_s21,
    0x7704a3: location_name.grass_land_6_s22,
    0x7704a4: location_name.grass_land_6_s23,
    0x7704a5: location_name.grass_land_6_s24,
    0x7704a6: location_name.grass_land_6_s25,
    0x7704a7: location_name.grass_land_6_s26,
    0x7704a8: location_name.grass_land_6_s27,
    0x7704a9: location_name.grass_land_6_s28,
    0x7704aa: location_name.grass_land_6_s29,
    0x7704ab: location_name.ripple_field_1_s1,
    0x7704ac: location_name.ripple_field_1_s2,
    0x7704ad: location_name.ripple_field_1_s3,
    0x7704ae: location_name.ripple_field_1_s4,
    0x7704af: location_name.ripple_field_1_s5,
    0x7704b0: location_name.ripple_field_1_s6,
    0x7704b1: location_name.ripple_field_1_s7,
    0x7704b2: location_name.ripple_field_1_s8,
    0x7704b3: location_name.ripple_field_1_s9,
    0x7704b4: location_name.ripple_field_1_s10,
    0x7704b5: location_name.ripple_field_1_s11,
    0x7704b6: location_name.ripple_field_1_s12,
    0x7704b7: location_name.ripple_field_1_s13,
    0x7704b8: location_name.ripple_field_1_s14,
    0x7704b9: location_name.ripple_field_1_s15,
    0x7704ba: location_name.ripple_field_1_s16,
    0x7704bb: location_name.ripple_field_1_s17,
    0x7704bc: location_name.ripple_field_1_s18,
    0x7704bd: location_name.ripple_field_1_s19,
    0x7704be: location_name.ripple_field_2_s1,
    0x7704bf: location_name.ripple_field_2_s2,
    0x7704c0: location_name.ripple_field_2_s3,
    0x7704c1: location_name.ripple_field_2_s4,
    0x7704c2: location_name.ripple_field_2_s5,
    0x7704c3: location_name.ripple_field_2_s6,
    0x7704c4: location_name.ripple_field_2_s7,
    0x7704c5: location_name.ripple_field_2_s8,
    0x7704c6: location_name.ripple_field_2_s9,
    0x7704c7: location_name.ripple_field_2_s10,
    0x7704c8: location_name.ripple_field_2_s11,
    0x7704c9: location_name.ripple_field_2_s12,
    0x7704ca: location_name.ripple_field_2_s13,
    0x7704cb: location_name.ripple_field_2_s14,
    0x7704cc: location_name.ripple_field_2_s15,
    0x7704cd: location_name.ripple_field_2_s16,
    0x7704ce: location_name.ripple_field_2_s17,
    0x7704cf: location_name.ripple_field_3_s1,
    0x7704d0: location_name.ripple_field_3_s2,
    0x7704d1: location_name.ripple_field_3_s3,
    0x7704d2: location_name.ripple_field_3_s4,
    0x7704d3: location_name.ripple_field_3_s5,
    0x7704d4: location_name.ripple_field_3_s6,
    0x7704d5: location_name.ripple_field_3_s7,
    0x7704d6: location_name.ripple_field_3_s8,
    0x7704d7: location_name.ripple_field_3_s9,
    0x7704d8: location_name.ripple_field_3_s10,
    0x7704d9: location_name.ripple_field_3_s11,
    0x7704da: location_name.ripple_field_3_s12,
    0x7704db: location_name.ripple_field_3_s13,
    0x7704dc: location_name.ripple_field_3_s14,
    0x7704dd: location_name.ripple_field_3_s15,
    0x7704de: location_name.ripple_field_3_s16,
    0x7704df: location_name.ripple_field_3_s17,
    0x7704e0: location_name.ripple_field_3_s18,
    0x7704e1: location_name.ripple_field_3_s19,
    0x7704e2: location_name.ripple_field_3_s20,
    0x7704e3: location_name.ripple_field_3_s21,
    0x7704e4: location_name.ripple_field_4_s1,
    0x7704e5: location_name.ripple_field_4_s2,
    0x7704e6: location_name.ripple_field_4_s3,
    0x7704e7: location_name.ripple_field_4_s4,
    0x7704e8: location_name.ripple_field_4_s5,
    0x7704e9: location_name.ripple_field_4_s6,
    0x7704ea: location_name.ripple_field_4_s7,
    0x7704eb: location_name.ripple_field_4_s8,
    0x7704ec: location_name.ripple_field_4_s9,
    0x7704ed: location_name.ripple_field_4_s10,
    0x7704ee: location_name.ripple_field_4_s11,
    0x7704ef: location_name.ripple_field_4_s12,
    0x7704f0: location_name.ripple_field_4_s13,
    0x7704f1: location_name.ripple_field_4_s14,
    0x7704f2: location_name.ripple_field_4_s15,
    0x7704f3: location_name.ripple_field_4_s16,
    0x7704f4: location_name.ripple_field_4_s17,
    0x7704f5: location_name.ripple_field_4_s18,
    0x7704f6: location_name.ripple_field_4_s19,
    0x7704f7: location_name.ripple_field_4_s20,
    0x7704f8: location_name.ripple_field_4_s21,
    0x7704f9: location_name.ripple_field_4_s22,
    0x7704fa: location_name.ripple_field_4_s23,
    0x7704fb: location_name.ripple_field_4_s24,
    0x7704fc: location_name.ripple_field_4_s25,
    0x7704fd: location_name.ripple_field_4_s26,
    0x7704fe: location_name.ripple_field_4_s27,
    0x7704ff: location_name.ripple_field_4_s28,
    0x770500: location_name.ripple_field_4_s29,
    0x770501: location_name.ripple_field_4_s30,
    0x770502: location_name.ripple_field_4_s31,
    0x770503: location_name.ripple_field_4_s32,
    0x770504: location_name.ripple_field_4_s33,
    0x770505: location_name.ripple_field_4_s34,
    0x770506: location_name.ripple_field_4_s35,
    0x770507: location_name.ripple_field_4_s36,
    0x770508: location_name.ripple_field_4_s37,
    0x770509: location_name.ripple_field_4_s38,
    0x77050a: location_name.ripple_field_4_s39,
    0x77050b: location_name.ripple_field_4_s40,
    0x77050c: location_name.ripple_field_4_s41,
    0x77050d: location_name.ripple_field_4_s42,
    0x77050e: location_name.ripple_field_4_s43,
    0x77050f: location_name.ripple_field_4_s44,
    0x770510: location_name.ripple_field_4_s45,
    0x770511: location_name.ripple_field_4_s46,
    0x770512: location_name.ripple_field_4_s47,
    0x770513: location_name.ripple_field_4_s48,
    0x770514: location_name.ripple_field_4_s49,
    0x770515: location_name.ripple_field_4_s50,
    0x770516: location_name.ripple_field_4_s51,
    0x770517: location_name.ripple_field_5_s1,
    0x770518: location_name.ripple_field_5_s2,
    0x770519: location_name.ripple_field_5_s3,
    0x77051a: location_name.ripple_field_5_s4,
    0x77051b: location_name.ripple_field_5_s5,
    0x77051c: location_name.ripple_field_5_s6,
    0x77051d: location_name.ripple_field_5_s7,
    0x77051e: location_name.ripple_field_5_s8,
    0x77051f: location_name.ripple_field_5_s9,
    0x770520: location_name.ripple_field_5_s10,
    0x770521: location_name.ripple_field_5_s11,
    0x770522: location_name.ripple_field_5_s12,
    0x770523: location_name.ripple_field_5_s13,
    0x770524: location_name.ripple_field_5_s14,
    0x770525: location_name.ripple_field_5_s15,
    0x770526: location_name.ripple_field_5_s16,
    0x770527: location_name.ripple_field_5_s17,
    0x770528: location_name.ripple_field_5_s18,
    0x770529: location_name.ripple_field_5_s19,
    0x77052a: location_name.ripple_field_5_s20,
    0x77052b: location_name.ripple_field_5_s21,
    0x77052c: location_name.ripple_field_5_s22,
    0x77052d: location_name.ripple_field_5_s23,
    0x77052e: location_name.ripple_field_5_s24,
    0x77052f: location_name.ripple_field_5_s25,
    0x770530: location_name.ripple_field_5_s26,
    0x770531: location_name.ripple_field_5_s27,
    0x770532: location_name.ripple_field_5_s28,
    0x770533: location_name.ripple_field_5_s29,
    0x770534: location_name.ripple_field_5_s30,
    0x770535: location_name.ripple_field_5_s31,
    0x770536: location_name.ripple_field_5_s32,
    0x770537: location_name.ripple_field_5_s33,
    0x770538: location_name.ripple_field_5_s34,
    0x770539: location_name.ripple_field_5_s35,
    0x77053a: location_name.ripple_field_5_s36,
    0x77053b: location_name.ripple_field_5_s37,
    0x77053c: location_name.ripple_field_5_s38,
    0x77053d: location_name.ripple_field_5_s39,
    0x77053e: location_name.ripple_field_5_s40,
    0x77053f: location_name.ripple_field_5_s41,
    0x770540: location_name.ripple_field_5_s42,
    0x770541: location_name.ripple_field_5_s43,
    0x770542: location_name.ripple_field_5_s44,
    0x770543: location_name.ripple_field_5_s45,
    0x770544: location_name.ripple_field_5_s46,
    0x770545: location_name.ripple_field_5_s47,
    0x770546: location_name.ripple_field_5_s48,
    0x770547: location_name.ripple_field_5_s49,
    0x770548: location_name.ripple_field_5_s50,
    0x770549: location_name.ripple_field_5_s51,
    0x77054a: location_name.ripple_field_6_s1,
    0x77054b: location_name.ripple_field_6_s2,
    0x77054c: location_name.ripple_field_6_s3,
    0x77054d: location_name.ripple_field_6_s4,
    0x77054e: location_name.ripple_field_6_s5,
    0x77054f: location_name.ripple_field_6_s6,
    0x770550: location_name.ripple_field_6_s7,
    0x770551: location_name.ripple_field_6_s8,
    0x770552: location_name.ripple_field_6_s9,
    0x770553: location_name.ripple_field_6_s10,
    0x770554: location_name.ripple_field_6_s11,
    0x770555: location_name.ripple_field_6_s12,
    0x770556: location_name.ripple_field_6_s13,
    0x770557: location_name.ripple_field_6_s14,
    0x770558: location_name.ripple_field_6_s15,
    0x770559: location_name.ripple_field_6_s16,
    0x77055a: location_name.ripple_field_6_s17,
    0x77055b: location_name.ripple_field_6_s18,
    0x77055c: location_name.ripple_field_6_s19,
    0x77055d: location_name.ripple_field_6_s20,
    0x77055e: location_name.ripple_field_6_s21,
    0x77055f: location_name.ripple_field_6_s22,
    0x770560: location_name.ripple_field_6_s23,
    0x770561: location_name.sand_canyon_1_s1,
    0x770562: location_name.sand_canyon_1_s2,
    0x770563: location_name.sand_canyon_1_s3,
    0x770564: location_name.sand_canyon_1_s4,
    0x770565: location_name.sand_canyon_1_s5,
    0x770566: location_name.sand_canyon_1_s6,
    0x770567: location_name.sand_canyon_1_s7,
    0x770568: location_name.sand_canyon_1_s8,
    0x770569: location_name.sand_canyon_1_s9,
    0x77056a: location_name.sand_canyon_1_s10,
    0x77056b: location_name.sand_canyon_1_s11,
    0x77056c: location_name.sand_canyon_1_s12,
    0x77056d: location_name.sand_canyon_1_s13,
    0x77056e: location_name.sand_canyon_1_s14,
    0x77056f: location_name.sand_canyon_1_s15,
    0x770570: location_name.sand_canyon_1_s16,
    0x770571: location_name.sand_canyon_1_s17,
    0x770572: location_name.sand_canyon_1_s18,
    0x770573: location_name.sand_canyon_1_s19,
    0x770574: location_name.sand_canyon_1_s20,
    0x770575: location_name.sand_canyon_1_s21,
    0x770576: location_name.sand_canyon_1_s22,
    0x770577: location_name.sand_canyon_2_s1,
    0x770578: location_name.sand_canyon_2_s2,
    0x770579: location_name.sand_canyon_2_s3,
    0x77057a: location_name.sand_canyon_2_s4,
    0x77057b: location_name.sand_canyon_2_s5,
    0x77057c: location_name.sand_canyon_2_s6,
    0x77057d: location_name.sand_canyon_2_s7,
    0x77057e: location_name.sand_canyon_2_s8,
    0x77057f: location_name.sand_canyon_2_s9,
    0x770580: location_name.sand_canyon_2_s10,
    0x770581: location_name.sand_canyon_2_s11,
    0x770582: location_name.sand_canyon_2_s12,
    0x770583: location_name.sand_canyon_2_s13,
    0x770584: location_name.sand_canyon_2_s14,
    0x770585: location_name.sand_canyon_2_s15,
    0x770586: location_name.sand_canyon_2_s16,
    0x770587: location_name.sand_canyon_2_s17,
    0x770588: location_name.sand_canyon_2_s18,
    0x770589: location_name.sand_canyon_2_s19,
    0x77058a: location_name.sand_canyon_2_s20,
    0x77058b: location_name.sand_canyon_2_s21,
    0x77058c: location_name.sand_canyon_2_s22,
    0x77058d: location_name.sand_canyon_2_s23,
    0x77058e: location_name.sand_canyon_2_s24,
    0x77058f: location_name.sand_canyon_2_s25,
    0x770590: location_name.sand_canyon_2_s26,
    0x770591: location_name.sand_canyon_2_s27,
    0x770592: location_name.sand_canyon_2_s28,
    0x770593: location_name.sand_canyon_2_s29,
    0x770594: location_name.sand_canyon_2_s30,
    0x770595: location_name.sand_canyon_2_s31,
    0x770596: location_name.sand_canyon_2_s32,
    0x770597: location_name.sand_canyon_2_s33,
    0x770598: location_name.sand_canyon_2_s34,
    0x770599: location_name.sand_canyon_2_s35,
    0x77059a: location_name.sand_canyon_2_s36,
    0x77059b: location_name.sand_canyon_2_s37,
    0x77059c: location_name.sand_canyon_2_s38,
    0x77059d: location_name.sand_canyon_2_s39,
    0x77059e: location_name.sand_canyon_2_s40,
    0x77059f: location_name.sand_canyon_2_s41,
    0x7705a0: location_name.sand_canyon_2_s42,
    0x7705a1: location_name.sand_canyon_2_s43,
    0x7705a2: location_name.sand_canyon_2_s44,
    0x7705a3: location_name.sand_canyon_2_s45,
    0x7705a4: location_name.sand_canyon_2_s46,
    0x7705a5: location_name.sand_canyon_2_s47,
    0x7705a6: location_name.sand_canyon_2_s48,
    0x7705a7: location_name.sand_canyon_3_s1,
    0x7705a8: location_name.sand_canyon_3_s2,
    0x7705a9: location_name.sand_canyon_3_s3,
    0x7705aa: location_name.sand_canyon_3_s4,
    0x7705ab: location_name.sand_canyon_3_s5,
    0x7705ac: location_name.sand_canyon_3_s6,
    0x7705ad: location_name.sand_canyon_3_s7,
    0x7705ae: location_name.sand_canyon_3_s8,
    0x7705af: location_name.sand_canyon_3_s9,
    0x7705b0: location_name.sand_canyon_3_s10,
    0x7705b1: location_name.sand_canyon_4_s1,
    0x7705b2: location_name.sand_canyon_4_s2,
    0x7705b3: location_name.sand_canyon_4_s3,
    0x7705b4: location_name.sand_canyon_4_s4,
    0x7705b5: location_name.sand_canyon_4_s5,
    0x7705b6: location_name.sand_canyon_4_s6,
    0x7705b7: location_name.sand_canyon_4_s7,
    0x7705b8: location_name.sand_canyon_4_s8,
    0x7705b9: location_name.sand_canyon_4_s9,
    0x7705ba: location_name.sand_canyon_4_s10,
    0x7705bb: location_name.sand_canyon_4_s11,
    0x7705bc: location_name.sand_canyon_4_s12,
    0x7705bd: location_name.sand_canyon_4_s13,
    0x7705be: location_name.sand_canyon_4_s14,
    0x7705bf: location_name.sand_canyon_4_s15,
    0x7705c0: location_name.sand_canyon_4_s16,
    0x7705c1: location_name.sand_canyon_4_s17,
    0x7705c2: location_name.sand_canyon_4_s18,
    0x7705c3: location_name.sand_canyon_4_s19,
    0x7705c4: location_name.sand_canyon_4_s20,
    0x7705c5: location_name.sand_canyon_4_s21,
    0x7705c6: location_name.sand_canyon_4_s22,
    0x7705c7: location_name.sand_canyon_4_s23,
    0x7705c8: location_name.sand_canyon_5_s1,
    0x7705c9: location_name.sand_canyon_5_s2,
    0x7705ca: location_name.sand_canyon_5_s3,
    0x7705cb: location_name.sand_canyon_5_s4,
    0x7705cc: location_name.sand_canyon_5_s5,
    0x7705cd: location_name.sand_canyon_5_s6,
    0x7705ce: location_name.sand_canyon_5_s7,
    0x7705cf: location_name.sand_canyon_5_s8,
    0x7705d0: location_name.sand_canyon_5_s9,
    0x7705d1: location_name.sand_canyon_5_s10,
    0x7705d2: location_name.sand_canyon_5_s11,
    0x7705d3: location_name.sand_canyon_5_s12,
    0x7705d4: location_name.sand_canyon_5_s13,
    0x7705d5: location_name.sand_canyon_5_s14,
    0x7705d6: location_name.sand_canyon_5_s15,
    0x7705d7: location_name.sand_canyon_5_s16,
    0x7705d8: location_name.sand_canyon_5_s17,
    0x7705d9: location_name.sand_canyon_5_s18,
    0x7705da: location_name.sand_canyon_5_s19,
    0x7705db: location_name.sand_canyon_5_s20,
    0x7705dc: location_name.sand_canyon_5_s21,
    0x7705dd: location_name.sand_canyon_5_s22,
    0x7705de: location_name.sand_canyon_5_s23,
    0x7705df: location_name.sand_canyon_5_s24,
    0x7705e0: location_name.sand_canyon_5_s25,
    0x7705e1: location_name.sand_canyon_5_s26,
    0x7705e2: location_name.sand_canyon_5_s27,
    0x7705e3: location_name.sand_canyon_5_s28,
    0x7705e4: location_name.sand_canyon_5_s29,
    0x7705e5: location_name.sand_canyon_5_s30,
    0x7705e6: location_name.sand_canyon_5_s31,
    0x7705e7: location_name.sand_canyon_5_s32,
    0x7705e8: location_name.sand_canyon_5_s33,
    0x7705e9: location_name.sand_canyon_5_s34,
    0x7705ea: location_name.sand_canyon_5_s35,
    0x7705eb: location_name.sand_canyon_5_s36,
    0x7705ec: location_name.sand_canyon_5_s37,
    0x7705ed: location_name.sand_canyon_5_s38,
    0x7705ee: location_name.sand_canyon_5_s39,
    0x7705ef: location_name.sand_canyon_5_s40,
    0x7705f0: location_name.cloudy_park_1_s1,
    0x7705f1: location_name.cloudy_park_1_s2,
    0x7705f2: location_name.cloudy_park_1_s3,
    0x7705f3: location_name.cloudy_park_1_s4,
    0x7705f4: location_name.cloudy_park_1_s5,
    0x7705f5: location_name.cloudy_park_1_s6,
    0x7705f6: location_name.cloudy_park_1_s7,
    0x7705f7: location_name.cloudy_park_1_s8,
    0x7705f8: location_name.cloudy_park_1_s9,
    0x7705f9: location_name.cloudy_park_1_s10,
    0x7705fa: location_name.cloudy_park_1_s11,
    0x7705fb: location_name.cloudy_park_1_s12,
    0x7705fc: location_name.cloudy_park_1_s13,
    0x7705fd: location_name.cloudy_park_1_s14,
    0x7705fe: location_name.cloudy_park_1_s15,
    0x7705ff: location_name.cloudy_park_1_s16,
    0x770600: location_name.cloudy_park_1_s17,
    0x770601: location_name.cloudy_park_1_s18,
    0x770602: location_name.cloudy_park_1_s19,
    0x770603: location_name.cloudy_park_1_s20,
    0x770604: location_name.cloudy_park_1_s21,
    0x770605: location_name.cloudy_park_1_s22,
    0x770606: location_name.cloudy_park_1_s23,
    0x770607: location_name.cloudy_park_2_s1,
    0x770608: location_name.cloudy_park_2_s2,
    0x770609: location_name.cloudy_park_2_s3,
    0x77060a: location_name.cloudy_park_2_s4,
    0x77060b: location_name.cloudy_park_2_s5,
    0x77060c: location_name.cloudy_park_2_s6,
    0x77060d: location_name.cloudy_park_2_s7,
    0x77060e: location_name.cloudy_park_2_s8,
    0x77060f: location_name.cloudy_park_2_s9,
    0x770610: location_name.cloudy_park_2_s10,
    0x770611: location_name.cloudy_park_2_s11,
    0x770612: location_name.cloudy_park_2_s12,
    0x770613: location_name.cloudy_park_2_s13,
    0x770614: location_name.cloudy_park_2_s14,
    0x770615: location_name.cloudy_park_2_s15,
    0x770616: location_name.cloudy_park_2_s16,
    0x770617: location_name.cloudy_park_2_s17,
    0x770618: location_name.cloudy_park_2_s18,
    0x770619: location_name.cloudy_park_2_s19,
    0x77061a: location_name.cloudy_park_2_s20,
    0x77061b: location_name.cloudy_park_2_s21,
    0x77061c: location_name.cloudy_park_2_s22,
    0x77061d: location_name.cloudy_park_2_s23,
    0x77061e: location_name.cloudy_park_2_s24,
    0x77061f: location_name.cloudy_park_2_s25,
    0x770620: location_name.cloudy_park_2_s26,
    0x770621: location_name.cloudy_park_2_s27,
    0x770622: location_name.cloudy_park_2_s28,
    0x770623: location_name.cloudy_park_2_s29,
    0x770624: location_name.cloudy_park_2_s30,
    0x770625: location_name.cloudy_park_2_s31,
    0x770626: location_name.cloudy_park_2_s32,
    0x770627: location_name.cloudy_park_2_s33,
    0x770628: location_name.cloudy_park_2_s34,
    0x770629: location_name.cloudy_park_2_s35,
    0x77062a: location_name.cloudy_park_2_s36,
    0x77062b: location_name.cloudy_park_2_s37,
    0x77062c: location_name.cloudy_park_2_s38,
    0x77062d: location_name.cloudy_park_2_s39,
    0x77062e: location_name.cloudy_park_2_s40,
    0x77062f: location_name.cloudy_park_2_s41,
    0x770630: location_name.cloudy_park_2_s42,
    0x770631: location_name.cloudy_park_2_s43,
    0x770632: location_name.cloudy_park_2_s44,
    0x770633: location_name.cloudy_park_2_s45,
    0x770634: location_name.cloudy_park_2_s46,
    0x770635: location_name.cloudy_park_2_s47,
    0x770636: location_name.cloudy_park_2_s48,
    0x770637: location_name.cloudy_park_2_s49,
    0x770638: location_name.cloudy_park_2_s50,
    0x770639: location_name.cloudy_park_2_s51,
    0x77063a: location_name.cloudy_park_2_s52,
    0x77063b: location_name.cloudy_park_2_s53,
    0x77063c: location_name.cloudy_park_2_s54,
    0x77063d: location_name.cloudy_park_3_s1,
    0x77063e: location_name.cloudy_park_3_s2,
    0x77063f: location_name.cloudy_park_3_s3,
    0x770640: location_name.cloudy_park_3_s4,
    0x770641: location_name.cloudy_park_3_s5,
    0x770642: location_name.cloudy_park_3_s6,
    0x770643: location_name.cloudy_park_3_s7,
    0x770644: location_name.cloudy_park_3_s8,
    0x770645: location_name.cloudy_park_3_s9,
    0x770646: location_name.cloudy_park_3_s10,
    0x770647: location_name.cloudy_park_3_s11,
    0x770648: location_name.cloudy_park_3_s12,
    0x770649: location_name.cloudy_park_3_s13,
    0x77064a: location_name.cloudy_park_3_s14,
    0x77064b: location_name.cloudy_park_3_s15,
    0x77064c: location_name.cloudy_park_3_s16,
    0x77064d: location_name.cloudy_park_3_s17,
    0x77064e: location_name.cloudy_park_3_s18,
    0x77064f: location_name.cloudy_park_3_s19,
    0x770650: location_name.cloudy_park_3_s20,
    0x770651: location_name.cloudy_park_3_s21,
    0x770652: location_name.cloudy_park_3_s22,
    0x770653: location_name.cloudy_park_4_s1,
    0x770654: location_name.cloudy_park_4_s2,
    0x770655: location_name.cloudy_park_4_s3,
    0x770656: location_name.cloudy_park_4_s4,
    0x770657: location_name.cloudy_park_4_s5,
    0x770658: location_name.cloudy_park_4_s6,
    0x770659: location_name.cloudy_park_4_s7,
    0x77065a: location_name.cloudy_park_4_s8,
    0x77065b: location_name.cloudy_park_4_s9,
    0x77065c: location_name.cloudy_park_4_s10,
    0x77065d: location_name.cloudy_park_4_s11,
    0x77065e: location_name.cloudy_park_4_s12,
    0x77065f: location_name.cloudy_park_4_s13,
    0x770660: location_name.cloudy_park_4_s14,
    0x770661: location_name.cloudy_park_4_s15,
    0x770662: location_name.cloudy_park_4_s16,
    0x770663: location_name.cloudy_park_4_s17,
    0x770664: location_name.cloudy_park_4_s18,
    0x770665: location_name.cloudy_park_4_s19,
    0x770666: location_name.cloudy_park_4_s20,
    0x770667: location_name.cloudy_park_4_s21,
    0x770668: location_name.cloudy_park_4_s22,
    0x770669: location_name.cloudy_park_4_s23,
    0x77066a: location_name.cloudy_park_4_s24,
    0x77066b: location_name.cloudy_park_4_s25,
    0x77066c: location_name.cloudy_park_4_s26,
    0x77066d: location_name.cloudy_park_4_s27,
    0x77066e: location_name.cloudy_park_4_s28,
    0x77066f: location_name.cloudy_park_4_s29,
    0x770670: location_name.cloudy_park_4_s30,
    0x770671: location_name.cloudy_park_4_s31,
    0x770672: location_name.cloudy_park_4_s32,
    0x770673: location_name.cloudy_park_4_s33,
    0x770674: location_name.cloudy_park_4_s34,
    0x770675: location_name.cloudy_park_4_s35,
    0x770676: location_name.cloudy_park_4_s36,
    0x770677: location_name.cloudy_park_4_s37,
    0x770678: location_name.cloudy_park_4_s38,
    0x770679: location_name.cloudy_park_4_s39,
    0x77067a: location_name.cloudy_park_4_s40,
    0x77067b: location_name.cloudy_park_4_s41,
    0x77067c: location_name.cloudy_park_4_s42,
    0x77067d: location_name.cloudy_park_4_s43,
    0x77067e: location_name.cloudy_park_4_s44,
    0x77067f: location_name.cloudy_park_4_s45,
    0x770680: location_name.cloudy_park_4_s46,
    0x770681: location_name.cloudy_park_4_s47,
    0x770682: location_name.cloudy_park_4_s48,
    0x770683: location_name.cloudy_park_4_s49,
    0x770684: location_name.cloudy_park_4_s50,
    0x770685: location_name.cloudy_park_5_s1,
    0x770686: location_name.cloudy_park_5_s2,
    0x770687: location_name.cloudy_park_5_s3,
    0x770688: location_name.cloudy_park_5_s4,
    0x770689: location_name.cloudy_park_5_s5,
    0x77068a: location_name.cloudy_park_5_s6,
    0x77068b: location_name.cloudy_park_6_s1,
    0x77068c: location_name.cloudy_park_6_s2,
    0x77068d: location_name.cloudy_park_6_s3,
    0x77068e: location_name.cloudy_park_6_s4,
    0x77068f: location_name.cloudy_park_6_s5,
    0x770690: location_name.cloudy_park_6_s6,
    0x770691: location_name.cloudy_park_6_s7,
    0x770692: location_name.cloudy_park_6_s8,
    0x770693: location_name.cloudy_park_6_s9,
    0x770694: location_name.cloudy_park_6_s10,
    0x770695: location_name.cloudy_park_6_s11,
    0x770696: location_name.cloudy_park_6_s12,
    0x770697: location_name.cloudy_park_6_s13,
    0x770698: location_name.cloudy_park_6_s14,
    0x770699: location_name.cloudy_park_6_s15,
    0x77069a: location_name.cloudy_park_6_s16,
    0x77069b: location_name.cloudy_park_6_s17,
    0x77069c: location_name.cloudy_park_6_s18,
    0x77069d: location_name.cloudy_park_6_s19,
    0x77069e: location_name.cloudy_park_6_s20,
    0x77069f: location_name.cloudy_park_6_s21,
    0x7706a0: location_name.cloudy_park_6_s22,
    0x7706a1: location_name.cloudy_park_6_s23,
    0x7706a2: location_name.cloudy_park_6_s24,
    0x7706a3: location_name.cloudy_park_6_s25,
    0x7706a4: location_name.cloudy_park_6_s26,
    0x7706a5: location_name.cloudy_park_6_s27,
    0x7706a6: location_name.cloudy_park_6_s28,
    0x7706a7: location_name.cloudy_park_6_s29,
    0x7706a8: location_name.cloudy_park_6_s30,
    0x7706a9: location_name.cloudy_park_6_s31,
    0x7706aa: location_name.cloudy_park_6_s32,
    0x7706ab: location_name.cloudy_park_6_s33,
    0x7706ac: location_name.iceberg_1_s1,
    0x7706ad: location_name.iceberg_1_s2,
    0x7706ae: location_name.iceberg_1_s3,
    0x7706af: location_name.iceberg_1_s4,
    0x7706b0: location_name.iceberg_1_s5,
    0x7706b1: location_name.iceberg_1_s6,
    0x7706b2: location_name.iceberg_2_s1,
    0x7706b3: location_name.iceberg_2_s2,
    0x7706b4: location_name.iceberg_2_s3,
    0x7706b5: location_name.iceberg_2_s4,
    0x7706b6: location_name.iceberg_2_s5,
    0x7706b7: location_name.iceberg_2_s6,
    0x7706b8: location_name.iceberg_2_s7,
    0x7706b9: location_name.iceberg_2_s8,
    0x7706ba: location_name.iceberg_2_s9,
    0x7706bb: location_name.iceberg_2_s10,
    0x7706bc: location_name.iceberg_2_s11,
    0x7706bd: location_name.iceberg_2_s12,
    0x7706be: location_name.iceberg_2_s13,
    0x7706bf: location_name.iceberg_2_s14,
    0x7706c0: location_name.iceberg_2_s15,
    0x7706c1: location_name.iceberg_2_s16,
    0x7706c2: location_name.iceberg_2_s17,
    0x7706c3: location_name.iceberg_2_s18,
    0x7706c4: location_name.iceberg_2_s19,
    0x7706c5: location_name.iceberg_3_s1,
    0x7706c6: location_name.iceberg_3_s2,
    0x7706c7: location_name.iceberg_3_s3,
    0x7706c8: location_name.iceberg_3_s4,
    0x7706c9: location_name.iceberg_3_s5,
    0x7706ca: location_name.iceberg_3_s6,
    0x7706cb: location_name.iceberg_3_s7,
    0x7706cc: location_name.iceberg_3_s8,
    0x7706cd: location_name.iceberg_3_s9,
    0x7706ce: location_name.iceberg_3_s10,
    0x7706cf: location_name.iceberg_3_s11,
    0x7706d0: location_name.iceberg_3_s12,
    0x7706d1: location_name.iceberg_3_s13,
    0x7706d2: location_name.iceberg_3_s14,
    0x7706d3: location_name.iceberg_3_s15,
    0x7706d4: location_name.iceberg_3_s16,
    0x7706d5: location_name.iceberg_3_s17,
    0x7706d6: location_name.iceberg_3_s18,
    0x7706d7: location_name.iceberg_3_s19,
    0x7706d8: location_name.iceberg_3_s20,
    0x7706d9: location_name.iceberg_3_s21,
    0x7706da: location_name.iceberg_4_s1,
    0x7706db: location_name.iceberg_4_s2,
    0x7706dc: location_name.iceberg_4_s3,
    0x7706dd: location_name.iceberg_5_s1,
    0x7706de: location_name.iceberg_5_s2,
    0x7706df: location_name.iceberg_5_s3,
    0x7706e0: location_name.iceberg_5_s4,
    0x7706e1: location_name.iceberg_5_s5,
    0x7706e2: location_name.iceberg_5_s6,
    0x7706e3: location_name.iceberg_5_s7,
    0x7706e4: location_name.iceberg_5_s8,
    0x7706e5: location_name.iceberg_5_s9,
    0x7706e6: location_name.iceberg_5_s10,
    0x7706e7: location_name.iceberg_5_s11,
    0x7706e8: location_name.iceberg_5_s12,
    0x7706e9: location_name.iceberg_5_s13,
    0x7706ea: location_name.iceberg_5_s14,
    0x7706eb: location_name.iceberg_5_s15,
    0x7706ec: location_name.iceberg_5_s16,
    0x7706ed: location_name.iceberg_5_s17,
    0x7706ee: location_name.iceberg_5_s18,
    0x7706ef: location_name.iceberg_5_s19,
    0x7706f0: location_name.iceberg_5_s20,
    0x7706f1: location_name.iceberg_5_s21,
    0x7706f2: location_name.iceberg_5_s22,
    0x7706f3: location_name.iceberg_5_s23,
    0x7706f4: location_name.iceberg_5_s24,
    0x7706f5: location_name.iceberg_5_s25,
    0x7706f6: location_name.iceberg_5_s26,
    0x7706f7: location_name.iceberg_5_s27,
    0x7706f8: location_name.iceberg_5_s28,
    0x7706f9: location_name.iceberg_5_s29,
    0x7706fa: location_name.iceberg_5_s30,
    0x7706fb: location_name.iceberg_5_s31,
    0x7706fc: location_name.iceberg_5_s32,
    0x7706fd: location_name.iceberg_5_s33,
    0x7706fe: location_name.iceberg_5_s34,
    0x7706ff: location_name.iceberg_6_s1,

}

location_table = {
    **stage_locations,
    **heart_star_locations,
    **boss_locations,
    **consumable_locations,
    **star_locations
}
