from typing import Any, Dict

import Options as ap_options
from . import options
# @formatter:off
from .jojapocalypse_options import Jojapocalypse, JojaStartPrice, JojaEndPrice, JojaPricingPattern, JojaPurchasesForMembership, JojaAreYouSure
from ..strings.ap_names.ap_option_names import EatsanityOptionName, ChefsanityOptionName, HatsanityOptionName

all_random_settings = {
    "progression_balancing":                            "random",
    "accessibility":                                    "random",
    options.Goal.internal_name:                         "random",
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "random",
    options.ProfitMargin.internal_name:                 "random",
    options.BundleRandomization.internal_name:          "random",
    options.BundlePrice.internal_name:                  "random",
    options.BundlePerRoom.internal_name:                "random",
    options.EntranceRandomization.internal_name:        "random",
    options.SeasonRandomization.internal_name:          "random",
    options.Cropsanity.internal_name:                   "random",
    options.BackpackProgression.internal_name:          "random",
    options.BackpackSize.internal_name:                 "random",
    options.ToolProgression.internal_name:              "random",
    options.ElevatorProgression.internal_name:          "random",
    options.SkillProgression.internal_name:             "random",
    options.BuildingProgression.internal_name:          "random",
    options.FestivalLocations.internal_name:            "random",
    options.ArcadeMachineLocations.internal_name:       "random",
    options.SpecialOrderLocations.internal_name:        "random",
    options.QuestLocations.internal_name:               "random",
    options.Fishsanity.internal_name:                   "random",
    options.Museumsanity.internal_name:                 "random",
    options.Monstersanity.internal_name:                "random",
    options.Shipsanity.internal_name:                   "random",
    options.Cooksanity.internal_name:                   "random",
    options.Craftsanity.internal_name:                  "random",
    options.Friendsanity.internal_name:                 "random",
    options.FriendsanityHeartSize.internal_name:        "random",
    options.Booksanity.internal_name:                   "random",
    options.Moviesanity.internal_name:                  "random",
    options.IncludeEndgameLocations.internal_name:      "random",
    options.NumberOfMovementBuffs.internal_name:        "random",
    options.ExcludeGingerIsland.internal_name:          "random",
    options.TrapDifficulty.internal_name:               "random",
    options.MultipleDaySleepEnabled.internal_name:      "random",
    options.MultipleDaySleepCost.internal_name:         "random",
    options.ExperienceMultiplier.internal_name:         "random",
    options.FriendshipMultiplier.internal_name:         "random",
    options.DebrisMultiplier.internal_name:             "random",
    options.QuickStart.internal_name:                   "random",
    options.Gifting.internal_name:                      "random",
    "death_link":                                       "random",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

easy_settings = {
    options.Goal.internal_name:                         options.Goal.option_community_center,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "very rich",
    options.ProfitMargin.internal_name:                 "double",
    options.BundleRandomization.internal_name:          options.BundleRandomization.option_thematic,
    options.BundlePrice.internal_name:                  options.BundlePrice.option_cheap,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_one_fewer,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_disabled,
    options.StartWithout.internal_name:                 options.StartWithout.preset_none,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized_not_winter,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_enabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_early_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive_very_cheap,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive_very_cheap,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_easy,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_disabled,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_vanilla_very_short,
    options.QuestLocations.internal_name:               "minimum",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_only_easy_fish,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_milestones,
    options.Monstersanity.internal_name:                options.Monstersanity.option_one_per_category,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_none,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_none,
    options.Chefsanity.internal_name:                   options.Chefsanity.preset_none,
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_none,
    options.FriendsanityHeartSize.internal_name:        4,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_none,
    options.Booksanity.internal_name:                   options.Booksanity.option_none,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_none,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_none,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_none,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_none,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_false,
    options.NumberOfMovementBuffs.internal_name:        8,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.preset_all,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_true,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.option_easy,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.option_true,
    options.MultipleDaySleepCost.internal_name:         "free",
    options.ExperienceMultiplier.internal_name:         "triple",
    options.FriendshipMultiplier.internal_name:         "quadruple",
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.option_quarter,
    options.QuickStart.internal_name:                   options.QuickStart.option_true,
    options.Gifting.internal_name:                      options.Gifting.option_true,
    "death_link":                                       "false",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

medium_settings = {
    options.Goal.internal_name:                         options.Goal.option_community_center,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "rich",
    options.ProfitMargin.internal_name:                 150,
    options.BundleRandomization.internal_name:          options.BundleRandomization.option_remixed,
    options.BundlePrice.internal_name:                  options.BundlePrice.option_normal,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_normal,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_non_progression,
    options.StartWithout.internal_name:                 options.StartWithout.preset_easy,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_enabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_early_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive_cheap,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive_cheap,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_hard,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_victories_easy,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_board_short,
    options.QuestLocations.internal_name:               "normal",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_exclude_legendaries,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_milestones,
    options.Monstersanity.internal_name:                options.Monstersanity.option_one_per_monster,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_none,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_none,
    options.Chefsanity.internal_name:                   frozenset([ChefsanityOptionName.queen_of_sauce]),
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_starting_npcs,
    options.FriendsanityHeartSize.internal_name:        4,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_none,
    options.Booksanity.internal_name:                   options.Booksanity.option_power_skill,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_none,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_none,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_none,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_none,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_false,
    options.NumberOfMovementBuffs.internal_name:        6,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.preset_all,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_true,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.option_medium,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.option_true,
    options.MultipleDaySleepCost.internal_name:         "free",
    options.ExperienceMultiplier.internal_name:         "double",
    options.FriendshipMultiplier.internal_name:         "triple",
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.option_half,
    options.QuickStart.internal_name:                   options.QuickStart.option_true,
    options.Gifting.internal_name:                      options.Gifting.option_true,
    "death_link":                                       "false",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

hard_settings = {
    options.Goal.internal_name:                         options.Goal.option_grandpa_evaluation,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "extra",
    options.ProfitMargin.internal_name:                 "normal",
    options.BundleRandomization.internal_name:          options.BundleRandomization.option_remixed,
    options.BundlePrice.internal_name:                  options.BundlePrice.option_expensive,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_one_extra,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_buildings_without_house,
    options.StartWithout.internal_name:                 options.StartWithout.preset_easy,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_enabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive_from_previous_floor,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive_with_masteries,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_hard,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_full_shuffling,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_board_qi_short,
    options.QuestLocations.internal_name:               "lots",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_all,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_all,
    options.Monstersanity.internal_name:                options.Monstersanity.option_progressive_goals,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_crops,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_queen_of_sauce,
    options.Chefsanity.internal_name:                   frozenset([ChefsanityOptionName.queen_of_sauce, ChefsanityOptionName.purchases]),
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_all,
    options.FriendsanityHeartSize.internal_name:        4,
    options.Eatsanity.internal_name:                    frozenset([EatsanityOptionName.crops, EatsanityOptionName.fish, EatsanityOptionName.artisan]),
    options.Booksanity.internal_name:                   options.Booksanity.option_all,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_all,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_all_movies,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_simple,
    options.Hatsanity.internal_name:                    frozenset([HatsanityOptionName.easy]),
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_false,
    options.NumberOfMovementBuffs.internal_name:        4,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.default,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_false,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.option_hard,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.option_true,
    options.MultipleDaySleepCost.internal_name:         "cheap",
    options.ExperienceMultiplier.internal_name:         "vanilla",
    options.FriendshipMultiplier.internal_name:         "double",
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.option_vanilla,
    options.QuickStart.internal_name:                   options.QuickStart.option_true,
    options.Gifting.internal_name:                      options.Gifting.option_true,
    "death_link":                                       "true",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

nightmare_settings = {
    options.Goal.internal_name:                         options.Goal.option_community_center,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "vanilla",
    options.ProfitMargin.internal_name:                 "half",
    options.BundleRandomization.internal_name:          options.BundleRandomization.option_shuffled,
    options.BundlePrice.internal_name:                  options.BundlePrice.option_very_expensive,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_two_extra,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_buildings,
    options.StartWithout.internal_name:                 options.StartWithout.preset_all,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_enabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive_from_previous_floor,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive_with_masteries,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_hard,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_full_shuffling,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_board_qi,
    options.QuestLocations.internal_name:               "maximum",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_special,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_all,
    options.Monstersanity.internal_name:                options.Monstersanity.option_split_goals,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_full_shipment_with_fish,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_queen_of_sauce,
    options.Chefsanity.internal_name:                   frozenset([ChefsanityOptionName.queen_of_sauce, ChefsanityOptionName.purchases]),
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_all_with_marriage,
    options.FriendsanityHeartSize.internal_name:        4,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_all,
    options.Booksanity.internal_name:                   options.Booksanity.option_all,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_all,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_all_movies_and_all_loved_snacks,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_all,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_difficult,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_true,
    options.NumberOfMovementBuffs.internal_name:        2,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.preset_none,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_false,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.option_hell,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.option_true,
    options.MultipleDaySleepCost.internal_name:         "expensive",
    options.ExperienceMultiplier.internal_name:         "half",
    options.FriendshipMultiplier.internal_name:         "vanilla",
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.option_vanilla,
    options.QuickStart.internal_name:                   options.QuickStart.option_false,
    options.Gifting.internal_name:                      options.Gifting.option_true,
    "death_link":                                       "true",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

short_settings = {
    options.Goal.internal_name:                         options.Goal.option_bottom_of_the_mines,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                "filthy rich",
    options.ProfitMargin.internal_name:                 "quadruple",
    options.BundleRandomization.internal_name:          options.BundleRandomization.option_remixed,
    options.BundlePrice.internal_name:                  options.BundlePrice.option_minimum,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_two_fewer,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_disabled,
    options.StartWithout.internal_name:                 options.StartWithout.preset_none,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized_not_winter,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_disabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_early_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive_very_cheap,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive_very_cheap,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_disabled,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_disabled,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_vanilla_very_short,
    options.QuestLocations.internal_name:               "none",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_none,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_none,
    options.Monstersanity.internal_name:                options.Monstersanity.option_none,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_none,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_none,
    options.Chefsanity.internal_name:                   options.Chefsanity.preset_none,
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_none,
    options.FriendsanityHeartSize.internal_name:        4,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_none,
    options.Booksanity.internal_name:                   options.Booksanity.option_none,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_none,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_none,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_none,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_none,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_false,
    options.NumberOfMovementBuffs.internal_name:        10,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.preset_all,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_true,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.option_easy,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.option_true,
    options.MultipleDaySleepCost.internal_name:         "free",
    options.ExperienceMultiplier.internal_name:         "quadruple",
    options.FriendshipMultiplier.internal_name:         800,
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.option_none,
    options.QuickStart.internal_name:                   options.QuickStart.option_true,
    options.Gifting.internal_name:                      options.Gifting.option_true,
    "death_link":                                       "false",

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

minsanity_settings = {
    options.Goal.internal_name:                         options.Goal.default,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                options.StartingMoney.default,
    options.ProfitMargin.internal_name:                 options.ProfitMargin.default,
    options.BundleRandomization.internal_name:          options.BundleRandomization.default,
    options.BundlePrice.internal_name:                  options.BundlePrice.default,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_two_fewer,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.default,
    options.StartWithout.internal_name:                 options.StartWithout.preset_none,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_disabled,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_disabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_vanilla,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_12,
    options.ToolProgression.internal_name:              options.ToolProgression.option_vanilla,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_vanilla,
    options.SkillProgression.internal_name:             options.SkillProgression.option_vanilla,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_vanilla,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_disabled,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_disabled,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_vanilla_very_short,
    options.QuestLocations.internal_name:               "none",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_none,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_none,
    options.Monstersanity.internal_name:                options.Monstersanity.option_none,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_none,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_none,
    options.Chefsanity.internal_name:                   options.Chefsanity.preset_none,
    options.Craftsanity.internal_name:                  options.Craftsanity.option_none,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_none,
    options.FriendsanityHeartSize.internal_name:        options.FriendsanityHeartSize.default,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_none,
    options.Booksanity.internal_name:                   options.Booksanity.option_none,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_none,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_none,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_none,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_none,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_false,
    options.NumberOfMovementBuffs.internal_name:        options.NumberOfMovementBuffs.default,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.default,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_true,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.default,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.default,
    options.MultipleDaySleepCost.internal_name:         options.MultipleDaySleepCost.default,
    options.ExperienceMultiplier.internal_name:         options.ExperienceMultiplier.default,
    options.FriendshipMultiplier.internal_name:         options.FriendshipMultiplier.default,
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.default,
    options.QuickStart.internal_name:                   options.QuickStart.default,
    options.Gifting.internal_name:                      options.Gifting.default,
    "death_link":                                       ap_options.DeathLink.default,

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}

allsanity_settings = {
    options.Goal.internal_name:                         options.Goal.default,
    options.FarmType.internal_name:                     "random",
    options.StartingMoney.internal_name:                options.StartingMoney.default,
    options.ProfitMargin.internal_name:                 options.ProfitMargin.default,
    options.BundleRandomization.internal_name:          options.BundleRandomization.default,
    options.BundlePrice.internal_name:                  options.BundlePrice.default,
    options.BundlePerRoom.internal_name:                options.BundlePerRoom.option_two_extra,
    options.EntranceRandomization.internal_name:        options.EntranceRandomization.option_buildings,
    options.StartWithout.internal_name:                 options.StartWithout.preset_all,
    options.SeasonRandomization.internal_name:          options.SeasonRandomization.option_randomized,
    options.Cropsanity.internal_name:                   options.Cropsanity.option_enabled,
    options.BackpackProgression.internal_name:          options.BackpackProgression.option_early_progressive,
    options.BackpackSize.internal_name:                 options.BackpackSize.option_1,
    options.ToolProgression.internal_name:              options.ToolProgression.option_progressive,
    options.ElevatorProgression.internal_name:          options.ElevatorProgression.option_progressive,
    options.SkillProgression.internal_name:             options.SkillProgression.option_progressive_with_masteries,
    options.BuildingProgression.internal_name:          options.BuildingProgression.option_progressive,
    options.FestivalLocations.internal_name:            options.FestivalLocations.option_hard,
    options.ArcadeMachineLocations.internal_name:       options.ArcadeMachineLocations.option_full_shuffling,
    options.SpecialOrderLocations.internal_name:        options.SpecialOrderLocations.option_board_qi,
    options.QuestLocations.internal_name:               "maximum",
    options.Fishsanity.internal_name:                   options.Fishsanity.option_all,
    options.Museumsanity.internal_name:                 options.Museumsanity.option_all,
    options.Monstersanity.internal_name:                options.Monstersanity.option_progressive_goals,
    options.Shipsanity.internal_name:                   options.Shipsanity.option_everything,
    options.Cooksanity.internal_name:                   options.Cooksanity.option_all,
    options.Chefsanity.internal_name:                   options.Chefsanity.preset_all,
    options.Craftsanity.internal_name:                  options.Craftsanity.option_all,
    options.Friendsanity.internal_name:                 options.Friendsanity.option_all,
    options.FriendsanityHeartSize.internal_name:        1,
    options.Eatsanity.internal_name:                    options.Eatsanity.preset_all,
    options.Booksanity.internal_name:                   options.Booksanity.option_all,
    options.Walnutsanity.internal_name:                 options.Walnutsanity.preset_all,
    options.Moviesanity.internal_name:                  options.Moviesanity.option_all_movies_and_all_loved_snacks,
    options.Secretsanity.internal_name:                 options.Secretsanity.preset_all,
    options.Hatsanity.internal_name:                    options.Hatsanity.preset_all,
    options.IncludeEndgameLocations.internal_name:      options.IncludeEndgameLocations.option_true,
    options.NumberOfMovementBuffs.internal_name:        12,
    options.EnabledFillerBuffs.internal_name:           options.EnabledFillerBuffs.preset_all,
    options.ExcludeGingerIsland.internal_name:          options.ExcludeGingerIsland.option_false,
    options.TrapDifficulty.internal_name:               options.TrapDifficulty.default,
    options.MultipleDaySleepEnabled.internal_name:      options.MultipleDaySleepEnabled.default,
    options.MultipleDaySleepCost.internal_name:         options.MultipleDaySleepCost.default,
    options.ExperienceMultiplier.internal_name:         options.ExperienceMultiplier.default,
    options.FriendshipMultiplier.internal_name:         options.FriendshipMultiplier.default,
    options.DebrisMultiplier.internal_name:             options.DebrisMultiplier.default,
    options.QuickStart.internal_name:                   options.QuickStart.default,
    options.Gifting.internal_name:                      options.Gifting.default,
    "death_link":                                       ap_options.DeathLink.default,

    options.Jojapocalypse.internal_name:                Jojapocalypse.option_disabled,
    options.JojaStartPrice.internal_name:               JojaStartPrice.default,
    options.JojaEndPrice.internal_name:                 JojaEndPrice.default,
    options.JojaPricingPattern.internal_name:           JojaPricingPattern.default,
    options.JojaPurchasesForMembership.internal_name:   JojaPurchasesForMembership.default,
    options.JojaAreYouSure.internal_name:               JojaAreYouSure.option_false,
}
# @formatter:on


sv_options_presets: Dict[str, Dict[str, Any]] = {
    "All random": all_random_settings,
    "Easy": easy_settings,
    "Medium": medium_settings,
    "Hard": hard_settings,
    "Nightmare": nightmare_settings,
    "Short": short_settings,
    "Minsanity": minsanity_settings,
    "Allsanity": allsanity_settings,
}
