import typing

from BaseClasses import Location
from worlds.AutoWorld import World
from .Names import LocationName

class SMWLocation(Location):
    game: str = "Super Mario World"

    def __init__(self, player: int, name: str = '', address: int = None, parent=None, prog_byte: int = None, prog_bit: int = None):
        super().__init__(player, name, address, parent)
        self.progress_byte = prog_byte
        self.progress_bit  = prog_bit


level_location_table = {
    LocationName.yoshis_island_1_exit_1:  0xBC0000,
    LocationName.yoshis_island_2_exit_1:  0xBC0001,
    LocationName.yoshis_island_3_exit_1:  0xBC0002,
    LocationName.yoshis_island_4_exit_1:  0xBC0003,
    LocationName.yoshis_island_castle:    0xBC0004,
    LocationName.yoshis_island_koopaling: 0xBC00A0,

    LocationName.yellow_switch_palace: 0xBC0005,

    LocationName.donut_plains_1_exit_1:     0xBC0006,
    LocationName.donut_plains_1_exit_2:     0xBC0007,
    LocationName.donut_plains_2_exit_1:     0xBC0008,
    LocationName.donut_plains_2_exit_2:     0xBC0009,
    LocationName.donut_plains_3_exit_1:     0xBC000A,
    LocationName.donut_plains_4_exit_1:     0xBC000B,
    LocationName.donut_secret_1_exit_1:     0xBC000C,
    LocationName.donut_secret_1_exit_2:     0xBC000D,
    LocationName.donut_secret_2_exit_1:     0xBC0063,
    LocationName.donut_ghost_house_exit_1:  0xBC000E,
    LocationName.donut_ghost_house_exit_2:  0xBC000F,
    LocationName.donut_secret_house_exit_1: 0xBC0010,
    LocationName.donut_secret_house_exit_2: 0xBC0011,
    LocationName.donut_plains_castle:       0xBC0012,
    LocationName.donut_plains_koopaling:    0xBC00A1,

    LocationName.green_switch_palace: 0xBC0013,

    LocationName.vanilla_dome_1_exit_1:      0xBC0014,
    LocationName.vanilla_dome_1_exit_2:      0xBC0015,
    LocationName.vanilla_dome_2_exit_1:      0xBC0016,
    LocationName.vanilla_dome_2_exit_2:      0xBC0017,
    LocationName.vanilla_dome_3_exit_1:      0xBC0018,
    LocationName.vanilla_dome_4_exit_1:      0xBC0019,
    LocationName.vanilla_secret_1_exit_1:    0xBC001A,
    LocationName.vanilla_secret_1_exit_2:    0xBC001B,
    LocationName.vanilla_secret_2_exit_1:    0xBC001C,
    LocationName.vanilla_secret_3_exit_1:    0xBC001D,
    LocationName.vanilla_ghost_house_exit_1: 0xBC001E,
    LocationName.vanilla_fortress:           0xBC0020,
    LocationName.vanilla_reznor:             0xBC00B0,
    LocationName.vanilla_dome_castle:        0xBC0021,
    LocationName.vanilla_dome_koopaling:     0xBC00A2,

    LocationName.red_switch_palace: 0xBC0022,

    LocationName.butter_bridge_1_exit_1: 0xBC0023,
    LocationName.butter_bridge_2_exit_1: 0xBC0024,
    LocationName.cheese_bridge_exit_1:   0xBC0025,
    LocationName.cheese_bridge_exit_2:   0xBC0026,
    LocationName.cookie_mountain_exit_1: 0xBC0027,
    LocationName.soda_lake_exit_1:       0xBC0028,
    LocationName.twin_bridges_castle:    0xBC0029,
    LocationName.twin_bridges_koopaling: 0xBC00A3,

    LocationName.forest_of_illusion_1_exit_1: 0xBC002A,
    LocationName.forest_of_illusion_1_exit_2: 0xBC002B,
    LocationName.forest_of_illusion_2_exit_1: 0xBC002C,
    LocationName.forest_of_illusion_2_exit_2: 0xBC002D,
    LocationName.forest_of_illusion_3_exit_1: 0xBC002E,
    LocationName.forest_of_illusion_3_exit_2: 0xBC002F,
    LocationName.forest_of_illusion_4_exit_1: 0xBC0030,
    LocationName.forest_of_illusion_4_exit_2: 0xBC0031,
    LocationName.forest_ghost_house_exit_1:   0xBC0032,
    LocationName.forest_ghost_house_exit_2:   0xBC0033,
    LocationName.forest_secret_exit_1:        0xBC0034,
    LocationName.forest_fortress:             0xBC0035,
    LocationName.forest_reznor:               0xBC00B1,
    LocationName.forest_castle:               0xBC0036,
    LocationName.forest_koopaling:            0xBC00A4,

    LocationName.blue_switch_palace:      0xBC0037,

    LocationName.chocolate_island_1_exit_1:    0xBC0038,
    LocationName.chocolate_island_2_exit_1:    0xBC0039,
    LocationName.chocolate_island_2_exit_2:    0xBC003A,
    LocationName.chocolate_island_3_exit_1:    0xBC003B,
    LocationName.chocolate_island_3_exit_2:    0xBC003C,
    LocationName.chocolate_island_4_exit_1:    0xBC003D,
    LocationName.chocolate_island_5_exit_1:    0xBC003E,
    LocationName.chocolate_ghost_house_exit_1: 0xBC003F,
    LocationName.chocolate_secret_exit_1:      0xBC0041,
    LocationName.chocolate_fortress:           0xBC0042,
    LocationName.chocolate_reznor:             0xBC00B2,
    LocationName.chocolate_castle:             0xBC0043,
    LocationName.chocolate_koopaling:          0xBC00A5,

    LocationName.sunken_ghost_ship:    0xBC0044,

    LocationName.valley_of_bowser_1_exit_1: 0xBC0045,
    LocationName.valley_of_bowser_2_exit_1: 0xBC0046,
    LocationName.valley_of_bowser_2_exit_2: 0xBC0047,
    LocationName.valley_of_bowser_3_exit_1: 0xBC0048,
    LocationName.valley_of_bowser_4_exit_1: 0xBC0049,
    LocationName.valley_of_bowser_4_exit_2: 0xBC004A,
    LocationName.valley_ghost_house_exit_1: 0xBC004B,
    LocationName.valley_ghost_house_exit_2: 0xBC004C,
    LocationName.valley_fortress:           0xBC004E,
    LocationName.valley_reznor:             0xBC00B3,
    LocationName.valley_castle:             0xBC004F,
    LocationName.valley_koopaling:          0xBC00A6,

    LocationName.star_road_1_exit_1: 0xBC0051,
    LocationName.star_road_1_exit_2: 0xBC0052,
    LocationName.star_road_2_exit_1: 0xBC0053,
    LocationName.star_road_2_exit_2: 0xBC0054,
    LocationName.star_road_3_exit_1: 0xBC0055,
    LocationName.star_road_3_exit_2: 0xBC0056,
    LocationName.star_road_4_exit_1: 0xBC0057,
    LocationName.star_road_4_exit_2: 0xBC0058,
    LocationName.star_road_5_exit_1: 0xBC0059,
    LocationName.star_road_5_exit_2: 0xBC005A,

    LocationName.special_zone_1_exit_1: 0xBC005B,
    LocationName.special_zone_2_exit_1: 0xBC005C,
    LocationName.special_zone_3_exit_1: 0xBC005D,
    LocationName.special_zone_4_exit_1: 0xBC005E,
    LocationName.special_zone_5_exit_1: 0xBC005F,
    LocationName.special_zone_6_exit_1: 0xBC0060,
    LocationName.special_zone_7_exit_1: 0xBC0061,
    LocationName.special_zone_8_exit_1: 0xBC0062,
}

dragon_coin_location_table = {
    LocationName.yoshis_island_1_dragon: 0xBC0100,
    LocationName.yoshis_island_2_dragon: 0xBC0101,
    LocationName.yoshis_island_3_dragon: 0xBC0102,
    LocationName.yoshis_island_4_dragon: 0xBC0103,

    LocationName.donut_plains_1_dragon: 0xBC0106,
    LocationName.donut_plains_2_dragon: 0xBC0108,
    LocationName.donut_plains_3_dragon: 0xBC010A,
    LocationName.donut_plains_4_dragon: 0xBC010B,
    LocationName.donut_secret_1_dragon: 0xBC010C,
    LocationName.donut_secret_2_dragon: 0xBC010D,

    LocationName.vanilla_dome_1_dragon:      0xBC0114,
    LocationName.vanilla_dome_2_dragon:      0xBC0116,
    LocationName.vanilla_dome_3_dragon:      0xBC0118,
    LocationName.vanilla_dome_4_dragon:      0xBC0119,
    LocationName.vanilla_secret_1_dragon:    0xBC011A,
    LocationName.vanilla_secret_2_dragon:    0xBC011C,
    LocationName.vanilla_secret_3_dragon:    0xBC011D,
    LocationName.vanilla_ghost_house_dragon: 0xBC011E,

    LocationName.butter_bridge_1_dragon: 0xBC0123,
    LocationName.butter_bridge_2_dragon: 0xBC0124,
    LocationName.cheese_bridge_dragon:   0xBC0125,
    LocationName.cookie_mountain_dragon: 0xBC0127,
    LocationName.soda_lake_dragon:       0xBC0128,

    LocationName.forest_of_illusion_2_dragon: 0xBC012C,
    LocationName.forest_of_illusion_3_dragon: 0xBC012E,
    LocationName.forest_of_illusion_4_dragon: 0xBC0130,
    LocationName.forest_ghost_house_dragon:   0xBC0132,
    LocationName.forest_secret_dragon:        0xBC0134,
    LocationName.forest_castle_dragon:        0xBC0136,

    LocationName.chocolate_island_1_dragon:    0xBC0138,
    LocationName.chocolate_island_2_dragon:    0xBC0139,
    LocationName.chocolate_island_3_dragon:    0xBC013B,
    LocationName.chocolate_island_4_dragon:    0xBC013D,
    LocationName.chocolate_island_5_dragon:    0xBC013E,

    LocationName.sunken_ghost_ship_dragon: 0xBC0144,

    LocationName.valley_of_bowser_1_dragon: 0xBC0145,
    LocationName.valley_of_bowser_2_dragon: 0xBC0146,
    LocationName.valley_of_bowser_3_dragon: 0xBC0148,
    LocationName.valley_ghost_house_dragon: 0xBC014B,
    LocationName.valley_castle_dragon:      0xBC014F,

    LocationName.star_road_1_dragon: 0xBC0151,

    LocationName.special_zone_1_dragon: 0xBC015B,
    LocationName.special_zone_2_dragon: 0xBC015C,
    LocationName.special_zone_3_dragon: 0xBC015D,
    LocationName.special_zone_4_dragon: 0xBC015E,
    LocationName.special_zone_5_dragon: 0xBC015F,
    LocationName.special_zone_6_dragon: 0xBC0160,
    LocationName.special_zone_7_dragon: 0xBC0161,
    LocationName.special_zone_8_dragon: 0xBC0162,
}

moon_location_table = {
    LocationName.yoshis_island_1_moon:    0xBC0300,
    LocationName.donut_plains_4_moon:     0xBC030B,
    LocationName.vanilla_dome_3_moon:     0xBC0318,
    LocationName.cheese_bridge_moon:      0xBC0325,
    LocationName.forest_ghost_house_moon: 0xBC0332,
    LocationName.chocolate_island_1_moon: 0xBC0338,
    LocationName.valley_of_bowser_1_moon: 0xBC0345
}

hidden_1ups_location_table = {
    LocationName.yoshis_island_4_hidden_1up:      0xBC0403,
    LocationName.donut_plains_1_hidden_1up:       0xBC0406,
    LocationName.donut_plains_4_hidden_1up:       0xBC040B,
    LocationName.donut_plains_castle_hidden_1up:  0xBC0412,
    LocationName.vanilla_dome_4_hidden_1up:       0xBC0419,
    LocationName.vanilla_ghost_house_hidden_1up:  0xBC041E,
    LocationName.vanilla_fortress_hidden_1up:     0xBC0420,
    LocationName.cookie_mountain_hidden_1up:      0xBC0427,
    LocationName.forest_of_illusion_3_hidden_1up: 0xBC042E,
    LocationName.chocolate_island_2_hidden_1up:    0xBC0439,
    LocationName.chocolate_castle_hidden_1up:     0xBC0443,
    LocationName.valley_of_bowser_2_hidden_1up:   0xBC0446,
    LocationName.valley_castle_hidden_1up:        0xBC044F,
    LocationName.special_zone_1_hidden_1up:       0xBC045B
}
bonus_block_location_table = {
    LocationName.yoshis_island_3_bonus_block:    0xBC0502,
    LocationName.donut_plains_3_bonus_block:     0xBC050A,
    LocationName.butter_bridge_1_bonus_block:    0xBC0523,
    LocationName.chocolate_island_3_bonus_block: 0xBC053B
}

blocksanity_location_table = {
    LocationName.vanilla_secret_2_yoshi_block_1: 0xBC0600,
    LocationName.vanilla_secret_2_green_block_1: 0xBC0601,
    LocationName.vanilla_secret_2_powerup_block_1: 0xBC0602,
    LocationName.vanilla_secret_2_powerup_block_2: 0xBC0603,
    LocationName.vanilla_secret_2_multi_coin_block_1: 0xBC0604,
    LocationName.vanilla_secret_2_gray_pow_block_1: 0xBC0605,
    LocationName.vanilla_secret_2_coin_block_1: 0xBC0606,
    LocationName.vanilla_secret_2_coin_block_2: 0xBC0607,
    LocationName.vanilla_secret_2_coin_block_3: 0xBC0608,
    LocationName.vanilla_secret_2_coin_block_4: 0xBC0609,
    LocationName.vanilla_secret_2_coin_block_5: 0xBC060A,
    LocationName.vanilla_secret_2_coin_block_6: 0xBC060B,
    LocationName.vanilla_secret_3_powerup_block_1: 0xBC060C,
    LocationName.vanilla_secret_3_powerup_block_2: 0xBC060D,
    LocationName.donut_ghost_house_vine_block_1: 0xBC060E,
    LocationName.donut_ghost_house_directional_coin_block_1: 0xBC060F,
    LocationName.donut_ghost_house_life_block_1: 0xBC0610,
    LocationName.donut_ghost_house_life_block_2: 0xBC0611,
    LocationName.donut_ghost_house_life_block_3: 0xBC0612,
    LocationName.donut_ghost_house_life_block_4: 0xBC0613,
    LocationName.donut_plains_3_green_block_1: 0xBC0614,
    LocationName.donut_plains_3_coin_block_1: 0xBC0615,
    LocationName.donut_plains_3_coin_block_2: 0xBC0616,
    LocationName.donut_plains_3_vine_block_1: 0xBC0617,
    LocationName.donut_plains_3_powerup_block_1: 0xBC0618,
    LocationName.donut_plains_3_bonus_block_1: 0xBC0619,
    LocationName.donut_plains_4_coin_block_1: 0xBC061A,
    LocationName.donut_plains_4_powerup_block_1: 0xBC061B,
    LocationName.donut_plains_4_coin_block_2: 0xBC061C,
    LocationName.donut_plains_4_yoshi_block_1: 0xBC061D,
    LocationName.donut_plains_castle_yellow_block_1: 0xBC061E,
    LocationName.donut_plains_castle_coin_block_1: 0xBC061F,
    LocationName.donut_plains_castle_powerup_block_1: 0xBC0620,
    LocationName.donut_plains_castle_coin_block_2: 0xBC0621,
    LocationName.donut_plains_castle_vine_block_1: 0xBC0622,
    LocationName.donut_plains_castle_invis_life_block_1: 0xBC0623,
    LocationName.donut_plains_castle_coin_block_3: 0xBC0624,
    LocationName.donut_plains_castle_coin_block_4: 0xBC0625,
    LocationName.donut_plains_castle_coin_block_5: 0xBC0626,
    LocationName.donut_plains_castle_green_block_1: 0xBC0627,
    LocationName.donut_plains_2_coin_block_1: 0xBC0628,
    LocationName.donut_plains_2_coin_block_2: 0xBC0629,
    LocationName.donut_plains_2_coin_block_3: 0xBC062A,
    LocationName.donut_plains_2_yellow_block_1: 0xBC062B,
    LocationName.donut_plains_2_powerup_block_1: 0xBC062C,
    LocationName.donut_plains_2_multi_coin_block_1: 0xBC062D,
    LocationName.donut_plains_2_flying_block_1: 0xBC062E,
    LocationName.donut_plains_2_green_block_1: 0xBC062F,
    LocationName.donut_plains_2_yellow_block_2: 0xBC0630,
    LocationName.donut_plains_2_vine_block_1: 0xBC0631,
    LocationName.donut_secret_1_coin_block_1: 0xBC0632,
    LocationName.donut_secret_1_coin_block_2: 0xBC0633,
    LocationName.donut_secret_1_powerup_block_1: 0xBC0634,
    LocationName.donut_secret_1_coin_block_3: 0xBC0635,
    LocationName.donut_secret_1_powerup_block_2: 0xBC0636,
    LocationName.donut_secret_1_powerup_block_3: 0xBC0637,
    LocationName.donut_secret_1_life_block_1: 0xBC0638,
    LocationName.donut_secret_1_powerup_block_4: 0xBC0639,
    LocationName.donut_secret_1_powerup_block_5: 0xBC063A,
    LocationName.donut_secret_1_key_block_1: 0xBC063B,
    LocationName.vanilla_fortress_powerup_block_1: 0xBC063C,
    LocationName.vanilla_fortress_powerup_block_2: 0xBC063D,
    LocationName.vanilla_fortress_yellow_block_1: 0xBC063E,
    LocationName.butter_bridge_1_powerup_block_1: 0xBC063F,
    LocationName.butter_bridge_1_multi_coin_block_1: 0xBC0640,
    LocationName.butter_bridge_1_multi_coin_block_2: 0xBC0641,
    LocationName.butter_bridge_1_multi_coin_block_3: 0xBC0642,
    LocationName.butter_bridge_1_life_block_1: 0xBC0643,
    LocationName.butter_bridge_1_bonus_block_1: 0xBC0644,
    LocationName.butter_bridge_2_powerup_block_1: 0xBC0645,
    LocationName.butter_bridge_2_green_block_1: 0xBC0646,
    LocationName.butter_bridge_2_yoshi_block_1: 0xBC0647,
    LocationName.twin_bridges_castle_powerup_block_1: 0xBC0648,
    LocationName.cheese_bridge_powerup_block_1: 0xBC0649,
    LocationName.cheese_bridge_powerup_block_2: 0xBC064A,
    LocationName.cheese_bridge_wings_block_1: 0xBC064B,
    LocationName.cheese_bridge_powerup_block_3: 0xBC064C,
    LocationName.cookie_mountain_coin_block_1: 0xBC064D,
    LocationName.cookie_mountain_coin_block_2: 0xBC064E,
    LocationName.cookie_mountain_coin_block_3: 0xBC064F,
    LocationName.cookie_mountain_coin_block_4: 0xBC0650,
    LocationName.cookie_mountain_coin_block_5: 0xBC0651,
    LocationName.cookie_mountain_coin_block_6: 0xBC0652,
    LocationName.cookie_mountain_coin_block_7: 0xBC0653,
    LocationName.cookie_mountain_coin_block_8: 0xBC0654,
    LocationName.cookie_mountain_coin_block_9: 0xBC0655,
    LocationName.cookie_mountain_powerup_block_1: 0xBC0656,
    LocationName.cookie_mountain_life_block_1: 0xBC0657,
    LocationName.cookie_mountain_vine_block_1: 0xBC0658,
    LocationName.cookie_mountain_yoshi_block_1: 0xBC0659,
    LocationName.cookie_mountain_coin_block_10: 0xBC065A,
    LocationName.cookie_mountain_coin_block_11: 0xBC065B,
    LocationName.cookie_mountain_powerup_block_2: 0xBC065C,
    LocationName.cookie_mountain_coin_block_12: 0xBC065D,
    LocationName.cookie_mountain_coin_block_13: 0xBC065E,
    LocationName.cookie_mountain_coin_block_14: 0xBC065F,
    LocationName.cookie_mountain_coin_block_15: 0xBC0660,
    LocationName.cookie_mountain_coin_block_16: 0xBC0661,
    LocationName.cookie_mountain_coin_block_17: 0xBC0662,
    LocationName.cookie_mountain_coin_block_18: 0xBC0663,
    LocationName.cookie_mountain_coin_block_19: 0xBC0664,
    LocationName.cookie_mountain_coin_block_20: 0xBC0665,
    LocationName.cookie_mountain_coin_block_21: 0xBC0666,
    LocationName.cookie_mountain_coin_block_22: 0xBC0667,
    LocationName.cookie_mountain_coin_block_23: 0xBC0668,
    LocationName.cookie_mountain_coin_block_24: 0xBC0669,
    LocationName.cookie_mountain_coin_block_25: 0xBC066A,
    LocationName.cookie_mountain_coin_block_26: 0xBC066B,
    LocationName.cookie_mountain_coin_block_27: 0xBC066C,
    LocationName.cookie_mountain_coin_block_28: 0xBC066D,
    LocationName.cookie_mountain_coin_block_29: 0xBC066E,
    LocationName.cookie_mountain_coin_block_30: 0xBC066F,
    LocationName.soda_lake_powerup_block_1: 0xBC0670,
    LocationName.donut_secret_house_powerup_block_1: 0xBC0671,
    LocationName.donut_secret_house_multi_coin_block_1: 0xBC0672,
    LocationName.donut_secret_house_life_block_1: 0xBC0673,
    LocationName.donut_secret_house_vine_block_1: 0xBC0674,
    LocationName.donut_secret_house_directional_coin_block_1: 0xBC0675,
    LocationName.donut_plains_1_coin_block_1: 0xBC0676,
    LocationName.donut_plains_1_coin_block_2: 0xBC0677,
    LocationName.donut_plains_1_yoshi_block_1: 0xBC0678,
    LocationName.donut_plains_1_vine_block_1: 0xBC0679,
    LocationName.donut_plains_1_green_block_1: 0xBC067A,
    LocationName.donut_plains_1_green_block_2: 0xBC067B,
    LocationName.donut_plains_1_green_block_3: 0xBC067C,
    LocationName.donut_plains_1_green_block_4: 0xBC067D,
    LocationName.donut_plains_1_green_block_5: 0xBC067E,
    LocationName.donut_plains_1_green_block_6: 0xBC067F,
    LocationName.donut_plains_1_green_block_7: 0xBC0680,
    LocationName.donut_plains_1_green_block_8: 0xBC0681,
    LocationName.donut_plains_1_green_block_9: 0xBC0682,
    LocationName.donut_plains_1_green_block_10: 0xBC0683,
    LocationName.donut_plains_1_green_block_11: 0xBC0684,
    LocationName.donut_plains_1_green_block_12: 0xBC0685,
    LocationName.donut_plains_1_green_block_13: 0xBC0686,
    LocationName.donut_plains_1_green_block_14: 0xBC0687,
    LocationName.donut_plains_1_green_block_15: 0xBC0688,
    LocationName.donut_plains_1_green_block_16: 0xBC0689,
    LocationName.donut_plains_1_yellow_block_1: 0xBC068A,
    LocationName.donut_plains_1_yellow_block_2: 0xBC068B,
    LocationName.donut_plains_1_yellow_block_3: 0xBC068C,
    LocationName.sunken_ghost_ship_powerup_block_1: 0xBC068D,
    LocationName.sunken_ghost_ship_star_block_1: 0xBC068E,
    LocationName.chocolate_castle_yellow_block_1: 0xBC068F,
    LocationName.chocolate_castle_yellow_block_2: 0xBC0690,
    LocationName.chocolate_castle_green_block_1: 0xBC0691,
    LocationName.chocolate_fortress_powerup_block_1: 0xBC0692,
    LocationName.chocolate_fortress_powerup_block_2: 0xBC0693,
    LocationName.chocolate_fortress_coin_block_1: 0xBC0694,
    LocationName.chocolate_fortress_coin_block_2: 0xBC0695,
    LocationName.chocolate_fortress_green_block_1: 0xBC0696,
    LocationName.chocolate_island_5_yoshi_block_1: 0xBC0697,
    LocationName.chocolate_island_5_powerup_block_1: 0xBC0698,
    LocationName.chocolate_island_5_life_block_1: 0xBC0699,
    LocationName.chocolate_island_5_yellow_block_1: 0xBC069A,
    LocationName.chocolate_island_4_yellow_block_1: 0xBC069B,
    LocationName.chocolate_island_4_blue_pow_block_1: 0xBC069C,
    LocationName.chocolate_island_4_powerup_block_1: 0xBC069D,
    LocationName.forest_fortress_yellow_block_1: 0xBC069E,
    LocationName.forest_fortress_powerup_block_1: 0xBC069F,
    LocationName.forest_fortress_life_block_1: 0xBC06A0,
    LocationName.forest_fortress_life_block_2: 0xBC06A1,
    LocationName.forest_fortress_life_block_3: 0xBC06A2,
    LocationName.forest_fortress_life_block_4: 0xBC06A3,
    LocationName.forest_fortress_life_block_5: 0xBC06A4,
    LocationName.forest_fortress_life_block_6: 0xBC06A5,
    LocationName.forest_fortress_life_block_7: 0xBC06A6,
    LocationName.forest_fortress_life_block_8: 0xBC06A7,
    LocationName.forest_fortress_life_block_9: 0xBC06A8,
    LocationName.forest_castle_green_block_1: 0xBC06A9,
    LocationName.chocolate_ghost_house_powerup_block_1: 0xBC06AA,
    LocationName.chocolate_ghost_house_powerup_block_2: 0xBC06AB,
    LocationName.chocolate_ghost_house_life_block_1: 0xBC06AC,
    LocationName.chocolate_island_1_flying_block_1: 0xBC06AD,
    LocationName.chocolate_island_1_flying_block_2: 0xBC06AE,
    LocationName.chocolate_island_1_yoshi_block_1: 0xBC06AF,
    LocationName.chocolate_island_1_green_block_1: 0xBC06B0,
    LocationName.chocolate_island_1_life_block_1: 0xBC06B1,
    LocationName.chocolate_island_3_powerup_block_1: 0xBC06B2,
    LocationName.chocolate_island_3_powerup_block_2: 0xBC06B3,
    LocationName.chocolate_island_3_powerup_block_3: 0xBC06B4,
    LocationName.chocolate_island_3_green_block_1: 0xBC06B5,
    LocationName.chocolate_island_3_bonus_block_1: 0xBC06B6,
    LocationName.chocolate_island_3_vine_block_1: 0xBC06B7,
    LocationName.chocolate_island_3_life_block_1: 0xBC06B8,
    LocationName.chocolate_island_3_life_block_2: 0xBC06B9,
    LocationName.chocolate_island_3_life_block_3: 0xBC06BA,
    LocationName.chocolate_island_2_multi_coin_block_1: 0xBC06BB,
    LocationName.chocolate_island_2_invis_coin_block_1: 0xBC06BC,
    LocationName.chocolate_island_2_yoshi_block_1: 0xBC06BD,
    LocationName.chocolate_island_2_coin_block_1: 0xBC06BE,
    LocationName.chocolate_island_2_coin_block_2: 0xBC06BF,
    LocationName.chocolate_island_2_multi_coin_block_2: 0xBC06C0,
    LocationName.chocolate_island_2_powerup_block_1: 0xBC06C1,
    LocationName.chocolate_island_2_blue_pow_block_1: 0xBC06C2,
    LocationName.chocolate_island_2_yellow_block_1: 0xBC06C3,
    LocationName.chocolate_island_2_yellow_block_2: 0xBC06C4,
    LocationName.chocolate_island_2_green_block_1: 0xBC06C5,
    LocationName.chocolate_island_2_green_block_2: 0xBC06C6,
    LocationName.chocolate_island_2_green_block_3: 0xBC06C7,
    LocationName.chocolate_island_2_green_block_4: 0xBC06C8,
    LocationName.chocolate_island_2_green_block_5: 0xBC06C9,
    LocationName.chocolate_island_2_green_block_6: 0xBC06CA,
    LocationName.yoshis_island_castle_coin_block_1: 0xBC06CB,
    LocationName.yoshis_island_castle_coin_block_2: 0xBC06CC,
    LocationName.yoshis_island_castle_powerup_block_1: 0xBC06CD,
    LocationName.yoshis_island_castle_coin_block_3: 0xBC06CE,
    LocationName.yoshis_island_castle_coin_block_4: 0xBC06CF,
    LocationName.yoshis_island_castle_flying_block_1: 0xBC06D0,
    LocationName.yoshis_island_4_yellow_block_1: 0xBC06D1,
    LocationName.yoshis_island_4_powerup_block_1: 0xBC06D2,
    LocationName.yoshis_island_4_multi_coin_block_1: 0xBC06D3,
    LocationName.yoshis_island_4_star_block_1: 0xBC06D4,
    LocationName.yoshis_island_3_yellow_block_1: 0xBC06D5,
    LocationName.yoshis_island_3_yellow_block_2: 0xBC06D6,
    LocationName.yoshis_island_3_yellow_block_3: 0xBC06D7,
    LocationName.yoshis_island_3_yellow_block_4: 0xBC06D8,
    LocationName.yoshis_island_3_yellow_block_5: 0xBC06D9,
    LocationName.yoshis_island_3_yellow_block_6: 0xBC06DA,
    LocationName.yoshis_island_3_yellow_block_7: 0xBC06DB,
    LocationName.yoshis_island_3_yellow_block_8: 0xBC06DC,
    LocationName.yoshis_island_3_yellow_block_9: 0xBC06DD,
    LocationName.yoshis_island_3_coin_block_1: 0xBC06DE,
    LocationName.yoshis_island_3_yoshi_block_1: 0xBC06DF,
    LocationName.yoshis_island_3_coin_block_2: 0xBC06E0,
    LocationName.yoshis_island_3_powerup_block_1: 0xBC06E1,
    LocationName.yoshis_island_3_yellow_block_10: 0xBC06E2,
    LocationName.yoshis_island_3_yellow_block_11: 0xBC06E3,
    LocationName.yoshis_island_3_yellow_block_12: 0xBC06E4,
    LocationName.yoshis_island_3_bonus_block_1: 0xBC06E5,
    LocationName.yoshis_island_1_flying_block_1: 0xBC06E6,
    LocationName.yoshis_island_1_yellow_block_1: 0xBC06E7,
    LocationName.yoshis_island_1_life_block_1: 0xBC06E8,
    LocationName.yoshis_island_1_powerup_block_1: 0xBC06E9,
    LocationName.yoshis_island_2_flying_block_1: 0xBC06EA,
    LocationName.yoshis_island_2_flying_block_2: 0xBC06EB,
    LocationName.yoshis_island_2_flying_block_3: 0xBC06EC,
    LocationName.yoshis_island_2_flying_block_4: 0xBC06ED,
    LocationName.yoshis_island_2_flying_block_5: 0xBC06EE,
    LocationName.yoshis_island_2_flying_block_6: 0xBC06EF,
    LocationName.yoshis_island_2_coin_block_1: 0xBC06F0,
    LocationName.yoshis_island_2_yellow_block_1: 0xBC06F1,
    LocationName.yoshis_island_2_coin_block_2: 0xBC06F2,
    LocationName.yoshis_island_2_coin_block_3: 0xBC06F3,
    LocationName.yoshis_island_2_yoshi_block_1: 0xBC06F4,
    LocationName.yoshis_island_2_coin_block_4: 0xBC06F5,
    LocationName.yoshis_island_2_yoshi_block_2: 0xBC06F6,
    LocationName.yoshis_island_2_coin_block_5: 0xBC06F7,
    LocationName.yoshis_island_2_vine_block_1: 0xBC06F8,
    LocationName.yoshis_island_2_yellow_block_2: 0xBC06F9,
    LocationName.vanilla_ghost_house_powerup_block_1: 0xBC06FA,
    LocationName.vanilla_ghost_house_vine_block_1: 0xBC06FB,
    LocationName.vanilla_ghost_house_powerup_block_2: 0xBC06FC,
    LocationName.vanilla_ghost_house_multi_coin_block_1: 0xBC06FD,
    LocationName.vanilla_ghost_house_blue_pow_block_1: 0xBC06FE,
    LocationName.vanilla_secret_1_coin_block_1: 0xBC06FF,
    LocationName.vanilla_secret_1_powerup_block_1: 0xBC0700,
    LocationName.vanilla_secret_1_multi_coin_block_1: 0xBC0701,
    LocationName.vanilla_secret_1_vine_block_1: 0xBC0702,
    LocationName.vanilla_secret_1_vine_block_2: 0xBC0703,
    LocationName.vanilla_secret_1_coin_block_2: 0xBC0704,
    LocationName.vanilla_secret_1_coin_block_3: 0xBC0705,
    LocationName.vanilla_secret_1_powerup_block_2: 0xBC0706,
    LocationName.vanilla_dome_3_coin_block_1: 0xBC0707,
    LocationName.vanilla_dome_3_flying_block_1: 0xBC0708,
    LocationName.vanilla_dome_3_flying_block_2: 0xBC0709,
    LocationName.vanilla_dome_3_powerup_block_1: 0xBC070A,
    LocationName.vanilla_dome_3_flying_block_3: 0xBC070B,
    LocationName.vanilla_dome_3_invis_coin_block_1: 0xBC070C,
    LocationName.vanilla_dome_3_powerup_block_2: 0xBC070D,
    LocationName.vanilla_dome_3_multi_coin_block_1: 0xBC070E,
    LocationName.vanilla_dome_3_powerup_block_3: 0xBC070F,
    LocationName.vanilla_dome_3_yoshi_block_1: 0xBC0710,
    LocationName.vanilla_dome_3_powerup_block_4: 0xBC0711,
    LocationName.vanilla_dome_3_pswitch_coin_block_1: 0xBC0712,
    LocationName.vanilla_dome_3_pswitch_coin_block_2: 0xBC0713,
    LocationName.vanilla_dome_3_pswitch_coin_block_3: 0xBC0714,
    LocationName.vanilla_dome_3_pswitch_coin_block_4: 0xBC0715,
    LocationName.vanilla_dome_3_pswitch_coin_block_5: 0xBC0716,
    LocationName.vanilla_dome_3_pswitch_coin_block_6: 0xBC0717,
    LocationName.donut_secret_2_directional_coin_block_1: 0xBC0718,
    LocationName.donut_secret_2_vine_block_1: 0xBC0719,
    LocationName.donut_secret_2_star_block_1: 0xBC071A,
    LocationName.donut_secret_2_powerup_block_1: 0xBC071B,
    LocationName.donut_secret_2_star_block_2: 0xBC071C,
    LocationName.valley_of_bowser_4_yellow_block_1: 0xBC071D,
    LocationName.valley_of_bowser_4_powerup_block_1: 0xBC071E,
    LocationName.valley_of_bowser_4_vine_block_1: 0xBC071F,
    LocationName.valley_of_bowser_4_yoshi_block_1: 0xBC0720,
    LocationName.valley_of_bowser_4_life_block_1: 0xBC0721,
    LocationName.valley_of_bowser_4_powerup_block_2: 0xBC0722,
    LocationName.valley_castle_yellow_block_1: 0xBC0723,
    LocationName.valley_castle_yellow_block_2: 0xBC0724,
    LocationName.valley_castle_green_block_1: 0xBC0725,
    LocationName.valley_fortress_green_block_1: 0xBC0726,
    LocationName.valley_fortress_yellow_block_1: 0xBC0727,
    LocationName.valley_of_bowser_3_powerup_block_1: 0xBC0728,
    LocationName.valley_of_bowser_3_powerup_block_2: 0xBC0729,
    LocationName.valley_ghost_house_pswitch_coin_block_1: 0xBC072A,
    LocationName.valley_ghost_house_multi_coin_block_1: 0xBC072B,
    LocationName.valley_ghost_house_powerup_block_1: 0xBC072C,
    LocationName.valley_ghost_house_directional_coin_block_1: 0xBC072D,
    LocationName.valley_of_bowser_2_powerup_block_1: 0xBC072E,
    LocationName.valley_of_bowser_2_yellow_block_1: 0xBC072F,
    LocationName.valley_of_bowser_2_powerup_block_2: 0xBC0730,
    LocationName.valley_of_bowser_2_wings_block_1: 0xBC0731,
    LocationName.valley_of_bowser_1_green_block_1: 0xBC0732,
    LocationName.valley_of_bowser_1_invis_coin_block_1: 0xBC0733,
    LocationName.valley_of_bowser_1_invis_coin_block_2: 0xBC0734,
    LocationName.valley_of_bowser_1_invis_coin_block_3: 0xBC0735,
    LocationName.valley_of_bowser_1_yellow_block_1: 0xBC0736,
    LocationName.valley_of_bowser_1_yellow_block_2: 0xBC0737,
    LocationName.valley_of_bowser_1_yellow_block_3: 0xBC0738,
    LocationName.valley_of_bowser_1_yellow_block_4: 0xBC0739,
    LocationName.valley_of_bowser_1_vine_block_1: 0xBC073A,
    LocationName.chocolate_secret_powerup_block_1: 0xBC073B,
    LocationName.chocolate_secret_powerup_block_2: 0xBC073C,
    LocationName.vanilla_dome_2_coin_block_1: 0xBC073D,
    LocationName.vanilla_dome_2_powerup_block_1: 0xBC073E,
    LocationName.vanilla_dome_2_coin_block_2: 0xBC073F,
    LocationName.vanilla_dome_2_coin_block_3: 0xBC0740,
    LocationName.vanilla_dome_2_vine_block_1: 0xBC0741,
    LocationName.vanilla_dome_2_invis_life_block_1: 0xBC0742,
    LocationName.vanilla_dome_2_coin_block_4: 0xBC0743,
    LocationName.vanilla_dome_2_coin_block_5: 0xBC0744,
    LocationName.vanilla_dome_2_powerup_block_2: 0xBC0745,
    LocationName.vanilla_dome_2_powerup_block_3: 0xBC0746,
    LocationName.vanilla_dome_2_powerup_block_4: 0xBC0747,
    LocationName.vanilla_dome_2_powerup_block_5: 0xBC0748,
    LocationName.vanilla_dome_2_multi_coin_block_1: 0xBC0749,
    LocationName.vanilla_dome_2_multi_coin_block_2: 0xBC074A,
    LocationName.vanilla_dome_4_powerup_block_1: 0xBC074B,
    LocationName.vanilla_dome_4_powerup_block_2: 0xBC074C,
    LocationName.vanilla_dome_4_coin_block_1: 0xBC074D,
    LocationName.vanilla_dome_4_coin_block_2: 0xBC074E,
    LocationName.vanilla_dome_4_coin_block_3: 0xBC074F,
    LocationName.vanilla_dome_4_life_block_1: 0xBC0750,
    LocationName.vanilla_dome_4_coin_block_4: 0xBC0751,
    LocationName.vanilla_dome_4_coin_block_5: 0xBC0752,
    LocationName.vanilla_dome_4_coin_block_6: 0xBC0753,
    LocationName.vanilla_dome_4_coin_block_7: 0xBC0754,
    LocationName.vanilla_dome_4_coin_block_8: 0xBC0755,
    LocationName.vanilla_dome_1_flying_block_1: 0xBC0756,
    LocationName.vanilla_dome_1_powerup_block_1: 0xBC0757,
    LocationName.vanilla_dome_1_powerup_block_2: 0xBC0758,
    LocationName.vanilla_dome_1_coin_block_1: 0xBC0759,
    LocationName.vanilla_dome_1_life_block_1: 0xBC075A,
    LocationName.vanilla_dome_1_powerup_block_3: 0xBC075B,
    LocationName.vanilla_dome_1_vine_block_1: 0xBC075C,
    LocationName.vanilla_dome_1_star_block_1: 0xBC075D,
    LocationName.vanilla_dome_1_powerup_block_4: 0xBC075E,
    LocationName.vanilla_dome_1_coin_block_2: 0xBC075F,
    LocationName.vanilla_dome_castle_life_block_1: 0xBC0760,
    LocationName.vanilla_dome_castle_life_block_2: 0xBC0761,
    LocationName.vanilla_dome_castle_powerup_block_1: 0xBC0762,
    LocationName.vanilla_dome_castle_life_block_3: 0xBC0763,
    LocationName.vanilla_dome_castle_green_block_1: 0xBC0764,
    LocationName.forest_ghost_house_coin_block_1: 0xBC0765,
    LocationName.forest_ghost_house_powerup_block_1: 0xBC0766,
    LocationName.forest_ghost_house_flying_block_1: 0xBC0767,
    LocationName.forest_ghost_house_powerup_block_2: 0xBC0768,
    LocationName.forest_ghost_house_life_block_1: 0xBC0769,
    LocationName.forest_of_illusion_1_powerup_block_1: 0xBC076A,
    LocationName.forest_of_illusion_1_yoshi_block_1: 0xBC076B,
    LocationName.forest_of_illusion_1_powerup_block_2: 0xBC076C,
    LocationName.forest_of_illusion_1_key_block_1: 0xBC076D,
    LocationName.forest_of_illusion_1_life_block_1: 0xBC076E,
    LocationName.forest_of_illusion_4_multi_coin_block_1: 0xBC076F,
    LocationName.forest_of_illusion_4_coin_block_1: 0xBC0770,
    LocationName.forest_of_illusion_4_coin_block_2: 0xBC0771,
    LocationName.forest_of_illusion_4_coin_block_3: 0xBC0772,
    LocationName.forest_of_illusion_4_coin_block_4: 0xBC0773,
    LocationName.forest_of_illusion_4_powerup_block_1: 0xBC0774,
    LocationName.forest_of_illusion_4_coin_block_5: 0xBC0775,
    LocationName.forest_of_illusion_4_coin_block_6: 0xBC0776,
    LocationName.forest_of_illusion_4_coin_block_7: 0xBC0777,
    LocationName.forest_of_illusion_4_powerup_block_2: 0xBC0778,
    LocationName.forest_of_illusion_4_coin_block_8: 0xBC0779,
    LocationName.forest_of_illusion_4_coin_block_9: 0xBC077A,
    LocationName.forest_of_illusion_4_coin_block_10: 0xBC077B,
    LocationName.forest_of_illusion_2_green_block_1: 0xBC077C,
    LocationName.forest_of_illusion_2_powerup_block_1: 0xBC077D,
    LocationName.forest_of_illusion_2_invis_coin_block_1: 0xBC077E,
    LocationName.forest_of_illusion_2_invis_coin_block_2: 0xBC077F,
    LocationName.forest_of_illusion_2_invis_life_block_1: 0xBC0780,
    LocationName.forest_of_illusion_2_invis_coin_block_3: 0xBC0781,
    LocationName.forest_of_illusion_2_yellow_block_1: 0xBC0782,
    LocationName.forest_secret_powerup_block_1: 0xBC0783,
    LocationName.forest_secret_powerup_block_2: 0xBC0784,
    LocationName.forest_secret_life_block_1: 0xBC0785,
    LocationName.forest_of_illusion_3_yoshi_block_1: 0xBC0786,
    LocationName.forest_of_illusion_3_coin_block_1: 0xBC0787,
    LocationName.forest_of_illusion_3_multi_coin_block_1: 0xBC0788,
    LocationName.forest_of_illusion_3_coin_block_2: 0xBC0789,
    LocationName.forest_of_illusion_3_multi_coin_block_2: 0xBC078A,
    LocationName.forest_of_illusion_3_coin_block_3: 0xBC078B,
    LocationName.forest_of_illusion_3_coin_block_4: 0xBC078C,
    LocationName.forest_of_illusion_3_coin_block_5: 0xBC078D,
    LocationName.forest_of_illusion_3_coin_block_6: 0xBC078E,
    LocationName.forest_of_illusion_3_coin_block_7: 0xBC078F,
    LocationName.forest_of_illusion_3_coin_block_8: 0xBC0790,
    LocationName.forest_of_illusion_3_coin_block_9: 0xBC0791,
    LocationName.forest_of_illusion_3_coin_block_10: 0xBC0792,
    LocationName.forest_of_illusion_3_coin_block_11: 0xBC0793,
    LocationName.forest_of_illusion_3_coin_block_12: 0xBC0794,
    LocationName.forest_of_illusion_3_coin_block_13: 0xBC0795,
    LocationName.forest_of_illusion_3_coin_block_14: 0xBC0796,
    LocationName.forest_of_illusion_3_coin_block_15: 0xBC0797,
    LocationName.forest_of_illusion_3_coin_block_16: 0xBC0798,
    LocationName.forest_of_illusion_3_coin_block_17: 0xBC0799,
    LocationName.forest_of_illusion_3_coin_block_18: 0xBC079A,
    LocationName.forest_of_illusion_3_coin_block_19: 0xBC079B,
    LocationName.forest_of_illusion_3_coin_block_20: 0xBC079C,
    LocationName.forest_of_illusion_3_coin_block_21: 0xBC079D,
    LocationName.forest_of_illusion_3_coin_block_22: 0xBC079E,
    LocationName.forest_of_illusion_3_coin_block_23: 0xBC079F,
    LocationName.forest_of_illusion_3_coin_block_24: 0xBC07A0,
    LocationName.special_zone_8_yoshi_block_1: 0xBC07A1,
    LocationName.special_zone_8_coin_block_1: 0xBC07A2,
    LocationName.special_zone_8_coin_block_2: 0xBC07A3,
    LocationName.special_zone_8_coin_block_3: 0xBC07A4,
    LocationName.special_zone_8_coin_block_4: 0xBC07A5,
    LocationName.special_zone_8_coin_block_5: 0xBC07A6,
    LocationName.special_zone_8_blue_pow_block_1: 0xBC07A7,
    LocationName.special_zone_8_powerup_block_1: 0xBC07A8,
    LocationName.special_zone_8_star_block_1: 0xBC07A9,
    LocationName.special_zone_8_coin_block_6: 0xBC07AA,
    LocationName.special_zone_8_coin_block_7: 0xBC07AB,
    LocationName.special_zone_8_coin_block_8: 0xBC07AC,
    LocationName.special_zone_8_coin_block_9: 0xBC07AD,
    LocationName.special_zone_8_coin_block_10: 0xBC07AE,
    LocationName.special_zone_8_coin_block_11: 0xBC07AF,
    LocationName.special_zone_8_coin_block_12: 0xBC07B0,
    LocationName.special_zone_8_coin_block_13: 0xBC07B1,
    LocationName.special_zone_8_coin_block_14: 0xBC07B2,
    LocationName.special_zone_8_coin_block_15: 0xBC07B3,
    LocationName.special_zone_8_coin_block_16: 0xBC07B4,
    LocationName.special_zone_8_coin_block_17: 0xBC07B5,
    LocationName.special_zone_8_coin_block_18: 0xBC07B6,
    LocationName.special_zone_8_multi_coin_block_1: 0xBC07B7,
    LocationName.special_zone_8_coin_block_19: 0xBC07B8,
    LocationName.special_zone_8_coin_block_20: 0xBC07B9,
    LocationName.special_zone_8_coin_block_21: 0xBC07BA,
    LocationName.special_zone_8_coin_block_22: 0xBC07BB,
    LocationName.special_zone_8_coin_block_23: 0xBC07BC,
    LocationName.special_zone_8_powerup_block_2: 0xBC07BD,
    LocationName.special_zone_8_flying_block_1: 0xBC07BE,
    LocationName.special_zone_7_powerup_block_1: 0xBC07BF,
    LocationName.special_zone_7_yoshi_block_1: 0xBC07C0,
    LocationName.special_zone_7_coin_block_1: 0xBC07C1,
    LocationName.special_zone_7_powerup_block_2: 0xBC07C2,
    LocationName.special_zone_7_coin_block_2: 0xBC07C3,
    LocationName.special_zone_6_powerup_block_1: 0xBC07C4,
    LocationName.special_zone_6_coin_block_1: 0xBC07C5,
    LocationName.special_zone_6_coin_block_2: 0xBC07C6,
    LocationName.special_zone_6_yoshi_block_1: 0xBC07C7,
    LocationName.special_zone_6_life_block_1: 0xBC07C8,
    LocationName.special_zone_6_multi_coin_block_1: 0xBC07C9,
    LocationName.special_zone_6_coin_block_3: 0xBC07CA,
    LocationName.special_zone_6_coin_block_4: 0xBC07CB,
    LocationName.special_zone_6_coin_block_5: 0xBC07CC,
    LocationName.special_zone_6_coin_block_6: 0xBC07CD,
    LocationName.special_zone_6_coin_block_7: 0xBC07CE,
    LocationName.special_zone_6_coin_block_8: 0xBC07CF,
    LocationName.special_zone_6_coin_block_9: 0xBC07D0,
    LocationName.special_zone_6_coin_block_10: 0xBC07D1,
    LocationName.special_zone_6_coin_block_11: 0xBC07D2,
    LocationName.special_zone_6_coin_block_12: 0xBC07D3,
    LocationName.special_zone_6_coin_block_13: 0xBC07D4,
    LocationName.special_zone_6_coin_block_14: 0xBC07D5,
    LocationName.special_zone_6_coin_block_15: 0xBC07D6,
    LocationName.special_zone_6_coin_block_16: 0xBC07D7,
    LocationName.special_zone_6_coin_block_17: 0xBC07D8,
    LocationName.special_zone_6_coin_block_18: 0xBC07D9,
    LocationName.special_zone_6_coin_block_19: 0xBC07DA,
    LocationName.special_zone_6_coin_block_20: 0xBC07DB,
    LocationName.special_zone_6_coin_block_21: 0xBC07DC,
    LocationName.special_zone_6_coin_block_22: 0xBC07DD,
    LocationName.special_zone_6_coin_block_23: 0xBC07DE,
    LocationName.special_zone_6_coin_block_24: 0xBC07DF,
    LocationName.special_zone_6_coin_block_25: 0xBC07E0,
    LocationName.special_zone_6_coin_block_26: 0xBC07E1,
    LocationName.special_zone_6_coin_block_27: 0xBC07E2,
    LocationName.special_zone_6_coin_block_28: 0xBC07E3,
    LocationName.special_zone_6_powerup_block_2: 0xBC07E4,
    LocationName.special_zone_6_coin_block_29: 0xBC07E5,
    LocationName.special_zone_6_coin_block_30: 0xBC07E6,
    LocationName.special_zone_6_coin_block_31: 0xBC07E7,
    LocationName.special_zone_6_coin_block_32: 0xBC07E8,
    LocationName.special_zone_6_coin_block_33: 0xBC07E9,
    LocationName.special_zone_5_yoshi_block_1: 0xBC07EA,
    LocationName.special_zone_1_vine_block_1: 0xBC07EB,
    LocationName.special_zone_1_vine_block_2: 0xBC07EC,
    LocationName.special_zone_1_vine_block_3: 0xBC07ED,
    LocationName.special_zone_1_vine_block_4: 0xBC07EE,
    LocationName.special_zone_1_life_block_1: 0xBC07EF,
    LocationName.special_zone_1_vine_block_5: 0xBC07F0,
    LocationName.special_zone_1_blue_pow_block_1: 0xBC07F1,
    LocationName.special_zone_1_vine_block_6: 0xBC07F2,
    LocationName.special_zone_1_powerup_block_1: 0xBC07F3,
    LocationName.special_zone_1_pswitch_coin_block_1: 0xBC07F4,
    LocationName.special_zone_1_pswitch_coin_block_2: 0xBC07F5,
    LocationName.special_zone_1_pswitch_coin_block_3: 0xBC07F6,
    LocationName.special_zone_1_pswitch_coin_block_4: 0xBC07F7,
    LocationName.special_zone_1_pswitch_coin_block_5: 0xBC07F8,
    LocationName.special_zone_1_pswitch_coin_block_6: 0xBC07F9,
    LocationName.special_zone_1_pswitch_coin_block_7: 0xBC07FA,
    LocationName.special_zone_1_pswitch_coin_block_8: 0xBC07FB,
    LocationName.special_zone_1_pswitch_coin_block_9: 0xBC07FC,
    LocationName.special_zone_1_pswitch_coin_block_10: 0xBC07FD,
    LocationName.special_zone_1_pswitch_coin_block_11: 0xBC07FE,
    LocationName.special_zone_1_pswitch_coin_block_12: 0xBC07FF,
    LocationName.special_zone_1_pswitch_coin_block_13: 0xBC0800,
    LocationName.special_zone_2_powerup_block_1: 0xBC0801,
    LocationName.special_zone_2_coin_block_1: 0xBC0802,
    LocationName.special_zone_2_coin_block_2: 0xBC0803,
    LocationName.special_zone_2_powerup_block_2: 0xBC0804,
    LocationName.special_zone_2_coin_block_3: 0xBC0805,
    LocationName.special_zone_2_coin_block_4: 0xBC0806,
    LocationName.special_zone_2_powerup_block_3: 0xBC0807,
    LocationName.special_zone_2_multi_coin_block_1: 0xBC0808,
    LocationName.special_zone_2_coin_block_5: 0xBC0809,
    LocationName.special_zone_2_coin_block_6: 0xBC080A,
    LocationName.special_zone_3_powerup_block_1: 0xBC080B,
    LocationName.special_zone_3_yoshi_block_1: 0xBC080C,
    LocationName.special_zone_3_wings_block_1: 0xBC080D,
    LocationName.special_zone_4_powerup_block_1: 0xBC080E,
    LocationName.special_zone_4_star_block_1: 0xBC080F,
    LocationName.star_road_2_star_block_1: 0xBC0810,
    LocationName.star_road_3_key_block_1: 0xBC0811,
    LocationName.star_road_4_powerup_block_1: 0xBC0812,
    LocationName.star_road_4_green_block_1: 0xBC0813,
    LocationName.star_road_4_green_block_2: 0xBC0814,
    LocationName.star_road_4_green_block_3: 0xBC0815,
    LocationName.star_road_4_green_block_4: 0xBC0816,
    LocationName.star_road_4_green_block_5: 0xBC0817,
    LocationName.star_road_4_green_block_6: 0xBC0818,
    LocationName.star_road_4_green_block_7: 0xBC0819,
    LocationName.star_road_4_key_block_1: 0xBC081A,
    LocationName.star_road_5_directional_coin_block_1: 0xBC081B,
    LocationName.star_road_5_life_block_1: 0xBC081C,
    LocationName.star_road_5_vine_block_1: 0xBC081D,
    LocationName.star_road_5_yellow_block_1: 0xBC081E,
    LocationName.star_road_5_yellow_block_2: 0xBC081F,
    LocationName.star_road_5_yellow_block_3: 0xBC0820,
    LocationName.star_road_5_yellow_block_4: 0xBC0821,
    LocationName.star_road_5_yellow_block_5: 0xBC0822,
    LocationName.star_road_5_yellow_block_6: 0xBC0823,
    LocationName.star_road_5_yellow_block_7: 0xBC0824,
    LocationName.star_road_5_yellow_block_8: 0xBC0825,
    LocationName.star_road_5_yellow_block_9: 0xBC0826,
    LocationName.star_road_5_yellow_block_10: 0xBC0827,
    LocationName.star_road_5_yellow_block_11: 0xBC0828,
    LocationName.star_road_5_yellow_block_12: 0xBC0829,
    LocationName.star_road_5_yellow_block_13: 0xBC082A,
    LocationName.star_road_5_yellow_block_14: 0xBC082B,
    LocationName.star_road_5_yellow_block_15: 0xBC082C,
    LocationName.star_road_5_yellow_block_16: 0xBC082D,
    LocationName.star_road_5_yellow_block_17: 0xBC082E,
    LocationName.star_road_5_yellow_block_18: 0xBC082F,
    LocationName.star_road_5_yellow_block_19: 0xBC0830,
    LocationName.star_road_5_yellow_block_20: 0xBC0831,
    LocationName.star_road_5_green_block_1: 0xBC0832,
    LocationName.star_road_5_green_block_2: 0xBC0833,
    LocationName.star_road_5_green_block_3: 0xBC0834,
    LocationName.star_road_5_green_block_4: 0xBC0835,
    LocationName.star_road_5_green_block_5: 0xBC0836,
    LocationName.star_road_5_green_block_6: 0xBC0837,
    LocationName.star_road_5_green_block_7: 0xBC0838,
    LocationName.star_road_5_green_block_8: 0xBC0839,
    LocationName.star_road_5_green_block_9: 0xBC083A,
    LocationName.star_road_5_green_block_10: 0xBC083B,
    LocationName.star_road_5_green_block_11: 0xBC083C,
    LocationName.star_road_5_green_block_12: 0xBC083D,
    LocationName.star_road_5_green_block_13: 0xBC083E,
    LocationName.star_road_5_green_block_14: 0xBC083F,
    LocationName.star_road_5_green_block_15: 0xBC0840,
    LocationName.star_road_5_green_block_16: 0xBC0841,
    LocationName.star_road_5_green_block_17: 0xBC0842,
    LocationName.star_road_5_green_block_18: 0xBC0843,
    LocationName.star_road_5_green_block_19: 0xBC0844,
    LocationName.star_road_5_green_block_20: 0xBC0845
}

bowser_location_table = {
    LocationName.bowser: 0xBC0200,
}

yoshi_house_location_table = {
    LocationName.yoshis_house: 0xBC0201,
}

all_locations = {
    **level_location_table,
    **dragon_coin_location_table,
    **moon_location_table,
    **hidden_1ups_location_table,
    **bonus_block_location_table,
    **blocksanity_location_table,
    **bowser_location_table,
    **yoshi_house_location_table,
}

special_zone_level_names = [
    LocationName.special_zone_1_exit_1,
    LocationName.special_zone_2_exit_1,
    LocationName.special_zone_3_exit_1,
    LocationName.special_zone_4_exit_1,
    LocationName.special_zone_5_exit_1,
    LocationName.special_zone_6_exit_1,
    LocationName.special_zone_7_exit_1,
    LocationName.special_zone_8_exit_1,
]

special_zone_dragon_coin_names = [
    LocationName.special_zone_1_dragon,
    LocationName.special_zone_2_dragon,
    LocationName.special_zone_3_dragon,
    LocationName.special_zone_4_dragon,
    LocationName.special_zone_5_dragon,
    LocationName.special_zone_6_dragon,
    LocationName.special_zone_7_dragon,
    LocationName.special_zone_8_dragon,
]

special_zone_hidden_1up_names = [
    LocationName.special_zone_1_hidden_1up
]

special_zone_blocksanity_names = [
    LocationName.special_zone_8_yoshi_block_1,
    LocationName.special_zone_8_coin_block_1,
    LocationName.special_zone_8_coin_block_2,
    LocationName.special_zone_8_coin_block_3,
    LocationName.special_zone_8_coin_block_4,
    LocationName.special_zone_8_coin_block_5,
    LocationName.special_zone_8_blue_pow_block_1,
    LocationName.special_zone_8_powerup_block_1,
    LocationName.special_zone_8_star_block_1,
    LocationName.special_zone_8_coin_block_6,
    LocationName.special_zone_8_coin_block_7,
    LocationName.special_zone_8_coin_block_8,
    LocationName.special_zone_8_coin_block_9,
    LocationName.special_zone_8_coin_block_10,
    LocationName.special_zone_8_coin_block_11,
    LocationName.special_zone_8_coin_block_12,
    LocationName.special_zone_8_coin_block_13,
    LocationName.special_zone_8_coin_block_14,
    LocationName.special_zone_8_coin_block_15,
    LocationName.special_zone_8_coin_block_16,
    LocationName.special_zone_8_coin_block_17,
    LocationName.special_zone_8_coin_block_18,
    LocationName.special_zone_8_multi_coin_block_1,
    LocationName.special_zone_8_coin_block_19,
    LocationName.special_zone_8_coin_block_20,
    LocationName.special_zone_8_coin_block_21,
    LocationName.special_zone_8_coin_block_22,
    LocationName.special_zone_8_coin_block_23,
    LocationName.special_zone_8_powerup_block_2,
    LocationName.special_zone_8_flying_block_1,
    LocationName.special_zone_7_powerup_block_1,
    LocationName.special_zone_7_yoshi_block_1,
    LocationName.special_zone_7_coin_block_1,
    LocationName.special_zone_7_powerup_block_2,
    LocationName.special_zone_7_coin_block_2,
    LocationName.special_zone_6_powerup_block_1,
    LocationName.special_zone_6_coin_block_1,
    LocationName.special_zone_6_coin_block_2,
    LocationName.special_zone_6_yoshi_block_1,
    LocationName.special_zone_6_life_block_1,
    LocationName.special_zone_6_multi_coin_block_1,
    LocationName.special_zone_6_coin_block_3,
    LocationName.special_zone_6_coin_block_4,
    LocationName.special_zone_6_coin_block_5,
    LocationName.special_zone_6_coin_block_6,
    LocationName.special_zone_6_coin_block_7,
    LocationName.special_zone_6_coin_block_8,
    LocationName.special_zone_6_coin_block_9,
    LocationName.special_zone_6_coin_block_10,
    LocationName.special_zone_6_coin_block_11,
    LocationName.special_zone_6_coin_block_12,
    LocationName.special_zone_6_coin_block_13,
    LocationName.special_zone_6_coin_block_14,
    LocationName.special_zone_6_coin_block_15,
    LocationName.special_zone_6_coin_block_16,
    LocationName.special_zone_6_coin_block_17,
    LocationName.special_zone_6_coin_block_18,
    LocationName.special_zone_6_coin_block_19,
    LocationName.special_zone_6_coin_block_20,
    LocationName.special_zone_6_coin_block_21,
    LocationName.special_zone_6_coin_block_22,
    LocationName.special_zone_6_coin_block_23,
    LocationName.special_zone_6_coin_block_24,
    LocationName.special_zone_6_coin_block_25,
    LocationName.special_zone_6_coin_block_26,
    LocationName.special_zone_6_coin_block_27,
    LocationName.special_zone_6_coin_block_28,
    LocationName.special_zone_6_powerup_block_2,
    LocationName.special_zone_6_coin_block_29,
    LocationName.special_zone_6_coin_block_30,
    LocationName.special_zone_6_coin_block_31,
    LocationName.special_zone_6_coin_block_32,
    LocationName.special_zone_6_coin_block_33,
    LocationName.special_zone_5_yoshi_block_1,
    LocationName.special_zone_1_vine_block_1,
    LocationName.special_zone_1_vine_block_2,
    LocationName.special_zone_1_vine_block_3,
    LocationName.special_zone_1_vine_block_4,
    LocationName.special_zone_1_life_block_1,
    LocationName.special_zone_1_vine_block_5,
    LocationName.special_zone_1_blue_pow_block_1,
    LocationName.special_zone_1_vine_block_6,
    LocationName.special_zone_1_powerup_block_1,
    LocationName.special_zone_1_pswitch_coin_block_1,
    LocationName.special_zone_1_pswitch_coin_block_2,
    LocationName.special_zone_1_pswitch_coin_block_3,
    LocationName.special_zone_1_pswitch_coin_block_4,
    LocationName.special_zone_1_pswitch_coin_block_5,
    LocationName.special_zone_1_pswitch_coin_block_6,
    LocationName.special_zone_1_pswitch_coin_block_7,
    LocationName.special_zone_1_pswitch_coin_block_8,
    LocationName.special_zone_1_pswitch_coin_block_9,
    LocationName.special_zone_1_pswitch_coin_block_10,
    LocationName.special_zone_1_pswitch_coin_block_11,
    LocationName.special_zone_1_pswitch_coin_block_12,
    LocationName.special_zone_1_pswitch_coin_block_13,
    LocationName.special_zone_2_powerup_block_1,
    LocationName.special_zone_2_coin_block_1,
    LocationName.special_zone_2_coin_block_2,
    LocationName.special_zone_2_powerup_block_2,
    LocationName.special_zone_2_coin_block_3,
    LocationName.special_zone_2_coin_block_4,
    LocationName.special_zone_2_powerup_block_3,
    LocationName.special_zone_2_multi_coin_block_1,
    LocationName.special_zone_2_coin_block_5,
    LocationName.special_zone_2_coin_block_6,
    LocationName.special_zone_3_powerup_block_1,
    LocationName.special_zone_3_yoshi_block_1,
    LocationName.special_zone_3_wings_block_1,
    LocationName.special_zone_4_powerup_block_1,
    LocationName.special_zone_4_star_block_1
]

location_table = {}


def setup_locations(world: World):
    location_table = {**level_location_table}

    if world.options.dragon_coin_checks:
        location_table.update(dragon_coin_location_table)

    if world.options.moon_checks:
        location_table.update(moon_location_table)

    if world.options.hidden_1up_checks:
        location_table.update(hidden_1ups_location_table)

    if world.options.bonus_block_checks:
        location_table.update(bonus_block_location_table)

    if world.options.blocksanity:
        location_table.update(blocksanity_location_table)

    if world.options.goal == "yoshi_egg_hunt":
        location_table.update(yoshi_house_location_table)
    else:
        location_table.update(bowser_location_table)

    return location_table


lookup_id_to_name: typing.Dict[int, str] = {id: name for name, _ in all_locations.items()}
