from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from . import DKCWorld

from .Names import RegionName, LocationName


# Data format: location_type, data
location_id_to_level_id = {
    LocationName.jungle_hijinxs_clear:          [0x00, 0x16],
    LocationName.ropey_rampage_clear:           [0x00, 0x0C],
    LocationName.reptile_rumble_clear:          [0x00, 0x01],
    LocationName.coral_capers_clear:            [0x00, 0xBF],
    LocationName.barrel_cannon_canyon_clear:    [0x00, 0x17],
    LocationName.very_gnawty_lair_clear:        [0x00, 0xE0],
    LocationName.winky_walkway_clear:           [0x00, 0xD9],
    LocationName.mine_cart_carnage_clear:       [0x00, 0x2E],
    LocationName.bouncy_bonanza_clear:          [0x00, 0x07],
    LocationName.stop_go_station_clear:         [0x00, 0x31],
    LocationName.millstone_mayhem_clear:        [0x00, 0x42],
    LocationName.necky_nuts_clear:              [0x00, 0xE1],
    LocationName.vulture_culture_clear:         [0x00, 0xA5],
    LocationName.tree_top_town_clear:           [0x00, 0xA4],
    LocationName.forest_frenzy_clear:           [0x00, 0xD0],
    LocationName.temple_tempest_clear:          [0x00, 0x43],
    LocationName.orang_utan_gang_clear:         [0x00, 0x0D],
    LocationName.clam_city_clear:               [0x00, 0xDE],
    LocationName.bumble_b_rumble_clear:         [0x00, 0xE5],
    LocationName.snow_barrel_blast_clear:       [0x00, 0x24],
    LocationName.slipslide_ride_clear:          [0x00, 0x6D],
    LocationName.ice_age_alley_clear:           [0x00, 0xA7],
    LocationName.croctopus_chase_clear:         [0x00, 0x3E],
    LocationName.torchlight_trouble_clear:      [0x00, 0x14],
    LocationName.rope_bridge_rumble_clear:      [0x00, 0xCE],
    LocationName.really_gnawty_rampage_clear:   [0x00, 0xE2],
    LocationName.oil_drum_alley_clear:          [0x00, 0x40],
    LocationName.trick_track_trek_clear:        [0x00, 0x2F],
    LocationName.elevator_antics_clear:         [0x00, 0x18],
    LocationName.poison_pond_clear:             [0x00, 0x22],
    LocationName.mine_cart_madness_clear:       [0x00, 0x27],
    LocationName.blackout_basement_clear:       [0x00, 0x41],
    LocationName.boss_dumb_drum_clear:          [0x00, 0xE3],
    LocationName.tanked_up_trouble_clear:       [0x00, 0x30],
    LocationName.manic_mincers_clear:           [0x00, 0x12],
    LocationName.misty_mine_clear:              [0x00, 0x0A],
    LocationName.loopy_lights_clear:            [0x00, 0x36],
    LocationName.platform_perils_clear:         [0x00, 0x2B],
    LocationName.necky_revenge_clear:           [0x00, 0xE4],
    # KROOL 0x68

    LocationName.defeated_gnawty_1:             [0x00, 0xE0],
    LocationName.defeated_necky_1:              [0x00, 0xE1],
    LocationName.defeated_bumble_b:             [0x00, 0xE5],
    LocationName.defeated_gnawty_2:             [0x00, 0xE2],
    LocationName.defeated_boss_dumb_drum:       [0x00, 0xE3],
    LocationName.defeated_necky_2:              [0x00, 0xE4],
    
    LocationName.jungle_hijinxs_kong:           [0x01, 0x16],
    LocationName.ropey_rampage_kong:            [0x01, 0x0C],
    LocationName.reptile_rumble_kong:           [0x01, 0x01],
    LocationName.coral_capers_kong:             [0x01, 0xBF],
    LocationName.barrel_cannon_canyon_kong:     [0x01, 0x17],
    LocationName.winky_walkway_kong:            [0x01, 0xD9],
    LocationName.mine_cart_carnage_kong:        [0x01, 0x2E],
    LocationName.bouncy_bonanza_kong:           [0x01, 0x07],
    LocationName.stop_go_station_kong:          [0x01, 0x31],
    LocationName.millstone_mayhem_kong:         [0x01, 0x42],
    LocationName.vulture_culture_kong:          [0x01, 0xA5],
    LocationName.tree_top_town_kong:            [0x01, 0xA4],
    LocationName.forest_frenzy_kong:            [0x01, 0xD0],
    LocationName.temple_tempest_kong:           [0x01, 0x43],
    LocationName.orang_utan_gang_kong:          [0x01, 0x0D],
    LocationName.clam_city_kong:                [0x01, 0xDE],
    LocationName.snow_barrel_blast_kong:        [0x01, 0x24],
    LocationName.slipslide_ride_kong:           [0x01, 0x6D],
    LocationName.ice_age_alley_kong:            [0x01, 0xA7],
    LocationName.croctopus_chase_kong:          [0x01, 0x3E],
    LocationName.torchlight_trouble_kong:       [0x01, 0x14],
    LocationName.rope_bridge_rumble_kong:       [0x01, 0xCE],
    LocationName.oil_drum_alley_kong:           [0x01, 0x40],
    LocationName.trick_track_trek_kong:         [0x01, 0x2F],
    LocationName.elevator_antics_kong:          [0x01, 0x18],
    LocationName.poison_pond_kong:              [0x01, 0x22],
    LocationName.mine_cart_madness_kong:        [0x01, 0x27],
    LocationName.blackout_basement_kong:        [0x01, 0x41],
    LocationName.tanked_up_trouble_kong:        [0x01, 0x30],
    LocationName.manic_mincers_kong:            [0x01, 0x12],
    LocationName.misty_mine_kong:               [0x01, 0x0A],
    LocationName.loopy_lights_kong:             [0x01, 0x36],
    LocationName.platform_perils_kong:          [0x01, 0x2B],
    
    LocationName.jungle_hijinxs_bonus_1:           [0x02, 0x16, 0x02],
    LocationName.jungle_hijinxs_bonus_2:           [0x02, 0x16, 0x04],
    LocationName.ropey_rampage_bonus_1:            [0x02, 0x0C, 0x02],
    LocationName.ropey_rampage_bonus_2:            [0x02, 0x0C, 0x04],
    LocationName.reptile_rumble_bonus_1:           [0x02, 0x01, 0x02],
    LocationName.reptile_rumble_bonus_2:           [0x02, 0x01, 0x04],
    LocationName.reptile_rumble_bonus_3:           [0x02, 0x01, 0x08],
    LocationName.barrel_cannon_canyon_bonus_1:     [0x02, 0x17, 0x02],
    LocationName.barrel_cannon_canyon_bonus_2:     [0x02, 0x17, 0x04],
    LocationName.winky_walkway_bonus_1:            [0x02, 0xD9, 0x02],
    LocationName.bouncy_bonanza_bonus_1:           [0x02, 0x07, 0x02],
    LocationName.bouncy_bonanza_bonus_2:           [0x02, 0x07, 0x04],
    LocationName.stop_go_station_bonus_1:          [0x02, 0x31, 0x02],
    LocationName.stop_go_station_bonus_2:          [0x02, 0x31, 0x04],
    LocationName.millstone_mayhem_bonus_1:         [0x02, 0x42, 0x02],
    LocationName.millstone_mayhem_bonus_2:         [0x02, 0x42, 0x04],
    LocationName.millstone_mayhem_bonus_3:         [0x02, 0x42, 0x08],
    LocationName.vulture_culture_bonus_1:          [0x02, 0xA5, 0x02],
    LocationName.vulture_culture_bonus_2:          [0x02, 0xA5, 0x04],
    LocationName.vulture_culture_bonus_3:          [0x02, 0xA5, 0x08],
    LocationName.tree_top_town_bonus_2:            [0x02, 0xA4, 0x02],
    LocationName.tree_top_town_bonus_1:            [0x02, 0xA4, 0x04],
    LocationName.forest_frenzy_bonus_1:            [0x02, 0xD0, 0x02],
    LocationName.forest_frenzy_bonus_2:            [0x02, 0xD0, 0x04],
    LocationName.temple_tempest_bonus_1:           [0x02, 0x43, 0x02],
    LocationName.temple_tempest_bonus_2:           [0x02, 0x43, 0x04],
    LocationName.orang_utan_gang_bonus_1:          [0x02, 0x0D, 0x02],
    LocationName.orang_utan_gang_bonus_2:          [0x02, 0x0D, 0x04],
    LocationName.orang_utan_gang_bonus_3:          [0x02, 0x0D, 0x08],
    LocationName.orang_utan_gang_bonus_4:          [0x02, 0x0D, 0x10],
    LocationName.orang_utan_gang_bonus_5:          [0x02, 0x0D, 0x20],
    LocationName.snow_barrel_blast_bonus_1:        [0x02, 0x24, 0x02],
    LocationName.snow_barrel_blast_bonus_2:        [0x02, 0x24, 0x04],
    LocationName.snow_barrel_blast_bonus_3:        [0x02, 0x24, 0x08],
    LocationName.slipslide_ride_bonus_1:           [0x02, 0x6D, 0x02],
    LocationName.slipslide_ride_bonus_2:           [0x02, 0x6D, 0x04],
    LocationName.slipslide_ride_bonus_3:           [0x02, 0x6D, 0x08],
    LocationName.ice_age_alley_bonus_1:            [0x02, 0xA7, 0x02],
    LocationName.ice_age_alley_bonus_2:            [0x02, 0xA7, 0x04],
    LocationName.torchlight_trouble_bonus_1:       [0x02, 0x14, 0x02],
    LocationName.torchlight_trouble_bonus_2:       [0x02, 0x14, 0x04],
    LocationName.rope_bridge_rumble_bonus_2:       [0x02, 0xCE, 0x02],
    LocationName.rope_bridge_rumble_bonus_1:       [0x02, 0xCE, 0x04],
    LocationName.oil_drum_alley_bonus_1:           [0x02, 0x40, 0x02],
    LocationName.oil_drum_alley_bonus_2:           [0x02, 0x40, 0x04],
    LocationName.oil_drum_alley_bonus_3:           [0x02, 0x40, 0x08],
    LocationName.oil_drum_alley_bonus_4:           [0x02, 0x40, 0x10],
    LocationName.trick_track_trek_bonus_1:         [0x02, 0x2F, 0x02],
    LocationName.trick_track_trek_bonus_2:         [0x02, 0x2F, 0x04],
    LocationName.trick_track_trek_bonus_3:         [0x02, 0x2F, 0x08],
    LocationName.elevator_antics_bonus_1:          [0x02, 0x18, 0x02],
    LocationName.elevator_antics_bonus_2:          [0x02, 0x18, 0x04],
    LocationName.elevator_antics_bonus_3:          [0x02, 0x18, 0x08],
    LocationName.mine_cart_madness_bonus_1:        [0x02, 0x27, 0x02],
    LocationName.mine_cart_madness_bonus_2:        [0x02, 0x27, 0x04],
    LocationName.mine_cart_madness_bonus_3:        [0x02, 0x27, 0x08],
    LocationName.blackout_basement_bonus_1:        [0x02, 0x41, 0x02],
    LocationName.blackout_basement_bonus_2:        [0x02, 0x41, 0x04],
    LocationName.tanked_up_trouble_bonus_1:        [0x02, 0x30, 0x02],
    LocationName.manic_mincers_bonus_1:            [0x02, 0x12, 0x02],
    LocationName.manic_mincers_bonus_2:            [0x02, 0x12, 0x04],
    LocationName.misty_mine_bonus_1:               [0x02, 0x0A, 0x02],
    LocationName.misty_mine_bonus_2:               [0x02, 0x0A, 0x04],
    LocationName.loopy_lights_bonus_1:             [0x02, 0x36, 0x02],
    LocationName.loopy_lights_bonus_2:             [0x02, 0x36, 0x04],
    LocationName.platform_perils_bonus_1:          [0x02, 0x2B, 0x02],
    LocationName.platform_perils_bonus_2:          [0x02, 0x2B, 0x04],

    LocationName.jungle_hijinxs_balloon_1:  [0x04, 0x16, 0x01],
    LocationName.jungle_hijinxs_bunch_1:    [0x05, 0x16, 0x04],
    LocationName.jungle_hijinxs_bunch_2:    [0x05, 0x16, 0x06],
    LocationName.jungle_hijinxs_bunch_3:    [0x05, 0x16, 0x07],
    LocationName.jungle_hijinxs_bunch_4:    [0x05, 0x16, 0x0B],
    LocationName.jungle_hijinxs_bunch_5:    [0x05, 0x16, 0x0F],
    LocationName.jungle_hijinxs_bunch_6:    [0x05, 0x16, 0x10],
    LocationName.jungle_hijinxs_balloon_2:  [0x04, 0x16, 0x11],
    LocationName.jungle_hijinxs_bunch_7:    [0x05, 0x16, 0x14],
    LocationName.jungle_hijinxs_bunch_8:    [0x05, 0x16, 0x13],
    LocationName.jungle_hijinxs_bunch_9:    [0x05, 0x16, 0x12],
    LocationName.jungle_hijinxs_bunch_10:   [0x05, 0x16, 0x18],
    LocationName.jungle_hijinxs_bunch_11:   [0x05, 0x16, 0x17],
    LocationName.jungle_hijinxs_bunch_12:   [0x05, 0x16, 0x16],
    LocationName.jungle_hijinxs_balloon_3:  [0x04, 0x16, 0x1A],
    LocationName.jungle_hijinxs_bunch_13:   [0x05, 0x16, 0x1B],
    LocationName.jungle_hijinxs_balloon_4:  [0x04, 0x16, 0x1E],
    LocationName.jungle_hijinxs_token_1:    [0x03, 0x16, 0x26],
    LocationName.jungle_hijinxs_bunch_14:   [0x05, 0x16, 0x25],
    LocationName.jungle_hijinxs_bunch_15:   [0x05, 0x16, 0x30],
    LocationName.jungle_hijinxs_bunch_16:   [0x05, 0x16, 0x36],
    LocationName.jungle_hijinxs_bunch_17:   [0x05, 0x16, 0x38],
    LocationName.jungle_hijinxs_bunch_18:   [0x05, 0x16, 0x3A],
    LocationName.jungle_hijinxs_bunch_19:   [0x05, 0x16, 0x3B],
    LocationName.jungle_hijinxs_balloon_5:  [0x04, 0x16, 0x3D],
    LocationName.jungle_hijinxs_balloon_6:  [0x04, 0x16, 0x3E],

    LocationName.ropey_rampage_bunch_1:     [0x05, 0x0C, 0x02],
    LocationName.ropey_rampage_bunch_2:     [0x05, 0x0C, 0x05],
    LocationName.ropey_rampage_bunch_3:     [0x05, 0x0C, 0x06],
    LocationName.ropey_rampage_bunch_4:     [0x05, 0x0C, 0x04],
    LocationName.ropey_rampage_bunch_5:     [0x05, 0x0C, 0x03],
    LocationName.ropey_rampage_bunch_6:     [0x05, 0x0C, 0x0C],
    LocationName.ropey_rampage_bunch_7:     [0x05, 0x0C, 0x0D],
    LocationName.ropey_rampage_bunch_8:     [0x05, 0x0C, 0x0F],
    LocationName.ropey_rampage_bunch_9:     [0x05, 0x0C, 0x13],
    LocationName.ropey_rampage_token_1:     [0x03, 0x0C, 0x16],
    LocationName.ropey_rampage_bunch_10:    [0x05, 0x0C, 0x18],
    LocationName.ropey_rampage_bunch_11:    [0x05, 0x0C, 0x1B],
    LocationName.ropey_rampage_bunch_12:    [0x05, 0x0C, 0x1C],
    LocationName.ropey_rampage_bunch_13:    [0x05, 0x0C, 0x27],
    LocationName.ropey_rampage_bunch_14:    [0x05, 0x0C, 0x29],
    LocationName.ropey_rampage_bunch_15:    [0x05, 0x0C, 0x2D],
    LocationName.ropey_rampage_token_2:     [0x03, 0x0C, 0x3A],
    LocationName.ropey_rampage_bunch_16:    [0x05, 0x0C, 0x3B],
    LocationName.ropey_rampage_bunch_17:    [0x05, 0x0C, 0x47],
    LocationName.ropey_rampage_bunch_18:    [0x05, 0x0C, 0x48],
    LocationName.ropey_rampage_bunch_19:    [0x05, 0x0C, 0x4E],

    LocationName.reptile_rumble_bunch_1:    [0x05, 0x01, 0x02],
    LocationName.reptile_rumble_bunch_2:    [0x05, 0x01, 0x07],
    LocationName.reptile_rumble_bunch_3:    [0x05, 0x01, 0x0F],
    LocationName.reptile_rumble_bunch_4:    [0x05, 0x01, 0x16],
    LocationName.reptile_rumble_bunch_5:    [0x05, 0x01, 0x19],
    LocationName.reptile_rumble_bunch_6:    [0x05, 0x01, 0x1D],
    LocationName.reptile_rumble_bunch_7:    [0x05, 0x01, 0x21],
    LocationName.reptile_rumble_bunch_8:    [0x05, 0x01, 0x25],
    LocationName.reptile_rumble_bunch_9:    [0x05, 0x01, 0x2B],
    LocationName.reptile_rumble_bunch_10:   [0x05, 0x01, 0x32],
    LocationName.reptile_rumble_token_1:    [0x03, 0x01, 0x3C],
    LocationName.reptile_rumble_bunch_11:   [0x05, 0x01, 0x40],
    LocationName.reptile_rumble_bunch_12:   [0x05, 0x01, 0x43],
    LocationName.reptile_rumble_bunch_13:   [0x05, 0x01, 0x45],
    LocationName.reptile_rumble_bunch_14:   [0x05, 0x01, 0x50],

    LocationName.coral_capers_bunch_1:      [0x05, 0xBF, 0x09],
    LocationName.coral_capers_balloon_1:    [0x04, 0xBF, 0x1C],
    LocationName.coral_capers_bunch_2:      [0x05, 0xBF, 0x12],
    LocationName.coral_capers_token_1:      [0x03, 0xBF, 0x10],

    LocationName.barrel_cannon_canyon_token_1:  [0x03, 0x17, 0x10],
    LocationName.barrel_cannon_canyon_bunch_1:  [0x05, 0x17, 0x09],
    LocationName.barrel_cannon_canyon_bunch_2:  [0x05, 0x17, 0x17],
    LocationName.barrel_cannon_canyon_bunch_3:  [0x05, 0x17, 0x26],
    LocationName.barrel_cannon_canyon_bunch_4:  [0x05, 0x17, 0x27],
    LocationName.barrel_cannon_canyon_token_2:  [0x03, 0x17, 0x2A],
    LocationName.barrel_cannon_canyon_bunch_5:  [0x05, 0x17, 0x38],
    LocationName.barrel_cannon_canyon_bunch_6:  [0x05, 0x17, 0x3C],
    LocationName.barrel_cannon_canyon_bunch_7:  [0x05, 0x17, 0x43],
    LocationName.barrel_cannon_canyon_bunch_8:  [0x05, 0x17, 0x48],
    LocationName.barrel_cannon_canyon_bunch_9:  [0x05, 0x17, 0x4D],
    LocationName.barrel_cannon_canyon_bunch_10: [0x05, 0x17, 0x6C],
    LocationName.barrel_cannon_canyon_bunch_11: [0x05, 0x17, 0x71],
    LocationName.barrel_cannon_canyon_bunch_12: [0x05, 0x17, 0x70],

    LocationName.winky_walkway_bunch_1: [0x05, 0xD9, 0x01],
    LocationName.winky_walkway_bunch_2: [0x05, 0xD9, 0x0B],
    LocationName.winky_walkway_bunch_3: [0x05, 0xD9, 0x12],
    LocationName.winky_walkway_bunch_4: [0x05, 0xD9, 0x1B],
    LocationName.winky_walkway_token_1: [0x03, 0xD9, 0x1D],
    LocationName.winky_walkway_bunch_5: [0x05, 0xD9, 0x26],

    LocationName.mine_cart_carnage_bunch_1:     [0x05, 0x2E, 0x00],
    LocationName.mine_cart_carnage_bunch_2:     [0x05, 0x2E, 0x09],
    LocationName.mine_cart_carnage_token_1:     [0x03, 0x2E, 0x0A],
    LocationName.mine_cart_carnage_bunch_3:     [0x05, 0x2E, 0x14],
    LocationName.mine_cart_carnage_balloon_1:   [0x04, 0x2E, 0x15],

    LocationName.bouncy_bonanza_token_1:  [0x03, 0x07, 0x00],
    LocationName.bouncy_bonanza_bunch_1:  [0x05, 0x07, 0x03],
    LocationName.bouncy_bonanza_bunch_2:  [0x05, 0x07, 0x08],
    LocationName.bouncy_bonanza_bunch_3:  [0x05, 0x07, 0x12],
    LocationName.bouncy_bonanza_bunch_4:  [0x05, 0x07, 0x1B],
    LocationName.bouncy_bonanza_bunch_5:  [0x05, 0x07, 0x21],
    LocationName.bouncy_bonanza_bunch_6:  [0x05, 0x07, 0x2C],
    LocationName.bouncy_bonanza_bunch_7:  [0x05, 0x07, 0x34],
    LocationName.bouncy_bonanza_bunch_8:  [0x05, 0x07, 0x4E],
    LocationName.bouncy_bonanza_bunch_9:  [0x05, 0x07, 0x52],
    LocationName.bouncy_bonanza_bunch_10: [0x05, 0x07, 0x58],

    LocationName.stop_go_station_bunch_1: [0x05, 0x31, 0x04],
    LocationName.stop_go_station_bunch_2: [0x05, 0x31, 0x0D],
    LocationName.stop_go_station_bunch_3: [0x05, 0x31, 0x1E],
    LocationName.stop_go_station_token_1: [0x03, 0x31, 0x20],
    LocationName.stop_go_station_bunch_4: [0x05, 0x31, 0x2D],
    LocationName.stop_go_station_bunch_5: [0x05, 0x31, 0x3A],
    LocationName.stop_go_station_bunch_6: [0x05, 0x31, 0x42],
    LocationName.stop_go_station_bunch_7: [0x05, 0x31, 0x61],

    LocationName.millstone_mayhem_bunch_1: [0x05, 0x42, 0x06],
    LocationName.millstone_mayhem_bunch_2: [0x05, 0x42, 0x10],
    LocationName.millstone_mayhem_bunch_3: [0x05, 0x42, 0x20],
    LocationName.millstone_mayhem_bunch_4: [0x05, 0x42, 0x30],
    LocationName.millstone_mayhem_bunch_5: [0x05, 0x42, 0x37],
    LocationName.millstone_mayhem_bunch_6: [0x05, 0x42, 0x3D],
    LocationName.millstone_mayhem_bunch_7: [0x05, 0x42, 0x49],
    LocationName.millstone_mayhem_bunch_8: [0x05, 0x42, 0x4B],
    LocationName.millstone_mayhem_bunch_9: [0x05, 0x42, 0x4C],

    LocationName.vulture_culture_bunch_1: [0x05, 0xA5, 0x06],
    LocationName.vulture_culture_bunch_2: [0x05, 0xA5, 0x14],
    LocationName.vulture_culture_bunch_3: [0x05, 0xA5, 0x2D],
    LocationName.vulture_culture_bunch_4: [0x05, 0xA5, 0x30],
    LocationName.vulture_culture_bunch_5: [0x05, 0xA5, 0x37],
    LocationName.vulture_culture_bunch_6: [0x05, 0xA5, 0x55],

    LocationName.tree_top_town_bunch_1: [0x05, 0xA4, 0x01],
    LocationName.tree_top_town_bunch_2: [0x05, 0xA4, 0x19],
    LocationName.tree_top_town_bunch_3: [0x05, 0xA4, 0x30],
    LocationName.tree_top_town_token_1: [0x03, 0xA4, 0x54],
    LocationName.tree_top_town_bunch_4: [0x05, 0xA4, 0x56],

    LocationName.forest_frenzy_bunch_1:   [0x05, 0xD0, 0x04],
    LocationName.forest_frenzy_bunch_2:   [0x05, 0xD0, 0x0C],
    LocationName.forest_frenzy_bunch_3:   [0x05, 0xD0, 0x12],
    LocationName.forest_frenzy_bunch_4:   [0x05, 0xD0, 0x34],
    LocationName.forest_frenzy_bunch_5:   [0x05, 0xD0, 0x5C],
    LocationName.forest_frenzy_balloon_1: [0x04, 0xD0, 0x45],

    LocationName.temple_tempest_token_1: [0x03, 0x43, 0x00],
    LocationName.temple_tempest_bunch_1: [0x05, 0x43, 0x02],
    LocationName.temple_tempest_bunch_2: [0x05, 0x43, 0x0C],
    LocationName.temple_tempest_bunch_3: [0x05, 0x43, 0x15],
    LocationName.temple_tempest_bunch_4: [0x05, 0x43, 0x21],
    LocationName.temple_tempest_bunch_5: [0x05, 0x43, 0x35],
    LocationName.temple_tempest_bunch_6: [0x05, 0x43, 0x3D],
    LocationName.temple_tempest_bunch_7: [0x05, 0x43, 0x44],
    LocationName.temple_tempest_bunch_8: [0x05, 0x43, 0x4B],

    LocationName.orang_utan_gang_bunch_1: [0x05, 0x0D, 0x05],
    LocationName.orang_utan_gang_bunch_2: [0x05, 0x0D, 0x0C],
    LocationName.orang_utan_gang_bunch_3: [0x05, 0x0D, 0x19],
    LocationName.orang_utan_gang_bunch_4: [0x05, 0x0D, 0x1C],
    LocationName.orang_utan_gang_bunch_5: [0x05, 0x0D, 0x25],
    LocationName.orang_utan_gang_bunch_6: [0x05, 0x0D, 0x2D],
    LocationName.orang_utan_gang_token_1: [0x03, 0x0D, 0x32],
    LocationName.orang_utan_gang_bunch_7: [0x05, 0x0D, 0x34],
    LocationName.orang_utan_gang_bunch_8: [0x05, 0x0D, 0x40],
    LocationName.orang_utan_gang_bunch_9: [0x05, 0x0D, 0x41],

    LocationName.clam_city_bunch_1: [0x05, 0xDE, 0x04],
    LocationName.clam_city_bunch_2: [0x05, 0xDE, 0x12],
    LocationName.clam_city_token_1: [0x03, 0xDE, 0x28],

    LocationName.snow_barrel_blast_bunch_1:     [0x05, 0x24, 0x05],
    LocationName.snow_barrel_blast_balloon_1:   [0x04, 0x24, 0x07],
    LocationName.snow_barrel_blast_bunch_2:     [0x05, 0x24, 0x15],
    LocationName.snow_barrel_blast_bunch_3:     [0x05, 0x24, 0x46],
    LocationName.snow_barrel_blast_token_1:     [0x03, 0x24, 0x4B],
    LocationName.snow_barrel_blast_balloon_2:   [0x04, 0x24, 0x77],
    LocationName.snow_barrel_blast_bunch_4:     [0x05, 0x24, 0x7A],
    LocationName.snow_barrel_blast_bunch_5:     [0x05, 0x24, 0x7D],

    LocationName.slipslide_ride_token_1: [0x03, 0x6D, 0x33],
    LocationName.slipslide_ride_bunch_1: [0x05, 0x6D, 0x26],
    LocationName.slipslide_ride_bunch_2: [0x05, 0x6D, 0x23],
    LocationName.slipslide_ride_bunch_3: [0x05, 0x6D, 0x2F],
    LocationName.slipslide_ride_bunch_4: [0x05, 0x6D, 0x2D],
    LocationName.slipslide_ride_bunch_5: [0x05, 0x6D, 0x43],
    LocationName.slipslide_ride_bunch_6: [0x05, 0x6D, 0x68],
    LocationName.slipslide_ride_bunch_7: [0x05, 0x6D, 0x6A],
    LocationName.slipslide_ride_bunch_8: [0x05, 0x6D, 0x5C],
    LocationName.slipslide_ride_bunch_9: [0x05, 0x6D, 0x49],

    LocationName.ice_age_alley_bunch_1: [0x05, 0xA7, 0x06],
    LocationName.ice_age_alley_bunch_2: [0x05, 0xA7, 0x23],
    LocationName.ice_age_alley_bunch_3: [0x05, 0xA7, 0x37],

    LocationName.croctopus_chase_bunch_1:   [0x05, 0x3E, 0x06],
    LocationName.croctopus_chase_token_1:   [0x03, 0x3E, 0x1F],
    LocationName.croctopus_chase_token_2:   [0x03, 0x3E, 0x28],
    LocationName.croctopus_chase_bunch_2:   [0x05, 0x3E, 0x26],
    LocationName.croctopus_chase_bunch_3:   [0x05, 0x3E, 0x27],
    LocationName.croctopus_chase_bunch_4:   [0x05, 0x3E, 0x29],
    LocationName.croctopus_chase_bunch_5:   [0x05, 0x3E, 0x2A],
    LocationName.croctopus_chase_balloon_1: [0x04, 0x3E, 0x34],

    LocationName.torchlight_trouble_bunch_1: [0x05, 0x14, 0x32],

    LocationName.rope_bridge_rumble_bunch_1: [0x05, 0xCE, 0x2F],

    LocationName.oil_drum_alley_bunch_1: [0x05, 0x40, 0x27],
    LocationName.oil_drum_alley_bunch_2: [0x05, 0x40, 0x3E],

    LocationName.trick_track_trek_bunch_1: [0x05, 0x2F, 0x07],
    LocationName.trick_track_trek_token_1: [0x03, 0x2F, 0x3C],

    LocationName.elevator_antics_bunch_1: [0x05, 0x18, 0x0F],
    LocationName.elevator_antics_bunch_2: [0x05, 0x18, 0x2A],
    LocationName.elevator_antics_bunch_3: [0x05, 0x18, 0x33],

    LocationName.poison_pond_bunch_1: [0x05, 0x22, 0x0E],
    LocationName.poison_pond_bunch_2: [0x05, 0x22, 0x05],
    LocationName.poison_pond_bunch_3: [0x05, 0x22, 0x12],
    LocationName.poison_pond_bunch_4: [0x05, 0x22, 0x29],
    LocationName.poison_pond_bunch_5: [0x05, 0x22, 0x2C],
    LocationName.poison_pond_token_1: [0x03, 0x22, 0x47],
    LocationName.poison_pond_token_2: [0x03, 0x22, 0x39],
    LocationName.poison_pond_bunch_6: [0x05, 0x22, 0x41],

    LocationName.mine_cart_madness_token_1: [0x03, 0x27, 0x1A],
    LocationName.mine_cart_madness_bunch_1: [0x05, 0x27, 0x41],

    LocationName.blackout_basement_token_1: [0x03, 0x41, 0x0A],
    LocationName.blackout_basement_bunch_1: [0x05, 0x41, 0x2C],

    LocationName.tanked_up_trouble_bunch_1: [0x05, 0x30, 0x17],
    LocationName.tanked_up_trouble_bunch_2: [0x05, 0x30, 0x1E],
    LocationName.tanked_up_trouble_token_1: [0x03, 0x30, 0x25],
    LocationName.tanked_up_trouble_bunch_3: [0x05, 0x30, 0x48],
    LocationName.tanked_up_trouble_bunch_4: [0x05, 0x30, 0x59],

    LocationName.manic_mincers_bunch_1: [0x05, 0x12, 0x15],
    LocationName.manic_mincers_bunch_2: [0x05, 0x12, 0x2A],
    LocationName.manic_mincers_token_1: [0x03, 0x12, 0x40],

    LocationName.misty_mine_token_1: [0x03, 0x0A, 0x11],
    LocationName.misty_mine_bunch_1: [0x05, 0x0A, 0x09],
    LocationName.misty_mine_bunch_2: [0x05, 0x0A, 0x14],
    LocationName.misty_mine_token_2: [0x03, 0x0A, 0x32],

    LocationName.loopy_lights_bunch_1: [0x05, 0x36, 0x3F],
    LocationName.loopy_lights_bunch_2: [0x05, 0x36, 0x74],

    LocationName.platform_perils_token_1: [0x03, 0x2B, 0x27],
    LocationName.platform_perils_bunch_1: [0x05, 0x2B, 0x57],
}

level_list = [
    [RegionName.jungle_hijinxs_level, 0x16],
    [RegionName.ropey_rampage_level, 0x0C],
    [RegionName.reptile_rumble_level, 0x01],
    [RegionName.coral_capers_level, 0xBF],
    [RegionName.barrel_cannon_canyon_level, 0x17],
    [RegionName.winky_walkway_level, 0xD9],
    [RegionName.mine_cart_carnage_level, 0x2E],
    [RegionName.bouncy_bonanza_level, 0x07],
    [RegionName.stop_go_station_level, 0x31],
    [RegionName.millstone_mayhem_level, 0x42],
    [RegionName.vulture_culture_level, 0xA5],
    [RegionName.tree_top_town_level, 0xA4],
    [RegionName.forest_frenzy_level, 0xD0],
    [RegionName.temple_tempest_level, 0x43],
    [RegionName.orang_utan_gang_level, 0x0D],
    [RegionName.clam_city_level, 0xDE],
    [RegionName.snow_barrel_blast_level, 0x24],
    [RegionName.slipslide_ride_level, 0x6D],
    [RegionName.ice_age_alley_level, 0xA7],
    [RegionName.croctopus_chase_level, 0x3E],
    [RegionName.torchlight_trouble_level, 0x14],
    [RegionName.rope_bridge_rumble_level, 0xCE],
    [RegionName.oil_drum_alley_level, 0x40],
    [RegionName.trick_track_trek_level, 0x2F],
    [RegionName.elevator_antics_level, 0x18],
    [RegionName.poison_pond_level, 0x22],
    [RegionName.mine_cart_madness_level, 0x27],
    [RegionName.blackout_basement_level, 0x41],
    [RegionName.tanked_up_trouble_level, 0x30],
    [RegionName.manic_mincers_level, 0x12],
    [RegionName.misty_mine_level, 0x0A],
    [RegionName.loopy_lights_level, 0x36],
    [RegionName.platform_perils_level, 0x2B],
]

boss_list = [
    [RegionName.very_gnawty_lair_level, 0xE0],
    [RegionName.necky_nuts_level, 0xE1],
    [RegionName.bumble_b_rumble_level, 0xE5],
    [RegionName.really_gnawty_rampage_level, 0xE2],
    [RegionName.boss_dumb_drum_level, 0xE3],
    [RegionName.necky_revenge_level, 0xE4],
]

level_map = {
    RegionName.jungle_hijinxs_map: RegionName.kongo_jungle,
    RegionName.ropey_rampage_map: RegionName.kongo_jungle,
    RegionName.reptile_rumble_map: RegionName.kongo_jungle,
    RegionName.coral_capers_map: RegionName.kongo_jungle,
    RegionName.barrel_cannon_canyon_map: RegionName.kongo_jungle,
    RegionName.very_gnawty_lair_map: RegionName.kongo_jungle,
    RegionName.winky_walkway_map: RegionName.monkey_mines,
    RegionName.mine_cart_carnage_map: RegionName.monkey_mines,
    RegionName.bouncy_bonanza_map: RegionName.monkey_mines,
    RegionName.stop_go_station_map: RegionName.monkey_mines,
    RegionName.millstone_mayhem_map: RegionName.monkey_mines,
    RegionName.necky_nuts_map: RegionName.monkey_mines,
    RegionName.vulture_culture_map: RegionName.vine_valley,
    RegionName.tree_top_town_map: RegionName.vine_valley,
    RegionName.forest_frenzy_map: RegionName.vine_valley,
    RegionName.temple_tempest_map: RegionName.vine_valley,
    RegionName.orang_utan_gang_map: RegionName.vine_valley,
    RegionName.clam_city_map: RegionName.vine_valley,
    RegionName.bumble_b_rumble_map: RegionName.vine_valley,
    RegionName.snow_barrel_blast_map: RegionName.gorilla_glacier,
    RegionName.slipslide_ride_map: RegionName.gorilla_glacier,
    RegionName.ice_age_alley_map: RegionName.gorilla_glacier,
    RegionName.croctopus_chase_map: RegionName.gorilla_glacier,
    RegionName.torchlight_trouble_map: RegionName.gorilla_glacier,
    RegionName.rope_bridge_rumble_map: RegionName.gorilla_glacier,
    RegionName.really_gnawty_rampage_map: RegionName.gorilla_glacier,
    RegionName.oil_drum_alley_map: RegionName.kremkroc_industries,
    RegionName.trick_track_trek_map: RegionName.kremkroc_industries,
    RegionName.elevator_antics_map: RegionName.kremkroc_industries,
    RegionName.poison_pond_map: RegionName.kremkroc_industries,
    RegionName.mine_cart_madness_map: RegionName.kremkroc_industries,
    RegionName.blackout_basement_map: RegionName.kremkroc_industries,
    RegionName.boss_dumb_drum_map: RegionName.kremkroc_industries,
    RegionName.tanked_up_trouble_map: RegionName.chimp_caverns,
    RegionName.manic_mincers_map: RegionName.chimp_caverns,
    RegionName.misty_mine_map: RegionName.chimp_caverns,
    RegionName.loopy_lights_map: RegionName.chimp_caverns,
    RegionName.platform_perils_map: RegionName.chimp_caverns,
    RegionName.necky_revenge_map: RegionName.chimp_caverns,
}

level_connections = {
    RegionName.jungle_hijinxs_map: RegionName.jungle_hijinxs_level,
    RegionName.ropey_rampage_map: RegionName.ropey_rampage_level,
    RegionName.reptile_rumble_map: RegionName.reptile_rumble_level,
    RegionName.coral_capers_map: RegionName.coral_capers_level,
    RegionName.barrel_cannon_canyon_map: RegionName.barrel_cannon_canyon_level,
    RegionName.winky_walkway_map: RegionName.winky_walkway_level,
    RegionName.mine_cart_carnage_map: RegionName.mine_cart_carnage_level,
    RegionName.bouncy_bonanza_map: RegionName.bouncy_bonanza_level,
    RegionName.stop_go_station_map: RegionName.stop_go_station_level,
    RegionName.millstone_mayhem_map: RegionName.millstone_mayhem_level,
    RegionName.vulture_culture_map: RegionName.vulture_culture_level,
    RegionName.tree_top_town_map: RegionName.tree_top_town_level,
    RegionName.forest_frenzy_map: RegionName.forest_frenzy_level,
    RegionName.temple_tempest_map: RegionName.temple_tempest_level,
    RegionName.orang_utan_gang_map: RegionName.orang_utan_gang_level,
    RegionName.clam_city_map: RegionName.clam_city_level,
    RegionName.snow_barrel_blast_map: RegionName.snow_barrel_blast_level,
    RegionName.slipslide_ride_map: RegionName.slipslide_ride_level,
    RegionName.ice_age_alley_map: RegionName.ice_age_alley_level,
    RegionName.croctopus_chase_map: RegionName.croctopus_chase_level,
    RegionName.torchlight_trouble_map: RegionName.torchlight_trouble_level,
    RegionName.rope_bridge_rumble_map: RegionName.rope_bridge_rumble_level,
    RegionName.oil_drum_alley_map: RegionName.oil_drum_alley_level,
    RegionName.trick_track_trek_map: RegionName.trick_track_trek_level,
    RegionName.elevator_antics_map: RegionName.elevator_antics_level,
    RegionName.poison_pond_map: RegionName.poison_pond_level,
    RegionName.mine_cart_madness_map: RegionName.mine_cart_madness_level,
    RegionName.blackout_basement_map: RegionName.blackout_basement_level,
    RegionName.tanked_up_trouble_map: RegionName.tanked_up_trouble_level,
    RegionName.manic_mincers_map: RegionName.manic_mincers_level,
    RegionName.misty_mine_map: RegionName.misty_mine_level,
    RegionName.loopy_lights_map: RegionName.loopy_lights_level,
    RegionName.platform_perils_map: RegionName.platform_perils_level,
}

boss_connections = {
    RegionName.very_gnawty_lair_map: RegionName.very_gnawty_lair_level,
    RegionName.necky_nuts_map: RegionName.necky_nuts_level,
    RegionName.bumble_b_rumble_map: RegionName.bumble_b_rumble_level,
    RegionName.really_gnawty_rampage_map: RegionName.really_gnawty_rampage_level,
    RegionName.boss_dumb_drum_map: RegionName.boss_dumb_drum_level,
    RegionName.necky_revenge_map: RegionName.necky_revenge_level,
}

def generate_level_list(world: "DKCWorld"):
    shuffled_level_list = level_list.copy()
    shuffled_boss_list = boss_list.copy()
    #if world.options.shuffle_levels:
    #    world.random.shuffle(shuffled_level_list)
    #    world.random.shuffle(shuffled_boss_list)

    for map_level, level in level_connections.items():
        selected_level = shuffled_level_list.pop(0)
        world.level_connections[map_level] = selected_level[0]
        #world.rom_connections[level] = selected_level

    for map_boss, boss in boss_connections.items():
        selected_boss = shuffled_boss_list.pop(0)
        world.level_connections[map_boss] = selected_boss[0]
        #world.rom_connections[boss] = selected_boss

    # Place locked levels
    #world.level_connections[RegionName.pirate_panic_map] = RegionName.pirate_panic_level
