import collections

from .Regions import create_lw_region, create_dw_region, create_cave_region, create_dungeon_region
from .SubClasses import LTTPRegionType


def create_inverted_regions(multiworld, player):

    multiworld.regions += [
        create_dw_region(multiworld, player, 'Menu', None,
                         ['Links House S&Q', 'Dark Sanctuary S&Q', 'Old Man S&Q', 'Castle Ledge S&Q']),
        create_lw_region(multiworld, player, 'Light World',
                         ['Mushroom', 'Bottle Merchant', 'Flute Spot', 'Sunken Treasure', 'Purple Chest',
                          'Bombos Tablet'],
                         ["Blinds Hideout", "Hyrule Castle Secret Entrance Drop", 'Kings Grave Outer Rocks', 'Dam',
                          'Inverted Big Bomb Shop', 'Tavern North', 'Chicken House', 'Aginahs Cave', 'Sahasrahlas Hut',
                          'Kakariko Well Drop', 'Kakariko Well Cave',
                          'Blacksmiths Hut', 'Bat Cave Drop Ledge', 'Bat Cave Cave', 'Sick Kids House', 'Hobo Bridge',
                          'Lost Woods Hideout Drop', 'Lost Woods Hideout Stump',
                          'Lumberjack Tree Tree', 'Lumberjack Tree Cave', 'Mini Moldorm Cave', 'Ice Rod Cave',
                          'Lake Hylia Central Island Pier', 'Lake Hylia Island Pier', 'Lake Hylia Warp',
                          'Bonk Rock Cave', 'Library', 'Two Brothers House (East)', 'Desert Palace Stairs',
                          'Eastern Palace', 'Master Sword Meadow',
                          'Sanctuary', 'Sanctuary Grave', 'Death Mountain Entrance Rock', 'Light World River Drop',
                          'Elder House (East)', 'Elder House (West)', 'North Fairy Cave', 'North Fairy Cave Drop',
                          'Lost Woods Gamble', 'Snitch Lady (East)', 'Snitch Lady (West)', 'Tavern (Front)',
                          'Kakariko Shop', 'Long Fairy Cave', 'Good Bee Cave', '20 Rupee Cave',
                          'Cave Shop (Lake Hylia)',
                          'Bonk Fairy (Light)', '50 Rupee Cave', 'Fortune Teller (Light)', 'Lake Hylia Fairy',
                          'Light Hype Fairy', 'Desert Fairy', 'Lumberjack House', 'Lake Hylia Fortune Teller',
                          'Kakariko Gamble Game',
                          'East Dark World Mirror Spot', 'West Dark World Mirror Spot', 'South Dark World Mirror Spot',
                          'Cave 45', 'Checkerboard Cave', 'Mire Mirror Spot', 'Hammer Peg Area Mirror Spot',
                          'Shopping Mall Mirror Spot', 'Skull Woods Mirror Spot', 'Inverted Pyramid Entrance',
                          'Hyrule Castle Entrance (South)', 'Secret Passage Outer Bushes',
                          'Bush Covered Lawn Outer Bushes',
                          'Potion Shop Outer Bushes', 'Graveyard Cave Outer Bushes', 'Bomb Hut Outer Bushes']),
        create_lw_region(multiworld, player, 'Bush Covered Lawn', None,
                         ['Bush Covered House', 'Bush Covered Lawn Inner Bushes', 'Bush Covered Lawn Mirror Spot']),
        create_lw_region(multiworld, player, 'Bomb Hut Area', None,
                         ['Light World Bomb Hut', 'Bomb Hut Inner Bushes', 'Bomb Hut Mirror Spot']),
        create_lw_region(multiworld, player, 'Hyrule Castle Secret Entrance Area', None,
                         ['Hyrule Castle Secret Entrance Stairs', 'Secret Passage Inner Bushes']),
        create_lw_region(multiworld, player, 'Death Mountain Entrance', None,
                         ['Old Man Cave (West)', 'Death Mountain Entrance Drop', 'Bumper Cave Entrance Mirror Spot']),
        create_lw_region(multiworld, player, 'Lake Hylia Central Island', None,
                         ['Capacity Upgrade', 'Lake Hylia Central Island Mirror Spot']),
        create_cave_region(multiworld, player, 'Blinds Hideout', 'a bounty of five items', ["Blind\'s Hideout - Top",
                                                                                       "Blind\'s Hideout - Left",
                                                                                       "Blind\'s Hideout - Right",
                                                                                       "Blind\'s Hideout - Far Left",
                                                                                       "Blind\'s Hideout - Far Right"]),
        create_lw_region(multiworld, player, 'Northeast Light World', None,
                         ['Zoras River', 'Waterfall of Wishing Cave', 'Potion Shop Outer Rock', 'Catfish Mirror Spot',
                          'Northeast Light World Warp']),
        create_lw_region(multiworld, player, 'Waterfall of Wishing Cave', None,
                         ['Waterfall of Wishing', 'Northeast Light World Return']),
        create_lw_region(multiworld, player, 'Potion Shop Area', None,
                         ['Potion Shop', 'Potion Shop Inner Bushes', 'Potion Shop Inner Rock',
                          'Potion Shop Mirror Spot', 'Potion Shop River Drop']),
        create_lw_region(multiworld, player, 'Graveyard Cave Area', None,
                         ['Graveyard Cave', 'Graveyard Cave Inner Bushes', 'Graveyard Cave Mirror Spot']),
        create_lw_region(multiworld, player, 'River', None, ['Light World Pier', 'Potion Shop Pier']),
        create_cave_region(multiworld, player, 'Hyrule Castle Secret Entrance', 'a drop\'s exit',
                           ['Link\'s Uncle', 'Secret Passage'], ['Hyrule Castle Secret Entrance Exit']),
        create_lw_region(multiworld, player, 'Zoras River', ['King Zora', 'Zora\'s Ledge']),
        create_cave_region(multiworld, player, 'Waterfall of Wishing', 'a cave with two chests',
                           ['Waterfall Fairy - Left', 'Waterfall Fairy - Right']),
        create_lw_region(multiworld, player, 'Kings Grave Area', None, ['Kings Grave', 'Kings Grave Inner Rocks']),
        create_cave_region(multiworld, player, 'Kings Grave', 'a cave with a chest', ['King\'s Tomb']),
        create_cave_region(multiworld, player, 'North Fairy Cave', 'a drop\'s exit', None, ['North Fairy Cave Exit']),
        create_cave_region(multiworld, player, 'Dam', 'the dam', ['Floodgate', 'Floodgate Chest']),
        create_cave_region(multiworld, player, 'Inverted Links House', 'your house', ['Link\'s House'],
                           ['Inverted Links House Exit']),
        create_cave_region(multiworld, player, 'Chris Houlihan Room', 'I AM ERROR', None, ['Chris Houlihan Room Exit']),
        create_cave_region(multiworld, player, 'Tavern', 'the tavern', ['Kakariko Tavern']),
        create_cave_region(multiworld, player, 'Elder House', 'a connector', None,
                           ['Elder House Exit (East)', 'Elder House Exit (West)']),
        create_cave_region(multiworld, player, 'Snitch Lady (East)', 'a boring house'),
        create_cave_region(multiworld, player, 'Snitch Lady (West)', 'a boring house'),
        create_cave_region(multiworld, player, 'Bush Covered House', 'the grass man'),
        create_cave_region(multiworld, player, 'Tavern (Front)', 'the tavern'),
        create_cave_region(multiworld, player, 'Light World Bomb Hut', 'a restock room'),
        create_cave_region(multiworld, player, 'Kakariko Shop', 'a common shop'),
        create_cave_region(multiworld, player, 'Fortune Teller (Light)', 'a fortune teller'),
        create_cave_region(multiworld, player, 'Lake Hylia Fortune Teller', 'a fortune teller'),
        create_cave_region(multiworld, player, 'Lumberjack House', 'a boring house'),
        create_cave_region(multiworld, player, 'Bonk Fairy (Light)', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Bonk Fairy (Dark)', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Lake Hylia Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Swamp Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Desert Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Dark Lake Hylia Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Dark Lake Hylia Ledge Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Dark Desert Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Dark Death Mountain Healer Fairy', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Chicken House', 'a house with a chest', ['Chicken House']),
        create_cave_region(multiworld, player, 'Aginahs Cave', 'a cave with a chest', ['Aginah\'s Cave']),
        create_cave_region(multiworld, player, 'Sahasrahlas Hut', 'Sahasrahla',
                           ['Sahasrahla\'s Hut - Left', 'Sahasrahla\'s Hut - Middle', 'Sahasrahla\'s Hut - Right',
                            'Sahasrahla']),
        create_cave_region(multiworld, player, 'Kakariko Well (top)', 'a drop\'s exit',
                           ['Kakariko Well - Top', 'Kakariko Well - Left', 'Kakariko Well - Middle',
                            'Kakariko Well - Right', 'Kakariko Well - Bottom'], ['Kakariko Well (top to bottom)']),
        create_cave_region(multiworld, player, 'Kakariko Well (bottom)', 'a drop\'s exit', None, ['Kakariko Well Exit']),
        create_cave_region(multiworld, player, 'Blacksmiths Hut', 'the smith', ['Blacksmith', 'Missing Smith']),
        create_lw_region(multiworld, player, 'Bat Cave Drop Ledge', None, ['Bat Cave Drop']),
        create_cave_region(multiworld, player, 'Bat Cave (right)', 'a drop\'s exit', ['Magic Bat'], ['Bat Cave Door']),
        create_cave_region(multiworld, player, 'Bat Cave (left)', 'a drop\'s exit', None, ['Bat Cave Exit']),
        create_cave_region(multiworld, player, 'Sick Kids House', 'the sick kid', ['Sick Kid']),
        create_lw_region(multiworld, player, 'Hobo Bridge', ['Hobo']),
        create_cave_region(multiworld, player, 'Lost Woods Hideout (top)', 'a drop\'s exit', ['Lost Woods Hideout'],
                           ['Lost Woods Hideout (top to bottom)']),
        create_cave_region(multiworld, player, 'Lost Woods Hideout (bottom)', 'a drop\'s exit', None,
                           ['Lost Woods Hideout Exit']),
        create_cave_region(multiworld, player, 'Lumberjack Tree (top)', 'a drop\'s exit', ['Lumberjack Tree'],
                           ['Lumberjack Tree (top to bottom)']),
        create_cave_region(multiworld, player, 'Lumberjack Tree (bottom)', 'a drop\'s exit', None, ['Lumberjack Tree Exit']),
        create_cave_region(multiworld, player, 'Cave 45', 'a cave with an item', ['Cave 45']),
        create_cave_region(multiworld, player, 'Graveyard Cave', 'a cave with an item', ['Graveyard Cave']),
        create_cave_region(multiworld, player, 'Checkerboard Cave', 'a cave with an item', ['Checkerboard Cave']),
        create_cave_region(multiworld, player, 'Long Fairy Cave', 'a fairy fountain'),
        create_cave_region(multiworld, player, 'Mini Moldorm Cave', 'a bounty of five items',
                           ['Mini Moldorm Cave - Far Left', 'Mini Moldorm Cave - Left', 'Mini Moldorm Cave - Right',
                            'Mini Moldorm Cave - Far Right', 'Mini Moldorm Cave - Generous Guy']),
        create_cave_region(multiworld, player, 'Ice Rod Cave', 'a cave with a chest', ['Ice Rod Cave']),
        create_cave_region(multiworld, player, 'Good Bee Cave', 'a cold bee'),
        create_cave_region(multiworld, player, '20 Rupee Cave', 'a cave with some cash'),
        create_cave_region(multiworld, player, 'Cave Shop (Lake Hylia)', 'a common shop'),
        create_cave_region(multiworld, player, 'Cave Shop (Dark Death Mountain)', 'a common shop'),
        create_cave_region(multiworld, player, 'Bonk Rock Cave', 'a cave with a chest', ['Bonk Rock Cave']),
        create_cave_region(multiworld, player, 'Library', 'the library', ['Library']),
        create_cave_region(multiworld, player, 'Kakariko Gamble Game', 'a game of chance'),
        create_cave_region(multiworld, player, 'Potion Shop', 'the potion shop', ['Potion Shop']),
        create_lw_region(multiworld, player, 'Lake Hylia Island', ['Lake Hylia Island']),
        create_cave_region(multiworld, player, 'Capacity Upgrade', 'the queen of fairies', ['Capacity Upgrade Shop']),
        create_cave_region(multiworld, player, 'Two Brothers House', 'a connector', None,
                           ['Two Brothers House Exit (East)', 'Two Brothers House Exit (West)']),
        create_lw_region(multiworld, player, 'Maze Race Ledge', ['Maze Race'],
                         ['Two Brothers House (West)', 'Maze Race Mirror Spot']),
        create_cave_region(multiworld, player, '50 Rupee Cave', 'a cave with some cash'),
        create_lw_region(multiworld, player, 'Desert Ledge', ['Desert Ledge'],
                         ['Desert Palace Entrance (North) Rocks', 'Desert Palace Entrance (West)',
                          'Desert Ledge Drop']),
        create_lw_region(multiworld, player, 'Desert Palace Stairs', None,
                         ['Desert Palace Entrance (South)', 'Desert Palace Stairs Mirror Spot']),
        create_lw_region(multiworld, player, 'Desert Palace Lone Stairs', None,
                         ['Desert Palace Stairs Drop', 'Desert Palace Entrance (East)']),
        create_lw_region(multiworld, player, 'Desert Palace Entrance (North) Spot', None,
                         ['Desert Palace Entrance (North)', 'Desert Ledge Return Rocks',
                          'Desert Palace North Mirror Spot']),
        create_dungeon_region(multiworld, player, 'Desert Palace Main (Outer)', 'Desert Palace', ['Desert Palace - Big Chest', 'Desert Palace - Torch', 'Desert Palace - Map Chest'],
                              ['Desert Palace Pots (Outer)', 'Desert Palace Exit (West)', 'Desert Palace Exit (East)', 'Desert Palace East Wing']),
        create_dungeon_region(multiworld, player, 'Desert Palace Main (Inner)', 'Desert Palace', None, ['Desert Palace Exit (South)', 'Desert Palace Pots (Inner)']),
        create_dungeon_region(multiworld, player, 'Desert Palace East', 'Desert Palace', ['Desert Palace - Compass Chest', 'Desert Palace - Big Key Chest']),
        create_dungeon_region(multiworld, player, 'Desert Palace North', 'Desert Palace',
                              ['Desert Palace - Desert Tiles 1 Pot Key', 'Desert Palace - Beamos Hall Pot Key',
                               'Desert Palace - Desert Tiles 2 Pot Key',
                               'Desert Palace - Boss', 'Desert Palace - Prize'], ['Desert Palace Exit (North)']),
        create_dungeon_region(multiworld, player, 'Eastern Palace', 'Eastern Palace',
                              ['Eastern Palace - Compass Chest', 'Eastern Palace - Big Chest',
                               'Eastern Palace - Cannonball Chest',
                               'Eastern Palace - Dark Square Pot Key', 'Eastern Palace - Dark Eyegore Key Drop',
                               'Eastern Palace - Big Key Chest',
                               'Eastern Palace - Map Chest', 'Eastern Palace - Boss', 'Eastern Palace - Prize'],
                              ['Eastern Palace Exit']),
        create_lw_region(multiworld, player, 'Master Sword Meadow', ['Master Sword Pedestal']),
        create_cave_region(multiworld, player, 'Lost Woods Gamble', 'a game of chance'),
        create_lw_region(multiworld, player, 'Hyrule Castle Ledge', None, ['Hyrule Castle Entrance (East)', 'Hyrule Castle Entrance (West)', 'Inverted Ganons Tower', 'Hyrule Castle Ledge Courtyard Drop', 'Inverted Pyramid Hole']),
        create_dungeon_region(multiworld, player, 'Hyrule Castle', 'Hyrule Castle',
                              ['Hyrule Castle - Boomerang Chest', 'Hyrule Castle - Map Chest',
                               'Hyrule Castle - Zelda\'s Chest',
                               'Hyrule Castle - Map Guard Key Drop', 'Hyrule Castle - Boomerang Guard Key Drop',
                               'Hyrule Castle - Big Key Drop'],
                              ['Hyrule Castle Exit (East)', 'Hyrule Castle Exit (West)', 'Hyrule Castle Exit (South)',
                               'Throne Room']),
        create_dungeon_region(multiworld, player, 'Sewer Drop', 'a drop\'s exit', None, ['Sewer Drop']),  # This exists only to be referenced for access checks
        create_dungeon_region(multiworld, player, 'Sewers (Dark)', 'a drop\'s exit', ['Sewers - Dark Cross', 'Sewers - Key Rat Key Drop'], ['Sewers Door']),
        create_dungeon_region(multiworld, player, 'Sewers', 'a drop\'s exit', None, ['Sanctuary Push Door', 'Sewers Back Door', 'Sewers Secret Room']),
        create_dungeon_region(multiworld, player, 'Sewers Secret Room', 'a drop\'s exit', ['Sewers - Secret Room - Left', 'Sewers - Secret Room - Middle',
                                         'Sewers - Secret Room - Right']),
        create_dungeon_region(multiworld, player, 'Sanctuary', 'a drop\'s exit', ['Sanctuary'], ['Sanctuary Exit']),
        create_dungeon_region(multiworld, player, 'Inverted Agahnims Tower', 'Castle Tower', ['Castle Tower - Room 03', 'Castle Tower - Dark Maze',  'Castle Tower - Dark Archer Key Drop', 'Castle Tower - Circle of Pots Key Drop'], ['Agahnim 1', 'Inverted Agahnims Tower Exit']),
        create_dungeon_region(multiworld, player, 'Agahnim 1', 'Castle Tower', ['Agahnim 1'], None),
        create_cave_region(multiworld, player, 'Old Man Cave', 'a connector', ['Old Man'],
                           ['Old Man Cave Exit (East)', 'Old Man Cave Exit (West)']),
        create_cave_region(multiworld, player, 'Old Man House', 'a connector', None,
                           ['Old Man House Exit (Bottom)', 'Old Man House Front to Back']),
        create_cave_region(multiworld, player, 'Old Man House Back', 'a connector', None,
                           ['Old Man House Exit (Top)', 'Old Man House Back to Front']),
        create_lw_region(multiworld, player, 'Death Mountain', None,
                         ['Old Man Cave (East)', 'Old Man House (Bottom)', 'Old Man House (Top)',
                          'Death Mountain Return Cave (East)', 'Spectacle Rock Cave',
                          'Spectacle Rock Cave Peak', 'Spectacle Rock Cave (Bottom)', 'Broken Bridge (West)',
                          'Death Mountain Mirror Spot']),
        create_cave_region(multiworld, player, 'Death Mountain Return Cave', 'a connector', None,
                           ['Death Mountain Return Cave Exit (West)', 'Death Mountain Return Cave Exit (East)']),
        create_lw_region(multiworld, player, 'Death Mountain Return Ledge', None,
                         ['Death Mountain Return Ledge Drop', 'Death Mountain Return Cave (West)',
                          'Bumper Cave Ledge Mirror Spot']),
        create_cave_region(multiworld, player, 'Spectacle Rock Cave (Top)', 'a connector', ['Spectacle Rock Cave'],
                           ['Spectacle Rock Cave Drop', 'Spectacle Rock Cave Exit (Top)']),
        create_cave_region(multiworld, player, 'Spectacle Rock Cave (Bottom)', 'a connector', None,
                           ['Spectacle Rock Cave Exit']),
        create_cave_region(multiworld, player, 'Spectacle Rock Cave (Peak)', 'a connector', None,
                           ['Spectacle Rock Cave Peak Drop', 'Spectacle Rock Cave Exit (Peak)']),
        create_lw_region(multiworld, player, 'East Death Mountain (Bottom)', None,
                         ['Broken Bridge (East)', 'Paradox Cave (Bottom)', 'Paradox Cave (Middle)',
                          'East Death Mountain Mirror Spot (Bottom)', 'Hookshot Fairy',
                          'Fairy Ascension Rocks', 'Spiral Cave (Bottom)']),
        create_cave_region(multiworld, player, 'Hookshot Fairy', 'fairies deep in a cave'),
        create_cave_region(multiworld, player, 'Paradox Cave Front', 'a connector', None,
                           ['Paradox Cave Push Block Reverse', 'Paradox Cave Exit (Bottom)',
                            'Light World Death Mountain Shop']),
        create_cave_region(multiworld, player, 'Paradox Cave Chest Area', 'a connector', ['Paradox Cave Lower - Far Left',
                                                                                     'Paradox Cave Lower - Left',
                                                                                     'Paradox Cave Lower - Right',
                                                                                     'Paradox Cave Lower - Far Right',
                                                                                     'Paradox Cave Lower - Middle',
                                                                                     'Paradox Cave Upper - Left',
                                                                                     'Paradox Cave Upper - Right'],
                           ['Paradox Cave Push Block', 'Paradox Cave Bomb Jump']),
        create_cave_region(multiworld, player, 'Paradox Cave', 'a connector', None,
                           ['Paradox Cave Exit (Middle)', 'Paradox Cave Exit (Top)', 'Paradox Cave Drop']),
        create_cave_region(multiworld, player, 'Light World Death Mountain Shop', 'a common shop'),
        create_lw_region(multiworld, player, 'East Death Mountain (Top)', ['Floating Island'],
                         ['Paradox Cave (Top)', 'Death Mountain (Top)', 'Spiral Cave Ledge Access',
                          'East Death Mountain Drop', 'East Death Mountain Mirror Spot (Top)',
                          'Fairy Ascension Ledge Access', 'Mimic Cave Ledge Access',
                          'Floating Island Mirror Spot']),
        create_lw_region(multiworld, player, 'Spiral Cave Ledge', None,
                         ['Spiral Cave', 'Spiral Cave Ledge Drop', 'Dark Death Mountain Ledge Mirror Spot (West)']),
        create_lw_region(multiworld, player, 'Mimic Cave Ledge', None,
                         ['Mimic Cave', 'Mimic Cave Ledge Drop', 'Dark Death Mountain Ledge Mirror Spot (East)']),
        create_cave_region(multiworld, player, 'Spiral Cave (Top)', 'a connector', ['Spiral Cave'],
                           ['Spiral Cave (top to bottom)', 'Spiral Cave Exit (Top)']),
        create_cave_region(multiworld, player, 'Spiral Cave (Bottom)', 'a connector', None, ['Spiral Cave Exit']),
        create_lw_region(multiworld, player, 'Fairy Ascension Plateau', None,
                         ['Fairy Ascension Drop', 'Fairy Ascension Cave (Bottom)']),
        create_cave_region(multiworld, player, 'Fairy Ascension Cave (Bottom)', 'a connector', None,
                           ['Fairy Ascension Cave Climb', 'Fairy Ascension Cave Exit (Bottom)']),
        create_cave_region(multiworld, player, 'Fairy Ascension Cave (Drop)', 'a connector', None,
                           ['Fairy Ascension Cave Pots']),
        create_cave_region(multiworld, player, 'Fairy Ascension Cave (Top)', 'a connector', None,
                           ['Fairy Ascension Cave Exit (Top)', 'Fairy Ascension Cave Drop']),
        create_lw_region(multiworld, player, 'Fairy Ascension Ledge', None,
                         ['Fairy Ascension Ledge Drop', 'Fairy Ascension Cave (Top)', 'Laser Bridge Mirror Spot']),
        create_lw_region(multiworld, player, 'Death Mountain (Top)', ['Ether Tablet', 'Spectacle Rock'],
                         ['East Death Mountain (Top)', 'Tower of Hera', 'Death Mountain Drop',
                          'Death Mountain (Top) Mirror Spot']),
        create_dw_region(multiworld, player, 'Bumper Cave Ledge', ['Bumper Cave Ledge'],
                         ['Bumper Cave Ledge Drop', 'Bumper Cave (Top)']),
        create_dungeon_region(multiworld, player, 'Tower of Hera (Bottom)', 'Tower of Hera', ['Tower of Hera - Basement Cage', 'Tower of Hera - Map Chest'], ['Tower of Hera Small Key Door', 'Tower of Hera Big Key Door', 'Tower of Hera Exit']),
        create_dungeon_region(multiworld, player, 'Tower of Hera (Basement)', 'Tower of Hera', ['Tower of Hera - Big Key Chest']),
        create_dungeon_region(multiworld, player, 'Tower of Hera (Top)', 'Tower of Hera', ['Tower of Hera - Compass Chest', 'Tower of Hera - Big Chest', 'Tower of Hera - Boss', 'Tower of Hera - Prize']),

        create_dw_region(multiworld, player, 'East Dark World', ['Pyramid'],
                         ['Pyramid Fairy', 'South Dark World Bridge', 'Palace of Darkness',
                          'Dark Lake Hylia Drop (East)',
                          'Dark Lake Hylia Fairy', 'Palace of Darkness Hint', 'East Dark World Hint',
                          'Northeast Dark World Broken Bridge Pass', 'East Dark World Teleporter', 'EDW Flute']),
        create_dw_region(multiworld, player, 'Catfish', ['Catfish'], ['Catfish Exit Rock']),
        create_dw_region(multiworld, player, 'Northeast Dark World', None,
                         ['West Dark World Gap', 'Dark World Potion Shop', 'East Dark World Broken Bridge Pass',
                          'NEDW Flute', 'Dark Lake Hylia Teleporter', 'Catfish Entrance Rock']),
        create_cave_region(multiworld, player, 'Palace of Darkness Hint', 'a storyteller'),
        create_cave_region(multiworld, player, 'East Dark World Hint', 'a storyteller'),
        create_dw_region(multiworld, player, 'South Dark World', ['Stumpy', 'Digging Game'],
                         ['Dark Lake Hylia Drop (South)', 'Hype Cave', 'Swamp Palace', 'Village of Outcasts Heavy Rock',
                          'East Dark World Bridge', 'Inverted Links House', 'Archery Game', 'Bonk Fairy (Dark)',
                          'Dark Lake Hylia Shop', 'South Dark World Teleporter', 'Post Aga Teleporter', 'SDW Flute']),
        create_cave_region(multiworld, player, 'Inverted Big Bomb Shop', 'the bomb shop'),
        create_cave_region(multiworld, player, 'Archery Game', 'a game of skill'),
        create_dw_region(multiworld, player, 'Dark Lake Hylia', None,
                         ['East Dark World Pier', 'Dark Lake Hylia Ledge Pier', 'Ice Palace Missing Wall']),
        create_dw_region(multiworld, player, 'Dark Lake Hylia Central Island', None,
                         ['Dark Lake Hylia Shallows', 'Ice Palace', 'Dark Lake Hylia Central Island Teleporter']),
        create_dw_region(multiworld, player, 'Dark Lake Hylia Ledge', None,
                         ['Dark Lake Hylia Ledge Drop', 'Dark Lake Hylia Ledge Fairy', 'Dark Lake Hylia Ledge Hint',
                          'Dark Lake Hylia Ledge Spike Cave', 'DLHL Flute']),
        create_cave_region(multiworld, player, 'Dark Lake Hylia Ledge Hint', 'a storyteller'),
        create_cave_region(multiworld, player, 'Dark Lake Hylia Ledge Spike Cave', 'a spiky hint'),
        create_cave_region(multiworld, player, 'Hype Cave', 'a bounty of five items',
                           ['Hype Cave - Top', 'Hype Cave - Middle Right', 'Hype Cave - Middle Left',
                            'Hype Cave - Bottom', 'Hype Cave - Generous Guy']),
        create_dw_region(multiworld, player, 'West Dark World', ['Frog', 'Flute Activation Spot'],
                         ['Village of Outcasts Drop', 'East Dark World River Pier', 'Brewery', 'C-Shaped House',
                          'Chest Game', 'Thieves Town', 'Bumper Cave Entrance Rock',
                          'Skull Woods Forest', 'Village of Outcasts Pegs', 'Village of Outcasts Eastern Rocks',
                          'Red Shield Shop', 'Inverted Dark Sanctuary', 'Fortune Teller (Dark)',
                          'Dark World Lumberjack Shop',
                          'West Dark World Teleporter', 'WDW Flute']),
        create_dw_region(multiworld, player, 'Dark Grassy Lawn', None,
                         ['Grassy Lawn Pegs', 'Village of Outcasts Shop', 'Dark Grassy Lawn Flute']),
        create_dw_region(multiworld, player, 'Hammer Peg Area', ['Dark Blacksmith Ruins'],
                         ['Dark World Hammer Peg Cave', 'Peg Area Rocks', 'Hammer Peg Area Flute']),
        create_dw_region(multiworld, player, 'Bumper Cave Entrance', None,
                         ['Bumper Cave (Bottom)', 'Bumper Cave Entrance Drop']),
        create_cave_region(multiworld, player, 'Fortune Teller (Dark)', 'a fortune teller'),
        create_cave_region(multiworld, player, 'Village of Outcasts Shop', 'a common shop'),
        create_cave_region(multiworld, player, 'Dark Lake Hylia Shop', 'a common shop'),
        create_cave_region(multiworld, player, 'Dark World Lumberjack Shop', 'a common shop'),
        create_cave_region(multiworld, player, 'Dark World Potion Shop', 'a common shop'),
        create_cave_region(multiworld, player, 'Dark World Hammer Peg Cave', 'a cave with an item', ['Peg Cave']),
        create_cave_region(multiworld, player, 'Pyramid Fairy', 'a cave with two chests',
                           ['Pyramid Fairy - Left', 'Pyramid Fairy - Right']),
        create_cave_region(multiworld, player, 'Brewery', 'a house with a chest', ['Brewery']),
        create_cave_region(multiworld, player, 'C-Shaped House', 'a house with a chest', ['C-Shaped House']),
        create_cave_region(multiworld, player, 'Chest Game', 'a game of 16 chests', ['Chest Game']),
        create_cave_region(multiworld, player, 'Red Shield Shop', 'the rare shop'),
        create_cave_region(multiworld, player, 'Inverted Dark Sanctuary', 'a storyteller', None,
                           ['Inverted Dark Sanctuary Exit']),
        create_cave_region(multiworld, player, 'Bumper Cave', 'a connector', None,
                           ['Bumper Cave Exit (Bottom)', 'Bumper Cave Exit (Top)']),
        create_dw_region(multiworld, player, 'Skull Woods Forest', None,
                         ['Skull Woods First Section Hole (East)', 'Skull Woods First Section Hole (West)',
                          'Skull Woods First Section Hole (North)',
                          'Skull Woods First Section Door', 'Skull Woods Second Section Door (East)']),
        create_dw_region(multiworld, player, 'Skull Woods Forest (West)', None,
                         ['Skull Woods Second Section Hole', 'Skull Woods Second Section Door (West)',
                          'Skull Woods Final Section']),
        create_dw_region(multiworld, player, 'Dark Desert', None,
                         ['Misery Mire', 'Mire Shed', 'Dark Desert Hint', 'Dark Desert Fairy', 'DD Flute']),
        create_dw_region(multiworld, player, 'Dark Desert Ledge', None, ['Dark Desert Drop', 'Dark Desert Teleporter']),
        create_cave_region(multiworld, player, 'Mire Shed', 'a cave with two chests',
                           ['Mire Shed - Left', 'Mire Shed - Right']),
        create_cave_region(multiworld, player, 'Dark Desert Hint', 'a storyteller'),
        create_dw_region(multiworld, player, 'Dark Death Mountain', None,
                         ['Dark Death Mountain Drop (East)', 'Inverted Agahnims Tower', 'Superbunny Cave (Top)',
                          'Hookshot Cave', 'Turtle Rock',
                          'Spike Cave', 'Dark Death Mountain Fairy', 'Dark Death Mountain Teleporter (West)',
                          'Turtle Rock Tail Drop', 'DDM Flute']),
        create_dw_region(multiworld, player, 'Dark Death Mountain Ledge', None,
                         ['Dark Death Mountain Ledge (East)', 'Dark Death Mountain Ledge (West)']),
        create_dw_region(multiworld, player, 'Turtle Rock (Top)', None,
                         ['Dark Death Mountain Teleporter (East)', 'Turtle Rock Drop']),
        create_dw_region(multiworld, player, 'Dark Death Mountain Isolated Ledge', None,
                         ['Turtle Rock Isolated Ledge Entrance']),
        create_dw_region(multiworld, player, 'Dark Death Mountain (East Bottom)', None,
                         ['Superbunny Cave (Bottom)', 'Cave Shop (Dark Death Mountain)',
                          'Dark Death Mountain Teleporter (East Bottom)', 'EDDM Flute']),
        create_cave_region(multiworld, player, 'Superbunny Cave (Top)', 'a connector',
                           ['Superbunny Cave - Top', 'Superbunny Cave - Bottom'], ['Superbunny Cave Exit (Top)']),
        create_cave_region(multiworld, player, 'Superbunny Cave (Bottom)', 'a connector', None,
                           ['Superbunny Cave Climb', 'Superbunny Cave Exit (Bottom)']),
        create_cave_region(multiworld, player, 'Spike Cave', 'Spike Cave', ['Spike Cave']),
        create_cave_region(multiworld, player, 'Hookshot Cave', 'a connector',
                           ['Hookshot Cave - Top Right', 'Hookshot Cave - Top Left', 'Hookshot Cave - Bottom Right',
                            'Hookshot Cave - Bottom Left'],
                           ['Hookshot Cave Exit (South)', 'Hookshot Cave Bomb Wall (South)']),
        create_cave_region(multiworld, player, 'Hookshot Cave (Upper)', 'a connector', None, ['Hookshot Cave Exit (North)',
                                                                                         'Hookshot Cave Bomb Wall (North)']),
        create_dw_region(multiworld, player, 'Death Mountain Floating Island (Dark World)', None,
                         ['Floating Island Drop', 'Hookshot Cave Back Entrance']),
        create_cave_region(multiworld, player, 'Mimic Cave', 'Mimic Cave', ['Mimic Cave']),

        create_dungeon_region(multiworld, player, 'Swamp Palace (Entrance)', 'Swamp Palace', None, ['Swamp Palace Moat', 'Swamp Palace Exit']),
        create_dungeon_region(multiworld, player, 'Swamp Palace (First Room)', 'Swamp Palace', ['Swamp Palace - Entrance'], ['Swamp Palace Small Key Door']),
        create_dungeon_region(multiworld, player, 'Swamp Palace (Starting Area)', 'Swamp Palace', ['Swamp Palace - Map Chest', 'Swamp Palace - Pot Row Pot Key',
                                                                                       'Swamp Palace - Trench 1 Pot Key'], ['Swamp Palace (Center)']),
        create_dungeon_region(multiworld, player, 'Swamp Palace (Center)', 'Swamp Palace', ['Swamp Palace - Big Chest', 'Swamp Palace - Compass Chest', 'Swamp Palace - Hookshot Pot Key',
                                                                                'Swamp Palace - Trench 2 Pot Key'], ['Swamp Palace (North)', 'Swamp Palace (West)']),
        create_dungeon_region(multiworld, player, 'Swamp Palace (West)', 'Swamp Palace', ['Swamp Palace - Big Key Chest', 'Swamp Palace - West Chest']),
        create_dungeon_region(multiworld, player, 'Swamp Palace (North)', 'Swamp Palace', ['Swamp Palace - Flooded Room - Left', 'Swamp Palace - Flooded Room - Right',
                                                                               'Swamp Palace - Waterway Pot Key', 'Swamp Palace - Waterfall Room',
                                                                               'Swamp Palace - Boss', 'Swamp Palace - Prize']),
        create_dungeon_region(multiworld, player, 'Thieves Town (Entrance)', 'Thieves\' Town', ['Thieves\' Town - Big Key Chest',
                                                                            'Thieves\' Town - Map Chest',
                                                                            'Thieves\' Town - Compass Chest',
                                                                            'Thieves\' Town - Ambush Chest'], ['Thieves Town Big Key Door', 'Thieves Town Exit']),
        create_dungeon_region(multiworld, player, 'Thieves Town (Deep)', 'Thieves\' Town', ['Thieves\' Town - Attic',
                                                                                'Thieves\' Town - Big Chest',
                                                                                'Thieves\' Town - Hallway Pot Key',
                                                                                'Thieves\' Town - Spike Switch Pot Key',
                                                                                'Thieves\' Town - Blind\'s Cell'],
                              ['Blind Fight']),
        create_dungeon_region(multiworld, player, 'Blind Fight', 'Thieves\' Town', ['Thieves\' Town - Boss', 'Thieves\' Town - Prize']),
        create_dungeon_region(multiworld, player, 'Skull Woods First Section', 'Skull Woods', ['Skull Woods - Map Chest'], ['Skull Woods First Section Exit', 'Skull Woods First Section Bomb Jump', 'Skull Woods First Section South Door', 'Skull Woods First Section West Door']),
        create_dungeon_region(multiworld, player, 'Skull Woods First Section (Right)', 'Skull Woods', ['Skull Woods - Pinball Room'], ['Skull Woods First Section (Right) North Door']),
        create_dungeon_region(multiworld, player, 'Skull Woods First Section (Left)', 'Skull Woods', ['Skull Woods - Compass Chest', 'Skull Woods - Pot Prison'], ['Skull Woods First Section (Left) Door to Exit', 'Skull Woods First Section (Left) Door to Right']),
        create_dungeon_region(multiworld, player, 'Skull Woods First Section (Top)', 'Skull Woods', ['Skull Woods - Big Chest'], ['Skull Woods First Section (Top) One-Way Path']),
        create_dungeon_region(multiworld, player, 'Skull Woods Second Section (Drop)', 'Skull Woods', None, ['Skull Woods Second Section (Drop)']),
        create_dungeon_region(multiworld, player, 'Skull Woods Second Section', 'Skull Woods', ['Skull Woods - Big Key Chest', 'Skull Woods - West Lobby Pot Key'], ['Skull Woods Second Section Exit (East)', 'Skull Woods Second Section Exit (West)']),
        create_dungeon_region(multiworld, player, 'Skull Woods Final Section (Entrance)', 'Skull Woods', ['Skull Woods - Bridge Room'], ['Skull Woods Torch Room', 'Skull Woods Final Section Exit']),
        create_dungeon_region(multiworld, player, 'Skull Woods Final Section (Mothula)', 'Skull Woods', ['Skull Woods - Spike Corner Key Drop', 'Skull Woods - Boss', 'Skull Woods - Prize']),
        create_dungeon_region(multiworld, player, 'Ice Palace (Entrance)', 'Ice Palace', ['Ice Palace - Jelly Key Drop', 'Ice Palace - Compass Chest'], ['Ice Palace (Second Section)', 'Ice Palace Exit']),
        create_dungeon_region(multiworld, player, 'Ice Palace (Second Section)', 'Ice Palace', ['Ice Palace - Conveyor Key Drop'], ['Ice Palace (Main)']),
        create_dungeon_region(multiworld, player, 'Ice Palace (Main)', 'Ice Palace', ['Ice Palace - Freezor Chest',
                                                                          'Ice Palace - Many Pots Pot Key',
                                                                  'Ice Palace - Big Chest', 'Ice Palace - Iced T Room'], ['Ice Palace (East)', 'Ice Palace (Kholdstare)']),
        create_dungeon_region(multiworld, player, 'Ice Palace (East)', 'Ice Palace', ['Ice Palace - Spike Room'], ['Ice Palace (East Top)']),
        create_dungeon_region(multiworld, player, 'Ice Palace (East Top)', 'Ice Palace', ['Ice Palace - Big Key Chest', 'Ice Palace - Map Chest', 'Ice Palace - Hammer Block Key Drop']),
        create_dungeon_region(multiworld, player, 'Ice Palace (Kholdstare)', 'Ice Palace', ['Ice Palace - Boss', 'Ice Palace - Prize']),
        create_dungeon_region(multiworld, player, 'Misery Mire (Entrance)', 'Misery Mire', None, ['Misery Mire Entrance Gap', 'Misery Mire Exit']),
        create_dungeon_region(multiworld, player, 'Misery Mire (Main)', 'Misery Mire', ['Misery Mire - Big Chest', 'Misery Mire - Map Chest', 'Misery Mire - Main Lobby',
                                                                    'Misery Mire - Bridge Chest', 'Misery Mire - Spike Chest',
                                                                    'Misery Mire - Spikes Pot Key', 'Misery Mire - Fishbone Pot Key',
                                                                    'Misery Mire - Conveyor Crystal Key Drop'], ['Misery Mire (West)', 'Misery Mire Big Key Door']),
        create_dungeon_region(multiworld, player, 'Misery Mire (West)', 'Misery Mire', ['Misery Mire - Compass Chest', 'Misery Mire - Big Key Chest']),
        create_dungeon_region(multiworld, player, 'Misery Mire (Final Area)', 'Misery Mire', None, ['Misery Mire (Vitreous)']),
        create_dungeon_region(multiworld, player, 'Misery Mire (Vitreous)', 'Misery Mire', ['Misery Mire - Boss', 'Misery Mire - Prize']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Entrance)', 'Turtle Rock', None, ['Turtle Rock Entrance Gap', 'Turtle Rock Exit (Front)']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (First Section)', 'Turtle Rock', ['Turtle Rock - Compass Chest', 'Turtle Rock - Roller Room - Left',
                                                                             'Turtle Rock - Roller Room - Right'],
                                                                             ['Turtle Rock Entrance to Pokey Room', 'Turtle Rock Entrance Gap Reverse']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Pokey Room)', 'Turtle Rock', ['Turtle Rock - Pokey 1 Key Drop'], ['Turtle Rock (Pokey Room) (North)', 'Turtle Rock (Pokey Room) (South)']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Chain Chomp Room)', 'Turtle Rock', ['Turtle Rock - Chain Chomps'],
                              ['Turtle Rock (Chain Chomp Room) (North)', 'Turtle Rock (Chain Chomp Room) (South)']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Second Section)', 'Turtle Rock',
                              ['Turtle Rock - Big Key Chest', 'Turtle Rock - Pokey 2 Key Drop'],
                              ['Turtle Rock Chain Chomp Staircase', 'Turtle Rock Big Key Door',
                               'Turtle Rock Second Section Bomb Wall']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Second Section Bomb Wall)', 'Turtle Rock', None, ['Turtle Rock Ledge Exit (West)', 'Turtle Rock Second Section from Bomb Wall']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Big Chest)', 'Turtle Rock', ['Turtle Rock - Big Chest'], ['Turtle Rock (Big Chest) (North)', 'Turtle Rock Ledge Exit (East)']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Crystaroller Room)', 'Turtle Rock', ['Turtle Rock - Crystaroller Room'], ['Turtle Rock Dark Room Staircase', 'Turtle Rock Big Key Door Reverse']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Dark Room)', 'Turtle Rock', None, ['Turtle Rock (Dark Room) (North)', 'Turtle Rock (Dark Room) (South)']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Eye Bridge Bomb Wall)', 'Turtle Rock', None, ['Turtle Rock Isolated Ledge Exit', 'Turtle Rock Eye Bridge from Bomb Wall']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Eye Bridge)', 'Turtle Rock', ['Turtle Rock - Eye Bridge - Bottom Left', 'Turtle Rock - Eye Bridge - Bottom Right',
                                                                          'Turtle Rock - Eye Bridge - Top Left', 'Turtle Rock - Eye Bridge - Top Right'],
                              ['Turtle Rock Dark Room (South)', 'Turtle Rock (Trinexx)', 'Turtle Rock Eye Bridge Bomb Wall']),
        create_dungeon_region(multiworld, player, 'Turtle Rock (Trinexx)', 'Turtle Rock', ['Turtle Rock - Boss', 'Turtle Rock - Prize']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Entrance)', 'Palace of Darkness', ['Palace of Darkness - Shooter Room'], ['Palace of Darkness Bridge Room', 'Palace of Darkness Bonk Wall', 'Palace of Darkness Exit']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Center)', 'Palace of Darkness', ['Palace of Darkness - The Arena - Bridge', 'Palace of Darkness - Stalfos Basement'],
                              ['Palace of Darkness Big Key Chest Staircase', 'Palace of Darkness (North)', 'Palace of Darkness Big Key Door']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Big Key Chest)', 'Palace of Darkness', ['Palace of Darkness - Big Key Chest']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Bonk Section)', 'Palace of Darkness', ['Palace of Darkness - The Arena - Ledge', 'Palace of Darkness - Map Chest'], ['Palace of Darkness Hammer Peg Drop']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (North)', 'Palace of Darkness', ['Palace of Darkness - Compass Chest', 'Palace of Darkness - Dark Basement - Left', 'Palace of Darkness - Dark Basement - Right'],
                              ['Palace of Darkness Spike Statue Room Door', 'Palace of Darkness Maze Door']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Maze)', 'Palace of Darkness', ['Palace of Darkness - Dark Maze - Top', 'Palace of Darkness - Dark Maze - Bottom', 'Palace of Darkness - Big Chest']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Harmless Hellway)', 'Palace of Darkness', ['Palace of Darkness - Harmless Hellway']),
        create_dungeon_region(multiworld, player, 'Palace of Darkness (Final Section)', 'Palace of Darkness', ['Palace of Darkness - Boss', 'Palace of Darkness - Prize']),
        create_dungeon_region(multiworld, player, 'Inverted Ganons Tower (Entrance)', 'Ganon\'s Tower',
                              ['Ganons Tower - Bob\'s Torch', 'Ganons Tower - Hope Room - Left',
                               'Ganons Tower - Hope Room - Right', 'Ganons Tower - Conveyor Cross Pot Key'],
                              ['Ganons Tower (Tile Room)', 'Ganons Tower (Hookshot Room)', 'Ganons Tower Big Key Door',
                               'Inverted Ganons Tower Exit']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Tile Room)', 'Ganon\'s Tower', ['Ganons Tower - Tile Room'],
                              ['Ganons Tower (Tile Room) Key Door']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Compass Room)', 'Ganon\'s Tower',
                              ['Ganons Tower - Compass Room - Top Left', 'Ganons Tower - Compass Room - Top Right',
                               'Ganons Tower - Compass Room - Bottom Left',
                               'Ganons Tower - Compass Room - Bottom Right',
                               'Ganons Tower - Conveyor Star Pits Pot Key'],
                              ['Ganons Tower (Bottom) (East)']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Hookshot Room)', 'Ganon\'s Tower',
                              ['Ganons Tower - DMs Room - Top Left', 'Ganons Tower - DMs Room - Top Right',
                               'Ganons Tower - DMs Room - Bottom Left', 'Ganons Tower - DMs Room - Bottom Right',
                               'Ganons Tower - Double Switch Pot Key'],
                              ['Ganons Tower (Map Room)', 'Ganons Tower (Double Switch Room)']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Map Room)', 'Ganon\'s Tower', ['Ganons Tower - Map Chest']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Firesnake Room)', 'Ganon\'s Tower',
                              ['Ganons Tower - Firesnake Room'], ['Ganons Tower (Firesnake Room)']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Teleport Room)', 'Ganon\'s Tower',
                              ['Ganons Tower - Randomizer Room - Top Left',
                               'Ganons Tower - Randomizer Room - Top Right',
                               'Ganons Tower - Randomizer Room - Bottom Left',
                               'Ganons Tower - Randomizer Room - Bottom Right'],
                              ['Ganons Tower (Bottom) (West)']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Bottom)', 'Ganon\'s Tower',
                              ['Ganons Tower - Bob\'s Chest', 'Ganons Tower - Big Chest',
                               'Ganons Tower - Big Key Room - Left',
                               'Ganons Tower - Big Key Room - Right', 'Ganons Tower - Big Key Chest']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Top)', 'Ganon\'s Tower', None, ['Ganons Tower Torch Rooms']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Before Moldorm)', 'Ganon\'s Tower',
                              ['Ganons Tower - Mini Helmasaur Room - Left',
                               'Ganons Tower - Mini Helmasaur Room - Right',
                               'Ganons Tower - Pre-Moldorm Chest', 'Ganons Tower - Mini Helmasaur Key Drop'],
                              ['Ganons Tower Moldorm Door']),
        create_dungeon_region(multiworld, player, 'Ganons Tower (Moldorm)', 'Ganon\'s Tower', None, ['Ganons Tower Moldorm Gap']),

        create_dungeon_region(multiworld, player, 'Agahnim 2', 'Ganon\'s Tower', ['Ganons Tower - Validation Chest', 'Agahnim 2'], None),
        create_cave_region(multiworld, player, 'Pyramid', 'a drop\'s exit', ['Ganon'], ['Ganon Drop']),
        create_cave_region(multiworld, player, 'Bottom of Pyramid', 'a drop\'s exit', None, ['Pyramid Exit']),
        create_dw_region(multiworld, player, 'Pyramid Ledge', None, ['Pyramid Drop']),  # houlihan room exits here in inverted
        
        # to simplify flute connections
        create_cave_region(multiworld, player, 'The Sky', 'A Dark Sky', None,
                           ['DDM Landing', 'NEDW Landing', 'WDW Landing', 'SDW Landing', 'EDW Landing', 'DD Landing',
                            'DLHL Landing']),

        create_lw_region(multiworld, player, 'Desert Northern Cliffs'),
        create_lw_region(multiworld, player, 'Death Mountain Bunny Descent Area')
    ]


def mark_dark_world_regions(multiworld, player):
    # cross world caves may have some sections marked as both in_light_world, and in_dark_work.
    # That is ok. the bunny logic will check for this case and incorporate special rules.
    queue = collections.deque(region for region in multiworld.get_regions(player) if region.type == LTTPRegionType.DarkWorld)
    seen = set(queue)
    while queue:
        current = queue.popleft()
        current.is_dark_world = True
        for exit in current.exits:
            if exit.connected_region.type == LTTPRegionType.LightWorld:
                # Don't venture into the dark world
                continue
            if exit.connected_region not in seen:
                seen.add(exit.connected_region)
                queue.append(exit.connected_region)

    queue = collections.deque(region for region in multiworld.get_regions(player) if region.type == LTTPRegionType.LightWorld)
    seen = set(queue)
    while queue:
        current = queue.popleft()
        current.is_light_world = True
        for exit in current.exits:
            if exit.connected_region.type == LTTPRegionType.DarkWorld:
                # Don't venture into the light world
                continue
            if exit.connected_region not in seen:
                seen.add(exit.connected_region)
                queue.append(exit.connected_region)
