"""Stores the data for the locations of colored bananas and balloons in Angry Aztec."""

from randomizer.Enums.Kongs import Kongs
from randomizer.Enums.Levels import Levels
from randomizer.Enums.Regions import Regions
from randomizer.Enums.Maps import Maps
from randomizer.Enums.Settings import RemovedBarriersSelected
from randomizer.LogicClasses import Balloon, ColoredBananaGroup

ColoredBananaGroupList = [
    ColoredBananaGroup(
        group=1,
        map_id=Maps.CreepyCastle,
        name="Around DK portal platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 240, 392, 427],
            [1, 1.0, 163, 392, 377],
            [1, 1.0, 161, 392, 281],
            [1, 1.0, 228, 392, 210],
            [1, 1.0, 338, 392, 241],
        ],
    ),
    ColoredBananaGroup(
        group=2,
        map_id=Maps.CreepyCastle,
        name="Center of DK portal platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 260, 400, 310]],
    ),
    ColoredBananaGroup(
        group=3,
        map_id=Maps.CreepyCastle,
        name="Around small pool outside tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 723, 392, 147],
            [1, 1.0, 773, 392, 110],
            [1, 1.0, 843, 392, 88],
            [1, 1.0, 929, 392, 102],
            [1, 1.0, 995, 392, 168],
        ],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.CreepyCastle,
        name="On tree by small pool outside big tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 700, 420, 170], [1, 1.0, 698, 455, 172]],
    ),
    ColoredBananaGroup(
        group=4,
        map_id=Maps.CreepyCastle,
        name="On tree by small pool outside big tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 688, 490, 175], [1, 1.0, 680, 525, 180], [1, 1.0, 675, 560, 180]],
    ),
    ColoredBananaGroup(
        group=5,
        map_id=Maps.CreepyCastle,
        name="On steps to big tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 732, 392, 341],
            [1, 1.0, 795, 408, 360],
            [1, 1.0, 860, 424, 371],
            [1, 1.0, 925, 440, 371],
            [1, 1.0, 986, 456, 371],
        ],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.CreepyCastle,
        name="On tree by big tree (Tiny coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1075, 500, 164], [1, 1.0, 1080, 535, 165]],
    ),
    ColoredBananaGroup(
        group=6,
        map_id=Maps.CreepyCastle,
        name="On tree by big tree (Tiny coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 1090, 570, 150], [1, 1.0, 1100, 605, 147], [1, 1.0, 1100, 640, 147]],
    ),
    ColoredBananaGroup(
        group=7,
        map_id=Maps.CreepyCastle,
        name="On branch sticking out of big tree",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[5, 1.0, 1228, 610, 191]],
    ),
    ColoredBananaGroup(
        group=8,
        map_id=Maps.CreepyCastle,
        name="On big tree",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1240, 770, 230]],
    ),
    ColoredBananaGroup(
        group=9,
        map_id=Maps.CreepyCastle,
        name="On BBlast pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1382, 485, 195]],
    ),
    ColoredBananaGroup(
        group=10,
        map_id=Maps.CreepyCastle,
        name="On sewer pipe",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1006, 460, 268]],
    ),
    ColoredBananaGroup(
        group=11,
        map_id=Maps.CreepyCastle,
        name="Around big tree platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1546, 472, 290],
            [1, 1.0, 1506, 472, 223],
            [1, 1.0, 1466, 472, 156],
            [1, 1.0, 1426, 472, 89],
            [1, 1.0, 1346, 472, 70],
            [1, 1.0, 1266, 472, 51],
            [1, 1.0, 1185, 472, 37],
            [1, 1.0, 1125, 472, 83],
            [1, 1.0, 1032, 472, 154],
            [1, 1.0, 1032, 472, 284],
        ],
    ),
    ColoredBananaGroup(
        group=12,
        map_id=Maps.CreepyCastle,
        name="Path from big tree to first moving platforms (5 custom, 5 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1571, 474, 462],
            [1, 1.0, 1741, 489, 625],
            [1, 1.0, 1816, 507, 798],
            [1, 1.0, 1906, 484, 970],
            [1, 1.0, 1996, 485, 1126],
            [1, 1.0, 1482.9063720703125, 471.7508239746094, 410.7468566894531],
            [1, 1.0, 1682.87060546875, 476.8399658203125, 516.9596557617188],
            [1, 1.0, 1783.7528076171875, 498.9047546386719, 716.6826782226562],
            [1, 1.0, 1856.03955078125, 499.2713317871094, 874.0015258789062],
            [1, 1.0, 1951.1243896484375, 471.5587463378906, 1051.5426025390625],
        ],
    ),
    ColoredBananaGroup(
        group=13,
        map_id=Maps.CreepyCastle,
        name="Path from first moving platforms to staircase (not including) (4 custom, 6 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1944, 505, 1560],
            [1, 1.0, 1859, 518, 1726],
            [1, 1.0, 1703, 524, 1807],
            [1, 1.0, 1526, 524, 1810],
            [1, 1.0, 1996.7034912109375, 503.2200012207031, 1330.90380859375],
            [1, 1.0, 1983.5025634765625, 499.3127136230469, 1479.400390625],
            [1, 1.0, 2003.8294677734375, 498.432861328125, 1233.9351806640625],
            [1, 1.0, 1899.38671875, 512.4110717773438, 1643.1041259765625],
            [1, 1.0, 1793.7056884765625, 523.6666870117188, 1796.6204833984375],
            [1, 1.0, 1607.0909423828125, 523.94580078125, 1809.3326416015625],
        ],
    ),
    ColoredBananaGroup(
        group=14,
        map_id=Maps.CreepyCastle,
        name="Along side of staircase to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1419, 524, 1809],
            [1, 1.0, 1372, 524, 1780],
            [1, 1.0, 1325, 524, 1750],
            [1, 1.0, 1278, 524, 1720],
            [1, 1.0, 1230, 524, 1691],
        ],
    ),
    ColoredBananaGroup(
        group=15,
        map_id=Maps.CreepyCastle,
        name="On staircase to W1 (1 custom, 4 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1191, 648, 1634],
            [1, 1.0, 1250.8035888671875, 632.3333129882812, 1649.8541259765625],
            [1, 1.0, 1315.537841796875, 600.3333129882812, 1689.6029052734375],
            [1, 1.0, 1375.5775146484375, 568.3333129882812, 1729.61767578125],
            [1, 1.0, 1443.1025390625, 536.3333129882812, 1773.4937744140625],
        ],
    ),
    ColoredBananaGroup(
        group=16,
        map_id=Maps.CreepyCastle,
        name="On stones on path from moving platforms to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 2020, 520, 1523], [5, 1.0, 1972, 540, 1645], [5, 1.0, 1874, 555, 1859]],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.CreepyCastle,
        name="On tree by staircase to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1483, 545, 1965], [1, 1.0, 1479, 580, 1965]],
    ),
    ColoredBananaGroup(
        group=17,
        map_id=Maps.CreepyCastle,
        name="On tree by staircase to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 1465, 615, 1965], [1, 1.0, 1459, 650, 1965], [1, 1.0, 1457, 685, 1965]],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.CreepyCastle,
        name="On tree by low T&S portal (by Lanky coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[1, 1.0, 1738, 400, 2052], [1, 1.0, 1737, 435, 2050]],
    ),
    ColoredBananaGroup(
        group=18,
        map_id=Maps.CreepyCastle,
        name="On tree by low T&S portal (by Lanky coins)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 1724, 470, 2055], [1, 1.0, 1715, 505, 2053], [1, 1.0, 1712, 540, 2051]],
    ),
    ColoredBananaGroup(
        group=19,
        map_id=Maps.CreepyCastle,
        name="Path from crypt to low T&S portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[
            [1, 1.0, 1068, 366, 1878],
            [1, 1.0, 1132, 366, 1948],
            [1, 1.0, 1165, 366, 2039],
            [1, 1.0, 1214, 366, 2126],
            [1, 1.0, 1330, 366, 2120],
            [1, 1.0, 1423, 366, 2124],
            [1, 1.0, 1520, 366, 2111],
            [1, 1.0, 1578, 366, 2075],
            [1, 1.0, 1655, 370, 2020],
            [1, 1.0, 1700, 372, 1940],
        ],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.CreepyCastle,
        name="On ladder from W1 stairs to crypt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[1, 1.0, 1186, 385, 1969], [1, 1.0, 1186, 415, 1969]],
    ),
    ColoredBananaGroup(
        group=20,
        map_id=Maps.CreepyCastle,
        name="On ladder from W1 stairs to crypt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,  # Climbing requirement is implied in the logicRegion
        locations=[[1, 1.0, 1186, 445, 1969], [1, 1.0, 1186, 475, 1969], [1, 1.0, 1186, 505, 1969]],
    ),
    ColoredBananaGroup(
        group=21,
        map_id=Maps.CreepyCastle,
        name="Path from Crypt to Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[
            [1, 1.0, 948, 366, 1884],
            [1, 1.0, 899, 366, 1940],
            [1, 1.0, 868, 366, 2047],
            [1, 1.0, 808, 366, 2120],
            [1, 1.0, 703, 366, 2107],
            [1, 1.0, 605, 366, 2067],
            [1, 1.0, 518, 366, 2040],
            [1, 1.0, 462, 366, 1971],
            [1, 1.0, 398, 366, 1918],
            [1, 1.0, 325, 366, 1854],
            [1, 1.0, 258, 366, 1805],
            [1, 1.0, 168, 366, 1754],
            [1, 1.0, 117, 375, 1687],
            [1, 1.0, 86, 389, 1602],
            [1, 1.0, 80, 399, 1521],
            [1, 1.0, 69, 407, 1444],
            [1, 1.0, 58, 408, 1380],
            [1, 1.0, 47, 406, 1310],
            [1, 1.0, 46, 402, 1253],
            [1, 1.0, 31, 397, 1146],
        ],
    ),
    ColoredBananaGroup(
        group=22,
        map_id=Maps.CreepyCastle,
        name="On Tiny BP platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[5, 1.0, 64, 398, 943], [5, 1.0, 80, 391, 866]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.CreepyCastle,
        name="On ladder from past crypt to random platform below/past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[1, 1.0, 579, 380, 2017], [1, 1.0, 579, 410, 2016]],
    ),
    ColoredBananaGroup(
        group=23,
        map_id=Maps.CreepyCastle,
        name="On ladder from past crypt to random platform below/past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,  # Climbing requirement is implied in the logicRegion
        locations=[[1, 1.0, 579, 440, 2015], [1, 1.0, 579, 470, 2014], [1, 1.0, 578, 500, 2013]],
    ),
    ColoredBananaGroup(
        group=24,
        map_id=Maps.CreepyCastle,
        name="On pile of bricks on random platform past/below W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[[5, 1.0, 575, 560, 1742]],
    ),
    ColoredBananaGroup(
        group=25,
        map_id=Maps.CreepyCastle,
        name="Below moving platforms past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[
            [1, 1.0, 694, 524, 1661],
            [1, 1.0, 641, 524, 1645],
            [1, 1.0, 588, 524, 1629],
            [1, 1.0, 535, 524, 1612],
            [1, 1.0, 482, 524, 1596],
        ],
    ),
    ColoredBananaGroup(
        group=26,
        map_id=Maps.CreepyCastle,
        name="Around random platform past/below W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[
            [1, 1.0, 405, 524, 1668],
            [1, 1.0, 422, 521, 1727],
            [1, 1.0, 431, 517, 1801],
            [1, 1.0, 476, 517, 1862],
            [1, 1.0, 522, 516, 1928],
            [1, 1.0, 612, 516, 1983],
            [1, 1.0, 702, 516, 2020],
            [1, 1.0, 764, 516, 2039],
            [1, 1.0, 794, 516, 1947],
            [1, 1.0, 811, 516, 1856],
        ],
    ),
    ColoredBananaGroup(
        group=27,
        map_id=Maps.CreepyCastle,
        name="W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1024, 662, 1657], [5, 1.0, 1534, 688, 799]],
    ),
    ColoredBananaGroup(
        group=28,
        map_id=Maps.CreepyCastle,
        name="W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1385, 688, 633], [5, 1.0, 1900, 918, 950]],
    ),
    ColoredBananaGroup(
        group=29,
        map_id=Maps.CreepyCastle,
        name="W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1214, 688, 582], [5, 1.0, 389, 1150, 1394]],
    ),
    ColoredBananaGroup(
        group=30,
        map_id=Maps.CreepyCastle,
        name="W4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1083, 688, 583], [5, 1.0, 1536, 1395, 1770]],
    ),
    ColoredBananaGroup(
        group=31,
        map_id=Maps.CreepyCastle,
        name="W5",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 939, 688, 652], [5, 1.0, 1341, 1745, 1120]],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.CreepyCastle,
        name="On tree on platform past/below W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[[1, 1.0, 649, 545, 1935], [1, 1.0, 647, 580, 1930]],
    ),
    ColoredBananaGroup(
        group=32,
        map_id=Maps.CreepyCastle,
        name="On tree on platform past/below W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 638, 615, 1935], [1, 1.0, 628, 650, 1935], [1, 1.0, 625, 685, 1933]],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.CreepyCastle,
        name="On ladder next to Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[1, 1.0, 48, 415, 1129], [1, 1.0, 49, 445, 1129]],
    ),
    ColoredBananaGroup(
        group=33,
        map_id=Maps.CreepyCastle,
        name="On ladder next to Tiny BP",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,  # Climbing requirement is implied in the logicRegion
        locations=[[1, 1.0, 50, 475, 1129], [1, 1.0, 51, 505, 1129], [1, 1.0, 52, 535, 1129]],
    ),
    ColoredBananaGroup(
        group=34,
        map_id=Maps.CreepyCastle,
        name="Path from W1 to ladder (7 custom, 8 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 952, 648, 1681],
            [1, 1.0, 851, 648, 1688],
            [1, 1.0, 437, 648, 1599],
            [1, 1.0, 258, 648, 1592],
            [1, 1.0, 166, 621, 1522],
            [1, 1.0, 139, 586, 1398],
            [1, 1.0, 142, 561, 1237],
            [1, 1.0, 768.0885620117188, 648.3333129882812, 1673.0848388671875],
            [1, 1.0, 143.60256958007812, 566.3170776367188, 1301.483154296875],
            [1, 1.0, 338.8185729980469, 648.3333129882812, 1602.2059326171875],
            [1, 1.0, 144.32215881347656, 599.7493286132812, 1458.453125],
            [1, 1.0, 532.27294921875, 658.3333129882812, 1611.8822021484375],
            [1, 1.0, 642.0043334960938, 658.3333129882812, 1643.0064697265625],
            [1, 1.0, 147.4854278564453, 553.1714477539062, 1166.5216064453125],
            [1, 1.0, 213.35614013671875, 644.165283203125, 1557.5177001953125],
        ],
    ),
    ColoredBananaGroup(
        group=35,
        map_id=Maps.CreepyCastle,
        name="On ladder towards W2 (4 custom, 1 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 203, 575, 1148],
            [1, 1.0, 204, 608, 1148],
            [1, 1.0, 206, 675, 1148],
            [1, 1.0, 207, 708, 1148],
            [1, 1.0, 210.0167999267578, 635.0049438476562, 1147.9171142578125],
        ],
    ),
    ColoredBananaGroup(
        group=36,
        map_id=Maps.CreepyCastle,
        name="Stone path from drawbridge to wooden path (4 custom, 6 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 654, 674, 906],
            [1, 1.0, 538, 680, 984],
            [1, 1.0, 420, 686, 1040],
            [1, 1.0, 358, 702, 1113],
            [1, 1.0, 249.1775360107422, 713.5996704101562, 1143.7340087890625],
            [1, 1.0, 303.2047424316406, 733.2924194335938, 1268.2952880859375],
            [1, 1.0, 327.0840148925781, 759.6992797851562, 1381.5140380859375],
            [1, 1.0, 360.99072265625, 793.9478149414062, 1487.6424560546875],
            [1, 1.0, 450.887939453125, 803.1527709960938, 1601.6192626953125],
            [1, 1.0, 615.7953491210938, 807.7949829101562, 1645.82470703125],
        ],
    ),
    ColoredBananaGroup(
        group=37,
        map_id=Maps.CreepyCastle,
        name="On wooden path towards W2 (4 custom, 6 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 843, 841, 1851],
            [1, 1.0, 956, 850, 1929],
            [1, 1.0, 1107, 861, 1927],
            [1, 1.0, 1237, 869, 1884],
            [1, 1.0, 748.6635131835938, 829.6699829101562, 1705.5552978515625],
            [1, 1.0, 807.1790161132812, 836.1080932617188, 1794.7135009765625],
            [1, 1.0, 885.4238891601562, 845.6199340820312, 1911.1402587890625],
            [1, 1.0, 1039.240234375, 856.12158203125, 1930.1956787109375],
            [1, 1.0, 1187.7354736328125, 864.674072265625, 1917.6192626953125],
            [1, 1.0, 1283.2486572265625, 875.3877563476562, 1840.0238037109375],
        ],
    ),
    ColoredBananaGroup(
        group=38,
        map_id=Maps.CreepyCastle,
        name="On path near Lanky BP (5 custom, 5 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1452, 887, 1743],
            [1, 1.0, 1581, 895, 1739],
            [1, 1.0, 1741, 904, 1717],
            [1, 1.0, 1844, 904, 1611],
            [1, 1.0, 1912, 904, 1479],
            [1, 1.0, 1392.4349365234375, 882.893310546875, 1741.9449462890625],
            [1, 1.0, 1513.6805419921875, 890.17431640625, 1740.8138427734375],
            [1, 1.0, 1656.017578125, 899.4151000976562, 1729.52880859375],
            [1, 1.0, 1795.5718994140625, 903.83251953125, 1667.4468994140625],
            [1, 1.0, 1882.6068115234375, 903.92578125, 1554.5391845703125],
        ],
    ),
    ColoredBananaGroup(
        group=39,
        map_id=Maps.CreepyCastle,
        name="Near W2 (1 custom, 4 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1846, 904, 1067],
            [1, 1.0, 1898.1353759765625, 903.9172973632812, 1123.961669921875],
            [1, 1.0, 1799.8597412109375, 904.2492065429688, 1027.48974609375],
            [1, 1.0, 1919.5345458984375, 913.7392578125, 1351.2142333984375],
            [1, 1.0, 1918.03955078125, 913.7843627929688, 1236.7548828125],
        ],
    ),
    ColoredBananaGroup(
        group=40,
        map_id=Maps.CreepyCastle,
        name="On brick piles past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 157, 660, 1599], [5, 1.0, 270, 661, 1710]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.CreepyCastle,
        name="On tree past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 203, 660, 1637], [1, 1.0, 207, 695, 1635]],
    ),
    ColoredBananaGroup(
        group=41,
        map_id=Maps.CreepyCastle,
        name="On tree past W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.climbing or (l.jetpack and l.isdiddy),
        locations=[[1, 1.0, 200, 730, 1625], [1, 1.0, 195, 765, 1620], [1, 1.0, 196, 800, 1616]],
    ),
    ColoredBananaGroup(
        group=42,
        map_id=Maps.CreepyCastle,
        name="In moat by warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.swim,
        locations=[
            [1, 1.2, 1420, 427, 895],
            [1, 1.2, 1320, 427, 845],
            [1, 1.2, 1219, 427, 796],
            [1, 1.2, 1097, 427, 824],
            [1, 1.2, 975, 427, 851],
            [1, 1.2, 855, 427, 868],
            [1, 1.2, 752, 427, 793],
            [1, 1.2, 650, 427, 717],
            [1, 1.2, 555, 427, 722],
            [1, 1.2, 428, 427, 745],
        ],
    ),
    ColoredBananaGroup(
        group=43,
        map_id=Maps.CreepyCastle,
        name="In moat by upper cave entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.swim,
        locations=[[5, 1.2, 1090, 430, 944], [5, 1.2, 1248, 430, 922]],
    ),
    ColoredBananaGroup(
        group=44,
        map_id=Maps.CreepyCastle,
        name="On steps of upper cave entrance (warps side)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1095, 542, 973], [5, 1.0, 1251, 542, 951]],
    ),
    ColoredBananaGroup(
        group=45,
        map_id=Maps.CreepyCastle,
        name="On ladder into moat by W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1187, 545, 657],
            [1, 1.0, 1187, 575, 656],
            [1, 1.0, 1187, 605, 655],
            [1, 1.0, 1187, 635, 654],
            [1, 1.0, 1187, 665, 653],
        ],
    ),
    ColoredBananaGroup(
        group=46,
        map_id=Maps.CreepyCastle,
        name="Ladder from tree to warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1379, 500, 437],
            [1, 1.0, 1379, 540, 439],
            [1, 1.0, 1379, 580, 441],
            [1, 1.0, 1379, 620, 443],
            [1, 1.0, 1379, 660, 444],
        ],
    ),
    ColoredBananaGroup(
        group=47,
        map_id=Maps.CreepyCastle,
        name="Edge of warps platform by tag barrel",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1679, 678, 664], [5, 1.0, 1664, 674, 629]],
    ),
    ColoredBananaGroup(
        group=48,
        map_id=Maps.CreepyCastle,
        name="Wood border around tag barrel by warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1678, 757, 704],
            [1, 1.0, 1703, 757, 691],
            [1, 1.0, 1725, 757, 681],
            [1, 1.0, 1762, 757, 699],
            [1, 1.0, 1780, 757, 738],
            [1, 1.0, 1798, 757, 777],
            [1, 1.0, 1815, 757, 815],
            [1, 1.0, 1800, 757, 857],
            [1, 1.0, 1775, 757, 869],
            [1, 1.0, 1751, 757, 882],
        ],
    ),
    ColoredBananaGroup(
        group=49,
        map_id=Maps.CreepyCastle,
        name="W2 to wooden bridge (2 custom, 3 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1751, 904, 993],
            [1, 1.0, 1667, 904, 932],
            [1, 1.0, 1627.2080078125, 913.4754028320312, 857.639404296875],
            [1, 1.0, 1551.6759033203125, 932.9896850585938, 766.0227661132812],
            [1, 1.0, 1404.34814453125, 947.8786010742188, 713.232177734375],
        ],
    ),
    ColoredBananaGroup(
        group=50,
        map_id=Maps.CreepyCastle,
        name="Wooden bridge (2 custom, 3 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1197, 982, 757],
            [1, 1.0, 1025, 1021, 800],
            [1, 1.0, 1270.8013916015625, 972.045654296875, 740.7361450195312],
            [1, 1.0, 954.2062377929688, 1046.13427734375, 820.2206420898438],
            [1, 1.0, 1107.8131103515625, 998.59375, 781.5784301757812],
        ],
    ),
    ColoredBananaGroup(
        group=51,
        map_id=Maps.CreepyCastle,
        name="Wooden portion past bridge (3 custom, 2 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 867, 1058, 841],
            [1, 1.0, 760, 1078, 956],
            [1, 1.0, 677, 1110, 1090],
            [1, 1.0, 794.2158813476562, 1067.8890380859375, 895.1649780273438],
            [1, 1.0, 728.2880249023438, 1089.9351806640625, 1021.0140991210938],
        ],
    ),
    ColoredBananaGroup(
        group=52,
        map_id=Maps.CreepyCastle,
        name="In front of Cranky (6 custom, 4 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 564, 1127, 1191],
            [1, 1.0, 522, 1135, 1241],
            [1, 1.0, 490, 1136, 1340],
            [1, 1.0, 495, 1136, 1414],
            [1, 1.0, 540, 1137, 1511],
            [1, 1.0, 672, 1134, 1600],
            [1, 1.0, 600.7085571289062, 1121.703369140625, 1159.246337890625],
            [1, 1.0, 502.1750183105469, 1137.2412109375, 1288.8741455078125],
            [1, 1.0, 510.0443420410156, 1135.5538330078125, 1454.18701171875],
            [1, 1.0, 600.5433349609375, 1134.8414306640625, 1565.4376220703125],
        ],
    ),
    ColoredBananaGroup(
        group=53,
        map_id=Maps.CreepyCastle,
        name="First octagonal platform (4 custom, 1 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 724, 1185, 1603],
            [1, 1.0, 743, 1185, 1707],
            [1, 1.0, 849, 1185, 1693],
            [1, 1.0, 833, 1185, 1586],
            [1, 1.0, 779.8035278320312, 1184.6666259765625, 1648.1004638671875],
        ],
    ),
    ColoredBananaGroup(
        group=54,
        map_id=Maps.CreepyCastle,
        name="Second octagonal platform (4 custom, 1 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 890, 1235, 1627],
            [1, 1.0, 977, 1235, 1687],
            [1, 1.0, 1042, 1235, 1606],
            [1, 1.0, 959, 1235, 1558],
            [1, 1.0, 966.7368774414062, 1234.6666259765625, 1614.5640869140625],
        ],
    ),
    ColoredBananaGroup(
        group=55,
        map_id=Maps.CreepyCastle,
        name="On switch to Museum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 887, 1298, 1512]],
    ),
    ColoredBananaGroup(
        group=56,
        map_id=Maps.CreepyCastle,
        name="Wooden path from Museum to W4 (6 custom, 4 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 928, 1285, 1556],
            [1, 1.0, 978, 1285, 1490],
            [1, 1.0, 1085, 1303, 1471],
            [1, 1.0, 1140, 1313, 1493],
            [1, 1.0, 1222, 1335, 1536],
            [1, 1.0, 1322, 1368, 1625],
            [1, 1.0, 1028.6468505859375, 1292.1251220703125, 1475.9595947265625],
            [1, 1.0, 1177.100830078125, 1319.3809814453125, 1507.10595703125],
            [1, 1.0, 1268.2286376953125, 1349.9586181640625, 1580.638671875],
            [1, 1.0, 1363.6463623046875, 1386.6451416015625, 1664.3310546875],
        ],
    ),
    ColoredBananaGroup(
        group=57,
        map_id=Maps.CreepyCastle,
        name="On W4 platform (4 custom, 1 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1440, 1381, 1707],
            [1, 1.0, 1492, 1381, 1713],
            [1, 1.0, 1610, 1381, 1700],
            [1, 1.0, 1730, 1394, 1591],
            [1, 1.0, 1700.6680908203125, 1383.8505859375, 1643.2327880859375],
        ],
    ),
    ColoredBananaGroup(
        group=58,
        map_id=Maps.CreepyCastle,
        name="Around back of shed + greenhouse",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1341, 1381, 1821],
            [1, 1.0, 1339, 1381, 1895],
            [1, 1.0, 1381, 1381, 1975],
            [1, 1.0, 1451, 1381, 2015],
            [1, 1.0, 1563, 1381, 2054],
            [1, 1.0, 1629, 1381, 2042],
            [1, 1.0, 1727, 1381, 1994],
            [1, 1.0, 1795, 1381, 1910],
            [1, 1.0, 1802, 1381, 1811],
            [1, 1.0, 1743, 1381, 1743],
        ],
    ),
    ColoredBananaGroup(
        group=59,
        map_id=Maps.CreepyCastle,
        name="On greenhouse roof",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1631, 1467, 1940], [5, 1.0, 1578, 1467, 1963]],
    ),
    ColoredBananaGroup(
        group=60,
        map_id=Maps.CreepyCastle,
        name="In front of ballroom (6 custom, 4 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1894, 1406, 1346],
            [1, 1.0, 1957, 1406, 1311],
            [1, 1.0, 1956, 1406, 1209],
            [1, 1.0, 1871, 1406, 1182],
            [1, 1.0, 1765, 1414, 1087],
            [1, 1.0, 1689, 1421, 1027],
            [1, 1.0, 1790.9012451171875, 1408.5162353515625, 1508.0455322265625],
            [1, 1.0, 1866.87353515625, 1405.6666259765625, 1404.9395751953125],
            [1, 1.0, 1812.2734375, 1408.20458984375, 1134.1990966796875],
            [1, 1.0, 1640.45703125, 1425.3851318359375, 992.566650390625],
        ],
    ),
    ColoredBananaGroup(
        group=61,
        map_id=Maps.CreepyCastle,
        name="In front of Library entrance (5 custom, 5 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1535, 1435, 986],
            [1, 1.0, 1432, 1435, 977],
            [1, 1.0, 1183, 1463, 990],
            [1, 1.0, 1002, 1506, 1035],
            [1, 1.0, 835, 1526, 1093],
            [1, 1.0, 1278.5484619140625, 1444.4541015625, 989.2971801757812],
            [1, 1.0, 1491.5279541015625, 1440.7635498046875, 989.7277221679688],
            [1, 1.0, 1084.3359375, 1486.4752197265625, 1009.1160278320312],
            [1, 1.0, 917.4267578125, 1515.9879150390625, 1063.8978271484375],
            [1, 1.0, 744.8158569335938, 1537.5531005859375, 1100.7340087890625],
        ],
    ),
    ColoredBananaGroup(
        group=62,
        map_id=Maps.CreepyCastle,
        name="Around tower past library (2 custom, 3 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 495, 1552, 1276],
            [1, 1.0, 511, 1552, 1492],
            [1, 1.0, 578.2761840820312, 1549.0499267578125, 1173.6112060546875],
            [1, 1.0, 497.2899475097656, 1550.7984619140625, 1364.6531982421875],
            [1, 1.0, 569.7000732421875, 1551.4254150390625, 1552.5452880859375],
        ],
    ),
    ColoredBananaGroup(
        group=63,
        map_id=Maps.CreepyCastle,
        name="Path to W5 from Library switch (5 custom, 5 Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 663, 1553, 1624],
            [1, 1.0, 873, 1560, 1628],
            [1, 1.0, 1037, 1595, 1639],
            [1, 1.0, 1205, 1614, 1650],
            [1, 1.0, 1398, 1613, 1686],
            [1, 1.0, 740.4485473632812, 1559.4364013671875, 1624.50439453125],
            [1, 1.0, 965.8300170898438, 1580.4498291015625, 1634.169921875],
            [1, 1.0, 1120.7645263671875, 1604.3018798828125, 1645.08349609375],
            [1, 1.0, 1295.2933349609375, 1613.92578125, 1668.2091064453125],
            [1, 1.0, 1517.1641845703125, 1624.6710205078125, 1684.53564453125],
        ],
    ),
    ColoredBananaGroup(
        group=64,
        map_id=Maps.CreepyCastle,
        name="Path to W5 (1 custom, 9 Tiny singles, 1 Tiny bunch)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1360, 1729, 974],
            [1, 1.0, 1672.79248046875, 1642.14501953125, 1674.3824462890625],
            [1, 1.0, 1779.31884765625, 1650.6546630859375, 1562.3167724609375],
            [1, 1.0, 1862.1932373046875, 1660.2733154296875, 1448.0679931640625],
            [1, 1.0, 1864.6749267578125, 1667.1492919921875, 1326.4136962890625],
            [1, 1.0, 1863.4337158203125, 1675.0753173828125, 1213.0050048828125],
            [1, 1.0, 1797.0155029296875, 1682.5709228515625, 1098.4815673828125],
            [1, 1.0, 1702.76220703125, 1689.8370361328125, 1021.3359985351562],
            [1, 1.0, 1576.7852783203125, 1699.1553955078125, 958.629638671875],
            [1, 1.0, 1445.58740234375, 1718.0635986328125, 961.3455200195312],
            [5, 1.0, 1292.5950927734375, 1733.3897705078125, 1025.9903564453125],
        ],
    ),
    ColoredBananaGroup(
        group=65,
        map_id=Maps.CreepyCastle,
        name="Around tower at top",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1687, 1731, 1268],
            [1, 1.0, 1649, 1731, 1173],
            [1, 1.0, 1521, 1731, 1133],
            [1, 1.0, 1420, 1731, 1207],
            [1, 1.0, 1372, 1731, 1311],
            [1, 1.0, 1376, 1731, 1405],
            [1, 1.0, 1454, 1731, 1484],
            [1, 1.0, 1550, 1731, 1511],
            [1, 1.0, 1635, 1731, 1485],
            [1, 1.0, 1695, 1731, 1378],
        ],
    ),
    ColoredBananaGroup(
        group=66,
        map_id=Maps.CreepyCastle,
        name="On Tower Lanky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1549, 1745, 1175]],
    ),
    ColoredBananaGroup(
        group=67,
        map_id=Maps.CreepyCastle,
        name="On tower battlements (left of W5)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1779, 1768, 1187], [5, 1.0, 1601, 1774, 1040]],
    ),
    ColoredBananaGroup(
        group=68,
        map_id=Maps.CreepyCastle,
        name="On tower battlements past Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1307, 1773, 1536], [5, 1.0, 1521, 1774, 1611], [5, 1.0, 1721, 1774, 1514]],
    ),
    ColoredBananaGroup(
        group=69,
        map_id=Maps.CreepyCastle,
        name="Between W5 and path to Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1235, 1736, 1189]],
    ),
    ColoredBananaGroup(
        group=70,
        map_id=Maps.CreepyCastle,
        name="To and around Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1204, 1731, 1335],
            [1, 1.0, 1109, 1751, 1349],
            [1, 1.0, 1001, 1775, 1357],
            [1, 1.0, 900, 1794, 1354],
            [1, 1.0, 834, 1794, 1264],
            [1, 1.0, 738, 1794, 1248],
            [1, 1.0, 658, 1794, 1308],
            [1, 1.0, 674, 1794, 1446],
            [1, 1.0, 788, 1794, 1470],
            [1, 1.0, 873, 1794, 1424],
        ],
    ),
    ColoredBananaGroup(
        group=71,
        map_id=Maps.CreepyCastle,
        name="Battlements around Snide",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 682, 1835, 1559], [5, 1.0, 568, 1837, 1298], [5, 1.0, 787, 1837, 1178]],
    ),
    ColoredBananaGroup(
        group=72,
        map_id=Maps.CreepyCastle,
        name="On battlements at top of tower",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 1597, 2055, 1403],
            [5, 1.0, 1480, 2055, 1363],
            [5, 1.0, 1522, 2055, 1244],
            [5, 1.0, 1638, 2055, 1285],
        ],
    ),
    ColoredBananaGroup(
        group=73,
        map_id=Maps.CreepyCastle,
        name="Switch to Ballroom",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1833, 1415, 1335]],
    ),
    ColoredBananaGroup(
        group=74,
        map_id=Maps.CastleBallroom,
        name="Ballroom - Entrance path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 962, 40, 1638],
            [1, 1.0, 863, 40, 1638],
            [1, 1.0, 764, 40, 1638],
            [1, 1.0, 665, 40, 1638],
            [1, 1.0, 566, 40, 1638],
            [1, 1.0, 552, 40, 1533],
            [1, 1.0, 552, 52, 1452],
            [1, 1.0, 552, 88, 1373],
            [1, 1.0, 552, 120, 1300],
            [1, 1.0, 552, 120, 1193],
        ],
    ),
    ColoredBananaGroup(
        group=75,
        map_id=Maps.CastleBallroom,
        name="Carpeted ramps to main room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 889, 45, 924],
            [1, 1.0, 873, 66, 1006],
            [1, 1.0, 820, 90, 1087],
            [1, 1.0, 733, 115, 1129],
            [1, 1.0, 645, 120, 1142],
            [1, 1.0, 445, 120, 1142],
            [1, 1.0, 357, 115, 1129],
            [1, 1.0, 270, 90, 1087],
            [1, 1.0, 217, 66, 1006],
            [1, 1.0, 201, 45, 924],
        ],
    ),
    ColoredBananaGroup(
        group=76,
        map_id=Maps.CastleBallroom,
        name="Back two corners of ballroom floor",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[[5, 1.0, 353, 50, 344], [5, 1.0, 742, 50, 344]],
    ),
    ColoredBananaGroup(
        group=77,
        map_id=Maps.CastleBaboonBlast,
        name="In baboon blast course",
        konglist=[Kongs.donkey],
        region=Regions.CastleBaboonBlast,
        locations=[[5, 1.0, 2397, 475, 1412], [5, 1.0, 2166, 645, 1937]],
    ),
    ColoredBananaGroup(
        group=78,
        map_id=Maps.CastleDungeon,
        name="On buckets",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[[5, 1.0, 730, 220, 1882], [5, 1.0, 427, 140, 1384], [5, 1.0, 427, 140, 2430]],
    ),
    ColoredBananaGroup(
        group=79,
        map_id=Maps.CastleDungeon,
        name="On DK switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[[5, 1.0, 887, 205, 1996]],
    ),
    ColoredBananaGroup(
        group=80,
        map_id=Maps.CastleDungeon,
        name="On Lanky switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[[5, 1.0, 539, 125, 1380]],
    ),
    ColoredBananaGroup(
        group=81,
        map_id=Maps.CastleDungeon,
        name="On Diddy switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[[5, 1.0, 533, 125, 2595]],
    ),
    ColoredBananaGroup(
        group=82,
        map_id=Maps.CastleDungeon,
        name="Path between Diddy and Lanky switches",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[
            [1, 1.0, 540, 115, 1433],
            [1, 1.0, 540, 115, 1557],
            [1, 1.0, 540, 124, 1680],
            [1, 1.0, 540, 179, 1804],
            [1, 1.0, 540, 195, 1927],
            [1, 1.0, 540, 195, 2051],
            [1, 1.0, 540, 189, 2174],
            [1, 1.0, 540, 133, 2298],
            [1, 1.0, 540, 115, 2421],
            [1, 1.0, 540, 115, 2545],
        ],
    ),
    ColoredBananaGroup(
        group=83,
        map_id=Maps.CastleDungeon,
        name="In DK's room behind puzzle",
        konglist=[Kongs.donkey],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[[1, 1.0, 1494, 170, 1897], [1, 1.0, 1494, 170, 1973], [1, 1.0, 1494, 170, 2049], [1, 1.0, 1494, 170, 2125], [1, 1.0, 1494, 170, 2100]],
    ),
    ColoredBananaGroup(
        group=84,
        map_id=Maps.CastleDungeon,
        name="In Diddy's room between chains",
        konglist=[Kongs.diddy],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[[5, 1.2, 539, 155, 3092], [5, 1.2, 533, 132, 3357]],
    ),
    ColoredBananaGroup(
        group=85,
        map_id=Maps.CastleDungeon,
        name="On BB pads",
        konglist=[Kongs.lanky],
        region=Regions.Dungeon,
        logic=lambda l: (l.balloon and l.trombone and (l.CanSlamSwitch(Levels.CreepyCastle, 3)) or l.CanPhase()),
        locations=[[5, 1.0, 542, 120, 1010], [5, 1.0, 462, 120, 769], [5, 1.0, 608, 120, 504]],
    ),
    ColoredBananaGroup(
        group=86,
        map_id=Maps.CastleShed,
        name="Shed - Around room",
        konglist=[Kongs.chunky],
        region=Regions.Shed,
        locations=[
            [1, 1.0, 465, 0, 182],
            [1, 1.0, 400, 0, 182],
            [1, 1.0, 335, 0, 182],
            [1, 1.0, 270, 0, 182],
            [1, 1.0, 205, 0, 182],
            [1, 1.0, 140, 0, 182],
            [1, 1.0, 140, 0, 262],
            [1, 1.0, 140, 0, 342],
            [1, 1.0, 140, 0, 422],
            [1, 1.0, 465, 0, 262],
            [1, 1.0, 465, 0, 342],
            [1, 1.0, 465, 0, 422],
            [1, 1.0, 206, 0, 495],
            [1, 1.0, 304, 0, 495],
            [1, 1.0, 402, 0, 495],
        ],
    ),
    ColoredBananaGroup(
        group=87,
        map_id=Maps.CastleShed,
        name="On Gorilla Gone pad",
        konglist=[Kongs.chunky],
        region=Regions.Shed,
        logic=lambda l: l.punch,
        locations=[[5, 1.0, 304, 12, 354]],
    ),
    ColoredBananaGroup(
        group=88,
        map_id=Maps.CastleLowerCave,
        name="Path to Crypt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[
            [1, 1.0, 948, 223, 1257],
            [1, 1.0, 832, 234, 1257],
            [1, 1.0, 806, 228, 1374],
            [1, 1.0, 724, 212, 1452],
            [1, 1.0, 591, 178, 1537],
            [1, 1.0, 436, 125, 1540],
            [1, 1.0, 806, 228, 1140],
            [1, 1.0, 724, 212, 1062],
            [1, 1.0, 591, 178, 977],
            [1, 1.0, 436, 128, 974],
        ],
    ),
    ColoredBananaGroup(
        group=89,
        map_id=Maps.CastleLowerCave,
        name="In front of crypt entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[5, 1.0, 608, 90, 1269]],
    ),
    ColoredBananaGroup(
        group=90,
        map_id=Maps.CastleLowerCave,
        name="To and around mausoleum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[
            [1, 1.0, 1270, 214, 1259],
            [1, 1.0, 1370, 254, 1259],
            [1, 1.0, 1470, 294, 1259],
            [1, 1.0, 1570, 320, 1259],
            [1, 1.0, 1627, 320, 1180],
            [1, 1.0, 1722, 320, 1146],
            [1, 1.0, 1859, 320, 1215],
            [1, 1.0, 1859, 320, 1338],
            [1, 1.0, 1722, 320, 1372],
            [1, 1.0, 1627, 320, 1303],
        ],
    ),
    ColoredBananaGroup(
        group=91,
        map_id=Maps.CastleLowerCave,
        name="Between homing ammo pickups next to Funky",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[5, 1.0, 1318, 205, 470], [5, 1.0, 1308, 205, 375]],
    ),
    ColoredBananaGroup(
        group=92,
        map_id=Maps.CastleCrypt,
        name="Entrance stairs",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 373, 320, 1663],
            [1, 1.0, 448, 296, 1663],
            [1, 1.0, 523, 263, 1663],
            [1, 1.0, 598, 240, 1663],
            [1, 1.0, 673, 240, 1663],
        ],
    ),
    ColoredBananaGroup(
        group=93,
        map_id=Maps.CastleCrypt,
        name="Crypt - W1 (1 custom, 1 Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[5, 1.0, 734, 254, 1564], [5, 1.0, 1738.5306396484375, 15.0, 378.6136169433594]],
    ),
    ColoredBananaGroup(
        group=94,
        map_id=Maps.CastleCrypt,
        name="Crypt - W2 (1 custom, 1 Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[5, 1.0, 732, 254, 1661], [5, 1.0, 1511.1583251953125, 105.0, 2047.6162109375]],
    ),
    ColoredBananaGroup(
        group=95,
        map_id=Maps.CastleCrypt,
        name="Crypt - W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[5, 1.0, 731, 254, 1769], [5, 1.0, 1076, 174, 2479]],
    ),
    ColoredBananaGroup(
        group=96,
        map_id=Maps.CastleCrypt,
        name="Crypt - Path from warps to T intersection",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 730, 240, 1492],
            [1, 1.0, 730, 240, 1357],
            [1, 1.0, 815, 236, 1357],
            [1, 1.0, 900, 201, 1357],
            [1, 1.0, 985, 166, 1357],
        ],
    ),
    ColoredBananaGroup(
        group=97,
        map_id=Maps.CastleCrypt,
        name="Crypt - Path to W2",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 1078, 160, 1470],
            [1, 1.0, 1078, 137, 1570],
            [1, 1.0, 1078, 94, 1670],
            [1, 1.0, 1078, 80, 1770],
            [1, 1.0, 1078, 80, 1870],
            [1, 1.0, 1078, 80, 1970],
            [1, 1.0, 1186, 80, 1970],
            [1, 1.0, 1294, 80, 1970],
            [1, 1.0, 1401, 80, 1970],
            [1, 1.0, 1509, 80, 1970],
        ],
    ),
    ColoredBananaGroup(
        group=98,
        map_id=Maps.CastleCrypt,
        name="Crypt - Path to W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 1078, 160, 1214],
            [1, 1.0, 1078, 129, 1130],
            [1, 1.0, 1078, 92, 1046],
            [1, 1.0, 1078, 80, 962],
            [1, 1.0, 1078, 80, 878],
            [1, 1.0, 1160, 80, 878],
            [1, 1.0, 1242, 80, 878],
            [1, 1.0, 1324, 80, 878],
            [1, 1.0, 1505, 80, 878],
            [1, 1.0, 1513, 80, 746],
            [1, 1.0, 1513, 57, 659],
            [1, 1.0, 1513, 19, 572],
            [1, 1.0, 1513, 0, 485],
            [1, 1.0, 1563, 0, 395],
            [1, 1.0, 1654, 0, 381],
        ],
    ),
    ColoredBananaGroup(
        group=99,
        map_id=Maps.CastleCrypt,
        name="Crypt - Path to W3",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 730, 240, 1825],
            [1, 1.0, 730, 240, 1913],
            [1, 1.0, 730, 240, 2001],
            [1, 1.0, 730, 240, 2089],
            [1, 1.0, 730, 240, 2177],
            [1, 1.0, 843, 240, 2177],
            [1, 1.0, 956, 240, 2177],
            [1, 1.0, 1070, 240, 2177],
            [1, 1.0, 1070, 220, 2299],
            [1, 1.0, 1070, 185, 2378],
        ],
    ),
    ColoredBananaGroup(
        group=100,
        map_id=Maps.CastleCrypt,
        name="Back corners of DK's room",
        konglist=[Kongs.donkey],
        region=Regions.CryptDonkeyRoom,
        locations=[[5, 1.0, 1338, 85, 2500], [5, 1.0, 1678, 85, 2500]],
    ),
    ColoredBananaGroup(
        group=101,
        map_id=Maps.CastleCrypt,
        name="Bunch on coffin with pentagon of singles around it",
        konglist=[Kongs.diddy],
        region=Regions.CryptDiddyRoom,
        locations=[[5, 1.0, 2071, 81, 394], [1, 1.0, 2071, 81, 370], [1, 1.0, 2048, 81, 387], [1, 1.0, 2057, 81, 413], [1, 1.0, 2085, 81, 413], [1, 1.0, 2094, 81, 387]],
    ),
    ColoredBananaGroup(
        group=102,
        map_id=Maps.CastleMausoleum,
        name="On Goo hands",
        konglist=[Kongs.tiny],
        region=Regions.Mausoleum,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) and l.twirl,
        locations=[[5, 1.0, 1178, 190, 2048], [5, 1.0, 1348, 190, 2310], [5, 1.0, 987, 190, 2297]],
    ),
    ColoredBananaGroup(
        group=103,
        map_id=Maps.CastleMausoleum,
        name="On torches on Tiny's path",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.Mausoleum,
        locations=[[5, 1.0, 793, 300, 1228], [5, 1.0, 803, 220, 1784]],
    ),
    ColoredBananaGroup(
        group=104,
        map_id=Maps.CastleMausoleum,
        name="Path to Lanky's side",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.Mausoleum,
        locations=[
            [1, 1.0, 728, 240, 970],
            [1, 1.0, 728, 226, 875],
            [1, 1.0, 728, 184, 780],
            [1, 1.0, 728, 160, 685],
            [1, 1.0, 728, 160, 590],
            [1, 1.0, 835, 160, 590],
            [1, 1.0, 942, 160, 590],
            [1, 1.0, 1049, 160, 590],
            [1, 1.0, 1156, 160, 590],
            [1, 1.0, 1162, 160, 475],
            [1, 1.0, 1168, 160, 360],
            [1, 1.0, 1174, 160, 245],
            [1, 1.0, 1180, 160, 130],
            [1, 1.0, 1279, 160, 130],
            [1, 1.0, 1378, 144, 130],
            [1, 1.0, 1477, 100, 130],
            [1, 1.0, 1576, 80, 130],
            [1, 1.0, 1675, 80, 130],
            [1, 1.0, 1675, 80, 260],
            [1, 1.0, 1675, 80, 390],
        ],
    ),
    ColoredBananaGroup(
        group=105,
        map_id=Maps.CastleMausoleum,
        name="On trombone pad",
        konglist=[Kongs.lanky],
        region=Regions.Mausoleum,
        logic=lambda l: l.grape and l.sprint,
        locations=[[5, 1.0, 2100, 94, 560]],
    ),
    ColoredBananaGroup(
        group=106,
        map_id=Maps.CastleUpperCave,
        name="Behind Tiny's bonus barrel",
        konglist=[Kongs.tiny],
        region=Regions.UpperCave,
        logic=lambda l: l.twirl or l.CanPhase(),
        locations=[[5, 1.0, 1227, 200, 825], [5, 1.0, 1224, 200, 883]],
    ),
    ColoredBananaGroup(
        group=107,
        map_id=Maps.CastleGreenhouse,
        name="Near osprint barrel",
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        locations=[[5, 1.0, 325, 0, 873]],
    ),
    ColoredBananaGroup(
        group=108,
        map_id=Maps.CastleGreenhouse,
        name="Far dead end",
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        locations=[[5, 1.0, 122, 0, 428], [5, 1.0, 122, 0, 513]],
    ),
    ColoredBananaGroup(
        group=109,
        map_id=Maps.CastleGreenhouse,
        name="Corner dead end",
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        locations=[[5, 1.0, 787, 0, 127]],
    ),
    ColoredBananaGroup(
        group=110,
        map_id=Maps.CastleLibrary,
        name="On switch on books",
        konglist=[Kongs.donkey],
        region=Regions.Library,
        locations=[[5, 1.0, 267, 254, 329]],
    ),
    ColoredBananaGroup(
        group=111,
        map_id=Maps.CastleLibrary,
        name="Path from first room to book hallway",
        konglist=[Kongs.donkey],
        region=Regions.Library,
        locations=[
            [1, 1.0, 542, 171, 374],
            [1, 1.0, 702, 123, 374],
            [1, 1.0, 842, 100, 374],
            [1, 1.0, 842, 100, 493],
            [1, 1.0, 842, 100, 612],
            [1, 1.0, 842, 100, 731],
            [1, 1.0, 995, 100, 731],
            [1, 1.0, 1148, 100, 731],
            [1, 1.0, 1301, 100, 731],
            [1, 1.0, 1454, 100, 731],
            [1, 1.0, 1607, 100, 731],
            [1, 1.0, 1760, 100, 731],
            [1, 1.0, 1760, 116, 611],
            [1, 1.0, 1760, 164, 491],
            [1, 1.0, 1760, 180, 371],
        ],
    ),
    ColoredBananaGroup(
        group=112,
        map_id=Maps.CastleMuseum,
        name="On rock switch",
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        locations=[[5, 1.0, 774, 134, 730]],
    ),
    ColoredBananaGroup(
        group=113,
        map_id=Maps.CastleMuseum,
        name="Museum - Path from entrance to main room",
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        locations=[
            [1, 1.0, 1421, 0, 2351],
            [1, 1.0, 1421, 0, 2226],
            [1, 1.0, 1421, 50, 2101],
            [1, 1.0, 1421, 100, 1976],
            [1, 1.0, 1421, 100, 1851],
            [1, 1.0, 1293, 100, 1851],
            [1, 1.0, 1165, 143, 1851],
            [1, 1.0, 1037, 200, 1851],
            [1, 1.0, 909, 200, 1851],
            [1, 1.0, 781, 200, 1851],
            [1, 1.0, 781, 200, 1726],
            [1, 1.0, 781, 200, 1601],
            [1, 1.0, 781, 200, 1476],
            [1, 1.0, 781, 163, 1351],
            [1, 1.0, 781, 100, 1225],
        ],
    ),
    ColoredBananaGroup(
        group=114,
        map_id=Maps.CastleMuseum,
        name="Giant bunch on pedestal",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        logic=lambda l: l.monkeyport,
        locations=[[5, 2.5, 1136, 275, 1516]],
    ),
    ColoredBananaGroup(
        group=115,
        map_id=Maps.CastleMuseum,
        name="Pentagon around pedestal",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        logic=lambda l: l.monkeyport,
        locations=[
            [1, 1.0, 1136, 210, 1556],
            [1, 1.0, 1174, 210, 1528],
            [1, 1.0, 1160, 210, 1484],
            [1, 1.0, 1112, 210, 1484],
            [1, 1.0, 1098, 210, 1528],
        ],
    ),
    ColoredBananaGroup(
        group=116,
        map_id=Maps.CastleTower,
        name="By the entrance",
        konglist=[Kongs.lanky],
        region=Regions.Tower,
        locations=[[5, 1.0, 478, 230, 639], [5, 1.0, 307, 230, 645]],
    ),
    ColoredBananaGroup(
        group=117,
        map_id=Maps.CastleTower,
        name="On baboon balloon pad",
        konglist=[Kongs.lanky],
        region=Regions.Tower,
        locations=[[5, 1.0, 511, 239, 342]],
    ),
    ColoredBananaGroup(
        group=118,
        map_id=Maps.CastleTrashCan,
        name="Around trash can",
        konglist=[Kongs.tiny],
        region=Regions.TrashCan,
        locations=[
            [1, 2.0, 564, 15, 371],
            [1, 2.0, 477, 15, 470],
            [1, 2.0, 442, 15, 585],
            [1, 2.0, 448, 24, 715],
            [1, 2.0, 513, 37, 827],
            [1, 2.0, 636, 30, 837],
            [1, 2.0, 705, 22, 732],
            [1, 2.0, 759, 15, 626],
            [1, 2.0, 801, 52, 512],
            [1, 2.0, 678, 15, 392],
        ],
    ),
    ColoredBananaGroup(
        group=119,
        map_id=Maps.CastleTree,
        name="Big Tree - Middle of first room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleTree,
        locations=[[5, 1.0, 979, 405, 884]],
    ),
    ColoredBananaGroup(
        group=120,
        map_id=Maps.CastleTree,
        name="Around hole on DK's side",
        konglist=[Kongs.donkey],
        region=Regions.CastleTree,
        logic=lambda l: l.coconut or l.CanPhase(),
        locations=[
            [1, 1.0, 929, 400, 1836],
            [1, 1.0, 1002, 400, 1812],
            [1, 1.0, 1048, 400, 1750],
            [1, 1.0, 1048, 400, 1672],
            [1, 1.0, 1002, 400, 1610],
            [1, 1.0, 929, 400, 1586],
            [1, 1.0, 856, 400, 1610],
            [1, 1.0, 810, 400, 1672],
            [1, 1.0, 810, 400, 1750],
            [1, 1.0, 856, 400, 1812],
        ],
    ),
    ColoredBananaGroup(
        group=121,
        map_id=Maps.CastleTree,
        name="Path to Chunky's cage",
        konglist=[Kongs.chunky],
        region=Regions.CastleTreePastPunch,
        locations=[
            [1, 1.0, 962, 400, 572],
            [1, 1.0, 968, 382, 464],
            [1, 1.0, 979, 350, 345],
            [1, 1.0, 1073, 350, 329],
            [1, 1.0, 1163, 350, 325],
            [1, 1.0, 1287, 338, 340],
            [1, 1.0, 1382, 328, 348],
            [1, 1.0, 1489, 328, 336],
            [1, 1.0, 1597, 328, 326],
            [1, 1.0, 1685, 328, 324],
        ],
    ),
    ColoredBananaGroup(
        group=122,
        map_id=Maps.CastleMuseum,
        name="On chimneys of car race building",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        locations=[[5, 1.0, 421, 290, 1674], [5, 1.0, 386, 318, 1513]],
    ),
    ColoredBananaGroup(
        group=123,
        map_id=Maps.CreepyCastle,
        name="First bridge (Donkey)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        vanilla=True,
        locations=[
            [1, 1.0, 490.2774963378906, 383.5, 266.47711181640625],
            [1, 1.0, 412.2774963378906, 389.5, 269.47711181640625],
            [1, 1.0, 560.28662109375, 386.5, 265.30133056640625],
            [1, 1.0, 638.06982421875, 397.5, 260.097900390625],
            [1, 1.0, 349.0855712890625, 395.5, 274.03912353515625],
        ],
    ),
    ColoredBananaGroup(
        group=124,
        map_id=Maps.CreepyCastle,
        name="On cloud atop tower (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1868.2691650390625, 2045.49267578125, 1348.161376953125]],
    ),
    ColoredBananaGroup(
        group=125,
        map_id=Maps.CreepyCastle,
        name="On pole close to Cranky (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 562.0836181640625, 1300.1666259765625, 1094.6212158203125]],
    ),
    ColoredBananaGroup(
        group=126,
        map_id=Maps.CastleBallroom,
        name="On monkeyport pad (Tiny)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        vanilla=True,
        locations=[[5, 1.0, 554.1126708984375, 65.0, 1043.966796875]],
    ),
    ColoredBananaGroup(
        group=127,
        map_id=Maps.CastleBallroom,
        name="On candles (Diddy)",
        konglist=[Kongs.diddy],
        region=Regions.Ballroom,
        vanilla=True,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 882.455322265625, 333.5129089355469, 595.83544921875],
            [5, 1.0, 217.46343994140625, 333.5018005371094, 604.4033203125],
            [5, 1.0, 546.5313110351562, 333.5030212402344, 211.26060485839844],
        ],
    ),
    ColoredBananaGroup(
        group=128,
        map_id=Maps.CastleMausoleum,
        name="In green goo gap (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.Mausoleum,
        vanilla=True,
        logic=lambda l: l.twirl or (l.monkey_maneuvers and (not l.isKrushaAdjacent(Kongs.tiny))),
        locations=[[5, 1.0, 985.779541015625, 195.0, 1721.02587890625]],
    ),
    ColoredBananaGroup(
        group=129,
        map_id=Maps.CastleCrypt,
        name="In coffins (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.CryptChunkyRoom,
        vanilla=True,
        logic=lambda l: l.punch or l.CanPhase() or l.generalclips,
        locations=[[5, 1.0, 1405.1158447265625, 190.46810913085938, 2753.63671875], [5, 1.0, 1404.5225830078125, 190.34698486328125, 2951.347412109375]],
    ),
    ColoredBananaGroup(
        group=130,
        map_id=Maps.CastleMuseum,
        name="On monkeyport pads on car race side (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        vanilla=True,
        locations=[
            [5, 1.0, 651.7655639648438, 230.0, 1599.75146484375],
            [5, 1.0, 315.95721435546875, 230.0, 1588.6663818359375],
        ],
    ),
    ColoredBananaGroup(
        group=131,
        map_id=Maps.CastleMuseum,
        name="On monkeyport pad on monument side (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        vanilla=True,
        logic=lambda l: l.monkeyport or l.CanPhase(),
        locations=[[5, 1.0, 928.7748413085938, 230.0, 1512.7412109375]],
    ),
    ColoredBananaGroup(
        group=132,
        map_id=Maps.CastleMuseum,
        name="Inside boulder (Chunky)",
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        vanilla=True,
        logic=lambda l: l.punch and l.barrels,
        locations=[[5, 1.0, 773.6740112304688, 159.0, 298.97247314453125]],
    ),
    ColoredBananaGroup(
        group=133,
        map_id=Maps.CastleLibrary,
        name="In big books room (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.Library,
        vanilla=True,
        locations=[[5, 1.0, 430.787109375, 195.0, 371.3321228027344]],
    ),
    ColoredBananaGroup(
        group=134,
        map_id=Maps.CastleLibrary,
        name="In ghost book hallway (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.LibraryPastSlam,
        vanilla=True,
        logic=lambda l: l.strongKong,
        locations=[
            [5, 1.0, 2278.738037109375, 250.0, 370.8821716308594],
            [5, 1.0, 2556.36669921875, 250.0, 372.7164611816406],
        ],
    ),
    ColoredBananaGroup(
        group=135,
        map_id=Maps.CastleUpperCave,
        name="Path from moat entrance to Candy (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        vanilla=True,
        locations=[
            [1, 1.0, 123.05712127685547, 200.0, 2745.509765625],
            [1, 1.0, 140.33824157714844, 184.47137451171875, 2621.178466796875],
            [1, 1.0, 167.4883270263672, 160.0, 2499.1416015625],
            [1, 1.0, 269.5721130371094, 160.0, 2486.039794921875],
            [1, 1.0, 375.6454772949219, 176.2581787109375, 2501.604736328125],
            [1, 1.0, 498.3709716796875, 200.0, 2512.78466796875],
            [1, 1.0, 504.0376281738281, 214.32923889160156, 2378.353759765625],
            [1, 1.0, 544.3577270507812, 220.0, 2142.333740234375],
            [1, 1.0, 666.8458862304688, 236.73834228515625, 2152.2099609375],
            [1, 1.0, 801.2153930664062, 290.48614501953125, 2151.137451171875],
        ],
    ),
    ColoredBananaGroup(
        group=136,
        map_id=Maps.CastleUpperCave,
        name="Path from tag barrel to Candy (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        vanilla=True,
        locations=[
            [1, 1.0, 525.6336059570312, 220.0, 2000.48193359375],
            [1, 1.0, 530.9328002929688, 210.3932647705078, 1901.9664306640625],
            [1, 1.0, 532.0211791992188, 200.0, 1787.88623046875],
            [1, 1.0, 413.81640625, 175.5265655517578, 1756.5908203125],
            [1, 1.0, 310.5913391113281, 160.0, 1763.9525146484375],
            [1, 1.0, 212.69879150390625, 160.0, 1756.9705810546875],
            [1, 1.0, 199.8275909423828, 177.66734313964844, 1655.8316650390625],
            [1, 1.0, 202.11187744140625, 200.0, 1510.91943359375],
            [1, 1.0, 203.10008239746094, 181.16746520996094, 1362.3348388671875],
            [1, 1.0, 230.60142517089844, 150.0, 1230.8963623046875],
            [1, 1.0, 343.1304016113281, 150.0, 1234.334228515625],
            [1, 1.0, 456.2311096191406, 150.0, 1229.5125732421875],
            [1, 1.0, 541.4035034179688, 150.0, 1184.243896484375],
            [1, 1.0, 574.7877807617188, 154.4931182861328, 1082.6031494140625],
            [1, 1.0, 564.5869140625, 181.87828063964844, 991.8193969726562],
        ],
    ),
    ColoredBananaGroup(
        group=137,
        map_id=Maps.CastleUpperCave,
        name="Path from W1 entrance to tag barrel (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        vanilla=True,
        locations=[
            [1, 1.0, 571.4029541015625, 200.0, 860.7107543945312],
            [1, 1.0, 575.5375366210938, 177.5375213623047, 705.0750122070312],
            [1, 1.0, 573.5045166015625, 150.0, 593.9546508789062],
            [1, 1.0, 554.4815673828125, 150.0, 469.0948181152344],
            [1, 1.0, 548.5321044921875, 150.0, 373.5959777832031],
        ],
    ),
    ColoredBananaGroup(
        group=138,
        map_id=Maps.CastleDungeon,
        name="On face puzzle (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[[5, 1.0, 1330.8004150390625, 191.0, 1996.9613037109375]],
    ),
    ColoredBananaGroup(
        group=139,
        map_id=Maps.CastleDungeon,
        name="In cages DK side (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: l.punch or l.CanPhase(),
        locations=[[5, 1.0, 798.5471801757812, 195.0, 2207.813232421875], [5, 1.0, 796.4816284179688, 195.0, 1786.9832763671875]],
    ),
    ColoredBananaGroup(
        group=140,
        map_id=Maps.CastleDungeon,
        name="In cages Lanky side (Diddy)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: l.punch or l.CanPhase(),
        locations=[[5, 1.0, 326.51983642578125, 115.0, 1479.533203125], [5, 1.0, 745.7207641601562, 115.0, 1478.4139404296875]],
    ),
    ColoredBananaGroup(
        group=141,
        map_id=Maps.CastleTree,
        name="On plank in water (Donkey)",
        konglist=[Kongs.donkey],
        region=Regions.CastleTree,
        vanilla=True,
        logic=lambda l: l.coconut,
        locations=[[5, 1.0, 1674.9337158203125, 90.0, 1204.7913818359375]],
    ),
    ColoredBananaGroup(
        group=142,
        map_id=Maps.CastleTree,
        name="By punchable wall (Chunky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleTree,
        vanilla=True,
        locations=[[5, 1.0, 960.9935913085938, 422.0, 684.5026245117188]],
    ),
    ColoredBananaGroup(
        group=143,
        map_id=Maps.CastleTrashCan,
        name="On cheese (Tiny)",
        konglist=[Kongs.tiny],
        region=Regions.TrashCan,
        vanilla=True,
        locations=[[5, 2.2799997329711914, 593.357421875, 108.27153778076172, 592.9962768554688]],
    ),
    ColoredBananaGroup(
        group=144,
        map_id=Maps.CastleGreenhouse,
        name="Group 1 along path (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        vanilla=True,
        locations=[
            [5, 1.2599997520446777, 720.70751953125, 0, 822.3894653320312],
            [5, 1.2599997520446777, 430.1152648925781, 0, 480.8412780761719],
            [5, 1.2599997520446777, 416.0147705078125, 0, 131.07716369628906],
        ],
    ),
    ColoredBananaGroup(
        group=145,
        map_id=Maps.CastleGreenhouse,
        name="Group 2 along path (Lanky)",
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        vanilla=True,
        locations=[
            [5, 1.2599997520446777, 579.8276977539062, 0, 728.3095092773438],
            [5, 1.2599997520446777, 526.4144897460938, 0, 271.8726501464844],
            [5, 1.2599997520446777, 718.5166015625, 0, 628.7870483398438],
        ],
    ),
    ColoredBananaGroup(
        group=146,
        map_id=Maps.CastleLowerCave,
        name="Singles from entrance to Funky (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        vanilla=True,
        locations=[
            [1, 1.0, 1487.2659912109375, 172.21917724609375, 674.109619140625],
            [1, 1.0, 1119.2613525390625, 200.0, 1346.95263671875],
            [1, 1.0, 1124.7174072265625, 171.9124755859375, 1003.824951171875],
            [1, 1.0, 1464.59375, 200.0, 381.238037109375],
            [1, 1.0, 1357.34912109375, 150.0, 871.979248046875],
        ],
    ),
    ColoredBananaGroup(
        group=147,
        map_id=Maps.CastleLowerCave,
        name="Bunches from entrance to tag barrel (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        vanilla=True,
        locations=[
            [5, 1.0, 1119.44580078125, 200.0, 1536.4049072265625],
            [5, 1.0, 1121.390869140625, 200.0, 1162.2779541015625],
        ],
    ),
    ColoredBananaGroup(
        group=148,
        map_id=Maps.CastleLowerCave,
        name="Bunches from tag barrel to Funky (Lanky)",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        vanilla=True,
        locations=[
            [5, 1.0, 1223.7989501953125, 150.0, 882.0519409179688],
            [5, 1.0, 1463.3115234375, 150.0, 829.2488403320312],
            [5, 1.0, 1476.5509033203125, 200.0, 529.8535766601562],
        ],
    ),
    # Wave 2 by Snap
    ColoredBananaGroup(
        group=149,
        map_id=Maps.CreepyCastle,
        name="Pool near portal",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 901, 360, 283],
            [1, 1.0, 927, 360, 248],
            [1, 1.0, 927, 360, 204],
            [1, 1.0, 901, 360, 169],
            [1, 1.0, 860, 360, 156],
            [1, 1.0, 819, 360, 169],
            [1, 1.0, 793, 360, 204],
            [1, 1.0, 793, 360, 248],
            [1, 1.0, 819, 360, 283],
            [1, 1.0, 860, 360, 296],
        ],
    ),
    ColoredBananaGroup(
        group=150,
        map_id=Maps.CreepyCastle,
        name="Near the headphones",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 1895, 700, 1072]],
    ),
    ColoredBananaGroup(
        group=151,
        map_id=Maps.CreepyCastle,
        name="On stones near staircase to back W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [5, 1.0, 1531, 543, 2020],
            [5, 1.0, 1393, 556, 2021],
            [5, 1.0, 1252, 556, 2023],
        ],
    ),
    ColoredBananaGroup(
        group=152,
        map_id=Maps.CreepyCastle,
        name="Stone near back W1",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 993, 689, 1801]],
    ),
    ColoredBananaGroup(
        group=153,
        map_id=Maps.CreepyCastle,
        name="Stone on the graveyard platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[[5, 1.0, 545, 544, 1969]],
    ),
    ColoredBananaGroup(
        group=154,
        map_id=Maps.CreepyCastle,
        name="Gravestone in the graveyard",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        locations=[[5, 1.0, 737, 542, 1844]],
    ),
    ColoredBananaGroup(
        group=155,
        map_id=Maps.CreepyCastle,
        name="Wooden post near lone kasplat platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 40, 600, 1182], [1, 1.0, 40, 575, 1182], [1, 1.0, 40, 550, 1182], [1, 1.0, 40, 525, 1182], [1, 1.0, 40, 500, 1182]],
    ),
    ColoredBananaGroup(
        group=156,
        map_id=Maps.CreepyCastle,
        name="Stone brick above lone kasplat platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 120, 563, 865], [1, 1.0, 135, 566, 863], [1, 1.0, 151, 570, 861], [1, 1.0, 166, 573, 860], [1, 1.0, 181, 576, 858]],
    ),
    ColoredBananaGroup(
        group=157,
        map_id=Maps.CreepyCastle,
        name="Trees near rocketbarrel battlement",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 274, 548, 814],
            [1, 1.0, 264, 550, 784],
            [1, 1.0, 232, 552, 784],
            [1, 1.0, 222, 554, 814],
            [1, 1.0, 248, 556, 833],
            [1, 1.0, 484, 548, 534],
            [1, 1.0, 474, 550, 504],
            [1, 1.0, 442, 552, 504],
            [1, 1.0, 432, 554, 534],
            [1, 1.0, 458, 556, 553],
        ],
    ),
    ColoredBananaGroup(
        group=158,
        map_id=Maps.CreepyCastle,
        name="Stairs of the rocketbarrel battlement",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 231, 585, 634], [1, 1.0, 261, 585, 585], [1, 1.0, 292, 585, 544], [1, 1.0, 256, 603, 549], [1, 1.0, 224, 603, 594]],
    ),
    ColoredBananaGroup(
        group=159,
        map_id=Maps.CreepyCastle,
        name="Stones near staircase to warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 400, 590, 385], [5, 1.0, 621, 591, 361]],
    ),
    ColoredBananaGroup(
        group=160,
        map_id=Maps.CreepyCastle,
        name="Jump back to portal platform",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 290, 590, 380], [1, 1.0, 290, 567, 380], [1, 1.0, 290, 545, 380], [1, 1.0, 290, 522, 380], [1, 1.0, 290, 500, 380]],
    ),
    ColoredBananaGroup(
        group=161,
        map_id=Maps.CreepyCastle,
        name="Stones near ladder after drawbridge",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[5, 1.0, 280, 737, 1056], [5, 1.0, 236, 767, 1209]],
    ),
    ColoredBananaGroup(
        group=162,
        map_id=Maps.CreepyCastle,
        name="Edge of the moat",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 347, 548, 941], [1, 1.0, 325, 548, 776], [1, 1.0, 396, 548, 636], [1, 1.0, 546, 548, 566], [1, 1.0, 694, 548, 606]],
    ),
    ColoredBananaGroup(
        group=163,
        map_id=Maps.CreepyCastle,
        name="Staircase to warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 776, 657, 439],
            [1, 1.0, 739, 641, 429],
            [1, 1.0, 723, 641, 468],
            [1, 1.0, 683, 625, 456],
            [1, 1.0, 648, 609, 447],
            [1, 1.0, 656, 609, 401],
            [1, 1.0, 617, 593, 394],
            [1, 1.0, 578, 577, 393],
            [1, 1.0, 578, 577, 430],
            [1, 1.0, 545, 561, 432],
        ],
    ),
    ColoredBananaGroup(
        group=164,
        map_id=Maps.CreepyCastle,
        name="Fences near the warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 876, 673, 416],
            [1, 1.0, 906, 673, 416],
            [1, 1.0, 935, 673, 416],
            [1, 1.0, 965, 673, 416],
            [1, 1.0, 994, 673, 416],
            [1, 1.0, 1188, 673, 444],
            [1, 1.0, 1211, 673, 448],
            [1, 1.0, 1233, 673, 451],
            [1, 1.0, 1256, 673, 455],
            [1, 1.0, 1278, 673, 458],
            [1, 1.0, 1497, 673, 507],
            [1, 1.0, 1527, 673, 522],
            [1, 1.0, 1558, 673, 538],
            [1, 1.0, 1588, 673, 553],
            [1, 1.0, 1618, 673, 568],
        ],
    ),
    ColoredBananaGroup(
        group=165,
        map_id=Maps.CreepyCastle,
        name="On the drawbridge wooden beams",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.2, 820, 850, 679],
            [5, 1.2, 667, 850, 892],
        ],
    ),
    ColoredBananaGroup(
        group=166,
        map_id=Maps.CreepyCastle,
        name="End wall of the moat",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1454, 520, 726], [1, 1.0, 1460, 520, 775], [1, 1.0, 1466, 520, 823], [1, 1.0, 1471, 520, 872], [1, 1.0, 1477, 520, 920]],
    ),
    ColoredBananaGroup(
        group=167,
        map_id=Maps.CreepyCastle,
        name="Fence near Lanky kasplat",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1955, 904, 1520], [1, 1.0, 1968, 904, 1555], [1, 1.0, 1977, 904, 1589], [1, 1.0, 1960, 904, 1627], [1, 1.0, 1946, 904, 1656]],
    ),
    ColoredBananaGroup(
        group=168,
        map_id=Maps.CreepyCastle,
        name="Under the warp 2 rocketbarrel overhang",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1923, 830, 924]],
    ),
    ColoredBananaGroup(
        group=169,
        map_id=Maps.CreepyCastle,
        name="Museum sign",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 949, 1303, 1452], [1, 1.0, 962, 1303, 1451], [1, 1.0, 974, 1303, 1449], [1, 1.0, 987, 1303, 1448], [1, 1.0, 999, 1303, 1447]],
    ),
    ColoredBananaGroup(
        group=170,
        map_id=Maps.CreepyCastle,
        name="Ballroom sign",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1822, 1430, 1395], [1, 1.0, 1821, 1430, 1382], [1, 1.0, 1820, 1430, 1370], [1, 1.0, 1819, 1430, 1357], [1, 1.0, 1818, 1430, 1345]],
    ),
    ColoredBananaGroup(
        group=171,
        map_id=Maps.CreepyCastle,
        name="Pole near upper warp 4",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 1352, 1410, 1713], [1, 1.0, 1352, 1423, 1713], [1, 1.0, 1352, 1435, 1713], [1, 1.0, 1352, 1448, 1713], [1, 1.0, 1352, 1460, 1713]],
    ),
    ColoredBananaGroup(
        group=172,
        map_id=Maps.CreepyCastle,
        name="Against the tower",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1478, 1749, 1326],
            [1, 1.0, 1478, 1762, 1326],
            [1, 1.0, 1478, 1775, 1326],
            [1, 1.0, 1478, 1787, 1326],
            [1, 1.0, 1478, 1800, 1326],
            [1, 1.0, 1566, 1749, 1405],
            [1, 1.0, 1566, 1762, 1405],
            [1, 1.0, 1566, 1775, 1405],
            [1, 1.0, 1566, 1787, 1405],
            [1, 1.0, 1566, 1800, 1405],
        ],
    ),
    ColoredBananaGroup(
        group=173,
        map_id=Maps.CreepyCastle,
        name="Blind jump to the library switch",
        konglist=[Kongs.donkey],
        region=Regions.CreepyCastleMain,
        locations=[[1, 1.0, 737, 1818, 1622], [1, 1.0, 737, 1788, 1622], [1, 1.0, 737, 1759, 1622], [1, 1.0, 737, 1729, 1622], [1, 1.0, 737, 1700, 1622]],
    ),
    ColoredBananaGroup(
        group=174,
        map_id=Maps.CreepyCastle,
        name="Spiky fence at the top",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        locations=[
            [1, 1.0, 1751, 1731, 1298],
            [1, 1.0, 1751, 1741, 1298],
            [1, 1.0, 1731, 1731, 1299],
            [1, 1.0, 1731, 1741, 1299],
            [1, 1.0, 1731, 1751, 1299],
            [1, 1.0, 1709, 1741, 1301],
            [1, 1.0, 1687, 1731, 1302],
            [1, 1.0, 1687, 1741, 1302],
            [1, 1.0, 1687, 1751, 1302],
            [1, 1.0, 1687, 1761, 1302],
        ],
    ),
    ColoredBananaGroup(
        group=175,
        map_id=Maps.CreepyCastle,
        name="Warp 2 rocketbarrel liftoff !!",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 1923, 1046, 924],
            [1, 1.0, 1923, 1117, 924],
            [1, 1.0, 1923, 1189, 924],
            [1, 1.0, 1923, 1260, 924],
            [1, 1.0, 1923, 1332, 924],
            [1, 1.1, 1923, 1403, 924],
            [1, 1.1, 1923, 1475, 924],
            [1, 1.1, 1923, 1546, 924],
            [1, 1.1, 1923, 1617, 924],
            [1, 1.2, 1923, 1689, 924],
            [1, 1.2, 1923, 1760, 924],
            [1, 1.2, 1923, 1832, 924],
            [1, 1.3, 1923, 1903, 924],
            [1, 1.3, 1923, 1975, 924],
            [1, 1.4, 1923, 2046, 924],
        ],
    ),
    ColoredBananaGroup(
        group=176,
        map_id=Maps.CreepyCastle,
        name="Under the warp 4 overhang near Lanky kasplat",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[
            [5, 1.0, 1530, 1054, 1703],
            [5, 1.0, 1606, 1054, 1703],
        ],
    ),
    ColoredBananaGroup(
        group=177, map_id=Maps.CreepyCastle, name="Above Cranky", konglist=[Kongs.diddy], region=Regions.CreepyCastleMain, logic=lambda l: l.jetpack, locations=[[5, 1.0, 234, 1311, 1412]]
    ),
    ColoredBananaGroup(
        group=178,
        map_id=Maps.CreepyCastle,
        name="On poles in the back above warp 1",
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        locations=[[5, 1.0, 1325, 1043, 1720], [5, 1.0, 698, 990, 1730]],
    ),
    ColoredBananaGroup(
        group=179,
        map_id=Maps.CreepyCastle,
        name="Twirl from the library",  # Hard
        konglist=[Kongs.tiny],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.twirl,
        locations=[[1, 1.0, 980, 1534, 909], [1, 1.0, 960, 1523, 806], [1, 1.0, 942, 1465, 703], [1, 1.0, 922, 1330, 607], [1, 1.0, 902, 1099, 504]],
    ),
    ColoredBananaGroup(
        group=180,
        map_id=Maps.CreepyCastle,
        name="Gravestones near the lower door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[5, 1.0, 853, 386, 1903], [5, 1.0, 1121, 390, 1847]],
    ),
    ColoredBananaGroup(
        group=181,
        map_id=Maps.CreepyCastle,
        name="Gravestone on the way to lower T&S",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[5, 1.0, 1265, 386, 2077]],
    ),
    ColoredBananaGroup(
        group=182,
        map_id=Maps.CreepyCastle,
        name="Edge next to lower T&S",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        locations=[[1, 1.0, 1877, 368, 1894], [1, 1.0, 1877, 374, 1925], [1, 1.0, 1877, 379, 1955], [1, 1.0, 1877, 385, 1986], [1, 1.0, 1877, 390, 2016]],
    ),
    ColoredBananaGroup(
        group=183,
        map_id=Maps.CastleLowerCave,
        name="Mausoleum door",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[1, 1.0, 1626, 320, 1261], [1, 1.0, 1626, 332, 1261], [1, 1.0, 1626, 345, 1261], [1, 1.0, 1626, 357, 1261], [1, 1.0, 1626, 369, 1261]],
    ),
    ColoredBananaGroup(
        group=184,
        map_id=Maps.CastleLowerCave,
        name="Behind the mausoleum",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[5, 1.0, 1890, 370, 1261]],
    ),
    ColoredBananaGroup(
        group=185,
        map_id=Maps.CastleLowerCave,
        name="Slope towards the crypt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[1, 1.0, 931, 229, 1337], [1, 1.0, 931, 229, 1181], [1, 1.0, 960, 217, 1308], [1, 1.0, 960, 217, 1218], [1, 1.0, 990, 205, 1268]],
    ),
    ColoredBananaGroup(
        group=186,
        map_id=Maps.CastleLowerCave,
        name="Jump behind the fence near crypt",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[1, 1.0, 708, 90, 1271], [1, 1.0, 708, 126, 1271], [1, 1.0, 708, 161, 1271], [1, 1.0, 708, 197, 1271], [1, 1.0, 708, 232, 1271]],
    ),
    ColoredBananaGroup(group=187, map_id=Maps.CastleLowerCave, name="On top of the skull", konglist=[Kongs.diddy, Kongs.tiny], region=Regions.LowerCave, locations=[[5, 1.0, 194, 260, 1271]]),
    ColoredBananaGroup(
        group=188,
        map_id=Maps.CastleLowerCave,
        name="Crypt entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        locations=[[1, 1.0, 289, 91, 1268], [1, 1.0, 313, 91, 1268], [1, 1.0, 336, 90, 1269], [1, 1.0, 360, 90, 1269], [1, 1.0, 383, 90, 1269]],
    ),
    ColoredBananaGroup(
        group=189,
        map_id=Maps.CastleCrypt,
        name="Wall of the warps",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[
            [1, 1.0, 795, 240, 1581],
            [1, 1.0, 795, 250, 1581],
            [1, 1.0, 795, 260, 1581],
            [1, 1.0, 795, 270, 1581],
            [1, 1.0, 795, 280, 1581],
            [1, 1.0, 787, 240, 1760],
            [1, 1.0, 787, 250, 1760],
            [1, 1.0, 787, 260, 1760],
            [1, 1.0, 787, 270, 1760],
            [1, 1.0, 787, 280, 1760],
        ],
    ),
    ColoredBananaGroup(
        group=190,
        map_id=Maps.CastleCrypt,
        name="Torch on Chunky's path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[1, 1.0, 900, 295, 2240], [1, 1.0, 900, 304, 2240], [1, 1.0, 900, 313, 2240], [1, 1.0, 900, 322, 2240], [1, 1.0, 900, 331, 2240]],
    ),
    ColoredBananaGroup(
        group=191,
        map_id=Maps.CastleCrypt,
        name="Left torch on Diddy's path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[1, 1.0, 1234, 135, 810], [1, 1.0, 1234, 144, 810], [1, 1.0, 1234, 153, 810], [1, 1.0, 1234, 162, 810], [1, 1.0, 1234, 171, 810]],
    ),
    ColoredBananaGroup(
        group=192,
        map_id=Maps.CastleCrypt,
        name="Right torch farther down Diddy's path",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        locations=[[1, 1.0, 1577, 95, 621], [1, 1.0, 1577, 104, 621], [1, 1.0, 1577, 113, 621], [1, 1.0, 1577, 122, 621], [1, 1.0, 1577, 131, 621]],
    ),
    ColoredBananaGroup(
        group=193,
        map_id=Maps.CastleCrypt,
        name="Correct levers",
        konglist=[Kongs.donkey],
        region=Regions.CryptDonkeyRoom,
        locations=[
            [1, 1.0, 1610, 81, 2419],
            [1, 1.0, 1567, 81, 2418],
            [1, 1.0, 1523, 81, 2417],
            [1, 1.0, 1480, 81, 2416],
            [1, 1.0, 1437, 81, 2415],
            [1, 1.0, 1608, 81, 2226],
            [1, 1.0, 1574, 81, 2264],
            [1, 1.0, 1540, 81, 2302],
            [1, 1.0, 1505, 81, 2339],
            [1, 1.0, 1471, 81, 2377],
        ],
    ),
    ColoredBananaGroup(
        group=194,
        map_id=Maps.CastleCrypt,
        name="Back chimpy charge switches",
        konglist=[Kongs.diddy],
        region=Regions.CryptDiddyRoom,
        locations=[
            [5, 1.0, 2145, 5, 332],
            [5, 1.0, 2145, 5, 429],
        ],
    ),
    ColoredBananaGroup(
        group=195,
        map_id=Maps.CastleCrypt,
        name="In the slam coffin",
        konglist=[Kongs.chunky],
        region=Regions.CryptChunkyRoom,
        logic=lambda l: l.Slam or l.CanPhase(),
        locations=[
            [5, 1.0, 1037, 165, 2877],
            [5, 1.0, 1099, 165, 2840],
        ],
    ),
    ColoredBananaGroup(group=196, map_id=Maps.CastleMausoleum, name="Grape switch", konglist=[Kongs.lanky, Kongs.tiny], region=Regions.Mausoleum, locations=[[5, 1.0, 790, 275, 1069]]),
    ColoredBananaGroup(
        group=197,
        map_id=Maps.CastleMausoleum,
        name="Vines in the Lanky goo room",
        konglist=[Kongs.lanky],
        region=Regions.Mausoleum,
        logic=lambda l: ((l.grape and l.sprint) or l.generalclips or l.CanPhase()) and l.trombone and l.can_use_vines,
        locations=[[1, 1.0, 2273, 125, 454], [1, 1.0, 2368, 125, 478], [1, 1.0, 2415, 125, 584], [1, 1.0, 2385, 128, 684], [1, 1.0, 2304, 125, 748]],
    ),
    ColoredBananaGroup(
        group=198,
        map_id=Maps.CastleMausoleum,
        name="Slope down Tiny's path",
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.Mausoleum,
        locations=[[1, 1.0, 730, 232, 1244], [1, 1.0, 730, 216, 1281], [1, 1.0, 730, 199, 1317], [1, 1.0, 730, 183, 1354], [1, 1.0, 730, 167, 1390]],
    ),
    ColoredBananaGroup(
        group=199,
        map_id=Maps.CastleDungeon,
        name="Chained to the walls",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[
            [1, 1.0, 876, 195, 1914],
            [1, 1.0, 874, 195, 1928],
            [1, 1.0, 873, 195, 2087],
            [1, 1.0, 603, 115, 1579],
            [1, 1.0, 599, 115, 1569],
            [1, 1.0, 616, 115, 1383],
            [1, 1.0, 607, 115, 1375],
            [1, 1.0, 612, 115, 2432],
            [1, 1.0, 609, 115, 2445],
            [1, 1.0, 496, 181, 2189],
        ],
    ),
    ColoredBananaGroup(
        group=200,
        map_id=Maps.CastleDungeon,
        name="Entrance corners",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        locations=[
            [5, 1.0, 289, 200, 2064],
            [5, 1.0, 289, 200, 1934],
        ],
    ),
    ColoredBananaGroup(
        group=201,
        map_id=Maps.CastleDungeon,
        name="Circle on the DK puzzle",
        konglist=[Kongs.donkey],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[
            [1, 1.0, 1358, 178, 2034],
            [1, 1.0, 1377, 178, 2009],
            [1, 1.0, 1377, 178, 1979],
            [1, 1.0, 1358, 178, 1954],
            [1, 1.0, 1329, 178, 1944],
            [1, 1.0, 1300, 178, 1954],
            [1, 1.0, 1281, 178, 1979],
            [1, 1.0, 1281, 178, 2009],
            [1, 1.0, 1300, 178, 2034],
            [1, 1.0, 1329, 178, 2044],
        ],
    ),
    ColoredBananaGroup(
        group=202,
        map_id=Maps.CastleDungeon,
        name="Rotating throne",
        konglist=[Kongs.diddy],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[[5, 1.0, 531, 98, 3566]],
    ),
    ColoredBananaGroup(
        group=203,
        map_id=Maps.CastleDungeon,
        name="Under the chain vines in Diddy's room",
        konglist=[Kongs.diddy],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        locations=[[1, 1.0, 536, 92, 3021], [1, 1.0, 536, 92, 3159], [1, 1.0, 536, 92, 3281], [1, 1.0, 536, 92, 3385], [1, 1.0, 536, 92, 3492]],
    ),
    ColoredBananaGroup(
        group=204,
        map_id=Maps.CastleDungeon,
        name="Balloon backwards to the main dungeon",  # Hard
        konglist=[Kongs.lanky],
        region=Regions.Dungeon,
        logic=lambda l: (l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase()) and l.trombone and l.balloon,
        locations=[[5, 1.2, 538, 211, 1489]],
    ),
    # ColoredBananaGroup(
    #     group=205,
    #     map_id=Maps.CastleDungeon,
    #     name="In the goo in Lanky's room",
    #     konglist=[Kongs.lanky],
    #     region=Regions.Dungeon,
    #     logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
    #     locations=[[5, 1.0, 630, 90, 997]],
    # ), Will probably add back later
    ColoredBananaGroup(
        group=206,
        map_id=Maps.CastleUpperCave,
        name="Near Candy",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        locations=[
            [1, 1.0, 975, 300, 2185],
            [1, 1.0, 1027, 300, 2178],
            [1, 1.0, 989, 300, 2141],
            [1, 1.0, 998, 300, 2088],
            [1, 1.0, 951, 300, 2113],
            [1, 1.0, 904, 300, 2088],
            [1, 1.0, 913, 300, 2141],
            [1, 1.0, 875, 300, 2178],
            [1, 1.0, 927, 300, 2185],
            [1, 1.0, 951, 300, 2233],
        ],
    ),
    ColoredBananaGroup(group=207, map_id=Maps.CastleShed, name="On the box", konglist=[Kongs.chunky], region=Regions.Shed, locations=[[5, 1.0, 302, 58, 351]]),
    ColoredBananaGroup(
        group=208,
        map_id=Maps.CastleTrashCan,
        name="On the soda can",
        konglist=[Kongs.tiny],
        region=Regions.TrashCan,
        locations=[
            [1, 2.0, 668, 52, 510],
            [1, 2.0, 724, 52, 510],
            [1, 2.0, 780, 52, 510],
            [1, 2.0, 836, 52, 510],
            [1, 2.0, 892, 52, 510],
        ],
    ),
    ColoredBananaGroup(
        group=209,
        map_id=Maps.CastleTree,
        name="First room",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleTree,
        locations=[
            [1, 1.0, 1027, 400, 899],
            [1, 1.0, 1008, 400, 844],
            [1, 1.0, 950, 400, 844],
            [1, 1.0, 931, 400, 899],
            [1, 1.0, 979, 400, 934],
        ],
    ),
    ColoredBananaGroup(
        group=210,
        map_id=Maps.CastleTree,
        name="Against the pineapple gate",
        konglist=[Kongs.chunky],
        region=Regions.CastleTreePastPunch,
        locations=[[1, 1.0, 1744, 327, 286], [1, 1.0, 1744, 327, 306], [1, 1.0, 1744, 327, 325], [1, 1.0, 1744, 327, 345], [1, 1.0, 1744, 327, 364]],
    ),
    ColoredBananaGroup(
        group=211,
        map_id=Maps.CastleTree,
        name="Coconut switch",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleTree,
        locations=[[5, 1.0, 1061, 420, 1028]],
    ),
    ColoredBananaGroup(
        group=212,
        map_id=Maps.CastleTree,
        name="Underwater tunnel",
        konglist=[Kongs.donkey],
        region=Regions.CastleTree,
        logic=lambda l: (l.coconut or l.generalclips or l.CanPhase()) and l.swim,
        locations=[[1, 1.0, 1619, 2, 1501], [1, 1.0, 1602, 2, 1589], [1, 1.0, 1554, 2, 1645], [1, 1.0, 1458, 2, 1681], [1, 1.0, 1341, 2, 1689]],
    ),
    ColoredBananaGroup(
        group=213,
        map_id=Maps.CastleBallroom,
        name="Entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 990, 40, 1574],
            [1, 1.0, 990, 50, 1574],
            [1, 1.0, 990, 60, 1574],
            [1, 1.0, 990, 70, 1574],
            [1, 1.0, 990, 80, 1574],
            [1, 1.0, 990, 40, 1705],
            [1, 1.0, 990, 50, 1705],
            [1, 1.0, 990, 60, 1705],
            [1, 1.0, 990, 70, 1705],
            [1, 1.0, 990, 80, 1705],
        ],
    ),
    ColoredBananaGroup(
        group=214,
        map_id=Maps.CastleBallroom,
        name="Main room entrance",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 496, 120, 1250],
            [1, 1.0, 496, 130, 1250],
            [1, 1.0, 496, 140, 1250],
            [1, 1.0, 496, 150, 1250],
            [1, 1.0, 496, 160, 1250],
            [1, 1.0, 605, 120, 1250],
            [1, 1.0, 605, 130, 1250],
            [1, 1.0, 605, 140, 1250],
            [1, 1.0, 605, 150, 1250],
            [1, 1.0, 605, 160, 1250],
        ],
    ),
    ColoredBananaGroup(
        group=215,
        map_id=Maps.CastleBallroom,
        name="Black spaces",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 685, 45, 856],
            [1, 1.0, 618, 45, 793],
            [1, 1.0, 554, 45, 729],
            [1, 1.0, 486, 45, 666],
            [1, 1.0, 420, 45, 601],
            [1, 1.0, 355, 45, 539],
            [1, 1.0, 355, 45, 666],
            [1, 1.0, 420, 45, 729],
            [1, 1.0, 486, 45, 793],
            [1, 1.0, 551, 45, 856],
        ],
    ),
    ColoredBananaGroup(
        group=216,
        map_id=Maps.CastleBallroom,
        name="White spaces",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[
            [1, 1.0, 349, 45, 856],
            [1, 1.0, 415, 45, 794],
            [1, 1.0, 482, 45, 730],
            [1, 1.0, 547, 45, 667],
            [1, 1.0, 614, 45, 603],
            [1, 1.0, 679, 45, 540],
            [1, 1.0, 743, 45, 478],
            [1, 1.0, 750, 45, 725],
            [1, 1.0, 685, 45, 787],
            [1, 1.0, 617, 45, 854],
        ],
    ),
    ColoredBananaGroup(
        group=217,
        map_id=Maps.CastleBallroom,
        name="Near the monkeyport pad",
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        locations=[[1, 1.0, 757, 40, 1050], [1, 1.0, 641, 50, 1084], [1, 1.0, 550, 60, 1084], [1, 1.0, 457, 50, 1085], [1, 1.0, 342, 40, 1050]],
    ),
    ColoredBananaGroup(
        group=218,
        map_id=Maps.CastleBallroom,
        name="Chandelier",
        konglist=[Kongs.diddy],
        region=Regions.Ballroom,
        logic=lambda l: l.jetpack,
        locations=[
            [1, 1.0, 635, 535, 789],
            [1, 1.0, 703, 535, 740],
            [1, 1.0, 744, 535, 668],
            [1, 1.0, 753, 535, 585],
            [1, 1.0, 727, 535, 506],
            [1, 1.0, 672, 535, 444],
            [1, 1.0, 596, 535, 410],
            [1, 1.0, 512, 535, 410],
            [1, 1.0, 436, 535, 444],
            [1, 1.0, 381, 535, 506],
            [1, 1.0, 355, 535, 585],
            [1, 1.0, 364, 535, 668],
            [1, 1.0, 405, 535, 740],
            [1, 1.0, 473, 535, 789],
            [1, 1.0, 554, 535, 806],
        ],
    ),
    ColoredBananaGroup(
        group=219,
        map_id=Maps.CastleLibrary,
        name="On the big books",
        konglist=[Kongs.donkey],
        region=Regions.Library,
        locations=[
            [1, 1.0, 284, 215, 394],
            [1, 1.0, 331, 215, 401],
            [1, 1.0, 325, 215, 348],
            [1, 1.0, 327, 215, 311],
            [1, 1.0, 341, 215, 275],
            [1, 1.0, 289, 215, 275],
            [1, 1.0, 273, 215, 247],
            [1, 1.0, 228, 215, 287],
            [1, 1.0, 178, 215, 295],
            [1, 1.0, 178, 215, 345],
        ],
    ),
    ColoredBananaGroup(
        group=220,
        map_id=Maps.CastleLibrary,
        name="Flying books hallway",
        konglist=[Kongs.donkey],
        region=Regions.LibraryPastSlam,
        logic=lambda l: l.strongKong,
        locations=[
            [1, 1.0, 2466, 182, 408],
            [1, 1.0, 2476, 184, 366],
            [1, 1.0, 2449, 186, 332],
            [1, 1.0, 2405, 188, 332],
            [1, 1.0, 2378, 190, 366],
            [1, 1.0, 2388, 192, 408],
            [1, 1.0, 2427, 194, 427],
            [1, 1.0, 2449, 196, 365],
            [1, 1.0, 2405, 198, 365],
            [1, 1.0, 2427, 200, 402],
        ],
    ),
    ColoredBananaGroup(
        group=221,
        map_id=Maps.CastleMuseum,
        name="Around the boulder switch",
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        locations=[
            [1, 1.0, 825, 100, 807],
            [1, 1.0, 858, 100, 762],
            [1, 1.0, 858, 100, 706],
            [1, 1.0, 825, 100, 661],
            [1, 1.0, 772, 100, 644],
            [1, 1.0, 719, 100, 661],
            [1, 1.0, 686, 100, 706],
            [1, 1.0, 686, 100, 762],
            [1, 1.0, 719, 100, 807],
            [1, 1.0, 772, 100, 824],
        ],
    ),
    ColoredBananaGroup(
        group=222,
        map_id=Maps.CastleMuseum,
        name="Around the chimney of the little factory",
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        locations=[[1, 1.0, 369, 200, 1654], [1, 1.0, 371, 200, 1702], [1, 1.0, 415, 200, 1727], [1, 1.0, 456, 200, 1704], [1, 1.0, 459, 200, 1655]],
    ),
    ColoredBananaGroup(
        group=223,
        map_id=Maps.CastleTower,
        name="Around the hole",
        konglist=[Kongs.lanky],
        region=Regions.Tower,
        locations=[
            [1, 1.0, 499, 226, 537],
            [1, 1.0, 561, 226, 452],
            [1, 1.0, 561, 226, 346],
            [1, 1.0, 499, 226, 261],
            [1, 1.0, 399, 226, 229],
            [1, 1.0, 299, 226, 261],
            [1, 1.0, 237, 226, 346],
            [1, 1.0, 237, 226, 452],
            [1, 1.0, 299, 226, 537],
            [1, 1.0, 399, 226, 569],
        ],
    ),
]

BalloonList = [
    Balloon(
        id=1,
        map_id=Maps.CreepyCastle,
        name="Below first bridge",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[586, 330, 325], [404, 330, 340]],
    ),
    Balloon(
        id=2,
        map_id=Maps.CreepyCastle,
        name="Around big tree",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1248, 580, 127], [1361, 585, 243], [1295, 590, 368], [1142, 585, 313], [1149, 580, 184]],
    ),
    Balloon(
        id=3,
        map_id=Maps.CreepyCastle,
        name="Above area near low T&S portal",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        points=[[1322, 620, 1922], [1361, 600, 2141], [1600, 580, 2141], [1361, 600, 2141]],
    ),
    Balloon(
        id=4,
        map_id=Maps.CreepyCastle,
        name="Above empty area past W1",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        points=[[481, 720, 1802], [673, 700, 1834]],
    ),
    Balloon(
        id=5,
        map_id=Maps.CreepyCastle,
        name="Over and under moat bridge",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[608, 600, 726], [608, 810, 726], [883, 810, 915], [883, 600, 915]],
    ),
    Balloon(
        id=6,
        map_id=Maps.CreepyCastle,
        name="Above moat tunnel entrance",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1084, 760, 946], [1269, 750, 892]],
    ),
    Balloon(
        id=7,
        map_id=Maps.CreepyCastle,
        name="Above headphones by warps tag",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1785, 800, 932], [1857, 785, 1028]],
    ),
    Balloon(
        id=8,
        map_id=Maps.CreepyCastle,
        name="On right side of path to W2 (Diddy balloon on the left)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1228, 910, 2110], [850, 890, 2136]],
    ),
    Balloon(
        id=9,
        map_id=Maps.CreepyCastle,
        name="By Lanky blueprint",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1902, 820, 1730], [1902, 940, 1730]],
    ),
    Balloon(
        id=10,
        map_id=Maps.CreepyCastle,
        name="Above path from W2 to W3 (castle side)",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1279, 1060, 984], [1132, 1060, 1002]],
    ),
    Balloon(
        id=11,
        map_id=Maps.CreepyCastle,
        name="Around Cranky's shop",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[343, 1240, 1387], [155, 1260, 1272], [228, 1250, 1574]],
    ),
    Balloon(
        id=12,
        map_id=Maps.CreepyCastle,
        name="Behind greenhouse",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1619, 1480, 2147], [1832, 1490, 2013]],
    ),
    Balloon(
        id=13,
        map_id=Maps.CreepyCastle,
        name="Near ballroom entrance",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[
            [1995, 1500, 1412],
            [2085, 1510, 1331],
            [2080, 1520, 1142],
            [1942, 1510, 1090],
            [2080, 1495, 1142],
            [2085, 1480, 1331],
        ],
    ),
    Balloon(
        id=14,
        map_id=Maps.CreepyCastle,
        name="On path near W5 (castle side)",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[950, 1640, 1492], [1165, 1660, 1543]],
    ),
    Balloon(
        id=15,
        map_id=Maps.CreepyCastle,
        name="Around tower",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[
            [1673, 1780, 1245],
            [1497, 1820, 1160],
            [1418, 1840, 1383],
            [1597, 1830, 1502],
            [1740, 1820, 1357],
            [1597, 1810, 1502],
            [1418, 1795, 1383],
            [1497, 1805, 1160],
        ],
    ),
    Balloon(
        id=16,
        map_id=Maps.CreepyCastle,
        name="Above tower",
        speed=8,
        konglist=[Kongs.diddy],
        region=Regions.CreepyCastleMain,
        logic=lambda l: l.jetpack,
        points=[[1502, 2160, 1444], [1426, 2150, 1276], [1659, 2140, 1176], [1720, 2150, 1420]],
    ),
    Balloon(
        id=17,
        map_id=Maps.CreepyCastle,
        name="Behind Snide's",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[
            [704, 1900, 1087],
            [473, 1915, 1289],
            [539, 1920, 1565],
            [734, 1910, 1655],
            [539, 1900, 1565],
            [473, 1885, 1289],
        ],
    ),
    Balloon(
        id=18,
        map_id=Maps.CastleBallroom,
        name="In back of the room",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        points=[[444, 150, 367], [668, 140, 367]],
    ),
    Balloon(
        id=19,
        map_id=Maps.CastleDungeon,
        name="In Lanky's section",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        points=[[642, 200, 1488], [466, 220, 1405], [425, 190, 1563]],
    ),
    Balloon(
        id=20,
        map_id=Maps.CastleDungeon,
        name="In Diddy's section",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        points=[[636, 210, 2596], [447, 205, 2599], [457, 200, 2448], [687, 205, 2457]],
    ),
    Balloon(
        id=21,
        map_id=Maps.CastleDungeon,
        name="In DK's room",
        speed=10,
        konglist=[Kongs.donkey],
        region=Regions.Dungeon,
        logic=lambda l: l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase(),
        points=[[1500, 260, 1922], [1538, 275, 2092], [1382, 270, 2033]],
    ),
    Balloon(
        id=22,
        map_id=Maps.CastleLowerCave,
        name="Above pathway to crypt",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        points=[[744, 350, 1147], [698, 360, 1448]],
    ),
    Balloon(
        id=23,
        map_id=Maps.CastleLowerCave,
        name="Around mausoleum",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        points=[[1596, 440, 1339], [1614, 430, 1166], [1852, 410, 1168], [1814, 425, 1375]],
    ),
    Balloon(
        id=24,
        map_id=Maps.CastleCrypt,
        name="Above warps",
        speed=8,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        points=[[737, 350, 1488], [782, 360, 1672], [717, 345, 1867]],
    ),
    Balloon(
        id=25,
        map_id=Maps.CastleCrypt,
        name="Around coffin in Chunky's room",
        speed=7,
        konglist=[Kongs.chunky],
        region=Regions.CryptChunkyRoom,
        points=[[1229, 280, 2721], [1257, 285, 3014], [882, 275, 2975], [910, 280, 2715]],
    ),
    Balloon(
        id=26,
        map_id=Maps.CastleCrypt,
        name="Around coffin in Diddy's room",
        speed=7,
        konglist=[Kongs.diddy],
        region=Regions.CryptDiddyRoom,
        points=[[1951, 140, 246], [2167, 130, 194], [2174, 150, 600], [1968, 145, 577]],
    ),
    Balloon(
        id=27,
        map_id=Maps.CastleMausoleum,
        name="In and out of green goo pit",
        speed=11,
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.Mausoleum,
        points=[[1002, 220, 1731], [1002, 0, 1731]],
    ),
    Balloon(
        id=28,
        map_id=Maps.CastleMausoleum,
        name="Above green goo room",
        speed=8,
        konglist=[Kongs.tiny],
        region=Regions.Mausoleum,
        logic=lambda l: l.twirl or (l.monkey_maneuvers and (not l.isKrushaAdjacent(Kongs.tiny))),
        points=[[1304, 240, 2150], [967, 230, 2140]],
    ),
    Balloon(
        id=29,
        map_id=Maps.CastleUpperCave,
        name="Near moat entrance",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        points=[[171, 260, 2495], [498, 300, 2519]],
    ),
    Balloon(
        id=30,
        map_id=Maps.CastleUpperCave,
        name="Near Candy",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        points=[[1033, 400, 2071], [967, 410, 2253], [846, 400, 2108]],
    ),
    Balloon(
        id=31,
        map_id=Maps.CastleUpperCave,
        name="Coming in and out of pit by Tiny's bonus barrel",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        points=[[900, 240, 820], [900, 0, 820]],
    ),
    Balloon(
        id=32,
        map_id=Maps.CastleLibrary,
        name="In switch room",
        speed=8,
        konglist=[Kongs.donkey],
        region=Regions.Library,
        points=[[395, 280, 507], [178, 290, 498], [153, 300, 215]],
    ),
    Balloon(
        id=33,
        map_id=Maps.CastleLibrary,
        name="In GB room",
        speed=8,
        konglist=[Kongs.donkey],
        region=Regions.LibraryPastBooks,
        points=[[2707, 270, 255], [2850, 270, 280], [2857, 280, 492], [2682, 290, 476]],
    ),
    Balloon(
        id=34,
        map_id=Maps.CastleMuseum,
        name="In hallway to main room",
        speed=7,
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        points=[[787, 260, 1850], [778, 280, 1540]],
    ),
    Balloon(
        id=35,
        map_id=Maps.CastleMuseum,
        name="Around car race",
        speed=9,
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        points=[[522, 300, 1480], [305, 300, 1432], [288, 310, 1782], [533, 300, 1746]],
    ),
    Balloon(
        id=36,
        map_id=Maps.CastleTree,
        name="First room",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleTree,
        points=[[856, 510, 960], [1002, 515, 1045], [1080, 490, 866], [957, 495, 736], [842, 500, 830]],
    ),
    Balloon(
        id=37,
        map_id=Maps.CreepyCastle,
        name="Above W1 (Diddy)",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        vanilla=True,
        points=[[1036, 926, 1600], [1116, 910, 1550]],
    ),
    Balloon(
        id=38,
        map_id=Maps.CastleBallroom,
        name="By bonus barrel (Diddy)",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Ballroom,
        vanilla=True,
        points=[[610, 279, 954], [482, 282, 959]],
    ),
    Balloon(
        id=39,
        map_id=Maps.CastleTower,
        name="In tower (Lanky)",
        speed=9,
        konglist=[Kongs.lanky],
        region=Regions.Tower,
        vanilla=True,
        points=[[453, 379, 530], [332, 369, 511], [288, 375, 339], [414, 371, 284], [525, 373, 417]],
    ),
    Balloon(
        id=40,
        map_id=Maps.CastleMausoleum,
        name="In Lanky's green goo room (Lanky)",
        speed=7,
        konglist=[Kongs.lanky],
        region=Regions.Mausoleum,
        vanilla=True,
        logic=lambda l: l.sprint or l.generalclips or l.CanPhase(),
        points=[[2366, 134, 465], [2399, 124, 652], [2270, 126, 563]],
    ),
    Balloon(
        id=41,
        map_id=Maps.CastleCrypt,
        name="In coffin in Diddy's room (Diddy)",
        speed=3,
        konglist=[Kongs.diddy],
        region=Regions.CryptDiddyRoom,
        vanilla=True,
        logic=lambda l: l.charge or l.generalclips or l.CanPhase(),
        points=[[2044, 25, 59], [2061, 28, 56]],
    ),
    Balloon(
        id=42,
        map_id=Maps.CastleCrypt,
        name="In DK's room (Donkey)",
        speed=6,
        konglist=[Kongs.donkey],
        region=Regions.CryptDonkeyRoom,
        vanilla=True,
        points=[[1628, 132, 2476], [1434, 128, 2452]],
    ),
    Balloon(
        id=43,
        map_id=Maps.CastleMuseum,
        name="In monument room (Tiny)",
        speed=10,
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        vanilla=True,
        logic=lambda l: l.feather and (l.monkeyport or l.CanPhase()),
        points=[[1274, 268, 1475], [1238, 284, 1629], [1080, 248, 1628], [1022, 266, 1437], [1220, 288, 1390]],
    ),
    Balloon(
        id=44,
        map_id=Maps.CastleMuseum,
        name="Around middle (Chunky)",
        speed=5,
        konglist=[Kongs.chunky],
        region=Regions.Museum,
        vanilla=True,
        points=[[721, 156, 820], [682, 152, 731], [735, 146, 648], [867, 156, 684], [860, 152, 793]],
    ),
    Balloon(
        id=45,
        map_id=Maps.CastleDungeon,
        name="In Diddy's dungeon room (Diddy)",
        speed=9,
        konglist=[Kongs.diddy],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: (l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase()),
        points=[[603, 126, 3473], [476, 146, 3415], [594, 186, 3334]],
    ),
    Balloon(
        id=46,
        map_id=Maps.CastleDungeon,
        name="Far in Lanky's dungeon room (Lanky)",
        speed=6,
        konglist=[Kongs.lanky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: (l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase()) and l.trombone and l.balloon,
        points=[[617, 144, 261], [480, 144, 253]],
    ),
    Balloon(
        id=47,
        map_id=Maps.CastleDungeon,
        name="In cage left side (Chunky)",
        speed=2,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: (l.punch or l.CanPhase() or l.generalclips),
        points=[[751, 145, 2510], [753, 145, 2533]],
    ),
    Balloon(
        id=48,
        map_id=Maps.CastleDungeon,
        name="Close in Lanky's dungeon room (Lanky)",
        speed=7,
        konglist=[Kongs.lanky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: (l.CanSlamSwitch(Levels.CreepyCastle, 3) or l.CanPhase()),
        points=[[453, 156, 820], [661, 154, 805]],
    ),
    Balloon(
        id=49,
        map_id=Maps.CastleDungeon,
        name="In cage right side (Chunky)",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        vanilla=True,
        logic=lambda l: (l.punch or l.CanPhase() or l.generalclips),
        points=[[322, 137, 2535], [322, 137, 2516]],
    ),
    Balloon(
        id=50,
        map_id=Maps.CastleTree,
        name="Above hole (Donkey)",
        speed=13,
        konglist=[Kongs.donkey],
        region=Regions.CastleTree,
        vanilla=True,
        points=[[1011, 428, 1604], [1058, 484, 1745], [937, 496, 1845], [795, 460, 1761], [868, 446, 1572]],
    ),
    Balloon(
        id=51,
        map_id=Maps.CastleTree,
        name="In Chunky's room (Chunky)",
        speed=10,
        konglist=[Kongs.chunky],
        region=Regions.CastleTreePastPunch,
        vanilla=True,
        points=[[1676, 381, 289], [1510, 399, 382], [1402, 371, 326], [1300, 389, 406], [1202, 404, 304], [1053, 412, 378]],
    ),
    Balloon(
        id=53,
        map_id=Maps.CastleLowerCave,
        name="In front of crypt (Diddy)",
        speed=10,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        vanilla=True,
        points=[[325, 220, 1466], [197, 293, 1258], [257, 306, 1229]],
    ),
    Balloon(
        id=54,
        map_id=Maps.CastleLowerCave,
        name="In front of Funky (Tiny)",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        vanilla=True,
        points=[[1366, 294, 376], [1578, 284, 353]],
    ),
    # Wave 2 by Snap
    Balloon(
        id=55,
        map_id=Maps.CreepyCastle,
        name="From portal to lone kasplat",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[154, 477, 437], [69, 477, 569], [64, 477, 747], [69, 477, 569]],
    ),
    Balloon(
        id=56,
        map_id=Maps.CreepyCastle,
        name="Near ladder to headphones",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[1860, 600, 813], [1913, 649, 993], [2004, 578, 912]],
    ),
    Balloon(
        id=57,
        map_id=Maps.CreepyCastle,
        name="Around the lower T&S area",
        speed=6,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        points=[[1863, 425, 1965], [1718, 566, 1965], [1551, 622, 1993], [1547, 459, 2152], [1751, 444, 2129]],
    ),
    Balloon(
        id=58,
        map_id=Maps.CreepyCastle,
        name="Rising from the graveyard",
        speed=4,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleGraveyardPlatform,
        points=[[575, 606, 1742], [575, 480, 1742]],
    ),
    Balloon(
        id=59,
        map_id=Maps.CreepyCastle,
        name="Near the lower door",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CastleVeryBottom,
        points=[[1020, 400, 2044], [1006, 444, 2140], [1003, 319, 2089]],
    ),
    Balloon(
        id=60,
        map_id=Maps.CreepyCastle,
        name="Around tree in uneventful area just above the grayevard",
        speed=5,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[351, 900, 1610], [258, 711, 1737], [118, 722, 1680], [167, 800, 1532]],
    ),
    Balloon(
        id=61,
        map_id=Maps.CreepyCastle,
        name="Near museum platforms",
        speed=12,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.CreepyCastleMain,
        points=[[773, 1242, 1750], [850, 1211, 1547], [1028, 1165, 1514], [1114, 1303, 1728]],
    ),
    Balloon(
        id=62,
        map_id=Maps.CastleLowerCave,
        name="Tunnel to Funky",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.LowerCave,
        points=[[1078, 269, 1045], [1164, 196, 844], [1368, 222, 923], [1550, 240, 682], [1368, 222, 923], [1164, 196, 844]],
    ),
    Balloon(
        id=63,
        map_id=Maps.CastleCrypt,
        name="DK's path",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        points=[[1345, 170, 1977], [1095, 150, 1964], [1077, 155, 1713], [1095, 150, 1964]],
    ),
    Balloon(
        id=64,
        map_id=Maps.CastleCrypt,
        name="Tilted pineapple switch",
        speed=2,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.chunky],
        region=Regions.Crypt,
        points=[[1071, 220, 2519], [1071, 230, 2519]],
    ),
    Balloon(
        id=65,
        map_id=Maps.CastleMausoleum,
        name="Beginning of Lanky's path",
        speed=10,
        konglist=[Kongs.lanky, Kongs.tiny],
        region=Regions.Mausoleum,
        points=[[728, 200, 580], [1160, 200, 583]],
    ),
    Balloon(
        id=66,
        map_id=Maps.CastleDungeon,
        name="Intersection",
        speed=9,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.Dungeon,
        points=[[540, 250, 2005], [545, 250, 1759], [540, 250, 2005], [751, 250, 1998], [540, 250, 2005], [548, 250, 2244], [540, 250, 2005], [366, 250, 2005]],
    ),
    Balloon(
        id=67,
        map_id=Maps.CastleUpperCave,
        name="Near the dungeon door",
        speed=7,
        konglist=[Kongs.donkey, Kongs.diddy, Kongs.lanky, Kongs.tiny, Kongs.chunky],
        region=Regions.UpperCave,
        points=[[180, 222, 1213], [239, 262, 1490], [154, 222, 1754], [133, 235, 1527]],
    ),
    Balloon(
        id=68,
        map_id=Maps.CastleGreenhouse,
        name="Dead end near the arena",
        speed=4,
        konglist=[Kongs.lanky],
        region=Regions.Greenhouse,
        points=[[625, 40, 525], [570, 40, 525]],
    ),
    Balloon(
        id=69,
        map_id=Maps.CastleShed,
        name="Back of the shed (Chunky)",
        speed=6,
        konglist=[Kongs.chunky],
        region=Regions.Shed,
        vanilla=True,
        points=[[398, 90, 452], [223, 75, 474]],
    ),  # This one was missing from the list of vanilla
    Balloon(
        id=70,
        map_id=Maps.CastleTrashCan,
        name="Above the cheese",
        speed=15,
        konglist=[Kongs.tiny],
        region=Regions.TrashCan,
        points=[[592, 150, 687], [582, 111, 619], [618, 200, 583], [624, 150, 676], [549, 120, 625], [603, 140, 579], [593, 250, 620], [619, 100, 732], [582, 175, 543]],
    ),
    Balloon(
        id=71,
        map_id=Maps.CastleBallroom,
        name="Above the back candle",
        speed=5,
        konglist=[Kongs.diddy],
        region=Regions.Ballroom,
        logic=lambda l: l.jetpack,
        points=[[438, 433, 210], [606, 425, 212]],
    ),
    Balloon(
        id=72,
        map_id=Maps.CastleLibrary,
        name="Among the flying books",
        speed=13,
        konglist=[Kongs.donkey],
        region=Regions.LibraryPastSlam,
        points=[[2266, 200, 470], [2266, 200, 270], [2376, 260, 270], [2376, 260, 470], [2467, 215, 470], [2467, 215, 270], [2556, 280, 270], [2556, 280, 470]],
    ),
    Balloon(
        id=73,
        map_id=Maps.CastleMuseum,
        name="Through the glass",
        speed=10,
        konglist=[Kongs.tiny],
        region=Regions.MuseumBehindGlass,
        points=[[536, 263, 1636], [1020, 257, 1482]],
    ),
]
