from BaseClasses import Location
import typing
from .Names import locationName


class BanjoTooieLocation(Location):
    game: str = "Banjo-Tooie"

class LocationData(typing.NamedTuple):
    #last good ID: 1231640 (CCL Bean 2)
    #12C770 pointer instead (1230704)
    btid: int = 0
    # Save + mem addr
    memaddr: int = 0
    # some items have bitmasks. if bitmask>0 bitor to give item else
    bitmask: int = 0
    # some items are part of a group that needs to be processed seperately
    group: str  = ""

SMLoc_table = {
    locationName.CHEATOSM1: LocationData(1230752, 0x59, 3, "Cheato Page"),
    locationName.JINJOIH5:  LocationData(1230595, 0x3F, 0, "Jinjo"),
    locationName.ROYSTEN1:   LocationData(1230777, 0x36, 2), #obtained when breaking out roysten
    locationName.ROYSTEN2:   LocationData(1230778, 0x9E, 6), #obtained when breaking out roysten

    locationName.PMEGG:     LocationData(1230956, 0x77, 5, "Stop 'n' Swop"),
    locationName.BMEGG:     LocationData(1230957, 0x77, 3, "Stop 'n' Swop"),

    #Nests don"t have a save flag in the base game.
    locationName.NESTSM1: LocationData(1231010, 0, 0, "Nest"),
    locationName.NESTSM2: LocationData(1231011, 0, 0, "Nest"),
    locationName.NESTSM3: LocationData(1231012, 0, 0, "Nest"),
    locationName.NESTSM4: LocationData(1231013, 0, 0, "Nest"),
    locationName.NESTSM5: LocationData(1231014, 0, 0, "Nest"),
    locationName.NESTSM6: LocationData(1231015, 0, 0, "Nest"),
    locationName.NESTSM7: LocationData(1231016, 0, 0, "Nest"),
    locationName.NESTSM8: LocationData(1231017, 0, 0, "Nest"),
    locationName.NESTSM9: LocationData(1231018, 0, 0, "Nest"),
    locationName.NESTSM10: LocationData(1231019, 0, 0, "Nest"),
    locationName.NESTSM11: LocationData(1231020, 0, 0, "Nest"),
    locationName.NESTSM12: LocationData(1231021, 0, 0, "Nest"),
    locationName.NESTSM13: LocationData(1231022, 0, 0, "Nest"),
    locationName.NESTSM14: LocationData(1231023, 0, 0, "Nest"),
    locationName.NESTSM15: LocationData(1231024, 0, 0, "Nest"),
    locationName.NESTSM16: LocationData(1231025, 0, 0, "Nest"),
    locationName.NESTSM17: LocationData(1231026, 0, 0, "Nest"),
    locationName.NESTSM18: LocationData(1231027, 0, 0, "Nest"),
    locationName.NESTSM19: LocationData(1231028, 0, 0, "Nest"),
    locationName.NESTSM20: LocationData(1231029, 0, 0, "Nest"),
    locationName.NESTSM21: LocationData(1231030, 0, 0, "Nest"),
    locationName.NESTSM22: LocationData(1231031, 0, 0, "Nest"),
    locationName.NESTSM23: LocationData(1231032, 0, 0, "Nest"),
    locationName.NESTSM24: LocationData(1231033, 0, 0, "Nest"),
    locationName.NESTSM25: LocationData(1231034, 0, 0, "Nest"),
}

CheatoRewardsLoc_table = {
    locationName.CHEATOR1:  LocationData(1230992, 0x08, 4),
    locationName.CHEATOR2:  LocationData(1230993, 0x08, 5),
    locationName.CHEATOR3:  LocationData(1230994, 0x08, 6),
    locationName.CHEATOR4:  LocationData(1230995, 0x08, 7),
    locationName.CHEATOR5:  LocationData(1230996, 0x09, 0),
}

JVLoc_table = {
    locationName.JIGGYIH10: LocationData(1230685, 0x50, 1, "Jiggy"),

    locationName.TREBLEJV:  LocationData(1230789, 0x97, 7, "Treble Clef"),  #Set last ID for Clef Family. Client Reasons
    locationName.IKEY:      LocationData(1230958, 0, 0, "Stop 'n' Swop"), #Needs to be handled on client side
    locationName.GOGGLES: LocationData(1231005, 0x1E, 0), #actually watching 0x30, bit 1

    locationName.NESTIH1: LocationData(1231035, 0, 0, "Nest"),
    locationName.NESTIH2: LocationData(1231036, 0, 0, "Nest"),
    locationName.NESTIH3: LocationData(1231037, 0, 0, "Nest"),
    locationName.NESTIH4: LocationData(1231038, 0, 0, "Nest"),
    locationName.NESTIH5: LocationData(1231039, 0, 0, "Nest"),
    locationName.NESTIH6: LocationData(1231040, 0, 0, "Nest"),
    locationName.NESTIH7: LocationData(1231041, 0, 0, "Nest"),
    locationName.NESTIH8: LocationData(1231042, 0, 0, "Nest"),
    locationName.NESTIH9: LocationData(1231043, 0, 0, "Nest"),
    locationName.NESTIH10: LocationData(1231044, 0, 0, "Nest"),
    locationName.NESTIH11: LocationData(1231045, 0, 0, "Nest"),
    locationName.NESTIH12: LocationData(1231046, 0, 0, "Nest"),
    locationName.NESTIH13: LocationData(1231047, 0, 0, "Nest"),
    locationName.NESTIH14: LocationData(1231048, 0, 0, "Nest"),
    locationName.NESTIH15: LocationData(1231049, 0, 0, "Nest"),
    locationName.NESTIH16: LocationData(1231050, 0, 0, "Nest"),
    locationName.NESTIH17: LocationData(1231051, 0, 0, "Nest"),

    locationName.SIGNIH1:   LocationData(1231483, 0, 0, "Signpost"),

    locationName.SILOIOHJV:   LocationData(1231550, 0, 0, "Silos"),
}

JinjoRewardsLoc_table = {
    locationName.JIGGYIH1:  LocationData(1230676, 0x4F, 0),
    locationName.JIGGYIH2:  LocationData(1230677, 0x4F, 1),
    locationName.JIGGYIH3:  LocationData(1230678, 0x4F, 2),
    locationName.JIGGYIH4:  LocationData(1230679, 0x4F, 3),
    locationName.JIGGYIH5:  LocationData(1230680, 0x4F, 4),
    locationName.JIGGYIH6:  LocationData(1230681, 0x4F, 5),
    locationName.JIGGYIH7:  LocationData(1230682, 0x4F, 6),
    locationName.JIGGYIH8:  LocationData(1230683, 0x4F, 7),
    locationName.JIGGYIH9:  LocationData(1230684, 0x50, 0),
}

MTLoc_Table = {
    locationName.JINJOMT1: LocationData(1230551, 0x39, 4, "Jinjo"),
    locationName.JINJOMT2: LocationData(1230552, 0x39, 5, "Jinjo"),
    locationName.JINJOMT3: LocationData(1230553, 0x39, 6, "Jinjo"),
    locationName.JINJOMT4: LocationData(1230554, 0x39, 7, "Jinjo"),
    locationName.JINJOMT5: LocationData(1230555, 0x3A, 0, "Jinjo"),
    locationName.JIGGYMT1:  LocationData(1230596, 0x45, 0, "Jiggy"),
    locationName.JIGGYMT2:  LocationData(1230597, 0x45, 1, "Jiggy"),
    locationName.JIGGYMT3:  LocationData(1230598, 0x45, 2, "Jiggy"),
    locationName.JIGGYMT4:  LocationData(1230599, 0x45, 3, "Jiggy"),
    locationName.JIGGYMT5:  LocationData(1230600, 0x45, 4, "Jiggy"),
    locationName.JIGGYMT6:  LocationData(1230601, 0x45, 5, "Jiggy"),
    locationName.JIGGYMT7:  LocationData(1230602, 0x45, 6, "Jiggy"),
    locationName.JIGGYMT8:  LocationData(1230603, 0x45, 7, "Jiggy"),
    locationName.JIGGYMT9:  LocationData(1230604, 0x46, 0, "Jiggy"),
    locationName.JIGGYMT10: LocationData(1230605, 0x46, 1, "Jiggy"),
    locationName.GLOWBOMT1: LocationData(1230686, 0x42, 7, "Glowbo"),
    locationName.GLOWBOMT2: LocationData(1230687, 0x43, 0, "Glowbo"),
    locationName.HONEYCMT1: LocationData(1230703, 0x3F, 2, "Honeycomb"),
    locationName.HONEYCMT2: LocationData(1230704, 0x3F, 3, "Honeycomb"),
    locationName.HONEYCMT3: LocationData(1230705, 0x3F, 4, "Honeycomb"),
    locationName.CHEATOMT1: LocationData(1230728, 0x56, 3, "Cheato Page"),
    locationName.CHEATOMT2: LocationData(1230729, 0x56, 4, "Cheato Page"),
    locationName.CHEATOMT3: LocationData(1230730, 0x56, 5, "Cheato Page"),
    locationName.EGGAIM:    LocationData(1230753, 0x1B, 3, "Jamjars Silo"),
    locationName.BBLASTER:  LocationData(1230754, 0x1B, 2, "Jamjars Silo"),
    locationName.GGRAB:     LocationData(1230755, 0x1B, 1, "Jamjars Silo"),
    locationName.TREBLEMT:  LocationData(1230781, 0x86, 7, "Treble Clef"),
    locationName.NOTEMT1:   LocationData(1230800, 0x84, 7, "Note"),
    locationName.NOTEMT2:   LocationData(1230801, 0x85, 0, "Note"),
    locationName.NOTEMT3:   LocationData(1230802, 0x85, 1, "Note"),
    locationName.NOTEMT4:   LocationData(1230803, 0x85, 2, "Note"),
    locationName.NOTEMT5:   LocationData(1230804, 0x85, 3, "Note"),
    locationName.NOTEMT6:   LocationData(1230805, 0x85, 4, "Note"),
    locationName.NOTEMT7:   LocationData(1230806, 0x85, 5, "Note"),
    locationName.NOTEMT8:   LocationData(1230807, 0x85, 6, "Note"),
    locationName.NOTEMT9:   LocationData(1230808, 0x85, 7, "Note"),
    locationName.NOTEMT10:  LocationData(1230809, 0x86, 0, "Note"),
    locationName.NOTEMT11:  LocationData(1230810, 0x86, 1, "Note"),
    locationName.NOTEMT12:  LocationData(1230811, 0x86, 2, "Note"),
    locationName.NOTEMT13:  LocationData(1230812, 0x86, 3, "Note"),
    locationName.NOTEMT14:  LocationData(1230813, 0x86, 4, "Note"),
    locationName.NOTEMT15:  LocationData(1230814, 0x86, 5, "Note"),
    locationName.NOTEMT16:  LocationData(1230815, 0x86, 6, "Note"),

    locationName.NESTMT1: LocationData(1231098, 0, 0, "Nest"),
    locationName.NESTMT2: LocationData(1231099, 0, 0, "Nest"),
    locationName.NESTMT3: LocationData(1231100, 0, 0, "Nest"),
    locationName.NESTMT4: LocationData(1231101, 0, 0, "Nest"),
    locationName.NESTMT5: LocationData(1231102, 0, 0, "Nest"),
    locationName.NESTMT6: LocationData(1231103, 0, 0, "Nest"),
    locationName.NESTMT7: LocationData(1231104, 0, 0, "Nest"),
    locationName.NESTMT8: LocationData(1231105, 0, 0, "Nest"),
    locationName.NESTMT9: LocationData(1231106, 0, 0, "Nest"),
    locationName.NESTMT10: LocationData(1231107, 0, 0, "Nest"),
    locationName.NESTMT11: LocationData(1231108, 0, 0, "Nest"),
    locationName.NESTMT12: LocationData(1231109, 0, 0, "Nest"),
    locationName.NESTMT13: LocationData(1231110, 0, 0, "Nest"),
    locationName.NESTMT14: LocationData(1231111, 0, 0, "Nest"),
    locationName.NESTMT15: LocationData(1231112, 0, 0, "Nest"),
    locationName.NESTMT16: LocationData(1231113, 0, 0, "Nest"),
    locationName.NESTMT17: LocationData(1231114, 0, 0, "Nest"),
    locationName.NESTMT18: LocationData(1231115, 0, 0, "Nest"),
    locationName.NESTMT19: LocationData(1231116, 0, 0, "Nest"),
    locationName.NESTMT20: LocationData(1231117, 0, 0, "Nest"),
    locationName.NESTMT21: LocationData(1231118, 0, 0, "Nest"),
    locationName.NESTMT22: LocationData(1231119, 0, 0, "Nest"),
    locationName.NESTMT23: LocationData(1231120, 0, 0, "Nest"),
    locationName.NESTMT24: LocationData(1231121, 0, 0, "Nest"),
    locationName.NESTMT25: LocationData(1231122, 0, 0, "Nest"),
    locationName.NESTMT26: LocationData(1231123, 0, 0, "Nest"),
    locationName.NESTMT27: LocationData(1231124, 0, 0, "Nest"),
    locationName.NESTMT28: LocationData(1231125, 0, 0, "Nest"),
    locationName.NESTMT29: LocationData(1231126, 0, 0, "Nest"),
    locationName.NESTMT30: LocationData(1231127, 0, 0, "Nest"),
    locationName.NESTMT31: LocationData(1231128, 0, 0, "Nest"),
    locationName.NESTMT32: LocationData(1231129, 0, 0, "Nest"),
    locationName.NESTMT33: LocationData(1231130, 0, 0, "Nest"),
    locationName.NESTMT34: LocationData(1231131, 0, 0, "Nest"),
    locationName.NESTMT35: LocationData(1231132, 0, 0, "Nest"),
    locationName.NESTMT36: LocationData(1231133, 0, 0, "Nest"),
    locationName.NESTMT37: LocationData(1231134, 0, 0, "Nest"),
    locationName.NESTMT38: LocationData(1231135, 0, 0, "Nest"),
    locationName.NESTMT39: LocationData(1231136, 0, 0, "Nest"),
    locationName.NESTMT40: LocationData(1231137, 0, 0, "Nest"),
    locationName.NESTMT41: LocationData(1231138, 0, 0, "Nest"),

    locationName.SIGNMT1:   LocationData(1231502, 0, 0, "Signpost"),
    locationName.SIGNMT2:   LocationData(1231503, 0, 0, "Signpost"),
    locationName.SIGNMT3:   LocationData(1231504, 0, 0, "Signpost"),
    locationName.SIGNMT4:   LocationData(1231505, 0, 0, "Signpost"),
    locationName.SIGNMT5:   LocationData(1231506, 0, 0, "Signpost"),
    locationName.SIGNMT6:   LocationData(1231507, 0, 0, "Signpost"),
    locationName.SIGNMT7:   LocationData(1231508, 0, 0, "Signpost"),
    locationName.SIGNMT8:   LocationData(1231509, 0, 0, "Signpost"),
    locationName.SIGNMT9:   LocationData(1231510, 0, 0, "Signpost"),

    locationName.WARPMT1:   LocationData(1231557, 0, 0, "Warp Pads"),
    locationName.WARPMT2:   LocationData(1231558, 0, 0, "Warp Pads"),
    locationName.WARPMT3:   LocationData(1231559, 0, 0, "Warp Pads"),
    locationName.WARPMT4:   LocationData(1231560, 0, 0, "Warp Pads"),
    locationName.WARPMT5:   LocationData(1231561, 0, 0, "Warp Pads"),

    locationName.GRRELICE1:   LocationData(1231614, 0x5A, 5, "Green Relic"),
    locationName.GRRELICE2:   LocationData(1231615, 0x5A, 4, "Green Relic"),
    locationName.GRRELICB1:   LocationData(1231616, 0x5B, 7, "Green Relic"),
    locationName.GRRELICB2:   LocationData(1231617, 0x5B, 6, "Green Relic"),
    locationName.GRRELICB3:   LocationData(1231618, 0x5B, 5, "Green Relic"),
    locationName.GRRELICC1:   LocationData(1231619, 0x5B, 3, "Green Relic"),
    locationName.GRRELICC2:   LocationData(1231620, 0x5B, 4, "Green Relic"),
    locationName.GRRELICC3:   LocationData(1231621, 0x5B, 2, "Green Relic"),
    locationName.GRRELICC4:   LocationData(1231622, 0x5B, 1, "Green Relic"),
    locationName.GRRELICC5:   LocationData(1231623, 0x5C, 2, "Green Relic"),
    locationName.GRRELICG1:   LocationData(1231624, 0x5C, 3, "Green Relic"),
    locationName.GRRELICG2:   LocationData(1231625, 0x5C, 5, "Green Relic"),
    locationName.GRRELICG3:   LocationData(1231626, 0x5C, 4, "Green Relic"),
    locationName.GRRELICG4:   LocationData(1231627, 0x5C, 6, "Green Relic"),
    locationName.GRRELICG5:   LocationData(1231628, 0x5C, 7, "Green Relic"),
    locationName.GRRELICT1:   LocationData(1231629, 0x5C, 1, "Green Relic"),
    locationName.GRRELICT2:   LocationData(1231630, 0x5C, 0, "Green Relic"),
    locationName.GRRELICP1:   LocationData(1231631, 0x5D, 0, "Green Relic"),
    locationName.GRRELICP2:   LocationData(1231632, 0x5D, 1, "Green Relic"),
    locationName.GRRELICP3:   LocationData(1231633, 0x5D, 2, "Green Relic"),
    locationName.GRRELICS1:   LocationData(1231634, 0x5D, 4, "Green Relic"),
    locationName.GRRELICS2:   LocationData(1231635, 0x5D, 3, "Green Relic"),
    locationName.GRRELICR1:   LocationData(1231636, 0x5A, 6, "Green Relic"),
    locationName.GRRELICR2:   LocationData(1231637, 0x5A, 7, "Green Relic"),
    locationName.GRRELICR3:   LocationData(1231638, 0x5B, 0, "Green Relic"),

}

IHPLLoc_table = {
    locationName.JINJOIH4:  LocationData(1230594, 0x3E, 7, "Jinjo"),
    locationName.HONEYCIH1: LocationData(1230727, 0x42, 2, "Honeycomb"),
    locationName.FEGGS:     LocationData(1230756, 0x1E, 1, "Jamjars Silo"),
    locationName.NOTEIH1:   LocationData(1230928, 0x95, 7, "Note"),
    locationName.NOTEIH2:   LocationData(1230929, 0x96, 0, "Note"),
    locationName.NOTEIH3:   LocationData(1230930, 0x96, 1, "Note"),
    locationName.NOTEIH4:   LocationData(1230931, 0x96, 2, "Note"),

    locationName.NESTIH27: LocationData(1231061, 0, 0, "Nest"),
    locationName.NESTIH28: LocationData(1231062, 0, 0, "Nest"),
    locationName.NESTIH29: LocationData(1231063, 0, 0, "Nest"),
    locationName.NESTIH30: LocationData(1231064, 0, 0, "Nest"),
    locationName.NESTIH31: LocationData(1231065, 0, 0, "Nest"),
    locationName.NESTIH32: LocationData(1231066, 0, 0, "Nest"),
    locationName.NESTIH33: LocationData(1231067, 0, 0, "Nest"),

    locationName.SILOIOHPL:   LocationData(1231552, 0, 0, "Silos"),
}

HoneyBRewardsLoc_table = {
    locationName.HONEYBR1:  LocationData(1230997, 0x98, 2),
    locationName.HONEYBR2:  LocationData(1230998, 0x98, 3),
    locationName.HONEYBR3:  LocationData(1230999, 0x98, 0), #binary. bit 2 and 3 is set
    locationName.HONEYBR4:  LocationData(1231000, 0x98, 4),
    locationName.HONEYBR5:  LocationData(1231001, 0x98, 0), #binary. bit 2 and 4 is set
}

GMLoc_table = {
    locationName.JINJOGM1: LocationData(1230556, 0x3A, 1, "Jinjo"),
    locationName.JINJOGM2: LocationData(1230557, 0x3A, 2, "Jinjo"),
    locationName.JINJOGM3: LocationData(1230558, 0x3A, 3, "Jinjo"),
    locationName.JINJOGM4: LocationData(1230559, 0x3A, 4, "Jinjo"),
    locationName.JINJOGM5: LocationData(1230560, 0x3A, 5, "Jinjo"),
    locationName.JIGGYGM1:  LocationData(1230606, 0x46, 2, "Jiggy"),
    locationName.JIGGYGM2:  LocationData(1230607, 0x46, 3, "Jiggy"),
    locationName.JIGGYGM3:  LocationData(1230608, 0x46, 4, "Jiggy"),
    locationName.JIGGYGM4:  LocationData(1230609, 0x46, 5, "Jiggy"),
    locationName.JIGGYGM5:  LocationData(1230610, 0x46, 6, "Jiggy"),
    locationName.JIGGYGM6:  LocationData(1230611, 0x46, 7, "Jiggy"),
    locationName.JIGGYGM7:  LocationData(1230612, 0x47, 0, "Jiggy"),
    locationName.JIGGYGM8:  LocationData(1230613, 0x47, 1, "Jiggy"),
    locationName.JIGGYGM9:  LocationData(1230614, 0x47, 2, "Jiggy"),
    locationName.JIGGYGM10: LocationData(1230615, 0x47, 3, "Jiggy"),
    locationName.GLOWBOGM1: LocationData(1230688, 0x43, 1, "Glowbo"),
    locationName.GLOWBOGM2: LocationData(1230689, 0x43, 2, "Glowbo"),
    locationName.GLOWBOMEG: LocationData(1230046, 0x05, 6, "Glowbo"),
    locationName.HONEYCGM1: LocationData(1230706, 0x3F, 5, "Honeycomb"),
    locationName.HONEYCGM2: LocationData(1230707, 0x3F, 6, "Honeycomb"),
    locationName.HONEYCGM3: LocationData(1230708, 0x3F, 7, "Honeycomb"),
    locationName.CHEATOGM1: LocationData(1230731, 0x56, 6, "Cheato Page"),
    locationName.CHEATOGM2: LocationData(1230732, 0x56, 7, "Cheato Page"),
    locationName.CHEATOGM3: LocationData(1230733, 0x57, 0, "Cheato Page"),
    locationName.BDRILL:    LocationData(1230757, 0x1B, 6, "Jamjars Silo"),
    locationName.BBAYONET:  LocationData(1230758, 0x1B, 7, "Jamjars Silo"),
    locationName.TREBLEGM:  LocationData(1230782, 0x89, 0, "Treble Clef"),
    locationName.CHUFFY:    LocationData(1230796, 0x0B, 6, "Chuffy"),
    locationName.NOTEGGM1:   LocationData(1230816, 0x87, 0, "Note"),
    locationName.NOTEGGM2:   LocationData(1230817, 0x87, 1, "Note"),
    locationName.NOTEGGM3:   LocationData(1230818, 0x87, 2, "Note"),
    locationName.NOTEGGM4:   LocationData(1230819, 0x87, 3, "Note"),
    locationName.NOTEGGM5:   LocationData(1230820, 0x87, 4, "Note"),
    locationName.NOTEGGM6:   LocationData(1230821, 0x87, 5, "Note"),
    locationName.NOTEGGM7:   LocationData(1230822, 0x87, 6, "Note"),
    locationName.NOTEGGM8:   LocationData(1230823, 0x87, 7, "Note"),
    locationName.NOTEGGM9:   LocationData(1230824, 0x88, 0, "Note"),
    locationName.NOTEGGM10:  LocationData(1230825, 0x88, 1, "Note"),
    locationName.NOTEGGM11:  LocationData(1230826, 0x88, 2, "Note"),
    locationName.NOTEGGM12:  LocationData(1230827, 0x88, 3, "Note"),
    locationName.NOTEGGM13:  LocationData(1230828, 0x88, 4, "Note"),
    locationName.NOTEGGM14:  LocationData(1230829, 0x88, 5, "Note"),
    locationName.NOTEGGM15:  LocationData(1230830, 0x88, 6, "Note"),
    locationName.NOTEGGM16:  LocationData(1230831, 0x88, 7, "Note"),
    locationName.CHUNK1:    LocationData(1231002, 0x7D, 0),
    locationName.CHUNK2:    LocationData(1231003, 0x7D, 1),
    locationName.CHUNK3:    LocationData(1231004, 0x7D, 2),



    locationName.NESTGM1: LocationData(1231139, 0, 0, "Nest"),
    locationName.NESTGM2: LocationData(1231140, 0, 0, "Nest"),
    locationName.NESTGM3: LocationData(1231141, 0, 0, "Nest"),
    locationName.NESTGM4: LocationData(1231142, 0, 0, "Nest"),
    locationName.NESTGM5: LocationData(1231143, 0, 0, "Nest"),
    locationName.NESTGM6: LocationData(1231144, 0, 0, "Nest"),
    locationName.NESTGM7: LocationData(1231145, 0, 0, "Nest"),
    locationName.NESTGM8: LocationData(1231146, 0, 0, "Nest"),
    locationName.NESTGM9: LocationData(1231147, 0, 0, "Nest"),
    locationName.NESTGM10: LocationData(1231148, 0, 0, "Nest"),
    locationName.NESTGM11: LocationData(1231149, 0, 0, "Nest"),
    locationName.NESTGM12: LocationData(1231150, 0, 0, "Nest"),
    locationName.NESTGM13: LocationData(1231151, 0, 0, "Nest"),
    locationName.NESTGM14: LocationData(1231152, 0, 0, "Nest"),
    locationName.NESTGM15: LocationData(1231153, 0, 0, "Nest"),
    locationName.NESTGM16: LocationData(1231154, 0, 0, "Nest"),
    locationName.NESTGM17: LocationData(1231155, 0, 0, "Nest"),
    locationName.NESTGM18: LocationData(1231156, 0, 0, "Nest"),
    locationName.NESTGM19: LocationData(1231157, 0, 0, "Nest"),
    locationName.NESTGM20: LocationData(1231158, 0, 0, "Nest"),
    locationName.NESTGM21: LocationData(1231159, 0, 0, "Nest"),
    locationName.NESTGM22: LocationData(1231160, 0, 0, "Nest"),
    locationName.NESTGM23: LocationData(1231161, 0, 0, "Nest"),
    locationName.NESTGM24: LocationData(1231162, 0, 0, "Nest"),
    locationName.NESTGM25: LocationData(1231163, 0, 0, "Nest"),
    locationName.NESTGM26: LocationData(1231164, 0, 0, "Nest"),
    locationName.NESTGM27: LocationData(1231165, 0, 0, "Nest"),
    locationName.NESTGM28: LocationData(1231166, 0, 0, "Nest"),
    locationName.NESTGM29: LocationData(1231167, 0, 0, "Nest"),
    locationName.NESTGM30: LocationData(1231168, 0, 0, "Nest"),
    locationName.NESTGM31: LocationData(1231169, 0, 0, "Nest"),
    locationName.NESTGM32: LocationData(1231170, 0, 0, "Nest"),
    locationName.NESTGM33: LocationData(1231171, 0, 0, "Nest"),
    locationName.NESTGM34: LocationData(1231172, 0, 0, "Nest"),
    locationName.NESTGM35: LocationData(1231173, 0, 0, "Nest"),
    locationName.NESTGM36: LocationData(1231174, 0, 0, "Nest"),
    locationName.NESTGM37: LocationData(1231175, 0, 0, "Nest"),
    locationName.NESTGM38: LocationData(1231176, 0, 0, "Nest"),

    locationName.SIGNGM1:   LocationData(1231511, 0, 0, "Signpost"),
    locationName.SIGNGM2:   LocationData(1231512, 0, 0, "Signpost"),
    locationName.SIGNGM3:   LocationData(1231513, 0, 0, "Signpost"),
    locationName.SIGNGM4:   LocationData(1231514, 0, 0, "Signpost"),


    locationName.WARPGM1:   LocationData(1231562, 0, 0, "Warp Pads"),
    locationName.WARPGM2:   LocationData(1231563, 0, 0, "Warp Pads"),
    locationName.WARPGM3:   LocationData(1231564, 0, 0, "Warp Pads"),
    locationName.WARPGM4:   LocationData(1231565, 0, 0, "Warp Pads"),
    locationName.WARPGM5:   LocationData(1231566, 0, 0, "Warp Pads"),
}

IHPGLoc_table = {
    locationName.GEGGS:    LocationData(1230759, 0x1E, 2, "Jamjars Silo"),
    locationName.NOTEIH5:   LocationData(1230932, 0x96, 3, "Note"),
    locationName.NOTEIH6:   LocationData(1230933, 0x96, 4, "Note"),
    locationName.NOTEIH7:   LocationData(1230934, 0x96, 5, "Note"),
    locationName.NOTEIH8:   LocationData(1230935, 0x96, 6, "Note"),

    locationName.NESTIH34: LocationData(1231068, 0, 0, "Nest"),
    locationName.NESTIH35: LocationData(1231069, 0, 0, "Nest"),
    locationName.NESTIH36: LocationData(1231070, 0, 0, "Nest"),
    locationName.NESTIH37: LocationData(1231071, 0, 0, "Nest"),
    locationName.NESTIH38: LocationData(1231072, 0, 0, "Nest"),
    locationName.NESTIH39: LocationData(1231073, 0, 0, "Nest"),

    locationName.NESTIH46: LocationData(1231080, 0, 0, "Nest"),
    locationName.NESTIH47: LocationData(1231081, 0, 0, "Nest"),

    locationName.SIGNIH15:   LocationData(1231497, 0, 0, "Signpost"),
    locationName.SIGNIH16:   LocationData(1231498, 0, 0, "Signpost"),
    locationName.SIGNIH17:   LocationData(1231499, 0, 0, "Signpost"),

    locationName.SILOIOHPG:   LocationData(1231553, 0, 0, "Silos"),
}

WWLoc_table = {
    locationName.JINJOWW1: LocationData(1230561, 0x3A, 6, "Jinjo"),
    locationName.JINJOWW2: LocationData(1230562, 0x3A, 7, "Jinjo"),
    locationName.JINJOWW3: LocationData(1230563, 0x3B, 0, "Jinjo"),
    locationName.JINJOWW4: LocationData(1230564, 0x3B, 1, "Jinjo"),
    locationName.JINJOWW5: LocationData(1230565, 0x3B, 2, "Jinjo"),
    locationName.JIGGYWW1:  LocationData(1230616, 0x47, 4, "Jiggy"),
    locationName.JIGGYWW2:  LocationData(1230617, 0x47, 5, "Jiggy"),
    locationName.JIGGYWW3:  LocationData(1230618, 0x47, 6, "Jiggy"),
    locationName.JIGGYWW4:  LocationData(1230619, 0x47, 7, "Jiggy"),
    locationName.JIGGYWW5:  LocationData(1230620, 0x48, 0, "Jiggy"),
    locationName.JIGGYWW6:  LocationData(1230621, 0x48, 1, "Jiggy"),
    locationName.JIGGYWW7:  LocationData(1230622, 0x48, 2, "Jiggy"),
    locationName.JIGGYWW8:  LocationData(1230623, 0x48, 3, "Jiggy"),
    locationName.JIGGYWW9:  LocationData(1230624, 0x48, 4, "Jiggy"),
    locationName.JIGGYWW10: LocationData(1230625, 0x48, 5, "Jiggy"),
    locationName.GLOWBOWW1: LocationData(1230690, 0x43, 3, "Glowbo"),
    locationName.GLOWBOWW2: LocationData(1230691, 0x43, 4, "Glowbo"),
    locationName.HONEYCWW1: LocationData(1230709, 0x40, 0, "Honeycomb"),
    locationName.HONEYCWW2: LocationData(1230710, 0x40, 1, "Honeycomb"),
    locationName.HONEYCWW3: LocationData(1230711, 0x40, 2, "Honeycomb"),
    locationName.CHEATOWW1: LocationData(1230734, 0x57, 1, "Cheato Page"),
    locationName.CHEATOWW2: LocationData(1230735, 0x57, 2, "Cheato Page"),
    locationName.CHEATOWW3: LocationData(1230736, 0x57, 3, "Cheato Page"),
    locationName.AIREAIM:   LocationData(1230760, 0x1C, 0, "Jamjars Silo"),
    locationName.SPLITUP:   LocationData(1230761, 0x1C, 1, "Jamjars Silo"),
    locationName.PACKWH:    LocationData(1230762, 0x1D, 6, "Jamjars Silo"),
    locationName.TREBLEWW:  LocationData(1230783, 0x8B, 1, "Treble Clef"),
    locationName.TRAINSWWW: LocationData(1230795, 0x0D, 6, "Train Switch"),
    locationName.NOTEWW1:   LocationData(1230832, 0x89, 1, "Note"),
    locationName.NOTEWW2:   LocationData(1230833, 0x89, 2, "Note"),
    locationName.NOTEWW3:   LocationData(1230834, 0x89, 3, "Note"),
    locationName.NOTEWW4:   LocationData(1230835, 0x89, 4, "Note"),
    locationName.NOTEWW5:   LocationData(1230836, 0x89, 5, "Note"),
    locationName.NOTEWW6:   LocationData(1230837, 0x89, 6, "Note"),
    locationName.NOTEWW7:   LocationData(1230838, 0x89, 7, "Note"),
    locationName.NOTEWW8:   LocationData(1230839, 0x8A, 0, "Note"),
    locationName.NOTEWW9:   LocationData(1230840, 0x8A, 1, "Note"),
    locationName.NOTEWW10:  LocationData(1230841, 0x8A, 2, "Note"),
    locationName.NOTEWW11:  LocationData(1230842, 0x8A, 3, "Note"),
    locationName.NOTEWW12:  LocationData(1230843, 0x8A, 4, "Note"),
    locationName.NOTEWW13:  LocationData(1230844, 0x8A, 5, "Note"),
    locationName.NOTEWW14:  LocationData(1230845, 0x8A, 6, "Note"),
    locationName.NOTEWW15:  LocationData(1230846, 0x8A, 7, "Note"),
    locationName.NOTEWW16:  LocationData(1230847, 0x8B, 0, "Note"),

    locationName.NESTWW1: LocationData(1231177, 0, 0, "Nest"),
    locationName.NESTWW2: LocationData(1231178, 0, 0, "Nest"),
    locationName.NESTWW3: LocationData(1231179, 0, 0, "Nest"),
    locationName.NESTWW4: LocationData(1231180, 0, 0, "Nest"),
    locationName.NESTWW5: LocationData(1231181, 0, 0, "Nest"),
    locationName.NESTWW6: LocationData(1231182, 0, 0, "Nest"),
    locationName.NESTWW7: LocationData(1231183, 0, 0, "Nest"),
    locationName.NESTWW8: LocationData(1231184, 0, 0, "Nest"),
    locationName.NESTWW9: LocationData(1231185, 0, 0, "Nest"),
    locationName.NESTWW10: LocationData(1231186, 0, 0, "Nest"),
    locationName.NESTWW11: LocationData(1231187, 0, 0, "Nest"),
    locationName.NESTWW12: LocationData(1231188, 0, 0, "Nest"),
    locationName.NESTWW13: LocationData(1231189, 0, 0, "Nest"),
    locationName.NESTWW14: LocationData(1231190, 0, 0, "Nest"),
    locationName.NESTWW15: LocationData(1231191, 0, 0, "Nest"),
    locationName.NESTWW16: LocationData(1231192, 0, 0, "Nest"),
    locationName.NESTWW17: LocationData(1231193, 0, 0, "Nest"),
    locationName.NESTWW18: LocationData(1231194, 0, 0, "Nest"),
    locationName.NESTWW19: LocationData(1231195, 0, 0, "Nest"),
    locationName.NESTWW20: LocationData(1231196, 0, 0, "Nest"),
    locationName.NESTWW21: LocationData(1231197, 0, 0, "Nest"),
    locationName.NESTWW22: LocationData(1231198, 0, 0, "Nest"),
    locationName.NESTWW23: LocationData(1231199, 0, 0, "Nest"),
    locationName.NESTWW24: LocationData(1231200, 0, 0, "Nest"),
    locationName.NESTWW25: LocationData(1231201, 0, 0, "Nest"),
    locationName.NESTWW26: LocationData(1231202, 0, 0, "Nest"),
    locationName.NESTWW27: LocationData(1231203, 0, 0, "Nest"),
    locationName.NESTWW28: LocationData(1231204, 0, 0, "Nest"),
    locationName.NESTWW29: LocationData(1231205, 0, 0, "Nest"),
    locationName.NESTWW30: LocationData(1231206, 0, 0, "Nest"),
    locationName.NESTWW31: LocationData(1231207, 0, 0, "Nest"),
    locationName.NESTWW32: LocationData(1231208, 0, 0, "Nest"),
    locationName.NESTWW33: LocationData(1231209, 0, 0, "Nest"),
    locationName.NESTWW34: LocationData(1231210, 0, 0, "Nest"),
    locationName.NESTWW35: LocationData(1231211, 0, 0, "Nest"),
    locationName.NESTWW36: LocationData(1231212, 0, 0, "Nest"),
    locationName.NESTWW37: LocationData(1231213, 0, 0, "Nest"),
    locationName.NESTWW38: LocationData(1231214, 0, 0, "Nest"),
    locationName.NESTWW39: LocationData(1231215, 0, 0, "Nest"),
    locationName.NESTWW40: LocationData(1231216, 0, 0, "Nest"),
    locationName.NESTWW41: LocationData(1231217, 0, 0, "Nest"),
    locationName.NESTWW42: LocationData(1231218, 0, 0, "Nest"),

    locationName.SIGNWW1:   LocationData(1231515, 0, 0, "Signpost"),
    locationName.SIGNWW2:   LocationData(1231516, 0, 0, "Signpost"),
    locationName.SIGNWW3:   LocationData(1231517, 0, 0, "Signpost"),
    locationName.SIGNWW4:   LocationData(1231518, 0, 0, "Signpost"),
    locationName.SIGNWW5:   LocationData(1231519, 0, 0, "Signpost"),
    locationName.SIGNWW6:   LocationData(1231520, 0, 0, "Signpost"),
    locationName.SIGNWW7:   LocationData(1231521, 0, 0, "Signpost"),
    locationName.SIGNWW8:   LocationData(1231522, 0, 0, "Signpost"),

    locationName.WARPWW1:   LocationData(1231567, 0, 0, "Warp Pads"),
    locationName.WARPWW2:   LocationData(1231568, 0, 0, "Warp Pads"),
    locationName.WARPWW3:   LocationData(1231569, 0, 0, "Warp Pads"),
    locationName.WARPWW4:   LocationData(1231570, 0, 0, "Warp Pads"),
    locationName.WARPWW5:   LocationData(1231571, 0, 0, "Warp Pads"),

    locationName.MOGGY:     LocationData(1231596, 0x0C, 4),
    locationName.SOGGY:     LocationData(1231597, 0x0C, 5),
    locationName.GROGGY:    LocationData(1231598, 0x0C, 6),

    locationName.BTTICK1:   LocationData(1231610, 0x9C, 4, "Ticket"),
    locationName.BTTICK2:   LocationData(1231611, 0x9C, 5, "Ticket"),
    locationName.BTTICK3:   LocationData(1231612, 0x9C, 6, "Ticket"),
    locationName.BTTICK4:   LocationData(1231613, 0x9C, 7, "Ticket")
}
JRLoc_table = {
    locationName.JRLDB1: LocationData(1230521, 0x22, 7, "Doubloon"),
    locationName.JRLDB2: LocationData(1230522, 0x23, 0, "Doubloon"),
    locationName.JRLDB3: LocationData(1230523, 0x23, 1, "Doubloon"),
    locationName.JRLDB4: LocationData(1230524, 0x23, 2, "Doubloon"),
    locationName.JRLDB5: LocationData(1230525, 0x23, 3, "Doubloon"),
    locationName.JRLDB6: LocationData(1230526, 0x23, 4, "Doubloon"),
    locationName.JRLDB7: LocationData(1230527, 0x23, 5, "Doubloon"),
    locationName.JRLDB8: LocationData(1230528, 0x23, 6, "Doubloon"),
    locationName.JRLDB9: LocationData(1230529, 0x23, 7, "Doubloon"),
    locationName.JRLDB10: LocationData(1230530, 0x24, 0, "Doubloon"),
    locationName.JRLDB11: LocationData(1230531, 0x24, 1, "Doubloon"),
    locationName.JRLDB12: LocationData(1230532, 0x24, 2, "Doubloon"),
    locationName.JRLDB13: LocationData(1230533, 0x24, 3, "Doubloon"),
    locationName.JRLDB14: LocationData(1230534, 0x24, 4, "Doubloon"),
    locationName.JRLDB15: LocationData(1230535, 0x24, 5, "Doubloon"),
    locationName.JRLDB16: LocationData(1230536, 0x24, 6, "Doubloon"),
    locationName.JRLDB17: LocationData(1230537, 0x24, 7, "Doubloon"),
    locationName.JRLDB18: LocationData(1230538, 0x25, 0, "Doubloon"),
    locationName.JRLDB19: LocationData(1230539, 0x25, 1, "Doubloon"),
    locationName.JRLDB20: LocationData(1230540, 0x25, 2, "Doubloon"),
    locationName.JRLDB21: LocationData(1230541, 0x25, 3, "Doubloon"),
    locationName.JRLDB22: LocationData(1230542, 0x25, 4, "Doubloon"),
    locationName.JRLDB23: LocationData(1230543, 0x25, 5, "Doubloon"),
    locationName.JRLDB24: LocationData(1230544, 0x25, 6, "Doubloon"),
    locationName.JRLDB25: LocationData(1230545, 0x25, 7, "Doubloon"),
    locationName.JRLDB26: LocationData(1230546, 0x26, 0, "Doubloon"),
    locationName.JRLDB27: LocationData(1230547, 0x26, 1, "Doubloon"),
    locationName.JRLDB28: LocationData(1230548, 0x26, 2, "Doubloon"),
    locationName.JRLDB29: LocationData(1230549, 0x26, 3, "Doubloon"),
    locationName.JRLDB30: LocationData(1230550, 0x26, 4, "Doubloon"),
    locationName.JINJOJR1:  LocationData(1230566, 0x3B, 3, "Jinjo"),
    locationName.JINJOJR2:  LocationData(1230567, 0x3B, 4, "Jinjo"),
    locationName.JINJOJR3:  LocationData(1230568, 0x3B, 5, "Jinjo"),
    locationName.JINJOJR4:  LocationData(1230569, 0x3B, 6, "Jinjo"),
    locationName.JINJOJR5:  LocationData(1230570, 0x3B, 7, "Jinjo"),
    locationName.JIGGYJR1:  LocationData(1230626, 0x48, 6, "Jiggy"),
    locationName.JIGGYJR2:  LocationData(1230627, 0x48, 7, "Jiggy"),
    locationName.JIGGYJR3:  LocationData(1230628, 0x49, 0, "Jiggy"),
    locationName.JIGGYJR4:  LocationData(1230629, 0x49, 1, "Jiggy"),
    locationName.JIGGYJR5:  LocationData(1230630, 0x49, 2, "Jiggy"),
    locationName.JIGGYJR6:  LocationData(1230631, 0x49, 3, "Jiggy"),
    locationName.JIGGYJR7:  LocationData(1230632, 0x49, 4, "Jiggy"),
    locationName.JIGGYJR8:  LocationData(1230633, 0x49, 5, "Jiggy"),
    locationName.JIGGYJR9:  LocationData(1230634, 0x49, 6, "Jiggy"),
    locationName.JIGGYJR10: LocationData(1230635, 0x49, 7, "Jiggy"),
    locationName.GLOWBOJR1: LocationData(1230692, 0x43, 5, "Glowbo"),
    locationName.GLOWBOJR2: LocationData(1230693, 0x43, 6, "Glowbo"),
    locationName.HONEYCJR1: LocationData(1230712, 0x40, 3, "Honeycomb"),
    locationName.HONEYCJR2: LocationData(1230713, 0x40, 4, "Honeycomb"),
    locationName.HONEYCJR3: LocationData(1230714, 0x40, 5, "Honeycomb"),
    locationName.CHEATOJR1: LocationData(1230737, 0x57, 4, "Cheato Page"),
    locationName.CHEATOJR2: LocationData(1230738, 0x57, 5, "Cheato Page"),
    locationName.CHEATOJR3: LocationData(1230739, 0x57, 6, "Cheato Page"),
    locationName.WWHACK:   LocationData(1230764, 0x1C, 2, "Jamjars Silo"),
    locationName.TTORP:    LocationData(1230765, 0x1C, 3, "Jamjars Silo"),
    locationName.AUQAIM:   LocationData(1230766, 0x1C, 4, "Jamjars Silo"),
    locationName.TREBLEJR: LocationData(1230784, 0x8D, 2, "Treble Clef"),
    locationName.NOTEJRL1:   LocationData(1230848, 0x8B, 2, "Note"),
    locationName.NOTEJRL2:   LocationData(1230849, 0x8B, 3, "Note"),
    locationName.NOTEJRL3:   LocationData(1230850, 0x8B, 4, "Note"),
    locationName.NOTEJRL4:   LocationData(1230851, 0x8B, 5, "Note"),
    locationName.NOTEJRL5:   LocationData(1230852, 0x8B, 6, "Note"),
    locationName.NOTEJRL6:   LocationData(1230853, 0x8B, 7, "Note"),
    locationName.NOTEJRL7:   LocationData(1230854, 0x8C, 0, "Note"),
    locationName.NOTEJRL8:   LocationData(1230855, 0x8C, 1, "Note"),
    locationName.NOTEJRL9:   LocationData(1230856, 0x8C, 2, "Note"),
    locationName.NOTEJRL10:  LocationData(1230857, 0x8C, 3, "Note"),
    locationName.NOTEJRL11:  LocationData(1230858, 0x8C, 4, "Note"),
    locationName.NOTEJRL12:  LocationData(1230859, 0x8C, 5, "Note"),
    locationName.NOTEJRL13:  LocationData(1230860, 0x8C, 6, "Note"),
    locationName.NOTEJRL14:  LocationData(1230861, 0x8C, 6, "Note"),
    locationName.NOTEJRL15:  LocationData(1230862, 0x8D, 0, "Note"),
    locationName.NOTEJRL16:  LocationData(1230863, 0x8D, 1, "Note"),

    locationName.NESTJR1: LocationData(1231219, 0, 0, "Nest"),
    locationName.NESTJR2: LocationData(1231220, 0, 0, "Nest"),
    locationName.NESTJR3: LocationData(1231221, 0, 0, "Nest"),
    locationName.NESTJR4: LocationData(1231222, 0, 0, "Nest"),
    locationName.NESTJR5: LocationData(1231223, 0, 0, "Nest"),
    locationName.NESTJR6: LocationData(1231224, 0, 0, "Nest"),
    locationName.NESTJR7: LocationData(1231225, 0, 0, "Nest"),
    locationName.NESTJR8: LocationData(1231226, 0, 0, "Nest"),
    locationName.NESTJR9: LocationData(1231227, 0, 0, "Nest"),
    locationName.NESTJR10: LocationData(1231228, 0, 0, "Nest"),
    locationName.NESTJR11: LocationData(1231229, 0, 0, "Nest"),
    locationName.NESTJR12: LocationData(1231230, 0, 0, "Nest"),
    locationName.NESTJR13: LocationData(1231231, 0, 0, "Nest"),
    locationName.NESTJR14: LocationData(1231232, 0, 0, "Nest"),
    locationName.NESTJR15: LocationData(1231233, 0, 0, "Nest"),
    locationName.NESTJR16: LocationData(1231234, 0, 0, "Nest"),
    locationName.NESTJR17: LocationData(1231235, 0, 0, "Nest"),
    locationName.NESTJR18: LocationData(1231236, 0, 0, "Nest"),
    locationName.NESTJR19: LocationData(1231237, 0, 0, "Nest"),
    locationName.NESTJR20: LocationData(1231238, 0, 0, "Nest"),
    locationName.NESTJR21: LocationData(1231239, 0, 0, "Nest"),
    locationName.NESTJR22: LocationData(1231240, 0, 0, "Nest"),
    locationName.NESTJR23: LocationData(1231241, 0, 0, "Nest"),
    locationName.NESTJR24: LocationData(1231242, 0, 0, "Nest"),
    locationName.NESTJR25: LocationData(1231243, 0, 0, "Nest"),
    locationName.NESTJR26: LocationData(1231244, 0, 0, "Nest"),
    locationName.NESTJR27: LocationData(1231245, 0, 0, "Nest"),
    locationName.NESTJR28: LocationData(1231246, 0, 0, "Nest"),
    locationName.NESTJR29: LocationData(1231247, 0, 0, "Nest"),
    locationName.NESTJR30: LocationData(1231248, 0, 0, "Nest"),
    locationName.NESTJR31: LocationData(1231249, 0, 0, "Nest"),
    locationName.NESTJR32: LocationData(1231250, 0, 0, "Nest"),
    locationName.NESTJR33: LocationData(1231251, 0, 0, "Nest"),
    locationName.NESTJR34: LocationData(1231252, 0, 0, "Nest"),
    locationName.NESTJR35: LocationData(1231253, 0, 0, "Nest"),
    locationName.NESTJR36: LocationData(1231254, 0, 0, "Nest"),
    locationName.NESTJR37: LocationData(1231255, 0, 0, "Nest"),
    locationName.NESTJR38: LocationData(1231256, 0, 0, "Nest"),
    locationName.NESTJR39: LocationData(1231257, 0, 0, "Nest"),
    locationName.NESTJR40: LocationData(1231258, 0, 0, "Nest"),

    locationName.SIGNJR1:   LocationData(1231523, 0, 0, "Signpost"),
    locationName.SIGNJR2:   LocationData(1231524, 0, 0, "Signpost"),
    locationName.SIGNJR3:   LocationData(1231525, 0, 0, "Signpost"),
    locationName.SIGNJR4:   LocationData(1231526, 0, 0, "Signpost"),

    locationName.WARPJR1:   LocationData(1231572, 0, 0, "Warp Pads"),
    locationName.WARPJR2:   LocationData(1231573, 0, 0, "Warp Pads"),
    locationName.WARPJR3:   LocationData(1231574, 0, 0, "Warp Pads"),
    locationName.WARPJR4:   LocationData(1231575, 0, 0, "Warp Pads"),
    locationName.WARPJR5:   LocationData(1231576, 0, 0, "Warp Pads"),
}

TLLoc_table = {
    locationName.JINJOTL1:  LocationData(1230571, 0x3C, 0, "Jinjo"),
    locationName.JINJOTL2:  LocationData(1230572, 0x3C, 1, "Jinjo"),
    locationName.JINJOTL3:  LocationData(1230573, 0x3C, 2, "Jinjo"),
    locationName.JINJOTL4:  LocationData(1230574, 0x3C, 3, "Jinjo"),
    locationName.JINJOTL5:  LocationData(1230575, 0x3C, 4, "Jinjo"),
    locationName.JIGGYTD1:  LocationData(1230636, 0x4A, 0, "Jiggy"),
    locationName.JIGGYTD2:  LocationData(1230637, 0x4A, 1, "Jiggy"),
    locationName.JIGGYTD3:  LocationData(1230638, 0x4A, 2, "Jiggy"),
    locationName.JIGGYTD4:  LocationData(1230639, 0x4A, 3, "Jiggy"),
    locationName.JIGGYTD5:  LocationData(1230640, 0x4A, 4, "Jiggy"),
    locationName.JIGGYTD6:  LocationData(1230641, 0x4A, 5, "Jiggy"),
    locationName.JIGGYTD7:  LocationData(1230642, 0x4A, 6, "Jiggy"),
    locationName.JIGGYTD8:  LocationData(1230643, 0x4A, 7, "Jiggy"),
    locationName.JIGGYTD9:  LocationData(1230644, 0x4B, 0, "Jiggy"),
    locationName.JIGGYTD10: LocationData(1230645, 0x4B, 1, "Jiggy"),
    locationName.GLOWBOTL1: LocationData(1230694, 0x43, 7, "Glowbo"),
    locationName.GLOWBOTL2: LocationData(1230695, 0x44, 0, "Glowbo"),
    locationName.HONEYCTL1: LocationData(1230715, 0x40, 6, "Honeycomb"),
    locationName.HONEYCTL2: LocationData(1230716, 0x40, 7, "Honeycomb"),
    locationName.HONEYCTL3: LocationData(1230717, 0x41, 0, "Honeycomb"),
    locationName.CHEATOTL1: LocationData(1230740, 0x57, 7, "Cheato Page"),
    locationName.CHEATOTL2: LocationData(1230741, 0x58, 0, "Cheato Page"),
    locationName.CHEATOTL3: LocationData(1230742, 0x58, 1, "Cheato Page"),
    locationName.SPRINGB:   LocationData(1230768, 0x1D, 3, "Jamjars Silo"),
    locationName.TAXPACK:   LocationData(1230769, 0x1D, 4, "Jamjars Silo"),
    locationName.HATCH:     LocationData(1230770, 0x1D, 5, "Jamjars Silo"),
    locationName.TREBLETL:  LocationData(1230785, 0x8F, 3, "Treble Clef"),
    locationName.TRAINSWTD: LocationData(1230791, 0x27, 4, "Train Switch"),
    locationName.NOTETDL1:   LocationData(1230864, 0x8D, 3, "Note"),
    locationName.NOTETDL2:   LocationData(1230865, 0x8D, 4, "Note"),
    locationName.NOTETDL3:   LocationData(1230866, 0x8D, 5, "Note"),
    locationName.NOTETDL4:   LocationData(1230867, 0x8D, 6, "Note"),
    locationName.NOTETDL5:   LocationData(1230868, 0x8D, 7, "Note"),
    locationName.NOTETDL6:   LocationData(1230869, 0x8E, 0, "Note"),
    locationName.NOTETDL7:   LocationData(1230870, 0x8E, 1, "Note"),
    locationName.NOTETDL8:   LocationData(1230871, 0x8E, 2, "Note"),
    locationName.NOTETDL9:   LocationData(1230872, 0x8E, 3, "Note"),
    locationName.NOTETDL10:  LocationData(1230873, 0x8E, 4, "Note"),
    locationName.NOTETDL11:  LocationData(1230874, 0x8E, 5, "Note"),
    locationName.NOTETDL12:  LocationData(1230875, 0x8E, 6, "Note"),
    locationName.NOTETDL13:  LocationData(1230876, 0x8E, 7, "Note"),
    locationName.NOTETDL14:  LocationData(1230877, 0x8F, 0, "Note"),
    locationName.NOTETDL15:  LocationData(1230878, 0x8F, 1, "Note"),
    locationName.NOTETDL16:  LocationData(1230879, 0x8F, 2, "Note"),
    locationName.SCRUT:      LocationData(1231006, 0, 0), #Implement on Client Side
    locationName.SCRAT:      LocationData(1231007, 0, 0), #Implement on Client Side
    locationName.SCRIT:      LocationData(1231008, 0, 0), #Implement on Client Side
    locationName.ROARDINO:   LocationData(1231009, 0x17, 7),

    locationName.NESTTL1: LocationData(1231259, 0, 0, "Nest"),
    locationName.NESTTL2: LocationData(1231260, 0, 0, "Nest"),
    locationName.NESTTL3: LocationData(1231261, 0, 0, "Nest"),
    locationName.NESTTL4: LocationData(1231262, 0, 0, "Nest"),
    locationName.NESTTL5: LocationData(1231263, 0, 0, "Nest"),
    locationName.NESTTL6: LocationData(1231264, 0, 0, "Nest"),
    locationName.NESTTL7: LocationData(1231265, 0, 0, "Nest"),
    locationName.NESTTL8: LocationData(1231266, 0, 0, "Nest"),
    locationName.NESTTL9: LocationData(1231267, 0, 0, "Nest"),
    locationName.NESTTL10: LocationData(1231268, 0, 0, "Nest"),
    locationName.NESTTL11: LocationData(1231269, 0, 0, "Nest"),
    locationName.NESTTL12: LocationData(1231270, 0, 0, "Nest"),
    locationName.NESTTL13: LocationData(1231271, 0, 0, "Nest"),
    locationName.NESTTL14: LocationData(1231272, 0, 0, "Nest"),
    locationName.NESTTL15: LocationData(1231273, 0, 0, "Nest"),
    locationName.NESTTL16: LocationData(1231274, 0, 0, "Nest"),
    locationName.NESTTL17: LocationData(1231275, 0, 0, "Nest"),
    locationName.NESTTL18: LocationData(1231276, 0, 0, "Nest"),
    locationName.NESTTL19: LocationData(1231277, 0, 0, "Nest"),
    locationName.NESTTL20: LocationData(1231278, 0, 0, "Nest"),
    locationName.NESTTL21: LocationData(1231279, 0, 0, "Nest"),
    locationName.NESTTL22: LocationData(1231280, 0, 0, "Nest"),
    locationName.NESTTL23: LocationData(1231281, 0, 0, "Nest"),
    locationName.NESTTL24: LocationData(1231282, 0, 0, "Nest"),
    locationName.NESTTL25: LocationData(1231283, 0, 0, "Nest"),
    locationName.NESTTL26: LocationData(1231284, 0, 0, "Nest"),
    locationName.NESTTL27: LocationData(1231285, 0, 0, "Nest"),
    locationName.NESTTL28: LocationData(1231286, 0, 0, "Nest"),
    locationName.NESTTL29: LocationData(1231287, 0, 0, "Nest"),
    locationName.NESTTL30: LocationData(1231288, 0, 0, "Nest"),
    locationName.NESTTL31: LocationData(1231289, 0, 0, "Nest"),
    locationName.NESTTL32: LocationData(1231290, 0, 0, "Nest"),
    locationName.NESTTL33: LocationData(1231291, 0, 0, "Nest"),
    locationName.NESTTL34: LocationData(1231292, 0, 0, "Nest"),
    locationName.NESTTL35: LocationData(1231293, 0, 0, "Nest"),
    locationName.NESTTL36: LocationData(1231294, 0, 0, "Nest"),
    locationName.NESTTL37: LocationData(1231295, 0, 0, "Nest"),
    locationName.NESTTL38: LocationData(1231296, 0, 0, "Nest"),
    locationName.NESTTL39: LocationData(1231297, 0, 0, "Nest"),
    locationName.NESTTL40: LocationData(1231298, 0, 0, "Nest"),
    locationName.NESTTL41: LocationData(1231299, 0, 0, "Nest"),
    locationName.NESTTL42: LocationData(1231300, 0, 0, "Nest"),
    locationName.NESTTL43: LocationData(1231301, 0, 0, "Nest"),
    locationName.NESTTL44: LocationData(1231302, 0, 0, "Nest"),
    locationName.NESTTL45: LocationData(1231303, 0, 0, "Nest"),
    locationName.NESTTL46: LocationData(1231304, 0, 0, "Nest"),
    locationName.NESTTL47: LocationData(1231305, 0, 0, "Nest"),
    locationName.NESTTL48: LocationData(1231306, 0, 0, "Nest"),
    locationName.NESTTL49: LocationData(1231307, 0, 0, "Nest"),
    locationName.NESTTL50: LocationData(1231308, 0, 0, "Nest"),
    locationName.NESTTL51: LocationData(1231309, 0, 0, "Nest"),
    locationName.NESTTL52: LocationData(1231310, 0, 0, "Nest"),
    locationName.NESTTL53: LocationData(1231311, 0, 0, "Nest"),
    locationName.NESTTL54: LocationData(1231312, 0, 0, "Nest"),
    locationName.NESTTL55: LocationData(1231313, 0, 0, "Nest"),

    locationName.SIGNTL1:   LocationData(1231527, 0, 0, "Signpost"),
    locationName.SIGNTL2:   LocationData(1231528, 0, 0, "Signpost"),
    locationName.SIGNTL3:   LocationData(1231529, 0, 0, "Signpost"),
    locationName.SIGNTL4:   LocationData(1231530, 0, 0, "Signpost"),

    locationName.WARPTL1:   LocationData(1231577, 0, 0, "Warp Pads"),
    locationName.WARPTL2:   LocationData(1231578, 0, 0, "Warp Pads"),
    locationName.WARPTL3:   LocationData(1231579, 0, 0, "Warp Pads"),
    locationName.WARPTL4:   LocationData(1231580, 0, 0, "Warp Pads"),
    locationName.WARPTL5:   LocationData(1231581, 0, 0, "Warp Pads"),
}

GILoc_table = {
    locationName.JINJOGI1:  LocationData(1230576, 0x3C, 5, "Jinjo"),
    locationName.JINJOGI2:  LocationData(1230577, 0x3C, 6, "Jinjo"),
    locationName.JINJOGI3:  LocationData(1230578, 0x3C, 7, "Jinjo"),
    locationName.JINJOGI4:  LocationData(1230579, 0x3D, 0, "Jinjo"),
    locationName.JINJOGI5:  LocationData(1230580, 0x3D, 1, "Jinjo"),
    locationName.JIGGYGI1:  LocationData(1230646, 0x4B, 2, "Jiggy"),
    locationName.JIGGYGI2:  LocationData(1230647, 0x4B, 3, "Jiggy"),
    locationName.JIGGYGI3:  LocationData(1230648, 0x4B, 4, "Jiggy"),
    locationName.JIGGYGI4:  LocationData(1230649, 0x4B, 5, "Jiggy"),
    locationName.JIGGYGI5:  LocationData(1230650, 0x4B, 6, "Jiggy"),
    locationName.JIGGYGI6:  LocationData(1230651, 0x4B, 7, "Jiggy"),
    locationName.JIGGYGI7:  LocationData(1230652, 0x4C, 0, "Jiggy"),
    locationName.JIGGYGI8:  LocationData(1230653, 0x4C, 1, "Jiggy"),
    locationName.JIGGYGI9:  LocationData(1230654, 0x4C, 2, "Jiggy"),
    locationName.JIGGYGI10: LocationData(1230655, 0x4C, 3, "Jiggy"),
    locationName.GLOWBOGI1: LocationData(1230696, 0x44, 1, "Glowbo"),
    locationName.GLOWBOGI2: LocationData(1230697, 0x44, 2, "Glowbo"),
    locationName.HONEYCGI1: LocationData(1230718, 0x41, 1, "Honeycomb"),
    locationName.HONEYCGI2: LocationData(1230719, 0x41, 2, "Honeycomb"),
    locationName.HONEYCGI3: LocationData(1230720, 0x41, 3, "Honeycomb"),
    locationName.CHEATOGI1: LocationData(1230743, 0x58, 2, "Cheato Page"),
    locationName.CHEATOGI2: LocationData(1230744, 0x58, 3, "Cheato Page"),
    locationName.CHEATOGI3: LocationData(1230745, 0x58, 4, "Cheato Page"),
    locationName.SNPACK:    LocationData(1230771, 0x1D, 0, "Jamjars Silo"),
    locationName.LSPRING:   LocationData(1230772, 0x1D, 1, "Jamjars Silo"),
    locationName.CLAWBTS:   LocationData(1230773, 0x1D, 2, "Jamjars Silo"),
    locationName.TREBLEGI:  LocationData(1230786, 0x91, 4, "Treble Clef"),
    locationName.TRAINSWGI: LocationData(1230790, 0x27, 3, "Train Switch"),
    locationName.NOTEGI1:   LocationData(1230880, 0x8F, 4, "Note"),
    locationName.NOTEGI2:   LocationData(1230881, 0x8F, 5, "Note"),
    locationName.NOTEGI3:   LocationData(1230882, 0x8F, 6, "Note"),
    locationName.NOTEGI4:   LocationData(1230883, 0x8F, 7, "Note"),
    locationName.NOTEGI5:   LocationData(1230884, 0x8F, 0, "Note"),
    locationName.NOTEGI6:   LocationData(1230885, 0x90, 1, "Note"),
    locationName.NOTEGI7:   LocationData(1230886, 0x90, 2, "Note"),
    locationName.NOTEGI8:   LocationData(1230887, 0x90, 3, "Note"),
    locationName.NOTEGI9:   LocationData(1230888, 0x90, 4, "Note"),
    locationName.NOTEGI10:  LocationData(1230889, 0x90, 5, "Note"),
    locationName.NOTEGI11:  LocationData(1230890, 0x90, 6, "Note"),
    locationName.NOTEGI12:  LocationData(1230891, 0x90, 7, "Note"),
    locationName.NOTEGI13:  LocationData(1230892, 0x90, 0, "Note"),
    locationName.NOTEGI14:  LocationData(1230893, 0x91, 1, "Note"),
    locationName.NOTEGI15:  LocationData(1230894, 0x91, 2, "Note"),
    locationName.NOTEGI16:  LocationData(1230895, 0x91, 3, "Note"),

    locationName.NESTGI1: LocationData(1231314, 0, 0, "Nest"),
    locationName.NESTGI2: LocationData(1231315, 0, 0, "Nest"),
    locationName.NESTGI3: LocationData(1231316, 0, 0, "Nest"),
    locationName.NESTGI4: LocationData(1231317, 0, 0, "Nest"),
    locationName.NESTGI5: LocationData(1231318, 0, 0, "Nest"),
    locationName.NESTGI6: LocationData(1231319, 0, 0, "Nest"),
    locationName.NESTGI7: LocationData(1231320, 0, 0, "Nest"),
    locationName.NESTGI8: LocationData(1231321, 0, 0, "Nest"),
    locationName.NESTGI9: LocationData(1231322, 0, 0, "Nest"),
    locationName.NESTGI10: LocationData(1231323, 0, 0, "Nest"),
    locationName.NESTGI11: LocationData(1231324, 0, 0, "Nest"),
    locationName.NESTGI12: LocationData(1231325, 0, 0, "Nest"),
    locationName.NESTGI13: LocationData(1231326, 0, 0, "Nest"),
    locationName.NESTGI14: LocationData(1231327, 0, 0, "Nest"),
    locationName.NESTGI15: LocationData(1231328, 0, 0, "Nest"),
    locationName.NESTGI16: LocationData(1231329, 0, 0, "Nest"),
    locationName.NESTGI17: LocationData(1231330, 0, 0, "Nest"),
    locationName.NESTGI18: LocationData(1231331, 0, 0, "Nest"),
    locationName.NESTGI19: LocationData(1231332, 0, 0, "Nest"),
    locationName.NESTGI20: LocationData(1231333, 0, 0, "Nest"),
    locationName.NESTGI21: LocationData(1231334, 0, 0, "Nest"),
    locationName.NESTGI22: LocationData(1231335, 0, 0, "Nest"),
    locationName.NESTGI23: LocationData(1231336, 0, 0, "Nest"),
    locationName.NESTGI24: LocationData(1231337, 0, 0, "Nest"),
    locationName.NESTGI25: LocationData(1231338, 0, 0, "Nest"),
    locationName.NESTGI26: LocationData(1231339, 0, 0, "Nest"),
    locationName.NESTGI27: LocationData(1231340, 0, 0, "Nest"),
    locationName.NESTGI28: LocationData(1231341, 0, 0, "Nest"),
    locationName.NESTGI29: LocationData(1231342, 0, 0, "Nest"),
    locationName.NESTGI30: LocationData(1231343, 0, 0, "Nest"),
    locationName.NESTGI31: LocationData(1231344, 0, 0, "Nest"),
    locationName.NESTGI32: LocationData(1231345, 0, 0, "Nest"),
    locationName.NESTGI33: LocationData(1231346, 0, 0, "Nest"),
    locationName.NESTGI34: LocationData(1231347, 0, 0, "Nest"),
    locationName.NESTGI35: LocationData(1231348, 0, 0, "Nest"),
    locationName.NESTGI36: LocationData(1231349, 0, 0, "Nest"),
    locationName.NESTGI37: LocationData(1231350, 0, 0, "Nest"),
    locationName.NESTGI38: LocationData(1231351, 0, 0, "Nest"),
    locationName.NESTGI39: LocationData(1231352, 0, 0, "Nest"),
    locationName.NESTGI40: LocationData(1231353, 0, 0, "Nest"),
    locationName.NESTGI41: LocationData(1231354, 0, 0, "Nest"),
    locationName.NESTGI42: LocationData(1231355, 0, 0, "Nest"),
    locationName.NESTGI43: LocationData(1231356, 0, 0, "Nest"),
    locationName.NESTGI44: LocationData(1231357, 0, 0, "Nest"),
    locationName.NESTGI45: LocationData(1231358, 0, 0, "Nest"),
    locationName.NESTGI46: LocationData(1231359, 0, 0, "Nest"),
    locationName.NESTGI47: LocationData(1231360, 0, 0, "Nest"),
    locationName.NESTGI48: LocationData(1231361, 0, 0, "Nest"),
    locationName.NESTGI49: LocationData(1231362, 0, 0, "Nest"),
    locationName.NESTGI50: LocationData(1231363, 0, 0, "Nest"),
    locationName.NESTGI51: LocationData(1231364, 0, 0, "Nest"),
    locationName.NESTGI52: LocationData(1231365, 0, 0, "Nest"),
    locationName.NESTGI53: LocationData(1231366, 0, 0, "Nest"),
    locationName.NESTGI54: LocationData(1231367, 0, 0, "Nest"),
    locationName.NESTGI55: LocationData(1231368, 0, 0, "Nest"),
    locationName.NESTGI56: LocationData(1231369, 0, 0, "Nest"),
    locationName.NESTGI57: LocationData(1231370, 0, 0, "Nest"),
    locationName.NESTGI58: LocationData(1231371, 0, 0, "Nest"),
    locationName.NESTGI59: LocationData(1231372, 0, 0, "Nest"),
    locationName.NESTGI60: LocationData(1231373, 0, 0, "Nest"),
    locationName.NESTGI61: LocationData(1231374, 0, 0, "Nest"),
    locationName.NESTGI62: LocationData(1231375, 0, 0, "Nest"),
    locationName.NESTGI63: LocationData(1231376, 0, 0, "Nest"),
    locationName.NESTGI64: LocationData(1231377, 0, 0, "Nest"),
    locationName.NESTGI65: LocationData(1231378, 0, 0, "Nest"),
    locationName.NESTGI66: LocationData(1231379, 0, 0, "Nest"),
    locationName.NESTGI67: LocationData(1231380, 0, 0, "Nest"),
    locationName.NESTGI68: LocationData(1231381, 0, 0, "Nest"),
    locationName.NESTGI69: LocationData(1231382, 0, 0, "Nest"),
    locationName.NESTGI70: LocationData(1231383, 0, 0, "Nest"),
    locationName.NESTGI71: LocationData(1231384, 0, 0, "Nest"),
    locationName.NESTGI72: LocationData(1231385, 0, 0, "Nest"),
    locationName.NESTGI73: LocationData(1231386, 0, 0, "Nest"),
    locationName.NESTGI74: LocationData(1231387, 0, 0, "Nest"),
    locationName.NESTGI75: LocationData(1231388, 0, 0, "Nest"),
    locationName.NESTGI76: LocationData(1231389, 0, 0, "Nest"),
    locationName.NESTGI77: LocationData(1231390, 0, 0, "Nest"),
    locationName.NESTGI78: LocationData(1231391, 0, 0, "Nest"),

    locationName.SIGNGI1:   LocationData(1231531, 0, 0, "Signpost"),
    locationName.SIGNGI2:   LocationData(1231532, 0, 0, "Signpost"),
    locationName.SIGNGI3:   LocationData(1231533, 0, 0, "Signpost"),
    locationName.SIGNGI4:   LocationData(1231534, 0, 0, "Signpost"),

    locationName.WARPGI1:   LocationData(1231582, 0, 0, "Warp Pads"),
    locationName.WARPGI2:   LocationData(1231583, 0, 0, "Warp Pads"),
    locationName.WARPGI3:   LocationData(1231584, 0, 0, "Warp Pads"),
    locationName.WARPGI4:   LocationData(1231585, 0, 0, "Warp Pads"),
    locationName.WARPGI5:   LocationData(1231586, 0, 0, "Warp Pads"),

    locationName.SKIVWQ:    LocationData(1231602, 0x81, 1),
    locationName.SKIVF1:    LocationData(1231603, 0x81, 2),
    locationName.SKIVF2:    LocationData(1231604, 0x80, 7),
    locationName.SKIVF3:    LocationData(1231605, 0x81, 0),
    locationName.SKIVF5:    LocationData(1231606, 0x80, 6),
    locationName.SKIVOU:    LocationData(1231607, 0x80, 5),
}

HPLoc_table = {
    locationName.JINJOHP1:  LocationData(1230581, 0x3D, 2, "Jinjo"),
    locationName.JINJOHP2:  LocationData(1230582, 0x3D, 3, "Jinjo"),
    locationName.JINJOHP3:  LocationData(1230583, 0x3D, 4, "Jinjo"),
    locationName.JINJOHP4:  LocationData(1230584, 0x3D, 5, "Jinjo"),
    locationName.JINJOHP5:  LocationData(1230585, 0x3D, 6, "Jinjo"),
    locationName.JIGGYHP1:  LocationData(1230656, 0x4C, 4, "Jiggy"),
    locationName.JIGGYHP2:  LocationData(1230657, 0x4C, 5, "Jiggy"),
    locationName.JIGGYHP3:  LocationData(1230658, 0x4C, 6, "Jiggy"),
    locationName.JIGGYHP4:  LocationData(1230659, 0x4C, 7, "Jiggy"),
    locationName.JIGGYHP5:  LocationData(1230660, 0x4D, 0, "Jiggy"),
    locationName.JIGGYHP6:  LocationData(1230661, 0x4D, 1, "Jiggy"),
    locationName.JIGGYHP7:  LocationData(1230662, 0x4D, 2, "Jiggy"),
    locationName.JIGGYHP8:  LocationData(1230663, 0x4D, 3, "Jiggy"),
    locationName.JIGGYHP9:  LocationData(1230664, 0x4D, 4, "Jiggy"),
    locationName.JIGGYHP10: LocationData(1230665, 0x4D, 5, "Jiggy"),
    locationName.GLOWBOHP1: LocationData(1230698, 0x44, 3, "Glowbo"),
    locationName.GLOWBOHP2: LocationData(1230699, 0x44, 4, "Glowbo"),
    locationName.HONEYCHP1: LocationData(1230721, 0x41, 4, "Honeycomb"),
    locationName.HONEYCHP2: LocationData(1230722, 0x41, 5, "Honeycomb"),
    locationName.HONEYCHP3: LocationData(1230723, 0x41, 6, "Honeycomb"),
    locationName.CHEATOHP1: LocationData(1230746, 0x58, 5, "Cheato Page"),
    locationName.CHEATOHP2: LocationData(1230747, 0x58, 6, "Cheato Page"),
    locationName.CHEATOHP3: LocationData(1230748, 0x58, 7, "Cheato Page"),
    locationName.SHPACK:   LocationData(1230774, 0x1C, 6, "Jamjars Silo"),
    locationName.GLIDE:    LocationData(1230775, 0x1C, 7, "Jamjars Silo"),
    locationName.TREBLEHP: LocationData(1230787, 0x93, 5, "Treble Clef"),
    locationName.TRAINSWHP1: LocationData(1230792, 0x34, 7, "Train Switch"),
    locationName.TRAINSWHP2: LocationData(1230793, 0x35, 0, "Train Switch"),
    locationName.NOTEHFP1:   LocationData(1230896, 0x91, 5, "Note"),
    locationName.NOTEHFP2:   LocationData(1230897, 0x91, 6, "Note"),
    locationName.NOTEHFP3:   LocationData(1230898, 0x91, 7, "Note"),
    locationName.NOTEHFP4:   LocationData(1230899, 0x92, 0, "Note"),
    locationName.NOTEHFP5:   LocationData(1230900, 0x92, 1, "Note"),
    locationName.NOTEHFP6:   LocationData(1230901, 0x92, 2, "Note"),
    locationName.NOTEHFP7:   LocationData(1230902, 0x92, 3, "Note"),
    locationName.NOTEHFP8:   LocationData(1230903, 0x92, 4, "Note"),
    locationName.NOTEHFP9:   LocationData(1230904, 0x92, 5, "Note"),
    locationName.NOTEHFP10:  LocationData(1230905, 0x92, 6, "Note"),
    locationName.NOTEHFP11:  LocationData(1230906, 0x92, 7, "Note"),
    locationName.NOTEHFP12:  LocationData(1230907, 0x93, 0, "Note"),
    locationName.NOTEHFP13:  LocationData(1230908, 0x93, 1, "Note"),
    locationName.NOTEHFP14:  LocationData(1230909, 0x93, 2, "Note"),
    locationName.NOTEHFP15:  LocationData(1230910, 0x93, 3, "Note"),
    locationName.NOTEHFP16:  LocationData(1230911, 0x93, 4, "Note"),


    locationName.NESTHP1: LocationData(1231392, 0, 0, "Nest"),
    locationName.NESTHP2: LocationData(1231393, 0, 0, "Nest"),
    locationName.NESTHP3: LocationData(1231394, 0, 0, "Nest"),
    locationName.NESTHP4: LocationData(1231395, 0, 0, "Nest"),
    locationName.NESTHP5: LocationData(1231396, 0, 0, "Nest"),
    locationName.NESTHP6: LocationData(1231397, 0, 0, "Nest"),
    locationName.NESTHP7: LocationData(1231398, 0, 0, "Nest"),
    locationName.NESTHP8: LocationData(1231399, 0, 0, "Nest"),
    locationName.NESTHP9: LocationData(1231400, 0, 0, "Nest"),
    locationName.NESTHP10: LocationData(1231401, 0, 0, "Nest"),
    locationName.NESTHP11: LocationData(1231402, 0, 0, "Nest"),
    locationName.NESTHP12: LocationData(1231403, 0, 0, "Nest"),
    locationName.NESTHP13: LocationData(1231404, 0, 0, "Nest"),
    locationName.NESTHP14: LocationData(1231405, 0, 0, "Nest"),
    locationName.NESTHP15: LocationData(1231406, 0, 0, "Nest"),
    locationName.NESTHP16: LocationData(1231407, 0, 0, "Nest"),
    locationName.NESTHP17: LocationData(1231408, 0, 0, "Nest"),
    locationName.NESTHP18: LocationData(1231409, 0, 0, "Nest"),
    locationName.NESTHP19: LocationData(1231410, 0, 0, "Nest"),
    locationName.NESTHP20: LocationData(1231411, 0, 0, "Nest"),
    locationName.NESTHP21: LocationData(1231412, 0, 0, "Nest"),
    locationName.NESTHP22: LocationData(1231413, 0, 0, "Nest"),
    locationName.NESTHP23: LocationData(1231414, 0, 0, "Nest"),
    locationName.NESTHP24: LocationData(1231415, 0, 0, "Nest"),
    locationName.NESTHP25: LocationData(1231416, 0, 0, "Nest"),
    locationName.NESTHP26: LocationData(1231417, 0, 0, "Nest"),
    locationName.NESTHP27: LocationData(1231418, 0, 0, "Nest"),
    locationName.NESTHP28: LocationData(1231419, 0, 0, "Nest"),
    locationName.NESTHP29: LocationData(1231420, 0, 0, "Nest"),
    locationName.NESTHP30: LocationData(1231421, 0, 0, "Nest"),
    locationName.NESTHP31: LocationData(1231422, 0, 0, "Nest"),
    locationName.NESTHP32: LocationData(1231423, 0, 0, "Nest"),
    locationName.NESTHP33: LocationData(1231424, 0, 0, "Nest"),
    locationName.NESTHP34: LocationData(1231425, 0, 0, "Nest"),
    locationName.NESTHP35: LocationData(1231426, 0, 0, "Nest"),
    locationName.NESTHP36: LocationData(1231427, 0, 0, "Nest"),
    locationName.NESTHP37: LocationData(1231428, 0, 0, "Nest"),
    locationName.NESTHP38: LocationData(1231429, 0, 0, "Nest"),
    locationName.NESTHP39: LocationData(1231430, 0, 0, "Nest"),
    locationName.NESTHP40: LocationData(1231431, 0, 0, "Nest"),

    locationName.SIGNHP1:   LocationData(1231535, 0, 0, "Signpost"),
    locationName.SIGNHP2:   LocationData(1231536, 0, 0, "Signpost"),
    locationName.SIGNHP3:   LocationData(1231537, 0, 0, "Signpost"),
    locationName.SIGNHP4:   LocationData(1231538, 0, 0, "Signpost"),
    locationName.SIGNHP5:   LocationData(1231539, 0, 0, "Signpost"),

    locationName.WARPHP1:   LocationData(1231587, 0, 0, "Warp Pads"),
    locationName.WARPHP2:   LocationData(1231588, 0, 0, "Warp Pads"),
    locationName.WARPHP3:   LocationData(1231589, 0, 0, "Warp Pads"),
    locationName.WARPHP4:   LocationData(1231590, 0, 0, "Warp Pads"),
    locationName.WARPHP5:   LocationData(1231591, 0, 0, "Warp Pads"),

    locationName.ALPHETTE:    LocationData(1231599, 0x69, 2),
    locationName.BETETTE:    LocationData(1231600, 0x69, 3),
    locationName.GAMETTE:    LocationData(1231601, 0x69, 4)

}

CCLoc_table = {
    locationName.JINJOCC1:  LocationData(1230586, 0x3D, 7, "Jinjo"),
    locationName.JINJOCC2:  LocationData(1230587, 0x3E, 0, "Jinjo"),
    locationName.JINJOCC3:  LocationData(1230588, 0x3E, 1, "Jinjo"),
    locationName.JINJOCC4:  LocationData(1230589, 0x3E, 2, "Jinjo"),
    locationName.JINJOCC5:  LocationData(1230590, 0x3E, 3, "Jinjo"),
    locationName.JIGGYCC1:  LocationData(1230666, 0x4D, 6, "Jiggy"),
    locationName.JIGGYCC2:  LocationData(1230667, 0x4D, 7, "Jiggy"),
    locationName.JIGGYCC3:  LocationData(1230668, 0x4E, 0, "Jiggy"),
    locationName.JIGGYCC4:  LocationData(1230669, 0x4E, 1, "Jiggy"),
    locationName.JIGGYCC5:  LocationData(1230670, 0x4E, 2, "Jiggy"),
    locationName.JIGGYCC6:  LocationData(1230671, 0x4E, 3, "Jiggy"),
    locationName.JIGGYCC7:  LocationData(1230672, 0x4E, 4, "Jiggy"),
    locationName.JIGGYCC8:  LocationData(1230673, 0x4E, 5, "Jiggy"),
    locationName.JIGGYCC9:  LocationData(1230674, 0x4E, 6, "Jiggy"),
    locationName.JIGGYCC10: LocationData(1230675, 0x4E, 7, "Jiggy"),
    locationName.GLOWBOCC1: LocationData(1230700, 0x44, 5, "Glowbo"),
    locationName.GLOWBOCC2: LocationData(1230701, 0x44, 6, "Glowbo"),
    locationName.HONEYCCC1: LocationData(1230724, 0x41, 7, "Honeycomb"),
    locationName.HONEYCCC2: LocationData(1230725, 0x42, 0, "Honeycomb"),
    locationName.HONEYCCC3: LocationData(1230726, 0x42, 1, "Honeycomb"),
    locationName.CHEATOCC1: LocationData(1230749, 0x59, 0, "Cheato Page"),
    locationName.CHEATOCC2: LocationData(1230750, 0x59, 1, "Cheato Page"),
    locationName.CHEATOCC3: LocationData(1230751, 0x59, 2, "Cheato Page"),
    locationName.SAPACK:    LocationData(1230776, 0x1D, 7, "Jamjars Silo"),
    locationName.TREBLECC:  LocationData(1230788, 0x95, 6, "Treble Clef"),
    locationName.NOTECCL1:   LocationData(1230912, 0x93, 6, "Note"),
    locationName.NOTECCL2:   LocationData(1230913, 0x93, 7, "Note"),
    locationName.NOTECCL3:   LocationData(1230914, 0x94, 0, "Note"),
    locationName.NOTECCL4:   LocationData(1230915, 0x94, 1, "Note"),
    locationName.NOTECCL5:   LocationData(1230916, 0x94, 2, "Note"),
    locationName.NOTECCL6:   LocationData(1230917, 0x94, 3, "Note"),
    locationName.NOTECCL7:   LocationData(1230918, 0x94, 4, "Note"),
    locationName.NOTECCL8:   LocationData(1230919, 0x94, 5, "Note"),
    locationName.NOTECCL9:   LocationData(1230920, 0x94, 6, "Note"),
    locationName.NOTECCL10:  LocationData(1230921, 0x94, 7, "Note"),
    locationName.NOTECCL11:  LocationData(1230922, 0x95, 0, "Note"),
    locationName.NOTECCL12:  LocationData(1230923, 0x95, 1, "Note"),
    locationName.NOTECCL13:  LocationData(1230924, 0x95, 2, "Note"),
    locationName.NOTECCL14:  LocationData(1230925, 0x95, 3, "Note"),
    locationName.NOTECCL15:  LocationData(1230926, 0x95, 4, "Note"),
    locationName.NOTECCL16:  LocationData(1230927, 0x95, 5, "Note"),

    locationName.NESTCC1: LocationData(1231432, 0, 0, "Nest"),
    locationName.NESTCC2: LocationData(1231433, 0, 0, "Nest"),
    locationName.NESTCC3: LocationData(1231434, 0, 0, "Nest"),
    locationName.NESTCC4: LocationData(1231435, 0, 0, "Nest"),
    locationName.NESTCC5: LocationData(1231436, 0, 0, "Nest"),
    locationName.NESTCC6: LocationData(1231437, 0, 0, "Nest"),
    locationName.NESTCC7: LocationData(1231438, 0, 0, "Nest"),
    locationName.NESTCC8: LocationData(1231439, 0, 0, "Nest"),
    locationName.NESTCC9: LocationData(1231440, 0, 0, "Nest"),
    locationName.NESTCC10: LocationData(1231441, 0, 0, "Nest"),
    locationName.NESTCC11: LocationData(1231442, 0, 0, "Nest"),
    locationName.NESTCC12: LocationData(1231443, 0, 0, "Nest"),
    locationName.NESTCC13: LocationData(1231444, 0, 0, "Nest"),
    locationName.NESTCC14: LocationData(1231445, 0, 0, "Nest"),
    locationName.NESTCC15: LocationData(1231446, 0, 0, "Nest"),
    locationName.NESTCC16: LocationData(1231447, 0, 0, "Nest"),
    locationName.NESTCC17: LocationData(1231448, 0, 0, "Nest"),
    locationName.NESTCC18: LocationData(1231449, 0, 0, "Nest"),
    locationName.NESTCC19: LocationData(1231450, 0, 0, "Nest"),
    locationName.NESTCC20: LocationData(1231451, 0, 0, "Nest"),
    locationName.NESTCC21: LocationData(1231452, 0, 0, "Nest"),
    locationName.NESTCC22: LocationData(1231453, 0, 0, "Nest"),
    locationName.NESTCC23: LocationData(1231454, 0, 0, "Nest"),
    locationName.NESTCC24: LocationData(1231455, 0, 0, "Nest"),
    locationName.NESTCC25: LocationData(1231456, 0, 0, "Nest"),
    locationName.NESTCC26: LocationData(1231457, 0, 0, "Nest"),
    locationName.NESTCC27: LocationData(1231458, 0, 0, "Nest"),
    locationName.NESTCC28: LocationData(1231459, 0, 0, "Nest"),
    locationName.NESTCC29: LocationData(1231460, 0, 0, "Nest"),
    locationName.NESTCC30: LocationData(1231461, 0, 0, "Nest"),
    locationName.NESTCC31: LocationData(1231462, 0, 0, "Nest"),
    locationName.NESTCC32: LocationData(1231463, 0, 0, "Nest"),
    locationName.NESTCC33: LocationData(1231464, 0, 0, "Nest"),
    locationName.NESTCC34: LocationData(1231465, 0, 0, "Nest"),
    locationName.NESTCC35: LocationData(1231466, 0, 0, "Nest"),
    locationName.NESTCC36: LocationData(1231467, 0, 0, "Nest"),
    locationName.NESTCC37: LocationData(1231468, 0, 0, "Nest"),
    locationName.NESTCC38: LocationData(1231469, 0, 0, "Nest"),
    locationName.NESTCC39: LocationData(1231470, 0, 0, "Nest"),
    locationName.NESTCC40: LocationData(1231471, 0, 0, "Nest"),
    locationName.NESTCC41: LocationData(1231472, 0, 0, "Nest"),
    locationName.NESTCC42: LocationData(1231473, 0, 0, "Nest"),
    locationName.NESTCC43: LocationData(1231474, 0, 0, "Nest"),
    locationName.NESTCC44: LocationData(1231475, 0, 0, "Nest"),
    locationName.NESTCC45: LocationData(1231476, 0, 0, "Nest"),
    locationName.NESTCC46: LocationData(1231477, 0, 0, "Nest"),
    locationName.NESTCC47: LocationData(1231478, 0, 0, "Nest"),
    locationName.NESTCC48: LocationData(1231479, 0, 0, "Nest"),
    locationName.NESTCC49: LocationData(1231480, 0, 0, "Nest"),
    locationName.NESTCC50: LocationData(1231481, 0, 0, "Nest"),

    locationName.SIGNCC1:   LocationData(1231540, 0, 0, "Signpost"),
    locationName.SIGNCC2:   LocationData(1231541, 0, 0, "Signpost"),
    locationName.SIGNCC3:   LocationData(1231542, 0, 0, "Signpost"),
    locationName.SIGNCC4:   LocationData(1231543, 0, 0, "Signpost"),


    locationName.WARPCC1:   LocationData(1231592, 0, 0, "Warp Pads"),
    locationName.WARPCC2:   LocationData(1231593, 0, 0, "Warp Pads"),

    locationName.FITHJ:     LocationData(1231608, 0x76, 4),
    locationName.FITSR:     LocationData(1231609, 0x76, 5),

    locationName.BEANCC1:   LocationData(1231639, 0x62, 6),
    locationName.BEANCC2:   LocationData(1231640, 0x62, 5),
}

WorldUnlocks_table = {
    locationName.W1:      LocationData(1230944, 0, 0),
    locationName.W2:      LocationData(1230945, 0, 0),
    locationName.W3:      LocationData(1230946, 0, 0),
    locationName.W4:      LocationData(1230947, 0, 0),
    locationName.W5:      LocationData(1230948, 0, 0),
    locationName.W6:      LocationData(1230949, 0, 0),
    locationName.W7:      LocationData(1230950, 0, 0),
    locationName.W8:      LocationData(1230951, 0, 0),
    locationName.W9:      LocationData(1230952, 0, 0),
}

IHWHLoc_table = {
    locationName.JINJOIH1: LocationData(1230591, 0x3E, 4, "Jinjo"),
    locationName.YMEGGH:   LocationData(1230953, 0x77, 7, "Stop 'n' Swop"),
    locationName.PMEGGH:   LocationData(1230954, 0x77, 6, "Stop 'n' Swop"),
    locationName.BMEGGH:   LocationData(1230955, 0x77, 4, "Stop 'n' Swop"),

    locationName.NESTIH18: LocationData(1231052, 0, 0, "Nest"),
    locationName.NESTIH19: LocationData(1231053, 0, 0, "Nest"),
    locationName.NESTIH20: LocationData(1231054, 0, 0, "Nest"),
    locationName.NESTIH21: LocationData(1231055, 0, 0, "Nest"),
    locationName.NESTIH22: LocationData(1231056, 0, 0, "Nest"),
    locationName.NESTIH23: LocationData(1231057, 0, 0, "Nest"),
    locationName.NESTIH24: LocationData(1231058, 0, 0, "Nest"),
    locationName.NESTIH25: LocationData(1231059, 0, 0, "Nest"),
    locationName.NESTIH26: LocationData(1231060, 0, 0, "Nest"),

    locationName.SIGNIH2:   LocationData(1231484, 0, 0, "Signpost"),
    locationName.SIGNIH3:   LocationData(1231485, 0, 0, "Signpost"),
    locationName.SIGNIH4:   LocationData(1231486, 0, 0, "Signpost"),
    locationName.SIGNIH5:   LocationData(1231487, 0, 0, "Signpost"),
    locationName.SIGNIH6:   LocationData(1231488, 0, 0, "Signpost"),
    locationName.SIGNIH7:   LocationData(1231489, 0, 0, "Signpost"),
    locationName.SIGNIH8:   LocationData(1231490, 0, 0, "Signpost"),
    locationName.SIGNIH9:   LocationData(1231491, 0, 0, "Signpost"),
    locationName.SIGNIH10:   LocationData(1231492, 0, 0, "Signpost"),
    locationName.SIGNIH11:   LocationData(1231493, 0, 0, "Signpost"),
    locationName.SIGNIH12:   LocationData(1231494, 0, 0, "Signpost"),
    locationName.SIGNIH13:   LocationData(1231495, 0, 0, "Signpost"),
    locationName.SIGNIH14:   LocationData(1231496, 0, 0, "Signpost"),

    locationName.SILOIOHWH:   LocationData(1231551, 0, 0, "Silos"),
}

IHWLLoc_table = {
    locationName.JINJOIH2: LocationData(1230592, 0x3E, 5, "Jinjo"),
    locationName.CEGGS:   LocationData(1230767, 0x1E, 3, "Jamjars Silo"),
    locationName.NOTEIH13:   LocationData(1230940, 0x97, 3, "Note"),
    locationName.NOTEIH14:   LocationData(1230941, 0x97, 4, "Note"),
    locationName.NOTEIH15:   LocationData(1230942, 0x97, 5, "Note"),
    locationName.NOTEIH16:   LocationData(1230943, 0x97, 6, "Note"),

    locationName.NESTIH48: LocationData(1231082, 0, 0, "Nest"),
    locationName.NESTIH49: LocationData(1231083, 0, 0, "Nest"),
    locationName.NESTIH50: LocationData(1231084, 0, 0, "Nest"),
    locationName.NESTIH51: LocationData(1231085, 0, 0, "Nest"),
    locationName.NESTIH52: LocationData(1231086, 0, 0, "Nest"),
    locationName.NESTIH53: LocationData(1231087, 0, 0, "Nest"),
    locationName.NESTIH54: LocationData(1231088, 0, 0, "Nest"),
    locationName.NESTIH55: LocationData(1231089, 0, 0, "Nest"),

    locationName.NESTIH56: LocationData(1231090, 0, 0, "Nest"),
    locationName.NESTIH57: LocationData(1231091, 0, 0, "Nest"),

    locationName.SIGNIH19:   LocationData(1231501, 0, 0, "Signpost"),

    locationName.SILOIOHWL:   LocationData(1231555, 0, 0, "Silos"),
}

IHQMLoc_table = {
    locationName.NESTIH58: LocationData(1231092, 0, 0, "Nest"),
    locationName.NESTIH59: LocationData(1231093, 0, 0, "Nest"),
    locationName.NESTIH60: LocationData(1231094, 0, 0, "Nest"),
    locationName.NESTIH61: LocationData(1231095, 0, 0, "Nest"),
    locationName.NESTIH62: LocationData(1231096, 0, 0, "Nest"),
    locationName.NESTIH63: LocationData(1231097, 0, 0, "Nest"),

    locationName.SILOIOHQM:   LocationData(1231556, 0, 0, "Silos"),
}

IHCTLoc_table = {
    locationName.JINJOIH3: LocationData(1230593, 0x3E, 6, "Jinjo"),
    locationName.GLOWBOIH1: LocationData(1230702, 0x44, 7, "Glowbo"),
    locationName.IEGGS:   LocationData(1230763, 0x1E, 4, "Jamjars Silo"),
    locationName.TRAINSWIH: LocationData(1230794, 0x7B, 3, "Train Switch"),
    locationName.NOTEIH9:   LocationData(1230936, 0x96, 7, "Note"),
    locationName.NOTEIH10:   LocationData(1230937, 0x97, 0, "Note"),
    locationName.NOTEIH11:   LocationData(1230938, 0x97, 1, "Note"),
    locationName.NOTEIH12:   LocationData(1230939, 0x97, 2, "Note"),

    locationName.NESTIH40: LocationData(1231074, 0, 0, "Nest"),
    locationName.NESTIH41: LocationData(1231075, 0, 0, "Nest"),
    locationName.NESTIH42: LocationData(1231076, 0, 0, "Nest"),
    locationName.NESTIH43: LocationData(1231077, 0, 0, "Nest"),
    locationName.NESTIH44: LocationData(1231078, 0, 0, "Nest"),
    locationName.NESTIH45: LocationData(1231079, 0, 0, "Nest"),
    locationName.NESTIH64: LocationData(1231482, 0, 0, "Nest"), #Out of order.

    locationName.SIGNIH18:   LocationData(1231500, 0, 0, "Signpost"),

    locationName.SILOIOHCT:   LocationData(1231554, 0, 0, "Silos"),
}

CKLoc_table = {
    locationName.WARPCK1:   LocationData(1231594, 0, 0, "Warp Pads"),
    locationName.WARPCK2:   LocationData(1231595, 0, 0, "Warp Pads"),
}

boss_table = {
    locationName.HAG1:      LocationData(None, 0x03, 3)
}

MumboTokenBoss_table = {
    locationName.MUMBOTKNBOSS1: LocationData(1230960, 0, 0),
    locationName.MUMBOTKNBOSS2: LocationData(1230961, 0, 0),
    locationName.MUMBOTKNBOSS3: LocationData(1230962, 0, 0),
    locationName.MUMBOTKNBOSS4: LocationData(1230963, 0, 0),
    locationName.MUMBOTKNBOSS5: LocationData(1230964, 0, 0),
    locationName.MUMBOTKNBOSS6: LocationData(1230965, 0, 0),
    locationName.MUMBOTKNBOSS7: LocationData(1230966, 0, 0),
    locationName.MUMBOTKNBOSS8: LocationData(1230967, 0, 0),
}

MumboTokenGames_table = {
    locationName.MUMBOTKNGAME1:  LocationData(1230968, 0, 0),
    locationName.MUMBOTKNGAME2:  LocationData(1230969, 0, 0),
    locationName.MUMBOTKNGAME3:  LocationData(1230970, 0, 0),
    locationName.MUMBOTKNGAME4:  LocationData(1230971, 0, 0),
    locationName.MUMBOTKNGAME5:  LocationData(1230972, 0, 0),
    locationName.MUMBOTKNGAME6:  LocationData(1230973, 0, 0),
    locationName.MUMBOTKNGAME7:  LocationData(1230974, 0, 0),
    locationName.MUMBOTKNGAME8:  LocationData(1230975, 0, 0),
    locationName.MUMBOTKNGAME9:  LocationData(1230976, 0, 0),
    locationName.MUMBOTKNGAME10: LocationData(1230977, 0, 0),
    locationName.MUMBOTKNGAME11: LocationData(1230978, 0, 0),
    locationName.MUMBOTKNGAME12: LocationData(1230979, 0, 0),
    locationName.MUMBOTKNGAME13: LocationData(1230980, 0, 0),
    locationName.MUMBOTKNGAME14: LocationData(1230981, 0, 0),
    locationName.MUMBOTKNGAME15: LocationData(1230982, 0, 0),
}

MumboTokenJinjo_table = {
    locationName.MUMBOTKNJINJO1: LocationData(1230983, 0, 0),
    locationName.MUMBOTKNJINJO2: LocationData(1230984, 0, 0),
    locationName.MUMBOTKNJINJO3: LocationData(1230985, 0, 0),
    locationName.MUMBOTKNJINJO4: LocationData(1230986, 0, 0),
    locationName.MUMBOTKNJINJO5: LocationData(1230987, 0, 0),
    locationName.MUMBOTKNJINJO6: LocationData(1230988, 0, 0),
    locationName.MUMBOTKNJINJO7: LocationData(1230989, 0, 0),
    locationName.MUMBOTKNJINJO8: LocationData(1230990, 0, 0),
    locationName.MUMBOTKNJINJO9: LocationData(1230991, 0, 0),
}

all_location_table = {
    **SMLoc_table,
    **CheatoRewardsLoc_table,
    **JVLoc_table,
    **JinjoRewardsLoc_table,
    **WorldUnlocks_table,
    **IHWHLoc_table,
    **MTLoc_Table,
    **IHPLLoc_table,
    **HoneyBRewardsLoc_table,
    **GMLoc_table,
    **IHPGLoc_table,
    **WWLoc_table,
    **IHCTLoc_table,
    **JRLoc_table,
    **IHWLLoc_table,
    **IHQMLoc_table,
    **TLLoc_table,
    **GILoc_table,
    **HPLoc_table,
    **CCLoc_table,
    **CKLoc_table,
    **boss_table,
    **MumboTokenBoss_table,
    **MumboTokenGames_table,
    **MumboTokenJinjo_table
}
